/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcspbrk.c,v 1.1 1996/07/09 10:05:37 jack Exp $ */

#include <wchar.h>

wchar_t *
wcspbrk (const wchar_t *ws1, const wchar_t *ws2)
{
  while (1)
    {
      if (*ws1 == 0)
	return NULL;
      else if (wcschr (ws2, *ws1) != NULL)
	break;
      ws1++;
    }

  return (wchar_t *) ws1;
}
