// Associated include file : Common/Debug.H

#include "common/common.h"

#ifdef _UNIX_
  #define DebugPath "sword_debug.txt"
#else
  #ifdef _TURBOC_
	 #define DebugPath "C:\\Debug.txt"
  #else
	 #define DebugPath "C:/Debug.txt"
  #endif
#endif

#define OpenDebug    FileDebug=fopen(DebugPath,"at+")
#define CreateDebug  FileDebug=fopen(DebugPath,"wt")
#define CloseDebug   fclose(FileDebug)

FILE *FileDebug;
char  ModeDebug;
char  Increment[500];
char  Buffer[500];

void InitDebug(char Mode)
{ ModeDebug=Mode;
  if (ModeDebug & DebugON)
  { CreateDebug;
    fprintf(FileDebug,"SWORD 2.10. Debugging file\n");
    fprintf(FileDebug,"--------------------------\n\n");
    if (ModeDebug & DebugTemporary) CloseDebug;
  }
  *Increment=0;
}

void DoneDebug()
{ if (ModeDebug & DebugON)
  { if (!(ModeDebug & DebugTemporary)) CloseDebug;
  }
}

void Debug(va_list arg_list, ...)
{  
#ifndef _SUNOS_
   va_list arg_ptr;
   char *format;
   if (ModeDebug & DebugTemporary) OpenDebug;
   va_start(arg_ptr, arg_list);
   format = (char*)arg_list;
   vsprintf(Buffer,format,arg_ptr);
   fprintf(FileDebug,"%s%s",Increment,Buffer);
	fflush(FileDebug);
   if (ModeDebug & DebugTemporary) CloseDebug;
#endif
}

void DebugIncrement(void)
{ strcat(Increment,"   ");
}

void DebugDecrement(void)
{ if (strlen(Increment)>=3) Increment[strlen(Increment)-3]=0;
}
