/* --------------------------------------------------------------------------
   Project S.W.O.R.D
   V2.10

   SubSystem : Tests programs : Colors application
   File      : Samples/Tests/Colors/Colors.cc
   Author    : Eric NICOLAS
   Overview  : Main file for the Colors test program
   UpDate    : Apr 06, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

int main(int , char *argv[])
{ // Application identification
  ShortVersion="Colors tests";
  LongVersion ="Colors tests. Copyright (C) 1993-1996 The SWORD Group";

  // Init
  InitCommon(argv[0]);
  InitDrivers();
  printf("\n\nTESTS for the COLORS functions.\n\n");

  byte r,g,b,h,s,v,c,y,m,k;
  byte r1,g1,b1,h1,s1,v1;
  char Tmp[50];
  int  n;
  boolean quit=FALSE;
  do
  { printf("Enter color (r,g,b) [Enter for quit]:\n");
    printf("   r="); gets(Tmp);
    if (strlen(Tmp)==0) quit=TRUE;
    else
    { sscanf(Tmp,"%d",&n); r=(byte)n;
      printf("   g="); gets(Tmp); sscanf(Tmp,"%d",&n); g=(byte)n;
      printf("   b="); gets(Tmp); sscanf(Tmp,"%d",&n); b=(byte)n;
      printf("\nTesting color space conversions : \n");
      // HSV testing
      RGB2HSV(r,g,b,h,s,v);
      HSV2RGB(h,s,v,r1,g1,b1);
      printf("(r,g,b)=(%3d,%3d,%3d) > "
             "(h,s,v  )=(%3d,%3d,%3d    ) > "
             "(r,g,b)=(%3d,%3d,%3d)\n",
             (int)r, (int)g, (int)b,
             (int)h, (int)s, (int)v,
             (int)r1,(int)g1,(int)b1);
      // CYM testing
      RGB2CYM(r,g,b,c,y,m);
      CYM2RGB(c,y,m,r1,g1,b1);
      printf("(r,g,b)=(%3d,%3d,%3d) > "
             "(c,y,m  )=(%3d,%3d,%3d    ) > "
             "(r,g,b)=(%3d,%3d,%3d)\n",
             (int)r, (int)g, (int)b,
             (int)c, (int)y, (int)m,
             (int)r1,(int)g1,(int)b1);
      // CYMK
      RGB2CYMK(r,g,b,c,y,m,k);
      CYMK2RGB(c,y,m,k,r1,g1,b1);
      printf("(r,g,b)=(%3d,%3d,%3d) > "
             "(c,y,m,k)=(%3d,%3d,%3d,%3d) > "
             "(r,g,b)=(%3d,%3d,%3d)\n\n",
             (int)r, (int)g, (int)b,
             (int)c, (int)y, (int)m, (int)k,
             (int)r1,(int)g1,(int)b1);
    }
  } while(!quit);
  printf("\n\n");
  quit=FALSE;
  do
  { printf("Enter color (h,s,v) [Enter for quit]:\n");
    printf("   h="); gets(Tmp);
    if (strlen(Tmp)==0) quit=TRUE;
    else
    { sscanf(Tmp,"%d",&n); h=(byte)n;
      printf("   s="); gets(Tmp); sscanf(Tmp,"%d",&n); s=(byte)n;
      printf("   v="); gets(Tmp); sscanf(Tmp,"%d",&n); v=(byte)n;
      printf("\nTesting color space conversions : \n");
      // HSV testing
      HSV2RGB(h,s,v,r,g,b);
      RGB2HSV(r,g,b,h1,s1,v1);
      printf("(h,s,v)=(%3d,%3d,%3d) > "
             "(r,g,b  )=(%3d,%3d,%3d    ) > "
             "(h,s,v)=(%3d,%3d,%3d)\n",
             (int)h, (int)s, (int)v,
             (int)r, (int)g, (int)b,
             (int)h1,(int)s1,(int)v1);
      // CYM testing
      RGB2CYM(r,g,b,c,y,m);
      CYM2RGB(c,y,m,r1,g1,b1);
      printf("(r,g,b)=(%3d,%3d,%3d) > "
             "(c,y,m  )=(%3d,%3d,%3d    ) > "
             "(r,g,b)=(%3d,%3d,%3d)\n",
             (int)r, (int)g, (int)b,
             (int)c, (int)y, (int)m,
             (int)r1,(int)g1,(int)b1);
      // CYMK
      RGB2CYMK(r,g,b,c,y,m,k);
      CYMK2RGB(c,y,m,k,r1,g1,b1);
      printf("(r,g,b)=(%3d,%3d,%3d) > "
             "(c,y,m,k)=(%3d,%3d,%3d,%3d) > "
             "(r,g,b)=(%3d,%3d,%3d)\n\n",
             (int)r, (int)g, (int)b,
             (int)c, (int)y, (int)m, (int)k,
             (int)r1,(int)g1,(int)b1);
    }
  } while(!quit);
  printf("[QUIT]\n\n");
  // Done
  DoneDrivers();
  DoneCommon();
  return 0;
}

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   04/04/96 :EN: Initial draft
**   06/04/96 :EN: Fixing bug on HSV<->RGB transformations
** ------------------------------------------------------------------------*/
