


LESS(1)                  USER COMMANDS                    LESS(1)



NAME
     less - opposite of more

SYNOPSIS
     less -?
     less -V
     less [-[+]aBcCdeEfgGiImMnNqQrsSuUVwX]
          [-b _b_u_f_s] [-h _l_i_n_e_s] [-j _l_i_n_e] [-k _k_e_y_f_i_l_e]
          [-{oO} _l_o_g_f_i_l_e] [-p _p_a_t_t_e_r_n] [-P _p_r_o_m_p_t] [-t _t_a_g]
          [-T _t_a_g_s_f_i_l_e] [-x _t_a_b] [-y _l_i_n_e_s] [-[z] _l_i_n_e_s]
          [+[+]_c_m_d] [_f_i_l_e_n_a_m_e]...


DESCRIPTION
     _L_e_s_s is a program similar to  _m_o_r_e  (1),  but  which  allows
     backward  movement  in the file as well as forward movement.
     Also, _l_e_s_s does not have  to  read  the  entire  input  file
     before starting, so with large input files it starts up fas-
     ter than text editors like _v_i (1).  _L_e_s_s  uses  termcap  (or
     terminfo  on  some  systems),  so it can run on a variety of
     terminals.  There is even limited support for hardcopy  ter-
     minals.   (On  a  hardcopy  terminal,  lines which should be
     printed at the top of the screen are prefixed with a caret.)

     Commands are based on both _m_o_r_e and _v_i. Commands may be pre-
     ceded  by  a  decimal  number,  called N in the descriptions
     below.  The number is used by some commands, as indicated.


COMMANDS
     In the following  descriptions,  ^X  means  control-X.   ESC
     stands  for  the ESCAPE key; for example ESC-v means the two
     character sequence "ESCAPE", then "v".

     h or H
          Help: display a summary of these commands.  If you for-
          get all the other commands, remember this one.

     SPACE or ^V or f or ^F
          Scroll forward N lines, default one window (see  option
          -z below).  If N is more than the screen size, only the
          final screenful is displayed.   Warning:  some  systems
          use ^V as a special literalization character.

     z    Like SPACE, but if N is specified, it becomes  the  new
          window size.

     RETURN or ^N or e or ^E or j or ^J
          Scroll forward N lines, default 1.  The entire N  lines
          are displayed, even if N is more than the screen size.





                                                                1






LESS(1)                  USER COMMANDS                    LESS(1)



     d or ^D
          Scroll forward N lines, default one half of the  screen
          size.   If  N  is specified, it becomes the new default
          for subsequent d and u commands.

     b or ^B or ESC-v
          Scroll backward N lines, default one window (see option
          -z below).  If N is more than the screen size, only the
          final screenful is displayed.

     w    Like ESC-v, but if N is specified, it becomes  the  new
          window size.

     y or ^Y or ^P or k or ^K
          Scroll backward N lines, default 1.  The entire N lines
          are  displayed, even if N is more than the screen size.
          Warning: some systems use ^Y as a special  job  control
          character.

     u or ^U
          Scroll backward N lines, default one half of the screen
          size.   If  N  is specified, it becomes the new default
          for subsequent d and u commands.

     r or ^R or ^L
          Repaint the screen.

     R    Repaint the  screen,  discarding  any  buffered  input.
          Useful  if  the  file  is  changing  while  it is being
          viewed.

     F    Scroll forward, and keep trying to read when the end of
          file  is  reached.  Normally this command would be used
          when already at the end of the file.  It is  a  way  to
          monitor the tail of a file which is growing while it is
          being viewed.  (The behavior is similar  to  the  "tail
          -f" command.)

     g or < or ESC-<
          Go to line N in  the  file,  default  1  (beginning  of
          file).  (Warning: this may be slow if N is large.)

     G or > or ESC->
          Go to line N in the file, default the end of the  file.
          (Warning:  this  may  be slow if N is large, or if N is
          not specified and standard input, rather than  a  file,
          is being read.)

     p or %
          Go to a position N percent into the file.  N should  be
          between 0 and 100.




                                                                2






LESS(1)                  USER COMMANDS                    LESS(1)



     {    If a  left  curly  bracket  appears  in  the  top  line
          displayed  on  the screen, the { command will go to the
          matching right curly bracket.  The matching right curly
          bracket is positioned on the bottom line of the screen.
          If there is more than one left curly bracket on the top
          line,  a  number  N  may  be  used  to specify the N-th
          bracket on the line.

     }    If a right curly bracket appears  in  the  bottom  line
          displayed  on  the screen, the } command will go to the
          matching left curly bracket.  The matching  left  curly
          bracket  is  positioned  on the top line of the screen.
          If there is more than one right curly  bracket  on  the
          top  line,  a  number N may be used to specify the N-th
          bracket on the line.

     (    Like {, but applies to parentheses  rather  than  curly
          brackets.

     )    Like }, but applies to parentheses  rather  than  curly
          brackets.

     [    Like {, but applies  to  square  brackets  rather  than
          curly brackets.

     ]    Like }, but applies  to  square  brackets  rather  than
          curly brackets.

     ESC-^F
          Followed by two characters, acts like {, but  uses  the
          two  characters  as  open  and  close brackets, respec-
          tively.  For example, "ESC ^F < >" could be used to  go
          forward  to  the  >  which  matches  the  <  in the top
          displayed line.

     ESC-^B
          Followed by two characters, acts like }, but  uses  the
          two  characters  as  open  and  close brackets, respec-
          tively.  For example, "ESC ^B < >" could be used to  go
          backward  to  the  <  which matches the > in the bottom
          displayed line.

     m    Followed by any lowercase  letter,  marks  the  current
          position with that letter.

     '    (Single  quote.)  Followed  by  any  lowercase  letter,
          returns  to  the  position  which was previously marked
          with that letter.  Followed by  another  single  quote,
          returns to the position at which the last "large" move-
          ment command was executed.  Followed by a ^ or $, jumps
          to  the  beginning  or  end  of  the file respectively.
          Marks are preserved when a new file is examined, so the



                                                                3






LESS(1)                  USER COMMANDS                    LESS(1)



          ' command can be used to switch between input files.

     ^X^X Same as single quote.

     /pattern
          Search forward in the file for the N-th line containing
          the  pattern.  N defaults to 1.  The pattern is a regu-
          lar expression, as recognized by _e_d. The search  starts
          at  the  second  line  displayed (but see the -a and -j
          options, which change this).

          Certain characters are special if entered at the begin-
          ning  of  the  pattern;  they modify the type of search
          rather than become part of the pattern:

          !    Search for lines which do NOT match the pattern.

          *    Search multiple files.  That  is,  if  the  search
               reaches  the end of the current file without find-
               ing a match, the search continues in the next file
               in the command line list.

          @    Begin the search at the first line  of  the  first
               file  in the command line list, regardless of what
               is currently displayed on the screen or  the  set-
               tings of the -a or -j options.

     ?pattern
          Search backward in the file for the N-th line  contain-
          ing the pattern.  The search starts at the line immedi-
          ately before the top line displayed.

          Certain characters are special as in the / command:

          !    Search for lines which do NOT match the pattern.

          *    Search multiple files.  That  is,  if  the  search
               reaches  the beginning of the current file without
               finding a match, the search continues in the  pre-
               vious file in the command line list.

          @    Begin the search at the last line of the last file
               in  the  command  line list, regardless of what is
               currently displayed on the screen or the  settings
               of the -a or -j options.

     ESC-/pattern
          Same as "/*".

     ESC-?pattern
          Same as "?*".




                                                                4






LESS(1)                  USER COMMANDS                    LESS(1)



     n    Repeat previous search, for N-th  line  containing  the
          last  pattern.   If the previous search was modified by
          !, the search is made for the N-th line NOT  containing
          the pattern.  If the previous search was modified by *,
          the search continues in the next (or previous) file  if
          not  satisfied in the current file.  There is no effect
          if the previous search was modified by @.

     N    Repeat previous search, but in the reverse direction.

     ESC-n
          Repeat previous search, but crossing  file  boundaries.
          The  effect  is as if the previous search were modified
          by *.

     ESC-N
          Repeat previous search, but in  the  reverse  direction
          and crossing file boundaries.

     ESC-u
          Undo search highlighting.   Turn  off  highlighting  of
          strings   matching   the  current  search  pattern.  If
          highlighting is already off because of a previous ESC-u
          command, turn highlighting back on.  Any search command
          will also turn highlighting back on.  (Highlighting can
          also  be disabled by toggling the -G flag; in that case
          search commands do not turn highlighting back on.)

     :e [filename]
          Examine a new file.  If the filename  is  missing,  the
          "current"  file (see the :n and :p commands below) from
          the list of files in the command line  is  re-examined.
          A  percent  sign (%) in the filename is replaced by the
          name of the current file. A pound sign (#) is  replaced
          by  the  name  of  the  previously  examined file.  The
          filename is inserted into  the  command  line  list  of
          files  so  that  it can be seen by subsequent :n and :p
          commands.  If the filename consists of  several  files,
          they  are  all  inserted into the list of files and the
          first one is examined.

     ^X^V or E
          Same as :e.  Warning: some systems use ^V as a  special
          literalization character.

     :n   Examine the next file (from the list of files given  in
          the  command line).  If a number N is specified, the N-
          th next file is examined.

     :p   Examine the previous file in the command line list.  If
          a  number  N  is  specified,  the N-th previous file is
          examined.



                                                                5






LESS(1)                  USER COMMANDS                    LESS(1)



     :x   Examine the first file in the command line list.  If  a
          number  N  is  specified,  the N-th file in the list is
          examined.

     = or ^G or :f
          Prints some information about the  file  being  viewed,
          including  its name and the line number and byte offset
          of the bottom line being displayed.   If  possible,  it
          also prints the length of the file, the number of lines
          in the file and the percent of the file above the  last
          displayed line.

     -    Followed by one of the command line option letters (see
          below), this will change the setting of that option and
          print a message describing the  new  setting.   If  the
          option  letter  has a numeric value (such as -b or -h),
          or a string value (such as -P or -t), a new  value  may
          be entered after the option letter.  If no new value is
          entered, a message describing the  current  setting  is
          printed and nothing is changed.

     -+   Followed by one of the command line option letters (see
          below),  this will reset the option to its default set-
          ting and print a message describing  the  new  setting.
          (The  "-+_X" command does the same thing as "-+_X" on the
          command line.) This does  not  work  for  string-valued
          options.

     --   Followed by one of the command line option letters (see
          below), this will reset the option to the "opposite" of
          its default setting and print a message describing  the
          new setting.  (The "--_X" command does the same thing as
          "-_X" on the command  line.)  This  does  not  work  for
          numeric or string-valued options.

     _    (Underscore.) Followed  by  one  of  the  command  line
          option  letters  (see below), this will print a message
          describing the current setting  of  that  option.   The
          setting of the option is not changed.

     +cmd Causes the specified cmd to be executed each time a new
          file  is examined.  For example, +G causes _l_e_s_s to ini-
          tially display each file starting  at  the  end  rather
          than the beginning.

     V    Prints the version number of _l_e_s_s being run.

     q or :q or :Q or ZZ
          Exits _l_e_s_s.

     The following three  commands  may  or  may  not  be  valid,
     depending on your particular installation.



                                                                6






LESS(1)                  USER COMMANDS                    LESS(1)



     v    Invokes an  editor  to  edit  the  current  file  being
          viewed.  The editor is taken from the environment vari-
          able VISUAL if defined, or  EDITOR  if  VISUAL  is  not
          defined, or defaults to "vi" if neither VISUAL nor EDI-
          TOR is defined.  See also the  discussion  of  LESSEDIT
          under the section on PROMPTS below.

     ! shell-command
          Invokes a shell to run the shell-command given.  A per-
          cent sign (%) in the command is replaced by the name of
          the current file. A pound sign (#) is replaced  by  the
          name of the previously examined file.  "!!" repeats the
          last shell command.  "!" with no shell  command  simply
          invokes a shell.  In all cases, the shell is taken from
          the environment variable SHELL, or defaults to "sh".

     | <m> shell-command
          <m> represents any mark letter.  Pipes a section of the
          input  file to the given shell command.  The section of
          the file to be piped is between the first line  on  the
          current  screen  and the position marked by the letter.
          <m> may also be ^ or $ to indicate beginning or end  of
          file respectively.  If <m> is . or newline, the current
          screen is piped.

OPTIONS
     Command line options are described below.  Most options  may
     be changed while _l_e_s_s is running, via the "-" command.

     Options are also taken from the environment variable "LESS".
     For  example,  to avoid typing "less -options ..." each time
     _l_e_s_s is invoked, you might tell _c_s_h:

     setenv LESS "-options"

     or if you use _s_h:

     LESS="-options"; export LESS

     The environment variable is parsed before the command  line,
     so  command line options override the LESS environment vari-
     able.  If an option appears in the LESS variable, it can  be
     reset  to  its  default on the command line by beginning the
     command line option with "-+".

     A dollar sign ($) may be used to signal the end of an option
     string.   This  is  important only for options like -P which
     take a following string.

     -?   This option displays a summary of the commands accepted
          by _l_e_s_s (the same as the h command).  If this option is
          given, all other options are ignored,  and  _l_e_s_s  exits



                                                                7






LESS(1)                  USER COMMANDS                    LESS(1)



          after  the  help  screen  is viewed.  (Depending on how
          your shell interprets the  question  mark,  it  may  be
          necessary to quote the question mark, thus: "-\?".)

     -a   Causes searches to start after the last line  displayed
          on the screen, thus skipping all lines displayed on the
          screen.  By default, searches start at the second  line
          on the screen (or after the last found line; see the -j
          option).

     -b_n  Specifies the number of buffers _l_e_s_s will use for  each
          file.   Buffers  are  1K, and by default 10 buffers are
          used for each file (except if the file is a  pipe;  see
          the  -B  option).   The  number _n specifies a different
          number of buffers to use.

     -B   By default, when data is read from a pipe, buffers  are
          allocated  automatically  as needed.  If a large amount
          of data is read from the pipe, this can cause  a  large
          amount  of  memory to be allocated.  The -B option dis-
          ables this automatic allocation of buffers  for  pipes,
          so  that only the number of buffers specified by the -b
          option are used.  Warning: use  of  -B  can  result  in
          erroneous  display, since only the most recently viewed
          part of the file is kept in memory; any earlier data is
          lost.

     -c   Causes full screen repaints to be painted from the  top
          line  down.   By default, full screen repaints are done
          by scrolling from the bottom of the screen.

     -C   The -C option is like -c, but  the  screen  is  cleared
          before it is repainted.

     -d   The -d option suppresses  the  error  message  normally
          displayed  if the terminal is dumb; that is, lacks some
          important capability, such as the ability to clear  the
          screen or scroll backward.  The -d option does not oth-
          erwise change the behavior of _l_e_s_s on a dumb terminal).

     -Dx_c_o_l_o_r
          [MS-DOS only] Sets the color of the text displayed.   x
          is  a  single  character which selects the type of text
          whose color is being set: n=normal, s=standout, d=bold,
          u=underlined,  k=blink.   _c_o_l_o_r  is  a  pair of numbers
          separated by a period. The  first  number  selects  the
          foreground  color and the second selects the background
          color of the text.  A single number _N is  the  same  as
          _N._0.

     -e   Causes _l_e_s_s to automatically exit the  second  time  it
          reaches  end-of-file.  By default, the only way to exit



                                                                8






LESS(1)                  USER COMMANDS                    LESS(1)



          _l_e_s_s is via the "q" command.

     -E   Causes _l_e_s_s to automatically exit  the  first  time  it
          reaches end-of-file.

     -f   Forces non-regular files to be opened.  (A  non-regular
          file  is  a  directory  or a device special file.) Also
          suppresses the warning message when a  binary  file  is
          opened.   By  default,  _l_e_s_s  will  refuse to open non-
          regular files.

     -g   Normally, _l_e_s_s will highlight ALL strings  which  match
          the  last  search  command.   The  -g flag changes this
          behavior to highlight only the particular string  which
          was  found  by the last search command.  This can cause
          _l_e_s_s to run somewhat faster than the default.

     -G   The -G flag  suppresses  all  highlighting  of  strings
          found by search commands.

     -h_n  Specifies a maximum number of lines to scroll backward.
          If  it  is  necessary  to  scroll  backward more than _n
          lines, the screen is repainted in a  forward  direction
          instead.  (If the terminal does not have the ability to
          scroll backward, -h0 is implied.)

     -i   Causes searches to ignore case; that is, uppercase  and
          lowercase  are  considered  identical.   This option is
          ignored if any uppercase letters appear in  the  search
          pattern;  in  other words, if a pattern contains upper-
          case letters, then that search does not ignore case.

     -I   Like -i, but searches ignore case even if  the  pattern
          contains uppercase letters.

     -j_n  Specifies a line on the screen where the "target"  line
          is  to be positioned.  A target line is the object of a
          text search, tag search, jump to a line number, jump to
          a  file  percentage, or jump to a marked position.  The
          screen line is specified by a number: the top  line  on
          the  screen is 1, the next is 2, and so on.  The number
          may be negative to specify a line relative to the  bot-
          tom of the screen: the bottom line on the screen is -1,
          the second to the bottom is -2, and so on.  If  the  -j
          option  is used, searches begin at the line immediately
          after the target line.  For example, if "-j4" is  used,
          the  target  line  is the fourth line on the screen, so
          searches begin at the fifth line on the screen.

     -k_f_i_l_e_n_a_m_e
          Causes _l_e_s_s to open and interpret the named file  as  a
          _l_e_s_s_k_e_y   (1)   file.    Multiple  -k  options  may  be



                                                                9






LESS(1)                  USER COMMANDS                    LESS(1)



          specified.  If a file called .less exists in the user's
          home  directory,  this  file  is also used as a _l_e_s_s_k_e_y
          file.

     -m   Causes _l_e_s_s to prompt verbosely (like _m_o_r_e),  with  the
          percent into the file.  By default, _l_e_s_s prompts with a
          colon.

     -M   Causes _l_e_s_s to prompt even more verbosely than _m_o_r_e.

     -n   Suppresses line numbers.   The  default  (to  use  line
          numbers)  may  cause  _l_e_s_s  to  run more slowly in some
          cases,  especially  with  a  very  large  input   file.
          Suppressing  line  numbers  with the -n flag will avoid
          this problem.   Using  line  numbers  means:  the  line
          number  will  be displayed in the verbose prompt and in
          the = command, and the v command will pass the  current
          line  number  to the editor (see also the discussion of
          LESSEDIT in PROMPTS below).

     -N   Causes a line number to be displayed at  the  beginning
          of each line in the display.

     -o_f_i_l_e_n_a_m_e
          Causes _l_e_s_s to copy its input to the named file  as  it
          is being viewed.  This applies only when the input file
          is a pipe, not an ordinary file.  If the  file  already
          exists, _l_e_s_s will ask for confirmation before overwrit-
          ing it.

     -O_f_i_l_e_n_a_m_e
          The -O option is like -o,  but  it  will  overwrite  an
          existing file without asking for confirmation.

          If no log file  has  been  specified,  the  -o  and  -O
          options  can  be used from within _l_e_s_s to specify a log
          file.  Without a file name, they will simply report the
          name of the log file.  The "s" command is equivalent to
          specifying -o from within _l_e_s_s.

     -p_p_a_t_t_e_r_n
          The -p option on the  command  line  is  equivalent  to
          specifying  +/_p_a_t_t_e_r_n;  that is, it tells _l_e_s_s to start
          at the first occurrence of _p_a_t_t_e_r_n in the file.

     -P_p_r_o_m_p_t
          Provides a way to tailor the  three  prompt  styles  to
          your own preference.  This option would normally be put
          in the LESS environment  variable,  rather  than  being
          typed  in  with each _l_e_s_s command.  Such an option must
          either be the last option in the LESS variable,  or  be
          terminated  by  a dollar sign.  -P followed by a string



                                                               10






LESS(1)                  USER COMMANDS                    LESS(1)



          changes the default (short) prompt to that string.  -Pm
          changes  the  medium (-m) prompt to the string, and -PM
          changes the long (-M) prompt.  Also,  -P=  changes  the
          message  printed  by the = command to the given string.
          All prompt strings consist of a sequence of letters and
          special  escape  sequences.  See the section on PROMPTS
          for more details.

     -q   Causes moderately "quiet" operation: the terminal  bell
          is  not  rung  if an attempt is made to scroll past the
          end of the file or before the beginning  of  the  file.
          If  the  terminal  has  a  "visual  bell",  it  is used
          instead.  The  bell  will  be  rung  on  certain  other
          errors,  such  as  typing  an  invalid  character.  The
          default is to ring the terminal bell in all such cases.

     -Q   Causes totally "quiet" operation: the terminal bell  is
          never rung.

     -r   Causes "raw" control characters to be  displayed.   The
          default  is  to  display  control  characters using the
          caret notation; for example, a control-A (octal 001) is
          displayed  as "^A".  Warning: when the -r flag is used,
          _l_e_s_s cannot keep track of the actual appearance of  the
          screen  (since  this depends on how the screen responds
          to each type  of  control  character).   Thus,  various
          display  problems  may result, such as long lines being
          split in the wrong place.

     -s   Causes consecutive blank lines to be  squeezed  into  a
          single  blank  line.  This is useful when viewing _n_r_o_f_f
          output.

     -S   Causes lines longer than the screen width to be chopped
          rather  than  folded.  That is, the remainder of a long
          line is simply discarded.  The default is to fold  long
          lines; that is, display the remainder on the next line.

     -t_t_a_g
          The -t option, followed immediately by a TAG, will edit
          the  file containing that tag.  For this to work, there
          must be a file called "tags" in the current  directory,
          which  was  previously  built by the _c_t_a_g_s (1) command.
          This option may also  be  specified  from  within  _l_e_s_s
          (using the - command) as a way of examining a new file.
          The command ":t" is equivalent to  specifying  -t  from
          within _l_e_s_s.

     -T_t_a_g_s_f_i_l_e
          Specifies a tags file to be used instead of "tags".

     -u   Causes backspaces and carriage returns to be treated as



                                                               11






LESS(1)                  USER COMMANDS                    LESS(1)



          printable  characters;  that  is,  they are sent to the
          terminal when they appear in the input.

     -U   Causes backspaces and carriage returns to be treated as
          control characters; that is, they are handled as speci-
          fied by the -r option.

          By default, if neither -u nor -U is  given,  backspaces
          which  appear  adjacent  to an underscore character are
          treated specially: the  underlined  text  is  displayed
          using  the  terminal's hardware underlining capability.
          Also, backspaces which  appear  between  two  identical
          characters  are  treated specially: the overstruck text
          is printed using the terminal's hardware boldface capa-
          bility.   Other  backspaces are deleted, along with the
          preceding character.  Carriage returns immediately fol-
          lowed by a newline are deleted.  Other carriage returns
          are handled as specified by the -r option.  Text  which
          is overstruck or underlined can be searched for if nei-
          ther -u nor -U is in effect.

     -V   Displays the version number of _l_e_s_s.

     -w   Causes blank lines to be used to represent  lines  past
          the end of the file.  By default, a tilde character (~)
          is used.

     -x_n  Sets tab stops every _n positions.  The default for _n is
          8.

     -X   Disables sending the termcap initialization and  deini-
          tialization strings to the terminal.  This is sometimes
          desirable if the deinitialization string does something
          unnecessary, like clearing the screen.

     -y_n  Specifies a maximum number of lines to scroll  forward.
          If it is necessary to scroll forward more than _n lines,
          the screen is repainted instead.  The -c or  -C  option
          may  be  used  to repaint from the top of the screen if
          desired.   By  default,  any  forward  movement  causes
          scrolling.

     -[z]_n
          Changes the default scrolling window size to  _n  lines.
          The default is one screenful.  The z and w commands can
          also be used to change the window size.  The "z" may be
          omitted for compatibility with _m_o_r_e. If the number _n is
          negative, it indicates _n lines less  than  the  current
          screen  size.   For example, if the screen is 24 lines,
          -_z-_4 sets the scrolling window to  20  lines.   If  the
          screen  is  resized  to  40 lines, the scrolling window
          automatically changes to 36 lines.



                                                               12






LESS(1)                  USER COMMANDS                    LESS(1)



     +    If a command line option begins with +,  the  remainder
          of  that  option  is  taken to be an initial command to
          _l_e_s_s. For example, +G tells _l_e_s_s to start at the end of
          the  file rather than the beginning, and +/xyz tells it
          to start at the first occurrence of "xyz" in the  file.
          As a special case, +<number> acts like +<number>g; that
          is, it starts the display at the specified line  number
          (however,  see the caveat under the "g" command above).
          If the option  starts  with  ++,  the  initial  command
          applies  to every file being viewed, not just the first
          one.  The + command described previously  may  also  be
          used  to  set  (or change) an initial command for every
          file.


LINE EDITING
     When entering command line at the bottom of the screen  (for
     example, a filename for the :e command, or the pattern for a
     search command), certain keys can be used to manipulate  the
     command  line.   Most  commands  have an alternate form in [
     brackets ] which can be used if a key does not  exist  on  a
     particular keyboard. (The bracketed forms do not work in the
     MS-DOS version.) Any of these special keys  may  be  entered
     literally  by  preceding  it  with  the "literal" character,
     either ^V or ^A.  A backslash itself  may  also  be  entered
     literally by entering two backslashes.

     LEFTARROW [ ESC-h ]
          Move the cursor one space to the left.

     RIGHTARROW [ ESC-l ]
          Move the cursor one space to the right.

     ^LEFTARROW [ ESC-b or ESC-LEFTARROW ]
          (That is, CONTROL and LEFTARROW  simultaneously.)  Move
          the cursor one word to the left.

     ^RIGHTARROW [ ESC-w or ESC-RIGHTARROW ]
          (That is, CONTROL and RIGHTARROW simultaneously.)  Move
          the cursor one word to the right.

     HOME [ ESC-0 ]
          Move the cursor to the beginning of the line.

     END [ ESC-$ ]
          Move the cursor to the end of the line.

     BACKSPACE
          Delete the character to the left of the cursor, or can-
          cel the command if the command line is empty.

     DELETE or [ ESC-x ]



                                                               13






LESS(1)                  USER COMMANDS                    LESS(1)



          Delete the character under the cursor.

     ^BACKSPACE [ ESC-BACKSPACE ]
          (That is, CONTROL and BACKSPACE simultaneously.) Delete
          the word to the left of the cursor.

     ^DELETE [ ESC-X or ESC-DELETE ]
          (That is, CONTROL and  DELETE  simultaneously.)  Delete
          the word under the cursor.

     UPARROW [ ESC-k ]
          Retrieve the previous command line.

     DOWNARROW [ ESC-j ]
          Retrieve the next command line.

     TAB  Complete the partial filename to the left of  the  cur-
          sor.   If  it matches more than one filename, the first
          match is entered into the command line.  Repeated  TABs
          will cycle thru the other matching filenames.

     BACKTAB [ ESC-TAB ]
          Like, TAB, but cycles in the reverse direction thru the
          matching filenames.

     ^L   Complete the partial filename to the left of  the  cur-
          sor.  If it matches more than one filename, all matches
          are entered into the command line (if they fit).

     ^U (Unix) or ESC (MS-DOS)
          Delete the entire command line, or cancel  the  command
          if the command line is empty.  If you have changed your
          line-kill character in Unix to something other than ^U,
          that character is used instead of ^U.


KEY BINDINGS
     You may define your own _l_e_s_s commands by using  the  program
     _l_e_s_s_k_e_y  (1)  to  create  a file called ".less" in your home
     directory.  This file specifies a set of command keys and an
     action  associated  with each key.  You may also use _l_e_s_s_k_e_y
     to change the line-editing keys (see LINE EDITING).  See the
     _l_e_s_s_k_e_y manual page for more details.


INPUT PREPROCESSOR
     You may define an "input preprocessor" for _l_e_s_s. Before _l_e_s_s
     opens  a  file,  it  first  gives  your input preprocessor a
     chance to modify the  way  the  contents  of  the  file  are
     displayed.   An  input  preprocessor is simply an executable
     program (or shell script), which writes the contents of  the
     file  to a different file, called the replacement file.  The



                                                               14






LESS(1)                  USER COMMANDS                    LESS(1)



     contents of the replacement file are then displayed in place
     of  the  contents  of  the  original file.  However, it will
     appear to the user as if the original file is  opened;  that
     is,  _l_e_s_s  will display the original filename as the name of
     the current file.

     An input preprocessor receives one  command  line  argument,
     the  original  filename,  as entered by the user.  It should
     create the replacement file, and when  finished,  print  the
     name of the replacement file to its standard output.  If the
     input preprocessor does not output a  replacement  filename,
     _l_e_s_s  uses  the original file, as normal.  The input prepro-
     cessor is not called when viewing standard input.  To set up
     an input preprocessor, set the LESSOPEN environment variable
     to a command line which will invoke your input preprocessor.
     This  command  line  should  include  one  occurrence of the
     string "%s", which will be replaced by the filename when the
     input preprocessor command is invoked.

     When _l_e_s_s closes a file opened in such a way, it  will  call
     another  program,  called the input postprocessor, which may
     perform any desired clean-up action (such  as  deleting  the
     replacement   file   created  by  LESSOPEN).   This  program
     receives two command line arguments, the  original  filename
     as  entered  by  the  user,  and the name of the replacement
     file.  To set up an input postprocessor, set  the  LESSCLOSE
     environment  variable  to  a  command line which will invoke
     your input postprocessor.  It may include two occurrences of
     the  string  "%s";  the  first is replaced with the original
     name of the file  and  the  second  with  the  name  of  the
     replacement file, which was output by LESSOPEN.

     For example, on many Unix systems, these  two  scripts  will
     allow  you to keep files in compressed format, but still let
     _l_e_s_s view them directly:

     lessopen.sh:
          #! /bin/sh
          case "$1" in
          *.Z) uncompress -c $1  >/tmp/less.$$  2>/dev/null
               if [ -s /tmp/less.$$ ]; then
                    echo /tmp/less.$$
               else
                    rm -f /tmp/less.$$
               fi
               ;;
          esac

     lessclose.sh:
          #! /bin/sh
          rm $2




                                                               15






LESS(1)                  USER COMMANDS                    LESS(1)



     To use these scripts, put them both where they can  be  exe-
     cuted     and     set     LESSOPEN="lessopen.sh %s",     and
     LESSCLOSE="lessclose.sh %s %s".  More complex  LESSOPEN  and
     LESSCLOSE  scripts  may  be written to accept other types of
     compressed files, and so on.

     It is also possible to set up an input preprocessor to  pipe
     the file data directly to _l_e_s_s, rather than putting the data
     into a replacement file.  This avoids the need to decompress
     the  entire  file  before  starting  to  view  it.  An input
     preprocessor that works this way is called  an  input  pipe.
     An  input pipe, instead of writing the name of a replacement
     file on its standard output, writes the entire  contents  of
     the  replacement  file on its standard output.  If the input
     pipe does not write any characters on its  standard  output,
     then there is no replacement file and _l_e_s_s uses the original
     file, as normal.  To use an input pipe, make the first char-
     acter  in  the  LESSOPEN environment variable a vertical bar
     (|) to signify that the input preprocessor is an input pipe.

     For example, on many Unix systems,  this  script  will  work
     like the previous example scripts:

     lesspipe.sh:
          !# /bin/sh
          case "$1" in
          *.Z) uncompress -c $1  2>/dev/null
               ;;
          esac

     To use this script, put it where it can be executed and  set
     LESSOPEN="|lesspipe.sh  %s".   When an input pipe is used, a
     LESSCLOSE postprocessor can be used, but it is  usually  not
     necessary  since  there  is no replacement file to clean up.
     In this case, the replacement file name passed to the  LESS-
     CLOSE postprocessor is "-".


NATIONAL CHARACTER SETS
     There are three types of characters in the input file:

     normal characters
          can be displayed directly to the screen.

     control characters
          should not be displayed directly, but are  expected  to
          be  found in ordinary text files (such as backspace and
          tab).

     binary characters
          should not be displayed directly and are  not  expected
          to be found in text files.



                                                               16






LESS(1)                  USER COMMANDS                    LESS(1)



     A "character set" is simply a description of  which  charac-
     ters  are to be considered normal, control, and binary.  The
     LESSCHARSET environment variable may be  used  to  select  a
     character set.  Possible values for LESSCHARSET are:

     ascii
          The default  character  set.   BS,  TAB,  NL,  CR,  and
          formfeed  are control characters, all chars with values
          between 127 and 255 are binary, and all others are nor-
          mal.

     latin1
          Selects the ISO 8859/1 character set.  latin-1  is  the
          same  as  ASCII,  except characters between 161 and 255
          are treated as normal characters.

     dos  Selects a character set appropriate for MS-DOS.

     koi8-r
          Selects a Russian character set.

     next Selects a character set appropriate for NeXT computers.

     In special cases, it may be desired to tailor _l_e_s_s to use  a
     character  set other than the ones definable by LESSCHARSET.
     In this case, the environment variable  LESSCHARDEF  can  be
     used  to  define  a  character  set.   It should be set to a
     string where each character in  the  string  represents  one
     character  in  the character set.  The character "." is used
     for a normal character, "c" for control, and "b" for binary.
     A  decimal  number may be used for repetition.  For example,
     "bccc4b." would mean character 0 is binary, 1, 2 and  3  are
     control,  4,  5,  6  and 7 are binary, and 8 is normal.  All
     characters after the last are taken to be the  same  as  the
     last, so characters 9 through 255 would be normal.  (This is
     an example, and does  not  necessarily  represent  any  real
     character set.)

     This  table  shows  the  value  of  LESSCHARDEF   which   is
     equivalent to each of the possible values for LESSCHARSET:

          ascii     8bcccbcc18b95.b
          latin1    8bcccbcc18b95.33b.
          dos       8bcccbcc12bc5b95.b.
          koi8-r    8bcccbcc18b95.b128.
          next      8bcccbcc18b95.bb125.bb

     If neither LESSCHARSET nor LESSCHARDEF is set, but your sys-
     tem  supports  the _s_e_t_l_o_c_a_l_e interface, _l_e_s_s will use setlo-
     cale to determine the  character  set.   setlocale  is  con-
     trolled  by  setting  the LANG or LC_CTYPE environment vari-
     ables.



                                                               17






LESS(1)                  USER COMMANDS                    LESS(1)



     Control and binary  characters  are  displayed  in  standout
     (reverse  video).  Each such character is displayed in caret
     notation if possible (e.g. ^A for control-A).   Caret  nota-
     tion  is  used  only  if inverting the 0100 bit results in a
     normal printable character.   Otherwise,  the  character  is
     displayed  as  a  hex number in angle brackets.  This format
     can be changed by setting the LESSBINFMT  environment  vari-
     able.   LESSBINFMT may begin with a "*" and one character to
     select the display attribute:  "*k"  is  blinking,  "*d"  is
     bold,  "*u"  is underlined, "*s" is standout.  If LESSBINFMT
     does not begin with a "*", normal attribute is assumed.  The
     remainder  of  LESSBINFMT  is a string which may include one
     printf-style escape sequence (a % followed by x,  X,  o,  d,
     etc.).  For example, if LESSBINFMT is "*u[%x]", binary char-
     acters are displayed in underlined hexadecimal surrounded by
     brackets.   The  default  if  no  LESSBINFMT is specified is
     "*d<%X>".


PROMPTS
     The -P option allows  you  to  tailor  the  prompt  to  your
     preference.   The string given to the -P option replaces the
     specified prompt string.  Certain characters in  the  string
     are  interpreted  specially.  The prompt mechanism is rather
     complicated to provide flexibility, but  the  ordinary  user
     need not understand the details of constructing personalized
     prompt strings.

     A percent sign followed by a single  character  is  expanded
     according to what the following character is:

     %b_X  Replaced by the byte  offset  into  the  current  input
          file.   The  b is followed by a single character (shown
          as _X above) which specifies the line whose byte  offset
          is  to  be  used.   If the character is a "t", the byte
          offset of the top line in the display is used,  an  "m"
          means  use  the middle line, a "b" means use the bottom
          line, a "B" means use the line just  after  the  bottom
          line,  and a "j" means use the "target" line, as speci-
          fied by the -j option.

     %B   Replaced by the size of the current input file.

     %E   Replaced by the name of the  editor  (from  the  VISUAL
          environment  variable,  or the EDITOR environment vari-
          able if VISUAL is not defined).  See the discussion  of
          the LESSEDIT feature below.

     %f   Replaced by the name of the current input file.

     %i   Replaced by the index of the current file in  the  list
          of input files.



                                                               18






LESS(1)                  USER COMMANDS                    LESS(1)



     %l_X  Replaced by the line number of  a  line  in  the  input
          file.   The  line to be used is determined by the _X, as
          with the %b option.

     %L   Replaced by the line number of the  last  line  in  the
          input file.

     %m   Replaced by the total number of input files.

     %p_X  Replaced by the percent into the  current  input  file.
          The  line  used  is  determined by the _X as with the %b
          option.

     %s   Same as %B.

     %t   Causes any trailing spaces to be removed.  Usually used
          at the end of the string, but may appear anywhere.

     %x   Replaced by the name of the  next  input  file  in  the
          list.

     If any item is unknown (for example, the file size if  input
     is a pipe), a question mark is printed instead.

     The format of the prompt string can be changed depending  on
     certain  conditions.   A  question mark followed by a single
     character acts like an  "IF":  depending  on  the  following
     character,  a  condition  is evaluated.  If the condition is
     true, any characters following the question mark and  condi-
     tion  character, up to a period, are included in the prompt.
     If the condition is false, such characters are not included.
     A  colon  appearing between the question mark and the period
     can be used to establish an "ELSE": any  characters  between
     the  colon  and the period are included in the string if and
     only if the IF condition  is  false.   Condition  characters
     (which follow a question mark) may be:

     ?a   True if any characters have been included in the prompt
          so far.

     ?b_X  True if the byte offset of the specified line is known.

     ?B   True if the size of current input file is known.

     ?e   True if at end-of-file.

     ?f   True if there is an input filename (that is,  if  input
          is not a pipe).

     ?l_X  True if the line number of the specified line is known.

     ?L   True if the line number of the last line in the file is



                                                               19






LESS(1)                  USER COMMANDS                    LESS(1)



          known.

     ?m   True if there is more than one input file.

     ?n   True if this is the first prompt in a new input file.

     ?p_X  True if the percent into the current input file of  the
          specified line is known.

     ?s   Same as "?B".

     ?x   True if there is a next input file  (that  is,  if  the
          current input file is not the last one).

     Any characters other than the special ones  (question  mark,
     colon, period, percent, and backslash) become literally part
     of the  prompt.   Any  of  the  special  characters  may  be
     included  in  the  prompt  literally  by preceding it with a
     backslash.

     Some examples:

     ?f%f:Standard input.

     This prompt prints the filename,  if  known;  otherwise  the
     string "Standard input".

     ?f%f .?ltLine %lt:?pt%pt\%:?btByte %bt:-...

     This  prompt  would  print  the  filename,  if  known.   The
     filename is followed by the line number, if known, otherwise
     the percent if known, otherwise the byte  offset  if  known.
     Otherwise, a dash is printed.  Notice how each question mark
     has a matching period, and  how  the  %  after  the  %pt  is
     included literally by escaping it with a backslash.

     ?n?f%f .?m(file %i of %m) ..?e(END) ?x- Next\: %x..%t

     This prints the filename if this is the first  prompt  in  a
     file, followed by the "file N of N" message if there is more
     than one input file.  Then, if we are  at  end-of-file,  the
     string  "(END)"  is printed followed by the name of the next
     file, if there is one.  Finally,  any  trailing  spaces  are
     truncated.  This is the default prompt.  For reference, here
     are the defaults for  the  other  two  prompts  (-m  and  -M
     respectively).   Each is broken into two lines here for rea-
     dability only.

     ?n?f%f .?m(file %i of %m) ..?e(END) ?x- Next\: %x.:
          ?pB%pB\%:byte %bB?s/%s...%t

     ?f%f .?n?m(file %i of %m) ..?ltline %lt?L/%L. :byte %bB?s/%s. .



                                                               20






LESS(1)                  USER COMMANDS                    LESS(1)



          ?e(END) ?x- Next\: %x.:?pB%pB\%..%t

     And here is the default message produced by the = command:

     ?f%f .?m(file %i of %m) .?ltline %lt?L/%L. .
          byte %bB?s/%s. ?e(END) :?pB%pB\%..%t

     The prompt expansion features are also used for another pur-
     pose:  if an environment variable LESSEDIT is defined, it is
     used as the command to be executed when  the  v  command  is
     invoked.  The LESSEDIT string is expanded in the same way as
     the prompt strings.  The default value for LESSEDIT is:

          %E ?lm+%lm. %f

     Note that this expands to the editor name, followed by  a  +
     and  the  line  number,  followed by the file name.  If your
     editor does not accept  the  "+linenumber"  syntax,  or  has
     other  differences  in invocation syntax, the LESSEDIT vari-
     able can be changed to modify this default.


ENVIRONMENT VARIABLES
     Environment variables may be specified either in the  system
     environment as usual, or in a _l_e_s_s_k_e_y (1) file.

     COLUMNS
          Sets the number of columns on the screen.   Takes  pre-
          cedence  over  the  number  of columns specified by the
          TERM variable.  (But if you  have  a  windowing  system
          which  supports  TIOCGWINSZ  or  WIOCGETD,  the  window
          system's idea of the screen size takes precedence  over
          the LINES and COLUMNS environment variables.)

     EDITOR
          The name of the editor (used for the v command).

     HOME Name of the user's home directory (used to find a .less
          file).

     LANG Language for determining the character set.

     LC_CTYPE
          Language for determining the character set.

     LESS Flags which are passed to _l_e_s_s automatically.

     LESSBINFMT
          Format for displaying non-printable, non-control  char-
          acters.

     LESSCHARDEF



                                                               21






LESS(1)                  USER COMMANDS                    LESS(1)



          Defines a character set.

     LESSCHARSET
          Selects a predefined character set.

     LESSCLOSE
          Command  line   to   invoke   the   (optional)   input-
          postprocessor.

     LESSEDIT
          Editor prototype string (used for the v command).   See
          discussion under PROMPTS.

     LESSHELP
          Name of the help file.

     LESSOPEN
          Command  line   to   invoke   the   (optional)   input-
          preprocessor.

     LINES
          Sets the number of lines on  the  screen.   Takes  pre-
          cedence  over the number of lines specified by the TERM
          variable.

     SHELL
          The shell used to execute the ! command, as well as  to
          expand filenames.

     TERM The type of terminal on which _l_e_s_s is being run.

     VISUAL
          The name of the editor (used for the v command).


SEE ALSO
     lesskey(1)


WARNINGS
     The = command and prompts (unless changed by -P) report  the
     line  number  of  the line at the top of the screen, but the
     byte and percent of the line at the bottom of the screen.

     If the :e command is used to name more than  one  file,  and
     one  of  the named files has been viewed previously, the new
     files may be entered into the list in an unexpected order.

     On certain older terminals  (the  so-called  "magic  cookie"
     terminals),  search  highlighting  will  cause  an erroneous
     display.  On such terminals, search highlighting is disabled
     by default to avoid possible problems.



                                                               22






LESS(1)                  USER COMMANDS                    LESS(1)



     In certain cases, when search highlighting is enabled and  a
     search  pattern begins with a ^, more text than the matching
     string may be highlighted.



COPYRIGHT
     Copyright (c) 1984,1985,1989,1994,1995  Mark Nudelman















































                                                               23



