/* malloc a block of memory, with fatal error message if we can't do it. */

#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <malloc.h>
#include <memory.h>
#include <dos.h>

void _huge *
xhalloc (long size)
{
  void _huge *value = (void _huge *) halloc (size, (size_t)1 );

  if (!value)
    {
      fprintf (stderr, "indent: Virtual memory exhausted.\n");
      exit (1);
    }
  return value;
}

/* Here we do a huge "realloc" by allocating a new block and
   moving the old block afterwards.  This is *slow*, but should
   be reliable.  */

void _huge *
xhrealloc (void _huge *ptr, long new_size, long old_size)
{
  void _huge *value = (void _huge *) halloc (new_size, (size_t)1 );

  if (!value)
    {
      fprintf (stderr,"indent: Virtual memory exhausted.\n");
      exit (1);
    }
  else
    {
      char _huge *dest = value;
      char _huge *src = ptr;

      while (old_size > 0L)
	{
	  unsigned int bytes = (unsigned int) min (0x8000L, old_size);
	  memcpy (dest, src, bytes);
	  old_size -= (long) bytes;
	  dest += (long) bytes;
	  src += (long) bytes;
	}
    }
  hfree (ptr);
  return value;
}

long		/* doesn't belong here, but is also a 'huge' pointer kludge */
hread (int fd, char _huge *buffer, long bytes)
{
  long bytes_read = 0L;
  char *local;

  if ( (local = malloc(0x4001)) == NULL )
  {
    perror ("indent: memory exhausted");
    exit (1);
  }

  while (1)
    {
      int n = read (fd, local, (unsigned int) min (0x4000L, bytes));

      if (n > 0)
	{
	  bytes_read += (long) n;
	  bytes -= (long) n;
          memcpy(buffer, local, n); /* memcpy knows about huge pointers */
          buffer += n;
	}
      else if (n == 0)
      {
        free(local);
	return bytes_read;	/* done */
      }
      else
	{
	  perror ("indent: Error while reading input");
	  exit (1);
	}
    }
}


long
hwrite (int fd, char _huge *buffer, long bytes)
{
  long bytes_written = 0L;
  unsigned n, m;
  char *local;

  if ( (local = malloc(0x4001)) == NULL )
  {
    perror ("indent: memory exhausted");
    exit (1);
  }

  while (1)
    {
      n = (unsigned int) min (0x4000L, bytes);
      memcpy(local, buffer, n); /* memcpy knows about huge pointers */
      m = write (fd, local, n);

      if (m == n)
	{
	  bytes_written += (long) m;
	  bytes -= (long) m;

	  if (bytes <= 0)
          {
            free(local);
	    return bytes_written;
          }

          buffer += n;
	}
      else
	{
	  perror ("indent: Error while reading input");
	  exit (1);
	}
    }
}
