#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__makenew = "$Header: C:\CURSES\private\RCS\_makenew.c 2.1 1993/06/18 20:23:01 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_makenew()	- Create a WINDOW* (sans line allocation)

  PDCurses Description:
 	This is a private PDCurses routine.

 	Allocates all data for a new WINDOW* except the actual lines
 	themselves.

  PDCurses Return Value:
 	This function returns a valid WINDOW* on success and NULL on error.

  PDCurses Errors:
 	If PDC_makenew() is unable to allocate memory for the window
 	structure, it will free all allocated memory and return
 	a NULL pointer.

  Portability:
 	PDCurses	WINDOW* PDC_makenew( int num_lines, int num_columns,
 					 int begy, int begx );

**man-end**********************************************************************/

WINDOW*	PDC_makenew(int num_lines, int num_columns, int begy, int begx)
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	short	i;
	WINDOW *win;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_makenew() - called: lines %d cols %d begy %d begx %d\n",num_lines,num_columns,begy,begx);
#endif

	/*
	*	Use the standard runtime malloc/calloc package or use
	*	the user's emalloc/ecalloc package.
	*
	*	Allocate the window structure itself
	*/
	if ((win = (*mallc)(sizeof(WINDOW))) == (WINDOW *)NULL)
	{
		return( win );
	}

	/*
	* allocate the line pointer array
	*/
	if ((win->_y = (*callc)(num_lines, sizeof(chtype *))) == NULL)
	{
		(*fre)(win);
		return( (WINDOW *)NULL );
	}

	/*
	* allocate the minchng and maxchng arrays
	*/
	if ((win->_firstch = (*callc)(num_lines, sizeof(int))) == NULL)
	{
		(*fre)(win->_y);
		(*fre)(win);
		return( (WINDOW *)NULL );
	}
	if ((win->_lastch = (*callc)(num_lines, sizeof(int))) == NULL)
	{
		(*fre)(win->_firstch);
		(*fre)(win->_y);
		(*fre)(win);
		return( (WINDOW *)NULL );
	}

	/*
	* initialize window variables
	*/
	win->_curx = 0;
	win->_cury = 0;
	win->_maxy = num_lines;		/* real max screen size */
	win->_maxx = num_columns;	/* real max screen size */
	win->_pmaxy = num_lines;	/* real max window size */
	win->_pmaxx = num_columns;	/* real max window size */
	win->_begy = begy;
	win->_begx = begx;
	win->_flags = 0;
	win->_attrs = 0;		/* No attributes */
	win->_tabsize = 8;
	win->_clear = (bool) ((num_lines == LINES) && (num_columns == COLS));
	win->_leave = FALSE;
	win->_scroll = FALSE;
	win->_nodelay = FALSE;
	win->_use_keypad = FALSE;
	win->_use_idl = FALSE;
	win->_tmarg = 0;
	win->_bmarg = num_lines - 1;
	win->_title = NULL;
	win->_title_ofs = 1;
	win->_title_attr = win->_attrs;
	win->_blank = ' ';
	win->_parent = NULL;

	memset(win->_borderchars, '\0', 8*sizeof(chtype));

	/*
	* init to say window unchanged
	*/
	for (i = 0; i < num_lines; i++)
	{
		win->_firstch[i] = 0;
		win->_lastch[i] = num_columns - 1;
	}

	/*
	* set flags for window properties
	*/
	if ((begy + num_lines) == LINES)
	{
		win->_flags |= _ENDLINE;
		if ((begx == 0) &&
		    (num_columns == COLS) &&
		    (begy == 0))
		{
			win->_flags |= _FULLWIN;
		}
	}

	if (((begy + num_lines) == LINES) &&
	    ((begx + num_columns) == COLS))
	{
		win->_flags |= _SCROLLWIN;
	}
	return( win );
}
