/* glink.c */

/*
    Copyright (C) 1996 Chuck Kann  & Michael Bliss Feldman
			     ckann@seas.gwu.edu mfeldman@seas.gwu.edu
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.    


    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* modified May 1996 by Feldman; simplified for djgpp version 2 */
/* can be compiled using djgpp C; no longer requires Borland C  */
/* compile with gcc -o glink.exe glink.c                        */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
	
int
Run_Link(char **Args, int Num_Args)
{
    char *Program_Name = Args[0]; 
    int Name_Length;
    char Execute_Command[300];
    int i;

    Program_Name = Args[0];
    Name_Length = strlen(Program_Name);
    if ((strcmp(&Program_Name[Name_Length-3], "ali") != 0))
    {
	printf("File %s is not an \".ali\" file, linking not done\n", 
		Program_Name);
	return 0;
    }

    if (access(Program_Name, 0) != 0)
    {
	printf("File %s does not exist\n", Program_Name);
	return 0;
    }

    printf("Linking %s\n", Program_Name);
    Program_Name[Name_Length-4] = '\0';

    sprintf(Execute_Command,"gnatbind -x %s.ali", 
        Program_Name);
    system(Execute_Command);
    sprintf(Execute_Command,"gnatlink -g %s.ali", 
        Program_Name);
    /* for (i = 1; i < Num_Args ; ++i)
    {
        strcat(Execute_Command, " ");
        strcat(Execute_Command, Args[i]);
    } */
    system(Execute_Command);

    sprintf(Execute_Command,"fixfile %s",
        Program_Name);
    system(Execute_Command);
    return 1;
}

void main(int argc, char *argv[])
{
	char *Program_Name[2];
	int i;

    if (argc == 1)
    {
	Program_Name[0] = malloc(80 * sizeof(char));
        printf("Enter the name of the file to be linked\n");
        gets(Program_Name[0]);
        Run_Link(Program_Name, 0);
    }
    else
    {
	Run_Link(argv+1, argc -1);
    }
}
