generic
  Max_Elements : INTEGER := 100;
  type ITEM is private;
  with procedure ItemDisplay(E: in ITEM);

package Demo3 is
  type GSTACK is private;

  procedure Push ( S : in out GSTACK; E : in ITEM );
  procedure Init ( S : in out GSTACK );
  procedure Pop ( S : in out GSTACK; E : out ITEM );
  procedure Copy ( S1 : in GSTACK; S2 : in out GSTACK );
  procedure Display ( S : in GSTACK );
  function Is_Empty ( S : in GSTACK ) return BOOLEAN;
private -- Int_GSTACKs

  type LIST is array (1 .. Max_Elements) of ITEM;

  type GSTACK is
    record
      Structure : LIST;
      Top : INTEGER range 0 .. Max_Elements;
    end record;

end Demo3;
