
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adrepmen.adb "adatui-repaint_menu.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure repaint_menu ( 
   menu_window : pdcurses.A_WINDOW_T; 
   a_menu : a_menu_t ) 
is
   y           : c.signed_int;
   void        : c.signed_int;
   temp_str    : bstrings.bounded_string;
   temp_charv  : aliased c.charv(1..80);
   temp_charp  : c.charp;
   index       : natural;

begin

--
-- Modified loop to handle changes in menu type - AAD - 5/31/96
--
   index := 0;
   while a_menu.all(index).item_name /= NULL loop
      y := c.signed_int ( index + 1 );
      temp_str := bstrings.to_bounded_string( a_menu.all(index).item_name.all );
      make_charv (
	 source => temp_str,
	 target => temp_charv );
   --
   -- using unchecked access because type c.charp is defined at a higher
   -- level than temp_charv - creates a potential for dangling pointers
   --
      temp_charp := temp_charv'unchecked_access;

      void  := pdcurses.mvwaddstr ( menu_window, y, 2, temp_charp );
      index := index + 1;
   end loop;

   void := pdcurses.touchwin ( menu_window );
   void := pdcurses.wrefresh ( menu_window );
end repaint_menu;
