PACKAGE Rationals IS
------------------------------------------------------------------
--|                                                              
--| Specification of the abstract data type for representing
--| and manipulating rational numbers.
--| All rational quantities in this package are initialized
--| to 0/1.
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
 
  TYPE Rational IS PRIVATE;

  ZeroDenominator: EXCEPTION;

  FUNCTION "/" (X : Integer; Y : Integer) RETURN Rational;
  -- constructor:
  -- Pre :   X and Y are defined
  -- Post:   returns a rational number
  --   If Y > 0, returns Reduce(X,Y)
  --   If Y < 0, returns Reduce(-X,-Y)
  -- Raises: ZeroDenominator if Y = 0
 
  FUNCTION Numer (R : Rational) RETURN Integer;
  FUNCTION Denom (R : Rational) RETURN Positive;
  -- selectors:
  -- Pre: R is defined
  -- Post: Numer returns the numerator of R; Denom returns the denominator
 
  FUNCTION "<" (R1 : Rational; R2 : Rational) RETURN Boolean;
  FUNCTION "<="(R1 : Rational; R2 : Rational) RETURN Boolean;
  FUNCTION ">" (R1 : Rational; R2 : Rational) RETURN Boolean;
  FUNCTION ">="(R1 : Rational; R2 : Rational) RETURN Boolean;
  -- inquiry operators: comparison of two rational numbers
  -- Pre : R1 and R2 are defined
  -- Post: return R1 < R2, R1 > R2, R1 <= R2, and R1 >= R2, respectively
 
  FUNCTION "+"(R: Rational)   RETURN Rational;
  FUNCTION "-"(R: Rational)   RETURN Rational;
  FUNCTION "ABS"(R: Rational) RETURN Rational;
  -- monadic arithmetic constructors:
  -- Pre:  R is defined
  -- Post: return R, -R, and ABS R, respectively
 
  FUNCTION "+"(R1 : Rational; R2 : Rational) RETURN Rational;
  FUNCTION "-"(R1 : Rational; R2 : Rational) RETURN Rational;
  FUNCTION "*"(R1 : Rational; R2 : Rational) RETURN Rational;
  FUNCTION "/"(R1 : Rational; R2 : Rational) RETURN Rational;
  -- dyadic arithmetic constructors:
  -- Pre : R1 and R2 are defined
  -- Post: return the rational sum, difference, product, and
  --   quotient of R1 and R2, respectively
 
PRIVATE
-- A record of type Rational consists of a pair of Integer values
-- such that the first number represents the numerator of a rational
-- number and the second number represents the denominator.
 
  TYPE Rational IS RECORD
    Numerator  : Integer  := 0;
    Denominator: Positive := 1;
  END RECORD; 
END Rationals;
