WITH Swap_Generic;
PROCEDURE Sort_Merge_Generic(List: IN OUT ListType) IS
------------------------------------------------------------------------
--| Body of generic Merge Sort
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: January 1996                                     
------------------------------------------------------------------------

  PROCEDURE Exchange IS NEW Swap_Generic(ValueType => ElementType);
  
  TempArray        : ListType(List'Range);
  Max              : CONSTANT Integer := Integer(List'Last);
  CurrentLength    : Integer;  -- Length of subarrays 
  M                : Integer;  -- Position in Result
  Left,  TopLeft   : Integer;  -- Position and end of Left 
  Right, TopRight  : Integer;  -- Position and end of Right 
 
BEGIN
 
  CurrentLength := 1;
  WHILE CurrentLength < Max LOOP  -- New phase
 
    TempArray := List;
    Left := Integer(List'First);
    M := Integer(List'First);
 
    WHILE Left <= Max LOOP  -- Find pair of subarrays

      IF Left + CurrentLength <= Max THEN
        TopLeft := Left + CurrentLength;
      ELSE
        TopLeft := Max + 1;
      END IF;
      Right := TopLeft; 
 
      IF Right + CurrentLength <= Max THEN
        TopRight := Right + CurrentLength;
      ELSE
        TopRight := Max + 1;
      END IF;

      -- Go until one subarray runs out
      WHILE Left < TopLeft AND Right < TopRight LOOP
 
        IF KeyOf(TempArray(IndexType(Left))) 
         < KeyOf(TempArray(IndexType(Right))) THEN
          List(IndexType(M)) := TempArray(IndexType(Left));
          Left := Left + 1;
 
        ELSE
          List(IndexType(M)) := TempArray(IndexType(Right));
          Right := Right + 1;
 
        END IF;
        M := M + 1;

      END LOOP;
 
      -- Now "copy tail" of whichever subarray remains
      WHILE Left < TopLeft LOOP
        List(IndexType(M)) := TempArray(IndexType(Left));
        Left := Left + 1;
        M := M + 1;
      END LOOP;  
 
      WHILE Right < TopRight LOOP
        List(IndexType(M)) := TempArray(IndexType(Right));
        Right := Right + 1;
        M := M + 1;
      END LOOP;
 
      Left := TopRight;  -- Next pair of subarrays
    END LOOP;
 
    -- Now double size of subarrays
    -- and go back for next phase
 
    Put (List);  -- for debugging; display array at end of each phase

    CurrentLength := 2 * CurrentLength;
  END LOOP;
 
END Sort_Merge_Generic;
