GENERIC

  TYPE Element IS PRIVATE;     -- assignment and equality predefined
  TYPE KeyType IS PRIVATE;     -- here too

  Capacity: IN Positive;       -- maximum table size

  WITH FUNCTION  KeyOf      (Item: Element) RETURN KeyType;
  WITH FUNCTION  "<"        (Key1, Key2: KeyType) RETURN Boolean;

  -- This parameter specifies what to do with each element during
  -- a traversal of a table;
  WITH PROCEDURE Visit (Item: Element);

PACKAGE Table_ADO_Generic IS
------------------------------------------------------------------
--| Specification of the abstract data object for a table of
--| element records, each containing a key.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

-- Exported exceptions

  UninitializedTable: EXCEPTION;
  NoSpaceLeft       : EXCEPTION;

-- Operations  

  PROCEDURE InitializeTable;
  -- Pre : None
  -- Post: the Table ADO is initialized 
     
  FUNCTION SizeOfTable RETURN Natural;
  -- Pre : the Table ADO is initialized 
  -- Post: Returns the number of elements in the Table ADO

  PROCEDURE Search (Target  : KeyType;
                    Success : OUT Boolean);
  --  Pre : the Table ADO is initialized 
  --  Post: Success is True if Target is found; otherwise,
  --        Success is False.
     
  PROCEDURE Insert (Item    : Element;
                    Success : OUT Boolean);
  --  Pre : Item is defined; the Table ADO is initialized.
  --  Post: Success is True if insertion is performed; Success is False
  --        if insertion is not performed because there is already
  --        an element with the same key as Item.
  --  Raises: NoSpaceLeft if there is no space available for Item.
     
  PROCEDURE Delete (Target  : KeyType;
                    Success : OUT Boolean);
  --  Pre : Target are defined; Table ADO is initialized.
  --  Post: Success is True if deletion is performed; Success is False
  --        if deletion is not performed because there is no element
  --        whose key is Target.
     
  PROCEDURE Replace (Item    : Element;
                     Success : OUT Boolean);
  --  Item by the contents of Item.
  --  Pre : Item is defined; Table ADO is initialized.
  --  Post: Success is True if the replacement is performed; Success is
  --        False if there is no element with the same key as Item.
     
  PROCEDURE Retrieve (Target  : KeyType;
                      Item    : OUT Element;
                      Success : OUT Boolean);
  --  Pre : Table ADO is initialized 
  --  Post: Success is True if the copy is performed; Success is False
  --        if there is no element whose key is Target.

  PROCEDURE Traverse;
  --  Repeatedly calls procedure Visit (a generic parameter) to
  --    process each element of the Table ADO.
  --  Pre : Table ADO is initialized 
  --  Post: Each element is operated on in turn by procedure Visit.

END Table_ADO_Generic; 

