WITH Dates; USE Dates;
WITH Ada.Text_IO; 
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Dates IS
------------------------------------------------------------------
--|                                                              
--| Simple test of Dates package
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
--|                                                              
------------------------------------------------------------------

  TYPE Days IS (Mon, Tue, Wed, Thu, Fri, Sat, Sun);
  PACKAGE Days_IO IS NEW Ada.Text_IO.Enumeration_IO(Enum => Days);
  
  ThatDay, ThisDay: Date;

  PROCEDURE PutDate(Item: IN Date) IS
  BEGIN

    -- DayOfWeek returns 1..7, but positions are 0..6.
    Days_IO.Put(Item => Days'Val(DayOfWeek(Item) - 1), Width => 4);

    Ada.Integer_Text_IO.Put(Item => Month(Item), Width => 1);
    Ada.Text_IO.Put('/');
    Ada.Integer_Text_IO.Put(Item => DayOfMonth(Item), Width => 1);
    Ada.Text_IO.Put('/');
    Ada.Integer_Text_IO.Put(Item => Year(Item) REM 100, Width => 1);

  END PutDate;

BEGIN -- Test_Dates
   
  -- First, is today's date OK?
  ThisDay := Today;
  PutDate(Item => ThisDay);
  Ada.Text_IO.New_Line(Spacing => 2);

  -- Now make a table of dates for the current year.
  Ada.Text_IO.Put("Today           Yesterday       31 days from today");
  Ada.Text_IO.New_Line(Spacing => 2);
  
  FOR WhichMonth IN MonthNumber LOOP
    ThisDay := MakeDate(Year => Year(ThisDay), Month => WhichMonth, Day => 1);
    ThatDay := ThisDay - 1;     
    PutDate(Item => ThisDay);
    Ada.Text_IO.Put(Item => "     ");
    PutDate(Item => ThatDay);
    Ada.Text_IO.Put(Item => "     ");
    PutDate(Item => ThisDay + 31);
    Ada.Text_IO.New_Line;
  END LOOP;

  -- Now make a table of dates for a leap year.
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put("Today           Yesterday       31 days from today");
  Ada.Text_IO.New_Line(Spacing => 2);
 
  FOR WhichMonth IN MonthNumber LOOP
    ThisDay := MakeDate(Year => 1992, Month => WhichMonth, Day => 1);
    ThatDay := ThisDay - 1;     
    PutDate(Item => ThisDay);
    Ada.Text_IO.Put(Item => "     ");
    PutDate(Item => ThatDay);
    Ada.Text_IO.Put(Item => "     ");
    PutDate(Item => ThisDay + 31);
    Ada.Text_IO.New_Line;
  END LOOP;

END Test_Dates;
