PACKAGE BODY Vectors IS
------------------------------------------------------------------------
--| Body of Vectors package
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------------
 
  FUNCTION "+" (K : Float; Right : Vector) RETURN Vector IS
    Result : Vector(Right'Range);
  BEGIN 
    FOR R IN Right'Range LOOP
      Result(R) := K + Right(R);
    END LOOP;
 
    RETURN Result;
  END "+";
 
  FUNCTION "*" (K : Float; Right : Vector) RETURN Vector IS
  BEGIN -- stub
    RETURN Right;
  END "*";
 
  FUNCTION "+" (Left, Right : Vector) RETURN Vector IS
    Result : Vector(Left'Range);
  BEGIN 
    -- First check for conformability
    IF Left'First = Right'First AND 
       Left'Last  = Right'Last  THEN
  
    -- if conformable, go on to compute
      FOR R IN Left'Range LOOP
        Result(R) := Left(R) + Right(R);
      END LOOP;
 
      RETURN Result;

    ELSE
      RAISE Bounds_Error;
    END IF;
  END "+";
 
  FUNCTION "*" (Left, Right : Vector) RETURN Float IS
    Sum : Float;
  BEGIN -- stub
    RETURN 0.0;
  END "*";

END Vectors;
