WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Blank_Count IS
------------------------------------------------------------------
--| Counts the number of blanks in a sentence.   
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

   Blank :    CONSTANT Character :=  ' ';  -- character being counted   
   Sentinel : CONSTANT Character :=  '.';   -- sentinel character   

   Next  : Character;             -- next character in sentence   
   Count : Natural;               -- number of blank characters   

BEGIN  -- Blank_Count   

  Count :=  0;                    -- Initialize Count   
  Ada.Text_IO.Put(Item => "Enter a sentence ending with a period.");
  Ada.Text_IO.New_Line;

  -- Process each input character up to the period   
  Ada.Text_IO.Get(Item => Next);      -- Get first character   
  Ada.Text_IO.Put(Item => Next);
  WHILE Next /= Sentinel LOOP
    -- invariant: Count is the count of blanks so far and
    --   no prior value of Next is the sentinel
      
    IF Next = Blank THEN
      Count := Count + 1;         -- Increment blank count   
    END IF;
    Ada.Text_IO.Get(Item => Next);    -- Get next character   
    Ada.Text_IO.Put(Item => Next);
  END LOOP;
  -- assert: Count is the count of blanks and Next is the sentinel   

  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item => "The number of blanks is ");
  Ada.Integer_Text_IO.Put(Item => Count, Width => 1);
  Ada.Text_IO.New_Line;

END Blank_Count;
