WITH Ada.Text_IO;
PROCEDURE Colors IS
------------------------------------------------------------------
--|                                                              
--| Displays a French color, given the corresponding English color
--|                                                              
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
--|                                                              
------------------------------------------------------------------
 
  TYPE English_Colors IS 
     (white, black, red, purple, blue, green, yellow, orange);
         
  TYPE French_Colors IS 
     (blanc, noir, rouge, pourpre, bleu, vert, jaune, orange);
           
  PACKAGE English_Color_IO IS 
     NEW Ada.Text_IO.Enumeration_IO (Enum => English_Colors);
 
  PACKAGE French_Color_IO IS 
     NEW Ada.Text_IO.Enumeration_IO (Enum => French_Colors);
 
  Eng_Color : English_Colors;
  Fr_Color  : French_Colors;
  Position  : Natural;
     
BEGIN -- Colors

  Ada.Text_IO.Put (Item => "Please enter an English color > ");
  English_Color_IO.Get (Item => Eng_Color);

  Position := English_Colors'Pos(Eng_Color);
  Fr_Color  := French_Colors'Val(Position);
   
  Ada.Text_IO.Put (Item => "The French color is ");
  French_Color_IO.Put (Item => Fr_Color, Set => Ada.Text_IO.Lower_Case);
  Ada.Text_IO.New_Line;

END Colors;
 
