WITH Ada.Text_IO;
PROCEDURE Triangle IS
------------------------------------------------------------------
--| Draws an isosceles triangle
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------

  NumLines: CONSTANT Integer := 5;
  Blank   : CONSTANT Character := ' ';
  Star    : CONSTANT Character := '*';

BEGIN -- Triangle   

  FOR Row IN 1 .. NumLines LOOP    -- draw each row

    FOR LeadBlanks IN REVERSE 1 .. NumLines - Row LOOP
      Ada.Text_IO.Put(Item => Blank);  -- display leading blanks
    END LOOP;

    FOR CountStars IN 1 .. (2*Row) - 1 LOOP
      Ada.Text_IO.Put(Item => Star);   -- display asterisks
    END LOOP;

    Ada.Text_IO.New_Line;              -- terminate row

  END LOOP;      

END Triangle;
