#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <string.h>
#include <sys\stat.h>

#define false 0
#define true 1

unsigned char usebyte;
unsigned char infobyte;
char wib=-1;

void error(char *message, char choice, int fi) {
	if(choice)
		close(fi);
	printf("%s\n",message);
	exit(0);
}

void setpalette(char *palette, unsigned int n) {
	unsigned int s, o;
	s=FP_SEG(palette);
	o=FP_OFF(palette);
	asm {
		mov ax,0x1012
		mov bx,0x0000
		mov cx,n
		mov dx,o
		mov es,s
		int 0x10
	}
}

unsigned char getbyte(int fi) {
	unsigned char outbyte;
	if(wib==-1) {
		read(fi, &usebyte, 1);
		wib=7;
	}
	switch(infobyte&0x14) {
		case 0x14:
			outbyte=usebyte&(1<<(wib));
			wib--;
			break;
		case 0x04:
			outbyte=usebyte&(3<<(wib-1));
			wib-=2;
			break;
		case 0x00:
			outbyte=usebyte&(15<<(wib-3));
			wib-=4;
			break;
		case 0x10:
			outbyte=usebyte;
			wib=1;
	}
	return outbyte;
}

void main(int argc, char *argv[]) {
	unsigned char ch;
	unsigned int dtime;
	unsigned char header[4];
	int fi;
	unsigned char fullqrt;
	int l;
	unsigned char line[320];
	unsigned int lineoffset;
	unsigned char name[50];
	unsigned char no_step;
	unsigned int offset;
	char palette[768];
	unsigned int palsize;
	unsigned int to_x;
	unsigned char to_y;
	unsigned char showit;
	unsigned char version;
	unsigned char far *vidmem;
	int work;
	int x;
	unsigned char y;
	printf("Show DVM C++\nWritten by Bert Greevenbosch for Magic Software Rotterdam\nDevelopment Kit Version\nLast possible DVM version: 4.0\n");
	fi=open("DVMPAL.BIN",O_BINARY|O_RDONLY);
	if(fi==-1)
		error("Cannot open DVMPAL.BIN", false, fi);
	read(fi, &palette, 768);
	close(fi);
	if(argc==1)
		error("Syntax: SDC [Filename.DVM][/I]",0,fi);
	work=0;
	showit=false;
	strcpy(name, argv[1]);
	do {
		work++;
		if(name[work]=='/') {
			name[work]=0;
			work++;
			if(name[work]=='I'||name[work]=='i')
				showit=true;
		}
	} while(name[work]);
	if(strcmp(argv[2],"/I")==0)
		showit=true;
	fi=open(name,O_BINARY|O_RDONLY);
	if(fi==-1)
		error("Error opening file", false, fi);
	read(fi, &header, 3);
	header[3]=0;
	if(strcmp(header, "DVM"))
		error("Not a DVM", true, fi);
	read(fi, &fullqrt, 1);
	switch(fullqrt) {
		case 'F':
			infobyte=0xa0;
			break;
		case 'Q':
			infobyte=0x20;
			break;
		case 'V':
			read(fi, &version,1);
			if(version>0x40)
				error("Wrong version", true, fi);
			read(fi, &infobyte,1);
	}
	read(fi, &dtime, 2);
	if((infobyte&0x08)==0x08) {
		read(fi, &l, 2);
		for(work=0; work<l; work++) {
			read(fi, &ch, 1);
			if(showit)
				printf("%c", ch);
		}
		if(showit)
			asm {
				mov ah,0x00
				int 0x16
			}
	}
	asm {
		mov ax,0x0013
		int 0x10
	}
	vidmem=(char far *)MK_FP(0xa000, 0x0000);
	setpalette(palette, 256);
	switch(infobyte&0x14) {
		case 0x14:
			no_step=8;
			palsize=2;
			break;
		case 0x04:
			no_step=4;
			palsize=4;
			break;
		case 0x00:
			no_step=2;
			palsize=16;
			break;
		case 0x10:
			no_step=1;
			palsize=256;
	}
	if(!(infobyte&0x40))
		no_step=1;
	if((infobyte&0x22)==0x22) {
		read(fi, &palette, palsize*3);
		setpalette(palette, palsize);
	}
	do {
		if((infobyte&0x22)==0x20) {
			read(fi, &palette, palsize*3);
			setpalette(palette, palsize);
		}
		offset=0;
		if((infobyte&0x80)==0x80) {
			to_y=200;
			to_x=320;
		}
		else {
			to_y=100;
			to_x=160;
		}
		for(y=0; y<to_y; y++) {
			read(fi, &line, to_x/no_step);
			lineoffset=0;
			for(x=0; x<to_x; x+=no_step) {
				switch(no_step) {
					case 1:
						vidmem[offset]=line[lineoffset];
						break;
					case 2:
						vidmem[offset]=(line[lineoffset]&0xf0)>>4;
						vidmem[offset+1]=line[lineoffset]&0x0f;
						break;
					case 4:
						vidmem[offset]=(line[lineoffset]&0xc0)>>6;
						vidmem[offset+1]=(line[lineoffset]&0x30)>>4;
						vidmem[offset+2]=(line[lineoffset]&0x0c)>>2;
						vidmem[offset+3]=(line[lineoffset]&0x03);
						break;
					case 8:
						for(work=7; work>=0; work--)
							vidmem[offset+7-work]=(line[lineoffset]>>work)&0x01;
				}
				offset+=no_step;
				lineoffset++;
			}
			if(x==160)
				offset+=160;
		}
	} while(!eof(fi));
	close(fi);
	asm {
		mov ah,0x00
		int 0x16
		mov ax,0x0003
		int 0x10
	}
}