@rem disk1 is read-only, has a copy of \BIN\ (no REN - to avoid LFN conflicts).
@rem disk2 is large, all archives, *.tst and *.dir files are created there.
@rem All archivers and DO_*.BATs are in one of the %path% directories.

set disk1=c:
set disk2=d:
set dir0=\BIN\
set dir1=%dir0%astronmy\
set dir2=%dir0%chem\
set dir3=%dir0%font\
set dir4=%dir0%graphics\
set dir5=%dir0%lang\
set dir6=%dir0%mapping\
set dir7=%dir0%proj\
set dir8=%dir0%science\
set dir9=%dir0%winhelp\
set dira=%dir0%xwindows\

%disk2%
cd %dir0%
if "%1"=="" goto main
if "%2"=="" goto DIRnDEL
if "%3"=="" goto RENAME
if not "%8"=="" goto COMPRESS

@rem         If seven parameters given - EXTRACT process starts
:EXTRACT
call %0 %1 %2 %3 %4 %5 %6 %7 -
fc/b %dir1%*.bin %disk1%%dir1%*.bin >>!_%6.tst
fc/b %dir2%*.bin %disk1%%dir2%*.bin >>!_%6.tst
fc/b %dir3%*.bin %disk1%%dir3%*.bin >>!_%6.tst
fc/b %dir4%*.bin %disk1%%dir4%*.bin >>!_%6.tst
fc/b %dir5%*.bin %disk1%%dir5%*.bin >>!_%6.tst
fc/b %dir6%*.bin %disk1%%dir6%*.bin >>!_%6.tst
fc/b %dir7%*.bin %disk1%%dir7%*.bin >>!_%6.tst
fc/b %dir8%*.bin %disk1%%dir8%*.bin >>!_%6.tst
fc/b %dir9%*.bin %disk1%%dir9%*.bin >>!_%6.tst
fc/b %dira%*.bin %disk1%%dira%*.bin >>!_%6.tst
call %0 bin
goto end

@rem         If two parameters given - RENAME process starts
:RENAME
ren %dir1%*.%1 *.%2
ren %dir2%*.%1 *.%2
ren %dir3%*.%1 *.%2
ren %dir4%*.%1 *.%2
ren %dir5%*.%1 *.%2
ren %dir6%*.%1 *.%2
ren %dir7%*.%1 *.%2
ren %dir8%*.%1 *.%2
ren %dir9%*.%1 *.%2
ren %dira%*.%1 *.%2
goto end

@rem         If one parameter given - DIR'n'DEL process starts
:DIRnDEL
dir /s/on %dir3%*.%1 >>!_%1.dir
dir /s/on %dira%*.%1 >>!_%1.dir
dir /s/on %dir0%*.%1 >>!_%1.dir
del %dir1%*.%1
del %dir2%*.%1
del %dir3%*.%1
del %dir4%*.%1
del %dir5%*.%1
del %dir6%*.%1
del %dir7%*.%1
del %dir8%*.%1
del %dir9%*.%1
del %dira%*.%1
goto end



@rem         If no parameters given - MAIN process starts
:main
goto cont5
@rem            %1    %2  %p3% %p4% %p5%   %p6%     %p7%  %8  %9
call %0   pkzip  -exx  -    -    -     .pkz     .bin -
call %0   rar      a  -m5  -mde  -mm    -       .bin -
@rem call %0 bin bi0    (no REN - to avoid LFN conflicts).
call %0 bin
call %0 call do_xtrct pkunzip -e -     .pkz     .bin
call %0 call do_xtrct rar   x    -     .rar     .bin
goto end

call %0   sbc      c   -b59 -m1  -     .sb1     .bin -
call %0   sbc      c   -b59 -m2  -     .sb2     .bin -
call %0   sbc      c   -b59 -m3  -     .sb3     .bin -
call %0   sbc      c   -b59 -m3  -a    .sba     .bin -
call %0 bin
call %0 call do_xtrct sbc  x     -     .sba     .bin
call %0 call do_xtrct sbc  x     -     .sb3     .bin
call %0 call do_xtrct sbc  x     -     .sb2     .bin
call %0 call do_xtrct sbc  x     -     .sb1     .bin

:cont1
call %0   dc     e  -       -    -     .bin     .dc0 -
call %0   dc     e -b16300 -mb5  -     .bin     .dc5 -
call %0   ace32  a -m5    -d4096 -std  .ace     .bin -
call %0   eri  a!! -m5      -    -     .eri     .bin -
call %0 bin
call %0   eri      x   -    -    -     .eri     .bin
call %0   dc       x   -    -    -     .dc0     .bin
call %0   dc       x   -    -    -     .dc5     .bin
call %0 call do_xtrct ace32 x    -     .ace     .bin

:cont2
call %0  7z        a  -mx -tufa1 -     .uf1     .bin -
call %0  7zip      a  -mx   -    -     .7zi     .bin -
call %0  imp98     a   -2   -s4  -mm   .im2     .bin -
call %0  imp98     a   -1   -m3  -mm   .im1     .bin -
call %0  bix       a  -m9 -mdg   -     .bx9     .bin -
call %0  bzip2    -k   -9   -    -     .bin     .bin.bz2 -
call %0 bin
call %0 call do_xtrct 7z    x    -     .uf1     .bin
call %0 call do_xtrct 7zip  x    -     .7zi     .bin
call %0 call do_xtrct imp98 e    -     .im1     .bin
call %0 call do_xtrct imp98 e    -     .im2     .bin
call %0 call do_xtrct  bix  x    -     .bx9     .bin
call %0   bzip2   -dk  -    -    -     .bin.bz2 .bin


:cont2a
call %0   ybs_d -m16mu -    -    -     .y16     .bin -
call %0   ybs_d -m16mu -r   -    -     .ybr     .bin -
call %0   ba      -k   -50  -j   -     .bin     .bin.ba bin.ba bin.baj
call %0   ba      -k   -50  -    -     .bin     .bin.ba
call %0 bin
call %0 call do_xtrct ybs_d -d   -     .ybr     .bin
call %0 call do_xtrct ybs_d -d   -     .y16     .bin
call %0   ba      -dk  -    -    -     .bin.baj .bin
call %0   ba      -dk  -    -    -     .bin.ba  .bin

:cont3
call %0   zzip     a  -mx  -30m  -mm   .zz      .bin zz  zzm
call %0   zzip     a  -mx  -30m  -a    .zz      .bin zz  zza
call %0   zzip     a  -mx  -30m  -     .zz      .bin -
call %0   szip    -o10 -b41 -    -     .bin     .s10 -
call %0   szip    -o0  -b41 -    -     .bin     .sz0 -
call %0 bin
call %0   zzip     x   -    -    -     .zzm     .bin
call %0   zzip     x   -    -    -     .zza     .bin
call %0   zzip     x   -    -    -     .zz      .bin
call %0   szip    -d   -    -    -     .s10     .bin
call %0   szip    -d   -    -    -     .sz0     .bin

:cont4
call %0   rk      -mx3 -B9000 -  -     .rk4     .bin -
call %0 call  do_777  777 -mu32  -mg   .777     .bin -
call %0   uharc   a  -md8192 -m3 -     .uh3     .bin -
call %0   uharc   a  -md8192 -mx -     .uhx     .bin -
call %0   uharc   a  -md8192 -mz -     .uhz     .bin -
call %0   rk      -mx3 -    -    -     .rk3     .bin -
call %0 bin
call %0 call do_xtrct uharc x    -     .uhx     .bin
call %0 call do_xtrct uharc x    -     .uh3     .bin
call %0 call do_xtrct uharc x    -     .uhz     .bin
call %0 call do_xtrct 777   x    -     .777     .bin
call %0   rk     -x    -    -    -     .rk4     .bin
call %0   rk     -x    -    -    -     .rk3     .bin
goto end

:cont5
call %0   ppmonstr e  -o16 -m184 -     .bin     .pmm pmm o16
call %0   ppmonstr e  -o1  -m184 -     .bin     .pmm pmm o01
call %0   arh      a   -1   -2   -mm   .lg3     .bin -
call %0   boa    -m15  -    -    -     .b58     .bin -
call %0 bin
call %0 call do_xtrct ppmonstr d -     .o16     .bin
call %0 call do_xtrct ppmonstr d -     .o01     .bin
call %0 call do_xtrct arh   x    -     .lg3     .bin
call %0 call do_xtrct boa  -x    -     .b58     .bin
goto end


@rem         If more than seven parameters given - COMPRESS process starts
:COMPRESS
set p3=%3
set p4=%4
set p5=%5
set p6=%6
set p7=%7
if "%3"=="-" set p3=
if "%4"=="-" set p4=
if "%5"=="-" set p5=
if "%6"=="-" set p6=
if "%7"=="-" set p7=
if "%1"=="rk" goto lfname
if "%1"=="boa" goto lfname
if "%3"=="777" goto lfname
if "%1"=="ppmonstr" goto lfname

cd %dir1%

%1 %2 %p3% %p4% %p5% ___IBM~1%p6%       ___IBM~1%p7%
rem abort if something went wrong
if not exist ___IBM~1%p6% goto finish
if not exist ___IBM~1%p7% goto finish
%1 %2 %p3% %p4% %p5% ___SPE~1%p6%       ___SPE~1%p7%
%1 %2 %p3% %p4% %p5% ___TES~1%p6%       ___TES~1%p7%
%1 %2 %p3% %p4% %p5% ___TES~2%p6%       ___TES~2%p7%
%1 %2 %p3% %p4% %p5% __H~1%p6%          __H~1%p7%
%1 %2 %p3% %p4% %p5% _-H~1%p6%          _-H~1%p7%
%1 %2 %p3% %p4% %p5% _ACKGR~1%p6%       _ACKGR~1%p7%
%1 %2 %p3% %p4% %p5% _AKEF~10%p6%       _AKEF~10%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~1%p6%       _AKEFI~1%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~2%p6%       _AKEFI~2%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~3%p6%       _AKEFI~3%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~4%p6%       _AKEFI~4%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~5%p6%       _AKEFI~5%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~6%p6%       _AKEFI~6%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~7%p6%       _AKEFI~7%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~8%p6%       _AKEFI~8%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~9%p6%       _AKEFI~9%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~1%p6%       _ALLIS~1%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~2%p6%       _ALLIS~2%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~3%p6%       _ALLIS~3%p7%
%1 %2 %p3% %p4% %p5% _AP_DR~1%p6%       _AP_DR~1%p7%
%1 %2 %p3% %p4% %p5% _APC~1%p6%         _APC~1%p7%
%1 %2 %p3% %p4% %p5% _APEXE~1%p6%       _APEXE~1%p7%
%1 %2 %p3% %p4% %p5% _APH~1%p6%         _APH~1%p7%
%1 %2 %p3% %p4% %p5% _APMAK~1%p6%       _APMAK~1%p7%
%1 %2 %p3% %p4% %p5% _ARBAG~1%p6%       _ARBAG~1%p7%
%1 %2 %p3% %p4% %p5% _ARSFD~1%p6%       _ARSFD~1%p7%
%1 %2 %p3% %p4% %p5% _ARSSF~1%p6%       _ARSSF~1%p7%
%1 %2 %p3% %p4% %p5% _ARSSP~1%p6%       _ARSSP~1%p7%
%1 %2 %p3% %p4% %p5% _ARTHB~1%p6%       _ARTHB~1%p7%
%1 %2 %p3% %p4% %p5% _ARTHF~1%p6%       _ARTHF~1%p7%
%1 %2 %p3% %p4% %p5% _ARTHS~1%p6%       _ARTHS~1%p7%
%1 %2 %p3% %p4% %p5% _ASASP~1%p6%       _ASASP~1%p7%
%1 %2 %p3% %p4% %p5% _ASERJ~1%p6%       _ASERJ~1%p7%
%1 %2 %p3% %p4% %p5% _ATLON~1%p6%       _ATLON~1%p7%
%1 %2 %p3% %p4% %p5% _ATURN~1%p6%       _ATURN~1%p7%
%1 %2 %p3% %p4% %p5% _B_730~1%p6%       _B_730~1%p7%
%1 %2 %p3% %p4% %p5% _B_CPM~1%p6%       _B_CPM~1%p7%
%1 %2 %p3% %p4% %p5% _B_IBM~1%p6%       _B_IBM~1%p7%
%1 %2 %p3% %p4% %p5% _B_SPE~1%p6%       _B_SPE~1%p7%
%1 %2 %p3% %p4% %p5% _B_SYS~1%p6%       _B_SYS~1%p7%
%1 %2 %p3% %p4% %p5% _B_TES~1%p6%       _B_TES~1%p7%
%1 %2 %p3% %p4% %p5% _B_XC~1%p6%        _B_XC~1%p7%
%1 %2 %p3% %p4% %p5% _BH~1%p6%          _BH~1%p7%
%1 %2 %p3% %p4% %p5% _EADM~10%p6%       _EADM~10%p7%
%1 %2 %p3% %p4% %p5% _EADME~1%p6%       _EADME~1%p7%
%1 %2 %p3% %p4% %p5% _EADME~2%p6%       _EADME~2%p7%
%1 %2 %p3% %p4% %p5% _EADME~3%p6%       _EADME~3%p7%
%1 %2 %p3% %p4% %p5% _EADME~4%p6%       _EADME~4%p7%
%1 %2 %p3% %p4% %p5% _EADME~5%p6%       _EADME~5%p7%
%1 %2 %p3% %p4% %p5% _EADME~6%p6%       _EADME~6%p7%
%1 %2 %p3% %p4% %p5% _EADME~7%p6%       _EADME~7%p7%
%1 %2 %p3% %p4% %p5% _EADME~8%p6%       _EADME~8%p7%
%1 %2 %p3% %p4% %p5% _EADME~9%p6%       _EADME~9%p7%
%1 %2 %p3% %p4% %p5% _EFAUL~1%p6%       _EFAUL~1%p7%
%1 %2 %p3% %p4% %p5% _EFAUL~2%p6%       _EFAUL~2%p7%
%1 %2 %p3% %p4% %p5% _EFTPB~1%p6%       _EFTPB~1%p7%
%1 %2 %p3% %p4% %p5% _ENUSF~1%p6%       _ENUSF~1%p7%
%1 %2 %p3% %p4% %p5% _EPTUN~1%p6%       _EPTUN~1%p7%
%1 %2 %p3% %p4% %p5% _ERCUR~1%p6%       _ERCUR~1%p7%
%1 %2 %p3% %p4% %p5% _ERIDI~1%p6%       _ERIDI~1%p7%
%1 %2 %p3% %p4% %p5% _ERMAN~1%p6%       _ERMAN~1%p7%
%1 %2 %p3% %p4% %p5% _ERMH~1%p6%        _ERMH~1%p7%
%1 %2 %p3% %p4% %p5% _ERMNU~1%p6%       _ERMNU~1%p7%
%1 %2 %p3% %p4% %p5% _ERMNX~1%p6%       _ERMNX~1%p7%
%1 %2 %p3% %p4% %p5% _ESIZE~1%p6%       _ESIZE~1%p7%
%1 %2 %p3% %p4% %p5% _ESKJE~1%p6%       _ESKJE~1%p7%
%1 %2 %p3% %p4% %p5% _EST_S~1%p6%       _EST_S~1%p7%
%1 %2 %p3% %p4% %p5% _ESTDO~1%p6%       _ESTDO~1%p7%
%1 %2 %p3% %p4% %p5% _ESTM~1%p6%        _ESTM~1%p7%
%1 %2 %p3% %p4% %p5% _ESTPB~1%p6%       _ESTPB~1%p7%
%1 %2 %p3% %p4% %p5% _ESTSF~1%p6%       _ESTSF~1%p7%
%1 %2 %p3% %p4% %p5% _ESTSP~1%p6%       _ESTSP~1%p7%
%1 %2 %p3% %p4% %p5% _EWSFS~1%p6%       _EWSFS~1%p7%
%1 %2 %p3% %p4% %p5% _FS_DI~1%p6%       _FS_DI~1%p7%
%1 %2 %p3% %p4% %p5% _FS_FT~1%p6%       _FS_FT~1%p7%
%1 %2 %p3% %p4% %p5% _FS_GT~1%p6%       _FS_GT~1%p7%
%1 %2 %p3% %p4% %p5% _FS_PE~1%p6%       _FS_PE~1%p7%
%1 %2 %p3% %p4% %p5% _FS_PR~1%p6%       _FS_PR~1%p7%
%1 %2 %p3% %p4% %p5% _FS_VI~1%p6%       _FS_VI~1%p7%
%1 %2 %p3% %p4% %p5% _FSC~1%p6%         _FSC~1%p7%
%1 %2 %p3% %p4% %p5% _FSH~1%p6%         _FSH~1%p7%
%1 %2 %p3% %p4% %p5% _FSM_N~1%p6%       _FSM_N~1%p7%
%1 %2 %p3% %p4% %p5% _FSM_O~1%p6%       _FSM_O~1%p7%
%1 %2 %p3% %p4% %p5% _FSMAK~1%p6%       _FSMAK~1%p7%
%1 %2 %p3% %p4% %p5% _FSMC~1%p6%        _FSMC~1%p7%
%1 %2 %p3% %p4% %p5% _FSMH~1%p6%        _FSMH~1%p7%
%1 %2 %p3% %p4% %p5% _FSMMA~1%p6%       _FSMMA~1%p7%
%1 %2 %p3% %p4% %p5% _FSRO~1%p6%        _FSRO~1%p7%
%1 %2 %p3% %p4% %p5% _FSX_C~1%p6%       _FSX_C~1%p7%
%1 %2 %p3% %p4% %p5% _FSX_N~1%p6%       _FSX_N~1%p7%
%1 %2 %p3% %p4% %p5% _FSX_S~1%p6%       _FSX_S~1%p7%
%1 %2 %p3% %p4% %p5% _FSX_V~1%p6%       _FSX_V~1%p7%
%1 %2 %p3% %p4% %p5% _FSXC~1%p6%        _FSXC~1%p7%
%1 %2 %p3% %p4% %p5% _FSXH~1%p6%        _FSXH~1%p7%
%1 %2 %p3% %p4% %p5% _FSXMA~1%p6%       _FSXMA~1%p7%
%1 %2 %p3% %p4% %p5% _HUTTL~1%p6%       _HUTTL~1%p7%
%1 %2 %p3% %p4% %p5% _I_BOX~1%p6%       _I_BOX~1%p7%
%1 %2 %p3% %p4% %p5% _I_CLO~1%p6%       _I_CLO~1%p7%
%1 %2 %p3% %p4% %p5% _I_DIA~1%p6%       _I_DIA~1%p7%
%1 %2 %p3% %p4% %p5% _I_GET~1%p6%       _I_GET~1%p7%
%1 %2 %p3% %p4% %p5% _I_ICO~1%p6%       _I_ICO~1%p7%
%1 %2 %p3% %p4% %p5% _I_INI~1%p6%       _I_INI~1%p7%
%1 %2 %p3% %p4% %p5% _I_LIS~1%p6%       _I_LIS~1%p7%
%1 %2 %p3% %p4% %p5% _I_PBM~1%p6%       _I_PBM~1%p7%
%1 %2 %p3% %p4% %p5% _I_RBA~1%p6%       _I_RBA~1%p7%
%1 %2 %p3% %p4% %p5% _I_TES~1%p6%       _I_TES~1%p7%
%1 %2 %p3% %p4% %p5% _I_TES~2%p6%       _I_TES~2%p7%
%1 %2 %p3% %p4% %p5% _I_TEX~1%p6%       _I_TEX~1%p7%
%1 %2 %p3% %p4% %p5% _I_TWC~1%p6%       _I_TWC~1%p7%
%1 %2 %p3% %p4% %p5% _IDOC~1%p6%        _IDOC~1%p7%
%1 %2 %p3% %p4% %p5% _IGHTP~1%p6%       _IGHTP~1%p7%
%1 %2 %p3% %p4% %p5% _IH~1%p6%          _IH~1%p7%
%1 %2 %p3% %p4% %p5% _ILESY~1%p6%       _ILESY~1%p7%
%1 %2 %p3% %p4% %p5% _ISTAN~1%p6%       _ISTAN~1%p7%
%1 %2 %p3% %p4% %p5% _ITEST~1%p6%       _ITEST~1%p7%
%1 %2 %p3% %p4% %p5% _LANKP~1%p6%       _LANKP~1%p7%
%1 %2 %p3% %p4% %p5% _LEANL~1%p6%       _LEANL~1%p7%
%1 %2 %p3% %p4% %p5% _LEANL~2%p6%       _LEANL~2%p7%
%1 %2 %p3% %p4% %p5% _LEANS~1%p6%       _LEANS~1%p7%
%1 %2 %p3% %p4% %p5% _LEANS~2%p6%       _LEANS~2%p7%
%1 %2 %p3% %p4% %p5% _LEVAT~1%p6%       _LEVAT~1%p7%
%1 %2 %p3% %p4% %p5% _LOPPY~1%p6%       _LOPPY~1%p7%
%1 %2 %p3% %p4% %p5% _LOSEP~1%p6%       _LOSEP~1%p7%
%1 %2 %p3% %p4% %p5% _LUTOF~1%p6%       _LUTOF~1%p7%
%1 %2 %p3% %p4% %p5% _MAC_M~1%p6%       _MAC_M~1%p7%
%1 %2 %p3% %p4% %p5% _MACM~1%p6%        _MACM~1%p7%
%1 %2 %p3% %p4% %p5% _MALLF~1%p6%       _MALLF~1%p7%
%1 %2 %p3% %p4% %p5% _MALLG~1%p6%       _MALLG~1%p7%
%1 %2 %p3% %p4% %p5% _NCLIN~1%p6%       _NCLIN~1%p7%
%1 %2 %p3% %p4% %p5% _NSITA~1%p6%       _NSITA~1%p7%
%1 %2 %p3% %p4% %p5% _O_DIV~1%p6%       _O_DIV~1%p7%
%1 %2 %p3% %p4% %p5% _O_MAC~1%p6%       _O_MAC~1%p7%
%1 %2 %p3% %p4% %p5% _O_OUT~1%p6%       _O_OUT~1%p7%
%1 %2 %p3% %p4% %p5% _O_POS~1%p6%       _O_POS~1%p7%
%1 %2 %p3% %p4% %p5% _O_PRO~1%p6%       _O_PRO~1%p7%
%1 %2 %p3% %p4% %p5% _O_SET~1%p6%       _O_SET~1%p7%
%1 %2 %p3% %p4% %p5% _O_TEX~1%p6%       _O_TEX~1%p7%
%1 %2 %p3% %p4% %p5% _O_VAR~1%p6%       _O_VAR~1%p7%
%1 %2 %p3% %p4% %p5% _O_WOR~1%p6%       _O_WOR~1%p7%
%1 %2 %p3% %p4% %p5% _OC~1%p6%          _OC~1%p7%
%1 %2 %p3% %p4% %p5% _ODOC~1%p6%        _ODOC~1%p7%
%1 %2 %p3% %p4% %p5% _OEXE~1%p6%        _OEXE~1%p7%
%1 %2 %p3% %p4% %p5% _OH~1%p6%          _OH~1%p7%
%1 %2 %p3% %p4% %p5% _OLDER~1%p6%       _OLDER~1%p7%
%1 %2 %p3% %p4% %p5% _OMAK~1%p6%        _OMAK~1%p7%
%1 %2 %p3% %p4% %p5% _OMPLE~1%p6%       _OMPLE~1%p7%
%1 %2 %p3% %p4% %p5% _OONFD~1%p6%       _OONFD~1%p7%
%1 %2 %p3% %p4% %p5% _OONSF~1%p6%       _OONSF~1%p7%
%1 %2 %p3% %p4% %p5% _OQRF~1%p6%        _OQRF~1%p7%
%1 %2 %p3% %p4% %p5% _OVEPB~1%p6%       _OVEPB~1%p7%
%1 %2 %p3% %p4% %p5% _OWNPB~1%p6%       _OWNPB~1%p7%
%1 %2 %p3% %p4% %p5% _PPBM~1%p6%        _PPBM~1%p7%
%1 %2 %p3% %p4% %p5% _R_DEF~1%p6%       _R_DEF~1%p7%
%1 %2 %p3% %p4% %p5% _R_IBM~1%p6%       _R_IBM~1%p7%
%1 %2 %p3% %p4% %p5% _R_MGR~1%p6%       _R_MGR~1%p7%
%1 %2 %p3% %p4% %p5% _R_SPE~1%p6%       _R_SPE~1%p7%
%1 %2 %p3% %p4% %p5% _R_SYS~1%p6%       _R_SYS~1%p7%
%1 %2 %p3% %p4% %p5% _R_TAM~1%p6%       _R_TAM~1%p7%
%1 %2 %p3% %p4% %p5% _R_TES~1%p6%       _R_TES~1%p7%
%1 %2 %p3% %p4% %p5% _R_TES~2%p6%       _R_TES~2%p7%
%1 %2 %p3% %p4% %p5% _R_UNI~1%p6%       _R_UNI~1%p7%
%1 %2 %p3% %p4% %p5% _R_XC~1%p6%        _R_XC~1%p7%
%1 %2 %p3% %p4% %p5% _RANUS~1%p6%       _RANUS~1%p7%
%1 %2 %p3% %p4% %p5% _RBSPD~1%p6%       _RBSPD~1%p7%
%1 %2 %p3% %p4% %p5% _RFBAT~1%p6%       _RFBAT~1%p7%
%1 %2 %p3% %p4% %p5% _RH~1%p6%          _RH~1%p7%
%1 %2 %p3% %p4% %p5% _S_FOC~1%p6%       _S_FOC~1%p7%
%1 %2 %p3% %p4% %p5% _S_ORB~1%p6%       _S_ORB~1%p7%
%1 %2 %p3% %p4% %p5% _S_SPJ~1%p6%       _S_SPJ~1%p7%
%1 %2 %p3% %p4% %p5% _S_TES~1%p6%       _S_TES~1%p7%
%1 %2 %p3% %p4% %p5% _S_TES~2%p6%       _S_TES~2%p7%
%1 %2 %p3% %p4% %p5% _S_VPT~1%p6%       _S_VPT~1%p7%
%1 %2 %p3% %p4% %p5% _SH~1%p6%          _SH~1%p7%
%1 %2 %p3% %p4% %p5% _UBBLE~1%p6%       _UBBLE~1%p7%
%1 %2 %p3% %p4% %p5% _UICKS~1%p6%       _UICKS~1%p7%
%1 %2 %p3% %p4% %p5% _UILDL~1%p6%       _UILDL~1%p7%
%1 %2 %p3% %p4% %p5% _UILDL~2%p6%       _UILDL~2%p7%
%1 %2 %p3% %p4% %p5% _UILDS~1%p6%       _UILDS~1%p7%
%1 %2 %p3% %p4% %p5% _UILDS~2%p6%       _UILDS~2%p7%
%1 %2 %p3% %p4% %p5% _ULLSP~1%p6%       _ULLSP~1%p7%
%1 %2 %p3% %p4% %p5% _ULLTA~1%p6%       _ULLTA~1%p7%
%1 %2 %p3% %p4% %p5% _UNFD~1%p6%        _UNFD~1%p7%
%1 %2 %p3% %p4% %p5% _UPITE~1%p6%       _UPITE~1%p7%
%1 %2 %p3% %p4% %p5% _W_CPY~1%p6%       _W_CPY~1%p7%
%1 %2 %p3% %p4% %p5% _W_IBM~1%p6%       _W_IBM~1%p7%
%1 %2 %p3% %p4% %p5% _WH~1%p6%          _WH~1%p7%
%1 %2 %p3% %p4% %p5% _X10TA~1%p6%       _X10TA~1%p7%
%1 %2 %p3% %p4% %p5% _XECPB~1%p6%       _XECPB~1%p7%
%1 %2 %p3% %p4% %p5% _YNAPS~1%p6%       _YNAPS~1%p7%
%1 %2 %p3% %p4% %p5% _YWATE~1%p6%       _YWATE~1%p7%
%1 %2 %p3% %p4% %p5% 3DMWEX~1%p6%       3DMWEX~1%p7%
%1 %2 %p3% %p4% %p5% 3STARD~1%p6%       3STARD~1%p7%
%1 %2 %p3% %p4% %p5% 3STARE~1%p6%       3STARE~1%p7%
%1 %2 %p3% %p4% %p5% 3START~1%p6%       3START~1%p7%
%1 %2 %p3% %p4% %p5% 4179EL~1%p6%       4179EL~1%p7%
%1 %2 %p3% %p4% %p5% 96OH-1~1%p6%       96OH-1~1%p7%
%1 %2 %p3% %p4% %p5% 96OH-2~1%p6%       96OH-2~1%p7%
%1 %2 %p3% %p4% %p5% 96OHEL~1%p6%       96OHEL~1%p7%
%1 %2 %p3% %p4% %p5% AA_HAD~1%p6%       AA_HAD~1%p7%
%1 %2 %p3% %p4% %p5% AA_QUE~1%p6%       AA_QUE~1%p7%
%1 %2 %p3% %p4% %p5% AA102I~1%p6%       AA102I~1%p7%
%1 %2 %p3% %p4% %p5% AA118I~1%p6%       AA118I~1%p7%
%1 %2 %p3% %p4% %p5% AA200A~1%p6%       AA200A~1%p7%
%1 %2 %p3% %p4% %p5% AA200B~1%p6%       AA200B~1%p7%
%1 %2 %p3% %p4% %p5% AA200C~1%p6%       AA200C~1%p7%
%1 %2 %p3% %p4% %p5% AA200D~1%p6%       AA200D~1%p7%
%1 %2 %p3% %p4% %p5% AA200E~1%p6%       AA200E~1%p7%
%1 %2 %p3% %p4% %p5% AA200I~1%p6%       AA200I~1%p7%
%1 %2 %p3% %p4% %p5% AA200I~2%p6%       AA200I~2%p7%
%1 %2 %p3% %p4% %p5% AA200M~1%p6%       AA200M~1%p7%
%1 %2 %p3% %p4% %p5% AA200R~1%p6%       AA200R~1%p7%
%1 %2 %p3% %p4% %p5% AA245I~1%p6%       AA245I~1%p7%
%1 %2 %p3% %p4% %p5% AA400I~1%p6%       AA400I~1%p7%
%1 %2 %p3% %p4% %p5% AA403I~1%p6%       AA403I~1%p7%
%1 %2 %p3% %p4% %p5% AA404I~1%p6%       AA404I~1%p7%
%1 %2 %p3% %p4% %p5% AA405I~1%p6%       AA405I~1%p7%
%1 %2 %p3% %p4% %p5% AA406I~1%p6%       AA406I~1%p7%
%1 %2 %p3% %p4% %p5% AAANS~1%p6%        AAANS~1%p7%
%1 %2 %p3% %p4% %p5% AAC~1%p6%          AAC~1%p7%
%1 %2 %p3% %p4% %p5% AAEXE~1%p6%        AAEXE~1%p7%
%1 %2 %p3% %p4% %p5% AAINI~1%p6%        AAINI~1%p7%
%1 %2 %p3% %p4% %p5% AAMAK~1%p6%        AAMAK~1%p7%
%1 %2 %p3% %p4% %p5% AAOPT~1%p6%        AAOPT~1%p7%
%1 %2 %p3% %p4% %p5% AAPRJ~1%p6%        AAPRJ~1%p7%
%1 %2 %p3% %p4% %p5% AAQUE~1%p6%        AAQUE~1%p7%
%1 %2 %p3% %p4% %p5% AARSP~1%p6%        AARSP~1%p7%
%1 %2 %p3% %p4% %p5% ACONST~1%p6%       ACONST~1%p7%
%1 %2 %p3% %p4% %p5% ACONST~2%p6%       ACONST~2%p7%
%1 %2 %p3% %p4% %p5% ACTIVI~1%p6%       ACTIVI~1%p7%
%1 %2 %p3% %p4% %p5% ADAMS4~1%p6%       ADAMS4~1%p7%
%1 %2 %p3% %p4% %p5% ALTAZ_~1%p6%       ALTAZ_~1%p7%
%1 %2 %p3% %p4% %p5% ALTAZC~1%p6%       ALTAZC~1%p7%
%1 %2 %p3% %p4% %p5% ALTMEN~1%p6%       ALTMEN~1%p7%
%1 %2 %p3% %p4% %p5% ANDSTR~1%p6%       ANDSTR~1%p7%
%1 %2 %p3% %p4% %p5% ANGLES~1%p6%       ANGLES~1%p7%
%1 %2 %p3% %p4% %p5% ANGLES~2%p6%       ANGLES~2%p7%
%1 %2 %p3% %p4% %p5% ANNUAB~1%p6%       ANNUAB~1%p7%
%1 %2 %p3% %p4% %p5% ANNUAB~2%p6%       ANNUAB~2%p7%
%1 %2 %p3% %p4% %p5% ANOMAL~1%p6%       ANOMAL~1%p7%
%1 %2 %p3% %p4% %p5% ANSITA~1%p6%       ANSITA~1%p7%
%1 %2 %p3% %p4% %p5% APR199~1%p6%       APR199~1%p7%
%1 %2 %p3% %p4% %p5% AQRSTR~1%p6%       AQRSTR~1%p7%
%1 %2 %p3% %p4% %p5% ARCDOT~1%p6%       ARCDOT~1%p7%
%1 %2 %p3% %p4% %p5% ARCTIC~1%p6%       ARCTIC~1%p7%
%1 %2 %p3% %p4% %p5% ASINLC~1%p6%       ASINLC~1%p7%
%1 %2 %p3% %p4% %p5% ASTAVD~1%p6%       ASTAVD~1%p7%
%1 %2 %p3% %p4% %p5% ASTERB~1%p6%       ASTERB~1%p7%
%1 %2 %p3% %p4% %p5% ASTRO_~1%p6%       ASTRO_~1%p7%
%1 %2 %p3% %p4% %p5% ASTRO_~2%p6%       ASTRO_~2%p7%
%1 %2 %p3% %p4% %p5% ASTROD~1%p6%       ASTROD~1%p7%
%1 %2 %p3% %p4% %p5% ASTROE~1%p6%       ASTROE~1%p7%
%1 %2 %p3% %p4% %p5% ASTROH~1%p6%       ASTROH~1%p7%
%1 %2 %p3% %p4% %p5% ASTROM~1%p6%       ASTROM~1%p7%
%1 %2 %p3% %p4% %p5% ASTROM~2%p6%       ASTROM~2%p7%
%1 %2 %p3% %p4% %p5% ASTROM~3%p6%       ASTROM~3%p7%
%1 %2 %p3% %p4% %p5% ASTROM~4%p6%       ASTROM~4%p7%
%1 %2 %p3% %p4% %p5% ASTRON~1%p6%       ASTRON~1%p7%
%1 %2 %p3% %p4% %p5% ATANLC~1%p6%       ATANLC~1%p7%
%1 %2 %p3% %p4% %p5% ATT_BG~1%p6%       ATT_BG~1%p7%
%1 %2 %p3% %p4% %p5% ATTBGI~1%p6%       ATTBGI~1%p7%
%1 %2 %p3% %p4% %p5% AUG199~1%p6%       AUG199~1%p7%
%1 %2 %p3% %p4% %p5% AURSTR~1%p6%       AURSTR~1%p7%
%1 %2 %p3% %p4% %p5% B_STAR~1%p6%       B_STAR~1%p7%
%1 %2 %p3% %p4% %p5% B_STAR~2%p6%       B_STAR~2%p7%
%1 %2 %p3% %p4% %p5% BACKGR~1%p6%       BACKGR~1%p7%
%1 %2 %p3% %p4% %p5% BGI16D~1%p6%       BGI16D~1%p7%
%1 %2 %p3% %p4% %p5% BINARY~1%p6%       BINARY~1%p7%
%1 %2 %p3% %p4% %p5% BINARY~2%p6%       BINARY~2%p7%
%1 %2 %p3% %p4% %p5% BITIMA~1%p6%       BITIMA~1%p7%
%1 %2 %p3% %p4% %p5% BLANKP~1%p6%       BLANKP~1%p7%
%1 %2 %p3% %p4% %p5% BLUEMO~1%p6%       BLUEMO~1%p7%
%1 %2 %p3% %p4% %p5% BRIGHT~1%p6%       BRIGHT~1%p7%
%1 %2 %p3% %p4% %p5% BRIGHT~2%p6%       BRIGHT~2%p7%
%1 %2 %p3% %p4% %p5% BRNEBU~1%p6%       BRNEBU~1%p7%
%1 %2 %p3% %p4% %p5% BRUNGS~1%p6%       BRUNGS~1%p7%
%1 %2 %p3% %p4% %p5% BRUNGS~2%p6%       BRUNGS~2%p7%
%1 %2 %p3% %p4% %p5% BSCAT~1%p6%        BSCAT~1%p7%
%1 %2 %p3% %p4% %p5% BSINF~1%p6%        BSINF~1%p7%
%1 %2 %p3% %p4% %p5% BYWATE~1%p6%       BYWATE~1%p7%
%1 %2 %p3% %p4% %p5% C95O1-~1%p6%       C95O1-~1%p7%
%1 %2 %p3% %p4% %p5% C95O1-~2%p6%       C95O1-~2%p7%
%1 %2 %p3% %p4% %p5% C95O1E~1%p6%       C95O1E~1%p7%
%1 %2 %p3% %p4% %p5% CAL_MJ~1%p6%       CAL_MJ~1%p7%
%1 %2 %p3% %p4% %p5% CALLIS~1%p6%       CALLIS~1%p7%
%1 %2 %p3% %p4% %p5% CALLIS~2%p6%       CALLIS~2%p7%
%1 %2 %p3% %p4% %p5% CALLIS~3%p6%       CALLIS~3%p7%
%1 %2 %p3% %p4% %p5% CATALO~1%p6%       CATALO~1%p7%
%1 %2 %p3% %p4% %p5% CGA_2B~1%p6%       CGA_2B~1%p7%
%1 %2 %p3% %p4% %p5% CGA_3B~1%p6%       CGA_3B~1%p7%
%1 %2 %p3% %p4% %p5% CGA_7B~1%p6%       CGA_7B~1%p7%
%1 %2 %p3% %p4% %p5% CGA_BG~1%p6%       CGA_BG~1%p7%
%1 %2 %p3% %p4% %p5% CGABGI~1%p6%       CGABGI~1%p7%
%1 %2 %p3% %p4% %p5% CIRCUM~1%p6%       CIRCUM~1%p7%
%1 %2 %p3% %p4% %p5% CIRCUM~2%p6%       CIRCUM~2%p7%
%1 %2 %p3% %p4% %p5% CLOSEP~1%p6%       CLOSEP~1%p7%
%1 %2 %p3% %p4% %p5% CLUSTE~1%p6%       CLUSTE~1%p7%
%1 %2 %p3% %p4% %p5% COLOR0~1%p6%       COLOR0~1%p7%
%1 %2 %p3% %p4% %p5% COLORT~1%p6%       COLORT~1%p7%
%1 %2 %p3% %p4% %p5% COMETC~1%p6%       COMETC~1%p7%
%1 %2 %p3% %p4% %p5% COMETF~1%p6%       COMETF~1%p7%
%1 %2 %p3% %p4% %p5% COMETF~2%p6%       COMETF~2%p7%
%1 %2 %p3% %p4% %p5% COMPIL~1%p6%       COMPIL~1%p7%
%1 %2 %p3% %p4% %p5% COMPLE~1%p6%       COMPLE~1%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG~1%p7%
%1 %2 %p3% %p4% %p5% CONJUN~1%p6%       CONJUN~1%p7%
%1 %2 %p3% %p4% %p5% CONSTE~1%p6%       CONSTE~1%p7%
%1 %2 %p3% %p4% %p5% CONSTE~2%p6%       CONSTE~2%p7%
%1 %2 %p3% %p4% %p5% CONSTE~3%p6%       CONSTE~3%p7%
%1 %2 %p3% %p4% %p5% CONSTH~1%p6%       CONSTH~1%p7%
%1 %2 %p3% %p4% %p5% COPYIN~1%p6%       COPYIN~1%p7%
%1 %2 %p3% %p4% %p5% COSMOS~1%p6%       COSMOS~1%p7%
%1 %2 %p3% %p4% %p5% COSMOS~2%p6%       COSMOS~2%p7%
%1 %2 %p3% %p4% %p5% CPGFXD~1%p6%       CPGFXD~1%p7%
%1 %2 %p3% %p4% %p5% CRLFTX~1%p6%       CRLFTX~1%p7%
%1 %2 %p3% %p4% %p5% CT-VOI~1%p6%       CT-VOI~1%p7%
%1 %2 %p3% %p4% %p5% CWSDPM~1%p6%       CWSDPM~1%p7%
%1 %2 %p3% %p4% %p5% CWSDPM~2%p6%       CWSDPM~2%p7%
%1 %2 %p3% %p4% %p5% CZLNG~1%p6%        CZLNG~1%p7%
%1 %2 %p3% %p4% %p5% DBFMAI~1%p6%       DBFMAI~1%p7%
%1 %2 %p3% %p4% %p5% DCOMAI~1%p6%       DCOMAI~1%p7%
%1 %2 %p3% %p4% %p5% DCVMAI~1%p6%       DCVMAI~1%p7%
%1 %2 %p3% %p4% %p5% DE102H~1%p6%       DE102H~1%p7%
%1 %2 %p3% %p4% %p5% DE118I~1%p6%       DE118I~1%p7%
%1 %2 %p3% %p4% %p5% DE118I~2%p6%       DE118I~2%p7%
%1 %2 %p3% %p4% %p5% DE118I~3%p6%       DE118I~3%p7%
%1 %2 %p3% %p4% %p5% DE118I~4%p6%       DE118I~4%p7%
%1 %2 %p3% %p4% %p5% DE118I~5%p6%       DE118I~5%p7%
%1 %2 %p3% %p4% %p5% DE118S~1%p6%       DE118S~1%p7%
%1 %2 %p3% %p4% %p5% DE200A~1%p6%       DE200A~1%p7%
%1 %2 %p3% %p4% %p5% DE200C~1%p6%       DE200C~1%p7%
%1 %2 %p3% %p4% %p5% DE200H~1%p6%       DE200H~1%p7%
%1 %2 %p3% %p4% %p5% DE200Q~1%p6%       DE200Q~1%p7%
%1 %2 %p3% %p4% %p5% DE200T~1%p6%       DE200T~1%p7%
%1 %2 %p3% %p4% %p5% DE245H~1%p6%       DE245H~1%p7%
%1 %2 %p3% %p4% %p5% DE400H~1%p6%       DE400H~1%p7%
%1 %2 %p3% %p4% %p5% DE403H~1%p6%       DE403H~1%p7%
%1 %2 %p3% %p4% %p5% DE404H~1%p6%       DE404H~1%p7%
%1 %2 %p3% %p4% %p5% DE405H~1%p6%       DE405H~1%p7%
%1 %2 %p3% %p4% %p5% DE406H~1%p6%       DE406H~1%p7%
%1 %2 %p3% %p4% %p5% DEC199~1%p6%       DEC199~1%p7%
%1 %2 %p3% %p4% %p5% DEEPSK~1%p6%       DEEPSK~1%p7%
%1 %2 %p3% %p4% %p5% DEEPSK~2%p6%       DEEPSK~2%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       DEFAUL~1%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~2%p6%       DEFAUL~2%p7%
%1 %2 %p3% %p4% %p5% DEFLAT~1%p6%       DEFLAT~1%p7%
%1 %2 %p3% %p4% %p5% DEFLEC~1%p6%       DEFLEC~1%p7%
%1 %2 %p3% %p4% %p5% DEFLEC~2%p6%       DEFLEC~2%p7%
%1 %2 %p3% %p4% %p5% DELTAT~1%p6%       DELTAT~1%p7%
%1 %2 %p3% %p4% %p5% DEMO0P~1%p6%       DEMO0P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO1P~1%p6%       DEMO1P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO2P~1%p6%       DEMO2P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO3P~1%p6%       DEMO3P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO4P~1%p6%       DEMO4P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO5P~1%p6%       DEMO5P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO6P~1%p6%       DEMO6P~1%p7%
%1 %2 %p3% %p4% %p5% DEMO7P~1%p6%       DEMO7P~1%p7%
%1 %2 %p3% %p4% %p5% DEMOCA~1%p6%       DEMOCA~1%p7%
%1 %2 %p3% %p4% %p5% DEMOPO~1%p6%       DEMOPO~1%p7%
%1 %2 %p3% %p4% %p5% DEQMAI~1%p6%       DEQMAI~1%p7%
%1 %2 %p3% %p4% %p5% DERSET~1%p6%       DERSET~1%p7%
%1 %2 %p3% %p4% %p5% DESCRI~1%p6%       DESCRI~1%p7%
%1 %2 %p3% %p4% %p5% DESCRI~2%p6%       DESCRI~2%p7%
%1 %2 %p3% %p4% %p5% DESKJE~1%p6%       DESKJE~1%p7%
%1 %2 %p3% %p4% %p5% DESURE~1%p6%       DESURE~1%p7%
%1 %2 %p3% %p4% %p5% DEVELO~1%p6%       DEVELO~1%p7%
%1 %2 %p3% %p4% %p5% DIFF_D~1%p6%       DIFF_D~1%p7%
%1 %2 %p3% %p4% %p5% DIFF_D~2%p6%       DIFF_D~2%p7%
%1 %2 %p3% %p4% %p5% DIPDAT~1%p6%       DIPDAT~1%p7%
%1 %2 %p3% %p4% %p5% DISTAN~1%p6%       DISTAN~1%p7%
%1 %2 %p3% %p4% %p5% DITMAI~1%p6%       DITMAI~1%p7%
%1 %2 %p3% %p4% %p5% DIURAB~1%p6%       DIURAB~1%p7%
%1 %2 %p3% %p4% %p5% DIURAB~2%p6%       DIURAB~2%p7%
%1 %2 %p3% %p4% %p5% DIURPX~1%p6%       DIURPX~1%p7%
%1 %2 %p3% %p4% %p5% DIURPX~2%p6%       DIURPX~2%p7%
%1 %2 %p3% %p4% %p5% DKNEBU~1%p6%       DKNEBU~1%p7%
%1 %2 %p3% %p4% %p5% DMFMAI~1%p6%       DMFMAI~1%p7%
%1 %2 %p3% %p4% %p5% DMS_C~1%p6%        DMS_C~1%p7%
%1 %2 %p3% %p4% %p5% DMSC~1%p6%         DMSC~1%p7%
%1 %2 %p3% %p4% %p5% DOMOON~1%p6%       DOMOON~1%p7%
%1 %2 %p3% %p4% %p5% DOWNPB~1%p6%       DOWNPB~1%p7%
%1 %2 %p3% %p4% %p5% DPIMAI~1%p6%       DPIMAI~1%p7%
%1 %2 %p3% %p4% %p5% DPMI16~1%p6%       DPMI16~1%p7%
%1 %2 %p3% %p4% %p5% DPMI16~2%p6%       DPMI16~2%p7%
%1 %2 %p3% %p4% %p5% DSCMAI~1%p6%       DSCMAI~1%p7%
%1 %2 %p3% %p4% %p5% DSDAT~1%p6%        DSDAT~1%p7%
%1 %2 %p3% %p4% %p5% DSPACE~1%p6%       DSPACE~1%p7%
%1 %2 %p3% %p4% %p5% DSPACE~2%p6%       DSPACE~2%p7%
%1 %2 %p3% %p4% %p5% EAR404~1%p6%       EAR404~1%p7%
%1 %2 %p3% %p4% %p5% EARTHB~1%p6%       EARTHB~1%p7%
%1 %2 %p3% %p4% %p5% EARTHB~2%p6%       EARTHB~2%p7%
%1 %2 %p3% %p4% %p5% EARTHF~1%p6%       EARTHF~1%p7%
%1 %2 %p3% %p4% %p5% EARTHS~1%p6%       EARTHS~1%p7%
%1 %2 %p3% %p4% %p5% ECONST~1%p6%       ECONST~1%p7%
%1 %2 %p3% %p4% %p5% EGAVG~10%p6%       EGAVG~10%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~1%p6%       EGAVGA~1%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~2%p6%       EGAVGA~2%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~3%p6%       EGAVGA~3%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~4%p6%       EGAVGA~4%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~5%p6%       EGAVGA~5%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~6%p6%       EGAVGA~6%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~7%p6%       EGAVGA~7%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~8%p6%       EGAVGA~8%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~9%p6%       EGAVGA~9%p7%
%1 %2 %p3% %p4% %p5% EHEADH~1%p6%       EHEADH~1%p7%
%1 %2 %p3% %p4% %p5% ELEMCO~1%p6%       ELEMCO~1%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~1%p6%       ELEVAT~1%p7%
%1 %2 %p3% %p4% %p5% EMAILT~1%p6%       EMAILT~1%p7%
%1 %2 %p3% %p4% %p5% ENGLNG~1%p6%       ENGLNG~1%p7%
%1 %2 %p3% %p4% %p5% EPHEMC~1%p6%       EPHEMC~1%p7%
%1 %2 %p3% %p4% %p5% EPHEMD~1%p6%       EPHEMD~1%p7%
%1 %2 %p3% %p4% %p5% EPHEME~1%p6%       EPHEME~1%p7%
%1 %2 %p3% %p4% %p5% EPSILN~1%p6%       EPSILN~1%p7%
%1 %2 %p3% %p4% %p5% EPSILN~2%p6%       EPSILN~2%p7%
%1 %2 %p3% %p4% %p5% EPSILN~3%p6%       EPSILN~3%p7%
%1 %2 %p3% %p4% %p5% EQ_ECL~1%p6%       EQ_ECL~1%p7%
%1 %2 %p3% %p4% %p5% ETODEC~1%p6%       ETODEC~1%p7%
%1 %2 %p3% %p4% %p5% EXECPB~1%p6%       EXECPB~1%p7%
%1 %2 %p3% %p4% %p5% EXPWTD~1%p6%       EXPWTD~1%p7%
%1 %2 %p3% %p4% %p5% EXPWTE~1%p6%       EXPWTE~1%p7%
%1 %2 %p3% %p4% %p5% FAILUR~1%p6%       FAILUR~1%p7%
%1 %2 %p3% %p4% %p5% FASTDA~1%p6%       FASTDA~1%p7%
%1 %2 %p3% %p4% %p5% FAXTXT~1%p6%       FAXTXT~1%p7%
%1 %2 %p3% %p4% %p5% FEB199~1%p6%       FEB199~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_I~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_I~3%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_I~4%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_I~5%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_I~6%p7%
%1 %2 %p3% %p4% %p5% FILES_~1%p6%       FILES_~1%p7%
%1 %2 %p3% %p4% %p5% FILES_~2%p6%       FILES_~2%p7%
%1 %2 %p3% %p4% %p5% FILESL~1%p6%       FILESL~1%p7%
%1 %2 %p3% %p4% %p5% FILEST~1%p6%       FILEST~1%p7%
%1 %2 %p3% %p4% %p5% FILESY~1%p6%       FILESY~1%p7%
%1 %2 %p3% %p4% %p5% FINDCE~1%p6%       FINDCE~1%p7%
%1 %2 %p3% %p4% %p5% FINDOR~1%p6%       FINDOR~1%p7%
%1 %2 %p3% %p4% %p5% FINDOR~2%p6%       FINDOR~2%p7%
%1 %2 %p3% %p4% %p5% FK4FK5~1%p6%       FK4FK5~1%p7%
%1 %2 %p3% %p4% %p5% FK4FK5~2%p6%       FK4FK5~2%p7%
%1 %2 %p3% %p4% %p5% FLOGC~1%p6%        FLOGC~1%p7%
%1 %2 %p3% %p4% %p5% FLOORL~1%p6%       FLOORL~1%p7%
%1 %2 %p3% %p4% %p5% FLOORL~2%p6%       FLOORL~2%p7%
%1 %2 %p3% %p4% %p5% FLOORL~3%p6%       FLOORL~3%p7%
%1 %2 %p3% %p4% %p5% FLOPPY~1%p6%       FLOPPY~1%p7%
%1 %2 %p3% %p4% %p5% FOLDER~1%p6%       FOLDER~1%p7%
%1 %2 %p3% %p4% %p5% FONTCH~1%p6%       FONTCH~1%p7%
%1 %2 %p3% %p4% %p5% FORMAT~1%p6%       FORMAT~1%p7%
%1 %2 %p3% %p4% %p5% G12_NU~1%p6%       G12_NU~1%p7%
%1 %2 %p3% %p4% %p5% G12_NU~2%p6%       G12_NU~2%p7%
%1 %2 %p3% %p4% %p5% GALAXY~1%p6%       GALAXY~1%p7%
%1 %2 %p3% %p4% %p5% GALILE~1%p6%       GALILE~1%p7%
%1 %2 %p3% %p4% %p5% GALILE~2%p6%       GALILE~2%p7%
%1 %2 %p3% %p4% %p5% GALSAT~1%p6%       GALSAT~1%p7%
%1 %2 %p3% %p4% %p5% GALSAT~2%p6%       GALSAT~2%p7%
%1 %2 %p3% %p4% %p5% GALSAT~3%p6%       GALSAT~3%p7%
%1 %2 %p3% %p4% %p5% GALSAT~4%p6%       GALSAT~4%p7%
%1 %2 %p3% %p4% %p5% GALSAT~5%p6%       GALSAT~5%p7%
%1 %2 %p3% %p4% %p5% GARBAG~1%p6%       GARBAG~1%p7%
%1 %2 %p3% %p4% %p5% GEMSTR~1%p6%       GEMSTR~1%p7%
%1 %2 %p3% %p4% %p5% GENREX~1%p6%       GENREX~1%p7%
%1 %2 %p3% %p4% %p5% GFEMER~1%p6%       GFEMER~1%p7%
%1 %2 %p3% %p4% %p5% GIOCTR~1%p6%       GIOCTR~1%p7%
%1 %2 %p3% %p4% %p5% GIOERT~1%p6%       GIOERT~1%p7%
%1 %2 %p3% %p4% %p5% GIOPES~1%p6%       GIOPES~1%p7%
%1 %2 %p3% %p4% %p5% GIOPLN~1%p6%       GIOPLN~1%p7%
%1 %2 %p3% %p4% %p5% GIOSPC~1%p6%       GIOSPC~1%p7%
%1 %2 %p3% %p4% %p5% GL_ARG~1%p6%       GL_ARG~1%p7%
%1 %2 %p3% %p4% %p5% GL_ARG~2%p6%       GL_ARG~2%p7%
%1 %2 %p3% %p4% %p5% GL_GFX~1%p6%       GL_GFX~1%p7%
%1 %2 %p3% %p4% %p5% GL_GFX~2%p6%       GL_GFX~2%p7%
%1 %2 %p3% %p4% %p5% GL_INT~1%p6%       GL_INT~1%p7%
%1 %2 %p3% %p4% %p5% GL_INT~2%p6%       GL_INT~2%p7%
%1 %2 %p3% %p4% %p5% GLC~1%p6%          GLC~1%p7%
%1 %2 %p3% %p4% %p5% GLH~1%p6%          GLH~1%p7%
%1 %2 %p3% %p4% %p5% GLOBUL~1%p6%       GLOBUL~1%p7%
%1 %2 %p3% %p4% %p5% GLOBUL~2%p6%       GLOBUL~2%p7%
%1 %2 %p3% %p4% %p5% GOBAT~1%p6%        GOBAT~1%p7%
%1 %2 %p3% %p4% %p5% GPLANC~1%p6%       GPLANC~1%p7%
%1 %2 %p3% %p4% %p5% GRAPHI~1%p6%       GRAPHI~1%p7%
%1 %2 %p3% %p4% %p5% GRAPHI~2%p6%       GRAPHI~2%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~1%p6%       GRAVIT~1%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~2%p6%       GRAVIT~2%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~3%p6%       GRAVIT~3%p7%
%1 %2 %p3% %p4% %p5% GRAVKI~1%p6%       GRAVKI~1%p7%
%1 %2 %p3% %p4% %p5% GRAVKI~2%p6%       GRAVKI~2%p7%
%1 %2 %p3% %p4% %p5% GTEXE~1%p6%        GTEXE~1%p7%
%1 %2 %p3% %p4% %p5% HEATDO~1%p6%       HEATDO~1%p7%
%1 %2 %p3% %p4% %p5% HEATDO~2%p6%       HEATDO~2%p7%
%1 %2 %p3% %p4% %p5% HEATDO~3%p6%       HEATDO~3%p7%
%1 %2 %p3% %p4% %p5% HEATF~1%p6%        HEATF~1%p7%
%1 %2 %p3% %p4% %p5% HELP_2~1%p6%       HELP_2~1%p7%
%1 %2 %p3% %p4% %p5% HELP_T~1%p6%       HELP_T~1%p7%
%1 %2 %p3% %p4% %p5% HELPTX~1%p6%       HELPTX~1%p7%
%1 %2 %p3% %p4% %p5% HERC_2~1%p6%       HERC_2~1%p7%
%1 %2 %p3% %p4% %p5% HERC_3~1%p6%       HERC_3~1%p7%
%1 %2 %p3% %p4% %p5% HERC_7~1%p6%       HERC_7~1%p7%
%1 %2 %p3% %p4% %p5% HERC_B~1%p6%       HERC_B~1%p7%
%1 %2 %p3% %p4% %p5% HERCBG~1%p6%       HERCBG~1%p7%
%1 %2 %p3% %p4% %p5% HGXMOU~1%p6%       HGXMOU~1%p7%
%1 %2 %p3% %p4% %p5% HGXMOU~2%p6%       HGXMOU~2%p7%
%1 %2 %p3% %p4% %p5% HLP190~1%p6%       HLP190~1%p7%
%1 %2 %p3% %p4% %p5% HLPALG~1%p6%       HLPALG~1%p7%
%1 %2 %p3% %p4% %p5% HLPALI~1%p6%       HLPALI~1%p7%
%1 %2 %p3% %p4% %p5% HLPANG~1%p6%       HLPANG~1%p7%
%1 %2 %p3% %p4% %p5% HLPAVE~1%p6%       HLPAVE~1%p7%
%1 %2 %p3% %p4% %p5% HLPBLI~1%p6%       HLPBLI~1%p7%
%1 %2 %p3% %p4% %p5% HLPBLU~1%p6%       HLPBLU~1%p7%
%1 %2 %p3% %p4% %p5% HLPBMA~1%p6%       HLPBMA~1%p7%
%1 %2 %p3% %p4% %p5% HLPBOX~1%p6%       HLPBOX~1%p7%
%1 %2 %p3% %p4% %p5% HLPBUF~1%p6%       HLPBUF~1%p7%
%1 %2 %p3% %p4% %p5% HLPCAL~1%p6%       HLPCAL~1%p7%
%1 %2 %p3% %p4% %p5% HLPCFG~1%p6%       HLPCFG~1%p7%
%1 %2 %p3% %p4% %p5% HLPCOP~1%p6%       HLPCOP~1%p7%
%1 %2 %p3% %p4% %p5% HLPCRI~1%p6%       HLPCRI~1%p7%
%1 %2 %p3% %p4% %p5% HLPCRO~1%p6%       HLPCRO~1%p7%
%1 %2 %p3% %p4% %p5% HLPDAR~1%p6%       HLPDAR~1%p7%
%1 %2 %p3% %p4% %p5% HLPDEC~1%p6%       HLPDEC~1%p7%
%1 %2 %p3% %p4% %p5% HLPDMA~1%p6%       HLPDMA~1%p7%
%1 %2 %p3% %p4% %p5% HLPENL~1%p6%       HLPENL~1%p7%
%1 %2 %p3% %p4% %p5% HLPEQU~1%p6%       HLPEQU~1%p7%
%1 %2 %p3% %p4% %p5% HLPEXA~1%p6%       HLPEXA~1%p7%
%1 %2 %p3% %p4% %p5% HLPEXP~1%p6%       HLPEXP~1%p7%
%1 %2 %p3% %p4% %p5% HLPFIL~1%p6%       HLPFIL~1%p7%
%1 %2 %p3% %p4% %p5% HLPFIL~2%p6%       HLPFIL~2%p7%
%1 %2 %p3% %p4% %p5% HLPFIT~1%p6%       HLPFIT~1%p7%
%1 %2 %p3% %p4% %p5% HLPFLA~1%p6%       HLPFLA~1%p7%
%1 %2 %p3% %p4% %p5% HLPFLI~1%p6%       HLPFLI~1%p7%
%1 %2 %p3% %p4% %p5% HLPGIF~1%p6%       HLPGIF~1%p7%
%1 %2 %p3% %p4% %p5% HLPGSC~1%p6%       HLPGSC~1%p7%
%1 %2 %p3% %p4% %p5% HLPHEA~1%p6%       HLPHEA~1%p7%
%1 %2 %p3% %p4% %p5% HLPHIS~1%p6%       HLPHIS~1%p7%
%1 %2 %p3% %p4% %p5% HLPHOT~1%p6%       HLPHOT~1%p7%
%1 %2 %p3% %p4% %p5% HLPINV~1%p6%       HLPINV~1%p7%
%1 %2 %p3% %p4% %p5% HLPLOA~1%p6%       HLPLOA~1%p7%
%1 %2 %p3% %p4% %p5% HLPLOG~1%p6%       HLPLOG~1%p7%
%1 %2 %p3% %p4% %p5% HLPMAT~1%p6%       HLPMAT~1%p7%
%1 %2 %p3% %p4% %p5% HLPMED~1%p6%       HLPMED~1%p7%
%1 %2 %p3% %p4% %p5% HLPMER~1%p6%       HLPMER~1%p7%
%1 %2 %p3% %p4% %p5% HLPPRE~1%p6%       HLPPRE~1%p7%
%1 %2 %p3% %p4% %p5% HLPPRO~1%p6%       HLPPRO~1%p7%
%1 %2 %p3% %p4% %p5% HLPREC~1%p6%       HLPREC~1%p7%
%1 %2 %p3% %p4% %p5% HLPRED~1%p6%       HLPRED~1%p7%
%1 %2 %p3% %p4% %p5% HLPRES~1%p6%       HLPRES~1%p7%
%1 %2 %p3% %p4% %p5% HLPROT~1%p6%       HLPROT~1%p7%
%1 %2 %p3% %p4% %p5% HLPSAV~1%p6%       HLPSAV~1%p7%
%1 %2 %p3% %p4% %p5% HLPSAW~1%p6%       HLPSAW~1%p7%
%1 %2 %p3% %p4% %p5% HLPSAW~2%p6%       HLPSAW~2%p7%
%1 %2 %p3% %p4% %p5% HLPSCA~1%p6%       HLPSCA~1%p7%
%1 %2 %p3% %p4% %p5% HLPSHA~1%p6%       HLPSHA~1%p7%
%1 %2 %p3% %p4% %p5% HLPSQP~1%p6%       HLPSQP~1%p7%
%1 %2 %p3% %p4% %p5% HLPSTR~1%p6%       HLPSTR~1%p7%
%1 %2 %p3% %p4% %p5% HLPSUM~1%p6%       HLPSUM~1%p7%
%1 %2 %p3% %p4% %p5% HLPTAB~1%p6%       HLPTAB~1%p7%
%1 %2 %p3% %p4% %p5% HLPTHR~1%p6%       HLPTHR~1%p7%
%1 %2 %p3% %p4% %p5% HLPTRA~1%p6%       HLPTRA~1%p7%
%1 %2 %p3% %p4% %p5% HLPUSH~1%p6%       HLPUSH~1%p7%
%1 %2 %p3% %p4% %p5% HLPVBU~1%p6%       HLPVBU~1%p7%
%1 %2 %p3% %p4% %p5% HLPVID~1%p6%       HLPVID~1%p7%
%1 %2 %p3% %p4% %p5% HLPVIE~1%p6%       HLPVIE~1%p7%
%1 %2 %p3% %p4% %p5% HLPXMS~1%p6%       HLPXMS~1%p7%
%1 %2 %p3% %p4% %p5% HO211_~1%p6%       HO211_~1%p7%
%1 %2 %p3% %p4% %p5% HO211A~1%p6%       HO211A~1%p7%
%1 %2 %p3% %p4% %p5% HO211C~1%p6%       HO211C~1%p7%
%1 %2 %p3% %p4% %p5% HO211E~1%p6%       HO211E~1%p7%
%1 %2 %p3% %p4% %p5% HREXE~1%p6%        HREXE~1%p7%
%1 %2 %p3% %p4% %p5% HUBBLE~1%p6%       HUBBLE~1%p7%
%1 %2 %p3% %p4% %p5% IEEEC~1%p6%        IEEEC~1%p7%
%1 %2 %p3% %p4% %p5% IMAGES~1%p6%       IMAGES~1%p7%
%1 %2 %p3% %p4% %p5% INCLIN~1%p6%       INCLIN~1%p7%
%1 %2 %p3% %p4% %p5% INI118~1%p6%       INI118~1%p7%
%1 %2 %p3% %p4% %p5% INSCEX~1%p6%       INSCEX~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTAL~2%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTAL~3%p7%
%1 %2 %p3% %p4% %p5% INSVEX~1%p6%       INSVEX~1%p7%
%1 %2 %p3% %p4% %p5% INTH~1%p6%         INTH~1%p7%
%1 %2 %p3% %p4% %p5% IOC~1%p6%          IOC~1%p7%
%1 %2 %p3% %p4% %p5% JAN199~1%p6%       JAN199~1%p7%
%1 %2 %p3% %p4% %p5% JIMSDE~1%p6%       JIMSDE~1%p7%
%1 %2 %p3% %p4% %p5% JPLMPC~1%p6%       JPLMPC~1%p7%
%1 %2 %p3% %p4% %p5% JPSTPH~1%p6%       JPSTPH~1%p7%
%1 %2 %p3% %p4% %p5% JPSTPH~2%p6%       JPSTPH~2%p7%
%1 %2 %p3% %p4% %p5% JUL199~1%p6%       JUL199~1%p7%
%1 %2 %p3% %p4% %p5% JUN199~1%p6%       JUN199~1%p7%
%1 %2 %p3% %p4% %p5% JUP404~1%p6%       JUP404~1%p7%
%1 %2 %p3% %p4% %p5% JUPITE~1%p6%       JUPITE~1%p7%
%1 %2 %p3% %p4% %p5% JUPITE~2%p6%       JUPITE~2%p7%
%1 %2 %p3% %p4% %p5% JUPITE~3%p6%       JUPITE~3%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~1%p6%       JUPSAT~1%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~2%p6%       JUPSAT~2%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~3%p6%       JUPSAT~3%p7%
%1 %2 %p3% %p4% %p5% KBIN~1%p6%         KBIN~1%p7%
%1 %2 %p3% %p4% %p5% KDATME~1%p6%       KDATME~1%p7%
%1 %2 %p3% %p4% %p5% KEP_H~1%p6%        KEP_H~1%p7%
%1 %2 %p3% %p4% %p5% KEPH~1%p6%         KEPH~1%p7%
%1 %2 %p3% %p4% %p5% KEPIC~1%p6%        KEPIC~1%p7%
%1 %2 %p3% %p4% %p5% KEPJC~1%p6%        KEPJC~1%p7%
%1 %2 %p3% %p4% %p5% KEPJPL~1%p6%       KEPJPL~1%p7%
%1 %2 %p3% %p4% %p5% KEPLER~1%p6%       KEPLER~1%p7%
%1 %2 %p3% %p4% %p5% KFILES~1%p6%       KFILES~1%p7%
%1 %2 %p3% %p4% %p5% KFILES~2%p6%       KFILES~2%p7%
%1 %2 %p3% %p4% %p5% KOMETD~1%p6%       KOMETD~1%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~1%p6%       KOMSOF~1%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~2%p6%       KOMSOF~2%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~3%p6%       KOMSOF~3%p7%
%1 %2 %p3% %p4% %p5% LATLON~1%p6%       LATLON~1%p7%
%1 %2 %p3% %p4% %p5% LEFTPB~1%p6%       LEFTPB~1%p7%
%1 %2 %p3% %p4% %p5% LEOSTR~1%p6%       LEOSTR~1%p7%
%1 %2 %p3% %p4% %p5% LIB403~1%p6%       LIB403~1%p7%
%1 %2 %p3% %p4% %p5% LIBSTR~1%p6%       LIBSTR~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       LICENS~3%p7%
%1 %2 %p3% %p4% %p5% LIGHTT~1%p6%       LIGHTT~1%p7%
%1 %2 %p3% %p4% %p5% LIGHTT~2%p6%       LIGHTT~2%p7%
%1 %2 %p3% %p4% %p5% LISTIN~1%p6%       LISTIN~1%p7%
%1 %2 %p3% %p4% %p5% LITECH~1%p6%       LITECH~1%p7%
%1 %2 %p3% %p4% %p5% LITT_C~1%p6%       LITT_C~1%p7%
%1 %2 %p3% %p4% %p5% LITTCH~1%p6%       LITTCH~1%p7%
%1 %2 %p3% %p4% %p5% LMDAT~1%p6%        LMDAT~1%p7%
%1 %2 %p3% %p4% %p5% LONLAT~1%p6%       LONLAT~1%p7%
%1 %2 %p3% %p4% %p5% LONLAT~2%p6%       LONLAT~2%p7%
%1 %2 %p3% %p4% %p5% LUNINT~1%p6%       LUNINT~1%p7%
%1 %2 %p3% %p4% %p5% LUNPAR~1%p6%       LUNPAR~1%p7%
%1 %2 %p3% %p4% %p5% M51ST7~1%p6%       M51ST7~1%p7%
%1 %2 %p3% %p4% %p5% MAINC~1%p6%        MAINC~1%p7%
%1 %2 %p3% %p4% %p5% MAINME~1%p6%       MAINME~1%p7%
%1 %2 %p3% %p4% %p5% MAKEFI~1%p6%       MAKEFI~1%p7%
%1 %2 %p3% %p4% %p5% MAKEFI~2%p6%       MAKEFI~2%p7%
%1 %2 %p3% %p4% %p5% MAKEPL~1%p6%       MAKEPL~1%p7%
%1 %2 %p3% %p4% %p5% MAKEPL~2%p6%       MAKEPL~2%p7%
%1 %2 %p3% %p4% %p5% MANIFE~1%p6%       MANIFE~1%p7%
%1 %2 %p3% %p4% %p5% MANIFE~2%p6%       MANIFE~2%p7%
%1 %2 %p3% %p4% %p5% MANTXT~1%p6%       MANTXT~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       MANUAL~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       MANUAL~2%p7%
%1 %2 %p3% %p4% %p5% MAR199~1%p6%       MAR199~1%p7%
%1 %2 %p3% %p4% %p5% MAR404~1%p6%       MAR404~1%p7%
%1 %2 %p3% %p4% %p5% MARSBM~1%p6%       MARSBM~1%p7%
%1 %2 %p3% %p4% %p5% MARSFD~1%p6%       MARSFD~1%p7%
%1 %2 %p3% %p4% %p5% MARSGI~1%p6%       MARSGI~1%p7%
%1 %2 %p3% %p4% %p5% MARSSF~1%p6%       MARSSF~1%p7%
%1 %2 %p3% %p4% %p5% MARSSP~1%p6%       MARSSP~1%p7%
%1 %2 %p3% %p4% %p5% MAY199~1%p6%       MAY199~1%p7%
%1 %2 %p3% %p4% %p5% MBIN~1%p6%         MBIN~1%p7%
%1 %2 %p3% %p4% %p5% MCOLOR~1%p6%       MCOLOR~1%p7%
%1 %2 %p3% %p4% %p5% MCONF_~1%p6%       MCONF_~1%p7%
%1 %2 %p3% %p4% %p5% MCONFH~1%p6%       MCONFH~1%p7%
%1 %2 %p3% %p4% %p5% MER404~1%p6%       MER404~1%p7%
%1 %2 %p3% %p4% %p5% MERCUR~1%p6%       MERCUR~1%p7%
%1 %2 %p3% %p4% %p5% MERCUR~2%p6%       MERCUR~2%p7%
%1 %2 %p3% %p4% %p5% MERCUR~3%p6%       MERCUR~3%p7%
%1 %2 %p3% %p4% %p5% MERIDI~1%p6%       MERIDI~1%p7%
%1 %2 %p3% %p4% %p5% MESSIE~1%p6%       MESSIE~1%p7%
%1 %2 %p3% %p4% %p5% MESSIE~2%p6%       MESSIE~2%p7%
%1 %2 %p3% %p4% %p5% MESSIE~3%p6%       MESSIE~3%p7%
%1 %2 %p3% %p4% %p5% MILKDA~1%p6%       MILKDA~1%p7%
%1 %2 %p3% %p4% %p5% MIRAIN~1%p6%       MIRAIN~1%p7%
%1 %2 %p3% %p4% %p5% MIRAPL~1%p6%       MIRAPL~1%p7%
%1 %2 %p3% %p4% %p5% MISTAK~1%p6%       MISTAK~1%p7%
%1 %2 %p3% %p4% %p5% MLAT40~1%p6%       MLAT40~1%p7%
%1 %2 %p3% %p4% %p5% MLR404~1%p6%       MLR404~1%p7%
%1 %2 %p3% %p4% %p5% MOON2E~1%p6%       MOON2E~1%p7%
%1 %2 %p3% %p4% %p5% MOON7F~1%p6%       MOON7F~1%p7%
%1 %2 %p3% %p4% %p5% MOONBG~1%p6%       MOONBG~1%p7%
%1 %2 %p3% %p4% %p5% MOONBM~1%p6%       MOONBM~1%p7%
%1 %2 %p3% %p4% %p5% MOONC~1%p6%        MOONC~1%p7%
%1 %2 %p3% %p4% %p5% MOONDA~1%p6%       MOONDA~1%p7%
%1 %2 %p3% %p4% %p5% MOONDO~1%p6%       MOONDO~1%p7%
%1 %2 %p3% %p4% %p5% MOONDR~1%p6%       MOONDR~1%p7%
%1 %2 %p3% %p4% %p5% MOONEX~1%p6%       MOONEX~1%p7%
%1 %2 %p3% %p4% %p5% MOONFD~1%p6%       MOONFD~1%p7%
%1 %2 %p3% %p4% %p5% MOONGI~1%p6%       MOONGI~1%p7%
%1 %2 %p3% %p4% %p5% MOONJP~1%p6%       MOONJP~1%p7%
%1 %2 %p3% %p4% %p5% MOONNF~1%p6%       MOONNF~1%p7%
%1 %2 %p3% %p4% %p5% MOONSF~1%p6%       MOONSF~1%p7%
%1 %2 %p3% %p4% %p5% MOONTX~1%p6%       MOONTX~1%p7%
%1 %2 %p3% %p4% %p5% MOVEPB~1%p6%       MOVEPB~1%p7%
%1 %2 %p3% %p4% %p5% MOVIE~10%p6%       MOVIE~10%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~1%p6%       MOVIE0~1%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~2%p6%       MOVIE0~2%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~3%p6%       MOVIE0~3%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~4%p6%       MOVIE0~4%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~5%p6%       MOVIE0~5%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~6%p6%       MOVIE0~6%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~7%p6%       MOVIE0~7%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~8%p6%       MOVIE0~8%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~9%p6%       MOVIE0~9%p7%
%1 %2 %p3% %p4% %p5% MOVIEE~1%p6%       MOVIEE~1%p7%
%1 %2 %p3% %p4% %p5% MSCMAK~1%p6%       MSCMAK~1%p7%
%1 %2 %p3% %p4% %p5% MSCNMA~1%p6%       MSCNMA~1%p7%
%1 %2 %p3% %p4% %p5% MSHERC~1%p6%       MSHERC~1%p7%
%1 %2 %p3% %p4% %p5% MTHERR~1%p6%       MTHERR~1%p7%
%1 %2 %p3% %p4% %p5% NASASP~1%p6%       NASASP~1%p7%
%1 %2 %p3% %p4% %p5% NBODYD~1%p6%       NBODYD~1%p7%
%1 %2 %p3% %p4% %p5% NBODYD~2%p6%       NBODYD~2%p7%
%1 %2 %p3% %p4% %p5% NEP404~1%p6%       NEP404~1%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~1%p6%       NEPTUN~1%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~2%p6%       NEPTUN~2%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~3%p6%       NEPTUN~3%p7%
%1 %2 %p3% %p4% %p5% NEWSFS~1%p6%       NEWSFS~1%p7%
%1 %2 %p3% %p4% %p5% NEWTXT~1%p6%       NEWTXT~1%p7%
%1 %2 %p3% %p4% %p5% NIL_~1%p6%         NIL_~1%p7%
%1 %2 %p3% %p4% %p5% NIL~1%p6%          NIL~1%p7%
%1 %2 %p3% %p4% %p5% NOMDAT~1%p6%       NOMDAT~1%p7%
%1 %2 %p3% %p4% %p5% NOV199~1%p6%       NOV199~1%p7%
%1 %2 %p3% %p4% %p5% NULLSP~1%p6%       NULLSP~1%p7%
%1 %2 %p3% %p4% %p5% NULLTA~1%p6%       NULLTA~1%p7%
%1 %2 %p3% %p4% %p5% NUT1TC~1%p6%       NUT1TC~1%p7%
%1 %2 %p3% %p4% %p5% NUTATE~1%p6%       NUTATE~1%p7%
%1 %2 %p3% %p4% %p5% NUTATE~2%p6%       NUTATE~2%p7%
%1 %2 %p3% %p4% %p5% NUTATI~1%p6%       NUTATI~1%p7%
%1 %2 %p3% %p4% %p5% NX10TA~1%p6%       NX10TA~1%p7%
%1 %2 %p3% %p4% %p5% OBJECT~1%p6%       OBJECT~1%p7%
%1 %2 %p3% %p4% %p5% OBJXC~1%p6%        OBJXC~1%p7%
%1 %2 %p3% %p4% %p5% OBLATE~1%p6%       OBLATE~1%p7%
%1 %2 %p3% %p4% %p5% OBLIQC~1%p6%       OBLIQC~1%p7%
%1 %2 %p3% %p4% %p5% OCHDOC~1%p6%       OCHDOC~1%p7%
%1 %2 %p3% %p4% %p5% OCHEXE~1%p6%       OCHEXE~1%p7%
%1 %2 %p3% %p4% %p5% OCHOBJ~1%p6%       OCHOBJ~1%p7%
%1 %2 %p3% %p4% %p5% OCHPNT~1%p6%       OCHPNT~1%p7%
%1 %2 %p3% %p4% %p5% OCHTXT~1%p6%       OCHTXT~1%p7%
%1 %2 %p3% %p4% %p5% OCT199~1%p6%       OCT199~1%p7%
%1 %2 %p3% %p4% %p5% OPARAM~1%p6%       OPARAM~1%p7%
%1 %2 %p3% %p4% %p5% OPENCL~1%p6%       OPENCL~1%p7%
%1 %2 %p3% %p4% %p5% ORBIT_~1%p6%       ORBIT_~1%p7%
%1 %2 %p3% %p4% %p5% ORBITC~1%p6%       ORBITC~1%p7%
%1 %2 %p3% %p4% %p5% ORBSPD~1%p6%       ORBSPD~1%p7%
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       ORDER_~1%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       ORDERD~1%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERF~1%p7%
%1 %2 %p3% %p4% %p5% ORDERT~1%p6%       ORDERT~1%p7%
%1 %2 %p3% %p4% %p5% ORIDAT~1%p6%       ORIDAT~1%p7%
%1 %2 %p3% %p4% %p5% OVERSE~1%p6%       OVERSE~1%p7%
%1 %2 %p3% %p4% %p5% PANBIN~1%p6%       PANBIN~1%p7%
%1 %2 %p3% %p4% %p5% PARALL~1%p6%       PARALL~1%p7%
%1 %2 %p3% %p4% %p5% PBIN~1%p6%         PBIN~1%p7%
%1 %2 %p3% %p4% %p5% PC3270~1%p6%       PC3270~1%p7%
%1 %2 %p3% %p4% %p5% PC3270~2%p6%       PC3270~2%p7%
%1 %2 %p3% %p4% %p5% PCTOMO~1%p6%       PCTOMO~1%p7%
%1 %2 %p3% %p4% %p5% PELEME~1%p6%       PELEME~1%p7%
%1 %2 %p3% %p4% %p5% PL406B~1%p6%       PL406B~1%p7%
%1 %2 %p3% %p4% %p5% PL406B~2%p6%       PL406B~2%p7%
%1 %2 %p3% %p4% %p5% PLAN19~1%p6%       PLAN19~1%p7%
%1 %2 %p3% %p4% %p5% PLANET~1%p6%       PLANET~1%p7%
%1 %2 %p3% %p4% %p5% PLANET~2%p6%       PLANET~2%p7%
%1 %2 %p3% %p4% %p5% PLANET~3%p6%       PLANET~3%p7%
%1 %2 %p3% %p4% %p5% PLANET~4%p6%       PLANET~4%p7%
%1 %2 %p3% %p4% %p5% PLANET~5%p6%       PLANET~5%p7%
%1 %2 %p3% %p4% %p5% PLANET~6%p6%       PLANET~6%p7%
%1 %2 %p3% %p4% %p5% PLANET~7%p6%       PLANET~7%p7%
%1 %2 %p3% %p4% %p5% PLANET~8%p6%       PLANET~8%p7%
%1 %2 %p3% %p4% %p5% PLANSB~1%p6%       PLANSB~1%p7%
%1 %2 %p3% %p4% %p5% PLANSB~2%p6%       PLANSB~2%p7%
%1 %2 %p3% %p4% %p5% PLANSC~1%p6%       PLANSC~1%p7%
%1 %2 %p3% %p4% %p5% PLANTB~1%p6%       PLANTB~1%p7%
%1 %2 %p3% %p4% %p5% PLNWCH~1%p6%       PLNWCH~1%p7%
%1 %2 %p3% %p4% %p5% PLNWCH~2%p6%       PLNWCH~2%p7%
%1 %2 %p3% %p4% %p5% PLOTAP~1%p6%       PLOTAP~1%p7%
%1 %2 %p3% %p4% %p5% PLOTBP~1%p6%       PLOTBP~1%p7%
%1 %2 %p3% %p4% %p5% PLOTC~1%p6%        PLOTC~1%p7%
%1 %2 %p3% %p4% %p5% PLTRAC~1%p6%       PLTRAC~1%p7%
%1 %2 %p3% %p4% %p5% PLU404~1%p6%       PLU404~1%p7%
%1 %2 %p3% %p4% %p5% PLUTOB~1%p6%       PLUTOB~1%p7%
%1 %2 %p3% %p4% %p5% PLUTOF~1%p6%       PLUTOF~1%p7%
%1 %2 %p3% %p4% %p5% PLUTOG~1%p6%       PLUTOG~1%p7%
%1 %2 %p3% %p4% %p5% POLARI~1%p6%       POLARI~1%p7%
%1 %2 %p3% %p4% %p5% POLEVL~1%p6%       POLEVL~1%p7%
%1 %2 %p3% %p4% %p5% POPUPC~1%p6%       POPUPC~1%p7%
%1 %2 %p3% %p4% %p5% POSTAL~1%p6%       POSTAL~1%p7%
%1 %2 %p3% %p4% %p5% PRECES~1%p6%       PRECES~1%p7%
%1 %2 %p3% %p4% %p5% PRECES~2%p6%       PRECES~2%p7%
%1 %2 %p3% %p4% %p5% PRECES~3%p6%       PRECES~3%p7%
%1 %2 %p3% %p4% %p5% PRECES~4%p6%       PRECES~4%p7%
%1 %2 %p3% %p4% %p5% PRECH~1%p6%        PRECH~1%p7%
%1 %2 %p3% %p4% %p5% PROTOS~1%p6%       PROTOS~1%p7%
%1 %2 %p3% %p4% %p5% PROTOS~2%p6%       PROTOS~2%p7%
%1 %2 %p3% %p4% %p5% PTLINE~1%p6%       PTLINE~1%p7%
%1 %2 %p3% %p4% %p5% PTSTAR~1%p6%       PTSTAR~1%p7%
%1 %2 %p3% %p4% %p5% PURCHA~1%p6%       PURCHA~1%p7%
%1 %2 %p3% %p4% %p5% QUESTI~1%p6%       QUESTI~1%p7%
%1 %2 %p3% %p4% %p5% QUICKS~1%p6%       QUICKS~1%p7%
%1 %2 %p3% %p4% %p5% RDNUMS~1%p6%       RDNUMS~1%p7%
%1 %2 %p3% %p4% %p5% READ_2~1%p6%       READ_2~1%p7%
%1 %2 %p3% %p4% %p5% READ_M~1%p6%       READ_M~1%p7%
%1 %2 %p3% %p4% %p5% READ_M~2%p6%       READ_M~2%p7%
%1 %2 %p3% %p4% %p5% READ_M~3%p6%       READ_M~3%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       READM~10%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       READM~11%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       READM~12%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       READM~13%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       READM~14%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       READM~15%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       READM~16%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       READM~17%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       READM~18%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       READM~19%p7%
%1 %2 %p3% %p4% %p5% READM~20%p6%       READM~20%p7%
%1 %2 %p3% %p4% %p5% READM~21%p6%       READM~21%p7%
%1 %2 %p3% %p4% %p5% READM~22%p6%       READM~22%p7%
%1 %2 %p3% %p4% %p5% READM~23%p6%       READM~23%p7%
%1 %2 %p3% %p4% %p5% READM~24%p6%       READM~24%p7%
%1 %2 %p3% %p4% %p5% READM~25%p6%       READM~25%p7%
%1 %2 %p3% %p4% %p5% READM~26%p6%       READM~26%p7%
%1 %2 %p3% %p4% %p5% READM~27%p6%       READM~27%p7%
%1 %2 %p3% %p4% %p5% READM~28%p6%       READM~28%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README~7%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README~8%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README~9%p7%
%1 %2 %p3% %p4% %p5% READTX~1%p6%       READTX~1%p7%
%1 %2 %p3% %p4% %p5% REDTBL~1%p6%       REDTBL~1%p7%
%1 %2 %p3% %p4% %p5% REDUCE~1%p6%       REDUCE~1%p7%
%1 %2 %p3% %p4% %p5% REFRAC~1%p6%       REFRAC~1%p7%
%1 %2 %p3% %p4% %p5% REFRAC~2%p6%       REFRAC~2%p7%
%1 %2 %p3% %p4% %p5% REFRAC~3%p6%       REFRAC~3%p7%
%1 %2 %p3% %p4% %p5% REFRAC~4%p6%       REFRAC~4%p7%
%1 %2 %p3% %p4% %p5% REGION~1%p6%       REGION~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGIST~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGIST~2%p7%
%1 %2 %p3% %p4% %p5% REGIST~3%p6%       REGIST~3%p7%
%1 %2 %p3% %p4% %p5% REGIST~4%p6%       REGIST~4%p7%
%1 %2 %p3% %p4% %p5% REGIST~5%p6%       REGIST~5%p7%
%1 %2 %p3% %p4% %p5% REGIST~6%p6%       REGIST~6%p7%
%1 %2 %p3% %p4% %p5% REGIST~7%p6%       REGIST~7%p7%
%1 %2 %p3% %p4% %p5% RELTIV~1%p6%       RELTIV~1%p7%
%1 %2 %p3% %p4% %p5% RESIZE~1%p6%       RESIZE~1%p7%
%1 %2 %p3% %p4% %p5% RETROG~1%p6%       RETROG~1%p7%
%1 %2 %p3% %p4% %p5% REVTIM~1%p6%       REVTIM~1%p7%
%1 %2 %p3% %p4% %p5% RIGHTP~1%p6%       RIGHTP~1%p7%
%1 %2 %p3% %p4% %p5% RINGTI~1%p6%       RINGTI~1%p7%
%1 %2 %p3% %p4% %p5% RISET_~1%p6%       RISET_~1%p7%
%1 %2 %p3% %p4% %p5% RISETC~1%p6%       RISETC~1%p7%
%1 %2 %p3% %p4% %p5% RNGCCA~1%p6%       RNGCCA~1%p7%
%1 %2 %p3% %p4% %p5% RNGCIN~1%p6%       RNGCIN~1%p7%
%1 %2 %p3% %p4% %p5% ROEXE~1%p6%        ROEXE~1%p7%
%1 %2 %p3% %p4% %p5% ROTATE~1%p6%       ROTATE~1%p7%
%1 %2 %p3% %p4% %p5% RPLANE~1%p6%       RPLANE~1%p7%
%1 %2 %p3% %p4% %p5% RPLANE~2%p6%       RPLANE~2%p7%
%1 %2 %p3% %p4% %p5% RSTAR_~1%p6%       RSTAR_~1%p7%
%1 %2 %p3% %p4% %p5% RSTARC~1%p6%       RSTARC~1%p7%
%1 %2 %p3% %p4% %p5% RTM_EX~1%p6%       RTM_EX~1%p7%
%1 %2 %p3% %p4% %p5% RTMEXE~1%p6%       RTMEXE~1%p7%
%1 %2 %p3% %p4% %p5% RUNGEC~1%p6%       RUNGEC~1%p7%
%1 %2 %p3% %p4% %p5% SAODAT~1%p6%       SAODAT~1%p7%
%1 %2 %p3% %p4% %p5% SAOIND~1%p6%       SAOIND~1%p7%
%1 %2 %p3% %p4% %p5% SAONOR~1%p6%       SAONOR~1%p7%
%1 %2 %p3% %p4% %p5% SAONOR~2%p6%       SAONOR~2%p7%
%1 %2 %p3% %p4% %p5% SAOSOU~1%p6%       SAOSOU~1%p7%
%1 %2 %p3% %p4% %p5% SAOSOU~2%p6%       SAOSOU~2%p7%
%1 %2 %p3% %p4% %p5% SAT404~1%p6%       SAT404~1%p7%
%1 %2 %p3% %p4% %p5% SATSAT~1%p6%       SATSAT~1%p7%
%1 %2 %p3% %p4% %p5% SATSAT~2%p6%       SATSAT~2%p7%
%1 %2 %p3% %p4% %p5% SATSAT~3%p6%       SATSAT~3%p7%
%1 %2 %p3% %p4% %p5% SATSAT~4%p6%       SATSAT~4%p7%
%1 %2 %p3% %p4% %p5% SATURN~1%p6%       SATURN~1%p7%
%1 %2 %p3% %p4% %p5% SATURN~2%p6%       SATURN~2%p7%
%1 %2 %p3% %p4% %p5% SATURN~3%p6%       SATURN~3%p7%
%1 %2 %p3% %p4% %p5% SATVIE~1%p6%       SATVIE~1%p7%
%1 %2 %p3% %p4% %p5% SATVIE~2%p6%       SATVIE~2%p7%
%1 %2 %p3% %p4% %p5% SCLOCK~1%p6%       SCLOCK~1%p7%
%1 %2 %p3% %p4% %p5% SCLOCK~2%p6%       SCLOCK~2%p7%
%1 %2 %p3% %p4% %p5% SCOPES~1%p6%       SCOPES~1%p7%
%1 %2 %p3% %p4% %p5% SCOPES~2%p6%       SCOPES~2%p7%
%1 %2 %p3% %p4% %p5% SCREEN~1%p6%       SCREEN~1%p7%
%1 %2 %p3% %p4% %p5% SEL_FL~1%p6%       SEL_FL~1%p7%
%1 %2 %p3% %p4% %p5% SEP199~1%p6%       SEP199~1%p7%
%1 %2 %p3% %p4% %p5% SERCON~1%p6%       SERCON~1%p7%
%1 %2 %p3% %p4% %p5% SEREQT~1%p6%       SEREQT~1%p7%
%1 %2 %p3% %p4% %p5% SERIDB~1%p6%       SERIDB~1%p7%
%1 %2 %p3% %p4% %p5% SERIDC~1%p6%       SERIDC~1%p7%
%1 %2 %p3% %p4% %p5% SERIDC~2%p6%       SERIDC~2%p7%
%1 %2 %p3% %p4% %p5% SERIDI~1%p6%       SERIDI~1%p7%
%1 %2 %p3% %p4% %p5% SERIDM~1%p6%       SERIDM~1%p7%
%1 %2 %p3% %p4% %p5% SERIDP~1%p6%       SERIDP~1%p7%
%1 %2 %p3% %p4% %p5% SET3C~1%p6%        SET3C~1%p7%
%1 %2 %p3% %p4% %p5% SETPRE~1%p6%       SETPRE~1%p7%
%1 %2 %p3% %p4% %p5% SETPRE~2%p6%       SETPRE~2%p7%
%1 %2 %p3% %p4% %p5% SETPRE~3%p6%       SETPRE~3%p7%
%1 %2 %p3% %p4% %p5% SETUPM~1%p6%       SETUPM~1%p7%
%1 %2 %p3% %p4% %p5% SEX_DE~1%p6%       SEX_DE~1%p7%
%1 %2 %p3% %p4% %p5% SFSEXE~1%p6%       SFSEXE~1%p7%
%1 %2 %p3% %p4% %p5% SFSMAP~1%p6%       SFSMAP~1%p7%
%1 %2 %p3% %p4% %p5% SFSRO~1%p6%        SFSRO~1%p7%
%1 %2 %p3% %p4% %p5% SFSXAP~1%p6%       SFSXAP~1%p7%
%1 %2 %p3% %p4% %p5% SGRSTR~1%p6%       SGRSTR~1%p7%
%1 %2 %p3% %p4% %p5% SHOWCO~1%p6%       SHOWCO~1%p7%
%1 %2 %p3% %p4% %p5% SHUTTL~1%p6%       SHUTTL~1%p7%
%1 %2 %p3% %p4% %p5% SIDRLT~1%p6%       SIDRLT~1%p7%
%1 %2 %p3% %p4% %p5% SIDRLT~2%p6%       SIDRLT~2%p7%
%1 %2 %p3% %p4% %p5% SIMON-~1%p6%       SIMON-~1%p7%
%1 %2 %p3% %p4% %p5% SIMOND~1%p6%       SIMOND~1%p7%
%1 %2 %p3% %p4% %p5% SIMONE~1%p6%       SIMONE~1%p7%
%1 %2 %p3% %p4% %p5% SINLC~1%p6%        SINLC~1%p7%
%1 %2 %p3% %p4% %p5% SKLNG~1%p6%        SKLNG~1%p7%
%1 %2 %p3% %p4% %p5% SKY3DE~1%p6%       SKY3DE~1%p7%
%1 %2 %p3% %p4% %p5% SKY3DI~1%p6%       SKY3DI~1%p7%
%1 %2 %p3% %p4% %p5% SKY3DV~1%p6%       SKY3DV~1%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~1%p6%       SKYGLO~1%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~2%p6%       SKYGLO~2%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~3%p6%       SKYGLO~3%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~1%p6%       SKYPLO~1%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~2%p6%       SKYPLO~2%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~3%p6%       SKYPLO~3%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~4%p6%       SKYPLO~4%p7%
%1 %2 %p3% %p4% %p5% SMALLG~1%p6%       SMALLG~1%p7%
%1 %2 %p3% %p4% %p5% SOLARD~1%p6%       SOLARD~1%p7%
%1 %2 %p3% %p4% %p5% SOLARE~1%p6%       SOLARE~1%p7%
%1 %2 %p3% %p4% %p5% SOLEX3~1%p6%       SOLEX3~1%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~1%p6%       SOLEX5~1%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~2%p6%       SOLEX5~2%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~3%p6%       SOLEX5~3%p7%
%1 %2 %p3% %p4% %p5% SPEEDU~1%p6%       SPEEDU~1%p7%
%1 %2 %p3% %p4% %p5% SQRTL3~1%p6%       SQRTL3~1%p7%
%1 %2 %p3% %p4% %p5% SQRTLC~1%p6%       SQRTLC~1%p7%
%1 %2 %p3% %p4% %p5% SQRTLS~1%p6%       SQRTLS~1%p7%
%1 %2 %p3% %p4% %p5% SRCHC~1%p6%        SRCHC~1%p7%
%1 %2 %p3% %p4% %p5% SS2TXT~1%p6%       SS2TXT~1%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~1%p6%       SSYSTE~1%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~2%p6%       SSYSTE~2%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~3%p6%       SSYSTE~3%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~4%p6%       SSYSTE~4%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~5%p6%       SSYSTE~5%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~6%p6%       SSYSTE~6%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~7%p6%       SSYSTE~7%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~8%p6%       SSYSTE~8%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~9%p6%       SSYSTE~9%p7%
%1 %2 %p3% %p4% %p5% STAR_C~1%p6%       STAR_C~1%p7%
%1 %2 %p3% %p4% %p5% STAR19~1%p6%       STAR19~1%p7%
%1 %2 %p3% %p4% %p5% STARCA~1%p6%       STARCA~1%p7%
%1 %2 %p3% %p4% %p5% STARDA~1%p6%       STARDA~1%p7%
%1 %2 %p3% %p4% %p5% STARDE~1%p6%       STARDE~1%p7%
%1 %2 %p3% %p4% %p5% STARFI~1%p6%       STARFI~1%p7%
%1 %2 %p3% %p4% %p5% STARFI~2%p6%       STARFI~2%p7%
%1 %2 %p3% %p4% %p5% STARPL~1%p6%       STARPL~1%p7%
%1 %2 %p3% %p4% %p5% STARPL~2%p6%       STARPL~2%p7%
%1 %2 %p3% %p4% %p5% STARPL~3%p6%       STARPL~3%p7%
%1 %2 %p3% %p4% %p5% STARS2~1%p6%       STARS2~1%p7%
%1 %2 %p3% %p4% %p5% STARS3~1%p6%       STARS3~1%p7%
%1 %2 %p3% %p4% %p5% STARS4~1%p6%       STARS4~1%p7%
%1 %2 %p3% %p4% %p5% STARS4~2%p6%       STARS4~2%p7%
%1 %2 %p3% %p4% %p5% STARS5~1%p6%       STARS5~1%p7%
%1 %2 %p3% %p4% %p5% STARSD~1%p6%       STARSD~1%p7%
%1 %2 %p3% %p4% %p5% START_~1%p6%       START_~1%p7%
%1 %2 %p3% %p4% %p5% STARTI~1%p6%       STARTI~1%p7%
%1 %2 %p3% %p4% %p5% STARTT~1%p6%       STARTT~1%p7%
%1 %2 %p3% %p4% %p5% STARVI~1%p6%       STARVI~1%p7%
%1 %2 %p3% %p4% %p5% STARVI~2%p6%       STARVI~2%p7%
%1 %2 %p3% %p4% %p5% STARVI~3%p6%       STARVI~3%p7%
%1 %2 %p3% %p4% %p5% STARVI~4%p6%       STARVI~4%p7%
%1 %2 %p3% %p4% %p5% STARVI~5%p6%       STARVI~5%p7%
%1 %2 %p3% %p4% %p5% STARVI~6%p6%       STARVI~6%p7%
%1 %2 %p3% %p4% %p5% STARVI~7%p6%       STARVI~7%p7%
%1 %2 %p3% %p4% %p5% STARVI~8%p6%       STARVI~8%p7%
%1 %2 %p3% %p4% %p5% STARWO~1%p6%       STARWO~1%p7%
%1 %2 %p3% %p4% %p5% STARWO~2%p6%       STARWO~2%p7%
%1 %2 %p3% %p4% %p5% STAVDA~1%p6%       STAVDA~1%p7%
%1 %2 %p3% %p4% %p5% STELLD~1%p6%       STELLD~1%p7%
%1 %2 %p3% %p4% %p5% STIMEC~1%p6%       STIMEC~1%p7%
%1 %2 %p3% %p4% %p5% STIMEE~1%p6%       STIMEE~1%p7%
%1 %2 %p3% %p4% %p5% STIMET~1%p6%       STIMET~1%p7%
%1 %2 %p3% %p4% %p5% STIMEW~1%p6%       STIMEW~1%p7%
%1 %2 %p3% %p4% %p5% STRINT~1%p6%       STRINT~1%p7%
%1 %2 %p3% %p4% %p5% SUCCES~1%p6%       SUCCES~1%p7%
%1 %2 %p3% %p4% %p5% SUN_2C~1%p6%       SUN_2C~1%p7%
%1 %2 %p3% %p4% %p5% SUN_C~1%p6%        SUN_C~1%p7%
%1 %2 %p3% %p4% %p5% SUNBMP~1%p6%       SUNBMP~1%p7%
%1 %2 %p3% %p4% %p5% SUNC~1%p6%         SUNC~1%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~1%p6%       SUNDEM~1%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~2%p6%       SUNDEM~2%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~3%p6%       SUNDEM~3%p7%
%1 %2 %p3% %p4% %p5% SUNEAR~1%p6%       SUNEAR~1%p7%
%1 %2 %p3% %p4% %p5% SUNFD~1%p6%        SUNFD~1%p7%
%1 %2 %p3% %p4% %p5% SUNHEI~1%p6%       SUNHEI~1%p7%
%1 %2 %p3% %p4% %p5% SUNINT~1%p6%       SUNINT~1%p7%
%1 %2 %p3% %p4% %p5% SUNTAB~1%p6%       SUNTAB~1%p7%
%1 %2 %p3% %p4% %p5% SUNTAB~2%p6%       SUNTAB~2%p7%
%1 %2 %p3% %p4% %p5% SV_ENH~1%p6%       SV_ENH~1%p7%
%1 %2 %p3% %p4% %p5% SV_ITH~1%p6%       SV_ITH~1%p7%
%1 %2 %p3% %p4% %p5% SVCFG~1%p6%        SVCFG~1%p7%
%1 %2 %p3% %p4% %p5% SVCST~1%p6%        SVCST~1%p7%
%1 %2 %p3% %p4% %p5% SVEXE~1%p6%        SVEXE~1%p7%
%1 %2 %p3% %p4% %p5% SVGA16~1%p6%       SVGA16~1%p7%
%1 %2 %p3% %p4% %p5% SVGA25~1%p6%       SVGA25~1%p7%
%1 %2 %p3% %p4% %p5% SVGA25~2%p6%       SVGA25~2%p7%
%1 %2 %p3% %p4% %p5% SVGA25~3%p6%       SVGA25~3%p7%
%1 %2 %p3% %p4% %p5% SVGAS3~1%p6%       SVGAS3~1%p7%
%1 %2 %p3% %p4% %p5% SVGATR~1%p6%       SVGATR~1%p7%
%1 %2 %p3% %p4% %p5% SVMAP~1%p6%        SVMAP~1%p7%
%1 %2 %p3% %p4% %p5% SVPLT~1%p6%        SVPLT~1%p7%
%1 %2 %p3% %p4% %p5% SVSTA~1%p6%        SVSTA~1%p7%
%1 %2 %p3% %p4% %p5% SYNAPS~1%p6%       SYNAPS~1%p7%
%1 %2 %p3% %p4% %p5% TANLC~1%p6%        TANLC~1%p7%
%1 %2 %p3% %p4% %p5% TAUSTR~1%p6%       TAUSTR~1%p7%
%1 %2 %p3% %p4% %p5% TDB_C~1%p6%        TDB_C~1%p7%
%1 %2 %p3% %p4% %p5% TDBC~1%p6%         TDBC~1%p7%
%1 %2 %p3% %p4% %p5% TEDEXE~1%p6%       TEDEXE~1%p7%
%1 %2 %p3% %p4% %p5% TESTBA~1%p6%       TESTBA~1%p7%
%1 %2 %p3% %p4% %p5% TESTDB~1%p6%       TESTDB~1%p7%
%1 %2 %p3% %p4% %p5% TESTLD~1%p6%       TESTLD~1%p7%
%1 %2 %p3% %p4% %p5% TESTLP~1%p6%       TESTLP~1%p7%
%1 %2 %p3% %p4% %p5% TESTPB~1%p6%       TESTPB~1%p7%
%1 %2 %p3% %p4% %p5% TESTPO~1%p6%       TESTPO~1%p7%
%1 %2 %p3% %p4% %p5% TESTQU~1%p6%       TESTQU~1%p7%
%1 %2 %p3% %p4% %p5% TESTSA~1%p6%       TESTSA~1%p7%
%1 %2 %p3% %p4% %p5% TESTSF~1%p6%       TESTSF~1%p7%
%1 %2 %p3% %p4% %p5% TESTVA~1%p6%       TESTVA~1%p7%
%1 %2 %p3% %p4% %p5% THREED~1%p6%       THREED~1%p7%
%1 %2 %p3% %p4% %p5% TIMEC~1%p6%        TIMEC~1%p7%
%1 %2 %p3% %p4% %p5% TIMEZO~1%p6%       TIMEZO~1%p7%
%1 %2 %p3% %p4% %p5% TITLES~1%p6%       TITLES~1%p7%
%1 %2 %p3% %p4% %p5% TMACM~1%p6%        TMACM~1%p7%
%1 %2 %p3% %p4% %p5% TMSRBF~1%p6%       TMSRBF~1%p7%
%1 %2 %p3% %p4% %p5% TRACKE~1%p6%       TRACKE~1%p7%
%1 %2 %p3% %p4% %p5% TRACKE~2%p6%       TRACKE~2%p7%
%1 %2 %p3% %p4% %p5% TRACKE~3%p6%       TRACKE~3%p7%
%1 %2 %p3% %p4% %p5% TRACKE~4%p6%       TRACKE~4%p7%
%1 %2 %p3% %p4% %p5% TRIP_C~1%p6%       TRIP_C~1%p7%
%1 %2 %p3% %p4% %p5% TRIPCH~1%p6%       TRIPCH~1%p7%
%1 %2 %p3% %p4% %p5% TRNSIT~1%p6%       TRNSIT~1%p7%
%1 %2 %p3% %p4% %p5% TRNSIT~2%p6%       TRNSIT~2%p7%
%1 %2 %p3% %p4% %p5% TURBOC~1%p6%       TURBOC~1%p7%
%1 %2 %p3% %p4% %p5% TUTOR~1%p6%        TUTOR~1%p7%
%1 %2 %p3% %p4% %p5% TUTTLE~1%p6%       TUTTLE~1%p7%
%1 %2 %p3% %p4% %p5% UNIV00~1%p6%       UNIV00~1%p7%
%1 %2 %p3% %p4% %p5% UNIXDM~1%p6%       UNIXDM~1%p7%
%1 %2 %p3% %p4% %p5% UNIXLM~1%p6%       UNIXLM~1%p7%
%1 %2 %p3% %p4% %p5% UNIXMA~1%p6%       UNIXMA~1%p7%
%1 %2 %p3% %p4% %p5% UPPBM~1%p6%        UPPBM~1%p7%
%1 %2 %p3% %p4% %p5% URA404~1%p6%       URA404~1%p7%
%1 %2 %p3% %p4% %p5% URANUS~1%p6%       URANUS~1%p7%
%1 %2 %p3% %p4% %p5% URANUS~2%p6%       URANUS~2%p7%
%1 %2 %p3% %p4% %p5% URANUS~3%p6%       URANUS~3%p7%
%1 %2 %p3% %p4% %p5% UTC_GS~1%p6%       UTC_GS~1%p7%
%1 %2 %p3% %p4% %p5% V1JCTR~1%p6%       V1JCTR~1%p7%
%1 %2 %p3% %p4% %p5% V1JERT~1%p6%       V1JERT~1%p7%
%1 %2 %p3% %p4% %p5% V1JPES~1%p6%       V1JPES~1%p7%
%1 %2 %p3% %p4% %p5% V1JPLN~1%p6%       V1JPLN~1%p7%
%1 %2 %p3% %p4% %p5% V1JSAT~1%p6%       V1JSAT~1%p7%
%1 %2 %p3% %p4% %p5% V1JSPC~1%p6%       V1JSPC~1%p7%
%1 %2 %p3% %p4% %p5% V1SCTR~1%p6%       V1SCTR~1%p7%
%1 %2 %p3% %p4% %p5% V1SERT~1%p6%       V1SERT~1%p7%
%1 %2 %p3% %p4% %p5% V1SPES~1%p6%       V1SPES~1%p7%
%1 %2 %p3% %p4% %p5% V1SPLN~1%p6%       V1SPLN~1%p7%
%1 %2 %p3% %p4% %p5% V1SSAT~1%p6%       V1SSAT~1%p7%
%1 %2 %p3% %p4% %p5% V1SSPC~1%p6%       V1SSPC~1%p7%
%1 %2 %p3% %p4% %p5% V2JCTR~1%p6%       V2JCTR~1%p7%
%1 %2 %p3% %p4% %p5% V2JERT~1%p6%       V2JERT~1%p7%
%1 %2 %p3% %p4% %p5% V2JPES~1%p6%       V2JPES~1%p7%
%1 %2 %p3% %p4% %p5% V2JPLN~1%p6%       V2JPLN~1%p7%
%1 %2 %p3% %p4% %p5% V2JSAT~1%p6%       V2JSAT~1%p7%
%1 %2 %p3% %p4% %p5% V2JSPC~1%p6%       V2JSPC~1%p7%
%1 %2 %p3% %p4% %p5% V2NCTR~1%p6%       V2NCTR~1%p7%
%1 %2 %p3% %p4% %p5% V2NERT~1%p6%       V2NERT~1%p7%
%1 %2 %p3% %p4% %p5% V2NPES~1%p6%       V2NPES~1%p7%
%1 %2 %p3% %p4% %p5% V2NPLN~1%p6%       V2NPLN~1%p7%
%1 %2 %p3% %p4% %p5% V2NSAT~1%p6%       V2NSAT~1%p7%
%1 %2 %p3% %p4% %p5% V2NSPC~1%p6%       V2NSPC~1%p7%
%1 %2 %p3% %p4% %p5% V2SCTR~1%p6%       V2SCTR~1%p7%
%1 %2 %p3% %p4% %p5% V2SERT~1%p6%       V2SERT~1%p7%
%1 %2 %p3% %p4% %p5% V2SPES~1%p6%       V2SPES~1%p7%
%1 %2 %p3% %p4% %p5% V2SPLN~1%p6%       V2SPLN~1%p7%
%1 %2 %p3% %p4% %p5% V2SSAT~1%p6%       V2SSAT~1%p7%
%1 %2 %p3% %p4% %p5% V2SSPC~1%p6%       V2SSPC~1%p7%
%1 %2 %p3% %p4% %p5% V2UCTR~1%p6%       V2UCTR~1%p7%
%1 %2 %p3% %p4% %p5% V2UERT~1%p6%       V2UERT~1%p7%
%1 %2 %p3% %p4% %p5% V2UPES~1%p6%       V2UPES~1%p7%
%1 %2 %p3% %p4% %p5% V2UPLN~1%p6%       V2UPLN~1%p7%
%1 %2 %p3% %p4% %p5% V2USAT~1%p6%       V2USAT~1%p7%
%1 %2 %p3% %p4% %p5% V2USPC~1%p6%       V2USPC~1%p7%
%1 %2 %p3% %p4% %p5% VARSTA~1%p6%       VARSTA~1%p7%
%1 %2 %p3% %p4% %p5% VDSDAT~1%p6%       VDSDAT~1%p7%
%1 %2 %p3% %p4% %p5% VEARTH~1%p6%       VEARTH~1%p7%
%1 %2 %p3% %p4% %p5% VEARTH~2%p6%       VEARTH~2%p7%
%1 %2 %p3% %p4% %p5% VEN404~1%p6%       VEN404~1%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDIN~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~2%p6%       VENDOR~2%p7%
%1 %2 %p3% %p4% %p5% VENDOR~3%p6%       VENDOR~3%p7%
%1 %2 %p3% %p4% %p5% VENDOR~4%p6%       VENDOR~4%p7%
%1 %2 %p3% %p4% %p5% VENDOR~5%p6%       VENDOR~5%p7%
%1 %2 %p3% %p4% %p5% VENUSB~1%p6%       VENUSB~1%p7%
%1 %2 %p3% %p4% %p5% VENUSF~1%p6%       VENUSF~1%p7%
%1 %2 %p3% %p4% %p5% VENUSG~1%p6%       VENUSG~1%p7%
%1 %2 %p3% %p4% %p5% VERSIO~1%p6%       VERSIO~1%p7%
%1 %2 %p3% %p4% %p5% VIRSTR~1%p6%       VIRSTR~1%p7%
%1 %2 %p3% %p4% %p5% WATCHC~1%p6%       WATCHC~1%p7%
%1 %2 %p3% %p4% %p5% WHATSN~1%p6%       WHATSN~1%p7%
%1 %2 %p3% %p4% %p5% WMOONB~1%p6%       WMOONB~1%p7%
%1 %2 %p3% %p4% %p5% WMOONB~2%p6%       WMOONB~2%p7%
%1 %2 %p3% %p4% %p5% WMOONB~3%p6%       WMOONB~3%p7%
%1 %2 %p3% %p4% %p5% X200C~1%p6%        X200C~1%p7%
%1 %2 %p3% %p4% %p5% YALEBI~1%p6%       YALEBI~1%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~1%p6%       ZATAN2~1%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~2%p6%       ZATAN2~2%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~3%p6%       ZATAN2~3%p7%
%1 %2 %p3% %p4% %p5% ZEROME~1%p6%       ZEROME~1%p7%

cd %dir2%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST3~1%p7%
%1 %2 %p3% %p4% %p5% _INST3~2%p6%       _INST3~2%p7%
%1 %2 %p3% %p4% %p5% _INST3~3%p6%       _INST3~3%p7%
%1 %2 %p3% %p4% %p5% _INST3~4%p6%       _INST3~4%p7%
%1 %2 %p3% %p4% %p5% _INST3~5%p6%       _INST3~5%p7%
%1 %2 %p3% %p4% %p5% _INST3~6%p6%       _INST3~6%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL~1%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~2%p6%       _ISDEL~2%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~3%p6%       _ISDEL~3%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~4%p6%       _ISDEL~4%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~5%p6%       _ISDEL~5%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~6%p6%       _ISDEL~6%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~1%p6%       _ISRE0~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~2%p6%       _ISRE0~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~1%p6%       _ISRE1~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~2%p6%       _ISRE1~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~1%p6%       _ISRE2~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~1%p6%       _ISRE4~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~2%p6%       _ISRE4~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE7~1%p6%       _ISRE7~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE7~2%p6%       _ISRE7~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE9~1%p6%       _ISRE9~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE9~2%p6%       _ISRE9~2%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS0~1%p6%       _ISUS0~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS1~1%p6%       _ISUS1~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS4~1%p6%       _ISUS4~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS7~1%p6%       _ISUS7~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS9~1%p6%       _ISUS9~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _SETUP~2%p7%
%1 %2 %p3% %p4% %p5% _SETUP~3%p6%       _SETUP~3%p7%
%1 %2 %p3% %p4% %p5% _SETUP~4%p6%       _SETUP~4%p7%
%1 %2 %p3% %p4% %p5% _SETUP~5%p6%       _SETUP~5%p7%
%1 %2 %p3% %p4% %p5% _SETUP~6%p6%       _SETUP~6%p7%
%1 %2 %p3% %p4% %p5% 0202JT~1%p6%       0202JT~1%p7%
%1 %2 %p3% %p4% %p5% 1005NC~1%p6%       1005NC~1%p7%
%1 %2 %p3% %p4% %p5% 2REDOX~1%p6%       2REDOX~1%p7%
%1 %2 %p3% %p4% %p5% 32VLEI~1%p6%       32VLEI~1%p7%
%1 %2 %p3% %p4% %p5% 3RD_4T~1%p6%       3RD_4T~1%p7%
%1 %2 %p3% %p4% %p5% 5THFOR~1%p6%       5THFOR~1%p7%
%1 %2 %p3% %p4% %p5% 6THFOR~1%p6%       6THFOR~1%p7%
%1 %2 %p3% %p4% %p5% 7THFOR~1%p6%       7THFOR~1%p7%
%1 %2 %p3% %p4% %p5% A04109~1%p6%       A04109~1%p7%
%1 %2 %p3% %p4% %p5% A30099~1%p6%       A30099~1%p7%
%1 %2 %p3% %p4% %p5% ABBREV~1%p6%       ABBREV~1%p7%
%1 %2 %p3% %p4% %p5% ABBREV~2%p6%       ABBREV~2%p7%
%1 %2 %p3% %p4% %p5% ABBREV~3%p6%       ABBREV~3%p7%
%1 %2 %p3% %p4% %p5% ACIDBN~1%p6%       ACIDBN~1%p7%
%1 %2 %p3% %p4% %p5% ACMSET~1%p6%       ACMSET~1%p7%
%1 %2 %p3% %p4% %p5% ACMSET~2%p6%       ACMSET~2%p7%
%1 %2 %p3% %p4% %p5% ACTIVE~1%p6%       ACTIVE~1%p7%
%1 %2 %p3% %p4% %p5% ACTIVE~2%p6%       ACTIVE~2%p7%
%1 %2 %p3% %p4% %p5% ADMINC~1%p6%       ADMINC~1%p7%
%1 %2 %p3% %p4% %p5% ADMIND~1%p6%       ADMIND~1%p7%
%1 %2 %p3% %p4% %p5% ADMINH~1%p6%       ADMINH~1%p7%
%1 %2 %p3% %p4% %p5% ADMINR~1%p6%       ADMINR~1%p7%
%1 %2 %p3% %p4% %p5% ADMINR~2%p6%       ADMINR~2%p7%
%1 %2 %p3% %p4% %p5% ADMINR~3%p6%       ADMINR~3%p7%
%1 %2 %p3% %p4% %p5% ADMINR~4%p6%       ADMINR~4%p7%
%1 %2 %p3% %p4% %p5% ALCOHO~1%p6%       ALCOHO~1%p7%
%1 %2 %p3% %p4% %p5% ALDEHY~1%p6%       ALDEHY~1%p7%
%1 %2 %p3% %p4% %p5% ALKANE~1%p6%       ALKANE~1%p7%
%1 %2 %p3% %p4% %p5% ALKENE~1%p6%       ALKENE~1%p7%
%1 %2 %p3% %p4% %p5% ALKYNE~1%p6%       ALKYNE~1%p7%
%1 %2 %p3% %p4% %p5% ALLFIL~1%p6%       ALLFIL~1%p7%
%1 %2 %p3% %p4% %p5% ALLFIL~2%p6%       ALLFIL~2%p7%
%1 %2 %p3% %p4% %p5% ANIHEL~1%p6%       ANIHEL~1%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~1%p6%       ARCHIV~1%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~2%p6%       ARCHIV~2%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~3%p6%       ARCHIV~3%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~4%p6%       ARCHIV~4%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~5%p6%       ARCHIV~5%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~6%p6%       ARCHIV~6%p7%
%1 %2 %p3% %p4% %p5% ASTRON~1%p6%       ASTRON~1%p7%
%1 %2 %p3% %p4% %p5% ASYCFI~1%p6%       ASYCFI~1%p7%
%1 %2 %p3% %p4% %p5% BALANC~1%p6%       BALANC~1%p7%
%1 %2 %p3% %p4% %p5% BDECFG~1%p6%       BDECFG~1%p7%
%1 %2 %p3% %p4% %p5% BDECFG~2%p6%       BDECFG~2%p7%
%1 %2 %p3% %p4% %p5% BDECFG~3%p6%       BDECFG~3%p7%
%1 %2 %p3% %p4% %p5% BHKALC~1%p6%       BHKALC~1%p7%
%1 %2 %p3% %p4% %p5% BLGIF~1%p6%        BLGIF~1%p7%
%1 %2 %p3% %p4% %p5% BLUEDA~1%p6%       BLUEDA~1%p7%
%1 %2 %p3% %p4% %p5% BLW32D~1%p6%       BLW32D~1%p7%
%1 %2 %p3% %p4% %p5% BM0GIF~1%p6%       BM0GIF~1%p7%
%1 %2 %p3% %p4% %p5% BONDIT~1%p6%       BONDIT~1%p7%
%1 %2 %p3% %p4% %p5% BONDIT~2%p6%       BONDIT~2%p7%
%1 %2 %p3% %p4% %p5% BORLND~1%p6%       BORLND~1%p7%
%1 %2 %p3% %p4% %p5% BRUSSE~1%p6%       BRUSSE~1%p7%
%1 %2 %p3% %p4% %p5% BTNADD~1%p6%       BTNADD~1%p7%
%1 %2 %p3% %p4% %p5% BTNCAL~1%p6%       BTNCAL~1%p7%
%1 %2 %p3% %p4% %p5% BTNCOL~1%p6%       BTNCOL~1%p7%
%1 %2 %p3% %p4% %p5% BTNCOP~1%p6%       BTNCOP~1%p7%
%1 %2 %p3% %p4% %p5% BTNERA~1%p6%       BTNERA~1%p7%
%1 %2 %p3% %p4% %p5% BTNEXI~1%p6%       BTNEXI~1%p7%
%1 %2 %p3% %p4% %p5% BTNFIL~1%p6%       BTNFIL~1%p7%
%1 %2 %p3% %p4% %p5% BTNFOR~1%p6%       BTNFOR~1%p7%
%1 %2 %p3% %p4% %p5% BTNGAS~1%p6%       BTNGAS~1%p7%
%1 %2 %p3% %p4% %p5% BTNHAL~1%p6%       BTNHAL~1%p7%
%1 %2 %p3% %p4% %p5% BTNNER~1%p6%       BTNNER~1%p7%
%1 %2 %p3% %p4% %p5% BTNPRT~1%p6%       BTNPRT~1%p7%
%1 %2 %p3% %p4% %p5% BTNPRT~2%p6%       BTNPRT~2%p7%
%1 %2 %p3% %p4% %p5% BTNRAN~1%p6%       BTNRAN~1%p7%
%1 %2 %p3% %p4% %p5% BTNSAV~1%p6%       BTNSAV~1%p7%
%1 %2 %p3% %p4% %p5% BTNSOL~1%p6%       BTNSOL~1%p7%
%1 %2 %p3% %p4% %p5% BTNTAB~1%p6%       BTNTAB~1%p7%
%1 %2 %p3% %p4% %p5% BTNTIP~1%p6%       BTNTIP~1%p7%
%1 %2 %p3% %p4% %p5% C_MDLG~1%p6%       C_MDLG~1%p7%
%1 %2 %p3% %p4% %p5% CASNOI~1%p6%       CASNOI~1%p7%
%1 %2 %p3% %p4% %p5% CATBAC~1%p6%       CATBAC~1%p7%
%1 %2 %p3% %p4% %p5% CATBAC~2%p6%       CATBAC~2%p7%
%1 %2 %p3% %p4% %p5% CATUSE~1%p6%       CATUSE~1%p7%
%1 %2 %p3% %p4% %p5% CATUSE~2%p6%       CATUSE~2%p7%
%1 %2 %p3% %p4% %p5% CCHEMI~1%p6%       CCHEMI~1%p7%
%1 %2 %p3% %p4% %p5% CEEURO~1%p6%       CEEURO~1%p7%
%1 %2 %p3% %p4% %p5% CELLPR~1%p6%       CELLPR~1%p7%
%1 %2 %p3% %p4% %p5% CHARSE~1%p6%       CHARSE~1%p7%
%1 %2 %p3% %p4% %p5% CHEMAS~1%p6%       CHEMAS~1%p7%
%1 %2 %p3% %p4% %p5% CHEMAS~2%p6%       CHEMAS~2%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~1%p6%       CHEMFI~1%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~2%p6%       CHEMFI~2%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~3%p6%       CHEMFI~3%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~4%p6%       CHEMFI~4%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~5%p6%       CHEMFI~5%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~6%p6%       CHEMFI~6%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~7%p6%       CHEMFI~7%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~8%p6%       CHEMFI~8%p7%
%1 %2 %p3% %p4% %p5% CHEMOS~1%p6%       CHEMOS~1%p7%
%1 %2 %p3% %p4% %p5% CHEMPR~1%p6%       CHEMPR~1%p7%
%1 %2 %p3% %p4% %p5% CHEMPR~2%p6%       CHEMPR~2%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~1%p6%       CHEMPU~1%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~2%p6%       CHEMPU~2%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~3%p6%       CHEMPU~3%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~4%p6%       CHEMPU~4%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~5%p6%       CHEMPU~5%p7%
%1 %2 %p3% %p4% %p5% CMIRRO~1%p6%       CMIRRO~1%p7%
%1 %2 %p3% %p4% %p5% CMIX19~1%p6%       CMIX19~1%p7%
%1 %2 %p3% %p4% %p5% CMPDSX~1%p6%       CMPDSX~1%p7%
%1 %2 %p3% %p4% %p5% COFILE~1%p6%       COFILE~1%p7%
%1 %2 %p3% %p4% %p5% COFILE~2%p6%       COFILE~2%p7%
%1 %2 %p3% %p4% %p5% COFILE~3%p6%       COFILE~3%p7%
%1 %2 %p3% %p4% %p5% COMCTL~1%p6%       COMCTL~1%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG~1%p7%
%1 %2 %p3% %p4% %p5% COMDLG~2%p6%       COMDLG~2%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG~1%p7%
%1 %2 %p3% %p4% %p5% CONTAC~1%p6%       CONTAC~1%p7%
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       CONTEN~1%p7%
%1 %2 %p3% %p4% %p5% COREC0~1%p6%       COREC0~1%p7%
%1 %2 %p3% %p4% %p5% COREC1~1%p6%       COREC1~1%p7%
%1 %2 %p3% %p4% %p5% COREC7~1%p6%       COREC7~1%p7%
%1 %2 %p3% %p4% %p5% COREC9~1%p6%       COREC9~1%p7%
%1 %2 %p3% %p4% %p5% CP3240~1%p6%       CP3240~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D0~1%p6%       CTL3D0~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D1~1%p6%       CTL3D1~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D2~1%p6%       CTL3D2~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D3~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~1%p6%       CTL3D4~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~2%p6%       CTL3D4~2%p7%
%1 %2 %p3% %p4% %p5% CTL3D7~1%p6%       CTL3D7~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D9~1%p6%       CTL3D9~1%p7%
%1 %2 %p3% %p4% %p5% DECROL~1%p6%       DECROL~1%p7%
%1 %2 %p3% %p4% %p5% DECROL~2%p6%       DECROL~2%p7%
%1 %2 %p3% %p4% %p5% DECROL~3%p6%       DECROL~3%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       DEFAUL~1%p7%
%1 %2 %p3% %p4% %p5% DESIGN~1%p6%       DESIGN~1%p7%
%1 %2 %p3% %p4% %p5% DESIGN~2%p6%       DESIGN~2%p7%
%1 %2 %p3% %p4% %p5% DESIGN~3%p6%       DESIGN~3%p7%
%1 %2 %p3% %p4% %p5% DESIGN~4%p6%       DESIGN~4%p7%
%1 %2 %p3% %p4% %p5% DESIGN~5%p6%       DESIGN~5%p7%
%1 %2 %p3% %p4% %p5% DESIGN~6%p6%       DESIGN~6%p7%
%1 %2 %p3% %p4% %p5% DESIGN~7%p6%       DESIGN~7%p7%
%1 %2 %p3% %p4% %p5% DESIGN~8%p6%       DESIGN~8%p7%
%1 %2 %p3% %p4% %p5% DISK1_~1%p6%       DISK1_~1%p7%
%1 %2 %p3% %p4% %p5% DISK1_~2%p6%       DISK1_~2%p7%
%1 %2 %p3% %p4% %p5% DISK1_~3%p6%       DISK1_~3%p7%
%1 %2 %p3% %p4% %p5% DISK1_~4%p6%       DISK1_~4%p7%
%1 %2 %p3% %p4% %p5% DISK1_~5%p6%       DISK1_~5%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1I~1%p7%
%1 %2 %p3% %p4% %p5% DISK2I~1%p6%       DISK2I~1%p7%
%1 %2 %p3% %p4% %p5% DISPCO~1%p6%       DISPCO~1%p7%
%1 %2 %p3% %p4% %p5% DISPCO~2%p6%       DISPCO~2%p7%
%1 %2 %p3% %p4% %p5% DISPCO~3%p6%       DISPCO~3%p7%
%1 %2 %p3% %p4% %p5% DISPOS~1%p6%       DISPOS~1%p7%
%1 %2 %p3% %p4% %p5% DISPOS~2%p6%       DISPOS~2%p7%
%1 %2 %p3% %p4% %p5% DISPOS~3%p6%       DISPOS~3%p7%
%1 %2 %p3% %p4% %p5% DISPOS~4%p6%       DISPOS~4%p7%
%1 %2 %p3% %p4% %p5% DLGIM9~1%p6%       DLGIM9~1%p7%
%1 %2 %p3% %p4% %p5% DNAPDB~1%p6%       DNAPDB~1%p7%
%1 %2 %p3% %p4% %p5% DROPDO~1%p6%       DROPDO~1%p7%
%1 %2 %p3% %p4% %p5% DSETUP~1%p6%       DSETUP~1%p7%
%1 %2 %p3% %p4% %p5% E_EMMA~1%p6%       E_EMMA~1%p7%
%1 %2 %p3% %p4% %p5% ECE(ML~1%p6%       ECE(ML~1%p7%
%1 %2 %p3% %p4% %p5% ECELLP~1%p6%       ECELLP~1%p7%
%1 %2 %p3% %p4% %p5% ECELLP~2%p6%       ECELLP~2%p7%
%1 %2 %p3% %p4% %p5% ECELLP~3%p6%       ECELLP~3%p7%
%1 %2 %p3% %p4% %p5% ECELLS~1%p6%       ECELLS~1%p7%
%1 %2 %p3% %p4% %p5% ECELLS~2%p6%       ECELLS~2%p7%
%1 %2 %p3% %p4% %p5% ECELLS~3%p6%       ECELLS~3%p7%
%1 %2 %p3% %p4% %p5% ECMEC~1%p6%        ECMEC~1%p7%
%1 %2 %p3% %p4% %p5% EDITGI~1%p6%       EDITGI~1%p7%
%1 %2 %p3% %p4% %p5% EDITIN~1%p6%       EDITIN~1%p7%
%1 %2 %p3% %p4% %p5% EDITME~1%p6%       EDITME~1%p7%
%1 %2 %p3% %p4% %p5% EEAA0~1%p6%        EEAA0~1%p7%
%1 %2 %p3% %p4% %p5% EEMEC~1%p6%        EEMEC~1%p7%
%1 %2 %p3% %p4% %p5% EEOCV~1%p6%        EEOCV~1%p7%
%1 %2 %p3% %p4% %p5% EEPRN~1%p6%        EEPRN~1%p7%
%1 %2 %p3% %p4% %p5% ELECTR~1%p6%       ELECTR~1%p7%
%1 %2 %p3% %p4% %p5% ELECTR~2%p6%       ELECTR~2%p7%
%1 %2 %p3% %p4% %p5% ELEMMA~1%p6%       ELEMMA~1%p7%
%1 %2 %p3% %p4% %p5% ELEMVI~1%p6%       ELEMVI~1%p7%
%1 %2 %p3% %p4% %p5% ELEMVI~2%p6%       ELEMVI~2%p7%
%1 %2 %p3% %p4% %p5% EMEC~1%p6%         EMEC~1%p7%
%1 %2 %p3% %p4% %p5% EQBMGI~1%p6%       EQBMGI~1%p7%
%1 %2 %p3% %p4% %p5% EQNED1~1%p6%       EQNED1~1%p7%
%1 %2 %p3% %p4% %p5% EQNEDG~1%p6%       EQNEDG~1%p7%
%1 %2 %p3% %p4% %p5% EQNSGI~1%p6%       EQNSGI~1%p7%
%1 %2 %p3% %p4% %p5% EQUATI~1%p6%       EQUATI~1%p7%
%1 %2 %p3% %p4% %p5% ESTERB~1%p6%       ESTERB~1%p7%
%1 %2 %p3% %p4% %p5% ETHERB~1%p6%       ETHERB~1%p7%
%1 %2 %p3% %p4% %p5% EUROPE~1%p6%       EUROPE~1%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~1%p6%       EVOLPR~1%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~2%p6%       EVOLPR~2%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~3%p6%       EVOLPR~3%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~1%p6%       EXAMPL~1%p7%
%1 %2 %p3% %p4% %p5% EXCEPT~1%p6%       EXCEPT~1%p7%
%1 %2 %p3% %p4% %p5% EXCEPT~2%p6%       EXCEPT~2%p7%
%1 %2 %p3% %p4% %p5% F_MDES~1%p6%       F_MDES~1%p7%
%1 %2 %p3% %p4% %p5% F_MDES~2%p6%       F_MDES~2%p7%
%1 %2 %p3% %p4% %p5% F_MPRO~1%p6%       F_MPRO~1%p7%
%1 %2 %p3% %p4% %p5% F_MPRO~2%p6%       F_MPRO~2%p7%
%1 %2 %p3% %p4% %p5% F_MTAB~1%p6%       F_MTAB~1%p7%
%1 %2 %p3% %p4% %p5% F_MTAB~2%p6%       F_MTAB~2%p7%
%1 %2 %p3% %p4% %p5% F_MTOO~1%p6%       F_MTOO~1%p7%
%1 %2 %p3% %p4% %p5% F_MTOO~2%p6%       F_MTOO~2%p7%
%1 %2 %p3% %p4% %p5% FACILI~1%p6%       FACILI~1%p7%
%1 %2 %p3% %p4% %p5% FACILI~2%p6%       FACILI~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_I~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_I~3%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_I~4%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_I~5%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_I~6%p7%
%1 %2 %p3% %p4% %p5% FILE_I~7%p6%       FILE_I~7%p7%
%1 %2 %p3% %p4% %p5% FILE_I~8%p6%       FILE_I~8%p7%
%1 %2 %p3% %p4% %p5% FILEGI~1%p6%       FILEGI~1%p7%
%1 %2 %p3% %p4% %p5% FILEME~1%p6%       FILEME~1%p7%
%1 %2 %p3% %p4% %p5% FINISH~1%p6%       FINISH~1%p7%
%1 %2 %p3% %p4% %p5% FORMUL~1%p6%       FORMUL~1%p7%
%1 %2 %p3% %p4% %p5% FORMUL~2%p6%       FORMUL~2%p7%
%1 %2 %p3% %p4% %p5% FORMUL~3%p6%       FORMUL~3%p7%
%1 %2 %p3% %p4% %p5% FOXFON~1%p6%       FOXFON~1%p7%
%1 %2 %p3% %p4% %p5% FOXUSE~1%p6%       FOXUSE~1%p7%
%1 %2 %p3% %p4% %p5% FOXUSE~2%p6%       FOXUSE~2%p7%
%1 %2 %p3% %p4% %p5% FRMABO~1%p6%       FRMABO~1%p7%
%1 %2 %p3% %p4% %p5% FRMABO~2%p6%       FRMABO~2%p7%
%1 %2 %p3% %p4% %p5% FRMDES~1%p6%       FRMDES~1%p7%
%1 %2 %p3% %p4% %p5% FRMDES~2%p6%       FRMDES~2%p7%
%1 %2 %p3% %p4% %p5% FRMTAB~1%p6%       FRMTAB~1%p7%
%1 %2 %p3% %p4% %p5% FRMTAB~2%p6%       FRMTAB~2%p7%
%1 %2 %p3% %p4% %p5% GADLL~1%p6%        GADLL~1%p7%
%1 %2 %p3% %p4% %p5% GAHLP~1%p6%        GAHLP~1%p7%
%1 %2 %p3% %p4% %p5% GAINI~1%p6%        GAINI~1%p7%
%1 %2 %p3% %p4% %p5% GASESD~1%p6%       GASESD~1%p7%
%1 %2 %p3% %p4% %p5% GEP3F_~1%p6%       GEP3F_~1%p7%
%1 %2 %p3% %p4% %p5% GEP3FA~1%p6%       GEP3FA~1%p7%
%1 %2 %p3% %p4% %p5% GEPASI~1%p6%       GEPASI~1%p7%
%1 %2 %p3% %p4% %p5% GEPASI~2%p6%       GEPASI~2%p7%
%1 %2 %p3% %p4% %p5% GEPASI~3%p6%       GEPASI~3%p7%
%1 %2 %p3% %p4% %p5% GLOBEG~1%p6%       GLOBEG~1%p7%
%1 %2 %p3% %p4% %p5% GLOSSA~1%p6%       GLOSSA~1%p7%
%1 %2 %p3% %p4% %p5% GNUPLO~1%p6%       GNUPLO~1%p7%
%1 %2 %p3% %p4% %p5% GRAPH3~1%p6%       GRAPH3~1%p7%
%1 %2 %p3% %p4% %p5% GRAPH3~2%p6%       GRAPH3~2%p7%
%1 %2 %p3% %p4% %p5% GREEND~1%p6%       GREEND~1%p7%
%1 %2 %p3% %p4% %p5% GREYDA~1%p6%       GREYDA~1%p7%
%1 %2 %p3% %p4% %p5% GRID32~1%p6%       GRID32~1%p7%
%1 %2 %p3% %p4% %p5% GSW32E~1%p6%       GSW32E~1%p7%
%1 %2 %p3% %p4% %p5% GSW32E~2%p6%       GSW32E~2%p7%
%1 %2 %p3% %p4% %p5% GSWAG3~1%p6%       GSWAG3~1%p7%
%1 %2 %p3% %p4% %p5% GSWDLL~1%p6%       GSWDLL~1%p7%
%1 %2 %p3% %p4% %p5% GSWDLL~2%p6%       GSWDLL~2%p7%
%1 %2 %p3% %p4% %p5% HALFEQ~1%p6%       HALFEQ~1%p7%
%1 %2 %p3% %p4% %p5% HALFEQ~2%p6%       HALFEQ~2%p7%
%1 %2 %p3% %p4% %p5% HEADER~1%p6%       HEADER~1%p7%
%1 %2 %p3% %p4% %p5% HEADER~2%p6%       HEADER~2%p7%
%1 %2 %p3% %p4% %p5% HELPPA~1%p6%       HELPPA~1%p7%
%1 %2 %p3% %p4% %p5% HMMGPS~1%p6%       HMMGPS~1%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~1%p6%       HOOJEE~1%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~2%p6%       HOOJEE~2%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~3%p6%       HOOJEE~3%p7%
%1 %2 %p3% %p4% %p5% HYPERG~1%p6%       HYPERG~1%p7%
%1 %2 %p3% %p4% %p5% IDAPI3~1%p6%       IDAPI3~1%p7%
%1 %2 %p3% %p4% %p5% IDAPI3~2%p6%       IDAPI3~2%p7%
%1 %2 %p3% %p4% %p5% IDAPIN~1%p6%       IDAPIN~1%p7%
%1 %2 %p3% %p4% %p5% IDBAT3~1%p6%       IDBAT3~1%p7%
%1 %2 %p3% %p4% %p5% IDPDX3~1%p6%       IDPDX3~1%p7%
%1 %2 %p3% %p4% %p5% IDR200~1%p6%       IDR200~1%p7%
%1 %2 %p3% %p4% %p5% IDSQL3~1%p6%       IDSQL3~1%p7%
%1 %2 %p3% %p4% %p5% INFOCD~1%p6%       INFOCD~1%p7%
%1 %2 %p3% %p4% %p5% INFODB~1%p6%       INFODB~1%p7%
%1 %2 %p3% %p4% %p5% INFOFP~1%p6%       INFOFP~1%p7%
%1 %2 %p3% %p4% %p5% INFOTB~1%p6%       INFOTB~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTAL~2%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTAL~3%p7%
%1 %2 %p3% %p4% %p5% INVENT~1%p6%       INVENT~1%p7%
%1 %2 %p3% %p4% %p5% INVENT~2%p6%       INVENT~2%p7%
%1 %2 %p3% %p4% %p5% INVENT~3%p6%       INVENT~3%p7%
%1 %2 %p3% %p4% %p5% INVENT~4%p6%       INVENT~4%p7%
%1 %2 %p3% %p4% %p5% KETONE~1%p6%       KETONE~1%p7%
%1 %2 %p3% %p4% %p5% KHEMCC~1%p6%       KHEMCC~1%p7%
%1 %2 %p3% %p4% %p5% KHEMCD~1%p6%       KHEMCD~1%p7%
%1 %2 %p3% %p4% %p5% KHEMCF~1%p6%       KHEMCF~1%p7%
%1 %2 %p3% %p4% %p5% KINMMF~1%p6%       KINMMF~1%p7%
%1 %2 %p3% %p4% %p5% KMODIC~1%p6%       KMODIC~1%p7%
%1 %2 %p3% %p4% %p5% KMODUL~1%p6%       KMODUL~1%p7%
%1 %2 %p3% %p4% %p5% LABEL3~1%p6%       LABEL3~1%p7%
%1 %2 %p3% %p4% %p5% LABEL3~2%p6%       LABEL3~2%p7%
%1 %2 %p3% %p4% %p5% LABELH~1%p6%       LABELH~1%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~1%p6%       LBFGSB~1%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~2%p6%       LBFGSB~2%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~3%p6%       LBFGSB~3%p7%
%1 %2 %p3% %p4% %p5% LBLUED~1%p6%       LBLUED~1%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~1%p6%       LEVMAR~1%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~2%p6%       LEVMAR~2%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~3%p6%       LEVMAR~3%p7%
%1 %2 %p3% %p4% %p5% LICE_S~1%p6%       LICE_S~1%p7%
%1 %2 %p3% %p4% %p5% LICEN_~1%p6%       LICEN_~1%p7%
%1 %2 %p3% %p4% %p5% LICEN9~1%p6%       LICEN9~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% LINEAR~1%p6%       LINEAR~1%p7%
%1 %2 %p3% %p4% %p5% LINEAR~2%p6%       LINEAR~2%p7%
%1 %2 %p3% %p4% %p5% LOCATE~1%p6%       LOCATE~1%p7%
%1 %2 %p3% %p4% %p5% LOCATE~2%p6%       LOCATE~2%p7%
%1 %2 %p3% %p4% %p5% LOCATI~1%p6%       LOCATI~1%p7%
%1 %2 %p3% %p4% %p5% LOCATI~2%p6%       LOCATI~2%p7%
%1 %2 %p3% %p4% %p5% LOCATI~3%p6%       LOCATI~3%p7%
%1 %2 %p3% %p4% %p5% LOCATI~4%p6%       LOCATI~4%p7%
%1 %2 %p3% %p4% %p5% LOGADM~1%p6%       LOGADM~1%p7%
%1 %2 %p3% %p4% %p5% LOGLAB~1%p6%       LOGLAB~1%p7%
%1 %2 %p3% %p4% %p5% LOGREP~1%p6%       LOGREP~1%p7%
%1 %2 %p3% %p4% %p5% LOGSAF~1%p6%       LOGSAF~1%p7%
%1 %2 %p3% %p4% %p5% LOGSET~1%p6%       LOGSET~1%p7%
%1 %2 %p3% %p4% %p5% LOGSRC~1%p6%       LOGSRC~1%p7%
%1 %2 %p3% %p4% %p5% LOGWAS~1%p6%       LOGWAS~1%p7%
%1 %2 %p3% %p4% %p5% M_DELE~1%p6%       M_DELE~1%p7%
%1 %2 %p3% %p4% %p5% MAILGI~1%p6%       MAILGI~1%p7%
%1 %2 %p3% %p4% %p5% MAINGI~1%p6%       MAINGI~1%p7%
%1 %2 %p3% %p4% %p5% MANU_L~1%p6%       MANU_L~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       MANUAL~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       MANUAL~2%p7%
%1 %2 %p3% %p4% %p5% MANUAL~3%p6%       MANUAL~3%p7%
%1 %2 %p3% %p4% %p5% MENDE4~1%p6%       MENDE4~1%p7%
%1 %2 %p3% %p4% %p5% MENDEL~1%p6%       MENDEL~1%p7%
%1 %2 %p3% %p4% %p5% MFC4_D~1%p6%       MFC4_D~1%p7%
%1 %2 %p3% %p4% %p5% MFILEC~1%p6%       MFILEC~1%p7%
%1 %2 %p3% %p4% %p5% MFILED~1%p6%       MFILED~1%p7%
%1 %2 %p3% %p4% %p5% MFILEF~1%p6%       MFILEF~1%p7%
%1 %2 %p3% %p4% %p5% MIRROR~1%p6%       MIRROR~1%p7%
%1 %2 %p3% %p4% %p5% MIRROR~2%p6%       MIRROR~2%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~1%p6%       MIXTUR~1%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~2%p6%       MIXTUR~2%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~3%p6%       MIXTUR~3%p7%
%1 %2 %p3% %p4% %p5% MMSPEC~1%p6%       MMSPEC~1%p7%
%1 %2 %p3% %p4% %p5% MNUEDI~1%p6%       MNUEDI~1%p7%
%1 %2 %p3% %p4% %p5% MNUEQN~1%p6%       MNUEQN~1%p7%
%1 %2 %p3% %p4% %p5% MNUFIL~1%p6%       MNUFIL~1%p7%
%1 %2 %p3% %p4% %p5% MNUOPT~1%p6%       MNUOPT~1%p7%
%1 %2 %p3% %p4% %p5% MNUSHO~1%p6%       MNUSHO~1%p7%
%1 %2 %p3% %p4% %p5% MODELE~1%p6%       MODELE~1%p7%
%1 %2 %p3% %p4% %p5% MOLVIE~1%p6%       MOLVIE~1%p7%
%1 %2 %p3% %p4% %p5% MSDSCD~1%p6%       MSDSCD~1%p7%
%1 %2 %p3% %p4% %p5% MSDSDB~1%p6%       MSDSDB~1%p7%
%1 %2 %p3% %p4% %p5% MSDSFP~1%p6%       MSDSFP~1%p7%
%1 %2 %p3% %p4% %p5% MSDSTB~1%p6%       MSDSTB~1%p7%
%1 %2 %p3% %p4% %p5% MSFLXG~1%p6%       MSFLXG~1%p7%
%1 %2 %p3% %p4% %p5% MSSETU~1%p6%       MSSETU~1%p7%
%1 %2 %p3% %p4% %p5% MSTART~1%p6%       MSTART~1%p7%
%1 %2 %p3% %p4% %p5% MSTART~2%p6%       MSTART~2%p7%
%1 %2 %p3% %p4% %p5% MSTART~3%p6%       MSTART~3%p7%
%1 %2 %p3% %p4% %p5% MSVC_T~1%p6%       MSVC_T~1%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       MSVCRT~1%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~2%p6%       MSVCRT~2%p7%
%1 %2 %p3% %p4% %p5% MTBENG~1%p6%       MTBENG~1%p7%
%1 %2 %p3% %p4% %p5% MTBENG~2%p6%       MTBENG~2%p7%
%1 %2 %p3% %p4% %p5% MWT_AB~1%p6%       MWT_AB~1%p7%
%1 %2 %p3% %p4% %p5% MWT_EL~1%p6%       MWT_EL~1%p7%
%1 %2 %p3% %p4% %p5% MWT_EL~2%p6%       MWT_EL~2%p7%
%1 %2 %p3% %p4% %p5% MWT_VA~1%p6%       MWT_VA~1%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~1%p6%       MWTWIN~1%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~2%p6%       MWTWIN~2%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~3%p6%       MWTWIN~3%p7%
%1 %2 %p3% %p4% %p5% N02_RE~1%p6%       N02_RE~1%p7%
%1 %2 %p3% %p4% %p5% N20OXI~1%p6%       N20OXI~1%p7%
%1 %2 %p3% %p4% %p5% NERNST~1%p6%       NERNST~1%p7%
%1 %2 %p3% %p4% %p5% NOTE2I~1%p6%       NOTE2I~1%p7%
%1 %2 %p3% %p4% %p5% ODBCKE~1%p6%       ODBCKE~1%p7%
%1 %2 %p3% %p4% %p5% ODBCST~1%p6%       ODBCST~1%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~1%p6%       OFFSIT~1%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~2%p6%       OFFSIT~2%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~3%p6%       OFFSIT~3%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~4%p6%       OFFSIT~4%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~5%p6%       OFFSIT~5%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~6%p6%       OFFSIT~6%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~7%p6%       OFFSIT~7%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~8%p6%       OFFSIT~8%p7%
%1 %2 %p3% %p4% %p5% OLEAUT~1%p6%       OLEAUT~1%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       OLEPRO~1%p7%
%1 %2 %p3% %p4% %p5% OPENBO~1%p6%       OPENBO~1%p7%
%1 %2 %p3% %p4% %p5% OPTION~1%p6%       OPTION~1%p7%
%1 %2 %p3% %p4% %p5% OPTION~2%p6%       OPTION~2%p7%
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       ORDER_~1%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERF~1%p7%
%1 %2 %p3% %p4% %p5% OTHERB~1%p6%       OTHERB~1%p7%
%1 %2 %p3% %p4% %p5% OXIDAT~1%p6%       OXIDAT~1%p7%
%1 %2 %p3% %p4% %p5% PINKDA~1%p6%       PINKDA~1%p7%
%1 %2 %p3% %p4% %p5% POLAR4~1%p6%       POLAR4~1%p7%
%1 %2 %p3% %p4% %p5% POLARD~1%p6%       POLARD~1%p7%
%1 %2 %p3% %p4% %p5% POLARH~1%p6%       POLARH~1%p7%
%1 %2 %p3% %p4% %p5% POLART~1%p6%       POLART~1%p7%
%1 %2 %p3% %p4% %p5% POLYCO~1%p6%       POLYCO~1%p7%
%1 %2 %p3% %p4% %p5% POLYCO~2%p6%       POLYCO~2%p7%
%1 %2 %p3% %p4% %p5% POLYCO~3%p6%       POLYCO~3%p7%
%1 %2 %p3% %p4% %p5% PSEDAT~1%p6%       PSEDAT~1%p7%
%1 %2 %p3% %p4% %p5% PTDATA~1%p6%       PTDATA~1%p7%
%1 %2 %p3% %p4% %p5% PTDATA~2%p6%       PTDATA~2%p7%
%1 %2 %p3% %p4% %p5% PTDATA~3%p6%       PTDATA~3%p7%
%1 %2 %p3% %p4% %p5% PTDATA~4%p6%       PTDATA~4%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~1%p6%       PUBLIC~1%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~2%p6%       PUBLIC~2%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~3%p6%       PUBLIC~3%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~4%p6%       PUBLIC~4%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~5%p6%       PUBLIC~5%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~6%p6%       PUBLIC~6%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~7%p6%       PUBLIC~7%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~8%p6%       PUBLIC~8%p7%
%1 %2 %p3% %p4% %p5% QINFOD~1%p6%       QINFOD~1%p7%
%1 %2 %p3% %p4% %p5% QINFOF~1%p6%       QINFOF~1%p7%
%1 %2 %p3% %p4% %p5% QRPT30~1%p6%       QRPT30~1%p7%
%1 %2 %p3% %p4% %p5% R_CHTX~1%p6%       R_CHTX~1%p7%
%1 %2 %p3% %p4% %p5% READ_E~1%p6%       READ_E~1%p7%
%1 %2 %p3% %p4% %p5% READM_~1%p6%       READM_~1%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       READM~10%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       READM~11%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       READM~12%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       READM~13%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       READM~14%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       READM~15%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       READM~16%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       READM~17%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       READM~18%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       READM~19%p7%
%1 %2 %p3% %p4% %p5% READM7~1%p6%       READM7~1%p7%
%1 %2 %p3% %p4% %p5% READM9~1%p6%       READM9~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README~7%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README~8%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README~9%p7%
%1 %2 %p3% %p4% %p5% REDDAT~1%p6%       REDDAT~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGIST~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGIST~2%p7%
%1 %2 %p3% %p4% %p5% REMIND~1%p6%       REMIND~1%p7%
%1 %2 %p3% %p4% %p5% REPORT~1%p6%       REPORT~1%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RICHED~1%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX~1%p7%
%1 %2 %p3% %p4% %p5% RICHTX~2%p6%       RICHTX~2%p7%
%1 %2 %p3% %p4% %p5% RINFOD~1%p6%       RINFOD~1%p7%
%1 %2 %p3% %p4% %p5% RINFOF~1%p6%       RINFOF~1%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~1%p6%       RNDSRC~1%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~2%p6%       RNDSRC~2%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~3%p6%       RNDSRC~3%p7%
%1 %2 %p3% %p4% %p5% RXCTLB~1%p6%       RXCTLB~1%p7%
%1 %2 %p3% %p4% %p5% S_OWIC~1%p6%       S_OWIC~1%p7%
%1 %2 %p3% %p4% %p5% SAFETY~1%p6%       SAFETY~1%p7%
%1 %2 %p3% %p4% %p5% SAMPLE~1%p6%       SAMPLE~1%p7%
%1 %2 %p3% %p4% %p5% SEARCH~1%p6%       SEARCH~1%p7%
%1 %2 %p3% %p4% %p5% SEQFBG~1%p6%       SEQFBG~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_~2%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP_~3%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_~4%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_~5%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_~6%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_~7%p7%
%1 %2 %p3% %p4% %p5% SETUP_~8%p6%       SETUP_~8%p7%
%1 %2 %p3% %p4% %p5% SETUP_~9%p6%       SETUP_~9%p7%
%1 %2 %p3% %p4% %p5% SETUP~10%p6%       SETUP~10%p7%
%1 %2 %p3% %p4% %p5% SETUP~11%p6%       SETUP~11%p7%
%1 %2 %p3% %p4% %p5% SETUP~12%p6%       SETUP~12%p7%
%1 %2 %p3% %p4% %p5% SETUP~13%p6%       SETUP~13%p7%
%1 %2 %p3% %p4% %p5% SETUP~14%p6%       SETUP~14%p7%
%1 %2 %p3% %p4% %p5% SETUP~15%p6%       SETUP~15%p7%
%1 %2 %p3% %p4% %p5% SETUP~16%p6%       SETUP~16%p7%
%1 %2 %p3% %p4% %p5% SETUP~17%p6%       SETUP~17%p7%
%1 %2 %p3% %p4% %p5% SETUP~18%p6%       SETUP~18%p7%
%1 %2 %p3% %p4% %p5% SETUP~19%p6%       SETUP~19%p7%
%1 %2 %p3% %p4% %p5% SETUP~20%p6%       SETUP~20%p7%
%1 %2 %p3% %p4% %p5% SETUP~21%p6%       SETUP~21%p7%
%1 %2 %p3% %p4% %p5% SETUP~22%p6%       SETUP~22%p7%
%1 %2 %p3% %p4% %p5% SETUP~23%p6%       SETUP~23%p7%
%1 %2 %p3% %p4% %p5% SETUP~24%p6%       SETUP~24%p7%
%1 %2 %p3% %p4% %p5% SETUP0~1%p6%       SETUP0~1%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       SETUP1~1%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       SETUP1~2%p7%
%1 %2 %p3% %p4% %p5% SETUP2~1%p6%       SETUP2~1%p7%
%1 %2 %p3% %p4% %p5% SETUP4~1%p6%       SETUP4~1%p7%
%1 %2 %p3% %p4% %p5% SETUP7~1%p6%       SETUP7~1%p7%
%1 %2 %p3% %p4% %p5% SETUP9~1%p6%       SETUP9~1%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPH~1%p6%       SETUPH~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUPI~3%p7%
%1 %2 %p3% %p4% %p5% SETUPI~4%p6%       SETUPI~4%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUPL~1%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUPP~1%p7%
%1 %2 %p3% %p4% %p5% SETUPR~1%p6%       SETUPR~1%p7%
%1 %2 %p3% %p4% %p5% SETUPS~1%p6%       SETUPS~1%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       SETUPT~1%p7%
%1 %2 %p3% %p4% %p5% SHIPP9~1%p6%       SHIPP9~1%p7%
%1 %2 %p3% %p4% %p5% SHOWGI~1%p6%       SHOWGI~1%p7%
%1 %2 %p3% %p4% %p5% SHOWME~1%p6%       SHOWME~1%p7%
%1 %2 %p3% %p4% %p5% SIGNAL~1%p6%       SIGNAL~1%p7%
%1 %2 %p3% %p4% %p5% SIGNAL~2%p6%       SIGNAL~2%p7%
%1 %2 %p3% %p4% %p5% SNOWIC~1%p6%       SNOWIC~1%p7%
%1 %2 %p3% %p4% %p5% SOLNSD~1%p6%       SOLNSD~1%p7%
%1 %2 %p3% %p4% %p5% ST4UNS~1%p6%       ST4UNS~1%p7%
%1 %2 %p3% %p4% %p5% STANDA~1%p6%       STANDA~1%p7%
%1 %2 %p3% %p4% %p5% STDOLE~1%p6%       STDOLE~1%p7%
%1 %2 %p3% %p4% %p5% STEEPE~1%p6%       STEEPE~1%p7%
%1 %2 %p3% %p4% %p5% STEEPE~2%p6%       STEEPE~2%p7%
%1 %2 %p3% %p4% %p5% STEEPE~3%p6%       STEEPE~3%p7%
%1 %2 %p3% %p4% %p5% STKIT4~1%p6%       STKIT4~1%p7%
%1 %2 %p3% %p4% %p5% STOCKN~1%p6%       STOCKN~1%p7%
%1 %2 %p3% %p4% %p5% STOICE~1%p6%       STOICE~1%p7%
%1 %2 %p3% %p4% %p5% STOICH~1%p6%       STOICH~1%p7%
%1 %2 %p3% %p4% %p5% SURVEY~1%p6%       SURVEY~1%p7%
%1 %2 %p3% %p4% %p5% TANDAT~1%p6%       TANDAT~1%p7%
%1 %2 %p3% %p4% %p5% TEE35B~1%p6%       TEE35B~1%p7%
%1 %2 %p3% %p4% %p5% TNDLL~1%p6%        TNDLL~1%p7%
%1 %2 %p3% %p4% %p5% TNHLP~1%p6%        TNHLP~1%p7%
%1 %2 %p3% %p4% %p5% TNINI~1%p6%        TNINI~1%p7%
%1 %2 %p3% %p4% %p5% TOOLBA~1%p6%       TOOLBA~1%p7%
%1 %2 %p3% %p4% %p5% TRANSP~1%p6%       TRANSP~1%p7%
%1 %2 %p3% %p4% %p5% TRANSP~2%p6%       TRANSP~2%p7%
%1 %2 %p3% %p4% %p5% TRANSP~3%p6%       TRANSP~3%p7%
%1 %2 %p3% %p4% %p5% TRANSP~4%p6%       TRANSP~4%p7%
%1 %2 %p3% %p4% %p5% TRANSP~5%p6%       TRANSP~5%p7%
%1 %2 %p3% %p4% %p5% TRANSP~6%p6%       TRANSP~6%p7%
%1 %2 %p3% %p4% %p5% TRANSP~7%p6%       TRANSP~7%p7%
%1 %2 %p3% %p4% %p5% TRANSP~8%p6%       TRANSP~8%p7%
%1 %2 %p3% %p4% %p5% UNINS0~1%p6%       UNINS0~1%p7%
%1 %2 %p3% %p4% %p5% UNINS1~1%p6%       UNINS1~1%p7%
%1 %2 %p3% %p4% %p5% UNINS2~1%p6%       UNINS2~1%p7%
%1 %2 %p3% %p4% %p5% UNINS4~1%p6%       UNINS4~1%p7%
%1 %2 %p3% %p4% %p5% UNINS7~1%p6%       UNINS7~1%p7%
%1 %2 %p3% %p4% %p5% UNINS9~1%p6%       UNINS9~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST~1%p7%
%1 %2 %p3% %p4% %p5% USABLL~1%p6%       USABLL~1%p7%
%1 %2 %p3% %p4% %p5% USAGE2~1%p6%       USAGE2~1%p7%
%1 %2 %p3% %p4% %p5% USAGE2~2%p6%       USAGE2~2%p7%
%1 %2 %p3% %p4% %p5% USAGE3~1%p6%       USAGE3~1%p7%
%1 %2 %p3% %p4% %p5% USAGE3~2%p6%       USAGE3~2%p7%
%1 %2 %p3% %p4% %p5% USAGEC~1%p6%       USAGEC~1%p7%
%1 %2 %p3% %p4% %p5% USAGED~1%p6%       USAGED~1%p7%
%1 %2 %p3% %p4% %p5% USAGEF~1%p6%       USAGEF~1%p7%
%1 %2 %p3% %p4% %p5% USAGEF~2%p6%       USAGEF~2%p7%
%1 %2 %p3% %p4% %p5% VCL35B~1%p6%       VCL35B~1%p7%
%1 %2 %p3% %p4% %p5% VCLDB3~1%p6%       VCLDB3~1%p7%
%1 %2 %p3% %p4% %p5% VCLDBX~1%p6%       VCLDBX~1%p7%
%1 %2 %p3% %p4% %p5% VCLSMP~1%p6%       VCLSMP~1%p7%
%1 %2 %p3% %p4% %p5% VCLX30~1%p6%       VCLX30~1%p7%
%1 %2 %p3% %p4% %p5% VCLX35~1%p6%       VCLX35~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR~1%p7%
%1 %2 %p3% %p4% %p5% VFP6RD~1%p6%       VFP6RD~1%p7%
%1 %2 %p3% %p4% %p5% VFP6RE~1%p6%       VFP6RE~1%p7%
%1 %2 %p3% %p4% %p5% VFP6RU~1%p6%       VFP6RU~1%p7%
%1 %2 %p3% %p4% %p5% VIRTUA~1%p6%       VIRTUA~1%p7%
%1 %2 %p3% %p4% %p5% VLECAL~1%p6%       VLECAL~1%p7%
%1 %2 %p3% %p4% %p5% WASTEH~1%p6%       WASTEH~1%p7%
%1 %2 %p3% %p4% %p5% WASTEM~1%p6%       WASTEM~1%p7%
%1 %2 %p3% %p4% %p5% WASTEM~2%p6%       WASTEM~2%p7%
%1 %2 %p3% %p4% %p5% WASTEM~3%p6%       WASTEM~3%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~1%p6%       WGNUPL~1%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~2%p6%       WGNUPL~2%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~3%p6%       WGNUPL~3%p7%
%1 %2 %p3% %p4% %p5% WHITED~1%p6%       WHITED~1%p7%
%1 %2 %p3% %p4% %p5% WIZSET~1%p6%       WIZSET~1%p7%
%1 %2 %p3% %p4% %p5% YELLOW~1%p6%       YELLOW~1%p7%
%1 %2 %p3% %p4% %p5% ZLIB_D~1%p6%       ZLIB_D~1%p7%

cd %dir3%

%1 %2 %p3% %p4% %p5% _BORDE~1%p6%       _BORDE~1%p7%
%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST3~1%p7%
%1 %2 %p3% %p4% %p5% _INST3~2%p6%       _INST3~2%p7%
%1 %2 %p3% %p4% %p5% _INST3~3%p6%       _INST3~3%p7%
%1 %2 %p3% %p4% %p5% _INST3~4%p6%       _INST3~4%p7%
%1 %2 %p3% %p4% %p5% _INST3~5%p6%       _INST3~5%p7%
%1 %2 %p3% %p4% %p5% _INST3~6%p6%       _INST3~6%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL~1%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~2%p6%       _ISDEL~2%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~3%p6%       _ISDEL~3%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~4%p6%       _ISDEL~4%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~5%p6%       _ISDEL~5%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~6%p6%       _ISDEL~6%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~1%p6%       _ISRE0~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~2%p6%       _ISRE0~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~1%p6%       _ISRE1~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~2%p6%       _ISRE1~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~1%p6%       _ISRE2~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~2%p6%       _ISRE2~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE3~1%p6%       _ISRE3~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE3~2%p6%       _ISRE3~2%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~1%p6%       _ISRE4~1%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~2%p6%       _ISRE4~2%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS0~1%p6%       _ISUS0~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS1~1%p6%       _ISUS1~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS2~1%p6%       _ISUS2~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS3~1%p6%       _ISUS3~1%p7%
%1 %2 %p3% %p4% %p5% _ISUS4~1%p6%       _ISUS4~1%p7%
%1 %2 %p3% %p4% %p5% _LIC7N~1%p6%       _LIC7N~1%p7%
%1 %2 %p3% %p4% %p5% _REA7M~1%p6%       _REA7M~1%p7%
%1 %2 %p3% %p4% %p5% _REA8M~1%p6%       _REA8M~1%p7%
%1 %2 %p3% %p4% %p5% _REA9M~1%p6%       _REA9M~1%p7%
%1 %2 %p3% %p4% %p5% _READM~1%p6%       _READM~1%p7%
%1 %2 %p3% %p4% %p5% _READM~2%p6%       _READM~2%p7%
%1 %2 %p3% %p4% %p5% _READM~3%p6%       _READM~3%p7%
%1 %2 %p3% %p4% %p5% _READM~4%p6%       _READM~4%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _SETUP~2%p7%
%1 %2 %p3% %p4% %p5% _SETUP~3%p6%       _SETUP~3%p7%
%1 %2 %p3% %p4% %p5% _SETUP~4%p6%       _SETUP~4%p7%
%1 %2 %p3% %p4% %p5% _SETUP~5%p6%       _SETUP~5%p7%
%1 %2 %p3% %p4% %p5% _SETUP~6%p6%       _SETUP~6%p7%
%1 %2 %p3% %p4% %p5% 001GIF~1%p6%       001GIF~1%p7%
%1 %2 %p3% %p4% %p5% 0047HT~1%p6%       0047HT~1%p7%
%1 %2 %p3% %p4% %p5% 050GIF~1%p6%       050GIF~1%p7%
%1 %2 %p3% %p4% %p5% 1975RG~1%p6%       1975RG~1%p7%
%1 %2 %p3% %p4% %p5% 1976RG~1%p6%       1976RG~1%p7%
%1 %2 %p3% %p4% %p5% 3000HT~1%p6%       3000HT~1%p7%
%1 %2 %p3% %p4% %p5% 3002HT~1%p6%       3002HT~1%p7%
%1 %2 %p3% %p4% %p5% 3003HT~1%p6%       3003HT~1%p7%
%1 %2 %p3% %p4% %p5% 3004HT~1%p6%       3004HT~1%p7%
%1 %2 %p3% %p4% %p5% 3008HT~1%p6%       3008HT~1%p7%
%1 %2 %p3% %p4% %p5% 3009HT~1%p6%       3009HT~1%p7%
%1 %2 %p3% %p4% %p5% 3010HT~1%p6%       3010HT~1%p7%
%1 %2 %p3% %p4% %p5% 32768N~1%p6%       32768N~1%p7%
%1 %2 %p3% %p4% %p5% 375GIF~1%p6%       375GIF~1%p7%
%1 %2 %p3% %p4% %p5% 416GIF~1%p6%       416GIF~1%p7%
%1 %2 %p3% %p4% %p5% 426JPG~1%p6%       426JPG~1%p7%
%1 %2 %p3% %p4% %p5% 436GIF~1%p6%       436GIF~1%p7%
%1 %2 %p3% %p4% %p5% 666GIF~1%p6%       666GIF~1%p7%
%1 %2 %p3% %p4% %p5% 7HOURS~1%p6%       7HOURS~1%p7%
%1 %2 %p3% %p4% %p5% A0000~10%p6%       A0000~10%p7%
%1 %2 %p3% %p4% %p5% A0000~11%p6%       A0000~11%p7%
%1 %2 %p3% %p4% %p5% A0000~12%p6%       A0000~12%p7%
%1 %2 %p3% %p4% %p5% A0000~13%p6%       A0000~13%p7%
%1 %2 %p3% %p4% %p5% A0000~14%p6%       A0000~14%p7%
%1 %2 %p3% %p4% %p5% A0000~15%p6%       A0000~15%p7%
%1 %2 %p3% %p4% %p5% A0000~16%p6%       A0000~16%p7%
%1 %2 %p3% %p4% %p5% A0000~17%p6%       A0000~17%p7%
%1 %2 %p3% %p4% %p5% A0000~18%p6%       A0000~18%p7%
%1 %2 %p3% %p4% %p5% A0000~19%p6%       A0000~19%p7%
%1 %2 %p3% %p4% %p5% A0000~20%p6%       A0000~20%p7%
%1 %2 %p3% %p4% %p5% A0000~21%p6%       A0000~21%p7%
%1 %2 %p3% %p4% %p5% A0000~22%p6%       A0000~22%p7%
%1 %2 %p3% %p4% %p5% A0000~23%p6%       A0000~23%p7%
%1 %2 %p3% %p4% %p5% A0000~24%p6%       A0000~24%p7%
%1 %2 %p3% %p4% %p5% A0000~25%p6%       A0000~25%p7%
%1 %2 %p3% %p4% %p5% A00000~1%p6%       A00000~1%p7%
%1 %2 %p3% %p4% %p5% A00000~2%p6%       A00000~2%p7%
%1 %2 %p3% %p4% %p5% A00000~3%p6%       A00000~3%p7%
%1 %2 %p3% %p4% %p5% A00000~4%p6%       A00000~4%p7%
%1 %2 %p3% %p4% %p5% A00000~5%p6%       A00000~5%p7%
%1 %2 %p3% %p4% %p5% A00000~6%p6%       A00000~6%p7%
%1 %2 %p3% %p4% %p5% A00000~7%p6%       A00000~7%p7%
%1 %2 %p3% %p4% %p5% A00000~8%p6%       A00000~8%p7%
%1 %2 %p3% %p4% %p5% A00000~9%p6%       A00000~9%p7%
%1 %2 %p3% %p4% %p5% ABOUT_~1%p6%       ABOUT_~1%p7%
%1 %2 %p3% %p4% %p5% ABOUTH~1%p6%       ABOUTH~1%p7%
%1 %2 %p3% %p4% %p5% ACTION~1%p6%       ACTION~1%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~1%p6%       ADD2CA~1%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~2%p6%       ADD2CA~2%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~3%p6%       ADD2CA~3%p7%
%1 %2 %p3% %p4% %p5% ADVP8C~1%p6%       ADVP8C~1%p7%
%1 %2 %p3% %p4% %p5% ADVP9C~1%p6%       ADVP9C~1%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~1%p6%       AKFVIE~1%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~2%p6%       AKFVIE~2%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~3%p6%       AKFVIE~3%p7%
%1 %2 %p3% %p4% %p5% ALC5UN~1%p6%       ALC5UN~1%p7%
%1 %2 %p3% %p4% %p5% ALC6UN~1%p6%       ALC6UN~1%p7%
%1 %2 %p3% %p4% %p5% ALGICU~1%p6%       ALGICU~1%p7%
%1 %2 %p3% %p4% %p5% AMAZON~1%p6%       AMAZON~1%p7%
%1 %2 %p3% %p4% %p5% AMVIEW~1%p6%       AMVIEW~1%p7%
%1 %2 %p3% %p4% %p5% AND5OM~1%p6%       AND5OM~1%p7%
%1 %2 %p3% %p4% %p5% AND6OM~1%p6%       AND6OM~1%p7%
%1 %2 %p3% %p4% %p5% ANGSTR~1%p6%       ANGSTR~1%p7%
%1 %2 %p3% %p4% %p5% ANTELO~1%p6%       ANTELO~1%p7%
%1 %2 %p3% %p4% %p5% ANTIBL~1%p6%       ANTIBL~1%p7%
%1 %2 %p3% %p4% %p5% ARC5IT~1%p6%       ARC5IT~1%p7%
%1 %2 %p3% %p4% %p5% ARC6IT~1%p6%       ARC6IT~1%p7%
%1 %2 %p3% %p4% %p5% ARIATT~1%p6%       ARIATT~1%p7%
%1 %2 %p3% %p4% %p5% ATMDLL~1%p6%       ATMDLL~1%p7%
%1 %2 %p3% %p4% %p5% B0000~10%p6%       B0000~10%p7%
%1 %2 %p3% %p4% %p5% B0000~11%p6%       B0000~11%p7%
%1 %2 %p3% %p4% %p5% B0000~12%p6%       B0000~12%p7%
%1 %2 %p3% %p4% %p5% B0000~13%p6%       B0000~13%p7%
%1 %2 %p3% %p4% %p5% B0000~14%p6%       B0000~14%p7%
%1 %2 %p3% %p4% %p5% B0000~15%p6%       B0000~15%p7%
%1 %2 %p3% %p4% %p5% B0000~16%p6%       B0000~16%p7%
%1 %2 %p3% %p4% %p5% B0000~17%p6%       B0000~17%p7%
%1 %2 %p3% %p4% %p5% B0000~18%p6%       B0000~18%p7%
%1 %2 %p3% %p4% %p5% B0000~19%p6%       B0000~19%p7%
%1 %2 %p3% %p4% %p5% B0000~20%p6%       B0000~20%p7%
%1 %2 %p3% %p4% %p5% B0000~21%p6%       B0000~21%p7%
%1 %2 %p3% %p4% %p5% B0000~22%p6%       B0000~22%p7%
%1 %2 %p3% %p4% %p5% B00000~1%p6%       B00000~1%p7%
%1 %2 %p3% %p4% %p5% B00000~2%p6%       B00000~2%p7%
%1 %2 %p3% %p4% %p5% B00000~3%p6%       B00000~3%p7%
%1 %2 %p3% %p4% %p5% B00000~4%p6%       B00000~4%p7%
%1 %2 %p3% %p4% %p5% B00000~5%p6%       B00000~5%p7%
%1 %2 %p3% %p4% %p5% B00000~6%p6%       B00000~6%p7%
%1 %2 %p3% %p4% %p5% B00000~7%p6%       B00000~7%p7%
%1 %2 %p3% %p4% %p5% B00000~8%p6%       B00000~8%p7%
%1 %2 %p3% %p4% %p5% B00000~9%p6%       B00000~9%p7%
%1 %2 %p3% %p4% %p5% BACKGR~1%p6%       BACKGR~1%p7%
%1 %2 %p3% %p4% %p5% BAD5IL~1%p6%       BAD5IL~1%p7%
%1 %2 %p3% %p4% %p5% BAD6IL~1%p6%       BAD6IL~1%p7%
%1 %2 %p3% %p4% %p5% BAR5TT~1%p6%       BAR5TT~1%p7%
%1 %2 %p3% %p4% %p5% BAR6TT~1%p6%       BAR6TT~1%p7%
%1 %2 %p3% %p4% %p5% BARCOD~1%p6%       BARCOD~1%p7%
%1 %2 %p3% %p4% %p5% BATCH_~1%p6%       BATCH_~1%p7%
%1 %2 %p3% %p4% %p5% BBORON~1%p6%       BBORON~1%p7%
%1 %2 %p3% %p4% %p5% BCFEXE~1%p6%       BCFEXE~1%p7%
%1 %2 %p3% %p4% %p5% BER5TT~1%p6%       BER5TT~1%p7%
%1 %2 %p3% %p4% %p5% BER6TT~1%p6%       BER6TT~1%p7%
%1 %2 %p3% %p4% %p5% BLA5KA~1%p6%       BLA5KA~1%p7%
%1 %2 %p3% %p4% %p5% BLA6KA~1%p6%       BLA6KA~1%p7%
%1 %2 %p3% %p4% %p5% BLACKA~1%p6%       BLACKA~1%p7%
%1 %2 %p3% %p4% %p5% BLUE_O~1%p6%       BLUE_O~1%p7%
%1 %2 %p3% %p4% %p5% BLURST~1%p6%       BLURST~1%p7%
%1 %2 %p3% %p4% %p5% BMP1ST~1%p6%       BMP1ST~1%p7%
%1 %2 %p3% %p4% %p5% BONZAI~1%p6%       BONZAI~1%p7%
%1 %2 %p3% %p4% %p5% BOO6WA~1%p6%       BOO6WA~1%p7%
%1 %2 %p3% %p4% %p5% BOR59T~1%p6%       BOR59T~1%p7%
%1 %2 %p3% %p4% %p5% BOR69T~1%p6%       BOR69T~1%p7%
%1 %2 %p3% %p4% %p5% BOX_TI~1%p6%       BOX_TI~1%p7%
%1 %2 %p3% %p4% %p5% BOX_TI~2%p6%       BOX_TI~2%p7%
%1 %2 %p3% %p4% %p5% BTTSOI~1%p6%       BTTSOI~1%p7%
%1 %2 %p3% %p4% %p5% BUC5AN~1%p6%       BUC5AN~1%p7%
%1 %2 %p3% %p4% %p5% BUC6AN~1%p6%       BUC6AN~1%p7%
%1 %2 %p3% %p4% %p5% BUGSRE~1%p6%       BUGSRE~1%p7%
%1 %2 %p3% %p4% %p5% BUGSUB~1%p6%       BUGSUB~1%p7%
%1 %2 %p3% %p4% %p5% BULLET~1%p6%       BULLET~1%p7%
%1 %2 %p3% %p4% %p5% BUMPED~1%p6%       BUMPED~1%p7%
%1 %2 %p3% %p4% %p5% BUTTON~1%p6%       BUTTON~1%p7%
%1 %2 %p3% %p4% %p5% C0000~10%p6%       C0000~10%p7%
%1 %2 %p3% %p4% %p5% C0000~11%p6%       C0000~11%p7%
%1 %2 %p3% %p4% %p5% C0000~12%p6%       C0000~12%p7%
%1 %2 %p3% %p4% %p5% C0000~13%p6%       C0000~13%p7%
%1 %2 %p3% %p4% %p5% C0000~14%p6%       C0000~14%p7%
%1 %2 %p3% %p4% %p5% C0000~15%p6%       C0000~15%p7%
%1 %2 %p3% %p4% %p5% C0000~16%p6%       C0000~16%p7%
%1 %2 %p3% %p4% %p5% C0000~17%p6%       C0000~17%p7%
%1 %2 %p3% %p4% %p5% C0000~18%p6%       C0000~18%p7%
%1 %2 %p3% %p4% %p5% C00000~1%p6%       C00000~1%p7%
%1 %2 %p3% %p4% %p5% C00000~2%p6%       C00000~2%p7%
%1 %2 %p3% %p4% %p5% C00000~3%p6%       C00000~3%p7%
%1 %2 %p3% %p4% %p5% C00000~4%p6%       C00000~4%p7%
%1 %2 %p3% %p4% %p5% C00000~5%p6%       C00000~5%p7%
%1 %2 %p3% %p4% %p5% C00000~6%p6%       C00000~6%p7%
%1 %2 %p3% %p4% %p5% C00000~7%p6%       C00000~7%p7%
%1 %2 %p3% %p4% %p5% C00000~8%p6%       C00000~8%p7%
%1 %2 %p3% %p4% %p5% C00000~9%p6%       C00000~9%p7%
%1 %2 %p3% %p4% %p5% CAMBIO~1%p6%       CAMBIO~1%p7%
%1 %2 %p3% %p4% %p5% CEL5IC~1%p6%       CEL5IC~1%p7%
%1 %2 %p3% %p4% %p5% CEL6IC~1%p6%       CEL6IC~1%p7%
%1 %2 %p3% %p4% %p5% CHANGE~1%p6%       CHANGE~1%p7%
%1 %2 %p3% %p4% %p5% CHANGE~2%p6%       CHANGE~2%p7%
%1 %2 %p3% %p4% %p5% CHANGE~3%p6%       CHANGE~3%p7%
%1 %2 %p3% %p4% %p5% CHARAC~1%p6%       CHARAC~1%p7%
%1 %2 %p3% %p4% %p5% CHARSG~1%p6%       CHARSG~1%p7%
%1 %2 %p3% %p4% %p5% CHECK1~1%p6%       CHECK1~1%p7%
%1 %2 %p3% %p4% %p5% CHECK3~1%p6%       CHECK3~1%p7%
%1 %2 %p3% %p4% %p5% CHOAKD~1%p6%       CHOAKD~1%p7%
%1 %2 %p3% %p4% %p5% CHRIST~1%p6%       CHRIST~1%p7%
%1 %2 %p3% %p4% %p5% CHRIST~2%p6%       CHRIST~2%p7%
%1 %2 %p3% %p4% %p5% CLI5KM~1%p6%       CLI5KM~1%p7%
%1 %2 %p3% %p4% %p5% CLI6KM~1%p6%       CLI6KM~1%p7%
%1 %2 %p3% %p4% %p5% CODONT~1%p6%       CODONT~1%p7%
%1 %2 %p3% %p4% %p5% COI5ED~1%p6%       COI5ED~1%p7%
%1 %2 %p3% %p4% %p5% COI6ED~1%p6%       COI6ED~1%p7%
%1 %2 %p3% %p4% %p5% COLOPH~1%p6%       COLOPH~1%p7%
%1 %2 %p3% %p4% %p5% COMBN_~1%p6%       COMBN_~1%p7%
%1 %2 %p3% %p4% %p5% COMBN_~2%p6%       COMBN_~2%p7%
%1 %2 %p3% %p4% %p5% COMBN_~3%p6%       COMBN_~3%p7%
%1 %2 %p3% %p4% %p5% COMBNS~1%p6%       COMBNS~1%p7%
%1 %2 %p3% %p4% %p5% COMBNS~2%p6%       COMBNS~2%p7%
%1 %2 %p3% %p4% %p5% COMBNS~3%p6%       COMBNS~3%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG~1%p7%
%1 %2 %p3% %p4% %p5% CONSTA~1%p6%       CONSTA~1%p7%
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       CONTEN~1%p7%
%1 %2 %p3% %p4% %p5% CONTEN~2%p6%       CONTEN~2%p7%
%1 %2 %p3% %p4% %p5% COREC0~1%p6%       COREC0~1%p7%
%1 %2 %p3% %p4% %p5% COREC1~1%p6%       COREC1~1%p7%
%1 %2 %p3% %p4% %p5% COREC2~1%p6%       COREC2~1%p7%
%1 %2 %p3% %p4% %p5% COREC3~1%p6%       COREC3~1%p7%
%1 %2 %p3% %p4% %p5% COREC4~1%p6%       COREC4~1%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECO~1%p7%
%1 %2 %p3% %p4% %p5% COSINE~1%p6%       COSINE~1%p7%
%1 %2 %p3% %p4% %p5% COVERG~1%p6%       COVERG~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D0~1%p6%       CTL3D0~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D1~1%p6%       CTL3D1~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D2~1%p6%       CTL3D2~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D3~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~2%p6%       CTL3D3~2%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~1%p6%       CTL3D4~1%p7%
%1 %2 %p3% %p4% %p5% CUN5IF~1%p6%       CUN5IF~1%p7%
%1 %2 %p3% %p4% %p5% CUN6IF~1%p6%       CUN6IF~1%p7%
%1 %2 %p3% %p4% %p5% CW3215~1%p6%       CW3215~1%p7%
%1 %2 %p3% %p4% %p5% CWISDO~1%p6%       CWISDO~1%p7%
%1 %2 %p3% %p4% %p5% D0000~10%p6%       D0000~10%p7%
%1 %2 %p3% %p4% %p5% D0000~11%p6%       D0000~11%p7%
%1 %2 %p3% %p4% %p5% D0000~12%p6%       D0000~12%p7%
%1 %2 %p3% %p4% %p5% D0000~13%p6%       D0000~13%p7%
%1 %2 %p3% %p4% %p5% D0000~14%p6%       D0000~14%p7%
%1 %2 %p3% %p4% %p5% D0000~15%p6%       D0000~15%p7%
%1 %2 %p3% %p4% %p5% D0000~16%p6%       D0000~16%p7%
%1 %2 %p3% %p4% %p5% D0000~17%p6%       D0000~17%p7%
%1 %2 %p3% %p4% %p5% D0000~18%p6%       D0000~18%p7%
%1 %2 %p3% %p4% %p5% D0000~19%p6%       D0000~19%p7%
%1 %2 %p3% %p4% %p5% D0000~20%p6%       D0000~20%p7%
%1 %2 %p3% %p4% %p5% D0000~21%p6%       D0000~21%p7%
%1 %2 %p3% %p4% %p5% D0000~22%p6%       D0000~22%p7%
%1 %2 %p3% %p4% %p5% D0000~23%p6%       D0000~23%p7%
%1 %2 %p3% %p4% %p5% D0000~24%p6%       D0000~24%p7%
%1 %2 %p3% %p4% %p5% D0000~25%p6%       D0000~25%p7%
%1 %2 %p3% %p4% %p5% D0000~26%p6%       D0000~26%p7%
%1 %2 %p3% %p4% %p5% D0000~27%p6%       D0000~27%p7%
%1 %2 %p3% %p4% %p5% D0000~28%p6%       D0000~28%p7%
%1 %2 %p3% %p4% %p5% D0000~29%p6%       D0000~29%p7%
%1 %2 %p3% %p4% %p5% D0000~30%p6%       D0000~30%p7%
%1 %2 %p3% %p4% %p5% D0000~31%p6%       D0000~31%p7%
%1 %2 %p3% %p4% %p5% D0000~32%p6%       D0000~32%p7%
%1 %2 %p3% %p4% %p5% D0000~33%p6%       D0000~33%p7%
%1 %2 %p3% %p4% %p5% D0000~34%p6%       D0000~34%p7%
%1 %2 %p3% %p4% %p5% D0000~35%p6%       D0000~35%p7%
%1 %2 %p3% %p4% %p5% D0000~36%p6%       D0000~36%p7%
%1 %2 %p3% %p4% %p5% D0000~37%p6%       D0000~37%p7%
%1 %2 %p3% %p4% %p5% D0000~38%p6%       D0000~38%p7%
%1 %2 %p3% %p4% %p5% D0000~39%p6%       D0000~39%p7%
%1 %2 %p3% %p4% %p5% D0000~40%p6%       D0000~40%p7%
%1 %2 %p3% %p4% %p5% D0000~41%p6%       D0000~41%p7%
%1 %2 %p3% %p4% %p5% D0000~42%p6%       D0000~42%p7%
%1 %2 %p3% %p4% %p5% D0000~43%p6%       D0000~43%p7%
%1 %2 %p3% %p4% %p5% D0000~44%p6%       D0000~44%p7%
%1 %2 %p3% %p4% %p5% D00000~1%p6%       D00000~1%p7%
%1 %2 %p3% %p4% %p5% D00000~2%p6%       D00000~2%p7%
%1 %2 %p3% %p4% %p5% D00000~3%p6%       D00000~3%p7%
%1 %2 %p3% %p4% %p5% D00000~4%p6%       D00000~4%p7%
%1 %2 %p3% %p4% %p5% D00000~5%p6%       D00000~5%p7%
%1 %2 %p3% %p4% %p5% D00000~6%p6%       D00000~6%p7%
%1 %2 %p3% %p4% %p5% D00000~7%p6%       D00000~7%p7%
%1 %2 %p3% %p4% %p5% D00000~8%p6%       D00000~8%p7%
%1 %2 %p3% %p4% %p5% D00000~9%p6%       D00000~9%p7%
%1 %2 %p3% %p4% %p5% DARK1S~1%p6%       DARK1S~1%p7%
%1 %2 %p3% %p4% %p5% DATATA~1%p6%       DATATA~1%p7%
%1 %2 %p3% %p4% %p5% DAVIST~1%p6%       DAVIST~1%p7%
%1 %2 %p3% %p4% %p5% DELPRG~1%p6%       DELPRG~1%p7%
%1 %2 %p3% %p4% %p5% DELPRG~2%p6%       DELPRG~2%p7%
%1 %2 %p3% %p4% %p5% DELPRG~3%p6%       DELPRG~3%p7%
%1 %2 %p3% %p4% %p5% DINGBA~1%p6%       DINGBA~1%p7%
%1 %2 %p3% %p4% %p5% DISK1_~1%p6%       DISK1_~1%p7%
%1 %2 %p3% %p4% %p5% DISK1_~2%p6%       DISK1_~2%p7%
%1 %2 %p3% %p4% %p5% DISK1_~3%p6%       DISK1_~3%p7%
%1 %2 %p3% %p4% %p5% DISK1_~4%p6%       DISK1_~4%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1I~1%p7%
%1 %2 %p3% %p4% %p5% DISTTF~1%p6%       DISTTF~1%p7%
%1 %2 %p3% %p4% %p5% DLGIM0~1%p6%       DLGIM0~1%p7%
%1 %2 %p3% %p4% %p5% DLGIM2~1%p6%       DLGIM2~1%p7%
%1 %2 %p3% %p4% %p5% DLGIM4~1%p6%       DLGIM4~1%p7%
%1 %2 %p3% %p4% %p5% DOC5ME~1%p6%       DOC5ME~1%p7%
%1 %2 %p3% %p4% %p5% DOCTOR~1%p6%       DOCTOR~1%p7%
%1 %2 %p3% %p4% %p5% DONNER~1%p6%       DONNER~1%p7%
%1 %2 %p3% %p4% %p5% DOR5LA~1%p6%       DOR5LA~1%p7%
%1 %2 %p3% %p4% %p5% DOR6LA~1%p6%       DOR6LA~1%p7%
%1 %2 %p3% %p4% %p5% DOUBLE~1%p6%       DOUBLE~1%p7%
%1 %2 %p3% %p4% %p5% DOVEST~1%p6%       DOVEST~1%p7%
%1 %2 %p3% %p4% %p5% DROPSH~1%p6%       DROPSH~1%p7%
%1 %2 %p3% %p4% %p5% DUE5TT~1%p6%       DUE5TT~1%p7%
%1 %2 %p3% %p4% %p5% DUE6TT~1%p6%       DUE6TT~1%p7%
%1 %2 %p3% %p4% %p5% DWORRY~1%p6%       DWORRY~1%p7%
%1 %2 %p3% %p4% %p5% DYSPRO~1%p6%       DYSPRO~1%p7%
%1 %2 %p3% %p4% %p5% E0000~10%p6%       E0000~10%p7%
%1 %2 %p3% %p4% %p5% E0000~11%p6%       E0000~11%p7%
%1 %2 %p3% %p4% %p5% E0000~12%p6%       E0000~12%p7%
%1 %2 %p3% %p4% %p5% E0000~13%p6%       E0000~13%p7%
%1 %2 %p3% %p4% %p5% E0000~14%p6%       E0000~14%p7%
%1 %2 %p3% %p4% %p5% E0000~15%p6%       E0000~15%p7%
%1 %2 %p3% %p4% %p5% E0000~16%p6%       E0000~16%p7%
%1 %2 %p3% %p4% %p5% E0000~17%p6%       E0000~17%p7%
%1 %2 %p3% %p4% %p5% E0000~18%p6%       E0000~18%p7%
%1 %2 %p3% %p4% %p5% E0000~19%p6%       E0000~19%p7%
%1 %2 %p3% %p4% %p5% E00000~1%p6%       E00000~1%p7%
%1 %2 %p3% %p4% %p5% E00000~2%p6%       E00000~2%p7%
%1 %2 %p3% %p4% %p5% E00000~3%p6%       E00000~3%p7%
%1 %2 %p3% %p4% %p5% E00000~4%p6%       E00000~4%p7%
%1 %2 %p3% %p4% %p5% E00000~5%p6%       E00000~5%p7%
%1 %2 %p3% %p4% %p5% E00000~6%p6%       E00000~6%p7%
%1 %2 %p3% %p4% %p5% E00000~7%p6%       E00000~7%p7%
%1 %2 %p3% %p4% %p5% E00000~8%p6%       E00000~8%p7%
%1 %2 %p3% %p4% %p5% E00000~9%p6%       E00000~9%p7%
%1 %2 %p3% %p4% %p5% EAN-13~1%p6%       EAN-13~1%p7%
%1 %2 %p3% %p4% %p5% EAN-13~2%p6%       EAN-13~2%p7%
%1 %2 %p3% %p4% %p5% EAN-13~3%p6%       EAN-13~3%p7%
%1 %2 %p3% %p4% %p5% EAN-13~4%p6%       EAN-13~4%p7%
%1 %2 %p3% %p4% %p5% EAN13D~1%p6%       EAN13D~1%p7%
%1 %2 %p3% %p4% %p5% EDGEGI~1%p6%       EDGEGI~1%p7%
%1 %2 %p3% %p4% %p5% EDIT_S~1%p6%       EDIT_S~1%p7%
%1 %2 %p3% %p4% %p5% ELDER4~1%p6%       ELDER4~1%p7%
%1 %2 %p3% %p4% %p5% EPILOG~1%p6%       EPILOG~1%p7%
%1 %2 %p3% %p4% %p5% ESPDLL~1%p6%       ESPDLL~1%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~1%p6%       EXAMPL~1%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~2%p6%       EXAMPL~2%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~3%p6%       EXAMPL~3%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~4%p6%       EXAMPL~4%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~5%p6%       EXAMPL~5%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~6%p6%       EXAMPL~6%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~7%p6%       EXAMPL~7%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~8%p6%       EXAMPL~8%p7%
%1 %2 %p3% %p4% %p5% EXMONO~1%p6%       EXMONO~1%p7%
%1 %2 %p3% %p4% %p5% F0000~10%p6%       F0000~10%p7%
%1 %2 %p3% %p4% %p5% F0000~11%p6%       F0000~11%p7%
%1 %2 %p3% %p4% %p5% F0000~12%p6%       F0000~12%p7%
%1 %2 %p3% %p4% %p5% F0000~13%p6%       F0000~13%p7%
%1 %2 %p3% %p4% %p5% F0000~14%p6%       F0000~14%p7%
%1 %2 %p3% %p4% %p5% F0000~15%p6%       F0000~15%p7%
%1 %2 %p3% %p4% %p5% F0000~16%p6%       F0000~16%p7%
%1 %2 %p3% %p4% %p5% F0000~17%p6%       F0000~17%p7%
%1 %2 %p3% %p4% %p5% F0000~18%p6%       F0000~18%p7%
%1 %2 %p3% %p4% %p5% F0000~19%p6%       F0000~19%p7%
%1 %2 %p3% %p4% %p5% F00000~1%p6%       F00000~1%p7%
%1 %2 %p3% %p4% %p5% F00000~2%p6%       F00000~2%p7%
%1 %2 %p3% %p4% %p5% F00000~3%p6%       F00000~3%p7%
%1 %2 %p3% %p4% %p5% F00000~4%p6%       F00000~4%p7%
%1 %2 %p3% %p4% %p5% F00000~5%p6%       F00000~5%p7%
%1 %2 %p3% %p4% %p5% F00000~6%p6%       F00000~6%p7%
%1 %2 %p3% %p4% %p5% F00000~7%p6%       F00000~7%p7%
%1 %2 %p3% %p4% %p5% F00000~8%p6%       F00000~8%p7%
%1 %2 %p3% %p4% %p5% F00000~9%p6%       F00000~9%p7%
%1 %2 %p3% %p4% %p5% FARADA~1%p6%       FARADA~1%p7%
%1 %2 %p3% %p4% %p5% FC11BM~1%p6%       FC11BM~1%p7%
%1 %2 %p3% %p4% %p5% FCP3EX~1%p6%       FCP3EX~1%p7%
%1 %2 %p3% %p4% %p5% FDFDFD~1%p6%       FDFDFD~1%p7%
%1 %2 %p3% %p4% %p5% FILE_~10%p6%       FILE_~10%p7%
%1 %2 %p3% %p4% %p5% FILE_~11%p6%       FILE_~11%p7%
%1 %2 %p3% %p4% %p5% FILE_~12%p6%       FILE_~12%p7%
%1 %2 %p3% %p4% %p5% FILE_~13%p6%       FILE_~13%p7%
%1 %2 %p3% %p4% %p5% FILE_~14%p6%       FILE_~14%p7%
%1 %2 %p3% %p4% %p5% FILE_~15%p6%       FILE_~15%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_I~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_I~3%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_I~4%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_I~5%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_I~6%p7%
%1 %2 %p3% %p4% %p5% FILE_I~7%p6%       FILE_I~7%p7%
%1 %2 %p3% %p4% %p5% FILE_I~8%p6%       FILE_I~8%p7%
%1 %2 %p3% %p4% %p5% FILE_I~9%p6%       FILE_I~9%p7%
%1 %2 %p3% %p4% %p5% FILEDE~1%p6%       FILEDE~1%p7%
%1 %2 %p3% %p4% %p5% FMDLLD~1%p6%       FMDLLD~1%p7%
%1 %2 %p3% %p4% %p5% FMHLP~1%p6%        FMHLP~1%p7%
%1 %2 %p3% %p4% %p5% FN238I~1%p6%       FN238I~1%p7%
%1 %2 %p3% %p4% %p5% FOG_LI~1%p6%       FOG_LI~1%p7%
%1 %2 %p3% %p4% %p5% FOG2ST~1%p6%       FOG2ST~1%p7%
%1 %2 %p3% %p4% %p5% FON5RA~1%p6%       FON5RA~1%p7%
%1 %2 %p3% %p4% %p5% FON6RA~1%p6%       FON6RA~1%p7%
%1 %2 %p3% %p4% %p5% FON6RA~2%p6%       FON6RA~2%p7%
%1 %2 %p3% %p4% %p5% FON6RA~3%p6%       FON6RA~3%p7%
%1 %2 %p3% %p4% %p5% FONT7R~1%p6%       FONT7R~1%p7%
%1 %2 %p3% %p4% %p5% FONT7R~2%p6%       FONT7R~2%p7%
%1 %2 %p3% %p4% %p5% FONT7R~3%p6%       FONT7R~3%p7%
%1 %2 %p3% %p4% %p5% FONT7R~4%p6%       FONT7R~4%p7%
%1 %2 %p3% %p4% %p5% FONT8A~1%p6%       FONT8A~1%p7%
%1 %2 %p3% %p4% %p5% FONTCE~1%p6%       FONTCE~1%p7%
%1 %2 %p3% %p4% %p5% FONTCO~1%p6%       FONTCO~1%p7%
%1 %2 %p3% %p4% %p5% FONTCO~2%p6%       FONTCO~2%p7%
%1 %2 %p3% %p4% %p5% FONTCP~1%p6%       FONTCP~1%p7%
%1 %2 %p3% %p4% %p5% FONTDR~1%p6%       FONTDR~1%p7%
%1 %2 %p3% %p4% %p5% FONTEX~1%p6%       FONTEX~1%p7%
%1 %2 %p3% %p4% %p5% FONTEX~2%p6%       FONTEX~2%p7%
%1 %2 %p3% %p4% %p5% FONTEX~3%p6%       FONTEX~3%p7%
%1 %2 %p3% %p4% %p5% FONTEX~4%p6%       FONTEX~4%p7%
%1 %2 %p3% %p4% %p5% FONTFI~1%p6%       FONTFI~1%p7%
%1 %2 %p3% %p4% %p5% FONTIM~1%p6%       FONTIM~1%p7%
%1 %2 %p3% %p4% %p5% FONTIM~2%p6%       FONTIM~2%p7%
%1 %2 %p3% %p4% %p5% FONTLI~1%p6%       FONTLI~1%p7%
%1 %2 %p3% %p4% %p5% FONTLI~2%p6%       FONTLI~2%p7%
%1 %2 %p3% %p4% %p5% FONTLI~3%p6%       FONTLI~3%p7%
%1 %2 %p3% %p4% %p5% FONTPE~1%p6%       FONTPE~1%p7%
%1 %2 %p3% %p4% %p5% FONTR2~1%p6%       FONTR2~1%p7%
%1 %2 %p3% %p4% %p5% FONTRA~1%p6%       FONTRA~1%p7%
%1 %2 %p3% %p4% %p5% FONTRA~2%p6%       FONTRA~2%p7%
%1 %2 %p3% %p4% %p5% FONTT3~1%p6%       FONTT3~1%p7%
%1 %2 %p3% %p4% %p5% FONTVI~1%p6%       FONTVI~1%p7%
%1 %2 %p3% %p4% %p5% FRESNE~1%p6%       FRESNE~1%p7%
%1 %2 %p3% %p4% %p5% FRIDAY~1%p6%       FRIDAY~1%p7%
%1 %2 %p3% %p4% %p5% FT2070~1%p6%       FT2070~1%p7%
%1 %2 %p3% %p4% %p5% FUNFON~1%p6%       FUNFON~1%p7%
%1 %2 %p3% %p4% %p5% G_RGIF~1%p6%       G_RGIF~1%p7%
%1 %2 %p3% %p4% %p5% G0000~10%p6%       G0000~10%p7%
%1 %2 %p3% %p4% %p5% G0000~11%p6%       G0000~11%p7%
%1 %2 %p3% %p4% %p5% G0000~12%p6%       G0000~12%p7%
%1 %2 %p3% %p4% %p5% G0000~13%p6%       G0000~13%p7%
%1 %2 %p3% %p4% %p5% G0000~14%p6%       G0000~14%p7%
%1 %2 %p3% %p4% %p5% G0000~15%p6%       G0000~15%p7%
%1 %2 %p3% %p4% %p5% G0000~16%p6%       G0000~16%p7%
%1 %2 %p3% %p4% %p5% G0000~17%p6%       G0000~17%p7%
%1 %2 %p3% %p4% %p5% G0000~18%p6%       G0000~18%p7%
%1 %2 %p3% %p4% %p5% G0000~19%p6%       G0000~19%p7%
%1 %2 %p3% %p4% %p5% G0000~20%p6%       G0000~20%p7%
%1 %2 %p3% %p4% %p5% G00000~1%p6%       G00000~1%p7%
%1 %2 %p3% %p4% %p5% G00000~2%p6%       G00000~2%p7%
%1 %2 %p3% %p4% %p5% G00000~3%p6%       G00000~3%p7%
%1 %2 %p3% %p4% %p5% G00000~4%p6%       G00000~4%p7%
%1 %2 %p3% %p4% %p5% G00000~5%p6%       G00000~5%p7%
%1 %2 %p3% %p4% %p5% G00000~6%p6%       G00000~6%p7%
%1 %2 %p3% %p4% %p5% G00000~7%p6%       G00000~7%p7%
%1 %2 %p3% %p4% %p5% G00000~8%p6%       G00000~8%p7%
%1 %2 %p3% %p4% %p5% G00000~9%p6%       G00000~9%p7%
%1 %2 %p3% %p4% %p5% GEBANN~1%p6%       GEBANN~1%p7%
%1 %2 %p3% %p4% %p5% GECLIP~1%p6%       GECLIP~1%p7%
%1 %2 %p3% %p4% %p5% GECOME~1%p6%       GECOME~1%p7%
%1 %2 %p3% %p4% %p5% GECURV~1%p6%       GECURV~1%p7%
%1 %2 %p3% %p4% %p5% GEELS_~1%p6%       GEELS_~1%p7%
%1 %2 %p3% %p4% %p5% GEFIM_~1%p6%       GEFIM_~1%p7%
%1 %2 %p3% %p4% %p5% GEFLEE~1%p6%       GEFLEE~1%p7%
%1 %2 %p3% %p4% %p5% GEFRF_~1%p6%       GEFRF_~1%p7%
%1 %2 %p3% %p4% %p5% GEFRIL~1%p6%       GEFRIL~1%p7%
%1 %2 %p3% %p4% %p5% GEGLOB~1%p6%       GEGLOB~1%p7%
%1 %2 %p3% %p4% %p5% GEHAS_~1%p6%       GEHAS_~1%p7%
%1 %2 %p3% %p4% %p5% GEMONT~1%p6%       GEMONT~1%p7%
%1 %2 %p3% %p4% %p5% GENET_~1%p6%       GENET_~1%p7%
%1 %2 %p3% %p4% %p5% GEODES~1%p6%       GEODES~1%p7%
%1 %2 %p3% %p4% %p5% GERMST~1%p6%       GERMST~1%p7%
%1 %2 %p3% %p4% %p5% GEROMA~1%p6%       GEROMA~1%p7%
%1 %2 %p3% %p4% %p5% GESHS_~1%p6%       GESHS_~1%p7%
%1 %2 %p3% %p4% %p5% GETTIN~1%p6%       GETTIN~1%p7%
%1 %2 %p3% %p4% %p5% GMTTTF~1%p6%       GMTTTF~1%p7%
%1 %2 %p3% %p4% %p5% GOLDAN~1%p6%       GOLDAN~1%p7%
%1 %2 %p3% %p4% %p5% GOLDST~1%p6%       GOLDST~1%p7%
%1 %2 %p3% %p4% %p5% GOODMO~1%p6%       GOODMO~1%p7%
%1 %2 %p3% %p4% %p5% GRADAT~1%p6%       GRADAT~1%p7%
%1 %2 %p3% %p4% %p5% GRASSS~1%p6%       GRASSS~1%p7%
%1 %2 %p3% %p4% %p5% GREENG~1%p6%       GREENG~1%p7%
%1 %2 %p3% %p4% %p5% GUIDET~1%p6%       GUIDET~1%p7%
%1 %2 %p3% %p4% %p5% GUILDO~1%p6%       GUILDO~1%p7%
%1 %2 %p3% %p4% %p5% GWP5EB~1%p6%       GWP5EB~1%p7%
%1 %2 %p3% %p4% %p5% H0000~10%p6%       H0000~10%p7%
%1 %2 %p3% %p4% %p5% H0000~11%p6%       H0000~11%p7%
%1 %2 %p3% %p4% %p5% H0000~12%p6%       H0000~12%p7%
%1 %2 %p3% %p4% %p5% H0000~13%p6%       H0000~13%p7%
%1 %2 %p3% %p4% %p5% H0000~14%p6%       H0000~14%p7%
%1 %2 %p3% %p4% %p5% H0000~15%p6%       H0000~15%p7%
%1 %2 %p3% %p4% %p5% H0000~16%p6%       H0000~16%p7%
%1 %2 %p3% %p4% %p5% H0000~17%p6%       H0000~17%p7%
%1 %2 %p3% %p4% %p5% H0000~18%p6%       H0000~18%p7%
%1 %2 %p3% %p4% %p5% H0000~19%p6%       H0000~19%p7%
%1 %2 %p3% %p4% %p5% H0000~20%p6%       H0000~20%p7%
%1 %2 %p3% %p4% %p5% H0000~21%p6%       H0000~21%p7%
%1 %2 %p3% %p4% %p5% H0000~22%p6%       H0000~22%p7%
%1 %2 %p3% %p4% %p5% H0000~23%p6%       H0000~23%p7%
%1 %2 %p3% %p4% %p5% H0000~24%p6%       H0000~24%p7%
%1 %2 %p3% %p4% %p5% H0000~25%p6%       H0000~25%p7%
%1 %2 %p3% %p4% %p5% H0000~26%p6%       H0000~26%p7%
%1 %2 %p3% %p4% %p5% H0000~27%p6%       H0000~27%p7%
%1 %2 %p3% %p4% %p5% H0000~28%p6%       H0000~28%p7%
%1 %2 %p3% %p4% %p5% H0000~29%p6%       H0000~29%p7%
%1 %2 %p3% %p4% %p5% H0000~30%p6%       H0000~30%p7%
%1 %2 %p3% %p4% %p5% H0000~31%p6%       H0000~31%p7%
%1 %2 %p3% %p4% %p5% H0000~32%p6%       H0000~32%p7%
%1 %2 %p3% %p4% %p5% H0000~33%p6%       H0000~33%p7%
%1 %2 %p3% %p4% %p5% H0000~34%p6%       H0000~34%p7%
%1 %2 %p3% %p4% %p5% H0000~35%p6%       H0000~35%p7%
%1 %2 %p3% %p4% %p5% H0000~36%p6%       H0000~36%p7%
%1 %2 %p3% %p4% %p5% H0000~37%p6%       H0000~37%p7%
%1 %2 %p3% %p4% %p5% H0000~38%p6%       H0000~38%p7%
%1 %2 %p3% %p4% %p5% H0000~39%p6%       H0000~39%p7%
%1 %2 %p3% %p4% %p5% H0000~40%p6%       H0000~40%p7%
%1 %2 %p3% %p4% %p5% H0000~41%p6%       H0000~41%p7%
%1 %2 %p3% %p4% %p5% H0000~42%p6%       H0000~42%p7%
%1 %2 %p3% %p4% %p5% H0000~43%p6%       H0000~43%p7%
%1 %2 %p3% %p4% %p5% H0000~44%p6%       H0000~44%p7%
%1 %2 %p3% %p4% %p5% H0000~45%p6%       H0000~45%p7%
%1 %2 %p3% %p4% %p5% H0000~46%p6%       H0000~46%p7%
%1 %2 %p3% %p4% %p5% H0000~47%p6%       H0000~47%p7%
%1 %2 %p3% %p4% %p5% H0000~48%p6%       H0000~48%p7%
%1 %2 %p3% %p4% %p5% H0000~49%p6%       H0000~49%p7%
%1 %2 %p3% %p4% %p5% H0000~50%p6%       H0000~50%p7%
%1 %2 %p3% %p4% %p5% H0000~51%p6%       H0000~51%p7%
%1 %2 %p3% %p4% %p5% H0000~52%p6%       H0000~52%p7%
%1 %2 %p3% %p4% %p5% H0000~53%p6%       H0000~53%p7%
%1 %2 %p3% %p4% %p5% H0000~54%p6%       H0000~54%p7%
%1 %2 %p3% %p4% %p5% H0000~55%p6%       H0000~55%p7%
%1 %2 %p3% %p4% %p5% H0000~56%p6%       H0000~56%p7%
%1 %2 %p3% %p4% %p5% H0000~57%p6%       H0000~57%p7%
%1 %2 %p3% %p4% %p5% H0000~58%p6%       H0000~58%p7%
%1 %2 %p3% %p4% %p5% H0000~59%p6%       H0000~59%p7%
%1 %2 %p3% %p4% %p5% H0000~60%p6%       H0000~60%p7%
%1 %2 %p3% %p4% %p5% H0000~61%p6%       H0000~61%p7%
%1 %2 %p3% %p4% %p5% H0000~62%p6%       H0000~62%p7%
%1 %2 %p3% %p4% %p5% H0000~63%p6%       H0000~63%p7%
%1 %2 %p3% %p4% %p5% H0000~64%p6%       H0000~64%p7%
%1 %2 %p3% %p4% %p5% H0000~65%p6%       H0000~65%p7%
%1 %2 %p3% %p4% %p5% H0000~66%p6%       H0000~66%p7%
%1 %2 %p3% %p4% %p5% H0000~67%p6%       H0000~67%p7%
%1 %2 %p3% %p4% %p5% H0000~68%p6%       H0000~68%p7%
%1 %2 %p3% %p4% %p5% H0000~69%p6%       H0000~69%p7%
%1 %2 %p3% %p4% %p5% H0000~70%p6%       H0000~70%p7%
%1 %2 %p3% %p4% %p5% H0000~71%p6%       H0000~71%p7%
%1 %2 %p3% %p4% %p5% H0000~72%p6%       H0000~72%p7%
%1 %2 %p3% %p4% %p5% H0000~73%p6%       H0000~73%p7%
%1 %2 %p3% %p4% %p5% H0000~74%p6%       H0000~74%p7%
%1 %2 %p3% %p4% %p5% H0000~75%p6%       H0000~75%p7%
%1 %2 %p3% %p4% %p5% H0000~76%p6%       H0000~76%p7%
%1 %2 %p3% %p4% %p5% H0000~77%p6%       H0000~77%p7%
%1 %2 %p3% %p4% %p5% H0000~78%p6%       H0000~78%p7%
%1 %2 %p3% %p4% %p5% H0000~79%p6%       H0000~79%p7%
%1 %2 %p3% %p4% %p5% H0000~80%p6%       H0000~80%p7%
%1 %2 %p3% %p4% %p5% H0000~81%p6%       H0000~81%p7%
%1 %2 %p3% %p4% %p5% H0000~82%p6%       H0000~82%p7%
%1 %2 %p3% %p4% %p5% H0000~83%p6%       H0000~83%p7%
%1 %2 %p3% %p4% %p5% H0000~84%p6%       H0000~84%p7%
%1 %2 %p3% %p4% %p5% H0000~85%p6%       H0000~85%p7%
%1 %2 %p3% %p4% %p5% H0000~86%p6%       H0000~86%p7%
%1 %2 %p3% %p4% %p5% H0000~87%p6%       H0000~87%p7%
%1 %2 %p3% %p4% %p5% H00000~1%p6%       H00000~1%p7%
%1 %2 %p3% %p4% %p5% H00000~2%p6%       H00000~2%p7%
%1 %2 %p3% %p4% %p5% H00000~3%p6%       H00000~3%p7%
%1 %2 %p3% %p4% %p5% H00000~4%p6%       H00000~4%p7%
%1 %2 %p3% %p4% %p5% H00000~5%p6%       H00000~5%p7%
%1 %2 %p3% %p4% %p5% H00000~6%p6%       H00000~6%p7%
%1 %2 %p3% %p4% %p5% H00000~7%p6%       H00000~7%p7%
%1 %2 %p3% %p4% %p5% H00000~8%p6%       H00000~8%p7%
%1 %2 %p3% %p4% %p5% H00000~9%p6%       H00000~9%p7%
%1 %2 %p3% %p4% %p5% HAN_PA~1%p6%       HAN_PA~1%p7%
%1 %2 %p3% %p4% %p5% HAYDEN~1%p6%       HAYDEN~1%p7%
%1 %2 %p3% %p4% %p5% HEADAC~1%p6%       HEADAC~1%p7%
%1 %2 %p3% %p4% %p5% HEADLI~1%p6%       HEADLI~1%p7%
%1 %2 %p3% %p4% %p5% HISTOR~1%p6%       HISTOR~1%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~1%p6%       HOMEBA~1%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~2%p6%       HOMEBA~2%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~3%p6%       HOMEBA~3%p7%
%1 %2 %p3% %p4% %p5% HOWTO_~1%p6%       HOWTO_~1%p7%
%1 %2 %p3% %p4% %p5% HTM50~10%p6%       HTM50~10%p7%
%1 %2 %p3% %p4% %p5% HTM50~11%p6%       HTM50~11%p7%
%1 %2 %p3% %p4% %p5% HTM50~12%p6%       HTM50~12%p7%
%1 %2 %p3% %p4% %p5% HTM50~13%p6%       HTM50~13%p7%
%1 %2 %p3% %p4% %p5% HTM50~14%p6%       HTM50~14%p7%
%1 %2 %p3% %p4% %p5% HTM50~15%p6%       HTM50~15%p7%
%1 %2 %p3% %p4% %p5% HTM50~16%p6%       HTM50~16%p7%
%1 %2 %p3% %p4% %p5% HTM50~17%p6%       HTM50~17%p7%
%1 %2 %p3% %p4% %p5% HTM500~1%p6%       HTM500~1%p7%
%1 %2 %p3% %p4% %p5% HTM500~2%p6%       HTM500~2%p7%
%1 %2 %p3% %p4% %p5% HTM500~3%p6%       HTM500~3%p7%
%1 %2 %p3% %p4% %p5% HTM500~4%p6%       HTM500~4%p7%
%1 %2 %p3% %p4% %p5% HTM500~5%p6%       HTM500~5%p7%
%1 %2 %p3% %p4% %p5% HTM500~6%p6%       HTM500~6%p7%
%1 %2 %p3% %p4% %p5% HTM500~7%p6%       HTM500~7%p7%
%1 %2 %p3% %p4% %p5% HTM500~8%p6%       HTM500~8%p7%
%1 %2 %p3% %p4% %p5% HTM500~9%p6%       HTM500~9%p7%
%1 %2 %p3% %p4% %p5% HYDROG~1%p6%       HYDROG~1%p7%
%1 %2 %p3% %p4% %p5% I2OF5N~1%p6%       I2OF5N~1%p7%
%1 %2 %p3% %p4% %p5% I2OF5T~1%p6%       I2OF5T~1%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~1%p6%       IC_JFO~1%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~2%p6%       IC_JFO~2%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~3%p6%       IC_JFO~3%p7%
%1 %2 %p3% %p4% %p5% ICON2S~1%p6%       ICON2S~1%p7%
%1 %2 %p3% %p4% %p5% ICON3D~1%p6%       ICON3D~1%p7%
%1 %2 %p3% %p4% %p5% ICON4D~1%p6%       ICON4D~1%p7%
%1 %2 %p3% %p4% %p5% ICON5D~1%p6%       ICON5D~1%p7%
%1 %2 %p3% %p4% %p5% ICON6D~1%p6%       ICON6D~1%p7%
%1 %2 %p3% %p4% %p5% ICONST~1%p6%       ICONST~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE~10%p6%       IMAGE~10%p7%
%1 %2 %p3% %p4% %p5% IMAGE~11%p6%       IMAGE~11%p7%
%1 %2 %p3% %p4% %p5% IMAGE~12%p6%       IMAGE~12%p7%
%1 %2 %p3% %p4% %p5% IMAGE~13%p6%       IMAGE~13%p7%
%1 %2 %p3% %p4% %p5% IMAGE~14%p6%       IMAGE~14%p7%
%1 %2 %p3% %p4% %p5% IMAGE~15%p6%       IMAGE~15%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~1%p6%       IMAGE1~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~2%p6%       IMAGE1~2%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~3%p6%       IMAGE1~3%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~4%p6%       IMAGE1~4%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~5%p6%       IMAGE1~5%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~6%p6%       IMAGE1~6%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~7%p6%       IMAGE1~7%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~8%p6%       IMAGE1~8%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~9%p6%       IMAGE1~9%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~1%p6%       IMAGE2~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~2%p6%       IMAGE2~2%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~3%p6%       IMAGE2~3%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~4%p6%       IMAGE2~4%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~5%p6%       IMAGE2~5%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~6%p6%       IMAGE2~6%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~7%p6%       IMAGE2~7%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~8%p6%       IMAGE2~8%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~9%p6%       IMAGE2~9%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~1%p6%       IMAGE3~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~2%p6%       IMAGE3~2%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~3%p6%       IMAGE3~3%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~4%p6%       IMAGE3~4%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~5%p6%       IMAGE3~5%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~6%p6%       IMAGE3~6%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~7%p6%       IMAGE3~7%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~8%p6%       IMAGE3~8%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~9%p6%       IMAGE3~9%p7%
%1 %2 %p3% %p4% %p5% IMAGE4~1%p6%       IMAGE4~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE5~1%p6%       IMAGE5~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE6~1%p6%       IMAGE6~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE7~1%p6%       IMAGE7~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE8~1%p6%       IMAGE8~1%p7%
%1 %2 %p3% %p4% %p5% IMAGE9~1%p6%       IMAGE9~1%p7%
%1 %2 %p3% %p4% %p5% IND5DR~1%p6%       IND5DR~1%p7%
%1 %2 %p3% %p4% %p5% INITIA~1%p6%       INITIA~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTAL~2%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTAL~3%p7%
%1 %2 %p3% %p4% %p5% INSTAL~4%p6%       INSTAL~4%p7%
%1 %2 %p3% %p4% %p5% INSTAL~5%p6%       INSTAL~5%p7%
%1 %2 %p3% %p4% %p5% INSTAL~6%p6%       INSTAL~6%p7%
%1 %2 %p3% %p4% %p5% ISUNIN~1%p6%       ISUNIN~1%p7%
%1 %2 %p3% %p4% %p5% JFONTE~1%p6%       JFONTE~1%p7%
%1 %2 %p3% %p4% %p5% JFONTJ~1%p6%       JFONTJ~1%p7%
%1 %2 %p3% %p4% %p5% JOBS32~1%p6%       JOBS32~1%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~1%p6%       JOBSPE~1%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~2%p6%       JOBSPE~2%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~3%p6%       JOBSPE~3%p7%
%1 %2 %p3% %p4% %p5% JSPEC4~1%p6%       JSPEC4~1%p7%
%1 %2 %p3% %p4% %p5% KANONT~1%p6%       KANONT~1%p7%
%1 %2 %p3% %p4% %p5% LANGDA~1%p6%       LANGDA~1%p7%
%1 %2 %p3% %p4% %p5% LAYOUT~1%p6%       LAYOUT~1%p7%
%1 %2 %p3% %p4% %p5% LEAFAN~1%p6%       LEAFAN~1%p7%
%1 %2 %p3% %p4% %p5% LEEMET~1%p6%       LEEMET~1%p7%
%1 %2 %p3% %p4% %p5% LEFTBA~1%p6%       LEFTBA~1%p7%
%1 %2 %p3% %p4% %p5% LEG5LD~1%p6%       LEG5LD~1%p7%
%1 %2 %p3% %p4% %p5% LEG6LD~1%p6%       LEG6LD~1%p7%
%1 %2 %p3% %p4% %p5% LEVITY~1%p6%       LEVITY~1%p7%
%1 %2 %p3% %p4% %p5% LEXOTT~1%p6%       LEXOTT~1%p7%
%1 %2 %p3% %p4% %p5% LIC5NS~1%p6%       LIC5NS~1%p7%
%1 %2 %p3% %p4% %p5% LIC6NS~1%p6%       LIC6NS~1%p7%
%1 %2 %p3% %p4% %p5% LICEN1~1%p6%       LICEN1~1%p7%
%1 %2 %p3% %p4% %p5% LICEN2~1%p6%       LICEN2~1%p7%
%1 %2 %p3% %p4% %p5% LICEN4~1%p6%       LICEN4~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       LICENS~3%p7%
%1 %2 %p3% %p4% %p5% LICENS~4%p6%       LICENS~4%p7%
%1 %2 %p3% %p4% %p5% LICENS~5%p6%       LICENS~5%p7%
%1 %2 %p3% %p4% %p5% LICENS~6%p6%       LICENS~6%p7%
%1 %2 %p3% %p4% %p5% LICENS~7%p6%       LICENS~7%p7%
%1 %2 %p3% %p4% %p5% LICENS~8%p6%       LICENS~8%p7%
%1 %2 %p3% %p4% %p5% LIGHT_~1%p6%       LIGHT_~1%p7%
%1 %2 %p3% %p4% %p5% LIGHT_~2%p6%       LIGHT_~2%p7%
%1 %2 %p3% %p4% %p5% LIGHT1~1%p6%       LIGHT1~1%p7%
%1 %2 %p3% %p4% %p5% LIGHT2~1%p6%       LIGHT2~1%p7%
%1 %2 %p3% %p4% %p5% LINEAR~1%p6%       LINEAR~1%p7%
%1 %2 %p3% %p4% %p5% LINEAR~2%p6%       LINEAR~2%p7%
%1 %2 %p3% %p4% %p5% LISTFO~1%p6%       LISTFO~1%p7%
%1 %2 %p3% %p4% %p5% LOGO3B~1%p6%       LOGO3B~1%p7%
%1 %2 %p3% %p4% %p5% MAILT3~1%p6%       MAILT3~1%p7%
%1 %2 %p3% %p4% %p5% MAILTA~1%p6%       MAILTA~1%p7%
%1 %2 %p3% %p4% %p5% MAINHT~1%p6%       MAINHT~1%p7%
%1 %2 %p3% %p4% %p5% MAN5AL~1%p6%       MAN5AL~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       MANUAL~1%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       MANUAL~2%p7%
%1 %2 %p3% %p4% %p5% MAR5HA~1%p6%       MAR5HA~1%p7%
%1 %2 %p3% %p4% %p5% MAR6HA~1%p6%       MAR6HA~1%p7%
%1 %2 %p3% %p4% %p5% MAYQUE~1%p6%       MAYQUE~1%p7%
%1 %2 %p3% %p4% %p5% MELANI~1%p6%       MELANI~1%p7%
%1 %2 %p3% %p4% %p5% MENA00~1%p6%       MENA00~1%p7%
%1 %2 %p3% %p4% %p5% MENA00~2%p6%       MENA00~2%p7%
%1 %2 %p3% %p4% %p5% MENA00~3%p6%       MENA00~3%p7%
%1 %2 %p3% %p4% %p5% MESSAG~1%p6%       MESSAG~1%p7%
%1 %2 %p3% %p4% %p5% MESSAG~2%p6%       MESSAG~2%p7%
%1 %2 %p3% %p4% %p5% MF359I~1%p6%       MF359I~1%p7%
%1 %2 %p3% %p4% %p5% MFC42D~1%p6%       MFC42D~1%p7%
%1 %2 %p3% %p4% %p5% MGLICE~1%p6%       MGLICE~1%p7%
%1 %2 %p3% %p4% %p5% MONO7D~1%p6%       MONO7D~1%p7%
%1 %2 %p3% %p4% %p5% MONO7D~2%p6%       MONO7D~2%p7%
%1 %2 %p3% %p4% %p5% MONO9D~1%p6%       MONO9D~1%p7%
%1 %2 %p3% %p4% %p5% MONO9D~2%p6%       MONO9D~2%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       MSVCRT~1%p7%
%1 %2 %p3% %p4% %p5% MVDGIF~1%p6%       MVDGIF~1%p7%
%1 %2 %p3% %p4% %p5% MYAT7D~1%p6%       MYAT7D~1%p7%
%1 %2 %p3% %p4% %p5% MYAT9D~1%p6%       MYAT9D~1%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~1%p6%       MYFO9T~1%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~2%p6%       MYFO9T~2%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~3%p6%       MYFO9T~3%p7%
%1 %2 %p3% %p4% %p5% NATLOG~1%p6%       NATLOG~1%p7%
%1 %2 %p3% %p4% %p5% NEON2-~1%p6%       NEON2-~1%p7%
%1 %2 %p3% %p4% %p5% NEON2D~1%p6%       NEON2D~1%p7%
%1 %2 %p3% %p4% %p5% NEONDI~1%p6%       NEONDI~1%p7%
%1 %2 %p3% %p4% %p5% NEW1ST~1%p6%       NEW1ST~1%p7%
%1 %2 %p3% %p4% %p5% NEWGIF~1%p6%       NEWGIF~1%p7%
%1 %2 %p3% %p4% %p5% NEXTVE~1%p6%       NEXTVE~1%p7%
%1 %2 %p3% %p4% %p5% NONBLO~1%p6%       NONBLO~1%p7%
%1 %2 %p3% %p4% %p5% NOTEGI~1%p6%       NOTEGI~1%p7%
%1 %2 %p3% %p4% %p5% NTSTLK~1%p6%       NTSTLK~1%p7%
%1 %2 %p3% %p4% %p5% NULLPT~1%p6%       NULLPT~1%p7%
%1 %2 %p3% %p4% %p5% NUMBER~1%p6%       NUMBER~1%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       OLEPRO~1%p7%
%1 %2 %p3% %p4% %p5% OMBUDS~1%p6%       OMBUDS~1%p7%
%1 %2 %p3% %p4% %p5% ORD5RA~1%p6%       ORD5RA~1%p7%
%1 %2 %p3% %p4% %p5% ORD5RD~1%p6%       ORD5RD~1%p7%
%1 %2 %p3% %p4% %p5% ORD5RG~1%p6%       ORD5RG~1%p7%
%1 %2 %p3% %p4% %p5% ORD5RN~1%p6%       ORD5RN~1%p7%
%1 %2 %p3% %p4% %p5% ORD6RA~1%p6%       ORD6RA~1%p7%
%1 %2 %p3% %p4% %p5% ORD6RD~1%p6%       ORD6RD~1%p7%
%1 %2 %p3% %p4% %p5% ORD6RG~1%p6%       ORD6RG~1%p7%
%1 %2 %p3% %p4% %p5% ORD6RN~1%p6%       ORD6RN~1%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERF~1%p7%
%1 %2 %p3% %p4% %p5% ORDERH~1%p6%       ORDERH~1%p7%
%1 %2 %p3% %p4% %p5% ORDERS~1%p6%       ORDERS~1%p7%
%1 %2 %p3% %p4% %p5% ORDERT~1%p6%       ORDERT~1%p7%
%1 %2 %p3% %p4% %p5% OSDAT~1%p6%        OSDAT~1%p7%
%1 %2 %p3% %p4% %p5% OTH5SO~1%p6%       OTH5SO~1%p7%
%1 %2 %p3% %p4% %p5% OTH6SO~1%p6%       OTH6SO~1%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~1%p6%       OUTLIN~1%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~2%p6%       OUTLIN~2%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~3%p6%       OUTLIN~3%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~4%p6%       OUTLIN~4%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~5%p6%       OUTLIN~5%p7%
%1 %2 %p3% %p4% %p5% PAD_FI~1%p6%       PAD_FI~1%p7%
%1 %2 %p3% %p4% %p5% PAPER_~1%p6%       PAPER_~1%p7%
%1 %2 %p3% %p4% %p5% PAPER1~1%p6%       PAPER1~1%p7%
%1 %2 %p3% %p4% %p5% PAPER2~1%p6%       PAPER2~1%p7%
%1 %2 %p3% %p4% %p5% PARKFO~1%p6%       PARKFO~1%p7%
%1 %2 %p3% %p4% %p5% PERCHA~1%p6%       PERCHA~1%p7%
%1 %2 %p3% %p4% %p5% PHONTZ~1%p6%       PHONTZ~1%p7%
%1 %2 %p3% %p4% %p5% PHONTZ~2%p6%       PHONTZ~2%p7%
%1 %2 %p3% %p4% %p5% PINBAL~1%p6%       PINBAL~1%p7%
%1 %2 %p3% %p4% %p5% PINK_T~1%p6%       PINK_T~1%p7%
%1 %2 %p3% %p4% %p5% PINK2S~1%p6%       PINK2S~1%p7%
%1 %2 %p3% %p4% %p5% PIZZAD~1%p6%       PIZZAD~1%p7%
%1 %2 %p3% %p4% %p5% PREFIX~1%p6%       PREFIX~1%p7%
%1 %2 %p3% %p4% %p5% PRESSE~1%p6%       PRESSE~1%p7%
%1 %2 %p3% %p4% %p5% PROTER~1%p6%       PROTER~1%p7%
%1 %2 %p3% %p4% %p5% PSSETU~1%p6%       PSSETU~1%p7%
%1 %2 %p3% %p4% %p5% PSSETU~2%p6%       PSSETU~2%p7%
%1 %2 %p3% %p4% %p5% PSSETU~3%p6%       PSSETU~3%p7%
%1 %2 %p3% %p4% %p5% PUPLE1~1%p6%       PUPLE1~1%p7%
%1 %2 %p3% %p4% %p5% PVFP32~1%p6%       PVFP32~1%p7%
%1 %2 %p3% %p4% %p5% PVSHA4~1%p6%       PVSHA4~1%p7%
%1 %2 %p3% %p4% %p5% RANSOM~1%p6%       RANSOM~1%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       READM~10%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       READM~11%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       READM~12%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       READM~13%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       READM~14%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       READM~15%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       READM~16%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       READM~17%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       READM~18%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       READM~19%p7%
%1 %2 %p3% %p4% %p5% READM~20%p6%       READM~20%p7%
%1 %2 %p3% %p4% %p5% READM~21%p6%       READM~21%p7%
%1 %2 %p3% %p4% %p5% READM~22%p6%       READM~22%p7%
%1 %2 %p3% %p4% %p5% READM~23%p6%       READM~23%p7%
%1 %2 %p3% %p4% %p5% READM~24%p6%       READM~24%p7%
%1 %2 %p3% %p4% %p5% READM~25%p6%       READM~25%p7%
%1 %2 %p3% %p4% %p5% READM~26%p6%       READM~26%p7%
%1 %2 %p3% %p4% %p5% READM~27%p6%       READM~27%p7%
%1 %2 %p3% %p4% %p5% READM~28%p6%       READM~28%p7%
%1 %2 %p3% %p4% %p5% READM~29%p6%       READM~29%p7%
%1 %2 %p3% %p4% %p5% READM~30%p6%       READM~30%p7%
%1 %2 %p3% %p4% %p5% READM~31%p6%       READM~31%p7%
%1 %2 %p3% %p4% %p5% READM~32%p6%       READM~32%p7%
%1 %2 %p3% %p4% %p5% READM~33%p6%       READM~33%p7%
%1 %2 %p3% %p4% %p5% READM~34%p6%       READM~34%p7%
%1 %2 %p3% %p4% %p5% READM~35%p6%       READM~35%p7%
%1 %2 %p3% %p4% %p5% READM~36%p6%       READM~36%p7%
%1 %2 %p3% %p4% %p5% READM~37%p6%       READM~37%p7%
%1 %2 %p3% %p4% %p5% READM~38%p6%       READM~38%p7%
%1 %2 %p3% %p4% %p5% READM~39%p6%       READM~39%p7%
%1 %2 %p3% %p4% %p5% READM~40%p6%       READM~40%p7%
%1 %2 %p3% %p4% %p5% READM~41%p6%       READM~41%p7%
%1 %2 %p3% %p4% %p5% READM~42%p6%       READM~42%p7%
%1 %2 %p3% %p4% %p5% READM~43%p6%       READM~43%p7%
%1 %2 %p3% %p4% %p5% READM~44%p6%       READM~44%p7%
%1 %2 %p3% %p4% %p5% READM~45%p6%       READM~45%p7%
%1 %2 %p3% %p4% %p5% READM~46%p6%       READM~46%p7%
%1 %2 %p3% %p4% %p5% READM~47%p6%       READM~47%p7%
%1 %2 %p3% %p4% %p5% READM~48%p6%       READM~48%p7%
%1 %2 %p3% %p4% %p5% READM~49%p6%       READM~49%p7%
%1 %2 %p3% %p4% %p5% READM~50%p6%       READM~50%p7%
%1 %2 %p3% %p4% %p5% READM~51%p6%       READM~51%p7%
%1 %2 %p3% %p4% %p5% READM~52%p6%       READM~52%p7%
%1 %2 %p3% %p4% %p5% READM~53%p6%       READM~53%p7%
%1 %2 %p3% %p4% %p5% READM~54%p6%       READM~54%p7%
%1 %2 %p3% %p4% %p5% READM~55%p6%       READM~55%p7%
%1 %2 %p3% %p4% %p5% READM~56%p6%       READM~56%p7%
%1 %2 %p3% %p4% %p5% READM~57%p6%       READM~57%p7%
%1 %2 %p3% %p4% %p5% READM~58%p6%       READM~58%p7%
%1 %2 %p3% %p4% %p5% READM~59%p6%       READM~59%p7%
%1 %2 %p3% %p4% %p5% READM0~1%p6%       READM0~1%p7%
%1 %2 %p3% %p4% %p5% READM4~1%p6%       READM4~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README~7%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README~8%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README~9%p7%
%1 %2 %p3% %p4% %p5% RED_CH~1%p6%       RED_CH~1%p7%
%1 %2 %p3% %p4% %p5% RED_OU~1%p6%       RED_OU~1%p7%
%1 %2 %p3% %p4% %p5% RED_RE~1%p6%       RED_RE~1%p7%
%1 %2 %p3% %p4% %p5% RED_TR~1%p6%       RED_TR~1%p7%
%1 %2 %p3% %p4% %p5% RED1ST~1%p6%       RED1ST~1%p7%
%1 %2 %p3% %p4% %p5% RED2ST~1%p6%       RED2ST~1%p7%
%1 %2 %p3% %p4% %p5% REF5RE~1%p6%       REF5RE~1%p7%
%1 %2 %p3% %p4% %p5% REG5ST~1%p6%       REG5ST~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGIST~1%p7%
%1 %2 %p3% %p4% %p5% REGSVR~1%p6%       REGSVR~1%p7%
%1 %2 %p3% %p4% %p5% RELEAS~1%p6%       RELEAS~1%p7%
%1 %2 %p3% %p4% %p5% RESURG~1%p6%       RESURG~1%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RICHED~1%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX~1%p7%
%1 %2 %p3% %p4% %p5% ROBOTT~1%p6%       ROBOTT~1%p7%
%1 %2 %p3% %p4% %p5% ROUND2~1%p6%       ROUND2~1%p7%
%1 %2 %p3% %p4% %p5% SAMPLE~1%p6%       SAMPLE~1%p7%
%1 %2 %p3% %p4% %p5% SAVEHT~1%p6%       SAVEHT~1%p7%
%1 %2 %p3% %p4% %p5% SCR_BA~1%p6%       SCR_BA~1%p7%
%1 %2 %p3% %p4% %p5% SCR_BU~1%p6%       SCR_BU~1%p7%
%1 %2 %p3% %p4% %p5% SCR_DR~1%p6%       SCR_DR~1%p7%
%1 %2 %p3% %p4% %p5% SCR_DR~2%p6%       SCR_DR~2%p7%
%1 %2 %p3% %p4% %p5% SCR_ED~1%p6%       SCR_ED~1%p7%
%1 %2 %p3% %p4% %p5% SCR_GR~1%p6%       SCR_GR~1%p7%
%1 %2 %p3% %p4% %p5% SCR_ME~1%p6%       SCR_ME~1%p7%
%1 %2 %p3% %p4% %p5% SCR_OU~1%p6%       SCR_OU~1%p7%
%1 %2 %p3% %p4% %p5% SCRIPT~1%p6%       SCRIPT~1%p7%
%1 %2 %p3% %p4% %p5% SEA1ST~1%p6%       SEA1ST~1%p7%
%1 %2 %p3% %p4% %p5% SECRET~1%p6%       SECRET~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_~2%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP_~3%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_~4%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_~5%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_~6%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_~7%p7%
%1 %2 %p3% %p4% %p5% SETUP_~8%p6%       SETUP_~8%p7%
%1 %2 %p3% %p4% %p5% SETUP_~9%p6%       SETUP_~9%p7%
%1 %2 %p3% %p4% %p5% SETUP~10%p6%       SETUP~10%p7%
%1 %2 %p3% %p4% %p5% SETUP~11%p6%       SETUP~11%p7%
%1 %2 %p3% %p4% %p5% SETUP~12%p6%       SETUP~12%p7%
%1 %2 %p3% %p4% %p5% SETUP~13%p6%       SETUP~13%p7%
%1 %2 %p3% %p4% %p5% SETUP~14%p6%       SETUP~14%p7%
%1 %2 %p3% %p4% %p5% SETUP~15%p6%       SETUP~15%p7%
%1 %2 %p3% %p4% %p5% SETUP~16%p6%       SETUP~16%p7%
%1 %2 %p3% %p4% %p5% SETUP~17%p6%       SETUP~17%p7%
%1 %2 %p3% %p4% %p5% SETUP~18%p6%       SETUP~18%p7%
%1 %2 %p3% %p4% %p5% SETUP~19%p6%       SETUP~19%p7%
%1 %2 %p3% %p4% %p5% SETUP~20%p6%       SETUP~20%p7%
%1 %2 %p3% %p4% %p5% SETUP~21%p6%       SETUP~21%p7%
%1 %2 %p3% %p4% %p5% SETUP~22%p6%       SETUP~22%p7%
%1 %2 %p3% %p4% %p5% SETUP~23%p6%       SETUP~23%p7%
%1 %2 %p3% %p4% %p5% SETUP~24%p6%       SETUP~24%p7%
%1 %2 %p3% %p4% %p5% SETUP~25%p6%       SETUP~25%p7%
%1 %2 %p3% %p4% %p5% SETUP~26%p6%       SETUP~26%p7%
%1 %2 %p3% %p4% %p5% SETUP~27%p6%       SETUP~27%p7%
%1 %2 %p3% %p4% %p5% SETUP~28%p6%       SETUP~28%p7%
%1 %2 %p3% %p4% %p5% SETUP~29%p6%       SETUP~29%p7%
%1 %2 %p3% %p4% %p5% SETUP~30%p6%       SETUP~30%p7%
%1 %2 %p3% %p4% %p5% SETUP~31%p6%       SETUP~31%p7%
%1 %2 %p3% %p4% %p5% SETUP~32%p6%       SETUP~32%p7%
%1 %2 %p3% %p4% %p5% SETUP~33%p6%       SETUP~33%p7%
%1 %2 %p3% %p4% %p5% SETUP~34%p6%       SETUP~34%p7%
%1 %2 %p3% %p4% %p5% SETUP~35%p6%       SETUP~35%p7%
%1 %2 %p3% %p4% %p5% SETUP0~1%p6%       SETUP0~1%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       SETUP1~1%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       SETUP1~2%p7%
%1 %2 %p3% %p4% %p5% SETUP1~3%p6%       SETUP1~3%p7%
%1 %2 %p3% %p4% %p5% SETUP2~1%p6%       SETUP2~1%p7%
%1 %2 %p3% %p4% %p5% SETUP3~1%p6%       SETUP3~1%p7%
%1 %2 %p3% %p4% %p5% SETUP4~1%p6%       SETUP4~1%p7%
%1 %2 %p3% %p4% %p5% SETUPB~1%p6%       SETUPB~1%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUPI~3%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUPL~1%p7%
%1 %2 %p3% %p4% %p5% SETUPL~2%p6%       SETUPL~2%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUPP~1%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       SETUPT~1%p7%
%1 %2 %p3% %p4% %p5% SFTTRE~1%p6%       SFTTRE~1%p7%
%1 %2 %p3% %p4% %p5% SHA5EW~1%p6%       SHA5EW~1%p7%
%1 %2 %p3% %p4% %p5% SHA6EW~1%p6%       SHA6EW~1%p7%
%1 %2 %p3% %p4% %p5% SIGNAL~1%p6%       SIGNAL~1%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       SIMPLE~1%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       SIMPLE~2%p7%
%1 %2 %p3% %p4% %p5% SINE1S~1%p6%       SINE1S~1%p7%
%1 %2 %p3% %p4% %p5% SINE2S~1%p6%       SINE2S~1%p7%
%1 %2 %p3% %p4% %p5% SINGLE~1%p6%       SINGLE~1%p7%
%1 %2 %p3% %p4% %p5% SINGLE~2%p6%       SINGLE~2%p7%
%1 %2 %p3% %p4% %p5% SINGLE~3%p6%       SINGLE~3%p7%
%1 %2 %p3% %p4% %p5% SKINGI~1%p6%       SKINGI~1%p7%
%1 %2 %p3% %p4% %p5% SKY1ST~1%p6%       SKY1ST~1%p7%
%1 %2 %p3% %p4% %p5% SKYGIF~1%p6%       SKYGIF~1%p7%
%1 %2 %p3% %p4% %p5% SNOW2S~1%p6%       SNOW2S~1%p7%
%1 %2 %p3% %p4% %p5% SNOW3S~1%p6%       SNOW3S~1%p7%
%1 %2 %p3% %p4% %p5% SNOWST~1%p6%       SNOWST~1%p7%
%1 %2 %p3% %p4% %p5% SPACE1~1%p6%       SPACE1~1%p7%
%1 %2 %p3% %p4% %p5% SPLASH~1%p6%       SPLASH~1%p7%
%1 %2 %p3% %p4% %p5% SS221T~1%p6%       SS221T~1%p7%
%1 %2 %p3% %p4% %p5% ST4UNS~1%p6%       ST4UNS~1%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~1%p6%       ST5UNS~1%p7%
%1 %2 %p3% %p4% %p5% STALKE~1%p6%       STALKE~1%p7%
%1 %2 %p3% %p4% %p5% STALKE~2%p6%       STALKE~2%p7%
%1 %2 %p3% %p4% %p5% STAR0L~1%p6%       STAR0L~1%p7%
%1 %2 %p3% %p4% %p5% STAR1L~1%p6%       STAR1L~1%p7%
%1 %2 %p3% %p4% %p5% STAR2L~1%p6%       STAR2L~1%p7%
%1 %2 %p3% %p4% %p5% STEVET~1%p6%       STEVET~1%p7%
%1 %2 %p3% %p4% %p5% STH___~1%p6%       STH___~1%p7%
%1 %2 %p3% %p4% %p5% STH___~2%p6%       STH___~2%p7%
%1 %2 %p3% %p4% %p5% STKIT4~1%p6%       STKIT4~1%p7%
%1 %2 %p3% %p4% %p5% STYLE_~1%p6%       STYLE_~1%p7%
%1 %2 %p3% %p4% %p5% SUBMER~1%p6%       SUBMER~1%p7%
%1 %2 %p3% %p4% %p5% SUCKGO~1%p6%       SUCKGO~1%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~1%p6%       SYMSEL~1%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~2%p6%       SYMSEL~2%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~3%p6%       SYMSEL~3%p7%
%1 %2 %p3% %p4% %p5% TABLED~1%p6%       TABLED~1%p7%
%1 %2 %p3% %p4% %p5% TECHNE~1%p6%       TECHNE~1%p7%
%1 %2 %p3% %p4% %p5% TEMPLA~1%p6%       TEMPLA~1%p7%
%1 %2 %p3% %p4% %p5% TETANU~1%p6%       TETANU~1%p7%
%1 %2 %p3% %p4% %p5% TEX10G~1%p6%       TEX10G~1%p7%
%1 %2 %p3% %p4% %p5% TEX11G~1%p6%       TEX11G~1%p7%
%1 %2 %p3% %p4% %p5% TEX12G~1%p6%       TEX12G~1%p7%
%1 %2 %p3% %p4% %p5% TEX13G~1%p6%       TEX13G~1%p7%
%1 %2 %p3% %p4% %p5% TEX15G~1%p6%       TEX15G~1%p7%
%1 %2 %p3% %p4% %p5% TEX18G~1%p6%       TEX18G~1%p7%
%1 %2 %p3% %p4% %p5% TEX19G~1%p6%       TEX19G~1%p7%
%1 %2 %p3% %p4% %p5% TEX210~1%p6%       TEX210~1%p7%
%1 %2 %p3% %p4% %p5% TEX22G~1%p6%       TEX22G~1%p7%
%1 %2 %p3% %p4% %p5% TEX24G~1%p6%       TEX24G~1%p7%
%1 %2 %p3% %p4% %p5% TEX25G~1%p6%       TEX25G~1%p7%
%1 %2 %p3% %p4% %p5% TEX27G~1%p6%       TEX27G~1%p7%
%1 %2 %p3% %p4% %p5% TEX2GI~1%p6%       TEX2GI~1%p7%
%1 %2 %p3% %p4% %p5% TEX30G~1%p6%       TEX30G~1%p7%
%1 %2 %p3% %p4% %p5% TEX31G~1%p6%       TEX31G~1%p7%
%1 %2 %p3% %p4% %p5% TEX32G~1%p6%       TEX32G~1%p7%
%1 %2 %p3% %p4% %p5% TEX33G~1%p6%       TEX33G~1%p7%
%1 %2 %p3% %p4% %p5% TEX34G~1%p6%       TEX34G~1%p7%
%1 %2 %p3% %p4% %p5% TEX35G~1%p6%       TEX35G~1%p7%
%1 %2 %p3% %p4% %p5% TEX36G~1%p6%       TEX36G~1%p7%
%1 %2 %p3% %p4% %p5% TEX37G~1%p6%       TEX37G~1%p7%
%1 %2 %p3% %p4% %p5% TEX38G~1%p6%       TEX38G~1%p7%
%1 %2 %p3% %p4% %p5% TEX39G~1%p6%       TEX39G~1%p7%
%1 %2 %p3% %p4% %p5% TEX3GI~1%p6%       TEX3GI~1%p7%
%1 %2 %p3% %p4% %p5% TEX40G~1%p6%       TEX40G~1%p7%
%1 %2 %p3% %p4% %p5% TEX42G~1%p6%       TEX42G~1%p7%
%1 %2 %p3% %p4% %p5% TEX43G~1%p6%       TEX43G~1%p7%
%1 %2 %p3% %p4% %p5% TEX44G~1%p6%       TEX44G~1%p7%
%1 %2 %p3% %p4% %p5% TEX45G~1%p6%       TEX45G~1%p7%
%1 %2 %p3% %p4% %p5% TEX46G~1%p6%       TEX46G~1%p7%
%1 %2 %p3% %p4% %p5% TEX47G~1%p6%       TEX47G~1%p7%
%1 %2 %p3% %p4% %p5% TEX48G~1%p6%       TEX48G~1%p7%
%1 %2 %p3% %p4% %p5% TEX49G~1%p6%       TEX49G~1%p7%
%1 %2 %p3% %p4% %p5% TEX50G~1%p6%       TEX50G~1%p7%
%1 %2 %p3% %p4% %p5% TEX51G~1%p6%       TEX51G~1%p7%
%1 %2 %p3% %p4% %p5% TEX52G~1%p6%       TEX52G~1%p7%
%1 %2 %p3% %p4% %p5% TEX53G~1%p6%       TEX53G~1%p7%
%1 %2 %p3% %p4% %p5% TEX54G~1%p6%       TEX54G~1%p7%
%1 %2 %p3% %p4% %p5% TEX55G~1%p6%       TEX55G~1%p7%
%1 %2 %p3% %p4% %p5% TEX56G~1%p6%       TEX56G~1%p7%
%1 %2 %p3% %p4% %p5% TEX57G~1%p6%       TEX57G~1%p7%
%1 %2 %p3% %p4% %p5% TEX58G~1%p6%       TEX58G~1%p7%
%1 %2 %p3% %p4% %p5% TEX59G~1%p6%       TEX59G~1%p7%
%1 %2 %p3% %p4% %p5% TEX60G~1%p6%       TEX60G~1%p7%
%1 %2 %p3% %p4% %p5% TEX61G~1%p6%       TEX61G~1%p7%
%1 %2 %p3% %p4% %p5% TEX62G~1%p6%       TEX62G~1%p7%
%1 %2 %p3% %p4% %p5% TEX63G~1%p6%       TEX63G~1%p7%
%1 %2 %p3% %p4% %p5% TEX64G~1%p6%       TEX64G~1%p7%
%1 %2 %p3% %p4% %p5% TEX65G~1%p6%       TEX65G~1%p7%
%1 %2 %p3% %p4% %p5% TEX7GI~1%p6%       TEX7GI~1%p7%
%1 %2 %p3% %p4% %p5% TEXT_L~1%p6%       TEXT_L~1%p7%
%1 %2 %p3% %p4% %p5% THISPR~1%p6%       THISPR~1%p7%
%1 %2 %p3% %p4% %p5% THREED~1%p6%       THREED~1%p7%
%1 %2 %p3% %p4% %p5% TILE1G~1%p6%       TILE1G~1%p7%
%1 %2 %p3% %p4% %p5% TILE2G~1%p6%       TILE2G~1%p7%
%1 %2 %p3% %p4% %p5% TILE3G~1%p6%       TILE3G~1%p7%
%1 %2 %p3% %p4% %p5% TILE4G~1%p6%       TILE4G~1%p7%
%1 %2 %p3% %p4% %p5% TILE5G~1%p6%       TILE5G~1%p7%
%1 %2 %p3% %p4% %p5% TILE6G~1%p6%       TILE6G~1%p7%
%1 %2 %p3% %p4% %p5% TILEST~1%p6%       TILEST~1%p7%
%1 %2 %p3% %p4% %p5% TITLEG~1%p6%       TITLEG~1%p7%
%1 %2 %p3% %p4% %p5% TOASTT~1%p6%       TOASTT~1%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~1%p6%       TOMBAT~1%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~2%p6%       TOMBAT~2%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~3%p6%       TOMBAT~3%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~4%p6%       TOMBAT~4%p7%
%1 %2 %p3% %p4% %p5% TOMBOT~1%p6%       TOMBOT~1%p7%
%1 %2 %p3% %p4% %p5% TOMHAN~1%p6%       TOMHAN~1%p7%
%1 %2 %p3% %p4% %p5% TOMMYS~1%p6%       TOMMYS~1%p7%
%1 %2 %p3% %p4% %p5% TOMNRT~1%p6%       TOMNRT~1%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~1%p6%       TOPBAR~1%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~2%p6%       TOPBAR~2%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~3%p6%       TOPBAR~3%p7%
%1 %2 %p3% %p4% %p5% TOWELD~1%p6%       TOWELD~1%p7%
%1 %2 %p3% %p4% %p5% TRADEM~1%p6%       TRADEM~1%p7%
%1 %2 %p3% %p4% %p5% TRUETY~1%p6%       TRUETY~1%p7%
%1 %2 %p3% %p4% %p5% TSMILE~1%p6%       TSMILE~1%p7%
%1 %2 %p3% %p4% %p5% TTFMAN~1%p6%       TTFMAN~1%p7%
%1 %2 %p3% %p4% %p5% TUESDA~1%p6%       TUESDA~1%p7%
%1 %2 %p3% %p4% %p5% TYPEC~10%p6%       TYPEC~10%p7%
%1 %2 %p3% %p4% %p5% TYPECA~1%p6%       TYPECA~1%p7%
%1 %2 %p3% %p4% %p5% TYPECA~2%p6%       TYPECA~2%p7%
%1 %2 %p3% %p4% %p5% TYPECA~3%p6%       TYPECA~3%p7%
%1 %2 %p3% %p4% %p5% TYPECA~4%p6%       TYPECA~4%p7%
%1 %2 %p3% %p4% %p5% TYPECA~5%p6%       TYPECA~5%p7%
%1 %2 %p3% %p4% %p5% TYPECA~6%p6%       TYPECA~6%p7%
%1 %2 %p3% %p4% %p5% TYPECA~7%p6%       TYPECA~7%p7%
%1 %2 %p3% %p4% %p5% TYPECA~8%p6%       TYPECA~8%p7%
%1 %2 %p3% %p4% %p5% TYPECA~9%p6%       TYPECA~9%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~1%p6%       TYPOGR~1%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~2%p6%       TYPOGR~2%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~3%p6%       TYPOGR~3%p7%
%1 %2 %p3% %p4% %p5% UNIB7T~1%p6%       UNIB7T~1%p7%
%1 %2 %p3% %p4% %p5% UNIB9T~1%p6%       UNIB9T~1%p7%
%1 %2 %p3% %p4% %p5% UNIN7T~1%p6%       UNIN7T~1%p7%
%1 %2 %p3% %p4% %p5% UNIN9T~1%p6%       UNIN9T~1%p7%
%1 %2 %p3% %p4% %p5% UNINS0~1%p6%       UNINS0~1%p7%
%1 %2 %p3% %p4% %p5% UNINS1~1%p6%       UNINS1~1%p7%
%1 %2 %p3% %p4% %p5% UNINS2~1%p6%       UNINS2~1%p7%
%1 %2 %p3% %p4% %p5% UNINS3~1%p6%       UNINS3~1%p7%
%1 %2 %p3% %p4% %p5% UNINS4~1%p6%       UNINS4~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       UNINST~2%p7%
%1 %2 %p3% %p4% %p5% UNZDLL~1%p6%       UNZDLL~1%p7%
%1 %2 %p3% %p4% %p5% UPC-AH~1%p6%       UPC-AH~1%p7%
%1 %2 %p3% %p4% %p5% UPC-AT~1%p6%       UPC-AT~1%p7%
%1 %2 %p3% %p4% %p5% UPC-EH~1%p6%       UPC-EH~1%p7%
%1 %2 %p3% %p4% %p5% UPC-ET~1%p6%       UPC-ET~1%p7%
%1 %2 %p3% %p4% %p5% VALIUM~1%p6%       VALIUM~1%p7%
%1 %2 %p3% %p4% %p5% VALUES~1%p6%       VALUES~1%p7%
%1 %2 %p3% %p4% %p5% VB5STK~1%p6%       VB5STK~1%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDIN~1%p7%
%1 %2 %p3% %p4% %p5% VENDIN~2%p6%       VENDIN~2%p7%
%1 %2 %p3% %p4% %p5% VENDIN~3%p6%       VENDIN~3%p7%
%1 %2 %p3% %p4% %p5% VENDIN~4%p6%       VENDIN~4%p7%
%1 %2 %p3% %p4% %p5% VERSIO~1%p6%       VERSIO~1%p7%
%1 %2 %p3% %p4% %p5% VIEWCA~1%p6%       VIEWCA~1%p7%
%1 %2 %p3% %p4% %p5% VIEWCA~2%p6%       VIEWCA~2%p7%
%1 %2 %p3% %p4% %p5% VIEWCA~3%p6%       VIEWCA~3%p7%
%1 %2 %p3% %p4% %p5% VISIFO~1%p6%       VISIFO~1%p7%
%1 %2 %p3% %p4% %p5% VISIGO~1%p6%       VISIGO~1%p7%
%1 %2 %p3% %p4% %p5% VISIT4~1%p6%       VISIT4~1%p7%
%1 %2 %p3% %p4% %p5% W95I8F~1%p6%       W95I8F~1%p7%
%1 %2 %p3% %p4% %p5% W95I8F~2%p6%       W95I8F~2%p7%
%1 %2 %p3% %p4% %p5% W95I9F~1%p6%       W95I9F~1%p7%
%1 %2 %p3% %p4% %p5% W95I9F~2%p6%       W95I9F~2%p7%
%1 %2 %p3% %p4% %p5% WEIGHT~1%p6%       WEIGHT~1%p7%
%1 %2 %p3% %p4% %p5% WHA5SN~1%p6%       WHA5SN~1%p7%
%1 %2 %p3% %p4% %p5% WHA6SN~1%p6%       WHA6SN~1%p7%
%1 %2 %p3% %p4% %p5% WHITE_~1%p6%       WHITE_~1%p7%
%1 %2 %p3% %p4% %p5% WINNWA~1%p6%       WINNWA~1%p7%
%1 %2 %p3% %p4% %p5% WINNWA~2%p6%       WINNWA~2%p7%
%1 %2 %p3% %p4% %p5% WOLVES~1%p6%       WOLVES~1%p7%
%1 %2 %p3% %p4% %p5% WOODEN~1%p6%       WOODEN~1%p7%
%1 %2 %p3% %p4% %p5% YELLOW~1%p6%       YELLOW~1%p7%
%1 %2 %p3% %p4% %p5% YELLOW~2%p6%       YELLOW~2%p7%
%1 %2 %p3% %p4% %p5% YELLOW~3%p6%       YELLOW~3%p7%
%1 %2 %p3% %p4% %p5% YELLOW~4%p6%       YELLOW~4%p7%
%1 %2 %p3% %p4% %p5% YIKATU~1%p6%       YIKATU~1%p7%
%1 %2 %p3% %p4% %p5% ZINCBO~1%p6%       ZINCBO~1%p7%
%1 %2 %p3% %p4% %p5% ZIPDLL~1%p6%       ZIPDLL~1%p7%

cd %dir4%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST3~1%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL~1%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP~1%p7%
%1 %2 %p3% %p4% %p5% AGODLL~1%p6%       AGODLL~1%p7%
%1 %2 %p3% %p4% %p5% ANAFL2~1%p6%       ANAFL2~1%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECO~1%p7%
%1 %2 %p3% %p4% %p5% CPUINF~1%p6%       CPUINF~1%p7%
%1 %2 %p3% %p4% %p5% DATATA~1%p6%       DATATA~1%p7%
%1 %2 %p3% %p4% %p5% FINDHE~1%p6%       FINDHE~1%p7%
%1 %2 %p3% %p4% %p5% IPLA6D~1%p6%       IPLA6D~1%p7%
%1 %2 %p3% %p4% %p5% IPLDLL~1%p6%       IPLDLL~1%p7%
%1 %2 %p3% %p4% %p5% IPLM5D~1%p6%       IPLM5D~1%p7%
%1 %2 %p3% %p4% %p5% IPLM6D~1%p6%       IPLM6D~1%p7%
%1 %2 %p3% %p4% %p5% IPLP5D~1%p6%       IPLP5D~1%p7%
%1 %2 %p3% %p4% %p5% IPLP6D~1%p6%       IPLP6D~1%p7%
%1 %2 %p3% %p4% %p5% IPLPXD~1%p6%       IPLPXD~1%p7%
%1 %2 %p3% %p4% %p5% ISUNIN~1%p6%       ISUNIN~1%p7%
%1 %2 %p3% %p4% %p5% LANGDA~1%p6%       LANGDA~1%p7%
%1 %2 %p3% %p4% %p5% LAYOUT~1%p6%       LAYOUT~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% MFC42D~1%p6%       MFC42D~1%p7%
%1 %2 %p3% %p4% %p5% MLIB4V~1%p6%       MLIB4V~1%p7%
%1 %2 %p3% %p4% %p5% OSDAT~1%p6%        OSDAT~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% SETUPB~1%p6%       SETUPB~1%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUPL~1%p7%
%1 %2 %p3% %p4% %p5% SOFT3D~1%p6%       SOFT3D~1%p7%
%1 %2 %p3% %p4% %p5% SOFTFA~1%p6%       SOFTFA~1%p7%
%1 %2 %p3% %p4% %p5% SOFTFA~2%p6%       SOFTFA~2%p7%
%1 %2 %p3% %p4% %p5% VALUES~1%p6%       VALUES~1%p7%

cd %dir5%

%1 %2 %p3% %p4% %p5% ABDOME~1%p6%       ABDOME~1%p7%
%1 %2 %p3% %p4% %p5% ABDOME~2%p6%       ABDOME~2%p7%
%1 %2 %p3% %p4% %p5% ABOUTH~1%p6%       ABOUTH~1%p7%
%1 %2 %p3% %p4% %p5% ALPHAB~1%p6%       ALPHAB~1%p7%
%1 %2 %p3% %p4% %p5% ALPHAB~2%p6%       ALPHAB~2%p7%
%1 %2 %p3% %p4% %p5% ANIMAL~1%p6%       ANIMAL~1%p7%
%1 %2 %p3% %p4% %p5% ANIMAL~2%p6%       ANIMAL~2%p7%
%1 %2 %p3% %p4% %p5% ANN_LA~1%p6%       ANN_LA~1%p7%
%1 %2 %p3% %p4% %p5% ANNULA~1%p6%       ANNULA~1%p7%
%1 %2 %p3% %p4% %p5% ANNULA~2%p6%       ANNULA~2%p7%
%1 %2 %p3% %p4% %p5% ANNULA~3%p6%       ANNULA~3%p7%
%1 %2 %p3% %p4% %p5% ARMHTM~1%p6%       ARMHTM~1%p7%
%1 %2 %p3% %p4% %p5% ARMJPG~1%p6%       ARMJPG~1%p7%
%1 %2 %p3% %p4% %p5% AUR_CU~1%p6%       AUR_CU~1%p7%
%1 %2 %p3% %p4% %p5% AURICU~1%p6%       AURICU~1%p7%
%1 %2 %p3% %p4% %p5% AURICU~2%p6%       AURICU~2%p7%
%1 %2 %p3% %p4% %p5% AURICU~3%p6%       AURICU~3%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       AUTORU~1%p7%
%1 %2 %p3% %p4% %p5% AUTORU~2%p6%       AUTORU~2%p7%
%1 %2 %p3% %p4% %p5% BACKHT~1%p6%       BACKHT~1%p7%
%1 %2 %p3% %p4% %p5% BACKJP~1%p6%       BACKJP~1%p7%
%1 %2 %p3% %p4% %p5% BASICH~1%p6%       BASICH~1%p7%
%1 %2 %p3% %p4% %p5% BASICJ~1%p6%       BASICJ~1%p7%
%1 %2 %p3% %p4% %p5% BOD_WA~1%p6%       BOD_WA~1%p7%
%1 %2 %p3% %p4% %p5% BODYHT~1%p6%       BODYHT~1%p7%
%1 %2 %p3% %p4% %p5% BODYJP~1%p6%       BODYJP~1%p7%
%1 %2 %p3% %p4% %p5% BODYWA~1%p6%       BODYWA~1%p7%
%1 %2 %p3% %p4% %p5% BON_WA~1%p6%       BON_WA~1%p7%
%1 %2 %p3% %p4% %p5% BONAHT~1%p6%       BONAHT~1%p7%
%1 %2 %p3% %p4% %p5% BONAJP~1%p6%       BONAJP~1%p7%
%1 %2 %p3% %p4% %p5% BONAWA~1%p6%       BONAWA~1%p7%
%1 %2 %p3% %p4% %p5% BOU_HE~1%p6%       BOU_HE~1%p7%
%1 %2 %p3% %p4% %p5% BOUCHE~1%p6%       BOUCHE~1%p7%
%1 %2 %p3% %p4% %p5% BRA_WA~1%p6%       BRA_WA~1%p7%
%1 %2 %p3% %p4% %p5% BRASWA~1%p6%       BRASWA~1%p7%
%1 %2 %p3% %p4% %p5% BUSILE~1%p6%       BUSILE~1%p7%
%1 %2 %p3% %p4% %p5% BUSILE~2%p6%       BUSILE~2%p7%
%1 %2 %p3% %p4% %p5% BUSISP~1%p6%       BUSISP~1%p7%
%1 %2 %p3% %p4% %p5% BUSISP~2%p6%       BUSISP~2%p7%
%1 %2 %p3% %p4% %p5% BUSIWO~1%p6%       BUSIWO~1%p7%
%1 %2 %p3% %p4% %p5% BUSIWO~2%p6%       BUSIWO~2%p7%
%1 %2 %p3% %p4% %p5% CHE_EU~1%p6%       CHE_EU~1%p7%
%1 %2 %p3% %p4% %p5% CHE_IL~1%p6%       CHE_IL~1%p7%
%1 %2 %p3% %p4% %p5% CHEEKH~1%p6%       CHEEKH~1%p7%
%1 %2 %p3% %p4% %p5% CHEEKJ~1%p6%       CHEEKJ~1%p7%
%1 %2 %p3% %p4% %p5% CHESTH~1%p6%       CHESTH~1%p7%
%1 %2 %p3% %p4% %p5% CHESTJ~1%p6%       CHESTJ~1%p7%
%1 %2 %p3% %p4% %p5% CHEVEU~1%p6%       CHEVEU~1%p7%
%1 %2 %p3% %p4% %p5% CHEVIL~1%p6%       CHEVIL~1%p7%
%1 %2 %p3% %p4% %p5% CHINHT~1%p6%       CHINHT~1%p7%
%1 %2 %p3% %p4% %p5% CHINJP~1%p6%       CHINJP~1%p7%
%1 %2 %p3% %p4% %p5% CIL_WA~1%p6%       CIL_WA~1%p7%
%1 %2 %p3% %p4% %p5% CILWAV~1%p6%       CILWAV~1%p7%
%1 %2 %p3% %p4% %p5% COL_R1~1%p6%       COL_R1~1%p7%
%1 %2 %p3% %p4% %p5% COL_R1~2%p6%       COL_R1~2%p7%
%1 %2 %p3% %p4% %p5% COL_R1~3%p6%       COL_R1~3%p7%
%1 %2 %p3% %p4% %p5% COL_R1~4%p6%       COL_R1~4%p7%
%1 %2 %p3% %p4% %p5% COL_R1~5%p6%       COL_R1~5%p7%
%1 %2 %p3% %p4% %p5% COL_R1~6%p6%       COL_R1~6%p7%
%1 %2 %p3% %p4% %p5% COL_R1~7%p6%       COL_R1~7%p7%
%1 %2 %p3% %p4% %p5% COL_R2~1%p6%       COL_R2~1%p7%
%1 %2 %p3% %p4% %p5% COL_R3~1%p6%       COL_R3~1%p7%
%1 %2 %p3% %p4% %p5% COL_R4~1%p6%       COL_R4~1%p7%
%1 %2 %p3% %p4% %p5% COL_R5~1%p6%       COL_R5~1%p7%
%1 %2 %p3% %p4% %p5% COL_R5~2%p6%       COL_R5~2%p7%
%1 %2 %p3% %p4% %p5% COL_R6~1%p6%       COL_R6~1%p7%
%1 %2 %p3% %p4% %p5% COL_R7~1%p6%       COL_R7~1%p7%
%1 %2 %p3% %p4% %p5% COL_R8~1%p6%       COL_R8~1%p7%
%1 %2 %p3% %p4% %p5% COL_R9~1%p6%       COL_R9~1%p7%
%1 %2 %p3% %p4% %p5% COLOR~10%p6%       COLOR~10%p7%
%1 %2 %p3% %p4% %p5% COLOR~11%p6%       COLOR~11%p7%
%1 %2 %p3% %p4% %p5% COLOR~12%p6%       COLOR~12%p7%
%1 %2 %p3% %p4% %p5% COLOR~13%p6%       COLOR~13%p7%
%1 %2 %p3% %p4% %p5% COLOR~14%p6%       COLOR~14%p7%
%1 %2 %p3% %p4% %p5% COLOR~15%p6%       COLOR~15%p7%
%1 %2 %p3% %p4% %p5% COLOR~16%p6%       COLOR~16%p7%
%1 %2 %p3% %p4% %p5% COLOR~17%p6%       COLOR~17%p7%
%1 %2 %p3% %p4% %p5% COLOR~18%p6%       COLOR~18%p7%
%1 %2 %p3% %p4% %p5% COLOR~19%p6%       COLOR~19%p7%
%1 %2 %p3% %p4% %p5% COLOR1~1%p6%       COLOR1~1%p7%
%1 %2 %p3% %p4% %p5% COLOR1~2%p6%       COLOR1~2%p7%
%1 %2 %p3% %p4% %p5% COLOR1~3%p6%       COLOR1~3%p7%
%1 %2 %p3% %p4% %p5% COLOR1~4%p6%       COLOR1~4%p7%
%1 %2 %p3% %p4% %p5% COLOR1~5%p6%       COLOR1~5%p7%
%1 %2 %p3% %p4% %p5% COLOR1~6%p6%       COLOR1~6%p7%
%1 %2 %p3% %p4% %p5% COLOR1~7%p6%       COLOR1~7%p7%
%1 %2 %p3% %p4% %p5% COLOR1~8%p6%       COLOR1~8%p7%
%1 %2 %p3% %p4% %p5% COLOR1~9%p6%       COLOR1~9%p7%
%1 %2 %p3% %p4% %p5% COLOR2~1%p6%       COLOR2~1%p7%
%1 %2 %p3% %p4% %p5% COLOR2~2%p6%       COLOR2~2%p7%
%1 %2 %p3% %p4% %p5% COLOR2~3%p6%       COLOR2~3%p7%
%1 %2 %p3% %p4% %p5% COLOR3~1%p6%       COLOR3~1%p7%
%1 %2 %p3% %p4% %p5% COLOR3~2%p6%       COLOR3~2%p7%
%1 %2 %p3% %p4% %p5% COLOR3~3%p6%       COLOR3~3%p7%
%1 %2 %p3% %p4% %p5% COLOR4~1%p6%       COLOR4~1%p7%
%1 %2 %p3% %p4% %p5% COLOR4~2%p6%       COLOR4~2%p7%
%1 %2 %p3% %p4% %p5% COLOR4~3%p6%       COLOR4~3%p7%
%1 %2 %p3% %p4% %p5% COLOR5~1%p6%       COLOR5~1%p7%
%1 %2 %p3% %p4% %p5% COLOR5~2%p6%       COLOR5~2%p7%
%1 %2 %p3% %p4% %p5% COLOR5~3%p6%       COLOR5~3%p7%
%1 %2 %p3% %p4% %p5% COLOR5~4%p6%       COLOR5~4%p7%
%1 %2 %p3% %p4% %p5% COLOR5~5%p6%       COLOR5~5%p7%
%1 %2 %p3% %p4% %p5% COLOR5~6%p6%       COLOR5~6%p7%
%1 %2 %p3% %p4% %p5% COLOR5~7%p6%       COLOR5~7%p7%
%1 %2 %p3% %p4% %p5% COLOR5~8%p6%       COLOR5~8%p7%
%1 %2 %p3% %p4% %p5% COLOR6~1%p6%       COLOR6~1%p7%
%1 %2 %p3% %p4% %p5% COLOR6~2%p6%       COLOR6~2%p7%
%1 %2 %p3% %p4% %p5% COLOR6~3%p6%       COLOR6~3%p7%
%1 %2 %p3% %p4% %p5% COLOR7~1%p6%       COLOR7~1%p7%
%1 %2 %p3% %p4% %p5% COLOR7~2%p6%       COLOR7~2%p7%
%1 %2 %p3% %p4% %p5% COLOR7~3%p6%       COLOR7~3%p7%
%1 %2 %p3% %p4% %p5% COLOR8~1%p6%       COLOR8~1%p7%
%1 %2 %p3% %p4% %p5% COLOR8~2%p6%       COLOR8~2%p7%
%1 %2 %p3% %p4% %p5% COLOR8~3%p6%       COLOR8~3%p7%
%1 %2 %p3% %p4% %p5% COLOR9~1%p6%       COLOR9~1%p7%
%1 %2 %p3% %p4% %p5% COLOR9~2%p6%       COLOR9~2%p7%
%1 %2 %p3% %p4% %p5% COLOR9~3%p6%       COLOR9~3%p7%
%1 %2 %p3% %p4% %p5% COLORH~1%p6%       COLORH~1%p7%
%1 %2 %p3% %p4% %p5% COLORJ~1%p6%       COLORJ~1%p7%
%1 %2 %p3% %p4% %p5% CON_TI~1%p6%       CON_TI~1%p7%
%1 %2 %p3% %p4% %p5% CONSTI~1%p6%       CONSTI~1%p7%
%1 %2 %p3% %p4% %p5% CORPSG~1%p6%       CORPSG~1%p7%
%1 %2 %p3% %p4% %p5% CORPSH~1%p6%       CORPSH~1%p7%
%1 %2 %p3% %p4% %p5% COT_SW~1%p6%       COT_SW~1%p7%
%1 %2 %p3% %p4% %p5% COTESH~1%p6%       COTESH~1%p7%
%1 %2 %p3% %p4% %p5% COTESJ~1%p6%       COTESJ~1%p7%
%1 %2 %p3% %p4% %p5% COTESW~1%p6%       COTESW~1%p7%
%1 %2 %p3% %p4% %p5% COU_EW~1%p6%       COU_EW~1%p7%
%1 %2 %p3% %p4% %p5% COU_WA~1%p6%       COU_WA~1%p7%
%1 %2 %p3% %p4% %p5% COUDEW~1%p6%       COUDEW~1%p7%
%1 %2 %p3% %p4% %p5% COUNTR~1%p6%       COUNTR~1%p7%
%1 %2 %p3% %p4% %p5% COUNTR~2%p6%       COUNTR~2%p7%
%1 %2 %p3% %p4% %p5% COUWAV~1%p6%       COUWAV~1%p7%
%1 %2 %p3% %p4% %p5% CTL3DV~1%p6%       CTL3DV~1%p7%
%1 %2 %p3% %p4% %p5% CUI_SE~1%p6%       CUI_SE~1%p7%
%1 %2 %p3% %p4% %p5% CUISIN~1%p6%       CUISIN~1%p7%
%1 %2 %p3% %p4% %p5% CUISIN~2%p6%       CUISIN~2%p7%
%1 %2 %p3% %p4% %p5% CUISSE~1%p6%       CUISSE~1%p7%
%1 %2 %p3% %p4% %p5% DANSK_~1%p6%       DANSK_~1%p7%
%1 %2 %p3% %p4% %p5% DANSKD~1%p6%       DANSKD~1%p7%
%1 %2 %p3% %p4% %p5% DEMOGI~1%p6%       DEMOGI~1%p7%
%1 %2 %p3% %p4% %p5% DEMOHT~1%p6%       DEMOHT~1%p7%
%1 %2 %p3% %p4% %p5% DEN_WA~1%p6%       DEN_WA~1%p7%
%1 %2 %p3% %p4% %p5% DENTWA~1%p6%       DENTWA~1%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~1%p6%       DEUTSC~1%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~2%p6%       DEUTSC~2%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~3%p6%       DEUTSC~3%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~4%p6%       DEUTSC~4%p7%
%1 %2 %p3% %p4% %p5% DIA_EW~1%p6%       DIA_EW~1%p7%
%1 %2 %p3% %p4% %p5% DIA_RH~1%p6%       DIA_RH~1%p7%
%1 %2 %p3% %p4% %p5% DIABEW~1%p6%       DIABEW~1%p7%
%1 %2 %p3% %p4% %p5% DIARRH~1%p6%       DIARRH~1%p7%
%1 %2 %p3% %p4% %p5% DICTEJ~1%p6%       DICTEJ~1%p7%
%1 %2 %p3% %p4% %p5% DICTIO~1%p6%       DICTIO~1%p7%
%1 %2 %p3% %p4% %p5% DIRECG~1%p6%       DIRECG~1%p7%
%1 %2 %p3% %p4% %p5% DIRECH~1%p6%       DIRECH~1%p7%
%1 %2 %p3% %p4% %p5% DOI_TW~1%p6%       DOI_TW~1%p7%
%1 %2 %p3% %p4% %p5% DOIGTW~1%p6%       DOIGTW~1%p7%
%1 %2 %p3% %p4% %p5% DOS_WA~1%p6%       DOS_WA~1%p7%
%1 %2 %p3% %p4% %p5% DOSWAV~1%p6%       DOSWAV~1%p7%
%1 %2 %p3% %p4% %p5% EAR_WA~1%p6%       EAR_WA~1%p7%
%1 %2 %p3% %p4% %p5% EARHTM~1%p6%       EARHTM~1%p7%
%1 %2 %p3% %p4% %p5% EARJPG~1%p6%       EARJPG~1%p7%
%1 %2 %p3% %p4% %p5% EARWAV~1%p6%       EARWAV~1%p7%
%1 %2 %p3% %p4% %p5% EKREAC~1%p6%       EKREAC~1%p7%
%1 %2 %p3% %p4% %p5% ELBOWH~1%p6%       ELBOWH~1%p7%
%1 %2 %p3% %p4% %p5% ELBOWJ~1%p6%       ELBOWJ~1%p7%
%1 %2 %p3% %p4% %p5% EMP_BR~1%p6%       EMP_BR~1%p7%
%1 %2 %p3% %p4% %p5% EMP_JA~1%p6%       EMP_JA~1%p7%
%1 %2 %p3% %p4% %p5% EMPUBR~1%p6%       EMPUBR~1%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~1%p6%       EMPUJA~1%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~2%p6%       EMPUJA~2%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~3%p6%       EMPUJA~3%p7%
%1 %2 %p3% %p4% %p5% ENGLIS~1%p6%       ENGLIS~1%p7%
%1 %2 %p3% %p4% %p5% ENGLIS~2%p6%       ENGLIS~2%p7%
%1 %2 %p3% %p4% %p5% ENR_UM~1%p6%       ENR_UM~1%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~1%p6%       ENRHUM~1%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~2%p6%       ENRHUM~2%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~3%p6%       ENRHUM~3%p7%
%1 %2 %p3% %p4% %p5% EPA_LE~1%p6%       EPA_LE~1%p7%
%1 %2 %p3% %p4% %p5% EPAULE~1%p6%       EPAULE~1%p7%
%1 %2 %p3% %p4% %p5% ESPANO~1%p6%       ESPANO~1%p7%
%1 %2 %p3% %p4% %p5% ESPANO~2%p6%       ESPANO~2%p7%
%1 %2 %p3% %p4% %p5% EXERCI~1%p6%       EXERCI~1%p7%
%1 %2 %p3% %p4% %p5% EXMENU~1%p6%       EXMENU~1%p7%
%1 %2 %p3% %p4% %p5% EXPORT~1%p6%       EXPORT~1%p7%
%1 %2 %p3% %p4% %p5% EYEBRO~1%p6%       EYEBRO~1%p7%
%1 %2 %p3% %p4% %p5% EYEBRO~2%p6%       EYEBRO~2%p7%
%1 %2 %p3% %p4% %p5% EYEHTM~1%p6%       EYEHTM~1%p7%
%1 %2 %p3% %p4% %p5% EYEJPG~1%p6%       EYEJPG~1%p7%
%1 %2 %p3% %p4% %p5% EYELAS~1%p6%       EYELAS~1%p7%
%1 %2 %p3% %p4% %p5% EYELAS~2%p6%       EYELAS~2%p7%
%1 %2 %p3% %p4% %p5% FAMILY~1%p6%       FAMILY~1%p7%
%1 %2 %p3% %p4% %p5% FAMILY~2%p6%       FAMILY~2%p7%
%1 %2 %p3% %p4% %p5% FAT_GU~1%p6%       FAT_GU~1%p7%
%1 %2 %p3% %p4% %p5% FATIGU~1%p6%       FATIGU~1%p7%
%1 %2 %p3% %p4% %p5% FES_ES~1%p6%       FES_ES~1%p7%
%1 %2 %p3% %p4% %p5% FESSES~1%p6%       FESSES~1%p7%
%1 %2 %p3% %p4% %p5% FESSES~2%p6%       FESSES~2%p7%
%1 %2 %p3% %p4% %p5% FESSES~3%p6%       FESSES~3%p7%
%1 %2 %p3% %p4% %p5% FFMSG~1%p6%        FFMSG~1%p7%
%1 %2 %p3% %p4% %p5% FILLIT~1%p6%       FILLIT~1%p7%
%1 %2 %p3% %p4% %p5% FINGER~1%p6%       FINGER~1%p7%
%1 %2 %p3% %p4% %p5% FINGER~2%p6%       FINGER~2%p7%
%1 %2 %p3% %p4% %p5% FINNAI~1%p6%       FINNAI~1%p7%
%1 %2 %p3% %p4% %p5% FINNAI~2%p6%       FINNAI~2%p7%
%1 %2 %p3% %p4% %p5% FONDJP~1%p6%       FONDJP~1%p7%
%1 %2 %p3% %p4% %p5% FOOTHT~1%p6%       FOOTHT~1%p7%
%1 %2 %p3% %p4% %p5% FOOTJP~1%p6%       FOOTJP~1%p7%
%1 %2 %p3% %p4% %p5% FOREHE~1%p6%       FOREHE~1%p7%
%1 %2 %p3% %p4% %p5% FOREHE~2%p6%       FOREHE~2%p7%
%1 %2 %p3% %p4% %p5% FRANCA~1%p6%       FRANCA~1%p7%
%1 %2 %p3% %p4% %p5% FRANCA~2%p6%       FRANCA~2%p7%
%1 %2 %p3% %p4% %p5% FRANCA~3%p6%       FRANCA~3%p7%
%1 %2 %p3% %p4% %p5% FRANCA~4%p6%       FRANCA~4%p7%
%1 %2 %p3% %p4% %p5% FRO_TW~1%p6%       FRO_TW~1%p7%
%1 %2 %p3% %p4% %p5% FRONTW~1%p6%       FRONTW~1%p7%
%1 %2 %p3% %p4% %p5% FRUITS~1%p6%       FRUITS~1%p7%
%1 %2 %p3% %p4% %p5% FUTURE~1%p6%       FUTURE~1%p7%
%1 %2 %p3% %p4% %p5% FUTURE~2%p6%       FUTURE~2%p7%
%1 %2 %p3% %p4% %p5% GAL_WA~1%p6%       GAL_WA~1%p7%
%1 %2 %p3% %p4% %p5% GALEWA~1%p6%       GALEWA~1%p7%
%1 %2 %p3% %p4% %p5% GEN_UW~1%p6%       GEN_UW~1%p7%
%1 %2 %p3% %p4% %p5% GENOUW~1%p6%       GENOUW~1%p7%
%1 %2 %p3% %p4% %p5% GOR_EW~1%p6%       GOR_EW~1%p7%
%1 %2 %p3% %p4% %p5% GORGEW~1%p6%       GORGEW~1%p7%
%1 %2 %p3% %p4% %p5% GREE_G~1%p6%       GREE_G~1%p7%
%1 %2 %p3% %p4% %p5% GREENG~1%p6%       GREENG~1%p7%
%1 %2 %p3% %p4% %p5% GRI_PE~1%p6%       GRI_PE~1%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~1%p6%       GRIPPE~1%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~2%p6%       GRIPPE~2%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~3%p6%       GRIPPE~3%p7%
%1 %2 %p3% %p4% %p5% HABITS~1%p6%       HABITS~1%p7%
%1 %2 %p3% %p4% %p5% HABITS~2%p6%       HABITS~2%p7%
%1 %2 %p3% %p4% %p5% HAIRHT~1%p6%       HAIRHT~1%p7%
%1 %2 %p3% %p4% %p5% HAIRJP~1%p6%       HAIRJP~1%p7%
%1 %2 %p3% %p4% %p5% HAN_HE~1%p6%       HAN_HE~1%p7%
%1 %2 %p3% %p4% %p5% HANCHE~1%p6%       HANCHE~1%p7%
%1 %2 %p3% %p4% %p5% HANDGI~1%p6%       HANDGI~1%p7%
%1 %2 %p3% %p4% %p5% HANDHT~1%p6%       HANDHT~1%p7%
%1 %2 %p3% %p4% %p5% HANDJP~1%p6%       HANDJP~1%p7%
%1 %2 %p3% %p4% %p5% HEADHT~1%p6%       HEADHT~1%p7%
%1 %2 %p3% %p4% %p5% HEADJP~1%p6%       HEADJP~1%p7%
%1 %2 %p3% %p4% %p5% HEBREW~1%p6%       HEBREW~1%p7%
%1 %2 %p3% %p4% %p5% HEBREW~2%p6%       HEBREW~2%p7%
%1 %2 %p3% %p4% %p5% HEELHT~1%p6%       HEELHT~1%p7%
%1 %2 %p3% %p4% %p5% HEELJP~1%p6%       HEELJP~1%p7%
%1 %2 %p3% %p4% %p5% HIPHTM~1%p6%       HIPHTM~1%p7%
%1 %2 %p3% %p4% %p5% HIPJPG~1%p6%       HIPJPG~1%p7%
%1 %2 %p3% %p4% %p5% HOMESP~1%p6%       HOMESP~1%p7%
%1 %2 %p3% %p4% %p5% HOMESP~2%p6%       HOMESP~2%p7%
%1 %2 %p3% %p4% %p5% HOMEVE~1%p6%       HOMEVE~1%p7%
%1 %2 %p3% %p4% %p5% HOMEVE~2%p6%       HOMEVE~2%p7%
%1 %2 %p3% %p4% %p5% HOMEVO~1%p6%       HOMEVO~1%p7%
%1 %2 %p3% %p4% %p5% HOMEVO~2%p6%       HOMEVO~2%p7%
%1 %2 %p3% %p4% %p5% HORSEA~1%p6%       HORSEA~1%p7%
%1 %2 %p3% %p4% %p5% HOTESP~1%p6%       HOTESP~1%p7%
%1 %2 %p3% %p4% %p5% HOTESP~2%p6%       HOTESP~2%p7%
%1 %2 %p3% %p4% %p5% HOTEVO~1%p6%       HOTEVO~1%p7%
%1 %2 %p3% %p4% %p5% HOTEVO~2%p6%       HOTEVO~2%p7%
%1 %2 %p3% %p4% %p5% ICONE~10%p6%       ICONE~10%p7%
%1 %2 %p3% %p4% %p5% ICONE~11%p6%       ICONE~11%p7%
%1 %2 %p3% %p4% %p5% ICONE~12%p6%       ICONE~12%p7%
%1 %2 %p3% %p4% %p5% ICONE1~1%p6%       ICONE1~1%p7%
%1 %2 %p3% %p4% %p5% ICONE1~2%p6%       ICONE1~2%p7%
%1 %2 %p3% %p4% %p5% ICONE1~3%p6%       ICONE1~3%p7%
%1 %2 %p3% %p4% %p5% ICONE1~4%p6%       ICONE1~4%p7%
%1 %2 %p3% %p4% %p5% ICONE1~5%p6%       ICONE1~5%p7%
%1 %2 %p3% %p4% %p5% ICONE1~6%p6%       ICONE1~6%p7%
%1 %2 %p3% %p4% %p5% ICONE1~7%p6%       ICONE1~7%p7%
%1 %2 %p3% %p4% %p5% ICONE1~8%p6%       ICONE1~8%p7%
%1 %2 %p3% %p4% %p5% ICONE1~9%p6%       ICONE1~9%p7%
%1 %2 %p3% %p4% %p5% ICONE2~1%p6%       ICONE2~1%p7%
%1 %2 %p3% %p4% %p5% ICONE3~1%p6%       ICONE3~1%p7%
%1 %2 %p3% %p4% %p5% ICONE3~2%p6%       ICONE3~2%p7%
%1 %2 %p3% %p4% %p5% ICONE4~1%p6%       ICONE4~1%p7%
%1 %2 %p3% %p4% %p5% ICONE4~2%p6%       ICONE4~2%p7%
%1 %2 %p3% %p4% %p5% ICONE5~1%p6%       ICONE5~1%p7%
%1 %2 %p3% %p4% %p5% ICONE5~2%p6%       ICONE5~2%p7%
%1 %2 %p3% %p4% %p5% ICONE6~1%p6%       ICONE6~1%p7%
%1 %2 %p3% %p4% %p5% ICONE7~1%p6%       ICONE7~1%p7%
%1 %2 %p3% %p4% %p5% ICONE8~1%p6%       ICONE8~1%p7%
%1 %2 %p3% %p4% %p5% ICONE9~1%p6%       ICONE9~1%p7%
%1 %2 %p3% %p4% %p5% ICONE9~2%p6%       ICONE9~2%p7%
%1 %2 %p3% %p4% %p5% ICONE9~3%p6%       ICONE9~3%p7%
%1 %2 %p3% %p4% %p5% ICONE9~4%p6%       ICONE9~4%p7%
%1 %2 %p3% %p4% %p5% IND_XW~1%p6%       IND_XW~1%p7%
%1 %2 %p3% %p4% %p5% INDEX_~1%p6%       INDEX_~1%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       INDEXH~1%p7%
%1 %2 %p3% %p4% %p5% INDEXJ~1%p6%       INDEXJ~1%p7%
%1 %2 %p3% %p4% %p5% INDEXW~1%p6%       INDEXW~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% ITALIA~1%p6%       ITALIA~1%p7%
%1 %2 %p3% %p4% %p5% ITALIA~2%p6%       ITALIA~2%p7%
%1 %2 %p3% %p4% %p5% JAM_EW~1%p6%       JAM_EW~1%p7%
%1 %2 %p3% %p4% %p5% JAMBEW~1%p6%       JAMBEW~1%p7%
%1 %2 %p3% %p4% %p5% JOU_WA~1%p6%       JOU_WA~1%p7%
%1 %2 %p3% %p4% %p5% JOUEWA~1%p6%       JOUEWA~1%p7%
%1 %2 %p3% %p4% %p5% KH500U~1%p6%       KH500U~1%p7%
%1 %2 %p3% %p4% %p5% KHMERM~1%p6%       KHMERM~1%p7%
%1 %2 %p3% %p4% %p5% KLE_WA~1%p6%       KLE_WA~1%p7%
%1 %2 %p3% %p4% %p5% KLEGWA~1%p6%       KLEGWA~1%p7%
%1 %2 %p3% %p4% %p5% KNEEHT~1%p6%       KNEEHT~1%p7%
%1 %2 %p3% %p4% %p5% KNEEJP~1%p6%       KNEEJP~1%p7%
%1 %2 %p3% %p4% %p5% LAN_UE~1%p6%       LAN_UE~1%p7%
%1 %2 %p3% %p4% %p5% LANGUE~1%p6%       LANGUE~1%p7%
%1 %2 %p3% %p4% %p5% LEAFHT~1%p6%       LEAFHT~1%p7%
%1 %2 %p3% %p4% %p5% LEAFJP~1%p6%       LEAFJP~1%p7%
%1 %2 %p3% %p4% %p5% LEAMEH~1%p6%       LEAMEH~1%p7%
%1 %2 %p3% %p4% %p5% LEAMET~1%p6%       LEAMET~1%p7%
%1 %2 %p3% %p4% %p5% LEG_WA~1%p6%       LEG_WA~1%p7%
%1 %2 %p3% %p4% %p5% LEGHTM~1%p6%       LEGHTM~1%p7%
%1 %2 %p3% %p4% %p5% LEGJPG~1%p6%       LEGJPG~1%p7%
%1 %2 %p3% %p4% %p5% LEGWAV~1%p6%       LEGWAV~1%p7%
%1 %2 %p3% %p4% %p5% LESENS~1%p6%       LESENS~1%p7%
%1 %2 %p3% %p4% %p5% LESENS~2%p6%       LESENS~2%p7%
%1 %2 %p3% %p4% %p5% LESSO~10%p6%       LESSO~10%p7%
%1 %2 %p3% %p4% %p5% LESSO~11%p6%       LESSO~11%p7%
%1 %2 %p3% %p4% %p5% LESSO~12%p6%       LESSO~12%p7%
%1 %2 %p3% %p4% %p5% LESSO~13%p6%       LESSO~13%p7%
%1 %2 %p3% %p4% %p5% LESSO~14%p6%       LESSO~14%p7%
%1 %2 %p3% %p4% %p5% LESSO~15%p6%       LESSO~15%p7%
%1 %2 %p3% %p4% %p5% LESSO~16%p6%       LESSO~16%p7%
%1 %2 %p3% %p4% %p5% LESSO~17%p6%       LESSO~17%p7%
%1 %2 %p3% %p4% %p5% LESSO~18%p6%       LESSO~18%p7%
%1 %2 %p3% %p4% %p5% LESSO~19%p6%       LESSO~19%p7%
%1 %2 %p3% %p4% %p5% LESSO~20%p6%       LESSO~20%p7%
%1 %2 %p3% %p4% %p5% LESSO~21%p6%       LESSO~21%p7%
%1 %2 %p3% %p4% %p5% LESSO~22%p6%       LESSO~22%p7%
%1 %2 %p3% %p4% %p5% LESSO~23%p6%       LESSO~23%p7%
%1 %2 %p3% %p4% %p5% LESSO~24%p6%       LESSO~24%p7%
%1 %2 %p3% %p4% %p5% LESSO~25%p6%       LESSO~25%p7%
%1 %2 %p3% %p4% %p5% LESSO~26%p6%       LESSO~26%p7%
%1 %2 %p3% %p4% %p5% LESSO~27%p6%       LESSO~27%p7%
%1 %2 %p3% %p4% %p5% LESSO~28%p6%       LESSO~28%p7%
%1 %2 %p3% %p4% %p5% LESSO~29%p6%       LESSO~29%p7%
%1 %2 %p3% %p4% %p5% LESSO~30%p6%       LESSO~30%p7%
%1 %2 %p3% %p4% %p5% LESSO~31%p6%       LESSO~31%p7%
%1 %2 %p3% %p4% %p5% LESSO~32%p6%       LESSO~32%p7%
%1 %2 %p3% %p4% %p5% LESSO~33%p6%       LESSO~33%p7%
%1 %2 %p3% %p4% %p5% LESSO~34%p6%       LESSO~34%p7%
%1 %2 %p3% %p4% %p5% LESSO~35%p6%       LESSO~35%p7%
%1 %2 %p3% %p4% %p5% LESSON~1%p6%       LESSON~1%p7%
%1 %2 %p3% %p4% %p5% LESSON~2%p6%       LESSON~2%p7%
%1 %2 %p3% %p4% %p5% LESSON~3%p6%       LESSON~3%p7%
%1 %2 %p3% %p4% %p5% LESSON~4%p6%       LESSON~4%p7%
%1 %2 %p3% %p4% %p5% LESSON~5%p6%       LESSON~5%p7%
%1 %2 %p3% %p4% %p5% LESSON~6%p6%       LESSON~6%p7%
%1 %2 %p3% %p4% %p5% LESSON~7%p6%       LESSON~7%p7%
%1 %2 %p3% %p4% %p5% LESSON~8%p6%       LESSON~8%p7%
%1 %2 %p3% %p4% %p5% LESSON~9%p6%       LESSON~9%p7%
%1 %2 %p3% %p4% %p5% LEU_EM~1%p6%       LEU_EM~1%p7%
%1 %2 %p3% %p4% %p5% LEUCEM~1%p6%       LEUCEM~1%p7%
%1 %2 %p3% %p4% %p5% LEV_EW~1%p6%       LEV_EW~1%p7%
%1 %2 %p3% %p4% %p5% LEVREW~1%p6%       LEVREW~1%p7%
%1 %2 %p3% %p4% %p5% LIPHTM~1%p6%       LIPHTM~1%p7%
%1 %2 %p3% %p4% %p5% LIPJPG~1%p6%       LIPJPG~1%p7%
%1 %2 %p3% %p4% %p5% LISEZM~1%p6%       LISEZM~1%p7%
%1 %2 %p3% %p4% %p5% LISEZM~2%p6%       LISEZM~2%p7%
%1 %2 %p3% %p4% %p5% LITTLE~1%p6%       LITTLE~1%p7%
%1 %2 %p3% %p4% %p5% LITTLE~2%p6%       LITTLE~2%p7%
%1 %2 %p3% %p4% %p5% LOGO_G~1%p6%       LOGO_G~1%p7%
%1 %2 %p3% %p4% %p5% MAI_WA~1%p6%       MAI_WA~1%p7%
%1 %2 %p3% %p4% %p5% MAINWA~1%p6%       MAINWA~1%p7%
%1 %2 %p3% %p4% %p5% MAJ_UR~1%p6%       MAJ_UR~1%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~1%p6%       MAJEUR~1%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~2%p6%       MAJEUR~2%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~3%p6%       MAJEUR~3%p7%
%1 %2 %p3% %p4% %p5% MAJORH~1%p6%       MAJORH~1%p7%
%1 %2 %p3% %p4% %p5% MAJORJ~1%p6%       MAJORJ~1%p7%
%1 %2 %p3% %p4% %p5% MAL_EN~1%p6%       MAL_EN~1%p7%
%1 %2 %p3% %p4% %p5% MAL_EN~2%p6%       MAL_EN~2%p7%
%1 %2 %p3% %p4% %p5% MAL_RI~1%p6%       MAL_RI~1%p7%
%1 %2 %p3% %p4% %p5% MALARI~1%p6%       MALARI~1%p7%
%1 %2 %p3% %p4% %p5% MALDEN~1%p6%       MALDEN~1%p7%
%1 %2 %p3% %p4% %p5% MALVEN~1%p6%       MALVEN~1%p7%
%1 %2 %p3% %p4% %p5% MALVEN~2%p6%       MALVEN~2%p7%
%1 %2 %p3% %p4% %p5% MALVEN~3%p6%       MALVEN~3%p7%
%1 %2 %p3% %p4% %p5% MCI32O~1%p6%       MCI32O~1%p7%
%1 %2 %p3% %p4% %p5% MEEPIM~1%p6%       MEEPIM~1%p7%
%1 %2 %p3% %p4% %p5% MEN_ON~1%p6%       MEN_ON~1%p7%
%1 %2 %p3% %p4% %p5% MENTON~1%p6%       MENTON~1%p7%
%1 %2 %p3% %p4% %p5% MENUJP~1%p6%       MENUJP~1%p7%
%1 %2 %p3% %p4% %p5% MIDDLE~1%p6%       MIDDLE~1%p7%
%1 %2 %p3% %p4% %p5% MIDDLE~2%p6%       MIDDLE~2%p7%
%1 %2 %p3% %p4% %p5% MIG_AI~1%p6%       MIG_AI~1%p7%
%1 %2 %p3% %p4% %p5% MIGRAI~1%p6%       MIGRAI~1%p7%
%1 %2 %p3% %p4% %p5% MOISHT~1%p6%       MOISHT~1%p7%
%1 %2 %p3% %p4% %p5% MOISJP~1%p6%       MOISJP~1%p7%
%1 %2 %p3% %p4% %p5% MOL_ET~1%p6%       MOL_ET~1%p7%
%1 %2 %p3% %p4% %p5% MOLLET~1%p6%       MOLLET~1%p7%
%1 %2 %p3% %p4% %p5% MOU_HW~1%p6%       MOU_HW~1%p7%
%1 %2 %p3% %p4% %p5% MOU_TA~1%p6%       MOU_TA~1%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~1%p6%       MOUSTA~1%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~2%p6%       MOUSTA~2%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~3%p6%       MOUSTA~3%p7%
%1 %2 %p3% %p4% %p5% MOUTHH~1%p6%       MOUTHH~1%p7%
%1 %2 %p3% %p4% %p5% MOUTHJ~1%p6%       MOUTHJ~1%p7%
%1 %2 %p3% %p4% %p5% MOUTHW~1%p6%       MOUTHW~1%p7%
%1 %2 %p3% %p4% %p5% MUE_WA~1%p6%       MUE_WA~1%p7%
%1 %2 %p3% %p4% %p5% MUETWA~1%p6%       MUETWA~1%p7%
%1 %2 %p3% %p4% %p5% NAR_NE~1%p6%       NAR_NE~1%p7%
%1 %2 %p3% %p4% %p5% NARINE~1%p6%       NARINE~1%p7%
%1 %2 %p3% %p4% %p5% NAVELH~1%p6%       NAVELH~1%p7%
%1 %2 %p3% %p4% %p5% NAVELJ~1%p6%       NAVELJ~1%p7%
%1 %2 %p3% %p4% %p5% NECKHT~1%p6%       NECKHT~1%p7%
%1 %2 %p3% %p4% %p5% NECKJP~1%p6%       NECKJP~1%p7%
%1 %2 %p3% %p4% %p5% NEDERL~1%p6%       NEDERL~1%p7%
%1 %2 %p3% %p4% %p5% NEDERL~2%p6%       NEDERL~2%p7%
%1 %2 %p3% %p4% %p5% NEDERL~3%p6%       NEDERL~3%p7%
%1 %2 %p3% %p4% %p5% NEZ_WA~1%p6%       NEZ_WA~1%p7%
%1 %2 %p3% %p4% %p5% NEZWAV~1%p6%       NEZWAV~1%p7%
%1 %2 %p3% %p4% %p5% NOM_RI~1%p6%       NOM_RI~1%p7%
%1 %2 %p3% %p4% %p5% NOMBRI~1%p6%       NOMBRI~1%p7%
%1 %2 %p3% %p4% %p5% NORSKD~1%p6%       NORSKD~1%p7%
%1 %2 %p3% %p4% %p5% NOSEHT~1%p6%       NOSEHT~1%p7%
%1 %2 %p3% %p4% %p5% NOSEJP~1%p6%       NOSEJP~1%p7%
%1 %2 %p3% %p4% %p5% NOVIDE~1%p6%       NOVIDE~1%p7%
%1 %2 %p3% %p4% %p5% NOVIDE~2%p6%       NOVIDE~2%p7%
%1 %2 %p3% %p4% %p5% NUMBER~1%p6%       NUMBER~1%p7%
%1 %2 %p3% %p4% %p5% NUMBER~2%p6%       NUMBER~2%p7%
%1 %2 %p3% %p4% %p5% NVIDEO~1%p6%       NVIDEO~1%p7%
%1 %2 %p3% %p4% %p5% NVIDEO~2%p6%       NVIDEO~2%p7%
%1 %2 %p3% %p4% %p5% NYNORS~1%p6%       NYNORS~1%p7%
%1 %2 %p3% %p4% %p5% OEI_WA~1%p6%       OEI_WA~1%p7%
%1 %2 %p3% %p4% %p5% OEILWA~1%p6%       OEILWA~1%p7%
%1 %2 %p3% %p4% %p5% ONG_EW~1%p6%       ONG_EW~1%p7%
%1 %2 %p3% %p4% %p5% ONGLEH~1%p6%       ONGLEH~1%p7%
%1 %2 %p3% %p4% %p5% ONGLEJ~1%p6%       ONGLEJ~1%p7%
%1 %2 %p3% %p4% %p5% ONGLEW~1%p6%       ONGLEW~1%p7%
%1 %2 %p3% %p4% %p5% ORE_LL~1%p6%       ORE_LL~1%p7%
%1 %2 %p3% %p4% %p5% OREILL~1%p6%       OREILL~1%p7%
%1 %2 %p3% %p4% %p5% ORT_IL~1%p6%       ORT_IL~1%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~1%p6%       ORTEIL~1%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~2%p6%       ORTEIL~2%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~3%p6%       ORTEIL~3%p7%
%1 %2 %p3% %p4% %p5% PALMHT~1%p6%       PALMHT~1%p7%
%1 %2 %p3% %p4% %p5% PALMJP~1%p6%       PALMJP~1%p7%
%1 %2 %p3% %p4% %p5% PAS_EG~1%p6%       PAS_EG~1%p7%
%1 %2 %p3% %p4% %p5% PAU_EW~1%p6%       PAU_EW~1%p7%
%1 %2 %p3% %p4% %p5% PAUMEH~1%p6%       PAUMEH~1%p7%
%1 %2 %p3% %p4% %p5% PAUMEJ~1%p6%       PAUMEJ~1%p7%
%1 %2 %p3% %p4% %p5% PAUMEW~1%p6%       PAUMEW~1%p7%
%1 %2 %p3% %p4% %p5% PICTUR~1%p6%       PICTUR~1%p7%
%1 %2 %p3% %p4% %p5% PICTUR~2%p6%       PICTUR~2%p7%
%1 %2 %p3% %p4% %p5% PIE_WA~1%p6%       PIE_WA~1%p7%
%1 %2 %p3% %p4% %p5% PIEDHT~1%p6%       PIEDHT~1%p7%
%1 %2 %p3% %p4% %p5% PIEDJP~1%p6%       PIEDJP~1%p7%
%1 %2 %p3% %p4% %p5% PIEDWA~1%p6%       PIEDWA~1%p7%
%1 %2 %p3% %p4% %p5% PINKRO~1%p6%       PINKRO~1%p7%
%1 %2 %p3% %p4% %p5% PINKRO~2%p6%       PINKRO~2%p7%
%1 %2 %p3% %p4% %p5% POI_NE~1%p6%       POI_NE~1%p7%
%1 %2 %p3% %p4% %p5% POI_RI~1%p6%       POI_RI~1%p7%
%1 %2 %p3% %p4% %p5% POIGNE~1%p6%       POIGNE~1%p7%
%1 %2 %p3% %p4% %p5% POITRI~1%p6%       POITRI~1%p7%
%1 %2 %p3% %p4% %p5% PORTUG~1%p6%       PORTUG~1%p7%
%1 %2 %p3% %p4% %p5% PORTUG~2%p6%       PORTUG~2%p7%
%1 %2 %p3% %p4% %p5% PORTUG~3%p6%       PORTUG~3%p7%
%1 %2 %p3% %p4% %p5% POU_EW~1%p6%       POU_EW~1%p7%
%1 %2 %p3% %p4% %p5% POUCEW~1%p6%       POUCEW~1%p7%
%1 %2 %p3% %p4% %p5% PROFES~1%p6%       PROFES~1%p7%
%1 %2 %p3% %p4% %p5% PROFES~2%p6%       PROFES~2%p7%
%1 %2 %p3% %p4% %p5% PTE_WA~1%p6%       PTE_WA~1%p7%
%1 %2 %p3% %p4% %p5% PTEYHT~1%p6%       PTEYHT~1%p7%
%1 %2 %p3% %p4% %p5% PTEYJP~1%p6%       PTEYJP~1%p7%
%1 %2 %p3% %p4% %p5% QWERTY~1%p6%       QWERTY~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% REDROS~1%p6%       REDROS~1%p7%
%1 %2 %p3% %p4% %p5% REDROS~2%p6%       REDROS~2%p7%
%1 %2 %p3% %p4% %p5% REG_EW~1%p6%       REG_EW~1%p7%
%1 %2 %p3% %p4% %p5% RELIGI~1%p6%       RELIGI~1%p7%
%1 %2 %p3% %p4% %p5% RELIGI~2%p6%       RELIGI~2%p7%
%1 %2 %p3% %p4% %p5% RESTSP~1%p6%       RESTSP~1%p7%
%1 %2 %p3% %p4% %p5% RESTSP~2%p6%       RESTSP~2%p7%
%1 %2 %p3% %p4% %p5% RESTVO~1%p6%       RESTVO~1%p7%
%1 %2 %p3% %p4% %p5% RESTVO~2%p6%       RESTVO~2%p7%
%1 %2 %p3% %p4% %p5% RIBSHT~1%p6%       RIBSHT~1%p7%
%1 %2 %p3% %p4% %p5% RIBSJP~1%p6%       RIBSJP~1%p7%
%1 %2 %p3% %p4% %p5% RINGHT~1%p6%       RINGHT~1%p7%
%1 %2 %p3% %p4% %p5% RINGJP~1%p6%       RINGJP~1%p7%
%1 %2 %p3% %p4% %p5% RUSSIA~1%p6%       RUSSIA~1%p7%
%1 %2 %p3% %p4% %p5% RUSSIA~2%p6%       RUSSIA~2%p7%
%1 %2 %p3% %p4% %p5% SETKEY~1%p6%       SETKEY~1%p7%
%1 %2 %p3% %p4% %p5% SETUPG~1%p6%       SETUPG~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPJ~1%p6%       SETUPJ~1%p7%
%1 %2 %p3% %p4% %p5% SHOULD~1%p6%       SHOULD~1%p7%
%1 %2 %p3% %p4% %p5% SHOULD~2%p6%       SHOULD~2%p7%
%1 %2 %p3% %p4% %p5% SID_WA~1%p6%       SID_WA~1%p7%
%1 %2 %p3% %p4% %p5% SIDAHT~1%p6%       SIDAHT~1%p7%
%1 %2 %p3% %p4% %p5% SIDAJP~1%p6%       SIDAJP~1%p7%
%1 %2 %p3% %p4% %p5% SIDAWA~1%p6%       SIDAWA~1%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~1%p6%       SLOVEN~1%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~2%p6%       SLOVEN~2%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~3%p6%       SLOVEN~3%p7%
%1 %2 %p3% %p4% %p5% SOFTIS~1%p6%       SOFTIS~1%p7%
%1 %2 %p3% %p4% %p5% SOFTIS~2%p6%       SOFTIS~2%p7%
%1 %2 %p3% %p4% %p5% SOU_CI~1%p6%       SOU_CI~1%p7%
%1 %2 %p3% %p4% %p5% SOU_DW~1%p6%       SOU_DW~1%p7%
%1 %2 %p3% %p4% %p5% SOURCI~1%p6%       SOURCI~1%p7%
%1 %2 %p3% %p4% %p5% SOURDW~1%p6%       SOURDW~1%p7%
%1 %2 %p3% %p4% %p5% STARTE~1%p6%       STARTE~1%p7%
%1 %2 %p3% %p4% %p5% STOMAC~1%p6%       STOMAC~1%p7%
%1 %2 %p3% %p4% %p5% STOMAC~2%p6%       STOMAC~2%p7%
%1 %2 %p3% %p4% %p5% STUDEN~1%p6%       STUDEN~1%p7%
%1 %2 %p3% %p4% %p5% SURINT~1%p6%       SURINT~1%p7%
%1 %2 %p3% %p4% %p5% SVENSK~1%p6%       SVENSK~1%p7%
%1 %2 %p3% %p4% %p5% SVENSK~2%p6%       SVENSK~2%p7%
%1 %2 %p3% %p4% %p5% TAI_LE~1%p6%       TAI_LE~1%p7%
%1 %2 %p3% %p4% %p5% TAILLE~1%p6%       TAILLE~1%p7%
%1 %2 %p3% %p4% %p5% TAL_NW~1%p6%       TAL_NW~1%p7%
%1 %2 %p3% %p4% %p5% TALONH~1%p6%       TALONH~1%p7%
%1 %2 %p3% %p4% %p5% TALONJ~1%p6%       TALONJ~1%p7%
%1 %2 %p3% %p4% %p5% TALONW~1%p6%       TALONW~1%p7%
%1 %2 %p3% %p4% %p5% TET_WA~1%p6%       TET_WA~1%p7%
%1 %2 %p3% %p4% %p5% TETEWA~1%p6%       TETEWA~1%p7%
%1 %2 %p3% %p4% %p5% THIGHH~1%p6%       THIGHH~1%p7%
%1 %2 %p3% %p4% %p5% THIGHJ~1%p6%       THIGHJ~1%p7%
%1 %2 %p3% %p4% %p5% THUMBH~1%p6%       THUMBH~1%p7%
%1 %2 %p3% %p4% %p5% THUMBJ~1%p6%       THUMBJ~1%p7%
%1 %2 %p3% %p4% %p5% TOEHTM~1%p6%       TOEHTM~1%p7%
%1 %2 %p3% %p4% %p5% TOEJPG~1%p6%       TOEJPG~1%p7%
%1 %2 %p3% %p4% %p5% TONGUE~1%p6%       TONGUE~1%p7%
%1 %2 %p3% %p4% %p5% TONGUE~2%p6%       TONGUE~2%p7%
%1 %2 %p3% %p4% %p5% TOOTHH~1%p6%       TOOTHH~1%p7%
%1 %2 %p3% %p4% %p5% TOOTHJ~1%p6%       TOOTHJ~1%p7%
%1 %2 %p3% %p4% %p5% TOU_SE~1%p6%       TOU_SE~1%p7%
%1 %2 %p3% %p4% %p5% TOUSSE~1%p6%       TOUSSE~1%p7%
%1 %2 %p3% %p4% %p5% TRE_VE~1%p6%       TRE_VE~1%p7%
%1 %2 %p3% %p4% %p5% TRESVE~1%p6%       TRESVE~1%p7%
%1 %2 %p3% %p4% %p5% TRESVE~2%p6%       TRESVE~2%p7%
%1 %2 %p3% %p4% %p5% TRESVE~3%p6%       TRESVE~3%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~1%p6%       UKRAIN~1%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~2%p6%       UKRAIN~2%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       UNINST~2%p7%
%1 %2 %p3% %p4% %p5% UNINST~3%p6%       UNINST~3%p7%
%1 %2 %p3% %p4% %p5% URI_ER~1%p6%       URI_ER~1%p7%
%1 %2 %p3% %p4% %p5% URINER~1%p6%       URINER~1%p7%
%1 %2 %p3% %p4% %p5% US1999~1%p6%       US1999~1%p7%
%1 %2 %p3% %p4% %p5% US1999~2%p6%       US1999~2%p7%
%1 %2 %p3% %p4% %p5% US1JPG~1%p6%       US1JPG~1%p7%
%1 %2 %p3% %p4% %p5% US2JPG~1%p6%       US2JPG~1%p7%
%1 %2 %p3% %p4% %p5% US3JPG~1%p6%       US3JPG~1%p7%
%1 %2 %p3% %p4% %p5% US4JPG~1%p6%       US4JPG~1%p7%
%1 %2 %p3% %p4% %p5% US5JPG~1%p6%       US5JPG~1%p7%
%1 %2 %p3% %p4% %p5% US6JPG~1%p6%       US6JPG~1%p7%
%1 %2 %p3% %p4% %p5% US7JPG~1%p6%       US7JPG~1%p7%
%1 %2 %p3% %p4% %p5% US8JPG~1%p6%       US8JPG~1%p7%
%1 %2 %p3% %p4% %p5% USERWA~1%p6%       USERWA~1%p7%
%1 %2 %p3% %p4% %p5% USMDB~1%p6%        USMDB~1%p7%
%1 %2 %p3% %p4% %p5% USMSG~1%p6%        USMSG~1%p7%
%1 %2 %p3% %p4% %p5% USUELH~1%p6%       USUELH~1%p7%
%1 %2 %p3% %p4% %p5% USUELJ~1%p6%       USUELJ~1%p7%
%1 %2 %p3% %p4% %p5% VEN_RE~1%p6%       VEN_RE~1%p7%
%1 %2 %p3% %p4% %p5% VENTRE~1%p6%       VENTRE~1%p7%
%1 %2 %p3% %p4% %p5% VER_EB~1%p6%       VER_EB~1%p7%
%1 %2 %p3% %p4% %p5% VER_IG~1%p6%       VER_IG~1%p7%
%1 %2 %p3% %p4% %p5% VERTEB~1%p6%       VERTEB~1%p7%
%1 %2 %p3% %p4% %p5% VERTEB~2%p6%       VERTEB~2%p7%
%1 %2 %p3% %p4% %p5% VERTEB~3%p6%       VERTEB~3%p7%
%1 %2 %p3% %p4% %p5% VERTIG~1%p6%       VERTIG~1%p7%
%1 %2 %p3% %p4% %p5% VOICEJ~1%p6%       VOICEJ~1%p7%
%1 %2 %p3% %p4% %p5% WAISTH~1%p6%       WAISTH~1%p7%
%1 %2 %p3% %p4% %p5% WAISTJ~1%p6%       WAISTJ~1%p7%
%1 %2 %p3% %p4% %p5% WB0051~1%p6%       WB0051~1%p7%
%1 %2 %p3% %p4% %p5% WB01_4~1%p6%       WB01_4~1%p7%
%1 %2 %p3% %p4% %p5% WB0154~1%p6%       WB0154~1%p7%
%1 %2 %p3% %p4% %p5% WB0154~2%p6%       WB0154~2%p7%
%1 %2 %p3% %p4% %p5% WINSTA~1%p6%       WINSTA~1%p7%
%1 %2 %p3% %p4% %p5% WINSTA~2%p6%       WINSTA~2%p7%
%1 %2 %p3% %p4% %p5% WINSTA~3%p6%       WINSTA~3%p7%
%1 %2 %p3% %p4% %p5% WINSTA~4%p6%       WINSTA~4%p7%
%1 %2 %p3% %p4% %p5% WINSTA~5%p6%       WINSTA~5%p7%
%1 %2 %p3% %p4% %p5% WINSTL~1%p6%       WINSTL~1%p7%
%1 %2 %p3% %p4% %p5% WRISTH~1%p6%       WRISTH~1%p7%
%1 %2 %p3% %p4% %p5% WRISTJ~1%p6%       WRISTJ~1%p7%
%1 %2 %p3% %p4% %p5% YORUBA~1%p6%       YORUBA~1%p7%

cd %dir6%

%1 %2 %p3% %p4% %p5% $BMPBG~1%p6%       $BMPBG~1%p7%
%1 %2 %p3% %p4% %p5% $CFXBG~1%p6%       $CFXBG~1%p7%
%1 %2 %p3% %p4% %p5% $CGMBG~1%p6%       $CGMBG~1%p7%
%1 %2 %p3% %p4% %p5% $CLQBG~1%p6%       $CLQBG~1%p7%
%1 %2 %p3% %p4% %p5% $DJBGI~1%p6%       $DJBGI~1%p7%
%1 %2 %p3% %p4% %p5% $DJCBG~1%p6%       $DJCBG~1%p7%
%1 %2 %p3% %p4% %p5% $DXFBG~1%p6%       $DXFBG~1%p7%
%1 %2 %p3% %p4% %p5% $FXBGI~1%p6%       $FXBGI~1%p7%
%1 %2 %p3% %p4% %p5% $HP709~1%p6%       $HP709~1%p7%
%1 %2 %p3% %p4% %p5% $HP747~1%p6%       $HP747~1%p7%
%1 %2 %p3% %p4% %p5% $HP747~2%p6%       $HP747~2%p7%
%1 %2 %p3% %p4% %p5% $HP755~1%p6%       $HP755~1%p7%
%1 %2 %p3% %p4% %p5% $HP758~1%p6%       $HP758~1%p7%
%1 %2 %p3% %p4% %p5% $HP759~1%p6%       $HP759~1%p7%
%1 %2 %p3% %p4% %p5% $IBMQB~1%p6%       $IBMQB~1%p7%
%1 %2 %p3% %p4% %p5% $IMGBG~1%p6%       $IMGBG~1%p7%
%1 %2 %p3% %p4% %p5% $LJ3RB~1%p6%       $LJ3RB~1%p7%
%1 %2 %p3% %p4% %p5% $LJ3RI~1%p6%       $LJ3RI~1%p7%
%1 %2 %p3% %p4% %p5% $LJBGI~1%p6%       $LJBGI~1%p7%
%1 %2 %p3% %p4% %p5% $LJINI~1%p6%       $LJINI~1%p7%
%1 %2 %p3% %p4% %p5% $LQBGI~1%p6%       $LQBGI~1%p7%
%1 %2 %p3% %p4% %p5% $OKI92~1%p6%       $OKI92~1%p7%
%1 %2 %p3% %p4% %p5% $PCXBG~1%p6%       $PCXBG~1%p7%
%1 %2 %p3% %p4% %p5% $PJBGI~1%p6%       $PJBGI~1%p7%
%1 %2 %p3% %p4% %p5% $PP24B~1%p6%       $PP24B~1%p7%
%1 %2 %p3% %p4% %p5% $PSBGI~1%p6%       $PSBGI~1%p7%
%1 %2 %p3% %p4% %p5% $PSINI~1%p6%       $PSINI~1%p7%
%1 %2 %p3% %p4% %p5% $TIFBG~1%p6%       $TIFBG~1%p7%
%1 %2 %p3% %p4% %p5% $TSHBG~1%p6%       $TSHBG~1%p7%
%1 %2 %p3% %p4% %p5% $UTIFB~1%p6%       $UTIFB~1%p7%
%1 %2 %p3% %p4% %p5% $VSHOB~1%p6%       $VSHOB~1%p7%
%1 %2 %p3% %p4% %p5% $VSHOI~1%p6%       $VSHOI~1%p7%
%1 %2 %p3% %p4% %p5% $WPGBG~1%p6%       $WPGBG~1%p7%
%1 %2 %p3% %p4% %p5% 339741~1%p6%       339741~1%p7%
%1 %2 %p3% %p4% %p5% 339741~2%p6%       339741~2%p7%
%1 %2 %p3% %p4% %p5% AFRICA~1%p6%       AFRICA~1%p7%
%1 %2 %p3% %p4% %p5% AFRICA~2%p6%       AFRICA~2%p7%
%1 %2 %p3% %p4% %p5% AFRICA~3%p6%       AFRICA~3%p7%
%1 %2 %p3% %p4% %p5% AFRICA~4%p6%       AFRICA~4%p7%
%1 %2 %p3% %p4% %p5% AFRICA~5%p6%       AFRICA~5%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~1%p6%       AIRPOR~1%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~2%p6%       AIRPOR~2%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~3%p6%       AIRPOR~3%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~4%p6%       AIRPOR~4%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~5%p6%       AIRPOR~5%p7%
%1 %2 %p3% %p4% %p5% ALBANI~1%p6%       ALBANI~1%p7%
%1 %2 %p3% %p4% %p5% ALBANI~2%p6%       ALBANI~2%p7%
%1 %2 %p3% %p4% %p5% AMERIC~1%p6%       AMERIC~1%p7%
%1 %2 %p3% %p4% %p5% ANGOLA~1%p6%       ANGOLA~1%p7%
%1 %2 %p3% %p4% %p5% ARGENT~1%p6%       ARGENT~1%p7%
%1 %2 %p3% %p4% %p5% ASIABN~1%p6%       ASIABN~1%p7%
%1 %2 %p3% %p4% %p5% ATTBGI~1%p6%       ATTBGI~1%p7%
%1 %2 %p3% %p4% %p5% AUSTRA~1%p6%       AUSTRA~1%p7%
%1 %2 %p3% %p4% %p5% AUSTRA~2%p6%       AUSTRA~2%p7%
%1 %2 %p3% %p4% %p5% AUSTRI~1%p6%       AUSTRI~1%p7%
%1 %2 %p3% %p4% %p5% AUSTRI~2%p6%       AUSTRI~2%p7%
%1 %2 %p3% %p4% %p5% BNDCVT~1%p6%       BNDCVT~1%p7%
%1 %2 %p3% %p4% %p5% BOLIVI~1%p6%       BOLIVI~1%p7%
%1 %2 %p3% %p4% %p5% BOTSWA~1%p6%       BOTSWA~1%p7%
%1 %2 %p3% %p4% %p5% BOUNDA~1%p6%       BOUNDA~1%p7%
%1 %2 %p3% %p4% %p5% BOUNDX~1%p6%       BOUNDX~1%p7%
%1 %2 %p3% %p4% %p5% BRAZIL~1%p6%       BRAZIL~1%p7%
%1 %2 %p3% %p4% %p5% BUILDB~1%p6%       BUILDB~1%p7%
%1 %2 %p3% %p4% %p5% BULGAR~1%p6%       BULGAR~1%p7%
%1 %2 %p3% %p4% %p5% BULGAR~2%p6%       BULGAR~2%p7%
%1 %2 %p3% %p4% %p5% BURKIN~1%p6%       BURKIN~1%p7%
%1 %2 %p3% %p4% %p5% BURKIN~2%p6%       BURKIN~2%p7%
%1 %2 %p3% %p4% %p5% C16BV1~1%p6%       C16BV1~1%p7%
%1 %2 %p3% %p4% %p5% C16BV2~1%p6%       C16BV2~1%p7%
%1 %2 %p3% %p4% %p5% C16BV3~1%p6%       C16BV3~1%p7%
%1 %2 %p3% %p4% %p5% C16SV1~1%p6%       C16SV1~1%p7%
%1 %2 %p3% %p4% %p5% C16SV1~2%p6%       C16SV1~2%p7%
%1 %2 %p3% %p4% %p5% C16SV2~1%p6%       C16SV2~1%p7%
%1 %2 %p3% %p4% %p5% C16SV2~2%p6%       C16SV2~2%p7%
%1 %2 %p3% %p4% %p5% C16SV3~1%p6%       C16SV3~1%p7%
%1 %2 %p3% %p4% %p5% C16SV3~2%p6%       C16SV3~2%p7%
%1 %2 %p3% %p4% %p5% C16SV4~1%p6%       C16SV4~1%p7%
%1 %2 %p3% %p4% %p5% C16SV4~2%p6%       C16SV4~2%p7%
%1 %2 %p3% %p4% %p5% C16SV5~1%p6%       C16SV5~1%p7%
%1 %2 %p3% %p4% %p5% C16SV5~2%p6%       C16SV5~2%p7%
%1 %2 %p3% %p4% %p5% C16SV6~1%p6%       C16SV6~1%p7%
%1 %2 %p3% %p4% %p5% C16SV6~2%p6%       C16SV6~2%p7%
%1 %2 %p3% %p4% %p5% C16SV7~1%p6%       C16SV7~1%p7%
%1 %2 %p3% %p4% %p5% C16SV7~2%p6%       C16SV7~2%p7%
%1 %2 %p3% %p4% %p5% C16SV8~1%p6%       C16SV8~1%p7%
%1 %2 %p3% %p4% %p5% C16SV8~2%p6%       C16SV8~2%p7%
%1 %2 %p3% %p4% %p5% C16SV9~1%p6%       C16SV9~1%p7%
%1 %2 %p3% %p4% %p5% C16SV9~2%p6%       C16SV9~2%p7%
%1 %2 %p3% %p4% %p5% C256BV~1%p6%       C256BV~1%p7%
%1 %2 %p3% %p4% %p5% C256BV~2%p6%       C256BV~2%p7%
%1 %2 %p3% %p4% %p5% C256BV~3%p6%       C256BV~3%p7%
%1 %2 %p3% %p4% %p5% C256BV~4%p6%       C256BV~4%p7%
%1 %2 %p3% %p4% %p5% C256BV~5%p6%       C256BV~5%p7%
%1 %2 %p3% %p4% %p5% C256BV~6%p6%       C256BV~6%p7%
%1 %2 %p3% %p4% %p5% C256S~10%p6%       C256S~10%p7%
%1 %2 %p3% %p4% %p5% C256S~11%p6%       C256S~11%p7%
%1 %2 %p3% %p4% %p5% C256S~12%p6%       C256S~12%p7%
%1 %2 %p3% %p4% %p5% C256S~13%p6%       C256S~13%p7%
%1 %2 %p3% %p4% %p5% C256S~14%p6%       C256S~14%p7%
%1 %2 %p3% %p4% %p5% C256S~15%p6%       C256S~15%p7%
%1 %2 %p3% %p4% %p5% C256S~16%p6%       C256S~16%p7%
%1 %2 %p3% %p4% %p5% C256S~17%p6%       C256S~17%p7%
%1 %2 %p3% %p4% %p5% C256S~18%p6%       C256S~18%p7%
%1 %2 %p3% %p4% %p5% C256S~19%p6%       C256S~19%p7%
%1 %2 %p3% %p4% %p5% C256S~20%p6%       C256S~20%p7%
%1 %2 %p3% %p4% %p5% C256SV~1%p6%       C256SV~1%p7%
%1 %2 %p3% %p4% %p5% C256SV~2%p6%       C256SV~2%p7%
%1 %2 %p3% %p4% %p5% C256SV~3%p6%       C256SV~3%p7%
%1 %2 %p3% %p4% %p5% C256SV~4%p6%       C256SV~4%p7%
%1 %2 %p3% %p4% %p5% C256SV~5%p6%       C256SV~5%p7%
%1 %2 %p3% %p4% %p5% C256SV~6%p6%       C256SV~6%p7%
%1 %2 %p3% %p4% %p5% C256SV~7%p6%       C256SV~7%p7%
%1 %2 %p3% %p4% %p5% C256SV~8%p6%       C256SV~8%p7%
%1 %2 %p3% %p4% %p5% C256SV~9%p6%       C256SV~9%p7%
%1 %2 %p3% %p4% %p5% CABND~1%p6%        CABND~1%p7%
%1 %2 %p3% %p4% %p5% CAMBOD~1%p6%       CAMBOD~1%p7%
%1 %2 %p3% %p4% %p5% CAMBOD~2%p6%       CAMBOD~2%p7%
%1 %2 %p3% %p4% %p5% CAMERO~1%p6%       CAMERO~1%p7%
%1 %2 %p3% %p4% %p5% CANARY~1%p6%       CANARY~1%p7%
%1 %2 %p3% %p4% %p5% CANARY~2%p6%       CANARY~2%p7%
%1 %2 %p3% %p4% %p5% CAPITA~1%p6%       CAPITA~1%p7%
%1 %2 %p3% %p4% %p5% CARBND~1%p6%       CARBND~1%p7%
%1 %2 %p3% %p4% %p5% CARDSD~1%p6%       CARDSD~1%p7%
%1 %2 %p3% %p4% %p5% CB5DLL~1%p6%       CB5DLL~1%p7%
%1 %2 %p3% %p4% %p5% CDISK~10%p6%       CDISK~10%p7%
%1 %2 %p3% %p4% %p5% CDISK0~1%p6%       CDISK0~1%p7%
%1 %2 %p3% %p4% %p5% CDISK0~2%p6%       CDISK0~2%p7%
%1 %2 %p3% %p4% %p5% CDISK0~3%p6%       CDISK0~3%p7%
%1 %2 %p3% %p4% %p5% CDISK0~4%p6%       CDISK0~4%p7%
%1 %2 %p3% %p4% %p5% CDISK0~5%p6%       CDISK0~5%p7%
%1 %2 %p3% %p4% %p5% CDISK0~6%p6%       CDISK0~6%p7%
%1 %2 %p3% %p4% %p5% CDISK0~7%p6%       CDISK0~7%p7%
%1 %2 %p3% %p4% %p5% CDISK0~8%p6%       CDISK0~8%p7%
%1 %2 %p3% %p4% %p5% CDISK0~9%p6%       CDISK0~9%p7%
%1 %2 %p3% %p4% %p5% CDISK1~1%p6%       CDISK1~1%p7%
%1 %2 %p3% %p4% %p5% CDISK1~2%p6%       CDISK1~2%p7%
%1 %2 %p3% %p4% %p5% CDISK1~3%p6%       CDISK1~3%p7%
%1 %2 %p3% %p4% %p5% CDISK1~4%p6%       CDISK1~4%p7%
%1 %2 %p3% %p4% %p5% CDISK1~5%p6%       CDISK1~5%p7%
%1 %2 %p3% %p4% %p5% CDISK1~6%p6%       CDISK1~6%p7%
%1 %2 %p3% %p4% %p5% CDISK1~7%p6%       CDISK1~7%p7%
%1 %2 %p3% %p4% %p5% CDISK1~8%p6%       CDISK1~8%p7%
%1 %2 %p3% %p4% %p5% CDISK1~9%p6%       CDISK1~9%p7%
%1 %2 %p3% %p4% %p5% CDISK2~1%p6%       CDISK2~1%p7%
%1 %2 %p3% %p4% %p5% CDISK2~2%p6%       CDISK2~2%p7%
%1 %2 %p3% %p4% %p5% CDISK2~3%p6%       CDISK2~3%p7%
%1 %2 %p3% %p4% %p5% CDISK2~4%p6%       CDISK2~4%p7%
%1 %2 %p3% %p4% %p5% CDISK2~5%p6%       CDISK2~5%p7%
%1 %2 %p3% %p4% %p5% CDISK2~6%p6%       CDISK2~6%p7%
%1 %2 %p3% %p4% %p5% CDISK2~7%p6%       CDISK2~7%p7%
%1 %2 %p3% %p4% %p5% CGABGI~1%p6%       CGABGI~1%p7%
%1 %2 %p3% %p4% %p5% CHILEB~1%p6%       CHILEB~1%p7%
%1 %2 %p3% %p4% %p5% CHINAB~1%p6%       CHINAB~1%p7%
%1 %2 %p3% %p4% %p5% CHINAL~1%p6%       CHINAL~1%p7%
%1 %2 %p3% %p4% %p5% CIRCLE~1%p6%       CIRCLE~1%p7%
%1 %2 %p3% %p4% %p5% CIRCLE~2%p6%       CIRCLE~2%p7%
%1 %2 %p3% %p4% %p5% CITIES~1%p6%       CITIES~1%p7%
%1 %2 %p3% %p4% %p5% CITY_0~1%p6%       CITY_0~1%p7%
%1 %2 %p3% %p4% %p5% CITY_0~2%p6%       CITY_0~2%p7%
%1 %2 %p3% %p4% %p5% CITY_1~1%p6%       CITY_1~1%p7%
%1 %2 %p3% %p4% %p5% CITY_1~2%p6%       CITY_1~2%p7%
%1 %2 %p3% %p4% %p5% CITY_1~3%p6%       CITY_1~3%p7%
%1 %2 %p3% %p4% %p5% CITY_1~4%p6%       CITY_1~4%p7%
%1 %2 %p3% %p4% %p5% CITY_1~5%p6%       CITY_1~5%p7%
%1 %2 %p3% %p4% %p5% CITY_1~6%p6%       CITY_1~6%p7%
%1 %2 %p3% %p4% %p5% CITY_B~1%p6%       CITY_B~1%p7%
%1 %2 %p3% %p4% %p5% CITY_B~2%p6%       CITY_B~2%p7%
%1 %2 %p3% %p4% %p5% CITY_C~1%p6%       CITY_C~1%p7%
%1 %2 %p3% %p4% %p5% CITY_C~2%p6%       CITY_C~2%p7%
%1 %2 %p3% %p4% %p5% CITY_L~1%p6%       CITY_L~1%p7%
%1 %2 %p3% %p4% %p5% CITY1D~1%p6%       CITY1D~1%p7%
%1 %2 %p3% %p4% %p5% CITY2D~1%p6%       CITY2D~1%p7%
%1 %2 %p3% %p4% %p5% CITY3D~1%p6%       CITY3D~1%p7%
%1 %2 %p3% %p4% %p5% CITYCA~1%p6%       CITYCA~1%p7%
%1 %2 %p3% %p4% %p5% CITYCA~2%p6%       CITYCA~2%p7%
%1 %2 %p3% %p4% %p5% CITYCA~3%p6%       CITYCA~3%p7%
%1 %2 %p3% %p4% %p5% CITYCA~4%p6%       CITYCA~4%p7%
%1 %2 %p3% %p4% %p5% CNSDAT~1%p6%       CNSDAT~1%p7%
%1 %2 %p3% %p4% %p5% COLOMB~1%p6%       COLOMB~1%p7%
%1 %2 %p3% %p4% %p5% COLORS~1%p6%       COLORS~1%p7%
%1 %2 %p3% %p4% %p5% COLUMB~1%p6%       COLUMB~1%p7%
%1 %2 %p3% %p4% %p5% COMBIN~1%p6%       COMBIN~1%p7%
%1 %2 %p3% %p4% %p5% COMIND~1%p6%       COMIND~1%p7%
%1 %2 %p3% %p4% %p5% COMIND~2%p6%       COMIND~2%p7%
%1 %2 %p3% %p4% %p5% COMPLE~1%p6%       COMPLE~1%p7%
%1 %2 %p3% %p4% %p5% COMPLE~2%p6%       COMPLE~2%p7%
%1 %2 %p3% %p4% %p5% COMPLE~3%p6%       COMPLE~3%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG~1%p7%
%1 %2 %p3% %p4% %p5% CONGOB~1%p6%       CONGOB~1%p7%
%1 %2 %p3% %p4% %p5% COORDC~1%p6%       COORDC~1%p7%
%1 %2 %p3% %p4% %p5% COORDC~2%p6%       COORDC~2%p7%
%1 %2 %p3% %p4% %p5% COPYMA~1%p6%       COPYMA~1%p7%
%1 %2 %p3% %p4% %p5% COUNTR~1%p6%       COUNTR~1%p7%
%1 %2 %p3% %p4% %p5% COUNTR~2%p6%       COUNTR~2%p7%
%1 %2 %p3% %p4% %p5% COUNTR~3%p6%       COUNTR~3%p7%
%1 %2 %p3% %p4% %p5% COUNTR~4%p6%       COUNTR~4%p7%
%1 %2 %p3% %p4% %p5% COUNTR~5%p6%       COUNTR~5%p7%
%1 %2 %p3% %p4% %p5% COUNTR~6%p6%       COUNTR~6%p7%
%1 %2 %p3% %p4% %p5% COUNTY~1%p6%       COUNTY~1%p7%
%1 %2 %p3% %p4% %p5% COUNTY~2%p6%       COUNTY~2%p7%
%1 %2 %p3% %p4% %p5% COUNTY~3%p6%       COUNTY~3%p7%
%1 %2 %p3% %p4% %p5% COUNTY~4%p6%       COUNTY~4%p7%
%1 %2 %p3% %p4% %p5% COUR_C~1%p6%       COUR_C~1%p7%
%1 %2 %p3% %p4% %p5% COUR_E~1%p6%       COUR_E~1%p7%
%1 %2 %p3% %p4% %p5% COUR_V~1%p6%       COUR_V~1%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~1%p6%       CSIMBV~1%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~2%p6%       CSIMBV~2%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~3%p6%       CSIMBV~3%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~4%p6%       CSIMBV~4%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~5%p6%       CSIMBV~5%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~6%p6%       CSIMBV~6%p7%
%1 %2 %p3% %p4% %p5% CSIMS~10%p6%       CSIMS~10%p7%
%1 %2 %p3% %p4% %p5% CSIMS~11%p6%       CSIMS~11%p7%
%1 %2 %p3% %p4% %p5% CSIMS~12%p6%       CSIMS~12%p7%
%1 %2 %p3% %p4% %p5% CSIMS~13%p6%       CSIMS~13%p7%
%1 %2 %p3% %p4% %p5% CSIMS~14%p6%       CSIMS~14%p7%
%1 %2 %p3% %p4% %p5% CSIMS~15%p6%       CSIMS~15%p7%
%1 %2 %p3% %p4% %p5% CSIMS~16%p6%       CSIMS~16%p7%
%1 %2 %p3% %p4% %p5% CSIMS~17%p6%       CSIMS~17%p7%
%1 %2 %p3% %p4% %p5% CSIMS~18%p6%       CSIMS~18%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~1%p6%       CSIMSV~1%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~2%p6%       CSIMSV~2%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~3%p6%       CSIMSV~3%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~4%p6%       CSIMSV~4%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~5%p6%       CSIMSV~5%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~6%p6%       CSIMSV~6%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~7%p6%       CSIMSV~7%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~8%p6%       CSIMSV~8%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~9%p6%       CSIMSV~9%p7%
%1 %2 %p3% %p4% %p5% CUBABN~1%p6%       CUBABN~1%p7%
%1 %2 %p3% %p4% %p5% CUBALL~1%p6%       CUBALL~1%p7%
%1 %2 %p3% %p4% %p5% CULTUR~1%p6%       CULTUR~1%p7%
%1 %2 %p3% %p4% %p5% CULTUR~2%p6%       CULTUR~2%p7%
%1 %2 %p3% %p4% %p5% CULTUR~3%p6%       CULTUR~3%p7%
%1 %2 %p3% %p4% %p5% CZECHO~1%p6%       CZECHO~1%p7%
%1 %2 %p3% %p4% %p5% CZECHO~2%p6%       CZECHO~2%p7%
%1 %2 %p3% %p4% %p5% CZVGAS~1%p6%       CZVGAS~1%p7%
%1 %2 %p3% %p4% %p5% DASHED~1%p6%       DASHED~1%p7%
%1 %2 %p3% %p4% %p5% DAYSIM~1%p6%       DAYSIM~1%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       DEFAUL~1%p7%
%1 %2 %p3% %p4% %p5% DEFHAR~1%p6%       DEFHAR~1%p7%
%1 %2 %p3% %p4% %p5% DEMO10~1%p6%       DEMO10~1%p7%
%1 %2 %p3% %p4% %p5% DEMO10~2%p6%       DEMO10~2%p7%
%1 %2 %p3% %p4% %p5% DEMO11~1%p6%       DEMO11~1%p7%
%1 %2 %p3% %p4% %p5% DEMO11~2%p6%       DEMO11~2%p7%
%1 %2 %p3% %p4% %p5% DEMO12~1%p6%       DEMO12~1%p7%
%1 %2 %p3% %p4% %p5% DEMO12~2%p6%       DEMO12~2%p7%
%1 %2 %p3% %p4% %p5% DEMO12~3%p6%       DEMO12~3%p7%
%1 %2 %p3% %p4% %p5% DEMO12~4%p6%       DEMO12~4%p7%
%1 %2 %p3% %p4% %p5% DEMO13~1%p6%       DEMO13~1%p7%
%1 %2 %p3% %p4% %p5% DEMO13~2%p6%       DEMO13~2%p7%
%1 %2 %p3% %p4% %p5% DEMO15~1%p6%       DEMO15~1%p7%
%1 %2 %p3% %p4% %p5% DEMO15~2%p6%       DEMO15~2%p7%
%1 %2 %p3% %p4% %p5% DEMO1R~1%p6%       DEMO1R~1%p7%
%1 %2 %p3% %p4% %p5% DEMO20~1%p6%       DEMO20~1%p7%
%1 %2 %p3% %p4% %p5% DEMO20~2%p6%       DEMO20~2%p7%
%1 %2 %p3% %p4% %p5% DEMO22~1%p6%       DEMO22~1%p7%
%1 %2 %p3% %p4% %p5% DEMO22~2%p6%       DEMO22~2%p7%
%1 %2 %p3% %p4% %p5% DEMO23~1%p6%       DEMO23~1%p7%
%1 %2 %p3% %p4% %p5% DEMO23~2%p6%       DEMO23~2%p7%
%1 %2 %p3% %p4% %p5% DEMO25~1%p6%       DEMO25~1%p7%
%1 %2 %p3% %p4% %p5% DEMO25~2%p6%       DEMO25~2%p7%
%1 %2 %p3% %p4% %p5% DEMO30~1%p6%       DEMO30~1%p7%
%1 %2 %p3% %p4% %p5% DEMO30~2%p6%       DEMO30~2%p7%
%1 %2 %p3% %p4% %p5% DEMO40~1%p6%       DEMO40~1%p7%
%1 %2 %p3% %p4% %p5% DEMO40~2%p6%       DEMO40~2%p7%
%1 %2 %p3% %p4% %p5% DEMO45~1%p6%       DEMO45~1%p7%
%1 %2 %p3% %p4% %p5% DEMO45~2%p6%       DEMO45~2%p7%
%1 %2 %p3% %p4% %p5% DEMO50~1%p6%       DEMO50~1%p7%
%1 %2 %p3% %p4% %p5% DEMO50~2%p6%       DEMO50~2%p7%
%1 %2 %p3% %p4% %p5% DEMO52~1%p6%       DEMO52~1%p7%
%1 %2 %p3% %p4% %p5% DEMO52~2%p6%       DEMO52~2%p7%
%1 %2 %p3% %p4% %p5% DEMO55~1%p6%       DEMO55~1%p7%
%1 %2 %p3% %p4% %p5% DEMO55~2%p6%       DEMO55~2%p7%
%1 %2 %p3% %p4% %p5% DEMO60~1%p6%       DEMO60~1%p7%
%1 %2 %p3% %p4% %p5% DEMO60~2%p6%       DEMO60~2%p7%
%1 %2 %p3% %p4% %p5% DEMO61~1%p6%       DEMO61~1%p7%
%1 %2 %p3% %p4% %p5% DEMO61~2%p6%       DEMO61~2%p7%
%1 %2 %p3% %p4% %p5% DEMO62~1%p6%       DEMO62~1%p7%
%1 %2 %p3% %p4% %p5% DEMO62~2%p6%       DEMO62~2%p7%
%1 %2 %p3% %p4% %p5% DEMO70~1%p6%       DEMO70~1%p7%
%1 %2 %p3% %p4% %p5% DEMO70~2%p6%       DEMO70~2%p7%
%1 %2 %p3% %p4% %p5% DEMO75~1%p6%       DEMO75~1%p7%
%1 %2 %p3% %p4% %p5% DEMO75~2%p6%       DEMO75~2%p7%
%1 %2 %p3% %p4% %p5% DEMO80~1%p6%       DEMO80~1%p7%
%1 %2 %p3% %p4% %p5% DEMO80~2%p6%       DEMO80~2%p7%
%1 %2 %p3% %p4% %p5% DEMO85~1%p6%       DEMO85~1%p7%
%1 %2 %p3% %p4% %p5% DEMO85~2%p6%       DEMO85~2%p7%
%1 %2 %p3% %p4% %p5% DEMO98~1%p6%       DEMO98~1%p7%
%1 %2 %p3% %p4% %p5% DEMOAD~1%p6%       DEMOAD~1%p7%
%1 %2 %p3% %p4% %p5% DEMOAT~1%p6%       DEMOAT~1%p7%
%1 %2 %p3% %p4% %p5% DEMOBN~1%p6%       DEMOBN~1%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~1%p6%       DEMOCO~1%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~2%p6%       DEMOCO~2%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~3%p6%       DEMOCO~3%p7%
%1 %2 %p3% %p4% %p5% DEMODE~1%p6%       DEMODE~1%p7%
%1 %2 %p3% %p4% %p5% DEMODO~1%p6%       DEMODO~1%p7%
%1 %2 %p3% %p4% %p5% DEMOFC~1%p6%       DEMOFC~1%p7%
%1 %2 %p3% %p4% %p5% DEMOFI~1%p6%       DEMOFI~1%p7%
%1 %2 %p3% %p4% %p5% DEMOGI~1%p6%       DEMOGI~1%p7%
%1 %2 %p3% %p4% %p5% DEMOLA~1%p6%       DEMOLA~1%p7%
%1 %2 %p3% %p4% %p5% DEMOLI~1%p6%       DEMOLI~1%p7%
%1 %2 %p3% %p4% %p5% DEMOMP~1%p6%       DEMOMP~1%p7%
%1 %2 %p3% %p4% %p5% DEMOMT~1%p6%       DEMOMT~1%p7%
%1 %2 %p3% %p4% %p5% DEMONA~1%p6%       DEMONA~1%p7%
%1 %2 %p3% %p4% %p5% DEMOPO~1%p6%       DEMOPO~1%p7%
%1 %2 %p3% %p4% %p5% DEMORE~1%p6%       DEMORE~1%p7%
%1 %2 %p3% %p4% %p5% DEMOSA~1%p6%       DEMOSA~1%p7%
%1 %2 %p3% %p4% %p5% DEMOSA~2%p6%       DEMOSA~2%p7%
%1 %2 %p3% %p4% %p5% DEMOTE~1%p6%       DEMOTE~1%p7%
%1 %2 %p3% %p4% %p5% DEMOTY~1%p6%       DEMOTY~1%p7%
%1 %2 %p3% %p4% %p5% DEMOZO~1%p6%       DEMOZO~1%p7%
%1 %2 %p3% %p4% %p5% DEMOZS~1%p6%       DEMOZS~1%p7%
%1 %2 %p3% %p4% %p5% DIAMON~1%p6%       DIAMON~1%p7%
%1 %2 %p3% %p4% %p5% DIAMON~2%p6%       DIAMON~2%p7%
%1 %2 %p3% %p4% %p5% DISK01~1%p6%       DISK01~1%p7%
%1 %2 %p3% %p4% %p5% DISK02~1%p6%       DISK02~1%p7%
%1 %2 %p3% %p4% %p5% DISK03~1%p6%       DISK03~1%p7%
%1 %2 %p3% %p4% %p5% DISK04~1%p6%       DISK04~1%p7%
%1 %2 %p3% %p4% %p5% DISK05~1%p6%       DISK05~1%p7%
%1 %2 %p3% %p4% %p5% DISK06~1%p6%       DISK06~1%p7%
%1 %2 %p3% %p4% %p5% DISK07~1%p6%       DISK07~1%p7%
%1 %2 %p3% %p4% %p5% DISK08~1%p6%       DISK08~1%p7%
%1 %2 %p3% %p4% %p5% DISK09~1%p6%       DISK09~1%p7%
%1 %2 %p3% %p4% %p5% DISK10~1%p6%       DISK10~1%p7%
%1 %2 %p3% %p4% %p5% DISK11~1%p6%       DISK11~1%p7%
%1 %2 %p3% %p4% %p5% DISK12~1%p6%       DISK12~1%p7%
%1 %2 %p3% %p4% %p5% DISK13~1%p6%       DISK13~1%p7%
%1 %2 %p3% %p4% %p5% DISK14~1%p6%       DISK14~1%p7%
%1 %2 %p3% %p4% %p5% DISK15~1%p6%       DISK15~1%p7%
%1 %2 %p3% %p4% %p5% DISK16~1%p6%       DISK16~1%p7%
%1 %2 %p3% %p4% %p5% DISK17~1%p6%       DISK17~1%p7%
%1 %2 %p3% %p4% %p5% DISK18~1%p6%       DISK18~1%p7%
%1 %2 %p3% %p4% %p5% DISK19~1%p6%       DISK19~1%p7%
%1 %2 %p3% %p4% %p5% DISK20~1%p6%       DISK20~1%p7%
%1 %2 %p3% %p4% %p5% DISK21~1%p6%       DISK21~1%p7%
%1 %2 %p3% %p4% %p5% DISK22~1%p6%       DISK22~1%p7%
%1 %2 %p3% %p4% %p5% DISK23~1%p6%       DISK23~1%p7%
%1 %2 %p3% %p4% %p5% DISK24~1%p6%       DISK24~1%p7%
%1 %2 %p3% %p4% %p5% DISK25~1%p6%       DISK25~1%p7%
%1 %2 %p3% %p4% %p5% DISK26~1%p6%       DISK26~1%p7%
%1 %2 %p3% %p4% %p5% DOUBLE~1%p6%       DOUBLE~1%p7%
%1 %2 %p3% %p4% %p5% DPMI16~1%p6%       DPMI16~1%p7%
%1 %2 %p3% %p4% %p5% DRAINP~1%p6%       DRAINP~1%p7%
%1 %2 %p3% %p4% %p5% DRAINP~2%p6%       DRAINP~2%p7%
%1 %2 %p3% %p4% %p5% DRAINP~3%p6%       DRAINP~3%p7%
%1 %2 %p3% %p4% %p5% DRAINT~1%p6%       DRAINT~1%p7%
%1 %2 %p3% %p4% %p5% DRAINT~2%p6%       DRAINT~2%p7%
%1 %2 %p3% %p4% %p5% DRAINT~3%p6%       DRAINT~3%p7%
%1 %2 %p3% %p4% %p5% DS1DOC~1%p6%       DS1DOC~1%p7%
%1 %2 %p3% %p4% %p5% DS2DOC~1%p6%       DS2DOC~1%p7%
%1 %2 %p3% %p4% %p5% DS3DOC~1%p6%       DS3DOC~1%p7%
%1 %2 %p3% %p4% %p5% DS4DOC~1%p6%       DS4DOC~1%p7%
%1 %2 %p3% %p4% %p5% DUPLEX~1%p6%       DUPLEX~1%p7%
%1 %2 %p3% %p4% %p5% ECUADO~1%p6%       ECUADO~1%p7%
%1 %2 %p3% %p4% %p5% EGAINT~1%p6%       EGAINT~1%p7%
%1 %2 %p3% %p4% %p5% EGAOZG~1%p6%       EGAOZG~1%p7%
%1 %2 %p3% %p4% %p5% EGASCN~1%p6%       EGASCN~1%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~1%p6%       EGAVGA~1%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~1%p6%       EMAPIN~1%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~2%p6%       EMAPIN~2%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~3%p6%       EMAPIN~3%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~1%p6%       EPIMAP~1%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~2%p6%       EPIMAP~2%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~3%p6%       EPIMAP~3%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~4%p6%       EPIMAP~4%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~5%p6%       EPIMAP~5%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~6%p6%       EPIMAP~6%p7%
%1 %2 %p3% %p4% %p5% EUROPE~1%p6%       EUROPE~1%p7%
%1 %2 %p3% %p4% %p5% EXTEND~1%p6%       EXTEND~1%p7%
%1 %2 %p3% %p4% %p5% FALKLA~1%p6%       FALKLA~1%p7%
%1 %2 %p3% %p4% %p5% FEA-AD~1%p6%       FEA-AD~1%p7%
%1 %2 %p3% %p4% %p5% FEA-GD~1%p6%       FEA-GD~1%p7%
%1 %2 %p3% %p4% %p5% FEAATT~1%p6%       FEAATT~1%p7%
%1 %2 %p3% %p4% %p5% FEAGEO~1%p6%       FEAGEO~1%p7%
%1 %2 %p3% %p4% %p5% FGUIAN~1%p6%       FGUIAN~1%p7%
%1 %2 %p3% %p4% %p5% FIGEDI~1%p6%       FIGEDI~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_I~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_I~3%p7%
%1 %2 %p3% %p4% %p5% FNKEYS~1%p6%       FNKEYS~1%p7%
%1 %2 %p3% %p4% %p5% FRANCE~1%p6%       FRANCE~1%p7%
%1 %2 %p3% %p4% %p5% FRANCE~2%p6%       FRANCE~2%p7%
%1 %2 %p3% %p4% %p5% GARMIN~1%p6%       GARMIN~1%p7%
%1 %2 %p3% %p4% %p5% GARMIN~2%p6%       GARMIN~2%p7%
%1 %2 %p3% %p4% %p5% GDHEAD~1%p6%       GDHEAD~1%p7%
%1 %2 %p3% %p4% %p5% GDHEAD~2%p6%       GDHEAD~2%p7%
%1 %2 %p3% %p4% %p5% GEOCOD~1%p6%       GEOCOD~1%p7%
%1 %2 %p3% %p4% %p5% GEORGI~1%p6%       GEORGI~1%p7%
%1 %2 %p3% %p4% %p5% GEORGI~2%p6%       GEORGI~2%p7%
%1 %2 %p3% %p4% %p5% GEOTOE~1%p6%       GEOTOE~1%p7%
%1 %2 %p3% %p4% %p5% GEOTOM~1%p6%       GEOTOM~1%p7%
%1 %2 %p3% %p4% %p5% GERMAN~1%p6%       GERMAN~1%p7%
%1 %2 %p3% %p4% %p5% GERMAN~2%p6%       GERMAN~2%p7%
%1 %2 %p3% %p4% %p5% GETMOD~1%p6%       GETMOD~1%p7%
%1 %2 %p3% %p4% %p5% GOOSES~1%p6%       GOOSES~1%p7%
%1 %2 %p3% %p4% %p5% GPS1LO~1%p6%       GPS1LO~1%p7%
%1 %2 %p3% %p4% %p5% GPS2NM~1%p6%       GPS2NM~1%p7%
%1 %2 %p3% %p4% %p5% GPS3NM~1%p6%       GPS3NM~1%p7%
%1 %2 %p3% %p4% %p5% GPSCGA~1%p6%       GPSCGA~1%p7%
%1 %2 %p3% %p4% %p5% GPSCGA~2%p6%       GPSCGA~2%p7%
%1 %2 %p3% %p4% %p5% GPSEXE~1%p6%       GPSEXE~1%p7%
%1 %2 %p3% %p4% %p5% GPSLOG~1%p6%       GPSLOG~1%p7%
%1 %2 %p3% %p4% %p5% GRIDCG~1%p6%       GRIDCG~1%p7%
%1 %2 %p3% %p4% %p5% GROUPS~1%p6%       GROUPS~1%p7%
%1 %2 %p3% %p4% %p5% GUAMAD~1%p6%       GUAMAD~1%p7%
%1 %2 %p3% %p4% %p5% GUAMVB~1%p6%       GUAMVB~1%p7%
%1 %2 %p3% %p4% %p5% GUINEA~1%p6%       GUINEA~1%p7%
%1 %2 %p3% %p4% %p5% GUYANA~1%p6%       GUYANA~1%p7%
%1 %2 %p3% %p4% %p5% HATCHB~1%p6%       HATCHB~1%p7%
%1 %2 %p3% %p4% %p5% HATCHB~2%p6%       HATCHB~2%p7%
%1 %2 %p3% %p4% %p5% HATCHS~1%p6%       HATCHS~1%p7%
%1 %2 %p3% %p4% %p5% HATCHS~2%p6%       HATCHS~2%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~1%p6%       HAWDLG~1%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~2%p6%       HAWDLG~2%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~3%p6%       HAWDLG~3%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~4%p6%       HAWDLG~4%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~5%p6%       HAWDLG~5%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~6%p6%       HAWDLG~6%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~7%p6%       HAWDLG~7%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~8%p6%       HAWDLG~8%p7%
%1 %2 %p3% %p4% %p5% HBARDA~1%p6%       HBARDA~1%p7%
%1 %2 %p3% %p4% %p5% HBARMR~1%p6%       HBARMR~1%p7%
%1 %2 %p3% %p4% %p5% HELV_C~1%p6%       HELV_C~1%p7%
%1 %2 %p3% %p4% %p5% HELV_E~1%p6%       HELV_E~1%p7%
%1 %2 %p3% %p4% %p5% HELV_V~1%p6%       HELV_V~1%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~1%p6%       HEPRAT~1%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~2%p6%       HEPRAT~2%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~3%p6%       HEPRAT~3%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~4%p6%       HEPRAT~4%p7%
%1 %2 %p3% %p4% %p5% HERCBG~1%p6%       HERCBG~1%p7%
%1 %2 %p3% %p4% %p5% HONDUR~1%p6%       HONDUR~1%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~1%p6%       HOSPIT~1%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~2%p6%       HOSPIT~2%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~3%p6%       HOSPIT~3%p7%
%1 %2 %p3% %p4% %p5% HUNGAR~1%p6%       HUNGAR~1%p7%
%1 %2 %p3% %p4% %p5% HUNGAR~2%p6%       HUNGAR~2%p7%
%1 %2 %p3% %p4% %p5% IBM851~1%p6%       IBM851~1%p7%
%1 %2 %p3% %p4% %p5% INDEXD~1%p6%       INDEXD~1%p7%
%1 %2 %p3% %p4% %p5% INDONE~1%p6%       INDONE~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTAL~2%p7%
%1 %2 %p3% %p4% %p5% INTERA~1%p6%       INTERA~1%p7%
%1 %2 %p3% %p4% %p5% IRANBN~1%p6%       IRANBN~1%p7%
%1 %2 %p3% %p4% %p5% IRANLL~1%p6%       IRANLL~1%p7%
%1 %2 %p3% %p4% %p5% IVORYB~1%p6%       IVORYB~1%p7%
%1 %2 %p3% %p4% %p5% KENYAB~1%p6%       KENYAB~1%p7%
%1 %2 %p3% %p4% %p5% LAND_C~1%p6%       LAND_C~1%p7%
%1 %2 %p3% %p4% %p5% LAND_C~2%p6%       LAND_C~2%p7%
%1 %2 %p3% %p4% %p5% LAND_C~3%p6%       LAND_C~3%p7%
%1 %2 %p3% %p4% %p5% LAOSBN~1%p6%       LAOSBN~1%p7%
%1 %2 %p3% %p4% %p5% LAOSLL~1%p6%       LAOSLL~1%p7%
%1 %2 %p3% %p4% %p5% LIBERI~1%p6%       LIBERI~1%p7%
%1 %2 %p3% %p4% %p5% LIBYAB~1%p6%       LIBYAB~1%p7%
%1 %2 %p3% %p4% %p5% LIBYAL~1%p6%       LIBYAL~1%p7%
%1 %2 %p3% %p4% %p5% LINETY~1%p6%       LINETY~1%p7%
%1 %2 %p3% %p4% %p5% LOGOSY~1%p6%       LOGOSY~1%p7%
%1 %2 %p3% %p4% %p5% LOWE-A~1%p6%       LOWE-A~1%p7%
%1 %2 %p3% %p4% %p5% LOWE-A~2%p6%       LOWE-A~2%p7%
%1 %2 %p3% %p4% %p5% LOWE-G~1%p6%       LOWE-G~1%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~1%p6%       LOWE-S~1%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~2%p6%       LOWE-S~2%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~3%p6%       LOWE-S~3%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~4%p6%       LOWE-S~4%p7%
%1 %2 %p3% %p4% %p5% LOWE1A~1%p6%       LOWE1A~1%p7%
%1 %2 %p3% %p4% %p5% LOWE2A~1%p6%       LOWE2A~1%p7%
%1 %2 %p3% %p4% %p5% LOWEGE~1%p6%       LOWEGE~1%p7%
%1 %2 %p3% %p4% %p5% MADAGA~1%p6%       MADAGA~1%p7%
%1 %2 %p3% %p4% %p5% MAF000~1%p6%       MAF000~1%p7%
%1 %2 %p3% %p4% %p5% MALAWI~1%p6%       MALAWI~1%p7%
%1 %2 %p3% %p4% %p5% MALAYE~1%p6%       MALAYE~1%p7%
%1 %2 %p3% %p4% %p5% MALAYS~1%p6%       MALAYS~1%p7%
%1 %2 %p3% %p4% %p5% MALAYW~1%p6%       MALAYW~1%p7%
%1 %2 %p3% %p4% %p5% MALIBN~1%p6%       MALIBN~1%p7%
%1 %2 %p3% %p4% %p5% MAPDAT~1%p6%       MAPDAT~1%p7%
%1 %2 %p3% %p4% %p5% MAPIT7~1%p6%       MAPIT7~1%p7%
%1 %2 %p3% %p4% %p5% MAPITB~1%p6%       MAPITB~1%p7%
%1 %2 %p3% %p4% %p5% MAPITD~1%p6%       MAPITD~1%p7%
%1 %2 %p3% %p4% %p5% MAPITS~1%p6%       MAPITS~1%p7%
%1 %2 %p3% %p4% %p5% MAPITT~1%p6%       MAPITT~1%p7%
%1 %2 %p3% %p4% %p5% MCGASC~1%p6%       MCGASC~1%p7%
%1 %2 %p3% %p4% %p5% MEXICO~1%p6%       MEXICO~1%p7%
%1 %2 %p3% %p4% %p5% MEXICO~2%p6%       MEXICO~2%p7%
%1 %2 %p3% %p4% %p5% MHRSCN~1%p6%       MHRSCN~1%p7%
%1 %2 %p3% %p4% %p5% MINDEF~1%p6%       MINDEF~1%p7%
%1 %2 %p3% %p4% %p5% MONGOL~1%p6%       MONGOL~1%p7%
%1 %2 %p3% %p4% %p5% MONGOL~2%p6%       MONGOL~2%p7%
%1 %2 %p3% %p4% %p5% MOZAMB~1%p6%       MOZAMB~1%p7%
%1 %2 %p3% %p4% %p5% MP1TOM~1%p6%       MP1TOM~1%p7%
%1 %2 %p3% %p4% %p5% MSHERC~1%p6%       MSHERC~1%p7%
%1 %2 %p3% %p4% %p5% MYPINS~1%p6%       MYPINS~1%p7%
%1 %2 %p3% %p4% %p5% MYPINS~2%p6%       MYPINS~2%p7%
%1 %2 %p3% %p4% %p5% MYPINS~3%p6%       MYPINS~3%p7%
%1 %2 %p3% %p4% %p5% NABLAD~1%p6%       NABLAD~1%p7%
%1 %2 %p3% %p4% %p5% NABLAM~1%p6%       NABLAM~1%p7%
%1 %2 %p3% %p4% %p5% NAMIBI~1%p6%       NAMIBI~1%p7%
%1 %2 %p3% %p4% %p5% NEWYOR~1%p6%       NEWYOR~1%p7%
%1 %2 %p3% %p4% %p5% NEWYOR~2%p6%       NEWYOR~2%p7%
%1 %2 %p3% %p4% %p5% NIGERI~1%p6%       NIGERI~1%p7%
%1 %2 %p3% %p4% %p5% NKOREA~1%p6%       NKOREA~1%p7%
%1 %2 %p3% %p4% %p5% NKOREA~2%p6%       NKOREA~2%p7%
%1 %2 %p3% %p4% %p5% NMETOM~1%p6%       NMETOM~1%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~1%p6%       OCEAN_~1%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~2%p6%       OCEAN_~2%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~3%p6%       OCEAN_~3%p7%
%1 %2 %p3% %p4% %p5% ORBITS~1%p6%       ORBITS~1%p7%
%1 %2 %p3% %p4% %p5% ORBITS~2%p6%       ORBITS~2%p7%
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       ORDER_~1%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       ORDERD~1%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERF~1%p7%
%1 %2 %p3% %p4% %p5% OZ-ADA~1%p6%       OZ-ADA~1%p7%
%1 %2 %p3% %p4% %p5% OZ-GDA~1%p6%       OZ-GDA~1%p7%
%1 %2 %p3% %p4% %p5% OZAPID~1%p6%       OZAPID~1%p7%
%1 %2 %p3% %p4% %p5% OZATT~1%p6%        OZATT~1%p7%
%1 %2 %p3% %p4% %p5% OZCENS~1%p6%       OZCENS~1%p7%
%1 %2 %p3% %p4% %p5% OZCENS~2%p6%       OZCENS~2%p7%
%1 %2 %p3% %p4% %p5% OZCMB~1%p6%        OZCMB~1%p7%
%1 %2 %p3% %p4% %p5% OZDEMO~1%p6%       OZDEMO~1%p7%
%1 %2 %p3% %p4% %p5% OZENTE~1%p6%       OZENTE~1%p7%
%1 %2 %p3% %p4% %p5% OZGEO~1%p6%        OZGEO~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS~10%p6%       OZGIS~10%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~1%p6%       OZGIS1~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~2%p6%       OZGIS1~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~3%p6%       OZGIS1~3%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~4%p6%       OZGIS1~4%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~5%p6%       OZGIS1~5%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~6%p6%       OZGIS1~6%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~1%p6%       OZGIS2~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~2%p6%       OZGIS2~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~3%p6%       OZGIS2~3%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~4%p6%       OZGIS2~4%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~5%p6%       OZGIS2~5%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~6%p6%       OZGIS2~6%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~7%p6%       OZGIS2~7%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~8%p6%       OZGIS2~8%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~9%p6%       OZGIS2~9%p7%
%1 %2 %p3% %p4% %p5% OZGIS3~1%p6%       OZGIS3~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS3~2%p6%       OZGIS3~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS4~1%p6%       OZGIS4~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS5~1%p6%       OZGIS5~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS5~2%p6%       OZGIS5~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS6~1%p6%       OZGIS6~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS6~2%p6%       OZGIS6~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS7~1%p6%       OZGIS7~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS7~2%p6%       OZGIS7~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS8~1%p6%       OZGIS8~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS8~2%p6%       OZGIS8~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~1%p6%       OZGIS9~1%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~2%p6%       OZGIS9~2%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~3%p6%       OZGIS9~3%p7%
%1 %2 %p3% %p4% %p5% OZGISB~1%p6%       OZGISB~1%p7%
%1 %2 %p3% %p4% %p5% OZGISC~1%p6%       OZGISC~1%p7%
%1 %2 %p3% %p4% %p5% OZGISD~1%p6%       OZGISD~1%p7%
%1 %2 %p3% %p4% %p5% OZGISI~1%p6%       OZGISI~1%p7%
%1 %2 %p3% %p4% %p5% OZGISM~1%p6%       OZGISM~1%p7%
%1 %2 %p3% %p4% %p5% OZGISP~1%p6%       OZGISP~1%p7%
%1 %2 %p3% %p4% %p5% OZWHIC~1%p6%       OZWHIC~1%p7%
%1 %2 %p3% %p4% %p5% PAKIST~1%p6%       PAKIST~1%p7%
%1 %2 %p3% %p4% %p5% PAKIST~2%p6%       PAKIST~2%p7%
%1 %2 %p3% %p4% %p5% PARAGU~1%p6%       PARAGU~1%p7%
%1 %2 %p3% %p4% %p5% PC3270~1%p6%       PC3270~1%p7%
%1 %2 %p3% %p4% %p5% PERUBN~1%p6%       PERUBN~1%p7%
%1 %2 %p3% %p4% %p5% PLACEN~1%p6%       PLACEN~1%p7%
%1 %2 %p3% %p4% %p5% PLUSDA~1%p6%       PLUSDA~1%p7%
%1 %2 %p3% %p4% %p5% PLUSMR~1%p6%       PLUSMR~1%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~1%p6%       PO_TEX~1%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~2%p6%       PO_TEX~2%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~3%p6%       PO_TEX~3%p7%
%1 %2 %p3% %p4% %p5% POLAND~1%p6%       POLAND~1%p7%
%1 %2 %p3% %p4% %p5% POPPLA~1%p6%       POPPLA~1%p7%
%1 %2 %p3% %p4% %p5% POPPLA~2%p6%       POPPLA~2%p7%
%1 %2 %p3% %p4% %p5% POPPLA~3%p6%       POPPLA~3%p7%
%1 %2 %p3% %p4% %p5% POPREC~1%p6%       POPREC~1%p7%
%1 %2 %p3% %p4% %p5% PREVRE~1%p6%       PREVRE~1%p7%
%1 %2 %p3% %p4% %p5% PRINTE~1%p6%       PRINTE~1%p7%
%1 %2 %p3% %p4% %p5% PUERTO~1%p6%       PUERTO~1%p7%
%1 %2 %p3% %p4% %p5% READ_M~1%p6%       READ_M~1%p7%
%1 %2 %p3% %p4% %p5% READ_M~2%p6%       READ_M~2%p7%
%1 %2 %p3% %p4% %p5% READCO~1%p6%       READCO~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% REGION~1%p6%       REGION~1%p7%
%1 %2 %p3% %p4% %p5% REGION~2%p6%       REGION~2%p7%
%1 %2 %p3% %p4% %p5% REGION~3%p6%       REGION~3%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGIST~1%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGIST~2%p7%
%1 %2 %p3% %p4% %p5% ROMANI~1%p6%       ROMANI~1%p7%
%1 %2 %p3% %p4% %p5% ROMANI~2%p6%       ROMANI~2%p7%
%1 %2 %p3% %p4% %p5% RTMEXE~1%p6%       RTMEXE~1%p7%
%1 %2 %p3% %p4% %p5% SAFRIC~1%p6%       SAFRIC~1%p7%
%1 %2 %p3% %p4% %p5% SAMERI~1%p6%       SAMERI~1%p7%
%1 %2 %p3% %p4% %p5% SARABI~1%p6%       SARABI~1%p7%
%1 %2 %p3% %p4% %p5% SARABI~2%p6%       SARABI~2%p7%
%1 %2 %p3% %p4% %p5% SCANTA~1%p6%       SCANTA~1%p7%
%1 %2 %p3% %p4% %p5% SCANTA~2%p6%       SCANTA~2%p7%
%1 %2 %p3% %p4% %p5% SCDSCN~1%p6%       SCDSCN~1%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~1%p6%       SEAS_M~1%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~2%p6%       SEAS_M~2%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~3%p6%       SEAS_M~3%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       SIMPLE~1%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       SIMPLE~2%p7%
%1 %2 %p3% %p4% %p5% SIMULA~1%p6%       SIMULA~1%p7%
%1 %2 %p3% %p4% %p5% SLEONE~1%p6%       SLEONE~1%p7%
%1 %2 %p3% %p4% %p5% SMAPIT~1%p6%       SMAPIT~1%p7%
%1 %2 %p3% %p4% %p5% SPAINB~1%p6%       SPAINB~1%p7%
%1 %2 %p3% %p4% %p5% SPAINL~1%p6%       SPAINL~1%p7%
%1 %2 %p3% %p4% %p5% SPECIA~1%p6%       SPECIA~1%p7%
%1 %2 %p3% %p4% %p5% SQUARE~1%p6%       SQUARE~1%p7%
%1 %2 %p3% %p4% %p5% SQUARE~2%p6%       SQUARE~2%p7%
%1 %2 %p3% %p4% %p5% STANDA~1%p6%       STANDA~1%p7%
%1 %2 %p3% %p4% %p5% STATEL~1%p6%       STATEL~1%p7%
%1 %2 %p3% %p4% %p5% STATEL~2%p6%       STATEL~2%p7%
%1 %2 %p3% %p4% %p5% STATEL~3%p6%       STATEL~3%p7%
%1 %2 %p3% %p4% %p5% STATES~1%p6%       STATES~1%p7%
%1 %2 %p3% %p4% %p5% STDFIG~1%p6%       STDFIG~1%p7%
%1 %2 %p3% %p4% %p5% STDFNT~1%p6%       STDFNT~1%p7%
%1 %2 %p3% %p4% %p5% STDPEN~1%p6%       STDPEN~1%p7%
%1 %2 %p3% %p4% %p5% STF1AP~1%p6%       STF1AP~1%p7%
%1 %2 %p3% %p4% %p5% STPBND~1%p6%       STPBND~1%p7%
%1 %2 %p3% %p4% %p5% SUBAFR~1%p6%       SUBAFR~1%p7%
%1 %2 %p3% %p4% %p5% SURINA~1%p6%       SURINA~1%p7%
%1 %2 %p3% %p4% %p5% SURVDB~1%p6%       SURVDB~1%p7%
%1 %2 %p3% %p4% %p5% SWEDEN~1%p6%       SWEDEN~1%p7%
%1 %2 %p3% %p4% %p5% SWEDEN~2%p6%       SWEDEN~2%p7%
%1 %2 %p3% %p4% %p5% SYMBOL~1%p6%       SYMBOL~1%p7%
%1 %2 %p3% %p4% %p5% SYMBOL~2%p6%       SYMBOL~2%p7%
%1 %2 %p3% %p4% %p5% TANZAN~1%p6%       TANZAN~1%p7%
%1 %2 %p3% %p4% %p5% TEMPDA~1%p6%       TEMPDA~1%p7%
%1 %2 %p3% %p4% %p5% TEMPDB~1%p6%       TEMPDB~1%p7%
%1 %2 %p3% %p4% %p5% TEMPRA~1%p6%       TEMPRA~1%p7%
%1 %2 %p3% %p4% %p5% TEST1D~1%p6%       TEST1D~1%p7%
%1 %2 %p3% %p4% %p5% TEST2D~1%p6%       TEST2D~1%p7%
%1 %2 %p3% %p4% %p5% TEST3D~1%p6%       TEST3D~1%p7%
%1 %2 %p3% %p4% %p5% TEST4D~1%p6%       TEST4D~1%p7%
%1 %2 %p3% %p4% %p5% TESTDE~1%p6%       TESTDE~1%p7%
%1 %2 %p3% %p4% %p5% TOPBAT~1%p6%       TOPBAT~1%p7%
%1 %2 %p3% %p4% %p5% TOPOEX~1%p6%       TOPOEX~1%p7%
%1 %2 %p3% %p4% %p5% TOPOTX~1%p6%       TOPOTX~1%p7%
%1 %2 %p3% %p4% %p5% TOWERS~1%p6%       TOWERS~1%p7%
%1 %2 %p3% %p4% %p5% TOWERS~2%p6%       TOWERS~2%p7%
%1 %2 %p3% %p4% %p5% TOWERS~3%p6%       TOWERS~3%p7%
%1 %2 %p3% %p4% %p5% TOWERS~4%p6%       TOWERS~4%p7%
%1 %2 %p3% %p4% %p5% TRANSP~1%p6%       TRANSP~1%p7%
%1 %2 %p3% %p4% %p5% TRANSP~2%p6%       TRANSP~2%p7%
%1 %2 %p3% %p4% %p5% TRANSP~3%p6%       TRANSP~3%p7%
%1 %2 %p3% %p4% %p5% TRIANG~1%p6%       TRIANG~1%p7%
%1 %2 %p3% %p4% %p5% TRIANG~2%p6%       TRIANG~2%p7%
%1 %2 %p3% %p4% %p5% TRIPLE~1%p6%       TRIPLE~1%p7%
%1 %2 %p3% %p4% %p5% TRIPLE~2%p6%       TRIPLE~2%p7%
%1 %2 %p3% %p4% %p5% TURKEY~1%p6%       TURKEY~1%p7%
%1 %2 %p3% %p4% %p5% TURKEY~2%p6%       TURKEY~2%p7%
%1 %2 %p3% %p4% %p5% UG1REC~1%p6%       UG1REC~1%p7%
%1 %2 %p3% %p4% %p5% UG2REC~1%p6%       UG2REC~1%p7%
%1 %2 %p3% %p4% %p5% UG3REC~1%p6%       UG3REC~1%p7%
%1 %2 %p3% %p4% %p5% UG4REC~1%p6%       UG4REC~1%p7%
%1 %2 %p3% %p4% %p5% UG5REC~1%p6%       UG5REC~1%p7%
%1 %2 %p3% %p4% %p5% UG6REC~1%p6%       UG6REC~1%p7%
%1 %2 %p3% %p4% %p5% UGANDA~1%p6%       UGANDA~1%p7%
%1 %2 %p3% %p4% %p5% UGANDB~1%p6%       UGANDB~1%p7%
%1 %2 %p3% %p4% %p5% UGDATA~1%p6%       UGDATA~1%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~1%p6%       UKRAIN~1%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~2%p6%       UKRAIN~2%p7%
%1 %2 %p3% %p4% %p5% URUGUA~1%p6%       URUGUA~1%p7%
%1 %2 %p3% %p4% %p5% USABND~1%p6%       USABND~1%p7%
%1 %2 %p3% %p4% %p5% USACGA~1%p6%       USACGA~1%p7%
%1 %2 %p3% %p4% %p5% USAINI~1%p6%       USAINI~1%p7%
%1 %2 %p3% %p4% %p5% USAIRS~1%p6%       USAIRS~1%p7%
%1 %2 %p3% %p4% %p5% USAKBN~1%p6%       USAKBN~1%p7%
%1 %2 %p3% %p4% %p5% USALBN~1%p6%       USALBN~1%p7%
%1 %2 %p3% %p4% %p5% USALL~1%p6%        USALL~1%p7%
%1 %2 %p3% %p4% %p5% USALOG~1%p6%       USALOG~1%p7%
%1 %2 %p3% %p4% %p5% USAMAT~1%p6%       USAMAT~1%p7%
%1 %2 %p3% %p4% %p5% USARBN~1%p6%       USARBN~1%p7%
%1 %2 %p3% %p4% %p5% USARES~1%p6%       USARES~1%p7%
%1 %2 %p3% %p4% %p5% USAZBN~1%p6%       USAZBN~1%p7%
%1 %2 %p3% %p4% %p5% USCABN~1%p6%       USCABN~1%p7%
%1 %2 %p3% %p4% %p5% USCOBN~1%p6%       USCOBN~1%p7%
%1 %2 %p3% %p4% %p5% USCTBN~1%p6%       USCTBN~1%p7%
%1 %2 %p3% %p4% %p5% USDCBN~1%p6%       USDCBN~1%p7%
%1 %2 %p3% %p4% %p5% USDEBN~1%p6%       USDEBN~1%p7%
%1 %2 %p3% %p4% %p5% USFLBN~1%p6%       USFLBN~1%p7%
%1 %2 %p3% %p4% %p5% USGABN~1%p6%       USGABN~1%p7%
%1 %2 %p3% %p4% %p5% USHIBN~1%p6%       USHIBN~1%p7%
%1 %2 %p3% %p4% %p5% USIABN~1%p6%       USIABN~1%p7%
%1 %2 %p3% %p4% %p5% USIDBN~1%p6%       USIDBN~1%p7%
%1 %2 %p3% %p4% %p5% USILBN~1%p6%       USILBN~1%p7%
%1 %2 %p3% %p4% %p5% USINBN~1%p6%       USINBN~1%p7%
%1 %2 %p3% %p4% %p5% USKSBN~1%p6%       USKSBN~1%p7%
%1 %2 %p3% %p4% %p5% USKYBN~1%p6%       USKYBN~1%p7%
%1 %2 %p3% %p4% %p5% USLABN~1%p6%       USLABN~1%p7%
%1 %2 %p3% %p4% %p5% USMABN~1%p6%       USMABN~1%p7%
%1 %2 %p3% %p4% %p5% USMDBN~1%p6%       USMDBN~1%p7%
%1 %2 %p3% %p4% %p5% USMEBN~1%p6%       USMEBN~1%p7%
%1 %2 %p3% %p4% %p5% USMIBN~1%p6%       USMIBN~1%p7%
%1 %2 %p3% %p4% %p5% USMNBN~1%p6%       USMNBN~1%p7%
%1 %2 %p3% %p4% %p5% USMOBN~1%p6%       USMOBN~1%p7%
%1 %2 %p3% %p4% %p5% USMSBN~1%p6%       USMSBN~1%p7%
%1 %2 %p3% %p4% %p5% USMTBN~1%p6%       USMTBN~1%p7%
%1 %2 %p3% %p4% %p5% USNCBN~1%p6%       USNCBN~1%p7%
%1 %2 %p3% %p4% %p5% USNDBN~1%p6%       USNDBN~1%p7%
%1 %2 %p3% %p4% %p5% USNEBN~1%p6%       USNEBN~1%p7%
%1 %2 %p3% %p4% %p5% USNHBN~1%p6%       USNHBN~1%p7%
%1 %2 %p3% %p4% %p5% USNJBN~1%p6%       USNJBN~1%p7%
%1 %2 %p3% %p4% %p5% USNMBN~1%p6%       USNMBN~1%p7%
%1 %2 %p3% %p4% %p5% USNVBN~1%p6%       USNVBN~1%p7%
%1 %2 %p3% %p4% %p5% USNYBN~1%p6%       USNYBN~1%p7%
%1 %2 %p3% %p4% %p5% USOHBN~1%p6%       USOHBN~1%p7%
%1 %2 %p3% %p4% %p5% USOKBN~1%p6%       USOKBN~1%p7%
%1 %2 %p3% %p4% %p5% USORBN~1%p6%       USORBN~1%p7%
%1 %2 %p3% %p4% %p5% USPABN~1%p6%       USPABN~1%p7%
%1 %2 %p3% %p4% %p5% USRIBN~1%p6%       USRIBN~1%p7%
%1 %2 %p3% %p4% %p5% USSCBN~1%p6%       USSCBN~1%p7%
%1 %2 %p3% %p4% %p5% USSDBN~1%p6%       USSDBN~1%p7%
%1 %2 %p3% %p4% %p5% USTNBN~1%p6%       USTNBN~1%p7%
%1 %2 %p3% %p4% %p5% USTXBN~1%p6%       USTXBN~1%p7%
%1 %2 %p3% %p4% %p5% USUTBN~1%p6%       USUTBN~1%p7%
%1 %2 %p3% %p4% %p5% USVABN~1%p6%       USVABN~1%p7%
%1 %2 %p3% %p4% %p5% USVTBN~1%p6%       USVTBN~1%p7%
%1 %2 %p3% %p4% %p5% USWABN~1%p6%       USWABN~1%p7%
%1 %2 %p3% %p4% %p5% USWIBN~1%p6%       USWIBN~1%p7%
%1 %2 %p3% %p4% %p5% USWVBN~1%p6%       USWVBN~1%p7%
%1 %2 %p3% %p4% %p5% USWYBN~1%p6%       USWYBN~1%p7%
%1 %2 %p3% %p4% %p5% UTILIT~1%p6%       UTILIT~1%p7%
%1 %2 %p3% %p4% %p5% UTILIT~2%p6%       UTILIT~2%p7%
%1 %2 %p3% %p4% %p5% UTILIT~3%p6%       UTILIT~3%p7%
%1 %2 %p3% %p4% %p5% VBARDA~1%p6%       VBARDA~1%p7%
%1 %2 %p3% %p4% %p5% VBARMR~1%p6%       VBARMR~1%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDIN~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~2%p6%       VENDOR~2%p7%
%1 %2 %p3% %p4% %p5% VENEZU~1%p6%       VENEZU~1%p7%
%1 %2 %p3% %p4% %p5% VGASCN~1%p6%       VGASCN~1%p7%
%1 %2 %p3% %p4% %p5% VICRAI~1%p6%       VICRAI~1%p7%
%1 %2 %p3% %p4% %p5% VICSHI~1%p6%       VICSHI~1%p7%
%1 %2 %p3% %p4% %p5% VICTOW~1%p6%       VICTOW~1%p7%
%1 %2 %p3% %p4% %p5% VIDEOD~1%p6%       VIDEOD~1%p7%
%1 %2 %p3% %p4% %p5% VIETNA~1%p6%       VIETNA~1%p7%
%1 %2 %p3% %p4% %p5% VMAP_F~1%p6%       VMAP_F~1%p7%
%1 %2 %p3% %p4% %p5% VMAP_F~2%p6%       VMAP_F~2%p7%
%1 %2 %p3% %p4% %p5% VMAPDO~1%p6%       VMAPDO~1%p7%
%1 %2 %p3% %p4% %p5% VMAPEX~1%p6%       VMAPEX~1%p7%
%1 %2 %p3% %p4% %p5% VMAPFA~1%p6%       VMAPFA~1%p7%
%1 %2 %p3% %p4% %p5% VMAPMA~1%p6%       VMAPMA~1%p7%
%1 %2 %p3% %p4% %p5% VMAPRE~1%p6%       VMAPRE~1%p7%
%1 %2 %p3% %p4% %p5% VMAPUS~1%p6%       VMAPUS~1%p7%
%1 %2 %p3% %p4% %p5% VMVEND~1%p6%       VMVEND~1%p7%
%1 %2 %p3% %p4% %p5% WASHRA~1%p6%       WASHRA~1%p7%
%1 %2 %p3% %p4% %p5% WASHRO~1%p6%       WASHRO~1%p7%
%1 %2 %p3% %p4% %p5% WASHTR~1%p6%       WASHTR~1%p7%
%1 %2 %p3% %p4% %p5% WASHTR~2%p6%       WASHTR~2%p7%
%1 %2 %p3% %p4% %p5% WEEKSM~1%p6%       WEEKSM~1%p7%
%1 %2 %p3% %p4% %p5% WINBVD~1%p6%       WINBVD~1%p7%
%1 %2 %p3% %p4% %p5% WINBVD~2%p6%       WINBVD~2%p7%
%1 %2 %p3% %p4% %p5% WINSVD~1%p6%       WINSVD~1%p7%
%1 %2 %p3% %p4% %p5% WINSVD~2%p6%       WINSVD~2%p7%
%1 %2 %p3% %p4% %p5% WORLDB~1%p6%       WORLDB~1%p7%
%1 %2 %p3% %p4% %p5% WORLDD~1%p6%       WORLDD~1%p7%
%1 %2 %p3% %p4% %p5% WOTSNE~1%p6%       WOTSNE~1%p7%
%1 %2 %p3% %p4% %p5% X11-BG~1%p6%       X11-BG~1%p7%
%1 %2 %p3% %p4% %p5% XLISTD~1%p6%       XLISTD~1%p7%
%1 %2 %p3% %p4% %p5% XLISTM~1%p6%       XLISTM~1%p7%
%1 %2 %p3% %p4% %p5% YEARSI~1%p6%       YEARSI~1%p7%
%1 %2 %p3% %p4% %p5% YUGOSL~1%p6%       YUGOSL~1%p7%
%1 %2 %p3% %p4% %p5% YUGOSL~2%p6%       YUGOSL~2%p7%
%1 %2 %p3% %p4% %p5% ZAIREB~1%p6%       ZAIREB~1%p7%
%1 %2 %p3% %p4% %p5% ZIMBAB~1%p6%       ZIMBAB~1%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~1%p6%       ZPHONE~1%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~2%p6%       ZPHONE~2%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~3%p6%       ZPHONE~3%p7%

cd %dir7%

%1 %2 %p3% %p4% %p5% ACMSET~1%p6%       ACMSET~1%p7%
%1 %2 %p3% %p4% %p5% ACMSET~2%p6%       ACMSET~2%p7%
%1 %2 %p3% %p4% %p5% ADMINI~1%p6%       ADMINI~1%p7%
%1 %2 %p3% %p4% %p5% ASYCFI~1%p6%       ASYCFI~1%p7%
%1 %2 %p3% %p4% %p5% CMPICO~1%p6%       CMPICO~1%p7%
%1 %2 %p3% %p4% %p5% COMCAT~1%p6%       COMCAT~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D3~1%p7%
%1 %2 %p3% %p4% %p5% DAO253~1%p6%       DAO253~1%p7%
%1 %2 %p3% %p4% %p5% DAO350~1%p6%       DAO350~1%p7%
%1 %2 %p3% %p4% %p5% DATAMD~1%p6%       DATAMD~1%p7%
%1 %2 %p3% %p4% %p5% EXPAND~1%p6%       EXPAND~1%p7%
%1 %2 %p3% %p4% %p5% GR8409~1%p6%       GR8409~1%p7%
%1 %2 %p3% %p4% %p5% GR8GAL~1%p6%       GR8GAL~1%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~1%p6%       GRAPH8~1%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~2%p6%       GRAPH8~2%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~3%p6%       GRAPH8~3%p7%
%1 %2 %p3% %p4% %p5% GRINTL~1%p6%       GRINTL~1%p7%
%1 %2 %p3% %p4% %p5% HLINKD~1%p6%       HLINKD~1%p7%
%1 %2 %p3% %p4% %p5% HLINKP~1%p6%       HLINKP~1%p7%
%1 %2 %p3% %p4% %p5% HLINKS~1%p6%       HLINKS~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% MFCANS~1%p6%       MFCANS~1%p7%
%1 %2 %p3% %p4% %p5% MISC2S~1%p6%       MISC2S~1%p7%
%1 %2 %p3% %p4% %p5% MISCSR~1%p6%       MISCSR~1%p7%
%1 %2 %p3% %p4% %p5% MPADI3~1%p6%       MPADI3~1%p7%
%1 %2 %p3% %p4% %p5% MPANG3~1%p6%       MPANG3~1%p7%
%1 %2 %p3% %p4% %p5% MRT7EN~1%p6%       MRT7EN~1%p7%
%1 %2 %p3% %p4% %p5% MSACC8~1%p6%       MSACC8~1%p7%
%1 %2 %p3% %p4% %p5% MSACCC~1%p6%       MSACCC~1%p7%
%1 %2 %p3% %p4% %p5% MSACCE~1%p6%       MSACCE~1%p7%
%1 %2 %p3% %p4% %p5% MSACCE~2%p6%       MSACCE~2%p7%
%1 %2 %p3% %p4% %p5% MSACNV~1%p6%       MSACNV~1%p7%
%1 %2 %p3% %p4% %p5% MSACNV~2%p6%       MSACNV~2%p7%
%1 %2 %p3% %p4% %p5% MSAEXP~1%p6%       MSAEXP~1%p7%
%1 %2 %p3% %p4% %p5% MSAIN8~1%p6%       MSAIN8~1%p7%
%1 %2 %p3% %p4% %p5% MSJET3~1%p6%       MSJET3~1%p7%
%1 %2 %p3% %p4% %p5% MSJINT~1%p6%       MSJINT~1%p7%
%1 %2 %p3% %p4% %p5% MSJTER~1%p6%       MSJTER~1%p7%
%1 %2 %p3% %p4% %p5% MSO97R~1%p6%       MSO97R~1%p7%
%1 %2 %p3% %p4% %p5% MSODEU~1%p6%       MSODEU~1%p7%
%1 %2 %p3% %p4% %p5% MSOFFI~1%p6%       MSOFFI~1%p7%
%1 %2 %p3% %p4% %p5% MSRD2X~1%p6%       MSRD2X~1%p7%
%1 %2 %p3% %p4% %p5% MSREPL~1%p6%       MSREPL~1%p7%
%1 %2 %p3% %p4% %p5% MSSETU~1%p6%       MSSETU~1%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       MSVCRT~1%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~2%p6%       MSVCRT~2%p7%
%1 %2 %p3% %p4% %p5% OLEAUT~1%p6%       OLEAUT~1%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       OLEPRO~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% SCP32D~1%p6%       SCP32D~1%p7%
%1 %2 %p3% %p4% %p5% SELFRE~1%p6%       SELFRE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUPL~1%p7%
%1 %2 %p3% %p4% %p5% SETUPS~1%p6%       SETUPS~1%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       SETUPT~1%p7%
%1 %2 %p3% %p4% %p5% SOA800~1%p6%       SOA800~1%p7%
%1 %2 %p3% %p4% %p5% STDOLE~1%p6%       STDOLE~1%p7%
%1 %2 %p3% %p4% %p5% SYSICO~1%p6%       SYSICO~1%p7%
%1 %2 %p3% %p4% %p5% TAHOMA~1%p6%       TAHOMA~1%p7%
%1 %2 %p3% %p4% %p5% TAHOMA~2%p6%       TAHOMA~2%p7%
%1 %2 %p3% %p4% %p5% TASKMA~1%p6%       TASKMA~1%p7%
%1 %2 %p3% %p4% %p5% TASKMA~2%p6%       TASKMA~2%p7%
%1 %2 %p3% %p4% %p5% TASKMA~3%p6%       TASKMA~3%p7%
%1 %2 %p3% %p4% %p5% TASKMA~4%p6%       TASKMA~4%p7%
%1 %2 %p3% %p4% %p5% URLMON~1%p6%       URLMON~1%p7%
%1 %2 %p3% %p4% %p5% UTILIT~1%p6%       UTILIT~1%p7%
%1 %2 %p3% %p4% %p5% VBA332~1%p6%       VBA332~1%p7%
%1 %2 %p3% %p4% %p5% VBA3EN~1%p6%       VBA3EN~1%p7%
%1 %2 %p3% %p4% %p5% VBACV2~1%p6%       VBACV2~1%p7%
%1 %2 %p3% %p4% %p5% VSETUP~1%p6%       VSETUP~1%p7%
%1 %2 %p3% %p4% %p5% W95FIB~1%p6%       W95FIB~1%p7%
%1 %2 %p3% %p4% %p5% WININE~1%p6%       WININE~1%p7%
%1 %2 %p3% %p4% %p5% WINSSP~1%p6%       WINSSP~1%p7%
%1 %2 %p3% %p4% %p5% WPSYSD~1%p6%       WPSYSD~1%p7%
%1 %2 %p3% %p4% %p5% WRKGAD~1%p6%       WRKGAD~1%p7%

cd %dir8%

%1 %2 %p3% %p4% %p5% _C_BOU~1%p6%       _C_BOU~1%p7%
%1 %2 %p3% %p4% %p5% _C_FIG~1%p6%       _C_FIG~1%p7%
%1 %2 %p3% %p4% %p5% _C_GEN~1%p6%       _C_GEN~1%p7%
%1 %2 %p3% %p4% %p5% _C_SEL~1%p6%       _C_SEL~1%p7%
%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST3~1%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL~1%p7%
%1 %2 %p3% %p4% %p5% _ISREG~1%p6%       _ISREG~1%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES~1%p7%
%1 %2 %p3% %p4% %p5% _ISUSE~1%p6%       _ISUSE~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _SETUP~2%p7%
%1 %2 %p3% %p4% %p5% AGEO~1%p6%         AGEO~1%p7%
%1 %2 %p3% %p4% %p5% AKCGIS~1%p6%       AKCGIS~1%p7%
%1 %2 %p3% %p4% %p5% AKZGIS~1%p6%       AKZGIS~1%p7%
%1 %2 %p3% %p4% %p5% ALCGIS~1%p6%       ALCGIS~1%p7%
%1 %2 %p3% %p4% %p5% ALZGIS~1%p6%       ALZGIS~1%p7%
%1 %2 %p3% %p4% %p5% ANDROM~1%p6%       ANDROM~1%p7%
%1 %2 %p3% %p4% %p5% ANGSEP~1%p6%       ANGSEP~1%p7%
%1 %2 %p3% %p4% %p5% ARCGIS~1%p6%       ARCGIS~1%p7%
%1 %2 %p3% %p4% %p5% ARZGIS~1%p6%       ARZGIS~1%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       AUTORU~1%p7%
%1 %2 %p3% %p4% %p5% AXISMA~1%p6%       AXISMA~1%p7%
%1 %2 %p3% %p4% %p5% AZCGIS~1%p6%       AZCGIS~1%p7%
%1 %2 %p3% %p4% %p5% AZZGIS~1%p6%       AZZGIS~1%p7%
%1 %2 %p3% %p4% %p5% BDWARF~1%p6%       BDWARF~1%p7%
%1 %2 %p3% %p4% %p5% BGEO~1%p6%         BGEO~1%p7%
%1 %2 %p3% %p4% %p5% BOOKGI~1%p6%       BOOKGI~1%p7%
%1 %2 %p3% %p4% %p5% BOTBAR~1%p6%       BOTBAR~1%p7%
%1 %2 %p3% %p4% %p5% C_CONT~1%p6%       C_CONT~1%p7%
%1 %2 %p3% %p4% %p5% C_CUST~1%p6%       C_CUST~1%p7%
%1 %2 %p3% %p4% %p5% C_DEMO~1%p6%       C_DEMO~1%p7%
%1 %2 %p3% %p4% %p5% C_DISP~1%p6%       C_DISP~1%p7%
%1 %2 %p3% %p4% %p5% C_EDIT~1%p6%       C_EDIT~1%p7%
%1 %2 %p3% %p4% %p5% C_EXER~1%p6%       C_EXER~1%p7%
%1 %2 %p3% %p4% %p5% C_FAQG~1%p6%       C_FAQG~1%p7%
%1 %2 %p3% %p4% %p5% C_FILE~1%p6%       C_FILE~1%p7%
%1 %2 %p3% %p4% %p5% C_FIND~1%p6%       C_FIND~1%p7%
%1 %2 %p3% %p4% %p5% C_GUID~1%p6%       C_GUID~1%p7%
%1 %2 %p3% %p4% %p5% C_INDE~1%p6%       C_INDE~1%p7%
%1 %2 %p3% %p4% %p5% C_INFO~1%p6%       C_INFO~1%p7%
%1 %2 %p3% %p4% %p5% C_INST~1%p6%       C_INST~1%p7%
%1 %2 %p3% %p4% %p5% C_INTR~1%p6%       C_INTR~1%p7%
%1 %2 %p3% %p4% %p5% C_LICE~1%p6%       C_LICE~1%p7%
%1 %2 %p3% %p4% %p5% C_LIVE~1%p6%       C_LIVE~1%p7%
%1 %2 %p3% %p4% %p5% C_LOCA~1%p6%       C_LOCA~1%p7%
%1 %2 %p3% %p4% %p5% C_LOOK~1%p6%       C_LOOK~1%p7%
%1 %2 %p3% %p4% %p5% C_LSIN~1%p6%       C_LSIN~1%p7%
%1 %2 %p3% %p4% %p5% C_MOVI~1%p6%       C_MOVI~1%p7%
%1 %2 %p3% %p4% %p5% C_MULT~1%p6%       C_MULT~1%p7%
%1 %2 %p3% %p4% %p5% C_OPTI~1%p6%       C_OPTI~1%p7%
%1 %2 %p3% %p4% %p5% C_ORBI~1%p6%       C_ORBI~1%p7%
%1 %2 %p3% %p4% %p5% C_PLAN~1%p6%       C_PLAN~1%p7%
%1 %2 %p3% %p4% %p5% C_PRIN~1%p6%       C_PRIN~1%p7%
%1 %2 %p3% %p4% %p5% C_SETT~1%p6%       C_SETT~1%p7%
%1 %2 %p3% %p4% %p5% C_SPEE~1%p6%       C_SPEE~1%p7%
%1 %2 %p3% %p4% %p5% C_TIME~1%p6%       C_TIME~1%p7%
%1 %2 %p3% %p4% %p5% C_TOOL~1%p6%       C_TOOL~1%p7%
%1 %2 %p3% %p4% %p5% C_TROU~1%p6%       C_TROU~1%p7%
%1 %2 %p3% %p4% %p5% C_WIND~1%p6%       C_WIND~1%p7%
%1 %2 %p3% %p4% %p5% CACGIS~1%p6%       CACGIS~1%p7%
%1 %2 %p3% %p4% %p5% CARRIB~1%p6%       CARRIB~1%p7%
%1 %2 %p3% %p4% %p5% CATALO~1%p6%       CATALO~1%p7%
%1 %2 %p3% %p4% %p5% CAZGIS~1%p6%       CAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% CGEO~1%p6%         CGEO~1%p7%
%1 %2 %p3% %p4% %p5% CHAPTE~1%p6%       CHAPTE~1%p7%
%1 %2 %p3% %p4% %p5% CO_COM~1%p6%       CO_COM~1%p7%
%1 %2 %p3% %p4% %p5% CO_CON~1%p6%       CO_CON~1%p7%
%1 %2 %p3% %p4% %p5% CO_ECL~1%p6%       CO_ECL~1%p7%
%1 %2 %p3% %p4% %p5% CO_EQU~1%p6%       CO_EQU~1%p7%
%1 %2 %p3% %p4% %p5% CO_GAL~1%p6%       CO_GAL~1%p7%
%1 %2 %p3% %p4% %p5% CO_HOR~1%p6%       CO_HOR~1%p7%
%1 %2 %p3% %p4% %p5% CO_LOC~1%p6%       CO_LOC~1%p7%
%1 %2 %p3% %p4% %p5% CO_MES~1%p6%       CO_MES~1%p7%
%1 %2 %p3% %p4% %p5% CO_MIL~1%p6%       CO_MIL~1%p7%
%1 %2 %p3% %p4% %p5% CO_NGC~1%p6%       CO_NGC~1%p7%
%1 %2 %p3% %p4% %p5% CO_ONS~1%p6%       CO_ONS~1%p7%
%1 %2 %p3% %p4% %p5% CO_PLA~1%p6%       CO_PLA~1%p7%
%1 %2 %p3% %p4% %p5% CO_STA~1%p6%       CO_STA~1%p7%
%1 %2 %p3% %p4% %p5% COCGIS~1%p6%       COCGIS~1%p7%
%1 %2 %p3% %p4% %p5% COM_GE~1%p6%       COM_GE~1%p7%
%1 %2 %p3% %p4% %p5% COM_IM~1%p6%       COM_IM~1%p7%
%1 %2 %p3% %p4% %p5% COMET~1%p6%        COMET~1%p7%
%1 %2 %p3% %p4% %p5% COMETS~2%p6%       COMETS~2%p7%
%1 %2 %p3% %p4% %p5% COMPAR~1%p6%       COMPAR~1%p7%
%1 %2 %p3% %p4% %p5% CONS_B~1%p6%       CONS_B~1%p7%
%1 %2 %p3% %p4% %p5% CONS_F~1%p6%       CONS_F~1%p7%
%1 %2 %p3% %p4% %p5% CONS_G~1%p6%       CONS_G~1%p7%
%1 %2 %p3% %p4% %p5% CONS_S~1%p6%       CONS_S~1%p7%
%1 %2 %p3% %p4% %p5% CONSTE~1%p6%       CONSTE~1%p7%
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       CONTEN~1%p7%
%1 %2 %p3% %p4% %p5% COOLGI~1%p6%       COOLGI~1%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECO~1%p7%
%1 %2 %p3% %p4% %p5% COZGIS~1%p6%       COZGIS~1%p7%
%1 %2 %p3% %p4% %p5% CTCGIS~1%p6%       CTCGIS~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D3~1%p7%
%1 %2 %p3% %p4% %p5% CTZGIS~1%p6%       CTZGIS~1%p7%
%1 %2 %p3% %p4% %p5% CUSTOM~1%p6%       CUSTOM~1%p7%
%1 %2 %p3% %p4% %p5% DATAUS~1%p6%       DATAUS~1%p7%
%1 %2 %p3% %p4% %p5% DCCGIS~1%p6%       DCCGIS~1%p7%
%1 %2 %p3% %p4% %p5% DCZGIS~1%p6%       DCZGIS~1%p7%
%1 %2 %p3% %p4% %p5% DECGIS~1%p6%       DECGIS~1%p7%
%1 %2 %p3% %p4% %p5% DEMOSH~1%p6%       DEMOSH~1%p7%
%1 %2 %p3% %p4% %p5% DEZGIS~1%p6%       DEZGIS~1%p7%
%1 %2 %p3% %p4% %p5% DGEO~1%p6%         DGEO~1%p7%
%1 %2 %p3% %p4% %p5% DIGAT~10%p6%       DIGAT~10%p7%
%1 %2 %p3% %p4% %p5% DIGAT~11%p6%       DIGAT~11%p7%
%1 %2 %p3% %p4% %p5% DIGAT~12%p6%       DIGAT~12%p7%
%1 %2 %p3% %p4% %p5% DIGAT~13%p6%       DIGAT~13%p7%
%1 %2 %p3% %p4% %p5% DIGAT~14%p6%       DIGAT~14%p7%
%1 %2 %p3% %p4% %p5% DIGAT~15%p6%       DIGAT~15%p7%
%1 %2 %p3% %p4% %p5% DIGAT~16%p6%       DIGAT~16%p7%
%1 %2 %p3% %p4% %p5% DIGAT~17%p6%       DIGAT~17%p7%
%1 %2 %p3% %p4% %p5% DIGAT~18%p6%       DIGAT~18%p7%
%1 %2 %p3% %p4% %p5% DIGAT~19%p6%       DIGAT~19%p7%
%1 %2 %p3% %p4% %p5% DIGAT~20%p6%       DIGAT~20%p7%
%1 %2 %p3% %p4% %p5% DIGAT~21%p6%       DIGAT~21%p7%
%1 %2 %p3% %p4% %p5% DIGAT~22%p6%       DIGAT~22%p7%
%1 %2 %p3% %p4% %p5% DIGAT~23%p6%       DIGAT~23%p7%
%1 %2 %p3% %p4% %p5% DIGAT~24%p6%       DIGAT~24%p7%
%1 %2 %p3% %p4% %p5% DIGAT~25%p6%       DIGAT~25%p7%
%1 %2 %p3% %p4% %p5% DIGAT~26%p6%       DIGAT~26%p7%
%1 %2 %p3% %p4% %p5% DIGAT~27%p6%       DIGAT~27%p7%
%1 %2 %p3% %p4% %p5% DIGAT~28%p6%       DIGAT~28%p7%
%1 %2 %p3% %p4% %p5% DIGAT~29%p6%       DIGAT~29%p7%
%1 %2 %p3% %p4% %p5% DIGAT~30%p6%       DIGAT~30%p7%
%1 %2 %p3% %p4% %p5% DIGATM~1%p6%       DIGATM~1%p7%
%1 %2 %p3% %p4% %p5% DIGATM~2%p6%       DIGATM~2%p7%
%1 %2 %p3% %p4% %p5% DIGATM~3%p6%       DIGATM~3%p7%
%1 %2 %p3% %p4% %p5% DIGATM~4%p6%       DIGATM~4%p7%
%1 %2 %p3% %p4% %p5% DIGATM~5%p6%       DIGATM~5%p7%
%1 %2 %p3% %p4% %p5% DIGATM~6%p6%       DIGATM~6%p7%
%1 %2 %p3% %p4% %p5% DIGATM~7%p6%       DIGATM~7%p7%
%1 %2 %p3% %p4% %p5% DIGATM~8%p6%       DIGATM~8%p7%
%1 %2 %p3% %p4% %p5% DIGATM~9%p6%       DIGATM~9%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1I~1%p7%
%1 %2 %p3% %p4% %p5% DISPLA~1%p6%       DISPLA~1%p7%
%1 %2 %p3% %p4% %p5% DISPLA~2%p6%       DISPLA~2%p7%
%1 %2 %p3% %p4% %p5% DISPLA~3%p6%       DISPLA~3%p7%
%1 %2 %p3% %p4% %p5% DISPPA~1%p6%       DISPPA~1%p7%
%1 %2 %p3% %p4% %p5% DLGIMA~1%p6%       DLGIMA~1%p7%
%1 %2 %p3% %p4% %p5% DRAGGE~1%p6%       DRAGGE~1%p7%
%1 %2 %p3% %p4% %p5% DUMMYM~1%p6%       DUMMYM~1%p7%
%1 %2 %p3% %p4% %p5% DUMMYS~1%p6%       DUMMYS~1%p7%
%1 %2 %p3% %p4% %p5% EARTH~1%p6%        EARTH~1%p7%
%1 %2 %p3% %p4% %p5% ECLIPS~1%p6%       ECLIPS~1%p7%
%1 %2 %p3% %p4% %p5% ECLIPS~2%p6%       ECLIPS~2%p7%
%1 %2 %p3% %p4% %p5% ECLIPT~1%p6%       ECLIPT~1%p7%
%1 %2 %p3% %p4% %p5% ECLIPT~2%p6%       ECLIPT~2%p7%
%1 %2 %p3% %p4% %p5% EDITGI~1%p6%       EDITGI~1%p7%
%1 %2 %p3% %p4% %p5% EDITHT~1%p6%       EDITHT~1%p7%
%1 %2 %p3% %p4% %p5% EGEO~1%p6%         EGEO~1%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~1%p6%       ELEVAT~1%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~2%p6%       ELEVAT~2%p7%
%1 %2 %p3% %p4% %p5% EQUATO~1%p6%       EQUATO~1%p7%
%1 %2 %p3% %p4% %p5% ETA~1%p6%          ETA~1%p7%
%1 %2 %p3% %p4% %p5% EXERCI~1%p6%       EXERCI~1%p7%
%1 %2 %p3% %p4% %p5% FALL~1%p6%         FALL~1%p7%
%1 %2 %p3% %p4% %p5% FAQHTM~1%p6%       FAQHTM~1%p7%
%1 %2 %p3% %p4% %p5% FGEO~1%p6%         FGEO~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILEGI~1%p6%       FILEGI~1%p7%
%1 %2 %p3% %p4% %p5% FILEHT~1%p6%       FILEHT~1%p7%
%1 %2 %p3% %p4% %p5% FILLGE~1%p6%       FILLGE~1%p7%
%1 %2 %p3% %p4% %p5% FINDGI~1%p6%       FINDGI~1%p7%
%1 %2 %p3% %p4% %p5% FINDHT~1%p6%       FINDHT~1%p7%
%1 %2 %p3% %p4% %p5% FIXED_~1%p6%       FIXED_~1%p7%
%1 %2 %p3% %p4% %p5% FIXEDJ~1%p6%       FIXEDJ~1%p7%
%1 %2 %p3% %p4% %p5% FLCGIS~1%p6%       FLCGIS~1%p7%
%1 %2 %p3% %p4% %p5% FLZGIS~1%p6%       FLZGIS~1%p7%
%1 %2 %p3% %p4% %p5% GACGIS~1%p6%       GACGIS~1%p7%
%1 %2 %p3% %p4% %p5% GALACT~1%p6%       GALACT~1%p7%
%1 %2 %p3% %p4% %p5% GAZGIS~1%p6%       GAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% GGEO~1%p6%         GGEO~1%p7%
%1 %2 %p3% %p4% %p5% GOTOGI~1%p6%       GOTOGI~1%p7%
%1 %2 %p3% %p4% %p5% GUIDES~1%p6%       GUIDES~1%p7%
%1 %2 %p3% %p4% %p5% GUIDES~2%p6%       GUIDES~2%p7%
%1 %2 %p3% %p4% %p5% HALE-B~1%p6%       HALE-B~1%p7%
%1 %2 %p3% %p4% %p5% HANDSJ~1%p6%       HANDSJ~1%p7%
%1 %2 %p3% %p4% %p5% HGEO~1%p6%         HGEO~1%p7%
%1 %2 %p3% %p4% %p5% HICGIS~1%p6%       HICGIS~1%p7%
%1 %2 %p3% %p4% %p5% HIZGIS~1%p6%       HIZGIS~1%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~1%p6%       HOMEBA~1%p7%
%1 %2 %p3% %p4% %p5% HOMEGI~1%p6%       HOMEGI~1%p7%
%1 %2 %p3% %p4% %p5% HOMELO~1%p6%       HOMELO~1%p7%
%1 %2 %p3% %p4% %p5% HOMELO~2%p6%       HOMELO~2%p7%
%1 %2 %p3% %p4% %p5% HORIZO~1%p6%       HORIZO~1%p7%
%1 %2 %p3% %p4% %p5% HORIZO~2%p6%       HORIZO~2%p7%
%1 %2 %p3% %p4% %p5% HORSEH~1%p6%       HORSEH~1%p7%
%1 %2 %p3% %p4% %p5% HORSEJ~1%p6%       HORSEJ~1%p7%
%1 %2 %p3% %p4% %p5% HYAKAT~1%p6%       HYAKAT~1%p7%
%1 %2 %p3% %p4% %p5% HYAKUT~1%p6%       HYAKUT~1%p7%
%1 %2 %p3% %p4% %p5% IACGIS~1%p6%       IACGIS~1%p7%
%1 %2 %p3% %p4% %p5% IAPETU~1%p6%       IAPETU~1%p7%
%1 %2 %p3% %p4% %p5% IAZGIS~1%p6%       IAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% IC2GIF~1%p6%       IC2GIF~1%p7%
%1 %2 %p3% %p4% %p5% ICGIF~1%p6%        ICGIF~1%p7%
%1 %2 %p3% %p4% %p5% IDCGIS~1%p6%       IDCGIS~1%p7%
%1 %2 %p3% %p4% %p5% IDZGIS~1%p6%       IDZGIS~1%p7%
%1 %2 %p3% %p4% %p5% IGEO~1%p6%         IGEO~1%p7%
%1 %2 %p3% %p4% %p5% ILCGIS~1%p6%       ILCGIS~1%p7%
%1 %2 %p3% %p4% %p5% ILZGIS~1%p6%       ILZGIS~1%p7%
%1 %2 %p3% %p4% %p5% INCGIF~1%p6%       INCGIF~1%p7%
%1 %2 %p3% %p4% %p5% INCGIS~1%p6%       INCGIS~1%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       INDEXH~1%p7%
%1 %2 %p3% %p4% %p5% INDEXP~1%p6%       INDEXP~1%p7%
%1 %2 %p3% %p4% %p5% INFOHT~1%p6%       INFOHT~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INTROH~1%p6%       INTROH~1%p7%
%1 %2 %p3% %p4% %p5% INZGIS~1%p6%       INZGIS~1%p7%
%1 %2 %p3% %p4% %p5% JGEO~1%p6%         JGEO~1%p7%
%1 %2 %p3% %p4% %p5% JUPITE~1%p6%       JUPITE~1%p7%
%1 %2 %p3% %p4% %p5% JUPITE~2%p6%       JUPITE~2%p7%
%1 %2 %p3% %p4% %p5% KGEO~1%p6%         KGEO~1%p7%
%1 %2 %p3% %p4% %p5% KSCGIS~1%p6%       KSCGIS~1%p7%
%1 %2 %p3% %p4% %p5% KSZGIS~1%p6%       KSZGIS~1%p7%
%1 %2 %p3% %p4% %p5% KYCGIS~1%p6%       KYCGIS~1%p7%
%1 %2 %p3% %p4% %p5% KYZGIS~1%p6%       KYZGIS~1%p7%
%1 %2 %p3% %p4% %p5% LACGIS~1%p6%       LACGIS~1%p7%
%1 %2 %p3% %p4% %p5% LAZGIS~1%p6%       LAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% LGEO~1%p6%         LGEO~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% LIVESK~1%p6%       LIVESK~1%p7%
%1 %2 %p3% %p4% %p5% LIVESK~2%p6%       LIVESK~2%p7%
%1 %2 %p3% %p4% %p5% LIVESK~3%p6%       LIVESK~3%p7%
%1 %2 %p3% %p4% %p5% LOCALG~1%p6%       LOCALG~1%p7%
%1 %2 %p3% %p4% %p5% LOCATI~1%p6%       LOCATI~1%p7%
%1 %2 %p3% %p4% %p5% LOCATI~2%p6%       LOCATI~2%p7%
%1 %2 %p3% %p4% %p5% LOCATI~3%p6%       LOCATI~3%p7%
%1 %2 %p3% %p4% %p5% LOCTOO~1%p6%       LOCTOO~1%p7%
%1 %2 %p3% %p4% %p5% LONELY~1%p6%       LONELY~1%p7%
%1 %2 %p3% %p4% %p5% LOOKHT~1%p6%       LOOKHT~1%p7%
%1 %2 %p3% %p4% %p5% LOOKIN~1%p6%       LOOKIN~1%p7%
%1 %2 %p3% %p4% %p5% LOST~1%p6%         LOST~1%p7%
%1 %2 %p3% %p4% %p5% LSINST~1%p6%       LSINST~1%p7%
%1 %2 %p3% %p4% %p5% LSSETG~1%p6%       LSSETG~1%p7%
%1 %2 %p3% %p4% %p5% M100SN~1%p6%       M100SN~1%p7%
%1 %2 %p3% %p4% %p5% M106SN~1%p6%       M106SN~1%p7%
%1 %2 %p3% %p4% %p5% M13~1%p6%          M13~1%p7%
%1 %2 %p3% %p4% %p5% M17~1%p6%          M17~1%p7%
%1 %2 %p3% %p4% %p5% M20~1%p6%          M20~1%p7%
%1 %2 %p3% %p4% %p5% M31~1%p6%          M31~1%p7%
%1 %2 %p3% %p4% %p5% M31GIF~2%p6%       M31GIF~2%p7%
%1 %2 %p3% %p4% %p5% M33~1%p6%          M33~1%p7%
%1 %2 %p3% %p4% %p5% M45~1%p6%          M45~1%p7%
%1 %2 %p3% %p4% %p5% M51~1%p6%          M51~1%p7%
%1 %2 %p3% %p4% %p5% M57~1%p6%          M57~1%p7%
%1 %2 %p3% %p4% %p5% M65~1%p6%          M65~1%p7%
%1 %2 %p3% %p4% %p5% M66~1%p6%          M66~1%p7%
%1 %2 %p3% %p4% %p5% M8~1%p6%           M8~1%p7%
%1 %2 %p3% %p4% %p5% M83~2%p6%          M83~2%p7%
%1 %2 %p3% %p4% %p5% M91SNF~1%p6%       M91SNF~1%p7%
%1 %2 %p3% %p4% %p5% M99SNF~1%p6%       M99SNF~1%p7%
%1 %2 %p3% %p4% %p5% MACGIS~1%p6%       MACGIS~1%p7%
%1 %2 %p3% %p4% %p5% MANY~1%p6%         MANY~1%p7%
%1 %2 %p3% %p4% %p5% MARSRE~1%p6%       MARSRE~1%p7%
%1 %2 %p3% %p4% %p5% MAURYG~1%p6%       MAURYG~1%p7%
%1 %2 %p3% %p4% %p5% MAZGIS~1%p6%       MAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MDCGIS~1%p6%       MDCGIS~1%p7%
%1 %2 %p3% %p4% %p5% MDZGIS~1%p6%       MDZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MECGIS~1%p6%       MECGIS~1%p7%
%1 %2 %p3% %p4% %p5% MESS_G~1%p6%       MESS_G~1%p7%
%1 %2 %p3% %p4% %p5% MESS_I~1%p6%       MESS_I~1%p7%
%1 %2 %p3% %p4% %p5% MESS_M~1%p6%       MESS_M~1%p7%
%1 %2 %p3% %p4% %p5% MESSIE~1%p6%       MESSIE~1%p7%
%1 %2 %p3% %p4% %p5% MEZGIS~1%p6%       MEZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MGEO~1%p6%         MGEO~1%p7%
%1 %2 %p3% %p4% %p5% MICGIS~1%p6%       MICGIS~1%p7%
%1 %2 %p3% %p4% %p5% MILKWA~1%p6%       MILKWA~1%p7%
%1 %2 %p3% %p4% %p5% MILKY_~1%p6%       MILKY_~1%p7%
%1 %2 %p3% %p4% %p5% MILKY~1%p6%        MILKY~1%p7%
%1 %2 %p3% %p4% %p5% MIZGIS~1%p6%       MIZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MNCGIS~1%p6%       MNCGIS~1%p7%
%1 %2 %p3% %p4% %p5% MNZGIS~1%p6%       MNZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MOCGIS~1%p6%       MOCGIS~1%p7%
%1 %2 %p3% %p4% %p5% MOONIN~1%p6%       MOONIN~1%p7%
%1 %2 %p3% %p4% %p5% MOONIN~2%p6%       MOONIN~2%p7%
%1 %2 %p3% %p4% %p5% MOUSEI~1%p6%       MOUSEI~1%p7%
%1 %2 %p3% %p4% %p5% MOVIE1~1%p6%       MOVIE1~1%p7%
%1 %2 %p3% %p4% %p5% MOVIE2~1%p6%       MOVIE2~1%p7%
%1 %2 %p3% %p4% %p5% MOVIES~1%p6%       MOVIES~1%p7%
%1 %2 %p3% %p4% %p5% MOZGIS~1%p6%       MOZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MSCGIS~1%p6%       MSCGIS~1%p7%
%1 %2 %p3% %p4% %p5% MSZGIS~1%p6%       MSZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MTCGIS~1%p6%       MTCGIS~1%p7%
%1 %2 %p3% %p4% %p5% MTZGIS~1%p6%       MTZGIS~1%p7%
%1 %2 %p3% %p4% %p5% MULTIH~1%p6%       MULTIH~1%p7%
%1 %2 %p3% %p4% %p5% MWAYGI~1%p6%       MWAYGI~1%p7%
%1 %2 %p3% %p4% %p5% NCCGIS~1%p6%       NCCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NCZGIS~1%p6%       NCZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NDCGIS~1%p6%       NDCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NDZGIS~1%p6%       NDZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NEARES~1%p6%       NEARES~1%p7%
%1 %2 %p3% %p4% %p5% NECGIS~1%p6%       NECGIS~1%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~1%p6%       NEPTUN~1%p7%
%1 %2 %p3% %p4% %p5% NEZGIS~1%p6%       NEZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NGC_BR~1%p6%       NGC_BR~1%p7%
%1 %2 %p3% %p4% %p5% NGC_GE~1%p6%       NGC_GE~1%p7%
%1 %2 %p3% %p4% %p5% NGC_LE~1%p6%       NGC_LE~1%p7%
%1 %2 %p3% %p4% %p5% NGCGIF~1%p6%       NGCGIF~1%p7%
%1 %2 %p3% %p4% %p5% NGCJPG~1%p6%       NGCJPG~1%p7%
%1 %2 %p3% %p4% %p5% NGEO~1%p6%         NGEO~1%p7%
%1 %2 %p3% %p4% %p5% NHCGIS~1%p6%       NHCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NHZGIS~1%p6%       NHZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NJCGIS~1%p6%       NJCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NJZGIS~1%p6%       NJZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NMCGIS~1%p6%       NMCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NMZGIS~1%p6%       NMZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NOTE2G~1%p6%       NOTE2G~1%p7%
%1 %2 %p3% %p4% %p5% NOTEGI~1%p6%       NOTEGI~1%p7%
%1 %2 %p3% %p4% %p5% NOWGIF~1%p6%       NOWGIF~1%p7%
%1 %2 %p3% %p4% %p5% NVCGIS~1%p6%       NVCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NVZGIS~1%p6%       NVZGIS~1%p7%
%1 %2 %p3% %p4% %p5% NYCGIS~1%p6%       NYCGIS~1%p7%
%1 %2 %p3% %p4% %p5% NYZGIS~1%p6%       NYZGIS~1%p7%
%1 %2 %p3% %p4% %p5% O_COME~1%p6%       O_COME~1%p7%
%1 %2 %p3% %p4% %p5% O_CONS~1%p6%       O_CONS~1%p7%
%1 %2 %p3% %p4% %p5% O_ECLI~1%p6%       O_ECLI~1%p7%
%1 %2 %p3% %p4% %p5% O_EQUA~1%p6%       O_EQUA~1%p7%
%1 %2 %p3% %p4% %p5% O_GALA~1%p6%       O_GALA~1%p7%
%1 %2 %p3% %p4% %p5% O_HORI~1%p6%       O_HORI~1%p7%
%1 %2 %p3% %p4% %p5% O_LOCA~1%p6%       O_LOCA~1%p7%
%1 %2 %p3% %p4% %p5% O_MESS~1%p6%       O_MESS~1%p7%
%1 %2 %p3% %p4% %p5% O_MILK~1%p6%       O_MILK~1%p7%
%1 %2 %p3% %p4% %p5% O_NGCI~1%p6%       O_NGCI~1%p7%
%1 %2 %p3% %p4% %p5% O_ONSC~1%p6%       O_ONSC~1%p7%
%1 %2 %p3% %p4% %p5% O_PLAN~1%p6%       O_PLAN~1%p7%
%1 %2 %p3% %p4% %p5% O_STAR~1%p6%       O_STAR~1%p7%
%1 %2 %p3% %p4% %p5% OGEO~1%p6%         OGEO~1%p7%
%1 %2 %p3% %p4% %p5% OHCGIS~1%p6%       OHCGIS~1%p7%
%1 %2 %p3% %p4% %p5% OHZGIS~1%p6%       OHZGIS~1%p7%
%1 %2 %p3% %p4% %p5% OKCGIS~1%p6%       OKCGIS~1%p7%
%1 %2 %p3% %p4% %p5% OKZGIS~1%p6%       OKZGIS~1%p7%
%1 %2 %p3% %p4% %p5% OMEGA~1%p6%        OMEGA~1%p7%
%1 %2 %p3% %p4% %p5% ONSCRE~1%p6%       ONSCRE~1%p7%
%1 %2 %p3% %p4% %p5% OPTION~1%p6%       OPTION~1%p7%
%1 %2 %p3% %p4% %p5% ORBIT1~1%p6%       ORBIT1~1%p7%
%1 %2 %p3% %p4% %p5% ORBITH~1%p6%       ORBITH~1%p7%
%1 %2 %p3% %p4% %p5% ORCGIS~1%p6%       ORCGIS~1%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       ORDERD~1%p7%
%1 %2 %p3% %p4% %p5% ORZGIS~1%p6%       ORZGIS~1%p7%
%1 %2 %p3% %p4% %p5% OTHERS~1%p6%       OTHERS~1%p7%
%1 %2 %p3% %p4% %p5% OUTPU~10%p6%       OUTPU~10%p7%
%1 %2 %p3% %p4% %p5% OUTPU~11%p6%       OUTPU~11%p7%
%1 %2 %p3% %p4% %p5% OUTPU~12%p6%       OUTPU~12%p7%
%1 %2 %p3% %p4% %p5% OUTPU~13%p6%       OUTPU~13%p7%
%1 %2 %p3% %p4% %p5% OUTPU~14%p6%       OUTPU~14%p7%
%1 %2 %p3% %p4% %p5% OUTPU~15%p6%       OUTPU~15%p7%
%1 %2 %p3% %p4% %p5% OUTPU~16%p6%       OUTPU~16%p7%
%1 %2 %p3% %p4% %p5% OUTPU~17%p6%       OUTPU~17%p7%
%1 %2 %p3% %p4% %p5% OUTPU~18%p6%       OUTPU~18%p7%
%1 %2 %p3% %p4% %p5% OUTPU~19%p6%       OUTPU~19%p7%
%1 %2 %p3% %p4% %p5% OUTPU~20%p6%       OUTPU~20%p7%
%1 %2 %p3% %p4% %p5% OUTPU~21%p6%       OUTPU~21%p7%
%1 %2 %p3% %p4% %p5% OUTPU~22%p6%       OUTPU~22%p7%
%1 %2 %p3% %p4% %p5% OUTPU~23%p6%       OUTPU~23%p7%
%1 %2 %p3% %p4% %p5% OUTPU~24%p6%       OUTPU~24%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~1%p6%       OUTPUT~1%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~2%p6%       OUTPUT~2%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~3%p6%       OUTPUT~3%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~4%p6%       OUTPUT~4%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~5%p6%       OUTPUT~5%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~6%p6%       OUTPUT~6%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~7%p6%       OUTPUT~7%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~8%p6%       OUTPUT~8%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~9%p6%       OUTPUT~9%p7%
%1 %2 %p3% %p4% %p5% PACGIS~1%p6%       PACGIS~1%p7%
%1 %2 %p3% %p4% %p5% PAZGIS~1%p6%       PAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% PGEO~1%p6%         PGEO~1%p7%
%1 %2 %p3% %p4% %p5% PLAN_G~1%p6%       PLAN_G~1%p7%
%1 %2 %p3% %p4% %p5% PLAN_O~1%p6%       PLAN_O~1%p7%
%1 %2 %p3% %p4% %p5% PLAN_P~1%p6%       PLAN_P~1%p7%
%1 %2 %p3% %p4% %p5% PLAN_S~1%p6%       PLAN_S~1%p7%
%1 %2 %p3% %p4% %p5% PLAN2S~1%p6%       PLAN2S~1%p7%
%1 %2 %p3% %p4% %p5% PLANET~1%p6%       PLANET~1%p7%
%1 %2 %p3% %p4% %p5% PLANET~2%p6%       PLANET~2%p7%
%1 %2 %p3% %p4% %p5% PLANET~3%p6%       PLANET~3%p7%
%1 %2 %p3% %p4% %p5% PLANET~4%p6%       PLANET~4%p7%
%1 %2 %p3% %p4% %p5% PLANET~5%p6%       PLANET~5%p7%
%1 %2 %p3% %p4% %p5% PLANET~6%p6%       PLANET~6%p7%
%1 %2 %p3% %p4% %p5% PLUGIN~1%p6%       PLUGIN~1%p7%
%1 %2 %p3% %p4% %p5% PPALGI~1%p6%       PPALGI~1%p7%
%1 %2 %p3% %p4% %p5% PQ_GRA~1%p6%       PQ_GRA~1%p7%
%1 %2 %p3% %p4% %p5% PQ_GRA~2%p6%       PQ_GRA~2%p7%
%1 %2 %p3% %p4% %p5% PQ_NON~1%p6%       PQ_NON~1%p7%
%1 %2 %p3% %p4% %p5% PQ_NON~2%p6%       PQ_NON~2%p7%
%1 %2 %p3% %p4% %p5% PQ_SHA~1%p6%       PQ_SHA~1%p7%
%1 %2 %p3% %p4% %p5% PRECES~1%p6%       PRECES~1%p7%
%1 %2 %p3% %p4% %p5% PRINTI~1%p6%       PRINTI~1%p7%
%1 %2 %p3% %p4% %p5% PRINTJ~1%p6%       PRINTJ~1%p7%
%1 %2 %p3% %p4% %p5% QGEO~1%p6%         QGEO~1%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README~7%p7%
%1 %2 %p3% %p4% %p5% README1%p6%        README1%p7%
%1 %2 %p3% %p4% %p5% REALTI~1%p6%       REALTI~1%p7%
%1 %2 %p3% %p4% %p5% RGEO~1%p6%         RGEO~1%p7%
%1 %2 %p3% %p4% %p5% RICGIS~1%p6%       RICGIS~1%p7%
%1 %2 %p3% %p4% %p5% RIZGIS~1%p6%       RIZGIS~1%p7%
%1 %2 %p3% %p4% %p5% SAO~1%p6%          SAO~1%p7%
%1 %2 %p3% %p4% %p5% SATURN~1%p6%       SATURN~1%p7%
%1 %2 %p3% %p4% %p5% SATURN~2%p6%       SATURN~2%p7%
%1 %2 %p3% %p4% %p5% SCCGIS~1%p6%       SCCGIS~1%p7%
%1 %2 %p3% %p4% %p5% SCORPI~1%p6%       SCORPI~1%p7%
%1 %2 %p3% %p4% %p5% SCZGIS~1%p6%       SCZGIS~1%p7%
%1 %2 %p3% %p4% %p5% SDCGIS~1%p6%       SDCGIS~1%p7%
%1 %2 %p3% %p4% %p5% SDZGIS~1%p6%       SDZGIS~1%p7%
%1 %2 %p3% %p4% %p5% SETIMA~1%p6%       SETIMA~1%p7%
%1 %2 %p3% %p4% %p5% SETTIN~1%p6%       SETTIN~1%p7%
%1 %2 %p3% %p4% %p5% SETTIN~2%p6%       SETTIN~2%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_~2%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUPI~3%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUPP~1%p7%
%1 %2 %p3% %p4% %p5% SFOVGI~1%p6%       SFOVGI~1%p7%
%1 %2 %p3% %p4% %p5% SKY32V~1%p6%       SKY32V~1%p7%
%1 %2 %p3% %p4% %p5% SKY3D2~1%p6%       SKY3D2~1%p7%
%1 %2 %p3% %p4% %p5% SKY3DE~1%p6%       SKY3DE~1%p7%
%1 %2 %p3% %p4% %p5% SOLAR~1%p6%        SOLAR~1%p7%
%1 %2 %p3% %p4% %p5% SOLARE~2%p6%       SOLARE~2%p7%
%1 %2 %p3% %p4% %p5% SOLARS~2%p6%       SOLARS~2%p7%
%1 %2 %p3% %p4% %p5% SOLMAP~1%p6%       SOLMAP~1%p7%
%1 %2 %p3% %p4% %p5% SPACER~1%p6%       SPACER~1%p7%
%1 %2 %p3% %p4% %p5% SPEEDT~1%p6%       SPEEDT~1%p7%
%1 %2 %p3% %p4% %p5% SSTEPG~1%p6%       SSTEPG~1%p7%
%1 %2 %p3% %p4% %p5% STARPI~1%p6%       STARPI~1%p7%
%1 %2 %p3% %p4% %p5% STARRY~1%p6%       STARRY~1%p7%
%1 %2 %p3% %p4% %p5% STARSG~1%p6%       STARSG~1%p7%
%1 %2 %p3% %p4% %p5% STEPHA~1%p6%       STEPHA~1%p7%
%1 %2 %p3% %p4% %p5% SUNSET~1%p6%       SUNSET~1%p7%
%1 %2 %p3% %p4% %p5% T_ANGS~1%p6%       T_ANGS~1%p7%
%1 %2 %p3% %p4% %p5% T_ARRO~1%p6%       T_ARRO~1%p7%
%1 %2 %p3% %p4% %p5% T_CONS~1%p6%       T_CONS~1%p7%
%1 %2 %p3% %p4% %p5% T_HAND~1%p6%       T_HAND~1%p7%
%1 %2 %p3% %p4% %p5% T_LOCG~1%p6%       T_LOCG~1%p7%
%1 %2 %p3% %p4% %p5% T_MOVI~1%p6%       T_MOVI~1%p7%
%1 %2 %p3% %p4% %p5% T_PICT~1%p6%       T_PICT~1%p7%
%1 %2 %p3% %p4% %p5% T_ZOOM~1%p6%       T_ZOOM~1%p7%
%1 %2 %p3% %p4% %p5% TEMPHO~1%p6%       TEMPHO~1%p7%
%1 %2 %p3% %p4% %p5% TEMPHO~2%p6%       TEMPHO~2%p7%
%1 %2 %p3% %p4% %p5% THE~1%p6%          THE~1%p7%
%1 %2 %p3% %p4% %p5% TIMEGI~1%p6%       TIMEGI~1%p7%
%1 %2 %p3% %p4% %p5% TIMEHT~1%p6%       TIMEHT~1%p7%
%1 %2 %p3% %p4% %p5% TNCGIS~1%p6%       TNCGIS~1%p7%
%1 %2 %p3% %p4% %p5% TNZGIS~1%p6%       TNZGIS~1%p7%
%1 %2 %p3% %p4% %p5% TOOLBA~1%p6%       TOOLBA~1%p7%
%1 %2 %p3% %p4% %p5% TOOLHT~1%p6%       TOOLHT~1%p7%
%1 %2 %p3% %p4% %p5% TOOLSG~1%p6%       TOOLSG~1%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~1%p6%       TOPBAR~1%p7%
%1 %2 %p3% %p4% %p5% TXCGIS~1%p6%       TXCGIS~1%p7%
%1 %2 %p3% %p4% %p5% TXZGIS~1%p6%       TXZGIS~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST~1%p7%
%1 %2 %p3% %p4% %p5% USER~1%p6%         USER~1%p7%
%1 %2 %p3% %p4% %p5% UTCGIS~1%p6%       UTCGIS~1%p7%
%1 %2 %p3% %p4% %p5% UTZGIS~1%p6%       UTZGIS~1%p7%
%1 %2 %p3% %p4% %p5% VACGIS~1%p6%       VACGIS~1%p7%
%1 %2 %p3% %p4% %p5% VAZGIS~1%p6%       VAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% VEIL~1%p6%         VEIL~1%p7%
%1 %2 %p3% %p4% %p5% VENUSS~1%p6%       VENUSS~1%p7%
%1 %2 %p3% %p4% %p5% VTCGIS~1%p6%       VTCGIS~1%p7%
%1 %2 %p3% %p4% %p5% VTZGIS~1%p6%       VTZGIS~1%p7%
%1 %2 %p3% %p4% %p5% WACGIS~1%p6%       WACGIS~1%p7%
%1 %2 %p3% %p4% %p5% WAZGIS~1%p6%       WAZGIS~1%p7%
%1 %2 %p3% %p4% %p5% WELCOM~1%p6%       WELCOM~1%p7%
%1 %2 %p3% %p4% %p5% WHEREJ~1%p6%       WHEREJ~1%p7%
%1 %2 %p3% %p4% %p5% WICGIS~1%p6%       WICGIS~1%p7%
%1 %2 %p3% %p4% %p5% WINDOW~1%p6%       WINDOW~1%p7%
%1 %2 %p3% %p4% %p5% WINDOW~2%p6%       WINDOW~2%p7%
%1 %2 %p3% %p4% %p5% WIZGIS~1%p6%       WIZGIS~1%p7%
%1 %2 %p3% %p4% %p5% WVCGIS~1%p6%       WVCGIS~1%p7%
%1 %2 %p3% %p4% %p5% WVZGIS~1%p6%       WVZGIS~1%p7%
%1 %2 %p3% %p4% %p5% WYCGIS~1%p6%       WYCGIS~1%p7%
%1 %2 %p3% %p4% %p5% WYZGIS~1%p6%       WYZGIS~1%p7%
%1 %2 %p3% %p4% %p5% XREFZO~1%p6%       XREFZO~1%p7%
%1 %2 %p3% %p4% %p5% ZOOM2G~1%p6%       ZOOM2G~1%p7%
%1 %2 %p3% %p4% %p5% ZOOMGI~1%p6%       ZOOMGI~1%p7%

cd %dir9%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST3~1%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL~1%p7%
%1 %2 %p3% %p4% %p5% _ISREG~1%p6%       _ISREG~1%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES~1%p7%
%1 %2 %p3% %p4% %p5% _ISUSE~1%p6%       _ISUSE~1%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP~1%p7%
%1 %2 %p3% %p4% %p5% !!LICE~1%p6%       !!LICE~1%p7%
%1 %2 %p3% %p4% %p5% A0000~10%p6%       A0000~10%p7%
%1 %2 %p3% %p4% %p5% A0000~11%p6%       A0000~11%p7%
%1 %2 %p3% %p4% %p5% A0000~12%p6%       A0000~12%p7%
%1 %2 %p3% %p4% %p5% A0000~13%p6%       A0000~13%p7%
%1 %2 %p3% %p4% %p5% A0000~14%p6%       A0000~14%p7%
%1 %2 %p3% %p4% %p5% A0000~15%p6%       A0000~15%p7%
%1 %2 %p3% %p4% %p5% A0000~16%p6%       A0000~16%p7%
%1 %2 %p3% %p4% %p5% A0000~17%p6%       A0000~17%p7%
%1 %2 %p3% %p4% %p5% A0000~18%p6%       A0000~18%p7%
%1 %2 %p3% %p4% %p5% A0000~19%p6%       A0000~19%p7%
%1 %2 %p3% %p4% %p5% A0000~20%p6%       A0000~20%p7%
%1 %2 %p3% %p4% %p5% A0000~21%p6%       A0000~21%p7%
%1 %2 %p3% %p4% %p5% A0000~22%p6%       A0000~22%p7%
%1 %2 %p3% %p4% %p5% A0000~23%p6%       A0000~23%p7%
%1 %2 %p3% %p4% %p5% A0000~24%p6%       A0000~24%p7%
%1 %2 %p3% %p4% %p5% A0000~25%p6%       A0000~25%p7%
%1 %2 %p3% %p4% %p5% A0000~26%p6%       A0000~26%p7%
%1 %2 %p3% %p4% %p5% A0000~27%p6%       A0000~27%p7%
%1 %2 %p3% %p4% %p5% A0000~28%p6%       A0000~28%p7%
%1 %2 %p3% %p4% %p5% A0000~29%p6%       A0000~29%p7%
%1 %2 %p3% %p4% %p5% A0000~30%p6%       A0000~30%p7%
%1 %2 %p3% %p4% %p5% A0000~31%p6%       A0000~31%p7%
%1 %2 %p3% %p4% %p5% A0000~32%p6%       A0000~32%p7%
%1 %2 %p3% %p4% %p5% A0000~33%p6%       A0000~33%p7%
%1 %2 %p3% %p4% %p5% A0000~34%p6%       A0000~34%p7%
%1 %2 %p3% %p4% %p5% A0000~35%p6%       A0000~35%p7%
%1 %2 %p3% %p4% %p5% A0000~36%p6%       A0000~36%p7%
%1 %2 %p3% %p4% %p5% A0000~37%p6%       A0000~37%p7%
%1 %2 %p3% %p4% %p5% A0000~38%p6%       A0000~38%p7%
%1 %2 %p3% %p4% %p5% A0000~39%p6%       A0000~39%p7%
%1 %2 %p3% %p4% %p5% A0000~40%p6%       A0000~40%p7%
%1 %2 %p3% %p4% %p5% A0000~41%p6%       A0000~41%p7%
%1 %2 %p3% %p4% %p5% A0000~42%p6%       A0000~42%p7%
%1 %2 %p3% %p4% %p5% A0000~43%p6%       A0000~43%p7%
%1 %2 %p3% %p4% %p5% A0000~44%p6%       A0000~44%p7%
%1 %2 %p3% %p4% %p5% A0000~45%p6%       A0000~45%p7%
%1 %2 %p3% %p4% %p5% A0000~46%p6%       A0000~46%p7%
%1 %2 %p3% %p4% %p5% A0000~47%p6%       A0000~47%p7%
%1 %2 %p3% %p4% %p5% A0000~48%p6%       A0000~48%p7%
%1 %2 %p3% %p4% %p5% A0000~49%p6%       A0000~49%p7%
%1 %2 %p3% %p4% %p5% A0000~50%p6%       A0000~50%p7%
%1 %2 %p3% %p4% %p5% A0000~51%p6%       A0000~51%p7%
%1 %2 %p3% %p4% %p5% A0000~52%p6%       A0000~52%p7%
%1 %2 %p3% %p4% %p5% A0000~53%p6%       A0000~53%p7%
%1 %2 %p3% %p4% %p5% A0000~54%p6%       A0000~54%p7%
%1 %2 %p3% %p4% %p5% A0000~55%p6%       A0000~55%p7%
%1 %2 %p3% %p4% %p5% A0000~56%p6%       A0000~56%p7%
%1 %2 %p3% %p4% %p5% A0000~57%p6%       A0000~57%p7%
%1 %2 %p3% %p4% %p5% A0000~58%p6%       A0000~58%p7%
%1 %2 %p3% %p4% %p5% A0000~59%p6%       A0000~59%p7%
%1 %2 %p3% %p4% %p5% A0000~60%p6%       A0000~60%p7%
%1 %2 %p3% %p4% %p5% A0000~61%p6%       A0000~61%p7%
%1 %2 %p3% %p4% %p5% A0000~62%p6%       A0000~62%p7%
%1 %2 %p3% %p4% %p5% A0000~63%p6%       A0000~63%p7%
%1 %2 %p3% %p4% %p5% A0000~64%p6%       A0000~64%p7%
%1 %2 %p3% %p4% %p5% A0000~65%p6%       A0000~65%p7%
%1 %2 %p3% %p4% %p5% A0000~66%p6%       A0000~66%p7%
%1 %2 %p3% %p4% %p5% A0000~67%p6%       A0000~67%p7%
%1 %2 %p3% %p4% %p5% A0000~68%p6%       A0000~68%p7%
%1 %2 %p3% %p4% %p5% A0000~69%p6%       A0000~69%p7%
%1 %2 %p3% %p4% %p5% A0000~70%p6%       A0000~70%p7%
%1 %2 %p3% %p4% %p5% A0000~71%p6%       A0000~71%p7%
%1 %2 %p3% %p4% %p5% A0000~72%p6%       A0000~72%p7%
%1 %2 %p3% %p4% %p5% A0000~73%p6%       A0000~73%p7%
%1 %2 %p3% %p4% %p5% A0000~74%p6%       A0000~74%p7%
%1 %2 %p3% %p4% %p5% A0000~75%p6%       A0000~75%p7%
%1 %2 %p3% %p4% %p5% A0000~76%p6%       A0000~76%p7%
%1 %2 %p3% %p4% %p5% A0000~77%p6%       A0000~77%p7%
%1 %2 %p3% %p4% %p5% A0000~78%p6%       A0000~78%p7%
%1 %2 %p3% %p4% %p5% A00000~1%p6%       A00000~1%p7%
%1 %2 %p3% %p4% %p5% A00000~2%p6%       A00000~2%p7%
%1 %2 %p3% %p4% %p5% A00000~3%p6%       A00000~3%p7%
%1 %2 %p3% %p4% %p5% A00000~4%p6%       A00000~4%p7%
%1 %2 %p3% %p4% %p5% A00000~5%p6%       A00000~5%p7%
%1 %2 %p3% %p4% %p5% A00000~6%p6%       A00000~6%p7%
%1 %2 %p3% %p4% %p5% A00000~7%p6%       A00000~7%p7%
%1 %2 %p3% %p4% %p5% A00000~8%p6%       A00000~8%p7%
%1 %2 %p3% %p4% %p5% A00000~9%p6%       A00000~9%p7%
%1 %2 %p3% %p4% %p5% APPSET~1%p6%       APPSET~1%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       AUTORU~1%p7%
%1 %2 %p3% %p4% %p5% AUTORU~2%p6%       AUTORU~2%p7%
%1 %2 %p3% %p4% %p5% AVANZA~1%p6%       AVANZA~1%p7%
%1 %2 %p3% %p4% %p5% AWPHEL~1%p6%       AWPHEL~1%p7%
%1 %2 %p3% %p4% %p5% AWPHEL~2%p6%       AWPHEL~2%p7%
%1 %2 %p3% %p4% %p5% BCB10P~1%p6%       BCB10P~1%p7%
%1 %2 %p3% %p4% %p5% BCB30P~1%p6%       BCB30P~1%p7%
%1 %2 %p3% %p4% %p5% BORHEL~1%p6%       BORHEL~1%p7%
%1 %2 %p3% %p4% %p5% BORHEL~2%p6%       BORHEL~2%p7%
%1 %2 %p3% %p4% %p5% BORHEL~3%p6%       BORHEL~3%p7%
%1 %2 %p3% %p4% %p5% CD_INS~1%p6%       CD_INS~1%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~1%p6%       CDNAVI~1%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~2%p6%       CDNAVI~2%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~3%p6%       CDNAVI~3%p7%
%1 %2 %p3% %p4% %p5% CDROMA~1%p6%       CDROMA~1%p7%
%1 %2 %p3% %p4% %p5% CHELP3~1%p6%       CHELP3~1%p7%
%1 %2 %p3% %p4% %p5% CHELP3~2%p6%       CHELP3~2%p7%
%1 %2 %p3% %p4% %p5% CLASS~10%p6%       CLASS~10%p7%
%1 %2 %p3% %p4% %p5% CLASS~11%p6%       CLASS~11%p7%
%1 %2 %p3% %p4% %p5% CLASS~12%p6%       CLASS~12%p7%
%1 %2 %p3% %p4% %p5% CLASS~13%p6%       CLASS~13%p7%
%1 %2 %p3% %p4% %p5% CLASS~14%p6%       CLASS~14%p7%
%1 %2 %p3% %p4% %p5% CLASS~15%p6%       CLASS~15%p7%
%1 %2 %p3% %p4% %p5% CLASS~16%p6%       CLASS~16%p7%
%1 %2 %p3% %p4% %p5% CLASS~17%p6%       CLASS~17%p7%
%1 %2 %p3% %p4% %p5% CLASS~18%p6%       CLASS~18%p7%
%1 %2 %p3% %p4% %p5% CLASS~19%p6%       CLASS~19%p7%
%1 %2 %p3% %p4% %p5% CLASS~20%p6%       CLASS~20%p7%
%1 %2 %p3% %p4% %p5% CLASS~21%p6%       CLASS~21%p7%
%1 %2 %p3% %p4% %p5% CLASSI~1%p6%       CLASSI~1%p7%
%1 %2 %p3% %p4% %p5% CLASSI~2%p6%       CLASSI~2%p7%
%1 %2 %p3% %p4% %p5% CLASSI~3%p6%       CLASSI~3%p7%
%1 %2 %p3% %p4% %p5% CLASSI~4%p6%       CLASSI~4%p7%
%1 %2 %p3% %p4% %p5% CLASSI~5%p6%       CLASSI~5%p7%
%1 %2 %p3% %p4% %p5% CLASSI~6%p6%       CLASSI~6%p7%
%1 %2 %p3% %p4% %p5% CLASSI~7%p6%       CLASSI~7%p7%
%1 %2 %p3% %p4% %p5% CLASSI~8%p6%       CLASSI~8%p7%
%1 %2 %p3% %p4% %p5% CLASSI~9%p6%       CLASSI~9%p7%
%1 %2 %p3% %p4% %p5% COLLEG~1%p6%       COLLEG~1%p7%
%1 %2 %p3% %p4% %p5% COLLEG~2%p6%       COLLEG~2%p7%
%1 %2 %p3% %p4% %p5% COMCTL~1%p6%       COMCTL~1%p7%
%1 %2 %p3% %p4% %p5% COMCTL~2%p6%       COMCTL~2%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG~1%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECO~1%p7%
%1 %2 %p3% %p4% %p5% CORNIC~1%p6%       CORNIC~1%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D3~1%p7%
%1 %2 %p3% %p4% %p5% CUSTHE~1%p6%       CUSTHE~1%p7%
%1 %2 %p3% %p4% %p5% CUSTHE~2%p6%       CUSTHE~2%p7%
%1 %2 %p3% %p4% %p5% D000~100%p6%       D000~100%p7%
%1 %2 %p3% %p4% %p5% D000~101%p6%       D000~101%p7%
%1 %2 %p3% %p4% %p5% D0000~10%p6%       D0000~10%p7%
%1 %2 %p3% %p4% %p5% D0000~11%p6%       D0000~11%p7%
%1 %2 %p3% %p4% %p5% D0000~12%p6%       D0000~12%p7%
%1 %2 %p3% %p4% %p5% D0000~13%p6%       D0000~13%p7%
%1 %2 %p3% %p4% %p5% D0000~14%p6%       D0000~14%p7%
%1 %2 %p3% %p4% %p5% D0000~15%p6%       D0000~15%p7%
%1 %2 %p3% %p4% %p5% D0000~16%p6%       D0000~16%p7%
%1 %2 %p3% %p4% %p5% D0000~17%p6%       D0000~17%p7%
%1 %2 %p3% %p4% %p5% D0000~18%p6%       D0000~18%p7%
%1 %2 %p3% %p4% %p5% D0000~19%p6%       D0000~19%p7%
%1 %2 %p3% %p4% %p5% D0000~20%p6%       D0000~20%p7%
%1 %2 %p3% %p4% %p5% D0000~21%p6%       D0000~21%p7%
%1 %2 %p3% %p4% %p5% D0000~22%p6%       D0000~22%p7%
%1 %2 %p3% %p4% %p5% D0000~23%p6%       D0000~23%p7%
%1 %2 %p3% %p4% %p5% D0000~24%p6%       D0000~24%p7%
%1 %2 %p3% %p4% %p5% D0000~25%p6%       D0000~25%p7%
%1 %2 %p3% %p4% %p5% D0000~26%p6%       D0000~26%p7%
%1 %2 %p3% %p4% %p5% D0000~27%p6%       D0000~27%p7%
%1 %2 %p3% %p4% %p5% D0000~28%p6%       D0000~28%p7%
%1 %2 %p3% %p4% %p5% D0000~29%p6%       D0000~29%p7%
%1 %2 %p3% %p4% %p5% D0000~30%p6%       D0000~30%p7%
%1 %2 %p3% %p4% %p5% D0000~31%p6%       D0000~31%p7%
%1 %2 %p3% %p4% %p5% D0000~32%p6%       D0000~32%p7%
%1 %2 %p3% %p4% %p5% D0000~33%p6%       D0000~33%p7%
%1 %2 %p3% %p4% %p5% D0000~34%p6%       D0000~34%p7%
%1 %2 %p3% %p4% %p5% D0000~35%p6%       D0000~35%p7%
%1 %2 %p3% %p4% %p5% D0000~36%p6%       D0000~36%p7%
%1 %2 %p3% %p4% %p5% D0000~37%p6%       D0000~37%p7%
%1 %2 %p3% %p4% %p5% D0000~38%p6%       D0000~38%p7%
%1 %2 %p3% %p4% %p5% D0000~39%p6%       D0000~39%p7%
%1 %2 %p3% %p4% %p5% D0000~40%p6%       D0000~40%p7%
%1 %2 %p3% %p4% %p5% D0000~41%p6%       D0000~41%p7%
%1 %2 %p3% %p4% %p5% D0000~42%p6%       D0000~42%p7%
%1 %2 %p3% %p4% %p5% D0000~43%p6%       D0000~43%p7%
%1 %2 %p3% %p4% %p5% D0000~44%p6%       D0000~44%p7%
%1 %2 %p3% %p4% %p5% D0000~45%p6%       D0000~45%p7%
%1 %2 %p3% %p4% %p5% D0000~46%p6%       D0000~46%p7%
%1 %2 %p3% %p4% %p5% D0000~47%p6%       D0000~47%p7%
%1 %2 %p3% %p4% %p5% D0000~48%p6%       D0000~48%p7%
%1 %2 %p3% %p4% %p5% D0000~49%p6%       D0000~49%p7%
%1 %2 %p3% %p4% %p5% D0000~50%p6%       D0000~50%p7%
%1 %2 %p3% %p4% %p5% D0000~51%p6%       D0000~51%p7%
%1 %2 %p3% %p4% %p5% D0000~52%p6%       D0000~52%p7%
%1 %2 %p3% %p4% %p5% D0000~53%p6%       D0000~53%p7%
%1 %2 %p3% %p4% %p5% D0000~54%p6%       D0000~54%p7%
%1 %2 %p3% %p4% %p5% D0000~55%p6%       D0000~55%p7%
%1 %2 %p3% %p4% %p5% D0000~56%p6%       D0000~56%p7%
%1 %2 %p3% %p4% %p5% D0000~57%p6%       D0000~57%p7%
%1 %2 %p3% %p4% %p5% D0000~58%p6%       D0000~58%p7%
%1 %2 %p3% %p4% %p5% D0000~59%p6%       D0000~59%p7%
%1 %2 %p3% %p4% %p5% D0000~60%p6%       D0000~60%p7%
%1 %2 %p3% %p4% %p5% D0000~61%p6%       D0000~61%p7%
%1 %2 %p3% %p4% %p5% D0000~62%p6%       D0000~62%p7%
%1 %2 %p3% %p4% %p5% D0000~63%p6%       D0000~63%p7%
%1 %2 %p3% %p4% %p5% D0000~64%p6%       D0000~64%p7%
%1 %2 %p3% %p4% %p5% D0000~65%p6%       D0000~65%p7%
%1 %2 %p3% %p4% %p5% D0000~66%p6%       D0000~66%p7%
%1 %2 %p3% %p4% %p5% D0000~67%p6%       D0000~67%p7%
%1 %2 %p3% %p4% %p5% D0000~68%p6%       D0000~68%p7%
%1 %2 %p3% %p4% %p5% D0000~69%p6%       D0000~69%p7%
%1 %2 %p3% %p4% %p5% D0000~70%p6%       D0000~70%p7%
%1 %2 %p3% %p4% %p5% D0000~71%p6%       D0000~71%p7%
%1 %2 %p3% %p4% %p5% D0000~72%p6%       D0000~72%p7%
%1 %2 %p3% %p4% %p5% D0000~73%p6%       D0000~73%p7%
%1 %2 %p3% %p4% %p5% D0000~74%p6%       D0000~74%p7%
%1 %2 %p3% %p4% %p5% D0000~75%p6%       D0000~75%p7%
%1 %2 %p3% %p4% %p5% D0000~76%p6%       D0000~76%p7%
%1 %2 %p3% %p4% %p5% D0000~77%p6%       D0000~77%p7%
%1 %2 %p3% %p4% %p5% D0000~78%p6%       D0000~78%p7%
%1 %2 %p3% %p4% %p5% D0000~79%p6%       D0000~79%p7%
%1 %2 %p3% %p4% %p5% D0000~80%p6%       D0000~80%p7%
%1 %2 %p3% %p4% %p5% D0000~81%p6%       D0000~81%p7%
%1 %2 %p3% %p4% %p5% D0000~82%p6%       D0000~82%p7%
%1 %2 %p3% %p4% %p5% D0000~83%p6%       D0000~83%p7%
%1 %2 %p3% %p4% %p5% D0000~84%p6%       D0000~84%p7%
%1 %2 %p3% %p4% %p5% D0000~85%p6%       D0000~85%p7%
%1 %2 %p3% %p4% %p5% D0000~86%p6%       D0000~86%p7%
%1 %2 %p3% %p4% %p5% D0000~87%p6%       D0000~87%p7%
%1 %2 %p3% %p4% %p5% D0000~88%p6%       D0000~88%p7%
%1 %2 %p3% %p4% %p5% D0000~89%p6%       D0000~89%p7%
%1 %2 %p3% %p4% %p5% D0000~90%p6%       D0000~90%p7%
%1 %2 %p3% %p4% %p5% D0000~91%p6%       D0000~91%p7%
%1 %2 %p3% %p4% %p5% D0000~92%p6%       D0000~92%p7%
%1 %2 %p3% %p4% %p5% D0000~93%p6%       D0000~93%p7%
%1 %2 %p3% %p4% %p5% D0000~94%p6%       D0000~94%p7%
%1 %2 %p3% %p4% %p5% D0000~95%p6%       D0000~95%p7%
%1 %2 %p3% %p4% %p5% D0000~96%p6%       D0000~96%p7%
%1 %2 %p3% %p4% %p5% D0000~97%p6%       D0000~97%p7%
%1 %2 %p3% %p4% %p5% D0000~98%p6%       D0000~98%p7%
%1 %2 %p3% %p4% %p5% D0000~99%p6%       D0000~99%p7%
%1 %2 %p3% %p4% %p5% D00000~1%p6%       D00000~1%p7%
%1 %2 %p3% %p4% %p5% D00000~2%p6%       D00000~2%p7%
%1 %2 %p3% %p4% %p5% D00000~3%p6%       D00000~3%p7%
%1 %2 %p3% %p4% %p5% D00000~4%p6%       D00000~4%p7%
%1 %2 %p3% %p4% %p5% D00000~5%p6%       D00000~5%p7%
%1 %2 %p3% %p4% %p5% D00000~6%p6%       D00000~6%p7%
%1 %2 %p3% %p4% %p5% D00000~7%p6%       D00000~7%p7%
%1 %2 %p3% %p4% %p5% D00000~8%p6%       D00000~8%p7%
%1 %2 %p3% %p4% %p5% D00000~9%p6%       D00000~9%p7%
%1 %2 %p3% %p4% %p5% D00001~1%p6%       D00001~1%p7%
%1 %2 %p3% %p4% %p5% D00001~2%p6%       D00001~2%p7%
%1 %2 %p3% %p4% %p5% D00001~3%p6%       D00001~3%p7%
%1 %2 %p3% %p4% %p5% D00001~4%p6%       D00001~4%p7%
%1 %2 %p3% %p4% %p5% D00001~5%p6%       D00001~5%p7%
%1 %2 %p3% %p4% %p5% D00001~6%p6%       D00001~6%p7%
%1 %2 %p3% %p4% %p5% DEINST~1%p6%       DEINST~1%p7%
%1 %2 %p3% %p4% %p5% DELPHI~1%p6%       DELPHI~1%p7%
%1 %2 %p3% %p4% %p5% DELPHI~2%p6%       DELPHI~2%p7%
%1 %2 %p3% %p4% %p5% DELPHI~3%p6%       DELPHI~3%p7%
%1 %2 %p3% %p4% %p5% DELPHI~4%p6%       DELPHI~4%p7%
%1 %2 %p3% %p4% %p5% DEMOWH~1%p6%       DEMOWH~1%p7%
%1 %2 %p3% %p4% %p5% DEMOWH~2%p6%       DEMOWH~2%p7%
%1 %2 %p3% %p4% %p5% DIAPOS~1%p6%       DIAPOS~1%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1I~1%p7%
%1 %2 %p3% %p4% %p5% DLGIMA~1%p6%       DLGIMA~1%p7%
%1 %2 %p3% %p4% %p5% E000~100%p6%       E000~100%p7%
%1 %2 %p3% %p4% %p5% E000~101%p6%       E000~101%p7%
%1 %2 %p3% %p4% %p5% E0000~10%p6%       E0000~10%p7%
%1 %2 %p3% %p4% %p5% E0000~11%p6%       E0000~11%p7%
%1 %2 %p3% %p4% %p5% E0000~12%p6%       E0000~12%p7%
%1 %2 %p3% %p4% %p5% E0000~13%p6%       E0000~13%p7%
%1 %2 %p3% %p4% %p5% E0000~14%p6%       E0000~14%p7%
%1 %2 %p3% %p4% %p5% E0000~15%p6%       E0000~15%p7%
%1 %2 %p3% %p4% %p5% E0000~16%p6%       E0000~16%p7%
%1 %2 %p3% %p4% %p5% E0000~17%p6%       E0000~17%p7%
%1 %2 %p3% %p4% %p5% E0000~18%p6%       E0000~18%p7%
%1 %2 %p3% %p4% %p5% E0000~19%p6%       E0000~19%p7%
%1 %2 %p3% %p4% %p5% E0000~20%p6%       E0000~20%p7%
%1 %2 %p3% %p4% %p5% E0000~21%p6%       E0000~21%p7%
%1 %2 %p3% %p4% %p5% E0000~22%p6%       E0000~22%p7%
%1 %2 %p3% %p4% %p5% E0000~23%p6%       E0000~23%p7%
%1 %2 %p3% %p4% %p5% E0000~24%p6%       E0000~24%p7%
%1 %2 %p3% %p4% %p5% E0000~25%p6%       E0000~25%p7%
%1 %2 %p3% %p4% %p5% E0000~26%p6%       E0000~26%p7%
%1 %2 %p3% %p4% %p5% E0000~27%p6%       E0000~27%p7%
%1 %2 %p3% %p4% %p5% E0000~28%p6%       E0000~28%p7%
%1 %2 %p3% %p4% %p5% E0000~29%p6%       E0000~29%p7%
%1 %2 %p3% %p4% %p5% E0000~30%p6%       E0000~30%p7%
%1 %2 %p3% %p4% %p5% E0000~31%p6%       E0000~31%p7%
%1 %2 %p3% %p4% %p5% E0000~32%p6%       E0000~32%p7%
%1 %2 %p3% %p4% %p5% E0000~33%p6%       E0000~33%p7%
%1 %2 %p3% %p4% %p5% E0000~34%p6%       E0000~34%p7%
%1 %2 %p3% %p4% %p5% E0000~35%p6%       E0000~35%p7%
%1 %2 %p3% %p4% %p5% E0000~36%p6%       E0000~36%p7%
%1 %2 %p3% %p4% %p5% E0000~37%p6%       E0000~37%p7%
%1 %2 %p3% %p4% %p5% E0000~38%p6%       E0000~38%p7%
%1 %2 %p3% %p4% %p5% E0000~39%p6%       E0000~39%p7%
%1 %2 %p3% %p4% %p5% E0000~40%p6%       E0000~40%p7%
%1 %2 %p3% %p4% %p5% E0000~41%p6%       E0000~41%p7%
%1 %2 %p3% %p4% %p5% E0000~42%p6%       E0000~42%p7%
%1 %2 %p3% %p4% %p5% E0000~43%p6%       E0000~43%p7%
%1 %2 %p3% %p4% %p5% E0000~44%p6%       E0000~44%p7%
%1 %2 %p3% %p4% %p5% E0000~45%p6%       E0000~45%p7%
%1 %2 %p3% %p4% %p5% E0000~46%p6%       E0000~46%p7%
%1 %2 %p3% %p4% %p5% E0000~47%p6%       E0000~47%p7%
%1 %2 %p3% %p4% %p5% E0000~48%p6%       E0000~48%p7%
%1 %2 %p3% %p4% %p5% E0000~49%p6%       E0000~49%p7%
%1 %2 %p3% %p4% %p5% E0000~50%p6%       E0000~50%p7%
%1 %2 %p3% %p4% %p5% E0000~51%p6%       E0000~51%p7%
%1 %2 %p3% %p4% %p5% E0000~52%p6%       E0000~52%p7%
%1 %2 %p3% %p4% %p5% E0000~53%p6%       E0000~53%p7%
%1 %2 %p3% %p4% %p5% E0000~54%p6%       E0000~54%p7%
%1 %2 %p3% %p4% %p5% E0000~55%p6%       E0000~55%p7%
%1 %2 %p3% %p4% %p5% E0000~56%p6%       E0000~56%p7%
%1 %2 %p3% %p4% %p5% E0000~57%p6%       E0000~57%p7%
%1 %2 %p3% %p4% %p5% E0000~58%p6%       E0000~58%p7%
%1 %2 %p3% %p4% %p5% E0000~59%p6%       E0000~59%p7%
%1 %2 %p3% %p4% %p5% E0000~60%p6%       E0000~60%p7%
%1 %2 %p3% %p4% %p5% E0000~61%p6%       E0000~61%p7%
%1 %2 %p3% %p4% %p5% E0000~62%p6%       E0000~62%p7%
%1 %2 %p3% %p4% %p5% E0000~63%p6%       E0000~63%p7%
%1 %2 %p3% %p4% %p5% E0000~64%p6%       E0000~64%p7%
%1 %2 %p3% %p4% %p5% E0000~65%p6%       E0000~65%p7%
%1 %2 %p3% %p4% %p5% E0000~66%p6%       E0000~66%p7%
%1 %2 %p3% %p4% %p5% E0000~67%p6%       E0000~67%p7%
%1 %2 %p3% %p4% %p5% E0000~68%p6%       E0000~68%p7%
%1 %2 %p3% %p4% %p5% E0000~69%p6%       E0000~69%p7%
%1 %2 %p3% %p4% %p5% E0000~70%p6%       E0000~70%p7%
%1 %2 %p3% %p4% %p5% E0000~71%p6%       E0000~71%p7%
%1 %2 %p3% %p4% %p5% E0000~72%p6%       E0000~72%p7%
%1 %2 %p3% %p4% %p5% E0000~73%p6%       E0000~73%p7%
%1 %2 %p3% %p4% %p5% E0000~74%p6%       E0000~74%p7%
%1 %2 %p3% %p4% %p5% E0000~75%p6%       E0000~75%p7%
%1 %2 %p3% %p4% %p5% E0000~76%p6%       E0000~76%p7%
%1 %2 %p3% %p4% %p5% E0000~77%p6%       E0000~77%p7%
%1 %2 %p3% %p4% %p5% E0000~78%p6%       E0000~78%p7%
%1 %2 %p3% %p4% %p5% E0000~79%p6%       E0000~79%p7%
%1 %2 %p3% %p4% %p5% E0000~80%p6%       E0000~80%p7%
%1 %2 %p3% %p4% %p5% E0000~81%p6%       E0000~81%p7%
%1 %2 %p3% %p4% %p5% E0000~82%p6%       E0000~82%p7%
%1 %2 %p3% %p4% %p5% E0000~83%p6%       E0000~83%p7%
%1 %2 %p3% %p4% %p5% E0000~84%p6%       E0000~84%p7%
%1 %2 %p3% %p4% %p5% E0000~85%p6%       E0000~85%p7%
%1 %2 %p3% %p4% %p5% E0000~86%p6%       E0000~86%p7%
%1 %2 %p3% %p4% %p5% E0000~87%p6%       E0000~87%p7%
%1 %2 %p3% %p4% %p5% E0000~88%p6%       E0000~88%p7%
%1 %2 %p3% %p4% %p5% E0000~89%p6%       E0000~89%p7%
%1 %2 %p3% %p4% %p5% E0000~90%p6%       E0000~90%p7%
%1 %2 %p3% %p4% %p5% E0000~91%p6%       E0000~91%p7%
%1 %2 %p3% %p4% %p5% E0000~92%p6%       E0000~92%p7%
%1 %2 %p3% %p4% %p5% E0000~93%p6%       E0000~93%p7%
%1 %2 %p3% %p4% %p5% E0000~94%p6%       E0000~94%p7%
%1 %2 %p3% %p4% %p5% E0000~95%p6%       E0000~95%p7%
%1 %2 %p3% %p4% %p5% E0000~96%p6%       E0000~96%p7%
%1 %2 %p3% %p4% %p5% E0000~97%p6%       E0000~97%p7%
%1 %2 %p3% %p4% %p5% E0000~98%p6%       E0000~98%p7%
%1 %2 %p3% %p4% %p5% E0000~99%p6%       E0000~99%p7%
%1 %2 %p3% %p4% %p5% E00000~1%p6%       E00000~1%p7%
%1 %2 %p3% %p4% %p5% E00000~2%p6%       E00000~2%p7%
%1 %2 %p3% %p4% %p5% E00000~3%p6%       E00000~3%p7%
%1 %2 %p3% %p4% %p5% E00000~4%p6%       E00000~4%p7%
%1 %2 %p3% %p4% %p5% E00000~5%p6%       E00000~5%p7%
%1 %2 %p3% %p4% %p5% E00000~6%p6%       E00000~6%p7%
%1 %2 %p3% %p4% %p5% E00000~7%p6%       E00000~7%p7%
%1 %2 %p3% %p4% %p5% E00000~8%p6%       E00000~8%p7%
%1 %2 %p3% %p4% %p5% E00000~9%p6%       E00000~9%p7%
%1 %2 %p3% %p4% %p5% E00001~1%p6%       E00001~1%p7%
%1 %2 %p3% %p4% %p5% E00001~2%p6%       E00001~2%p7%
%1 %2 %p3% %p4% %p5% E00001~3%p6%       E00001~3%p7%
%1 %2 %p3% %p4% %p5% E00001~4%p6%       E00001~4%p7%
%1 %2 %p3% %p4% %p5% E00001~5%p6%       E00001~5%p7%
%1 %2 %p3% %p4% %p5% E00001~6%p6%       E00001~6%p7%
%1 %2 %p3% %p4% %p5% ESEM0A~1%p6%       ESEM0A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM10~1%p6%       ESEM10~1%p7%
%1 %2 %p3% %p4% %p5% ESEM10~2%p6%       ESEM10~2%p7%
%1 %2 %p3% %p4% %p5% ESEM10~3%p6%       ESEM10~3%p7%
%1 %2 %p3% %p4% %p5% ESEM12~1%p6%       ESEM12~1%p7%
%1 %2 %p3% %p4% %p5% ESEM1A~1%p6%       ESEM1A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM2_~1%p6%       ESEM2_~1%p7%
%1 %2 %p3% %p4% %p5% ESEM2A~1%p6%       ESEM2A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM3A~1%p6%       ESEM3A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM5_~1%p6%       ESEM5_~1%p7%
%1 %2 %p3% %p4% %p5% ESEM51~1%p6%       ESEM51~1%p7%
%1 %2 %p3% %p4% %p5% ESEM5A~1%p6%       ESEM5A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM6_~1%p6%       ESEM6_~1%p7%
%1 %2 %p3% %p4% %p5% ESEM61~1%p6%       ESEM61~1%p7%
%1 %2 %p3% %p4% %p5% ESEM6A~1%p6%       ESEM6A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM7_~1%p6%       ESEM7_~1%p7%
%1 %2 %p3% %p4% %p5% ESEM7A~1%p6%       ESEM7A~1%p7%
%1 %2 %p3% %p4% %p5% ESEM8A~1%p6%       ESEM8A~1%p7%
%1 %2 %p3% %p4% %p5% FAR_IN~1%p6%       FAR_IN~1%p7%
%1 %2 %p3% %p4% %p5% FAR_IN~2%p6%       FAR_IN~2%p7%
%1 %2 %p3% %p4% %p5% FARBAT~1%p6%       FARBAT~1%p7%
%1 %2 %p3% %p4% %p5% FAREXE~1%p6%       FAREXE~1%p7%
%1 %2 %p3% %p4% %p5% FARHEL~1%p6%       FARHEL~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_I~1%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_I~2%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_I~3%p7%
%1 %2 %p3% %p4% %p5% FINEST~1%p6%       FINEST~1%p7%
%1 %2 %p3% %p4% %p5% FOL1AE~1%p6%       FOL1AE~1%p7%
%1 %2 %p3% %p4% %p5% FORMLE~1%p6%       FORMLE~1%p7%
%1 %2 %p3% %p4% %p5% FOUR1F~1%p6%       FOUR1F~1%p7%
%1 %2 %p3% %p4% %p5% FOURBO~1%p6%       FOURBO~1%p7%
%1 %2 %p3% %p4% %p5% FOURFR~1%p6%       FOURFR~1%p7%
%1 %2 %p3% %p4% %p5% FRDXGI~1%p6%       FRDXGI~1%p7%
%1 %2 %p3% %p4% %p5% GIDREM~1%p6%       GIDREM~1%p7%
%1 %2 %p3% %p4% %p5% GOODBY~1%p6%       GOODBY~1%p7%
%1 %2 %p3% %p4% %p5% GOODBY~2%p6%       GOODBY~2%p7%
%1 %2 %p3% %p4% %p5% HCER_~1%p6%        HCER_~1%p7%
%1 %2 %p3% %p4% %p5% HCEX_~1%p6%        HCEX_~1%p7%
%1 %2 %p3% %p4% %p5% HELP32~1%p6%       HELP32~1%p7%
%1 %2 %p3% %p4% %p5% HELPDE~1%p6%       HELPDE~1%p7%
%1 %2 %p3% %p4% %p5% HELPDE~2%p6%       HELPDE~2%p7%
%1 %2 %p3% %p4% %p5% HELPDE~3%p6%       HELPDE~3%p7%
%1 %2 %p3% %p4% %p5% HELPDE~4%p6%       HELPDE~4%p7%
%1 %2 %p3% %p4% %p5% HELPDE~5%p6%       HELPDE~5%p7%
%1 %2 %p3% %p4% %p5% HELPFI~1%p6%       HELPFI~1%p7%
%1 %2 %p3% %p4% %p5% HELPHE~1%p6%       HELPHE~1%p7%
%1 %2 %p3% %p4% %p5% HELPHE~2%p6%       HELPHE~2%p7%
%1 %2 %p3% %p4% %p5% HELPHE~3%p6%       HELPHE~3%p7%
%1 %2 %p3% %p4% %p5% HELPSC~1%p6%       HELPSC~1%p7%
%1 %2 %p3% %p4% %p5% HELPSO~1%p6%       HELPSO~1%p7%
%1 %2 %p3% %p4% %p5% HELPSO~2%p6%       HELPSO~2%p7%
%1 %2 %p3% %p4% %p5% HELPSO~3%p6%       HELPSO~3%p7%
%1 %2 %p3% %p4% %p5% HELPX_~1%p6%       HELPX_~1%p7%
%1 %2 %p3% %p4% %p5% HISTOR~1%p6%       HISTOR~1%p7%
%1 %2 %p3% %p4% %p5% HLP2TX~1%p6%       HLP2TX~1%p7%
%1 %2 %p3% %p4% %p5% HLPTXT~1%p6%       HLPTXT~1%p7%
%1 %2 %p3% %p4% %p5% HLPTXT~2%p6%       HLPTXT~2%p7%
%1 %2 %p3% %p4% %p5% HLPX13~1%p6%       HLPX13~1%p7%
%1 %2 %p3% %p4% %p5% HTMLAE~1%p6%       HTMLAE~1%p7%
%1 %2 %p3% %p4% %p5% IMMAGI~1%p6%       IMMAGI~1%p7%
%1 %2 %p3% %p4% %p5% INDEXA~1%p6%       INDEXA~1%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       INDEXH~1%p7%
%1 %2 %p3% %p4% %p5% INDEXR~1%p6%       INDEXR~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INTEST~1%p6%       INTEST~1%p7%
%1 %2 %p3% %p4% %p5% IPER3R~1%p6%       IPER3R~1%p7%
%1 %2 %p3% %p4% %p5% IPER3W~1%p6%       IPER3W~1%p7%
%1 %2 %p3% %p4% %p5% JAVAAP~1%p6%       JAVAAP~1%p7%
%1 %2 %p3% %p4% %p5% JAVASC~1%p6%       JAVASC~1%p7%
%1 %2 %p3% %p4% %p5% JAVASC~2%p6%       JAVASC~2%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENS~2%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       LICENS~3%p7%
%1 %2 %p3% %p4% %p5% LISEZM~1%p6%       LISEZM~1%p7%
%1 %2 %p3% %p4% %p5% LISTEA~1%p6%       LISTEA~1%p7%
%1 %2 %p3% %p4% %p5% METAHD~1%p6%       METAHD~1%p7%
%1 %2 %p3% %p4% %p5% MIDEIN~1%p6%       MIDEIN~1%p7%
%1 %2 %p3% %p4% %p5% MODULI~1%p6%       MODULI~1%p7%
%1 %2 %p3% %p4% %p5% MULTIM~1%p6%       MULTIM~1%p7%
%1 %2 %p3% %p4% %p5% OBJECT~1%p6%       OBJECT~1%p7%
%1 %2 %p3% %p4% %p5% OBJECT~2%p6%       OBJECT~2%p7%
%1 %2 %p3% %p4% %p5% ORDERH~1%p6%       ORDERH~1%p7%
%1 %2 %p3% %p4% %p5% P1GIF~1%p6%        P1GIF~1%p7%
%1 %2 %p3% %p4% %p5% P2GIF~1%p6%        P2GIF~1%p7%
%1 %2 %p3% %p4% %p5% P3GIF~1%p6%        P3GIF~1%p7%
%1 %2 %p3% %p4% %p5% P4GIF~1%p6%        P4GIF~1%p7%
%1 %2 %p3% %p4% %p5% PREVIE~1%p6%       PREVIE~1%p7%
%1 %2 %p3% %p4% %p5% PREVW3~1%p6%       PREVW3~1%p7%
%1 %2 %p3% %p4% %p5% PVPLUS~1%p6%       PVPLUS~1%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       READM~10%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       READM~11%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       READM~12%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       READM~13%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       READM~14%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       READM~15%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       READM~16%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       READM~17%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       READM~18%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README~1%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README~2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README~3%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README~4%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README~5%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README~6%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README~7%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README~8%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README~9%p7%
%1 %2 %p3% %p4% %p5% RESOLU~1%p6%       RESOLU~1%p7%
%1 %2 %p3% %p4% %p5% RESOLU~2%p6%       RESOLU~2%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RICHED~1%p7%
%1 %2 %p3% %p4% %p5% RICHED~2%p6%       RICHED~2%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX~1%p7%
%1 %2 %p3% %p4% %p5% RICHTX~2%p6%       RICHTX~2%p7%
%1 %2 %p3% %p4% %p5% RTF2HL~1%p6%       RTF2HL~1%p7%
%1 %2 %p3% %p4% %p5% RTF2HL~2%p6%       RTF2HL~2%p7%
%1 %2 %p3% %p4% %p5% SETUEN~1%p6%       SETUEN~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_~1%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_~2%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP_~3%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_~4%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_~5%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_~6%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_~7%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       SETUP1~1%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       SETUP1~2%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUPE~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPI~1%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUPI~2%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUPI~3%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUPL~1%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUPP~1%p7%
%1 %2 %p3% %p4% %p5% SILOGO~1%p6%       SILOGO~1%p7%
%1 %2 %p3% %p4% %p5% SILOGO~2%p6%       SILOGO~2%p7%
%1 %2 %p3% %p4% %p5% SILOGO~3%p6%       SILOGO~3%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       SIMPLE~1%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       SIMPLE~2%p7%
%1 %2 %p3% %p4% %p5% SIMTEL~1%p6%       SIMTEL~1%p7%
%1 %2 %p3% %p4% %p5% SLIDE1~1%p6%       SLIDE1~1%p7%
%1 %2 %p3% %p4% %p5% SLIDE1~2%p6%       SLIDE1~2%p7%
%1 %2 %p3% %p4% %p5% SPLITM~1%p6%       SPLITM~1%p7%
%1 %2 %p3% %p4% %p5% SPLITM~2%p6%       SPLITM~2%p7%
%1 %2 %p3% %p4% %p5% SSETUP~1%p6%       SSETUP~1%p7%
%1 %2 %p3% %p4% %p5% SSPLAS~1%p6%       SSPLAS~1%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~1%p6%       ST5UNS~1%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~2%p6%       ST5UNS~2%p7%
%1 %2 %p3% %p4% %p5% STILIA~1%p6%       STILIA~1%p7%
%1 %2 %p3% %p4% %p5% STILIG~1%p6%       STILIG~1%p7%
%1 %2 %p3% %p4% %p5% STILIH~1%p6%       STILIH~1%p7%
%1 %2 %p3% %p4% %p5% STILIH~2%p6%       STILIH~2%p7%
%1 %2 %p3% %p4% %p5% STILIR~1%p6%       STILIR~1%p7%
%1 %2 %p3% %p4% %p5% TABELL~1%p6%       TABELL~1%p7%
%1 %2 %p3% %p4% %p5% TESTRT~1%p6%       TESTRT~1%p7%
%1 %2 %p3% %p4% %p5% TRE1FR~1%p6%       TRE1FR~1%p7%
%1 %2 %p3% %p4% %p5% TRE1W-~1%p6%       TRE1W-~1%p7%
%1 %2 %p3% %p4% %p5% TRE1WI~1%p6%       TRE1WI~1%p7%
%1 %2 %p3% %p4% %p5% TWOHOR~1%p6%       TWOHOR~1%p7%
%1 %2 %p3% %p4% %p5% TWOHOR~2%p6%       TWOHOR~2%p7%
%1 %2 %p3% %p4% %p5% TWOHOR~3%p6%       TWOHOR~3%p7%
%1 %2 %p3% %p4% %p5% TWOHOR~4%p6%       TWOHOR~4%p7%
%1 %2 %p3% %p4% %p5% TWOHOR~5%p6%       TWOHOR~5%p7%
%1 %2 %p3% %p4% %p5% TWOVER~1%p6%       TWOVER~1%p7%
%1 %2 %p3% %p4% %p5% TWOVER~2%p6%       TWOVER~2%p7%
%1 %2 %p3% %p4% %p5% TWOVER~3%p6%       TWOVER~3%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST~1%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       UNINST~2%p7%
%1 %2 %p3% %p4% %p5% UNSETU~1%p6%       UNSETU~1%p7%
%1 %2 %p3% %p4% %p5% UNSETU~2%p6%       UNSETU~2%p7%
%1 %2 %p3% %p4% %p5% VB5STK~1%p6%       VB5STK~1%p7%
%1 %2 %p3% %p4% %p5% VB5STK~2%p6%       VB5STK~2%p7%
%1 %2 %p3% %p4% %p5% VENDEU~1%p6%       VENDEU~1%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR~1%p7%
%1 %2 %p3% %p4% %p5% WELCOM~1%p6%       WELCOM~1%p7%
%1 %2 %p3% %p4% %p5% WELCOM~2%p6%       WELCOM~2%p7%
%1 %2 %p3% %p4% %p5% WINCTL~1%p6%       WINCTL~1%p7%
%1 %2 %p3% %p4% %p5% XCDUNZ~1%p6%       XCDUNZ~1%p7%
%1 %2 %p3% %p4% %p5% XCDZIP~1%p6%       XCDZIP~1%p7%
%1 %2 %p3% %p4% %p5% ZAPRES~1%p6%       ZAPRES~1%p7%
%1 %2 %p3% %p4% %p5% ZAPRES~2%p6%       ZAPRES~2%p7%

cd %dira%

%1 %2 %p3% %p4% %p5% 10X20P~1%p6%       10X20P~1%p7%
%1 %2 %p3% %p4% %p5% 12X24P~1%p6%       12X24P~1%p7%
%1 %2 %p3% %p4% %p5% 12X24R~1%p6%       12X24R~1%p7%
%1 %2 %p3% %p4% %p5% 3C501C~1%p6%       3C501C~1%p7%
%1 %2 %p3% %p4% %p5% 3C503C~1%p6%       3C503C~1%p7%
%1 %2 %p3% %p4% %p5% 3C505C~1%p6%       3C505C~1%p7%
%1 %2 %p3% %p4% %p5% 3C507C~1%p6%       3C507C~1%p7%
%1 %2 %p3% %p4% %p5% 3C509C~1%p6%       3C509C~1%p7%
%1 %2 %p3% %p4% %p5% 3C523C~1%p6%       3C523C~1%p7%
%1 %2 %p3% %p4% %p5% 5X7PCF~1%p6%       5X7PCF~1%p7%
%1 %2 %p3% %p4% %p5% 5X8PCF~1%p6%       5X8PCF~1%p7%
%1 %2 %p3% %p4% %p5% 6X10PC~1%p6%       6X10PC~1%p7%
%1 %2 %p3% %p4% %p5% 6X12PC~1%p6%       6X12PC~1%p7%
%1 %2 %p3% %p4% %p5% 6X13BP~1%p6%       6X13BP~1%p7%
%1 %2 %p3% %p4% %p5% 6X13PC~1%p6%       6X13PC~1%p7%
%1 %2 %p3% %p4% %p5% 6X9PCF~1%p6%       6X9PCF~1%p7%
%1 %2 %p3% %p4% %p5% 7X13BP~1%p6%       7X13BP~1%p7%
%1 %2 %p3% %p4% %p5% 7X13PC~1%p6%       7X13PC~1%p7%
%1 %2 %p3% %p4% %p5% 7X14BP~1%p6%       7X14BP~1%p7%
%1 %2 %p3% %p4% %p5% 7X14PC~1%p6%       7X14PC~1%p7%
%1 %2 %p3% %p4% %p5% 7X14RK~1%p6%       7X14RK~1%p7%
%1 %2 %p3% %p4% %p5% 8X13BP~1%p6%       8X13BP~1%p7%
%1 %2 %p3% %p4% %p5% 8X13PC~1%p6%       8X13PC~1%p7%
%1 %2 %p3% %p4% %p5% 8X16PC~1%p6%       8X16PC~1%p7%
%1 %2 %p3% %p4% %p5% 8X16RK~1%p6%       8X16RK~1%p7%
%1 %2 %p3% %p4% %p5% 9X15BP~1%p6%       9X15BP~1%p7%
%1 %2 %p3% %p4% %p5% 9X15PC~1%p6%       9X15PC~1%p7%
%1 %2 %p3% %p4% %p5% AQUILA~1%p6%       AQUILA~1%p7%
%1 %2 %p3% %p4% %p5% AR450C~1%p6%       AR450C~1%p7%
%1 %2 %p3% %p4% %p5% ARCETH~1%p6%       ARCETH~1%p7%
%1 %2 %p3% %p4% %p5% ARCNET~1%p6%       ARCNET~1%p7%
%1 %2 %p3% %p4% %p5% AT&T_L~1%p6%       AT&T_L~1%p7%
%1 %2 %p3% %p4% %p5% AT&TCO~1%p6%       AT&TCO~1%p7%
%1 %2 %p3% %p4% %p5% AT1500~1%p6%       AT1500~1%p7%
%1 %2 %p3% %p4% %p5% AT1700~1%p6%       AT1700~1%p7%
%1 %2 %p3% %p4% %p5% BDFTOP~1%p6%       BDFTOP~1%p7%
%1 %2 %p3% %p4% %p5% C_ARI0~1%p6%       C_ARI0~1%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~1%p6%       C_ARI1~1%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~2%p6%       C_ARI1~2%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~3%p6%       C_ARI1~3%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~4%p6%       C_ARI1~4%p7%
%1 %2 %p3% %p4% %p5% C_ARI2~1%p6%       C_ARI2~1%p7%
%1 %2 %p3% %p4% %p5% C_ARR0~1%p6%       C_ARR0~1%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~1%p6%       C_ARR1~1%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~2%p6%       C_ARR1~2%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~3%p6%       C_ARR1~3%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~4%p6%       C_ARR1~4%p7%
%1 %2 %p3% %p4% %p5% C_ARR2~1%p6%       C_ARR2~1%p7%
%1 %2 %p3% %p4% %p5% C_URB0~1%p6%       C_URB0~1%p7%
%1 %2 %p3% %p4% %p5% C_URB1~1%p6%       C_URB1~1%p7%
%1 %2 %p3% %p4% %p5% C_URB1~2%p6%       C_URB1~2%p7%
%1 %2 %p3% %p4% %p5% C_URB1~3%p6%       C_URB1~3%p7%
%1 %2 %p3% %p4% %p5% C_URB1~4%p6%       C_URB1~4%p7%
%1 %2 %p3% %p4% %p5% C_URB2~1%p6%       C_URB2~1%p7%
%1 %2 %p3% %p4% %p5% C_URBO~1%p6%       C_URBO~1%p7%
%1 %2 %p3% %p4% %p5% C_URBO~2%p6%       C_URBO~2%p7%
%1 %2 %p3% %p4% %p5% C_URBO~3%p6%       C_URBO~3%p7%
%1 %2 %p3% %p4% %p5% C_URBO~4%p6%       C_URBO~4%p7%
%1 %2 %p3% %p4% %p5% C_URBO~5%p6%       C_URBO~5%p7%
%1 %2 %p3% %p4% %p5% C_URBO~6%p6%       C_URBO~6%p7%
%1 %2 %p3% %p4% %p5% C_URO0~1%p6%       C_URO0~1%p7%
%1 %2 %p3% %p4% %p5% C_URO1~1%p6%       C_URO1~1%p7%
%1 %2 %p3% %p4% %p5% C_URO1~2%p6%       C_URO1~2%p7%
%1 %2 %p3% %p4% %p5% C_URO1~3%p6%       C_URO1~3%p7%
%1 %2 %p3% %p4% %p5% C_URO1~4%p6%       C_URO1~4%p7%
%1 %2 %p3% %p4% %p5% C_URO2~1%p6%       C_URO2~1%p7%
%1 %2 %p3% %p4% %p5% C_URR0~1%p6%       C_URR0~1%p7%
%1 %2 %p3% %p4% %p5% C_URR1~1%p6%       C_URR1~1%p7%
%1 %2 %p3% %p4% %p5% C_URR1~2%p6%       C_URR1~2%p7%
%1 %2 %p3% %p4% %p5% C_URR1~3%p6%       C_URR1~3%p7%
%1 %2 %p3% %p4% %p5% C_URR1~4%p6%       C_URR1~4%p7%
%1 %2 %p3% %p4% %p5% C_URR2~1%p6%       C_URR2~1%p7%
%1 %2 %p3% %p4% %p5% C0419B~1%p6%       C0419B~1%p7%
%1 %2 %p3% %p4% %p5% C0582B~1%p6%       C0582B~1%p7%
%1 %2 %p3% %p4% %p5% C0583B~1%p6%       C0583B~1%p7%
%1 %2 %p3% %p4% %p5% C0611B~1%p6%       C0611B~1%p7%
%1 %2 %p3% %p4% %p5% C0632B~1%p6%       C0632B~1%p7%
%1 %2 %p3% %p4% %p5% C0633B~1%p6%       C0633B~1%p7%
%1 %2 %p3% %p4% %p5% C0648B~1%p6%       C0648B~1%p7%
%1 %2 %p3% %p4% %p5% C0649B~1%p6%       C0649B~1%p7%
%1 %2 %p3% %p4% %p5% CHARI0~1%p6%       CHARI0~1%p7%
%1 %2 %p3% %p4% %p5% CHARI1~1%p6%       CHARI1~1%p7%
%1 %2 %p3% %p4% %p5% CHARI1~2%p6%       CHARI1~2%p7%
%1 %2 %p3% %p4% %p5% CHARI1~3%p6%       CHARI1~3%p7%
%1 %2 %p3% %p4% %p5% CHARI1~4%p6%       CHARI1~4%p7%
%1 %2 %p3% %p4% %p5% CHARI2~1%p6%       CHARI2~1%p7%
%1 %2 %p3% %p4% %p5% CHARR0~1%p6%       CHARR0~1%p7%
%1 %2 %p3% %p4% %p5% CHARR1~1%p6%       CHARR1~1%p7%
%1 %2 %p3% %p4% %p5% CHARR1~2%p6%       CHARR1~2%p7%
%1 %2 %p3% %p4% %p5% CHARR1~3%p6%       CHARR1~3%p7%
%1 %2 %p3% %p4% %p5% CHARR1~4%p6%       CHARR1~4%p7%
%1 %2 %p3% %p4% %p5% CHARR2~1%p6%       CHARR2~1%p7%
%1 %2 %p3% %p4% %p5% CLB6X1~1%p6%       CLB6X1~1%p7%
%1 %2 %p3% %p4% %p5% CLB6X1~2%p6%       CLB6X1~2%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~1%p6%       CLB8X1~1%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~2%p6%       CLB8X1~2%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~3%p6%       CLB8X1~3%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~4%p6%       CLB8X1~4%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~5%p6%       CLB8X1~5%p7%
%1 %2 %p3% %p4% %p5% CLB8X8~1%p6%       CLB8X8~1%p7%
%1 %2 %p3% %p4% %p5% CLB9X1~1%p6%       CLB9X1~1%p7%
%1 %2 %p3% %p4% %p5% CLI6X1~1%p6%       CLI6X1~1%p7%
%1 %2 %p3% %p4% %p5% CLI8X8~1%p6%       CLI8X8~1%p7%
%1 %2 %p3% %p4% %p5% CLR4X6~1%p6%       CLR4X6~1%p7%
%1 %2 %p3% %p4% %p5% CLR5X1~1%p6%       CLR5X1~1%p7%
%1 %2 %p3% %p4% %p5% CLR5X6~1%p6%       CLR5X6~1%p7%
%1 %2 %p3% %p4% %p5% CLR5X8~1%p6%       CLR5X8~1%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~1%p6%       CLR6X1~1%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~2%p6%       CLR6X1~2%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~3%p6%       CLR6X1~3%p7%
%1 %2 %p3% %p4% %p5% CLR6X6~1%p6%       CLR6X6~1%p7%
%1 %2 %p3% %p4% %p5% CLR6X8~1%p6%       CLR6X8~1%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~1%p6%       CLR7X1~1%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~2%p6%       CLR7X1~2%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~3%p6%       CLR7X1~3%p7%
%1 %2 %p3% %p4% %p5% CLR7X8~1%p6%       CLR7X8~1%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~1%p6%       CLR8X1~1%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~2%p6%       CLR8X1~2%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~3%p6%       CLR8X1~3%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~4%p6%       CLR8X1~4%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~5%p6%       CLR8X1~5%p7%
%1 %2 %p3% %p4% %p5% CLR8X8~1%p6%       CLR8X8~1%p7%
%1 %2 %p3% %p4% %p5% CLR9X1~1%p6%       CLR9X1~1%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG~1%p7%
%1 %2 %p3% %p4% %p5% COURB0~1%p6%       COURB0~1%p7%
%1 %2 %p3% %p4% %p5% COURB1~1%p6%       COURB1~1%p7%
%1 %2 %p3% %p4% %p5% COURB1~2%p6%       COURB1~2%p7%
%1 %2 %p3% %p4% %p5% COURB1~3%p6%       COURB1~3%p7%
%1 %2 %p3% %p4% %p5% COURB1~4%p6%       COURB1~4%p7%
%1 %2 %p3% %p4% %p5% COURB2~1%p6%       COURB2~1%p7%
%1 %2 %p3% %p4% %p5% COURBI~1%p6%       COURBI~1%p7%
%1 %2 %p3% %p4% %p5% COURBO~1%p6%       COURBO~1%p7%
%1 %2 %p3% %p4% %p5% COURBO~2%p6%       COURBO~2%p7%
%1 %2 %p3% %p4% %p5% COURBO~3%p6%       COURBO~3%p7%
%1 %2 %p3% %p4% %p5% COURBO~4%p6%       COURBO~4%p7%
%1 %2 %p3% %p4% %p5% COURBO~5%p6%       COURBO~5%p7%
%1 %2 %p3% %p4% %p5% COURBO~6%p6%       COURBO~6%p7%
%1 %2 %p3% %p4% %p5% COURBP~1%p6%       COURBP~1%p7%
%1 %2 %p3% %p4% %p5% COURIP~1%p6%       COURIP~1%p7%
%1 %2 %p3% %p4% %p5% COURO0~1%p6%       COURO0~1%p7%
%1 %2 %p3% %p4% %p5% COURO1~1%p6%       COURO1~1%p7%
%1 %2 %p3% %p4% %p5% COURO1~2%p6%       COURO1~2%p7%
%1 %2 %p3% %p4% %p5% COURO1~3%p6%       COURO1~3%p7%
%1 %2 %p3% %p4% %p5% COURO1~4%p6%       COURO1~4%p7%
%1 %2 %p3% %p4% %p5% COURO2~1%p6%       COURO2~1%p7%
%1 %2 %p3% %p4% %p5% COURPF~1%p6%       COURPF~1%p7%
%1 %2 %p3% %p4% %p5% COURR0~1%p6%       COURR0~1%p7%
%1 %2 %p3% %p4% %p5% COURR1~1%p6%       COURR1~1%p7%
%1 %2 %p3% %p4% %p5% COURR1~2%p6%       COURR1~2%p7%
%1 %2 %p3% %p4% %p5% COURR1~3%p6%       COURR1~3%p7%
%1 %2 %p3% %p4% %p5% COURR1~4%p6%       COURR1~4%p7%
%1 %2 %p3% %p4% %p5% COURR2~1%p6%       COURR2~1%p7%
%1 %2 %p3% %p4% %p5% CROX1C~1%p6%       CROX1C~1%p7%
%1 %2 %p3% %p4% %p5% CROX1C~2%p6%       CROX1C~2%p7%
%1 %2 %p3% %p4% %p5% CROX1C~3%p6%       CROX1C~3%p7%
%1 %2 %p3% %p4% %p5% CROX1C~4%p6%       CROX1C~4%p7%
%1 %2 %p3% %p4% %p5% CROX1H~1%p6%       CROX1H~1%p7%
%1 %2 %p3% %p4% %p5% CROX1H~2%p6%       CROX1H~2%p7%
%1 %2 %p3% %p4% %p5% CROX1H~3%p6%       CROX1H~3%p7%
%1 %2 %p3% %p4% %p5% CROX1H~4%p6%       CROX1H~4%p7%
%1 %2 %p3% %p4% %p5% CROX1T~1%p6%       CROX1T~1%p7%
%1 %2 %p3% %p4% %p5% CROX1T~2%p6%       CROX1T~2%p7%
%1 %2 %p3% %p4% %p5% CROX1T~3%p6%       CROX1T~3%p7%
%1 %2 %p3% %p4% %p5% CROX1T~4%p6%       CROX1T~4%p7%
%1 %2 %p3% %p4% %p5% CROX2C~1%p6%       CROX2C~1%p7%
%1 %2 %p3% %p4% %p5% CROX2C~2%p6%       CROX2C~2%p7%
%1 %2 %p3% %p4% %p5% CROX2C~3%p6%       CROX2C~3%p7%
%1 %2 %p3% %p4% %p5% CROX2C~4%p6%       CROX2C~4%p7%
%1 %2 %p3% %p4% %p5% CROX2H~1%p6%       CROX2H~1%p7%
%1 %2 %p3% %p4% %p5% CROX2H~2%p6%       CROX2H~2%p7%
%1 %2 %p3% %p4% %p5% CROX2H~3%p6%       CROX2H~3%p7%
%1 %2 %p3% %p4% %p5% CROX2H~4%p6%       CROX2H~4%p7%
%1 %2 %p3% %p4% %p5% CROX2T~1%p6%       CROX2T~1%p7%
%1 %2 %p3% %p4% %p5% CROX2T~2%p6%       CROX2T~2%p7%
%1 %2 %p3% %p4% %p5% CROX2T~3%p6%       CROX2T~3%p7%
%1 %2 %p3% %p4% %p5% CROX2T~4%p6%       CROX2T~4%p7%
%1 %2 %p3% %p4% %p5% CROX3C~1%p6%       CROX3C~1%p7%
%1 %2 %p3% %p4% %p5% CROX3C~2%p6%       CROX3C~2%p7%
%1 %2 %p3% %p4% %p5% CROX3C~3%p6%       CROX3C~3%p7%
%1 %2 %p3% %p4% %p5% CROX3C~4%p6%       CROX3C~4%p7%
%1 %2 %p3% %p4% %p5% CROX3H~1%p6%       CROX3H~1%p7%
%1 %2 %p3% %p4% %p5% CROX3H~2%p6%       CROX3H~2%p7%
%1 %2 %p3% %p4% %p5% CROX3H~3%p6%       CROX3H~3%p7%
%1 %2 %p3% %p4% %p5% CROX3H~4%p6%       CROX3H~4%p7%
%1 %2 %p3% %p4% %p5% CROX3T~1%p6%       CROX3T~1%p7%
%1 %2 %p3% %p4% %p5% CROX3T~2%p6%       CROX3T~2%p7%
%1 %2 %p3% %p4% %p5% CROX3T~3%p6%       CROX3T~3%p7%
%1 %2 %p3% %p4% %p5% CROX3T~4%p6%       CROX3T~4%p7%
%1 %2 %p3% %p4% %p5% CROX4H~1%p6%       CROX4H~1%p7%
%1 %2 %p3% %p4% %p5% CROX4H~2%p6%       CROX4H~2%p7%
%1 %2 %p3% %p4% %p5% CROX4H~3%p6%       CROX4H~3%p7%
%1 %2 %p3% %p4% %p5% CROX4H~4%p6%       CROX4H~4%p7%
%1 %2 %p3% %p4% %p5% CROX4T~1%p6%       CROX4T~1%p7%
%1 %2 %p3% %p4% %p5% CROX4T~2%p6%       CROX4T~2%p7%
%1 %2 %p3% %p4% %p5% CROX4T~3%p6%       CROX4T~3%p7%
%1 %2 %p3% %p4% %p5% CROX4T~4%p6%       CROX4T~4%p7%
%1 %2 %p3% %p4% %p5% CROX5H~1%p6%       CROX5H~1%p7%
%1 %2 %p3% %p4% %p5% CROX5H~2%p6%       CROX5H~2%p7%
%1 %2 %p3% %p4% %p5% CROX5H~3%p6%       CROX5H~3%p7%
%1 %2 %p3% %p4% %p5% CROX5H~4%p6%       CROX5H~4%p7%
%1 %2 %p3% %p4% %p5% CROX5T~1%p6%       CROX5T~1%p7%
%1 %2 %p3% %p4% %p5% CROX5T~2%p6%       CROX5T~2%p7%
%1 %2 %p3% %p4% %p5% CROX5T~3%p6%       CROX5T~3%p7%
%1 %2 %p3% %p4% %p5% CROX5T~4%p6%       CROX5T~4%p7%
%1 %2 %p3% %p4% %p5% CROX6H~1%p6%       CROX6H~1%p7%
%1 %2 %p3% %p4% %p5% CROX6H~2%p6%       CROX6H~2%p7%
%1 %2 %p3% %p4% %p5% CROX6H~3%p6%       CROX6H~3%p7%
%1 %2 %p3% %p4% %p5% CROX6H~4%p6%       CROX6H~4%p7%
%1 %2 %p3% %p4% %p5% CROX6T~1%p6%       CROX6T~1%p7%
%1 %2 %p3% %p4% %p5% CROX6T~2%p6%       CROX6T~2%p7%
%1 %2 %p3% %p4% %p5% CROX6T~3%p6%       CROX6T~3%p7%
%1 %2 %p3% %p4% %p5% CROX6T~4%p6%       CROX6T~4%p7%
%1 %2 %p3% %p4% %p5% CSLIPP~1%p6%       CSLIPP~1%p7%
%1 %2 %p3% %p4% %p5% CTROND~1%p6%       CTROND~1%p7%
%1 %2 %p3% %p4% %p5% CURSOR~1%p6%       CURSOR~1%p7%
%1 %2 %p3% %p4% %p5% DAVIDS~1%p6%       DAVIDS~1%p7%
%1 %2 %p3% %p4% %p5% DE600C~1%p6%       DE600C~1%p7%
%1 %2 %p3% %p4% %p5% DECCUR~1%p6%       DECCUR~1%p7%
%1 %2 %p3% %p4% %p5% DECSES~1%p6%       DECSES~1%p7%
%1 %2 %p3% %p4% %p5% DEPCAC~1%p6%       DEPCAC~1%p7%
%1 %2 %p3% %p4% %p5% DIALPP~1%p6%       DIALPP~1%p7%
%1 %2 %p3% %p4% %p5% DIS_PK~1%p6%       DIS_PK~1%p7%
%1 %2 %p3% %p4% %p5% DIS_PK~2%p6%       DIS_PK~2%p7%
%1 %2 %p3% %p4% %p5% DK8696~1%p6%       DK8696~1%p7%
%1 %2 %p3% %p4% %p5% DK8696~2%p6%       DK8696~2%p7%
%1 %2 %p3% %p4% %p5% EMU387~1%p6%       EMU387~1%p7%
%1 %2 %p3% %p4% %p5% EN301C~1%p6%       EN301C~1%p7%
%1 %2 %p3% %p4% %p5% ES3210~1%p6%       ES3210~1%p7%
%1 %2 %p3% %p4% %p5% ETHERS~1%p6%       ETHERS~1%p7%
%1 %2 %p3% %p4% %p5% ETHIIE~1%p6%       ETHIIE~1%p7%
%1 %2 %p3% %p4% %p5% EXOS20~1%p6%       EXOS20~1%p7%
%1 %2 %p3% %p4% %p5% EXP16C~1%p6%       EXP16C~1%p7%
%1 %2 %p3% %p4% %p5% EXPRES~1%p6%       EXPRES~1%p7%
%1 %2 %p3% %p4% %p5% F_NTSA~1%p6%       F_NTSA~1%p7%
%1 %2 %p3% %p4% %p5% F_NTSD~1%p6%       F_NTSD~1%p7%
%1 %2 %p3% %p4% %p5% FONT04~1%p6%       FONT04~1%p7%
%1 %2 %p3% %p4% %p5% FONT05~1%p6%       FONT05~1%p7%
%1 %2 %p3% %p4% %p5% FONT05~2%p6%       FONT05~2%p7%
%1 %2 %p3% %p4% %p5% FONT06~1%p6%       FONT06~1%p7%
%1 %2 %p3% %p4% %p5% FONT06~2%p6%       FONT06~2%p7%
%1 %2 %p3% %p4% %p5% FONT06~3%p6%       FONT06~3%p7%
%1 %2 %p3% %p4% %p5% FONT07~1%p6%       FONT07~1%p7%
%1 %2 %p3% %p4% %p5% FONT07~2%p6%       FONT07~2%p7%
%1 %2 %p3% %p4% %p5% FONTS_~1%p6%       FONTS_~1%p7%
%1 %2 %p3% %p4% %p5% FONTS_~2%p6%       FONTS_~2%p7%
%1 %2 %p3% %p4% %p5% FONTS_~3%p6%       FONTS_~3%p7%
%1 %2 %p3% %p4% %p5% FONTS_~4%p6%       FONTS_~4%p7%
%1 %2 %p3% %p4% %p5% FONTS_~5%p6%       FONTS_~5%p7%
%1 %2 %p3% %p4% %p5% FONTS_~6%p6%       FONTS_~6%p7%
%1 %2 %p3% %p4% %p5% FONTS_~7%p6%       FONTS_~7%p7%
%1 %2 %p3% %p4% %p5% FONTS_~8%p6%       FONTS_~8%p7%
%1 %2 %p3% %p4% %p5% FONTSA~1%p6%       FONTSA~1%p7%
%1 %2 %p3% %p4% %p5% FONTSD~1%p6%       FONTSD~1%p7%
%1 %2 %p3% %p4% %p5% FONTSS~1%p6%       FONTSS~1%p7%
%1 %2 %p3% %p4% %p5% GB16FS~1%p6%       GB16FS~1%p7%
%1 %2 %p3% %p4% %p5% GB16ST~1%p6%       GB16ST~1%p7%
%1 %2 %p3% %p4% %p5% GB24ST~1%p6%       GB24ST~1%p7%
%1 %2 %p3% %p4% %p5% H_LVB0~1%p6%       H_LVB0~1%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~1%p6%       H_LVB1~1%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~2%p6%       H_LVB1~2%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~3%p6%       H_LVB1~3%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~4%p6%       H_LVB1~4%p7%
%1 %2 %p3% %p4% %p5% H_LVB2~1%p6%       H_LVB2~1%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~1%p6%       H_LVBO~1%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~2%p6%       H_LVBO~2%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~3%p6%       H_LVBO~3%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~4%p6%       H_LVBO~4%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~5%p6%       H_LVBO~5%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~6%p6%       H_LVBO~6%p7%
%1 %2 %p3% %p4% %p5% H_LVO0~1%p6%       H_LVO0~1%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~1%p6%       H_LVO1~1%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~2%p6%       H_LVO1~2%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~3%p6%       H_LVO1~3%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~4%p6%       H_LVO1~4%p7%
%1 %2 %p3% %p4% %p5% H_LVO2~1%p6%       H_LVO2~1%p7%
%1 %2 %p3% %p4% %p5% H_LVR0~1%p6%       H_LVR0~1%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~1%p6%       H_LVR1~1%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~2%p6%       H_LVR1~2%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~3%p6%       H_LVR1~3%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~4%p6%       H_LVR1~4%p7%
%1 %2 %p3% %p4% %p5% H_LVR2~1%p6%       H_LVR2~1%p7%
%1 %2 %p3% %p4% %p5% HANGLG~1%p6%       HANGLG~1%p7%
%1 %2 %p3% %p4% %p5% HANGLM~1%p6%       HANGLM~1%p7%
%1 %2 %p3% %p4% %p5% HANGLM~2%p6%       HANGLM~2%p7%
%1 %2 %p3% %p4% %p5% HEB6X1~1%p6%       HEB6X1~1%p7%
%1 %2 %p3% %p4% %p5% HEB8X1~1%p6%       HEB8X1~1%p7%
%1 %2 %p3% %p4% %p5% HELVB0~1%p6%       HELVB0~1%p7%
%1 %2 %p3% %p4% %p5% HELVB1~1%p6%       HELVB1~1%p7%
%1 %2 %p3% %p4% %p5% HELVB1~2%p6%       HELVB1~2%p7%
%1 %2 %p3% %p4% %p5% HELVB1~3%p6%       HELVB1~3%p7%
%1 %2 %p3% %p4% %p5% HELVB1~4%p6%       HELVB1~4%p7%
%1 %2 %p3% %p4% %p5% HELVB2~1%p6%       HELVB2~1%p7%
%1 %2 %p3% %p4% %p5% HELVBO~1%p6%       HELVBO~1%p7%
%1 %2 %p3% %p4% %p5% HELVBO~2%p6%       HELVBO~2%p7%
%1 %2 %p3% %p4% %p5% HELVBO~3%p6%       HELVBO~3%p7%
%1 %2 %p3% %p4% %p5% HELVBO~4%p6%       HELVBO~4%p7%
%1 %2 %p3% %p4% %p5% HELVBO~5%p6%       HELVBO~5%p7%
%1 %2 %p3% %p4% %p5% HELVBO~6%p6%       HELVBO~6%p7%
%1 %2 %p3% %p4% %p5% HELVO0~1%p6%       HELVO0~1%p7%
%1 %2 %p3% %p4% %p5% HELVO1~1%p6%       HELVO1~1%p7%
%1 %2 %p3% %p4% %p5% HELVO1~2%p6%       HELVO1~2%p7%
%1 %2 %p3% %p4% %p5% HELVO1~3%p6%       HELVO1~3%p7%
%1 %2 %p3% %p4% %p5% HELVO1~4%p6%       HELVO1~4%p7%
%1 %2 %p3% %p4% %p5% HELVO2~1%p6%       HELVO2~1%p7%
%1 %2 %p3% %p4% %p5% HELVR0~1%p6%       HELVR0~1%p7%
%1 %2 %p3% %p4% %p5% HELVR1~1%p6%       HELVR1~1%p7%
%1 %2 %p3% %p4% %p5% HELVR1~2%p6%       HELVR1~2%p7%
%1 %2 %p3% %p4% %p5% HELVR1~3%p6%       HELVR1~3%p7%
%1 %2 %p3% %p4% %p5% HELVR1~4%p6%       HELVR1~4%p7%
%1 %2 %p3% %p4% %p5% HELVR2~1%p6%       HELVR2~1%p7%
%1 %2 %p3% %p4% %p5% HPPCLA~1%p6%       HPPCLA~1%p7%
%1 %2 %p3% %p4% %p5% HPPCLA~2%p6%       HPPCLA~2%p7%
%1 %2 %p3% %p4% %p5% IBMTOK~1%p6%       IBMTOK~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTAL~1%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTAL~2%p7%
%1 %2 %p3% %p4% %p5% IPXPKT~1%p6%       IPXPKT~1%p7%
%1 %2 %p3% %p4% %p5% ISOLAN~1%p6%       ISOLAN~1%p7%
%1 %2 %p3% %p4% %p5% ISOLIN~1%p6%       ISOLIN~1%p7%
%1 %2 %p3% %p4% %p5% JISKAN~1%p6%       JISKAN~1%p7%
%1 %2 %p3% %p4% %p5% JISKAN~2%p6%       JISKAN~2%p7%
%1 %2 %p3% %p4% %p5% K14PCF~1%p6%       K14PCF~1%p7%
%1 %2 %p3% %p4% %p5% KEYMA~10%p6%       KEYMA~10%p7%
%1 %2 %p3% %p4% %p5% KEYMA~11%p6%       KEYMA~11%p7%
%1 %2 %p3% %p4% %p5% KEYMA~12%p6%       KEYMA~12%p7%
%1 %2 %p3% %p4% %p5% KEYMA~13%p6%       KEYMA~13%p7%
%1 %2 %p3% %p4% %p5% KEYMA~14%p6%       KEYMA~14%p7%
%1 %2 %p3% %p4% %p5% KEYMA~15%p6%       KEYMA~15%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~1%p6%       KEYMAP~1%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~2%p6%       KEYMAP~2%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~3%p6%       KEYMAP~3%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~4%p6%       KEYMAP~4%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~5%p6%       KEYMAP~5%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~6%p6%       KEYMAP~6%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~7%p6%       KEYMAP~7%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~8%p6%       KEYMAP~8%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~9%p6%       KEYMAP~9%p7%
%1 %2 %p3% %p4% %p5% KODIAK~1%p6%       KODIAK~1%p7%
%1 %2 %p3% %p4% %p5% KODIAK~2%p6%       KODIAK~2%p7%
%1 %2 %p3% %p4% %p5% KODIAK~3%p6%       KODIAK~3%p7%
%1 %2 %p3% %p4% %p5% KOI10X~1%p6%       KOI10X~1%p7%
%1 %2 %p3% %p4% %p5% KOI10X~2%p6%       KOI10X~2%p7%
%1 %2 %p3% %p4% %p5% KOI12X~1%p6%       KOI12X~1%p7%
%1 %2 %p3% %p4% %p5% KOI6X1~1%p6%       KOI6X1~1%p7%
%1 %2 %p3% %p4% %p5% KOI6X1~2%p6%       KOI6X1~2%p7%
%1 %2 %p3% %p4% %p5% KOI8X1~1%p6%       KOI8X1~1%p7%
%1 %2 %p3% %p4% %p5% KOI9X1~1%p6%       KOI9X1~1%p7%
%1 %2 %p3% %p4% %p5% KOINIL~1%p6%       KOINIL~1%p7%
%1 %2 %p3% %p4% %p5% L_BB08~1%p6%       L_BB08~1%p7%
%1 %2 %p3% %p4% %p5% L_BB10~1%p6%       L_BB10~1%p7%
%1 %2 %p3% %p4% %p5% L_BB12~1%p6%       L_BB12~1%p7%
%1 %2 %p3% %p4% %p5% L_BB14~1%p6%       L_BB14~1%p7%
%1 %2 %p3% %p4% %p5% L_BB18~1%p6%       L_BB18~1%p7%
%1 %2 %p3% %p4% %p5% L_BB19~1%p6%       L_BB19~1%p7%
%1 %2 %p3% %p4% %p5% L_BB24~1%p6%       L_BB24~1%p7%
%1 %2 %p3% %p4% %p5% L_BBI0~1%p6%       L_BBI0~1%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~1%p6%       L_BBI1~1%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~2%p6%       L_BBI1~2%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~3%p6%       L_BBI1~3%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~4%p6%       L_BBI1~4%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~5%p6%       L_BBI1~5%p7%
%1 %2 %p3% %p4% %p5% L_BBI2~1%p6%       L_BBI2~1%p7%
%1 %2 %p3% %p4% %p5% L_BI08~1%p6%       L_BI08~1%p7%
%1 %2 %p3% %p4% %p5% L_BI10~1%p6%       L_BI10~1%p7%
%1 %2 %p3% %p4% %p5% L_BI12~1%p6%       L_BI12~1%p7%
%1 %2 %p3% %p4% %p5% L_BI14~1%p6%       L_BI14~1%p7%
%1 %2 %p3% %p4% %p5% L_BI18~1%p6%       L_BI18~1%p7%
%1 %2 %p3% %p4% %p5% L_BI19~1%p6%       L_BI19~1%p7%
%1 %2 %p3% %p4% %p5% L_BI24~1%p6%       L_BI24~1%p7%
%1 %2 %p3% %p4% %p5% L_BIS0~1%p6%       L_BIS0~1%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~1%p6%       L_BIS1~1%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~2%p6%       L_BIS1~2%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~3%p6%       L_BIS1~3%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~4%p6%       L_BIS1~4%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~5%p6%       L_BIS1~5%p7%
%1 %2 %p3% %p4% %p5% L_BIS2~1%p6%       L_BIS2~1%p7%
%1 %2 %p3% %p4% %p5% L_BR08~1%p6%       L_BR08~1%p7%
%1 %2 %p3% %p4% %p5% L_BR10~1%p6%       L_BR10~1%p7%
%1 %2 %p3% %p4% %p5% L_BR12~1%p6%       L_BR12~1%p7%
%1 %2 %p3% %p4% %p5% L_BR14~1%p6%       L_BR14~1%p7%
%1 %2 %p3% %p4% %p5% L_BR18~1%p6%       L_BR18~1%p7%
%1 %2 %p3% %p4% %p5% L_BR19~1%p6%       L_BR19~1%p7%
%1 %2 %p3% %p4% %p5% L_BR24~1%p6%       L_BR24~1%p7%
%1 %2 %p3% %p4% %p5% L_BS08~1%p6%       L_BS08~1%p7%
%1 %2 %p3% %p4% %p5% L_BS10~1%p6%       L_BS10~1%p7%
%1 %2 %p3% %p4% %p5% L_BS12~1%p6%       L_BS12~1%p7%
%1 %2 %p3% %p4% %p5% L_BS14~1%p6%       L_BS14~1%p7%
%1 %2 %p3% %p4% %p5% L_BS18~1%p6%       L_BS18~1%p7%
%1 %2 %p3% %p4% %p5% L_BS19~1%p6%       L_BS19~1%p7%
%1 %2 %p3% %p4% %p5% L_BS24~1%p6%       L_BS24~1%p7%
%1 %2 %p3% %p4% %p5% L_IS08~1%p6%       L_IS08~1%p7%
%1 %2 %p3% %p4% %p5% L_IS10~1%p6%       L_IS10~1%p7%
%1 %2 %p3% %p4% %p5% L_IS12~1%p6%       L_IS12~1%p7%
%1 %2 %p3% %p4% %p5% L_IS14~1%p6%       L_IS14~1%p7%
%1 %2 %p3% %p4% %p5% L_IS18~1%p6%       L_IS18~1%p7%
%1 %2 %p3% %p4% %p5% L_IS19~1%p6%       L_IS19~1%p7%
%1 %2 %p3% %p4% %p5% L_IS24~1%p6%       L_IS24~1%p7%
%1 %2 %p3% %p4% %p5% L_RS08~1%p6%       L_RS08~1%p7%
%1 %2 %p3% %p4% %p5% L_RS10~1%p6%       L_RS10~1%p7%
%1 %2 %p3% %p4% %p5% L_RS12~1%p6%       L_RS12~1%p7%
%1 %2 %p3% %p4% %p5% L_RS14~1%p6%       L_RS14~1%p7%
%1 %2 %p3% %p4% %p5% L_RS18~1%p6%       L_RS18~1%p7%
%1 %2 %p3% %p4% %p5% L_RS19~1%p6%       L_RS19~1%p7%
%1 %2 %p3% %p4% %p5% L_RS24~1%p6%       L_RS24~1%p7%
%1 %2 %p3% %p4% %p5% L_TBS0~1%p6%       L_TBS0~1%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~1%p6%       L_TBS1~1%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~2%p6%       L_TBS1~2%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~3%p6%       L_TBS1~3%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~4%p6%       L_TBS1~4%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~5%p6%       L_TBS1~5%p7%
%1 %2 %p3% %p4% %p5% L_TBS2~1%p6%       L_TBS2~1%p7%
%1 %2 %p3% %p4% %p5% L_TRS0~1%p6%       L_TRS0~1%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~1%p6%       L_TRS1~1%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~2%p6%       L_TRS1~2%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~3%p6%       L_TRS1~3%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~4%p6%       L_TRS1~4%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~5%p6%       L_TRS1~5%p7%
%1 %2 %p3% %p4% %p5% L_TRS2~1%p6%       L_TRS2~1%p7%
%1 %2 %p3% %p4% %p5% LAN595~1%p6%       LAN595~1%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENS~1%p7%
%1 %2 %p3% %p4% %p5% LUBB08~1%p6%       LUBB08~1%p7%
%1 %2 %p3% %p4% %p5% LUBB10~1%p6%       LUBB10~1%p7%
%1 %2 %p3% %p4% %p5% LUBB12~1%p6%       LUBB12~1%p7%
%1 %2 %p3% %p4% %p5% LUBB14~1%p6%       LUBB14~1%p7%
%1 %2 %p3% %p4% %p5% LUBB18~1%p6%       LUBB18~1%p7%
%1 %2 %p3% %p4% %p5% LUBB19~1%p6%       LUBB19~1%p7%
%1 %2 %p3% %p4% %p5% LUBB24~1%p6%       LUBB24~1%p7%
%1 %2 %p3% %p4% %p5% LUBBI0~1%p6%       LUBBI0~1%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~1%p6%       LUBBI1~1%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~2%p6%       LUBBI1~2%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~3%p6%       LUBBI1~3%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~4%p6%       LUBBI1~4%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~5%p6%       LUBBI1~5%p7%
%1 %2 %p3% %p4% %p5% LUBBI2~1%p6%       LUBBI2~1%p7%
%1 %2 %p3% %p4% %p5% LUBI08~1%p6%       LUBI08~1%p7%
%1 %2 %p3% %p4% %p5% LUBI10~1%p6%       LUBI10~1%p7%
%1 %2 %p3% %p4% %p5% LUBI12~1%p6%       LUBI12~1%p7%
%1 %2 %p3% %p4% %p5% LUBI14~1%p6%       LUBI14~1%p7%
%1 %2 %p3% %p4% %p5% LUBI18~1%p6%       LUBI18~1%p7%
%1 %2 %p3% %p4% %p5% LUBI19~1%p6%       LUBI19~1%p7%
%1 %2 %p3% %p4% %p5% LUBI24~1%p6%       LUBI24~1%p7%
%1 %2 %p3% %p4% %p5% LUBIS0~1%p6%       LUBIS0~1%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~1%p6%       LUBIS1~1%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~2%p6%       LUBIS1~2%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~3%p6%       LUBIS1~3%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~4%p6%       LUBIS1~4%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~5%p6%       LUBIS1~5%p7%
%1 %2 %p3% %p4% %p5% LUBIS2~1%p6%       LUBIS2~1%p7%
%1 %2 %p3% %p4% %p5% LUBR08~1%p6%       LUBR08~1%p7%
%1 %2 %p3% %p4% %p5% LUBR10~1%p6%       LUBR10~1%p7%
%1 %2 %p3% %p4% %p5% LUBR12~1%p6%       LUBR12~1%p7%
%1 %2 %p3% %p4% %p5% LUBR14~1%p6%       LUBR14~1%p7%
%1 %2 %p3% %p4% %p5% LUBR18~1%p6%       LUBR18~1%p7%
%1 %2 %p3% %p4% %p5% LUBR19~1%p6%       LUBR19~1%p7%
%1 %2 %p3% %p4% %p5% LUBR24~1%p6%       LUBR24~1%p7%
%1 %2 %p3% %p4% %p5% LUBS08~1%p6%       LUBS08~1%p7%
%1 %2 %p3% %p4% %p5% LUBS10~1%p6%       LUBS10~1%p7%
%1 %2 %p3% %p4% %p5% LUBS12~1%p6%       LUBS12~1%p7%
%1 %2 %p3% %p4% %p5% LUBS14~1%p6%       LUBS14~1%p7%
%1 %2 %p3% %p4% %p5% LUBS18~1%p6%       LUBS18~1%p7%
%1 %2 %p3% %p4% %p5% LUBS19~1%p6%       LUBS19~1%p7%
%1 %2 %p3% %p4% %p5% LUBS24~1%p6%       LUBS24~1%p7%
%1 %2 %p3% %p4% %p5% LUIS08~1%p6%       LUIS08~1%p7%
%1 %2 %p3% %p4% %p5% LUIS10~1%p6%       LUIS10~1%p7%
%1 %2 %p3% %p4% %p5% LUIS12~1%p6%       LUIS12~1%p7%
%1 %2 %p3% %p4% %p5% LUIS14~1%p6%       LUIS14~1%p7%
%1 %2 %p3% %p4% %p5% LUIS18~1%p6%       LUIS18~1%p7%
%1 %2 %p3% %p4% %p5% LUIS19~1%p6%       LUIS19~1%p7%
%1 %2 %p3% %p4% %p5% LUIS24~1%p6%       LUIS24~1%p7%
%1 %2 %p3% %p4% %p5% LURS08~1%p6%       LURS08~1%p7%
%1 %2 %p3% %p4% %p5% LURS10~1%p6%       LURS10~1%p7%
%1 %2 %p3% %p4% %p5% LURS12~1%p6%       LURS12~1%p7%
%1 %2 %p3% %p4% %p5% LURS14~1%p6%       LURS14~1%p7%
%1 %2 %p3% %p4% %p5% LURS18~1%p6%       LURS18~1%p7%
%1 %2 %p3% %p4% %p5% LURS19~1%p6%       LURS19~1%p7%
%1 %2 %p3% %p4% %p5% LURS24~1%p6%       LURS24~1%p7%
%1 %2 %p3% %p4% %p5% LUTBS0~1%p6%       LUTBS0~1%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~1%p6%       LUTBS1~1%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~2%p6%       LUTBS1~2%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~3%p6%       LUTBS1~3%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~4%p6%       LUTBS1~4%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~5%p6%       LUTBS1~5%p7%
%1 %2 %p3% %p4% %p5% LUTBS2~1%p6%       LUTBS2~1%p7%
%1 %2 %p3% %p4% %p5% LUTRS0~1%p6%       LUTRS0~1%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~1%p6%       LUTRS1~1%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~2%p6%       LUTRS1~2%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~3%p6%       LUTRS1~3%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~4%p6%       LUTRS1~4%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~5%p6%       LUTRS1~5%p7%
%1 %2 %p3% %p4% %p5% LUTRS2~1%p6%       LUTRS2~1%p7%
%1 %2 %p3% %p4% %p5% MKFNTD~1%p6%       MKFNTD~1%p7%
%1 %2 %p3% %p4% %p5% MYLEXC~1%p6%       MYLEXC~1%p7%
%1 %2 %p3% %p4% %p5% N_ENB0~1%p6%       N_ENB0~1%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~1%p6%       N_ENB1~1%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~2%p6%       N_ENB1~2%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~3%p6%       N_ENB1~3%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~4%p6%       N_ENB1~4%p7%
%1 %2 %p3% %p4% %p5% N_ENB2~1%p6%       N_ENB2~1%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~1%p6%       N_ENBI~1%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~2%p6%       N_ENBI~2%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~3%p6%       N_ENBI~3%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~4%p6%       N_ENBI~4%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~5%p6%       N_ENBI~5%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~6%p6%       N_ENBI~6%p7%
%1 %2 %p3% %p4% %p5% N_ENI0~1%p6%       N_ENI0~1%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~1%p6%       N_ENI1~1%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~2%p6%       N_ENI1~2%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~3%p6%       N_ENI1~3%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~4%p6%       N_ENI1~4%p7%
%1 %2 %p3% %p4% %p5% N_ENI2~1%p6%       N_ENI2~1%p7%
%1 %2 %p3% %p4% %p5% N_ENR0~1%p6%       N_ENR0~1%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~1%p6%       N_ENR1~1%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~2%p6%       N_ENR1~2%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~3%p6%       N_ENR1~3%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~4%p6%       N_ENR1~4%p7%
%1 %2 %p3% %p4% %p5% N_ENR2~1%p6%       N_ENR2~1%p7%
%1 %2 %p3% %p4% %p5% NCENB0~1%p6%       NCENB0~1%p7%
%1 %2 %p3% %p4% %p5% NCENB1~1%p6%       NCENB1~1%p7%
%1 %2 %p3% %p4% %p5% NCENB1~2%p6%       NCENB1~2%p7%
%1 %2 %p3% %p4% %p5% NCENB1~3%p6%       NCENB1~3%p7%
%1 %2 %p3% %p4% %p5% NCENB1~4%p6%       NCENB1~4%p7%
%1 %2 %p3% %p4% %p5% NCENB2~1%p6%       NCENB2~1%p7%
%1 %2 %p3% %p4% %p5% NCENBI~1%p6%       NCENBI~1%p7%
%1 %2 %p3% %p4% %p5% NCENBI~2%p6%       NCENBI~2%p7%
%1 %2 %p3% %p4% %p5% NCENBI~3%p6%       NCENBI~3%p7%
%1 %2 %p3% %p4% %p5% NCENBI~4%p6%       NCENBI~4%p7%
%1 %2 %p3% %p4% %p5% NCENBI~5%p6%       NCENBI~5%p7%
%1 %2 %p3% %p4% %p5% NCENBI~6%p6%       NCENBI~6%p7%
%1 %2 %p3% %p4% %p5% NCENI0~1%p6%       NCENI0~1%p7%
%1 %2 %p3% %p4% %p5% NCENI1~1%p6%       NCENI1~1%p7%
%1 %2 %p3% %p4% %p5% NCENI1~2%p6%       NCENI1~2%p7%
%1 %2 %p3% %p4% %p5% NCENI1~3%p6%       NCENI1~3%p7%
%1 %2 %p3% %p4% %p5% NCENI1~4%p6%       NCENI1~4%p7%
%1 %2 %p3% %p4% %p5% NCENI2~1%p6%       NCENI2~1%p7%
%1 %2 %p3% %p4% %p5% NCENR0~1%p6%       NCENR0~1%p7%
%1 %2 %p3% %p4% %p5% NCENR1~1%p6%       NCENR1~1%p7%
%1 %2 %p3% %p4% %p5% NCENR1~2%p6%       NCENR1~2%p7%
%1 %2 %p3% %p4% %p5% NCENR1~3%p6%       NCENR1~3%p7%
%1 %2 %p3% %p4% %p5% NCENR1~4%p6%       NCENR1~4%p7%
%1 %2 %p3% %p4% %p5% NCENR2~1%p6%       NCENR2~1%p7%
%1 %2 %p3% %p4% %p5% NCRET1~1%p6%       NCRET1~1%p7%
%1 %2 %p3% %p4% %p5% NE1000~1%p6%       NE1000~1%p7%
%1 %2 %p3% %p4% %p5% NE2000~1%p6%       NE2000~1%p7%
%1 %2 %p3% %p4% %p5% NE2100~1%p6%       NE2100~1%p7%
%1 %2 %p3% %p4% %p5% NE2COM~1%p6%       NE2COM~1%p7%
%1 %2 %p3% %p4% %p5% NI5010~1%p6%       NI5010~1%p7%
%1 %2 %p3% %p4% %p5% NI5210~1%p6%       NI5210~1%p7%
%1 %2 %p3% %p4% %p5% NI6510~1%p6%       NI6510~1%p7%
%1 %2 %p3% %p4% %p5% NI9210~1%p6%       NI9210~1%p7%
%1 %2 %p3% %p4% %p5% NIL2PC~1%p6%       NIL2PC~1%p7%
%1 %2 %p3% %p4% %p5% NTI16C~1%p6%       NTI16C~1%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~1%p6%       ODIPKT~1%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~2%p6%       ODIPKT~2%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~3%p6%       ODIPKT~3%p7%
%1 %2 %p3% %p4% %p5% OLCURS~1%p6%       OLCURS~1%p7%
%1 %2 %p3% %p4% %p5% OLGL10~1%p6%       OLGL10~1%p7%
%1 %2 %p3% %p4% %p5% OLGL12~1%p6%       OLGL12~1%p7%
%1 %2 %p3% %p4% %p5% OLGL14~1%p6%       OLGL14~1%p7%
%1 %2 %p3% %p4% %p5% OLGL19~1%p6%       OLGL19~1%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERF~1%p7%
%1 %2 %p3% %p4% %p5% PKTDRV~1%p6%       PKTDRV~1%p7%
%1 %2 %p3% %p4% %p5% PKTMUX~1%p6%       PKTMUX~1%p7%
%1 %2 %p3% %p4% %p5% PKTMUX~2%p6%       PKTMUX~2%p7%
%1 %2 %p3% %p4% %p5% PKTSTA~1%p6%       PKTSTA~1%p7%
%1 %2 %p3% %p4% %p5% PPPDOC~1%p6%       PPPDOC~1%p7%
%1 %2 %p3% %p4% %p5% PPPEXE~1%p6%       PPPEXE~1%p7%
%1 %2 %p3% %p4% %p5% PRICIN~1%p6%       PRICIN~1%p7%
%1 %2 %p3% %p4% %p5% RGBTXT~1%p6%       RGBTXT~1%p7%
%1 %2 %p3% %p4% %p5% ROMAN_~1%p6%       ROMAN_~1%p7%
%1 %2 %p3% %p4% %p5% ROMANP~1%p6%       ROMANP~1%p7%
%1 %2 %p3% %p4% %p5% S_MB08~1%p6%       S_MB08~1%p7%
%1 %2 %p3% %p4% %p5% S_MB10~1%p6%       S_MB10~1%p7%
%1 %2 %p3% %p4% %p5% S_MB12~1%p6%       S_MB12~1%p7%
%1 %2 %p3% %p4% %p5% S_MB14~1%p6%       S_MB14~1%p7%
%1 %2 %p3% %p4% %p5% S_MB18~1%p6%       S_MB18~1%p7%
%1 %2 %p3% %p4% %p5% S_MB24~1%p6%       S_MB24~1%p7%
%1 %2 %p3% %p4% %p5% SLIPPE~1%p6%       SLIPPE~1%p7%
%1 %2 %p3% %p4% %p5% SLIPPE~2%p6%       SLIPPE~2%p7%
%1 %2 %p3% %p4% %p5% SMC_WD~1%p6%       SMC_WD~1%p7%
%1 %2 %p3% %p4% %p5% SYMB08~1%p6%       SYMB08~1%p7%
%1 %2 %p3% %p4% %p5% SYMB10~1%p6%       SYMB10~1%p7%
%1 %2 %p3% %p4% %p5% SYMB12~1%p6%       SYMB12~1%p7%
%1 %2 %p3% %p4% %p5% SYMB14~1%p6%       SYMB14~1%p7%
%1 %2 %p3% %p4% %p5% SYMB18~1%p6%       SYMB18~1%p7%
%1 %2 %p3% %p4% %p5% SYMB24~1%p6%       SYMB24~1%p7%
%1 %2 %p3% %p4% %p5% T_CH14~1%p6%       T_CH14~1%p7%
%1 %2 %p3% %p4% %p5% T_CHB1~1%p6%       T_CHB1~1%p7%
%1 %2 %p3% %p4% %p5% T_MB08~1%p6%       T_MB08~1%p7%
%1 %2 %p3% %p4% %p5% T_MB10~1%p6%       T_MB10~1%p7%
%1 %2 %p3% %p4% %p5% T_MB12~1%p6%       T_MB12~1%p7%
%1 %2 %p3% %p4% %p5% T_MB14~1%p6%       T_MB14~1%p7%
%1 %2 %p3% %p4% %p5% T_MB18~1%p6%       T_MB18~1%p7%
%1 %2 %p3% %p4% %p5% T_MB24~1%p6%       T_MB24~1%p7%
%1 %2 %p3% %p4% %p5% T_MBI0~1%p6%       T_MBI0~1%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~1%p6%       T_MBI1~1%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~2%p6%       T_MBI1~2%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~3%p6%       T_MBI1~3%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~4%p6%       T_MBI1~4%p7%
%1 %2 %p3% %p4% %p5% T_MBI2~1%p6%       T_MBI2~1%p7%
%1 %2 %p3% %p4% %p5% T_MI08~1%p6%       T_MI08~1%p7%
%1 %2 %p3% %p4% %p5% T_MI10~1%p6%       T_MI10~1%p7%
%1 %2 %p3% %p4% %p5% T_MI12~1%p6%       T_MI12~1%p7%
%1 %2 %p3% %p4% %p5% T_MI14~1%p6%       T_MI14~1%p7%
%1 %2 %p3% %p4% %p5% T_MI18~1%p6%       T_MI18~1%p7%
%1 %2 %p3% %p4% %p5% T_MI24~1%p6%       T_MI24~1%p7%
%1 %2 %p3% %p4% %p5% T_MR08~1%p6%       T_MR08~1%p7%
%1 %2 %p3% %p4% %p5% T_MR10~1%p6%       T_MR10~1%p7%
%1 %2 %p3% %p4% %p5% T_MR12~1%p6%       T_MR12~1%p7%
%1 %2 %p3% %p4% %p5% T_MR14~1%p6%       T_MR14~1%p7%
%1 %2 %p3% %p4% %p5% T_MR18~1%p6%       T_MR18~1%p7%
%1 %2 %p3% %p4% %p5% T_MR24~1%p6%       T_MR24~1%p7%
%1 %2 %p3% %p4% %p5% T_RM14~1%p6%       T_RM14~1%p7%
%1 %2 %p3% %p4% %p5% T_RMB1~1%p6%       T_RMB1~1%p7%
%1 %2 %p3% %p4% %p5% TCENET~1%p6%       TCENET~1%p7%
%1 %2 %p3% %p4% %p5% TECH14~1%p6%       TECH14~1%p7%
%1 %2 %p3% %p4% %p5% TECHB1~1%p6%       TECHB1~1%p7%
%1 %2 %p3% %p4% %p5% TERM14~1%p6%       TERM14~1%p7%
%1 %2 %p3% %p4% %p5% TERMB1~1%p6%       TERMB1~1%p7%
%1 %2 %p3% %p4% %p5% TERMIN~1%p6%       TERMIN~1%p7%
%1 %2 %p3% %p4% %p5% TIARAC~1%p6%       TIARAC~1%p7%
%1 %2 %p3% %p4% %p5% TIMB08~1%p6%       TIMB08~1%p7%
%1 %2 %p3% %p4% %p5% TIMB10~1%p6%       TIMB10~1%p7%
%1 %2 %p3% %p4% %p5% TIMB12~1%p6%       TIMB12~1%p7%
%1 %2 %p3% %p4% %p5% TIMB14~1%p6%       TIMB14~1%p7%
%1 %2 %p3% %p4% %p5% TIMB18~1%p6%       TIMB18~1%p7%
%1 %2 %p3% %p4% %p5% TIMB24~1%p6%       TIMB24~1%p7%
%1 %2 %p3% %p4% %p5% TIMBI0~1%p6%       TIMBI0~1%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~1%p6%       TIMBI1~1%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~2%p6%       TIMBI1~2%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~3%p6%       TIMBI1~3%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~4%p6%       TIMBI1~4%p7%
%1 %2 %p3% %p4% %p5% TIMBI2~1%p6%       TIMBI2~1%p7%
%1 %2 %p3% %p4% %p5% TIMI08~1%p6%       TIMI08~1%p7%
%1 %2 %p3% %p4% %p5% TIMI10~1%p6%       TIMI10~1%p7%
%1 %2 %p3% %p4% %p5% TIMI12~1%p6%       TIMI12~1%p7%
%1 %2 %p3% %p4% %p5% TIMI14~1%p6%       TIMI14~1%p7%
%1 %2 %p3% %p4% %p5% TIMI18~1%p6%       TIMI18~1%p7%
%1 %2 %p3% %p4% %p5% TIMI24~1%p6%       TIMI24~1%p7%
%1 %2 %p3% %p4% %p5% TIMR08~1%p6%       TIMR08~1%p7%
%1 %2 %p3% %p4% %p5% TIMR10~1%p6%       TIMR10~1%p7%
%1 %2 %p3% %p4% %p5% TIMR12~1%p6%       TIMR12~1%p7%
%1 %2 %p3% %p4% %p5% TIMR14~1%p6%       TIMR14~1%p7%
%1 %2 %p3% %p4% %p5% TIMR18~1%p6%       TIMR18~1%p7%
%1 %2 %p3% %p4% %p5% TIMR24~1%p6%       TIMR24~1%p7%
%1 %2 %p3% %p4% %p5% UBNICP~1%p6%       UBNICP~1%p7%
%1 %2 %p3% %p4% %p5% UBNICP~2%p6%       UBNICP~2%p7%
%1 %2 %p3% %p4% %p5% UNZIPD~1%p6%       UNZIPD~1%p7%
%1 %2 %p3% %p4% %p5% UNZIPE~1%p6%       UNZIPE~1%p7%
%1 %2 %p3% %p4% %p5% USERRT~1%p6%       USERRT~1%p7%
%1 %2 %p3% %p4% %p5% USERTX~1%p6%       USERTX~1%p7%
%1 %2 %p3% %p4% %p5% UTB___~1%p6%       UTB___~1%p7%
%1 %2 %p3% %p4% %p5% UTBI__~1%p6%       UTBI__~1%p7%
%1 %2 %p3% %p4% %p5% UTI___~1%p6%       UTI___~1%p7%
%1 %2 %p3% %p4% %p5% UTRG__~1%p6%       UTRG__~1%p7%
%1 %2 %p3% %p4% %p5% UVCONF~1%p6%       UVCONF~1%p7%
%1 %2 %p3% %p4% %p5% VAXMAT~1%p6%       VAXMAT~1%p7%
%1 %2 %p3% %p4% %p5% WINPKT~1%p6%       WINPKT~1%p7%
%1 %2 %p3% %p4% %p5% WINPKT~2%p6%       WINPKT~2%p7%
%1 %2 %p3% %p4% %p5% X_8514~1%p6%       X_8514~1%p7%
%1 %2 %p3% %p4% %p5% X_AGXE~1%p6%       X_AGXE~1%p7%
%1 %2 %p3% %p4% %p5% X_MACH~1%p6%       X_MACH~1%p7%
%1 %2 %p3% %p4% %p5% X_MACH~2%p6%       X_MACH~2%p7%
%1 %2 %p3% %p4% %p5% X_MONO~1%p6%       X_MONO~1%p7%
%1 %2 %p3% %p4% %p5% X_S3EX~1%p6%       X_S3EX~1%p7%
%1 %2 %p3% %p4% %p5% X_SVGA~1%p6%       X_SVGA~1%p7%
%1 %2 %p3% %p4% %p5% XAPPEA~1%p6%       XAPPEA~1%p7%
%1 %2 %p3% %p4% %p5% XAPPLO~1%p6%       XAPPLO~1%p7%
%1 %2 %p3% %p4% %p5% XINSTA~1%p6%       XINSTA~1%p7%
%1 %2 %p3% %p4% %p5% XINSTA~2%p6%       XINSTA~2%p7%
%1 %2 %p3% %p4% %p5% XINSTA~3%p6%       XINSTA~3%p7%
%1 %2 %p3% %p4% %p5% XINSTA~4%p6%       XINSTA~4%p7%
%1 %2 %p3% %p4% %p5% XINSTA~5%p6%       XINSTA~5%p7%
%1 %2 %p3% %p4% %p5% XTREME~1%p6%       XTREME~1%p7%
%1 %2 %p3% %p4% %p5% ZNOTEC~1%p6%       ZNOTEC~1%p7%
goto finish

:lfname

cd %dir1%

%1 %2 %p3% %p4% %p5% ___IBM~1%p6%       ___IBMPC.C%p7%
rem abort if something went wrong
if not exist ___IBM~1%p6% goto finish
if not exist ___IBMPC.C%p7% goto finish
%1 %2 %p3% %p4% %p5% ___SPE~1%p6%       ___SPEC.C%p7%
%1 %2 %p3% %p4% %p5% ___TES~1%p6%       ___TEST.C%p7%
%1 %2 %p3% %p4% %p5% ___TES~2%p6%       ___TEST.MAK%p7%
%1 %2 %p3% %p4% %p5% __H~1%p6%          __.H%p7%
%1 %2 %p3% %p4% %p5% _-H~1%p6%          _-.H%p7%
%1 %2 %p3% %p4% %p5% _ACKGR~1%p6%       _ACKGRND.PBM%p7%
%1 %2 %p3% %p4% %p5% _AKEF~10%p6%       _AKEFILE.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~1%p6%       _AKEFIL_.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~2%p6%       _AKEFIL_.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~3%p6%       _AKEFIL2.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~4%p6%       _AKEFIL2.X%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~5%p6%       _AKEFIL3.MGR%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~6%p6%       _AKEFIL3.TAM%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~7%p6%       _AKEFILE.%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~8%p6%       _AKEFILE.MGR%p7%
%1 %2 %p3% %p4% %p5% _AKEFI~9%p6%       _AKEFILE.TAM%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~1%p6%       _ALLISTO.FD%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~2%p6%       _ALLISTO.SFS%p7%
%1 %2 %p3% %p4% %p5% _ALLIS~3%p6%       _ALLISTO.SPD%p7%
%1 %2 %p3% %p4% %p5% _AP_DR~1%p6%       _AP_DR.C%p7%
%1 %2 %p3% %p4% %p5% _APC~1%p6%         _AP.C%p7%
%1 %2 %p3% %p4% %p5% _APEXE~1%p6%       _AP.EXE%p7%
%1 %2 %p3% %p4% %p5% _APH~1%p6%         _AP.H%p7%
%1 %2 %p3% %p4% %p5% _APMAK~1%p6%       _AP.MAK%p7%
%1 %2 %p3% %p4% %p5% _ARBAG~1%p6%       _ARBAGE.PBM%p7%
%1 %2 %p3% %p4% %p5% _ARSFD~1%p6%       _ARS.FD%p7%
%1 %2 %p3% %p4% %p5% _ARSSF~1%p6%       _ARS.SFS%p7%
%1 %2 %p3% %p4% %p5% _ARSSP~1%p6%       _ARS.SPD%p7%
%1 %2 %p3% %p4% %p5% _ARTHB~1%p6%       _ARTHB.SPD%p7%
%1 %2 %p3% %p4% %p5% _ARTHF~1%p6%       _ARTH.FD%p7%
%1 %2 %p3% %p4% %p5% _ARTHS~1%p6%       _ARTH.SPD%p7%
%1 %2 %p3% %p4% %p5% _ASASP~1%p6%       _ASA.SPD%p7%
%1 %2 %p3% %p4% %p5% _ASERJ~1%p6%       _ASERJET.TAB%p7%
%1 %2 %p3% %p4% %p5% _ATLON~1%p6%       _ATLON.SPD%p7%
%1 %2 %p3% %p4% %p5% _ATURN~1%p6%       _ATURN.FD%p7%
%1 %2 %p3% %p4% %p5% _B_730~1%p6%       _B_7300.C%p7%
%1 %2 %p3% %p4% %p5% _B_CPM~1%p6%       _B_CPM.C%p7%
%1 %2 %p3% %p4% %p5% _B_IBM~1%p6%       _B_IBMPC.C%p7%
%1 %2 %p3% %p4% %p5% _B_SPE~1%p6%       _B_SPEC.C%p7%
%1 %2 %p3% %p4% %p5% _B_SYS~1%p6%       _B_SYSV.C%p7%
%1 %2 %p3% %p4% %p5% _B_TES~1%p6%       _B_TEST.C%p7%
%1 %2 %p3% %p4% %p5% _B_XC~1%p6%        _B_X.C%p7%
%1 %2 %p3% %p4% %p5% _BH~1%p6%          _B.H%p7%
%1 %2 %p3% %p4% %p5% _EADM~10%p6%       _EADME_.UI%p7%
%1 %2 %p3% %p4% %p5% _EADME~1%p6%       _EAD.ME%p7%
%1 %2 %p3% %p4% %p5% _EADME~2%p6%       _EADME.bin%p7%
%1 %2 %p3% %p4% %p5% _EADME~3%p6%       _EADME.MAP%p7%
%1 %2 %p3% %p4% %p5% _EADME~4%p6%       _EADME.PC%p7%
%1 %2 %p3% %p4% %p5% _EADME~5%p6%       _EADME.SFS%p7%
%1 %2 %p3% %p4% %p5% _EADME~6%p6%       _EADME.SRC%p7%
%1 %2 %p3% %p4% %p5% _EADME~7%p6%       _EADME.UI%p7%
%1 %2 %p3% %p4% %p5% _EADME~8%p6%       _EADME_.MAP%p7%
%1 %2 %p3% %p4% %p5% _EADME~9%p6%       _EADME_.SFS%p7%
%1 %2 %p3% %p4% %p5% _EFAUL~1%p6%       _EFAULT.PBM%p7%
%1 %2 %p3% %p4% %p5% _EFAUL~2%p6%       _EFAULT.SFS%p7%
%1 %2 %p3% %p4% %p5% _EFTPB~1%p6%       _EFT.PBM%p7%
%1 %2 %p3% %p4% %p5% _ENUSF~1%p6%       _ENUS.FD%p7%
%1 %2 %p3% %p4% %p5% _EPTUN~1%p6%       _EPTUNE.FD%p7%
%1 %2 %p3% %p4% %p5% _ERCUR~1%p6%       _ERCURY.FD%p7%
%1 %2 %p3% %p4% %p5% _ERIDI~1%p6%       _ERIDIAN.SPD%p7%
%1 %2 %p3% %p4% %p5% _ERMAN~1%p6%       _ERMANSI.C%p7%
%1 %2 %p3% %p4% %p5% _ERMH~1%p6%        _ERM.H%p7%
%1 %2 %p3% %p4% %p5% _ERMNU~1%p6%       _ERMNULL.C%p7%
%1 %2 %p3% %p4% %p5% _ERMNX~1%p6%       _ERMNX10.C%p7%
%1 %2 %p3% %p4% %p5% _ESIZE~1%p6%       _ESIZE.PBM%p7%
%1 %2 %p3% %p4% %p5% _ESKJE~1%p6%       _ESKJET.TAB%p7%
%1 %2 %p3% %p4% %p5% _EST_S~1%p6%       _EST_.SPD%p7%
%1 %2 %p3% %p4% %p5% _ESTDO~1%p6%       _EST.DOC%p7%
%1 %2 %p3% %p4% %p5% _ESTM~1%p6%        _EST.M%p7%
%1 %2 %p3% %p4% %p5% _ESTPB~1%p6%       _EST.PBM%p7%
%1 %2 %p3% %p4% %p5% _ESTSF~1%p6%       _EST.SFS%p7%
%1 %2 %p3% %p4% %p5% _ESTSP~1%p6%       _EST.SPD%p7%
%1 %2 %p3% %p4% %p5% _EWSFS~1%p6%       _EW.SFS%p7%
%1 %2 %p3% %p4% %p5% _FS_DI~1%p6%       _FS_DI.C%p7%
%1 %2 %p3% %p4% %p5% _FS_FT~1%p6%       _FS_FT.C%p7%
%1 %2 %p3% %p4% %p5% _FS_GT~1%p6%       _FS_GT.C%p7%
%1 %2 %p3% %p4% %p5% _FS_PE~1%p6%       _FS_PE.C%p7%
%1 %2 %p3% %p4% %p5% _FS_PR~1%p6%       _FS_PR.C%p7%
%1 %2 %p3% %p4% %p5% _FS_VI~1%p6%       _FS_VI.C%p7%
%1 %2 %p3% %p4% %p5% _FSC~1%p6%         _FS.C%p7%
%1 %2 %p3% %p4% %p5% _FSH~1%p6%         _FS.H%p7%
%1 %2 %p3% %p4% %p5% _FSM_N~1%p6%       _FSM_N.MAK%p7%
%1 %2 %p3% %p4% %p5% _FSM_O~1%p6%       _FSM_OM.C%p7%
%1 %2 %p3% %p4% %p5% _FSMAK~1%p6%       _FS.MAK%p7%
%1 %2 %p3% %p4% %p5% _FSMC~1%p6%        _FSM.C%p7%
%1 %2 %p3% %p4% %p5% _FSMH~1%p6%        _FSM.H%p7%
%1 %2 %p3% %p4% %p5% _FSMMA~1%p6%       _FSM.MAK%p7%
%1 %2 %p3% %p4% %p5% _FSRO~1%p6%        _FS.RO%p7%
%1 %2 %p3% %p4% %p5% _FSX_C~1%p6%       _FSX_CP.C%p7%
%1 %2 %p3% %p4% %p5% _FSX_N~1%p6%       _FSX_N.MAK%p7%
%1 %2 %p3% %p4% %p5% _FSX_S~1%p6%       _FSX_SP.C%p7%
%1 %2 %p3% %p4% %p5% _FSX_V~1%p6%       _FSX_VAR.C%p7%
%1 %2 %p3% %p4% %p5% _FSXC~1%p6%        _FSX.C%p7%
%1 %2 %p3% %p4% %p5% _FSXH~1%p6%        _FSX.H%p7%
%1 %2 %p3% %p4% %p5% _FSXMA~1%p6%       _FSX.MAK%p7%
%1 %2 %p3% %p4% %p5% _HUTTL~1%p6%       _HUTTLE.SFS%p7%
%1 %2 %p3% %p4% %p5% _I_BOX~1%p6%       _I_BOXES.C%p7%
%1 %2 %p3% %p4% %p5% _I_CLO~1%p6%       _I_CLOCK.C%p7%
%1 %2 %p3% %p4% %p5% _I_DIA~1%p6%       _I_DIAL.C%p7%
%1 %2 %p3% %p4% %p5% _I_GET~1%p6%       _I_GETS.C%p7%
%1 %2 %p3% %p4% %p5% _I_ICO~1%p6%       _I_ICON.C%p7%
%1 %2 %p3% %p4% %p5% _I_INI~1%p6%       _I_INIT.C%p7%
%1 %2 %p3% %p4% %p5% _I_LIS~1%p6%       _I_LIST.C%p7%
%1 %2 %p3% %p4% %p5% _I_PBM~1%p6%       _I_PBM.C%p7%
%1 %2 %p3% %p4% %p5% _I_RBA~1%p6%       _I_RBAND.C%p7%
%1 %2 %p3% %p4% %p5% _I_TES~1%p6%       _I_TEST.C%p7%
%1 %2 %p3% %p4% %p5% _I_TES~2%p6%       _I_TEST.MAK%p7%
%1 %2 %p3% %p4% %p5% _I_TEX~1%p6%       _I_TEXT.C%p7%
%1 %2 %p3% %p4% %p5% _I_TWC~1%p6%       _I_TW.C%p7%
%1 %2 %p3% %p4% %p5% _IDOC~1%p6%        _I.DOC%p7%
%1 %2 %p3% %p4% %p5% _IGHTP~1%p6%       _IGHT.PBM%p7%
%1 %2 %p3% %p4% %p5% _IH~1%p6%          _I.H%p7%
%1 %2 %p3% %p4% %p5% _ILESY~1%p6%       _ILESYS.PBM%p7%
%1 %2 %p3% %p4% %p5% _ISTAN~1%p6%       _ISTANT.SFS%p7%
%1 %2 %p3% %p4% %p5% _ITEST~1%p6%       _ITEST_N.MAK%p7%
%1 %2 %p3% %p4% %p5% _LANKP~1%p6%       _LANK.PBM%p7%
%1 %2 %p3% %p4% %p5% _LEANL~1%p6%       _LEANLIB.BAT%p7%
%1 %2 %p3% %p4% %p5% _LEANL~2%p6%       _LEANLIB.SH%p7%
%1 %2 %p3% %p4% %p5% _LEANS~1%p6%       _LEANSFS.BAT%p7%
%1 %2 %p3% %p4% %p5% _LEANS~2%p6%       _LEANSFS.SH%p7%
%1 %2 %p3% %p4% %p5% _LEVAT~1%p6%       _LEVATOR.PBM%p7%
%1 %2 %p3% %p4% %p5% _LOPPY~1%p6%       _LOPPY.PBM%p7%
%1 %2 %p3% %p4% %p5% _LOSEP~1%p6%       _LOSE.PBM%p7%
%1 %2 %p3% %p4% %p5% _LUTOF~1%p6%       _LUTO.FD%p7%
%1 %2 %p3% %p4% %p5% _MAC_M~1%p6%       _MAC_.M%p7%
%1 %2 %p3% %p4% %p5% _MACM~1%p6%        _MAC.M%p7%
%1 %2 %p3% %p4% %p5% _MALLF~1%p6%       _MALLFON.%p7%
%1 %2 %p3% %p4% %p5% _MALLG~1%p6%       _MALLGR.SPD%p7%
%1 %2 %p3% %p4% %p5% _NCLIN~1%p6%       _NCLINED.SFS%p7%
%1 %2 %p3% %p4% %p5% _NSITA~1%p6%       _NSI.TAB%p7%
%1 %2 %p3% %p4% %p5% _O_DIV~1%p6%       _O_DIVE.C%p7%
%1 %2 %p3% %p4% %p5% _O_MAC~1%p6%       _O_MACR.C%p7%
%1 %2 %p3% %p4% %p5% _O_OUT~1%p6%       _O_OUTP.C%p7%
%1 %2 %p3% %p4% %p5% _O_POS~1%p6%       _O_POST.C%p7%
%1 %2 %p3% %p4% %p5% _O_PRO~1%p6%       _O_PROC.C%p7%
%1 %2 %p3% %p4% %p5% _O_SET~1%p6%       _O_SETP.C%p7%
%1 %2 %p3% %p4% %p5% _O_TEX~1%p6%       _O_TEXT.C%p7%
%1 %2 %p3% %p4% %p5% _O_VAR~1%p6%       _O_VAR.C%p7%
%1 %2 %p3% %p4% %p5% _O_WOR~1%p6%       _O_WORD.C%p7%
%1 %2 %p3% %p4% %p5% _OC~1%p6%          _O.C%p7%
%1 %2 %p3% %p4% %p5% _ODOC~1%p6%        _O.DOC%p7%
%1 %2 %p3% %p4% %p5% _OEXE~1%p6%        _O.EXE%p7%
%1 %2 %p3% %p4% %p5% _OH~1%p6%          _O.H%p7%
%1 %2 %p3% %p4% %p5% _OLDER~1%p6%       _OLDER.PBM%p7%
%1 %2 %p3% %p4% %p5% _OMAK~1%p6%        _O.MAK%p7%
%1 %2 %p3% %p4% %p5% _OMPLE~1%p6%       _OMPLEX.SFS%p7%
%1 %2 %p3% %p4% %p5% _OONFD~1%p6%       _OON.FD%p7%
%1 %2 %p3% %p4% %p5% _OONSF~1%p6%       _OON.SFS%p7%
%1 %2 %p3% %p4% %p5% _OQRF~1%p6%        _O.QRF%p7%
%1 %2 %p3% %p4% %p5% _OVEPB~1%p6%       _OVE.PBM%p7%
%1 %2 %p3% %p4% %p5% _OWNPB~1%p6%       _OWN.PBM%p7%
%1 %2 %p3% %p4% %p5% _PPBM~1%p6%        _P.PBM%p7%
%1 %2 %p3% %p4% %p5% _R_DEF~1%p6%       _R_DEF.C%p7%
%1 %2 %p3% %p4% %p5% _R_IBM~1%p6%       _R_IBMPC.C%p7%
%1 %2 %p3% %p4% %p5% _R_MGR~1%p6%       _R_MGR.C%p7%
%1 %2 %p3% %p4% %p5% _R_SPE~1%p6%       _R_SPEC.C%p7%
%1 %2 %p3% %p4% %p5% _R_SYS~1%p6%       _R_SYSV.C%p7%
%1 %2 %p3% %p4% %p5% _R_TAM~1%p6%       _R_TAM.C%p7%
%1 %2 %p3% %p4% %p5% _R_TES~1%p6%       _R_TEST.C%p7%
%1 %2 %p3% %p4% %p5% _R_TES~2%p6%       _R_TEST.MAK%p7%
%1 %2 %p3% %p4% %p5% _R_UNI~1%p6%       _R_UNIX.C%p7%
%1 %2 %p3% %p4% %p5% _R_XC~1%p6%        _R_X.C%p7%
%1 %2 %p3% %p4% %p5% _RANUS~1%p6%       _RANUS.FD%p7%
%1 %2 %p3% %p4% %p5% _RBSPD~1%p6%       _RB.SPD%p7%
%1 %2 %p3% %p4% %p5% _RFBAT~1%p6%       _RF.BAT%p7%
%1 %2 %p3% %p4% %p5% _RH~1%p6%          _R.H%p7%
%1 %2 %p3% %p4% %p5% _S_FOC~1%p6%       _S_FOCUS.C%p7%
%1 %2 %p3% %p4% %p5% _S_ORB~1%p6%       _S_ORBIT.C%p7%
%1 %2 %p3% %p4% %p5% _S_SPJ~1%p6%       _S_SPJ.C%p7%
%1 %2 %p3% %p4% %p5% _S_TES~1%p6%       _S_TEST.C%p7%
%1 %2 %p3% %p4% %p5% _S_TES~2%p6%       _S_TEST.MAK%p7%
%1 %2 %p3% %p4% %p5% _S_VPT~1%p6%       _S_VPT.C%p7%
%1 %2 %p3% %p4% %p5% _SH~1%p6%          _S.H%p7%
%1 %2 %p3% %p4% %p5% _UBBLE~1%p6%       _UBBLE.SFS%p7%
%1 %2 %p3% %p4% %p5% _UICKS~1%p6%       _UICK.SFS%p7%
%1 %2 %p3% %p4% %p5% _UILDL~1%p6%       _UILDLIB.BAT%p7%
%1 %2 %p3% %p4% %p5% _UILDL~2%p6%       _UILDLIB.SH%p7%
%1 %2 %p3% %p4% %p5% _UILDS~1%p6%       _UILDSFS.BAT%p7%
%1 %2 %p3% %p4% %p5% _UILDS~2%p6%       _UILDSFS.SH%p7%
%1 %2 %p3% %p4% %p5% _ULLSP~1%p6%       _ULL.SPD%p7%
%1 %2 %p3% %p4% %p5% _ULLTA~1%p6%       _ULL.TAB%p7%
%1 %2 %p3% %p4% %p5% _UNFD~1%p6%        _UN.FD%p7%
%1 %2 %p3% %p4% %p5% _UPITE~1%p6%       _UPITER.FD%p7%
%1 %2 %p3% %p4% %p5% _W_CPY~1%p6%       _W_CPY.H%p7%
%1 %2 %p3% %p4% %p5% _W_IBM~1%p6%       _W_IBMPC.C%p7%
%1 %2 %p3% %p4% %p5% _WH~1%p6%          _W.H%p7%
%1 %2 %p3% %p4% %p5% _X10TA~1%p6%       _X10.TAB%p7%
%1 %2 %p3% %p4% %p5% _XECPB~1%p6%       _XEC.PBM%p7%
%1 %2 %p3% %p4% %p5% _YNAPS~1%p6%       _YNAPSIS.PBM%p7%
%1 %2 %p3% %p4% %p5% _YWATE~1%p6%       _YWATER.PBM%p7%
%1 %2 %p3% %p4% %p5% 3DMWEX~1%p6%       3DMW.EXE%p7%
%1 %2 %p3% %p4% %p5% 3STARD~1%p6%       3STAR.DAT%p7%
%1 %2 %p3% %p4% %p5% 3STARE~1%p6%       3STAR.EXE%p7%
%1 %2 %p3% %p4% %p5% 3START~1%p6%       3STAR.TXT%p7%
%1 %2 %p3% %p4% %p5% 4179EL~1%p6%       4179.ELM%p7%
%1 %2 %p3% %p4% %p5% 96OH-1~1%p6%       96OH-1.ST6%p7%
%1 %2 %p3% %p4% %p5% 96OH-2~1%p6%       96OH-2.ST6%p7%
%1 %2 %p3% %p4% %p5% 96OHEL~1%p6%       96OH.ELM%p7%
%1 %2 %p3% %p4% %p5% AA_HAD~1%p6%       AA_HADEC.C%p7%
%1 %2 %p3% %p4% %p5% AA_QUE~1%p6%       AA_.QUE%p7%
%1 %2 %p3% %p4% %p5% AA102I~1%p6%       AA102.INI%p7%
%1 %2 %p3% %p4% %p5% AA118I~1%p6%       AA118I.INI%p7%
%1 %2 %p3% %p4% %p5% AA200A~1%p6%       AA200.ANS%p7%
%1 %2 %p3% %p4% %p5% AA200B~1%p6%       AA200.BAK%p7%
%1 %2 %p3% %p4% %p5% AA200C~1%p6%       AA200.C%p7%
%1 %2 %p3% %p4% %p5% AA200D~1%p6%       AA200.DSW%p7%
%1 %2 %p3% %p4% %p5% AA200E~1%p6%       AA200.EXE%p7%
%1 %2 %p3% %p4% %p5% AA200I~1%p6%       AA200.IDE%p7%
%1 %2 %p3% %p4% %p5% AA200I~2%p6%       AA200.INI%p7%
%1 %2 %p3% %p4% %p5% AA200M~1%p6%       AA200.MAK%p7%
%1 %2 %p3% %p4% %p5% AA200R~1%p6%       AA200.RSP%p7%
%1 %2 %p3% %p4% %p5% AA245I~1%p6%       AA245.INI%p7%
%1 %2 %p3% %p4% %p5% AA400I~1%p6%       AA400.INI%p7%
%1 %2 %p3% %p4% %p5% AA403I~1%p6%       AA403.INI%p7%
%1 %2 %p3% %p4% %p5% AA404I~1%p6%       AA404.INI%p7%
%1 %2 %p3% %p4% %p5% AA405I~1%p6%       AA405.INI%p7%
%1 %2 %p3% %p4% %p5% AA406I~1%p6%       AA406.INI%p7%
%1 %2 %p3% %p4% %p5% AAANS~1%p6%        AA.ANS%p7%
%1 %2 %p3% %p4% %p5% AAC~1%p6%          AA.C%p7%
%1 %2 %p3% %p4% %p5% AAEXE~1%p6%        AA.EXE%p7%
%1 %2 %p3% %p4% %p5% AAINI~1%p6%        AA.INI%p7%
%1 %2 %p3% %p4% %p5% AAMAK~1%p6%        AA.MAK%p7%
%1 %2 %p3% %p4% %p5% AAOPT~1%p6%        AA.OPT%p7%
%1 %2 %p3% %p4% %p5% AAPRJ~1%p6%        AA.PRJ%p7%
%1 %2 %p3% %p4% %p5% AAQUE~1%p6%        AA.QUE%p7%
%1 %2 %p3% %p4% %p5% AARSP~1%p6%        AA.RSP%p7%
%1 %2 %p3% %p4% %p5% ACONST~1%p6%       ACONST.C%p7%
%1 %2 %p3% %p4% %p5% ACONST~2%p6%       ACONST.H%p7%
%1 %2 %p3% %p4% %p5% ACTIVI~1%p6%       ACTIVITY.TXT%p7%
%1 %2 %p3% %p4% %p5% ADAMS4~1%p6%       ADAMS4.C%p7%
%1 %2 %p3% %p4% %p5% ALTAZ_~1%p6%       ALTAZ_.C%p7%
%1 %2 %p3% %p4% %p5% ALTAZC~1%p6%       ALTAZ.C%p7%
%1 %2 %p3% %p4% %p5% ALTMEN~1%p6%       ALTMENUS.C%p7%
%1 %2 %p3% %p4% %p5% ANDSTR~1%p6%       AND.STR%p7%
%1 %2 %p3% %p4% %p5% ANGLES~1%p6%       ANGLES.C%p7%
%1 %2 %p3% %p4% %p5% ANGLES~2%p6%       ANGLES_.C%p7%
%1 %2 %p3% %p4% %p5% ANNUAB~1%p6%       ANNUAB.C%p7%
%1 %2 %p3% %p4% %p5% ANNUAB~2%p6%       ANNUAB_.C%p7%
%1 %2 %p3% %p4% %p5% ANOMAL~1%p6%       ANOMALY.C%p7%
%1 %2 %p3% %p4% %p5% ANSITA~1%p6%       ANSI.TAB%p7%
%1 %2 %p3% %p4% %p5% APR199~1%p6%       APR1996.DAT%p7%
%1 %2 %p3% %p4% %p5% AQRSTR~1%p6%       AQR.STR%p7%
%1 %2 %p3% %p4% %p5% ARCDOT~1%p6%       ARCDOT.C%p7%
%1 %2 %p3% %p4% %p5% ARCTIC~1%p6%       ARCTIC.MNU%p7%
%1 %2 %p3% %p4% %p5% ASINLC~1%p6%       ASINL.C%p7%
%1 %2 %p3% %p4% %p5% ASTAVD~1%p6%       ASTAV.DAT%p7%
%1 %2 %p3% %p4% %p5% ASTERB~1%p6%       ASTERB.bin%p7%
%1 %2 %p3% %p4% %p5% ASTRO_~1%p6%       ASTRO_.DOC%p7%
%1 %2 %p3% %p4% %p5% ASTRO_~2%p6%       ASTRO_.EXE%p7%
%1 %2 %p3% %p4% %p5% ASTROD~1%p6%       ASTRO.DOC%p7%
%1 %2 %p3% %p4% %p5% ASTROE~1%p6%       ASTRO.EXE%p7%
%1 %2 %p3% %p4% %p5% ASTROH~1%p6%       ASTRO.H%p7%
%1 %2 %p3% %p4% %p5% ASTROM~1%p6%       ASTROMET.EXE%p7%
%1 %2 %p3% %p4% %p5% ASTROM~2%p6%       ASTROMET.PIF%p7%
%1 %2 %p3% %p4% %p5% ASTROM~3%p6%       ASTROMT1.ICO%p7%
%1 %2 %p3% %p4% %p5% ASTROM~4%p6%       ASTROMT2.ICO%p7%
%1 %2 %p3% %p4% %p5% ASTRON~1%p6%       ASTRONMY.DOC%p7%
%1 %2 %p3% %p4% %p5% ATANLC~1%p6%       ATANL.C%p7%
%1 %2 %p3% %p4% %p5% ATT_BG~1%p6%       ATT_.BGI%p7%
%1 %2 %p3% %p4% %p5% ATTBGI~1%p6%       ATT.BGI%p7%
%1 %2 %p3% %p4% %p5% AUG199~1%p6%       AUG1996.DAT%p7%
%1 %2 %p3% %p4% %p5% AURSTR~1%p6%       AUR.STR%p7%
%1 %2 %p3% %p4% %p5% B_STAR~1%p6%       B_STAR.DOC%p7%
%1 %2 %p3% %p4% %p5% B_STAR~2%p6%       B_STAR.EXE%p7%
%1 %2 %p3% %p4% %p5% BACKGR~1%p6%       BACKGRND.PBM%p7%
%1 %2 %p3% %p4% %p5% BGI16D~1%p6%       BGI16.DLL%p7%
%1 %2 %p3% %p4% %p5% BINARY~1%p6%       BINARY3.DOC%p7%
%1 %2 %p3% %p4% %p5% BINARY~2%p6%       BINARY3.EXE%p7%
%1 %2 %p3% %p4% %p5% BITIMA~1%p6%       BITIMAGE.BGI%p7%
%1 %2 %p3% %p4% %p5% BLANKP~1%p6%       BLANK.PBM%p7%
%1 %2 %p3% %p4% %p5% BLUEMO~1%p6%       BLUEMOON.TXT%p7%
%1 %2 %p3% %p4% %p5% BRIGHT~1%p6%       BRIGHT4.STR%p7%
%1 %2 %p3% %p4% %p5% BRIGHT~2%p6%       BRIGHT5.STR%p7%
%1 %2 %p3% %p4% %p5% BRNEBU~1%p6%       BRNEBULA.GRP%p7%
%1 %2 %p3% %p4% %p5% BRUNGS~1%p6%       BRUNGSC.EXE%p7%
%1 %2 %p3% %p4% %p5% BRUNGS~2%p6%       BRUNGSC.TXT%p7%
%1 %2 %p3% %p4% %p5% BSCAT~1%p6%        BS.CAT%p7%
%1 %2 %p3% %p4% %p5% BSINF~1%p6%        BS.INF%p7%
%1 %2 %p3% %p4% %p5% BYWATE~1%p6%       BYWATER.PBM%p7%
%1 %2 %p3% %p4% %p5% C95O1-~1%p6%       C95O1-1.ST6%p7%
%1 %2 %p3% %p4% %p5% C95O1-~2%p6%       C95O1-2.ST6%p7%
%1 %2 %p3% %p4% %p5% C95O1E~1%p6%       C95O1.ELM%p7%
%1 %2 %p3% %p4% %p5% CAL_MJ~1%p6%       CAL_MJD.C%p7%
%1 %2 %p3% %p4% %p5% CALLIS~1%p6%       CALLISTO.FD%p7%
%1 %2 %p3% %p4% %p5% CALLIS~2%p6%       CALLISTO.SFS%p7%
%1 %2 %p3% %p4% %p5% CALLIS~3%p6%       CALLISTO.SPD%p7%
%1 %2 %p3% %p4% %p5% CATALO~1%p6%       CATALOG.TXT%p7%
%1 %2 %p3% %p4% %p5% CGA_2B~1%p6%       CGA_2.BGI%p7%
%1 %2 %p3% %p4% %p5% CGA_3B~1%p6%       CGA_3.BGI%p7%
%1 %2 %p3% %p4% %p5% CGA_7B~1%p6%       CGA_7.BGI%p7%
%1 %2 %p3% %p4% %p5% CGA_BG~1%p6%       CGA_.BGI%p7%
%1 %2 %p3% %p4% %p5% CGABGI~1%p6%       CGA.BGI%p7%
%1 %2 %p3% %p4% %p5% CIRCUM~1%p6%       CIRCUM.C%p7%
%1 %2 %p3% %p4% %p5% CIRCUM~2%p6%       CIRCUM.H%p7%
%1 %2 %p3% %p4% %p5% CLOSEP~1%p6%       CLOSE.PBM%p7%
%1 %2 %p3% %p4% %p5% CLUSTE~1%p6%       CLUSTER.EXE%p7%
%1 %2 %p3% %p4% %p5% COLOR0~1%p6%       COLOR00.PAL%p7%
%1 %2 %p3% %p4% %p5% COLORT~1%p6%       COLOR.TBL%p7%
%1 %2 %p3% %p4% %p5% COMETC~1%p6%       COMET.C%p7%
%1 %2 %p3% %p4% %p5% COMETF~1%p6%       COMETFI_.%p7%
%1 %2 %p3% %p4% %p5% COMETF~2%p6%       COMETFIL.%p7%
%1 %2 %p3% %p4% %p5% COMPIL~1%p6%       COMPILER.C%p7%
%1 %2 %p3% %p4% %p5% COMPLE~1%p6%       COMPLEX.SFS%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG.AIP%p7%
%1 %2 %p3% %p4% %p5% CONJUN~1%p6%       CONJUNCT.C%p7%
%1 %2 %p3% %p4% %p5% CONSTE~1%p6%       CONSTEL.C%p7%
%1 %2 %p3% %p4% %p5% CONSTE~2%p6%       CONSTEL_.C%p7%
%1 %2 %p3% %p4% %p5% CONSTE~3%p6%       CONSTELL.DAT%p7%
%1 %2 %p3% %p4% %p5% CONSTH~1%p6%       CONST.H%p7%
%1 %2 %p3% %p4% %p5% COPYIN~1%p6%       COPYING.TXT%p7%
%1 %2 %p3% %p4% %p5% COSMOS~1%p6%       COSMOS.DOC%p7%
%1 %2 %p3% %p4% %p5% COSMOS~2%p6%       COSMOS16.EXE%p7%
%1 %2 %p3% %p4% %p5% CPGFXD~1%p6%       cpgfx.dat%p7%
%1 %2 %p3% %p4% %p5% CRLFTX~1%p6%       CRLF.TXT%p7%
%1 %2 %p3% %p4% %p5% CT-VOI~1%p6%       CT-VOICE.DRV%p7%
%1 %2 %p3% %p4% %p5% CWSDPM~1%p6%       CWSDPMI.EXE%p7%
%1 %2 %p3% %p4% %p5% CWSDPM~2%p6%       CWSDPMI_.EXE%p7%
%1 %2 %p3% %p4% %p5% CZLNG~1%p6%        CZ.LNG%p7%
%1 %2 %p3% %p4% %p5% DBFMAI~1%p6%       DBFMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DCOMAI~1%p6%       DCOMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DCVMAI~1%p6%       DCVMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DE102H~1%p6%       DE102.H%p7%
%1 %2 %p3% %p4% %p5% DE118I~1%p6%       DE118I.ANS%p7%
%1 %2 %p3% %p4% %p5% DE118I~2%p6%       DE118I.H%p7%
%1 %2 %p3% %p4% %p5% DE118I~3%p6%       DE118I.OUT%p7%
%1 %2 %p3% %p4% %p5% DE118I~4%p6%       DE118I.QUE%p7%
%1 %2 %p3% %p4% %p5% DE118I~5%p6%       DE118IA.ANS%p7%
%1 %2 %p3% %p4% %p5% DE118S~1%p6%       DE118SAV.DOC%p7%
%1 %2 %p3% %p4% %p5% DE200A~1%p6%       DE200.ANS%p7%
%1 %2 %p3% %p4% %p5% DE200C~1%p6%       DE200CD.H%p7%
%1 %2 %p3% %p4% %p5% DE200H~1%p6%       DE200.H%p7%
%1 %2 %p3% %p4% %p5% DE200Q~1%p6%       DE200.QUE%p7%
%1 %2 %p3% %p4% %p5% DE200T~1%p6%       DE200.TST%p7%
%1 %2 %p3% %p4% %p5% DE245H~1%p6%       DE245.H%p7%
%1 %2 %p3% %p4% %p5% DE400H~1%p6%       DE400.H%p7%
%1 %2 %p3% %p4% %p5% DE403H~1%p6%       DE403.H%p7%
%1 %2 %p3% %p4% %p5% DE404H~1%p6%       DE404.H%p7%
%1 %2 %p3% %p4% %p5% DE405H~1%p6%       DE405.H%p7%
%1 %2 %p3% %p4% %p5% DE406H~1%p6%       DE406.H%p7%
%1 %2 %p3% %p4% %p5% DEC199~1%p6%       DEC1996.DAT%p7%
%1 %2 %p3% %p4% %p5% DEEPSK~1%p6%       deepsky.exe%p7%
%1 %2 %p3% %p4% %p5% DEEPSK~2%p6%       DEEPSKY.TXT%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       DEFAULT.PBM%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~2%p6%       DEFAULT.SFS%p7%
%1 %2 %p3% %p4% %p5% DEFLAT~1%p6%       DEFLAT_.C%p7%
%1 %2 %p3% %p4% %p5% DEFLEC~1%p6%       DEFLEC.C%p7%
%1 %2 %p3% %p4% %p5% DEFLEC~2%p6%       DEFLEC_.C%p7%
%1 %2 %p3% %p4% %p5% DELTAT~1%p6%       DELTAT.C%p7%
%1 %2 %p3% %p4% %p5% DEMO0P~1%p6%       DEMO0.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO1P~1%p6%       DEMO1.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO2P~1%p6%       DEMO2.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO3P~1%p6%       DEMO3.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO4P~1%p6%       DEMO4.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO5P~1%p6%       DEMO5.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO6P~1%p6%       DEMO6.POS%p7%
%1 %2 %p3% %p4% %p5% DEMO7P~1%p6%       DEMO7.POS%p7%
%1 %2 %p3% %p4% %p5% DEMOCA~1%p6%       DEMO.CAT%p7%
%1 %2 %p3% %p4% %p5% DEMOPO~1%p6%       DEMO.POS%p7%
%1 %2 %p3% %p4% %p5% DEQMAI~1%p6%       DEQMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DERSET~1%p6%       DERSET1.EXE%p7%
%1 %2 %p3% %p4% %p5% DESCRI~1%p6%       DESCRIP.MMS%p7%
%1 %2 %p3% %p4% %p5% DESCRI~2%p6%       DESCRIP_.MMS%p7%
%1 %2 %p3% %p4% %p5% DESKJE~1%p6%       DESKJET.TAB%p7%
%1 %2 %p3% %p4% %p5% DESURE~1%p6%       DESUREG2.DEM%p7%
%1 %2 %p3% %p4% %p5% DEVELO~1%p6%       DEVELOPE.DOC%p7%
%1 %2 %p3% %p4% %p5% DIFF_D~1%p6%       DIFF_DRA.DOC%p7%
%1 %2 %p3% %p4% %p5% DIFF_D~2%p6%       DIFF_DRA.EXE%p7%
%1 %2 %p3% %p4% %p5% DIPDAT~1%p6%       DIP.DAT%p7%
%1 %2 %p3% %p4% %p5% DISTAN~1%p6%       DISTANT.SFS%p7%
%1 %2 %p3% %p4% %p5% DITMAI~1%p6%       DITMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DIURAB~1%p6%       DIURAB.C%p7%
%1 %2 %p3% %p4% %p5% DIURAB~2%p6%       DIURAB_.C%p7%
%1 %2 %p3% %p4% %p5% DIURPX~1%p6%       DIURPX.C%p7%
%1 %2 %p3% %p4% %p5% DIURPX~2%p6%       DIURPX_.C%p7%
%1 %2 %p3% %p4% %p5% DKNEBU~1%p6%       DKNEBULA.GRP%p7%
%1 %2 %p3% %p4% %p5% DMFMAI~1%p6%       DMFMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DMS_C~1%p6%        DMS_.C%p7%
%1 %2 %p3% %p4% %p5% DMSC~1%p6%         DMS.C%p7%
%1 %2 %p3% %p4% %p5% DOMOON~1%p6%       DOMOON.C%p7%
%1 %2 %p3% %p4% %p5% DOWNPB~1%p6%       DOWN.PBM%p7%
%1 %2 %p3% %p4% %p5% DPIMAI~1%p6%       DPIMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DPMI16~1%p6%       DPMI16B_.OVL%p7%
%1 %2 %p3% %p4% %p5% DPMI16~2%p6%       DPMI16BI.OVL%p7%
%1 %2 %p3% %p4% %p5% DSCMAI~1%p6%       DSCMAIN1.EXE%p7%
%1 %2 %p3% %p4% %p5% DSDAT~1%p6%        DS.DAT%p7%
%1 %2 %p3% %p4% %p5% DSPACE~1%p6%       DSPACE5A.EXE%p7%
%1 %2 %p3% %p4% %p5% DSPACE~2%p6%       DSPACE5B.EXE%p7%
%1 %2 %p3% %p4% %p5% EAR404~1%p6%       EAR404.C%p7%
%1 %2 %p3% %p4% %p5% EARTHB~1%p6%       EARTH.BMP%p7%
%1 %2 %p3% %p4% %p5% EARTHB~2%p6%       EARTHB.SPD%p7%
%1 %2 %p3% %p4% %p5% EARTHF~1%p6%       EARTH.FD%p7%
%1 %2 %p3% %p4% %p5% EARTHS~1%p6%       EARTH.SPD%p7%
%1 %2 %p3% %p4% %p5% ECONST~1%p6%       ECONST.C%p7%
%1 %2 %p3% %p4% %p5% EGAVG~10%p6%       EGAVGA_8.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~1%p6%       EGAVGA.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~2%p6%       EGAVGA.BGX%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~3%p6%       EGAVGA_.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~4%p6%       EGAVGA_2.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~5%p6%       EGAVGA_3.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~6%p6%       EGAVGA_4.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~7%p6%       EGAVGA_5.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~8%p6%       EGAVGA_6.BGI%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~9%p6%       EGAVGA_7.BGI%p7%
%1 %2 %p3% %p4% %p5% EHEADH~1%p6%       EHEAD.H%p7%
%1 %2 %p3% %p4% %p5% ELEMCO~1%p6%       ELEMCONV.EXE%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~1%p6%       ELEVATOR.PBM%p7%
%1 %2 %p3% %p4% %p5% EMAILT~1%p6%       EMAIL.TXT%p7%
%1 %2 %p3% %p4% %p5% ENGLNG~1%p6%       ENG.LNG%p7%
%1 %2 %p3% %p4% %p5% EPHEMC~1%p6%       EPHEM.CFG%p7%
%1 %2 %p3% %p4% %p5% EPHEMD~1%p6%       EPHEM.DB%p7%
%1 %2 %p3% %p4% %p5% EPHEME~1%p6%       EPHEM.EXE%p7%
%1 %2 %p3% %p4% %p5% EPSILN~1%p6%       EPSILN.C%p7%
%1 %2 %p3% %p4% %p5% EPSILN~2%p6%       EPSILN_.C%p7%
%1 %2 %p3% %p4% %p5% EPSILN~3%p6%       EPSILN_2.C%p7%
%1 %2 %p3% %p4% %p5% EQ_ECL~1%p6%       EQ_ECL.C%p7%
%1 %2 %p3% %p4% %p5% ETODEC~1%p6%       ETODEC.C%p7%
%1 %2 %p3% %p4% %p5% EXECPB~1%p6%       EXEC.PBM%p7%
%1 %2 %p3% %p4% %p5% EXPWTD~1%p6%       EXPWT.DOC%p7%
%1 %2 %p3% %p4% %p5% EXPWTE~1%p6%       EXPWT.EXE%p7%
%1 %2 %p3% %p4% %p5% FAILUR~1%p6%       FAILURE.VOC%p7%
%1 %2 %p3% %p4% %p5% FASTDA~1%p6%       FASTDAY.MNU%p7%
%1 %2 %p3% %p4% %p5% FAXTXT~1%p6%       FAX.TXT%p7%
%1 %2 %p3% %p4% %p5% FEB199~1%p6%       FEB1996.DAT%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_ID_.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_ID2.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_ID3.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_ID4.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_ID5.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILES_~1%p6%       FILES_.LST%p7%
%1 %2 %p3% %p4% %p5% FILES_~2%p6%       FILES_.TXT%p7%
%1 %2 %p3% %p4% %p5% FILESL~1%p6%       FILES.LST%p7%
%1 %2 %p3% %p4% %p5% FILEST~1%p6%       FILES.TXT%p7%
%1 %2 %p3% %p4% %p5% FILESY~1%p6%       FILESYS.PBM%p7%
%1 %2 %p3% %p4% %p5% FINDCE~1%p6%       FINDCENT.C%p7%
%1 %2 %p3% %p4% %p5% FINDOR~1%p6%       FINDORB.RTF%p7%
%1 %2 %p3% %p4% %p5% FINDOR~2%p6%       FINDORB2.EXE%p7%
%1 %2 %p3% %p4% %p5% FK4FK5~1%p6%       FK4FK5.C%p7%
%1 %2 %p3% %p4% %p5% FK4FK5~2%p6%       FK4FK5_.C%p7%
%1 %2 %p3% %p4% %p5% FLOGC~1%p6%        FLOG.C%p7%
%1 %2 %p3% %p4% %p5% FLOORL~1%p6%       FLOORL.387%p7%
%1 %2 %p3% %p4% %p5% FLOORL~2%p6%       FLOORL.C%p7%
%1 %2 %p3% %p4% %p5% FLOORL~3%p6%       FLOORL.SUN%p7%
%1 %2 %p3% %p4% %p5% FLOPPY~1%p6%       FLOPPY.PBM%p7%
%1 %2 %p3% %p4% %p5% FOLDER~1%p6%       FOLDER.PBM%p7%
%1 %2 %p3% %p4% %p5% FONTCH~1%p6%       FONT.CHR%p7%
%1 %2 %p3% %p4% %p5% FORMAT~1%p6%       FORMATS.C%p7%
%1 %2 %p3% %p4% %p5% G12_NU~1%p6%       G12_NU2.CLU%p7%
%1 %2 %p3% %p4% %p5% G12_NU~2%p6%       G12_NU2.VGA%p7%
%1 %2 %p3% %p4% %p5% GALAXY~1%p6%       GALAXY.GRP%p7%
%1 %2 %p3% %p4% %p5% GALILE~1%p6%       GALIL.EXE%p7%
%1 %2 %p3% %p4% %p5% GALILE~2%p6%       GALILEAN.DOC%p7%
%1 %2 %p3% %p4% %p5% GALSAT~1%p6%       GALSAT00.BAS%p7%
%1 %2 %p3% %p4% %p5% GALSAT~2%p6%       GALSAT53.CFG%p7%
%1 %2 %p3% %p4% %p5% GALSAT~3%p6%       GALSAT53.DAT%p7%
%1 %2 %p3% %p4% %p5% GALSAT~4%p6%       GALSAT53.DOC%p7%
%1 %2 %p3% %p4% %p5% GALSAT~5%p6%       GALSAT53.EXE%p7%
%1 %2 %p3% %p4% %p5% GARBAG~1%p6%       GARBAGE.PBM%p7%
%1 %2 %p3% %p4% %p5% GEMSTR~1%p6%       GEM.STR%p7%
%1 %2 %p3% %p4% %p5% GENREX~1%p6%       GENR.EXE%p7%
%1 %2 %p3% %p4% %p5% GFEMER~1%p6%       GFE.MER%p7%
%1 %2 %p3% %p4% %p5% GIOCTR~1%p6%       GIO.CTR%p7%
%1 %2 %p3% %p4% %p5% GIOERT~1%p6%       GIOERT.EPH%p7%
%1 %2 %p3% %p4% %p5% GIOPES~1%p6%       GIOPES.EPH%p7%
%1 %2 %p3% %p4% %p5% GIOPLN~1%p6%       GIOPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% GIOSPC~1%p6%       GIOSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% GL_ARG~1%p6%       gl_arg.c%p7%
%1 %2 %p3% %p4% %p5% GL_ARG~2%p6%       gl_arg.h%p7%
%1 %2 %p3% %p4% %p5% GL_GFX~1%p6%       gl_gfx.c%p7%
%1 %2 %p3% %p4% %p5% GL_GFX~2%p6%       gl_gfx.h%p7%
%1 %2 %p3% %p4% %p5% GL_INT~1%p6%       gl_inter.c%p7%
%1 %2 %p3% %p4% %p5% GL_INT~2%p6%       gl_inter.h%p7%
%1 %2 %p3% %p4% %p5% GLC~1%p6%          gl.c%p7%
%1 %2 %p3% %p4% %p5% GLH~1%p6%          gl.h%p7%
%1 %2 %p3% %p4% %p5% GLOBUL~1%p6%       globular.exe%p7%
%1 %2 %p3% %p4% %p5% GLOBUL~2%p6%       GLOBULAR.GRP%p7%
%1 %2 %p3% %p4% %p5% GOBAT~1%p6%        GO.BAT%p7%
%1 %2 %p3% %p4% %p5% GPLANC~1%p6%       GPLAN.C%p7%
%1 %2 %p3% %p4% %p5% GRAPHI~1%p6%       GRAPHIC5.GRP%p7%
%1 %2 %p3% %p4% %p5% GRAPHI~2%p6%       GRAPHIC6.GRP%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~1%p6%       GRAVITY.DOC%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~2%p6%       GRAVITY.EXE%p7%
%1 %2 %p3% %p4% %p5% GRAVIT~3%p6%       GRAVITY.HLP%p7%
%1 %2 %p3% %p4% %p5% GRAVKI~1%p6%       GRAVKIT.DOC%p7%
%1 %2 %p3% %p4% %p5% GRAVKI~2%p6%       GRAVKIT.ING%p7%
%1 %2 %p3% %p4% %p5% GTEXE~1%p6%        GT.EXE%p7%
%1 %2 %p3% %p4% %p5% HEATDO~1%p6%       HEAT.DOC%p7%
%1 %2 %p3% %p4% %p5% HEATDO~2%p6%       HEATDOS.EXE%p7%
%1 %2 %p3% %p4% %p5% HEATDO~3%p6%       HEATDOS.FOR%p7%
%1 %2 %p3% %p4% %p5% HEATF~1%p6%        HEAT.F%p7%
%1 %2 %p3% %p4% %p5% HELP_2~1%p6%       HELP_2.TXT%p7%
%1 %2 %p3% %p4% %p5% HELP_T~1%p6%       HELP_.TXT%p7%
%1 %2 %p3% %p4% %p5% HELPTX~1%p6%       HELP.TXT%p7%
%1 %2 %p3% %p4% %p5% HERC_2~1%p6%       HERC_2.BGI%p7%
%1 %2 %p3% %p4% %p5% HERC_3~1%p6%       HERC_3.BGI%p7%
%1 %2 %p3% %p4% %p5% HERC_7~1%p6%       HERC_7.BGI%p7%
%1 %2 %p3% %p4% %p5% HERC_B~1%p6%       HERC_.BGI%p7%
%1 %2 %p3% %p4% %p5% HERCBG~1%p6%       HERC.BGI%p7%
%1 %2 %p3% %p4% %p5% HGXMOU~1%p6%       HGXMOUSE.EXE%p7%
%1 %2 %p3% %p4% %p5% HGXMOU~2%p6%       HGXMOUSE.TXT%p7%
%1 %2 %p3% %p4% %p5% HLP190~1%p6%       HLP190.%p7%
%1 %2 %p3% %p4% %p5% HLPALG~1%p6%       HLPALGEB.%p7%
%1 %2 %p3% %p4% %p5% HLPALI~1%p6%       HLPALIGN.%p7%
%1 %2 %p3% %p4% %p5% HLPANG~1%p6%       HLPANGLE.%p7%
%1 %2 %p3% %p4% %p5% HLPAVE~1%p6%       HLPAVER.%p7%
%1 %2 %p3% %p4% %p5% HLPBLI~1%p6%       HLPBLINK.%p7%
%1 %2 %p3% %p4% %p5% HLPBLU~1%p6%       HLPBLUR.%p7%
%1 %2 %p3% %p4% %p5% HLPBMA~1%p6%       HLPBMASK.%p7%
%1 %2 %p3% %p4% %p5% HLPBOX~1%p6%       HLPBOX.%p7%
%1 %2 %p3% %p4% %p5% HLPBUF~1%p6%       HLPBUFFS.%p7%
%1 %2 %p3% %p4% %p5% HLPCAL~1%p6%       HLPCAL.%p7%
%1 %2 %p3% %p4% %p5% HLPCFG~1%p6%       HLPCFG.%p7%
%1 %2 %p3% %p4% %p5% HLPCOP~1%p6%       HLPCOPY.%p7%
%1 %2 %p3% %p4% %p5% HLPCRI~1%p6%       HLPCRIS.%p7%
%1 %2 %p3% %p4% %p5% HLPCRO~1%p6%       HLPCROP.%p7%
%1 %2 %p3% %p4% %p5% HLPDAR~1%p6%       HLPDARK.%p7%
%1 %2 %p3% %p4% %p5% HLPDEC~1%p6%       HLPDECON.%p7%
%1 %2 %p3% %p4% %p5% HLPDMA~1%p6%       HLPDMASK.%p7%
%1 %2 %p3% %p4% %p5% HLPENL~1%p6%       HLPENLA.%p7%
%1 %2 %p3% %p4% %p5% HLPEQU~1%p6%       HLPEQUAL.%p7%
%1 %2 %p3% %p4% %p5% HLPEXA~1%p6%       HLPEXAM.%p7%
%1 %2 %p3% %p4% %p5% HLPEXP~1%p6%       HLPEXP.%p7%
%1 %2 %p3% %p4% %p5% HLPFIL~1%p6%       HLPFILE.%p7%
%1 %2 %p3% %p4% %p5% HLPFIL~2%p6%       HLPFILTR.%p7%
%1 %2 %p3% %p4% %p5% HLPFIT~1%p6%       HLPFITSH.%p7%
%1 %2 %p3% %p4% %p5% HLPFLA~1%p6%       HLPFLAT.%p7%
%1 %2 %p3% %p4% %p5% HLPFLI~1%p6%       HLPFLIP.%p7%
%1 %2 %p3% %p4% %p5% HLPGIF~1%p6%       HLPGIF.%p7%
%1 %2 %p3% %p4% %p5% HLPGSC~1%p6%       HLPGSC.%p7%
%1 %2 %p3% %p4% %p5% HLPHEA~1%p6%       HLPHEAD.%p7%
%1 %2 %p3% %p4% %p5% HLPHIS~1%p6%       HLPHIST.%p7%
%1 %2 %p3% %p4% %p5% HLPHOT~1%p6%       HLPHOTK.%p7%
%1 %2 %p3% %p4% %p5% HLPINV~1%p6%       HLPINVE.%p7%
%1 %2 %p3% %p4% %p5% HLPLOA~1%p6%       HLPLOAD.%p7%
%1 %2 %p3% %p4% %p5% HLPLOG~1%p6%       HLPLOGAR.%p7%
%1 %2 %p3% %p4% %p5% HLPMAT~1%p6%       HLPMATH.%p7%
%1 %2 %p3% %p4% %p5% HLPMED~1%p6%       HLPMEDI.%p7%
%1 %2 %p3% %p4% %p5% HLPMER~1%p6%       HLPMERGE.%p7%
%1 %2 %p3% %p4% %p5% HLPPRE~1%p6%       HLPPREC.%p7%
%1 %2 %p3% %p4% %p5% HLPPRO~1%p6%       HLPPROFL.%p7%
%1 %2 %p3% %p4% %p5% HLPREC~1%p6%       HLPRECRD.%p7%
%1 %2 %p3% %p4% %p5% HLPRED~1%p6%       HLPREDU.%p7%
%1 %2 %p3% %p4% %p5% HLPRES~1%p6%       HLPRESAM.%p7%
%1 %2 %p3% %p4% %p5% HLPROT~1%p6%       HLPROTA.%p7%
%1 %2 %p3% %p4% %p5% HLPSAV~1%p6%       HLPSAVE.%p7%
%1 %2 %p3% %p4% %p5% HLPSAW~1%p6%       HLPSAW.%p7%
%1 %2 %p3% %p4% %p5% HLPSAW~2%p6%       HLPSAWTH.%p7%
%1 %2 %p3% %p4% %p5% HLPSCA~1%p6%       HLPSCALE.%p7%
%1 %2 %p3% %p4% %p5% HLPSHA~1%p6%       HLPSHAR.%p7%
%1 %2 %p3% %p4% %p5% HLPSQP~1%p6%       HLPSQPX.%p7%
%1 %2 %p3% %p4% %p5% HLPSTR~1%p6%       HLPSTRCH.%p7%
%1 %2 %p3% %p4% %p5% HLPSUM~1%p6%       HLPSUM.%p7%
%1 %2 %p3% %p4% %p5% HLPTAB~1%p6%       HLPTABLE.%p7%
%1 %2 %p3% %p4% %p5% HLPTHR~1%p6%       HLPTHRED.%p7%
%1 %2 %p3% %p4% %p5% HLPTRA~1%p6%       HLPTRANS.%p7%
%1 %2 %p3% %p4% %p5% HLPUSH~1%p6%       HLPUSHA.%p7%
%1 %2 %p3% %p4% %p5% HLPVBU~1%p6%       HLPVBUF.%p7%
%1 %2 %p3% %p4% %p5% HLPVID~1%p6%       HLPVIDEO.%p7%
%1 %2 %p3% %p4% %p5% HLPVIE~1%p6%       HLPVIEW.%p7%
%1 %2 %p3% %p4% %p5% HLPXMS~1%p6%       HLPXMS.%p7%
%1 %2 %p3% %p4% %p5% HO211_~1%p6%       HO211_WS.TXT%p7%
%1 %2 %p3% %p4% %p5% HO211A~1%p6%       HO211A.EXE%p7%
%1 %2 %p3% %p4% %p5% HO211C~1%p6%       HO211.C%p7%
%1 %2 %p3% %p4% %p5% HO211E~1%p6%       HO211.EXE%p7%
%1 %2 %p3% %p4% %p5% HREXE~1%p6%        HR.EXE%p7%
%1 %2 %p3% %p4% %p5% HUBBLE~1%p6%       HUBBLE.SFS%p7%
%1 %2 %p3% %p4% %p5% IEEEC~1%p6%        IEEE.C%p7%
%1 %2 %p3% %p4% %p5% IMAGES~1%p6%       IMAGES.TXT%p7%
%1 %2 %p3% %p4% %p5% INCLIN~1%p6%       INCLINED.SFS%p7%
%1 %2 %p3% %p4% %p5% INI118~1%p6%       INI118D.H%p7%
%1 %2 %p3% %p4% %p5% INSCEX~1%p6%       INSC.EXE%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.EXE%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTALLC.BAT%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTALLV.BAT%p7%
%1 %2 %p3% %p4% %p5% INSVEX~1%p6%       INSV.EXE%p7%
%1 %2 %p3% %p4% %p5% INTH~1%p6%         INT.H%p7%
%1 %2 %p3% %p4% %p5% IOC~1%p6%          IO.C%p7%
%1 %2 %p3% %p4% %p5% JAN199~1%p6%       JAN1996.DAT%p7%
%1 %2 %p3% %p4% %p5% JIMSDE~1%p6%       JIMSDEMO.EXE%p7%
%1 %2 %p3% %p4% %p5% JPLMPC~1%p6%       JPLMP.C%p7%
%1 %2 %p3% %p4% %p5% JPSTPH~1%p6%       JPSTPHN.DOC%p7%
%1 %2 %p3% %p4% %p5% JPSTPH~2%p6%       JPSTPHN.EXE%p7%
%1 %2 %p3% %p4% %p5% JUL199~1%p6%       JUL1996.DAT%p7%
%1 %2 %p3% %p4% %p5% JUN199~1%p6%       JUN1996.DAT%p7%
%1 %2 %p3% %p4% %p5% JUP404~1%p6%       JUP404.C%p7%
%1 %2 %p3% %p4% %p5% JUPITE~1%p6%       JUPITER.BMP%p7%
%1 %2 %p3% %p4% %p5% JUPITE~2%p6%       JUPITER.FD%p7%
%1 %2 %p3% %p4% %p5% JUPITE~3%p6%       JUPITER.GIF%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~1%p6%       JUPSAT.DTA%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~2%p6%       JUPSAT.EXE%p7%
%1 %2 %p3% %p4% %p5% JUPSAT~3%p6%       JUPSAT.TXT%p7%
%1 %2 %p3% %p4% %p5% KBIN~1%p6%         K.bin%p7%
%1 %2 %p3% %p4% %p5% KDATME~1%p6%       KDAT.MER%p7%
%1 %2 %p3% %p4% %p5% KEP_H~1%p6%        KEP_.H%p7%
%1 %2 %p3% %p4% %p5% KEPH~1%p6%         KEP.H%p7%
%1 %2 %p3% %p4% %p5% KEPIC~1%p6%        KEPI.C%p7%
%1 %2 %p3% %p4% %p5% KEPJC~1%p6%        KEPJ.C%p7%
%1 %2 %p3% %p4% %p5% KEPJPL~1%p6%       KEPJPL.C%p7%
%1 %2 %p3% %p4% %p5% KEPLER~1%p6%       KEPLER.C%p7%
%1 %2 %p3% %p4% %p5% KFILES~1%p6%       KFILES.C%p7%
%1 %2 %p3% %p4% %p5% KFILES~2%p6%       KFILES_.C%p7%
%1 %2 %p3% %p4% %p5% KOMETD~1%p6%       KOMET.DAT%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~1%p6%       KOMSOFT.DOC%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~2%p6%       KOMSOFT.EXE%p7%
%1 %2 %p3% %p4% %p5% KOMSOF~3%p6%       KOMSOFT.ICO%p7%
%1 %2 %p3% %p4% %p5% LATLON~1%p6%       LATLON.SPD%p7%
%1 %2 %p3% %p4% %p5% LEFTPB~1%p6%       LEFT.PBM%p7%
%1 %2 %p3% %p4% %p5% LEOSTR~1%p6%       LEO.STR%p7%
%1 %2 %p3% %p4% %p5% LIB403~1%p6%       LIB403.INI%p7%
%1 %2 %p3% %p4% %p5% LIBSTR~1%p6%       LIB.STR%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENSE.%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENSE.TXT%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       LICENSE_.TXT%p7%
%1 %2 %p3% %p4% %p5% LIGHTT~1%p6%       LIGHTT.C%p7%
%1 %2 %p3% %p4% %p5% LIGHTT~2%p6%       LIGHTT_.C%p7%
%1 %2 %p3% %p4% %p5% LISTIN~1%p6%       LISTING.C%p7%
%1 %2 %p3% %p4% %p5% LITECH~1%p6%       LITE.CHR%p7%
%1 %2 %p3% %p4% %p5% LITT_C~1%p6%       LITT_.CHR%p7%
%1 %2 %p3% %p4% %p5% LITTCH~1%p6%       LITT.CHR%p7%
%1 %2 %p3% %p4% %p5% LMDAT~1%p6%        LM.DAT%p7%
%1 %2 %p3% %p4% %p5% LONLAT~1%p6%       LONLAT.C%p7%
%1 %2 %p3% %p4% %p5% LONLAT~2%p6%       LONLAT_.C%p7%
%1 %2 %p3% %p4% %p5% LUNINT~1%p6%       LUNINTRP.DAT%p7%
%1 %2 %p3% %p4% %p5% LUNPAR~1%p6%       LUNPAR.DAT%p7%
%1 %2 %p3% %p4% %p5% M51ST7~1%p6%       M51.ST7%p7%
%1 %2 %p3% %p4% %p5% MAINC~1%p6%        MAIN.C%p7%
%1 %2 %p3% %p4% %p5% MAINME~1%p6%       MAINMENU.C%p7%
%1 %2 %p3% %p4% %p5% MAKEFI~1%p6%       MAKEFIL_.%p7%
%1 %2 %p3% %p4% %p5% MAKEFI~2%p6%       MAKEFILE.%p7%
%1 %2 %p3% %p4% %p5% MAKEPL~1%p6%       MAKEPLAN.DOC%p7%
%1 %2 %p3% %p4% %p5% MAKEPL~2%p6%       MAKEPLAN.EXE%p7%
%1 %2 %p3% %p4% %p5% MANIFE~1%p6%       MANIFEST.%p7%
%1 %2 %p3% %p4% %p5% MANIFE~2%p6%       MANIFEST.TXT%p7%
%1 %2 %p3% %p4% %p5% MANTXT~1%p6%       MAN.TXT%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       MANUAL.TXT%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       MANUAL_.TXT%p7%
%1 %2 %p3% %p4% %p5% MAR199~1%p6%       MAR1996.DAT%p7%
%1 %2 %p3% %p4% %p5% MAR404~1%p6%       MAR404.C%p7%
%1 %2 %p3% %p4% %p5% MARSBM~1%p6%       MARS.BMP%p7%
%1 %2 %p3% %p4% %p5% MARSFD~1%p6%       MARS.FD%p7%
%1 %2 %p3% %p4% %p5% MARSGI~1%p6%       MARS.GIF%p7%
%1 %2 %p3% %p4% %p5% MARSSF~1%p6%       MARS.SFS%p7%
%1 %2 %p3% %p4% %p5% MARSSP~1%p6%       MARS.SPD%p7%
%1 %2 %p3% %p4% %p5% MAY199~1%p6%       MAY1996.DAT%p7%
%1 %2 %p3% %p4% %p5% MBIN~1%p6%         M.bin%p7%
%1 %2 %p3% %p4% %p5% MCOLOR~1%p6%       MCOLORI.STD%p7%
%1 %2 %p3% %p4% %p5% MCONF_~1%p6%       MCONF_.H%p7%
%1 %2 %p3% %p4% %p5% MCONFH~1%p6%       MCONF.H%p7%
%1 %2 %p3% %p4% %p5% MER404~1%p6%       MER404.C%p7%
%1 %2 %p3% %p4% %p5% MERCUR~1%p6%       MERCURY.BMP%p7%
%1 %2 %p3% %p4% %p5% MERCUR~2%p6%       MERCURY.FD%p7%
%1 %2 %p3% %p4% %p5% MERCUR~3%p6%       MERCURY.GIF%p7%
%1 %2 %p3% %p4% %p5% MERIDI~1%p6%       MERIDIAN.SPD%p7%
%1 %2 %p3% %p4% %p5% MESSIE~1%p6%       MESSIER.CAT%p7%
%1 %2 %p3% %p4% %p5% MESSIE~2%p6%       MESSIER.STR%p7%
%1 %2 %p3% %p4% %p5% MESSIE~3%p6%       MESSIER_.CAT%p7%
%1 %2 %p3% %p4% %p5% MILKDA~1%p6%       MILK.DAT%p7%
%1 %2 %p3% %p4% %p5% MIRAIN~1%p6%       MIRA.INI%p7%
%1 %2 %p3% %p4% %p5% MIRAPL~1%p6%       mirapla.exe%p7%
%1 %2 %p3% %p4% %p5% MISTAK~1%p6%       MISTAKES.TXT%p7%
%1 %2 %p3% %p4% %p5% MLAT40~1%p6%       MLAT404.C%p7%
%1 %2 %p3% %p4% %p5% MLR404~1%p6%       MLR404.C%p7%
%1 %2 %p3% %p4% %p5% MOON2E~1%p6%       MOON2.EXE%p7%
%1 %2 %p3% %p4% %p5% MOON7F~1%p6%       MOON7FL.FTS%p7%
%1 %2 %p3% %p4% %p5% MOONBG~1%p6%       MOONBG.BMP%p7%
%1 %2 %p3% %p4% %p5% MOONBM~1%p6%       MOON.BMP%p7%
%1 %2 %p3% %p4% %p5% MOONC~1%p6%        MOON.C%p7%
%1 %2 %p3% %p4% %p5% MOONDA~1%p6%       MOONDATA.DAT%p7%
%1 %2 %p3% %p4% %p5% MOONDO~1%p6%       MOON.DOC%p7%
%1 %2 %p3% %p4% %p5% MOONDR~1%p6%       MOON.DRW%p7%
%1 %2 %p3% %p4% %p5% MOONEX~1%p6%       MOON.EXE%p7%
%1 %2 %p3% %p4% %p5% MOONFD~1%p6%       MOON.FD%p7%
%1 %2 %p3% %p4% %p5% MOONGI~1%p6%       MOON.GIF%p7%
%1 %2 %p3% %p4% %p5% MOONJP~1%p6%       MOONJPL.C%p7%
%1 %2 %p3% %p4% %p5% MOONNF~1%p6%       MOONNF.C%p7%
%1 %2 %p3% %p4% %p5% MOONSF~1%p6%       MOON.SFS%p7%
%1 %2 %p3% %p4% %p5% MOONTX~1%p6%       MOON.TXT%p7%
%1 %2 %p3% %p4% %p5% MOVEPB~1%p6%       MOVE.PBM%p7%
%1 %2 %p3% %p4% %p5% MOVIE~10%p6%       MOVIE.010%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~1%p6%       MOVIE.001%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~2%p6%       MOVIE.002%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~3%p6%       MOVIE.003%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~4%p6%       MOVIE.004%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~5%p6%       MOVIE.005%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~6%p6%       MOVIE.006%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~7%p6%       MOVIE.007%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~8%p6%       MOVIE.008%p7%
%1 %2 %p3% %p4% %p5% MOVIE0~9%p6%       MOVIE.009%p7%
%1 %2 %p3% %p4% %p5% MOVIEE~1%p6%       MOVIE.EXE%p7%
%1 %2 %p3% %p4% %p5% MSCMAK~1%p6%       MSC.MAK%p7%
%1 %2 %p3% %p4% %p5% MSCNMA~1%p6%       MSCN.MAK%p7%
%1 %2 %p3% %p4% %p5% MSHERC~1%p6%       MSHERC.COM%p7%
%1 %2 %p3% %p4% %p5% MTHERR~1%p6%       MTHERR.C%p7%
%1 %2 %p3% %p4% %p5% NASASP~1%p6%       NASA.SPD%p7%
%1 %2 %p3% %p4% %p5% NBODYD~1%p6%       NBODYD16.EXE%p7%
%1 %2 %p3% %p4% %p5% NBODYD~2%p6%       NBODYD16.TXT%p7%
%1 %2 %p3% %p4% %p5% NEP404~1%p6%       NEP404.C%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~1%p6%       NEPTUNE.BMP%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~2%p6%       NEPTUNE.FD%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~3%p6%       NEPTUNE.GIF%p7%
%1 %2 %p3% %p4% %p5% NEWSFS~1%p6%       NEW.SFS%p7%
%1 %2 %p3% %p4% %p5% NEWTXT~1%p6%       NEW.TXT%p7%
%1 %2 %p3% %p4% %p5% NIL_~1%p6%         nil_~1%p7%
%1 %2 %p3% %p4% %p5% NIL~1%p6%          NIL.%p7%
%1 %2 %p3% %p4% %p5% NOMDAT~1%p6%       NOM.DAT%p7%
%1 %2 %p3% %p4% %p5% NOV199~1%p6%       NOV1996.DAT%p7%
%1 %2 %p3% %p4% %p5% NULLSP~1%p6%       NULL.SPD%p7%
%1 %2 %p3% %p4% %p5% NULLTA~1%p6%       NULL.TAB%p7%
%1 %2 %p3% %p4% %p5% NUT1TC~1%p6%       NUT1T.C%p7%
%1 %2 %p3% %p4% %p5% NUTATE~1%p6%       NUTATE.C%p7%
%1 %2 %p3% %p4% %p5% NUTATE~2%p6%       NUTATE_.C%p7%
%1 %2 %p3% %p4% %p5% NUTATI~1%p6%       NUTATION.C%p7%
%1 %2 %p3% %p4% %p5% NX10TA~1%p6%       NX10.TAB%p7%
%1 %2 %p3% %p4% %p5% OBJECT~1%p6%       OBJECTS.DAT%p7%
%1 %2 %p3% %p4% %p5% OBJXC~1%p6%        OBJX.C%p7%
%1 %2 %p3% %p4% %p5% OBLATE~1%p6%       OBLATE.C%p7%
%1 %2 %p3% %p4% %p5% OBLIQC~1%p6%       OBLIQ.C%p7%
%1 %2 %p3% %p4% %p5% OCHDOC~1%p6%       OCH.DOC%p7%
%1 %2 %p3% %p4% %p5% OCHEXE~1%p6%       OCH.EXE%p7%
%1 %2 %p3% %p4% %p5% OCHOBJ~1%p6%       OCH.OBJ%p7%
%1 %2 %p3% %p4% %p5% OCHPNT~1%p6%       OCH.PNT%p7%
%1 %2 %p3% %p4% %p5% OCHTXT~1%p6%       OCH.TXT%p7%
%1 %2 %p3% %p4% %p5% OCT199~1%p6%       OCT1996.DAT%p7%
%1 %2 %p3% %p4% %p5% OPARAM~1%p6%       OPARAMS.C%p7%
%1 %2 %p3% %p4% %p5% OPENCL~1%p6%       OPENCLUS.GRP%p7%
%1 %2 %p3% %p4% %p5% ORBIT_~1%p6%       ORBIT_.CAT%p7%
%1 %2 %p3% %p4% %p5% ORBITC~1%p6%       ORBIT.CAT%p7%
%1 %2 %p3% %p4% %p5% ORBSPD~1%p6%       ORB.SPD%p7%
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       ORDER_.FRM%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       ORDER.DOC%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDER.FRM%p7%
%1 %2 %p3% %p4% %p5% ORDERT~1%p6%       ORDER.TXT%p7%
%1 %2 %p3% %p4% %p5% ORIDAT~1%p6%       ORI.DAT%p7%
%1 %2 %p3% %p4% %p5% OVERSE~1%p6%       OVERSEAS.TXT%p7%
%1 %2 %p3% %p4% %p5% PANBIN~1%p6%       PAN.bin%p7%
%1 %2 %p3% %p4% %p5% PARALL~1%p6%       PARALLAX.C%p7%
%1 %2 %p3% %p4% %p5% PBIN~1%p6%         P.bin%p7%
%1 %2 %p3% %p4% %p5% PC3270~1%p6%       PC3270.BGI%p7%
%1 %2 %p3% %p4% %p5% PC3270~2%p6%       PC3270_7.BGI%p7%
%1 %2 %p3% %p4% %p5% PCTOMO~1%p6%       PCTOMOT.C%p7%
%1 %2 %p3% %p4% %p5% PELEME~1%p6%       PELEMENT.C%p7%
%1 %2 %p3% %p4% %p5% PL406B~1%p6%       PL406B.bin%p7%
%1 %2 %p3% %p4% %p5% PL406B~2%p6%       PL406B.DAT%p7%
%1 %2 %p3% %p4% %p5% PLAN19~1%p6%       PLAN1994.STR%p7%
%1 %2 %p3% %p4% %p5% PLANET~1%p6%       PLANET.1A%p7%
%1 %2 %p3% %p4% %p5% PLANET~2%p6%       PLANET.EXE%p7%
%1 %2 %p3% %p4% %p5% PLANET~3%p6%       PLANET.MAN%p7%
%1 %2 %p3% %p4% %p5% PLANET~4%p6%       PLANETAR.GRP%p7%
%1 %2 %p3% %p4% %p5% PLANET~5%p6%       PLANETS.DAT%p7%
%1 %2 %p3% %p4% %p5% PLANET~6%p6%       PLANETS.NDX%p7%
%1 %2 %p3% %p4% %p5% PLANET~7%p6%       PLANETS_.DAT%p7%
%1 %2 %p3% %p4% %p5% PLANET~8%p6%       PLANETS_.NDX%p7%
%1 %2 %p3% %p4% %p5% PLANSB~1%p6%       PLANS.bin%p7%
%1 %2 %p3% %p4% %p5% PLANSB~2%p6%       PLANSB.DAT%p7%
%1 %2 %p3% %p4% %p5% PLANSC~1%p6%       PLANS.C%p7%
%1 %2 %p3% %p4% %p5% PLANTB~1%p6%       PLANTBL.H%p7%
%1 %2 %p3% %p4% %p5% PLNWCH~1%p6%       PLNWCH.EXE%p7%
%1 %2 %p3% %p4% %p5% PLNWCH~2%p6%       PLNWCH.HLP%p7%
%1 %2 %p3% %p4% %p5% PLOTAP~1%p6%       PLOTA.PS%p7%
%1 %2 %p3% %p4% %p5% PLOTBP~1%p6%       PLOTB.PS%p7%
%1 %2 %p3% %p4% %p5% PLOTC~1%p6%        PLOT.C%p7%
%1 %2 %p3% %p4% %p5% PLTRAC~1%p6%       PLTRACK.EXE%p7%
%1 %2 %p3% %p4% %p5% PLU404~1%p6%       PLU404.C%p7%
%1 %2 %p3% %p4% %p5% PLUTOB~1%p6%       PLUTO.BMP%p7%
%1 %2 %p3% %p4% %p5% PLUTOF~1%p6%       PLUTO.FD%p7%
%1 %2 %p3% %p4% %p5% PLUTOG~1%p6%       PLUTO.GIF%p7%
%1 %2 %p3% %p4% %p5% POLARI~1%p6%       POLARIS.MNU%p7%
%1 %2 %p3% %p4% %p5% POLEVL~1%p6%       POLEVLL.C%p7%
%1 %2 %p3% %p4% %p5% POPUPC~1%p6%       POPUP.C%p7%
%1 %2 %p3% %p4% %p5% POSTAL~1%p6%       POSTAL.TXT%p7%
%1 %2 %p3% %p4% %p5% PRECES~1%p6%       PRECESS.C%p7%
%1 %2 %p3% %p4% %p5% PRECES~2%p6%       PRECESS_.C%p7%
%1 %2 %p3% %p4% %p5% PRECES~3%p6%       PRECESS2.C%p7%
%1 %2 %p3% %p4% %p5% PRECES~4%p6%       PRECESS3.C%p7%
%1 %2 %p3% %p4% %p5% PRECH~1%p6%        PREC.H%p7%
%1 %2 %p3% %p4% %p5% PROTOS~1%p6%       PROTOS.H%p7%
%1 %2 %p3% %p4% %p5% PROTOS~2%p6%       PROTOS_.H%p7%
%1 %2 %p3% %p4% %p5% PTLINE~1%p6%       PTLINES.TXT%p7%
%1 %2 %p3% %p4% %p5% PTSTAR~1%p6%       PTSTARS.TXT%p7%
%1 %2 %p3% %p4% %p5% PURCHA~1%p6%       PURCHASE.TXT%p7%
%1 %2 %p3% %p4% %p5% QUESTI~1%p6%       QUESTION.VOC%p7%
%1 %2 %p3% %p4% %p5% QUICKS~1%p6%       QUICK.SFS%p7%
%1 %2 %p3% %p4% %p5% RDNUMS~1%p6%       RDNUMS.C%p7%
%1 %2 %p3% %p4% %p5% READ_2~1%p6%       READ_2.ME%p7%
%1 %2 %p3% %p4% %p5% READ_M~1%p6%       READ_.ME%p7%
%1 %2 %p3% %p4% %p5% READ_M~2%p6%       READ_ME.1ST%p7%
%1 %2 %p3% %p4% %p5% READ_M~3%p6%       READ_ME.BAT%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       README.PC%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       README.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       README.WRI%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       README_.%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       README_2.%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       README_2.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       README_3.%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       README_3.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       README_4.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~20%p6%       README_5.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~21%p6%       README_6.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~22%p6%       README_7.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~23%p6%       README_8.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~24%p6%       README_9.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~25%p6%       README_A.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~26%p6%       README_B.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~27%p6%       README_C.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~28%p6%       README42.txt%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       READ.ME%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       READ.ME2%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README.%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README.1ST%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README.404%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README.AA%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README.BAT%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README.DOC%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README.EXE%p7%
%1 %2 %p3% %p4% %p5% READTX~1%p6%       READ.TXT%p7%
%1 %2 %p3% %p4% %p5% REDTBL~1%p6%       RED.TBL%p7%
%1 %2 %p3% %p4% %p5% REDUCE~1%p6%       REDUCE.C%p7%
%1 %2 %p3% %p4% %p5% REFRAC~1%p6%       REFRAC.C%p7%
%1 %2 %p3% %p4% %p5% REFRAC~2%p6%       REFRAC_.C%p7%
%1 %2 %p3% %p4% %p5% REFRAC~3%p6%       REFRACT.C%p7%
%1 %2 %p3% %p4% %p5% REFRAC~4%p6%       REFRACT.DAT%p7%
%1 %2 %p3% %p4% %p5% REGION~1%p6%       REGIONS.DAT%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGISTE_.TXT%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGISTE2.TXT%p7%
%1 %2 %p3% %p4% %p5% REGIST~3%p6%       REGISTER.DOC%p7%
%1 %2 %p3% %p4% %p5% REGIST~4%p6%       REGISTER.EXE%p7%
%1 %2 %p3% %p4% %p5% REGIST~5%p6%       REGISTER.FRM%p7%
%1 %2 %p3% %p4% %p5% REGIST~6%p6%       REGISTER.HLP%p7%
%1 %2 %p3% %p4% %p5% REGIST~7%p6%       REGISTER.TXT%p7%
%1 %2 %p3% %p4% %p5% RELTIV~1%p6%       RELTIV.C%p7%
%1 %2 %p3% %p4% %p5% RESIZE~1%p6%       RESIZE.PBM%p7%
%1 %2 %p3% %p4% %p5% RETROG~1%p6%       RETROGRA.MNU%p7%
%1 %2 %p3% %p4% %p5% REVTIM~1%p6%       REVTIME.C%p7%
%1 %2 %p3% %p4% %p5% RIGHTP~1%p6%       RIGHT.PBM%p7%
%1 %2 %p3% %p4% %p5% RINGTI~1%p6%       RINGTILT.GIF%p7%
%1 %2 %p3% %p4% %p5% RISET_~1%p6%       RISET_C.C%p7%
%1 %2 %p3% %p4% %p5% RISETC~1%p6%       RISET.C%p7%
%1 %2 %p3% %p4% %p5% RNGCCA~1%p6%       RNGC.CAT%p7%
%1 %2 %p3% %p4% %p5% RNGCIN~1%p6%       RNGC.INF%p7%
%1 %2 %p3% %p4% %p5% ROEXE~1%p6%        RO.EXE%p7%
%1 %2 %p3% %p4% %p5% ROTATE~1%p6%       ROTATE.C%p7%
%1 %2 %p3% %p4% %p5% RPLANE~1%p6%       RPLANET.C%p7%
%1 %2 %p3% %p4% %p5% RPLANE~2%p6%       RPLANET_.C%p7%
%1 %2 %p3% %p4% %p5% RSTAR_~1%p6%       RSTAR_.C%p7%
%1 %2 %p3% %p4% %p5% RSTARC~1%p6%       RSTAR.C%p7%
%1 %2 %p3% %p4% %p5% RTM_EX~1%p6%       RTM_.EXE%p7%
%1 %2 %p3% %p4% %p5% RTMEXE~1%p6%       RTM.EXE%p7%
%1 %2 %p3% %p4% %p5% RUNGEC~1%p6%       RUNGE.C%p7%
%1 %2 %p3% %p4% %p5% SAODAT~1%p6%       SAO.DAT%p7%
%1 %2 %p3% %p4% %p5% SAOIND~1%p6%       SAOINDEX.RND%p7%
%1 %2 %p3% %p4% %p5% SAONOR~1%p6%       SAONORTH.DAT%p7%
%1 %2 %p3% %p4% %p5% SAONOR~2%p6%       SAONORTH.IDX%p7%
%1 %2 %p3% %p4% %p5% SAOSOU~1%p6%       SAOSOUTH.DAT%p7%
%1 %2 %p3% %p4% %p5% SAOSOU~2%p6%       SAOSOUTH.IDX%p7%
%1 %2 %p3% %p4% %p5% SAT404~1%p6%       SAT404.C%p7%
%1 %2 %p3% %p4% %p5% SATSAT~1%p6%       SATSAT2.BAS%p7%
%1 %2 %p3% %p4% %p5% SATSAT~2%p6%       SATSAT2.CFG%p7%
%1 %2 %p3% %p4% %p5% SATSAT~3%p6%       SATSAT2.DOC%p7%
%1 %2 %p3% %p4% %p5% SATSAT~4%p6%       SATSAT2.EXE%p7%
%1 %2 %p3% %p4% %p5% SATURN~1%p6%       SATURN.BMP%p7%
%1 %2 %p3% %p4% %p5% SATURN~2%p6%       SATURN.FD%p7%
%1 %2 %p3% %p4% %p5% SATURN~3%p6%       SATURN.GIF%p7%
%1 %2 %p3% %p4% %p5% SATVIE~1%p6%       SATVIEW.DOC%p7%
%1 %2 %p3% %p4% %p5% SATVIE~2%p6%       SATVIEW.EXE%p7%
%1 %2 %p3% %p4% %p5% SCLOCK~1%p6%       SCLOCK10.DOC%p7%
%1 %2 %p3% %p4% %p5% SCLOCK~2%p6%       SCLOCK10.EXE%p7%
%1 %2 %p3% %p4% %p5% SCOPES~1%p6%       SCOPES.GRH%p7%
%1 %2 %p3% %p4% %p5% SCOPES~2%p6%       SCOPES.SAV%p7%
%1 %2 %p3% %p4% %p5% SCREEN~1%p6%       SCREEN.H%p7%
%1 %2 %p3% %p4% %p5% SEL_FL~1%p6%       SEL_FLD.C%p7%
%1 %2 %p3% %p4% %p5% SEP199~1%p6%       SEP1996.DAT%p7%
%1 %2 %p3% %p4% %p5% SERCON~1%p6%       SERCONO.HIN%p7%
%1 %2 %p3% %p4% %p5% SEREQT~1%p6%       SEREQT.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDB~1%p6%       SERIDBIF.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDC~1%p6%       SERIDCOL.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDC~2%p6%       SERIDCOR.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDI~1%p6%       SERIDIT.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDM~1%p6%       SERIDMON.HIN%p7%
%1 %2 %p3% %p4% %p5% SERIDP~1%p6%       SERIDPI.HIN%p7%
%1 %2 %p3% %p4% %p5% SET3C~1%p6%        SET3.C%p7%
%1 %2 %p3% %p4% %p5% SETPRE~1%p6%       SETPREC.387%p7%
%1 %2 %p3% %p4% %p5% SETPRE~2%p6%       SETPREC.688%p7%
%1 %2 %p3% %p4% %p5% SETPRE~3%p6%       SETPREC.87%p7%
%1 %2 %p3% %p4% %p5% SETUPM~1%p6%       SETUP.MER%p7%
%1 %2 %p3% %p4% %p5% SEX_DE~1%p6%       SEX_DEC.C%p7%
%1 %2 %p3% %p4% %p5% SFSEXE~1%p6%       SFS.EXE%p7%
%1 %2 %p3% %p4% %p5% SFSMAP~1%p6%       SFSM.APP%p7%
%1 %2 %p3% %p4% %p5% SFSRO~1%p6%        SFS.RO%p7%
%1 %2 %p3% %p4% %p5% SFSXAP~1%p6%       SFSX.APP%p7%
%1 %2 %p3% %p4% %p5% SGRSTR~1%p6%       SGR.STR%p7%
%1 %2 %p3% %p4% %p5% SHOWCO~1%p6%       SHOWCON.DAT%p7%
%1 %2 %p3% %p4% %p5% SHUTTL~1%p6%       SHUTTLE.SFS%p7%
%1 %2 %p3% %p4% %p5% SIDRLT~1%p6%       SIDRLT.C%p7%
%1 %2 %p3% %p4% %p5% SIDRLT~2%p6%       SIDRLT_.C%p7%
%1 %2 %p3% %p4% %p5% SIMON-~1%p6%       SIMON-CZ.DOC%p7%
%1 %2 %p3% %p4% %p5% SIMOND~1%p6%       SIMON.DOC%p7%
%1 %2 %p3% %p4% %p5% SIMONE~1%p6%       SIMON.EXE%p7%
%1 %2 %p3% %p4% %p5% SINLC~1%p6%        SINL.C%p7%
%1 %2 %p3% %p4% %p5% SKLNG~1%p6%        SK.LNG%p7%
%1 %2 %p3% %p4% %p5% SKY3DE~1%p6%       SKY3D.EXE%p7%
%1 %2 %p3% %p4% %p5% SKY3DI~1%p6%       SKY3D.ICO%p7%
%1 %2 %p3% %p4% %p5% SKY3DV~1%p6%       SKY3D.VFS%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~1%p6%       SKYGLOBE.DAT%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~2%p6%       SKYGLOBE.EXE%p7%
%1 %2 %p3% %p4% %p5% SKYGLO~3%p6%       SKYGLOBE.TXT%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~1%p6%       SKYPLOT.DAT%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~2%p6%       SKYPLOT.DOC%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~3%p6%       SKYPLOT.EXE%p7%
%1 %2 %p3% %p4% %p5% SKYPLO~4%p6%       SKYPLOTE.EXE%p7%
%1 %2 %p3% %p4% %p5% SMALLG~1%p6%       SMALLGR.SPD%p7%
%1 %2 %p3% %p4% %p5% SOLARD~1%p6%       SOLAR.DOC%p7%
%1 %2 %p3% %p4% %p5% SOLARE~1%p6%       SOLAR.EXE%p7%
%1 %2 %p3% %p4% %p5% SOLEX3~1%p6%       SOLEX3.RTF%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~1%p6%       SOLEX5.BAS%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~2%p6%       SOLEX5.EXE%p7%
%1 %2 %p3% %p4% %p5% SOLEX5~3%p6%       SOLEX5.RTF%p7%
%1 %2 %p3% %p4% %p5% SPEEDU~1%p6%       SPEEDUP.EXE%p7%
%1 %2 %p3% %p4% %p5% SQRTL3~1%p6%       SQRTL.387%p7%
%1 %2 %p3% %p4% %p5% SQRTLC~1%p6%       SQRTL.C%p7%
%1 %2 %p3% %p4% %p5% SQRTLS~1%p6%       SQRTL.SUN%p7%
%1 %2 %p3% %p4% %p5% SRCHC~1%p6%        SRCH.C%p7%
%1 %2 %p3% %p4% %p5% SS2TXT~1%p6%       SS2TXT.BAS%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~1%p6%       SSYSTEM.C%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~2%p6%       SSYSTEM.DOC%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~3%p6%       SSYSTEM.EXE%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~4%p6%       SSYSTEM.H%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~5%p6%       SSYSTEM.OPT%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~6%p6%       SSYSTEMD.MAK%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~7%p6%       SSYSTEMD.RSP%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~8%p6%       SSYSTEML.MAK%p7%
%1 %2 %p3% %p4% %p5% SSYSTE~9%p6%       SSYSTEML.RSP%p7%
%1 %2 %p3% %p4% %p5% STAR_C~1%p6%       STAR_.CAT%p7%
%1 %2 %p3% %p4% %p5% STAR19~1%p6%       STAR1950.CAT%p7%
%1 %2 %p3% %p4% %p5% STARCA~1%p6%       STAR.CAT%p7%
%1 %2 %p3% %p4% %p5% STARDA~1%p6%       STARDATA.DBF%p7%
%1 %2 %p3% %p4% %p5% STARDE~1%p6%       STARDEMO.EXE%p7%
%1 %2 %p3% %p4% %p5% STARFI~1%p6%       STARFIL_.%p7%
%1 %2 %p3% %p4% %p5% STARFI~2%p6%       STARFILE.%p7%
%1 %2 %p3% %p4% %p5% STARPL~1%p6%       STARPLOT.CFG%p7%
%1 %2 %p3% %p4% %p5% STARPL~2%p6%       STARPLOT.DOC%p7%
%1 %2 %p3% %p4% %p5% STARPL~3%p6%       STARPLOT.EXE%p7%
%1 %2 %p3% %p4% %p5% STARS2~1%p6%       STARS.250%p7%
%1 %2 %p3% %p4% %p5% STARS3~1%p6%       STARS.350%p7%
%1 %2 %p3% %p4% %p5% STARS4~1%p6%       STARS.400%p7%
%1 %2 %p3% %p4% %p5% STARS4~2%p6%       STARS.450%p7%
%1 %2 %p3% %p4% %p5% STARS5~1%p6%       STARS.500%p7%
%1 %2 %p3% %p4% %p5% STARSD~1%p6%       STARS.DAT%p7%
%1 %2 %p3% %p4% %p5% START_~1%p6%       START_.TXT%p7%
%1 %2 %p3% %p4% %p5% STARTI~1%p6%       STARTING.DAT%p7%
%1 %2 %p3% %p4% %p5% STARTT~1%p6%       START.TXT%p7%
%1 %2 %p3% %p4% %p5% STARVI~1%p6%       STARVIEW.bin%p7%
%1 %2 %p3% %p4% %p5% STARVI~2%p6%       STARVIEW.DOC%p7%
%1 %2 %p3% %p4% %p5% STARVI~3%p6%       STARVIEW.ELE%p7%
%1 %2 %p3% %p4% %p5% STARVI~4%p6%       STARVIEW.EXE%p7%
%1 %2 %p3% %p4% %p5% STARVI~5%p6%       STARVIEW.IDS%p7%
%1 %2 %p3% %p4% %p5% STARVI~6%p6%       STARVIEW.MAX%p7%
%1 %2 %p3% %p4% %p5% STARVI~7%p6%       STARVIEW.NAM%p7%
%1 %2 %p3% %p4% %p5% STARVI~8%p6%       STARVIEW.SIN%p7%
%1 %2 %p3% %p4% %p5% STARWO~1%p6%       STARWORK.DOC%p7%
%1 %2 %p3% %p4% %p5% STARWO~2%p6%       STARWORK.VOC%p7%
%1 %2 %p3% %p4% %p5% STAVDA~1%p6%       STAV.DAT%p7%
%1 %2 %p3% %p4% %p5% STELLD~1%p6%       STELL.DAT%p7%
%1 %2 %p3% %p4% %p5% STIMEC~1%p6%       STIME.CFG%p7%
%1 %2 %p3% %p4% %p5% STIMEE~1%p6%       STIME.EXE%p7%
%1 %2 %p3% %p4% %p5% STIMET~1%p6%       STIME.TXT%p7%
%1 %2 %p3% %p4% %p5% STIMEW~1%p6%       STIME.WRI%p7%
%1 %2 %p3% %p4% %p5% STRINT~1%p6%       STRINTRP.DAT%p7%
%1 %2 %p3% %p4% %p5% SUCCES~1%p6%       SUCCESS.VOC%p7%
%1 %2 %p3% %p4% %p5% SUN_2C~1%p6%       SUN_2.C%p7%
%1 %2 %p3% %p4% %p5% SUN_C~1%p6%        SUN_.C%p7%
%1 %2 %p3% %p4% %p5% SUNBMP~1%p6%       SUN.BMP%p7%
%1 %2 %p3% %p4% %p5% SUNC~1%p6%         SUN.C%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~1%p6%       SUNDEMO.EXE%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~2%p6%       SUNDEMO.TXT%p7%
%1 %2 %p3% %p4% %p5% SUNDEM~3%p6%       SUNDEMO2.TXT%p7%
%1 %2 %p3% %p4% %p5% SUNEAR~1%p6%       SUNEARTH.CLU%p7%
%1 %2 %p3% %p4% %p5% SUNFD~1%p6%        SUN.FD%p7%
%1 %2 %p3% %p4% %p5% SUNHEI~1%p6%       SUNHEIGH.MNU%p7%
%1 %2 %p3% %p4% %p5% SUNINT~1%p6%       SUNINTRP.DAT%p7%
%1 %2 %p3% %p4% %p5% SUNTAB~1%p6%       SUNTAB.EXE%p7%
%1 %2 %p3% %p4% %p5% SUNTAB~2%p6%       SUNTAB05.DOC%p7%
%1 %2 %p3% %p4% %p5% SV_ENH~1%p6%       SV_EN.HLP%p7%
%1 %2 %p3% %p4% %p5% SV_ITH~1%p6%       SV_IT.HLP%p7%
%1 %2 %p3% %p4% %p5% SVCFG~1%p6%        SV.CFG%p7%
%1 %2 %p3% %p4% %p5% SVCST~1%p6%        SV.CST%p7%
%1 %2 %p3% %p4% %p5% SVEXE~1%p6%        SV.EXE%p7%
%1 %2 %p3% %p4% %p5% SVGA16~1%p6%       SVGA16.BGI%p7%
%1 %2 %p3% %p4% %p5% SVGA25~1%p6%       SVGA256.BGI%p7%
%1 %2 %p3% %p4% %p5% SVGA25~2%p6%       SVGA256_.BGI%p7%
%1 %2 %p3% %p4% %p5% SVGA25~3%p6%       SVGA2562.BGI%p7%
%1 %2 %p3% %p4% %p5% SVGAS3~1%p6%       SVGAS3.BGI%p7%
%1 %2 %p3% %p4% %p5% SVGATR~1%p6%       SVGATRBL.TXT%p7%
%1 %2 %p3% %p4% %p5% SVMAP~1%p6%        SV.MAP%p7%
%1 %2 %p3% %p4% %p5% SVPLT~1%p6%        SV.PLT%p7%
%1 %2 %p3% %p4% %p5% SVSTA~1%p6%        SV.STA%p7%
%1 %2 %p3% %p4% %p5% SYNAPS~1%p6%       SYNAPSIS.PBM%p7%
%1 %2 %p3% %p4% %p5% TANLC~1%p6%        TANL.C%p7%
%1 %2 %p3% %p4% %p5% TAUSTR~1%p6%       TAU.STR%p7%
%1 %2 %p3% %p4% %p5% TDB_C~1%p6%        TDB_.C%p7%
%1 %2 %p3% %p4% %p5% TDBC~1%p6%         TDB.C%p7%
%1 %2 %p3% %p4% %p5% TEDEXE~1%p6%       TED.EXE%p7%
%1 %2 %p3% %p4% %p5% TESTBA~1%p6%       TEST.BAT%p7%
%1 %2 %p3% %p4% %p5% TESTDB~1%p6%       TEST.DB%p7%
%1 %2 %p3% %p4% %p5% TESTLD~1%p6%       TEST.LD%p7%
%1 %2 %p3% %p4% %p5% TESTLP~1%p6%       TESTLPT.EXE%p7%
%1 %2 %p3% %p4% %p5% TESTPB~1%p6%       TEST.PBM%p7%
%1 %2 %p3% %p4% %p5% TESTPO~1%p6%       TESTPO.C%p7%
%1 %2 %p3% %p4% %p5% TESTQU~1%p6%       TEST.QUE%p7%
%1 %2 %p3% %p4% %p5% TESTSA~1%p6%       TEST.SAV%p7%
%1 %2 %p3% %p4% %p5% TESTSF~1%p6%       TEST.SFS%p7%
%1 %2 %p3% %p4% %p5% TESTVA~1%p6%       TEST.VAX%p7%
%1 %2 %p3% %p4% %p5% THREED~1%p6%       THREED.VBX%p7%
%1 %2 %p3% %p4% %p5% TIMEC~1%p6%        TIME.C%p7%
%1 %2 %p3% %p4% %p5% TIMEZO~1%p6%       TIMEZONE.TXT%p7%
%1 %2 %p3% %p4% %p5% TITLES~1%p6%       TITLE.S50%p7%
%1 %2 %p3% %p4% %p5% TMACM~1%p6%        TMAC.M%p7%
%1 %2 %p3% %p4% %p5% TMSRBF~1%p6%       TMSRB.FON%p7%
%1 %2 %p3% %p4% %p5% TRACKE~1%p6%       TRACKER5.CFG%p7%
%1 %2 %p3% %p4% %p5% TRACKE~2%p6%       TRACKER5.DAT%p7%
%1 %2 %p3% %p4% %p5% TRACKE~3%p6%       TRACKER5.DOC%p7%
%1 %2 %p3% %p4% %p5% TRACKE~4%p6%       TRACKER5.EXE%p7%
%1 %2 %p3% %p4% %p5% TRIP_C~1%p6%       TRIP_.CHR%p7%
%1 %2 %p3% %p4% %p5% TRIPCH~1%p6%       TRIP.CHR%p7%
%1 %2 %p3% %p4% %p5% TRNSIT~1%p6%       TRNSIT.C%p7%
%1 %2 %p3% %p4% %p5% TRNSIT~2%p6%       TRNSIT_.C%p7%
%1 %2 %p3% %p4% %p5% TURBOC~1%p6%       TURBOC.MAK%p7%
%1 %2 %p3% %p4% %p5% TUTOR~1%p6%        TUTOR.%p7%
%1 %2 %p3% %p4% %p5% TUTTLE~1%p6%       TUTTLE.MNU%p7%
%1 %2 %p3% %p4% %p5% UNIV00~1%p6%       UNIV0001.DAT%p7%
%1 %2 %p3% %p4% %p5% UNIXDM~1%p6%       UNIXD.MAK%p7%
%1 %2 %p3% %p4% %p5% UNIXLM~1%p6%       UNIXL.MAK%p7%
%1 %2 %p3% %p4% %p5% UNIXMA~1%p6%       UNIX.MAK%p7%
%1 %2 %p3% %p4% %p5% UPPBM~1%p6%        UP.PBM%p7%
%1 %2 %p3% %p4% %p5% URA404~1%p6%       URA404.C%p7%
%1 %2 %p3% %p4% %p5% URANUS~1%p6%       URANUS.BMP%p7%
%1 %2 %p3% %p4% %p5% URANUS~2%p6%       URANUS.FD%p7%
%1 %2 %p3% %p4% %p5% URANUS~3%p6%       URANUS.GIF%p7%
%1 %2 %p3% %p4% %p5% UTC_GS~1%p6%       UTC_GST.C%p7%
%1 %2 %p3% %p4% %p5% V1JCTR~1%p6%       V1J.CTR%p7%
%1 %2 %p3% %p4% %p5% V1JERT~1%p6%       V1JERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V1JPES~1%p6%       V1JPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V1JPLN~1%p6%       V1JPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V1JSAT~1%p6%       V1JSAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V1JSPC~1%p6%       V1JSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% V1SCTR~1%p6%       V1S.CTR%p7%
%1 %2 %p3% %p4% %p5% V1SERT~1%p6%       V1SERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V1SPES~1%p6%       V1SPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V1SPLN~1%p6%       V1SPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V1SSAT~1%p6%       V1SSAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V1SSPC~1%p6%       V1SSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% V2JCTR~1%p6%       V2J.CTR%p7%
%1 %2 %p3% %p4% %p5% V2JERT~1%p6%       V2JERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2JPES~1%p6%       V2JPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V2JPLN~1%p6%       V2JPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V2JSAT~1%p6%       V2JSAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2JSPC~1%p6%       V2JSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% V2NCTR~1%p6%       V2N.CTR%p7%
%1 %2 %p3% %p4% %p5% V2NERT~1%p6%       V2NERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2NPES~1%p6%       V2NPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V2NPLN~1%p6%       V2NPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V2NSAT~1%p6%       V2NSAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2NSPC~1%p6%       V2NSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% V2SCTR~1%p6%       V2S.CTR%p7%
%1 %2 %p3% %p4% %p5% V2SERT~1%p6%       V2SERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2SPES~1%p6%       V2SPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V2SPLN~1%p6%       V2SPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V2SSAT~1%p6%       V2SSAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2SSPC~1%p6%       V2SSPC.EPH%p7%
%1 %2 %p3% %p4% %p5% V2UCTR~1%p6%       V2U.CTR%p7%
%1 %2 %p3% %p4% %p5% V2UERT~1%p6%       V2UERT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2UPES~1%p6%       V2UPES.EPH%p7%
%1 %2 %p3% %p4% %p5% V2UPLN~1%p6%       V2UPLN.EPH%p7%
%1 %2 %p3% %p4% %p5% V2USAT~1%p6%       V2USAT.EPH%p7%
%1 %2 %p3% %p4% %p5% V2USPC~1%p6%       V2USPC.EPH%p7%
%1 %2 %p3% %p4% %p5% VARSTA~1%p6%       VARSTAR.EXE%p7%
%1 %2 %p3% %p4% %p5% VDSDAT~1%p6%       VDS.DAT%p7%
%1 %2 %p3% %p4% %p5% VEARTH~1%p6%       VEARTH.C%p7%
%1 %2 %p3% %p4% %p5% VEARTH~2%p6%       VEARTH_.C%p7%
%1 %2 %p3% %p4% %p5% VEN404~1%p6%       VEN404.C%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDINFO.DIZ%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR.DOC%p7%
%1 %2 %p3% %p4% %p5% VENDOR~2%p6%       VENDOR.TXT%p7%
%1 %2 %p3% %p4% %p5% VENDOR~3%p6%       VENDOR_.TXT%p7%
%1 %2 %p3% %p4% %p5% VENDOR~4%p6%       VENDOR_2.TXT%p7%
%1 %2 %p3% %p4% %p5% VENDOR~5%p6%       VENDOR_3.TXT%p7%
%1 %2 %p3% %p4% %p5% VENUSB~1%p6%       VENUS.BMP%p7%
%1 %2 %p3% %p4% %p5% VENUSF~1%p6%       VENUS.FD%p7%
%1 %2 %p3% %p4% %p5% VENUSG~1%p6%       VENUS.GIF%p7%
%1 %2 %p3% %p4% %p5% VERSIO~1%p6%       VERSION.C%p7%
%1 %2 %p3% %p4% %p5% VIRSTR~1%p6%       VIR.STR%p7%
%1 %2 %p3% %p4% %p5% WATCHC~1%p6%       WATCH.C%p7%
%1 %2 %p3% %p4% %p5% WHATSN~1%p6%       WHATSNEW.TXT%p7%
%1 %2 %p3% %p4% %p5% WMOONB~1%p6%       WMOONBG.DAT%p7%
%1 %2 %p3% %p4% %p5% WMOONB~2%p6%       WMOONBG.EXE%p7%
%1 %2 %p3% %p4% %p5% WMOONB~3%p6%       WMOONBG.TXT%p7%
%1 %2 %p3% %p4% %p5% X200C~1%p6%        X200.C%p7%
%1 %2 %p3% %p4% %p5% YALEBI~1%p6%       YALE.bin%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~1%p6%       ZATAN2.C%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~2%p6%       ZATAN2_.C%p7%
%1 %2 %p3% %p4% %p5% ZATAN2~3%p6%       ZATAN2_2.C%p7%
%1 %2 %p3% %p4% %p5% ZEROME~1%p6%       ZERO.MER%p7%

cd %dir2%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST32_.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~2%p6%       _INST322.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~3%p6%       _INST324.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~4%p6%       _INST327.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~5%p6%       _INST329.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~6%p6%       _INST32I.EX_%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~2%p6%       _ISDEL_.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~3%p6%       _ISDEL_2.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~4%p6%       _ISDEL_4.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~5%p6%       _ISDEL_7.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~6%p6%       _ISDEL_9.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~1%p6%       _ISRE0.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~2%p6%       _ISRE032.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~1%p6%       _ISRE1.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~2%p6%       _ISRE132.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~1%p6%       _isre2.dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~1%p6%       _isre4.dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~2%p6%       _ISRE432.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE7~1%p6%       _isre7.dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE7~2%p6%       _ISRE732.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE9~1%p6%       _isre9.dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE9~2%p6%       _ISRE932.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS0~1%p6%       _ISUS0R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS1~1%p6%       _ISUS1R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS4~1%p6%       _ISUS4R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS7~1%p6%       _ISUS7R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS9~1%p6%       _ISUS9R.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _SETUP_.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~3%p6%       _SETUP_2.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~4%p6%       _SETUP_4.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~5%p6%       _SETUP_7.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~6%p6%       _SETUP_9.DLL%p7%
%1 %2 %p3% %p4% %p5% 0202JT~1%p6%       0202jta2.ocv%p7%
%1 %2 %p3% %p4% %p5% 1005NC~1%p6%       1005ncv6.ocv%p7%
%1 %2 %p3% %p4% %p5% 2REDOX~1%p6%       "2 redox.CVN%p7%"
%1 %2 %p3% %p4% %p5% 32VLEI~1%p6%       32VLE.IC_%p7%
%1 %2 %p3% %p4% %p5% 3RD_4T~1%p6%       "3rd, 4th Forms.dat%p7%"
%1 %2 %p3% %p4% %p5% 5THFOR~1%p6%       "5th Form.dat%p7%"
%1 %2 %p3% %p4% %p5% 6THFOR~1%p6%       "6th Form.dat%p7%"
%1 %2 %p3% %p4% %p5% 7THFOR~1%p6%       "7th Form.dat%p7%"
%1 %2 %p3% %p4% %p5% A04109~1%p6%       A04109y.aa0%p7%
%1 %2 %p3% %p4% %p5% A30099~1%p6%       A30099d.aa0%p7%
%1 %2 %p3% %p4% %p5% ABBREV~1%p6%       ABBREV.CDX%p7%
%1 %2 %p3% %p4% %p5% ABBREV~2%p6%       ABBREV.DBF%p7%
%1 %2 %p3% %p4% %p5% ABBREV~3%p6%       ABBREV.FPT%p7%
%1 %2 %p3% %p4% %p5% ACIDBN~1%p6%       acid.bnd%p7%
%1 %2 %p3% %p4% %p5% ACMSET~1%p6%       ACMSETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% ACMSET~2%p6%       ACMSETUP.HLP%p7%
%1 %2 %p3% %p4% %p5% ACTIVE~1%p6%       ACTIVE.CDX%p7%
%1 %2 %p3% %p4% %p5% ACTIVE~2%p6%       ACTIVE.DBF%p7%
%1 %2 %p3% %p4% %p5% ADMINC~1%p6%       ADMIN.CDX%p7%
%1 %2 %p3% %p4% %p5% ADMIND~1%p6%       ADMIN.DBF%p7%
%1 %2 %p3% %p4% %p5% ADMINH~1%p6%       ADMIN.HLP%p7%
%1 %2 %p3% %p4% %p5% ADMINR~1%p6%       ADMINRPT.ERR%p7%
%1 %2 %p3% %p4% %p5% ADMINR~2%p6%       ADMINRPT.FRT%p7%
%1 %2 %p3% %p4% %p5% ADMINR~3%p6%       ADMINRPT.FRX%p7%
%1 %2 %p3% %p4% %p5% ADMINR~4%p6%       ADMINRPT.FXP%p7%
%1 %2 %p3% %p4% %p5% ALCOHO~1%p6%       alcohol.bnd%p7%
%1 %2 %p3% %p4% %p5% ALDEHY~1%p6%       aldehyde.bnd%p7%
%1 %2 %p3% %p4% %p5% ALKANE~1%p6%       alkane.bnd%p7%
%1 %2 %p3% %p4% %p5% ALKENE~1%p6%       alkene.bnd%p7%
%1 %2 %p3% %p4% %p5% ALKYNE~1%p6%       alkyne.bnd%p7%
%1 %2 %p3% %p4% %p5% ALLFIL~1%p6%       ALLFILE_.TXT%p7%
%1 %2 %p3% %p4% %p5% ALLFIL~2%p6%       allfiles.txt%p7%
%1 %2 %p3% %p4% %p5% ANIHEL~1%p6%       aniHelp.gif%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~1%p6%       ARCHIVE.CDX%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~2%p6%       ARCHIVE.DBF%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~3%p6%       ARCHIVE.FPT%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~4%p6%       ARCHIVE.TBK%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~5%p6%       ARCHIVE2.FRT%p7%
%1 %2 %p3% %p4% %p5% ARCHIV~6%p6%       ARCHIVE2.FRX%p7%
%1 %2 %p3% %p4% %p5% ASTRON~1%p6%       Astronom.con%p7%
%1 %2 %p3% %p4% %p5% ASYCFI~1%p6%       ASYCFILT.DLL%p7%
%1 %2 %p3% %p4% %p5% BALANC~1%p6%       "Balancing Redox Equations.html%p7%"
%1 %2 %p3% %p4% %p5% BDECFG~1%p6%       BDECFG32.CNT%p7%
%1 %2 %p3% %p4% %p5% BDECFG~2%p6%       BDECFG32.EXE%p7%
%1 %2 %p3% %p4% %p5% BDECFG~3%p6%       BDECFG32.HLP%p7%
%1 %2 %p3% %p4% %p5% BHKALC~1%p6%       BHKALC11.EXE%p7%
%1 %2 %p3% %p4% %p5% BLGIF~1%p6%        BL.gif%p7%
%1 %2 %p3% %p4% %p5% BLUEDA~1%p6%       blue.dat%p7%
%1 %2 %p3% %p4% %p5% BLW32D~1%p6%       BLW32.DLL%p7%
%1 %2 %p3% %p4% %p5% BM0GIF~1%p6%       bm0.gif%p7%
%1 %2 %p3% %p4% %p5% BONDIT~1%p6%       bondit.exe%p7%
%1 %2 %p3% %p4% %p5% BONDIT~2%p6%       BONDIT.HLP%p7%
%1 %2 %p3% %p4% %p5% BORLND~1%p6%       BORLNDMM.DLL%p7%
%1 %2 %p3% %p4% %p5% BRUSSE~1%p6%       brusselator.gps%p7%
%1 %2 %p3% %p4% %p5% BTNADD~1%p6%       btnadd.gif%p7%
%1 %2 %p3% %p4% %p5% BTNCAL~1%p6%       btncalc.gif%p7%
%1 %2 %p3% %p4% %p5% BTNCOL~1%p6%       btncolor.gif%p7%
%1 %2 %p3% %p4% %p5% BTNCOP~1%p6%       btncopy.gif%p7%
%1 %2 %p3% %p4% %p5% BTNERA~1%p6%       btnerase.gif%p7%
%1 %2 %p3% %p4% %p5% BTNEXI~1%p6%       btnexit.gif%p7%
%1 %2 %p3% %p4% %p5% BTNFIL~1%p6%       btnfile.gif%p7%
%1 %2 %p3% %p4% %p5% BTNFOR~1%p6%       btnform.gif%p7%
%1 %2 %p3% %p4% %p5% BTNGAS~1%p6%       btngas.gif%p7%
%1 %2 %p3% %p4% %p5% BTNHAL~1%p6%       btnhalfc.gif%p7%
%1 %2 %p3% %p4% %p5% BTNNER~1%p6%       btnnerns.gif%p7%
%1 %2 %p3% %p4% %p5% BTNPRT~1%p6%       btnprt.gif%p7%
%1 %2 %p3% %p4% %p5% BTNPRT~2%p6%       btnprtsu.gif%p7%
%1 %2 %p3% %p4% %p5% BTNRAN~1%p6%       btnrand.gif%p7%
%1 %2 %p3% %p4% %p5% BTNSAV~1%p6%       btnsave.gif%p7%
%1 %2 %p3% %p4% %p5% BTNSOL~1%p6%       btnsoln.gif%p7%
%1 %2 %p3% %p4% %p5% BTNTAB~1%p6%       btntable.gif%p7%
%1 %2 %p3% %p4% %p5% BTNTIP~1%p6%       btntips.gif%p7%
%1 %2 %p3% %p4% %p5% C_MDLG~1%p6%       C_mdlg32.ocx%p7%
%1 %2 %p3% %p4% %p5% CASNOI~1%p6%       CASNO.IDX%p7%
%1 %2 %p3% %p4% %p5% CATBAC~1%p6%       CATBACK.DBF%p7%
%1 %2 %p3% %p4% %p5% CATBAC~2%p6%       CATBACK.FPT%p7%
%1 %2 %p3% %p4% %p5% CATUSE~1%p6%       CATUSER.DBF%p7%
%1 %2 %p3% %p4% %p5% CATUSE~2%p6%       CATUSER.FPT%p7%
%1 %2 %p3% %p4% %p5% CCHEMI~1%p6%       CChemistry.exe%p7%
%1 %2 %p3% %p4% %p5% CEEURO~1%p6%       CEEUROPE.BLL%p7%
%1 %2 %p3% %p4% %p5% CELLPR~1%p6%       "Cell Properties Form.html%p7%"
%1 %2 %p3% %p4% %p5% CHARSE~1%p6%       CHARSET.BLL%p7%
%1 %2 %p3% %p4% %p5% CHEMAS~1%p6%       ChemAs.exe%p7%
%1 %2 %p3% %p4% %p5% CHEMAS~2%p6%       ChemAs.hlp%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~1%p6%       CHEMFILE.CDX%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~2%p6%       CHEMFILE.DBF%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~3%p6%       CHEMFILE.ERR%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~4%p6%       CHEMFILE.FPT%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~5%p6%       CHEMFILE.FRT%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~6%p6%       CHEMFILE.FRX%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~7%p6%       CHEMFILE.FXP%p7%
%1 %2 %p3% %p4% %p5% CHEMFI~8%p6%       CHEMFILE.TBK%p7%
%1 %2 %p3% %p4% %p5% CHEMOS~1%p6%       Chemos1.gps%p7%
%1 %2 %p3% %p4% %p5% CHEMPR~1%p6%       CHEMPRT.FRT%p7%
%1 %2 %p3% %p4% %p5% CHEMPR~2%p6%       CHEMPRT.FRX%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~1%p6%       chempute.1st%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~2%p6%       chempute.txt%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~3%p6%       chemputer.exe%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~4%p6%       Chemputer.ico%p7%
%1 %2 %p3% %p4% %p5% CHEMPU~5%p6%       Chemputer2.ico%p7%
%1 %2 %p3% %p4% %p5% CMIRRO~1%p6%       CMIRROR.DBF%p7%
%1 %2 %p3% %p4% %p5% CMIX19~1%p6%       cmix191.exe%p7%
%1 %2 %p3% %p4% %p5% CMPDSX~1%p6%       cmpds.xl_%p7%
%1 %2 %p3% %p4% %p5% COFILE~1%p6%       COFILE.CDX%p7%
%1 %2 %p3% %p4% %p5% COFILE~2%p6%       COFILE.DBF%p7%
%1 %2 %p3% %p4% %p5% COFILE~3%p6%       COFILE.FPT%p7%
%1 %2 %p3% %p4% %p5% COMCTL~1%p6%       COMCTL32.DLL%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG32.oca%p7%
%1 %2 %p3% %p4% %p5% COMDLG~2%p6%       COMDLG32.OCX%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG.FPW%p7%
%1 %2 %p3% %p4% %p5% CONTAC~1%p6%       "Contact Information.html%p7%"
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       Contents.html%p7%
%1 %2 %p3% %p4% %p5% COREC0~1%p6%       COREC0MP.INI%p7%
%1 %2 %p3% %p4% %p5% COREC1~1%p6%       COREC1MP.INI%p7%
%1 %2 %p3% %p4% %p5% COREC7~1%p6%       COREC7MP.INI%p7%
%1 %2 %p3% %p4% %p5% COREC9~1%p6%       COREC9MP.INI%p7%
%1 %2 %p3% %p4% %p5% CP3240~1%p6%       cp3240mt.dll%p7%
%1 %2 %p3% %p4% %p5% CTL3D0~1%p6%       CTL3D02.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D1~1%p6%       CTL3D12.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D2~1%p6%       CTL3D22.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       ctl3d32.dl_%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~1%p6%       CTL3D42.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~2%p6%       CTL3D42S.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D7~1%p6%       CTL3D72.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D9~1%p6%       CTL3D92.DLL%p7%
%1 %2 %p3% %p4% %p5% DECROL~1%p6%       Decroly1.gps%p7%
%1 %2 %p3% %p4% %p5% DECROL~2%p6%       Decroly2.gps%p7%
%1 %2 %p3% %p4% %p5% DECROL~3%p6%       Decroly3.gps%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       default.emf%p7%
%1 %2 %p3% %p4% %p5% DESIGN~1%p6%       DESIGNAT.CDX%p7%
%1 %2 %p3% %p4% %p5% DESIGN~2%p6%       DESIGNAT.DBF%p7%
%1 %2 %p3% %p4% %p5% DESIGN~3%p6%       DESIGNAT.ERR%p7%
%1 %2 %p3% %p4% %p5% DESIGN~4%p6%       DESIGNAT.FPT%p7%
%1 %2 %p3% %p4% %p5% DESIGN~5%p6%       DESIGNAT.FRT%p7%
%1 %2 %p3% %p4% %p5% DESIGN~6%p6%       DESIGNAT.FRX%p7%
%1 %2 %p3% %p4% %p5% DESIGN~7%p6%       DESIGNAT.FXP%p7%
%1 %2 %p3% %p4% %p5% DESIGN~8%p6%       DESIGNAT.TBK%p7%
%1 %2 %p3% %p4% %p5% DISK1_~1%p6%       DISK1_.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~2%p6%       DISK1_2.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~3%p6%       DISK1_4.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~4%p6%       DISK1_7.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~5%p6%       DISK1_9.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1.ID%p7%
%1 %2 %p3% %p4% %p5% DISK2I~1%p6%       disk2.id%p7%
%1 %2 %p3% %p4% %p5% DISPCO~1%p6%       DISPCODE.CDX%p7%
%1 %2 %p3% %p4% %p5% DISPCO~2%p6%       DISPCODE.DBF%p7%
%1 %2 %p3% %p4% %p5% DISPCO~3%p6%       DISPCODE.FPT%p7%
%1 %2 %p3% %p4% %p5% DISPOS~1%p6%       DISPOSAL.CDX%p7%
%1 %2 %p3% %p4% %p5% DISPOS~2%p6%       DISPOSAL.DBF%p7%
%1 %2 %p3% %p4% %p5% DISPOS~3%p6%       DISPOSAL.FPT%p7%
%1 %2 %p3% %p4% %p5% DISPOS~4%p6%       DISPOSAL.TBK%p7%
%1 %2 %p3% %p4% %p5% DLGIM9~1%p6%       DLGIM9GE.BMP%p7%
%1 %2 %p3% %p4% %p5% DNAPDB~1%p6%       DNA.pdb%p7%
%1 %2 %p3% %p4% %p5% DROPDO~1%p6%       dropdown.gif%p7%
%1 %2 %p3% %p4% %p5% DSETUP~1%p6%       Dsetup.dll%p7%
%1 %2 %p3% %p4% %p5% E_EMMA~1%p6%       E_emMake.vbp%p7%
%1 %2 %p3% %p4% %p5% ECE(ML~1%p6%       "ECE (mlh).CVN%p7%"
%1 %2 %p3% %p4% %p5% ECELLP~1%p6%       ECellPro.cnt%p7%
%1 %2 %p3% %p4% %p5% ECELLP~2%p6%       EcellPro.exe%p7%
%1 %2 %p3% %p4% %p5% ECELLP~3%p6%       ECELLPRO.HLP%p7%
%1 %2 %p3% %p4% %p5% ECELLS~1%p6%       ecells.dat%p7%
%1 %2 %p3% %p4% %p5% ECELLS~2%p6%       ecells.gif%p7%
%1 %2 %p3% %p4% %p5% ECELLS~3%p6%       ecellspro.html%p7%
%1 %2 %p3% %p4% %p5% ECMEC~1%p6%        EC.MEC%p7%
%1 %2 %p3% %p4% %p5% EDITGI~1%p6%       edit.gif%p7%
%1 %2 %p3% %p4% %p5% EDITIN~1%p6%       "Editing Half Cells.html%p7%"
%1 %2 %p3% %p4% %p5% EDITME~1%p6%       "Edit Menu.html%p7%"
%1 %2 %p3% %p4% %p5% EEAA0~1%p6%        ee.AA0%p7%
%1 %2 %p3% %p4% %p5% EEMEC~1%p6%        EE.MEC%p7%
%1 %2 %p3% %p4% %p5% EEOCV~1%p6%        ee.OCV%p7%
%1 %2 %p3% %p4% %p5% EEPRN~1%p6%        ee.PRN%p7%
%1 %2 %p3% %p4% %p5% ELECTR~1%p6%       electro.gif%p7%
%1 %2 %p3% %p4% %p5% ELECTR~2%p6%       Electrodes.html%p7%
%1 %2 %p3% %p4% %p5% ELEMMA~1%p6%       ElemMake.exe%p7%
%1 %2 %p3% %p4% %p5% ELEMVI~1%p6%       ElemView.exe%p7%
%1 %2 %p3% %p4% %p5% ELEMVI~2%p6%       ElemView.vbp%p7%
%1 %2 %p3% %p4% %p5% EMEC~1%p6%         E.MEC%p7%
%1 %2 %p3% %p4% %p5% EQBMGI~1%p6%       eqbm.gif%p7%
%1 %2 %p3% %p4% %p5% EQNED1~1%p6%       eqned16.gif%p7%
%1 %2 %p3% %p4% %p5% EQNEDG~1%p6%       eqnedg16.gif%p7%
%1 %2 %p3% %p4% %p5% EQNSGI~1%p6%       eqns.gif%p7%
%1 %2 %p3% %p4% %p5% EQUATI~1%p6%       "Equations Menu.html%p7%"
%1 %2 %p3% %p4% %p5% ESTERB~1%p6%       ester.bnd%p7%
%1 %2 %p3% %p4% %p5% ETHERB~1%p6%       ether.bnd%p7%
%1 %2 %p3% %p4% %p5% EUROPE~1%p6%       EUROPE.BLL%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~1%p6%       evolprog.dll%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~2%p6%       EVOLPROG.HLP%p7%
%1 %2 %p3% %p4% %p5% EVOLPR~3%p6%       evolprog.ini%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~1%p6%       EXAMPLE.TSK%p7%
%1 %2 %p3% %p4% %p5% EXCEPT~1%p6%       EXCEPT.FRT%p7%
%1 %2 %p3% %p4% %p5% EXCEPT~2%p6%       EXCEPT.FRX%p7%
%1 %2 %p3% %p4% %p5% F_MDES~1%p6%       f_mDescription.frm%p7%
%1 %2 %p3% %p4% %p5% F_MDES~2%p6%       f_mDescription.frx%p7%
%1 %2 %p3% %p4% %p5% F_MPRO~1%p6%       f_mProperties.frm%p7%
%1 %2 %p3% %p4% %p5% F_MPRO~2%p6%       f_mProperties.frx%p7%
%1 %2 %p3% %p4% %p5% F_MTAB~1%p6%       f_mTable.frm%p7%
%1 %2 %p3% %p4% %p5% F_MTAB~2%p6%       f_mTable.frx%p7%
%1 %2 %p3% %p4% %p5% F_MTOO~1%p6%       f_mToolBox.frm%p7%
%1 %2 %p3% %p4% %p5% F_MTOO~2%p6%       f_mToolBox.frx%p7%
%1 %2 %p3% %p4% %p5% FACILI~1%p6%       FACILITY.FRT%p7%
%1 %2 %p3% %p4% %p5% FACILI~2%p6%       FACILITY.FRX%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_ID_.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_ID0.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_ID1.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_ID3.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_ID4.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~7%p6%       FILE_ID5.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~8%p6%       file_idz.diz%p7%
%1 %2 %p3% %p4% %p5% FILEGI~1%p6%       file.gif%p7%
%1 %2 %p3% %p4% %p5% FILEME~1%p6%       "File Menu.html%p7%"
%1 %2 %p3% %p4% %p5% FINISH~1%p6%       FINISH.WAV%p7%
%1 %2 %p3% %p4% %p5% FORMUL~1%p6%       formula.CNT%p7%
%1 %2 %p3% %p4% %p5% FORMUL~2%p6%       Formula.exe%p7%
%1 %2 %p3% %p4% %p5% FORMUL~3%p6%       Formula.hlp%p7%
%1 %2 %p3% %p4% %p5% FOXFON~1%p6%       FOXFONT.FON%p7%
%1 %2 %p3% %p4% %p5% FOXUSE~1%p6%       FOXUSER.DBF%p7%
%1 %2 %p3% %p4% %p5% FOXUSE~2%p6%       FOXUSER.FPT%p7%
%1 %2 %p3% %p4% %p5% FRMABO~1%p6%       frmAbout.frm%p7%
%1 %2 %p3% %p4% %p5% FRMABO~2%p6%       frmAbout.frx%p7%
%1 %2 %p3% %p4% %p5% FRMDES~1%p6%       frmDescription.frm%p7%
%1 %2 %p3% %p4% %p5% FRMDES~2%p6%       frmDescription.frx%p7%
%1 %2 %p3% %p4% %p5% FRMTAB~1%p6%       frmTable.frm%p7%
%1 %2 %p3% %p4% %p5% FRMTAB~2%p6%       frmTable.frx%p7%
%1 %2 %p3% %p4% %p5% GADLL~1%p6%        ga.dll%p7%
%1 %2 %p3% %p4% %p5% GAHLP~1%p6%        GA.HLP%p7%
%1 %2 %p3% %p4% %p5% GAINI~1%p6%        ga.ini%p7%
%1 %2 %p3% %p4% %p5% GASESD~1%p6%       Gases.Dat%p7%
%1 %2 %p3% %p4% %p5% GEP3F_~1%p6%       gep3f_q.txt%p7%
%1 %2 %p3% %p4% %p5% GEP3FA~1%p6%       gep3faq.txt%p7%
%1 %2 %p3% %p4% %p5% GEPASI~1%p6%       Gepasi.exe%p7%
%1 %2 %p3% %p4% %p5% GEPASI~2%p6%       GEPASI.HLP%p7%
%1 %2 %p3% %p4% %p5% GEPASI~3%p6%       gepasi.kdb%p7%
%1 %2 %p3% %p4% %p5% GLOBEG~1%p6%       globe.gif%p7%
%1 %2 %p3% %p4% %p5% GLOSSA~1%p6%       Glossary.html%p7%
%1 %2 %p3% %p4% %p5% GNUPLO~1%p6%       gnuplot37gepasi.patch%p7%
%1 %2 %p3% %p4% %p5% GRAPH3~1%p6%       GRAPH32.OC_%p7%
%1 %2 %p3% %p4% %p5% GRAPH3~2%p6%       graph32.ocx%p7%
%1 %2 %p3% %p4% %p5% GREEND~1%p6%       green.dat%p7%
%1 %2 %p3% %p4% %p5% GREYDA~1%p6%       grey.dat%p7%
%1 %2 %p3% %p4% %p5% GRID32~1%p6%       GRID32.OC_%p7%
%1 %2 %p3% %p4% %p5% GSW32E~1%p6%       gsw32.ex_%p7%
%1 %2 %p3% %p4% %p5% GSW32E~2%p6%       gsw32.exe%p7%
%1 %2 %p3% %p4% %p5% GSWAG3~1%p6%       gswag32.dll%p7%
%1 %2 %p3% %p4% %p5% GSWDLL~1%p6%       gswdll32.dl_%p7%
%1 %2 %p3% %p4% %p5% GSWDLL~2%p6%       gswdll32.dll%p7%
%1 %2 %p3% %p4% %p5% HALFEQ~1%p6%       "Half Equation Form.html%p7%"
%1 %2 %p3% %p4% %p5% HALFEQ~2%p6%       "Half Equation Grid.html%p7%"
%1 %2 %p3% %p4% %p5% HEADER~1%p6%       HEADER.CDX%p7%
%1 %2 %p3% %p4% %p5% HEADER~2%p6%       HEADER.DBF%p7%
%1 %2 %p3% %p4% %p5% HELPPA~1%p6%       helppage.gif%p7%
%1 %2 %p3% %p4% %p5% HMMGPS~1%p6%       HMM.GPS%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~1%p6%       hoojee.dll%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~2%p6%       HOOJEE.HLP%p7%
%1 %2 %p3% %p4% %p5% HOOJEE~3%p6%       hoojee.ini%p7%
%1 %2 %p3% %p4% %p5% HYPERG~1%p6%       Hypergraphic.html%p7%
%1 %2 %p3% %p4% %p5% IDAPI3~1%p6%       IDAPI32.CNF%p7%
%1 %2 %p3% %p4% %p5% IDAPI3~2%p6%       IDAPI32.DLL%p7%
%1 %2 %p3% %p4% %p5% IDAPIN~1%p6%       IDAPINST.DLL%p7%
%1 %2 %p3% %p4% %p5% IDBAT3~1%p6%       IDBAT32.DLL%p7%
%1 %2 %p3% %p4% %p5% IDPDX3~1%p6%       IDPDX32.DLL%p7%
%1 %2 %p3% %p4% %p5% IDR200~1%p6%       IDR20009.DLL%p7%
%1 %2 %p3% %p4% %p5% IDSQL3~1%p6%       IDSQL32.DLL%p7%
%1 %2 %p3% %p4% %p5% INFOCD~1%p6%       INFO.CDX%p7%
%1 %2 %p3% %p4% %p5% INFODB~1%p6%       INFO.DBF%p7%
%1 %2 %p3% %p4% %p5% INFOFP~1%p6%       INFO.FPT%p7%
%1 %2 %p3% %p4% %p5% INFOTB~1%p6%       INFO.TBK%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.EXE%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTALL.INF%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTALL_.EXE%p7%
%1 %2 %p3% %p4% %p5% INVENT~1%p6%       INVENT.CDX%p7%
%1 %2 %p3% %p4% %p5% INVENT~2%p6%       INVENT.DBF%p7%
%1 %2 %p3% %p4% %p5% INVENT~3%p6%       INVENT1.FRT%p7%
%1 %2 %p3% %p4% %p5% INVENT~4%p6%       INVENT1.FRX%p7%
%1 %2 %p3% %p4% %p5% KETONE~1%p6%       ketone.bnd%p7%
%1 %2 %p3% %p4% %p5% KHEMCC~1%p6%       KHEMC.CDX%p7%
%1 %2 %p3% %p4% %p5% KHEMCD~1%p6%       KHEMC.DBF%p7%
%1 %2 %p3% %p4% %p5% KHEMCF~1%p6%       KHEMC.FPT%p7%
%1 %2 %p3% %p4% %p5% KINMMF~1%p6%       KinMMfit.gps%p7%
%1 %2 %p3% %p4% %p5% KMODIC~1%p6%       KMOD.ICO%p7%
%1 %2 %p3% %p4% %p5% KMODUL~1%p6%       KMODULES.EXE%p7%
%1 %2 %p3% %p4% %p5% LABEL3~1%p6%       LABEL3.LBT%p7%
%1 %2 %p3% %p4% %p5% LABEL3~2%p6%       LABEL3.LBX%p7%
%1 %2 %p3% %p4% %p5% LABELH~1%p6%       LABEL.HLP%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~1%p6%       lbfgsb.dll%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~2%p6%       LBFGSB.HLP%p7%
%1 %2 %p3% %p4% %p5% LBFGSB~3%p6%       lbfgsb.ini%p7%
%1 %2 %p3% %p4% %p5% LBLUED~1%p6%       lblue.dat%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~1%p6%       levmarq.dll%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~2%p6%       LEVMARQ.HLP%p7%
%1 %2 %p3% %p4% %p5% LEVMAR~3%p6%       levmarq.ini%p7%
%1 %2 %p3% %p4% %p5% LICE_S~1%p6%       Lice_se.txt%p7%
%1 %2 %p3% %p4% %p5% LICEN_~1%p6%       licen_e.txt%p7%
%1 %2 %p3% %p4% %p5% LICEN9~1%p6%       Licen9e.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       license.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENSE_.TXT%p7%
%1 %2 %p3% %p4% %p5% LINEAR~1%p6%       linear5.gps%p7%
%1 %2 %p3% %p4% %p5% LINEAR~2%p6%       linear5a.gps%p7%
%1 %2 %p3% %p4% %p5% LOCATE~1%p6%       LOCATE.FRT%p7%
%1 %2 %p3% %p4% %p5% LOCATE~2%p6%       LOCATE.FRX%p7%
%1 %2 %p3% %p4% %p5% LOCATI~1%p6%       LOCATION.CDX%p7%
%1 %2 %p3% %p4% %p5% LOCATI~2%p6%       LOCATION.DBF%p7%
%1 %2 %p3% %p4% %p5% LOCATI~3%p6%       LOCATION.FPT%p7%
%1 %2 %p3% %p4% %p5% LOCATI~4%p6%       LOCATION.TBK%p7%
%1 %2 %p3% %p4% %p5% LOGADM~1%p6%       LOGADMIN.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGLAB~1%p6%       LOGLABEL.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGREP~1%p6%       LOGREPT.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGSAF~1%p6%       LOGSAFE.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGSET~1%p6%       LOGSETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGSRC~1%p6%       LOGSRCH.EXE%p7%
%1 %2 %p3% %p4% %p5% LOGWAS~1%p6%       LOGWASTE.EXE%p7%
%1 %2 %p3% %p4% %p5% M_DELE~1%p6%       m_dElemMaker.bas%p7%
%1 %2 %p3% %p4% %p5% MAILGI~1%p6%       mail.gif%p7%
%1 %2 %p3% %p4% %p5% MAINGI~1%p6%       main.gif%p7%
%1 %2 %p3% %p4% %p5% MANU_L~1%p6%       Manu_l.txt%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       Manual.doc%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       Manual.htm%p7%
%1 %2 %p3% %p4% %p5% MANUAL~3%p6%       Manual.txt%p7%
%1 %2 %p3% %p4% %p5% MENDE4~1%p6%       Mende46l.bmp%p7%
%1 %2 %p3% %p4% %p5% MENDEL~1%p6%       Mendel.exe%p7%
%1 %2 %p3% %p4% %p5% MFC4_D~1%p6%       MFC4_.DLL%p7%
%1 %2 %p3% %p4% %p5% MFILEC~1%p6%       MFILE.CDX%p7%
%1 %2 %p3% %p4% %p5% MFILED~1%p6%       MFILE.DBF%p7%
%1 %2 %p3% %p4% %p5% MFILEF~1%p6%       MFILE.FPT%p7%
%1 %2 %p3% %p4% %p5% MIRROR~1%p6%       MIRROR.CDX%p7%
%1 %2 %p3% %p4% %p5% MIRROR~2%p6%       MIRROR.DBF%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~1%p6%       MIXTURE.CDX%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~2%p6%       MIXTURE.DBF%p7%
%1 %2 %p3% %p4% %p5% MIXTUR~3%p6%       MIXTURE.FPT%p7%
%1 %2 %p3% %p4% %p5% MMSPEC~1%p6%       mmspect.dat%p7%
%1 %2 %p3% %p4% %p5% MNUEDI~1%p6%       mnuedit.gif%p7%
%1 %2 %p3% %p4% %p5% MNUEQN~1%p6%       mnueqns.gif%p7%
%1 %2 %p3% %p4% %p5% MNUFIL~1%p6%       mnufile.gif%p7%
%1 %2 %p3% %p4% %p5% MNUOPT~1%p6%       mnuopt.gif%p7%
%1 %2 %p3% %p4% %p5% MNUSHO~1%p6%       mnushow.gif%p7%
%1 %2 %p3% %p4% %p5% MODELE~1%p6%       modElemMaker.bas%p7%
%1 %2 %p3% %p4% %p5% MOLVIE~1%p6%       MolView.exe%p7%
%1 %2 %p3% %p4% %p5% MSDSCD~1%p6%       MSDS.CDX%p7%
%1 %2 %p3% %p4% %p5% MSDSDB~1%p6%       MSDS.DBF%p7%
%1 %2 %p3% %p4% %p5% MSDSFP~1%p6%       MSDS.FPT%p7%
%1 %2 %p3% %p4% %p5% MSDSTB~1%p6%       MSDS.TBK%p7%
%1 %2 %p3% %p4% %p5% MSFLXG~1%p6%       MSFLXGRD.OCX%p7%
%1 %2 %p3% %p4% %p5% MSSETU~1%p6%       MSSETUP.DLL%p7%
%1 %2 %p3% %p4% %p5% MSTART~1%p6%       mstartlm.dll%p7%
%1 %2 %p3% %p4% %p5% MSTART~2%p6%       MSTARTLM.HLP%p7%
%1 %2 %p3% %p4% %p5% MSTART~3%p6%       mstartlm.ini%p7%
%1 %2 %p3% %p4% %p5% MSVC_T~1%p6%       MSVC_T40.DLL%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       MSVCRT.DLL%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~2%p6%       MSVCRT40.DLL%p7%
%1 %2 %p3% %p4% %p5% MTBENG~1%p6%       mtbengex.con%p7%
%1 %2 %p3% %p4% %p5% MTBENG~2%p6%       mtbengex.unc%p7%
%1 %2 %p3% %p4% %p5% MWT_AB~1%p6%       MWT_ABBR.dat%p7%
%1 %2 %p3% %p4% %p5% MWT_EL~1%p6%       MWT_ELEM.BAK%p7%
%1 %2 %p3% %p4% %p5% MWT_EL~2%p6%       MWT_ELEM.dat%p7%
%1 %2 %p3% %p4% %p5% MWT_VA~1%p6%       MWT_VALU.ini%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~1%p6%       mwtwin.chm%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~2%p6%       mwtwin.exe%p7%
%1 %2 %p3% %p4% %p5% MWTWIN~3%p6%       MWTWIN.ini%p7%
%1 %2 %p3% %p4% %p5% N02_RE~1%p6%       "N02+ Reduction (ex4).CVN%p7%"
%1 %2 %p3% %p4% %p5% N20OXI~1%p6%       "N20 Oxidation.CVN%p7%"
%1 %2 %p3% %p4% %p5% NERNST~1%p6%       nernst.gif%p7%
%1 %2 %p3% %p4% %p5% NOTE2I~1%p6%       NOTE2.ICO%p7%
%1 %2 %p3% %p4% %p5% ODBCKE~1%p6%       ODBCKEY.INF%p7%
%1 %2 %p3% %p4% %p5% ODBCST~1%p6%       ODBCSTF.DLL%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~1%p6%       OFFSITE.CDX%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~2%p6%       OFFSITE.DBF%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~3%p6%       OFFSITE.ERR%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~4%p6%       OFFSITE.FPT%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~5%p6%       OFFSITE.FRT%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~6%p6%       OFFSITE.FRX%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~7%p6%       OFFSITE.FXP%p7%
%1 %2 %p3% %p4% %p5% OFFSIT~8%p6%       OFFSITE.TBK%p7%
%1 %2 %p3% %p4% %p5% OLEAUT~1%p6%       OLEAUT32.DLL%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       OLEPRO32.DLL%p7%
%1 %2 %p3% %p4% %p5% OPENBO~1%p6%       openbook.gif%p7%
%1 %2 %p3% %p4% %p5% OPTION~1%p6%       options.gif%p7%
%1 %2 %p3% %p4% %p5% OPTION~2%p6%       "Options Menu.html%p7%"
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       order_.frm%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDER.FRM%p7%
%1 %2 %p3% %p4% %p5% OTHERB~1%p6%       OTHER.BLL%p7%
%1 %2 %p3% %p4% %p5% OXIDAT~1%p6%       "Oxidation Numbers.html%p7%"
%1 %2 %p3% %p4% %p5% PINKDA~1%p6%       pink.dat%p7%
%1 %2 %p3% %p4% %p5% POLAR4~1%p6%       polar4.exe%p7%
%1 %2 %p3% %p4% %p5% POLARD~1%p6%       polar.doc%p7%
%1 %2 %p3% %p4% %p5% POLARH~1%p6%       polar.htm%p7%
%1 %2 %p3% %p4% %p5% POLART~1%p6%       polar.txt%p7%
%1 %2 %p3% %p4% %p5% POLYCO~1%p6%       polycon.cnt%p7%
%1 %2 %p3% %p4% %p5% POLYCO~2%p6%       Polycon.exe%p7%
%1 %2 %p3% %p4% %p5% POLYCO~3%p6%       polycon.hlp%p7%
%1 %2 %p3% %p4% %p5% PSEDAT~1%p6%       Pse.dat%p7%
%1 %2 %p3% %p4% %p5% PTDATA~1%p6%       ptdata.APX%p7%
%1 %2 %p3% %p4% %p5% PTDATA~2%p6%       ptdata.Db%p7%
%1 %2 %p3% %p4% %p5% PTDATA~3%p6%       ptdata.Mb%p7%
%1 %2 %p3% %p4% %p5% PTDATA~4%p6%       ptdata.PX%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~1%p6%       PUBLIC.CDX%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~2%p6%       PUBLIC.DBF%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~3%p6%       PUBLIC.ERR%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~4%p6%       PUBLIC.FPT%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~5%p6%       PUBLIC.FRT%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~6%p6%       PUBLIC.FRX%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~7%p6%       PUBLIC.FXP%p7%
%1 %2 %p3% %p4% %p5% PUBLIC~8%p6%       PUBLIC.TBK%p7%
%1 %2 %p3% %p4% %p5% QINFOD~1%p6%       QINFO.DBF%p7%
%1 %2 %p3% %p4% %p5% QINFOF~1%p6%       QINFO.FPT%p7%
%1 %2 %p3% %p4% %p5% QRPT30~1%p6%       qrpt30.dpl%p7%
%1 %2 %p3% %p4% %p5% R_CHTX~1%p6%       R_chtx32.ocx%p7%
%1 %2 %p3% %p4% %p5% READ_E~1%p6%       Read_e.txt%p7%
%1 %2 %p3% %p4% %p5% READM_~1%p6%       readm_.txt%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       README_6.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       README_7.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       README_8.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       README_9.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       README_A.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       README_B.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       README_C.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       README_D.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       README_E.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       readme_z.txt%p7%
%1 %2 %p3% %p4% %p5% READM7~1%p6%       readm7.txt%p7%
%1 %2 %p3% %p4% %p5% READM9~1%p6%       Readm9.txt%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       "Read Me.doc%p7%"
%1 %2 %p3% %p4% %p5% README~2%p6%       README.TXT%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README_0.TXT%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README_1.TXT%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README_2.TXT%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README_3.TXT%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README_4.TXT%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README_5.TXT%p7%
%1 %2 %p3% %p4% %p5% REDDAT~1%p6%       red.dat%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGISTE_.TXT%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGISTER.TXT%p7%
%1 %2 %p3% %p4% %p5% REMIND~1%p6%       REMINDER.EXE%p7%
%1 %2 %p3% %p4% %p5% REPORT~1%p6%       REPORT.HLP%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RICHED32.DLL%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX32.oca%p7%
%1 %2 %p3% %p4% %p5% RICHTX~2%p6%       RICHTX32.OCX%p7%
%1 %2 %p3% %p4% %p5% RINFOD~1%p6%       RINFO.DBF%p7%
%1 %2 %p3% %p4% %p5% RINFOF~1%p6%       RINFO.FPT%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~1%p6%       rndsrch.dll%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~2%p6%       RNDSRCH.HLP%p7%
%1 %2 %p3% %p4% %p5% RNDSRC~3%p6%       rndsrch.ini%p7%
%1 %2 %p3% %p4% %p5% RXCTLB~1%p6%       Rxctl.bpl%p7%
%1 %2 %p3% %p4% %p5% S_OWIC~1%p6%       S_ow.ico%p7%
%1 %2 %p3% %p4% %p5% SAFETY~1%p6%       SAFETY.HLP%p7%
%1 %2 %p3% %p4% %p5% SAMPLE~1%p6%       sample.stc%p7%
%1 %2 %p3% %p4% %p5% SEARCH~1%p6%       SEARCH.HLP%p7%
%1 %2 %p3% %p4% %p5% SEQFBG~1%p6%       SEQFB.GPS%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP_.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_2.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_2.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_2.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP_~8%p6%       SETUP_3.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~9%p6%       SETUP_3.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~10%p6%       SETUP_4.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~11%p6%       SETUP_4.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~12%p6%       SETUP_4.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~13%p6%       SETUP_4.ISS%p7%
%1 %2 %p3% %p4% %p5% SETUP~14%p6%       SETUP_4.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP~15%p6%       SETUP_7.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~16%p6%       SETUP_7.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~17%p6%       SETUP_7.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~18%p6%       SETUP_7.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP~19%p6%       SETUP_8.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~20%p6%       SETUP_8.LST%p7%
%1 %2 %p3% %p4% %p5% SETUP~21%p6%       SETUP_9.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~22%p6%       SETUP_9.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~23%p6%       SETUP_9.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~24%p6%       SETUP_9.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP0~1%p6%       SETUP0.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       SETUP1.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       setup132.ex_%p7%
%1 %2 %p3% %p4% %p5% SETUP2~1%p6%       SETUP2.LST%p7%
%1 %2 %p3% %p4% %p5% SETUP4~1%p6%       SETUP4.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP7~1%p6%       SETUP7.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP9~1%p6%       SETUP9.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUPH~1%p6%       SETUP.HLP%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUP.INF%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUP.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUP.INS%p7%
%1 %2 %p3% %p4% %p5% SETUPI~4%p6%       SETUP.ISS%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUP.LST%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUP.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUPR~1%p6%       SETUP.RUL%p7%
%1 %2 %p3% %p4% %p5% SETUPS~1%p6%       SETUP.STF%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       SETUP.TDF%p7%
%1 %2 %p3% %p4% %p5% SHIPP9~1%p6%       shipp9ng2_16.bmp%p7%
%1 %2 %p3% %p4% %p5% SHOWGI~1%p6%       show.gif%p7%
%1 %2 %p3% %p4% %p5% SHOWME~1%p6%       "Show Menu.html%p7%"
%1 %2 %p3% %p4% %p5% SIGNAL~1%p6%       SignalTransduction.1%p7%
%1 %2 %p3% %p4% %p5% SIGNAL~2%p6%       SignalTransduction.2%p7%
%1 %2 %p3% %p4% %p5% SNOWIC~1%p6%       Snow.ico%p7%
%1 %2 %p3% %p4% %p5% SOLNSD~1%p6%       Solns.Dat%p7%
%1 %2 %p3% %p4% %p5% ST4UNS~1%p6%       ST4UNST.EX_%p7%
%1 %2 %p3% %p4% %p5% STANDA~1%p6%       "Standard Electrode Potentials.html%p7%"
%1 %2 %p3% %p4% %p5% STDOLE~1%p6%       STDOLE2.TLB%p7%
%1 %2 %p3% %p4% %p5% STEEPE~1%p6%       steepest.dll%p7%
%1 %2 %p3% %p4% %p5% STEEPE~2%p6%       STEEPEST.HLP%p7%
%1 %2 %p3% %p4% %p5% STEEPE~3%p6%       steepest.ini%p7%
%1 %2 %p3% %p4% %p5% STKIT4~1%p6%       stkit432.dl_%p7%
%1 %2 %p3% %p4% %p5% STOCKN~1%p6%       STOCKNO.IDX%p7%
%1 %2 %p3% %p4% %p5% STOICE~1%p6%       stoic.exe%p7%
%1 %2 %p3% %p4% %p5% STOICH~1%p6%       STOIC.HLP%p7%
%1 %2 %p3% %p4% %p5% SURVEY~1%p6%       survey.txt%p7%
%1 %2 %p3% %p4% %p5% TANDAT~1%p6%       tan.dat%p7%
%1 %2 %p3% %p4% %p5% TEE35B~1%p6%       tee35.bpl%p7%
%1 %2 %p3% %p4% %p5% TNDLL~1%p6%        tn.dll%p7%
%1 %2 %p3% %p4% %p5% TNHLP~1%p6%        TN.HLP%p7%
%1 %2 %p3% %p4% %p5% TNINI~1%p6%        tn.ini%p7%
%1 %2 %p3% %p4% %p5% TOOLBA~1%p6%       "Toolbars Menu.html%p7%"
%1 %2 %p3% %p4% %p5% TRANSP~1%p6%       TRANSPOR.CDX%p7%
%1 %2 %p3% %p4% %p5% TRANSP~2%p6%       TRANSPOR.DBF%p7%
%1 %2 %p3% %p4% %p5% TRANSP~3%p6%       TRANSPOR.ERR%p7%
%1 %2 %p3% %p4% %p5% TRANSP~4%p6%       TRANSPOR.FPT%p7%
%1 %2 %p3% %p4% %p5% TRANSP~5%p6%       TRANSPOR.FRT%p7%
%1 %2 %p3% %p4% %p5% TRANSP~6%p6%       TRANSPOR.FRX%p7%
%1 %2 %p3% %p4% %p5% TRANSP~7%p6%       TRANSPOR.FXP%p7%
%1 %2 %p3% %p4% %p5% TRANSP~8%p6%       TRANSPOR.TBK%p7%
%1 %2 %p3% %p4% %p5% UNINS0~1%p6%       UNINS0.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS1~1%p6%       UNINS1.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS2~1%p6%       unins2.exe%p7%
%1 %2 %p3% %p4% %p5% UNINS4~1%p6%       unins4.exe%p7%
%1 %2 %p3% %p4% %p5% UNINS7~1%p6%       unins7.exe%p7%
%1 %2 %p3% %p4% %p5% UNINS9~1%p6%       unins9.exe%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       uninst.exe%p7%
%1 %2 %p3% %p4% %p5% USABLL~1%p6%       USA.BLL%p7%
%1 %2 %p3% %p4% %p5% USAGE2~1%p6%       USAGE2.FRT%p7%
%1 %2 %p3% %p4% %p5% USAGE2~2%p6%       USAGE2.FRX%p7%
%1 %2 %p3% %p4% %p5% USAGE3~1%p6%       USAGE3.FRT%p7%
%1 %2 %p3% %p4% %p5% USAGE3~2%p6%       USAGE3.FRX%p7%
%1 %2 %p3% %p4% %p5% USAGEC~1%p6%       USAGE.CDX%p7%
%1 %2 %p3% %p4% %p5% USAGED~1%p6%       USAGE.DBF%p7%
%1 %2 %p3% %p4% %p5% USAGEF~1%p6%       USAGE.FRT%p7%
%1 %2 %p3% %p4% %p5% USAGEF~2%p6%       USAGE.FRX%p7%
%1 %2 %p3% %p4% %p5% VCL35B~1%p6%       vcl35.bpl%p7%
%1 %2 %p3% %p4% %p5% VCLDB3~1%p6%       vcldb30.dpl%p7%
%1 %2 %p3% %p4% %p5% VCLDBX~1%p6%       vcldbx30.dpl%p7%
%1 %2 %p3% %p4% %p5% VCLSMP~1%p6%       vclsmp30.dpl%p7%
%1 %2 %p3% %p4% %p5% VCLX30~1%p6%       vclx30.dpl%p7%
%1 %2 %p3% %p4% %p5% VCLX35~1%p6%       vclx35.bpl%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       vendor.txt%p7%
%1 %2 %p3% %p4% %p5% VFP6RD~1%p6%       VFP6R.DLL%p7%
%1 %2 %p3% %p4% %p5% VFP6RE~1%p6%       VFP6RENU.DLL%p7%
%1 %2 %p3% %p4% %p5% VFP6RU~1%p6%       VFP6RUN.EXE%p7%
%1 %2 %p3% %p4% %p5% VIRTUA~1%p6%       VirtualCV.exe%p7%
%1 %2 %p3% %p4% %p5% VLECAL~1%p6%       VLECALC.ex_%p7%
%1 %2 %p3% %p4% %p5% WASTEH~1%p6%       WASTE.HLP%p7%
%1 %2 %p3% %p4% %p5% WASTEM~1%p6%       WASTEMIX.CDX%p7%
%1 %2 %p3% %p4% %p5% WASTEM~2%p6%       WASTEMIX.DBF%p7%
%1 %2 %p3% %p4% %p5% WASTEM~3%p6%       WASTEMIX.FPT%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~1%p6%       wgnuplot.exe%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~2%p6%       WGNUPLOT.HLP%p7%
%1 %2 %p3% %p4% %p5% WGNUPL~3%p6%       wgnuplot.mnu%p7%
%1 %2 %p3% %p4% %p5% WHITED~1%p6%       white.dat%p7%
%1 %2 %p3% %p4% %p5% WIZSET~1%p6%       WIZSET32.DLL%p7%
%1 %2 %p3% %p4% %p5% YELLOW~1%p6%       yellow.dat%p7%
%1 %2 %p3% %p4% %p5% ZLIB_D~1%p6%       zlib_.dll%p7%

cd %dir3%

%1 %2 %p3% %p4% %p5% _BORDE~1%p6%       _border.htm%p7%
%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST32_.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~2%p6%       _INST321.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~3%p6%       _INST324.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~4%p6%       _INST32I.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~5%p6%       _INST32M.EX_%p7%
%1 %2 %p3% %p4% %p5% _INST3~6%p6%       _INST32O.EX_%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~2%p6%       _ISDEL_.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~3%p6%       _ISDEL_1.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~4%p6%       _ISDEL_4.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~5%p6%       _ISDEL_M.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~6%p6%       _ISDEL_O.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~1%p6%       _IsRe0.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE0~2%p6%       _ISRE032.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~1%p6%       _IsRe1.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE1~2%p6%       _ISRE132.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~1%p6%       _IsRe2.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE2~2%p6%       _ISRE232.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE3~1%p6%       _IsRe3.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE3~2%p6%       _ISRE332.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~1%p6%       _IsRe4.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISRE4~2%p6%       _ISRE432.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _IsRes.Dll%p7%
%1 %2 %p3% %p4% %p5% _ISUS0~1%p6%       _ISUS0R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS1~1%p6%       _ISUS1R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS2~1%p6%       _ISUS2R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS3~1%p6%       _ISUS3R.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUS4~1%p6%       _ISUS4R.DLL%p7%
%1 %2 %p3% %p4% %p5% _LIC7N~1%p6%       _Lic7nse.txt%p7%
%1 %2 %p3% %p4% %p5% _REA7M~1%p6%       _Rea7Me.txt%p7%
%1 %2 %p3% %p4% %p5% _REA8M~1%p6%       _REA8ME.TXT%p7%
%1 %2 %p3% %p4% %p5% _REA9M~1%p6%       _REA9ME.TXT%p7%
%1 %2 %p3% %p4% %p5% _READM~1%p6%       _readme.htm%p7%
%1 %2 %p3% %p4% %p5% _READM~2%p6%       _ReadMe.txt%p7%
%1 %2 %p3% %p4% %p5% _READM~3%p6%       _README_.TXT%p7%
%1 %2 %p3% %p4% %p5% _READM~4%p6%       _READMEP.TXT%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _SETUP_.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~3%p6%       _SETUP_1.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~4%p6%       _SETUP_B.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~5%p6%       _SETUP_M.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~6%p6%       _SETUP_O.DLL%p7%
%1 %2 %p3% %p4% %p5% 001GIF~1%p6%       001.gif%p7%
%1 %2 %p3% %p4% %p5% 0047HT~1%p6%       0047.htm%p7%
%1 %2 %p3% %p4% %p5% 050GIF~1%p6%       050.gif%p7%
%1 %2 %p3% %p4% %p5% 1975RG~1%p6%       1975RG__.TTF%p7%
%1 %2 %p3% %p4% %p5% 1976RG~1%p6%       1976RG__.TTF%p7%
%1 %2 %p3% %p4% %p5% 3000HT~1%p6%       3000.htm%p7%
%1 %2 %p3% %p4% %p5% 3002HT~1%p6%       3002.htm%p7%
%1 %2 %p3% %p4% %p5% 3003HT~1%p6%       3003.htm%p7%
%1 %2 %p3% %p4% %p5% 3004HT~1%p6%       3004.htm%p7%
%1 %2 %p3% %p4% %p5% 3008HT~1%p6%       3008.htm%p7%
%1 %2 %p3% %p4% %p5% 3009HT~1%p6%       3009.htm%p7%
%1 %2 %p3% %p4% %p5% 3010HT~1%p6%       3010.htm%p7%
%1 %2 %p3% %p4% %p5% 32768N~1%p6%       32768no.ttf%p7%
%1 %2 %p3% %p4% %p5% 375GIF~1%p6%       375.gif%p7%
%1 %2 %p3% %p4% %p5% 416GIF~1%p6%       416.gif%p7%
%1 %2 %p3% %p4% %p5% 426JPG~1%p6%       426.jpg%p7%
%1 %2 %p3% %p4% %p5% 436GIF~1%p6%       436.gif%p7%
%1 %2 %p3% %p4% %p5% 666GIF~1%p6%       666.gif%p7%
%1 %2 %p3% %p4% %p5% 7HOURS~1%p6%       7hours.ttf%p7%
%1 %2 %p3% %p4% %p5% A0000~10%p6%       a0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~11%p6%       a0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~12%p6%       a0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~13%p6%       a0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~14%p6%       a0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~15%p6%       a0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~16%p6%       a0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~17%p6%       a0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~18%p6%       a0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~19%p6%       a0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~20%p6%       a0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~21%p6%       a0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~22%p6%       a0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~23%p6%       a0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~24%p6%       a0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~25%p6%       a0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~1%p6%       a0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% A00000~2%p6%       a0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% A00000~3%p6%       a0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~4%p6%       a0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~5%p6%       a0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~6%p6%       a0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~7%p6%       a0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~8%p6%       a0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~9%p6%       a0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% ABOUT_~1%p6%       about_fontstyle.htm%p7%
%1 %2 %p3% %p4% %p5% ABOUTH~1%p6%       about.htm%p7%
%1 %2 %p3% %p4% %p5% ACTION~1%p6%       actionj.ttf%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~1%p6%       ADD2CAR_.JPG%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~2%p6%       ADD2CAR0.JPG%p7%
%1 %2 %p3% %p4% %p5% ADD2CA~3%p6%       add2cart.jpg%p7%
%1 %2 %p3% %p4% %p5% ADVP8C~1%p6%       AdvP8ck.DLL%p7%
%1 %2 %p3% %p4% %p5% ADVP9C~1%p6%       AdvP9ck.DLL%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~1%p6%       akFView.cnt%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~2%p6%       akFView.exe%p7%
%1 %2 %p3% %p4% %p5% AKFVIE~3%p6%       akFView.hlp%p7%
%1 %2 %p3% %p4% %p5% ALC5UN~1%p6%       ALC5UNIN.EXE%p7%
%1 %2 %p3% %p4% %p5% ALC6UN~1%p6%       ALC6UNIN.EXE%p7%
%1 %2 %p3% %p4% %p5% ALGICU~1%p6%       ALGICURG.TTF%p7%
%1 %2 %p3% %p4% %p5% AMAZON~1%p6%       amazon.gif%p7%
%1 %2 %p3% %p4% %p5% AMVIEW~1%p6%       amviewer.txt%p7%
%1 %2 %p3% %p4% %p5% AND5OM~1%p6%       AND5OMED.TTF%p7%
%1 %2 %p3% %p4% %p5% AND6OM~1%p6%       AND6OMED.TTF%p7%
%1 %2 %p3% %p4% %p5% ANGSTR~1%p6%       ANGSTROM.TTF%p7%
%1 %2 %p3% %p4% %p5% ANTELO~1%p6%       antelope.ttf%p7%
%1 %2 %p3% %p4% %p5% ANTIBL~1%p6%       antiblue.ttf%p7%
%1 %2 %p3% %p4% %p5% ARC5IT~1%p6%       ARC5ITEX.TTF%p7%
%1 %2 %p3% %p4% %p5% ARC6IT~1%p6%       ARC6ITEX.TTF%p7%
%1 %2 %p3% %p4% %p5% ARIATT~1%p6%       Aria.ttf%p7%
%1 %2 %p3% %p4% %p5% ATMDLL~1%p6%       ATMDLL.DLL%p7%
%1 %2 %p3% %p4% %p5% B0000~10%p6%       b0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~11%p6%       b0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~12%p6%       b0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~13%p6%       b0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~14%p6%       b0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~15%p6%       b0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~16%p6%       b0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~17%p6%       b0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~18%p6%       b0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~19%p6%       b0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~20%p6%       b0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~21%p6%       b0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% B0000~22%p6%       b0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~1%p6%       b0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% B00000~2%p6%       b0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% B00000~3%p6%       b0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~4%p6%       b0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~5%p6%       b0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~6%p6%       b0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~7%p6%       b0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~8%p6%       b0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% B00000~9%p6%       b0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% BACKGR~1%p6%       background_about.htm%p7%
%1 %2 %p3% %p4% %p5% BAD5IL~1%p6%       BAD5ILMS.TTF%p7%
%1 %2 %p3% %p4% %p5% BAD6IL~1%p6%       BAD6ILMS.TTF%p7%
%1 %2 %p3% %p4% %p5% BAR5TT~1%p6%       BAR5.TTF%p7%
%1 %2 %p3% %p4% %p5% BAR6TT~1%p6%       BAR6.TTF%p7%
%1 %2 %p3% %p4% %p5% BARCOD~1%p6%       "Barcode EAN 13.xls%p7%"
%1 %2 %p3% %p4% %p5% BATCH_~1%p6%       batch_create.htm%p7%
%1 %2 %p3% %p4% %p5% BBORON~1%p6%       bboron.ttf%p7%
%1 %2 %p3% %p4% %p5% BCFEXE~1%p6%       bcf.exe%p7%
%1 %2 %p3% %p4% %p5% BER5TT~1%p6%       BER5.TTF%p7%
%1 %2 %p3% %p4% %p5% BER6TT~1%p6%       BER6.TTF%p7%
%1 %2 %p3% %p4% %p5% BLA5KA~1%p6%       BLA5KADD.TTF%p7%
%1 %2 %p3% %p4% %p5% BLA6KA~1%p6%       BLA6KADD.TTF%p7%
%1 %2 %p3% %p4% %p5% BLACKA~1%p6%       BlackAndWhite.sty%p7%
%1 %2 %p3% %p4% %p5% BLUE_O~1%p6%       blue_outline.sty%p7%
%1 %2 %p3% %p4% %p5% BLURST~1%p6%       blur.sty%p7%
%1 %2 %p3% %p4% %p5% BMP1ST~1%p6%       Bmp1.sty%p7%
%1 %2 %p3% %p4% %p5% BONZAI~1%p6%       BONZAI.TTF%p7%
%1 %2 %p3% %p4% %p5% BOO6WA~1%p6%       BOO6WARE.DOC%p7%
%1 %2 %p3% %p4% %p5% BOR59T~1%p6%       BOR59.TTF%p7%
%1 %2 %p3% %p4% %p5% BOR69T~1%p6%       BOR69.TTF%p7%
%1 %2 %p3% %p4% %p5% BOX_TI~1%p6%       box_title.din%p7%
%1 %2 %p3% %p4% %p5% BOX_TI~2%p6%       box_title2.din%p7%
%1 %2 %p3% %p4% %p5% BTTSOI~1%p6%       BTTSOIEF.TTF%p7%
%1 %2 %p3% %p4% %p5% BUC5AN~1%p6%       BUC5ANEE.TTF%p7%
%1 %2 %p3% %p4% %p5% BUC6AN~1%p6%       BUC6ANEE.TTF%p7%
%1 %2 %p3% %p4% %p5% BUGSRE~1%p6%       BugsReport.%p7%
%1 %2 %p3% %p4% %p5% BUGSUB~1%p6%       bugsubmit.txt%p7%
%1 %2 %p3% %p4% %p5% BULLET~1%p6%       Bulletin_about.htm%p7%
%1 %2 %p3% %p4% %p5% BUMPED~1%p6%       bumped.sty%p7%
%1 %2 %p3% %p4% %p5% BUTTON~1%p6%       buttonize.htm%p7%
%1 %2 %p3% %p4% %p5% C0000~10%p6%       c0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~11%p6%       c0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~12%p6%       c0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~13%p6%       c0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~14%p6%       c0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~15%p6%       c0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~16%p6%       c0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~17%p6%       c0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% C0000~18%p6%       c0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~1%p6%       c0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% C00000~2%p6%       c0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% C00000~3%p6%       c0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~4%p6%       c0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~5%p6%       c0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~6%p6%       c0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~7%p6%       c0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~8%p6%       c0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% C00000~9%p6%       c0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% CAMBIO~1%p6%       Cambios.txt%p7%
%1 %2 %p3% %p4% %p5% CEL5IC~1%p6%       CEL5ICHD.TTF%p7%
%1 %2 %p3% %p4% %p5% CEL6IC~1%p6%       CEL6ICHD.TTF%p7%
%1 %2 %p3% %p4% %p5% CHANGE~1%p6%       Changes.%p7%
%1 %2 %p3% %p4% %p5% CHANGE~2%p6%       Changes.txt%p7%
%1 %2 %p3% %p4% %p5% CHANGE~3%p6%       CHANGES_.TXT%p7%
%1 %2 %p3% %p4% %p5% CHARAC~1%p6%       Characteristica3.0%p7%
%1 %2 %p3% %p4% %p5% CHARSG~1%p6%       chars.gif%p7%
%1 %2 %p3% %p4% %p5% CHECK1~1%p6%       Check1.gif%p7%
%1 %2 %p3% %p4% %p5% CHECK3~1%p6%       Check3.gif%p7%
%1 %2 %p3% %p4% %p5% CHOAKD~1%p6%       choak.din%p7%
%1 %2 %p3% %p4% %p5% CHRIST~1%p6%       christmas.din%p7%
%1 %2 %p3% %p4% %p5% CHRIST~2%p6%       christmas.sty%p7%
%1 %2 %p3% %p4% %p5% CLI5KM~1%p6%       CLI5KME.EXE%p7%
%1 %2 %p3% %p4% %p5% CLI6KM~1%p6%       CLI6KME.EXE%p7%
%1 %2 %p3% %p4% %p5% CODONT~1%p6%       codon.ttf%p7%
%1 %2 %p3% %p4% %p5% COI5ED~1%p6%       COI5ED.TTF%p7%
%1 %2 %p3% %p4% %p5% COI6ED~1%p6%       COI6ED.TTF%p7%
%1 %2 %p3% %p4% %p5% COLOPH~1%p6%       colophon.ttf%p7%
%1 %2 %p3% %p4% %p5% COMBN_~1%p6%       COMBN___.PFB%p7%
%1 %2 %p3% %p4% %p5% COMBN_~2%p6%       COMBN___.PFM%p7%
%1 %2 %p3% %p4% %p5% COMBN_~3%p6%       COMBN___.TTF%p7%
%1 %2 %p3% %p4% %p5% COMBNS~1%p6%       COMBNS__.PFB%p7%
%1 %2 %p3% %p4% %p5% COMBNS~2%p6%       COMBNS__.PFM%p7%
%1 %2 %p3% %p4% %p5% COMBNS~3%p6%       COMBNS__.TTF%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG32.OC_%p7%
%1 %2 %p3% %p4% %p5% CONSTA~1%p6%       constant.ttf%p7%
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       contents.htm%p7%
%1 %2 %p3% %p4% %p5% CONTEN~2%p6%       contents_txt.htm%p7%
%1 %2 %p3% %p4% %p5% COREC0~1%p6%       corec0mp.ini%p7%
%1 %2 %p3% %p4% %p5% COREC1~1%p6%       corec1mp.ini%p7%
%1 %2 %p3% %p4% %p5% COREC2~1%p6%       corec2mp.ini%p7%
%1 %2 %p3% %p4% %p5% COREC3~1%p6%       corec3mp.ini%p7%
%1 %2 %p3% %p4% %p5% COREC4~1%p6%       corec4mp.ini%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       corecomp.ini%p7%
%1 %2 %p3% %p4% %p5% COSINE~1%p6%       cosinek.ttf%p7%
%1 %2 %p3% %p4% %p5% COVERG~1%p6%       cover.gif%p7%
%1 %2 %p3% %p4% %p5% CTL3D0~1%p6%       CTL3D02.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D1~1%p6%       CTL3D12.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D2~1%p6%       CTL3D22.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       ctl3d32.dl_%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~2%p6%       CTL3D32.DLL%p7%
%1 %2 %p3% %p4% %p5% CTL3D4~1%p6%       CTL3D42.DLL%p7%
%1 %2 %p3% %p4% %p5% CUN5IF~1%p6%       CUN5IFOR.TTF%p7%
%1 %2 %p3% %p4% %p5% CUN6IF~1%p6%       CUN6IFOR.TTF%p7%
%1 %2 %p3% %p4% %p5% CW3215~1%p6%       CW3215.DLL%p7%
%1 %2 %p3% %p4% %p5% CWISDO~1%p6%       cwisdom.ttf%p7%
%1 %2 %p3% %p4% %p5% D0000~10%p6%       d0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~11%p6%       d0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~12%p6%       d0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~13%p6%       d0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~14%p6%       d0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~15%p6%       d0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~16%p6%       d0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~17%p6%       d0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~18%p6%       d0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~19%p6%       d0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~20%p6%       d0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~21%p6%       d0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~22%p6%       d0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~23%p6%       d0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~24%p6%       d0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~25%p6%       d0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~26%p6%       d0000024.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~27%p6%       d0000025.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~28%p6%       d0000026.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~29%p6%       d0000027.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~30%p6%       d0000028.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~31%p6%       d0000029.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~32%p6%       d0000030.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~33%p6%       d0000031.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~34%p6%       d0000032.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~35%p6%       d0000033.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~36%p6%       d0000034.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~37%p6%       d0000035.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~38%p6%       d0000036.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~39%p6%       d0000037.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~40%p6%       d0000038.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~41%p6%       d0000039.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~42%p6%       d0000040.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~43%p6%       d0000041.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~44%p6%       d0000042.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~1%p6%       d0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% D00000~2%p6%       d0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% D00000~3%p6%       d0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~4%p6%       d0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~5%p6%       d0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~6%p6%       d0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~7%p6%       d0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~8%p6%       d0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~9%p6%       d0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% DARK1S~1%p6%       Dark1.sty%p7%
%1 %2 %p3% %p4% %p5% DATATA~1%p6%       DATA.TAG%p7%
%1 %2 %p3% %p4% %p5% DAVIST~1%p6%       davis.ttf%p7%
%1 %2 %p3% %p4% %p5% DELPRG~1%p6%       DELPRG__.PFB%p7%
%1 %2 %p3% %p4% %p5% DELPRG~2%p6%       DELPRG__.PFM%p7%
%1 %2 %p3% %p4% %p5% DELPRG~3%p6%       DELPRG__.TTF%p7%
%1 %2 %p3% %p4% %p5% DINGBA~1%p6%       dingbat.exe%p7%
%1 %2 %p3% %p4% %p5% DISK1_~1%p6%       DISK1_.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~2%p6%       DISK1_1.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~3%p6%       DISK1_3.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1_~4%p6%       DISK1_O.ID%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1.ID%p7%
%1 %2 %p3% %p4% %p5% DISTTF~1%p6%       dis.ttf%p7%
%1 %2 %p3% %p4% %p5% DLGIM0~1%p6%       DLGIM0GE.BMP%p7%
%1 %2 %p3% %p4% %p5% DLGIM2~1%p6%       DLGIM2GE.BMP%p7%
%1 %2 %p3% %p4% %p5% DLGIM4~1%p6%       DLGIM4GE.BMP%p7%
%1 %2 %p3% %p4% %p5% DOC5ME~1%p6%       DOC5MENT.ICN%p7%
%1 %2 %p3% %p4% %p5% DOCTOR~1%p6%       DoctorAz.ttf%p7%
%1 %2 %p3% %p4% %p5% DONNER~1%p6%       donner.ttf%p7%
%1 %2 %p3% %p4% %p5% DOR5LA~1%p6%       DOR5LA__.TTF%p7%
%1 %2 %p3% %p4% %p5% DOR6LA~1%p6%       DOR6LA__.TTF%p7%
%1 %2 %p3% %p4% %p5% DOUBLE~1%p6%       double.gif%p7%
%1 %2 %p3% %p4% %p5% DOVEST~1%p6%       DOVES.TTF%p7%
%1 %2 %p3% %p4% %p5% DROPSH~1%p6%       dropshadow.htm%p7%
%1 %2 %p3% %p4% %p5% DUE5TT~1%p6%       DUE5.TTF%p7%
%1 %2 %p3% %p4% %p5% DUE6TT~1%p6%       DUE6.TTF%p7%
%1 %2 %p3% %p4% %p5% DWORRY~1%p6%       dworry.din%p7%
%1 %2 %p3% %p4% %p5% DYSPRO~1%p6%       dyspro.ttf%p7%
%1 %2 %p3% %p4% %p5% E0000~10%p6%       e0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~11%p6%       e0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~12%p6%       e0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~13%p6%       e0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~14%p6%       e0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~15%p6%       e0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~16%p6%       e0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~17%p6%       e0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~18%p6%       e0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~19%p6%       e0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~1%p6%       e0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% E00000~2%p6%       e0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% E00000~3%p6%       e0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~4%p6%       e0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~5%p6%       e0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~6%p6%       e0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~7%p6%       e0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~8%p6%       e0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~9%p6%       e0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% EAN-13~1%p6%       EAN-13.TTF%p7%
%1 %2 %p3% %p4% %p5% EAN-13~2%p6%       EAN-13B.TTF%p7%
%1 %2 %p3% %p4% %p5% EAN-13~3%p6%       EAN-13BH.TTF%p7%
%1 %2 %p3% %p4% %p5% EAN-13~4%p6%       EAN-13HH.TTF%p7%
%1 %2 %p3% %p4% %p5% EAN13D~1%p6%       ean13.doc%p7%
%1 %2 %p3% %p4% %p5% EDGEGI~1%p6%       edge.gif%p7%
%1 %2 %p3% %p4% %p5% EDIT_S~1%p6%       edit_style.html%p7%
%1 %2 %p3% %p4% %p5% ELDER4~1%p6%       ELDER4.TTF%p7%
%1 %2 %p3% %p4% %p5% EPILOG~1%p6%       epilog.ttf%p7%
%1 %2 %p3% %p4% %p5% ESPDLL~1%p6%       esp.dll%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~1%p6%       example.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~2%p6%       example1.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~3%p6%       example2.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~4%p6%       example3.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~5%p6%       example4.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~6%p6%       example5.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~7%p6%       example6.htm%p7%
%1 %2 %p3% %p4% %p5% EXAMPL~8%p6%       example7.htm%p7%
%1 %2 %p3% %p4% %p5% EXMONO~1%p6%       EXMONO.TTF%p7%
%1 %2 %p3% %p4% %p5% F0000~10%p6%       f0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~11%p6%       f0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~12%p6%       f0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~13%p6%       f0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~14%p6%       f0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~15%p6%       f0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~16%p6%       f0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~17%p6%       f0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~18%p6%       f0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% F0000~19%p6%       f0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~1%p6%       f0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% F00000~2%p6%       f0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% F00000~3%p6%       f0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~4%p6%       f0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~5%p6%       f0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~6%p6%       f0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~7%p6%       f0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~8%p6%       f0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% F00000~9%p6%       f0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% FARADA~1%p6%       faraday.ttf%p7%
%1 %2 %p3% %p4% %p5% FC11BM~1%p6%       fc11.bmp%p7%
%1 %2 %p3% %p4% %p5% FCP3EX~1%p6%       fcp3.exe%p7%
%1 %2 %p3% %p4% %p5% FDFDFD~1%p6%       fdfdfd.sty%p7%
%1 %2 %p3% %p4% %p5% FILE_~10%p6%       FILE_IDP.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_~11%p6%       FILE_IDS.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_~12%p6%       FILE_IDT.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_~13%p6%       FILE_IDU.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_~14%p6%       FILE_IDW.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_~15%p6%       FILE_IDZ.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_ID4.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_ID8.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~4%p6%       FILE_IDH.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~5%p6%       FILE_IDI.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~6%p6%       FILE_IDJ.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~7%p6%       FILE_IDK.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~8%p6%       FILE_IDM.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~9%p6%       FILE_IDO.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILEDE~1%p6%       filedesc.diz%p7%
%1 %2 %p3% %p4% %p5% FMDLLD~1%p6%       fmdll.dll%p7%
%1 %2 %p3% %p4% %p5% FMHLP~1%p6%        FM.HLP%p7%
%1 %2 %p3% %p4% %p5% FN238I~1%p6%       FN238.INF%p7%
%1 %2 %p3% %p4% %p5% FOG_LI~1%p6%       fog_light.sty%p7%
%1 %2 %p3% %p4% %p5% FOG2ST~1%p6%       Fog2.sty%p7%
%1 %2 %p3% %p4% %p5% FON5RA~1%p6%       FON5RANG.EXE%p7%
%1 %2 %p3% %p4% %p5% FON6RA~1%p6%       FON6RANG.DOC%p7%
%1 %2 %p3% %p4% %p5% FON6RA~2%p6%       FON6RANG.EXE%p7%
%1 %2 %p3% %p4% %p5% FON6RA~3%p6%       FON6RANG.HLP%p7%
%1 %2 %p3% %p4% %p5% FONT7R~1%p6%       Font7rax.cnt%p7%
%1 %2 %p3% %p4% %p5% FONT7R~2%p6%       Font7rax.exe%p7%
%1 %2 %p3% %p4% %p5% FONT7R~3%p6%       Font7rax.hlp%p7%
%1 %2 %p3% %p4% %p5% FONT7R~4%p6%       Font7rax.url%p7%
%1 %2 %p3% %p4% %p5% FONT8A~1%p6%       FONT8A~1.EXE%p7%
%1 %2 %p3% %p4% %p5% FONTCE~1%p6%       "Font C.exe%p7%"
%1 %2 %p3% %p4% %p5% FONTCO~1%p6%       Fontcomp.exe%p7%
%1 %2 %p3% %p4% %p5% FONTCO~2%p6%       FontCompare.hlp%p7%
%1 %2 %p3% %p4% %p5% FONTCP~1%p6%       fontcp10.txt%p7%
%1 %2 %p3% %p4% %p5% FONTDR~1%p6%       Fontdraw.exe%p7%
%1 %2 %p3% %p4% %p5% FONTEX~1%p6%       FontExpert.cnt%p7%
%1 %2 %p3% %p4% %p5% FONTEX~2%p6%       FontExpert.exe%p7%
%1 %2 %p3% %p4% %p5% FONTEX~3%p6%       FontExpert.hlp%p7%
%1 %2 %p3% %p4% %p5% FONTEX~4%p6%       FontExpertRus.dll%p7%
%1 %2 %p3% %p4% %p5% FONTFI~1%p6%       fontfind.exe%p7%
%1 %2 %p3% %p4% %p5% FONTIM~1%p6%       FontImpressions.exe%p7%
%1 %2 %p3% %p4% %p5% FONTIM~2%p6%       FONTIMPRESSIONS.HLP%p7%
%1 %2 %p3% %p4% %p5% FONTLI~1%p6%       FONTLIBRAR_.JPG%p7%
%1 %2 %p3% %p4% %p5% FONTLI~2%p6%       FONTLIBRAR0.JPG%p7%
%1 %2 %p3% %p4% %p5% FONTLI~3%p6%       fontlibrary.jpg%p7%
%1 %2 %p3% %p4% %p5% FONTPE~1%p6%       fontpeep.txt%p7%
%1 %2 %p3% %p4% %p5% FONTR2~1%p6%       fontr202.xml%p7%
%1 %2 %p3% %p4% %p5% FONTRA~1%p6%       FONTRAN_.EXE%p7%
%1 %2 %p3% %p4% %p5% FONTRA~2%p6%       fontrang.exe%p7%
%1 %2 %p3% %p4% %p5% FONTT3~1%p6%       FontT32.exe%p7%
%1 %2 %p3% %p4% %p5% FONTVI~1%p6%       FontViewer.exe%p7%
%1 %2 %p3% %p4% %p5% FRESNE~1%p6%       fresnel.ttf%p7%
%1 %2 %p3% %p4% %p5% FRIDAY~1%p6%       friday.din%p7%
%1 %2 %p3% %p4% %p5% FT2070~1%p6%       FT20701.INF%p7%
%1 %2 %p3% %p4% %p5% FUNFON~1%p6%       funfonts_lg.jpg%p7%
%1 %2 %p3% %p4% %p5% G_RGIF~1%p6%       G_r.gif%p7%
%1 %2 %p3% %p4% %p5% G0000~10%p6%       g0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~11%p6%       g0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~12%p6%       g0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~13%p6%       g0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~14%p6%       g0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~15%p6%       g0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~16%p6%       g0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~17%p6%       g0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~18%p6%       g0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~19%p6%       g0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% G0000~20%p6%       g0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~1%p6%       g0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% G00000~2%p6%       g0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% G00000~3%p6%       g0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~4%p6%       g0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~5%p6%       g0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~6%p6%       g0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~7%p6%       g0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~8%p6%       g0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% G00000~9%p6%       g0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% GEBANN~1%p6%       GEBANNER.TTF%p7%
%1 %2 %p3% %p4% %p5% GECLIP~1%p6%       GECLIPZ_.TTF%p7%
%1 %2 %p3% %p4% %p5% GECOME~1%p6%       GECOMEDY.TTF%p7%
%1 %2 %p3% %p4% %p5% GECURV~1%p6%       GECURVIT.TTF%p7%
%1 %2 %p3% %p4% %p5% GEELS_~1%p6%       GEELS___.TTF%p7%
%1 %2 %p3% %p4% %p5% GEFIM_~1%p6%       GEFIM___.TTF%p7%
%1 %2 %p3% %p4% %p5% GEFLEE~1%p6%       GEFLEET_.TTF%p7%
%1 %2 %p3% %p4% %p5% GEFRF_~1%p6%       GEFRF___.TTF%p7%
%1 %2 %p3% %p4% %p5% GEFRIL~1%p6%       GEFRILLS.TTF%p7%
%1 %2 %p3% %p4% %p5% GEGLOB~1%p6%       GEGLOB__.TTF%p7%
%1 %2 %p3% %p4% %p5% GEHAS_~1%p6%       GEHAS___.TTF%p7%
%1 %2 %p3% %p4% %p5% GEMONT~1%p6%       GEMONTAG.TTF%p7%
%1 %2 %p3% %p4% %p5% GENET_~1%p6%       GENET___.TTF%p7%
%1 %2 %p3% %p4% %p5% GEODES~1%p6%       geodesic.ttf%p7%
%1 %2 %p3% %p4% %p5% GERMST~1%p6%       germs.ttf%p7%
%1 %2 %p3% %p4% %p5% GEROMA~1%p6%       GEROMANE.TTF%p7%
%1 %2 %p3% %p4% %p5% GESHS_~1%p6%       GESHS___.TTF%p7%
%1 %2 %p3% %p4% %p5% GETTIN~1%p6%       GettingStarted.htm%p7%
%1 %2 %p3% %p4% %p5% GMTTTF~1%p6%       gmt.ttf%p7%
%1 %2 %p3% %p4% %p5% GOLDAN~1%p6%       "gold and leaf.din%p7%"
%1 %2 %p3% %p4% %p5% GOLDST~1%p6%       Gold.sty%p7%
%1 %2 %p3% %p4% %p5% GOODMO~1%p6%       goodmorning.din%p7%
%1 %2 %p3% %p4% %p5% GRADAT~1%p6%       gradation1.sty%p7%
%1 %2 %p3% %p4% %p5% GRASSS~1%p6%       Grass.sty%p7%
%1 %2 %p3% %p4% %p5% GREENG~1%p6%       greengreen.din%p7%
%1 %2 %p3% %p4% %p5% GUIDET~1%p6%       guide.txt%p7%
%1 %2 %p3% %p4% %p5% GUILDO~1%p6%       guildof.ttf%p7%
%1 %2 %p3% %p4% %p5% GWP5EB~1%p6%       GWP5EB.EXE%p7%
%1 %2 %p3% %p4% %p5% H0000~10%p6%       h0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~11%p6%       h0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~12%p6%       h0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~13%p6%       h0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~14%p6%       h0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~15%p6%       h0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~16%p6%       h0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~17%p6%       h0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~18%p6%       h0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~19%p6%       h0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~20%p6%       h0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~21%p6%       h0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~22%p6%       h0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~23%p6%       h0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~24%p6%       h0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~25%p6%       h0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~26%p6%       h0000024.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~27%p6%       h0000025.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~28%p6%       h0000026.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~29%p6%       h0000027.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~30%p6%       h0000028.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~31%p6%       h0000029.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~32%p6%       h0000030.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~33%p6%       h0000031.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~34%p6%       h0000032.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~35%p6%       h0000033.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~36%p6%       h0000034.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~37%p6%       h0000035.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~38%p6%       h0000036.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~39%p6%       h0000037.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~40%p6%       h0000038.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~41%p6%       h0000039.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~42%p6%       h0000040.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~43%p6%       h0000041.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~44%p6%       h0000042.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~45%p6%       h0000043.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~46%p6%       h0000044.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~47%p6%       h0000045.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~48%p6%       h0000046.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~49%p6%       h0000047.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~50%p6%       h0000048.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~51%p6%       h0000049.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~52%p6%       h0000050.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~53%p6%       h0000051.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~54%p6%       h0000052.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~55%p6%       h0000053.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~56%p6%       h0000054.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~57%p6%       h0000055.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~58%p6%       h0000056.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~59%p6%       h0000057.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~60%p6%       h0000058.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~61%p6%       h0000059.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~62%p6%       h0000060.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~63%p6%       h0000061.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~64%p6%       h0000062.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~65%p6%       h0000063.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~66%p6%       h0000064.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~67%p6%       h0000065.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~68%p6%       h0000066.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~69%p6%       h0000067.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~70%p6%       h0000068.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~71%p6%       h0000069.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~72%p6%       h0000070.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~73%p6%       h0000071.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~74%p6%       h0000072.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~75%p6%       h0000073.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~76%p6%       h0000074.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~77%p6%       h0000075.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~78%p6%       h0000076.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~79%p6%       h0000077.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~80%p6%       h0000078.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~81%p6%       h0000079.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~82%p6%       h0000080.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~83%p6%       h0000081.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~84%p6%       h0000082.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~85%p6%       h0000083.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~86%p6%       h0000084.EWI%p7%
%1 %2 %p3% %p4% %p5% H0000~87%p6%       h0000085.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~1%p6%       h0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% H00000~2%p6%       h0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% H00000~3%p6%       h0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~4%p6%       h0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~5%p6%       h0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~6%p6%       h0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~7%p6%       h0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~8%p6%       h0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% H00000~9%p6%       h0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% HAN_PA~1%p6%       han_paper.din%p7%
%1 %2 %p3% %p4% %p5% HAYDEN~1%p6%       hayden.gif%p7%
%1 %2 %p3% %p4% %p5% HEADAC~1%p6%       headache.ttf%p7%
%1 %2 %p3% %p4% %p5% HEADLI~1%p6%       headlinefonts_lg.jpg%p7%
%1 %2 %p3% %p4% %p5% HISTOR~1%p6%       history.txt%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~1%p6%       homebar.jpg%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~2%p6%       HOMEBAR_.JPG%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~3%p6%       HOMEBAR0.JPG%p7%
%1 %2 %p3% %p4% %p5% HOWTO_~1%p6%       howto_make_fontstyle.htm%p7%
%1 %2 %p3% %p4% %p5% HTM50~10%p6%       HTM50070.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~11%p6%       HTM50071.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~12%p6%       HTM50072.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~13%p6%       HTM50073.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~14%p6%       HTM50074.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~15%p6%       HTM50075.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM50~16%p6%       HTM50076.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM50~17%p6%       HTM50077.JPG%p7%
%1 %2 %p3% %p4% %p5% HTM500~1%p6%       HTM50000.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~2%p6%       HTM50001.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~3%p6%       HTM50002.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~4%p6%       HTM50031.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~5%p6%       HTM50032.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~6%p6%       HTM50033.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~7%p6%       HTM50039.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~8%p6%       HTM50059.GIF%p7%
%1 %2 %p3% %p4% %p5% HTM500~9%p6%       HTM50060.JPG%p7%
%1 %2 %p3% %p4% %p5% HYDROG~1%p6%       hydrogen.ttf%p7%
%1 %2 %p3% %p4% %p5% I2OF5N~1%p6%       I2OF5NT.TTF%p7%
%1 %2 %p3% %p4% %p5% I2OF5T~1%p6%       I2OF5.TTF%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~1%p6%       ic_JFont.gif%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~2%p6%       ic_JFont_Editor.gif%p7%
%1 %2 %p3% %p4% %p5% IC_JFO~3%p6%       ic_JFont_Reference.gif%p7%
%1 %2 %p3% %p4% %p5% ICON2S~1%p6%       Icon2.sty%p7%
%1 %2 %p3% %p4% %p5% ICON3D~1%p6%       icon3.din%p7%
%1 %2 %p3% %p4% %p5% ICON4D~1%p6%       icon4.din%p7%
%1 %2 %p3% %p4% %p5% ICON5D~1%p6%       icon5.din%p7%
%1 %2 %p3% %p4% %p5% ICON6D~1%p6%       icon6.din%p7%
%1 %2 %p3% %p4% %p5% ICONST~1%p6%       Icon.sty%p7%
%1 %2 %p3% %p4% %p5% IMAGE~10%p6%       Image18.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE~11%p6%       Image19.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE~12%p6%       Image28.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE~13%p6%       Image29.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE~14%p6%       Image38.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE~15%p6%       Image39.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~1%p6%       Image1.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~2%p6%       Image10.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~3%p6%       Image11.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~4%p6%       Image12.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~5%p6%       Image13.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~6%p6%       Image14.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~7%p6%       Image15.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~8%p6%       Image16.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE1~9%p6%       Image17.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~1%p6%       Image2.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~2%p6%       Image20.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~3%p6%       Image21.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~4%p6%       Image22.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~5%p6%       Image23.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~6%p6%       Image24.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~7%p6%       Image25.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~8%p6%       Image26.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE2~9%p6%       Image27.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~1%p6%       Image3.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~2%p6%       Image30.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~3%p6%       Image31.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~4%p6%       Image32.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~5%p6%       Image33.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~6%p6%       Image34.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~7%p6%       Image35.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~8%p6%       Image36.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE3~9%p6%       Image37.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE4~1%p6%       Image4.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE5~1%p6%       Image5.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE6~1%p6%       Image6.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE7~1%p6%       Image7.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE8~1%p6%       Image8.gif%p7%
%1 %2 %p3% %p4% %p5% IMAGE9~1%p6%       Image9.gif%p7%
%1 %2 %p3% %p4% %p5% IND5DR~1%p6%       IND5DROM.HTM%p7%
%1 %2 %p3% %p4% %p5% INITIA~1%p6%       initial.ttf%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       install.txt%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTALL_.TXT%p7%
%1 %2 %p3% %p4% %p5% INSTAL~3%p6%       INSTALL0.TXT%p7%
%1 %2 %p3% %p4% %p5% INSTAL~4%p6%       INSTALLFONT_.HTM%p7%
%1 %2 %p3% %p4% %p5% INSTAL~5%p6%       INSTALLFONT0.HTM%p7%
%1 %2 %p3% %p4% %p5% INSTAL~6%p6%       installfonts.htm%p7%
%1 %2 %p3% %p4% %p5% ISUNIN~1%p6%       IsUninst.Exe%p7%
%1 %2 %p3% %p4% %p5% JFONTE~1%p6%       JFont.exe%p7%
%1 %2 %p3% %p4% %p5% JFONTJ~1%p6%       JFont.jar%p7%
%1 %2 %p3% %p4% %p5% JOBS32~1%p6%       jobs32.exe%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~1%p6%       jobspec.hlp%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~2%p6%       JobSpec.ini%p7%
%1 %2 %p3% %p4% %p5% JOBSPE~3%p6%       jobspecs.hlp%p7%
%1 %2 %p3% %p4% %p5% JSPEC4~1%p6%       jspec42a.BMP%p7%
%1 %2 %p3% %p4% %p5% KANONT~1%p6%       Kanon.ttf%p7%
%1 %2 %p3% %p4% %p5% LANGDA~1%p6%       lang.dat%p7%
%1 %2 %p3% %p4% %p5% LAYOUT~1%p6%       layout.bin%p7%
%1 %2 %p3% %p4% %p5% LEAFAN~1%p6%       "leaf and letter.din%p7%"
%1 %2 %p3% %p4% %p5% LEEMET~1%p6%       Leeme.txt%p7%
%1 %2 %p3% %p4% %p5% LEFTBA~1%p6%       Leftback.gif%p7%
%1 %2 %p3% %p4% %p5% LEG5LD~1%p6%       LEG5LDOG.HTM%p7%
%1 %2 %p3% %p4% %p5% LEG6LD~1%p6%       LEG6LDOG.DOC%p7%
%1 %2 %p3% %p4% %p5% LEVITY~1%p6%       levity.ttf%p7%
%1 %2 %p3% %p4% %p5% LEXOTT~1%p6%       lexo.ttf%p7%
%1 %2 %p3% %p4% %p5% LIC5NS~1%p6%       LIC5NSE.TXT%p7%
%1 %2 %p3% %p4% %p5% LIC6NS~1%p6%       LIC6NSE.TXT%p7%
%1 %2 %p3% %p4% %p5% LICEN1~1%p6%       licen1e.txt%p7%
%1 %2 %p3% %p4% %p5% LICEN2~1%p6%       licen2eagreement.txt%p7%
%1 %2 %p3% %p4% %p5% LICEN4~1%p6%       Licen4e.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       licens__.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       License.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       LICENSE_.TXT%p7%
%1 %2 %p3% %p4% %p5% LICENS~4%p6%       License_r.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~5%p6%       LICENSE0.TXT%p7%
%1 %2 %p3% %p4% %p5% LICENS~6%p6%       LICENSE2.TXT%p7%
%1 %2 %p3% %p4% %p5% LICENS~7%p6%       LICENSEN.TXT%p7%
%1 %2 %p3% %p4% %p5% LICENS~8%p6%       LICENSEZ.TXT%p7%
%1 %2 %p3% %p4% %p5% LIGHT_~1%p6%       light_check.sty%p7%
%1 %2 %p3% %p4% %p5% LIGHT_~2%p6%       light_cross.din%p7%
%1 %2 %p3% %p4% %p5% LIGHT1~1%p6%       Light1.sty%p7%
%1 %2 %p3% %p4% %p5% LIGHT2~1%p6%       Light2.sty%p7%
%1 %2 %p3% %p4% %p5% LINEAR~1%p6%       linear.ttf%p7%
%1 %2 %p3% %p4% %p5% LINEAR~2%p6%       linear_gradient.htm%p7%
%1 %2 %p3% %p4% %p5% LISTFO~1%p6%       ListFonts.exe%p7%
%1 %2 %p3% %p4% %p5% LOGO3B~1%p6%       logo3.bmp%p7%
%1 %2 %p3% %p4% %p5% MAILT3~1%p6%       mailt31.xml%p7%
%1 %2 %p3% %p4% %p5% MAILTA~1%p6%       MailTalkX.exe%p7%
%1 %2 %p3% %p4% %p5% MAINHT~1%p6%       main.htm%p7%
%1 %2 %p3% %p4% %p5% MAN5AL~1%p6%       MAN5AL.HTM%p7%
%1 %2 %p3% %p4% %p5% MANUAL~1%p6%       MANUAL.DOC%p7%
%1 %2 %p3% %p4% %p5% MANUAL~2%p6%       MANUAL.TXT%p7%
%1 %2 %p3% %p4% %p5% MAR5HA~1%p6%       MAR5HALL.TTF%p7%
%1 %2 %p3% %p4% %p5% MAR6HA~1%p6%       MAR6HALL.TTF%p7%
%1 %2 %p3% %p4% %p5% MAYQUE~1%p6%       MAYQUEEN.TTF%p7%
%1 %2 %p3% %p4% %p5% MELANI~1%p6%       melanie.ttf%p7%
%1 %2 %p3% %p4% %p5% MENA00~1%p6%       Mena0001.doc%p7%
%1 %2 %p3% %p4% %p5% MENA00~2%p6%       Mena0001.ttf%p7%
%1 %2 %p3% %p4% %p5% MENA00~3%p6%       Mena0001.txt%p7%
%1 %2 %p3% %p4% %p5% MESSAG~1%p6%       message.jpg%p7%
%1 %2 %p3% %p4% %p5% MESSAG~2%p6%       message_about.htm%p7%
%1 %2 %p3% %p4% %p5% MF359I~1%p6%       MF359.INF%p7%
%1 %2 %p3% %p4% %p5% MFC42D~1%p6%       MFC42.DLL%p7%
%1 %2 %p3% %p4% %p5% MGLICE~1%p6%       MGLICENSE.TXT%p7%
%1 %2 %p3% %p4% %p5% MONO7D~1%p6%       Mono7D.ttr%p7%
%1 %2 %p3% %p4% %p5% MONO7D~2%p6%       Mono7DB.ttr%p7%
%1 %2 %p3% %p4% %p5% MONO9D~1%p6%       MONO9D.TTR%p7%
%1 %2 %p3% %p4% %p5% MONO9D~2%p6%       MONO9DB.TTR%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       MSVCRT.DLL%p7%
%1 %2 %p3% %p4% %p5% MVDGIF~1%p6%       mvd.gif%p7%
%1 %2 %p3% %p4% %p5% MYAT7D~1%p6%       MyAT7.dll%p7%
%1 %2 %p3% %p4% %p5% MYAT9D~1%p6%       MYAT9.DLL%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~1%p6%       MYFO9TS.CNT%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~2%p6%       MYFO9TS.EXE%p7%
%1 %2 %p3% %p4% %p5% MYFO9T~3%p6%       MYFO9TS.HLP%p7%
%1 %2 %p3% %p4% %p5% NATLOG~1%p6%       natlog.ttf%p7%
%1 %2 %p3% %p4% %p5% NEON2-~1%p6%       neon2-.din%p7%
%1 %2 %p3% %p4% %p5% NEON2D~1%p6%       neon2.din%p7%
%1 %2 %p3% %p4% %p5% NEONDI~1%p6%       neon.din%p7%
%1 %2 %p3% %p4% %p5% NEW1ST~1%p6%       New1.sty%p7%
%1 %2 %p3% %p4% %p5% NEWGIF~1%p6%       new.gif%p7%
%1 %2 %p3% %p4% %p5% NEXTVE~1%p6%       NextVersion.%p7%
%1 %2 %p3% %p4% %p5% NONBLO~1%p6%       nonblock.ttf%p7%
%1 %2 %p3% %p4% %p5% NOTEGI~1%p6%       note.gif%p7%
%1 %2 %p3% %p4% %p5% NTSTLK~1%p6%       ntstlkr1.gif%p7%
%1 %2 %p3% %p4% %p5% NULLPT~1%p6%       nullp.ttf%p7%
%1 %2 %p3% %p4% %p5% NUMBER~1%p6%       numbers.gif%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       OLEPRO32.DLL%p7%
%1 %2 %p3% %p4% %p5% OMBUDS~1%p6%       OMBUDSMN.TXT%p7%
%1 %2 %p3% %p4% %p5% ORD5RA~1%p6%       ORD5RAUS.EXE%p7%
%1 %2 %p3% %p4% %p5% ORD5RD~1%p6%       ORD5R.DOC%p7%
%1 %2 %p3% %p4% %p5% ORD5RG~1%p6%       ORD5RGBR.EXE%p7%
%1 %2 %p3% %p4% %p5% ORD5RN~1%p6%       ORD5RNOR.EXE%p7%
%1 %2 %p3% %p4% %p5% ORD6RA~1%p6%       ORD6RAUS.EXE%p7%
%1 %2 %p3% %p4% %p5% ORD6RD~1%p6%       ORD6R.DOC%p7%
%1 %2 %p3% %p4% %p5% ORD6RG~1%p6%       ORD6RGBR.EXE%p7%
%1 %2 %p3% %p4% %p5% ORD6RN~1%p6%       ORD6RNOR.EXE%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       orderfunfonts.htm%p7%
%1 %2 %p3% %p4% %p5% ORDERH~1%p6%       orderheadlinefonts.htm%p7%
%1 %2 %p3% %p4% %p5% ORDERS~1%p6%       orderscriptfonts.htm%p7%
%1 %2 %p3% %p4% %p5% ORDERT~1%p6%       ORDER.TXT%p7%
%1 %2 %p3% %p4% %p5% OSDAT~1%p6%        os.dat%p7%
%1 %2 %p3% %p4% %p5% OTH5SO~1%p6%       OTH5SOFT.HTM%p7%
%1 %2 %p3% %p4% %p5% OTH6SO~1%p6%       OTH6SOFT.DOC%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~1%p6%       outline.htm%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~2%p6%       Outline1.sty%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~3%p6%       outline2.sty%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~4%p6%       outline3.sty%p7%
%1 %2 %p3% %p4% %p5% OUTLIN~5%p6%       outline4.sty%p7%
%1 %2 %p3% %p4% %p5% PAD_FI~1%p6%       pad_file.xml%p7%
%1 %2 %p3% %p4% %p5% PAPER_~1%p6%       paper_hole.sty%p7%
%1 %2 %p3% %p4% %p5% PAPER1~1%p6%       Paper1.gif%p7%
%1 %2 %p3% %p4% %p5% PAPER2~1%p6%       Paper2.sty%p7%
%1 %2 %p3% %p4% %p5% PARKFO~1%p6%       PARKFONT.HLP%p7%
%1 %2 %p3% %p4% %p5% PERCHA~1%p6%       perchasing.htm%p7%
%1 %2 %p3% %p4% %p5% PHONTZ~1%p6%       Phontz.DE_%p7%
%1 %2 %p3% %p4% %p5% PHONTZ~2%p6%       Phontz.ex_%p7%
%1 %2 %p3% %p4% %p5% PINBAL~1%p6%       pinball.ttf%p7%
%1 %2 %p3% %p4% %p5% PINK_T~1%p6%       pink_tile.sty%p7%
%1 %2 %p3% %p4% %p5% PINK2S~1%p6%       pink2.sty%p7%
%1 %2 %p3% %p4% %p5% PIZZAD~1%p6%       pizza.din%p7%
%1 %2 %p3% %p4% %p5% PREFIX~1%p6%       prefix.ttf%p7%
%1 %2 %p3% %p4% %p5% PRESSE~1%p6%       Pressed1.sty%p7%
%1 %2 %p3% %p4% %p5% PROTER~1%p6%       PROTERON.TTF%p7%
%1 %2 %p3% %p4% %p5% PSSETU~1%p6%       pssetup.exe%p7%
%1 %2 %p3% %p4% %p5% PSSETU~2%p6%       pssetup.inf%p7%
%1 %2 %p3% %p4% %p5% PSSETU~3%p6%       pssetupeng.dll%p7%
%1 %2 %p3% %p4% %p5% PUPLE1~1%p6%       Puple1.sty%p7%
%1 %2 %p3% %p4% %p5% PVFP32~1%p6%       pvfp3220.exe%p7%
%1 %2 %p3% %p4% %p5% PVSHA4~1%p6%       pvsha4e.dll%p7%
%1 %2 %p3% %p4% %p5% RANSOM~1%p6%       ransom.ttf%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       "Readme English.txt%p7%"
%1 %2 %p3% %p4% %p5% READM~11%p6%       "Readme Franais.txt%p7%"
%1 %2 %p3% %p4% %p5% READM~12%p6%       "Readme Magyar.txt%p7%"
%1 %2 %p3% %p4% %p5% READM~13%p6%       README_.DOC%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       README_.RTF%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       ReadMe__.txt%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       README_0.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       README_1.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~19%p6%       README_2.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~20%p6%       README_3.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~21%p6%       README_4.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~22%p6%       README_5.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~23%p6%       README_6.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~24%p6%       README_7.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~25%p6%       README_8.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~26%p6%       README_9.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~27%p6%       README_A.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~28%p6%       README_B.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~29%p6%       README_C.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~30%p6%       README_D.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~31%p6%       README_E.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~32%p6%       README_F.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~33%p6%       README_G.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~34%p6%       README_H.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~35%p6%       README_I.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~36%p6%       README_J.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~37%p6%       README_K.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~38%p6%       README_L.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~39%p6%       README_M.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~40%p6%       README_N.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~41%p6%       README_O.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~42%p6%       README_P.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~43%p6%       README_Q.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~44%p6%       README_R.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~45%p6%       README_S.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~46%p6%       README_T.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~47%p6%       README_U.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~48%p6%       README_V.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~49%p6%       README_W.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~50%p6%       README_X.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~51%p6%       README_Y.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~52%p6%       README_Z.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~53%p6%       README~1.HTM%p7%
%1 %2 %p3% %p4% %p5% READM~54%p6%       README0Z.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~55%p6%       readme1st.txt%p7%
%1 %2 %p3% %p4% %p5% READM~56%p6%       readme25.txt%p7%
%1 %2 %p3% %p4% %p5% READM~57%p6%       readmeean.txt%p7%
%1 %2 %p3% %p4% %p5% READM~58%p6%       readmeupca.txt%p7%
%1 %2 %p3% %p4% %p5% READM~59%p6%       readmeupce.txt%p7%
%1 %2 %p3% %p4% %p5% READM0~1%p6%       READM0.txt%p7%
%1 %2 %p3% %p4% %p5% READM4~1%p6%       readm4.txt%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       "Read Me.txt%p7%"
%1 %2 %p3% %p4% %p5% README~2%p6%       README.1ST%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       Readme.doc%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       ReadMe.htm%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README.rtf%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README.SAM%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README.tx_%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       readme.txt%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       "Readme Deutsch.txt%p7%"
%1 %2 %p3% %p4% %p5% RED_CH~1%p6%       red_check.sty%p7%
%1 %2 %p3% %p4% %p5% RED_OU~1%p6%       red_outline.sty%p7%
%1 %2 %p3% %p4% %p5% RED_RE~1%p6%       Red_red.sty%p7%
%1 %2 %p3% %p4% %p5% RED_TR~1%p6%       red_tree.din%p7%
%1 %2 %p3% %p4% %p5% RED1ST~1%p6%       Red1.sty%p7%
%1 %2 %p3% %p4% %p5% RED2ST~1%p6%       Red2.sty%p7%
%1 %2 %p3% %p4% %p5% REF5RE~1%p6%       REF5RENC.HTM%p7%
%1 %2 %p3% %p4% %p5% REG5ST~1%p6%       REG5ST.HTM%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       Register.txt%p7%
%1 %2 %p3% %p4% %p5% REGSVR~1%p6%       REGSVR32.EXE%p7%
%1 %2 %p3% %p4% %p5% RELEAS~1%p6%       ReleaseNotes.%p7%
%1 %2 %p3% %p4% %p5% RESURG~1%p6%       resurgen.ttf%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RichEd32.dl_%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX32.OC_%p7%
%1 %2 %p3% %p4% %p5% ROBOTT~1%p6%       robot.ttf%p7%
%1 %2 %p3% %p4% %p5% ROUND2~1%p6%       round2.din%p7%
%1 %2 %p3% %p4% %p5% SAMPLE~1%p6%       sample.txt%p7%
%1 %2 %p3% %p4% %p5% SAVEHT~1%p6%       save.htm%p7%
%1 %2 %p3% %p4% %p5% SCR_BA~1%p6%       scr_background.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_BU~1%p6%       scr_bulletin.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_DR~1%p6%       scr_draw.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_DR~2%p6%       scr_dropshadow.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_ED~1%p6%       scr_edit_style.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_GR~1%p6%       scr_gradient.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_ME~1%p6%       scr_message.gif%p7%
%1 %2 %p3% %p4% %p5% SCR_OU~1%p6%       scr_outline.gif%p7%
%1 %2 %p3% %p4% %p5% SCRIPT~1%p6%       scriptfonts_lg.jpg%p7%
%1 %2 %p3% %p4% %p5% SEA1ST~1%p6%       Sea1.sty%p7%
%1 %2 %p3% %p4% %p5% SECRET~1%p6%       secret.ttf%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP__.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_0.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_1.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_1.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_1.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP_~8%p6%       SETUP_1_.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~9%p6%       SETUP_4.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~10%p6%       SETUP_4.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~11%p6%       SETUP_4.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~12%p6%       SETUP_7.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~13%p6%       SETUP_8.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~14%p6%       SETUP_9.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~15%p6%       SETUP_B.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~16%p6%       SETUP_B.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~17%p6%       SETUP_B.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~18%p6%       SETUP_B.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP~19%p6%       SETUP_F.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~20%p6%       SETUP_G.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~21%p6%       SETUP_L.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~22%p6%       SETUP_M.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~23%p6%       SETUP_M.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~24%p6%       SETUP_M.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~25%p6%       SETUP_O.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~26%p6%       SETUP_O.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP~27%p6%       SETUP_O.INS%p7%
%1 %2 %p3% %p4% %p5% SETUP~28%p6%       SETUP_O.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUP~29%p6%       SETUP_P.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~30%p6%       SETUP_R.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~31%p6%       SETUP_S.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~32%p6%       SETUP_T.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~33%p6%       SETUP_W.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~34%p6%       SETUP_X.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP~35%p6%       SETUP_X.LST%p7%
%1 %2 %p3% %p4% %p5% SETUP0~1%p6%       SETUP0.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       setup1.ex_%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       SETUP1.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP1~3%p6%       setup132.ex_%p7%
%1 %2 %p3% %p4% %p5% SETUP2~1%p6%       SETUP2.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP3~1%p6%       SETUP3.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP4~1%p6%       SETUP4.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPB~1%p6%       setup.bmp%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUP.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUP.INS%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUP.ISS%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       setup.lid%p7%
%1 %2 %p3% %p4% %p5% SETUPL~2%p6%       SETUP.LST%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUP.PKG%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       setup.txt%p7%
%1 %2 %p3% %p4% %p5% SFTTRE~1%p6%       SFTTREEX.OCX%p7%
%1 %2 %p3% %p4% %p5% SHA5EW~1%p6%       SHA5EWAR.HTM%p7%
%1 %2 %p3% %p4% %p5% SHA6EW~1%p6%       SHA6EWAR.DOC%p7%
%1 %2 %p3% %p4% %p5% SIGNAL~1%p6%       signal.ttf%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       Simple.sty%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       simple_red.sty%p7%
%1 %2 %p3% %p4% %p5% SINE1S~1%p6%       Sine1.sty%p7%
%1 %2 %p3% %p4% %p5% SINE2S~1%p6%       Sine2.sty%p7%
%1 %2 %p3% %p4% %p5% SINGLE~1%p6%       single.gif%p7%
%1 %2 %p3% %p4% %p5% SINGLE~2%p6%       single_color.htm%p7%
%1 %2 %p3% %p4% %p5% SINGLE~3%p6%       singlecolor.sty%p7%
%1 %2 %p3% %p4% %p5% SKINGI~1%p6%       Skin.gif%p7%
%1 %2 %p3% %p4% %p5% SKY1ST~1%p6%       Sky1.sty%p7%
%1 %2 %p3% %p4% %p5% SKYGIF~1%p6%       Sky.gif%p7%
%1 %2 %p3% %p4% %p5% SNOW2S~1%p6%       Snow2.sty%p7%
%1 %2 %p3% %p4% %p5% SNOW3S~1%p6%       Snow3.sty%p7%
%1 %2 %p3% %p4% %p5% SNOWST~1%p6%       Snow.sty%p7%
%1 %2 %p3% %p4% %p5% SPACE1~1%p6%       Space1.sty%p7%
%1 %2 %p3% %p4% %p5% SPLASH~1%p6%       splash.bm_%p7%
%1 %2 %p3% %p4% %p5% SS221T~1%p6%       ss221.txt%p7%
%1 %2 %p3% %p4% %p5% ST4UNS~1%p6%       St4unst.ex_%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~1%p6%       ST5UNST.EX_%p7%
%1 %2 %p3% %p4% %p5% STALKE~1%p6%       stalker1.ttf%p7%
%1 %2 %p3% %p4% %p5% STALKE~2%p6%       stalker2.ttf%p7%
%1 %2 %p3% %p4% %p5% STAR0L~1%p6%       Star0.lit%p7%
%1 %2 %p3% %p4% %p5% STAR1L~1%p6%       Star1.lit%p7%
%1 %2 %p3% %p4% %p5% STAR2L~1%p6%       Star2.lit%p7%
%1 %2 %p3% %p4% %p5% STEVET~1%p6%       STEVE.TTF%p7%
%1 %2 %p3% %p4% %p5% STH___~1%p6%       STH_____.PFB%p7%
%1 %2 %p3% %p4% %p5% STH___~2%p6%       STH_____.PFM%p7%
%1 %2 %p3% %p4% %p5% STKIT4~1%p6%       stkit432.dl_%p7%
%1 %2 %p3% %p4% %p5% STYLE_~1%p6%       style_effect.htm%p7%
%1 %2 %p3% %p4% %p5% SUBMER~1%p6%       SUBMERGD.TTF%p7%
%1 %2 %p3% %p4% %p5% SUCKGO~1%p6%       suckgolf.ttf%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~1%p6%       symsel2.exe%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~2%p6%       symsel2.txt%p7%
%1 %2 %p3% %p4% %p5% SYMSEL~3%p6%       SYMSEL2_.EXE%p7%
%1 %2 %p3% %p4% %p5% TABLED~1%p6%       table.din%p7%
%1 %2 %p3% %p4% %p5% TECHNE~1%p6%       technet.ttf%p7%
%1 %2 %p3% %p4% %p5% TEMPLA~1%p6%       template.htm%p7%
%1 %2 %p3% %p4% %p5% TETANU~1%p6%       tetanus.ttf%p7%
%1 %2 %p3% %p4% %p5% TEX10G~1%p6%       Tex10.gif%p7%
%1 %2 %p3% %p4% %p5% TEX11G~1%p6%       Tex11.gif%p7%
%1 %2 %p3% %p4% %p5% TEX12G~1%p6%       Tex12.gif%p7%
%1 %2 %p3% %p4% %p5% TEX13G~1%p6%       Tex13.gif%p7%
%1 %2 %p3% %p4% %p5% TEX15G~1%p6%       Tex15.gif%p7%
%1 %2 %p3% %p4% %p5% TEX18G~1%p6%       Tex18.gif%p7%
%1 %2 %p3% %p4% %p5% TEX19G~1%p6%       Tex19.gif%p7%
%1 %2 %p3% %p4% %p5% TEX210~1%p6%       Tex210.gif%p7%
%1 %2 %p3% %p4% %p5% TEX22G~1%p6%       Tex22.gif%p7%
%1 %2 %p3% %p4% %p5% TEX24G~1%p6%       Tex24.gif%p7%
%1 %2 %p3% %p4% %p5% TEX25G~1%p6%       Tex25.gif%p7%
%1 %2 %p3% %p4% %p5% TEX27G~1%p6%       Tex27.gif%p7%
%1 %2 %p3% %p4% %p5% TEX2GI~1%p6%       Tex2.gif%p7%
%1 %2 %p3% %p4% %p5% TEX30G~1%p6%       Tex30.gif%p7%
%1 %2 %p3% %p4% %p5% TEX31G~1%p6%       Tex31.gif%p7%
%1 %2 %p3% %p4% %p5% TEX32G~1%p6%       Tex32.gif%p7%
%1 %2 %p3% %p4% %p5% TEX33G~1%p6%       Tex33.gif%p7%
%1 %2 %p3% %p4% %p5% TEX34G~1%p6%       Tex34.gif%p7%
%1 %2 %p3% %p4% %p5% TEX35G~1%p6%       Tex35.gif%p7%
%1 %2 %p3% %p4% %p5% TEX36G~1%p6%       Tex36.gif%p7%
%1 %2 %p3% %p4% %p5% TEX37G~1%p6%       Tex37.gif%p7%
%1 %2 %p3% %p4% %p5% TEX38G~1%p6%       Tex38.gif%p7%
%1 %2 %p3% %p4% %p5% TEX39G~1%p6%       Tex39.gif%p7%
%1 %2 %p3% %p4% %p5% TEX3GI~1%p6%       Tex3.gif%p7%
%1 %2 %p3% %p4% %p5% TEX40G~1%p6%       Tex40.gif%p7%
%1 %2 %p3% %p4% %p5% TEX42G~1%p6%       Tex42.gif%p7%
%1 %2 %p3% %p4% %p5% TEX43G~1%p6%       Tex43.gif%p7%
%1 %2 %p3% %p4% %p5% TEX44G~1%p6%       Tex44.gif%p7%
%1 %2 %p3% %p4% %p5% TEX45G~1%p6%       Tex45.gif%p7%
%1 %2 %p3% %p4% %p5% TEX46G~1%p6%       Tex46.gif%p7%
%1 %2 %p3% %p4% %p5% TEX47G~1%p6%       Tex47.gif%p7%
%1 %2 %p3% %p4% %p5% TEX48G~1%p6%       Tex48.gif%p7%
%1 %2 %p3% %p4% %p5% TEX49G~1%p6%       Tex49.gif%p7%
%1 %2 %p3% %p4% %p5% TEX50G~1%p6%       Tex50.gif%p7%
%1 %2 %p3% %p4% %p5% TEX51G~1%p6%       Tex51.gif%p7%
%1 %2 %p3% %p4% %p5% TEX52G~1%p6%       Tex52.gif%p7%
%1 %2 %p3% %p4% %p5% TEX53G~1%p6%       Tex53.gif%p7%
%1 %2 %p3% %p4% %p5% TEX54G~1%p6%       Tex54.gif%p7%
%1 %2 %p3% %p4% %p5% TEX55G~1%p6%       Tex55.gif%p7%
%1 %2 %p3% %p4% %p5% TEX56G~1%p6%       Tex56.gif%p7%
%1 %2 %p3% %p4% %p5% TEX57G~1%p6%       Tex57.gif%p7%
%1 %2 %p3% %p4% %p5% TEX58G~1%p6%       tex58.gif%p7%
%1 %2 %p3% %p4% %p5% TEX59G~1%p6%       tex59.gif%p7%
%1 %2 %p3% %p4% %p5% TEX60G~1%p6%       tex60.gif%p7%
%1 %2 %p3% %p4% %p5% TEX61G~1%p6%       tex61.gif%p7%
%1 %2 %p3% %p4% %p5% TEX62G~1%p6%       tex62.gif%p7%
%1 %2 %p3% %p4% %p5% TEX63G~1%p6%       tex63.gif%p7%
%1 %2 %p3% %p4% %p5% TEX64G~1%p6%       tex64.gif%p7%
%1 %2 %p3% %p4% %p5% TEX65G~1%p6%       tex65.gif%p7%
%1 %2 %p3% %p4% %p5% TEX7GI~1%p6%       Tex7.gif%p7%
%1 %2 %p3% %p4% %p5% TEXT_L~1%p6%       text_line.din%p7%
%1 %2 %p3% %p4% %p5% THISPR~1%p6%       thisprty.ttf%p7%
%1 %2 %p3% %p4% %p5% THREED~1%p6%       THREED32.OC_%p7%
%1 %2 %p3% %p4% %p5% TILE1G~1%p6%       Tile1.git%p7%
%1 %2 %p3% %p4% %p5% TILE2G~1%p6%       tile2.git%p7%
%1 %2 %p3% %p4% %p5% TILE3G~1%p6%       tile3.git%p7%
%1 %2 %p3% %p4% %p5% TILE4G~1%p6%       tile4.git%p7%
%1 %2 %p3% %p4% %p5% TILE5G~1%p6%       tile5.git%p7%
%1 %2 %p3% %p4% %p5% TILE6G~1%p6%       tile6.git%p7%
%1 %2 %p3% %p4% %p5% TILEST~1%p6%       tile.sty%p7%
%1 %2 %p3% %p4% %p5% TITLEG~1%p6%       title.gif%p7%
%1 %2 %p3% %p4% %p5% TOASTT~1%p6%       toast.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~1%p6%       TOMBATS1.TTF%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~2%p6%       tombats3.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~3%p6%       tombats4.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMBAT~4%p6%       tombats6.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMBOT~1%p6%       tombots.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMHAN~1%p6%       tomhand.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMMYS~1%p6%       tommys.ttf%p7%
%1 %2 %p3% %p4% %p5% TOMNRT~1%p6%       tomnr.ttf%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~1%p6%       topbar.jpg%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~2%p6%       TOPBAR_.JPG%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~3%p6%       TOPBAR0.JPG%p7%
%1 %2 %p3% %p4% %p5% TOWELD~1%p6%       towel.din%p7%
%1 %2 %p3% %p4% %p5% TRADEM~1%p6%       trademark.txt%p7%
%1 %2 %p3% %p4% %p5% TRUETY~1%p6%       "TrueType Renamer.exe%p7%"
%1 %2 %p3% %p4% %p5% TSMILE~1%p6%       tsmiles.ttf%p7%
%1 %2 %p3% %p4% %p5% TTFMAN~1%p6%       TTFMAN.EXE%p7%
%1 %2 %p3% %p4% %p5% TUESDA~1%p6%       tuesday.ttf%p7%
%1 %2 %p3% %p4% %p5% TYPEC~10%p6%       TYPECASE.RTF%p7%
%1 %2 %p3% %p4% %p5% TYPECA~1%p6%       TYPECASE.BMP%p7%
%1 %2 %p3% %p4% %p5% TYPECA~2%p6%       TYPECASE.CPP%p7%
%1 %2 %p3% %p4% %p5% TYPECA~3%p6%       TYPECASE.DEF%p7%
%1 %2 %p3% %p4% %p5% TYPECA~4%p6%       TYPECASE.EXE%p7%
%1 %2 %p3% %p4% %p5% TYPECA~5%p6%       TYPECASE.H%p7%
%1 %2 %p3% %p4% %p5% TYPECA~6%p6%       TYPECASE.HLP%p7%
%1 %2 %p3% %p4% %p5% TYPECA~7%p6%       TYPECASE.ICO%p7%
%1 %2 %p3% %p4% %p5% TYPECA~8%p6%       TYPECASE.MAC%p7%
%1 %2 %p3% %p4% %p5% TYPECA~9%p6%       TYPECASE.RC%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~1%p6%       TYPOGRAF.CNT%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~2%p6%       TYPOGRAF.EXE%p7%
%1 %2 %p3% %p4% %p5% TYPOGR~3%p6%       TYPOGRAF.HLP%p7%
%1 %2 %p3% %p4% %p5% UNIB7T~1%p6%       Unib7.ttr%p7%
%1 %2 %p3% %p4% %p5% UNIB9T~1%p6%       UNIB9.TTR%p7%
%1 %2 %p3% %p4% %p5% UNIN7T~1%p6%       Unin7.ttr%p7%
%1 %2 %p3% %p4% %p5% UNIN9T~1%p6%       UNIN9.TTR%p7%
%1 %2 %p3% %p4% %p5% UNINS0~1%p6%       UNINS0.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS1~1%p6%       UNINS1.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS2~1%p6%       UNINS2.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS3~1%p6%       UNINS3.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINS4~1%p6%       UNINS4.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINSTAL.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       Uninstalled.txt%p7%
%1 %2 %p3% %p4% %p5% UNZDLL~1%p6%       UNZDLL.DLL%p7%
%1 %2 %p3% %p4% %p5% UPC-AH~1%p6%       UPC-AHH.TTF%p7%
%1 %2 %p3% %p4% %p5% UPC-AT~1%p6%       UPC-A.TTF%p7%
%1 %2 %p3% %p4% %p5% UPC-EH~1%p6%       UPC-EHH.TTF%p7%
%1 %2 %p3% %p4% %p5% UPC-ET~1%p6%       UPC-E.TTF%p7%
%1 %2 %p3% %p4% %p5% VALIUM~1%p6%       valium.ttf%p7%
%1 %2 %p3% %p4% %p5% VALUES~1%p6%       value.shl%p7%
%1 %2 %p3% %p4% %p5% VB5STK~1%p6%       VB5StKit.dl_%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDINF_.DIZ%p7%
%1 %2 %p3% %p4% %p5% VENDIN~2%p6%       VENDINF0.DIZ%p7%
%1 %2 %p3% %p4% %p5% VENDIN~3%p6%       VENDINF1.DIZ%p7%
%1 %2 %p3% %p4% %p5% VENDIN~4%p6%       VENDINFO.DIZ%p7%
%1 %2 %p3% %p4% %p5% VERSIO~1%p6%       "Version history.txt%p7%"
%1 %2 %p3% %p4% %p5% VIEWCA~1%p6%       VIEWCAR_.JPG%p7%
%1 %2 %p3% %p4% %p5% VIEWCA~2%p6%       VIEWCAR0.JPG%p7%
%1 %2 %p3% %p4% %p5% VIEWCA~3%p6%       viewcart.jpg%p7%
%1 %2 %p3% %p4% %p5% VISIFO~1%p6%       visifont.ex_%p7%
%1 %2 %p3% %p4% %p5% VISIGO~1%p6%       VISIGOLD.HL_%p7%
%1 %2 %p3% %p4% %p5% VISIT4~1%p6%       Visit4s.bmp%p7%
%1 %2 %p3% %p4% %p5% W95I8F~1%p6%       W95I8f16.DLL%p7%
%1 %2 %p3% %p4% %p5% W95I8F~2%p6%       W95I8f32.DLL%p7%
%1 %2 %p3% %p4% %p5% W95I9F~1%p6%       W95I9f16.DLL%p7%
%1 %2 %p3% %p4% %p5% W95I9F~2%p6%       W95I9f32.DLL%p7%
%1 %2 %p3% %p4% %p5% WEIGHT~1%p6%       weights.gif%p7%
%1 %2 %p3% %p4% %p5% WHA5SN~1%p6%       WHA5SNEW.DOC%p7%
%1 %2 %p3% %p4% %p5% WHA6SN~1%p6%       WHA6SNEW.DOC%p7%
%1 %2 %p3% %p4% %p5% WHITE_~1%p6%       white_paper.sty%p7%
%1 %2 %p3% %p4% %p5% WINNWA~1%p6%       WINNWA.$%p7%
%1 %2 %p3% %p4% %p5% WINNWA~2%p6%       WINNWA.TTF%p7%
%1 %2 %p3% %p4% %p5% WOLVES~1%p6%       wolves.ttf%p7%
%1 %2 %p3% %p4% %p5% WOODEN~1%p6%       wooden.din%p7%
%1 %2 %p3% %p4% %p5% YELLOW~1%p6%       Yellow.sty%p7%
%1 %2 %p3% %p4% %p5% YELLOW~2%p6%       yellow_letter.din%p7%
%1 %2 %p3% %p4% %p5% YELLOW~3%p6%       yellow_round.din%p7%
%1 %2 %p3% %p4% %p5% YELLOW~4%p6%       yellow_round.sty%p7%
%1 %2 %p3% %p4% %p5% YIKATU~1%p6%       yikatu.ttf%p7%
%1 %2 %p3% %p4% %p5% ZINCBO~1%p6%       zincboom.ttf%p7%
%1 %2 %p3% %p4% %p5% ZIPDLL~1%p6%       ZIPDLL.DLL%p7%

cd %dir4%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST32I.EX_%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _IsRes.Dll%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _setup.dll%p7%
%1 %2 %p3% %p4% %p5% AGODLL~1%p6%       ago.dll%p7%
%1 %2 %p3% %p4% %p5% ANAFL2~1%p6%       anaFL2.stf%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       corecomp.ini%p7%
%1 %2 %p3% %p4% %p5% CPUINF~1%p6%       Cpuinf32.dll%p7%
%1 %2 %p3% %p4% %p5% DATATA~1%p6%       DATA.TAG%p7%
%1 %2 %p3% %p4% %p5% FINDHE~1%p6%       FindHelp.ico%p7%
%1 %2 %p3% %p4% %p5% IPLA6D~1%p6%       iplA6.dll%p7%
%1 %2 %p3% %p4% %p5% IPLDLL~1%p6%       ipl.dll%p7%
%1 %2 %p3% %p4% %p5% IPLM5D~1%p6%       iplM5.dll%p7%
%1 %2 %p3% %p4% %p5% IPLM6D~1%p6%       iplM6.dll%p7%
%1 %2 %p3% %p4% %p5% IPLP5D~1%p6%       iplP5.dll%p7%
%1 %2 %p3% %p4% %p5% IPLP6D~1%p6%       iplP6.dll%p7%
%1 %2 %p3% %p4% %p5% IPLPXD~1%p6%       iplPX.dll%p7%
%1 %2 %p3% %p4% %p5% ISUNIN~1%p6%       IsUninst.Exe%p7%
%1 %2 %p3% %p4% %p5% LANGDA~1%p6%       lang.dat%p7%
%1 %2 %p3% %p4% %p5% LAYOUT~1%p6%       layout.bin%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       licens_.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       license.txt%p7%
%1 %2 %p3% %p4% %p5% MFC42D~1%p6%       mfc42.dll%p7%
%1 %2 %p3% %p4% %p5% MLIB4V~1%p6%       mlib4vc0.dll%p7%
%1 %2 %p3% %p4% %p5% OSDAT~1%p6%        os.dat%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       ReadMe.ico%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README.TXT%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       readme_.txt%p7%
%1 %2 %p3% %p4% %p5% SETUPB~1%p6%       setup.bmp%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUP.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       setup.ins%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       setup.lid%p7%
%1 %2 %p3% %p4% %p5% SOFT3D~1%p6%       soft3dhlp.chm%p7%
%1 %2 %p3% %p4% %p5% SOFTFA~1%p6%       SoftFace.exe%p7%
%1 %2 %p3% %p4% %p5% SOFTFA~2%p6%       SoftFace.ico%p7%
%1 %2 %p3% %p4% %p5% VALUES~1%p6%       value.shl%p7%

cd %dir5%

%1 %2 %p3% %p4% %p5% ABDOME~1%p6%       abdomen.htm%p7%
%1 %2 %p3% %p4% %p5% ABDOME~2%p6%       abdomen.jpg%p7%
%1 %2 %p3% %p4% %p5% ABOUTH~1%p6%       about.htm%p7%
%1 %2 %p3% %p4% %p5% ALPHAB~1%p6%       alphabet.htm%p7%
%1 %2 %p3% %p4% %p5% ALPHAB~2%p6%       alphabet.jpg%p7%
%1 %2 %p3% %p4% %p5% ANIMAL~1%p6%       ANIMAL.gif%p7%
%1 %2 %p3% %p4% %p5% ANIMAL~2%p6%       animal.htm%p7%
%1 %2 %p3% %p4% %p5% ANN_LA~1%p6%       ann_lai.wav%p7%
%1 %2 %p3% %p4% %p5% ANNULA~1%p6%       annulai.htm%p7%
%1 %2 %p3% %p4% %p5% ANNULA~2%p6%       annulai.jpg%p7%
%1 %2 %p3% %p4% %p5% ANNULA~3%p6%       annulai.wav%p7%
%1 %2 %p3% %p4% %p5% ARMHTM~1%p6%       arm.htm%p7%
%1 %2 %p3% %p4% %p5% ARMJPG~1%p6%       arm.jpg%p7%
%1 %2 %p3% %p4% %p5% AUR_CU~1%p6%       Aur_cu.wav%p7%
%1 %2 %p3% %p4% %p5% AURICU~1%p6%       Auricu.htm%p7%
%1 %2 %p3% %p4% %p5% AURICU~2%p6%       Auricu.jpg%p7%
%1 %2 %p3% %p4% %p5% AURICU~3%p6%       Auricu.wav%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       Autorun.cnf%p7%
%1 %2 %p3% %p4% %p5% AUTORU~2%p6%       autorun.GIF%p7%
%1 %2 %p3% %p4% %p5% BACKHT~1%p6%       back.htm%p7%
%1 %2 %p3% %p4% %p5% BACKJP~1%p6%       back.jpg%p7%
%1 %2 %p3% %p4% %p5% BASICH~1%p6%       basic.htm%p7%
%1 %2 %p3% %p4% %p5% BASICJ~1%p6%       basic.jpg%p7%
%1 %2 %p3% %p4% %p5% BOD_WA~1%p6%       bod_.wav%p7%
%1 %2 %p3% %p4% %p5% BODYHT~1%p6%       body.htm%p7%
%1 %2 %p3% %p4% %p5% BODYJP~1%p6%       body.jpg%p7%
%1 %2 %p3% %p4% %p5% BODYWA~1%p6%       body.wav%p7%
%1 %2 %p3% %p4% %p5% BON_WA~1%p6%       BON_.wav%p7%
%1 %2 %p3% %p4% %p5% BONAHT~1%p6%       bona.htm%p7%
%1 %2 %p3% %p4% %p5% BONAJP~1%p6%       bona.jpg%p7%
%1 %2 %p3% %p4% %p5% BONAWA~1%p6%       BONA.WAV%p7%
%1 %2 %p3% %p4% %p5% BOU_HE~1%p6%       bou_he.wav%p7%
%1 %2 %p3% %p4% %p5% BOUCHE~1%p6%       bouche.wav%p7%
%1 %2 %p3% %p4% %p5% BRA_WA~1%p6%       Bra_.wav%p7%
%1 %2 %p3% %p4% %p5% BRASWA~1%p6%       Bras.wav%p7%
%1 %2 %p3% %p4% %p5% BUSILE~1%p6%       busilett.htm%p7%
%1 %2 %p3% %p4% %p5% BUSILE~2%p6%       busilett.jpg%p7%
%1 %2 %p3% %p4% %p5% BUSISP~1%p6%       busispk.htm%p7%
%1 %2 %p3% %p4% %p5% BUSISP~2%p6%       BUSISPK.jpg%p7%
%1 %2 %p3% %p4% %p5% BUSIWO~1%p6%       busiword.htm%p7%
%1 %2 %p3% %p4% %p5% BUSIWO~2%p6%       BUSIword.jpg%p7%
%1 %2 %p3% %p4% %p5% CHE_EU~1%p6%       Che_eux.wav%p7%
%1 %2 %p3% %p4% %p5% CHE_IL~1%p6%       che_ille.wav%p7%
%1 %2 %p3% %p4% %p5% CHEEKH~1%p6%       cheek.htm%p7%
%1 %2 %p3% %p4% %p5% CHEEKJ~1%p6%       cheek.jpg%p7%
%1 %2 %p3% %p4% %p5% CHESTH~1%p6%       chest.htm%p7%
%1 %2 %p3% %p4% %p5% CHESTJ~1%p6%       chest.jpg%p7%
%1 %2 %p3% %p4% %p5% CHEVEU~1%p6%       Cheveux.wav%p7%
%1 %2 %p3% %p4% %p5% CHEVIL~1%p6%       cheville.wav%p7%
%1 %2 %p3% %p4% %p5% CHINHT~1%p6%       chin.htm%p7%
%1 %2 %p3% %p4% %p5% CHINJP~1%p6%       chin.jpg%p7%
%1 %2 %p3% %p4% %p5% CIL_WA~1%p6%       Cil_.wav%p7%
%1 %2 %p3% %p4% %p5% CILWAV~1%p6%       Cil.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~1%p6%       COL_R10.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~2%p6%       COL_R100.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~3%p6%       COL_R110.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~4%p6%       COL_R120.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~5%p6%       COL_R130.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~6%p6%       COL_R140.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R1~7%p6%       COL_R150.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R2~1%p6%       COL_R20.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R3~1%p6%       COL_R30.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R4~1%p6%       COL_R40.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R5~1%p6%       COL_R5.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R5~2%p6%       COL_R50.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R6~1%p6%       COL_R60.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R7~1%p6%       COL_R70.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R8~1%p6%       COL_R80.wav%p7%
%1 %2 %p3% %p4% %p5% COL_R9~1%p6%       COL_R90.wav%p7%
%1 %2 %p3% %p4% %p5% COLOR~10%p6%       color120.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR~11%p6%       color120.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR~12%p6%       COLOR120.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR~13%p6%       COLOR130.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR~14%p6%       color140.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR~15%p6%       color140.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR~16%p6%       COLOR140.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR~17%p6%       color150.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR~18%p6%       Color150.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR~19%p6%       COLOR150.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR1~1%p6%       color10.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR1~2%p6%       color10.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR1~3%p6%       COLOR10.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR1~4%p6%       color100.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR1~5%p6%       color100.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR1~6%p6%       COLOR100.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR1~7%p6%       color110.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR1~8%p6%       color110.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR1~9%p6%       COLOR110.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR2~1%p6%       color20.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR2~2%p6%       color20.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR2~3%p6%       COLOR20.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR3~1%p6%       color30.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR3~2%p6%       color30.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR3~3%p6%       COLOR30.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR4~1%p6%       color40.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR4~2%p6%       color40.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR4~3%p6%       COLOR40.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR5~1%p6%       color5.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR5~2%p6%       color5.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR5~3%p6%       COLOR5.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR5~4%p6%       color50.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR5~5%p6%       color50.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR5~6%p6%       COLOR50.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR5~7%p6%       color55.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR5~8%p6%       color55.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR6~1%p6%       color60.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR6~2%p6%       color60.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR6~3%p6%       COLOR60.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR7~1%p6%       color70.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR7~2%p6%       color70.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR7~3%p6%       COLOR70.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR8~1%p6%       color80.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR8~2%p6%       color80.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR8~3%p6%       COLOR80.WAV%p7%
%1 %2 %p3% %p4% %p5% COLOR9~1%p6%       color90.htm%p7%
%1 %2 %p3% %p4% %p5% COLOR9~2%p6%       Color90.jpg%p7%
%1 %2 %p3% %p4% %p5% COLOR9~3%p6%       COLOR90.WAV%p7%
%1 %2 %p3% %p4% %p5% COLORH~1%p6%       color.htm%p7%
%1 %2 %p3% %p4% %p5% COLORJ~1%p6%       Color.jpg%p7%
%1 %2 %p3% %p4% %p5% CON_TI~1%p6%       con_tipe.wav%p7%
%1 %2 %p3% %p4% %p5% CONSTI~1%p6%       constipe.wav%p7%
%1 %2 %p3% %p4% %p5% CORPSG~1%p6%       CORPS.GIF%p7%
%1 %2 %p3% %p4% %p5% CORPSH~1%p6%       corps.htm%p7%
%1 %2 %p3% %p4% %p5% COT_SW~1%p6%       Cot_s.wav%p7%
%1 %2 %p3% %p4% %p5% COTESH~1%p6%       Cotes.htm%p7%
%1 %2 %p3% %p4% %p5% COTESJ~1%p6%       Cotes.jpg%p7%
%1 %2 %p3% %p4% %p5% COTESW~1%p6%       Cotes.wav%p7%
%1 %2 %p3% %p4% %p5% COU_EW~1%p6%       Cou_e.wav%p7%
%1 %2 %p3% %p4% %p5% COU_WA~1%p6%       Cou_.wav%p7%
%1 %2 %p3% %p4% %p5% COUDEW~1%p6%       Coude.wav%p7%
%1 %2 %p3% %p4% %p5% COUNTR~1%p6%       country.gif%p7%
%1 %2 %p3% %p4% %p5% COUNTR~2%p6%       country.htm%p7%
%1 %2 %p3% %p4% %p5% COUWAV~1%p6%       Cou.wav%p7%
%1 %2 %p3% %p4% %p5% CTL3DV~1%p6%       CTL3DV2.DLL%p7%
%1 %2 %p3% %p4% %p5% CUI_SE~1%p6%       Cui_se.wav%p7%
%1 %2 %p3% %p4% %p5% CUISIN~1%p6%       cuisine.htm%p7%
%1 %2 %p3% %p4% %p5% CUISIN~2%p6%       Cuisine.jpg%p7%
%1 %2 %p3% %p4% %p5% CUISSE~1%p6%       Cuisse.wav%p7%
%1 %2 %p3% %p4% %p5% DANSK_~1%p6%       DANSK_.DLL%p7%
%1 %2 %p3% %p4% %p5% DANSKD~1%p6%       DANSK.DLL%p7%
%1 %2 %p3% %p4% %p5% DEMOGI~1%p6%       demo.gif%p7%
%1 %2 %p3% %p4% %p5% DEMOHT~1%p6%       demo.HTM%p7%
%1 %2 %p3% %p4% %p5% DEN_WA~1%p6%       Den_.wav%p7%
%1 %2 %p3% %p4% %p5% DENTWA~1%p6%       Dent.wav%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~1%p6%       DEUTSCH.DLL%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~2%p6%       DEUTSCH_.DLL%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~3%p6%       DEUTSCH2.DLL%p7%
%1 %2 %p3% %p4% %p5% DEUTSC~4%p6%       DEUTSCH3.DLL%p7%
%1 %2 %p3% %p4% %p5% DIA_EW~1%p6%       dia_e.wav%p7%
%1 %2 %p3% %p4% %p5% DIA_RH~1%p6%       dia_rhe.wav%p7%
%1 %2 %p3% %p4% %p5% DIABEW~1%p6%       diabe.wav%p7%
%1 %2 %p3% %p4% %p5% DIARRH~1%p6%       diarrhe.wav%p7%
%1 %2 %p3% %p4% %p5% DICTEJ~1%p6%       dicte.jpg%p7%
%1 %2 %p3% %p4% %p5% DICTIO~1%p6%       dictionary.jpg%p7%
%1 %2 %p3% %p4% %p5% DIRECG~1%p6%       direc.GIF%p7%
%1 %2 %p3% %p4% %p5% DIRECH~1%p6%       direc.htm%p7%
%1 %2 %p3% %p4% %p5% DOI_TW~1%p6%       Doi_t.wav%p7%
%1 %2 %p3% %p4% %p5% DOIGTW~1%p6%       Doigt.wav%p7%
%1 %2 %p3% %p4% %p5% DOS_WA~1%p6%       Dos_.wav%p7%
%1 %2 %p3% %p4% %p5% DOSWAV~1%p6%       Dos.wav%p7%
%1 %2 %p3% %p4% %p5% EAR_WA~1%p6%       ear_.wav%p7%
%1 %2 %p3% %p4% %p5% EARHTM~1%p6%       ear.htm%p7%
%1 %2 %p3% %p4% %p5% EARJPG~1%p6%       ear.jpg%p7%
%1 %2 %p3% %p4% %p5% EARWAV~1%p6%       ear.wav%p7%
%1 %2 %p3% %p4% %p5% EKREAC~1%p6%       EKREACH_.TTF%p7%
%1 %2 %p3% %p4% %p5% ELBOWH~1%p6%       elbow.htm%p7%
%1 %2 %p3% %p4% %p5% ELBOWJ~1%p6%       elbow.jpg%p7%
%1 %2 %p3% %p4% %p5% EMP_BR~1%p6%       emp_bras.wav%p7%
%1 %2 %p3% %p4% %p5% EMP_JA~1%p6%       emp_jam.wav%p7%
%1 %2 %p3% %p4% %p5% EMPUBR~1%p6%       empubras.wav%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~1%p6%       empujam.htm%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~2%p6%       empujam.jpg%p7%
%1 %2 %p3% %p4% %p5% EMPUJA~3%p6%       empujam.wav%p7%
%1 %2 %p3% %p4% %p5% ENGLIS~1%p6%       ENGLISH.DLL%p7%
%1 %2 %p3% %p4% %p5% ENGLIS~2%p6%       ENGLISH_.DLL%p7%
%1 %2 %p3% %p4% %p5% ENR_UM~1%p6%       enr_ume.wav%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~1%p6%       enrhume.htm%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~2%p6%       enrhume.jpg%p7%
%1 %2 %p3% %p4% %p5% ENRHUM~3%p6%       enrhume.wav%p7%
%1 %2 %p3% %p4% %p5% EPA_LE~1%p6%       Epa_le.wav%p7%
%1 %2 %p3% %p4% %p5% EPAULE~1%p6%       Epaule.wav%p7%
%1 %2 %p3% %p4% %p5% ESPANO~1%p6%       ESPANOL.DLL%p7%
%1 %2 %p3% %p4% %p5% ESPANO~2%p6%       ESPANOL_.DLL%p7%
%1 %2 %p3% %p4% %p5% EXERCI~1%p6%       exercise.jpg%p7%
%1 %2 %p3% %p4% %p5% EXMENU~1%p6%       exmenu.jpg%p7%
%1 %2 %p3% %p4% %p5% EXPORT~1%p6%       export.mdb%p7%
%1 %2 %p3% %p4% %p5% EYEBRO~1%p6%       eyebrow.htm%p7%
%1 %2 %p3% %p4% %p5% EYEBRO~2%p6%       eyebrow.jpg%p7%
%1 %2 %p3% %p4% %p5% EYEHTM~1%p6%       eye.htm%p7%
%1 %2 %p3% %p4% %p5% EYEJPG~1%p6%       eye.jpg%p7%
%1 %2 %p3% %p4% %p5% EYELAS~1%p6%       eyelash.htm%p7%
%1 %2 %p3% %p4% %p5% EYELAS~2%p6%       eyelash.jpg%p7%
%1 %2 %p3% %p4% %p5% FAMILY~1%p6%       family.htm%p7%
%1 %2 %p3% %p4% %p5% FAMILY~2%p6%       family.jpg%p7%
%1 %2 %p3% %p4% %p5% FAT_GU~1%p6%       fat_gue.wav%p7%
%1 %2 %p3% %p4% %p5% FATIGU~1%p6%       fatigue.wav%p7%
%1 %2 %p3% %p4% %p5% FES_ES~1%p6%       Fes_es.wav%p7%
%1 %2 %p3% %p4% %p5% FESSES~1%p6%       Fesses.htm%p7%
%1 %2 %p3% %p4% %p5% FESSES~2%p6%       Fesses.jpg%p7%
%1 %2 %p3% %p4% %p5% FESSES~3%p6%       Fesses.wav%p7%
%1 %2 %p3% %p4% %p5% FFMSG~1%p6%        FF.MSG%p7%
%1 %2 %p3% %p4% %p5% FILLIT~1%p6%       FILLITUP.ANI%p7%
%1 %2 %p3% %p4% %p5% FINGER~1%p6%       finger.htm%p7%
%1 %2 %p3% %p4% %p5% FINGER~2%p6%       finger.jpg%p7%
%1 %2 %p3% %p4% %p5% FINNAI~1%p6%       finnail.htm%p7%
%1 %2 %p3% %p4% %p5% FINNAI~2%p6%       finnail.jpg%p7%
%1 %2 %p3% %p4% %p5% FONDJP~1%p6%       Fond.jpg%p7%
%1 %2 %p3% %p4% %p5% FOOTHT~1%p6%       foot.htm%p7%
%1 %2 %p3% %p4% %p5% FOOTJP~1%p6%       foot.jpg%p7%
%1 %2 %p3% %p4% %p5% FOREHE~1%p6%       forehead.htm%p7%
%1 %2 %p3% %p4% %p5% FOREHE~2%p6%       forehead.jpg%p7%
%1 %2 %p3% %p4% %p5% FRANCA~1%p6%       FRANCAI_.DLL%p7%
%1 %2 %p3% %p4% %p5% FRANCA~2%p6%       FRANCAI2.DLL%p7%
%1 %2 %p3% %p4% %p5% FRANCA~3%p6%       FRANCAI3.DLL%p7%
%1 %2 %p3% %p4% %p5% FRANCA~4%p6%       FRANCAIS.DLL%p7%
%1 %2 %p3% %p4% %p5% FRO_TW~1%p6%       Fro_t.wav%p7%
%1 %2 %p3% %p4% %p5% FRONTW~1%p6%       Front.wav%p7%
%1 %2 %p3% %p4% %p5% FRUITS~1%p6%       fruits.gif%p7%
%1 %2 %p3% %p4% %p5% FUTURE~1%p6%       future.gif%p7%
%1 %2 %p3% %p4% %p5% FUTURE~2%p6%       FUTURE.HTM%p7%
%1 %2 %p3% %p4% %p5% GAL_WA~1%p6%       gal_.wav%p7%
%1 %2 %p3% %p4% %p5% GALEWA~1%p6%       gale.wav%p7%
%1 %2 %p3% %p4% %p5% GEN_UW~1%p6%       Gen_u.wav%p7%
%1 %2 %p3% %p4% %p5% GENOUW~1%p6%       Genou.wav%p7%
%1 %2 %p3% %p4% %p5% GOR_EW~1%p6%       gor_e.wav%p7%
%1 %2 %p3% %p4% %p5% GORGEW~1%p6%       gorge.wav%p7%
%1 %2 %p3% %p4% %p5% GREE_G~1%p6%       gree_.GIF%p7%
%1 %2 %p3% %p4% %p5% GREENG~1%p6%       green.gif%p7%
%1 %2 %p3% %p4% %p5% GRI_PE~1%p6%       gri_pe.wav%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~1%p6%       grippe.htm%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~2%p6%       grippe.jpg%p7%
%1 %2 %p3% %p4% %p5% GRIPPE~3%p6%       grippe.wav%p7%
%1 %2 %p3% %p4% %p5% HABITS~1%p6%       habits.GIF%p7%
%1 %2 %p3% %p4% %p5% HABITS~2%p6%       habits.htm%p7%
%1 %2 %p3% %p4% %p5% HAIRHT~1%p6%       hair.htm%p7%
%1 %2 %p3% %p4% %p5% HAIRJP~1%p6%       hair.jpg%p7%
%1 %2 %p3% %p4% %p5% HAN_HE~1%p6%       Han_he.wav%p7%
%1 %2 %p3% %p4% %p5% HANCHE~1%p6%       Hanche.wav%p7%
%1 %2 %p3% %p4% %p5% HANDGI~1%p6%       HAND.GIF%p7%
%1 %2 %p3% %p4% %p5% HANDHT~1%p6%       hand.htm%p7%
%1 %2 %p3% %p4% %p5% HANDJP~1%p6%       hand.jpg%p7%
%1 %2 %p3% %p4% %p5% HEADHT~1%p6%       head.htm%p7%
%1 %2 %p3% %p4% %p5% HEADJP~1%p6%       head.jpg%p7%
%1 %2 %p3% %p4% %p5% HEBREW~1%p6%       HEBREW.DLL%p7%
%1 %2 %p3% %p4% %p5% HEBREW~2%p6%       HEBREW_.DLL%p7%
%1 %2 %p3% %p4% %p5% HEELHT~1%p6%       heel.htm%p7%
%1 %2 %p3% %p4% %p5% HEELJP~1%p6%       heel.jpg%p7%
%1 %2 %p3% %p4% %p5% HIPHTM~1%p6%       hip.htm%p7%
%1 %2 %p3% %p4% %p5% HIPJPG~1%p6%       hip.jpg%p7%
%1 %2 %p3% %p4% %p5% HOMESP~1%p6%       homespk.htm%p7%
%1 %2 %p3% %p4% %p5% HOMESP~2%p6%       homespk.jpg%p7%
%1 %2 %p3% %p4% %p5% HOMEVE~1%p6%       homever.htm%p7%
%1 %2 %p3% %p4% %p5% HOMEVE~2%p6%       homever.jpg%p7%
%1 %2 %p3% %p4% %p5% HOMEVO~1%p6%       homevoc.htm%p7%
%1 %2 %p3% %p4% %p5% HOMEVO~2%p6%       Homevoc.jpg%p7%
%1 %2 %p3% %p4% %p5% HORSEA~1%p6%       HORSE.ANI%p7%
%1 %2 %p3% %p4% %p5% HOTESP~1%p6%       hotespk.htm%p7%
%1 %2 %p3% %p4% %p5% HOTESP~2%p6%       hotespk.jpg%p7%
%1 %2 %p3% %p4% %p5% HOTEVO~1%p6%       hotevoc.htm%p7%
%1 %2 %p3% %p4% %p5% HOTEVO~2%p6%       Hotevoc.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE~10%p6%       icone108.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE~11%p6%       icone109.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE~12%p6%       icone110.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~1%p6%       icone1.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~2%p6%       icone100.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~3%p6%       icone101.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~4%p6%       icone102.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~5%p6%       icone103.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~6%p6%       icone104.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~7%p6%       icone105.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~8%p6%       icone106.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE1~9%p6%       icone107.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE2~1%p6%       icone2.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE3~1%p6%       icone3.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE3~2%p6%       ICONE3_.JPG%p7%
%1 %2 %p3% %p4% %p5% ICONE4~1%p6%       icone4.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE4~2%p6%       ICONE4_.JPG%p7%
%1 %2 %p3% %p4% %p5% ICONE5~1%p6%       icone5.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE5~2%p6%       ICONE5_.JPG%p7%
%1 %2 %p3% %p4% %p5% ICONE6~1%p6%       icone6.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE7~1%p6%       icone7.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE8~1%p6%       icone8.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE9~1%p6%       icone9.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE9~2%p6%       icone97.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE9~3%p6%       icone98.jpg%p7%
%1 %2 %p3% %p4% %p5% ICONE9~4%p6%       icone99.jpg%p7%
%1 %2 %p3% %p4% %p5% IND_XW~1%p6%       Ind_x.wav%p7%
%1 %2 %p3% %p4% %p5% INDEX_~1%p6%       INDEX_.HTM%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       index.htm%p7%
%1 %2 %p3% %p4% %p5% INDEXJ~1%p6%       index.jpg%p7%
%1 %2 %p3% %p4% %p5% INDEXW~1%p6%       Index.wav%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.EXE%p7%
%1 %2 %p3% %p4% %p5% ITALIA~1%p6%       ITALIAN_.DLL%p7%
%1 %2 %p3% %p4% %p5% ITALIA~2%p6%       ITALIANO.DLL%p7%
%1 %2 %p3% %p4% %p5% JAM_EW~1%p6%       jam_e.wav%p7%
%1 %2 %p3% %p4% %p5% JAMBEW~1%p6%       jambe.wav%p7%
%1 %2 %p3% %p4% %p5% JOU_WA~1%p6%       Jou_.wav%p7%
%1 %2 %p3% %p4% %p5% JOUEWA~1%p6%       Joue.wav%p7%
%1 %2 %p3% %p4% %p5% KH500U~1%p6%       kh500us.txt%p7%
%1 %2 %p3% %p4% %p5% KHMERM~1%p6%       khmer.mdb%p7%
%1 %2 %p3% %p4% %p5% KLE_WA~1%p6%       kle_.wav%p7%
%1 %2 %p3% %p4% %p5% KLEGWA~1%p6%       kleg.wav%p7%
%1 %2 %p3% %p4% %p5% KNEEHT~1%p6%       knee.htm%p7%
%1 %2 %p3% %p4% %p5% KNEEJP~1%p6%       knee.jpg%p7%
%1 %2 %p3% %p4% %p5% LAN_UE~1%p6%       Lan_ue.wav%p7%
%1 %2 %p3% %p4% %p5% LANGUE~1%p6%       Langue.wav%p7%
%1 %2 %p3% %p4% %p5% LEAFHT~1%p6%       leaf.htm%p7%
%1 %2 %p3% %p4% %p5% LEAFJP~1%p6%       leaf.jpg%p7%
%1 %2 %p3% %p4% %p5% LEAMEH~1%p6%       Leame.htm%p7%
%1 %2 %p3% %p4% %p5% LEAMET~1%p6%       LEAME.txt%p7%
%1 %2 %p3% %p4% %p5% LEG_WA~1%p6%       leg_.wav%p7%
%1 %2 %p3% %p4% %p5% LEGHTM~1%p6%       leg.htm%p7%
%1 %2 %p3% %p4% %p5% LEGJPG~1%p6%       leg.jpg%p7%
%1 %2 %p3% %p4% %p5% LEGWAV~1%p6%       leg.wav%p7%
%1 %2 %p3% %p4% %p5% LESENS~1%p6%       LESENSIE.htm%p7%
%1 %2 %p3% %p4% %p5% LESENS~2%p6%       LESENSIE.txt%p7%
%1 %2 %p3% %p4% %p5% LESSO~10%p6%       lesson12.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~11%p6%       lesson13.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~12%p6%       lesson13.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~13%p6%       lesson14.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~14%p6%       lesson14.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~15%p6%       lesson15.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~16%p6%       lesson15.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~17%p6%       lesson16.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~18%p6%       lesson16.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~19%p6%       lesson2.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~20%p6%       lesson2.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~21%p6%       lesson3.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~22%p6%       lesson3.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~23%p6%       lesson4.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~24%p6%       lesson4.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~25%p6%       lesson5.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~26%p6%       lesson5.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~27%p6%       lesson6.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~28%p6%       lesson6.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~29%p6%       lesson7.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~30%p6%       lesson7.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~31%p6%       lesson8.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~32%p6%       lesson8.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~33%p6%       lesson9.htm%p7%
%1 %2 %p3% %p4% %p5% LESSO~34%p6%       lesson9.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSO~35%p6%       lessons.htm%p7%
%1 %2 %p3% %p4% %p5% LESSON~1%p6%       lesson.htm%p7%
%1 %2 %p3% %p4% %p5% LESSON~2%p6%       lesson.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSON~3%p6%       lesson1.htm%p7%
%1 %2 %p3% %p4% %p5% LESSON~4%p6%       lesson1.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSON~5%p6%       lesson10.htm%p7%
%1 %2 %p3% %p4% %p5% LESSON~6%p6%       lesson10.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSON~7%p6%       lesson11.htm%p7%
%1 %2 %p3% %p4% %p5% LESSON~8%p6%       lesson11.jpg%p7%
%1 %2 %p3% %p4% %p5% LESSON~9%p6%       lesson12.htm%p7%
%1 %2 %p3% %p4% %p5% LEU_EM~1%p6%       leu_emie.wav%p7%
%1 %2 %p3% %p4% %p5% LEUCEM~1%p6%       leucemie.wav%p7%
%1 %2 %p3% %p4% %p5% LEV_EW~1%p6%       Lev_e.wav%p7%
%1 %2 %p3% %p4% %p5% LEVREW~1%p6%       Levre.wav%p7%
%1 %2 %p3% %p4% %p5% LIPHTM~1%p6%       lip.htm%p7%
%1 %2 %p3% %p4% %p5% LIPJPG~1%p6%       lip.jpg%p7%
%1 %2 %p3% %p4% %p5% LISEZM~1%p6%       Lisezmoi.htm%p7%
%1 %2 %p3% %p4% %p5% LISEZM~2%p6%       Lisezmoi.txt%p7%
%1 %2 %p3% %p4% %p5% LITTLE~1%p6%       little.htm%p7%
%1 %2 %p3% %p4% %p5% LITTLE~2%p6%       little.jpg%p7%
%1 %2 %p3% %p4% %p5% LOGO_G~1%p6%       LOGO_.GIF%p7%
%1 %2 %p3% %p4% %p5% MAI_WA~1%p6%       Mai_.wav%p7%
%1 %2 %p3% %p4% %p5% MAINWA~1%p6%       Main.wav%p7%
%1 %2 %p3% %p4% %p5% MAJ_UR~1%p6%       Maj_ur.wav%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~1%p6%       majeur.htm%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~2%p6%       majeur.jpg%p7%
%1 %2 %p3% %p4% %p5% MAJEUR~3%p6%       Majeur.wav%p7%
%1 %2 %p3% %p4% %p5% MAJORH~1%p6%       major.htm%p7%
%1 %2 %p3% %p4% %p5% MAJORJ~1%p6%       major.jpg%p7%
%1 %2 %p3% %p4% %p5% MAL_EN~1%p6%       mal_ent.wav%p7%
%1 %2 %p3% %p4% %p5% MAL_EN~2%p6%       mal_entr.wav%p7%
%1 %2 %p3% %p4% %p5% MAL_RI~1%p6%       mal_ria.wav%p7%
%1 %2 %p3% %p4% %p5% MALARI~1%p6%       malaria.wav%p7%
%1 %2 %p3% %p4% %p5% MALDEN~1%p6%       maldent.wav%p7%
%1 %2 %p3% %p4% %p5% MALVEN~1%p6%       malventr.htm%p7%
%1 %2 %p3% %p4% %p5% MALVEN~2%p6%       malventr.jpg%p7%
%1 %2 %p3% %p4% %p5% MALVEN~3%p6%       malventr.wav%p7%
%1 %2 %p3% %p4% %p5% MCI32O~1%p6%       MCI32.OCX%p7%
%1 %2 %p3% %p4% %p5% MEEPIM~1%p6%       meepim.jpg%p7%
%1 %2 %p3% %p4% %p5% MEN_ON~1%p6%       Men_on.wav%p7%
%1 %2 %p3% %p4% %p5% MENTON~1%p6%       Menton.wav%p7%
%1 %2 %p3% %p4% %p5% MENUJP~1%p6%       menu.jpg%p7%
%1 %2 %p3% %p4% %p5% MIDDLE~1%p6%       middle.htm%p7%
%1 %2 %p3% %p4% %p5% MIDDLE~2%p6%       middle.jpg%p7%
%1 %2 %p3% %p4% %p5% MIG_AI~1%p6%       mig_aine.wav%p7%
%1 %2 %p3% %p4% %p5% MIGRAI~1%p6%       migraine.wav%p7%
%1 %2 %p3% %p4% %p5% MOISHT~1%p6%       mois.htm%p7%
%1 %2 %p3% %p4% %p5% MOISJP~1%p6%       Mois.jpg%p7%
%1 %2 %p3% %p4% %p5% MOL_ET~1%p6%       Mol_et.wav%p7%
%1 %2 %p3% %p4% %p5% MOLLET~1%p6%       Mollet.wav%p7%
%1 %2 %p3% %p4% %p5% MOU_HW~1%p6%       mou_h.wav%p7%
%1 %2 %p3% %p4% %p5% MOU_TA~1%p6%       MOU_TACH.wav%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~1%p6%       moustach.htm%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~2%p6%       moustach.jpg%p7%
%1 %2 %p3% %p4% %p5% MOUSTA~3%p6%       MOUSTACH.WAV%p7%
%1 %2 %p3% %p4% %p5% MOUTHH~1%p6%       mouth.htm%p7%
%1 %2 %p3% %p4% %p5% MOUTHJ~1%p6%       mouth.jpg%p7%
%1 %2 %p3% %p4% %p5% MOUTHW~1%p6%       mouth.wav%p7%
%1 %2 %p3% %p4% %p5% MUE_WA~1%p6%       Mue_.wav%p7%
%1 %2 %p3% %p4% %p5% MUETWA~1%p6%       Muet.wav%p7%
%1 %2 %p3% %p4% %p5% NAR_NE~1%p6%       nar_ne.wav%p7%
%1 %2 %p3% %p4% %p5% NARINE~1%p6%       narine.wav%p7%
%1 %2 %p3% %p4% %p5% NAVELH~1%p6%       navel.htm%p7%
%1 %2 %p3% %p4% %p5% NAVELJ~1%p6%       navel.jpg%p7%
%1 %2 %p3% %p4% %p5% NECKHT~1%p6%       neck.htm%p7%
%1 %2 %p3% %p4% %p5% NECKJP~1%p6%       neck.jpg%p7%
%1 %2 %p3% %p4% %p5% NEDERL~1%p6%       NEDERLA_.DLL%p7%
%1 %2 %p3% %p4% %p5% NEDERL~2%p6%       NEDERLA2.DLL%p7%
%1 %2 %p3% %p4% %p5% NEDERL~3%p6%       NEDERLAN.DLL%p7%
%1 %2 %p3% %p4% %p5% NEZ_WA~1%p6%       Nez_.wav%p7%
%1 %2 %p3% %p4% %p5% NEZWAV~1%p6%       Nez.wav%p7%
%1 %2 %p3% %p4% %p5% NOM_RI~1%p6%       Nom_ril.wav%p7%
%1 %2 %p3% %p4% %p5% NOMBRI~1%p6%       Nombril.wav%p7%
%1 %2 %p3% %p4% %p5% NORSKD~1%p6%       NORSK.DLL%p7%
%1 %2 %p3% %p4% %p5% NOSEHT~1%p6%       nose.htm%p7%
%1 %2 %p3% %p4% %p5% NOSEJP~1%p6%       nose.jpg%p7%
%1 %2 %p3% %p4% %p5% NOVIDE~1%p6%       novideo.jpg%p7%
%1 %2 %p3% %p4% %p5% NOVIDE~2%p6%       NOVIDEO_.JPG%p7%
%1 %2 %p3% %p4% %p5% NUMBER~1%p6%       number.gif%p7%
%1 %2 %p3% %p4% %p5% NUMBER~2%p6%       number.htm%p7%
%1 %2 %p3% %p4% %p5% NVIDEO~1%p6%       nvideo.htm%p7%
%1 %2 %p3% %p4% %p5% NVIDEO~2%p6%       NVIDEO_.HTM%p7%
%1 %2 %p3% %p4% %p5% NYNORS~1%p6%       NYNORSK.DLL%p7%
%1 %2 %p3% %p4% %p5% OEI_WA~1%p6%       Oei_.wav%p7%
%1 %2 %p3% %p4% %p5% OEILWA~1%p6%       Oeil.wav%p7%
%1 %2 %p3% %p4% %p5% ONG_EW~1%p6%       Ong_e.wav%p7%
%1 %2 %p3% %p4% %p5% ONGLEH~1%p6%       Ongle.htm%p7%
%1 %2 %p3% %p4% %p5% ONGLEJ~1%p6%       Ongle.jpg%p7%
%1 %2 %p3% %p4% %p5% ONGLEW~1%p6%       Ongle.wav%p7%
%1 %2 %p3% %p4% %p5% ORE_LL~1%p6%       ore_lle.wav%p7%
%1 %2 %p3% %p4% %p5% OREILL~1%p6%       oreille.wav%p7%
%1 %2 %p3% %p4% %p5% ORT_IL~1%p6%       Ort_il.wav%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~1%p6%       Orteil.htm%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~2%p6%       Orteil.jpg%p7%
%1 %2 %p3% %p4% %p5% ORTEIL~3%p6%       Orteil.wav%p7%
%1 %2 %p3% %p4% %p5% PALMHT~1%p6%       palm.htm%p7%
%1 %2 %p3% %p4% %p5% PALMJP~1%p6%       palm.jpg%p7%
%1 %2 %p3% %p4% %p5% PAS_EG~1%p6%       pas_egle.wav%p7%
%1 %2 %p3% %p4% %p5% PAU_EW~1%p6%       Pau_e.wav%p7%
%1 %2 %p3% %p4% %p5% PAUMEH~1%p6%       Paume.htm%p7%
%1 %2 %p3% %p4% %p5% PAUMEJ~1%p6%       Paume.jpg%p7%
%1 %2 %p3% %p4% %p5% PAUMEW~1%p6%       Paume.wav%p7%
%1 %2 %p3% %p4% %p5% PICTUR~1%p6%       pictures.GIF%p7%
%1 %2 %p3% %p4% %p5% PICTUR~2%p6%       pictures.htm%p7%
%1 %2 %p3% %p4% %p5% PIE_WA~1%p6%       Pie_.wav%p7%
%1 %2 %p3% %p4% %p5% PIEDHT~1%p6%       pied.htm%p7%
%1 %2 %p3% %p4% %p5% PIEDJP~1%p6%       pied.jpg%p7%
%1 %2 %p3% %p4% %p5% PIEDWA~1%p6%       Pied.wav%p7%
%1 %2 %p3% %p4% %p5% PINKRO~1%p6%       pinkrose.htm%p7%
%1 %2 %p3% %p4% %p5% PINKRO~2%p6%       pinkrose.jpg%p7%
%1 %2 %p3% %p4% %p5% POI_NE~1%p6%       Poi_net.wav%p7%
%1 %2 %p3% %p4% %p5% POI_RI~1%p6%       Poi_rine.wav%p7%
%1 %2 %p3% %p4% %p5% POIGNE~1%p6%       Poignet.wav%p7%
%1 %2 %p3% %p4% %p5% POITRI~1%p6%       Poitrine.wav%p7%
%1 %2 %p3% %p4% %p5% PORTUG~1%p6%       PORTUGU_.DLL%p7%
%1 %2 %p3% %p4% %p5% PORTUG~2%p6%       PORTUGU2.DLL%p7%
%1 %2 %p3% %p4% %p5% PORTUG~3%p6%       PORTUGUE.DLL%p7%
%1 %2 %p3% %p4% %p5% POU_EW~1%p6%       Pou_e.wav%p7%
%1 %2 %p3% %p4% %p5% POUCEW~1%p6%       Pouce.wav%p7%
%1 %2 %p3% %p4% %p5% PROFES~1%p6%       profes.htm%p7%
%1 %2 %p3% %p4% %p5% PROFES~2%p6%       Profes.jpg%p7%
%1 %2 %p3% %p4% %p5% PTE_WA~1%p6%       PTE_.wav%p7%
%1 %2 %p3% %p4% %p5% PTEYHT~1%p6%       Ptey.htm%p7%
%1 %2 %p3% %p4% %p5% PTEYJP~1%p6%       Ptey.jpg%p7%
%1 %2 %p3% %p4% %p5% QWERTY~1%p6%       QWERTY.JPG%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       Readme.htm%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README.NOW%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README.TXT%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README_.NOW%p7%
%1 %2 %p3% %p4% %p5% REDROS~1%p6%       redrose.htm%p7%
%1 %2 %p3% %p4% %p5% REDROS~2%p6%       redrose.jpg%p7%
%1 %2 %p3% %p4% %p5% REG_EW~1%p6%       reg_e.wav%p7%
%1 %2 %p3% %p4% %p5% RELIGI~1%p6%       religion.htm%p7%
%1 %2 %p3% %p4% %p5% RELIGI~2%p6%       religion.JPG%p7%
%1 %2 %p3% %p4% %p5% RESTSP~1%p6%       restspk.htm%p7%
%1 %2 %p3% %p4% %p5% RESTSP~2%p6%       Restspk.jpg%p7%
%1 %2 %p3% %p4% %p5% RESTVO~1%p6%       restvoc.htm%p7%
%1 %2 %p3% %p4% %p5% RESTVO~2%p6%       Restvoc.jpg%p7%
%1 %2 %p3% %p4% %p5% RIBSHT~1%p6%       ribs.htm%p7%
%1 %2 %p3% %p4% %p5% RIBSJP~1%p6%       ribs.jpg%p7%
%1 %2 %p3% %p4% %p5% RINGHT~1%p6%       ring.htm%p7%
%1 %2 %p3% %p4% %p5% RINGJP~1%p6%       ring.jpg%p7%
%1 %2 %p3% %p4% %p5% RUSSIA~1%p6%       RUSSIAN.DLL%p7%
%1 %2 %p3% %p4% %p5% RUSSIA~2%p6%       RUSSIAN_.DLL%p7%
%1 %2 %p3% %p4% %p5% SETKEY~1%p6%       Setkeyb.jpg%p7%
%1 %2 %p3% %p4% %p5% SETUPG~1%p6%       setup.GIF%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUPINF.INF%p7%
%1 %2 %p3% %p4% %p5% SETUPJ~1%p6%       setup.jpg%p7%
%1 %2 %p3% %p4% %p5% SHOULD~1%p6%       shoulder.htm%p7%
%1 %2 %p3% %p4% %p5% SHOULD~2%p6%       shoulder.jpg%p7%
%1 %2 %p3% %p4% %p5% SID_WA~1%p6%       sid_.wav%p7%
%1 %2 %p3% %p4% %p5% SIDAHT~1%p6%       sida.htm%p7%
%1 %2 %p3% %p4% %p5% SIDAJP~1%p6%       sida.jpg%p7%
%1 %2 %p3% %p4% %p5% SIDAWA~1%p6%       sida.wav%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~1%p6%       SLOVENE.DLL%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~2%p6%       SLOVENE_.DLL%p7%
%1 %2 %p3% %p4% %p5% SLOVEN~3%p6%       SLOVENE2.DLL%p7%
%1 %2 %p3% %p4% %p5% SOFTIS~1%p6%       softish.htm%p7%
%1 %2 %p3% %p4% %p5% SOFTIS~2%p6%       softish.jpg%p7%
%1 %2 %p3% %p4% %p5% SOU_CI~1%p6%       Sou_cil.wav%p7%
%1 %2 %p3% %p4% %p5% SOU_DW~1%p6%       Sou_d.wav%p7%
%1 %2 %p3% %p4% %p5% SOURCI~1%p6%       Sourcil.wav%p7%
%1 %2 %p3% %p4% %p5% SOURDW~1%p6%       Sourd.wav%p7%
%1 %2 %p3% %p4% %p5% STARTE~1%p6%       start.exe%p7%
%1 %2 %p3% %p4% %p5% STOMAC~1%p6%       stomach.htm%p7%
%1 %2 %p3% %p4% %p5% STOMAC~2%p6%       stomach.jpg%p7%
%1 %2 %p3% %p4% %p5% STUDEN~1%p6%       Students.mdb%p7%
%1 %2 %p3% %p4% %p5% SURINT~1%p6%       SURIN.TTF%p7%
%1 %2 %p3% %p4% %p5% SVENSK~1%p6%       SVENSKA.DLL%p7%
%1 %2 %p3% %p4% %p5% SVENSK~2%p6%       SVENSKA_.DLL%p7%
%1 %2 %p3% %p4% %p5% TAI_LE~1%p6%       Tai_le.wav%p7%
%1 %2 %p3% %p4% %p5% TAILLE~1%p6%       Taille.wav%p7%
%1 %2 %p3% %p4% %p5% TAL_NW~1%p6%       Tal_n.wav%p7%
%1 %2 %p3% %p4% %p5% TALONH~1%p6%       talon.htm%p7%
%1 %2 %p3% %p4% %p5% TALONJ~1%p6%       talon.jpg%p7%
%1 %2 %p3% %p4% %p5% TALONW~1%p6%       Talon.wav%p7%
%1 %2 %p3% %p4% %p5% TET_WA~1%p6%       Tet_.wav%p7%
%1 %2 %p3% %p4% %p5% TETEWA~1%p6%       Tete.wav%p7%
%1 %2 %p3% %p4% %p5% THIGHH~1%p6%       thigh.htm%p7%
%1 %2 %p3% %p4% %p5% THIGHJ~1%p6%       thigh.jpg%p7%
%1 %2 %p3% %p4% %p5% THUMBH~1%p6%       thumb.htm%p7%
%1 %2 %p3% %p4% %p5% THUMBJ~1%p6%       thumb.jpg%p7%
%1 %2 %p3% %p4% %p5% TOEHTM~1%p6%       toe.htm%p7%
%1 %2 %p3% %p4% %p5% TOEJPG~1%p6%       toe.jpg%p7%
%1 %2 %p3% %p4% %p5% TONGUE~1%p6%       tongue.htm%p7%
%1 %2 %p3% %p4% %p5% TONGUE~2%p6%       tongue.jpg%p7%
%1 %2 %p3% %p4% %p5% TOOTHH~1%p6%       tooth.htm%p7%
%1 %2 %p3% %p4% %p5% TOOTHJ~1%p6%       tooth.jpg%p7%
%1 %2 %p3% %p4% %p5% TOU_SE~1%p6%       tou_se.wav%p7%
%1 %2 %p3% %p4% %p5% TOUSSE~1%p6%       tousse.wav%p7%
%1 %2 %p3% %p4% %p5% TRE_VE~1%p6%       tre_vent.wav%p7%
%1 %2 %p3% %p4% %p5% TRESVE~1%p6%       tresvent.htm%p7%
%1 %2 %p3% %p4% %p5% TRESVE~2%p6%       tresvent.jpg%p7%
%1 %2 %p3% %p4% %p5% TRESVE~3%p6%       tresvent.wav%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~1%p6%       UKRAINE.DLL%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~2%p6%       UKRAINE_.DLL%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST.LNS%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       UNINST.RC%p7%
%1 %2 %p3% %p4% %p5% UNINST~3%p6%       UNINSTAL.EXE%p7%
%1 %2 %p3% %p4% %p5% URI_ER~1%p6%       uri_er.wav%p7%
%1 %2 %p3% %p4% %p5% URINER~1%p6%       uriner.wav%p7%
%1 %2 %p3% %p4% %p5% US1999~1%p6%       us1999.exe%p7%
%1 %2 %p3% %p4% %p5% US1999~2%p6%       us1999p.exe%p7%
%1 %2 %p3% %p4% %p5% US1JPG~1%p6%       us1.jpg%p7%
%1 %2 %p3% %p4% %p5% US2JPG~1%p6%       us2.jpg%p7%
%1 %2 %p3% %p4% %p5% US3JPG~1%p6%       us3.jpg%p7%
%1 %2 %p3% %p4% %p5% US4JPG~1%p6%       us4.jpg%p7%
%1 %2 %p3% %p4% %p5% US5JPG~1%p6%       us5.jpg%p7%
%1 %2 %p3% %p4% %p5% US6JPG~1%p6%       us6.jpg%p7%
%1 %2 %p3% %p4% %p5% US7JPG~1%p6%       us7.jpg%p7%
%1 %2 %p3% %p4% %p5% US8JPG~1%p6%       us8.jpg%p7%
%1 %2 %p3% %p4% %p5% USERWA~1%p6%       USER.WAV%p7%
%1 %2 %p3% %p4% %p5% USMDB~1%p6%        us.MDB%p7%
%1 %2 %p3% %p4% %p5% USMSG~1%p6%        US.MSG%p7%
%1 %2 %p3% %p4% %p5% USUELH~1%p6%       USUEL.htm%p7%
%1 %2 %p3% %p4% %p5% USUELJ~1%p6%       USUEL.jpg%p7%
%1 %2 %p3% %p4% %p5% VEN_RE~1%p6%       Ven_re.wav%p7%
%1 %2 %p3% %p4% %p5% VENTRE~1%p6%       Ventre.wav%p7%
%1 %2 %p3% %p4% %p5% VER_EB~1%p6%       Ver_ebre.wav%p7%
%1 %2 %p3% %p4% %p5% VER_IG~1%p6%       ver_ige.wav%p7%
%1 %2 %p3% %p4% %p5% VERTEB~1%p6%       vertebra.htm%p7%
%1 %2 %p3% %p4% %p5% VERTEB~2%p6%       vertebra.jpg%p7%
%1 %2 %p3% %p4% %p5% VERTEB~3%p6%       Vertebre.wav%p7%
%1 %2 %p3% %p4% %p5% VERTIG~1%p6%       vertige.wav%p7%
%1 %2 %p3% %p4% %p5% VOICEJ~1%p6%       voice.jpg%p7%
%1 %2 %p3% %p4% %p5% WAISTH~1%p6%       waist.htm%p7%
%1 %2 %p3% %p4% %p5% WAISTJ~1%p6%       waist.jpg%p7%
%1 %2 %p3% %p4% %p5% WB0051~1%p6%       WB00516_.GIF%p7%
%1 %2 %p3% %p4% %p5% WB01_4~1%p6%       WB01_41.GIF%p7%
%1 %2 %p3% %p4% %p5% WB0154~1%p6%       WB01541.gif%p7%
%1 %2 %p3% %p4% %p5% WB0154~2%p6%       WB01541_.GIF%p7%
%1 %2 %p3% %p4% %p5% WINSTA~1%p6%       WINSTALC.DLL%p7%
%1 %2 %p3% %p4% %p5% WINSTA~2%p6%       WINSTALL.inf%p7%
%1 %2 %p3% %p4% %p5% WINSTA~3%p6%       WINSTALL.LNS%p7%
%1 %2 %p3% %p4% %p5% WINSTA~4%p6%       WINSTALL.RC%p7%
%1 %2 %p3% %p4% %p5% WINSTA~5%p6%       WINSTALZ.DLL%p7%
%1 %2 %p3% %p4% %p5% WINSTL~1%p6%       WINSTL32.DLL%p7%
%1 %2 %p3% %p4% %p5% WRISTH~1%p6%       wrist.htm%p7%
%1 %2 %p3% %p4% %p5% WRISTJ~1%p6%       wrist.jpg%p7%
%1 %2 %p3% %p4% %p5% YORUBA~1%p6%       YORUBA.DLL%p7%

cd %dir6%

%1 %2 %p3% %p4% %p5% $BMPBG~1%p6%       $BMP.BGI%p7%
%1 %2 %p3% %p4% %p5% $CFXBG~1%p6%       $CFX.BGI%p7%
%1 %2 %p3% %p4% %p5% $CGMBG~1%p6%       $CGM.BGI%p7%
%1 %2 %p3% %p4% %p5% $CLQBG~1%p6%       $CLQ.BGI%p7%
%1 %2 %p3% %p4% %p5% $DJBGI~1%p6%       $DJ.BGI%p7%
%1 %2 %p3% %p4% %p5% $DJCBG~1%p6%       $DJC.BGI%p7%
%1 %2 %p3% %p4% %p5% $DXFBG~1%p6%       $DXF.BGI%p7%
%1 %2 %p3% %p4% %p5% $FXBGI~1%p6%       $FX.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP709~1%p6%       $HP7090.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP747~1%p6%       $HP7470.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP747~2%p6%       $HP7475.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP755~1%p6%       $HP7550.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP758~1%p6%       $HP7585.BGI%p7%
%1 %2 %p3% %p4% %p5% $HP759~1%p6%       $HP7595.BGI%p7%
%1 %2 %p3% %p4% %p5% $IBMQB~1%p6%       $IBMQ.BGI%p7%
%1 %2 %p3% %p4% %p5% $IMGBG~1%p6%       $IMG.BGI%p7%
%1 %2 %p3% %p4% %p5% $LJ3RB~1%p6%       $LJ3R.BGI%p7%
%1 %2 %p3% %p4% %p5% $LJ3RI~1%p6%       $LJ3R.INI%p7%
%1 %2 %p3% %p4% %p5% $LJBGI~1%p6%       $LJ.BGI%p7%
%1 %2 %p3% %p4% %p5% $LJINI~1%p6%       $LJ.INI%p7%
%1 %2 %p3% %p4% %p5% $LQBGI~1%p6%       $LQ.BGI%p7%
%1 %2 %p3% %p4% %p5% $OKI92~1%p6%       $OKI92.BGI%p7%
%1 %2 %p3% %p4% %p5% $PCXBG~1%p6%       $PCX.BGI%p7%
%1 %2 %p3% %p4% %p5% $PJBGI~1%p6%       $PJ.BGI%p7%
%1 %2 %p3% %p4% %p5% $PP24B~1%p6%       $PP24.BGI%p7%
%1 %2 %p3% %p4% %p5% $PSBGI~1%p6%       $PS.BGI%p7%
%1 %2 %p3% %p4% %p5% $PSINI~1%p6%       $PS.INI%p7%
%1 %2 %p3% %p4% %p5% $TIFBG~1%p6%       $TIF.BGI%p7%
%1 %2 %p3% %p4% %p5% $TSHBG~1%p6%       $TSH.BGI%p7%
%1 %2 %p3% %p4% %p5% $UTIFB~1%p6%       $UTIF.BGI%p7%
%1 %2 %p3% %p4% %p5% $VSHOB~1%p6%       $VSHO.BGI%p7%
%1 %2 %p3% %p4% %p5% $VSHOI~1%p6%       $VSHO.INI%p7%
%1 %2 %p3% %p4% %p5% $WPGBG~1%p6%       $WPG.BGI%p7%
%1 %2 %p3% %p4% %p5% 339741~1%p6%       3397414.DWG%p7%
%1 %2 %p3% %p4% %p5% 339741~2%p6%       3397414.DXF%p7%
%1 %2 %p3% %p4% %p5% AFRICA~1%p6%       AFRICA.ASC%p7%
%1 %2 %p3% %p4% %p5% AFRICA~2%p6%       AFRICA.ATT%p7%
%1 %2 %p3% %p4% %p5% AFRICA~3%p6%       AFRICA.BND%p7%
%1 %2 %p3% %p4% %p5% AFRICA~4%p6%       AFRICA.DAT%p7%
%1 %2 %p3% %p4% %p5% AFRICA~5%p6%       AFRICA.GEO%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~1%p6%       AIRPORTS.DAT%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~2%p6%       AIRPORTS.DBF%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~3%p6%       AIRPORTS.DBQ%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~4%p6%       AIRPORTS.DBT%p7%
%1 %2 %p3% %p4% %p5% AIRPOR~5%p6%       AIRPORTS.MDX%p7%
%1 %2 %p3% %p4% %p5% ALBANI~1%p6%       ALBANIA.BND%p7%
%1 %2 %p3% %p4% %p5% ALBANI~2%p6%       ALBANIA.LL%p7%
%1 %2 %p3% %p4% %p5% AMERIC~1%p6%       AMERICAS.BND%p7%
%1 %2 %p3% %p4% %p5% ANGOLA~1%p6%       ANGOLA.BND%p7%
%1 %2 %p3% %p4% %p5% ARGENT~1%p6%       ARGENTIN.BND%p7%
%1 %2 %p3% %p4% %p5% ASIABN~1%p6%       ASIA.BND%p7%
%1 %2 %p3% %p4% %p5% ATTBGI~1%p6%       ATT.BGI%p7%
%1 %2 %p3% %p4% %p5% AUSTRA~1%p6%       AUSTRALI.BND%p7%
%1 %2 %p3% %p4% %p5% AUSTRA~2%p6%       AUSTRALI.LL%p7%
%1 %2 %p3% %p4% %p5% AUSTRI~1%p6%       AUSTRIA.BND%p7%
%1 %2 %p3% %p4% %p5% AUSTRI~2%p6%       AUSTRIA.LL%p7%
%1 %2 %p3% %p4% %p5% BNDCVT~1%p6%       BNDCVT.EXE%p7%
%1 %2 %p3% %p4% %p5% BOLIVI~1%p6%       BOLIVIA.BND%p7%
%1 %2 %p3% %p4% %p5% BOTSWA~1%p6%       BOTSWANA.BND%p7%
%1 %2 %p3% %p4% %p5% BOUNDA~1%p6%       BOUNDARY.EXE%p7%
%1 %2 %p3% %p4% %p5% BOUNDX~1%p6%       BOUNDX.EXE%p7%
%1 %2 %p3% %p4% %p5% BRAZIL~1%p6%       BRAZIL.BND%p7%
%1 %2 %p3% %p4% %p5% BUILDB~1%p6%       BUILD.BAT%p7%
%1 %2 %p3% %p4% %p5% BULGAR~1%p6%       BULGARIA.BND%p7%
%1 %2 %p3% %p4% %p5% BULGAR~2%p6%       BULGARIA.LL%p7%
%1 %2 %p3% %p4% %p5% BURKIN~1%p6%       BURKINA.BND%p7%
%1 %2 %p3% %p4% %p5% BURKIN~2%p6%       BURKINA.LL%p7%
%1 %2 %p3% %p4% %p5% C16BV1~1%p6%       C16BV1.DAT%p7%
%1 %2 %p3% %p4% %p5% C16BV2~1%p6%       C16BV2.DAT%p7%
%1 %2 %p3% %p4% %p5% C16BV3~1%p6%       C16BV3.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV1~1%p6%       C16SV1.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV1~2%p6%       C16SV1.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV2~1%p6%       C16SV2.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV2~2%p6%       C16SV2.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV3~1%p6%       C16SV3.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV3~2%p6%       C16SV3.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV4~1%p6%       C16SV4.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV4~2%p6%       C16SV4.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV5~1%p6%       C16SV5.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV5~2%p6%       C16SV5.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV6~1%p6%       C16SV6.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV6~2%p6%       C16SV6.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV7~1%p6%       C16SV7.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV7~2%p6%       C16SV7.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV8~1%p6%       C16SV8.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV8~2%p6%       C16SV8.DEV%p7%
%1 %2 %p3% %p4% %p5% C16SV9~1%p6%       C16SV9.DAT%p7%
%1 %2 %p3% %p4% %p5% C16SV9~2%p6%       C16SV9.DEV%p7%
%1 %2 %p3% %p4% %p5% C256BV~1%p6%       C256BV1.DAT%p7%
%1 %2 %p3% %p4% %p5% C256BV~2%p6%       C256BV1.DEV%p7%
%1 %2 %p3% %p4% %p5% C256BV~3%p6%       C256BV2.DAT%p7%
%1 %2 %p3% %p4% %p5% C256BV~4%p6%       C256BV2.DEV%p7%
%1 %2 %p3% %p4% %p5% C256BV~5%p6%       C256BV3.DAT%p7%
%1 %2 %p3% %p4% %p5% C256BV~6%p6%       C256BV3.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~10%p6%       C256SV4.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~11%p6%       C256SV5.DAT%p7%
%1 %2 %p3% %p4% %p5% C256S~12%p6%       C256SV5.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~13%p6%       C256SV6.DAT%p7%
%1 %2 %p3% %p4% %p5% C256S~14%p6%       C256SV6.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~15%p6%       C256SV7.DAT%p7%
%1 %2 %p3% %p4% %p5% C256S~16%p6%       C256SV7.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~17%p6%       C256SV8.DAT%p7%
%1 %2 %p3% %p4% %p5% C256S~18%p6%       C256SV8.DEV%p7%
%1 %2 %p3% %p4% %p5% C256S~19%p6%       C256SV9.DAT%p7%
%1 %2 %p3% %p4% %p5% C256S~20%p6%       C256SV9.DEV%p7%
%1 %2 %p3% %p4% %p5% C256SV~1%p6%       C256SV1.DAT%p7%
%1 %2 %p3% %p4% %p5% C256SV~2%p6%       C256SV1.DEV%p7%
%1 %2 %p3% %p4% %p5% C256SV~3%p6%       C256SV10.DAT%p7%
%1 %2 %p3% %p4% %p5% C256SV~4%p6%       C256SV10.DEV%p7%
%1 %2 %p3% %p4% %p5% C256SV~5%p6%       C256SV2.DAT%p7%
%1 %2 %p3% %p4% %p5% C256SV~6%p6%       C256SV2.DEV%p7%
%1 %2 %p3% %p4% %p5% C256SV~7%p6%       C256SV3.DAT%p7%
%1 %2 %p3% %p4% %p5% C256SV~8%p6%       C256SV3.DEV%p7%
%1 %2 %p3% %p4% %p5% C256SV~9%p6%       C256SV4.DAT%p7%
%1 %2 %p3% %p4% %p5% CABND~1%p6%        CA.BND%p7%
%1 %2 %p3% %p4% %p5% CAMBOD~1%p6%       CAMBODIA.BND%p7%
%1 %2 %p3% %p4% %p5% CAMBOD~2%p6%       CAMBODIA.LL%p7%
%1 %2 %p3% %p4% %p5% CAMERO~1%p6%       CAMEROON.BND%p7%
%1 %2 %p3% %p4% %p5% CANARY~1%p6%       CANARYI.BND%p7%
%1 %2 %p3% %p4% %p5% CANARY~2%p6%       CANARYI.LL%p7%
%1 %2 %p3% %p4% %p5% CAPITA~1%p6%       CAPITALS.DBF%p7%
%1 %2 %p3% %p4% %p5% CARBND~1%p6%       CAR.BND%p7%
%1 %2 %p3% %p4% %p5% CARDSD~1%p6%       CARDS.DBF%p7%
%1 %2 %p3% %p4% %p5% CB5DLL~1%p6%       CB5.DLL%p7%
%1 %2 %p3% %p4% %p5% CDISK~10%p6%       CDISK19.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~1%p6%       CDISK01.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~2%p6%       CDISK02.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~3%p6%       CDISK03.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~4%p6%       CDISK04.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~5%p6%       CDISK05.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~6%p6%       CDISK06.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~7%p6%       CDISK07.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~8%p6%       CDISK08.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK0~9%p6%       CDISK09.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~1%p6%       CDISK10.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~2%p6%       CDISK11.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~3%p6%       CDISK12.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~4%p6%       CDISK13.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~5%p6%       CDISK14.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~6%p6%       CDISK15.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~7%p6%       CDISK16.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~8%p6%       CDISK17.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK1~9%p6%       CDISK18.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~1%p6%       CDISK20.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~2%p6%       CDISK21.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~3%p6%       CDISK22.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~4%p6%       CDISK23.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~5%p6%       CDISK24.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~6%p6%       CDISK25.BAT%p7%
%1 %2 %p3% %p4% %p5% CDISK2~7%p6%       CDISK26.BAT%p7%
%1 %2 %p3% %p4% %p5% CGABGI~1%p6%       CGA.BGI%p7%
%1 %2 %p3% %p4% %p5% CHILEB~1%p6%       CHILE.BND%p7%
%1 %2 %p3% %p4% %p5% CHINAB~1%p6%       CHINA.BND%p7%
%1 %2 %p3% %p4% %p5% CHINAL~1%p6%       CHINA.LL%p7%
%1 %2 %p3% %p4% %p5% CIRCLE~1%p6%       CIRCLE.DAT%p7%
%1 %2 %p3% %p4% %p5% CIRCLE~2%p6%       CIRCLE.MRK%p7%
%1 %2 %p3% %p4% %p5% CITIES~1%p6%       CITIES.DAT%p7%
%1 %2 %p3% %p4% %p5% CITY_0~1%p6%       CITY_0.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_0~2%p6%       CITY_0.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_1~1%p6%       CITY_1.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_1~2%p6%       CITY_1.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_1~3%p6%       CITY_10.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_1~4%p6%       CITY_10.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_1~5%p6%       CITY_100.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_1~6%p6%       CITY_100.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_B~1%p6%       CITY_BIG.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_B~2%p6%       CITY_BIG.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_C~1%p6%       CITY_CAP.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY_C~2%p6%       CITY_CAP.MDX%p7%
%1 %2 %p3% %p4% %p5% CITY_L~1%p6%       CITY_LOC.DBF%p7%
%1 %2 %p3% %p4% %p5% CITY1D~1%p6%       CITY1.DBQ%p7%
%1 %2 %p3% %p4% %p5% CITY2D~1%p6%       CITY2.DBQ%p7%
%1 %2 %p3% %p4% %p5% CITY3D~1%p6%       CITY3.DBQ%p7%
%1 %2 %p3% %p4% %p5% CITYCA~1%p6%       CITYCAPS.DBF%p7%
%1 %2 %p3% %p4% %p5% CITYCA~2%p6%       CITYCAPS.MDX%p7%
%1 %2 %p3% %p4% %p5% CITYCA~3%p6%       CITYCAPS.MP1%p7%
%1 %2 %p3% %p4% %p5% CITYCA~4%p6%       CITYCAPS.MP3%p7%
%1 %2 %p3% %p4% %p5% CNSDAT~1%p6%       CNS.DAT%p7%
%1 %2 %p3% %p4% %p5% COLOMB~1%p6%       COLOMBIA.BND%p7%
%1 %2 %p3% %p4% %p5% COLORS~1%p6%       COLORS.MAP%p7%
%1 %2 %p3% %p4% %p5% COLUMB~1%p6%       COLUMBUS.MP3%p7%
%1 %2 %p3% %p4% %p5% COMBIN~1%p6%       COMBINED.MP3%p7%
%1 %2 %p3% %p4% %p5% COMIND~1%p6%       COMINDST.BND%p7%
%1 %2 %p3% %p4% %p5% COMIND~2%p6%       COMINDST.LL%p7%
%1 %2 %p3% %p4% %p5% COMPLE~1%p6%       COMPLEXI.CHR%p7%
%1 %2 %p3% %p4% %p5% COMPLE~2%p6%       COMPLEXR.CHR%p7%
%1 %2 %p3% %p4% %p5% COMPLE~3%p6%       COMPLEXS.CHR%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG.SYS%p7%
%1 %2 %p3% %p4% %p5% CONGOB~1%p6%       CONGO.BND%p7%
%1 %2 %p3% %p4% %p5% COORDC~1%p6%       COORDCHG.DOC%p7%
%1 %2 %p3% %p4% %p5% COORDC~2%p6%       COORDCHG.EXE%p7%
%1 %2 %p3% %p4% %p5% COPYMA~1%p6%       COPYMAP.EXE%p7%
%1 %2 %p3% %p4% %p5% COUNTR~1%p6%       COUNTRY.DBQ%p7%
%1 %2 %p3% %p4% %p5% COUNTR~2%p6%       COUNTRY_.DBF%p7%
%1 %2 %p3% %p4% %p5% COUNTR~3%p6%       COUNTRY_.DBT%p7%
%1 %2 %p3% %p4% %p5% COUNTR~4%p6%       COUNTRY_.MDX%p7%
%1 %2 %p3% %p4% %p5% COUNTR~5%p6%       COUNTRYL.DBF%p7%
%1 %2 %p3% %p4% %p5% COUNTR~6%p6%       COUNTRYL.MDX%p7%
%1 %2 %p3% %p4% %p5% COUNTY~1%p6%       COUNTY.DBQ%p7%
%1 %2 %p3% %p4% %p5% COUNTY~2%p6%       COUNTYLO.DBF%p7%
%1 %2 %p3% %p4% %p5% COUNTY~3%p6%       COUNTYLO.DBT%p7%
%1 %2 %p3% %p4% %p5% COUNTY~4%p6%       COUNTYLO.MDX%p7%
%1 %2 %p3% %p4% %p5% COUR_C~1%p6%       COUR_CGA.FON%p7%
%1 %2 %p3% %p4% %p5% COUR_E~1%p6%       COUR_EGA.FON%p7%
%1 %2 %p3% %p4% %p5% COUR_V~1%p6%       COUR_VGA.FON%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~1%p6%       CSIMBV1.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~2%p6%       CSIMBV1.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~3%p6%       CSIMBV2.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~4%p6%       CSIMBV2.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~5%p6%       CSIMBV3.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMBV~6%p6%       CSIMBV3.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMS~10%p6%       CSIMSV5.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMS~11%p6%       CSIMSV6.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMS~12%p6%       CSIMSV6.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMS~13%p6%       CSIMSV7.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMS~14%p6%       CSIMSV7.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMS~15%p6%       CSIMSV8.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMS~16%p6%       CSIMSV8.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMS~17%p6%       CSIMSV9.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMS~18%p6%       CSIMSV9.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~1%p6%       CSIMSV1.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~2%p6%       CSIMSV1.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~3%p6%       CSIMSV2.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~4%p6%       CSIMSV2.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~5%p6%       CSIMSV3.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~6%p6%       CSIMSV3.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~7%p6%       CSIMSV4.DAT%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~8%p6%       CSIMSV4.DEV%p7%
%1 %2 %p3% %p4% %p5% CSIMSV~9%p6%       CSIMSV5.DAT%p7%
%1 %2 %p3% %p4% %p5% CUBABN~1%p6%       CUBA.BND%p7%
%1 %2 %p3% %p4% %p5% CUBALL~1%p6%       CUBA.LL%p7%
%1 %2 %p3% %p4% %p5% CULTUR~1%p6%       CULTURAL.DBF%p7%
%1 %2 %p3% %p4% %p5% CULTUR~2%p6%       CULTURAL.DBT%p7%
%1 %2 %p3% %p4% %p5% CULTUR~3%p6%       CULTURAL.MDX%p7%
%1 %2 %p3% %p4% %p5% CZECHO~1%p6%       CZECHOSL.BND%p7%
%1 %2 %p3% %p4% %p5% CZECHO~2%p6%       CZECHOSL.LL%p7%
%1 %2 %p3% %p4% %p5% CZVGAS~1%p6%       CZVGAS1.DAT%p7%
%1 %2 %p3% %p4% %p5% DASHED~1%p6%       DASHED.PEN%p7%
%1 %2 %p3% %p4% %p5% DAYSIM~1%p6%       DAY.SIM%p7%
%1 %2 %p3% %p4% %p5% DEFAUL~1%p6%       DEFAULT.DEV%p7%
%1 %2 %p3% %p4% %p5% DEFHAR~1%p6%       DEFHARD.DEV%p7%
%1 %2 %p3% %p4% %p5% DEMO10~1%p6%       DEMO10.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO10~2%p6%       DEMO10.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO11~1%p6%       DEMO11.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO11~2%p6%       DEMO11.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO12~1%p6%       DEMO12.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO12~2%p6%       DEMO12.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO12~3%p6%       DEMO123.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMO12~4%p6%       DEMO123.WK1%p7%
%1 %2 %p3% %p4% %p5% DEMO13~1%p6%       DEMO13.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO13~2%p6%       DEMO13.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO15~1%p6%       DEMO15.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO15~2%p6%       DEMO15.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO1R~1%p6%       DEMO1.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO20~1%p6%       DEMO20.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO20~2%p6%       DEMO20.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO22~1%p6%       DEMO22.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO22~2%p6%       DEMO22.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO23~1%p6%       DEMO23.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO23~2%p6%       DEMO23.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO25~1%p6%       DEMO25.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO25~2%p6%       DEMO25.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO30~1%p6%       DEMO30.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO30~2%p6%       DEMO30.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO40~1%p6%       DEMO40.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO40~2%p6%       DEMO40.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO45~1%p6%       DEMO45.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO45~2%p6%       DEMO45.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO50~1%p6%       DEMO50.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO50~2%p6%       DEMO50.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO52~1%p6%       DEMO52.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO52~2%p6%       DEMO52.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO55~1%p6%       DEMO55.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO55~2%p6%       DEMO55.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO60~1%p6%       DEMO60.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO60~2%p6%       DEMO60.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO61~1%p6%       DEMO61.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO61~2%p6%       DEMO61.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO62~1%p6%       DEMO62.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO62~2%p6%       DEMO62.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO70~1%p6%       DEMO70.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO70~2%p6%       DEMO70.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO75~1%p6%       DEMO75.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO75~2%p6%       DEMO75.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO80~1%p6%       DEMO80.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO80~2%p6%       DEMO80.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO85~1%p6%       DEMO85.RAS%p7%
%1 %2 %p3% %p4% %p5% DEMO85~2%p6%       DEMO85.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMO98~1%p6%       DEMO98.TXT%p7%
%1 %2 %p3% %p4% %p5% DEMOAD~1%p6%       DEMOADDR.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOAT~1%p6%       DEMOATTR.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOBN~1%p6%       DEMO.BND%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~1%p6%       DEMOCOLN.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~2%p6%       DEMOCOMB.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOCO~3%p6%       DEMOCOMD.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMODE~1%p6%       DEMO.DEF%p7%
%1 %2 %p3% %p4% %p5% DEMODO~1%p6%       DEMO.DOC%p7%
%1 %2 %p3% %p4% %p5% DEMOFC~1%p6%       DEMOFC.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOFI~1%p6%       DEMOFIG.MAP%p7%
%1 %2 %p3% %p4% %p5% DEMOGI~1%p6%       DEMOGINA.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOLA~1%p6%       DEMOLAMM.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOLI~1%p6%       DEMOLINE.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOMP~1%p6%       DEMO.MP3%p7%
%1 %2 %p3% %p4% %p5% DEMOMT~1%p6%       DEMOMTCH.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMONA~1%p6%       DEMONAME.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOPO~1%p6%       DEMOPOIN.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMORE~1%p6%       DEMO.REC%p7%
%1 %2 %p3% %p4% %p5% DEMOSA~1%p6%       DEMOSASA.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOSA~2%p6%       DEMOSASG.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOTE~1%p6%       DEMOTEXT.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOTY~1%p6%       DEMOTYPE.SIM%p7%
%1 %2 %p3% %p4% %p5% DEMOZO~1%p6%       DEMOZONE.DAT%p7%
%1 %2 %p3% %p4% %p5% DEMOZS~1%p6%       DEMOZSEG.DAT%p7%
%1 %2 %p3% %p4% %p5% DIAMON~1%p6%       DIAMOND.DAT%p7%
%1 %2 %p3% %p4% %p5% DIAMON~2%p6%       DIAMOND.MRK%p7%
%1 %2 %p3% %p4% %p5% DISK01~1%p6%       DISK01.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK02~1%p6%       DISK02.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK03~1%p6%       DISK03.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK04~1%p6%       DISK04.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK05~1%p6%       DISK05.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK06~1%p6%       DISK06.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK07~1%p6%       DISK07.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK08~1%p6%       DISK08.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK09~1%p6%       DISK09.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK10~1%p6%       DISK10.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK11~1%p6%       DISK11.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK12~1%p6%       DISK12.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK13~1%p6%       DISK13.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK14~1%p6%       DISK14.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK15~1%p6%       DISK15.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK16~1%p6%       DISK16.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK17~1%p6%       DISK17.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK18~1%p6%       DISK18.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK19~1%p6%       DISK19.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK20~1%p6%       DISK20.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK21~1%p6%       DISK21.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK22~1%p6%       DISK22.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK23~1%p6%       DISK23.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK24~1%p6%       DISK24.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK25~1%p6%       DISK25.BAT%p7%
%1 %2 %p3% %p4% %p5% DISK26~1%p6%       DISK26.BAT%p7%
%1 %2 %p3% %p4% %p5% DOUBLE~1%p6%       DOUBLE.MAP%p7%
%1 %2 %p3% %p4% %p5% DPMI16~1%p6%       DPMI16BI.OVL%p7%
%1 %2 %p3% %p4% %p5% DRAINP~1%p6%       DRAINPT.DBF%p7%
%1 %2 %p3% %p4% %p5% DRAINP~2%p6%       DRAINPT.DBT%p7%
%1 %2 %p3% %p4% %p5% DRAINP~3%p6%       DRAINPT.MDX%p7%
%1 %2 %p3% %p4% %p5% DRAINT~1%p6%       DRAINTXT.DBF%p7%
%1 %2 %p3% %p4% %p5% DRAINT~2%p6%       DRAINTXT.DBT%p7%
%1 %2 %p3% %p4% %p5% DRAINT~3%p6%       DRAINTXT.MDX%p7%
%1 %2 %p3% %p4% %p5% DS1DOC~1%p6%       DS1.DOC%p7%
%1 %2 %p3% %p4% %p5% DS2DOC~1%p6%       DS2.DOC%p7%
%1 %2 %p3% %p4% %p5% DS3DOC~1%p6%       DS3.DOC%p7%
%1 %2 %p3% %p4% %p5% DS4DOC~1%p6%       DS4.DOC%p7%
%1 %2 %p3% %p4% %p5% DUPLEX~1%p6%       DUPLEXR.CHR%p7%
%1 %2 %p3% %p4% %p5% ECUADO~1%p6%       ECUADOR.BND%p7%
%1 %2 %p3% %p4% %p5% EGAINT~1%p6%       EGAINTER.INI%p7%
%1 %2 %p3% %p4% %p5% EGAOZG~1%p6%       EGAOZGIS.INI%p7%
%1 %2 %p3% %p4% %p5% EGASCN~1%p6%       EGA.SCN%p7%
%1 %2 %p3% %p4% %p5% EGAVGA~1%p6%       EGAVGA.BGI%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~1%p6%       EMAPINFO.FIL%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~2%p6%       EMAPINFO.INS%p7%
%1 %2 %p3% %p4% %p5% EMAPIN~3%p6%       EMAPINFO.TXT%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~1%p6%       EPIMAP.CFG%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~2%p6%       EPIMAP.DOC%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~3%p6%       EPIMAP.DRV%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~4%p6%       EPIMAP.EXE%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~5%p6%       EPIMAP.HLP%p7%
%1 %2 %p3% %p4% %p5% EPIMAP~6%p6%       EPIMAP.OVR%p7%
%1 %2 %p3% %p4% %p5% EUROPE~1%p6%       EUROPE.BND%p7%
%1 %2 %p3% %p4% %p5% EXTEND~1%p6%       EXTENDED.MP3%p7%
%1 %2 %p3% %p4% %p5% FALKLA~1%p6%       FALKLAND.BND%p7%
%1 %2 %p3% %p4% %p5% FEA-AD~1%p6%       FEA-A.DAT%p7%
%1 %2 %p3% %p4% %p5% FEA-GD~1%p6%       FEA-G.DAT%p7%
%1 %2 %p3% %p4% %p5% FEAATT~1%p6%       FEA.ATT%p7%
%1 %2 %p3% %p4% %p5% FEAGEO~1%p6%       FEA.GEO%p7%
%1 %2 %p3% %p4% %p5% FGUIAN~1%p6%       FGUIANA.BND%p7%
%1 %2 %p3% %p4% %p5% FIGEDI~1%p6%       FIGEDIT.EXE%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_ID_.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_ID2.DIZ%p7%
%1 %2 %p3% %p4% %p5% FNKEYS~1%p6%       FNKEYS.DOC%p7%
%1 %2 %p3% %p4% %p5% FRANCE~1%p6%       FRANCE.BND%p7%
%1 %2 %p3% %p4% %p5% FRANCE~2%p6%       FRANCE.LL%p7%
%1 %2 %p3% %p4% %p5% GARMIN~1%p6%       GARMIN.TRK%p7%
%1 %2 %p3% %p4% %p5% GARMIN~2%p6%       GARMIN.WPT%p7%
%1 %2 %p3% %p4% %p5% GDHEAD~1%p6%       GDHEAD.DXF%p7%
%1 %2 %p3% %p4% %p5% GDHEAD~2%p6%       GDHEAD.PS%p7%
%1 %2 %p3% %p4% %p5% GEOCOD~1%p6%       GEOCODE.EXE%p7%
%1 %2 %p3% %p4% %p5% GEORGI~1%p6%       GEORGIA.BND%p7%
%1 %2 %p3% %p4% %p5% GEORGI~2%p6%       GEORGIA.REC%p7%
%1 %2 %p3% %p4% %p5% GEOTOE~1%p6%       GEOTOENT.EXE%p7%
%1 %2 %p3% %p4% %p5% GEOTOM~1%p6%       GEOTOMP1.EXE%p7%
%1 %2 %p3% %p4% %p5% GERMAN~1%p6%       GERMANY.BND%p7%
%1 %2 %p3% %p4% %p5% GERMAN~2%p6%       GERMANY.LL%p7%
%1 %2 %p3% %p4% %p5% GETMOD~1%p6%       GETMODE.EXE%p7%
%1 %2 %p3% %p4% %p5% GOOSES~1%p6%       GOOSE.SIM%p7%
%1 %2 %p3% %p4% %p5% GPS1LO~1%p6%       GPS1.LOG%p7%
%1 %2 %p3% %p4% %p5% GPS2NM~1%p6%       GPS2.NME%p7%
%1 %2 %p3% %p4% %p5% GPS3NM~1%p6%       GPS3.NME%p7%
%1 %2 %p3% %p4% %p5% GPSCGA~1%p6%       GPSCGA.EXE%p7%
%1 %2 %p3% %p4% %p5% GPSCGA~2%p6%       GPSCGA.HLP%p7%
%1 %2 %p3% %p4% %p5% GPSEXE~1%p6%       GPS.EXE%p7%
%1 %2 %p3% %p4% %p5% GPSLOG~1%p6%       GPS.LOG%p7%
%1 %2 %p3% %p4% %p5% GRIDCG~1%p6%       GRID.CGA%p7%
%1 %2 %p3% %p4% %p5% GROUPS~1%p6%       GROUPS.DAT%p7%
%1 %2 %p3% %p4% %p5% GUAMAD~1%p6%       GUAMAD.BND%p7%
%1 %2 %p3% %p4% %p5% GUAMVB~1%p6%       GUAMV.BND%p7%
%1 %2 %p3% %p4% %p5% GUINEA~1%p6%       GUINEA.BND%p7%
%1 %2 %p3% %p4% %p5% GUYANA~1%p6%       GUYANA.BND%p7%
%1 %2 %p3% %p4% %p5% HATCHB~1%p6%       HATCHBV1.DAT%p7%
%1 %2 %p3% %p4% %p5% HATCHB~2%p6%       HATCHBV1.DEV%p7%
%1 %2 %p3% %p4% %p5% HATCHS~1%p6%       HATCHSV1.DAT%p7%
%1 %2 %p3% %p4% %p5% HATCHS~2%p6%       HATCHSV1.DEV%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~1%p6%       HAWDLGAB.DAT%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~2%p6%       HAWDLGAB.GEO%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~3%p6%       HAWDLGRD.DAT%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~4%p6%       HAWDLGRD.GEO%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~5%p6%       HAWDLGST.DAT%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~6%p6%       HAWDLGST.GEO%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~7%p6%       HAWDLGWB.DAT%p7%
%1 %2 %p3% %p4% %p5% HAWDLG~8%p6%       HAWDLGWB.GEO%p7%
%1 %2 %p3% %p4% %p5% HBARDA~1%p6%       HBAR.DAT%p7%
%1 %2 %p3% %p4% %p5% HBARMR~1%p6%       HBAR.MRK%p7%
%1 %2 %p3% %p4% %p5% HELV_C~1%p6%       HELV_CGA.FON%p7%
%1 %2 %p3% %p4% %p5% HELV_E~1%p6%       HELV_EGA.FON%p7%
%1 %2 %p3% %p4% %p5% HELV_V~1%p6%       HELV_VGA.FON%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~1%p6%       HEPRATES.BAT%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~2%p6%       HEPRATES.MAP%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~3%p6%       HEPRATES.PGM%p7%
%1 %2 %p3% %p4% %p5% HEPRAT~4%p6%       HEPRATES.REC%p7%
%1 %2 %p3% %p4% %p5% HERCBG~1%p6%       HERC.BGI%p7%
%1 %2 %p3% %p4% %p5% HONDUR~1%p6%       HONDURAS.BND%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~1%p6%       HOSPITAL.BND%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~2%p6%       HOSPITAL.MAP%p7%
%1 %2 %p3% %p4% %p5% HOSPIT~3%p6%       HOSPITAL.REC%p7%
%1 %2 %p3% %p4% %p5% HUNGAR~1%p6%       HUNGARY.BND%p7%
%1 %2 %p3% %p4% %p5% HUNGAR~2%p6%       HUNGARY.LL%p7%
%1 %2 %p3% %p4% %p5% IBM851~1%p6%       IBM8514.BGI%p7%
%1 %2 %p3% %p4% %p5% INDEXD~1%p6%       INDEX.DOC%p7%
%1 %2 %p3% %p4% %p5% INDONE~1%p6%       INDONESI.BND%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.BAT%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTALL.EXE%p7%
%1 %2 %p3% %p4% %p5% INTERA~1%p6%       INTERACT.INI%p7%
%1 %2 %p3% %p4% %p5% IRANBN~1%p6%       IRAN.BND%p7%
%1 %2 %p3% %p4% %p5% IRANLL~1%p6%       IRAN.LL%p7%
%1 %2 %p3% %p4% %p5% IVORYB~1%p6%       IVORY.BND%p7%
%1 %2 %p3% %p4% %p5% KENYAB~1%p6%       KENYA.BND%p7%
%1 %2 %p3% %p4% %p5% LAND_C~1%p6%       LAND_COV.DBF%p7%
%1 %2 %p3% %p4% %p5% LAND_C~2%p6%       LAND_COV.DBT%p7%
%1 %2 %p3% %p4% %p5% LAND_C~3%p6%       LAND_COV.MDX%p7%
%1 %2 %p3% %p4% %p5% LAOSBN~1%p6%       LAOS.BND%p7%
%1 %2 %p3% %p4% %p5% LAOSLL~1%p6%       LAOS.LL%p7%
%1 %2 %p3% %p4% %p5% LIBERI~1%p6%       LIBERIA.BND%p7%
%1 %2 %p3% %p4% %p5% LIBYAB~1%p6%       LIBYA.BND%p7%
%1 %2 %p3% %p4% %p5% LIBYAL~1%p6%       LIBYA.LL%p7%
%1 %2 %p3% %p4% %p5% LINETY~1%p6%       LINETYPE.MP3%p7%
%1 %2 %p3% %p4% %p5% LOGOSY~1%p6%       LOGO.SYS%p7%
%1 %2 %p3% %p4% %p5% LOWE-A~1%p6%       LOWE-A1.DAT%p7%
%1 %2 %p3% %p4% %p5% LOWE-A~2%p6%       LOWE-A2.DAT%p7%
%1 %2 %p3% %p4% %p5% LOWE-G~1%p6%       LOWE-G.DAT%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~1%p6%       LOWE-S1.DAT%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~2%p6%       LOWE-S1.GEO%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~3%p6%       LOWE-S2.DAT%p7%
%1 %2 %p3% %p4% %p5% LOWE-S~4%p6%       LOWE-S2.GEO%p7%
%1 %2 %p3% %p4% %p5% LOWE1A~1%p6%       LOWE1.ATT%p7%
%1 %2 %p3% %p4% %p5% LOWE2A~1%p6%       LOWE2.ATT%p7%
%1 %2 %p3% %p4% %p5% LOWEGE~1%p6%       LOWE.GEO%p7%
%1 %2 %p3% %p4% %p5% MADAGA~1%p6%       MADAGASC.BND%p7%
%1 %2 %p3% %p4% %p5% MAF000~1%p6%       MAF000.%p7%
%1 %2 %p3% %p4% %p5% MALAWI~1%p6%       MALAWI.BND%p7%
%1 %2 %p3% %p4% %p5% MALAYE~1%p6%       MALAYE.LL%p7%
%1 %2 %p3% %p4% %p5% MALAYS~1%p6%       MALAYSIA.BND%p7%
%1 %2 %p3% %p4% %p5% MALAYW~1%p6%       MALAYW.LL%p7%
%1 %2 %p3% %p4% %p5% MALIBN~1%p6%       MALI.BND%p7%
%1 %2 %p3% %p4% %p5% MAPDAT~1%p6%       MAPDATA.DOC%p7%
%1 %2 %p3% %p4% %p5% MAPIT7~1%p6%       MAPIT7.DOC%p7%
%1 %2 %p3% %p4% %p5% MAPITB~1%p6%       MAPIT.BAT%p7%
%1 %2 %p3% %p4% %p5% MAPITD~1%p6%       MAPIT.DOC%p7%
%1 %2 %p3% %p4% %p5% MAPITS~1%p6%       MAPIT.SAV%p7%
%1 %2 %p3% %p4% %p5% MAPITT~1%p6%       MAPIT.TXT%p7%
%1 %2 %p3% %p4% %p5% MCGASC~1%p6%       MCGA.SCN%p7%
%1 %2 %p3% %p4% %p5% MEXICO~1%p6%       MEXICO.BND%p7%
%1 %2 %p3% %p4% %p5% MEXICO~2%p6%       MEXICO.LL%p7%
%1 %2 %p3% %p4% %p5% MHRSCN~1%p6%       MHR.SCN%p7%
%1 %2 %p3% %p4% %p5% MINDEF~1%p6%       MIN.DEF%p7%
%1 %2 %p3% %p4% %p5% MONGOL~1%p6%       MONGOLIA.BND%p7%
%1 %2 %p3% %p4% %p5% MONGOL~2%p6%       MONGOLIA.LL%p7%
%1 %2 %p3% %p4% %p5% MOZAMB~1%p6%       MOZAMBIQ.BND%p7%
%1 %2 %p3% %p4% %p5% MP1TOM~1%p6%       MP1TOMP3.EXE%p7%
%1 %2 %p3% %p4% %p5% MSHERC~1%p6%       MSHERC.COM%p7%
%1 %2 %p3% %p4% %p5% MYPINS~1%p6%       MYPINS.DBF%p7%
%1 %2 %p3% %p4% %p5% MYPINS~2%p6%       MYPINS.DBT%p7%
%1 %2 %p3% %p4% %p5% MYPINS~3%p6%       MYPINS.MDX%p7%
%1 %2 %p3% %p4% %p5% NABLAD~1%p6%       NABLA.DAT%p7%
%1 %2 %p3% %p4% %p5% NABLAM~1%p6%       NABLA.MRK%p7%
%1 %2 %p3% %p4% %p5% NAMIBI~1%p6%       NAMIBIA.BND%p7%
%1 %2 %p3% %p4% %p5% NEWYOR~1%p6%       NEWYORK.INF%p7%
%1 %2 %p3% %p4% %p5% NEWYOR~2%p6%       NEWYORK.T30%p7%
%1 %2 %p3% %p4% %p5% NIGERI~1%p6%       NIGERIA.BND%p7%
%1 %2 %p3% %p4% %p5% NKOREA~1%p6%       NKOREA.BND%p7%
%1 %2 %p3% %p4% %p5% NKOREA~2%p6%       NKOREA.LL%p7%
%1 %2 %p3% %p4% %p5% NMETOM~1%p6%       NMETOMP1.EXE%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~1%p6%       OCEAN_FE.DBF%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~2%p6%       OCEAN_FE.DBT%p7%
%1 %2 %p3% %p4% %p5% OCEAN_~3%p6%       OCEAN_FE.MDX%p7%
%1 %2 %p3% %p4% %p5% ORBITS~1%p6%       ORBITS.SIM%p7%
%1 %2 %p3% %p4% %p5% ORBITS~2%p6%       ORBITS1.SIM%p7%
%1 %2 %p3% %p4% %p5% ORDER_~1%p6%       ORDER_.DOC%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       ORDER.DOC%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       ORDERFRM.DOC%p7%
%1 %2 %p3% %p4% %p5% OZ-ADA~1%p6%       OZ-A.DAT%p7%
%1 %2 %p3% %p4% %p5% OZ-GDA~1%p6%       OZ-G.DAT%p7%
%1 %2 %p3% %p4% %p5% OZAPID~1%p6%       OZAPI.DOC%p7%
%1 %2 %p3% %p4% %p5% OZATT~1%p6%        OZ.ATT%p7%
%1 %2 %p3% %p4% %p5% OZCENS~1%p6%       OZCENSUS.BAT%p7%
%1 %2 %p3% %p4% %p5% OZCENS~2%p6%       OZCENSUS.CMD%p7%
%1 %2 %p3% %p4% %p5% OZCMB~1%p6%        OZ.CMB%p7%
%1 %2 %p3% %p4% %p5% OZDEMO~1%p6%       OZDEMO.EXE%p7%
%1 %2 %p3% %p4% %p5% OZENTE~1%p6%       OZENTER.EXE%p7%
%1 %2 %p3% %p4% %p5% OZGEO~1%p6%        OZ.GEO%p7%
%1 %2 %p3% %p4% %p5% OZGIS~10%p6%       OZGIS29.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~1%p6%       OZGIS10.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~2%p6%       OZGIS12.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~3%p6%       OZGIS14.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~4%p6%       OZGIS15.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~5%p6%       OZGIS16.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS1~6%p6%       OZGIS18.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~1%p6%       OZGIS2.DAT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~2%p6%       OZGIS20.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~3%p6%       OZGIS21.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~4%p6%       OZGIS22.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~5%p6%       OZGIS23.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~6%p6%       OZGIS24.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~7%p6%       OZGIS25.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~8%p6%       OZGIS26.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS2~9%p6%       OZGIS28.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS3~1%p6%       OZGIS30.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS3~2%p6%       OZGIS35.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS4~1%p6%       OZGIS40.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS5~1%p6%       OZGIS50.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS5~2%p6%       OZGIS52.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS6~1%p6%       OZGIS60.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS6~2%p6%       OZGIS65.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS7~1%p6%       OZGIS70.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS7~2%p6%       OZGIS75.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS8~1%p6%       OZGIS80.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS8~2%p6%       OZGIS85.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~1%p6%       OZGIS91.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~2%p6%       OZGIS92.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGIS9~3%p6%       OZGIS93.TUT%p7%
%1 %2 %p3% %p4% %p5% OZGISB~1%p6%       OZGIS.BAT%p7%
%1 %2 %p3% %p4% %p5% OZGISC~1%p6%       OZGIS.CMD%p7%
%1 %2 %p3% %p4% %p5% OZGISD~1%p6%       OZGIS.DOC%p7%
%1 %2 %p3% %p4% %p5% OZGISI~1%p6%       OZGIS.INI%p7%
%1 %2 %p3% %p4% %p5% OZGISM~1%p6%       OZGIS.MEN%p7%
%1 %2 %p3% %p4% %p5% OZGISP~1%p6%       OZGISPRG.EXE%p7%
%1 %2 %p3% %p4% %p5% OZWHIC~1%p6%       OZWHICH.CMD%p7%
%1 %2 %p3% %p4% %p5% PAKIST~1%p6%       PAKISTAN.BND%p7%
%1 %2 %p3% %p4% %p5% PAKIST~2%p6%       PAKISTAN.LL%p7%
%1 %2 %p3% %p4% %p5% PARAGU~1%p6%       PARAGUAY.BND%p7%
%1 %2 %p3% %p4% %p5% PC3270~1%p6%       PC3270.BGI%p7%
%1 %2 %p3% %p4% %p5% PERUBN~1%p6%       PERU.BND%p7%
%1 %2 %p3% %p4% %p5% PLACEN~1%p6%       PLACENAM.DBQ%p7%
%1 %2 %p3% %p4% %p5% PLUSDA~1%p6%       PLUS.DAT%p7%
%1 %2 %p3% %p4% %p5% PLUSMR~1%p6%       PLUS.MRK%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~1%p6%       PO_TEXT.DBF%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~2%p6%       PO_TEXT.DBT%p7%
%1 %2 %p3% %p4% %p5% PO_TEX~3%p6%       PO_TEXT.MDX%p7%
%1 %2 %p3% %p4% %p5% POLAND~1%p6%       POLAND.BND%p7%
%1 %2 %p3% %p4% %p5% POPPLA~1%p6%       POPPLACE.DBF%p7%
%1 %2 %p3% %p4% %p5% POPPLA~2%p6%       POPPLACE.DBT%p7%
%1 %2 %p3% %p4% %p5% POPPLA~3%p6%       POPPLACE.MDX%p7%
%1 %2 %p3% %p4% %p5% POPREC~1%p6%       POP.REC%p7%
%1 %2 %p3% %p4% %p5% PREVRE~1%p6%       PREV.REC%p7%
%1 %2 %p3% %p4% %p5% PRINTE~1%p6%       PRINTER.DAT%p7%
%1 %2 %p3% %p4% %p5% PUERTO~1%p6%       PUERTORI.BND%p7%
%1 %2 %p3% %p4% %p5% READ_M~1%p6%       READ_ME.1ST%p7%
%1 %2 %p3% %p4% %p5% READ_M~2%p6%       READ_ME.BAT%p7%
%1 %2 %p3% %p4% %p5% READCO~1%p6%       READ.COM%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       READ.ME%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       README.%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README.1ST%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README.TXT%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README_2.TXT%p7%
%1 %2 %p3% %p4% %p5% REGION~1%p6%       REGIONS.BND%p7%
%1 %2 %p3% %p4% %p5% REGION~2%p6%       REGIONS.MAP%p7%
%1 %2 %p3% %p4% %p5% REGION~3%p6%       REGIONS.REC%p7%
%1 %2 %p3% %p4% %p5% REGIST~1%p6%       REGISTER.DOC%p7%
%1 %2 %p3% %p4% %p5% REGIST~2%p6%       REGISTER.TXT%p7%
%1 %2 %p3% %p4% %p5% ROMANI~1%p6%       ROMANIA.BND%p7%
%1 %2 %p3% %p4% %p5% ROMANI~2%p6%       ROMANIA.LL%p7%
%1 %2 %p3% %p4% %p5% RTMEXE~1%p6%       RTM.EXE%p7%
%1 %2 %p3% %p4% %p5% SAFRIC~1%p6%       SAFRICA.BND%p7%
%1 %2 %p3% %p4% %p5% SAMERI~1%p6%       SAMERICA.BND%p7%
%1 %2 %p3% %p4% %p5% SARABI~1%p6%       SARABIA.BND%p7%
%1 %2 %p3% %p4% %p5% SARABI~2%p6%       SARABIA.LL%p7%
%1 %2 %p3% %p4% %p5% SCANTA~1%p6%       SCANTABL.DBF%p7%
%1 %2 %p3% %p4% %p5% SCANTA~2%p6%       SCANTABL.MDX%p7%
%1 %2 %p3% %p4% %p5% SCDSCN~1%p6%       SCD.SCN%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~1%p6%       SEAS_MAJ.DBF%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~2%p6%       SEAS_MAJ.DBT%p7%
%1 %2 %p3% %p4% %p5% SEAS_M~3%p6%       SEAS_MAJ.MDX%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       SIMPLEXR.CHR%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       SIMPLEXS.CHR%p7%
%1 %2 %p3% %p4% %p5% SIMULA~1%p6%       SIMULATE.EXE%p7%
%1 %2 %p3% %p4% %p5% SLEONE~1%p6%       SLEONE.BND%p7%
%1 %2 %p3% %p4% %p5% SMAPIT~1%p6%       SMAPIT.EXE%p7%
%1 %2 %p3% %p4% %p5% SPAINB~1%p6%       SPAIN.BND%p7%
%1 %2 %p3% %p4% %p5% SPAINL~1%p6%       SPAIN.LL%p7%
%1 %2 %p3% %p4% %p5% SPECIA~1%p6%       SPECIAL.PT%p7%
%1 %2 %p3% %p4% %p5% SQUARE~1%p6%       SQUARE.DAT%p7%
%1 %2 %p3% %p4% %p5% SQUARE~2%p6%       SQUARE.MRK%p7%
%1 %2 %p3% %p4% %p5% STANDA~1%p6%       STANDARD.CHR%p7%
%1 %2 %p3% %p4% %p5% STATEL~1%p6%       STATELOC.DBF%p7%
%1 %2 %p3% %p4% %p5% STATEL~2%p6%       STATELOC.DBT%p7%
%1 %2 %p3% %p4% %p5% STATEL~3%p6%       STATELOC.MDX%p7%
%1 %2 %p3% %p4% %p5% STATES~1%p6%       STATES.DBQ%p7%
%1 %2 %p3% %p4% %p5% STDFIG~1%p6%       STD.FIG%p7%
%1 %2 %p3% %p4% %p5% STDFNT~1%p6%       STD.FNT%p7%
%1 %2 %p3% %p4% %p5% STDPEN~1%p6%       STD.PEN%p7%
%1 %2 %p3% %p4% %p5% STF1AP~1%p6%       STF1A.PRM%p7%
%1 %2 %p3% %p4% %p5% STPBND~1%p6%       STP.BND%p7%
%1 %2 %p3% %p4% %p5% SUBAFR~1%p6%       SUBAFR.BND%p7%
%1 %2 %p3% %p4% %p5% SURINA~1%p6%       SURINAME.BND%p7%
%1 %2 %p3% %p4% %p5% SURVDB~1%p6%       SURVDB.REC%p7%
%1 %2 %p3% %p4% %p5% SWEDEN~1%p6%       SWEDEN.BND%p7%
%1 %2 %p3% %p4% %p5% SWEDEN~2%p6%       SWEDEN.LL%p7%
%1 %2 %p3% %p4% %p5% SYMBOL~1%p6%       SYMBOL.DWG%p7%
%1 %2 %p3% %p4% %p5% SYMBOL~2%p6%       SYMBOL.DXF%p7%
%1 %2 %p3% %p4% %p5% TANZAN~1%p6%       TANZANIA.BND%p7%
%1 %2 %p3% %p4% %p5% TEMPDA~1%p6%       TEMP.DAT%p7%
%1 %2 %p3% %p4% %p5% TEMPDB~1%p6%       TEMP.DBF%p7%
%1 %2 %p3% %p4% %p5% TEMPRA~1%p6%       TEMP.RAS%p7%
%1 %2 %p3% %p4% %p5% TEST1D~1%p6%       TEST1.DEF%p7%
%1 %2 %p3% %p4% %p5% TEST2D~1%p6%       TEST2.DEF%p7%
%1 %2 %p3% %p4% %p5% TEST3D~1%p6%       TEST3.DEF%p7%
%1 %2 %p3% %p4% %p5% TEST4D~1%p6%       TEST4.DEF%p7%
%1 %2 %p3% %p4% %p5% TESTDE~1%p6%       TEST.DEF%p7%
%1 %2 %p3% %p4% %p5% TOPBAT~1%p6%       TOP.BAT%p7%
%1 %2 %p3% %p4% %p5% TOPOEX~1%p6%       TOPO.EXE%p7%
%1 %2 %p3% %p4% %p5% TOPOTX~1%p6%       TOPO.TXT%p7%
%1 %2 %p3% %p4% %p5% TOWERS~1%p6%       TOWERS.DBF%p7%
%1 %2 %p3% %p4% %p5% TOWERS~2%p6%       TOWERS.DBQ%p7%
%1 %2 %p3% %p4% %p5% TOWERS~3%p6%       TOWERS.DBT%p7%
%1 %2 %p3% %p4% %p5% TOWERS~4%p6%       TOWERS.MDX%p7%
%1 %2 %p3% %p4% %p5% TRANSP~1%p6%       TRANSPOR.DBF%p7%
%1 %2 %p3% %p4% %p5% TRANSP~2%p6%       TRANSPOR.DBT%p7%
%1 %2 %p3% %p4% %p5% TRANSP~3%p6%       TRANSPOR.MDX%p7%
%1 %2 %p3% %p4% %p5% TRIANG~1%p6%       TRIANGLE.DAT%p7%
%1 %2 %p3% %p4% %p5% TRIANG~2%p6%       TRIANGLE.MRK%p7%
%1 %2 %p3% %p4% %p5% TRIPLE~1%p6%       TRIPLEXI.CHR%p7%
%1 %2 %p3% %p4% %p5% TRIPLE~2%p6%       TRIPLEXR.CHR%p7%
%1 %2 %p3% %p4% %p5% TURKEY~1%p6%       TURKEY.BND%p7%
%1 %2 %p3% %p4% %p5% TURKEY~2%p6%       TURKEY.LL%p7%
%1 %2 %p3% %p4% %p5% UG1REC~1%p6%       UG1.REC%p7%
%1 %2 %p3% %p4% %p5% UG2REC~1%p6%       UG2.REC%p7%
%1 %2 %p3% %p4% %p5% UG3REC~1%p6%       UG3.REC%p7%
%1 %2 %p3% %p4% %p5% UG4REC~1%p6%       UG4.REC%p7%
%1 %2 %p3% %p4% %p5% UG5REC~1%p6%       UG5.REC%p7%
%1 %2 %p3% %p4% %p5% UG6REC~1%p6%       UG6.REC%p7%
%1 %2 %p3% %p4% %p5% UGANDA~1%p6%       UGANDA.BND%p7%
%1 %2 %p3% %p4% %p5% UGANDB~1%p6%       UGAND.BND%p7%
%1 %2 %p3% %p4% %p5% UGDATA~1%p6%       UGDATA.REC%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~1%p6%       UKRAINE.BND%p7%
%1 %2 %p3% %p4% %p5% UKRAIN~2%p6%       UKRAINE.LL%p7%
%1 %2 %p3% %p4% %p5% URUGUA~1%p6%       URUGUAY.BND%p7%
%1 %2 %p3% %p4% %p5% USABND~1%p6%       USA.BND%p7%
%1 %2 %p3% %p4% %p5% USACGA~1%p6%       USA.CGA%p7%
%1 %2 %p3% %p4% %p5% USAINI~1%p6%       USA.INI%p7%
%1 %2 %p3% %p4% %p5% USAIRS~1%p6%       USAIR.SIM%p7%
%1 %2 %p3% %p4% %p5% USAKBN~1%p6%       USAK.BND%p7%
%1 %2 %p3% %p4% %p5% USALBN~1%p6%       USAL.BND%p7%
%1 %2 %p3% %p4% %p5% USALL~1%p6%        USA.LL%p7%
%1 %2 %p3% %p4% %p5% USALOG~1%p6%       USA.LOG%p7%
%1 %2 %p3% %p4% %p5% USAMAT~1%p6%       USAMATCH.PRM%p7%
%1 %2 %p3% %p4% %p5% USARBN~1%p6%       USAR.BND%p7%
%1 %2 %p3% %p4% %p5% USARES~1%p6%       USA.RES%p7%
%1 %2 %p3% %p4% %p5% USAZBN~1%p6%       USAZ.BND%p7%
%1 %2 %p3% %p4% %p5% USCABN~1%p6%       USCA.BND%p7%
%1 %2 %p3% %p4% %p5% USCOBN~1%p6%       USCO.BND%p7%
%1 %2 %p3% %p4% %p5% USCTBN~1%p6%       USCT.BND%p7%
%1 %2 %p3% %p4% %p5% USDCBN~1%p6%       USDC.BND%p7%
%1 %2 %p3% %p4% %p5% USDEBN~1%p6%       USDE.BND%p7%
%1 %2 %p3% %p4% %p5% USFLBN~1%p6%       USFL.BND%p7%
%1 %2 %p3% %p4% %p5% USGABN~1%p6%       USGA.BND%p7%
%1 %2 %p3% %p4% %p5% USHIBN~1%p6%       USHI.BND%p7%
%1 %2 %p3% %p4% %p5% USIABN~1%p6%       USIA.BND%p7%
%1 %2 %p3% %p4% %p5% USIDBN~1%p6%       USID.BND%p7%
%1 %2 %p3% %p4% %p5% USILBN~1%p6%       USIL.BND%p7%
%1 %2 %p3% %p4% %p5% USINBN~1%p6%       USIN.BND%p7%
%1 %2 %p3% %p4% %p5% USKSBN~1%p6%       USKS.BND%p7%
%1 %2 %p3% %p4% %p5% USKYBN~1%p6%       USKY.BND%p7%
%1 %2 %p3% %p4% %p5% USLABN~1%p6%       USLA.BND%p7%
%1 %2 %p3% %p4% %p5% USMABN~1%p6%       USMA.BND%p7%
%1 %2 %p3% %p4% %p5% USMDBN~1%p6%       USMD.BND%p7%
%1 %2 %p3% %p4% %p5% USMEBN~1%p6%       USME.BND%p7%
%1 %2 %p3% %p4% %p5% USMIBN~1%p6%       USMI.BND%p7%
%1 %2 %p3% %p4% %p5% USMNBN~1%p6%       USMN.BND%p7%
%1 %2 %p3% %p4% %p5% USMOBN~1%p6%       USMO.BND%p7%
%1 %2 %p3% %p4% %p5% USMSBN~1%p6%       USMS.BND%p7%
%1 %2 %p3% %p4% %p5% USMTBN~1%p6%       USMT.BND%p7%
%1 %2 %p3% %p4% %p5% USNCBN~1%p6%       USNC.BND%p7%
%1 %2 %p3% %p4% %p5% USNDBN~1%p6%       USND.BND%p7%
%1 %2 %p3% %p4% %p5% USNEBN~1%p6%       USNE.BND%p7%
%1 %2 %p3% %p4% %p5% USNHBN~1%p6%       USNH.BND%p7%
%1 %2 %p3% %p4% %p5% USNJBN~1%p6%       USNJ.BND%p7%
%1 %2 %p3% %p4% %p5% USNMBN~1%p6%       USNM.BND%p7%
%1 %2 %p3% %p4% %p5% USNVBN~1%p6%       USNV.BND%p7%
%1 %2 %p3% %p4% %p5% USNYBN~1%p6%       USNY.BND%p7%
%1 %2 %p3% %p4% %p5% USOHBN~1%p6%       USOH.BND%p7%
%1 %2 %p3% %p4% %p5% USOKBN~1%p6%       USOK.BND%p7%
%1 %2 %p3% %p4% %p5% USORBN~1%p6%       USOR.BND%p7%
%1 %2 %p3% %p4% %p5% USPABN~1%p6%       USPA.BND%p7%
%1 %2 %p3% %p4% %p5% USRIBN~1%p6%       USRI.BND%p7%
%1 %2 %p3% %p4% %p5% USSCBN~1%p6%       USSC.BND%p7%
%1 %2 %p3% %p4% %p5% USSDBN~1%p6%       USSD.BND%p7%
%1 %2 %p3% %p4% %p5% USTNBN~1%p6%       USTN.BND%p7%
%1 %2 %p3% %p4% %p5% USTXBN~1%p6%       USTX.BND%p7%
%1 %2 %p3% %p4% %p5% USUTBN~1%p6%       USUT.BND%p7%
%1 %2 %p3% %p4% %p5% USVABN~1%p6%       USVA.BND%p7%
%1 %2 %p3% %p4% %p5% USVTBN~1%p6%       USVT.BND%p7%
%1 %2 %p3% %p4% %p5% USWABN~1%p6%       USWA.BND%p7%
%1 %2 %p3% %p4% %p5% USWIBN~1%p6%       USWI.BND%p7%
%1 %2 %p3% %p4% %p5% USWVBN~1%p6%       USWV.BND%p7%
%1 %2 %p3% %p4% %p5% USWYBN~1%p6%       USWY.BND%p7%
%1 %2 %p3% %p4% %p5% UTILIT~1%p6%       UTILITY.DBF%p7%
%1 %2 %p3% %p4% %p5% UTILIT~2%p6%       UTILITY.DBT%p7%
%1 %2 %p3% %p4% %p5% UTILIT~3%p6%       UTILITY.MDX%p7%
%1 %2 %p3% %p4% %p5% VBARDA~1%p6%       VBAR.DAT%p7%
%1 %2 %p3% %p4% %p5% VBARMR~1%p6%       VBAR.MRK%p7%
%1 %2 %p3% %p4% %p5% VENDIN~1%p6%       VENDINFO.DIZ%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       VENDOR.DOC%p7%
%1 %2 %p3% %p4% %p5% VENDOR~2%p6%       VENDOR.TXT%p7%
%1 %2 %p3% %p4% %p5% VENEZU~1%p6%       VENEZUEL.BND%p7%
%1 %2 %p3% %p4% %p5% VGASCN~1%p6%       VGA.SCN%p7%
%1 %2 %p3% %p4% %p5% VICRAI~1%p6%       VICRAIL.DXF%p7%
%1 %2 %p3% %p4% %p5% VICSHI~1%p6%       VICSHIRE.DXF%p7%
%1 %2 %p3% %p4% %p5% VICTOW~1%p6%       VICTOWN.DXF%p7%
%1 %2 %p3% %p4% %p5% VIDEOD~1%p6%       VIDEO.DAT%p7%
%1 %2 %p3% %p4% %p5% VIETNA~1%p6%       VIETNAM.BND%p7%
%1 %2 %p3% %p4% %p5% VMAP_F~1%p6%       VMAP_FIX.MP1%p7%
%1 %2 %p3% %p4% %p5% VMAP_F~2%p6%       VMAP_FIX.MPS%p7%
%1 %2 %p3% %p4% %p5% VMAPDO~1%p6%       VMAP.DOC%p7%
%1 %2 %p3% %p4% %p5% VMAPEX~1%p6%       VMAP.EXE%p7%
%1 %2 %p3% %p4% %p5% VMAPFA~1%p6%       VMAPFAST.MAP%p7%
%1 %2 %p3% %p4% %p5% VMAPMA~1%p6%       VMAP.MAP%p7%
%1 %2 %p3% %p4% %p5% VMAPRE~1%p6%       VMAPREAD.ME%p7%
%1 %2 %p3% %p4% %p5% VMAPUS~1%p6%       VMAPUSER.PRN%p7%
%1 %2 %p3% %p4% %p5% VMVEND~1%p6%       VMVENDOR.DOC%p7%
%1 %2 %p3% %p4% %p5% WASHRA~1%p6%       WASHRAIL.GEO%p7%
%1 %2 %p3% %p4% %p5% WASHRO~1%p6%       WASHROAD.GEO%p7%
%1 %2 %p3% %p4% %p5% WASHTR~1%p6%       WASHTRAC.ATT%p7%
%1 %2 %p3% %p4% %p5% WASHTR~2%p6%       WASHTRAC.GEO%p7%
%1 %2 %p3% %p4% %p5% WEEKSM~1%p6%       WEEKS.MAP%p7%
%1 %2 %p3% %p4% %p5% WINBVD~1%p6%       WINBV.DAT%p7%
%1 %2 %p3% %p4% %p5% WINBVD~2%p6%       WINBV.DEV%p7%
%1 %2 %p3% %p4% %p5% WINSVD~1%p6%       WINSV.DAT%p7%
%1 %2 %p3% %p4% %p5% WINSVD~2%p6%       WINSV.DEV%p7%
%1 %2 %p3% %p4% %p5% WORLDB~1%p6%       WORLD.BND%p7%
%1 %2 %p3% %p4% %p5% WORLDD~1%p6%       WORLD.DAT%p7%
%1 %2 %p3% %p4% %p5% WOTSNE~1%p6%       WOTSNEW.DOC%p7%
%1 %2 %p3% %p4% %p5% X11-BG~1%p6%       X11-BGR.DAT%p7%
%1 %2 %p3% %p4% %p5% XLISTD~1%p6%       XLIST.DBF%p7%
%1 %2 %p3% %p4% %p5% XLISTM~1%p6%       XLIST.MDX%p7%
%1 %2 %p3% %p4% %p5% YEARSI~1%p6%       YEAR.SIM%p7%
%1 %2 %p3% %p4% %p5% YUGOSL~1%p6%       YUGOSLAV.BND%p7%
%1 %2 %p3% %p4% %p5% YUGOSL~2%p6%       YUGOSLAV.LL%p7%
%1 %2 %p3% %p4% %p5% ZAIREB~1%p6%       ZAIRE.BND%p7%
%1 %2 %p3% %p4% %p5% ZIMBAB~1%p6%       ZIMBABWE.BND%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~1%p6%       ZPHONE1.DBQ%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~2%p6%       ZPHONE2.DBQ%p7%
%1 %2 %p3% %p4% %p5% ZPHONE~3%p6%       ZPHONE3.DBQ%p7%

cd %dir7%

%1 %2 %p3% %p4% %p5% ACMSET~1%p6%       ACMSETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% ACMSET~2%p6%       acmsetup.hlp%p7%
%1 %2 %p3% %p4% %p5% ADMINI~1%p6%       admin.INF%p7%
%1 %2 %p3% %p4% %p5% ASYCFI~1%p6%       asycfilt.dll%p7%
%1 %2 %p3% %p4% %p5% CMPICO~1%p6%       CMPICO.ICO%p7%
%1 %2 %p3% %p4% %p5% COMCAT~1%p6%       comcat.dll%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D32.DLL%p7%
%1 %2 %p3% %p4% %p5% DAO253~1%p6%       DAO2535.TLB%p7%
%1 %2 %p3% %p4% %p5% DAO350~1%p6%       DAO350.DLL%p7%
%1 %2 %p3% %p4% %p5% DATAMD~1%p6%       DATA.MDE%p7%
%1 %2 %p3% %p4% %p5% EXPAND~1%p6%       expand.exe%p7%
%1 %2 %p3% %p4% %p5% GR8409~1%p6%       gr8409.dll%p7%
%1 %2 %p3% %p4% %p5% GR8GAL~1%p6%       gr8galry.gra%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~1%p6%       graph8.exe%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~2%p6%       graph8.olb%p7%
%1 %2 %p3% %p4% %p5% GRAPH8~3%p6%       graph8rt.srg%p7%
%1 %2 %p3% %p4% %p5% GRINTL~1%p6%       GRINTL32.DLL%p7%
%1 %2 %p3% %p4% %p5% HLINKD~1%p6%       HLINK.DLL%p7%
%1 %2 %p3% %p4% %p5% HLINKP~1%p6%       HLINKPRX.DLL%p7%
%1 %2 %p3% %p4% %p5% HLINKS~1%p6%       hlink.srg%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       Install.bat%p7%
%1 %2 %p3% %p4% %p5% MFCANS~1%p6%       MFCANS32.DLL%p7%
%1 %2 %p3% %p4% %p5% MISC2S~1%p6%       MISC2.SRG%p7%
%1 %2 %p3% %p4% %p5% MISCSR~1%p6%       misc.srg%p7%
%1 %2 %p3% %p4% %p5% MPADI3~1%p6%       MPADI32.DLL%p7%
%1 %2 %p3% %p4% %p5% MPANG3~1%p6%       MPANG32.CFG%p7%
%1 %2 %p3% %p4% %p5% MRT7EN~1%p6%       mrt7enu.dll%p7%
%1 %2 %p3% %p4% %p5% MSACC8~1%p6%       MSACC8.OLB%p7%
%1 %2 %p3% %p4% %p5% MSACCC~1%p6%       msacccah.dll%p7%
%1 %2 %p3% %p4% %p5% MSACCE~1%p6%       MSACCESS.EXE%p7%
%1 %2 %p3% %p4% %p5% MSACCE~2%p6%       MSACCESS.SRG%p7%
%1 %2 %p3% %p4% %p5% MSACNV~1%p6%       MSACNV30.DLL%p7%
%1 %2 %p3% %p4% %p5% MSACNV~2%p6%       MSACNV30.EXE%p7%
%1 %2 %p3% %p4% %p5% MSAEXP~1%p6%       MSAEXP30.DLL%p7%
%1 %2 %p3% %p4% %p5% MSAIN8~1%p6%       MSAIN800.DLL%p7%
%1 %2 %p3% %p4% %p5% MSJET3~1%p6%       MSJET35.DLL%p7%
%1 %2 %p3% %p4% %p5% MSJINT~1%p6%       MSJINT35.DLL%p7%
%1 %2 %p3% %p4% %p5% MSJTER~1%p6%       MSJTER35.DLL%p7%
%1 %2 %p3% %p4% %p5% MSO97R~1%p6%       mso97rt.dll%p7%
%1 %2 %p3% %p4% %p5% MSODEU~1%p6%       msodeusa.dll%p7%
%1 %2 %p3% %p4% %p5% MSOFFI~1%p6%       msoffice.srg%p7%
%1 %2 %p3% %p4% %p5% MSRD2X~1%p6%       MSRD2x35.DLL%p7%
%1 %2 %p3% %p4% %p5% MSREPL~1%p6%       MSREPL35.DLL%p7%
%1 %2 %p3% %p4% %p5% MSSETU~1%p6%       mssetup.dll%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~1%p6%       msvcrt20.dll%p7%
%1 %2 %p3% %p4% %p5% MSVCRT~2%p6%       msvcrt40.dll%p7%
%1 %2 %p3% %p4% %p5% OLEAUT~1%p6%       oleaut32.dll%p7%
%1 %2 %p3% %p4% %p5% OLEPRO~1%p6%       olepro32.dll%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README.txt%p7%
%1 %2 %p3% %p4% %p5% SCP32D~1%p6%       scp32.dll%p7%
%1 %2 %p3% %p4% %p5% SELFRE~1%p6%       SELFREG.DLL%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       setup.exe%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       setup.INF%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       setup.ini%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       setup.LST%p7%
%1 %2 %p3% %p4% %p5% SETUPS~1%p6%       setup.STF%p7%
%1 %2 %p3% %p4% %p5% SETUPT~1%p6%       setup.tdf%p7%
%1 %2 %p3% %p4% %p5% SOA800~1%p6%       SOA800.DLL%p7%
%1 %2 %p3% %p4% %p5% STDOLE~1%p6%       stdole2.tlb%p7%
%1 %2 %p3% %p4% %p5% SYSICO~1%p6%       SYSICON.ICO%p7%
%1 %2 %p3% %p4% %p5% TAHOMA~1%p6%       tahoma.ttf%p7%
%1 %2 %p3% %p4% %p5% TAHOMA~2%p6%       tahomabd.ttf%p7%
%1 %2 %p3% %p4% %p5% TASKMA~1%p6%       TASKMA~1.CNT%p7%
%1 %2 %p3% %p4% %p5% TASKMA~2%p6%       TASKMA~1.HLP%p7%
%1 %2 %p3% %p4% %p5% TASKMA~3%p6%       Taskma~1.mde%p7%
%1 %2 %p3% %p4% %p5% TASKMA~4%p6%       TASKMA~1.MDW%p7%
%1 %2 %p3% %p4% %p5% URLMON~1%p6%       urlmon.dll%p7%
%1 %2 %p3% %p4% %p5% UTILIT~1%p6%       UTILITY.MDA%p7%
%1 %2 %p3% %p4% %p5% VBA332~1%p6%       VBA332.DLL%p7%
%1 %2 %p3% %p4% %p5% VBA3EN~1%p6%       VBA3EN.DLL%p7%
%1 %2 %p3% %p4% %p5% VBACV2~1%p6%       VBACV20.DLL%p7%
%1 %2 %p3% %p4% %p5% VSETUP~1%p6%       VSetupT.exe%p7%
%1 %2 %p3% %p4% %p5% W95FIB~1%p6%       W95FIBER.DLL%p7%
%1 %2 %p3% %p4% %p5% WININE~1%p6%       wininet.dll%p7%
%1 %2 %p3% %p4% %p5% WINSSP~1%p6%       WINSSPI.DLL%p7%
%1 %2 %p3% %p4% %p5% WPSYSD~1%p6%       WPSysDat.mde%p7%
%1 %2 %p3% %p4% %p5% WRKGAD~1%p6%       wrkgadm.exe%p7%

cd %dir8%

%1 %2 %p3% %p4% %p5% _C_BOU~1%p6%       _C_BOUND.GIF%p7%
%1 %2 %p3% %p4% %p5% _C_FIG~1%p6%       _C_FIGUR.GIF%p7%
%1 %2 %p3% %p4% %p5% _C_GEN~1%p6%       _C_GENER.GIF%p7%
%1 %2 %p3% %p4% %p5% _C_SEL~1%p6%       _C_SELEC.GIF%p7%
%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _inst32i.ex_%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _isdel.exe%p7%
%1 %2 %p3% %p4% %p5% _ISREG~1%p6%       _ISREG32.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUSE~1%p6%       _ISUSER.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _setup.dll%p7%
%1 %2 %p3% %p4% %p5% _SETUP~2%p6%       _setup.lib%p7%
%1 %2 %p3% %p4% %p5% AGEO~1%p6%         a.geo%p7%
%1 %2 %p3% %p4% %p5% AKCGIS~1%p6%       AKC.GIS%p7%
%1 %2 %p3% %p4% %p5% AKZGIS~1%p6%       AKZ.GIS%p7%
%1 %2 %p3% %p4% %p5% ALCGIS~1%p6%       ALC.GIS%p7%
%1 %2 %p3% %p4% %p5% ALZGIS~1%p6%       ALZ.GIS%p7%
%1 %2 %p3% %p4% %p5% ANDROM~1%p6%       ANDROMED.%p7%
%1 %2 %p3% %p4% %p5% ANGSEP~1%p6%       ANGSEP.GIF%p7%
%1 %2 %p3% %p4% %p5% ARCGIS~1%p6%       ARC.GIS%p7%
%1 %2 %p3% %p4% %p5% ARZGIS~1%p6%       ARZ.GIS%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       Autorun.inf%p7%
%1 %2 %p3% %p4% %p5% AXISMA~1%p6%       AXIS.MAP%p7%
%1 %2 %p3% %p4% %p5% AZCGIS~1%p6%       AZC.GIS%p7%
%1 %2 %p3% %p4% %p5% AZZGIS~1%p6%       AZZ.GIS%p7%
%1 %2 %p3% %p4% %p5% BDWARF~1%p6%       BDWARFS.SSD%p7%
%1 %2 %p3% %p4% %p5% BGEO~1%p6%         b.geo%p7%
%1 %2 %p3% %p4% %p5% BOOKGI~1%p6%       BOOK.GIF%p7%
%1 %2 %p3% %p4% %p5% BOTBAR~1%p6%       BOTBAR.GIF%p7%
%1 %2 %p3% %p4% %p5% C_CONT~1%p6%       C_CONTEN.GIF%p7%
%1 %2 %p3% %p4% %p5% C_CUST~1%p6%       C_CUSTOM.GIF%p7%
%1 %2 %p3% %p4% %p5% C_DEMO~1%p6%       C_DEMOS.GIF%p7%
%1 %2 %p3% %p4% %p5% C_DISP~1%p6%       C_DISPLA.GIF%p7%
%1 %2 %p3% %p4% %p5% C_EDIT~1%p6%       C_EDIT.GIF%p7%
%1 %2 %p3% %p4% %p5% C_EXER~1%p6%       C_EXERCI.GIF%p7%
%1 %2 %p3% %p4% %p5% C_FAQG~1%p6%       C_FAQ.GIF%p7%
%1 %2 %p3% %p4% %p5% C_FILE~1%p6%       C_FILE.GIF%p7%
%1 %2 %p3% %p4% %p5% C_FIND~1%p6%       C_FIND.GIF%p7%
%1 %2 %p3% %p4% %p5% C_GUID~1%p6%       C_GUIDES.GIF%p7%
%1 %2 %p3% %p4% %p5% C_INDE~1%p6%       C_INDEX.GIF%p7%
%1 %2 %p3% %p4% %p5% C_INFO~1%p6%       C_INFO.GIF%p7%
%1 %2 %p3% %p4% %p5% C_INST~1%p6%       C_INSTAL.GIF%p7%
%1 %2 %p3% %p4% %p5% C_INTR~1%p6%       C_INTRO.GIF%p7%
%1 %2 %p3% %p4% %p5% C_LICE~1%p6%       C_LICENS.GIF%p7%
%1 %2 %p3% %p4% %p5% C_LIVE~1%p6%       C_LIVESK.GIF%p7%
%1 %2 %p3% %p4% %p5% C_LOCA~1%p6%       C_LOCATI.GIF%p7%
%1 %2 %p3% %p4% %p5% C_LOOK~1%p6%       C_LOOK.GIF%p7%
%1 %2 %p3% %p4% %p5% C_LSIN~1%p6%       C_LSINST.GIF%p7%
%1 %2 %p3% %p4% %p5% C_MOVI~1%p6%       C_MOVIES.GIF%p7%
%1 %2 %p3% %p4% %p5% C_MULT~1%p6%       C_MULTI.GIF%p7%
%1 %2 %p3% %p4% %p5% C_OPTI~1%p6%       C_OPTION.GIF%p7%
%1 %2 %p3% %p4% %p5% C_ORBI~1%p6%       C_ORBIT.GIF%p7%
%1 %2 %p3% %p4% %p5% C_PLAN~1%p6%       C_PLANET.GIF%p7%
%1 %2 %p3% %p4% %p5% C_PRIN~1%p6%       C_PRINTI.GIF%p7%
%1 %2 %p3% %p4% %p5% C_SETT~1%p6%       C_SETTIN.GIF%p7%
%1 %2 %p3% %p4% %p5% C_SPEE~1%p6%       C_SPEEDT.GIF%p7%
%1 %2 %p3% %p4% %p5% C_TIME~1%p6%       C_TIME.GIF%p7%
%1 %2 %p3% %p4% %p5% C_TOOL~1%p6%       C_TOOLS.GIF%p7%
%1 %2 %p3% %p4% %p5% C_TROU~1%p6%       C_TROUBL.GIF%p7%
%1 %2 %p3% %p4% %p5% C_WIND~1%p6%       C_WINDOW.GIF%p7%
%1 %2 %p3% %p4% %p5% CACGIS~1%p6%       CAC.GIS%p7%
%1 %2 %p3% %p4% %p5% CARRIB~1%p6%       CARRIBEA.%p7%
%1 %2 %p3% %p4% %p5% CATALO~1%p6%       CATALOG.VFS%p7%
%1 %2 %p3% %p4% %p5% CAZGIS~1%p6%       CAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% CGEO~1%p6%         c.geo%p7%
%1 %2 %p3% %p4% %p5% CHAPTE~1%p6%       CHAPTER.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_COM~1%p6%       CO_COMET.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_CON~1%p6%       CO_CONST.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_ECL~1%p6%       CO_ECLIP.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_EQU~1%p6%       CO_EQUAT.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_GAL~1%p6%       CO_GALAC.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_HOR~1%p6%       CO_HORIZ.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_LOC~1%p6%       CO_LOCAL.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_MES~1%p6%       CO_MESSI.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_MIL~1%p6%       CO_MILKY.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_NGC~1%p6%       CO_NGCIC.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_ONS~1%p6%       CO_ONSCR.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_PLA~1%p6%       CO_PLANE.GIF%p7%
%1 %2 %p3% %p4% %p5% CO_STA~1%p6%       CO_STARS.GIF%p7%
%1 %2 %p3% %p4% %p5% COCGIS~1%p6%       COC.GIS%p7%
%1 %2 %p3% %p4% %p5% COM_GE~1%p6%       COM_GENE.GIF%p7%
%1 %2 %p3% %p4% %p5% COM_IM~1%p6%       COM_IMAG.GIF%p7%
%1 %2 %p3% %p4% %p5% COMET~1%p6%        COMET.%p7%
%1 %2 %p3% %p4% %p5% COMETS~2%p6%       COMETS2.GIF%p7%
%1 %2 %p3% %p4% %p5% COMPAR~1%p6%       COMPARIS.JPG%p7%
%1 %2 %p3% %p4% %p5% CONS_B~1%p6%       CONS_BOU.GIF%p7%
%1 %2 %p3% %p4% %p5% CONS_F~1%p6%       CONS_FIG.GIF%p7%
%1 %2 %p3% %p4% %p5% CONS_G~1%p6%       CONS_GEN.GIF%p7%
%1 %2 %p3% %p4% %p5% CONS_S~1%p6%       CONS_SEL.GIF%p7%
%1 %2 %p3% %p4% %p5% CONSTE~1%p6%       CONSTELL.%p7%
%1 %2 %p3% %p4% %p5% CONTEN~1%p6%       CONTENTS.HTM%p7%
%1 %2 %p3% %p4% %p5% COOLGI~1%p6%       COOL.GIF%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECOMP.INI%p7%
%1 %2 %p3% %p4% %p5% COZGIS~1%p6%       COZ.GIS%p7%
%1 %2 %p3% %p4% %p5% CTCGIS~1%p6%       CTC.GIS%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D32.DLL%p7%
%1 %2 %p3% %p4% %p5% CTZGIS~1%p6%       CTZ.GIS%p7%
%1 %2 %p3% %p4% %p5% CUSTOM~1%p6%       CUSTOM.DAT%p7%
%1 %2 %p3% %p4% %p5% DATAUS~1%p6%       DATA.USR%p7%
%1 %2 %p3% %p4% %p5% DCCGIS~1%p6%       DCC.GIS%p7%
%1 %2 %p3% %p4% %p5% DCZGIS~1%p6%       DCZ.GIS%p7%
%1 %2 %p3% %p4% %p5% DECGIS~1%p6%       DEC.GIS%p7%
%1 %2 %p3% %p4% %p5% DEMOSH~1%p6%       DEMOS.HTM%p7%
%1 %2 %p3% %p4% %p5% DEZGIS~1%p6%       DEZ.GIS%p7%
%1 %2 %p3% %p4% %p5% DGEO~1%p6%         d.geo%p7%
%1 %2 %p3% %p4% %p5% DIGAT~10%p6%       digatmos.exe%p7%
%1 %2 %p3% %p4% %p5% DIGAT~11%p6%       DIGATMOS.GCI%p7%
%1 %2 %p3% %p4% %p5% DIGAT~12%p6%       DIGATMOS.HLP%p7%
%1 %2 %p3% %p4% %p5% DIGAT~13%p6%       DIGATMOS.MET%p7%
%1 %2 %p3% %p4% %p5% DIGAT~14%p6%       DIGATMOS.MSE%p7%
%1 %2 %p3% %p4% %p5% DIGAT~15%p6%       digatmos.pdf%p7%
%1 %2 %p3% %p4% %p5% DIGAT~16%p6%       DIGATMOS.PLL%p7%
%1 %2 %p3% %p4% %p5% DIGAT~17%p6%       DIGATMOS.PLR%p7%
%1 %2 %p3% %p4% %p5% DIGAT~18%p6%       DIGATMOS.PR1%p7%
%1 %2 %p3% %p4% %p5% DIGAT~19%p6%       DIGATMOS.PR2%p7%
%1 %2 %p3% %p4% %p5% DIGAT~20%p6%       DIGATMOS.PRI%p7%
%1 %2 %p3% %p4% %p5% DIGAT~21%p6%       DIGATMOS.RIX%p7%
%1 %2 %p3% %p4% %p5% DIGAT~22%p6%       DIGATMOS.SLZ%p7%
%1 %2 %p3% %p4% %p5% DIGAT~23%p6%       DIGATMOS.STI%p7%
%1 %2 %p3% %p4% %p5% DIGAT~24%p6%       DIGATMOS.STN%p7%
%1 %2 %p3% %p4% %p5% DIGAT~25%p6%       DIGATMOS.STW%p7%
%1 %2 %p3% %p4% %p5% DIGAT~26%p6%       DIGATMOS.SXI%p7%
%1 %2 %p3% %p4% %p5% DIGAT~27%p6%       DIGATMOS.SXW%p7%
%1 %2 %p3% %p4% %p5% DIGAT~28%p6%       DIGATMOS.SYI%p7%
%1 %2 %p3% %p4% %p5% DIGAT~29%p6%       DIGATMOS.TPX%p7%
%1 %2 %p3% %p4% %p5% DIGAT~30%p6%       DIGATMOS.XX1%p7%
%1 %2 %p3% %p4% %p5% DIGATM~1%p6%       DIGATMOS.CCL%p7%
%1 %2 %p3% %p4% %p5% DIGATM~2%p6%       DIGATMOS.CGF%p7%
%1 %2 %p3% %p4% %p5% DIGATM~3%p6%       DIGATMOS.CGZ%p7%
%1 %2 %p3% %p4% %p5% DIGATM~4%p6%       digatmos.cit%p7%
%1 %2 %p3% %p4% %p5% DIGATM~5%p6%       DIGATMOS.CLR%p7%
%1 %2 %p3% %p4% %p5% DIGATM~6%p6%       digatmos.cxn%p7%
%1 %2 %p3% %p4% %p5% DIGATM~7%p6%       digatmos.cxp%p7%
%1 %2 %p3% %p4% %p5% DIGATM~8%p6%       DIGATMOS.EMP%p7%
%1 %2 %p3% %p4% %p5% DIGATM~9%p6%       DIGATMOS.EMR%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       Disk1.id%p7%
%1 %2 %p3% %p4% %p5% DISPLA~1%p6%       DISPLAY.GIF%p7%
%1 %2 %p3% %p4% %p5% DISPLA~2%p6%       DISPLAY.HTM%p7%
%1 %2 %p3% %p4% %p5% DISPLA~3%p6%       DISPLAY.JPG%p7%
%1 %2 %p3% %p4% %p5% DISPPA~1%p6%       DISPPAL.GIF%p7%
%1 %2 %p3% %p4% %p5% DLGIMA~1%p6%       DLGIMAGE.BMP%p7%
%1 %2 %p3% %p4% %p5% DRAGGE~1%p6%       DRAGGER.GIF%p7%
%1 %2 %p3% %p4% %p5% DUMMYM~1%p6%       DUMMY.MAP%p7%
%1 %2 %p3% %p4% %p5% DUMMYS~1%p6%       DUMMY.SSD%p7%
%1 %2 %p3% %p4% %p5% EARTH~1%p6%        EARTH.%p7%
%1 %2 %p3% %p4% %p5% ECLIPS~1%p6%       ECLIPSE.%p7%
%1 %2 %p3% %p4% %p5% ECLIPS~2%p6%       ECLIPSE_.GIF%p7%
%1 %2 %p3% %p4% %p5% ECLIPT~1%p6%       ECLIPTIC.%p7%
%1 %2 %p3% %p4% %p5% ECLIPT~2%p6%       ECLIPTIC.GIF%p7%
%1 %2 %p3% %p4% %p5% EDITGI~1%p6%       EDIT.GIF%p7%
%1 %2 %p3% %p4% %p5% EDITHT~1%p6%       EDIT.HTM%p7%
%1 %2 %p3% %p4% %p5% EGEO~1%p6%         e.geo%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~1%p6%       ELEVATIO.GIF%p7%
%1 %2 %p3% %p4% %p5% ELEVAT~2%p6%       ELEVATIO.JPG%p7%
%1 %2 %p3% %p4% %p5% EQUATO~1%p6%       EQUATORI.GIF%p7%
%1 %2 %p3% %p4% %p5% ETA~1%p6%          ETA.%p7%
%1 %2 %p3% %p4% %p5% EXERCI~1%p6%       EXERCISE.HTM%p7%
%1 %2 %p3% %p4% %p5% FALL~1%p6%         FALL.%p7%
%1 %2 %p3% %p4% %p5% FAQHTM~1%p6%       FAQ.HTM%p7%
%1 %2 %p3% %p4% %p5% FGEO~1%p6%         f.geo%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILEGI~1%p6%       FILE.GIF%p7%
%1 %2 %p3% %p4% %p5% FILEHT~1%p6%       FILE.HTM%p7%
%1 %2 %p3% %p4% %p5% FILLGE~1%p6%       FILL.GEO%p7%
%1 %2 %p3% %p4% %p5% FINDGI~1%p6%       FIND.GIF%p7%
%1 %2 %p3% %p4% %p5% FINDHT~1%p6%       FIND.HTM%p7%
%1 %2 %p3% %p4% %p5% FIXED_~1%p6%       FIXED_F.GIF%p7%
%1 %2 %p3% %p4% %p5% FIXEDJ~1%p6%       FIXED.JPG%p7%
%1 %2 %p3% %p4% %p5% FLCGIS~1%p6%       FLC.GIS%p7%
%1 %2 %p3% %p4% %p5% FLZGIS~1%p6%       FLZ.GIS%p7%
%1 %2 %p3% %p4% %p5% GACGIS~1%p6%       GAC.GIS%p7%
%1 %2 %p3% %p4% %p5% GALACT~1%p6%       GALACTIC.GIF%p7%
%1 %2 %p3% %p4% %p5% GAZGIS~1%p6%       GAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% GGEO~1%p6%         g.geo%p7%
%1 %2 %p3% %p4% %p5% GOTOGI~1%p6%       GOTO.GIF%p7%
%1 %2 %p3% %p4% %p5% GUIDES~1%p6%       GUIDES.GIF%p7%
%1 %2 %p3% %p4% %p5% GUIDES~2%p6%       GUIDES.HTM%p7%
%1 %2 %p3% %p4% %p5% HALE-B~1%p6%       HALE-BOP.SNF%p7%
%1 %2 %p3% %p4% %p5% HANDSJ~1%p6%       HANDS.JPG%p7%
%1 %2 %p3% %p4% %p5% HGEO~1%p6%         h.geo%p7%
%1 %2 %p3% %p4% %p5% HICGIS~1%p6%       HIC.GIS%p7%
%1 %2 %p3% %p4% %p5% HIZGIS~1%p6%       HIZ.GIS%p7%
%1 %2 %p3% %p4% %p5% HOMEBA~1%p6%       HOMEBAR.GIF%p7%
%1 %2 %p3% %p4% %p5% HOMEGI~1%p6%       HOME.GIF%p7%
%1 %2 %p3% %p4% %p5% HOMELO~1%p6%       HOMELOCA.GIF%p7%
%1 %2 %p3% %p4% %p5% HOMELO~2%p6%       HOMELOCA.JPG%p7%
%1 %2 %p3% %p4% %p5% HORIZO~1%p6%       HORIZON.GIF%p7%
%1 %2 %p3% %p4% %p5% HORIZO~2%p6%       HORIZON.JPG%p7%
%1 %2 %p3% %p4% %p5% HORSEH~1%p6%       HORSEHEA.%p7%
%1 %2 %p3% %p4% %p5% HORSEJ~1%p6%       HORSE.JPG%p7%
%1 %2 %p3% %p4% %p5% HYAKAT~1%p6%       HYAKATUK.%p7%
%1 %2 %p3% %p4% %p5% HYAKUT~1%p6%       HYAKUTAK.SNF%p7%
%1 %2 %p3% %p4% %p5% IACGIS~1%p6%       IAC.GIS%p7%
%1 %2 %p3% %p4% %p5% IAPETU~1%p6%       IAPETUS.%p7%
%1 %2 %p3% %p4% %p5% IAZGIS~1%p6%       IAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% IC2GIF~1%p6%       IC2.GIF%p7%
%1 %2 %p3% %p4% %p5% ICGIF~1%p6%        IC.GIF%p7%
%1 %2 %p3% %p4% %p5% IDCGIS~1%p6%       IDC.GIS%p7%
%1 %2 %p3% %p4% %p5% IDZGIS~1%p6%       IDZ.GIS%p7%
%1 %2 %p3% %p4% %p5% IGEO~1%p6%         i.geo%p7%
%1 %2 %p3% %p4% %p5% ILCGIS~1%p6%       ILC.GIS%p7%
%1 %2 %p3% %p4% %p5% ILZGIS~1%p6%       ILZ.GIS%p7%
%1 %2 %p3% %p4% %p5% INCGIF~1%p6%       INC.GIF%p7%
%1 %2 %p3% %p4% %p5% INCGIS~1%p6%       INC.GIS%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       INDEX.HTM%p7%
%1 %2 %p3% %p4% %p5% INDEXP~1%p6%       INDEXPAG.HTM%p7%
%1 %2 %p3% %p4% %p5% INFOHT~1%p6%       INFO.HTM%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.HTM%p7%
%1 %2 %p3% %p4% %p5% INTROH~1%p6%       INTRO.HTM%p7%
%1 %2 %p3% %p4% %p5% INZGIS~1%p6%       INZ.GIS%p7%
%1 %2 %p3% %p4% %p5% JGEO~1%p6%         j.geo%p7%
%1 %2 %p3% %p4% %p5% JUPITE~1%p6%       JUPITER.%p7%
%1 %2 %p3% %p4% %p5% JUPITE~2%p6%       JUPITER.SNF%p7%
%1 %2 %p3% %p4% %p5% KGEO~1%p6%         k.geo%p7%
%1 %2 %p3% %p4% %p5% KSCGIS~1%p6%       KSC.GIS%p7%
%1 %2 %p3% %p4% %p5% KSZGIS~1%p6%       KSZ.GIS%p7%
%1 %2 %p3% %p4% %p5% KYCGIS~1%p6%       KYC.GIS%p7%
%1 %2 %p3% %p4% %p5% KYZGIS~1%p6%       KYZ.GIS%p7%
%1 %2 %p3% %p4% %p5% LACGIS~1%p6%       LAC.GIS%p7%
%1 %2 %p3% %p4% %p5% LAZGIS~1%p6%       LAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% LGEO~1%p6%         l.geo%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       LICENSE.HTM%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       LICENSE.TXT%p7%
%1 %2 %p3% %p4% %p5% LIVESK~1%p6%       LIVESKY.DLL%p7%
%1 %2 %p3% %p4% %p5% LIVESK~2%p6%       LIVESKY.GIF%p7%
%1 %2 %p3% %p4% %p5% LIVESK~3%p6%       LIVESKY.HTM%p7%
%1 %2 %p3% %p4% %p5% LOCALG~1%p6%       LOCAL.GIF%p7%
%1 %2 %p3% %p4% %p5% LOCATI~1%p6%       LOCATION.%p7%
%1 %2 %p3% %p4% %p5% LOCATI~2%p6%       LOCATION.HTM%p7%
%1 %2 %p3% %p4% %p5% LOCATI~3%p6%       LOCATION.JPG%p7%
%1 %2 %p3% %p4% %p5% LOCTOO~1%p6%       LOCTOOL.JPG%p7%
%1 %2 %p3% %p4% %p5% LONELY~1%p6%       LONELY.%p7%
%1 %2 %p3% %p4% %p5% LOOKHT~1%p6%       LOOK.HTM%p7%
%1 %2 %p3% %p4% %p5% LOOKIN~1%p6%       LOOKING.%p7%
%1 %2 %p3% %p4% %p5% LOST~1%p6%         LOST.%p7%
%1 %2 %p3% %p4% %p5% LSINST~1%p6%       LSINSTAL.HTM%p7%
%1 %2 %p3% %p4% %p5% LSSETG~1%p6%       LSSET.GIF%p7%
%1 %2 %p3% %p4% %p5% M100SN~1%p6%       M100.SNF%p7%
%1 %2 %p3% %p4% %p5% M106SN~1%p6%       M106.SNF%p7%
%1 %2 %p3% %p4% %p5% M13~1%p6%          M13.%p7%
%1 %2 %p3% %p4% %p5% M17~1%p6%          M17.%p7%
%1 %2 %p3% %p4% %p5% M20~1%p6%          M20.%p7%
%1 %2 %p3% %p4% %p5% M31~1%p6%          M31.%p7%
%1 %2 %p3% %p4% %p5% M31GIF~2%p6%       M31.GIF%p7%
%1 %2 %p3% %p4% %p5% M33~1%p6%          M33.%p7%
%1 %2 %p3% %p4% %p5% M45~1%p6%          M45.%p7%
%1 %2 %p3% %p4% %p5% M51~1%p6%          M51.%p7%
%1 %2 %p3% %p4% %p5% M57~1%p6%          M57.%p7%
%1 %2 %p3% %p4% %p5% M65~1%p6%          M65.%p7%
%1 %2 %p3% %p4% %p5% M66~1%p6%          M66.%p7%
%1 %2 %p3% %p4% %p5% M8~1%p6%           M8.%p7%
%1 %2 %p3% %p4% %p5% M83~2%p6%          M83.%p7%
%1 %2 %p3% %p4% %p5% M91SNF~1%p6%       M91.SNF%p7%
%1 %2 %p3% %p4% %p5% M99SNF~1%p6%       M99.SNF%p7%
%1 %2 %p3% %p4% %p5% MACGIS~1%p6%       MAC.GIS%p7%
%1 %2 %p3% %p4% %p5% MANY~1%p6%         MANY.%p7%
%1 %2 %p3% %p4% %p5% MARSRE~1%p6%       MARSRETR.GIF%p7%
%1 %2 %p3% %p4% %p5% MAURYG~1%p6%       MAURY.GIF%p7%
%1 %2 %p3% %p4% %p5% MAZGIS~1%p6%       MAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MDCGIS~1%p6%       MDC.GIS%p7%
%1 %2 %p3% %p4% %p5% MDZGIS~1%p6%       MDZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MECGIS~1%p6%       MEC.GIS%p7%
%1 %2 %p3% %p4% %p5% MESS_G~1%p6%       MESS_GEN.GIF%p7%
%1 %2 %p3% %p4% %p5% MESS_I~1%p6%       MESS_IMA.GIF%p7%
%1 %2 %p3% %p4% %p5% MESS_M~1%p6%       MESS_MAP.GIF%p7%
%1 %2 %p3% %p4% %p5% MESSIE~1%p6%       MESSIER.%p7%
%1 %2 %p3% %p4% %p5% MEZGIS~1%p6%       MEZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MGEO~1%p6%         m.geo%p7%
%1 %2 %p3% %p4% %p5% MICGIS~1%p6%       MIC.GIS%p7%
%1 %2 %p3% %p4% %p5% MILKWA~1%p6%       MILKWAY.JPG%p7%
%1 %2 %p3% %p4% %p5% MILKY_~1%p6%       MILKY_~1%p7%
%1 %2 %p3% %p4% %p5% MILKY~1%p6%        MILKY.%p7%
%1 %2 %p3% %p4% %p5% MIZGIS~1%p6%       MIZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MNCGIS~1%p6%       MNC.GIS%p7%
%1 %2 %p3% %p4% %p5% MNZGIS~1%p6%       MNZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MOCGIS~1%p6%       MOC.GIS%p7%
%1 %2 %p3% %p4% %p5% MOONIN~1%p6%       MOONINFO.GIF%p7%
%1 %2 %p3% %p4% %p5% MOONIN~2%p6%       MOONINFO.JPG%p7%
%1 %2 %p3% %p4% %p5% MOUSEI~1%p6%       MOUSEINF.GIF%p7%
%1 %2 %p3% %p4% %p5% MOVIE1~1%p6%       MOVIE1.JPG%p7%
%1 %2 %p3% %p4% %p5% MOVIE2~1%p6%       MOVIE2.JPG%p7%
%1 %2 %p3% %p4% %p5% MOVIES~1%p6%       MOVIES.HTM%p7%
%1 %2 %p3% %p4% %p5% MOZGIS~1%p6%       MOZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MSCGIS~1%p6%       MSC.GIS%p7%
%1 %2 %p3% %p4% %p5% MSZGIS~1%p6%       MSZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MTCGIS~1%p6%       MTC.GIS%p7%
%1 %2 %p3% %p4% %p5% MTZGIS~1%p6%       MTZ.GIS%p7%
%1 %2 %p3% %p4% %p5% MULTIH~1%p6%       MULTI.HTM%p7%
%1 %2 %p3% %p4% %p5% MWAYGI~1%p6%       MWAY.GIF%p7%
%1 %2 %p3% %p4% %p5% NCCGIS~1%p6%       NCC.GIS%p7%
%1 %2 %p3% %p4% %p5% NCZGIS~1%p6%       NCZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NDCGIS~1%p6%       NDC.GIS%p7%
%1 %2 %p3% %p4% %p5% NDZGIS~1%p6%       NDZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NEARES~1%p6%       NEAREST.MAP%p7%
%1 %2 %p3% %p4% %p5% NECGIS~1%p6%       NEC.GIS%p7%
%1 %2 %p3% %p4% %p5% NEPTUN~1%p6%       NEPTUNE.SNF%p7%
%1 %2 %p3% %p4% %p5% NEZGIS~1%p6%       NEZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NGC_BR~1%p6%       NGC_BRIG.GIF%p7%
%1 %2 %p3% %p4% %p5% NGC_GE~1%p6%       NGC_GENE.GIF%p7%
%1 %2 %p3% %p4% %p5% NGC_LE~1%p6%       NGC_LEGE.GIF%p7%
%1 %2 %p3% %p4% %p5% NGCGIF~1%p6%       NGC.GIF%p7%
%1 %2 %p3% %p4% %p5% NGCJPG~1%p6%       NGC.JPG%p7%
%1 %2 %p3% %p4% %p5% NGEO~1%p6%         n.geo%p7%
%1 %2 %p3% %p4% %p5% NHCGIS~1%p6%       NHC.GIS%p7%
%1 %2 %p3% %p4% %p5% NHZGIS~1%p6%       NHZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NJCGIS~1%p6%       NJC.GIS%p7%
%1 %2 %p3% %p4% %p5% NJZGIS~1%p6%       NJZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NMCGIS~1%p6%       NMC.GIS%p7%
%1 %2 %p3% %p4% %p5% NMZGIS~1%p6%       NMZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NOTE2G~1%p6%       NOTE2.GIF%p7%
%1 %2 %p3% %p4% %p5% NOTEGI~1%p6%       NOTE.GIF%p7%
%1 %2 %p3% %p4% %p5% NOWGIF~1%p6%       NOW.GIF%p7%
%1 %2 %p3% %p4% %p5% NVCGIS~1%p6%       NVC.GIS%p7%
%1 %2 %p3% %p4% %p5% NVZGIS~1%p6%       NVZ.GIS%p7%
%1 %2 %p3% %p4% %p5% NYCGIS~1%p6%       NYC.GIS%p7%
%1 %2 %p3% %p4% %p5% NYZGIS~1%p6%       NYZ.GIS%p7%
%1 %2 %p3% %p4% %p5% O_COME~1%p6%       O_COMETS.HTM%p7%
%1 %2 %p3% %p4% %p5% O_CONS~1%p6%       O_CONSTE.HTM%p7%
%1 %2 %p3% %p4% %p5% O_ECLI~1%p6%       O_ECLIPT.HTM%p7%
%1 %2 %p3% %p4% %p5% O_EQUA~1%p6%       O_EQUATO.HTM%p7%
%1 %2 %p3% %p4% %p5% O_GALA~1%p6%       O_GALACT.HTM%p7%
%1 %2 %p3% %p4% %p5% O_HORI~1%p6%       O_HORIZO.HTM%p7%
%1 %2 %p3% %p4% %p5% O_LOCA~1%p6%       O_LOCAL.HTM%p7%
%1 %2 %p3% %p4% %p5% O_MESS~1%p6%       O_MESSIE.HTM%p7%
%1 %2 %p3% %p4% %p5% O_MILK~1%p6%       O_MILKYW.HTM%p7%
%1 %2 %p3% %p4% %p5% O_NGCI~1%p6%       O_NGCIC.HTM%p7%
%1 %2 %p3% %p4% %p5% O_ONSC~1%p6%       O_ONSCRE.HTM%p7%
%1 %2 %p3% %p4% %p5% O_PLAN~1%p6%       O_PLANET.HTM%p7%
%1 %2 %p3% %p4% %p5% O_STAR~1%p6%       O_STARS.HTM%p7%
%1 %2 %p3% %p4% %p5% OGEO~1%p6%         o.geo%p7%
%1 %2 %p3% %p4% %p5% OHCGIS~1%p6%       OHC.GIS%p7%
%1 %2 %p3% %p4% %p5% OHZGIS~1%p6%       OHZ.GIS%p7%
%1 %2 %p3% %p4% %p5% OKCGIS~1%p6%       OKC.GIS%p7%
%1 %2 %p3% %p4% %p5% OKZGIS~1%p6%       OKZ.GIS%p7%
%1 %2 %p3% %p4% %p5% OMEGA~1%p6%        OMEGA.%p7%
%1 %2 %p3% %p4% %p5% ONSCRE~1%p6%       ONSCREEN.GIF%p7%
%1 %2 %p3% %p4% %p5% OPTION~1%p6%       OPTIONS.HTM%p7%
%1 %2 %p3% %p4% %p5% ORBIT1~1%p6%       ORBIT1.JPG%p7%
%1 %2 %p3% %p4% %p5% ORBITH~1%p6%       ORBIT.HTM%p7%
%1 %2 %p3% %p4% %p5% ORCGIS~1%p6%       ORC.GIS%p7%
%1 %2 %p3% %p4% %p5% ORDERD~1%p6%       order.doc%p7%
%1 %2 %p3% %p4% %p5% ORZGIS~1%p6%       ORZ.GIS%p7%
%1 %2 %p3% %p4% %p5% OTHERS~1%p6%       OTHER.SSD%p7%
%1 %2 %p3% %p4% %p5% OUTPU~10%p6%       OUTPUT.RDi%p7%
%1 %2 %p3% %p4% %p5% OUTPU~11%p6%       OUTPUT.RDj%p7%
%1 %2 %p3% %p4% %p5% OUTPU~12%p6%       OUTPUT.RDk%p7%
%1 %2 %p3% %p4% %p5% OUTPU~13%p6%       OUTPUT.RDl%p7%
%1 %2 %p3% %p4% %p5% OUTPU~14%p6%       OUTPUT.RDm%p7%
%1 %2 %p3% %p4% %p5% OUTPU~15%p6%       OUTPUT.RDn%p7%
%1 %2 %p3% %p4% %p5% OUTPU~16%p6%       OUTPUT.RDo%p7%
%1 %2 %p3% %p4% %p5% OUTPU~17%p6%       OUTPUT.RDp%p7%
%1 %2 %p3% %p4% %p5% OUTPU~18%p6%       OUTPUT.RDq%p7%
%1 %2 %p3% %p4% %p5% OUTPU~19%p6%       OUTPUT.RDX%p7%
%1 %2 %p3% %p4% %p5% OUTPU~20%p6%       OUTPUT.RDy%p7%
%1 %2 %p3% %p4% %p5% OUTPU~21%p6%       OUTPUT.ROF%p7%
%1 %2 %p3% %p4% %p5% OUTPU~22%p6%       OUTPUT.S00%p7%
%1 %2 %p3% %p4% %p5% OUTPU~23%p6%       OUTPUT.U00%p7%
%1 %2 %p3% %p4% %p5% OUTPU~24%p6%       output.wrq%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~1%p6%       OUTPUT.M00%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~2%p6%       OUTPUT.RDa%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~3%p6%       OUTPUT.RDb%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~4%p6%       OUTPUT.RDc%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~5%p6%       OUTPUT.RDd%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~6%p6%       OUTPUT.RDe%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~7%p6%       OUTPUT.RDf%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~8%p6%       OUTPUT.RDg%p7%
%1 %2 %p3% %p4% %p5% OUTPUT~9%p6%       OUTPUT.RDh%p7%
%1 %2 %p3% %p4% %p5% PACGIS~1%p6%       PAC.GIS%p7%
%1 %2 %p3% %p4% %p5% PAZGIS~1%p6%       PAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% PGEO~1%p6%         p.geo%p7%
%1 %2 %p3% %p4% %p5% PLAN_G~1%p6%       PLAN_GEN.GIF%p7%
%1 %2 %p3% %p4% %p5% PLAN_O~1%p6%       PLAN_ORB.GIF%p7%
%1 %2 %p3% %p4% %p5% PLAN_P~1%p6%       PLAN_PAT.GIF%p7%
%1 %2 %p3% %p4% %p5% PLAN_S~1%p6%       PLAN_SUR.GIF%p7%
%1 %2 %p3% %p4% %p5% PLAN2S~1%p6%       PLAN2.SSD%p7%
%1 %2 %p3% %p4% %p5% PLANET~1%p6%       PLANET.HTM%p7%
%1 %2 %p3% %p4% %p5% PLANET~2%p6%       PLANETS.%p7%
%1 %2 %p3% %p4% %p5% PLANET~3%p6%       PLANETS.JPG%p7%
%1 %2 %p3% %p4% %p5% PLANET~4%p6%       PLANETS.MAP%p7%
%1 %2 %p3% %p4% %p5% PLANET~5%p6%       PLANETS1.JPG%p7%
%1 %2 %p3% %p4% %p5% PLANET~6%p6%       PLANETS2.GIF%p7%
%1 %2 %p3% %p4% %p5% PLUGIN~1%p6%       PLUGIN.%p7%
%1 %2 %p3% %p4% %p5% PPALGI~1%p6%       PPAL.GIF%p7%
%1 %2 %p3% %p4% %p5% PQ_GRA~1%p6%       PQ_GRADB.JPG%p7%
%1 %2 %p3% %p4% %p5% PQ_GRA~2%p6%       PQ_GRADG.JPG%p7%
%1 %2 %p3% %p4% %p5% PQ_NON~1%p6%       PQ_NONEB.JPG%p7%
%1 %2 %p3% %p4% %p5% PQ_NON~2%p6%       PQ_NONEG.JPG%p7%
%1 %2 %p3% %p4% %p5% PQ_SHA~1%p6%       PQ_SHARP.JPG%p7%
%1 %2 %p3% %p4% %p5% PRECES~1%p6%       PRECESSI.SNF%p7%
%1 %2 %p3% %p4% %p5% PRINTI~1%p6%       PRINTING.HTM%p7%
%1 %2 %p3% %p4% %p5% PRINTJ~1%p6%       PRINT.JPG%p7%
%1 %2 %p3% %p4% %p5% QGEO~1%p6%         q.geo%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       README.HTM%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       readme.txt%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       readme__.txt%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README0.TXT%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README1.TXT%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README2.TXT%p7%
%1 %2 %p3% %p4% %p5% README1%p6%        readme1%p7%
%1 %2 %p3% %p4% %p5% REALTI~1%p6%       REALTIME.GIF%p7%
%1 %2 %p3% %p4% %p5% RGEO~1%p6%         r.geo%p7%
%1 %2 %p3% %p4% %p5% RICGIS~1%p6%       RIC.GIS%p7%
%1 %2 %p3% %p4% %p5% RIZGIS~1%p6%       RIZ.GIS%p7%
%1 %2 %p3% %p4% %p5% SAO~1%p6%          SAO.%p7%
%1 %2 %p3% %p4% %p5% SATURN~1%p6%       SATURN'S.%p7%
%1 %2 %p3% %p4% %p5% SATURN~2%p6%       SATURNIA.%p7%
%1 %2 %p3% %p4% %p5% SCCGIS~1%p6%       SCC.GIS%p7%
%1 %2 %p3% %p4% %p5% SCORPI~1%p6%       SCORPIUS.GIF%p7%
%1 %2 %p3% %p4% %p5% SCZGIS~1%p6%       SCZ.GIS%p7%
%1 %2 %p3% %p4% %p5% SDCGIS~1%p6%       SDC.GIS%p7%
%1 %2 %p3% %p4% %p5% SDZGIS~1%p6%       SDZ.GIS%p7%
%1 %2 %p3% %p4% %p5% SETIMA~1%p6%       SETI.MAP%p7%
%1 %2 %p3% %p4% %p5% SETTIN~1%p6%       SETTINGS.GIF%p7%
%1 %2 %p3% %p4% %p5% SETTIN~2%p6%       SETTINGS.HTM%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_.INS%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       Setup.exe%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       Setup.ini%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       Setup.ins%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       Setup.iss%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       Setup.pkg%p7%
%1 %2 %p3% %p4% %p5% SFOVGI~1%p6%       SFOV.GIF%p7%
%1 %2 %p3% %p4% %p5% SKY32V~1%p6%       SKY32V3C.DLL%p7%
%1 %2 %p3% %p4% %p5% SKY3D2~1%p6%       SKY3D2.VFS%p7%
%1 %2 %p3% %p4% %p5% SKY3DE~1%p6%       SKY3D.EXE%p7%
%1 %2 %p3% %p4% %p5% SOLAR~1%p6%        SOLAR.%p7%
%1 %2 %p3% %p4% %p5% SOLARE~2%p6%       SOLAREXT.SSD%p7%
%1 %2 %p3% %p4% %p5% SOLARS~2%p6%       SOLAR.SSD%p7%
%1 %2 %p3% %p4% %p5% SOLMAP~1%p6%       SOL.MAP%p7%
%1 %2 %p3% %p4% %p5% SPACER~1%p6%       SPACER15.GIF%p7%
%1 %2 %p3% %p4% %p5% SPEEDT~1%p6%       SPEEDTIP.HTM%p7%
%1 %2 %p3% %p4% %p5% SSTEPG~1%p6%       SSTEP.GIF%p7%
%1 %2 %p3% %p4% %p5% STARPI~1%p6%       STARPIC.GIF%p7%
%1 %2 %p3% %p4% %p5% STARRY~1%p6%       STARRY.%p7%
%1 %2 %p3% %p4% %p5% STARSG~1%p6%       STARS.GIF%p7%
%1 %2 %p3% %p4% %p5% STEPHA~1%p6%       STEPHANS.%p7%
%1 %2 %p3% %p4% %p5% SUNSET~1%p6%       SUNSET.%p7%
%1 %2 %p3% %p4% %p5% T_ANGS~1%p6%       T_ANGSEP.GIF%p7%
%1 %2 %p3% %p4% %p5% T_ARRO~1%p6%       T_ARROW.GIF%p7%
%1 %2 %p3% %p4% %p5% T_CONS~1%p6%       T_CONST.GIF%p7%
%1 %2 %p3% %p4% %p5% T_HAND~1%p6%       T_HAND.GIF%p7%
%1 %2 %p3% %p4% %p5% T_LOCG~1%p6%       T_LOC.GIF%p7%
%1 %2 %p3% %p4% %p5% T_MOVI~1%p6%       T_MOVIE.GIF%p7%
%1 %2 %p3% %p4% %p5% T_PICT~1%p6%       T_PICT.GIF%p7%
%1 %2 %p3% %p4% %p5% T_ZOOM~1%p6%       T_ZOOMTO.GIF%p7%
%1 %2 %p3% %p4% %p5% TEMPHO~1%p6%       TEMPHORZ.ATR%p7%
%1 %2 %p3% %p4% %p5% TEMPHO~2%p6%       temphorz.bmp%p7%
%1 %2 %p3% %p4% %p5% THE~1%p6%          THE.%p7%
%1 %2 %p3% %p4% %p5% TIMEGI~1%p6%       TIME.GIF%p7%
%1 %2 %p3% %p4% %p5% TIMEHT~1%p6%       TIME.HTM%p7%
%1 %2 %p3% %p4% %p5% TNCGIS~1%p6%       TNC.GIS%p7%
%1 %2 %p3% %p4% %p5% TNZGIS~1%p6%       TNZ.GIS%p7%
%1 %2 %p3% %p4% %p5% TOOLBA~1%p6%       TOOLBAR.JPG%p7%
%1 %2 %p3% %p4% %p5% TOOLHT~1%p6%       TOOL.HTM%p7%
%1 %2 %p3% %p4% %p5% TOOLSG~1%p6%       TOOLS.GIF%p7%
%1 %2 %p3% %p4% %p5% TOPBAR~1%p6%       TOPBAR.GIF%p7%
%1 %2 %p3% %p4% %p5% TXCGIS~1%p6%       TXC.GIS%p7%
%1 %2 %p3% %p4% %p5% TXZGIS~1%p6%       TXZ.GIS%p7%
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST.EXE%p7%
%1 %2 %p3% %p4% %p5% USER~1%p6%         USER.%p7%
%1 %2 %p3% %p4% %p5% UTCGIS~1%p6%       UTC.GIS%p7%
%1 %2 %p3% %p4% %p5% UTZGIS~1%p6%       UTZ.GIS%p7%
%1 %2 %p3% %p4% %p5% VACGIS~1%p6%       VAC.GIS%p7%
%1 %2 %p3% %p4% %p5% VAZGIS~1%p6%       VAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% VEIL~1%p6%         VEIL.%p7%
%1 %2 %p3% %p4% %p5% VENUSS~1%p6%       VENUS.SNF%p7%
%1 %2 %p3% %p4% %p5% VTCGIS~1%p6%       VTC.GIS%p7%
%1 %2 %p3% %p4% %p5% VTZGIS~1%p6%       VTZ.GIS%p7%
%1 %2 %p3% %p4% %p5% WACGIS~1%p6%       WAC.GIS%p7%
%1 %2 %p3% %p4% %p5% WAZGIS~1%p6%       WAZ.GIS%p7%
%1 %2 %p3% %p4% %p5% WELCOM~1%p6%       WELCOME.BMP%p7%
%1 %2 %p3% %p4% %p5% WHEREJ~1%p6%       WHERE.JPG%p7%
%1 %2 %p3% %p4% %p5% WICGIS~1%p6%       WIC.GIS%p7%
%1 %2 %p3% %p4% %p5% WINDOW~1%p6%       WINDOW.GIF%p7%
%1 %2 %p3% %p4% %p5% WINDOW~2%p6%       WINDOWS.HTM%p7%
%1 %2 %p3% %p4% %p5% WIZGIS~1%p6%       WIZ.GIS%p7%
%1 %2 %p3% %p4% %p5% WVCGIS~1%p6%       WVC.GIS%p7%
%1 %2 %p3% %p4% %p5% WVZGIS~1%p6%       WVZ.GIS%p7%
%1 %2 %p3% %p4% %p5% WYCGIS~1%p6%       WYC.GIS%p7%
%1 %2 %p3% %p4% %p5% WYZGIS~1%p6%       WYZ.GIS%p7%
%1 %2 %p3% %p4% %p5% XREFZO~1%p6%       xrefzone.txt%p7%
%1 %2 %p3% %p4% %p5% ZOOM2G~1%p6%       ZOOM2.GIF%p7%
%1 %2 %p3% %p4% %p5% ZOOMGI~1%p6%       ZOOM.GIF%p7%

cd %dir9%

%1 %2 %p3% %p4% %p5% _INST3~1%p6%       _INST32I.EX_%p7%
%1 %2 %p3% %p4% %p5% _ISDEL~1%p6%       _ISDEL.EXE%p7%
%1 %2 %p3% %p4% %p5% _ISREG~1%p6%       _ISREG32.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISRES~1%p6%       _ISRES.DLL%p7%
%1 %2 %p3% %p4% %p5% _ISUSE~1%p6%       _ISUSER.DLL%p7%
%1 %2 %p3% %p4% %p5% _SETUP~1%p6%       _SETUP.DLL%p7%
%1 %2 %p3% %p4% %p5% !!LICE~1%p6%       !!licenseWHe_D.txt%p7%
%1 %2 %p3% %p4% %p5% A0000~10%p6%       a0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~11%p6%       a0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~12%p6%       a0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~13%p6%       a0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~14%p6%       a0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~15%p6%       a0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~16%p6%       a0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~17%p6%       a0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~18%p6%       a0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~19%p6%       a0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~20%p6%       a0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~21%p6%       a0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~22%p6%       a0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~23%p6%       a0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~24%p6%       a0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~25%p6%       a0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~26%p6%       a0000024.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~27%p6%       a0000025.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~28%p6%       a0000026.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~29%p6%       a0000027.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~30%p6%       a0000028.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~31%p6%       a0000029.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~32%p6%       a0000030.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~33%p6%       a0000031.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~34%p6%       a0000032.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~35%p6%       a0000033.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~36%p6%       a0000034.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~37%p6%       a0000035.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~38%p6%       a0000036.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~39%p6%       a0000037.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~40%p6%       a0000038.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~41%p6%       a0000039.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~42%p6%       a0000040.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~43%p6%       a0000041.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~44%p6%       a0000042.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~45%p6%       a0000043.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~46%p6%       a0000044.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~47%p6%       a0000045.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~48%p6%       a0000046.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~49%p6%       a0000047.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~50%p6%       a0000048.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~51%p6%       a0000049.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~52%p6%       a0000050.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~53%p6%       a0000051.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~54%p6%       a0000052.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~55%p6%       a0000053.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~56%p6%       a0000054.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~57%p6%       a0000055.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~58%p6%       a0000056.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~59%p6%       a0000057.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~60%p6%       a0000058.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~61%p6%       a0000059.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~62%p6%       a0000060.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~63%p6%       a0000061.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~64%p6%       a0000062.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~65%p6%       a0000063.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~66%p6%       a0000064.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~67%p6%       a0000065.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~68%p6%       a0000066.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~69%p6%       a0000067.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~70%p6%       a0000068.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~71%p6%       a0000069.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~72%p6%       a0000070.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~73%p6%       a0000071.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~74%p6%       a0000072.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~75%p6%       a0000073.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~76%p6%       a0000074.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~77%p6%       a0000075.EWI%p7%
%1 %2 %p3% %p4% %p5% A0000~78%p6%       a0000076.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~1%p6%       a0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% A00000~2%p6%       a0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% A00000~3%p6%       a0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~4%p6%       a0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~5%p6%       a0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~6%p6%       a0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~7%p6%       a0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~8%p6%       a0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% A00000~9%p6%       a0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% APPSET~1%p6%       appsetup.inf%p7%
%1 %2 %p3% %p4% %p5% AUTORU~1%p6%       autorun.ico%p7%
%1 %2 %p3% %p4% %p5% AUTORU~2%p6%       Autorun.inf%p7%
%1 %2 %p3% %p4% %p5% AVANZA~1%p6%       Avanzate.aeh%p7%
%1 %2 %p3% %p4% %p5% AWPHEL~1%p6%       awphelpe.exe%p7%
%1 %2 %p3% %p4% %p5% AWPHEL~2%p6%       awphelpf.exe%p7%
%1 %2 %p3% %p4% %p5% BCB10P~1%p6%       BCB10.pak%p7%
%1 %2 %p3% %p4% %p5% BCB30P~1%p6%       BCB30.pak%p7%
%1 %2 %p3% %p4% %p5% BORHEL~1%p6%       BorHelp.cnt%p7%
%1 %2 %p3% %p4% %p5% BORHEL~2%p6%       BorHelp.dot%p7%
%1 %2 %p3% %p4% %p5% BORHEL~3%p6%       Borhelp.hlp%p7%
%1 %2 %p3% %p4% %p5% CD_INS~1%p6%       cd_install_77.exe%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~1%p6%       CdNavigationHystory.wzz%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~2%p6%       CdNavigationHystoryWithImm.wzz%p7%
%1 %2 %p3% %p4% %p5% CDNAVI~3%p6%       CdNavigationHystoryWithImmLicRd.wzz%p7%
%1 %2 %p3% %p4% %p5% CDROMA~1%p6%       CdRom.aeh%p7%
%1 %2 %p3% %p4% %p5% CHELP3~1%p6%       CHELP32.DLL%p7%
%1 %2 %p3% %p4% %p5% CHELP3~2%p6%       CHELP32.HLP%p7%
%1 %2 %p3% %p4% %p5% CLASS~10%p6%       classic11_.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~11%p6%       classic12.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~12%p6%       classic12_.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~13%p6%       classic121.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~14%p6%       classic14.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~15%p6%       classic15.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~16%p6%       classic16.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~17%p6%       classic16_.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~18%p6%       classic18.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~19%p6%       classic2.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~20%p6%       classic21.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASS~21%p6%       classic3.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~1%p6%       classic1.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~2%p6%       classic1_.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~3%p6%       classic10.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~4%p6%       classic10_.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~5%p6%       classic100.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~6%p6%       classic101.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~7%p6%       classic102.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~8%p6%       classic103.aeh%p7%
%1 %2 %p3% %p4% %p5% CLASSI~9%p6%       classic11.aeh%p7%
%1 %2 %p3% %p4% %p5% COLLEG~1%p6%       Collegamenti.aeh%p7%
%1 %2 %p3% %p4% %p5% COLLEG~2%p6%       CollegamentiSpeciali.aeh%p7%
%1 %2 %p3% %p4% %p5% COMCTL~1%p6%       COMCTL3_.OC_%p7%
%1 %2 %p3% %p4% %p5% COMCTL~2%p6%       COMCTL32.OC_%p7%
%1 %2 %p3% %p4% %p5% COMDLG~1%p6%       COMDLG32.OC_%p7%
%1 %2 %p3% %p4% %p5% CORECO~1%p6%       CORECOMP.INI%p7%
%1 %2 %p3% %p4% %p5% CORNIC~1%p6%       Cornici.aeh%p7%
%1 %2 %p3% %p4% %p5% CTL3D3~1%p6%       CTL3D32.DLL%p7%
%1 %2 %p3% %p4% %p5% CUSTHE~1%p6%       CUSTHELP.DLL%p7%
%1 %2 %p3% %p4% %p5% CUSTHE~2%p6%       CUSTHELP.HLP%p7%
%1 %2 %p3% %p4% %p5% D000~100%p6%       d0000098.EWI%p7%
%1 %2 %p3% %p4% %p5% D000~101%p6%       d0000099.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~10%p6%       d0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~11%p6%       d0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~12%p6%       d0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~13%p6%       d0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~14%p6%       d0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~15%p6%       d0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~16%p6%       d0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~17%p6%       d0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~18%p6%       d0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~19%p6%       d0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~20%p6%       d0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~21%p6%       d0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~22%p6%       d0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~23%p6%       d0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~24%p6%       d0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~25%p6%       d0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~26%p6%       d0000024.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~27%p6%       d0000025.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~28%p6%       d0000026.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~29%p6%       d0000027.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~30%p6%       d0000028.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~31%p6%       d0000029.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~32%p6%       d0000030.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~33%p6%       d0000031.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~34%p6%       d0000032.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~35%p6%       d0000033.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~36%p6%       d0000034.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~37%p6%       d0000035.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~38%p6%       d0000036.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~39%p6%       d0000037.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~40%p6%       d0000038.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~41%p6%       d0000039.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~42%p6%       d0000040.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~43%p6%       d0000041.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~44%p6%       d0000042.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~45%p6%       d0000043.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~46%p6%       d0000044.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~47%p6%       d0000045.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~48%p6%       d0000046.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~49%p6%       d0000047.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~50%p6%       d0000048.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~51%p6%       d0000049.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~52%p6%       d0000050.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~53%p6%       d0000051.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~54%p6%       d0000052.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~55%p6%       d0000053.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~56%p6%       d0000054.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~57%p6%       d0000055.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~58%p6%       d0000056.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~59%p6%       d0000057.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~60%p6%       d0000058.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~61%p6%       d0000059.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~62%p6%       d0000060.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~63%p6%       d0000061.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~64%p6%       d0000062.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~65%p6%       d0000063.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~66%p6%       d0000064.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~67%p6%       d0000065.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~68%p6%       d0000066.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~69%p6%       d0000067.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~70%p6%       d0000068.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~71%p6%       d0000069.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~72%p6%       d0000070.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~73%p6%       d0000071.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~74%p6%       d0000072.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~75%p6%       d0000073.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~76%p6%       d0000074.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~77%p6%       d0000075.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~78%p6%       d0000076.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~79%p6%       d0000077.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~80%p6%       d0000078.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~81%p6%       d0000079.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~82%p6%       d0000080.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~83%p6%       d0000081.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~84%p6%       d0000082.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~85%p6%       d0000083.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~86%p6%       d0000084.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~87%p6%       d0000085.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~88%p6%       d0000086.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~89%p6%       d0000087.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~90%p6%       d0000088.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~91%p6%       d0000089.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~92%p6%       d0000090.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~93%p6%       d0000091.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~94%p6%       d0000092.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~95%p6%       d0000093.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~96%p6%       d0000094.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~97%p6%       d0000095.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~98%p6%       d0000096.EWI%p7%
%1 %2 %p3% %p4% %p5% D0000~99%p6%       d0000097.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~1%p6%       d0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% D00000~2%p6%       d0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% D00000~3%p6%       d0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~4%p6%       d0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~5%p6%       d0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~6%p6%       d0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~7%p6%       d0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~8%p6%       d0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% D00000~9%p6%       d0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~1%p6%       d0000100.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~2%p6%       d0000101.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~3%p6%       d0000102.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~4%p6%       d0000103.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~5%p6%       d0000104.EWI%p7%
%1 %2 %p3% %p4% %p5% D00001~6%p6%       d0000105.EWI%p7%
%1 %2 %p3% %p4% %p5% DEINST~1%p6%       Deinst_e.exe%p7%
%1 %2 %p3% %p4% %p5% DELPHI~1%p6%       Delphi10.pak%p7%
%1 %2 %p3% %p4% %p5% DELPHI~2%p6%       Delphi20.pak%p7%
%1 %2 %p3% %p4% %p5% DELPHI~3%p6%       Delphi30.pak%p7%
%1 %2 %p3% %p4% %p5% DELPHI~4%p6%       Delphi40.pak%p7%
%1 %2 %p3% %p4% %p5% DEMOWH~1%p6%       demoWH.aeh%p7%
%1 %2 %p3% %p4% %p5% DEMOWH~2%p6%       demoWH_f.aeh%p7%
%1 %2 %p3% %p4% %p5% DIAPOS~1%p6%       Diapositive.aeh%p7%
%1 %2 %p3% %p4% %p5% DISK1I~1%p6%       DISK1.ID%p7%
%1 %2 %p3% %p4% %p5% DLGIMA~1%p6%       DLGIMAGE.BMP%p7%
%1 %2 %p3% %p4% %p5% E000~100%p6%       e0000098.EWI%p7%
%1 %2 %p3% %p4% %p5% E000~101%p6%       e0000099.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~10%p6%       e0000008.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~11%p6%       e0000009.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~12%p6%       e0000010.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~13%p6%       e0000011.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~14%p6%       e0000012.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~15%p6%       e0000013.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~16%p6%       e0000014.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~17%p6%       e0000015.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~18%p6%       e0000016.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~19%p6%       e0000017.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~20%p6%       e0000018.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~21%p6%       e0000019.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~22%p6%       e0000020.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~23%p6%       e0000021.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~24%p6%       e0000022.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~25%p6%       e0000023.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~26%p6%       e0000024.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~27%p6%       e0000025.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~28%p6%       e0000026.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~29%p6%       e0000027.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~30%p6%       e0000028.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~31%p6%       e0000029.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~32%p6%       e0000030.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~33%p6%       e0000031.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~34%p6%       e0000032.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~35%p6%       e0000033.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~36%p6%       e0000034.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~37%p6%       e0000035.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~38%p6%       e0000036.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~39%p6%       e0000037.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~40%p6%       e0000038.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~41%p6%       e0000039.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~42%p6%       e0000040.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~43%p6%       e0000041.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~44%p6%       e0000042.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~45%p6%       e0000043.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~46%p6%       e0000044.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~47%p6%       e0000045.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~48%p6%       e0000046.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~49%p6%       e0000047.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~50%p6%       e0000048.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~51%p6%       e0000049.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~52%p6%       e0000050.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~53%p6%       e0000051.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~54%p6%       e0000052.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~55%p6%       e0000053.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~56%p6%       e0000054.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~57%p6%       e0000055.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~58%p6%       e0000056.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~59%p6%       e0000057.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~60%p6%       e0000058.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~61%p6%       e0000059.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~62%p6%       e0000060.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~63%p6%       e0000061.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~64%p6%       e0000062.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~65%p6%       e0000063.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~66%p6%       e0000064.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~67%p6%       e0000065.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~68%p6%       e0000066.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~69%p6%       e0000067.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~70%p6%       e0000068.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~71%p6%       e0000069.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~72%p6%       e0000070.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~73%p6%       e0000071.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~74%p6%       e0000072.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~75%p6%       e0000073.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~76%p6%       e0000074.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~77%p6%       e0000075.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~78%p6%       e0000076.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~79%p6%       e0000077.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~80%p6%       e0000078.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~81%p6%       e0000079.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~82%p6%       e0000080.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~83%p6%       e0000081.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~84%p6%       e0000082.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~85%p6%       e0000083.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~86%p6%       e0000084.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~87%p6%       e0000085.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~88%p6%       e0000086.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~89%p6%       e0000087.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~90%p6%       e0000088.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~91%p6%       e0000089.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~92%p6%       e0000090.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~93%p6%       e0000091.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~94%p6%       e0000092.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~95%p6%       e0000093.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~96%p6%       e0000094.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~97%p6%       e0000095.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~98%p6%       e0000096.EWI%p7%
%1 %2 %p3% %p4% %p5% E0000~99%p6%       e0000097.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~1%p6%       e0000000.BAT%p7%
%1 %2 %p3% %p4% %p5% E00000~2%p6%       e0000000.TXT%p7%
%1 %2 %p3% %p4% %p5% E00000~3%p6%       e0000001.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~4%p6%       e0000002.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~5%p6%       e0000003.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~6%p6%       e0000004.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~7%p6%       e0000005.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~8%p6%       e0000006.EWI%p7%
%1 %2 %p3% %p4% %p5% E00000~9%p6%       e0000007.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~1%p6%       e0000100.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~2%p6%       e0000101.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~3%p6%       e0000102.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~4%p6%       e0000103.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~5%p6%       e0000104.EWI%p7%
%1 %2 %p3% %p4% %p5% E00001~6%p6%       e0000105.EWI%p7%
%1 %2 %p3% %p4% %p5% ESEM0A~1%p6%       esem0.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM10~1%p6%       esem10.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM10~2%p6%       esem10_.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM10~3%p6%       esem101.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM12~1%p6%       esem121.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM1A~1%p6%       esem1.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM2_~1%p6%       esem2_.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM2A~1%p6%       esem2.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM3A~1%p6%       esem3.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM5_~1%p6%       esem5_.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM51~1%p6%       esem51.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM5A~1%p6%       esem5.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM6_~1%p6%       esem6_.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM61~1%p6%       esem61.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM6A~1%p6%       esem6.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM7_~1%p6%       esem7_.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM7A~1%p6%       esem7.aeh%p7%
%1 %2 %p3% %p4% %p5% ESEM8A~1%p6%       esem8.aeh%p7%
%1 %2 %p3% %p4% %p5% FAR_IN~1%p6%       far_inst.exe%p7%
%1 %2 %p3% %p4% %p5% FAR_IN~2%p6%       far_inst.txt%p7%
%1 %2 %p3% %p4% %p5% FARBAT~1%p6%       FARBatch.INI%p7%
%1 %2 %p3% %p4% %p5% FAREXE~1%p6%       FAR.exe%p7%
%1 %2 %p3% %p4% %p5% FARHEL~1%p6%       farhelp.chm%p7%
%1 %2 %p3% %p4% %p5% FILE_I~1%p6%       FILE_ID.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~2%p6%       FILE_ID7.DIZ%p7%
%1 %2 %p3% %p4% %p5% FILE_I~3%p6%       FILE_IDB.DIZ%p7%
%1 %2 %p3% %p4% %p5% FINEST~1%p6%       Finestre.aeh%p7%
%1 %2 %p3% %p4% %p5% FOL1AE~1%p6%       fol1.aeh%p7%
%1 %2 %p3% %p4% %p5% FORMLE~1%p6%       "Form length.htm_txt%p7%"
%1 %2 %p3% %p4% %p5% FOUR1F~1%p6%       four1.frm%p7%
%1 %2 %p3% %p4% %p5% FOURBO~1%p6%       "four border.frm%p7%"
%1 %2 %p3% %p4% %p5% FOURFR~1%p6%       four.frm%p7%
%1 %2 %p3% %p4% %p5% FRDXGI~1%p6%       frDxGialla.bmp%p7%
%1 %2 %p3% %p4% %p5% GIDREM~1%p6%       GIDREMOV.EXE%p7%
%1 %2 %p3% %p4% %p5% GOODBY~1%p6%       goodbye.txt%p7%
%1 %2 %p3% %p4% %p5% GOODBY~2%p6%       goodbye_.txt%p7%
%1 %2 %p3% %p4% %p5% HCER_~1%p6%        HC.ER_%p7%
%1 %2 %p3% %p4% %p5% HCEX_~1%p6%        HC.EX_%p7%
%1 %2 %p3% %p4% %p5% HELP32~1%p6%       help32.exe%p7%
%1 %2 %p3% %p4% %p5% HELPDE~1%p6%       HELPDEC1.C%p7%
%1 %2 %p3% %p4% %p5% HELPDE~2%p6%       HELPDECO.C%p7%
%1 %2 %p3% %p4% %p5% HELPDE~3%p6%       HELPDECO.EXE%p7%
%1 %2 %p3% %p4% %p5% HELPDE~4%p6%       HELPDECO.H%p7%
%1 %2 %p3% %p4% %p5% HELPDE~5%p6%       HELPDECO.TXT%p7%
%1 %2 %p3% %p4% %p5% HELPFI~1%p6%       HELPFILE.TXT%p7%
%1 %2 %p3% %p4% %p5% HELPHE~1%p6%       HelpHelp.ex_%p7%
%1 %2 %p3% %p4% %p5% HELPHE~2%p6%       HELPHELP.HL_%p7%
%1 %2 %p3% %p4% %p5% HELPHE~3%p6%       HELPHELP.HLP%p7%
%1 %2 %p3% %p4% %p5% HELPSC~1%p6%       HelpScr.pak%p7%
%1 %2 %p3% %p4% %p5% HELPSO~1%p6%       "Help Source.cn_%p7%"
%1 %2 %p3% %p4% %p5% HELPSO~2%p6%       "HELP SOURCE.HL_%p7%"
%1 %2 %p3% %p4% %p5% HELPSO~3%p6%       "Help Source 1.2%p7%"
%1 %2 %p3% %p4% %p5% HELPX_~1%p6%       HELPX_1D.EXE%p7%
%1 %2 %p3% %p4% %p5% HISTOR~1%p6%       history.txt%p7%
%1 %2 %p3% %p4% %p5% HLP2TX~1%p6%       hlp2txt.txt%p7%
%1 %2 %p3% %p4% %p5% HLPTXT~1%p6%       hlptxt.cnt%p7%
%1 %2 %p3% %p4% %p5% HLPTXT~2%p6%       Hlptxt.hlp%p7%
%1 %2 %p3% %p4% %p5% HLPX13~1%p6%       HLPX13SE.EXE%p7%
%1 %2 %p3% %p4% %p5% HTMLAE~1%p6%       Html.aeh%p7%
%1 %2 %p3% %p4% %p5% IMMAGI~1%p6%       Immagini.aeh%p7%
%1 %2 %p3% %p4% %p5% INDEXA~1%p6%       INDEX.aeh%p7%
%1 %2 %p3% %p4% %p5% INDEXH~1%p6%       index.HPJ%p7%
%1 %2 %p3% %p4% %p5% INDEXR~1%p6%       index.rtf%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       Install_e.exe%p7%
%1 %2 %p3% %p4% %p5% INTEST~1%p6%       IntestazioniEPieDiPagina.aeh%p7%
%1 %2 %p3% %p4% %p5% IPER3R~1%p6%       IPER3rd_e.exe%p7%
%1 %2 %p3% %p4% %p5% IPER3W~1%p6%       IPER3whDemo_e.exe%p7%
%1 %2 %p3% %p4% %p5% JAVAAP~1%p6%       "Java applet with alternative image.ogg_txt%p7%"
%1 %2 %p3% %p4% %p5% JAVASC~1%p6%       "Java script.hd_txt%p7%"
%1 %2 %p3% %p4% %p5% JAVASC~2%p6%       Javascript.aeh%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       license.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~2%p6%       license_.txt%p7%
%1 %2 %p3% %p4% %p5% LICENS~3%p6%       licensee.txt%p7%
%1 %2 %p3% %p4% %p5% LISEZM~1%p6%       lisezmoi.txt%p7%
%1 %2 %p3% %p4% %p5% LISTEA~1%p6%       Liste.aeh%p7%
%1 %2 %p3% %p4% %p5% METAHD~1%p6%       Meta.hd_txt%p7%
%1 %2 %p3% %p4% %p5% MIDEIN~1%p6%       MiDeinst.exe%p7%
%1 %2 %p3% %p4% %p5% MODULI~1%p6%       moduli.aeh%p7%
%1 %2 %p3% %p4% %p5% MULTIM~1%p6%       Multimedia.aeh%p7%
%1 %2 %p3% %p4% %p5% OBJECT~1%p6%       "Object with alternative image.ogg_txt%p7%"
%1 %2 %p3% %p4% %p5% OBJECT~2%p6%       "Object with alternative image 2.ogg_txt%p7%"
%1 %2 %p3% %p4% %p5% ORDERH~1%p6%       ORDER.HLP%p7%
%1 %2 %p3% %p4% %p5% P1GIF~1%p6%        p1.gif%p7%
%1 %2 %p3% %p4% %p5% P2GIF~1%p6%        p2.gif%p7%
%1 %2 %p3% %p4% %p5% P3GIF~1%p6%        p3.gif%p7%
%1 %2 %p3% %p4% %p5% P4GIF~1%p6%        p4.gif%p7%
%1 %2 %p3% %p4% %p5% PREVIE~1%p6%       PREVIEW.HLP%p7%
%1 %2 %p3% %p4% %p5% PREVW3~1%p6%       PREVW32.HLP%p7%
%1 %2 %p3% %p4% %p5% PVPLUS~1%p6%       Pvplus32.dll%p7%
%1 %2 %p3% %p4% %p5% READM~10%p6%       README_6.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~11%p6%       README_7.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~12%p6%       README_8.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~13%p6%       README_9.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~14%p6%       README_A.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~15%p6%       README_B.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~16%p6%       README_C.TXT%p7%
%1 %2 %p3% %p4% %p5% READM~17%p6%       readme_d.txt%p7%
%1 %2 %p3% %p4% %p5% READM~18%p6%       readme_e.txt%p7%
%1 %2 %p3% %p4% %p5% README~1%p6%       readme.tx_%p7%
%1 %2 %p3% %p4% %p5% README~2%p6%       readme.txt%p7%
%1 %2 %p3% %p4% %p5% README~3%p6%       README_.TXT%p7%
%1 %2 %p3% %p4% %p5% README~4%p6%       README_0.TXT%p7%
%1 %2 %p3% %p4% %p5% README~5%p6%       README_1.TXT%p7%
%1 %2 %p3% %p4% %p5% README~6%p6%       README_2.TXT%p7%
%1 %2 %p3% %p4% %p5% README~7%p6%       README_3.TXT%p7%
%1 %2 %p3% %p4% %p5% README~8%p6%       README_4.TXT%p7%
%1 %2 %p3% %p4% %p5% README~9%p6%       README_5.TXT%p7%
%1 %2 %p3% %p4% %p5% RESOLU~1%p6%       RESOLUTE.EXE%p7%
%1 %2 %p3% %p4% %p5% RESOLU~2%p6%       RESOLUTE.TXT%p7%
%1 %2 %p3% %p4% %p5% RICHED~1%p6%       RICHED3_.DL_%p7%
%1 %2 %p3% %p4% %p5% RICHED~2%p6%       RichEd32.dl_%p7%
%1 %2 %p3% %p4% %p5% RICHTX~1%p6%       RICHTX3_.OC_%p7%
%1 %2 %p3% %p4% %p5% RICHTX~2%p6%       RICHTX32.OC_%p7%
%1 %2 %p3% %p4% %p5% RTF2HL~1%p6%       RTF2HLP.EXE%p7%
%1 %2 %p3% %p4% %p5% RTF2HL~2%p6%       RTF2HLP.HLP%p7%
%1 %2 %p3% %p4% %p5% SETUEN~1%p6%       SETUENG.DLL%p7%
%1 %2 %p3% %p4% %p5% SETUP_~1%p6%       SETUP_.INI%p7%
%1 %2 %p3% %p4% %p5% SETUP_~2%p6%       SETUP_3.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~3%p6%       SETUP_4.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~4%p6%       SETUP_5.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~5%p6%       SETUP_8.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP_~6%p6%       SETUP_8.LST%p7%
%1 %2 %p3% %p4% %p5% SETUP_~7%p6%       SETUP_B.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUP1~1%p6%       setup1.ex_%p7%
%1 %2 %p3% %p4% %p5% SETUP1~2%p6%       SETUP1_.EX_%p7%
%1 %2 %p3% %p4% %p5% SETUPE~1%p6%       SETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% SETUPI~1%p6%       SETUP.INI%p7%
%1 %2 %p3% %p4% %p5% SETUPI~2%p6%       SETUP.INS%p7%
%1 %2 %p3% %p4% %p5% SETUPI~3%p6%       SETUP.ISS%p7%
%1 %2 %p3% %p4% %p5% SETUPL~1%p6%       SETUP.LST%p7%
%1 %2 %p3% %p4% %p5% SETUPP~1%p6%       SETUP.PKG%p7%
%1 %2 %p3% %p4% %p5% SILOGO~1%p6%       silogo.ICO%p7%
%1 %2 %p3% %p4% %p5% SILOGO~2%p6%       silogo.wmf%p7%
%1 %2 %p3% %p4% %p5% SILOGO~3%p6%       SILOGO_.ICO%p7%
%1 %2 %p3% %p4% %p5% SIMPLE~1%p6%       "Simple image reference.htm_txt%p7%"
%1 %2 %p3% %p4% %p5% SIMPLE~2%p6%       "Simple script.htm_txt%p7%"
%1 %2 %p3% %p4% %p5% SIMTEL~1%p6%       SIMTEL.TXT%p7%
%1 %2 %p3% %p4% %p5% SLIDE1~1%p6%       slide1.aeh%p7%
%1 %2 %p3% %p4% %p5% SLIDE1~2%p6%       slide11.aeh%p7%
%1 %2 %p3% %p4% %p5% SPLITM~1%p6%       SPLITMRB.C%p7%
%1 %2 %p3% %p4% %p5% SPLITM~2%p6%       SPLITMRB.EXE%p7%
%1 %2 %p3% %p4% %p5% SSETUP~1%p6%       ssetup.gif%p7%
%1 %2 %p3% %p4% %p5% SSPLAS~1%p6%       ssplash.gif%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~1%p6%       ST5UNST.EX_%p7%
%1 %2 %p3% %p4% %p5% ST5UNS~2%p6%       ST5UNST_.EX_%p7%
%1 %2 %p3% %p4% %p5% STILIA~1%p6%       Stili.aeh%p7%
%1 %2 %p3% %p4% %p5% STILIG~1%p6%       STILI.GID%p7%
%1 %2 %p3% %p4% %p5% STILIH~1%p6%       STILI.HLP%p7%
%1 %2 %p3% %p4% %p5% STILIH~2%p6%       Stili.HPJ%p7%
%1 %2 %p3% %p4% %p5% STILIR~1%p6%       Stili.rtf%p7%
%1 %2 %p3% %p4% %p5% TABELL~1%p6%       tabelle.aeh%p7%
%1 %2 %p3% %p4% %p5% TESTRT~1%p6%       TEST.RTF%p7%
%1 %2 %p3% %p4% %p5% TRE1FR~1%p6%       "tre 1.frm%p7%"
%1 %2 %p3% %p4% %p5% TRE1W-~1%p6%       "tre 1 w-o border.frm%p7%"
%1 %2 %p3% %p4% %p5% TRE1WI~1%p6%       "tre 1 without border.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOHOR~1%p6%       "two horizontal.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOHOR~2%p6%       "two horizontal 100.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOHOR~3%p6%       "two horizontal 11.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOHOR~4%p6%       "two horizontal border.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOHOR~5%p6%       "two horizontal sup fix 60.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOVER~1%p6%       "two vertical 1.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOVER~2%p6%       "two vertical 102.frm%p7%"
%1 %2 %p3% %p4% %p5% TWOVER~3%p6%       "two vertical w-o border.frm%p7%"
%1 %2 %p3% %p4% %p5% UNINST~1%p6%       UNINST.EXE%p7%
%1 %2 %p3% %p4% %p5% UNINST~2%p6%       UNINSTALL.BAT%p7%
%1 %2 %p3% %p4% %p5% UNSETU~1%p6%       UNSETUP.EXE%p7%
%1 %2 %p3% %p4% %p5% UNSETU~2%p6%       UNSETUP.LST%p7%
%1 %2 %p3% %p4% %p5% VB5STK~1%p6%       VB5STKI_.DL_%p7%
%1 %2 %p3% %p4% %p5% VB5STK~2%p6%       VB5StKit.dl_%p7%
%1 %2 %p3% %p4% %p5% VENDEU~1%p6%       vendeurs.txt%p7%
%1 %2 %p3% %p4% %p5% VENDOR~1%p6%       vendor.txt%p7%
%1 %2 %p3% %p4% %p5% WELCOM~1%p6%       welcome.txt%p7%
%1 %2 %p3% %p4% %p5% WELCOM~2%p6%       welcome_.txt%p7%
%1 %2 %p3% %p4% %p5% WINCTL~1%p6%       Winctl32.dll%p7%
%1 %2 %p3% %p4% %p5% XCDUNZ~1%p6%       XCDUNZ32.DLL%p7%
%1 %2 %p3% %p4% %p5% XCDZIP~1%p6%       XCDZIP32.DLL%p7%
%1 %2 %p3% %p4% %p5% ZAPRES~1%p6%       ZAPRES.C%p7%
%1 %2 %p3% %p4% %p5% ZAPRES~2%p6%       ZAPRES.EXE%p7%

cd %dira%

%1 %2 %p3% %p4% %p5% 10X20P~1%p6%       10x20.pcf%p7%
%1 %2 %p3% %p4% %p5% 12X24P~1%p6%       12x24.pcf%p7%
%1 %2 %p3% %p4% %p5% 12X24R~1%p6%       12x24rk.pcf%p7%
%1 %2 %p3% %p4% %p5% 3C501C~1%p6%       3C501.COM%p7%
%1 %2 %p3% %p4% %p5% 3C503C~1%p6%       3C503.COM%p7%
%1 %2 %p3% %p4% %p5% 3C505C~1%p6%       3C505.COM%p7%
%1 %2 %p3% %p4% %p5% 3C507C~1%p6%       3C507.COM%p7%
%1 %2 %p3% %p4% %p5% 3C509C~1%p6%       3C509.COM%p7%
%1 %2 %p3% %p4% %p5% 3C523C~1%p6%       3C523.COM%p7%
%1 %2 %p3% %p4% %p5% 5X7PCF~1%p6%       5x7.pcf%p7%
%1 %2 %p3% %p4% %p5% 5X8PCF~1%p6%       5x8.pcf%p7%
%1 %2 %p3% %p4% %p5% 6X10PC~1%p6%       6x10.pcf%p7%
%1 %2 %p3% %p4% %p5% 6X12PC~1%p6%       6x12.pcf%p7%
%1 %2 %p3% %p4% %p5% 6X13BP~1%p6%       6x13B.pcf%p7%
%1 %2 %p3% %p4% %p5% 6X13PC~1%p6%       6x13.pcf%p7%
%1 %2 %p3% %p4% %p5% 6X9PCF~1%p6%       6x9.pcf%p7%
%1 %2 %p3% %p4% %p5% 7X13BP~1%p6%       7x13B.pcf%p7%
%1 %2 %p3% %p4% %p5% 7X13PC~1%p6%       7x13.pcf%p7%
%1 %2 %p3% %p4% %p5% 7X14BP~1%p6%       7x14B.pcf%p7%
%1 %2 %p3% %p4% %p5% 7X14PC~1%p6%       7x14.pcf%p7%
%1 %2 %p3% %p4% %p5% 7X14RK~1%p6%       7x14rk.pcf%p7%
%1 %2 %p3% %p4% %p5% 8X13BP~1%p6%       8x13B.pcf%p7%
%1 %2 %p3% %p4% %p5% 8X13PC~1%p6%       8x13.pcf%p7%
%1 %2 %p3% %p4% %p5% 8X16PC~1%p6%       8x16.pcf%p7%
%1 %2 %p3% %p4% %p5% 8X16RK~1%p6%       8x16rk.pcf%p7%
%1 %2 %p3% %p4% %p5% 9X15BP~1%p6%       9x15B.pcf%p7%
%1 %2 %p3% %p4% %p5% 9X15PC~1%p6%       9x15.pcf%p7%
%1 %2 %p3% %p4% %p5% AQUILA~1%p6%       AQUILA.COM%p7%
%1 %2 %p3% %p4% %p5% AR450C~1%p6%       AR450.COM%p7%
%1 %2 %p3% %p4% %p5% ARCETH~1%p6%       ARCETHER.COM%p7%
%1 %2 %p3% %p4% %p5% ARCNET~1%p6%       ARCNET.COM%p7%
%1 %2 %p3% %p4% %p5% AT&T_L~1%p6%       AT&T_LP.COM%p7%
%1 %2 %p3% %p4% %p5% AT&TCO~1%p6%       AT&T.COM%p7%
%1 %2 %p3% %p4% %p5% AT1500~1%p6%       AT1500.COM%p7%
%1 %2 %p3% %p4% %p5% AT1700~1%p6%       AT1700.COM%p7%
%1 %2 %p3% %p4% %p5% BDFTOP~1%p6%       bdftopcf.exe%p7%
%1 %2 %p3% %p4% %p5% C_ARI0~1%p6%       c_arI08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~1%p6%       c_arI10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~2%p6%       c_arI12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~3%p6%       c_arI14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARI1~4%p6%       c_arI18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARI2~1%p6%       c_arI24.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR0~1%p6%       c_arR08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~1%p6%       c_arR10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~2%p6%       c_arR12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~3%p6%       c_arR14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR1~4%p6%       c_arR18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_ARR2~1%p6%       c_arR24.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB0~1%p6%       c_urB08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB1~1%p6%       c_urB10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB1~2%p6%       c_urB12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB1~3%p6%       c_urB14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB1~4%p6%       c_urB18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URB2~1%p6%       c_urB24.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~1%p6%       c_urBO08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~2%p6%       c_urBO10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~3%p6%       c_urBO12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~4%p6%       c_urBO14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~5%p6%       c_urBO18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URBO~6%p6%       c_urBO24.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO0~1%p6%       c_urO08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO1~1%p6%       c_urO10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO1~2%p6%       c_urO12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO1~3%p6%       c_urO14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO1~4%p6%       c_urO18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URO2~1%p6%       c_urO24.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR0~1%p6%       c_urR08.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR1~1%p6%       c_urR10.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR1~2%p6%       c_urR12.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR1~3%p6%       c_urR14.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR1~4%p6%       c_urR18.pcf%p7%
%1 %2 %p3% %p4% %p5% C_URR2~1%p6%       c_urR24.pcf%p7%
%1 %2 %p3% %p4% %p5% C0419B~1%p6%       c0419bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0582B~1%p6%       c0582bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0583B~1%p6%       c0583bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0611B~1%p6%       c0611bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0632B~1%p6%       c0632bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0633B~1%p6%       c0633bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0648B~1%p6%       c0648bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% C0649B~1%p6%       c0649bt_.pfb%p7%
%1 %2 %p3% %p4% %p5% CHARI0~1%p6%       charI08.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARI1~1%p6%       charI10.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARI1~2%p6%       charI12.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARI1~3%p6%       charI14.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARI1~4%p6%       charI18.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARI2~1%p6%       charI24.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR0~1%p6%       charR08.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR1~1%p6%       charR10.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR1~2%p6%       charR12.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR1~3%p6%       charR14.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR1~4%p6%       charR18.pcf%p7%
%1 %2 %p3% %p4% %p5% CHARR2~1%p6%       charR24.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB6X1~1%p6%       clB6x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB6X1~2%p6%       clB6x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~1%p6%       clB8x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~2%p6%       clB8x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~3%p6%       clB8x13.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~4%p6%       clB8x14.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X1~5%p6%       clB8x16.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB8X8~1%p6%       clB8x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLB9X1~1%p6%       clB9x15.pcf%p7%
%1 %2 %p3% %p4% %p5% CLI6X1~1%p6%       clI6x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLI8X8~1%p6%       clI8x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR4X6~1%p6%       clR4x6.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR5X1~1%p6%       clR5x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR5X6~1%p6%       clR5x6.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR5X8~1%p6%       clR5x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~1%p6%       clR6x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~2%p6%       clR6x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR6X1~3%p6%       clR6x13.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR6X6~1%p6%       clR6x6.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR6X8~1%p6%       clR6x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~1%p6%       clR7x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~2%p6%       clR7x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR7X1~3%p6%       clR7x14.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR7X8~1%p6%       clR7x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~1%p6%       clR8x10.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~2%p6%       clR8x12.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~3%p6%       clR8x13.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~4%p6%       clR8x14.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X1~5%p6%       clR8x16.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR8X8~1%p6%       clR8x8.pcf%p7%
%1 %2 %p3% %p4% %p5% CLR9X1~1%p6%       clR9x15.pcf%p7%
%1 %2 %p3% %p4% %p5% CONFIG~1%p6%       CONFIG.PPP%p7%
%1 %2 %p3% %p4% %p5% COURB0~1%p6%       courB08.pcf%p7%
%1 %2 %p3% %p4% %p5% COURB1~1%p6%       courB10.pcf%p7%
%1 %2 %p3% %p4% %p5% COURB1~2%p6%       courB12.pcf%p7%
%1 %2 %p3% %p4% %p5% COURB1~3%p6%       courB14.pcf%p7%
%1 %2 %p3% %p4% %p5% COURB1~4%p6%       courB18.pcf%p7%
%1 %2 %p3% %p4% %p5% COURB2~1%p6%       courB24.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBI~1%p6%       courbi.pfa%p7%
%1 %2 %p3% %p4% %p5% COURBO~1%p6%       courBO08.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBO~2%p6%       courBO10.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBO~3%p6%       courBO12.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBO~4%p6%       courBO14.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBO~5%p6%       courBO18.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBO~6%p6%       courBO24.pcf%p7%
%1 %2 %p3% %p4% %p5% COURBP~1%p6%       courb.pfa%p7%
%1 %2 %p3% %p4% %p5% COURIP~1%p6%       couri.pfa%p7%
%1 %2 %p3% %p4% %p5% COURO0~1%p6%       courO08.pcf%p7%
%1 %2 %p3% %p4% %p5% COURO1~1%p6%       courO10.pcf%p7%
%1 %2 %p3% %p4% %p5% COURO1~2%p6%       courO12.pcf%p7%
%1 %2 %p3% %p4% %p5% COURO1~3%p6%       courO14.pcf%p7%
%1 %2 %p3% %p4% %p5% COURO1~4%p6%       courO18.pcf%p7%
%1 %2 %p3% %p4% %p5% COURO2~1%p6%       courO24.pcf%p7%
%1 %2 %p3% %p4% %p5% COURPF~1%p6%       cour.pfa%p7%
%1 %2 %p3% %p4% %p5% COURR0~1%p6%       courR08.pcf%p7%
%1 %2 %p3% %p4% %p5% COURR1~1%p6%       courR10.pcf%p7%
%1 %2 %p3% %p4% %p5% COURR1~2%p6%       courR12.pcf%p7%
%1 %2 %p3% %p4% %p5% COURR1~3%p6%       courR14.pcf%p7%
%1 %2 %p3% %p4% %p5% COURR1~4%p6%       courR18.pcf%p7%
%1 %2 %p3% %p4% %p5% COURR2~1%p6%       courR24.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1C~1%p6%       crox1c.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1C~2%p6%       crox1cb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1C~3%p6%       crox1cbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1C~4%p6%       crox1co.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1H~1%p6%       crox1h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1H~2%p6%       crox1hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1H~3%p6%       crox1hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1H~4%p6%       crox1ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1T~1%p6%       crox1t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1T~2%p6%       crox1tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1T~3%p6%       crox1tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX1T~4%p6%       crox1to.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2C~1%p6%       crox2c.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2C~2%p6%       crox2cb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2C~3%p6%       crox2cbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2C~4%p6%       crox2co.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2H~1%p6%       crox2h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2H~2%p6%       crox2hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2H~3%p6%       crox2hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2H~4%p6%       crox2ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2T~1%p6%       crox2t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2T~2%p6%       crox2tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2T~3%p6%       crox2tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX2T~4%p6%       crox2to.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3C~1%p6%       crox3c.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3C~2%p6%       crox3cb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3C~3%p6%       crox3cbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3C~4%p6%       crox3co.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3H~1%p6%       crox3h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3H~2%p6%       crox3hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3H~3%p6%       crox3hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3H~4%p6%       crox3ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3T~1%p6%       crox3t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3T~2%p6%       crox3tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3T~3%p6%       crox3tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX3T~4%p6%       crox3to.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4H~1%p6%       crox4h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4H~2%p6%       crox4hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4H~3%p6%       crox4hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4H~4%p6%       crox4ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4T~1%p6%       crox4t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4T~2%p6%       crox4tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4T~3%p6%       crox4tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX4T~4%p6%       crox4to.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5H~1%p6%       crox5h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5H~2%p6%       crox5hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5H~3%p6%       crox5hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5H~4%p6%       crox5ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5T~1%p6%       crox5t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5T~2%p6%       crox5tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5T~3%p6%       crox5tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX5T~4%p6%       crox5to.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6H~1%p6%       crox6h.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6H~2%p6%       crox6hb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6H~3%p6%       crox6hbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6H~4%p6%       crox6ho.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6T~1%p6%       crox6t.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6T~2%p6%       crox6tb.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6T~3%p6%       crox6tbo.pcf%p7%
%1 %2 %p3% %p4% %p5% CROX6T~4%p6%       crox6to.pcf%p7%
%1 %2 %p3% %p4% %p5% CSLIPP~1%p6%       CSLIPPER.EXE%p7%
%1 %2 %p3% %p4% %p5% CTROND~1%p6%       CTRONDNI.COM%p7%
%1 %2 %p3% %p4% %p5% CURSOR~1%p6%       cursor.pcf%p7%
%1 %2 %p3% %p4% %p5% DAVIDS~1%p6%       DAVIDSYS.COM%p7%
%1 %2 %p3% %p4% %p5% DE600C~1%p6%       DE600.COM%p7%
%1 %2 %p3% %p4% %p5% DECCUR~1%p6%       deccurs.pcf%p7%
%1 %2 %p3% %p4% %p5% DECSES~1%p6%       decsess.pcf%p7%
%1 %2 %p3% %p4% %p5% DEPCAC~1%p6%       DEPCA.COM%p7%
%1 %2 %p3% %p4% %p5% DIALPP~1%p6%       DIAL.PPP%p7%
%1 %2 %p3% %p4% %p5% DIS_PK~1%p6%       DIS_PKT.DOC%p7%
%1 %2 %p3% %p4% %p5% DIS_PK~2%p6%       DIS_PKT.DOS%p7%
%1 %2 %p3% %p4% %p5% DK8696~1%p6%       DK86960.COM%p7%
%1 %2 %p3% %p4% %p5% DK8696~2%p6%       DK86965.COM%p7%
%1 %2 %p3% %p4% %p5% EMU387~1%p6%       emu387.%p7%
%1 %2 %p3% %p4% %p5% EN301C~1%p6%       EN301.COM%p7%
%1 %2 %p3% %p4% %p5% ES3210~1%p6%       ES3210.COM%p7%
%1 %2 %p3% %p4% %p5% ETHERS~1%p6%       ETHERSL.COM%p7%
%1 %2 %p3% %p4% %p5% ETHIIE~1%p6%       ETHIIE.COM%p7%
%1 %2 %p3% %p4% %p5% EXOS20~1%p6%       EXOS205.COM%p7%
%1 %2 %p3% %p4% %p5% EXP16C~1%p6%       EXP16.COM%p7%
%1 %2 %p3% %p4% %p5% EXPRES~1%p6%       EXPRESS.COM%p7%
%1 %2 %p3% %p4% %p5% F_NTSA~1%p6%       f_nts.ali%p7%
%1 %2 %p3% %p4% %p5% F_NTSD~1%p6%       f_nts.dir%p7%
%1 %2 %p3% %p4% %p5% FONT04~1%p6%       font0419.spd%p7%
%1 %2 %p3% %p4% %p5% FONT05~1%p6%       font0582.spd%p7%
%1 %2 %p3% %p4% %p5% FONT05~2%p6%       font0583.spd%p7%
%1 %2 %p3% %p4% %p5% FONT06~1%p6%       font0611.spd%p7%
%1 %2 %p3% %p4% %p5% FONT06~2%p6%       font0648.spd%p7%
%1 %2 %p3% %p4% %p5% FONT06~3%p6%       font0649.spd%p7%
%1 %2 %p3% %p4% %p5% FONT07~1%p6%       font0709.spd%p7%
%1 %2 %p3% %p4% %p5% FONT07~2%p6%       font0710.spd%p7%
%1 %2 %p3% %p4% %p5% FONTS_~1%p6%       FONTS_.DIR%p7%
%1 %2 %p3% %p4% %p5% FONTS_~2%p6%       FONTS_2.ALI%p7%
%1 %2 %p3% %p4% %p5% FONTS_~3%p6%       FONTS_2.DIR%p7%
%1 %2 %p3% %p4% %p5% FONTS_~4%p6%       FONTS_3.DIR%p7%
%1 %2 %p3% %p4% %p5% FONTS_~5%p6%       FONTS_3.SCA%p7%
%1 %2 %p3% %p4% %p5% FONTS_~6%p6%       FONTS_4.DIR%p7%
%1 %2 %p3% %p4% %p5% FONTS_~7%p6%       FONTS_5.ALI%p7%
%1 %2 %p3% %p4% %p5% FONTS_~8%p6%       FONTS_5.DIR%p7%
%1 %2 %p3% %p4% %p5% FONTSA~1%p6%       fonts.ali%p7%
%1 %2 %p3% %p4% %p5% FONTSD~1%p6%       fonts.dir%p7%
%1 %2 %p3% %p4% %p5% FONTSS~1%p6%       fonts.sca%p7%
%1 %2 %p3% %p4% %p5% GB16FS~1%p6%       gb16fs.pcf%p7%
%1 %2 %p3% %p4% %p5% GB16ST~1%p6%       gb16st.pcf%p7%
%1 %2 %p3% %p4% %p5% GB24ST~1%p6%       gb24st.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB0~1%p6%       h_lvB08.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~1%p6%       h_lvB10.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~2%p6%       h_lvB12.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~3%p6%       h_lvB14.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB1~4%p6%       h_lvB18.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVB2~1%p6%       h_lvB24.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~1%p6%       h_lvBO08.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~2%p6%       h_lvBO10.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~3%p6%       h_lvBO12.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~4%p6%       h_lvBO14.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~5%p6%       h_lvBO18.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVBO~6%p6%       h_lvBO24.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO0~1%p6%       h_lvO08.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~1%p6%       h_lvO10.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~2%p6%       h_lvO12.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~3%p6%       h_lvO14.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO1~4%p6%       h_lvO18.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVO2~1%p6%       h_lvO24.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR0~1%p6%       h_lvR08.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~1%p6%       h_lvR10.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~2%p6%       h_lvR12.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~3%p6%       h_lvR14.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR1~4%p6%       h_lvR18.pcf%p7%
%1 %2 %p3% %p4% %p5% H_LVR2~1%p6%       h_lvR24.pcf%p7%
%1 %2 %p3% %p4% %p5% HANGLG~1%p6%       hanglg16.pcf%p7%
%1 %2 %p3% %p4% %p5% HANGLM~1%p6%       hanglm16.pcf%p7%
%1 %2 %p3% %p4% %p5% HANGLM~2%p6%       hanglm24.pcf%p7%
%1 %2 %p3% %p4% %p5% HEB6X1~1%p6%       heb6x13.pcf%p7%
%1 %2 %p3% %p4% %p5% HEB8X1~1%p6%       heb8x13.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB0~1%p6%       helvB08.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB1~1%p6%       helvB10.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB1~2%p6%       helvB12.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB1~3%p6%       helvB14.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB1~4%p6%       helvB18.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVB2~1%p6%       helvB24.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~1%p6%       helvBO08.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~2%p6%       helvBO10.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~3%p6%       helvBO12.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~4%p6%       helvBO14.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~5%p6%       helvBO18.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVBO~6%p6%       helvBO24.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO0~1%p6%       helvO08.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO1~1%p6%       helvO10.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO1~2%p6%       helvO12.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO1~3%p6%       helvO14.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO1~4%p6%       helvO18.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVO2~1%p6%       helvO24.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR0~1%p6%       helvR08.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR1~1%p6%       helvR10.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR1~2%p6%       helvR12.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR1~3%p6%       helvR14.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR1~4%p6%       helvR18.pcf%p7%
%1 %2 %p3% %p4% %p5% HELVR2~1%p6%       helvR24.pcf%p7%
%1 %2 %p3% %p4% %p5% HPPCLA~1%p6%       HPPCLAN.COM%p7%
%1 %2 %p3% %p4% %p5% HPPCLA~2%p6%       HPPCLANP.COM%p7%
%1 %2 %p3% %p4% %p5% IBMTOK~1%p6%       IBMTOKEN.COM%p7%
%1 %2 %p3% %p4% %p5% INSTAL~1%p6%       INSTALL.BAT%p7%
%1 %2 %p3% %p4% %p5% INSTAL~2%p6%       INSTALL.DOC%p7%
%1 %2 %p3% %p4% %p5% IPXPKT~1%p6%       IPXPKT.COM%p7%
%1 %2 %p3% %p4% %p5% ISOLAN~1%p6%       ISOLAN.COM%p7%
%1 %2 %p3% %p4% %p5% ISOLIN~1%p6%       ISOLINK.COM%p7%
%1 %2 %p3% %p4% %p5% JISKAN~1%p6%       jiskan16.pcf%p7%
%1 %2 %p3% %p4% %p5% JISKAN~2%p6%       jiskan24.pcf%p7%
%1 %2 %p3% %p4% %p5% K14PCF~1%p6%       k14.pcf%p7%
%1 %2 %p3% %p4% %p5% KEYMA~10%p6%       KEYMAP.SF%p7%
%1 %2 %p3% %p4% %p5% KEYMA~11%p6%       KEYMAP.SG%p7%
%1 %2 %p3% %p4% %p5% KEYMA~12%p6%       KEYMAP.SP%p7%
%1 %2 %p3% %p4% %p5% KEYMA~13%p6%       KEYMAP.SU%p7%
%1 %2 %p3% %p4% %p5% KEYMA~14%p6%       KEYMAP.UK%p7%
%1 %2 %p3% %p4% %p5% KEYMA~15%p6%       KEYMAP.US%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~1%p6%       KEYMAP.BE%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~2%p6%       KEYMAP.CF%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~3%p6%       KEYMAP.DK%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~4%p6%       KEYMAP.FR%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~5%p6%       KEYMAP.GR%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~6%p6%       KEYMAP.IT%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~7%p6%       KEYMAP.NL%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~8%p6%       KEYMAP.NO%p7%
%1 %2 %p3% %p4% %p5% KEYMAP~9%p6%       KEYMAP.PO%p7%
%1 %2 %p3% %p4% %p5% KODIAK~1%p6%       KODIAK16.COM%p7%
%1 %2 %p3% %p4% %p5% KODIAK~2%p6%       KODIAK8.COM%p7%
%1 %2 %p3% %p4% %p5% KODIAK~3%p6%       KODIAKK.COM%p7%
%1 %2 %p3% %p4% %p5% KOI10X~1%p6%       koi10x16b.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI10X~2%p6%       koi10x20.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI12X~1%p6%       koi12x24.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI6X1~1%p6%       koi6x10.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI6X1~2%p6%       koi6x13.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI8X1~1%p6%       koi8x13.pcf%p7%
%1 %2 %p3% %p4% %p5% KOI9X1~1%p6%       koi9x15.pcf%p7%
%1 %2 %p3% %p4% %p5% KOINIL~1%p6%       koinil2.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB08~1%p6%       l_bB08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB10~1%p6%       l_bB10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB12~1%p6%       l_bB12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB14~1%p6%       l_bB14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB18~1%p6%       l_bB18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB19~1%p6%       l_bB19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BB24~1%p6%       l_bB24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI0~1%p6%       l_bBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~1%p6%       l_bBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~2%p6%       l_bBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~3%p6%       l_bBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~4%p6%       l_bBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI1~5%p6%       l_bBI19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BBI2~1%p6%       l_bBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI08~1%p6%       l_bI08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI10~1%p6%       l_bI10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI12~1%p6%       l_bI12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI14~1%p6%       l_bI14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI18~1%p6%       l_bI18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI19~1%p6%       l_bI19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BI24~1%p6%       l_bI24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS0~1%p6%       l_BIS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~1%p6%       l_BIS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~2%p6%       l_BIS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~3%p6%       l_BIS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~4%p6%       l_BIS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS1~5%p6%       l_BIS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BIS2~1%p6%       l_BIS24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR08~1%p6%       l_bR08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR10~1%p6%       l_bR10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR12~1%p6%       l_bR12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR14~1%p6%       l_bR14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR18~1%p6%       l_bR18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR19~1%p6%       l_bR19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BR24~1%p6%       l_bR24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS08~1%p6%       l_BS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS10~1%p6%       l_BS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS12~1%p6%       l_BS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS14~1%p6%       l_BS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS18~1%p6%       l_BS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS19~1%p6%       l_BS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_BS24~1%p6%       l_BS24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS08~1%p6%       l_IS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS10~1%p6%       l_IS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS12~1%p6%       l_IS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS14~1%p6%       l_IS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS18~1%p6%       l_IS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS19~1%p6%       l_IS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_IS24~1%p6%       l_IS24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS08~1%p6%       l_RS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS10~1%p6%       l_RS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS12~1%p6%       l_RS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS14~1%p6%       l_RS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS18~1%p6%       l_RS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS19~1%p6%       l_RS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_RS24~1%p6%       l_RS24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS0~1%p6%       l_tBS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~1%p6%       l_tBS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~2%p6%       l_tBS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~3%p6%       l_tBS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~4%p6%       l_tBS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS1~5%p6%       l_tBS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TBS2~1%p6%       l_tBS24.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS0~1%p6%       l_tRS08.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~1%p6%       l_tRS10.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~2%p6%       l_tRS12.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~3%p6%       l_tRS14.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~4%p6%       l_tRS18.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS1~5%p6%       l_tRS19.pcf%p7%
%1 %2 %p3% %p4% %p5% L_TRS2~1%p6%       l_tRS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LAN595~1%p6%       LAN595.COM%p7%
%1 %2 %p3% %p4% %p5% LICENS~1%p6%       license.txt%p7%
%1 %2 %p3% %p4% %p5% LUBB08~1%p6%       lubB08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB10~1%p6%       lubB10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB12~1%p6%       lubB12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB14~1%p6%       lubB14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB18~1%p6%       lubB18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB19~1%p6%       lubB19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBB24~1%p6%       lubB24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI0~1%p6%       lubBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~1%p6%       lubBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~2%p6%       lubBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~3%p6%       lubBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~4%p6%       lubBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI1~5%p6%       lubBI19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBBI2~1%p6%       lubBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI08~1%p6%       lubI08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI10~1%p6%       lubI10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI12~1%p6%       lubI12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI14~1%p6%       lubI14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI18~1%p6%       lubI18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI19~1%p6%       lubI19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBI24~1%p6%       lubI24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS0~1%p6%       luBIS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~1%p6%       luBIS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~2%p6%       luBIS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~3%p6%       luBIS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~4%p6%       luBIS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS1~5%p6%       luBIS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBIS2~1%p6%       luBIS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR08~1%p6%       lubR08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR10~1%p6%       lubR10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR12~1%p6%       lubR12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR14~1%p6%       lubR14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR18~1%p6%       lubR18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR19~1%p6%       lubR19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBR24~1%p6%       lubR24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS08~1%p6%       luBS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS10~1%p6%       luBS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS12~1%p6%       luBS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS14~1%p6%       luBS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS18~1%p6%       luBS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS19~1%p6%       luBS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUBS24~1%p6%       luBS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS08~1%p6%       luIS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS10~1%p6%       luIS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS12~1%p6%       luIS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS14~1%p6%       luIS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS18~1%p6%       luIS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS19~1%p6%       luIS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUIS24~1%p6%       luIS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS08~1%p6%       luRS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS10~1%p6%       luRS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS12~1%p6%       luRS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS14~1%p6%       luRS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS18~1%p6%       luRS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS19~1%p6%       luRS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LURS24~1%p6%       luRS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS0~1%p6%       lutBS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~1%p6%       lutBS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~2%p6%       lutBS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~3%p6%       lutBS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~4%p6%       lutBS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS1~5%p6%       lutBS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTBS2~1%p6%       lutBS24.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS0~1%p6%       lutRS08.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~1%p6%       lutRS10.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~2%p6%       lutRS12.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~3%p6%       lutRS14.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~4%p6%       lutRS18.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS1~5%p6%       lutRS19.pcf%p7%
%1 %2 %p3% %p4% %p5% LUTRS2~1%p6%       lutRS24.pcf%p7%
%1 %2 %p3% %p4% %p5% MKFNTD~1%p6%       mkfntdir.exe%p7%
%1 %2 %p3% %p4% %p5% MYLEXC~1%p6%       MYLEX.COM%p7%
%1 %2 %p3% %p4% %p5% N_ENB0~1%p6%       n_enB08.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~1%p6%       n_enB10.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~2%p6%       n_enB12.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~3%p6%       n_enB14.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENB1~4%p6%       n_enB18.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENB2~1%p6%       n_enB24.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~1%p6%       n_enBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~2%p6%       n_enBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~3%p6%       n_enBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~4%p6%       n_enBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~5%p6%       n_enBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENBI~6%p6%       n_enBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI0~1%p6%       n_enI08.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~1%p6%       n_enI10.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~2%p6%       n_enI12.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~3%p6%       n_enI14.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI1~4%p6%       n_enI18.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENI2~1%p6%       n_enI24.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR0~1%p6%       n_enR08.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~1%p6%       n_enR10.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~2%p6%       n_enR12.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~3%p6%       n_enR14.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR1~4%p6%       n_enR18.pcf%p7%
%1 %2 %p3% %p4% %p5% N_ENR2~1%p6%       n_enR24.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB0~1%p6%       ncenB08.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB1~1%p6%       ncenB10.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB1~2%p6%       ncenB12.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB1~3%p6%       ncenB14.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB1~4%p6%       ncenB18.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENB2~1%p6%       ncenB24.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~1%p6%       ncenBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~2%p6%       ncenBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~3%p6%       ncenBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~4%p6%       ncenBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~5%p6%       ncenBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENBI~6%p6%       ncenBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI0~1%p6%       ncenI08.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI1~1%p6%       ncenI10.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI1~2%p6%       ncenI12.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI1~3%p6%       ncenI14.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI1~4%p6%       ncenI18.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENI2~1%p6%       ncenI24.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR0~1%p6%       ncenR08.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR1~1%p6%       ncenR10.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR1~2%p6%       ncenR12.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR1~3%p6%       ncenR14.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR1~4%p6%       ncenR18.pcf%p7%
%1 %2 %p3% %p4% %p5% NCENR2~1%p6%       ncenR24.pcf%p7%
%1 %2 %p3% %p4% %p5% NCRET1~1%p6%       NCRET105.COM%p7%
%1 %2 %p3% %p4% %p5% NE1000~1%p6%       NE1000.COM%p7%
%1 %2 %p3% %p4% %p5% NE2000~1%p6%       NE2000.COM%p7%
%1 %2 %p3% %p4% %p5% NE2100~1%p6%       NE2100.COM%p7%
%1 %2 %p3% %p4% %p5% NE2COM~1%p6%       NE2.COM%p7%
%1 %2 %p3% %p4% %p5% NI5010~1%p6%       NI5010.COM%p7%
%1 %2 %p3% %p4% %p5% NI5210~1%p6%       NI5210.COM%p7%
%1 %2 %p3% %p4% %p5% NI6510~1%p6%       NI6510.COM%p7%
%1 %2 %p3% %p4% %p5% NI9210~1%p6%       NI9210.COM%p7%
%1 %2 %p3% %p4% %p5% NIL2PC~1%p6%       nil2.pcf%p7%
%1 %2 %p3% %p4% %p5% NTI16C~1%p6%       NTI16.COM%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~1%p6%       ODIPKT.COM%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~2%p6%       ODIPKT.DOC%p7%
%1 %2 %p3% %p4% %p5% ODIPKT~3%p6%       ODIPKT.TXT%p7%
%1 %2 %p3% %p4% %p5% OLCURS~1%p6%       olcursor.pcf%p7%
%1 %2 %p3% %p4% %p5% OLGL10~1%p6%       olgl10.pcf%p7%
%1 %2 %p3% %p4% %p5% OLGL12~1%p6%       olgl12.pcf%p7%
%1 %2 %p3% %p4% %p5% OLGL14~1%p6%       olgl14.pcf%p7%
%1 %2 %p3% %p4% %p5% OLGL19~1%p6%       olgl19.pcf%p7%
%1 %2 %p3% %p4% %p5% ORDERF~1%p6%       order.frm%p7%
%1 %2 %p3% %p4% %p5% PKTDRV~1%p6%       PKTDRV.EXE%p7%
%1 %2 %p3% %p4% %p5% PKTMUX~1%p6%       PKTMUX.DOC%p7%
%1 %2 %p3% %p4% %p5% PKTMUX~2%p6%       PKTMUX.EXE%p7%
%1 %2 %p3% %p4% %p5% PKTSTA~1%p6%       PKTSTATS.EXE%p7%
%1 %2 %p3% %p4% %p5% PPPDOC~1%p6%       PPP.DOC%p7%
%1 %2 %p3% %p4% %p5% PPPEXE~1%p6%       PPP.EXE%p7%
%1 %2 %p3% %p4% %p5% PRICIN~1%p6%       pricing.txt%p7%
%1 %2 %p3% %p4% %p5% RGBTXT~1%p6%       rgb.txt%p7%
%1 %2 %p3% %p4% %p5% ROMAN_~1%p6%       roman_m.pho%p7%
%1 %2 %p3% %p4% %p5% ROMANP~1%p6%       roman.pho%p7%
%1 %2 %p3% %p4% %p5% S_MB08~1%p6%       s_mb08.pcf%p7%
%1 %2 %p3% %p4% %p5% S_MB10~1%p6%       s_mb10.pcf%p7%
%1 %2 %p3% %p4% %p5% S_MB12~1%p6%       s_mb12.pcf%p7%
%1 %2 %p3% %p4% %p5% S_MB14~1%p6%       s_mb14.pcf%p7%
%1 %2 %p3% %p4% %p5% S_MB18~1%p6%       s_mb18.pcf%p7%
%1 %2 %p3% %p4% %p5% S_MB24~1%p6%       s_mb24.pcf%p7%
%1 %2 %p3% %p4% %p5% SLIPPE~1%p6%       SLIPPER.DOC%p7%
%1 %2 %p3% %p4% %p5% SLIPPE~2%p6%       SLIPPER.EXE%p7%
%1 %2 %p3% %p4% %p5% SMC_WD~1%p6%       SMC_WD.COM%p7%
%1 %2 %p3% %p4% %p5% SYMB08~1%p6%       symb08.pcf%p7%
%1 %2 %p3% %p4% %p5% SYMB10~1%p6%       symb10.pcf%p7%
%1 %2 %p3% %p4% %p5% SYMB12~1%p6%       symb12.pcf%p7%
%1 %2 %p3% %p4% %p5% SYMB14~1%p6%       symb14.pcf%p7%
%1 %2 %p3% %p4% %p5% SYMB18~1%p6%       symb18.pcf%p7%
%1 %2 %p3% %p4% %p5% SYMB24~1%p6%       symb24.pcf%p7%
%1 %2 %p3% %p4% %p5% T_CH14~1%p6%       t_ch14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_CHB1~1%p6%       t_chB14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB08~1%p6%       t_mB08.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB10~1%p6%       t_mB10.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB12~1%p6%       t_mB12.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB14~1%p6%       t_mB14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB18~1%p6%       t_mB18.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MB24~1%p6%       t_mB24.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI0~1%p6%       t_mBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~1%p6%       t_mBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~2%p6%       t_mBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~3%p6%       t_mBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI1~4%p6%       t_mBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MBI2~1%p6%       t_mBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI08~1%p6%       t_mI08.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI10~1%p6%       t_mI10.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI12~1%p6%       t_mI12.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI14~1%p6%       t_mI14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI18~1%p6%       t_mI18.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MI24~1%p6%       t_mI24.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR08~1%p6%       t_mR08.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR10~1%p6%       t_mR10.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR12~1%p6%       t_mR12.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR14~1%p6%       t_mR14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR18~1%p6%       t_mR18.pcf%p7%
%1 %2 %p3% %p4% %p5% T_MR24~1%p6%       t_mR24.pcf%p7%
%1 %2 %p3% %p4% %p5% T_RM14~1%p6%       t_rm14.pcf%p7%
%1 %2 %p3% %p4% %p5% T_RMB1~1%p6%       t_rmB14.pcf%p7%
%1 %2 %p3% %p4% %p5% TCENET~1%p6%       TCENET.COM%p7%
%1 %2 %p3% %p4% %p5% TECH14~1%p6%       tech14.pcf%p7%
%1 %2 %p3% %p4% %p5% TECHB1~1%p6%       techB14.pcf%p7%
%1 %2 %p3% %p4% %p5% TERM14~1%p6%       term14.pcf%p7%
%1 %2 %p3% %p4% %p5% TERMB1~1%p6%       termB14.pcf%p7%
%1 %2 %p3% %p4% %p5% TERMIN~1%p6%       TERMIN.COM%p7%
%1 %2 %p3% %p4% %p5% TIARAC~1%p6%       TIARA.COM%p7%
%1 %2 %p3% %p4% %p5% TIMB08~1%p6%       timB08.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMB10~1%p6%       timB10.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMB12~1%p6%       timB12.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMB14~1%p6%       timB14.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMB18~1%p6%       timB18.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMB24~1%p6%       timB24.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI0~1%p6%       timBI08.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~1%p6%       timBI10.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~2%p6%       timBI12.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~3%p6%       timBI14.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI1~4%p6%       timBI18.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMBI2~1%p6%       timBI24.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI08~1%p6%       timI08.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI10~1%p6%       timI10.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI12~1%p6%       timI12.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI14~1%p6%       timI14.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI18~1%p6%       timI18.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMI24~1%p6%       timI24.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR08~1%p6%       timR08.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR10~1%p6%       timR10.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR12~1%p6%       timR12.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR14~1%p6%       timR14.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR18~1%p6%       timR18.pcf%p7%
%1 %2 %p3% %p4% %p5% TIMR24~1%p6%       timR24.pcf%p7%
%1 %2 %p3% %p4% %p5% UBNICP~1%p6%       UBNICPC.COM%p7%
%1 %2 %p3% %p4% %p5% UBNICP~2%p6%       UBNICPS2.COM%p7%
%1 %2 %p3% %p4% %p5% UNZIPD~1%p6%       unzip.doc%p7%
%1 %2 %p3% %p4% %p5% UNZIPE~1%p6%       unzip.exe%p7%
%1 %2 %p3% %p4% %p5% USERRT~1%p6%       user.rtf%p7%
%1 %2 %p3% %p4% %p5% USERTX~1%p6%       user.txt%p7%
%1 %2 %p3% %p4% %p5% UTB___~1%p6%       UTB_____.pfa%p7%
%1 %2 %p3% %p4% %p5% UTBI__~1%p6%       UTBI____.pfa%p7%
%1 %2 %p3% %p4% %p5% UTI___~1%p6%       UTI_____.pfa%p7%
%1 %2 %p3% %p4% %p5% UTRG__~1%p6%       UTRG____.pfa%p7%
%1 %2 %p3% %p4% %p5% UVCONF~1%p6%       uvconfig.exe%p7%
%1 %2 %p3% %p4% %p5% VAXMAT~1%p6%       VAXMATE.COM%p7%
%1 %2 %p3% %p4% %p5% WINPKT~1%p6%       WINPKT.ASM%p7%
%1 %2 %p3% %p4% %p5% WINPKT~2%p6%       WINPKT.COM%p7%
%1 %2 %p3% %p4% %p5% X_8514~1%p6%       x_8514.exe%p7%
%1 %2 %p3% %p4% %p5% X_AGXE~1%p6%       x_agx.exe%p7%
%1 %2 %p3% %p4% %p5% X_MACH~1%p6%       x_mach32.exe%p7%
%1 %2 %p3% %p4% %p5% X_MACH~2%p6%       x_mach8.exe%p7%
%1 %2 %p3% %p4% %p5% X_MONO~1%p6%       x_mono.exe%p7%
%1 %2 %p3% %p4% %p5% X_S3EX~1%p6%       x_s3.exe%p7%
%1 %2 %p3% %p4% %p5% X_SVGA~1%p6%       x_svga.exe%p7%
%1 %2 %p3% %p4% %p5% XAPPEA~1%p6%       xappeal.txt%p7%
%1 %2 %p3% %p4% %p5% XAPPLO~1%p6%       xapplogo.pcx%p7%
%1 %2 %p3% %p4% %p5% XINSTA~1%p6%       xinstall.cfg%p7%
%1 %2 %p3% %p4% %p5% XINSTA~2%p6%       xinstall.exe%p7%
%1 %2 %p3% %p4% %p5% XINSTA~3%p6%       xinstall.hlp%p7%
%1 %2 %p3% %p4% %p5% XINSTA~4%p6%       xinstall.rtf%p7%
%1 %2 %p3% %p4% %p5% XINSTA~5%p6%       xinstall.txt%p7%
%1 %2 %p3% %p4% %p5% XTREME~1%p6%       xtreme.pcx%p7%
%1 %2 %p3% %p4% %p5% ZNOTEC~1%p6%       ZNOTE.COM%p7%

:finish
cd %dir0%
if "%8"=="-" goto end
if "%8"=="" goto end
dir /s/on %dir0%*.%8 >>0_%8.dir
call %0 %8 %9
:end
