@echo off
 rem For DOS3.3 one may change 'call' into 'command/c' or use the external CALL
 rem program (by me) and remove the '@' before the 'echo off'.
ctty con
if "%1"==".path" goto Path
if "%2"==".NotFound" goto NoPath
if "%1"==".getfnx2" goto GETFNX_2
 rem delete currently existing scratch file _GETFNX1.BAT to be generated:
if exist _GETFNX1.BAT del _GETFNX1.BAT
 rem delete currently existing batch file GETFNX2.BAT to be generated and called by application:
if exist GETFNX2.BAT del GETFNX2.BAT
if "%1"=="" goto Help
if "%1"=="?" goto Help
if "%1"=="/?" goto Help
if "%1"=="-?" goto Help
if "%1"=="/h" goto Help
if "%1"=="/H" goto Help
if not exist %1 goto NotExist
if not "%2"=="" goto GETFNX_1
  rem %2 is the location or specification of the auxiliary file $GETFNX$.AUX

:Determine
 rem Determination of location (and name) of auxiliary file $GETFNX$.AUX in/as:
 rem a. the second parameter when calling GETFNX (not checked here)
 rem    1. the full _path_ only, incl. trailing '\' (e.g. 'GETFNX filename.ext C:\UTIL\') or
 rem    2. the full _file_specification_ (e.g. 'GETFNX filename.ext C:\UTIL\AUX-FILE.$$$')
 rem b. the environment variable %GETFNX%
 rem    1. the full _path_ only, incl. trailing '\' ('SET GETFNX=C:\UTIL\') or
 rem    2. the full _file_specification_ ('SET GETFNX=C:\UTIL\AUX-FILE.$$$')
 rem c. the ROOT directory of C: (C:\) (or automatically any APPENDed path) or
 rem d. the ROOT directory of the CURRENT drive (\) or
 rem e. the CURRENT directory (.\) or
 rem f. the PARENT directory of the current one (..\) or
 rem g. the SAME directory where GETFNX.BAT is residing:
 rem    if EXPLICITELY specified when starting GETFNX (DOS 3.x&up only).
 rem    (NOT if GETFNX.BAT can only be found via the PATH!) or
 rem h. the DOS PATH variable (this may take quite a while)
 rem If the environment variable has not been set: try other location(s)
if "%GETFNX%"=="" goto NoEnvVar
 rem If $GETFNX$.AUX found as file specified by %GETFNX% then restart this batch
 rem file (GETFNX.BAT as %0) with _full_path_&_file_name_ as the second parameter
if exist %GETFNX% %0 %1 %GETFNX%
 rem If $GETFNX$.AUX found in path specified by %GETFNX% then restart this batch
 rem file (GETFNX.BAT as %0) with _full_path_&_file_name_ as the second parameter
if exist %GETFNX%$GETFNX$.AUX %0 %1 %GETFNX%$GETFNX$.AUX
 rem If the auxiliary file thus can not be found: try other location(s) below:

:NoEnvVar
 rem Check the presence of $GETFNX$.AUX in (and specify _full_path_&_file_name_
 rem if found):
 rem (the root of C:)
if exist    C:\$GETFNX$.AUX %0 %1    C:\$GETFNX$.AUX
 rem (the root of the current drive)
if exist      \$GETFNX$.AUX %0 %1      \$GETFNX$.AUX
 rem (the current directory)
if exist     .\$GETFNX$.AUX %0 %1     .\$GETFNX$.AUX
 rem (the parent directory)
if exist    ..\$GETFNX$.AUX %0 %1    ..\$GETFNX$.AUX
 rem (the explicitely specified directory)
if exist %0\..\$GETFNX$.AUX %0 %1 %0\..\$GETFNX$.AUX

 rem ---DOSPATH---
 rem Within the subroutine :Path to be called now by subsequent 'shift'ing
 rem the call name for GETFNX (%0) as well as the first argument (%1),
 rem specifying the filename.ext to be split, gets lost. To solve this
 rem problem a temporary batch file $GETFNX$.BAT is created initially (in
 rem the current directory) that contains this information hardcoded and
 rem calls GETFNX (or whatever it is renamed) with the necessary parameter:
echo echo off>$GETFNX$.BAT
 rem If no write of this auxiliary file is possible then cancel finally:
if not exist $GETFNX$.BAT goto NoPath
echo %0 %1 %%1>>$GETFNX$.BAT
 rem At the end (or somewhere suited) remove the temporary file $GETFNX$.BAT .
 rem Depending on the (path and) name (length) for GETFNX the path environment
 rem variable will be used up to a certain number of characters, maximally
 rem around 100.
%0 .path %path%

:NoPath
echo *** Necessary auxilary file $GETFNX$.AUX could not be found - abort!
echo.
echo     Specify environment variable GETFNX to point to the path where
echo     $GETFNX$.AUX resides (either from the DOS prompt or in AUTOEXEC.BAT).
echo     E.g. SET GETFNX=C:\UTIL\             (terminated with backslash).
echo     Or specify full path and file name to the eventual alternate auxiliary
echo     file for $GETFNX$.AUX (e.g. SET GETFNX=C:\UTIL\AUX-FILE.$$$).
echo.
echo     Or specify path (terminated with '\') to or full file specification
echo     for $GETFNX$.AUX as the second parameter for %0
goto end

:GETFNX_1
 rem If %2 is _full_path_&_file_name_ of (alternate) $GETFNX$.AUX then continue
if exist %2 goto AuxPathChecked
 rem If %2 is path only to explicit $GETFNX$.AUX then restart GETFNX (%0) with
 rem _full_path_&_file_name_ as the first parameter
if exist %2$GETFNX$.AUX %0 %1 %2$GETFNX$.AUX
 rem %2 has been specified by the user, but $GETFNX$.AUX could not be found:
echo *** Auxiliary path[file] %2 is incorrect, file $GETFNX$.AUX not found.
echo     Now trying to find $GETFNX$.AUX using path (or full file specification):
echo     1. from environment variable GETFNX (path or full file specification)
echo     2. the root directory of C: (C:\) (or automatically any APPENDed path)
echo     3. the root of the current drive (\)
echo     4. the current directory (.\)
echo     5. the parent directory (..\)
echo     6. the same directory as GETFNX.BAT if GETFNX has been called by path
echo     7. from the DOS PATH variable (this may take quite a while)
echo.
goto Determine

:AuxPathChecked
echo --- Extract filename and extension from %1 ---
echo echo off>_getfnx1.bat
if not exist _getfnx1.bat goto Impossible
ctty nul
copy _getfnx1.bat+%2 /a _getfnx1.bat /b
 rem Next lines twice with slight difference in order to "dir" a file name without an extension correctly.
if not exist %1. goto HasExt
dir/w %1.|find "	">>_getfnx1.bat
goto NoExt
:HasExt
dir/w %1 |find "	">>_getfnx1.bat
:NoExt
call _getfnx1 %0 .getfnx2 %0
del _GETFNX1.BAT
ctty con
echo --- Extracted parts written to GETFNX2.BAT for further use ---
goto end

:NotExist
echo Specified file %1 does not exist. ABORT.
goto end

:Impossible
echo *** Temporary batch file for further processing could not be created. Abort!
goto end

:Help
echo GETFNX File name - extension splitter by Jim Groeneveld, vs. 1.0, 29/1-93.
echo.
echo Syntax: GETFNX [d:][\][path\]filename.ext [[d:][\][path\][auxfilespec]]
echo where d:           = drive: (of concerning file);
echo       path         = absolute or relative path ([\]sub1\sub2.....\);
echo       filename.ext = file specification to split into name and extension;
echo       auxfilespec  = the eventual alt. auxiliary file name for $GETFNX$.AUX;
echo.
echo Output: batch file GETFNX2.BAT with contents:
echo         echo off
echo         %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 filename extension
echo                                  (extension may be 'none')
echo to be called by application using:
echo         call GETFNX2 ownbatch [par1..par7] fn ext
echo User's batch file 'ownbatch.bat' may do anything with these parameters.
:end
goto exit

:GETFNX_2
shift
shift
if "%2"=="" %0 .getfnx2 %0 %1 none
echo echo off>GETFNX2.BAT
echo %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %1 %2>>GETFNX2.BAT
goto exit

:Path          SUBROUTINE PATH
shift
:ChkPath
 rem Check each path entry for the presence of $GETFNX$.AUX:
if "%1"=="" goto NotFound

 rem Check root specifications (ending with a trailing \) firstly:             *
for %%a in (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z) do if "%%a:\"=="%1" goto RootPath *
for %%a in (a b c d e f g h i j k l m n o p q r s t u v w x y z) do if "%%a:\"=="%1" goto RootPath *
 rem Path spec is not a root                                                   *
 rem If $RETURN.AUX has been found then restart with location as parameter
if exist %1\$GETFNX$.AUX $GETFNX$ %1\$GETFNX$.AUX
goto NextPath                                                                  *

:RootPath                                                                      *
 rem If $RETURN.AUX has been found then restart with location as parameter     *
if exist %1$GETFNX$.AUX $GETFNX$ %1$GETFNX$.AUX
 rem goto NextPath                                                             *
:NextPath                                                                      *
 rem Check next path entry:
shift
goto ChkPath

:NotFound
 rem path or auxiliary file not found, indicate
$GETFNX$ .NotFound
 rem Lines marked with * may eventually be deleted all at once resulting in a
 rem slightly changed check algorithm: 1. _with_ '\' and 2. _without_ '\'.
 rem These lines should work, however, with the * included.
 rem goto exit

:exit
 rem delete auxiliary file $GETFNX$.BAT if present
if exist $GETFNX$.BAT del $GETFNX$.BAT
