

                                                             QAZ v3.40a
                                       by Robert Rothenburg Walking-Owl
                             Copyright (c)1993,1994 All Rights Reserved


                                                                      A 
                                                              No-Frills
                                                           User's Guide 
                                                             and Manual



                                    "No archiver too obscure... almost"




(1) License and Distribution
-----------------------------------------------------------------------
Individuals and institutions have the right to use this software freely
so long as it is neither modified nor distributed for profit.

If you want to include QAZ as part of a shareware or commercial package,
please contact me at the postal address below.

(2) Contacting the Author
-----------------------------------------------------------------------
Although no registration is required (as the author is unsure of a per-
manent address for the next couple of years) voluntary donations are
accepted.  Preferrably a post-card or e-mail if nothing else.

The author (myself) can be reached at:

(electronic)    robert.rothenburg@asb.com
                rrothenb.ic.sunysb.edu

(post)          Robert Rothenburg Walking-Owl
                P.O. Box 1327
                South Stony Brook, NY 11790 USA

If you have any suggestions or bug-reports, please let me know.

If you have any questions about the utilities supported by QAZ (such
as where to get copies?, or what is this utility?) please ask around
on various e-networks or local BBS systems first.

(3) Legal Miscellanea
-----------------------------------------------------------------------
Being free, the author makes no guarantees or warrantees as to the use,
misuse or abuse of this software.  The author shall not be held respon-
sible for damage to (or improvement of) data, time, finance, ideologies
et cetera in association with the use of this program (QAZ).

The author also makes no gurantees that QAZ will correctly identify and
handle everything (it's impossible).  However, much effort and time has
been put into making QAZ as complete and powerful as possible.

Users of this utility take all responsibility for the licensing requir-
ements of associated software(s) used in conjunction with QAZ.

The various archive formats and utilities, as well as operating systems
and other softwares are the respected trademarks or copyrights of the
various people and-or corporations that own whatever rights there are to
their respective products, etc.

(4) What is QAZ?
-----------------------------------------------------------------------
"QAZ" stands for Q-A-Z, the leftmost three keys on a standard American
QWERTY-style keyboard (I couldn't think up a better name for it at the
time).

QAZ is an "almost universal archive viewer".  It will recognize, if not
view, most compressed- or archive(r)-file formats, specifically in the
DOS platform, although other types (from the Amiga, Macintosh and Unix)
are recognized as well.  (See the file WHICHARC.TXT for more details.)

QAZ is also capable of searching a drive for archives which contain a
specified set of files, or of returning exit codes identifying the file
type or attributes of the file (such as whether an archive contains AV
information or password-protected files) which can be used by other
software.

The output of QAZ is to standard-output, which means it can be used as
an online BBS viewing utility. The format of the listing is very cust-
omizable to suit users' individual tastes.

Note that the default date and time format settings should conform to
the DOS defaults on users' native systems, unless reconfigured by the
user.

(5) General Usage:
-----------------------------------------------------------------------
If you run QAZ with no options (or with the -H option), you should get 
the on-line help screen, which gives the general syntax of the options
along with a few examples.

QAZ can be run in "vanilla" mode with no options: QAZ filename (as an 
example, QAZ FOOBAR.LZH.  QAZ will also accept wildcards, and given the
options, can even span an entire disk searching for archives which con-
tain specified files (by names, dates or sizes). QAZ can even apply the
search-specs to files not in archives.

Acceptable wildcards are the standard DOS '*' and '?', as well as the un-
documented variants 'name' (with no extention = 'name.*') or '.ext' mean-
ing '*.ext'. Also acceptable are 'not'-specs (^filespec = all files except 
the given filespec) or sets (ie., '[abc]' or '[0-9,abcd]').

If you need to use a filename that begins with a control-character such
as '-', '`' or '^', or filenames that contain spaces (usually for non-DOS
archive formats) you may surround the filename with quotes, like so:
"-DASHFIL.FOO"

(6) Meaning of the Options:
-----------------------------------------------------------------------
Following is a "quick-and-dirty" summary of the options.  Since QAZ does
not write to any files (unless redirected), it's safe to play around with
them to get a feel for the program and even discover a few funky things
you can do wuth it.

The option letters can be preceed by either a dash ('-') or a backslash
('/'). Older versions of QAZ (v2) used the DOS SwitchChar, which was usu-
ally the backslash.

(7) Listing in ANSI Color                       -A[+|-]{ADILONR}={code}
-----------------------------------------------------------------------
Enables (-a+) or disables (-a-) ANSI codes for color (for in online/BBS 
usage). Requires a suitable ANSI-driver (like ANSI.SYS) to be installed
for the console or the device the output is being piped to.

Since QAZ v3.30a, ANSI colors can now be redefined:

  QAZ -A+                  Enables and resets colors to their defaults.
                    
  QAZ -Ax={code}           Defines field 'x' to 'code', where 'x' can be 
                           any of the following codes (defaults shown):

  QAZ -AL=1;40;37          Cutline to white
      -AN=1;40;33          Name to yellow
      -AD=1;40;32          Date/time to green
      -AR=1;40;35          Ratio to violet
      -AA=1;40;36          Archived to cyan
      -AO=1;40;31          Original to bright red
      -AI=1;40;34          Info to bright blue
  
The fields generally coincide with the all of the -V fields, except the
-VC comment, of course. Consult your DOS manual for more information on 
the ANSI escape codes.  QAZ requires only the numbers and no other ANSI 
commands.

(8) Bare Listing                                                -B[+|-]
-----------------------------------------------------------------------
Enables the bare listing format, similar to the /B switch in DOS DIR.
It can be used to generate picklists along with the -MQ option.

(9) Customize Miscellaneia (Character Codes)            -C[DLMTW]{code}
-----------------------------------------------------------------------
Changes the ASCII code for the cutline (-CL) or mark (-CM) characters: 
ie., use -CL61 for '=' as the cut-line (the lines separating the file-
listings from the field header and totals).  

The "code" may be a a decimal, hexidecimal, octal or binary number.
The following examples all set the mark character to an asterisk:

  QAZ -CM42                Sets the mark char to '*' (default is 0xfe).
      -CM$2a               (Same as above, in hexidecimal.)
      -CM0x2a              (Same as above, in hexidecimal.)
      -CM052               (Same as above, in octal.)
      -CM0b10000000010     (Same as above, in binary.)

  QAZ -CD{code}            Sets the date-separation character, which       
                           overrides the system's native country code
                           settings.  The -D option will use this as
                           the date-separator also.
      
      -CT{code}            Sets the time-separator character. Same as
                           -CD in that the country code settings and
                           what the -D and -DH options use us changed.
                   
      -CW{length}          Sets the length of the cut-line (same as
                           the -WL{length} option.

(10) Searching files by Date and-or Time             -D[H]{from}[,]{to}
-----------------------------------------------------------------------
Lists files between specified dates. The date is formatted based on -DF 
or native country-code settings of your machine, ie, MM-DD-YY, DD-MM-YY 
or YY-MM-DD, corresponding to the same format QAZ will output a listing 
of the archive as (also the same format generated by DOS DATE).

Giving a date (and-or time) with no comma tells QAZ to list only files
with that date.  A date before the comma gives an earliest date, and
after the comma a lestest date.  In other words,

  QAZ -D{date}             Views all files in an archive with given date.
      -D{date},            Views all files dated given date and after.
      -D,{date}            Views all files dated up to given date.
      -D{from},{to}        Views all files dated between given dates.

      -D-                  Disables date filtering.
      -D+                  Views all files with today's date.

Times may also be appended to a date: -D7-4-91;12:37. The times may be
in 24-hour format or 12-hour with an 'a' or 'p' (as in 12:37p) after-
wards to indicate morning or evening.

Using the -DH option, you can set a separate filter for times (and not 
dates).

Multiple date-time filters are allowed.  Thus,

  QAZ FOO.LIB -D,5-1-92 -D3-23-93,4-27-93  
  
views all files in FOO.LIB dated before May 2, 1992 and files between 
March 23 and April 27, 1993 (using American-style date formats).

You may also use "verbose" month names with the -D filter:

  QAZ FOO.LIB -D,May-1-94

Note that QAZ expects European- and Japanese-style dates in the proper
format (same as numerical dates).

You may also use wildcard days-of-the-month: if you want to list all                  
files during January, 1992, you can use the following:

  QAZ FOO.LIB -D1-1-92,1-3292                           or,
  QAZ FOO.LIB -D1-?-92
                  
Reminder: the -D and -DH options expect the date and time formatted as
          it would appear in the output.  If the date is formatted to 
          DD/MM/YY and you use an option -Dmm-dd-yy then QAZ will find
          no files matching the given specs.

(11) Setting the Date Format                               -DF{DNSV012}
-----------------------------------------------------------------------
This option sets the format of the date shown by QAZ, as well as what
the -D filter expects as input (the default should resemble the native
country-code settings).

  QAZ -DFD                 Resets to the default settings.
      -DFN                 Shows the (English) name of the day-of-the-
                           week alongside the date.
      -DFV                 Enables "verbose" dates (the English name of
                           the month, rather than the numeral).
      -DFS                 Uses short years (YY instead of YYYY).
      -DF0                 Uses American-style dates (MM-DD-YYYY).
      -DF1                 Uses European-style dates (DD-MM-YYYY).
      -DF2                 Uses Japanese-style dates (YYYY-MM-DD).

Note that options can be combined: Using -DFS2 tells QAZ to use short,
Japanese-style dates. Use the -CD option to set the date-separator.

(12) Setting the Time Format                                  -DT[LMNS]
-----------------------------------------------------------------------
Similar to the -DF option, but sets the format of the time of day.

      -DTL                 Sets to long (HH:MM:SS) times (default).
      -DTM                 Sets to military (24-hour) time.
      -DTN                 Sets to natural (12-hour) time.
      -DTS                 Sets to short (HH:MM) times.

Note: -DTN will only enable 12-hour times disabled by -DF0, -DF1 or                  
      -DF2 switches.  -DTM will re-enable 23-hour times disabled by
      the -DTN switch.
                   
(13) Miscellaneous Formatting                               -F{BCFIPU-}
-----------------------------------------------------------------------
The option performs some miscellaneous formatting functions on the list.

  QAZ -F-                  Resets to defaults.
      -FC                  Clips (truncates) filenames.
      -FF                  Uses a two-line display of the archive file-
                           name (with full path) and archiver-type.
      -FI                  Identify directories and volume-labels in
                           ratio field.  Directories will be shown
                           without using -FP, if they are saved as
                           file entries in the archive.
      -FU                  Uses (U)Nix-style path and filenames, with
                           spaces changed to '.'.
      -FP                  Shows filename as Path+File.
      -FB                  Shows the path on a separate line.

Note: Truncated (with -FC) files will be marked unless the -MN (supress
notices) switch is used.

(14) Case Settings                                            -L[LSU+-]
-----------------------------------------------------------------------
Sets the case of filenames (and the output of the listings in general).

      -LL                  For lowercase filenames (same as -L+). 
      -LS                  For "case-sensitive" filenames: case is
                           shown as it appears in archive (default).
      -LU                  For uppercase filenames.

Note: when the case is changed, the file will be marked in the display
unless the -MN (supress notices) switch is used.

(15) Miscellaneous Functions                           -M{CDFINQSX03+-}
-----------------------------------------------------------------------
The operation mode and miscellaneous functions can be set with these
switches.

  QAZ -MD                  Restores defaults (same as -M-).
      -M0                  Tells QAZ *not* to use 32-bit instructions,
                           if run on an 80386/486+ processor.
      -MC                  Reneables CPU identification (use 32-bit
                           instructions if on the right processor).
      -M3                  Force use of 32-bit instructions.

      -MF                  List forks in some Macintosh archives as
                           separate files with .data and .rsrc extentions.
      -MI                  Identify archive type only: don't list.
      -MN                  Supress notices/messages.             
      -MQ                  Quiet mode (no headers).
      -MS                  List only if selected filespecs are in archive             
                           (specs by name, -D, -DH, -I or -S filters).
      -MX                  For external "debug" mode.  The listing is in             
                           a set hexidecial output which external software
                           can easily read. When combined with the -RA and
                           -RA switches, allows for shells and catalogging
                           utilities to use QAZ powerfully.

Note: the -MT optio was removed from QAZ in v3.30.  To view a BinHex, AR7
or UU/XX-Encoded file, decode it into binary first and then use QAZ to
view it.

(16) Ordering (Sorting) the Listing                     -O[-]{ADNOPRST}
-----------------------------------------------------------------------
Sets the sorting-order of the file listing.

  QAZ -O-                  Disables sorting (natural order, default).
      -OO or -OS           Sort by original file size.
      -OA                  Sort by archived file size.
      -OD                  Sort by date-time stamp.
      -OT                  Sort by time-of-day only (not date).             
      -ON                  Sort by filename.
      -OR                  Sort by compression ratio.
      -OP                  Sort by pathname.
                   
Inserting a '-' before the field tells QAZ to reverse the sort order                   
(ie, QAZ FOO.LIB -O-N to sort names in descending order).

The -OE (sort by file extention) option has been removed in QAZ v3.40a
since it worked awkawrdly for non-8.3 filenames.
                   
(17) Load Picklists                                   -P[APV]{filename}
-----------------------------------------------------------------------
Tells QAZ to use various types of picklists.

  QAZ -PAfilename          Loads a list of archiver specs. Equivalent
                           to using QAZ @filename.
      -PPfilename          Loads a list of specs to use for files
                           within an archive.  Equivalent to using
                           QAZ archive @filename.
      -PVfilename          Loads a "void-list" of files that QAZ won't
                           touch (in the case of fluke files which may
                           cause QAZ to crash).

Note that the -PVfilename option returns a flag when used with the -RI
option if a file matches the specs on that list: hence, -PV can also be
used to flag the presence of certain files (such as those that might be
listed in "The Hack Report" for some BBS auto-scanning systems).


(18) Loading Options                                        -POfilename
-----------------------------------------------------------------------
Works similar to the picklist (-P) options, except that a file contain-
ing preferred/default options rather than filespecs is loaded.  This is
useful for setting many options which will not fit on a command line
with the QAZCMD variable: it is recommended that you set the QAZCMD var
to -POfilename (ie, -POQAZ.SYS) instead.

The options can be separated by spaces or lines.  Comments are also  
allowed. (See the included QAZ.SYS file for an example.)

Note that filespecs cannot be included in option files: you must use
the appropriate @file, -PA, -PV or -PP picklist options.

(19) Return Code Options                                       -R[ACIV]
-----------------------------------------------------------------------
Tells QAZ to return an exit code of information about the file examined.

  QAZ -R-                  Disables informative return codes (default).
                           No exit code unless file is damaged or abort
                           from -EA option.
      -RA                  Returns a code of "flags" as to whether an
                           archive contained authenticity information,
                           passworded files, is self-extracting, etc.
      -RI                  Returns information identifying the archive
                           type so batch files or external utilities
                           can use QAZ.
      -RC                  Returns a count of the number of files (up
                           to 255) in the archive.
      -RV                  Returns the "version" of the archiver format.
                           
See the later sections of this document for more information on exit/
return codes from these options.

(20) Searching Files by Size                        -S[A]{low}[,]{high}
-----------------------------------------------------------------------
Filter files by size: similar in format to the -D filter, the -S filter
works by original file sizes.  The -SA filter works by archived file
sizes.
                   
  QAZ -S1,                 To view files >= 1 byte.
      -S10k,10k            To view files between 10k- and 16k-bytes.
      -S10240,16384        Same as above.
      -S17347              View files only of 17347 bytes.
      -S,1m                View files under 1-MByte (1024 k-bytes).
      -S,70384             To view files <= 70384 bytes.

Multiple size-ranges can be set in QAZ v3.30a and later. To list all files 
between 10k and 16k or 20k and 32k, use:

  QAZ FOO.LIB -S10k,16k -S20k,32k

The -SA (filter by archived file sizes) works exactly as the -S option.

The -S and -SA options can also accept binary, octal and hexidecimal 
numbers in the following forms:

  $1000                    4096 in hexidecimal
  0x1000                   Same as above
  0b1000                   16 in binary
  01000                    128 in octal [*]

[*] Note: a number preceeded by a '0' indicates to QAZ that it is an 
    octal (base-8) number.  (The exception is with the -D option.)

(21) Set the format of the Ratio                               -SR[0-3]
-----------------------------------------------------------------------
Set the format of the ratios (if viewed).
                   
  QAZ -SR0                 Default (bytes-per-byte ratio).
      -SR1                 for ZIP-style percent compressed.
      -SR2                 for LHARC-style percent of original.
      -SR3                 for bits-per-byte ratio.

(22) Viewing the Directory Tree                          -T[PFD]{depth}
-----------------------------------------------------------------------
View archive by directory tree structure (similar to the TREE command
in DOS).

  QAZ -T or -TP            To view directories.
      -TF                  To view all files and directories.
      -TDx                 To view depth down to x levels (ie, -TD2).

(23) Setting Search Options                    -U{ABDERSTVX} -UI{depth}
-----------------------------------------------------------------------
Sets miscellaneous search modes.

  QAZ -U-                  Default (no recursive searching).
      -UA                  Assume the first filespec is a data-file,
                           not an archive file to search.
      -UB                  Beep when done.
      -US                  Use predefined search specs for common archive
                           extentions.
      -UE                  Use search specs in QAZSPEC variable.
      -UR                  Recurse in subdirectories.
      -UD                  Recurse in all directories of drives C-Z.
      -UD[x-y]             Recurse in all directories of drives x-y.
      -UV                  Verbose search: displays name of directory
                           being searched.
      -UT                  Display approximate search time when done.
      -UX                  Search for files outside (eXternal to) of
                           archives as well.
                   
To search a disk drive for archives which contain a file, use:

  QAZ drive\ -URSV -MSI filespec

The -UD option was added in QAZ v3.33a to recursively search every disk 
drive from C: to Z:.  If a drive is not ready, QAZ will skip it and try 
to search the next one (The -UR switch need not be added with -UD):

  QAZ -UDSAV -MSI filespec

If you would like to change the search range of the -UD option to B: 
through G:, use the following:

  QAZ -UD[B-G]SAV -MSI filespec
                   
Since QAZ no longer requires the archive filespec to be the first argument 
on the command line, the -UA option will tell QAZ to assume that the first 
filespec is a spec to search for, not to search in (if the -UA option occurs
before the first filespec).

QAZ v3.40a has the limited ability to recursively list archives that are 
stored (uncompressed) inside of other archives, using the -UI option to 
define the internal recursion level (default=0).  For example,

  QAZ FOOBAR.LIB -UI1 -MS

Note that this option only works for some archive formats at the time.
It is experimental and may change or be removed in future versions.

(24) Defining the View                                  -V{ACDHINOPRST}
-----------------------------------------------------------------------
Sets the "fields" to view on the archive, or enables viewing of archive
comments.

  QAZ FOO.LIB -VC          Tells QAZ to show the main archive comment,
                           if the comment is not compressed (as with
                           some formats like HPack, SQZ, etc.).

The -V option can also tell QAZ which "fields" to show in a regular
listing.  The default field is -VO-10A-11R_DT_N, which translates to
(from left to right) Original-size, Archived size, Ratio, Date, Time
and Filename.  The numbers indicate the field width, and the under-
scores tell QAZ to insert a space.

Negative field-widths (-nn) tell QAZ to right-justify the field.
Positive widths (+nn) tell QAZ to left-justify it.  Note that the
width *must* be a two-digit number.

An alternate might be -VN+24O+10A+10_DT

The codes are roughly equivalent to the fields used by the -A and -O
options:

  N                        FileName
  P                        File Path (if -FP option is not used).
  O                        Original Size
  A                        Archived Size
  R                        Ratio
  D                        Date
  T                        Time
  S                        CRC or CheckSum.
  I                        File attributes/Information.
  H                        Host Operating-System (if known/defined).

When fields are shown blank, it is usually because no information is 
defined for that field in the archive, (though in some cases it is 
because no documented information is known).

(25) Wide Listings                                              -W[+|-]
-----------------------------------------------------------------------
For a "wide" listing, of filenames only.  Normally five names per line,
unless filenames are longer, in which case the number per line will be
adjusted automatically.

(26) Line Width                                               -WL{code}
-----------------------------------------------------------------------
See the -CW option.

(27) Time Zone                                        -Z[+|-]{GMT-hour}
-----------------------------------------------------------------------
By default, QAZ assumes the time-zone is set in the TZ variable.  You
can manually change what QAZ assumes with this option, however.

  QAZ -Z+                  Use what's defined in TZ variable (default).
      -Z-                  Disable time-zone adjustments (use GMT).
      -Z5                  Sets time-zone to GMT-5 (EST).
      -Z8                  Sets time-zone to GMT-8 (PST)
      -Z-1                 Sets time-zone to GMT+1 (CET).

Useful for Unix or Mac formats which set the time relative to GMT.

(28) Attribute Filtering                                -I{^ADHPRSTVWX}
-----------------------------------------------------------------------
Lists only files which match (somewhat) the defined attributes. Pre-
ceeding an attribute with a carat ('^') tells QAZ *not* to list files
with that attribute set.

  A                        Archive, backup bit                   
  D                        Directory
  H                        Hidden
  P                        Password protected
  R                        File has read-access (*not Read-Only!)
  W                        File has write-access
  S                        File is a System file
  V                        Volume label
  X                        File has eXec attribute (Unix) or is an 
                           APPL (application--Mac).
  T                        File marked as "text" in archive.
  C                        File marked as a "comment"

Multiple attributes are allowable: ie, -IAHRW^D^V.  The default is to 
list all attributes.

(29) Execute DOS Command if File is Found             -E[AV-] "command"
-----------------------------------------------------------------------
This function tells QAZ to execute a DOS command if a file is found (ie
it matches the given search specs).  QAZ, if the memory is needed, will
(or should) swap to EMS, XMS or disk.

If an error occurs, QAZ will display a small error message.

  QAZ -E-                  Disables execution of external commands.
  QAZ -EA "command"        Aborts after command is executed, ends search.
  QAZ -EV "command"        Displays the command being executed.

Suppose you want to search your hard drives for an archive containing
the file LOST.TXT, and have QAZ copy it to the current directory:

  QAZ -UDAX -MSI -E "COPY !!" LOST.TXT

Note that the "!!" is a macro, signifying the name of the file. If the
file is found, or if an archive containing the file is found, they will
be copied to the current directory.

Note: a "bug" is that if QAZ copies the file to the current directory,
      and then continues searching and later finds the copied file in 
      the current directory, it will still run the given command: hence 
      the reason for the -EA option.

Or, if you prefer, you can have QAZ load the command interpreter when
it finds a file:

  QAZ -UR -MSI -E "COMMAND" \*.* FOO.BAR

In the above case, QAZ searches the whole of the current drive for
archives which contain the file FOO.BAR.  When found, QAZ shells to
DOS.  (When done, you would type EXIT to return to QAZ.)

You could also use the -E option to create a list of archives contain-
ing a specified file.  The example below generates a list of archives
with the file "README.*":

  QAZ -UDA -MSIQ -E "ECHO !! >>FOUND.LST" README.*

(30) Picklists                                                @filename
-----------------------------------------------------------------------
QAZ will read the file as a list of filespecs to use. If it is the first 
argument, QAZ will assume it is a list of archiver-specs. If another 
argument, QAZ will assume it is a list of specs for within the file.

Examples,

  qaz @ARCHIVES.LST
  qaz c:\ @SEARCH.LST -MSNI -UBRSV

(31) Setting the Default Options
-----------------------------------------------------------------------
Environment variable of default options. Use,

  SET QAZCMD=[options]

ie., 

  SET QAZCMD=-LS -FFCB -DFS'
  SET QAZCMD=/POQAZ.SYS

(32) Setting Extra Archive Specifications
-----------------------------------------------------------------------
Specs for use with -ue option. ie.,

  SET QAZSPEC=*.SDN *.[7S]PL

Useful for obscure filespecs not included with the -US option.

In QAZ v3.33a, you can also define secondary filespecs from the command 
line by preceeding it with a backwards single-quote. Note a restriction 
is that the spec have the same path as the primary filespec. 

For example, to examine all ZIP and ARJ files in the current directory, 
use:

  QAZ *.ZIP `*.ARJ

Note also that `@PICK.LST is equivalent to -paPICK.LST

(33) Default QAZSPECs with the -US Option
-----------------------------------------------------------------------

*.??Z      Unix Compress/GZip     *.AR[CJK]   ARC/PKARC/PKPAK/ARJ
*.CP[TZ]   CompactPro/CPShrink    *.DWC       DWC
*.EXE      DOS Self-Extractors    *.GZ        GZip
*.HA       HA                     *.H[AY]P    Hamarsoft HAP/Hyper
*.[HZ]PK   HPack or Zi-Lite       *.ICE       ReeveSoft Freeze/LHIce
*.LHA      LHArc (Amiga)          *.[PS]IT    PackIt/StuffIt
*.L[AB]R   Novosielski Libraries  *.LI[BFM]   Codec/Knowledge Dynamics/Limit
*.LZ[HS]   LHArc/LArc             *.[CM]D     MDCD
*.PAK      PAK                    *.SEA       Mac Self-Extracting Archives
*.SHK      ShrinkIt/NuFX          *.SQZ       Squeeze-It
*.[RST]AR  RAR/SAR/TAR            *.[MVYZ]    Moof/Voof/Yabba/Compress/GZip
*.ZIP      Zip                    *.ZOO       Zoo

Use a picklist or set the QAZSPEC variable to add extra specifications.

Only use the -US option when doing searches, *not* for normal listings
as a default: otherwise every matching filespec in the given directory
will be listed!

Note that in some cases it may be faster to search all files (*.*)
rather than use a large set of picklist specifications.

(34) QAZPATH
-----------------------------------------------------------------------
                   Path for qaz files, default is same path as QAZ.EXE.

                   if QAZ cannot file the -p[aopv].. files in the current 
                   (or given) path, QAZ then checks the qazpath for the file. 


(35) Return Codes given by the -RI option
-----------------------------------------------------------------------
When using the -RI option, QAZ will return an exit code indicating the file 
type.  External programs (such as batch files) can use this information to 
determine what utilities to use on the file.

The following is a list of the return codes:

        Code            Meaning (or archive type)          QAZ Version
        ----            ------------------------           -----------
          0             Unknown file type
          1           * An error has occured (possibly a bad archive)
          2             Memory overflow

         15           * Unidentified/Miscellaneous (Reserved)
         16             Possibly an ASCII (7-bit) text file

         17             AR (Use AR or LHA-compatable)
         18           * AR7 - no longer recognized as of QAZ v3.30a                                           
         19             ARC - v6 or earlier
         20             ARJ
         21             Unix Compress (v4)
         22             Compact Pro                       
         23             Central Point Shrink (CPSHRINK)
         24             Diet (v1)
         25             DWC
         26             MiscroSoft Compress (Use EXPAND)
         27             Unix Freeze (v2)
         28             GNU-Zip
         29             HA
         30             Hamarsoft HAP
         31             Hyper
         32             HPack                                          
         33             ReeveSoft Freeze v1.0 (for Windows)
         34           * (Reserved) 
         35             KBoom (v1.1) File
         36             Novosielski Libraries (LBR files)  
         37           * LArc (Amiga .LHA - Use LHArc)
         38             Knownledge Dynamics Archive         
         39             LHARC
         40             PAK Archive
         41             PGP-Encrypted (v2)
         42             PackIt                              
         43           * PUT (Use LHA-compatable)
         44             Queasy Archive
         45             Slim File
         46             StuffIt! Archive                             
         47             Squeeze-It! (.SQZ) Archive
         48             UltraCompressor II (.UC2)                     
         49             CP/M Squeeze (SQ,SQPC) File
         50             Zip
         51             Zoo
         52             Zi-Lite/ZPack (Usu. SFX)           
         53             Unix Tape Archive (.tar)
         54             SAR
         55             CoDec                             
         56             JRchive                            
         57             LArc (Use LHArc to decompress)     
         58           * BinHex 4.0 - no longer recognized as of QAZ v3.30a                        
         59           * Mac Self-Extracting Archive
         60             Mac DiskDoubler Archive            
         61             Amiga DMS Files                
         62             AMG Archive                        
         63             LIMIT Archive                      
         64             Yabba File                                     
         65             NuFX (ShrinkIt!) Archive                       
         66             MDCD Archive                                   
         67             Splint File                        - QAZ v3.09c
         68             RAR Archive (v1.40.2)              - QAZ v3.20a
         69             PowerPacker File                   - QAZ v3.21a
         70             Voof File                          - QAZ v3.30a
         71             7PLUS File                         - QAZ v3.30a
         72             RAR Archive (v1.50.1)              - QAZ v3.30a
         73             PKARC/PKPAK Archive (ARC)          - QAZ v3.30a
         74             ARC (v7.0+)                        - QAZ v3.30a
         75             SQWEZ (usu. SFX)                   - QAZ v3.40a
        
        128 .. 140    * Formerly Graphics formats prior to
                        QAZ v2.60a.  They are no longer
                        recognized by QAZ.

        254             Filename is in -PVfile list                    
        255             Syntax Error (Bad Option)

Note: Formats marked with an asterisk (*) are reserved for future versions 
      of QAZ.  Formats marked with a version number are not returned by 
      earlier versions of QAZ.
                      
To suppress output using the -R switch, one can do either of the
following:
                      
      QAZ archname -RI -MQ ^*
      QAZ archname -RI -MQI
      QAZ archname -RI > NUL

For an example of how to use the -R switch from a batch file, look at the 
included file XQAZ.BAT. This file uses QAZ to identify the archive type and 
then attempts to unarchive the file.

(36) Return Codes given by the -RA option
-----------------------------------------------------------------------
Added in this version of QAZ is the -RA option which will return an exit 
code if the file contains authentication information, password-protected 
files or is part of a multi-volume archive. 

(Check the included QAUTH.BAT file.)

In other words, if QAZ returns an exit-code other than 0 for -RA then one 
probably does not want automated system utilities to tamper with the file,  
but have it saved for later examination (if you are a SysOp, for example).

The codes returned by -RA are:

        Bit 0 set (1)   =  Archive may contain AV info.
        Bit 1 set (2)   =  Archive may contain encrypted files.
        Bit 2 set (4)   =  Archive may be part of multi-volume.
        Bit 3 set (8)   =  Self-Extracting archive (DOS).
        Bit 4 set (16)  =  NonDOS "8.3" filenames (QAZ v3.11a or later)
        Bit 5 set (32)  =  Archive in "unit" mode (QAZ v3.31a or later)

        Bit 7 set (128) =  Archive may be damaged.

QAZ v2.60a will no longer return an exit code of 0x01 for the -RI option if 
the archive is damaged, but instead return the identifying code. Use the -RA 
switch to determine if an archive may be damaged.

The -RA option can be used by automated BBS software to check files before 
attempting to convert archive formats or to insert advertisement files. If 
a non-zero value is returned, the SysOp should save the file for later exam-
ination. (Unfortunetly, standard DOS batch files are not capable of perform-
ing sophisticated checks of error-levels.)

(37) Return Codes given by the -RV option:
-----------------------------------------------------------------------
This option will return a version number of the archive, with the major
version in the most-significant nibble and the minor version in the least.
In pseudo code:

        exec("qaz.exe " .... " -rv");
        x = exitcode;
        major_version = x div 16;
        minor_version = x mod 16;

The major version should be a number from 0..14.  If it is 15, then it
is unknown.  The minor version should be a number from 0..9. If it is
15, then the minor version is unknown.


(38) Thanks & Ackowledgements
-----------------------------------------------------------------------
This is a partial listing of people who've tested, commented on, con-
tributed information, requested copies, reported bugs, sent software 
to me, or replied to my requests:

        Alan Barclay
        Roger Burton-West
        Timm Erickson
        Harald Feldmann
        Jeff Gilchrist
        Peter Gutmann
        Hari Hirvola
        Jack Hudgions
        Joe Jerszynski
        Rob Jung
        Todd Kempf
        Doug Macintosh
        Joe Negron
        Brian Niegocki
        Eugene Roshal
        Walter Scott
        Andrey Spasibozhko
        Jorj Strumolo
        Nico de Vries


(39) More Miscellanea, the -MX option:
-----------------------------------------------------------------------
QAZ was originally conceived as a test-utility for an as-yet-unwritten
disk catalog program because I have many archives in a variety of formats.
Hence it became an altogether seperate utility.

The -MX option was added to that other programs can shell out and use
QAZ to identify and generate a 'standardized' listing.  So feel free to
write utilities that make use of this feature.

The -MX option outputs the listing in hexidecimal: original size,
compressed/archived size, DOS-attributes, DOS-timestamp, CRC, and
full path.

An example output using the -MXQ option on an archive:

0000022e 0000014b 0020 128ab845 8fe9e874 \README
000030ef 000013aa 0020 1289ac3d 1aed42f4 \COMPRESS.TXT
00002c18 00000ce0 0020 128ab6e8 22454edf SRC\LZSS.C
000040b2 000010cc 0020 1289ac85 4aef3fc1 SRC\LZARI.C
00004fcb 000010e6 0020 1289ad0f 91feb024 SRC\LZHUF.C

The -MX option does not return Host-OS information.

Assume that these are not "absolute" paths.  Files in the current
path are always preceeded by a backslash while subdirectories are
not.

(40) Other Stuff...
-----------------------------------------------------------------------
For detailed information on revision-history or which file-formats QAZ
can recognize, check the WHATSNEW.TXT and WHICHARC.TXT files included
in the release, respectively.



