;----------------------------------------------------
; Firing Snake Version 1.01
;
; THIS GAME AND SOURCE CODE ARE FREELY DISTRIBUTABLE,
; AS LONG AS YOU KEEP THIS COPYRIGHT NOTICE:
;
;      Copyright (c) by Mysoft, Inc.
;                                       April, 2002
;
;      All rights reserved.
;
; For updates, and more info please check:
;
;      http://mysoft.s5.com/snake/
;
;----------- how to compile  -------------------------
;  
; for TASM (v5.0):
;                     TASM SNAKE.ASM
;                     TLINK SNAKE.OBJ
;
; for MASM (v2.0+):
;                     MASM SNAKE.ASM
;                     LINK SNAKE.OBJ
;
; (compiled file should be an .EXE !)
;
;
;  Level editor (with VB source) is available in
;  separate zip file (Source.zip).
;
; ???????????????????????????????????????????????????

; ------------ how to play ? -----------------------
; use arrow keys on your keyboard,
; CTRL key to shoot, ALT to speed up, P - to pause.
;
; collect apples, and avoid crashing into mines, stones
; and yourself.... more to come!
;
; ESC - exit anytime.
; --------------------------------------------------

        PAGE    ,80
        TITLE   FIRING SNAKE

COMMENT * Firing Snake - Clone of the Classic Arcade Game *

;***************************************************************

WATCH_KEYBOARD		MACRO
	PUSH	BX
	PUSH	DX
	PUSH	AX

	MOV	BX, 0

again_keys:

	MOV	AL, 4		; x
	MOV	AH, 1		; y
	MOV	text_back_color, 0

next_pos:

	MOV	DX, 0
	MOV	print_num_x, AL
	MOV	print_num_y, AH
	MOV	print_num_len, 3
	PUSH	AX
	MOV	AX, BX
	MOV	text_fore_color, 15	; white.
	CMP	KEYS[BX], 0
	JNE	skp
	MOV	text_fore_color, 34	; black.
      skp:
	CALL	PRINT_NUM
	POP	AX

	INC	BX
	CMP	BX, 128
	JNE	bx_still_small
	MOV	BX, 0
	jmp	stop
    bx_still_small:

	CMP	KEYS[KEY_ESC], 1
	JE	esc_pressed_h


	ADD	AL, 4 		; next x
	CMP	AL, 40		; got to end of line?
	JL	next_pos	; - no
	MOV	AL, 4		; - yes

	INC	AH		; next row
	CMP	AH, 30		; got to the end of screen?
	JL	next_pos	; - no
				; - yes!
stop:

	JMP	again_keys

    esc_pressed_h:

	POP	AX
	POP	DX
	POP	BX
ENDM

;***************************************************************

PRINT_COLOR_CODES	MACRO
	PUSH	AX
	PUSH	DX

	MOV	AL, 4		; x
	MOV	AH, 1		; y
	MOV	text_fore_color, 0
	MOV	text_back_color, 16

next_pos:

	MOV	DX, 0
	MOV	print_num_x, AL
	MOV	print_num_y, AH
	MOV	print_num_len, 3
	PUSH	AX
	XOR	AH, AH
	MOV	AL, text_fore_color
	CALL	PRINT_NUM
	POP	AX

	INC	text_fore_color		; next color.
	CMP	text_fore_color, 255
	JE	stop

	ADD	AL, 4 		; next x
	CMP	AL, 40		; got to end of line?
	JL	next_pos	; - no
	MOV	AL, 4		; - yes

	INC	AH		; next row
	CMP	AH, 30		; got to the end of screen?
	JL	next_pos	; - no
				; - yes!
stop:

	POP	DX
	POP	AX
ENDM

;***************************************************************

TILE_SCREEN	MACRO	start_from
LOCAL	tile_next, x_ok, tiling_complete
	MOV	BX, 0		; x
	MOV	DX, start_from	; y
    tile_next:
	CMP	BX, 640
	JL	x_ok
	MOV	BX, 0
	ADD	DX, 16
	CMP	DX, 480
	JAE	tiling_complete
    x_ok:
	LEA	SI, TILE
	CALL	PutIcon

	ADD	BX, 16
	JMP	tile_next
    tiling_complete:
ENDM

;***************************************************************

; moves snake to the left
DEC_X	MACRO
	DEC	snake[0]
	CMP	snake[0], -1
	JNE	ok1
	MOV	snake[0], 39
    ok1:
ENDM

;***************************************************************

; moves snake to the right
INC_X	MACRO
	INC	snake[0]
	CMP	snake[0], 40
	JNE	ok2
	MOV	snake[0], 0
ok2:
ENDM

;***************************************************************

; moves snake to the top
DEC_Y	MACRO
	DEC	snake[1]
	CMP	snake[1], 0 ; -1
	JNE	ok3
	MOV	snake[1], 29
ok3:
ENDM

;***************************************************************

; moves snake to the bottom
INC_Y	MACRO
	INC	snake[1]
	CMP	snake[1], 30
	JNE	ok4
	MOV	snake[1], 1 ; 0
ok4:
ENDM

;***************************************************************

; updates snake's coordinates
UPDATE_SNAKE_COORD	MACRO
	CMP	new_direction, LEFT	; 1
	JNE	n1
	DEC_X				; macro!
	JMP	snake_coord_updated
n1:

	CMP	new_direction, RIGHT	; 2
	JNE	n2
	INC_X				; macro!
	JMP	snake_coord_updated
n2:

	CMP	new_direction, UP	; 3
	JNE	n3
	DEC_Y				; macro!
	JMP	snake_coord_updated
n3:

	CMP	new_direction, DOWN	; 4
	JNE	n4
	INC_Y				; macro!
	; gets there anyway; JMP	snake_coord_updated
n4:

snake_coord_updated:

ENDM

;***************************************************************

; updates coordinates of a bomb.
; SI - the index of a bomb.
UPDATE_BOMB_COORD	MACRO
	CMP	BYTE PTR bomb_direction[SI], LEFT	; 1
	JNE	n1_b
	DEC	BYTE PTR bomb_x[SI]
	JMP	bomb_coord_updated
n1_b:

	CMP	BYTE PTR bomb_direction[SI], RIGHT	; 2
	JNE	n2_b
	INC	BYTE PTR bomb_x[SI]
	JMP	bomb_coord_updated
n2_b:

	CMP	BYTE PTR bomb_direction[SI], UP		; 3
	JNE	n3_b
	DEC	BYTE PTR bomb_y[SI]
	JMP	bomb_coord_updated
n3_b:

	CMP	BYTE PTR bomb_direction[SI], DOWN	; 4
	JNE	n4_b
	INC	BYTE PTR bomb_y[SI]
	; gets there any way; JMP	bomb_coord_updated
n4_b:

bomb_coord_updated:

ENDM

;***************************************************************

SHOW_SCORE_AND_VAL_CODE_INFO	MACRO	txt_ptr
LOCAL	nxt_row
	PUSH	AX
	PUSH	BX

    ; ****** print the text *******************************************
	LEA	BX, txt_ptr

	MOV	text_back_color, 16

	MOV	CL, 0
    nxt_row:
    	MOV	DL, [BX]		; get color of that string.
	MOV	text_fore_color, DL
	MOV	AL, 0
	MOV	AH, CL

	INC	BX			; point to actual string data.

	CALL	DrawString

	; BX points to 0 after DrawString, so adding 1 to BX will point
	; to the next string:
	INC	BX

	INC	CL		; next row.
	CMP	CL, 30		; got to the last row?
	JL	nxt_row		; - no.
    ; *******************************************************************


	; ===== show score:

	MOV	DX, score_h
	MOV	AX, score_l

	MOV	print_num_x, 25
	MOV	print_num_y, 9
	MOV	print_num_len, 6
	MOV	text_fore_color, 11
	MOV	text_back_color, 16
	CALL	PRINT_NUM

	; =====

	; ----- show validation code:
	CALL	MAKE_VAL_CODE

	MOV	text_fore_color, 11
	MOV	text_back_color, 16
	MOV	AL, 23	; x
	MOV	AH, 11	; y
	LEA	BX, s_buffer
	CALL	DrawString
	; --------------------------

	POP	BX
	POP	AX
ENDM

;***************************************************************

LEVEL_SEG	SEGMENT

; IMPORTANT! when adding new levels modify this constant!!!!!!!
; (we start level count from 0)
LEVEL_MAX	EQU	25	; the number of levels available in the game.


SUB_MAP_NUM	EQU	2	; ; we have 2 "sub-bit-maps".

; each row 5 bytes = 40 bits, so we get a 29*40 map:
LEVEL_BYTE_SIZE	EQU	145*SUB_MAP_NUM		; size of a single level in bytes.

;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

; The levels' map built this way:
;	00 - empty space
;	01 - apple
;	10 - mine
;	11 - stone
; Each level has two bit maps, first map is for Lower Bit and second
; map is for Higher Bit. So if there is a bit both in upper and lower
; sub-maps then there is a stone, if there is a bit only in the upper
; sub-map then this is an apple, otherwise it's a mine (no bit is wasted!).
;
;
;
; You can try making level maps manually,
; but I think it's better to use level maker
; for "Firing Snake", it's written in VB
; and source is also available.
;
;
;
; The location of level modules is important!!! first should go one after
; another: LEVEL_0 , LEVEL_1 , LEVEL_[N] , LEVEL_[N+1] etc....
; name (except LEVEL_0) isn't so important, you can even use no names at all.


;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
; the 40*29 map of "Level 0" !
; apples (or first stone bit):
LEVEL_0		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000010b,01011110b,10000100b,00011000b,00000000b
		DB	00000010b,01010000b,10000100b,00100100b,00000000b
		DB	00000010b,01010000b,10000100b,00100100b,00000000b
		DB	00000011b,11011100b,10000100b,00100100b,00000000b
		DB	00000010b,01010000b,10000100b,00100100b,00000000b
		DB	00000010b,01010000b,10000100b,00100100b,00000000b
		DB	00000010b,01011110b,11110111b,10011000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000011b,01001011b,10000000b,00000000b
		DB	00000000b,00000101b,01101010b,01000000b,00000000b
		DB	00000000b,00001111b,01011010b,01000000b,00000000b
		DB	00000000b,00010001b,01001011b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,10101000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
; mines (or stones if bit is set at the same place in the upper sub-map):
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000011b,01001011b,10000000b,00000000b
		DB	00000000b,00000101b,01101010b,01000000b,00000000b
		DB	00000000b,00001111b,01011010b,01000000b,00000000b
		DB	00000000b,00010001b,01001011b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00101110b,10000111b,00100010b,11100000b
		DB	00001001b,00101000b,10001000b,10110110b,10000000b
		DB	00001010b,10101100b,10001000b,10101010b,11000000b
		DB	00001100b,01101000b,10001000b,10100010b,10000000b
		DB	00000100b,01001110b,11100111b,00100010b,11100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_1		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011110b,10111001b,11100000b,00000000b,00011000b
		DB	00010000b,00100101b,00000000b,00000000b,00011000b
		DB	00011100b,10111001b,11000110b,00000000b,00000000b
		DB	00010000b,10101001b,00000110b,00000000b,00000000b
		DB	00010000b,10100101b,11100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000100b,00000000b
		DB	00000000b,00000000b,00000000b,00000110b,00000000b
		DB	00000001b,10000000b,00000000b,00000011b,00000000b
		DB	00000001b,10000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00011000b,00000000b,00000000b
		DB	00000000b,00000000b,00001000b,01000000b,11000000b
		DB	00000000b,00000000b,00000000b,00000000b,11000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00001100b,00000100b,00000000b,00000001b,00000000b
		DB	00001100b,00000000b,00000000b,00000011b,00000000b
		DB	00000000b,00000100b,00001110b,00000000b,00000000b
		DB	00000000b,00001100b,00001110b,00000001b,00000100b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000110b,00000000b,00000000b
		DB	00001111b,11110000b,00000110b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011110b,10111001b,11100000b,00000000b,00000000b
		DB	00010000b,00100101b,00000000b,00000000b,00000000b
		DB	00011100b,10111001b,11000000b,00000000b,00000000b
		DB	00010000b,10101001b,00000000b,00000000b,00000000b
		DB	00010000b,10100101b,11100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000110b,00000000b
		DB	00000000b,00000000b,00000000b,00000111b,00000000b
		DB	00000000b,00000000b,00000000b,00000011b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00111000b,00000000b,00000000b
		DB	00000000b,00000000b,00011000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000001b,00000000b
		DB	00000000b,00000100b,00000000b,00000011b,00000000b
		DB	00000000b,00000100b,00011111b,00000011b,00010000b
		DB	00000000b,00001100b,00010001b,00000000b,00000000b
		DB	00000000b,00001100b,00010001b,00000001b,00000000b
		DB	00000000b,00000000b,00011111b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,11110000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_2		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011100b,00000000b,00000000b,00000000b,00000000b
		DB	00011100b,00000000b,00000000b,00000011b,11000000b
		DB	00000000b,00000000b,00000000b,00000011b,01001100b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,01111111b,11111110b,00000011b,01000000b
		DB	00000000b,01111111b,11111110b,00000011b,01000000b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,01000000b,00000010b,00000011b,01000000b
		DB	00000000b,00000000b,00000000b,00000011b,01000000b
		DB	00000000b,00000000b,00000000b,00000011b,11000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00100000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,01111111b,11100000b,00000000b
		DB	00000000b,00000000b,01111111b,11100000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00000000b
		DB	00000000b,00000000b,00000111b,10100000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00000000b
		DB	00000000b,00011000b,00000111b,11100000b,01000000b
		DB	00000000b,00011000b,00000111b,11100000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000011b,11000000b
		DB	00000000b,00000000b,00000000b,00000011b,11001100b
		DB	00000000b,01111111b,11111110b,00000001b,11000000b
		DB	00000000b,01000000b,00000010b,00000001b,11000000b
		DB	00000000b,01000000b,00000010b,00000001b,11000000b
		DB	00000000b,01011000b,00011010b,00000001b,11000000b
		DB	00000000b,01011000b,00011010b,00000001b,11000000b
		DB	00000000b,01000000b,00000010b,00000001b,11000000b
		DB	00000000b,01000000b,00000010b,00000001b,11000000b
		DB	00000000b,01111111b,11111110b,00000001b,11000000b
		DB	00000000b,00000000b,00000000b,00000001b,11000000b
		DB	00000000b,00000000b,00000000b,00000011b,11000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,01110000b,00000000b,00000000b,00000000b
		DB	00000000b,01010000b,00000000b,00000000b,00000000b
		DB	00000000b,01110000b,01111111b,11100000b,00000000b
		DB	00000000b,00000000b,01111111b,11100000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00000000b
		DB	00001100b,00000000b,00000000b,00100000b,00000000b
		DB	00001100b,00000000b,00000000b,00100000b,11100000b
		DB	00000000b,00011000b,00000111b,11100000b,10100000b
		DB	00000000b,00011000b,00000111b,11100000b,11100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_3		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00100000b,00000000b,10000000b,00000000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,10000000b,00000010b,00010000b
		DB	00000000b,00000000b,00001001b,00000000b,00000000b
		DB	00001000b,00000100b,00000000b,00000010b,00000000b
		DB	00010100b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00000010b,00000010b,01001000b,00000000b
		DB	00000000b,00110000b,00000000b,00000000b,00000000b
		DB	00000010b,00000000b,00100000b,00000000b,01000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000010b,00010000b,00000000b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00001100b,00000000b,00000000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,11111111b,11111111b,11111110b,00100000b
		DB	00000000b,11110111b,01110010b,11111110b,00000000b
		DB	00000000b,11111101b,01111111b,11100110b,00000000b
		DB	00000000b,11011011b,10011101b,00011110b,00000000b
		DB	00000000b,11111111b,11111111b,11111110b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00001000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,10000000b,00000000b,00000000b,00000000b
		DB	00100000b,00000000b,00000000b,00000000b,00001000b
		DB	00001000b,00000000b,00000000b,00000000b,00000000b
		DB	00011100b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,01000000b,01000000b,00000000b,00000000b
		DB	00000000b,00110000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,10000000b,00000100b,00010000b,00010000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00001100b,00000000b,00000000b
		DB	00000000b,11111111b,11111111b,11111110b,00000000b
		DB	00000000b,11111011b,11111111b,11111110b,00000000b
		DB	00000000b,11111011b,11111111b,11111110b,00001000b
		DB	00000000b,11111111b,11111111b,11111110b,00000000b
		DB	00000000b,11111111b,11111111b,11111110b,00000000b
		DB	00100000b,11110111b,01110010b,11111110b,00000000b
		DB	00000000b,11111101b,01111111b,11100110b,00000000b
		DB	00000000b,11011011b,10011101b,00011110b,00000000b
		DB	00000000b,11111111b,11111111b,11111110b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00000000b,00000000b,00001000b
		DB	00000000b,00000000b,00000100b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_4		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011111b,11111111b,11111111b,11111111b,11111000b
		DB	00011111b,11111111b,11111111b,11111111b,11111000b
		DB	00000000b,00000000b,00000000b,00100000b,00011000b
		DB	00001000b,00000010b,00000001b,00100000b,00011000b
		DB	00000000b,00000000b,00000000b,00100010b,00011000b
		DB	00011111b,11111111b,11111001b,00100010b,00011000b
		DB	00011000b,00000000b,00000000b,00100010b,00011000b
		DB	00000000b,00000000b,00000000b,00111110b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000001b,00100000b,10001000b
		DB	00010000b,00000000b,00000000b,00000000b,00001000b
		DB	00010000b,00000000b,00000000b,00100000b,00011000b
		DB	00010000b,00000000b,00000000b,00100000b,00011000b
		DB	00011000b,00111111b,11111111b,11100000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00010000b,10011000b
		DB	00011000b,00000000b,00100000b,00010000b,00011000b
		DB	00011001b,00100000b,00100000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011001b,01111111b,11111111b,11111111b,11111000b
		DB	00011000b,01111111b,11111111b,11111111b,11111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011111b,11111111b,11111111b,11111111b,11111000b
		DB	00011111b,11111111b,11111111b,11111111b,11111000b
		DB	00000000b,00000000b,00000000b,00100000b,00011000b
		DB	00000000b,00000000b,00000000b,00100000b,00011000b
		DB	00000000b,00000000b,00000000b,00100010b,00011000b
		DB	00011111b,11111111b,11111000b,00111010b,00011000b
		DB	00011000b,00000000b,00000000b,00111110b,00011000b
		DB	00000000b,00000110b,00000000b,00111110b,00011000b
		DB	00011001b,11111110b,00000000b,00000000b,00011000b
		DB	00011001b,11111110b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00100000b,00011000b
		DB	00011000b,00000000b,00000000b,00100000b,00011000b
		DB	00011000b,00111111b,11111111b,11100000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00100000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,00000000b,00000000b,00000000b,00011000b
		DB	00011000b,01111111b,11111111b,11111111b,11111000b
		DB	00011000b,01111111b,11111111b,11111111b,11111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_5		DB	01000101b,00010010b,01010000b,01001001b,00001001b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	10000000b,00000000b,00000000b,00100000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000001b
		DB	10000000b,10000000b,00000000b,00000100b,00000000b
		DB	00000100b,00000001b,00100000b,00000000b,00000001b
		DB	10000000b,00000000b,00000000b,00000000b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00000000b,00100000b,00000001b
		DB	00000000b,00010000b,00100000b,00100000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00000000b,10000010b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001100b,00000000b,01000000b,00000000b,00000000b
		DB	10000000b,00000000b,00010000b,00010000b,01000001b
		DB	00000000b,00100100b,00000000b,00000000b,00000000b
		DB	10000010b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00100000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000010b,00000000b,00000001b
		DB	10000000b,00000000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	10000000b,00000000b,00000000b,00000000b,00000001b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00001000b,00001000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000001b
		DB	10000000b,00000000b,00000000b,00000000b,00000000b
		DB	00100100b,10010100b,00010000b,10100100b,00100100b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00100000b,00000000b,00000100b,00000000b,00000000b
		DB	00000000b,01000000b,00000000b,00100001b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000001b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,10100000b
		DB	00000000b,10000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00000000b
		DB	00000000b,00010000b,00100000b,00010000b,01000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000010b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,01000000b,00000000b,00000000b
		DB	00010000b,00000000b,00000000b,00010000b,01000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000010b,00000000b,00000000b
		DB	00000000b,00100000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000010b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00001000b,00000000b
		DB	00000000b,00001000b,00100000b,00000000b,00000000b
		DB	00000010b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_6		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000110b,00000000b,00000000b,01000000b,00000000b
		DB	00000110b,00000001b,11111111b,01000000b,00110000b
		DB	00000000b,00000001b,11111111b,01000000b,00110000b
		DB	00000000b,00000001b,11111111b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00111100b,00000000b,00011111b,11111100b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,11000000b
		DB	00000100b,00110000b,00011000b,01000000b,11000000b
		DB	00000100b,00110000b,00011000b,10000000b,11000000b
		DB	00000100b,00000000b,00000000b,10000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00011111b,11001111b,11111100b,11100000b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00100000b,00111111b,11110000b,00000100b
		DB	00000100b,00100000b,00111111b,11110000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,10000000b,00000000b,00000000b,00000000b
		DB	00000001b,10000000b,00000000b,00000000b,01100000b
		DB	00000000b,00000000b,00000000b,00000000b,01100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000110b,00000000b
		DB	00000000b,00000000b,01111100b,01000110b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00111111b,11111111b,00011111b,11111100b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,11000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00000000b,00000000b,01000000b,00000000b
		DB	00000100b,00011111b,11111111b,00011111b,11100000b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000100b,00100000b,00001111b,10000000b,00000100b
		DB	00000100b,00100000b,00001111b,10000000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000011b,00000000b,00000000b
		DB	00000000b,00000000b,00000011b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_7		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,01000000b,00000010b,00000000b,00000000b
		DB	00001000b,00000010b,00000000b,00001000b,00100000b
		DB	00000000b,00000010b,00010000b,10000000b,00000000b
		DB	00000001b,00100000b,00000000b,00100001b,10000000b
		DB	00000000b,00000100b,00010000b,00100000b,00010000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,10001000b,10001000b,00010000b
		DB	00000000b,01000000b,00000000b,00000001b,00000000b
		DB	00000000b,00001011b,00010000b,01000000b,10001000b
		DB	00000000b,00000000b,00000010b,00000100b,00000000b
		DB	00000010b,00000010b,10000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000010b,00010000b,01000100b
		DB	00000010b,00010000b,01000000b,00101000b,00000000b
		DB	00000000b,01000000b,01000000b,00001000b,11000000b
		DB	00001000b,00000100b,00010100b,01000000b,00010100b
		DB	00000000b,00010000b,10000000b,00000000b,00000000b
		DB	01000000b,00100000b,00100000b,10000100b,00000000b
		DB	00000001b,00000010b,01000000b,00000001b,00010000b
		DB	00101000b,00001000b,00000100b,00000000b,00000000b
		DB	00000000b,10000010b,00010000b,01010000b,00001000b
		DB	01000100b,00010000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,01001010b,00100000b,00000000b
		DB	00001001b,00000000b,00000000b,00000000b,00110000b
		DB	00000000b,00100000b,00010010b,00000010b,00000000b
		DB	00000000b,00000010b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,01000000b,00000010b,00000000b,00000000b
		DB	00001000b,00000010b,00000000b,00001000b,00100000b
		DB	00000000b,01000000b,00010000b,00000000b,00000000b
		DB	00000000b,00100000b,01000000b,00100000b,10000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00010000b,00000000b,00000000b,00000001b,00000000b
		DB	00000101b,00000000b,10001000b,10001000b,00000000b
		DB	00000000b,00000000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,10001000b
		DB	00000000b,00010000b,00000010b,00000100b,00000000b
		DB	00000010b,10000010b,10000000b,00000000b,00010000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00001000b,00000000b
		DB	00000000b,01000000b,01000000b,00000000b,01000000b
		DB	00001000b,00000100b,00000100b,01000000b,00000000b
		DB	00000001b,00000000b,10000001b,00000000b,00000000b
		DB	01001000b,00100000b,00000000b,10001000b,00000000b
		DB	00000001b,00000010b,00000000b,00000001b,00010000b
		DB	00001000b,00000000b,00000100b,00000000b,00000000b
		DB	00000000b,10000000b,00010000b,01010000b,01000000b
		DB	00000000b,00010000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,01000000b,10000000b,00000000b
		DB	00001000b,00000000b,00000000b,00000000b,00010000b
		DB	00000000b,00100000b,00000010b,00000010b,00000000b
		DB	00000000b,00000010b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_8		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000011b,11111111b,11111111b,11111110b,00001000b
		DB	00010011b,11111111b,11111111b,11111110b,00001000b
		DB	00010000b,00000000b,00000000b,00000000b,00001000b
		DB	00010000b,00000000b,00000000b,00000000b,00001000b
		DB	00010000b,01111111b,11111111b,11000010b,00001000b
		DB	00010001b,00000001b,00101000b,01000010b,11001000b
		DB	00010001b,11111111b,11111000b,01000010b,11001000b
		DB	00010001b,01000000b,00000000b,01000010b,00001000b
		DB	00010001b,01000000b,10111000b,01000010b,00001000b
		DB	00000001b,11111101b,11111111b,11011010b,00001000b
		DB	00000000b,00000000b,10010000b,01011010b,00001000b
		DB	00000000b,00000000b,10110000b,01000010b,00001000b
		DB	00000001b,00001001b,11011101b,11000010b,00001000b
		DB	00000001b,00001001b,00110000b,01000010b,00001000b
		DB	00000001b,00000000b,11010000b,01000010b,00001000b
		DB	00000001b,11111110b,11111111b,11000010b,00001000b
		DB	00000000b,00000000b,00000000b,00000010b,00001000b
		DB	00000000b,00000000b,00000000b,00011110b,01111000b
		DB	00000011b,11111111b,11111111b,11110000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00010000b,00001000b
		DB	00000011b,11111111b,11111110b,01110000b,11001000b
		DB	00000000b,00000000b,00000000b,00000000b,11001000b
		DB	00000011b,11111111b,11111111b,11100000b,00001000b
		DB	00000011b,11111111b,11111111b,11100111b,11111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00010011b,11111111b,11111111b,11111110b,00001000b
		DB	00010000b,00000000b,00000000b,00000000b,00001000b
		DB	00010000b,00000000b,00000000b,00000000b,00001000b
		DB	00010001b,11111111b,11111111b,11000010b,00001000b
		DB	00010000b,00000000b,00000000b,01000010b,00001000b
		DB	00010001b,11111111b,11111000b,01000010b,00001000b
		DB	00010001b,01000001b,11100000b,01000010b,00001000b
		DB	00010001b,01000000b,00000000b,01000010b,00001000b
		DB	00000001b,11111101b,11111111b,11000010b,00001000b
		DB	00000001b,11111000b,00100000b,01000010b,00001000b
		DB	00000001b,11111001b,00001000b,01000010b,00001000b
		DB	00000001b,11111001b,11011101b,11000010b,00001000b
		DB	00000001b,11111001b,00000000b,01000010b,00001000b
		DB	00000001b,11111000b,00100000b,01000010b,00001000b
		DB	00000001b,11111101b,11111111b,11000010b,00001000b
		DB	00000000b,00000000b,00000000b,00000010b,00001000b
		DB	00000000b,00000000b,00000000b,00011110b,01111000b
		DB	00000011b,11111111b,11111111b,11110000b,00001000b
		DB	01100000b,00000000b,00000000b,00000000b,00001000b
		DB	01100000b,00000000b,00000000b,00000000b,00001000b
		DB	00000011b,11111111b,11111110b,00010000b,00001000b
		DB	00000011b,11111111b,11111110b,01110000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00000011b,11111111b,11111111b,11100111b,11111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEVEL_9		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000010b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,11111000b,00000000b,00000000b
		DB	00000000b,00000000b,11111000b,00001000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,01000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000010b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000100b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00100000b
		DB	00000100b,00000000b,00010000b,00000000b,00000000b
		DB	00000000b,01001000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000001b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00000001b,00001000b,00000000b,00000000b
		DB	00000001b,00001000b,00000000b,00001000b,00000000b
		DB	00000000b,00000000b,00000010b,00000000b,00000000b
		DB	00000000b,00000000b,11111000b,00000000b,00000000b
		DB	00000000b,00000000b,11111000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00100000b,01000000b,00000000b,00000000b,01000000b
		DB	00000000b,00000000b,00100000b,00001000b,00000000b
		DB	00000010b,00000000b,00000010b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,10000000b,10000000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,10010000b,00000000b,00000000b,00100000b
		DB	00000000b,00000000b,01000010b,01000000b,00000000b
		DB	00000000b,00000000b,01000000b,00010000b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00010000b,00100000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_10		DB	00000000b,01000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000001b,00010000b,01000000b,00010000b
		DB	01000000b,01000000b,00000000b,00000001b,11000100b
		DB	00000100b,00000000b,00000000b,00000001b,11000000b
		DB	00000000b,00010011b,11111111b,10100001b,11000000b
		DB	00000000b,00000010b,00000000b,10000001b,11000100b
		DB	00000000b,00001010b,11111110b,10000001b,11000000b
		DB	00100000b,00000010b,11111110b,10001001b,11000000b
		DB	00000100b,00000010b,11111110b,10000001b,11000000b
		DB	00000000b,00010010b,11111110b,10000001b,11000000b
		DB	00000000b,10000010b,11111110b,10010001b,11000000b
		DB	00000100b,00100010b,11111110b,10000001b,11000000b
		DB	00000000b,00000010b,11111110b,10001001b,11000000b
		DB	00000000b,10000010b,00000000b,10000001b,11000000b
		DB	00100000b,00010011b,11111111b,10000000b,00000100b
		DB	00000010b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00100001b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	01000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,11111000b,00000100b,00001111b,00000000b
		DB	00000000b,11111000b,00000000b,00001111b,00000000b
		DB	00000000b,11111000b,00000000b,00001111b,00000000b
		DB	00000000b,11111000b,00100000b,00000000b,00000000b
		DB	00000000b,00000000b,00000001b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00001000b,00000000b,00000000b
		DB	00100000b,00000000b,00000000b,01010000b,00100100b
		DB	00000000b,00010000b,00000100b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,01000000b
		DB	00000000b,00000000b,00000000b,00000000b,10000000b
		DB	00000011b,10000011b,11111111b,10000001b,00000000b
		DB	00000011b,10000010b,00000000b,10000000b,01000000b
		DB	00000011b,10000010b,00000000b,10000000b,00000000b
		DB	00000011b,10000010b,00000000b,10000000b,00000000b
		DB	00000000b,00000010b,00000000b,10000001b,01000000b
		DB	00000000b,00000010b,00000000b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000000b,11000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000001b,01000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00000011b,11111111b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,11111111b,10000000b,01111111b,11100000b
		DB	00001000b,00000000b,10000000b,01000000b,00100000b
		DB	00001000b,00000000b,10000000b,01000000b,00100000b
		DB	00001000b,00000000b,10000000b,01001111b,00100000b
		DB	00001000b,00000000b,10000000b,01001111b,00100000b
		DB	00001000b,00000000b,10000000b,01001111b,00100000b
		DB	00001000b,00000000b,10000000b,01000000b,00100000b
		DB	00001000b,00000000b,10000000b,01000000b,00100000b
		DB	00001000b,00000000b,10000000b,01111111b,11100000b
		DB	00001111b,11111111b,10000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_11		DB	00000000b,10000101b,01001001b,01000000b,01000000b
		DB	10101101b,11101001b,11110111b,11110100b,00010000b
		DB	00000001b,00000001b,10000000b,00010110b,11101000b
		DB	00100011b,00010101b,00001001b,11110000b,10000100b
		DB	10010111b,10100001b,00001101b,00011010b,10000100b
		DB	10000111b,00011010b,10111001b,01010100b,11001100b
		DB	01010101b,00110000b,11111100b,10010000b,10001010b
		DB	00010110b,00010101b,10100001b,10011101b,10000010b
		DB	00000011b,11010101b,10100010b,00010001b,10000010b
		DB	00000100b,01010011b,10010000b,00100100b,00000000b
		DB	00000100b,01011110b,11100110b,10000001b,00100100b
		DB	00000100b,10110000b,10111111b,11111001b,10101000b
		DB	00000111b,01010101b,10110000b,11010001b,00001000b
		DB	00001110b,00000010b,10110000b,11011000b,10000110b
		DB	00001000b,01101110b,11010000b,11011001b,10000000b
		DB	01000011b,10111010b,11010000b,11111001b,00100000b
		DB	00000001b,00000000b,00011111b,11101000b,00001100b
		DB	01001101b,10010101b,11111100b,10010111b,00000110b
		DB	01000101b,11111011b,10100101b,00000000b,00011001b
		DB	00001001b,00001110b,10110000b,10110001b,01110000b
		DB	11000011b,00001110b,10101110b,00000001b,10000000b
		DB	10001001b,00001111b,11110010b,10010010b,00100000b
		DB	10010001b,00001101b,01011010b,01110110b,01101000b
		DB	10000011b,00001000b,00001101b,10100011b,01001001b
		DB	00100011b,11111001b,10100001b,01101100b,00000010b
		DB	10110001b,01001111b,00000000b,00010000b,01000110b
		DB	00000101b,01010000b,00001010b,10010001b,11110000b
		DB	00001110b,00010100b,00000010b,01100010b,00011100b
		DB	00000000b,00000010b,10100000b,01000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00011111b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000001b,11111000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_12		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,11111111b,11111111b,11111111b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00001000b,00000000b,00001100b,00000000b,00010100b
		DB	00000000b,00000000b,00000000b,00000000b,00010100b
		DB	00001111b,11111111b,11111111b,11111111b,11010100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00000000b,00011111b,11111000b,00000000b,01000100b
		DB	00000000b,00000000b,00000000b,00000001b,01000100b
		DB	00000000b,00000000b,00000000b,00000001b,01000100b
		DB	00001111b,11111111b,11111111b,11111001b,01000100b
		DB	00000000b,00000000b,00000000b,00001001b,01010100b
		DB	00000000b,00011111b,11110000b,00001001b,01010100b
		DB	00000000b,00000000b,00000000b,00001001b,01010100b
		DB	00000001b,00000000b,00000000b,00001001b,01010100b
		DB	00000001b,00000000b,00000000b,00001001b,01000100b
		DB	00000001b,00001111b,11110000b,00001001b,01000100b
		DB	00000001b,00000000b,00000000b,00001001b,01000100b
		DB	00000001b,00011111b,11111111b,11111000b,01010100b
		DB	00000001b,01010000b,00000000b,00000000b,01010100b
		DB	00000001b,01010111b,11111111b,11110000b,01010100b
		DB	00000001b,01010111b,11111111b,11110000b,01010100b
		DB	00000001b,01010000b,00000000b,00000000b,01010100b
		DB	00000001b,01011111b,11111111b,11111111b,11000100b
		DB	00000000b,01000000b,00000000b,00000000b,00000100b
		DB	00000000b,01000000b,00000000b,00001111b,11100100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00001111b,11111111b,11111111b,11111111b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,11111111b,11111111b,11111111b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00001111b,11111111b,11111111b,11111111b,11000100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00001111b,11111111b,11111111b,11111000b,01000100b
		DB	00000000b,00000000b,00000000b,00001000b,01000100b
		DB	00000000b,00000000b,00000000b,11101000b,01000100b
		DB	00000000b,00000000b,00000000b,11101000b,01000100b
		DB	00000001b,00000000b,00000000b,11101000b,01000100b
		DB	00000001b,00000000b,00000000b,11101000b,01000100b
		DB	00000001b,00000000b,00000000b,11101000b,01000100b
		DB	00000001b,00000000b,00000000b,00001000b,01000100b
		DB	00000001b,00011111b,11111111b,11111000b,01000100b
		DB	00000001b,00010000b,00000000b,00000000b,01000100b
		DB	00000001b,00010000b,00000000b,00000000b,01000100b
		DB	00000001b,00010000b,00000000b,00000000b,01000100b
		DB	00000001b,00010000b,00000000b,00000000b,01000100b
		DB	00000001b,00011111b,11111111b,11111111b,11000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000100b
		DB	00001111b,11111111b,11111111b,11111111b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_13		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00000000b,10000000b,00000000b,00000000b
		DB	00000000b,00001000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,10000000b,00001000b,00000000b,10000000b
		DB	00001000b,00001010b,00000000b,00001000b,00000000b
		DB	00000000b,00000000b,00001000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00010000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000100b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00001001b,00001000b
		DB	00000000b,00010000b,00100000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000001b,00000010b,00000100b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00000000b,00000010b,00000000b
		DB	00000000b,00000100b,00000000b,10000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,01000000b,00010000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,01000000b,10000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000001b,00000000b,00000001b,00000000b
		DB	00000001b,00000000b,00001001b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00010000b,00000000b
		DB	00000000b,00000001b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00000000b,10000000b,00000100b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,10000000b,00000000b,00000000b,10000000b
		DB	00000000b,00000010b,10000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,10000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00001000b,00001000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,01000000b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00100000b,00000010b,00000000b
		DB	00000000b,00000100b,00000000b,10000000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000000b,10000000b,01000000b,00000000b
		DB	00000010b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00100001b,00000000b,00000001b,00010000b
		DB	00000001b,00000000b,00000001b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000001b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_14		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,01111111b,11111111b,11101111b,11110000b
		DB	00001000b,00000100b,01110000b,00000000b,00010000b
		DB	00000000b,01100000b,01111100b,00000000b,00000000b
		DB	00001001b,11000100b,00000000b,00000000b,00010000b
		DB	00001000b,00000111b,11110111b,11111000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001000b,00000000b,00000000b,00001001b,00010000b
		DB	00001000b,01000100b,00011000b,00000001b,10010000b
		DB	00001000b,11000100b,00010010b,00001000b,10000000b
		DB	00000000b,10000100b,00010111b,10001000b,10010000b
		DB	00001000b,11000100b,11011111b,10001000b,00010000b
		DB	00001000b,10000100b,10010010b,00001000b,00010000b
		DB	00001000b,10000100b,00011010b,00001000b,00010000b
		DB	00001000b,10000100b,00000000b,00001000b,00010000b
		DB	00001000b,10000000b,00000000b,00000000b,00010000b
		DB	00001000b,11000100b,00000000b,00001001b,00010000b
		DB	00001000b,10000100b,00000000b,00001011b,00010000b
		DB	00001000b,10000111b,11111110b,11111010b,00000000b
		DB	00001000b,00000100b,00000000b,00001010b,00010000b
		DB	00000000b,01000100b,00011000b,00001011b,00010000b
		DB	00001000b,11100000b,00000110b,00001000b,00010000b
		DB	00001001b,11100100b,00000000b,00001000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001111b,01111111b,11101111b,11111111b,01110000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001111b,01111111b,11111111b,11101111b,11110000b
		DB	00001000b,00000100b,00000000b,10000000b,00010000b
		DB	00000000b,00000001b,00000000b,00000000b,01000000b
		DB	00001000b,00000100b,00000000b,00000000b,00010000b
		DB	00001000b,00000111b,11110111b,11111000b,10010000b
		DB	00001001b,00000100b,00000000b,00001000b,00010000b
		DB	00001000b,00100000b,10000000b,01001000b,00010000b
		DB	00001000b,00000100b,00000000b,00000000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00000000b
		DB	00000000b,00000100b,00000000b,00001000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001100b,00000100b,00000000b,00001010b,00010000b
		DB	00001000b,00000100b,00000001b,00001000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001000b,00010000b,00000000b,00000000b,00010000b
		DB	00001000b,00000100b,10000000b,01001000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001000b,00000111b,11111110b,11111000b,00000000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00000010b,00000100b,00000000b,10001000b,01010000b
		DB	00001000b,00000000b,01000000b,00001000b,00010000b
		DB	00001000b,00000100b,00000001b,00001000b,00010000b
		DB	00001000b,00000100b,00000000b,00001000b,00010000b
		DB	00001111b,01111111b,11101111b,11111111b,01110000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_15		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,10000000b,00001000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,01000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000100b,00000000b,00000001b,00000000b,00000000b
		DB	00000000b,00000000b,00010000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00100000b,00100000b
		DB	00000000b,00010000b,00000000b,00000000b,01000100b
		DB	00000101b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,10000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000100b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000100b,00001000b,00000000b,00000000b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00001000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,01000000b,00100000b,00000000b,00001000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00010000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,00010010b,00001000b,10000000b,00010000b
		DB	00010111b,00000000b,00000000b,10000000b,00000000b
		DB	00010000b,00000000b,00100100b,10000000b,00000000b
		DB	00001000b,01010000b,00111110b,10000011b,00000000b
		DB	00000000b,00010011b,00000000b,00100010b,00000000b
		DB	00000000b,11000000b,00000100b,00000000b,00001000b
		DB	00000000b,00001001b,00000000b,00000100b,00000000b
		DB	00001001b,00010000b,00000000b,00000100b,00000000b
		DB	00000001b,00000000b,01011101b,00100100b,00000000b
		DB	00000000b,00000011b,00001000b,00000000b,00000000b
		DB	00000000b,10001000b,00001000b,01000101b,01001000b
		DB	00010010b,01011010b,00010000b,00000000b,01000000b
		DB	00000000b,00001000b,00100000b,00010001b,10000000b
		DB	00000000b,10000000b,10000001b,00010000b,00000000b
		DB	00000000b,10000010b,00010000b,01001000b,00000000b
		DB	10010001b,01000000b,00000000b,10000000b,00000000b
		DB	00000101b,00100010b,01001000b,00011000b,10000000b
		DB	00001100b,00000000b,01000000b,00000000b,10000000b
		DB	00110100b,00100100b,00000000b,00010001b,10000000b
		DB	00100000b,00000000b,00000010b,00000000b,10000000b
		DB	00000000b,00000000b,10000000b,00000000b,00000000b
		DB	00000011b,00101100b,11010010b,10000000b,00000000b
		DB	00000100b,00000000b,00000010b,00000000b,00000000b
		DB	00000001b,10000010b,00010100b,00000010b,00000000b
		DB	00000000b,00000000b,00000001b,00000000b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_16		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00010101b,00100010b,00000000b,10010001b
		DB	00111101b,01010000b,10000000b,00000100b,00100001b
		DB	00000000b,00000000b,10000000b,00001100b,00000000b
		DB	01001000b,11010100b,01110110b,10000000b,10110000b
		DB	00000001b,10010000b,01001100b,00001000b,00100001b
		DB	01000000b,01111100b,00100000b,01010010b,01010000b
		DB	00010000b,00010100b,01001110b,00011000b,00000000b
		DB	01010000b,00000100b,00100000b,11001000b,00000000b
		DB	00000001b,10000100b,00000001b,10000000b,00000000b
		DB	00110101b,00001100b,00100000b,00000100b,00010000b
		DB	00000100b,00100001b,00010010b,00010110b,00100000b
		DB	00100001b,01000000b,00000100b,00001010b,00001001b
		DB	00010010b,01000000b,00001010b,00100100b,00000000b
		DB	00000011b,00001101b,11101100b,00000100b,00100000b
		DB	00010000b,01000111b,00100111b,01011100b,00000000b
		DB	00000010b,00000000b,00001000b,00110100b,00101000b
		DB	00000010b,00000001b,00000100b,10110100b,00010001b
		DB	00000100b,01001101b,01110110b,10110000b,00110001b
		DB	00111000b,10010110b,01000001b,00001100b,10100000b
		DB	00000001b,00001001b,00100010b,11100000b,01000000b
		DB	00000110b,01011010b,01000010b,00100000b,00000000b
		DB	00000000b,01001110b,00000000b,00000011b,00100000b
		DB	00000000b,00000000b,10000001b,00100100b,00000000b
		DB	00000000b,00110010b,10000000b,00001000b,00000000b
		DB	00000000b,00001010b,00000000b,00000000b,00000000b
		DB	00100001b,10000100b,10000010b,00000000b,00000000b
		DB	00001100b,10000000b,00001000b,11000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,10010000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000100b,00000000b
		DB	00000000b,01000000b,00001000b,00010100b,00000000b
		DB	00000000b,00000000b,00010000b,00000000b,00010000b
		DB	00000000b,10010000b,00101000b,00000000b,00000000b
		DB	00000000b,01100000b,00000000b,00000000b,00010000b
		DB	00000100b,00001000b,00001010b,00001000b,00000000b
		DB	00000001b,00000000b,00000100b,10000000b,00000000b
		DB	00000000b,10000000b,00000000b,00000010b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00010000b
		DB	00010010b,00000000b,00001000b,00000000b,00000000b
		DB	00000001b,01000000b,01000010b,00010000b,00001000b
		DB	00000000b,00000001b,00000000b,00000000b,00000000b
		DB	00000001b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,00000010b,00000011b,00001000b,00010000b
		DB	00000000b,01000000b,00100000b,00010000b,00000000b
		DB	00000000b,00000100b,00000000b,00000010b,10010000b
		DB	00000000b,00000000b,00001000b,00100000b,01000000b
		DB	00000000b,00000000b,00000000b,00001100b,10100000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000010b,01000100b,00001000b,00000000b,00000000b
		DB	00000000b,00010000b,00000000b,00000000b,00000000b
		DB	00000000b,00001000b,10000010b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00001000b,00000000b
		DB	00000000b,00000000b,00010000b,00000000b,00000000b
		DB	00000000b,00000000b,00001000b,01000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_17		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000011b,11111111b,11111111b,11111111b,11110000b
		DB	00000011b,11111111b,11111111b,11011111b,11110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,01110000b,00110000b
		DB	00000011b,00000000b,11100000b,01110000b,00110000b
		DB	00000011b,00000000b,11100000b,01110000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,00000000b,11100000b,00000000b,00110000b
		DB	00000011b,01111111b,11100000b,00000000b,00110000b
		DB	00000011b,01111111b,11100000b,00000000b,00110000b
		DB	00000011b,01111111b,11100000b,00000000b,00110000b
		DB	00000011b,01100000b,00000000b,00000000b,00110000b
		DB	00000011b,01111111b,11111111b,11111111b,11110000b
		DB	00000011b,01111111b,11111111b,11111111b,11110000b
		DB	00000011b,00111100b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000011b,11111111b,11111111b,11111111b,11110000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000010b,00000000b,01000000b,00000000b,00010000b
		DB	00000010b,00000000b,01000000b,00000000b,00010000b
		DB	00000010b,00111000b,00000000b,00000000b,00010000b
		DB	00000010b,00111000b,01000000b,11111000b,00010000b
		DB	00000010b,00111000b,01000000b,11111000b,00010000b
		DB	00000010b,00000000b,01000000b,11111000b,00010000b
		DB	00000010b,00000000b,01000000b,11111000b,00010000b
		DB	00000010b,00000000b,01000000b,11111000b,00010000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000000b,00000000b,01000000b,00000000b,00010000b
		DB	00000000b,01111111b,11000000b,00000000b,00010000b
		DB	00000010b,01000000b,00000000b,00000000b,00010000b
		DB	00000010b,01000000b,00000000b,00000000b,00010000b
		DB	00000010b,01000000b,00000000b,00000000b,00010000b
		DB	00000010b,01100111b,11111111b,11111101b,11110000b
		DB	00000010b,00111100b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_18		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,00111100b
		DB	00000111b,11111111b,11000000b,00000000b,00111100b
		DB	00000100b,00110000b,00000000b,00000000b,00000100b
		DB	00000100b,00010000b,01111111b,11111111b,10000100b
		DB	00000100b,00010000b,01111111b,11111111b,10000100b
		DB	00000100b,00100000b,01111111b,11111111b,10000100b
		DB	00000100b,00100000b,01111000b,00000111b,10000000b
		DB	00000111b,11100000b,01110000b,00000011b,10000100b
		DB	00000000b,00000000b,01110000b,00000011b,10000000b
		DB	00000000b,00000000b,01110000b,00000001b,10000000b
		DB	00000000b,00000000b,01100000b,00000001b,10000000b
		DB	00000000b,00000000b,01110000b,00000001b,10000000b
		DB	00000000b,00000000b,01110000b,00000001b,10000000b
		DB	00000000b,00000000b,01110000b,00000011b,10000000b
		DB	00000000b,00000000b,01110000b,00000011b,10000000b
		DB	00000000b,00000000b,01111000b,00000111b,10000000b
		DB	00000000b,00000100b,01111110b,00001111b,10000000b
		DB	00000000b,00000100b,01111111b,11111111b,10000000b
		DB	00000000b,00000100b,01111111b,11111111b,10001000b
		DB	00000010b,00000111b,10000000b,00000000b,00001000b
		DB	00000010b,00000000b,10000000b,00000000b,00001000b
		DB	00000010b,00111110b,10000000b,00000001b,00001000b
		DB	00000011b,00111110b,10000000b,00000001b,00001000b
		DB	00000011b,11111111b,10000000b,00000000b,11110000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,11111100b
		DB	00000000b,00000000b,00000000b,00000000b,01000100b
		DB	00000111b,11111111b,11000000b,00000000b,01000100b
		DB	00000100b,00110000b,00000000b,00000000b,01111100b
		DB	00000101b,10010000b,00000000b,00000000b,00000100b
		DB	00000101b,10010000b,00000000b,00000000b,00000100b
		DB	00000101b,10100000b,00000000b,00000000b,00000100b
		DB	00000100b,00100000b,00000000b,00000000b,00000000b
		DB	00000111b,11100000b,00000000b,00000000b,00000100b
		DB	00000000b,00000000b,00000000b,11000000b,00000000b
		DB	00000000b,00000000b,00000001b,11100000b,00000000b
		DB	00000000b,00000000b,00000011b,11110000b,00000000b
		DB	00000000b,00000000b,00000011b,11110000b,00000000b
		DB	00000000b,00000000b,00000001b,11100000b,00000000b
		DB	00000000b,00000000b,00000000b,11000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000100b,00000000b,00000000b,00000000b
		DB	00000001b,11111100b,00000000b,00000000b,00001000b
		DB	00000011b,11111111b,10000000b,00000000b,00001000b
		DB	00000010b,00000000b,10000000b,00000000b,00001000b
		DB	00000010b,00000000b,10000000b,00000001b,00001000b
		DB	00000011b,00000000b,10000000b,00000001b,11111000b
		DB	00000011b,11111111b,10000000b,00000000b,11110000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_19		DB	01000000b,00000000b,00000000b,00000000b,00000000b
		DB	00101011b,00110001b,00011001b,10111010b,00111010b
		DB	00101110b,01000000b,00100001b,01111001b,00110010b
		DB	00010000b,00000100b,00000000b,00000000b,00000110b
		DB	00010011b,11111111b,11111111b,11111111b,11111010b
		DB	00010011b,11111110b,00001000b,00000000b,01111001b
		DB	00010011b,11111110b,00001010b,11011110b,00111010b
		DB	01010011b,11111111b,11111011b,10101000b,00011010b
		DB	00110011b,11111111b,11111010b,00010110b,10011000b
		DB	00010011b,11111111b,11111011b,00101100b,00001010b
		DB	00000011b,11111111b,11111000b,00000111b,11101001b
		DB	00010011b,11111110b,00001000b,10010100b,11101011b
		DB	00100011b,11111110b,00001011b,11101000b,01101000b
		DB	00101011b,11111110b,00001000b,01110100b,00101011b
		DB	00001011b,11111111b,11111000b,10010010b,01111001b
		DB	10110011b,11111111b,11111000b,00110000b,01111011b
		DB	00010011b,11111111b,11111001b,10111000b,01111001b
		DB	00101011b,10111110b,00001010b,00001000b,00001000b
		DB	00010011b,11111110b,00001001b,11001000b,11101010b
		DB	00000011b,11111111b,11111001b,00111111b,11101001b
		DB	01101011b,11111111b,11111000b,10000111b,11101010b
		DB	00100011b,11111110b,00001000b,10000110b,10101001b
		DB	00000011b,11111110b,00001011b,11110000b,00101000b
		DB	00000011b,11111111b,11111000b,01110000b,00101011b
		DB	00110011b,11111110b,00001000b,00000000b,00001000b
		DB	00010011b,11111110b,00001000b,00111100b,00001001b
		DB	01000011b,11111111b,11111111b,11111111b,11111000b
		DB	01100000b,00000000b,00000010b,00000000b,00000010b
		DB	10010001b,00000101b,00101001b,00000010b,00100001b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000011b,11100010b,00001111b,11111111b,11111000b
		DB	00000011b,00000011b,11111000b,00000000b,00001000b
		DB	00000010b,00000011b,11111001b,00000000b,10001000b
		DB	00000010b,00000010b,00001000b,00000000b,00001000b
		DB	00000010b,00000010b,00001000b,00000000b,11001000b
		DB	00000010b,00000010b,00001000b,01100000b,00001000b
		DB	00000010b,00000010b,00001000b,00010000b,00001000b
		DB	00000010b,00000011b,11111000b,00000000b,00001000b
		DB	00000010b,00000011b,11111000b,00000001b,01001000b
		DB	00000010b,00000011b,11111000b,00000000b,00001000b
		DB	00000010b,01000010b,00001010b,10000000b,00001000b
		DB	00000010b,01000010b,00001000b,00000100b,10001000b
		DB	00000010b,01000010b,00001000b,00000000b,00001000b
		DB	00000010b,01000001b,11110000b,00100001b,00001000b
		DB	00000010b,01000011b,11111000b,01000000b,00001000b
		DB	00000010b,01000010b,00001000b,00000000b,00001000b
		DB	00000010b,00000010b,00001010b,01000000b,00001000b
		DB	00000010b,00000011b,11111000b,00000100b,01001000b
		DB	00000010b,00000011b,11111000b,00000001b,00001000b
		DB	00000010b,00000010b,00001000b,00000000b,01001000b
		DB	00000010b,00000011b,11111000b,10000000b,00001000b
		DB	00000010b,00000011b,11111000b,00111100b,00001000b
		DB	00000011b,11111111b,11111111b,11111100b,00111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_20		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000111b,11011111b,11101100b,00000000b
		DB	00000011b,00000100b,00000000b,00000100b,00000000b
		DB	00000101b,00000100b,01001111b,01010100b,00000000b
		DB	00001101b,00000101b,10111110b,10010100b,00110000b
		DB	00001000b,00000100b,10111000b,10000100b,00010000b
		DB	00001001b,00000000b,11101111b,10100100b,00110000b
		DB	00000110b,00000100b,01111010b,10001100b,00100000b
		DB	00000101b,00000100b,10001011b,10001100b,00100000b
		DB	00001100b,00000000b,10100010b,10100000b,00100000b
		DB	00000000b,00000100b,11111100b,11101100b,00100000b
		DB	00001110b,00000100b,11111100b,01000100b,00100000b
		DB	00000110b,00000000b,10010000b,11000000b,00100000b
		DB	00000000b,00000101b,01011101b,01011100b,00100000b
		DB	00000000b,00000101b,01111000b,01000100b,00100000b
		DB	00000010b,00000101b,11000111b,11000100b,01000000b
		DB	00000101b,00000111b,10111011b,10111100b,01000000b
		DB	00000010b,00000000b,00000000b,00000000b,00100000b
		DB	00000101b,00000000b,00000000b,00000000b,00100000b
		DB	00000110b,00000000b,00000000b,00000000b,00100000b
		DB	00000100b,00000000b,00000000b,00000000b,00100000b
		DB	00000000b,00000000b,00000000b,00000000b,00100000b
		DB	00000010b,00001111b,10000001b,11000011b,11100000b
		DB	00000001b,11111000b,11111001b,00100010b,01000000b
		DB	00000000b,00000000b,00000000b,00011100b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00111111b,11100111b,11011111b,11101100b,00000000b
		DB	00100000b,00100100b,00000000b,00000100b,11111000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100000b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100000b,00000000b,00000000b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100000b,00000000b,00000000b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100100b,00000000b,00000100b,10001000b
		DB	00100000b,00100111b,10111011b,10111100b,10001000b
		DB	00100000b,00100000b,00000000b,00000000b,10001000b
		DB	00100000b,00100000b,00000000b,00000000b,10001000b
		DB	00100000b,00100000b,00000000b,00000000b,10001000b
		DB	00100000b,00111111b,11111111b,11111111b,10001000b
		DB	00100000b,00000000b,00000000b,00000000b,00001000b
		DB	00100000b,00000000b,00000000b,00000000b,00001000b
		DB	00100000b,00000000b,00000000b,00000000b,00001000b
		DB	00100000b,00000000b,00000000b,00000000b,00001000b
		DB	00111111b,11111111b,11111111b,11111111b,11111000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_21		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00000000b,00000000b,00100001b,00000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000010b,01000000b,01010000b,00100000b,00000000b
		DB	00000100b,00000010b,00001000b,00000000b,00000000b
		DB	00011000b,00000100b,00001001b,00000001b,00100000b
		DB	00100001b,00000100b,00000000b,00000000b,00000000b
		DB	00000100b,00000101b,00100000b,00000000b,00000000b
		DB	00000000b,00001000b,00000000b,00000010b,00000000b
		DB	00000000b,00010000b,00000000b,00111110b,00000000b
		DB	00000000b,00100010b,01000010b,00000001b,00100000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00001000b,01000000b
		DB	00000000b,00000001b,00000000b,00000000b,00000000b
		DB	00000000b,10000000b,00000000b,00000001b,00010000b
		DB	00000000b,00000000b,00010000b,00000000b,10000000b
		DB	00010000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00100000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000001b,00000000b,00000000b
		DB	00000001b,00100000b,01000000b,00000001b,00000000b
		DB	00000000b,00100001b,01000100b,00001001b,00000000b
		DB	00010000b,00100100b,00001000b,00000001b,00000000b
		DB	00000000b,00100000b,00110000b,00000000b,10010000b
		DB	00000000b,00010000b,00000000b,00100000b,01000000b
		DB	00000010b,01001000b,10000000b,00100001b,00100000b
		DB	00000000b,00001000b,00000000b,00000000b,00001000b
		DB	00000010b,00001000b,10000010b,00000001b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,00000000b,00010010b,00000000b,00000000b
		DB	00000100b,00000010b,00001000b,00000000b,00000000b
		DB	00011000b,00001100b,00001000b,00000000b,00000000b
		DB	00100000b,00000100b,00000000b,00010000b,00000000b
		DB	00000000b,00010100b,00000000b,00000000b,00000000b
		DB	00000000b,00001000b,00000000b,00000000b,00000000b
		DB	00000000b,00010000b,00000000b,00111110b,00000000b
		DB	00000000b,10100100b,00000000b,00000001b,00000000b
		DB	00000000b,00000000b,00001000b,00000001b,00000000b
		DB	00000000b,00000000b,00000010b,00000000b,01000000b
		DB	00000010b,00000000b,00100000b,00100000b,00000000b
		DB	00000000b,00000000b,00000000b,01000000b,00000000b
		DB	00000000b,10000000b,10000000b,00010000b,00000000b
		DB	00000000b,00000000b,00000000b,10001000b,00000000b
		DB	00000010b,00000100b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,10000000b,00000000b
		DB	00000000b,00100000b,00000000b,00000001b,00010000b
		DB	00000000b,00100000b,00000101b,00000001b,00000000b
		DB	00000000b,00100000b,00001000b,00000001b,00000000b
		DB	00000000b,00100100b,00110000b,00010000b,10000000b
		DB	00000000b,00010100b,00000000b,00000000b,01000000b
		DB	00000000b,00001000b,00000000b,00000000b,00100000b
		DB	00000000b,00001000b,00000000b,00000000b,00000000b
		DB	00000000b,00001000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_22		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000111b,11111111b,11110000b
		DB	00001000b,00000111b,00000111b,11111111b,11110000b
		DB	00001000b,00001111b,10000110b,00000000b,00110000b
		DB	00000000b,00011000b,11000110b,00000000b,00110000b
		DB	00000000b,00110000b,01100110b,01111100b,00110000b
		DB	00000000b,01100000b,00110110b,01000100b,00110000b
		DB	00000000b,11000000b,00011110b,01000100b,00110000b
		DB	00000001b,10000000b,00001110b,01000100b,00110000b
		DB	00000011b,00001111b,10000110b,01111100b,00110000b
		DB	00000110b,00001111b,10000110b,00000000b,00110000b
		DB	00000110b,00001111b,10000110b,00000000b,00110000b
		DB	00000110b,00001111b,10000110b,00000000b,00110000b
		DB	00000011b,00001111b,10000110b,00000000b,00110000b
		DB	00000001b,10000000b,00001110b,00000000b,00110000b
		DB	00000000b,11000000b,00011110b,00000011b,10110000b
		DB	00000000b,01100000b,00110110b,00000011b,10110000b
		DB	00000000b,00110000b,01100110b,00000011b,10110000b
		DB	00000000b,00011000b,11000110b,00000000b,00110000b
		DB	00000000b,00001111b,10000110b,00000000b,00110000b
		DB	00000000b,00000111b,00000110b,00000000b,00110000b
		DB	00111111b,00000000b,00000111b,11111111b,11110000b
		DB	00110011b,00000000b,00000111b,11111111b,11110000b
		DB	00110011b,00000000b,00000000b,00000000b,00000000b
		DB	00110011b,00000000b,00000000b,00000000b,00000000b
		DB	00111111b,00000000b,00111111b,11111000b,00000000b
		DB	00111111b,00000000b,00111111b,11111000b,00000000b
		DB	00000000b,00000000b,00111111b,11111000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00011100b,00000000b,00000111b,11111101b,11110100b
		DB	00010100b,00000101b,00000111b,11111101b,11110100b
		DB	00010100b,00001101b,10000110b,00000000b,00110100b
		DB	00011100b,00011000b,11000110b,00000000b,00110100b
		DB	00000000b,00110000b,01100110b,00000000b,00110100b
		DB	00000000b,01100000b,00110110b,00111000b,00110100b
		DB	00000000b,11000000b,00011110b,00111000b,00110100b
		DB	00000001b,10011111b,11001110b,00111000b,00110100b
		DB	00000011b,00010000b,01000110b,00000000b,00110100b
		DB	00000110b,00010000b,01000110b,00000000b,00110100b
		DB	00000000b,00010000b,01000000b,00000000b,00110100b
		DB	00000110b,00010000b,01000110b,00000000b,00110100b
		DB	00000011b,00010000b,01000110b,00000000b,00110100b
		DB	00000001b,10011111b,11001110b,00000111b,11110100b
		DB	00000000b,11000000b,00011110b,00000100b,01110100b
		DB	00000000b,01100000b,00110110b,00000100b,01110100b
		DB	00000000b,00110000b,01100110b,00000100b,01110100b
		DB	00000000b,00011000b,11000110b,00000111b,11110100b
		DB	00000000b,00001101b,10000110b,00000000b,00110100b
		DB	00000000b,00000101b,00000110b,00000000b,00110100b
		DB	00100000b,00000000b,00000111b,11101111b,11110100b
		DB	00101100b,00000000b,00000111b,11101111b,11110100b
		DB	00101100b,00000000b,00000000b,00000000b,00000000b
		DB	00101100b,00000000b,00000000b,00000000b,00000000b
		DB	00100000b,00000000b,00000000b,00000000b,00000000b
		DB	00111111b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_23		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00011100b,00000100b,00000000b,01010010b,00000000b
		DB	00000000b,00010000b,00000001b,00000000b,10100000b
		DB	00000000b,00000000b,00000000b,01000000b,00100000b
		DB	00000000b,00000000b,10000000b,00000000b,00000000b
		DB	00001011b,00111000b,00000000b,01000000b,00100000b
		DB	00000001b,01000010b,01111000b,00000001b,00000000b
		DB	00010001b,00010000b,00011000b,00000100b,00000000b
		DB	00000000b,00000000b,00001000b,00000000b,00100000b
		DB	00000101b,11011010b,00010010b,00000000b,10000000b
		DB	00000100b,11010000b,00001000b,01000000b,10000000b
		DB	00000000b,10110000b,00000001b,00000000b,00001000b
		DB	00000000b,00000000b,00100000b,00000010b,00101000b
		DB	00000000b,10110010b,00000010b,01110110b,00000000b
		DB	00010000b,00000011b,10000100b,10000110b,00100000b
		DB	00000000b,00100100b,10010010b,00001110b,00010000b
		DB	00010000b,10000100b,00001000b,00000010b,01110000b
		DB	00000010b,00000000b,10000100b,00000000b,00110000b
		DB	00000001b,00000000b,10000000b,00000001b,10000000b
		DB	00001001b,00000000b,01000110b,00100100b,00010000b
		DB	00001000b,00001000b,10000010b,10000000b,00000000b
		DB	00010100b,01000000b,00000000b,00000100b,10100000b
		DB	00000111b,00000010b,00000000b,01000000b,00001000b
		DB	00000001b,00100000b,00100000b,00010000b,11111000b
		DB	00000011b,00000000b,00010111b,11000000b,00110000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000001b,10000000b,00000001b,00000001b,00000000b
		DB	00011110b,11000100b,01110111b,00000000b,00000000b
		DB	00000110b,10010010b,11010001b,01001001b,01000000b
		DB	00011010b,01100101b,00100000b,00000000b,10000000b
		DB	00010110b,10000000b,00100101b,00010000b,00000000b
		DB	00000000b,00010010b,00000100b,00000010b,10000000b
		DB	00000110b,10000010b,10000000b,00000001b,11000000b
		DB	00001001b,00011011b,00010100b,00000100b,00000000b
		DB	00000010b,00100000b,11000010b,01100000b,00000000b
		DB	00000100b,00111010b,00010010b,00000000b,10100000b
		DB	00010100b,00010100b,01010000b,00100100b,10000000b
		DB	00000000b,00100101b,00010110b,00000010b,00001000b
		DB	01010000b,01000000b,00101011b,00000001b,00001000b
		DB	01000000b,01100000b,00000000b,00100001b,00100000b
		DB	00000100b,00000000b,00000000b,00000111b,00000000b
		DB	00000010b,00101000b,00011000b,00001001b,00010000b
		DB	00100000b,10100000b,01000100b,00000101b,00010000b
		DB	00000010b,00000000b,00010000b,00000011b,00110100b
		DB	00000000b,01000100b,01001000b,00010000b,10000000b
		DB	00101011b,01001010b,01000100b,00100001b,00000000b
		DB	00001000b,01001000b,10000010b,00000000b,00010100b
		DB	00100000b,11010000b,01010000b,11000000b,00000000b
		DB	00000000b,00010000b,00000000b,10000001b,00000000b
		DB	00001000b,00110000b,00000101b,10101000b,00000000b
		DB	00000000b,00011011b,11100010b,00000000b,00000000b
		DB	00100001b,00000000b,00000000b,00000000b,00000100b
		DB	01000000b,00010001b,10000100b,00000010b,10000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

LEV_24		DB	00000000b,00000000b,00000000b,00000001b,00000000b
		DB	00000000b,11100000b,00000010b,00000001b,10000000b
		DB	00110000b,11000111b,11000100b,00100000b,00010000b
		DB	00100000b,00100011b,00000000b,00000000b,00000000b
		DB	00000000b,11000100b,00000001b,00000000b,00000000b
		DB	00001100b,01000000b,00000010b,00010100b,00010000b
		DB	00000000b,01000000b,00000000b,00000000b,00110000b
		DB	00100000b,01000000b,00000010b,00000100b,01100010b
		DB	00100000b,01000000b,00000010b,00000000b,01000010b
		DB	00100000b,01110000b,00100100b,00100010b,01000010b
		DB	00100000b,00111000b,00100000b,00000000b,10000000b
		DB	00000000b,00011100b,01110000b,00000001b,10000010b
		DB	00000000b,00011000b,10000000b,00100011b,00001010b
		DB	00000000b,00010001b,00000100b,00000110b,00000010b
		DB	00100000b,01010000b,00000100b,00001110b,01000000b
		DB	00100001b,11011000b,00000010b,00011110b,10000000b
		DB	00010000b,10001111b,00000000b,00111000b,01000010b
		DB	00011010b,00001011b,01000111b,10111000b,00000000b
		DB	00000000b,00000111b,01001111b,11111100b,00000010b
		DB	00100011b,11111111b,11101110b,01100110b,00000000b
		DB	01000110b,10110010b,01110000b,00000010b,00000001b
		DB	00001000b,10000000b,00000100b,00000011b,00000000b
		DB	00011000b,00000000b,00000000b,00010001b,10000000b
		DB	00010001b,00000001b,00010000b,01000000b,10000000b
		DB	01000001b,00000000b,00010000b,00000010b,00110001b
		DB	00100001b,00000001b,00010000b,00000000b,00110001b
		DB	00000110b,00000000b,00000100b,00000000b,10000001b
		DB	00000000b,00000000b,00000101b,10000100b,00000011b
		DB	00000000b,00000000b,00000000b,00000000b,00001110b

		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00001100b,00000000b,00000000b,00000000b,00000000b
		DB	00001000b,00000000b,00100000b,00000000b,00000000b
		DB	00000000b,01000000b,00000000b,10000000b,00010000b
		DB	00001000b,01000000b,00100000b,01000000b,00110000b
		DB	00001000b,01000100b,00000000b,01000000b,01100000b
		DB	00000000b,01000101b,00000000b,00000000b,01000000b
		DB	00000100b,01110000b,00000000b,01000000b,01000000b
		DB	00000100b,00011000b,00000000b,01000000b,10000000b
		DB	00000100b,00001000b,00000000b,01000001b,10100000b
		DB	00000110b,00011000b,00000000b,10000011b,00010000b
		DB	00000000b,00010000b,00100000b,10000010b,00010000b
		DB	00001000b,00010000b,00110000b,00000010b,00000000b
		DB	00001000b,00011000b,00000000b,00001110b,00010000b
		DB	00000000b,00001110b,00000000b,00001000b,00000000b
		DB	00000000b,00000010b,00000000b,00111000b,00010000b
		DB	00000000b,00000011b,00000111b,11101100b,00010000b
		DB	00000011b,11111111b,11001100b,00000110b,00000000b
		DB	00000110b,00000000b,01110000b,00000010b,00010000b
		DB	00001000b,00000000b,00000000b,11100011b,00000000b
		DB	00011000b,01111000b,00000000b,00000001b,10000000b
		DB	00010000b,00000000b,01000100b,00000000b,10000000b
		DB	00000000b,00110000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,11100000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
		DB	00000000b,00000000b,00000000b,00000000b,00000000b
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


LEVEL_SEG	ENDS


;***************************************************************


DSEG	SEGMENT 'DATA'

; some text (instructions), first byte is the color:
s_inst	DB	86, '                                        ', 0
	DB	46, '              FIRING SNAKE              ', 0
	DB	86, '                                        ', 0
	DB	86, '                                        ', 0
	DB	14, '        use CURSOR KEYS to move         ', 0
	DB	14, '                                        ', 0
	DB	14, '     CTRL to fire, ALT to speed up      ', 0
	DB	86, '                                        ', 0
	DB	14, '          P - pauses the game           ', 0
	DB	86, '                                        ', 0
	DB	86, '                                        ', 0
	DB	86, '                                        ', 0
	DB	46, '     COLLECT APPLES, AVOID CRASHING     ', 0
	DB	46, '                                        ', 0
	DB	46, '     INTO MINES, STONES AND YOURSELF    ', 0
	DB	86, '                                        ', 0
	DB	46, '                                        ', 0
	DB	86, '                                        ', 0
	DB	11, '     press ANY KEY to start the game    ', 0
	DB	15, '                                        ', 0
	DB	11, '      press ESC at any time to exit     ', 0
	DB	86, '                                        ', 0
	DB	86, '                                        ', 0
	DB	46, '   THIS GAME AND SOURCE CODE ARE FREE   ', 0
	DB	46, '                                        ', 0
	DB	46, '       COPYRIGHT [ 2002 BY MYSOFT       ', 0
	DB	46, '                                        ', 0
	DB	86, '                                        ', 0
	DB	15, '       http://mysoft.s5.com/snake/      ', 0
	DB	86, '                                        ', 0

; key constants (indexes):
KEY_ESC		EQU	1
KEY_CTRL	EQU	29
KEY_UP		EQU	72
KEY_DOWN	EQU	80
KEY_LEFT	EQU	75
KEY_RIGHT	EQU	77
KEY_SPACE	EQU	57
KEY_ENTER	EQU	28
KEY_LSHIFT	EQU	42
KEY_RSHIFT	EQU	54
KEY_ALT		EQU	56
KEY_P		EQU	25

MAX_SIZE	EQU	1160	; (40*29)
MIN_SIZE	EQU	2

; 1-left, 2-right, 3-up, 4-down, 0-no move!
new_direction	DB	0	; keeps direction (user command) - sets to cur_direction when timer allows.
cur_direction	DB	0	; keeps current snake direction.
start_direction	DB	0	; keeps the starting direction of the snake (first move) - used to replace tail when game/level starts.
; direction constants:
LEFT		EQU	1
RIGHT		EQU	2
UP		EQU	3
DOWN		EQU	4

level		DW	?
lives		DW	?

apples_to_eat	DW	?	; the number of apples snake should eat before going to the next level.

score_l		DW	?	; the game score counter
score_h		DW	?	; (two words used - allowed score up to 4 billion... though this cannot be printed:)
mWRD		DW	?	; used as a parameter (to add points to the score and for multiplication).

s_status	DB	'  SCORE:######    LEVEL:###   LIVES:##  ', 0
s_press_space	DB	'PRESS SPACE TO CONTINUE', 0
s_level_compl	DB	'LEVEL COMPLETE!', 0
s_oops		DB	'OOPS...', 0
s_game_over	DB	'GAME OVER', 0
s_thank_you	DB	'Thanks for playing Firing Snake!    (version 1.01)',13,10,13,10
		DB	'Firing Snake on the Net:',13,10,13,10
		DB	'           http://mysoft.s5.com/snake/',13,10,13,10,13,10,'$'
s_paused	DB	' GAME PAUSED!  PRESS SPACE TO CONTINUE  ', 0

s_buffer	DB	50 DUP(?)	; temporary string

s_last_level	DB	46, '                                        ', 0
		DB	46, '                                        ', 0
		DB	86, '                                        ', 0
		DB	11, '            CONGRATULATIONS!            ', 0
		DB	14, '                                        ', 0
		DB	86, '                                        ', 0
		DB	14, '     YOU MADE IT THROUGH ALL LEVELS     ', 0
		DB	86, '                                        ', 0
		DB	86, '                                        ', 0
		DB	15, '         YOUR SCORE:                    ', 0
		DB	86, '                                        ', 0
		DB	15, '       VALIDATION CODE:                 ', 0
		DB	86, '                                        ', 0
		DB	46, '                                        ', 0
		DB	14, '                                        ', 0
		DB	46, '      CHECK FOR NEW LEVELS HERE:        ', 0
		DB	46, '                                        ', 0
		DB	15, '       http://mysoft.s5.com/snake/      ', 0
		DB	86, '                                        ', 0
		DB	46, '    AND SEE HOW YOU STACK UP AGAINST    ', 0
		DB	86, '                                        ', 0
		DB	46, '  SNAKE PLAYERS FROM AROUND THE GLOBE!  ', 0
		DB	86, '                                        ', 0
		DB	86, '                                        ', 0
		DB	46, '                                        ', 0
		DB	86, '                                        ', 0
		DB	38, '        PRESS SPACE TO CONTINUE         ', 0
		DB	46, '                                        ', 0
		DB     103, '       COPYRIGHT [ 2002 BY MYSOFT       ', 0
		DB	86, '                                        ', 0

s_nice_try	DB	46, '                                        ', 0
		DB	46, '                                        ', 0
		DB	86, '                                        ', 0
		DB	35, '               NICE TRY!                ', 0
		DB	14, '                                        ', 0
		DB	86, '                                        ', 0
		DB	35, '          THANKS FOR PLAYING!           ', 0
		DB	86, '                                        ', 0
		DB	86, '                                        ', 0
		DB	15, '         YOUR SCORE:                    ', 0
		DB	86, '                                        ', 0
		DB	15, '       VALIDATION CODE:                 ', 0
		DB	86, '                                        ', 0
		DB	46, '                                        ', 0
		DB	14, '                                        ', 0
		DB	46, '      CHECK FOR NEW LEVELS HERE:        ', 0
		DB	46, '                                        ', 0
		DB	15, '       http://mysoft.s5.com/snake/      ', 0
		DB	86, '                                        ', 0
		DB	46, '    AND SEE HOW YOU STACK UP AGAINST    ', 0
		DB	86, '                                        ', 0
		DB	46, '  SNAKE PLAYERS FROM AROUND THE GLOBE!  ', 0
		DB	86, '                                        ', 0
		DB	86, '                                        ', 0
		DB	46, '                                        ', 0
		DB	86, '                                        ', 0
		DB	38, '        PRESS SPACE TO CONTINUE         ', 0
		DB	46, '                                        ', 0
		DB     103, '       COPYRIGHT [ 2002 BY MYSOFT       ', 0
		DB	86, '                                        ', 0


; starting point for a snake (its head):
DEFAULT_X	EQU	0
DEFAULT_Y	EQU	12

; snake size is doubled of the actual size because
; every part of the snake has 2 coordinates
snake_size	DW	? ; the size*2 of the snake (snake array)
; head coordinates are (snake[0], snake[1]),
snake		DB	MAX_SIZE DUP(?,?) ; the snake (from head to tail) [x,y]


; MAP CONSTANTS:
MINE_ID		EQU	7
BOMB_ID		EQU	2	; generated at run time!
SNAKE_ID	EQU	1	; generated at run time!
APPLE_ID	EQU	5
NOTHING_ID	EQU	0
STONE_ID	EQU	88

MAP_SIZE	EQU	1200	; 40*30 (first row is used for a status line).

; unlike level data game_map has an unused upper row (status) - this just helps in calculations:
game_map	DB	MAP_SIZE DUP (?)	; 40*30 = 1200		(40 bytes wasted:)

snake_wait	DW	0	; the timer for snake (when it gets less then current time then snake moves).
snake_w_hour	DW	0	; the hour of the timer for snake.

snake_skip_1_move	DB	0 ; snake skips one move when this set to '1'.

BOMB_MAX	EQU	10
bomb_count	DB	?			; number of currenlty flying bombs.
bomb_x		DB	BOMB_MAX DUP (?)	; left coordinate for a bomb.
bomb_y		DB	BOMB_MAX DUP (?)	; top coordinate for a bomb.
bomb_direction	DB	BOMB_MAX DUP (?)	; 1-left, 2-right, 3-up, 4-down, 0-no move (no bomb)!
bomb_visible	DB	BOMB_MAX DUP (?)	; used to know when it shouldn't be hidden.
bomb_wait	DW	BOMB_MAX DUP (?)	; the timer for bomb (when it gets less then current time then bomb moves).
bomb_w_hour	DW	BOMB_MAX DUP (?)	; the hour of the timer for bomb.
allow_bomb	DB	1	; flag - don't allow dropping all bombs on a single key press.

do_increase	DB	0	; should be set to 1 when required to increase the snake.


; for the keyboard:
Off_9		DW	?
Seg_9		DW	?
KB_Handler	DD	INT_9_REPLACER
KEYS		DB	128 DUP (0)	; array of KEYs, initialized.


; ------------ the struct for getting some VESA info (size of block 256 bytes):

; it seems that in 0x4F01 all pointers are 4 bytes, like in VC++ (not 2 bytes
; like in old C for DOS):
; for 0x4F01 - Return VBE mode information.

    ; Mandatory information for all VBE revisions
    ModeAttributes	DW	?	; mode attributes
    WinAAttributes	DB	?	; window A attributes
    WinBAttributes	DB	?	; window B attributes
    WinGranularity	DW	?	; window granularity
    WinSize		DW	?	; window size
    WinASegment		DW	?	; window A start segment
    WinBSegment		DW	?	; window B start segment
    WinFuncPtr		DD	?	; pointer to window function
    BytesPerScanLine	DW	?	; bytes per scan line

    ; Mandatory information for VBE 1.2 and above
    XResolution		DW	?	; horizontal resolution in pixels or chars
    YResolution		DW	?	; vertical resolution in pixels or chars
    XCharSize		DB	?	; character cell width in pixels
    YCharSize		DB	?	; character cell height in pixels
    NumberOfPlanes	DB	?	; number of memory planes
    BitsPerPixel	DB	?	; bits per pixel
    NumberOfBanks	DB	?	; number of banks
    MemoryModel		DB	?	; memory model type
    BankSize		DB	?	; bank size in KB
    NumberOfImagePages	DB	?	; number of images
    Reserved_1		DB	?	; reserved for page function

    ; Direct Color fields (required for direct/6 and YUV/7 memory models)
    RedMaskSize		DB	?	; size of direct color red mask in bits
    RedFieldPosition	DB	?	; bit position of lsb of red mask
    GreenMaskSize	DB	?	; size of direct color green mask in bits
    GreenFieldPosition	DB	?	; bit position of lsb of green mask
    BlueMaskSize	DB	?	; size of direct color blue mask in bits
    BlueFieldPosition	DB	?	; bit position of lsb of blue mask
    RsvdMaskSize	DB	?	; size of direct color reserved mask in bits
    RsvdFieldPosition	DB	?	; bit position of lsb of reserved mask
    DirectColorModeInfo	DB	?	; direct color mode attributes

    ; Mandatory information for VBE 2.0 and above
    PhysBasePtr		DD	?	; physical address for flat frame buffer
    OffScreenMemOffset	DD	?	; pointer to start of off screen memory
    OffScreenMemSize	DW	?	; amount of off screen memory in 1k units

    Reserved_2		DB	206	DUP (?)	; remainder of ModeInfoBlock

; ------------ end of the struct.

WH	EQU	16	; size of icon (WH * WH) - width and height.
mWHxWH	DW	WH*WH	; used in multiplication.
two	DW	2	; used as divider.
forty	DB	40	; used as muliplier.

; the stone:
STONE	DB        00,00,00,00,16,24,24,24,24,24,16,16,00,00,00,00
	DB        00,00,00,16,24,28,28,28,28,24,24,24,16,00,00,00
	DB        00,00,16,28,15,15,15,28,28,28,28,24,24,16,00,00
	DB        00,24,28,15,15,28,28,28,28,28,28,28,24,24,16,00
	DB        16,28,15,15,28,28,28,28,28,28,28,28,28,24,24,00
	DB        16,28,15,28,28,28,28,28,28,28,28,28,28,24,24,16
	DB        24,15,28,28,28,28,28,28,28,28,28,28,28,28,24,16
	DB        24,28,28,28,28,28,28,28,28,28,28,28,28,28,24,16
	DB        24,28,28,28,28,28,28,28,28,28,28,28,28,28,24,16
	DB        24,28,28,28,28,28,28,28,28,28,28,28,28,28,24,16
	DB        16,28,28,28,28,28,28,28,28,28,28,28,28,24,24,16
	DB        16,28,28,28,28,28,28,28,28,28,28,28,28,24,24,00
	DB        00,16,24,28,28,28,28,28,28,28,28,24,24,16,16,00
	DB        00,00,16,28,28,28,28,28,28,28,28,24,24,16,00,00
	DB        00,00,00,16,24,28,28,28,24,24,24,24,16,00,00,00
	DB        00,00,00,00,00,16,16,16,16,16,16,00,00,00,00,00

; the tile
TILE	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,09,09,09,01,01,01,01,01,01,01
	DB        01,01,01,01,01,09,01,01,01,16,01,01,01,01,01,01
	DB        01,01,01,01,01,09,01,01,01,16,01,01,01,01,01,01
	DB        01,01,01,01,01,09,01,01,01,16,01,01,01,01,01,01
	DB        01,01,01,01,01,01,16,16,16,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; the apple:
APPLE	DB        02,02,02,24,24,00,00,00,00,00,00,00,00,00,00,00
	DB        00,02,02,47,47,02,00,00,00,00,00,00,00,00,00,00
	DB        00,00,00,47,47,24,16,140,14,00,00,00,00,00,00,00
	DB        00,00,00,02,02,47,16,14,16,00,00,00,00,00,00,00
	DB        00,00,00,16,16,40,04,28,16,16,16,16,16,00,00,00
	DB        00,00,16,21,21,28,13,13,13,13,28,28,40,16,00,00
	DB        00,00,16,40,40,28,40,40,40,40,40,40,40,40,16,00
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,04,16
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,40,16
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,40,16
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,40,16
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,40,16
	DB        00,16,40,40,40,40,40,40,40,40,40,40,40,40,16,00
	DB        00,00,16,16,40,40,40,40,40,40,40,40,40,16,00,00
	DB        00,00,00,16,16,40,40,40,40,40,40,16,16,00,00,00
	DB        00,00,00,00,00,16,16,16,16,16,16,00,00,00,00,00

; the mine:
MINE	DB        00,00,00,00,00,24,00,00,00,00,00,24,24,00,00,00
	DB        00,00,00,00,00,24,24,00,00,00,24,31,24,00,00,00
	DB        00,00,00,00,00,24,31,40,40,24,24,31,24,00,00,00
	DB        00,00,00,00,24,40,24,40,40,40,28,24,24,00,00,00
	DB        00,24,24,40,40,40,40,40,40,40,40,40,40,00,00,00
	DB        24,31,28,24,40,40,40,24,28,40,40,40,40,00,00,00
	DB        00,24,28,24,40,40,40,24,31,24,40,40,40,24,24,24
	DB        00,24,40,40,40,40,40,40,40,40,40,40,40,31,24,00
	DB        00,24,40,40,24,31,24,40,24,40,40,40,40,40,00,00
	DB        00,24,40,40,40,24,40,40,31,24,40,40,40,40,00,00
	DB        24,31,24,40,40,40,40,40,24,24,40,40,40,40,00,00
	DB        24,31,24,40,40,40,40,40,40,24,40,24,24,24,00,00
	DB        00,24,00,40,40,40,24,40,40,40,24,28,31,24,00,00
	DB        00,00,00,00,00,24,28,40,40,40,00,24,31,24,00,00
	DB        00,00,00,00,00,24,24,40,40,00,00,00,24,24,00,00
	DB        00,00,00,00,00,24,00,00,00,00,00,00,00,00,00,00

; the bomb!
BOMB	DB        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	DB        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	DB        00,00,00,00,00,40,00,00,00,40,00,00,00,00,00,00
	DB        00,00,40,00,00,00,40,00,40,00,00,00,00,40,00,00
	DB        00,00,00,40,00,00,40,00,40,00,00,40,40,00,00,00
	DB        00,00,00,00,40,00,40,40,40,00,40,00,00,00,00,00
	DB        00,00,00,00,00,40,40,40,40,40,40,00,00,00,00,00
	DB        00,00,00,00,00,40,40,40,40,40,00,00,00,40,00,00
	DB        00,00,00,40,40,40,40,40,40,40,40,40,40,00,00,00
	DB        00,00,40,00,00,00,40,40,40,40,00,00,00,00,00,00
	DB        00,00,00,00,00,40,00,40,00,40,00,00,00,00,00,00
	DB        00,00,00,00,40,00,00,40,00,00,40,00,00,00,00,00
	DB        00,00,00,40,00,00,00,40,00,00,00,40,00,00,00,00
	DB        00,00,40,00,00,00,00,00,40,00,00,00,40,00,00,00
	DB        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
	DB        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00

; body left-top:
BODY_1	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; body right-top:
BODY_2	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,01,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; body left-bottom:
BODY_3	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,01,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01

; body right-bottom:
BODY_4	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01

; body left-right:
BODY_5	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; body top-bottom:
BODY_6	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01

; nose to the left:
HEAD_1	DB        00,00,00,00,00,40,40,40,40,40,40,40,00,00,00,00
	DB        00,00,00,00,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,40,40,40,40,40,40,47,47,47,47,40,40,40,40,40
	DB        00,40,40,40,40,40,40,02,47,47,47,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        00,40,40,40,40,40,40,02,47,47,47,40,40,40,40,40
	DB        00,40,40,40,40,40,40,47,47,47,47,40,40,40,40,40
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,00,00,00,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,00,00,00,40,40,40,40,40,40,40,00,00,00,00

; nose to the right:
HEAD_2	DB        00,00,00,00,40,40,40,40,40,40,40,00,00,00,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,00,00,00,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        40,40,40,40,40,47,47,47,47,40,40,40,40,40,40,00
	DB        40,40,40,40,40,47,47,47,02,40,40,40,40,40,40,00
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,47,47,40,40,40,40,40,40,40
	DB        40,40,40,40,40,47,47,47,02,40,40,40,40,40,40,00
	DB        40,40,40,40,40,47,47,47,47,40,40,40,40,40,40,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,00,00,00,00
	DB        00,00,00,00,40,40,40,40,40,40,40,00,00,00,00,00

; nose to up:
HEAD_3	DB        00,00,00,00,00,40,40,40,40,40,40,00,00,00,00,00
	DB        00,00,00,40,40,40,40,40,40,40,40,40,40,00,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,47,02,47,47,40,40,47,47,02,47,40,40,40
	DB        40,40,40,47,47,47,47,40,40,47,47,47,47,40,40,40
	DB        40,40,40,47,47,40,40,40,40,40,40,47,47,40,40,40
	DB        40,40,40,47,47,40,40,40,40,40,40,47,47,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,00,40,40,40,40,40,40,40,40,40,40,00,00,00

; nose to down:
HEAD_4	DB        00,00,00,40,40,40,40,40,40,40,40,40,40,00,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,47,47,40,40,40,40,40,40,47,47,40,40,40
	DB        40,40,40,47,47,40,40,40,40,40,40,47,47,40,40,40
	DB        40,40,40,47,47,47,47,40,40,47,47,47,47,40,40,40
	DB        40,40,40,47,02,47,47,40,40,47,47,02,47,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        00,40,40,40,40,40,40,40,40,40,40,40,40,40,40,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,40,40,40,40,40,40,40,40,40,40,40,40,00,00
	DB        00,00,00,40,40,40,40,40,40,40,40,40,40,00,00,00
	DB        00,00,00,00,00,40,40,40,40,40,40,00,00,00,00,00

; icon 16x16:
BLACK	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	DB	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16

; tail right
TAIL_1	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,01,01,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,01
	DB        40,40,40,40,40,40,40,40,40,40,40,40,01,01,01,01
	DB        40,40,40,40,40,40,40,40,40,01,01,01,01,01,01,01
	DB        40,40,40,40,40,40,40,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; tail bottom
TAIL_2	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,01,40,40,40,40,40,40,01,01,01,01,01
	DB        01,01,01,01,01,40,40,40,40,40,40,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; tail left
TAIL_3	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,40,40,40,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,40,40,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,01,01,40,40,40,40,40,40,40
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01

; tail top
TAIL_4	DB        01,01,01,01,01,01,01,01,01,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,01,40,40,01,01,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,01,40,40,40,40,01,01,01,01,01,01
	DB        01,01,01,01,01,40,40,40,40,40,40,01,01,01,01,01
	DB        01,01,01,01,01,40,40,40,40,40,40,01,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01
	DB        01,01,01,01,40,40,40,40,40,40,40,40,01,01,01,01

CURRENT_PAGE	DW	0	; current video page.


text_fore_color	DB	0
text_back_color DB	15

print_num_x	DB	?	; left position.
print_num_y	DB	?	; top position.
print_num_len	DB	?	; number of digits to be printed (for zeros before number).


; LETTERS ====================================================

; ' '
BLANK_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; !
EXCL_LETTER	DW        0000000000000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000000000000000b
		DW        0000001100000000b
		DW        0000001110000000b
		DW        0000000110000000b

; "
QMARKS_LETTER	DW        0000000000000000b
		DW        0000011001100000b
		DW        0000011001100000b
		DW        0000011001100000b
		DW        0000011001100000b
		DW        0000011001100000b
		DW        0000011001100000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; #
CROSS_LETTER	DW        0000000000000000b
		DW        0000001100011000b
		DW        0000001100011000b
		DW        0001111111111110b
		DW        0001111111111110b
		DW        0001111111111110b
		DW        0000011000110000b
		DW        0000011000110000b
		DW        0000110001100000b
		DW        0011111111111100b
		DW        0011111111111100b
		DW        0011111111111100b
		DW        0001100011000000b
		DW        0001100011000000b
		DW        0001100011000000b
		DW        0000000000000000b

; $
DOLLAR_LETTER	DW        0000001110000000b
		DW        0000001110000000b
		DW        0000011111100000b
		DW        0001111111110000b
		DW        0001111111110000b
		DW        0011101110000000b
		DW        0011101110000000b
		DW        0011111111100000b
		DW        0000111111110000b
		DW        0000001110111000b
		DW        0000001110111000b
		DW        0011111111111000b
		DW        0011111111110000b
		DW        0001111111100000b
		DW        0000001110000000b
		DW        0000001110000000b

; %
PERCENT_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0011100000110000b
		DW        0111110001110000b
		DW        1111111001100000b
		DW        1110111011100000b
		DW        1111111011000000b
		DW        0111111111000000b
		DW        0011101110000000b
		DW        0000001110111000b
		DW        0000011101111100b
		DW        0000011011111110b
		DW        0000111011101110b
		DW        0000110011111110b
		DW        0001110011111100b
		DW        0001100001111000b

; &
AND_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000111100000b
		DW        0000001111110000b
		DW        0000011111110000b
		DW        0000011101110000b
		DW        0000011111100000b
		DW        0000011111000000b
		DW        0000111111111000b
		DW        0001110111111000b
		DW        0011100011111000b
		DW        0011100011111000b
		DW        0011100001110000b
		DW        0011111111111000b
		DW        0001111111111100b
		DW        0000111110011100b

; '
QMARK_LETTER	DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; (
BOPEN_LETTER	DW        0000000011000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000001100000000b
		DW        0000001110000000b
		DW        0000000111000000b
		DW        0000000011000000b

; )
BCLOSE_LETTER	DW        0000001100000000b
		DW        0000001110000000b
		DW        0000000111000000b
		DW        0000000011000000b
		DW        0000000011000000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000011000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001100000000b

; *
STAR_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000111111111000b
		DW        0000111111111000b
		DW        0000011111100000b
		DW        0000011111100000b
		DW        0000111111110000b
		DW        0000110001110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; +
PLUS_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

;
COMMA_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000011000000b
		DW        0000000111000000b
		DW        0000000110000000b
		DW        0000001110000000b
		DW        0000001100000000b

; -
MINUS_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011111100000b
		DW        0000011111100000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; .
DOT_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000000000000000b

; /
SLASH_LETTER	DW        0000000000000000b
		DW        0000000000011000b
		DW        0000000000111000b
		DW        0000000000110000b
		DW        0000000001110000b
		DW        0000000001110000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000111000000b
		DW        0000000110000000b
		DW        0000001110000000b
		DW        0000001100000000b
		DW        0000011100000000b
		DW        0000011000000000b
		DW        0000111000000000b
		DW        0000110000000000b

; 0
ZERO_LETTER	DW        0000000000000000b
		DW        0000001111000000b
		DW        0000011111100000b
		DW        0000111111110000b
		DW        0000111001111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0000111001110000b
		DW        0000111111110000b
		DW        0000011111100000b
		DW        0000001111000000b

; 1
ONE_LETTER	DW        0000000000000000b
		DW        0000000111000000b
		DW        0000001111000000b
		DW        0000111111000000b
		DW        0000111111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000111111111000b
		DW        0000111111111000b
		DW        0000111111111000b
		DW        0000000000000000b

; 2
TWO_LETTER	DW        0000000000000000b
		DW        0000001111100000b
		DW        0000011111110000b
		DW        0000111111111000b
		DW        0001111000111000b
		DW        0001100000111000b
		DW        0000000001110000b
		DW        0000000011110000b
		DW        0000001111000000b
		DW        0000111100000000b
		DW        0000111000000000b
		DW        0001110000000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001111111111000b
		DW        0000000000000000b

; 3
THREE_LETTER	DW        0000000000000000b
		DW        0000001111100000b
		DW        0000011111110000b
		DW        0000111111111000b
		DW        0000110000111000b
		DW        0000000001111000b
		DW        0000001111111000b
		DW        0000001111110000b
		DW        0000001111110000b
		DW        0000000001111000b
		DW        0000000000111000b
		DW        0000110000111000b
		DW        0000111001111000b
		DW        0000111111111000b
		DW        0000011111110000b
		DW        0000001111100000b

; 4
FOUR_LETTER	DW        0000000000000000b
		DW        0000000001110000b
		DW        0000000011110000b
		DW        0000000011110000b
		DW        0000000111110000b
		DW        0000001101110000b
		DW        0000011001110000b
		DW        0000110001110000b
		DW        0001111111111000b
		DW        0011111111111100b
		DW        0011111111111000b
		DW        0000000001110000b
		DW        0000000001110000b
		DW        0000000001110000b
		DW        0000000001110000b
		DW        0000000000100000b

; 5
FIVE_LETTER	DW        0000000000000000b
		DW        0001111111111000b
		DW        0001111111111000b
		DW        0001111111110000b
		DW        0001110000000000b
		DW        0001111111100000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001110000111000b
		DW        0000000000111000b
		DW        0000000000111000b
		DW        0001100000111000b
		DW        0001110001111000b
		DW        0001111111110000b
		DW        0000111111100000b
		DW        0000011111000000b

; 6
SIX_LETTER	DW        0000000000000000b
		DW        0000000111100000b
		DW        0000000111100000b
		DW        0000001111000000b
		DW        0000011100000000b
		DW        0000111000000000b
		DW        0000111111100000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001111001111000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000001111000000b

; 7
SEVEN_LETTER	DW        0000000000000000b
		DW        0001111111111100b
		DW        0001111111111100b
		DW        0001111111111000b
		DW        0000000000110000b
		DW        0000000001110000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000011110000000b
		DW        0000011100000000b
		DW        0000011100000000b
		DW        0000000000000000b

; 8
EIGHT_LETTER	DW        0000000000000000b
		DW        0000001111000000b
		DW        0000011111100000b
		DW        0000111111110000b
		DW        0000111001110000b
		DW        0000111001110000b
		DW        0000111111110000b
		DW        0000011111100000b
		DW        0000111111110000b
		DW        0001111001111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001111111111000b
		DW        0000111111110000b
		DW        0000011111000000b

; 9
NINE_LETTER	DW        0000000000000000b
		DW        0000001111000000b
		DW        0000111111110000b
		DW        0001111111110000b
		DW        0001110001111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001111111111000b
		DW        0000111111111000b
		DW        0000011111110000b
		DW        0000000001110000b
		DW        0000000011100000b
		DW        0000001111000000b
		DW        0000111110000000b
		DW        0000111000000000b
		DW        0000000000000000b

; :
COLON_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000000000000000b
; ;
SEMICOL_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000011000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001100000000b
		DW        0000000000000000b

; <
LESS_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000011000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000011100000000b
		DW        0000111000000000b
		DW        0000011100000000b
		DW        0000001110000000b
		DW        0000000111000000b
		DW        0000000011000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; =
EQUAL_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; >
MORE_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001100000000b
		DW        0000001110000000b
		DW        0000000111000000b
		DW        0000000011100000b
		DW        0000000001110000b
		DW        0000000011100000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001100000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; ?
QUESTION_LETTER	DW        0000000000000000b
		DW        0000001111100000b
		DW        0000011111110000b
		DW        0000111111111000b
		DW        0000111000111100b
		DW        0000000000011100b
		DW        0000000000011100b
		DW        0000000001111000b
		DW        0000000111110000b
		DW        0000001111000000b
		DW        0000001110000000b
		DW        0000000000000000b
		DW        0000001100000000b
		DW        0000011100000000b
		DW        0000011100000000b
		DW        0000000000000000b

; @
AT_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011111000000b
		DW        0001111111110000b
		DW        0011100000111000b
		DW        0011001110011100b
		DW        0110011100001100b
		DW        0110110011001100b
		DW        0110110111001100b
		DW        0110111111111100b
		DW        0110011101111000b
		DW        0011000000000000b
		DW        0011100001100000b
		DW        0001111111100000b
		DW        0000011111000000b
		DW        0000000000000000b

; A
A_LETTER	DW        0000000000000000b
		DW        0000000001100000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000111100000b
		DW        0000001111110000b
		DW        0000001101110000b
		DW        0000011101110000b
		DW        0000011001110000b
		DW        0000111111111000b
		DW        0001111111111000b
		DW        0001111111111000b
		DW        0001100000111000b
		DW        0011100000011100b
		DW        0011000000011100b
		DW        0011000000001100b

; B
B_LETTER	DW        0000000000000000b
		DW        0000111111000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0001111111110000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001110000111100b
		DW        0001110000011100b
		DW        0001110000011100b
		DW        0001110001111100b
		DW        0001111111111000b
		DW        0001111111110000b
		DW        0001111110000000b

; C
C_LETTER	DW        0000000000000000b
		DW        0000000011111100b
		DW        0000000111111100b
		DW        0000001111111100b
		DW        0000011110001100b
		DW        0000011100000000b
		DW        0000111100000000b
		DW        0000111000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000001100b
		DW        0001111000111100b
		DW        0000111111111100b
		DW        0000011111110000b
		DW        0000001111100000b

; D
D_LETTER	DW        0000000000000000b
		DW        0011100000000000b
		DW        0011111000000000b
		DW        0011111111000000b
		DW        0011101111100000b
		DW        0011100011110000b
		DW        0011100000111000b
		DW        0011100000111100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000111100b
		DW        0011100001111000b
		DW        0011111111111000b
		DW        0011111111110000b
		DW        0000111111000000b

; E
E_LETTER	DW        0000000000000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001111111110000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001111111110000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0000111111110000b

; F
F_LETTER	DW        0000000000000000b
		DW        0001111111111000b
		DW        0001111111111100b
		DW        0001111111111000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001111111110000b
		DW        0001111111111000b
		DW        0001111111110000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0001110000000000b
		DW        0000100000000000b

; G
G_LETTER	DW        0000000000000000b
		DW        0000000111110000b
		DW        0000001111111000b
		DW        0000011111111100b
		DW        0000111100011100b
		DW        0000111000000000b
		DW        0001110000000000b
		DW        0001110011111110b
		DW        0011101111111110b
		DW        0011101111111100b
		DW        0011100000011100b
		DW        0011100000111000b
		DW        0011100001111000b
		DW        0011111111110000b
		DW        0001111111100000b
		DW        0000111110000000b

; H
H_LETTER	DW        0000000000000000b
		DW        0001000000000100b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011111111111110b
		DW        0011111111111110b
		DW        0011111111111110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0011100000001110b
		DW        0001000000000100b

; I
I_LETTER	DW        0000000000000000b
		DW        0000011111110000b
		DW        0000111111111000b
		DW        0000011111110000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000011111110000b
		DW        0000111111111000b
		DW        0000011111110000b

; J
J_LETTER	DW        0000000000000000b
		DW        0000011111111000b
		DW        0000111111111100b
		DW        0000011111111000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0000000011100000b
		DW        0001000011100000b
		DW        0011100011100000b
		DW        0011110011100000b
		DW        0001111111100000b
		DW        0000111111100000b
		DW        0000001111000000b

; K
K_LETTER	DW        0000000000000000b
		DW        0000100000011000b
		DW        0001110000111000b
		DW        0001110001110000b
		DW        0001110011100000b
		DW        0001110111100000b
		DW        0001111111000000b
		DW        0001111110000000b
		DW        0001111100000000b
		DW        0001111100000000b
		DW        0001111110000000b
		DW        0001110111100000b
		DW        0001110011110000b
		DW        0001110001111100b
		DW        0001110000011100b
		DW        0000100000000000b

; L
L_LETTER	DW        0000000000000000b
		DW        0000010000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111111110000b
		DW        0000111111111000b
		DW        0000111111110000b

; M
M_LETTER	DW        0000000000000000b
		DW        0000110000110000b
		DW        0001110000111000b
		DW        0001110000111000b
		DW        0011111000111000b
		DW        0011111001111100b
		DW        0011111001111100b
		DW        0011111001111100b
		DW        0011011011111100b
		DW        0111011011101100b
		DW        0111011111001110b
		DW        0111011111001110b
		DW        1110011111001110b
		DW        1110001111000111b
		DW        1110001110000111b
		DW        1110001110000011b

; N
N_LETTER	DW        0000000000000000b
		DW        0011000000001100b
		DW        0011100000001110b
		DW        0011110000001110b
		DW        0011110000001110b
		DW        0011111000001110b
		DW        0011111100001110b
		DW        0011101100001110b
		DW        0011100110001110b
		DW        0011100011001110b
		DW        0011100011101110b
		DW        0011100001111110b
		DW        0011100000111110b
		DW        0011100000011110b
		DW        0011100000001110b
		DW        0001000000000100b

; O
O_LETTER	DW        0000000000000000b
		DW        0000001111100000b
		DW        0000111111111000b
		DW        0001111111111000b
		DW        0001110000111100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0111000000011100b
		DW        0111000000011100b
		DW        0111000000011100b
		DW        0111000000111000b
		DW        0111000000111000b
		DW        0011100001111000b
		DW        0011111111110000b
		DW        0001111111100000b
		DW        0000011111000000b

; P
P_LETTER	DW        0000000000000000b
		DW        0000111111000000b
		DW        0000111111110000b
		DW        0000111111111000b
		DW        0000111001111000b
		DW        0000111000111000b
		DW        0000111001111000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000111111000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000010000000000b

; Q
Q_LETTER	DW        0000000000000000b
		DW        0000011111100000b
		DW        0000111111110000b
		DW        0001111111111000b
		DW        0011110000111000b
		DW        0111100000011100b
		DW        0111000000011100b
		DW        0111000000011100b
		DW        0111000010011100b
		DW        0111100011111100b
		DW        0011110001111100b
		DW        0011111111111000b
		DW        0001111111110000b
		DW        0000011111110000b
		DW        0000000000011000b
		DW        0000000000001100b

; R
R_LETTER	DW        0000000000000000b
		DW        0011111100000000b
		DW        0011111111000000b
		DW        0011111111110000b
		DW        0011100011110000b
		DW        0011100001111000b
		DW        0011100000111000b
		DW        0011100001111000b
		DW        0011111111110000b
		DW        0011111111100000b
		DW        0011111111000000b
		DW        0011101111110000b
		DW        0011100001111000b
		DW        0011100000111100b
		DW        0011100000011100b
		DW        0001000000000000b

; S
S_LETTER	DW        0000000000000000b
		DW        0000000111110000b
		DW        0000001111111000b
		DW        0000011111111000b
		DW        0000011100000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0000111111110000b
		DW        0000011111111000b
		DW        0000001111111100b
		DW        0000000000011100b
		DW        0001110000011100b
		DW        0001110000111100b
		DW        0001111111111000b
		DW        0000111111110000b
		DW        0000011111100000b

; T
T_LETTER	DW        0000000000000000b
		DW        0001111111111100b
		DW        0011111111111110b
		DW        0001111111111100b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000000010000000b

; U
U_LETTER	DW        0000000000000000b
		DW        0001000000001000b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0011100000011000b
		DW        0011100000111000b
		DW        0011110000111000b
		DW        0001110001110000b
		DW        0001111111110000b
		DW        0000111111100000b
		DW        0000011111000000b

; V
V_LETTER	DW        0000000000000000b
		DW        0011100000011100b
		DW        0011100000111100b
		DW        0011100000111000b
		DW        0011110000111000b
		DW        0001110001111000b
		DW        0001110001110000b
		DW        0001110001110000b
		DW        0000111011110000b
		DW        0000111011100000b
		DW        0000111011100000b
		DW        0000011111100000b
		DW        0000011111000000b
		DW        0000011111000000b
		DW        0000001110000000b
		DW        0000001110000000b

; W
W_LETTER	DW        0000000000000000b
		DW        1100000110000011b
		DW        1100001110000011b
		DW        1100001110000111b
		DW        1110001111000111b
		DW        1110011111000111b
		DW        1110011111000111b
		DW        1110011111001110b
		DW        0110111011001110b
		DW        0110111011001100b
		DW        0111110011111100b
		DW        0111110011111100b
		DW        0011110011111000b
		DW        0011100001111000b
		DW        0011100001110000b
		DW        0011100001110000b

; X
X_LETTER	DW        0000000000000000b
		DW        0011100000011100b
		DW        0011110000111100b
		DW        0001110000111000b
		DW        0000111001111000b
		DW        0000111011110000b
		DW        0000011111100000b
		DW        0000001111000000b
		DW        0000001111000000b
		DW        0000011111000000b
		DW        0000111111100000b
		DW        0001111001110000b
		DW        0001110001111000b
		DW        0011110000111000b
		DW        0111100000111100b
		DW        0111000000011100b

; Y
Y_LETTER	DW        0000000000000000b
		DW        0011100000011100b
		DW        0011100000011100b
		DW        0001110000111100b
		DW        0001110000111000b
		DW        0000111001111000b
		DW        0000111001110000b
		DW        0000011101110000b
		DW        0000011111100000b
		DW        0000001111100000b
		DW        0000000111000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000011110000000b
		DW        0000011100000000b
		DW        0000011100000000b

; Z
Z_LETTER	DW        0000000000000000b
		DW        0001111111111000b
		DW        0011111111111100b
		DW        0001111111111000b
		DW        0000000011110000b
		DW        0000000111100000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000011100000000b
		DW        0000111000000000b
		DW        0000111000000000b
		DW        0001110000000000b
		DW        0001111111111000b
		DW        0011111111111100b
		DW        0001111111111000b

; (C)  - it's not ASCII char it just replaces '['
COPY_LETTER	DW        0000000000000000b
		DW        0000011111000000b
		DW        0001111111110000b
		DW        0011100000111000b
		DW        0111000000011100b
		DW        0110011110001100b
		DW        1100110011000110b
		DW        1100110000000110b
		DW        1100110000000110b
		DW        1100110000000110b
		DW        1100110011000110b
		DW        0110011110001100b
		DW        0111000000011100b
		DW        0011100000111000b
		DW        0001111111110000b
		DW        0000011111000000b


; \
BSLASH_LETTER	DW        0000000000000000b
		DW        0001100000000000b
		DW        0001100000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000011000000b
		DW        0000000011000000b
		DW        0000000001100000b
		DW        0000000001100000b

; ]
QRBR_LETTER	DW        0000001111100000b
		DW        0000001111100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000000001100000b
		DW        0000001111100000b
		DW        0000001111100000b

; ^
POWER_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000110000000b
		DW        0000001111000000b
		DW        0000011101100000b
		DW        0000111000110000b
		DW        0000110000010000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; _
UNDERLN_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0011111111111100b
		DW        0011111111111100b
		DW        0000000000000000b
		DW        0000000000000000b

; '
QMR_LETTER	DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; a
a_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011111000000b
		DW        0000111111100000b
		DW        0000110001100000b
		DW        0000000111100000b
		DW        0000011111100000b
		DW        0000111001100000b
		DW        0000110001100000b
		DW        0000111111100000b
		DW        0000011110110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; b
b_S_LETTER	DW        0000000000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110111000000b
		DW        0000111111100000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000111111100000b
		DW        0000110111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; c
c_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001111000000b
		DW        0000011111100000b
		DW        0000111001100000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000111001100000b
		DW        0000011111100000b
		DW        0000001111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; d
d_S_LETTER	DW        0000000000000000b
		DW        0000000000110000b
		DW        0000000000110000b
		DW        0000000000110000b
		DW        0000001110110000b
		DW        0000011111110000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000011111110000b
		DW        0000001110110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; e
e_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110000000b
		DW        0000011111000000b
		DW        0000110001100000b
		DW        0000111111100000b
		DW        0000111111100000b
		DW        0000110000000000b
		DW        0000111001100000b
		DW        0000011111000000b
		DW        0000001110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; f
f_S_LETTER	DW        0000000000000000b
		DW        0000000111100000b
		DW        0000001111100000b
		DW        0000001100000000b
		DW        0000011111000000b
		DW        0000011111000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; g
g_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110110000b
		DW        0000011111110000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000011111110000b
		DW        0000001110110000b
		DW        0000110000110000b
		DW        0000111111110000b
		DW        0000011111100000b

; h
h_S_LETTER	DW        0000000000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110111100000b
		DW        0000111111110000b
		DW        0000111000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; i
i_S_LETTER	DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; j
j_S_LETTER	DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000000000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000011110000000b
		DW        0000011100000000b

; k
k_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110001100000b
		DW        0000110011000000b
		DW        0000110110000000b
		DW        0000111110000000b
		DW        0000111111000000b
		DW        0000111011000000b
		DW        0000110011000000b
		DW        0000110001100000b
		DW        0000110001100000b
		DW        0000000000000000b
		DW        0000000000000000b

; l
l_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011110000000b
		DW        0000011110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000000110000000b
		DW        0000111111110000b
		DW        0000111111110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; m
m_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0011011100111000b
		DW        0011111111111100b
		DW        0011100111001100b
		DW        0011000110001100b
		DW        0011000110001100b
		DW        0011000110001100b
		DW        0011000110001100b
		DW        0011000110001100b
		DW        0011000110001100b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; n
n_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110111100000b
		DW        0000111111110000b
		DW        0000111000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; o
o_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001111000000b
		DW        0000011111100000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000011111100000b
		DW        0000001111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; p
p_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110111000000b
		DW        0000111111100000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000111111100000b
		DW        0000110111000000b
		DW        0000110000000000b
		DW        0000110000000000b
		DW        0000110000000000b

; q
q_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000001110110000b
		DW        0000011111110000b
		DW        0000111001110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000111001110000b
		DW        0000011111110000b
		DW        0000001110110000b
		DW        0000000000110000b
		DW        0000000000110000b
		DW        0000000000110000b

; r
r_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011011100000b
		DW        0000011111100000b
		DW        0000011100000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000011000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; s
s_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000011111000000b
		DW        0000111111100000b
		DW        0000110001100000b
		DW        0000111100000000b
		DW        0000011111000000b
		DW        0000000011100000b
		DW        0000110001100000b
		DW        0000111111100000b
		DW        0000011111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; t
t_S_LETTER	DW        0000000000000000b
		DW        0000000100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000011111000000b
		DW        0000011111000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001100000000b
		DW        0000001111000000b
		DW        0000000111000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; u
u_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110000110000b
		DW        0000110001110000b
		DW        0000111111110000b
		DW        0000011110110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; v
v_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110001100000b
		DW        0000110001100000b
		DW        0000110001100000b
		DW        0000011011000000b
		DW        0000011011000000b
		DW        0000011011000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; w
w_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0110001110001100b
		DW        0110001110001100b
		DW        0011001110011000b
		DW        0011011011011000b
		DW        0011011011011000b
		DW        0011011011011000b
		DW        0001110001110000b
		DW        0001110001110000b
		DW        0001110001110000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; x
x_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000110001100000b
		DW        0000111011100000b
		DW        0000011011000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000011011000000b
		DW        0000111011100000b
		DW        0000110001100000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; y
y_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0001100000110000b
		DW        0001100000110000b
		DW        0000110001100000b
		DW        0000110001100000b
		DW        0000011011000000b
		DW        0000011011000000b
		DW        0000011111000000b
		DW        0000001110000000b
		DW        0000001110000000b
		DW        0000001100000000b
		DW        0000111100000000b
		DW        0000111000000000b

; z
z_S_LETTER	DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000111111100000b
		DW        0000111111100000b
		DW        0000000011000000b
		DW        0000000111000000b
		DW        0000001110000000b
		DW        0000011100000000b
		DW        0000011000000000b
		DW        0000111111100000b
		DW        0000111111100000b
		DW        0000000000000000b
		DW        0000000000000000b
		DW        0000000000000000b

; ============================================================

DSEG	ENDS

;***************************************************************

SSEG	SEGMENT STACK	'STACK'
	DW	100h	DUP (?)
SSEG	ENDS

;***************************************************************

CSEG	SEGMENT	'CODE'

;*******************************************************************

START	PROC	FAR
	ASSUME  CS:CSEG, DS:DSEG, SS:SSEG, ES:NOTHING

	; set DS to data segment:
	MOV     AX, DSEG
	MOV     DS, AX

;---------------- SET KEYBOARD HANDLER ----------
	; save location of old interrupt:
	;PUSH	ES
	MOV	AX, 3509h
	INT	21h
	MOV     Off_9, BX
	MOV     Seg_9, ES
	;POP	ES
	; set new interrupt:
	PUSH	DS
	LDS	DX, KB_Handler
	MOV	AX, 2509h
	INT	21h
	POP	DS
;------------------------------------------------

	; set video mode:
	mov ax, 04f02h
	mov bx, 101h	;(0100h for 640x400x256) (0101h for 640x480x256)
	int 10h

	; set active page (I'm not sure it is zero at the begining by default):
	XOR	DX, DX	; page
	XOR	BX, BX	; ??
	MOV	AX, 04f05h
	INT	010h		; sets page to DX! (?)

	; get WinFuncPtr for mode "101h" - 640x480x256
	CALL	GET_WinFuncPtr


	; debug!
	;PRINT_COLOR_CODES  ; used to get color codes... pretty wit :).
	;CALL	WAIT_SP

	;WATCH_KEYBOARD	; debug!


;:::: debug:
;	MOV	BX, 0	; x
;	MOV	DX, 0	; y
;	LEA	SI, M_LETTER
;	MOV	AL, 15	; fore color
;	MOV	AH, 16	; back color
;	CALL	PutLetter
;	CALL	WAIT_SP

;	;---debug!
;
;	MOV	score_h, 9
;	MOV	score_l, 0ffffh
;
;	CALL	MAKE_VAL_CODE
;
;	MOV	text_fore_color, 46
;	MOV	text_back_color, 16
;	MOV	AL, 0	; x
;	MOV	AH, 0	; y
;	LEA	BX, s_buffer
;	CALL	DrawString
;
;	CALL	WAIT_SPACE
;
;	;---

; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
show_instructions:

    	CALL	SHOW_INSTR

	; if "space" is pressed already, then wait until it is depressed,
	; otherwise it may trigger from previous "game over"
	; (reseting the KEYS[] vector didn't help),
	; the same thing is done for "enter" (though it doesn't help much),
	; it may not be released from command prompt command - when you type "snake[ENTER]....":
    wait_release:
	CMP	KEYS[KEY_SPACE], 1	; space still pressed?
	JE	wait_release		;  - yes.
	CMP	KEYS[KEY_ENTER], 1	; enter still pressed?
	JE	wait_release		;  - yup.


	CALL	WAIT_ANY_KEY

	; ESC pressed? (although the same check is done in the main loop,
	; this one never shows "NICE TRY"...)
	CMP	KEYS[KEY_ESC], 1	; ESCAPE?
	JNE	not_esc			; - no.
	JMP	exit_prog		; - yes.
    not_esc:

; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

reset_game:

	; set the status line (default):
	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	MOV	AL, 0
	MOV	AH, 0
	LEA	BX, s_status
	CALL	DrawString

	; reset all variables:
	MOV	level, 0
	MOV	lives, 3
	MOV	score_h, 0
	MOV	score_l, 0
	CALL	SHOW_LIVES
	CALL	SHOW_SCORE
	MOV	snake_size, MIN_SIZE*2

set_level:

	CALL	SHOW_LEVEL

; %%%%%%%%% set the map for current level %%%%%%%%%

	; while working with segments, I found out some interesting things,
	; at least they look so to me: TASM ignores the prefix when assume is
	; used, and it doesn't work without the assume...
	; MASM does it by the book... (ignores ASSUME when there is a prefix)

	; using correct ASSUME works for both assemblers,
	; but I'm still using the prefix below just to make it clear.

	; (finally I made it ASSUME ES:NOTHING - it's more understandable:)

	MOV	AX, LEVEL_SEG		; set ES to point to LEVEL_SEG
	MOV	ES, AX

	; calculate level data address:
	LEA	SI, LEVEL_0	; SI - source level pointer.
	MOV	AX, LEVEL_BYTE_SIZE
	MUL	level		; DX:AX = MAP_SIZE * level
	ADD	SI, AX

	MOV	BL, 10000000b	; a bit mask.

	; ++++++ first we'll get apples (or set a stone bit):
	MOV	DI, 40		; DI - game map pointer (init as 40 because first row ignored).
set_next_apple:
	MOV	game_map[DI], 0	; clear from any previous data.
	TEST	es:[SI], BL
	JZ	n_apple
	MOV	game_map[DI], APPLE_ID
    n_apple:
    	ROR	BL, 1
    	JNC	no_ror_car1
	INC	SI		; next byte.
    no_ror_car1:
	INC	DI
	CMP	DI, MAP_SIZE
	JL	set_next_apple
	;+++++++++++++++++++++++++++++++

	; ++++++ get mines / stones:
	MOV	BL, 10000000b	; a bit mask.
	MOV	DI, 40		; DI - game map pointer (init as 40 because first row ignored).
set_next_bomb_stone:
	TEST	es:[SI], BL
	JZ	n_bomb_stone
	CMP	game_map[DI], 0		; if it's not zero then it's a stone.
	JNE	n_stone
	MOV	game_map[DI], MINE_ID
	JMP	n_bomb_stone
    n_stone:
	MOV	game_map[DI], STONE_ID
    n_bomb_stone:
    	ROR	BL, 1
    	JNC	no_ror_car2
	INC	SI		; next byte.
    no_ror_car2:
	INC	DI
	CMP	DI, MAP_SIZE
	JL	set_next_bomb_stone
	;+++++++++++++++++++++++++++++++

map_set_complete:

; %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

start_game:	; (restart level)

	TILE_SCREEN	16


	MOV	apples_to_eat, 0	; reset apple count, before counting them again.


; ----------- set the map data:
	MOV	BX, 0	; x
	MOV	DX, 1	; y
map_next:
	CMP	BX, 40
	JL	x_ok_m
	MOV	BX, 0
	INC	DX
	CMP	DX, 30
	JAE	mapping_complete
x_ok_m:

	; get map info into CL
	MOV	DI, BX
	MOV	AL, DL
	MUL	forty	; AX = AL*40
	ADD	DI, AX
	MOV	CL, game_map[DI]


    chk_tile:
	CMP	CL, NOTHING_ID
	JE	skip_map
    chk_mine:
    	CMP	CL, MINE_ID
    	JNE	chk_apple
    	LEA	SI, MINE
    	JMP	si_set
    chk_apple:
	CMP	CL, APPLE_ID
	JNE	chk_stone
	LEA	SI, APPLE
    	INC	apples_to_eat		; another apple!
	JMP	si_set
    chk_stone:
	CMP	CL, STONE_ID
	JNE	unknown_obj
	LEA	SI, STONE
	JMP	si_set
    unknown_obj:	; (not legal object) some other info from previous play.
    	MOV	game_map[DI], 0	; reset this unknow object (possibly snake/bombs).
	JMP	skip_map

si_set:
	PUSH	BX
	PUSH	DX
	MOV	CL, 4
	SHL	BX, CL
	SHL	DX, CL
	CALL	PutIcon
	POP	DX
	POP	BX
skip_map:
	INC	BX
	JMP	map_next
mapping_complete:
; -----------

; ^^^^^^^^^^^^^^^ reset bombs (there maybe a flying bomb from previous game...):
	MOV	DI, 0
	MOV	BX, 0
	MOV	CX, BOMB_MAX
    reset_bombs:
	MOV	BYTE PTR bomb_direction[DI], 0
	MOV	BYTE PTR bomb_visible[DI], 0
	MOV	WORD PTR bomb_wait[BX], 0
	MOV	WORD PTR bomb_w_hour[BX], 0
	INC	DI
	ADD	BX, 2
	LOOP	reset_bombs
	MOV	bomb_count, 0		; no bomb flying!
; ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

; *************************************************
; draw snake at default position:
	MOV	BH, 0
	MOV	DH, 0

	MOV	BL, DEFAULT_X
	MOV	DL, DEFAULT_Y

	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	LEA	SI, HEAD_2
	CALL	PutIcon

; set all body parts coordinates to default:
	MOV	DI, 0
set_def_n:
	CMP	DI, snake_size
	JE	default_set_complete
	MOV	snake[DI], DEFAULT_X
	MOV	snake[DI+1], DEFAULT_Y
	INC	DI
	INC	DI
	JMP	set_def_n
default_set_complete:

; update the map (it's required to set it because it is set automatically
; only when head position changes): ##
;	MOV	game_map[DEFAULT_X+DEFAULT_Y*40], SNAKE_ID

; reset direction:
	MOV	new_direction, 0
	MOV	cur_direction, 0
	MOV	start_direction, 0
; *************************************************


mainloop:

; check the pressed key:
	CMP	KEYS[KEY_ESC], 1	; ESCAPE
	JNE	not_exit_prog
	CALL	THIS_WAS_A_NICE_GAME	; game interupted, so let's quit the scores.
	JMP	exit_prog
not_exit_prog:

	CMP	KEYS[KEY_LEFT], 1	; LEFT
	JNE	NL
	CMP	cur_direction, RIGHT	; don't allow to go left,
	JE	NL			; when current direction is right.
	MOV	new_direction, LEFT	; 1
NL:

	CMP	KEYS[KEY_RIGHT], 1 	; RIGHT
	JNE	NR
	CMP	cur_direction, LEFT	; don't allow to go right,
	JE	NR			; when current direction is left.
	MOV	new_direction, RIGHT	; 2
NR:

	CMP	KEYS[KEY_UP], 1 	; UP
	JNE	NU
	CMP	cur_direction, DOWN	; don't allow to go up,
	JE	NU			; when current direction is down.
	MOV	new_direction, UP	; 3
NU:

	CMP	KEYS[KEY_DOWN], 1 	; DOWN
	JNE	ND
	CMP	cur_direction, UP	; don't allow to go down,
	JE	ND			; when current direction is up.
	MOV	new_direction, DOWN	; 4
ND:

	CMP	start_direction, 0
	JNE	start_dir_e		; already set.
	CMP	new_direction, 0
	JE	start_dir_e		; no direction given (still stopped).
	MOV	AL, new_direction
	MOV	start_direction, AL
start_dir_e:

	;+++++++++ PAUSE ??? +++++++++++++++++++++++++++

	CMP	KEYS[KEY_P], 1		; "p"
	JNE	not_pause
	CALL	SHOW_PAUSE_ON_STATUS
	CALL	WAIT_SP
	CALL	SHOW_FULL_STATUS
    not_pause:

	;+++++++++++++++++++++++++++++++++++++++++++++++

;=============== THE BOMB =============
	CMP	KEYS[KEY_CTRL], 1	; CTRL
	JE	CTRL_PRESSED
	MOV	allow_bomb, 1		; CTRL NOT pressed, set flag to '1'.
	JMP	NB
CTRL_PRESSED:

	CMP	allow_bomb, 1		; don't allow dropping all bombs on a single key press
	JNE	NB			;
	CMP	bomb_count, BOMB_MAX	; check if maximum reached!
	JE	NB			;
	MOV	allow_bomb, 0		; CTRL pressed, set flag to '0'.
	MOV	SI, 0
search_free:
	CMP	SI, BOMB_MAX		; searched all available bombs?
	JE	NB			; no more free bombs.
	INC	SI			; point to the next bomb index.
	CMP	BYTE PTR bomb_direction[SI-1], 0	; is this bomb free?
	JNE	search_free		; check next bomb.

	DEC	SI	; get one back because of last INC.

	; gets here when SI contains an index of a free bomb

	; :::::: stoped snake can drop the bomb!
	CMP	cur_direction, 0
	JNE	snake_not_stopped
	MOV	AH, RIGHT		; by default snake's head is pointed to the right.
	JMP	snake_stopped_but_drops_the_bomb
    snake_not_stopped:
	; ::::::
	MOV	AH, cur_direction
    snake_stopped_but_drops_the_bomb:
	MOV	bomb_direction[SI], AH
	MOV	AH, snake[0]	; x
	MOV	bomb_x[SI], AH
	MOV	AH, snake[1]	; y
	MOV	bomb_y[SI], AH
	INC	bomb_count		; one more bomb taken.

	;+++++++ make sure the snake won't eat its own bomb,
	; this also make a cool effect of snake stopping before dropping the bomb:
	MOV	snake_skip_1_move, 1
	;++++++++++++++++++++++
NB:
;======================================

; ********** NO DIRECTION - NO MOVE **************
	CMP	new_direction, 0
	JNE	has_direction
	JMP	NO_MOVE
has_direction:
; ************************************************

;======================= MOVE SNAKE OR WAIT? =================================
	MOV	AH, 00h			; get tick count in CX:DX.
	INT	1Ah			;

	; ????? waited enough ??????

	CMP	snake_w_hour, CX	; check hour.
	JE	hour_ok
	JB	wait_complete

	; (((((((  check if timer was reset:
	MOV	BX, snake_w_hour
	SUB	BX, CX
	CMP	BX, 1
	; if hour is greater then 1 from current hour, then timer was probably reset:
	JA	wait_complete
	; (((((((

	JMP	NO_MOVE			; wait more.
hour_ok:
	CMP	snake_wait, DX		; check minutes.
	JBE	wait_complete
	JMP	NO_MOVE			; wait more.
wait_complete:
	; set new interval:
	MOV	snake_wait, DX		; minutes.
	MOV	snake_w_hour, CX	; hour.
	; set period (18.20444444 ticks per second).
	CMP	KEYS[KEY_ALT], 1
	JNE	normal_speed
	ADD	snake_wait, 2		; turbo speed.
	JMP	period_set		; (FLAGS NOT CHANGED!)
    normal_speed:
	ADD	snake_wait, 4		; normal speed.
    period_set:
	JNC	no_hour_carry		; check for carry.
	INC	snake_w_hour
no_hour_carry:
;========================================================================


; should one move be skipped?
	CMP	snake_skip_1_move, 0
	JE	NO_SKIP
	MOV	snake_skip_1_move, 0	; reset the flag.
	JMP	NO_MOVE			; wait more.
NO_SKIP:

; adding new element to a snake:
	CMP	do_increase, 0		; should increase?
	JE	hide_and_move
	MOV	do_increase, 0		; reset increase flag.
	CMP	snake_size, MAX_SIZE*2	; do not allow to grow over max size.
	JE	hide_and_move
	INC	snake_size		; increase snake size,
	INC	snake_size		; (by 2 because every element is 2 bytes).
	MOV	SI, snake_size		; move data to newly added element,
	MOV	AL, snake[SI-4]		; it's required to hide tail.
	MOV	AH, snake[SI-3]
	MOV	snake[SI-2], AL
	MOV	snake[SI-1], AH


hide_and_move:

; hide tail:
	XOR	BH, BH
	XOR	DH, DH

	MOV	SI, snake_size
	MOV	BL, snake[SI-2]	; x
	MOV	DL, snake[SI-1]	; y

	;----- update game map:
	LEA	DI, game_map
	ADD	DI, BX
	MOV	AL, 40
	MUL	DL
	ADD	DI, AX
	MOV	BYTE PTR [DI], NOTHING_ID
	;-----

	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	LEA	SI, TILE ; BLACK
	CALL	PutIcon

; move snake array from head to tail (tail should go away):
	MOV	SI, snake_size	; point to one element before end (before tail).
	DEC	SI
	DEC	SI
	DEC	SI
	DEC	SI
	MOV	DI, snake_size	; point to last element (tail).
	DEC	DI
	DEC	DI
	XOR	DX, DX		;
	MOV	AX, snake_size	;
	DIV	two		;
	DEC	AX		;
	MOV	CX, AX		; put (snake_size/2-1) into CX.
move_array:			; loop (snake_size/2-1) times.
	MOV	AL, snake[SI]
	MOV	snake[DI], AL
	MOV	AL, snake[SI+1]
	MOV	snake[DI+1], AL
	DEC	SI
	DEC	SI
	DEC	DI
	DEC	DI
	LOOP	move_array

; move_snake:

	UPDATE_SNAKE_COORD	; macro!

;+++++++++++++++++++++++++++++++++++++
; hide old head (replace it with body):
;
; decide what body part to use!
; (cur_direction is updated only in the end, so cur_direction is really
; the previous direction):
	MOV	AL, new_direction
	MOV	AH, cur_direction	; previous direction.
	CMP	AL, AH
	JE	prev_equal
	CMP	AH, RIGHT
	JE	prev_right
	CMP	AH, LEFT
	JE	prev_left
	CMP	AH, UP
	JE	prev_up
;----------------------------
prev_down:
	CMP	AL, LEFT
	JNE	d_new_right
    d_new_left:
	LEA	SI, BODY_1
	JMP	body_selected
    d_new_right:
	LEA	SI, BODY_2
	JMP	body_selected
;----------------------------
prev_up:
	CMP	AL, LEFT
	JNE	t_new_right
    t_new_left:
	LEA	SI, BODY_3	; from up to left.
	JMP	body_selected
    t_new_right:
	LEA	SI, BODY_4	; from up to right.
	JMP	body_selected
;----------------------------
prev_left:
	CMP	AL, UP
	JNE	l_new_down
    l_new_up:
	LEA	SI, BODY_2	; from left to up.
	JMP	body_selected
    l_new_down:
    	LEA	SI, BODY_4	; from left to down.
    	JMP	body_selected
;----------------------------
prev_right:
	CMP	AL, UP
	JNE	r_new_down
    r_new_up:
	LEA	SI, BODY_1	; from right to up.
	JMP	body_selected
    r_new_down:			; if it's not to up then to down.
	LEA	SI, BODY_3
	JMP	body_selected
;----------------------------
prev_equal:			; previous direction is the same as new.
	CMP	AL, LEFT
	JE	body_left_right
	CMP	AL, RIGHT
	JE	body_left_right
    body_top_bottom:		; if not left/right then top/bottom for sure.
	LEA	SI, BODY_6
	JMP	body_selected
;----------------------------
body_left_right:
	LEA	SI, BODY_5
;----------------------------
body_selected:
;----------------------------
	MOV	BL, snake[2]	; x
	XOR	BH, BH
	MOV	DL, snake[3]	; y
	XOR	DH, DH
	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	CALL	PutIcon
;+++++++++++++++++++++++++++++++++++++

; show new head:
	; get head's coordinates into BX,DX
	XOR	BH, BH
	XOR	DH, DH
	MOV	BL, snake[0]	; x
	MOV	DL, snake[1]	; y

	PUSH	BX	; store head's coordinates.
	PUSH	DX	;

	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	LEA	SI, HEAD_1
	MOV	AL, new_direction
	MOV	cur_direction, AL	; cur_direction updated.
	DEC	AL		; directions are counted from '1'... so need make a correction.
	XOR	AH, AH
	PUSH	DX		; MUL modifies DX:AX, need to save it.
	MUL	mWHxWH		; DX:AX = AX * mWHxWH     (mWHxWH=16*16=256)
	ADD	SI, AX		; DX is ignored (it should be zero).
	POP	DX		; restore DX stored from MUL.
	CALL	PutIcon

	; draw the tail!
	CALL	DRAW_TAIL

	POP	DX	; re-store head's coordinates.
	POP	BX	;

	;----- update game map:
	LEA	DI, game_map
	ADD	DI, BX
	MOV	AL, 40
	MUL	DL
	ADD	DI, AX
	MOV	CL, [DI]	; check if it's zero (nothing)
	;@@@@@@@@@@@ CHECK FOR HEAD COLLISION @@@@@@@@@@@@@@@
	CMP	CL, NOTHING_ID	;
	JE	head_collision_check_complete
	;CALL	MAKE_SOUND
    c_apple:
	CMP	CL, APPLE_ID	; an apple?
	JNE	c_mine		; check for next object.
	MOV	do_increase, 1	; size of snake will be increased.
	MOV	mWRD, 3		; 3 points for an apple.
	CALL	INC_SCORE
	DEC	apples_to_eat	; one apple less!
	;+++++++++++++++++++++++++++++++++++++++++++++++++++
	CMP	apples_to_eat, 0	; all apples eaten/destroyed?
	JNE	still_not_enough	; - no!
	JMP	go_next_level		; - yes!
      still_not_enough:
        ;+++++++++++++++++++++++++++++++++++++++++++++++++++
	JMP	head_collision_check_complete
    c_mine:
    	CMP	CL, MINE_ID
    	JNE	c_stone				; check for next object.
    	MOV	BYTE PTR [DI], NOTHING_ID	; mine should be removed after collision (explode).
    	JMP	restart_level_oops
    c_stone:
    	CMP	CL, STONE_ID
    	JNE	c_snake				; check for next object.
    	JMP	restart_level_oops
    c_snake:
    	CMP	CL, SNAKE_ID			; crashed onto itself???!!!
    	JNE	head_collision_check_complete
	JMP	restart_level_oops

head_collision_check_complete:
	;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	MOV	BYTE PTR [DI], SNAKE_ID
	;-----


NO_MOVE:			; end of move snake code.


;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	MOV	SI, 0		; SI keeps current bomb index.
PROCESS_NEXT_BOMB:

; is there a bomb to fly?
	CMP	BYTE PTR bomb_direction[SI], 0
	JNE	is_bomb
	JMP	NO_BOMB
is_bomb:

;++++++++++++++++++++++ MOVE BOMB OR WAIT? ++++++++++++++++++++++++++++++++=
	; get word index from byte index (word=2*byte):
	MOV	AX, 2
	MUL	SI	; DX:AX = SI*2	(DX-ignored! - should be zero)
	MOV	DI, AX		; DI keeps the word index
; *************************
	MOV	AH, 00h			; get tick count in CX:DX.
	INT	1Ah			;
	; waited enough?

	CMP	bomb_w_hour[DI], CX	; check hour.
	JE	hour_ok_b
	JB	wait_complete_b

	; (((((((  check if timer was reset:
	MOV	BX, bomb_w_hour[DI]
	SUB	BX, CX
	CMP	BX, 1
	; if hour is greater then 1 from current hour, then timer was probably reset:
	JA	wait_complete_b
	; (((((((

	JMP	NO_BOMB			; wait more.
hour_ok_b:
	CMP	bomb_wait[DI], DX	; check minutes.
	JBE	wait_complete_b
	JMP	NO_BOMB			; wait more.
wait_complete_b:
	; set new interval:
	MOV	bomb_wait[DI], DX	; minutes.
	MOV	bomb_w_hour[DI], CX	; hour.
	ADD	WORD PTR bomb_wait[DI], 1	; set period (18.20444444 ticks per second).
	JNC	no_hour_carry_b		; check for carry.
	INC	WORD PTR bomb_w_hour[DI]
no_hour_carry_b:
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; hide old bomb:
	CMP	BYTE PTR bomb_visible[SI], 0	; no need to hide hidden bomb,
	JE	BOMB_HIDDEN		; it's needed to avoid placing black box over snake's head

	XOR	BH, BH
	XOR	DH, DH

	MOV	BL, bomb_x[SI]	; x
	MOV	DL, bomb_y[SI]	; y

	;----- update game map:
	LEA	DI, game_map
	ADD	DI, BX
	MOV	AL, 40
	MUL	DL
	ADD	DI, AX
	MOV	BYTE PTR [DI], NOTHING_ID
	;-----

	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	PUSH	SI		; store bomb's index.
	LEA	SI, TILE
	CALL	PutIcon
	POP	SI		; re-store bomb's index.

	MOV	BYTE PTR bomb_visible[SI], 0

BOMB_HIDDEN:

; update bomb coordinates or stop it (when it goes out of screen)
; when bomb is thrown it is on the snake's head, so it should be moven first before
; any checks (including the collision with the target):

	UPDATE_BOMB_COORD	; macro!

; get updated bomb's coordinates into BX, DX (BH and DH are zeros):
	XOR	BH, BH
	XOR	DH, DH
	MOV	BL, bomb_x[SI]	; x
	MOV	DL, bomb_y[SI]	; y

	; some tricks made to avoid 'Relative jump out of range':

	CMP	BL, 40
	JE	do_bomb_stop
	CMP	BL, -1
	JE	do_bomb_stop
	CMP	DL, 30
	JE	do_bomb_stop
	CMP	DL, 0 ; not "-1" because of the status line.
	JE	do_bomb_stop

	JMP	not_bomb_stop
    do_bomb_stop:
	JMP	STOP_BOMB_WITHOUT_HIDING_THE_TARGET
    not_bomb_stop:


	;----- check map and update it:
	LEA	DI, game_map
	ADD	DI, BX
	MOV	AL, 40
	MUL	DL
	ADD	DI, AX
	MOV	CL, [DI]	; check if it's zero (nothing)
	CMP	CL, NOTHING_ID	;
	JE	NO_COLLISION
	; @@@@@@@@@@@@@@@@ check who caused the collision

	CMP	CL, MINE_ID	; a mine?
	JNE	not_mine
	MOV	mWRD, 2		; 2 points for a shot mine.
	CALL	INC_SCORE
	MOV	BYTE PTR [DI], NOTHING_ID
	JMP	STOP_THE_BOMB
     not_mine:

	CMP	CL, STONE_ID	; a stone?
	JNE	not_stone
	; stone cannot be shot down!!!!  - no points! and it stay where it is!
	JMP	STOP_BOMB_WITHOUT_HIDING_THE_TARGET
     not_stone:

	CMP	CL, APPLE_ID	; an apple?
	JNE	not_apple
	MOV	mWRD, 1		; 1 point for a shot apple.
	CALL	INC_SCORE
	DEC	apples_to_eat	; one apple less!
	;+++++++++++++++++++++++++++++++++++++++++++++++++++
	CMP	apples_to_eat, 0	; all apples eaten/destroyed?
	JNE	still_not_enough_d	; - no!
	;///// show tile where once was a bomb (we're going out):
     	MOV	CL, 4
     	SHL	BX, CL		; * 16
     	SHL	DX, CL		; * 16
     	LEA	SI, TILE
     	CALL	PutIcon
     	;///////////////////////////////////////
	JMP	go_next_level
       still_not_enough_d:
        ;+++++++++++++++++++++++++++++++++++++++++++++++++++
        MOV	BYTE PTR [DI], NOTHING_ID
        JMP	STOP_THE_BOMB
     not_apple:

     	CMP	CL, SNAKE_ID	; a snake?
     	JNE	not_snake
	;///// show tile where once was a bomb (we're going out):
     	MOV	CL, 4
     	SHL	BX, CL		; * 16
     	SHL	DX, CL		; * 16
     	LEA	SI, TILE
     	CALL	PutIcon
     	;///////////////////////////////////////
     	MOV	BYTE PTR [DI], NOTHING_ID	; not required here since level restarts.
     	JMP	restart_level_oops
     not_snake:

	; @@@@@@@@@@@@@@@@

	; nothing (no collision?)

	;MOV	BYTE PTR [DI], NOTHING_ID

	JMP	STOP_THE_BOMB
NO_COLLISION:
	MOV	BYTE PTR [DI], BOMB_ID
	;-----

	MOV	BYTE PTR bomb_visible[SI], 1

	; bomb still flying, show it:
	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	PUSH	SI		; store bomb's index.
	LEA	SI, BOMB
	CALL	PutIcon
	POP	SI		; re-store bomb's index.

	JMP	NO_BOMB		; bomb is not stopped yet (no collision/screen end).

STOP_THE_BOMB:
	; show tile where once was a bomb:
	MOV	CL, 4
	SHL	BX, CL		; * 16
	SHL	DX, CL		; * 16
	PUSH	SI		; store bomb's index.
	LEA	SI, TILE
	CALL	PutIcon
	POP	SI		; re-store bomb's index.
STOP_BOMB_WITHOUT_HIDING_THE_TARGET:
	MOV	BYTE PTR bomb_direction[SI], 0	; when gets here, then it's the last move.
	MOV	BYTE PTR bomb_visible[SI], 0
	DEC	bomb_count		; one bomb gone away (destroyed).
NO_BOMB:
;-------------------------------------------------------

	INC	SI			; to the next bomb index.
	CMP	SI, BOMB_MAX
	JE	out_bomb_loop
	JMP	PROCESS_NEXT_BOMB
out_bomb_loop:
;\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\


	JMP	mainloop	; main loop!!!!!!!



; )))))))))))))))))))))))))))))))))))))))))))))))))))))

go_next_level:

	INC	level

	; check if such level exists:
	CMP	level, LEVEL_MAX	; exists?
	JB	level_exists		; - yes.
	; tell user that this level is the last one....
	SHOW_SCORE_AND_VAL_CODE_INFO s_last_level	; destroyes the status line.
	CALL	WAIT_SP
	CALL	SHOW_FULL_STATUS	; restores the status line.
	MOV	level, 0		; back to zero (let the user earn points and grow:)
	JMP	set_level

    level_exists:

    	; show "LEVEL COMPLETE!":
    	MOV	text_fore_color, 44 ;46
    	MOV	text_back_color, 16
    	MOV	AL, 13	; x
    	MOV	AH, 13	; y
    	LEA	BX, s_level_compl
	CALL	DrawString

	CALL	WAIT_SPACE
	JMP	set_level

; )))))))))))))))))))))))))))))))))))))))))))))))))))))

restart_level_oops:
    	DEC	lives
    	CMP	lives, -1
    	JE	game_over
    	CALL	SHOW_LIVES

    	; show "oops...":
    	MOV	text_fore_color, 52 ;46
    	MOV	text_back_color, 16
    	MOV	AL, 15	; x
    	MOV	AH, 13	; y
    	LEA	BX, s_oops
	CALL	DrawString

	CALL	WAIT_SPACE
	JMP	start_game

; )))))))))))))))))))))))))))))))))))))))))))))))))))))

game_over:
	; show "game over":
    	MOV	text_fore_color, 46
    	MOV	text_back_color, 16
    	MOV	AL, 16
    	MOV	AH, 13
    	LEA	BX, s_game_over
	CALL	DrawString

	CALL	WAIT_SPACE

	CALL	THIS_WAS_A_NICE_GAME

	JMP	show_instructions

; )))))))))))))))))))))))))))))))))))))))))))))))))))))

exit_prog:

	MOV	AX, 0003h	; change screen back to mode 3 (text)
	INT	10h		;

;------ RESTORE ORIGINAL KEYBOARD HANDLER--------
	PUSH	DS
	MOV	DX, Off_9
	MOV	DS, Seg_9
	MOV	AX, 2509h
	INT	21h
	POP	DS
;------------------------------------------------


	LEA	DX, s_thank_you
	MOV	AH, 9h
	INT	21h

	MOV	AX, 4C00h	; return to OS with a ZERO.
	INT	21h		;

	RET
 START	ENDP

;***************************************************************

; procedure shows "press any key to continue",
; and does not return until space is pressed.
WAIT_SPACE	PROC	NEAR
	PUSH	AX
	PUSH	BX

	; ----------------------------

	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	MOV	AL, 9		; x
	MOV	AH, 15		; y
	LEA	BX, s_press_space
	CALL	DrawString

	; ----------------------------

	CALL	WAIT_SP

	POP	BX
	POP	AX
    	RET
WAIT_SPACE	ENDP

;***************************************************************

; this procedure does not return until space is pressed.
WAIT_SP	PROC	NEAR

	; --- reset space key if it's pressed already ---
	MOV	KEYS[KEY_SPACE], 0
	; -----------------------------------------------

	; --- wait for space ----
wait_for_space:
    	CMP	KEYS[KEY_SPACE], 1
    	JE	exit_wait_for_space
    	; processing of ESC is done in main loop, just should go there
    	; - though if ESC pressed too fast it works just like space:
    	CMP	KEYS[KEY_ESC], 1	; exit to OS?
    	JE	exit_wait_for_space
    	JMP	wait_for_space
exit_wait_for_space:
	;-------------------------

    	RET
WAIT_SP	ENDP

;***************************************************************

; this procedure does not return until any key is pressed.
WAIT_ANY_KEY	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX

	; --- reset keyboard ---
	MOV	BX, 0
	MOV	CX, 128
reset_kb:
	MOV	KEYS[BX], 0
	INC	BX
	LOOP	reset_kb
	; ----------------------

	; --- wait for any key ----
reset_bx:
	MOV	BX, 0
nothing_pressed:
	CMP	BX, 128
	JE	reset_bx
    	CMP	KEYS[BX], 1
    	JE	some_key_pressed
    	INC	BX
    	JMP	nothing_pressed
	;-------------------------

some_key_pressed:

	POP	CX
	POP	BX
	POP	AX
    	RET
WAIT_ANY_KEY	ENDP

;***************************************************************

; this procedure replaces last body part (BODY) with one of the tails (TAIL_X),
; should be called after the move (after old tail removed).
; NO PARAMETERS!
DRAW_TAIL	PROC	NEAR
	PUSH	DI
	PUSH	SI
	PUSH	AX
	PUSH	DX
	PUSH	BX

	MOV	DI, snake_size	; point to the last body part
	DEC	DI		;
	DEC	DI		;

	MOV	AL, snake[DI] 	; x of last body part.
	MOV	AH, snake[DI+1]	; y of last body part.

	; now decide what tail to use!
	DEC	DI		; point to body part before tail (pre-last)
	DEC	DI		;

	MOV	DL, snake[DI] 	; x of pre-last body part.
	MOV	DH, snake[DI+1]	; y of pre-last body part.

	CMP	AL, DL
	JB	tail_left
	JA	tail_right

	; gets here when x's are equal

	CMP	AH, DH
	JB	tail_top
	JA	tail_bottom

	; gets here when x's and y's are equal,
	; that means we are just starting the game or level,
	; so instead of tail body part should be drawn
	JMP	starting_tail_replacer

tail_bottom:
	LEA	SI, TAIL_2
	JMP	tail_selected

tail_top:
	LEA	SI, TAIL_4
	JMP	tail_selected

tail_right:
	LEA	SI, TAIL_1
	JMP	tail_selected

tail_left:
	LEA	SI, TAIL_3
	JMP	tail_selected

;=======================================
starting_tail_replacer:
	;----- update game map:	;##
	MOV	game_map[DEFAULT_X+DEFAULT_Y*40], SNAKE_ID
	;-----

	CMP	start_direction, RIGHT
	JNE	not_right_start
	LEA	SI, BODY_5	; right
	JMP	tail_selected
    not_right_start:
	CMP	start_direction, UP
	JNE	not_up_start
	LEA	SI, BODY_1	; up
	JMP	tail_selected
    not_up_start:
    	CMP	start_direction, DOWN
    	JNE	not_down_start
    	LEA	SI, BODY_3	; down
    	JMP	tail_selected
    not_down_start:
    	LEA	SI, TAIL_1	; in case it goes over the screen... (not very effective).
;=======================================


tail_selected:

;-*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-
	; tail is selected, but selection may be incorect when
	; snake moves over the screen (and appear on other end),
	; so need to make some more checks:

	; goes over screen from bottom to top?
	CMP	AH, 29		; tail at the bottom?
	JNE	not_bt
	CMP	DH, 1		; pre-tail at the top? (upper row ignored)
	JNE	not_bt
	LEA	SI, TAIL_4
	JMP	check_over_made
not_bt:

	; goes over screen from top to bottom?
	CMP	AH, 1		; tail at the top? (upper row ignored)
	JNE	not_tb
	CMP	DH, 29		; pre-tail at the bottom?
	JNE	not_tb
	LEA	SI, TAIL_2
	JMP	check_over_made
not_tb:

	; goes over screen from right to left?
	CMP	AL, 0		; tail at the right?
	JNE	not_rl
	CMP	DL, 39		; pre-tail at the left?
	JNE	not_rl
	LEA	SI, TAIL_1
	JMP	check_over_made
not_rl:

	; goes over screen from left to right?
	CMP	AL, 39		; tail at the left?
	JNE	not_lr
	CMP	DL, 0		; pre-tail at the right?
	JNE	not_lr
	LEA	SI, TAIL_3
	;JMP	check_over_made (goes there any way)
not_lr:


check_over_made:
;-*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-*--*-

	MOV	BL, AL
	MOV	DL, AH
	MOV	BH, 0
	MOV	DH, 0
	MOV	CL, 4
	SHL	BX, CL	; BX * 16
	SHL	DX, CL	; DX * 16
	CALL	PutIcon

tail_drawn:

	POP	BX
	POP	DX
	POP	AX
	POP	SI
	POP	DI
	RET
DRAW_TAIL	ENDP

;***************************************************************

MAKE_SOUND	PROC	NEAR
			PUSH	AX
			PUSH	CX

                        MOV     AL,0b6h
                        OUT     043h,AL
                        MOV     AL,090h
                        OUT     042h,AL
                        MOV     AL,000h
                        OUT     042h,AL
                        IN      AL,061h
                        OR      AL,3
                        OUT     061h,AL

NoSound1:               MOV     CX,08000h
TimerZ:                 LOOP    TimerZ

                        IN      AL,061h
                        AND     AL,0fch
                        OUT     061h,AL

                        POP	CX
                        POP	AX

                        RET
MAKE_SOUND	ENDP

;***************************************************************

;========================================================
;INPUT: 	BX=X postion (0..639)
;		DX=Y position (0..479)
;		SI=offset of ICON WHxWH
; Location = 0A000h + Xposition + (Yposition x 640)
; Screen: (640 x 480)
; Destroys original SI
;========================================================
PutIcon PROC
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	DX

	MOV	AX, 0A000h	; AX contains address of video.
	MOV	ES, AX		; ES contains address of video.

	MOV	AX, 640
	MUL	DX		; DX:AX = Yposition x 640

	ADD	BX, AX		; BX = Xposition + (Yposition x 640).
	JNC	no_car
	INC	DX		; next page.
no_car:


	MOV	CX, WH
next_y:

	PUSH	CX
	MOV	CX, WH
next_x:

	MOV	DI, BX


	; CHANGE THE PAGE!
	CMP	DX, CURRENT_PAGE
	JE	no_need_to_change	; saves a lot of time!!
	PUSH	BX
	MOV	CURRENT_PAGE, DX
	XOR	BX, BX
	MOV	AX, 04f05h
	;INT	010h		; sets page to DX!
	CALL 	[WinFuncPtr]	; faster then INT 010h to call 04f05h.
	POP	BX
no_need_to_change:


	; draw dot, if not '0'.
	MOV	AL, [SI]
	CMP	AL, 0		; instead of CMP (should be faster)
	JE	transparent	; '0' is for transparent.
	MOV	es:[DI], AL
transparent:

	INC	SI

	ADD	BX, 1		; next dot.
	JNC	no_car_x
	INC	DX		; next page.
no_car_x:

	LOOP	next_x

	POP	CX

	ADD	BX, 640-WH	; next row (y).
	JNC	no_car_y
	INC	DX		; next page.
no_car_y:

	LOOP	next_y

	POP	DX
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	RET
PutIcon	ENDP

;***************************************************************

;========================================================
;INPUT: 	BX - X postion  (0..639)
;		DX - Y position (0..479)
;		SI - offset of a letter data (16*16 bits = 256 bits = 32 bytes)
;		AL - fore color!!!!
;		AH - back color!!!!
; Location = 0A000h + Xposition + (Yposition x 640)
; Screen: (640 x 480)
; Destroys original SI
;========================================================
PutLetter	PROC
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DI

	; BX will be used as a mask, and DI will be used instead (directly).

	MOV	DI, BX		; DI = Xposition.

	MOV	BX, 1000000000000000b ; initialize the mask.

	PUSH	AX		; save colors.

	MOV	AX, 0A000h	; AX contains address of video.
	MOV	ES, AX		; ES contains address of video.

	MOV	AX, 640
	MUL	DX		; DX:AX = Yposition x 640

	ADD	DI, AX		; DI = Xposition + (Yposition x 640).
	JNC	no_car_L
	INC	DX		; next page.
no_car_L:

	POP	AX		; restore colors.

	MOV	CX, WH
next_y_L:

	PUSH	CX
	MOV	CX, WH
next_x_L:

	; CHANGE THE PAGE!
	CMP	DX, CURRENT_PAGE
	JE	no_need_to_change_L	; saves a lot of time!!
	PUSH	BX
	PUSH	AX
	MOV	CURRENT_PAGE, DX
	XOR	BX, BX
	MOV	AX, 04f05h
	;INT	010h		; sets page to DX!
	CALL 	[WinFuncPtr]	; faster then INT 010h to call 04f05h.
	POP	AX
	POP	BX
no_need_to_change_L:

	; draw dot, if not '0'.
	TEST	WORD PTR [SI], BX
	JZ	back_dot_L	; '0' is for backcolor dot.
	MOV	es:[DI], AL
	JMP	drawn_dot_L
back_dot_L:
	CMP	AH, 0		; if backcolor is '0' - means transparent.
	JE	drawn_dot_L	; jumps when transparent background.
	MOV	es:[DI], AH
drawn_dot_L:

	; move mask to the next bit in row (in letter data):
	ROR	BX, 1

	ADD	DI, 1		; next dot.
	JNC	no_car_x_L
	INC	DX		; next page.
no_car_x_L:

	LOOP	next_x_L

	POP	CX

	ADD	DI, 640-WH	; next row (y).
	JNC	no_car_y_L
	INC	DX		; next page.
no_car_y_L:

	; move SI to the next pair of bytes (next row
	; of the letter source data):
	INC	SI
	INC	SI

	LOOP	next_y_L

	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	RET
PutLetter ENDP

;***************************************************************

; draws string of custom defined letter on 40x30 screen,
; the function converts these coordinates to real screen
; coordinates: 640x480 automatically.
; AL - x (0..39).
; AH - y (0..29).
; BX - address of a string last char should be 0 (ASCII CODE=0)!
;   original BX points to last char (0) after execution!
DrawString	PROC	NEAR
	PUSH	AX
	PUSH	SI
	PUSH	DX
	PUSH	CX

next_char:
	MOV	CL, [BX]

	CMP	CL, 0
	JE	end_draw	; 0 marks end of the string.


; get letter address:
	LEA	SI, BLANK_LETTER
	SUB	CL, ' '		; first letter is space.
	PUSH	AX		; store x,y parameters.
	MOV	AH, 0
	MOV	AL, CL
	MOV	mWRD, 32	; 16*16 bits = 32 bytes.
	MUL	mWRD		; DX:AX = CL * 32
	ADD	SI, AX		; DX ignored (it should be zero).
	POP	AX		; re-store x,y parameters.

; draw letter:

	PUSH	BX	; store string pointer.
	MOV	BL, AL	; x
	XOR	BH, BH
	MOV	DL, AH	; y
	XOR	DH, DH
	MOV	CL, 4
	SHL	BX, CL	; BX * 16
	SHL	DX, CL	; DX * 16
	PUSH	AX	; store coordinates.
	MOV	AL, text_fore_color
	MOV	AH, text_back_color
	CALL	PutLetter
	POP	AX	; re-store coordinates.
	POP	BX	; re-store string pointer.

	INC	BX	; move to the next char.
	ADD	AL, 1	; move "cursor" for next char.
	JMP	next_char

end_draw:
	POP	CX
	POP	DX
	POP	SI
	POP	AX
	RET
DrawString	ENDP

;***************************************************************
; For performance reasons, it may be more efficient to call this function
; directly, without incurring the INT 10h overhead.  VBE Function 01h
; returns the segment:offset of this windowing function that may be
; called directly for this reason.
;
; NO PARAMETERS! (except memory structure for output).
;
; later "CALL [WinFuncPtr]" can be used instead of "INT 10"
; for use with 0x4F05 function.
GET_WinFuncPtr	PROC	NEAR
	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	ES

	; Input: AX 0x4F01 - Return VBE mode information
	;  CX Mode number
	;  ES:DI Pointer to ModeInfoBlock structure
	; Output: AX VBE Return Status

	MOV	AX, 04F01h
	MOV	CX, 101h	;(0100h for 640x400x256) (0101h for 640x480x256)
	MOV	BX, DS
	MOV	ES, BX
	LEA	DI, ModeAttributes

	INT	010h

	POP	ES
	POP	BX
	POP	CX
	POP	AX
	RET
GET_WinFuncPtr	ENDP

;***************************************************************

INT_9_REPLACER	PROC	FAR
	PUSH	AX
	PUSH	DI
	IN	AL, 60h
	XOR	AH, AH
	; got scan code into AX!
	MOV	DI, AX
	IN	AL, 61h
	OR	AL, 80h
	OUT	61h, AL
	AND	AL, 7Fh
	OUT	61h, AL
	MOV	AL, 20h
	OUT	20h, AL
	MOV	AX, DI		; process key
	AND	AL, 80h
	JZ	press		; process press
release:
	AND	DI, 7Fh		; process release
	MOV	KEYS[DI], 0
	JMP	end_int_9
press:
	MOV	KEYS[DI], 1
end_int_9:
	POP	DI
        POP	AX
        IRET
INT_9_REPLACER	ENDP

;***************************************************************
; prints out a number in DX:AX (not just a single digit)
; allowed values from 1 to 655359 (9:FFFF)
; (result of /10 should fit in AX).
; this function is NOT recursive! it just prints the number backwards.
;
; print_num_x		-  left position (0..39).
; print_num_y		-  top postion (0..29).
; print_num_len		-  number length (if number is smaller zeros will be printer)
;              		   in order to avoid printing zeros before number set it to -1 (255)
;                          every time before calling this function!!!
; DX:AX			-  the number!
;
;
;	ORIGINAL print_num_len AND print_num_x ARE DESTROYED!!!!
;
PRINT_NUM	PROC	NEAR

	PUSH	BX
	PUSH	CX
	PUSH	AX
	PUSH	DX

prev_digit:


	CMP	print_num_len, -1
	JE	check_for_zero		; don't care (check if DX:AX=0).
	CMP	print_num_len, 0
	JE	check_for_zero		; printed all digits (still check DX:AX=0 to make sure no number is cut off).
	DEC	print_num_len
	JMP	make_printing

check_for_zero:
	; Check if DX:AX is zero, if both registers are zero
	; go to end_show
	CMP	DX, 0
	JNZ	make_printing
	CMP	AX, 0
	JNZ	make_printing
	JMP	end_show
make_printing:



	MOV	BX, 10

	; DX:AX / BX   -   AX=result , DX=remainder :
	DIV	BX

	; DX is the remainder of DIV, DH is always '0' (because remainder
	; of /10 is always <10), so DL contains digit between 0 to 9.

	ADD	DL, 30h		; convert to ASCII code.

	PUSH	AX		; store the number.
	MOV	AL, print_num_x
	MOV	AH, print_num_y

	CALL	DRAW_CHAR

	DEC	print_num_x	; move to the next position.
	POP	AX		; restore the number.

	; DX contains the remainder from last DIV:
	XOR 	DX, DX

	JMP	prev_digit

end_show:

	POP	DX
	POP	AX
	POP	CX
	POP	BX

	RET
PRINT_NUM	ENDP

;***************************************************************
; draws char of custom defined letter on 40x30 screen,
; the function converts these coordinates to real screen
; coordinates: 640x480 automatically.
; AL - x (0..39).
; AH - y (0..29).
; DL - ascii code.
DRAW_CHAR	PROC	NEAR
	PUSH	AX
	PUSH	SI
	PUSH	DX
	PUSH	CX
	PUSH	BX

	MOV	CL, DL

; get letter address:
	LEA	SI, BLANK_LETTER
	SUB	CL, ' '		; first letter is space.
	PUSH	AX		; store x,y parameters.
	MOV	AH, 0
	MOV	AL, CL
	MOV	mWRD, 32	; 16*16 bits = 32 bytes.
	MUL	mWRD		; DX:AX = CL * 32
	ADD	SI, AX		; DX ignored (it should be zero).
	POP	AX		; re-store x,y parameters.


; draw letter:

	MOV	BL, AL	; x
	XOR	BH, BH
	MOV	DL, AH	; y
	XOR	DH, DH
	MOV	CL, 4
	SHL	BX, CL	; BX * 16
	SHL	DX, CL	; DX * 16
	PUSH	AX	; store coordinates.
	MOV	AL, text_fore_color
	MOV	AH, text_back_color
	CALL	PutLetter
	POP	AX	; re-store coordinates.

	POP	BX
	POP	CX
	POP	DX
	POP	SI
	POP	AX
	RET
DRAW_CHAR	ENDP

;***************************************************************

; displays the score at y=0 x=13 with 6 digits (leading zeros).
; no parameters!

SHOW_SCORE	PROC	NEAR
	PUSH	DX
	PUSH	AX

	MOV	DX, score_h
	MOV	AX, score_l

	MOV	print_num_x, 13
	MOV	print_num_y, 0
	MOV	print_num_len, 6
	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	CALL	PRINT_NUM

	POP	AX
	POP	DX
	RET
SHOW_SCORE	ENDP

;***************************************************************

; displays the live count at y=0 x=37 with 2 digits (leading zeros).
; no parameters!

SHOW_LIVES	PROC	NEAR
	PUSH	DX
	PUSH	AX

	MOV	DX, 0
	MOV	AX, lives

	MOV	print_num_x, 37
	MOV	print_num_y, 0
	MOV	print_num_len, 2
	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	CALL	PRINT_NUM

	POP	AX
	POP	DX
	RET
SHOW_LIVES	ENDP

;***************************************************************

; displays the current level at y=0 x=26 with 3 digits (leading zeros).
; no parameters!

SHOW_LEVEL	PROC	NEAR
	PUSH	DX
	PUSH	AX

	MOV	DX, 0
	MOV	AX, level

	MOV	print_num_x, 26
	MOV	print_num_y, 0
	MOV	print_num_len, 3
	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	CALL	PRINT_NUM

	POP	AX
	POP	DX
	RET
SHOW_LEVEL	ENDP

;***************************************************************

; adds mWRD to score
; mWRD - point to add

INC_SCORE	PROC	NEAR
	PUSH	AX

	MOV	AX, mWRD
	ADD	score_l, AX
	JNC	no_score_carry
	INC	score_h
    no_score_carry:

	; +++++++ well, this is a limitation of my PRINT_NUM procedure,
	; I cannot print bigger numbers, so score is stopped when its bigger
	; then 9:FFFF (655359)
	; I think it's better then exiting with divide overflow,
	; some people won't agree I know :)
	CMP	score_h, 9
	JBE	score_is_ok
	MOV	score_h, 9
	MOV	score_l, 0FFF0h		; let last 15 points loop.
    score_is_ok:
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	CALL	SHOW_SCORE

	POP	AX
	RET
INC_SCORE	ENDP

;***************************************************************

SHOW_INSTR	PROC	NEAR
	PUSH	AX
	PUSH	CX
	PUSH	BX
	PUSH	SI
	PUSH	DX

	TILE_SCREEN	0

    ; ****** print the text *******************************************
	LEA	BX, s_inst

	MOV	text_back_color, 0

	MOV	CL, 0
    next_row:
    	MOV	DL, [BX]		; get color of that string.
	MOV	text_fore_color, DL
	MOV	AL, 0
	MOV	AH, CL

	INC	BX			; point to actual string data.

	CALL	DrawString

	; BX points to 0 after DrawString, so adding 1 to BX will point
	; to the next string:
	INC	BX

	INC	CL		; next row.
	CMP	CL, 30		; got to the last row?
	JL	next_row	; - no.
    ; *******************************************************************


    ; ++++++ draw apples and bombs at the screen edges
    	MOV	DX, 16
    next_apple_row:
	LEA	SI, APPLE
	MOV	BX, 16
	CALL	PutIcon		; put apple.
	MOV	BX, 608
	CALL	PutIcon		; put bomb (SI moves to the next pic).
	ADD	DX, 32
	CMP	DX, 480
	JL	next_apple_row
    ; ++++++++++++++++++++++++++++++++

	POP	DX
	POP	SI
	POP	BX
	POP	CX
	POP	AX
	RET
SHOW_INSTR	ENDP

;***************************************************************

THIS_WAS_A_NICE_GAME	PROC	NEAR

	; ----- check score, if it's not zero show validation code, and wait for any key:
	CMP	score_l, 0
	JNZ	show_val_score
	CMP	score_h, 0
	JNZ	show_val_score
	JMP	ok_it_wasnt
     show_val_score:


	SHOW_SCORE_AND_VAL_CODE_INFO s_nice_try


	; wait for key releases:
    wait_release_j:
	CMP	KEYS[KEY_SPACE], 1	; space still pressed?
	JE	wait_release_j		;  - yes.
	CMP	KEYS[KEY_ESC], 1	; ESC still pressed?
	JE	wait_release_j		;  - yes.


	CALL	WAIT_SP

	; ------------------
     ok_it_wasnt:

	RET
THIS_WAS_A_NICE_GAME	ENDP

;***************************************************************

; stores the validation code of score into s_buffer
; (no comment on that:)
MAKE_VAL_CODE	PROC	NEAR
	PUSH	AX
	PUSH	DX
	PUSH	BX
	PUSH	CX

	MOV	AX, score_l
	MOV	DX, score_h

	MOV	s_buffer[0], 'S'
	MOV	s_buffer[1], 'N'
	MOV	BX, 2

	MOV	mWRD, 10

    jnxt:
	DIV	mWRD

	MOV	CX, DX
	ADD	CL, 'A'
	MOV	s_buffer[BX], CL

	INC	BX

	MOV	DX, 0
	CMP	AX, 0
	JNE	jnxt

	MOV	s_buffer[BX], 'X'
	MOV	s_buffer[BX+1], 'P'

	MOV	s_buffer[BX+2], 0		; termination zero.

	POP	CX
	POP	BX
	POP	DX
	POP	AX
	RET
MAKE_VAL_CODE	ENDP

;***************************************************************

; shows status line with all information on it
SHOW_FULL_STATUS	PROC	NEAR
	PUSH	BX
	PUSH	AX

	; set the status line (default):
	MOV	text_fore_color, 46
	MOV	text_back_color, 16
	MOV	AL, 0
	MOV	AH, 0
	LEA	BX, s_status
	CALL	DrawString
	; set data:
	CALL	SHOW_LIVES
	CALL	SHOW_SCORE
	CALL	SHOW_LEVEL

	POP	AX
	POP	BX
	RET
SHOW_FULL_STATUS	ENDP

;***************************************************************

; shows status line with all information on it
SHOW_PAUSE_ON_STATUS	PROC	NEAR
	PUSH	BX
	PUSH	AX

	; set the status line:
	MOV	text_fore_color, 15	; white
	MOV	text_back_color, 16	; black
	MOV	AL, 0		; x
	MOV	AH, 0		; y
	LEA	BX, s_paused
	CALL	DrawString

	POP	AX
	POP	BX
	RET
SHOW_PAUSE_ON_STATUS	ENDP

;***************************************************************

CSEG	ENDS

	END     START	; set entry point.
