;-----------------------------
; hi32.asm - Daniel Schlenzig
; reboot

comment ~

SetRegSize
  IN:  BL = segment registers to change
     +---+---+---+---+---+---+---+---+
     | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
     +---+---+---+---+---+---+---+---+
       |   |   |   |   |   |   |   +--  DS
       |   |   |   |   |   |   +------  ES
       |   |   |   |   |   +----------  FS
       |   |   |   |   +--------------  GS
       |   |   |   +------------------  SS
       |   +---+----------------------  Unused
       +------------------------------  CS
   If the bit is set, the register if able to adress up to 4GB

~

   locals @@
   .model small

   .data

true  equ 1
false equ 0

   .code
   .386p

   public InitHi32,SetRegSize

oldsegs       db ?
regds         dw ?
reges         dw ?
regfs         dw ?
reggs         dw ?
regss         dw ?
GDTPtr        df ?

GDT           dq 0

; CS
CSDes         dw 0FFFFh
              dw ?
              db ?
              db 9Ah
              dw 0000h

; DS, ES, FS, GS, SS (4 GByte)
DSDes         dw 0FFFFh
              dw ?
              db ?
              db 92h
              db 8Fh
              db 00h

; DS, ES, FS, GS, SS (64 KByte)
DSDes64       dw 0FFFFh
              dw ?
              db ?
              db 92h
              dw 0000h

segmss  dw      ?

InitHi32 proc
   smsw  ax
   test  ax, 1
   jz    short @@Init_NoV86
   mov   ax, false
   ret
@@Init_NoV86:
   push  di
   push  ds
   mov   ax, cs
   mov   ds, ax
   mov   oldsegs,0
   mov   di,cs
   mov   cs:[actseg],di
   movzx eax,di
   shl   eax,4
   push  eax
   mov   word ptr cs:[CSDes+2],ax
   mov   word ptr cs:[DSDes+2],ax
   mov   word ptr cs:[DSDes64+2],ax
   shr   eax,16
   mov   byte ptr cs:[CSDes+4],al
   mov   byte ptr cs:[DSDes+4],al
   mov   byte ptr cs:[DSDes64+4],al
   pop   eax
   mov   bx,offset GDT
   movzx ebx,bx
   add   eax,ebx
   mov   dword ptr cs:[GDTPtr+2],eax
   mov   word ptr cs:[GDTPtr],20h
   pop   ds
   pop   di

   mov   ax, true
   ret
InitHi32 endp

SetRegSize proc
   pushad
   push  ds es fs gs
   mov   cs:[segmss], ss

   mov   ax, cs
   mov   ds, ax
   mov   oldsegs, bl
   push  cs
   pop   es
   cld
   mov   byte ptr CSDes + 06H, 00h
   test  bl, 80h
   jz    @@CS64kb
   mov   byte ptr CSDes + 06h, 8Fh
@@CS64kb:
   mov   di, offset regds
   mov   cx, 05h
@@SegLoop:
   mov   ax, 0018h
   shr   bl, 1
   jnc   @@SegOk
   sub   ax, 0008h
@@SegOk:
   stosw
   loop  @@SegLoop
   mov   di, cs
   cli
   mov   al, 80h
   out   70h, al
   lgdt  cs:[GDTPtr]
   mov   eax, cr0
   or    eax, 1
   mov   cr0, eax
   db    0EAh
   dw    offset protmode, 0008h
protmode:
   mov   ds, cs:regds
   mov   es, cs:reges
   mov   fs, cs:regfs
   mov   gs, cs:reggs
   mov   ss, cs:regss
   mov   eax, cr0
   and   eax, 0FFFFFFFEh
   mov   cr0, eax
   db    0EAh
   dw    offset realmode
actseg dw ?
realmode:
   mov   ds, di
   mov   es, di
   mov   fs, di
   mov   gs, di
   mov   ss, cs:[segmss]
   mov   al, 00h
   out   70h, al
   sti
   pop   gs fs es ds
   popad
   ret
SetRegSize endp

   end


