;---------------------------------
; primary.asm by Mitch Ames

; This program checks for the existance of a secondary shell in memory,
; and returns an error level of 1 if so, 0 if not.

; The primary shell is the first program in memory which owns itself (as
; determined by the memory control block).  The program compares its parent's
; PSP with that of the primary PSP to determine whether the primary or a
; secondary shell is running.  Note that if this program is called directly
; from another (via function 4B) it will register the parent as a secondary
; shell.


code    segment
assume  cs:code,ds:code,es:code,ss:code

.radix  16

org     0100

start:  mov     sp,0100                 ;use default DTA as stack
        mov     ah,52                   ;find first memory control block
        int     21
        mov     ax,es:[bx-2]            ;AX points to first MCB segment
mcb:    mov     es,ax                   ;ES is memory control block segment
        inc     ax                      ;AX is memory block segment
        cmp     ax,es:[1]               ;does block own itself?
        jz      shell                   ;first one that does is primary shell
        add     ax,es:[3]               ;calculate address of next MCB
        jmp     mcb

shell:  cmp     ax,ds:[16]              ;is primary shell 
this program's parent?
        mov     al,0                    ;if so, exit code 0
        je      quit
        mov     dx,offset msg           ;else write message
        mov     ah,9
        int     21
        mov     al,1                    ;exit code 1
quit:   mov     ah,4C
        int     21

msg     db      "Secondary shell detected.",13d,10d,"$"


code    ends
end     start

