; From Wladimir van der Laan
;  
;                          
;                      
;                                          
;                        
;  FLAT-Real mode switch code
DATASEG

GDT_SIZE   dw 16        ; GDT Segment limit
GDT_BASE   dd ?         ; GDT Address
LABEL GDT
  dw 0,0,0,0            ; Dummy
  dw 0FFFFh,0,1001001000000000b,0000000011001111b

CODESEG
; Switch to Flat-Real-Mode
  mov ax,cs
  and eax,0FFFFh
  shl eax,4
  add eax,large offset GDT

  mov [GDT_BASE],eax
  lgdt [fword ptr GDT_SIZE]

  cli
  mov eax,cr0
  or ax,1
  mov cr0,eax
  jmp start_PM
start_PM:
  mov ax,8
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  mov eax,cr0
  and ax,0FFFEh
  mov cr0,eax
  jmp exit_PM
exit_PM:
  xor ax,ax
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  sti

  mov ax,cs
  mov ds,ax
  ; END of include file

