; From  Chad Wallace  - Disable MKDIR  (Intercepting INT 21)

; Q. To stop the user's from adding programs, I'd like to intercept and
;    selectively disable the 'Create Directory' DOS function 39h.  Can
;    somebody PLEASE show me an example of a similar TSR or any method
;    that might help me with this problem?
;
; A. I think this should do the trick.  It'll return Access Denied whenever
;    an attempt is made to create a directory:


code_seg        segment
BEGSEG  EQU     $<<             ; Beginning of segment assume  cs:code_seg,
ds:code_seg, es:code_seg, ss:code_seg
        org     100h

begin:
        jmp     init

int21:
        pushf                   ; Save flags
        cmp     ah, 39h         ; Check for Create Subdir.
        jnz     jmp_next        ; If not, jump to other handler

        popf
        stc                     ; Set carry for error
        mov     ax, 5           ; Access Denied
        retf    2               ; Preserve flags but restore stack

jmp_next:
        popf
        db      0eah            ; Far jump
int21off        dw      0       ; To old INT 21 handler
int21seg        dw      0

RESSIZ  EQU     (($ - BEGSEG) / 16) + 1 ; Number of resident paragraphs

init:
        mov     ah, 49h         ; Free environment block
        mov     bx, 2ch
        mov     es, [bx]
        int     21h

        mov     ax, 3521h       ; Get interrupt 21 vector
        int     21h
        mov     int21off, bx    ; Store address by offset
        mov     int21seg, es    ; and segment from BX and ES

        mov     ax, 2521h       ; Set interrupt 21 vector
        mov     dx, offset int21
        int     21h

        mov     ax, 3100h       ; Terminate and stay resident
        mov     dx, RESSIZ      ; Number of paragraphs to keep
        int     21h

code_seg        ends

        end     begin

