bell	equ	7
cr	equ	13
lf	equ	10
tab	equ	9
LINES	equ	48
eol	equ	'$'
esc	equ	27
;
;---------------
;
LPRINT	MACRO	L1,L2,L3,L4,L5,L6	;LPRINT A CHARACTER MACRO

IFNB	<L1>			;SET AL TO THE OPTIONAL PARAMETER
	MOV	AL,L1
	ENDIF
	CALL	LPRINT1		;PRINT THE CHAR

IFNB	<L2>
	LPRINT	L2,L3,L4,L5,L6
	ENDIF

      	ENDM
;
;---------------
;
FORM_FEED	macro
	lprint	12
	endm
;
;---------------
;
SW_LF	macro
	lprint	esc,'J',24,cr
	endm
;
;---------------
;
SW_SET_BIT	macro
	lprint	esc,'K',cl,ch
	endm	      
;
;---------------
;
CSEG    SEGMENT	byte public 'CODE'
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG


	ORG	81H
fname	label	byte
	ORG	100H
START	PROC	NEAR
	jmp	start1

	DB	CR,'Public Domain SideWays (pd)1985 by Donavon Kuhn ',cr,lf,1AH
;
handle		dw	0
char_flag	db	0
end_of_file	db	0
column		dw	0
row		db	0
;
start1:
	lea	dx,inst
	mov	ah,9
	int	21h

	xor	bh,bh
	mov	bl,ds:[80h]		;get length of input filename
	lea	di,fname
	mov	byte ptr [di][bx],0	;make into an ASCIIZ string

;	open	i,1,fname
	lea	di,fname-1		;strip leading spaces
splp:
	inc	di
	cmp	byte ptr [di],' '
	jz	splp

	cmp	byte ptr [di],0
	jz	usage
	cmp	byte ptr [di],'?'
	jnz	no_usage

usage:
	lea	dx,usagestr
	jmp	error1

no_usage:
	mov	dx,di
	mov	ah,3dh
	mov	al,0
	int	21h
	mov	handle,ax
	jnc	no_open_err1
	jmp	error

no_open_err1:
	lea	dx,pausestr
	mov	ah,9
	int	21h

no_open_err:

	lea	di,line_ptr		;fill text buffer with spaces
	mov	al,0
	cld
	mov	cx,LINES*1024+LINES*2
	rep	stosb

	mov	row,0
	lea	di,text_buffer
	mov	bx,0

lflp:
	inc	row
	cmp	row,LINES+1		;reached max lines/page yet?
	jb	not_yet
	jmp	read_done

not_yet:
	mov	line_ptr[bx],di		;pointer to the beginning of the line
	add	bx,2			;don't wreck BX!
	mov	column,0

charlp:
	push	bx
	mov	bx,handle
	mov	ah,3fh			;read char from file
	mov	cx,1
	lea	dx,inbuff
	int	21h
	pop	bx
	cmp	ax,1
	jz	read_ok
donejmp:
	mov	end_of_file,1
	jmp	read_done

read_ok:
	mov	al,byte ptr inbuff	;char in AL

	cmp	al,'Z'-64		;if CTRL-Z
	jz	donejmp	

	cmp	al,lf			;if a new line
	jz	lflp

	cmp	al,cr
	jnz	nocr
	mov	al,0
      	jmp	place
nocr:
	cmp	al,TAB
	jnz	notab
	mov	al,' '
tablp:	
	mov	[di],al
	inc	di
	inc	column
	call	colwidth
	test	column,7
	jnz	tablp	
	jmp	charlp

notab:
	cmp	al,'L'-64
	jz	read_done

	cmp	al,32
	jb	spacectrl

place: 
 	mov	[di],al
	inc	di
	inc	column
	call	colwidth
spacectrl:
	jmp	charlp


colwidth:
	cmp	column,1024
	jb	widthok
	lea	dx,toowide
	jmp	error1
widthok:
	ret



read_done:
	mov	ah,1
	int	16h
	jz	read_done1

	mov	ah,0
	int	16h
	cmp	al,27
	jne	read_done1

	jmp	all_done

read_done1:
	mov	cx,LINES*10
	SW_SET_BIT

	mov	cx,LINES
	lea	si,line_ptr+(LINES*2)-2
	mov	char_flag,0
prlp:
	mov	al,' '
	mov	di,[si]
	cmp	di,0
	jz	printit
	mov	al,[di]
	cmp	al,0
	jnz	notzero
	mov	word ptr [si],0
	mov	al,' '
	jmp	printit

notzero:
	inc	word ptr [si]
	mov	char_flag,1

printit:
	sub	al,32
	mov	ah,8
	mul	ah
	lea	di,swbit
	add	di,ax

	push	cx
	mov	cx,8
cxlp:
	mov	al,[di]
	inc	di
	lprint
	loop	cxlp
	pop	cx

	lprint	0,0

	sub	si,2
	loop	prlp

	SW_LF

	cmp	char_flag,0
	jz	next_page
	jmp	read_done

next_page:

	FORM_FEED

	cmp	end_of_file,0
	jnz	all_done
	jmp	no_open_err

all_done:
	mov	ax,4c00h
	int	21h

;
;-----------------
;
LPRINT1	PROC	NEAR		;LPRINT CHAR IN AL
	push	ax
	push	dx
	XOR	DX,DX
	XOR	AH,AH
	int	17h
	pop	dx
	pop	ax
	ret
LPRINT1 ENDP
;
;-----------------
;
inbuff	db	0

inst	DB	'Public Domain SideWays (pd)1985 by Donavon Kuhn '
	db	cr,lf,cr,lf,eol

toowide	db	'Line width cannot excede 1024 characters.',bell,cr,lf,eol
errmsg	db	'File not Found or Open Error.',bell,cr,lf,eol
pausestr	db	'Press ESC to Cancel',eol


error:
	lea	dx,errmsg
error1:
	mov	ah,9
	int	21h
	mov	ax,4c01h			;error with errorlevel 1
	int	21h
;
;
swbit:
	DB	0,0,0,0,0,0,0,0
	DB	0,16,0,16,16,56,56,16
	DB	0,0,0,0,0,36,36,36
	DB	0,36,36,126,36,126,36,36
	DB	0,24,124,2,60,64,62,24
	DB	0,70,38,16,8,100,98,0
	DB	0,118,136,136,86,48,72,48
	DB	0,0,0,0,0,32,16,16
	DB	0,16,32,64,64,64,32,16
	DB	0,32,16,8,8,8,16,32
	DB	0,0,68,56,254,56,68,0
	DB	0,0,16,16,124,16,16,0
	DB	32,16,16,0,0,0,0,0
	DB	0,0,0,0,126,0,0,0
	DB	0,16,16,0,0,0,0,0
	DB	0,64,32,16,8,4,2,0
	DB	0,60,98,82,74,70,66,60
	DB	0,124,16,16,16,80,48,16
	DB	0,126,66,48,12,2,66,60
	DB	0,60,66,2,28,2,66,60
	DB	0,28,8,254,72,40,24,8
	DB	0,60,66,2,2,124,64,126
	DB	0,60,66,66,124,64,32,28
	DB	0,16,16,16,8,4,66,126
	DB	0,60,66,66,60,66,66,60
	DB	0,56,4,2,62,66,66,60
	DB	0,16,16,0,0,16,16,0
	DB	32,16,16,0,0,16,16,0
	DB	0,8,16,32,64,32,16,8
	DB	0,0,126,0,0,126,0,0
	DB	0,16,8,4,2,4,8,16
	DB	0,8,0,8,4,2,66,60
	DB	0,60,64,94,82,94,66,60
	DB	0,66,66,126,66,66,36,24
	DB	0,124,34,34,60,34,34,124
	DB	0,28,34,64,64,64,34,28
	DB	0,120,36,34,34,34,36,120
	DB	0,126,34,40,56,40,34,126
	DB	0,112,32,40,56,40,34,126
	DB	0,30,34,78,64,64,34,28
	DB	0,66,66,66,126,66,66,66
	DB	0,56,16,16,16,16,16,56
	DB	0,56,68,68,4,4,4,14
	DB	0,99,36,40,48,40,36,98
	DB	0,126,34,32,32,32,32,112
	DB	0,65,65,65,65,73,85,99
	DB	0,66,66,66,70,74,82,98
	DB	0,24,36,66,66,66,36,24
	DB	0,112,32,32,60,34,34,124
	DB	0,3,60,74,66,66,66,60
	DB	0,114,36,40,60,34,34,124
	DB	0,60,66,2,60,64,66,60
	DB	0,28,8,8,8,8,73,127
	DB	0,60,66,66,66,66,66,66
	DB	0,8,20,34,65,65,65,65
	DB	0,54,73,73,73,65,65,65
	DB	0,65,34,20,8,20,34,65
	DB	0,28,8,8,8,20,34,65
	DB	0,127,33,16,8,4,66,127
	DB	0,120,64,64,64,64,64,120
	DB	0,2,4,8,16,32,64,128
	DB	0,120,8,8,8,8,8,120
	DB	0,0,0,0,130,68,40,16
	DB	255,0,0,0,0,0,0,0
	DB	0,0,0,0,0,8,16,16
	DB	0,63,66,62,2,60,0,0
	DB	0,46,49,49,46,32,32,96
	DB	0,60,66,64,66,60,0,0
	DB	0,59,70,70,58,2,2,6
	DB	0,60,64,126,66,60,0,0
	DB	0,56,16,16,56,16,18,12
	DB	124,2,62,66,66,61,0,0
	DB	0,98,34,34,50,44,32,96
	DB	0,56,16,16,16,48,0,16
	DB	60,66,66,2,2,6,0,2
	DB	0,38,40,48,40,36,32,96
	DB	0,56,16,16,16,16,16,48
	DB	0,73,73,73,73,118,0,0
	DB	0,66,66,66,98,92,0,0
	DB	0,60,66,66,66,60,0,0
	DB	112,32,44,50,50,108,0,0
	DB	14,4,52,76,76,54,0,0
	DB	0,112,32,34,50,108,0,0
	DB	0,124,2,60,64,62,0,0
	DB	0,12,18,16,16,124,16,16
	DB	0,58,70,66,66,66,0,0
	DB	0,8,20,34,65,65,0,0
	DB	0,54,73,73,73,65,0,0
	DB	0,68,40,16,40,68,0,0
	DB	124,2,62,66,66,66,0,0
	DB	0,124,32,16,8,124,0,0
	DB	0,12,16,16,96,16,16,12
	DB	0,16,16,16,0,16,16,16
	DB	0,48,8,8,6,8,8,48
	DB	0,0,0,0,0,0,76,50
	DB	0,127,65,65,34,20,8,0
;
;

line_ptr	label	word
usagestr:
	db	cr,lf
	db	'Usage:  PDSW filespec',cr,lf,cr,lf
	db	'Where:  filespec is the name of a file to be printed',cr,lf
	db	'        sideways to an Epson printer on LPT1:',cr,lf,eol

text_buffer	equ line_ptr+LINES*2

;
;
START	ENDP
CSEG	ENDS
	END	START

