; MWDEMO.ASM for ASMDEMO - Copyright (C) 1993 Douglas Herr
;  all rights reserved

include	asm.inc

public	mwdemo
extrn	mwinit:proc, mwdisplay:proc, mwunhide:proc
extrn	mwopen:proc, mwclose:proc, mwcloseall:proc
extrn	mwfill:proc, mwclear:proc, mwborder:proc
extrn	mwprint:proc, mwselect:proc, mwtop:proc
extrn	keyifwaiting:proc, ucursoron:proc, cursoroff:proc
extrn	tprintce:proc, ismouse:proc, tmousestatus:proc, tmousepos:proc

.data
initseg	dw 0
mwh	dw 10 dup(0)		; storage for 10 handles
r0	dw 1,1,15,20
color	db 4
wtext	db 'Window #'
wnumber	db '0',0
position	label word
column	db 1
row	db 1
prompt	db 'Move cursor with keyboard & press ENTER to select window',0
mprompt	db 'Move cursor with key or mouse, press ENTER or click mouse to select window',0
mouse	db 0

.code
mwdemo	proc
	mov	mouse,0FFh
	call	ismouse
	adc	mouse,0
	mov	color,4
	mov	wnumber,'0'
	mov	position,0101h

	call	mwinit
	mov	al,101b		; enable shadow & unhide for all
	mov	initseg,ax	; save segment address of screen buffers
	xor	di,di
	mov	cx,10
m0:	lea	bx,r0
	call	mwopen
	mov	mwh[di],ax
	mov	bx,ax
	mov	ah,color
	mov	al,0
	call	mwborder
	call	mwfill
	lea	si,wtext
	xor	dx,dx
	call	mwprint
	call	mwunhide
	inc	r0
	add	r0+2,2
	inc	r0+4
	add	r0+6,2
	inc	color
	inc	wnumber
	loop	m0

m1:	call	mwdisplay
	lea	si,prompt
	cmp	mouse,0
	je	m1b
	lea	si,mprompt
m1b:	xor	dx,dx
	mov	ah,15
	call	tprintce
m1a:	mov	dx,position
	ror	mouse,1
	jnc	m1c
	call	tmousepos
m1c:	call	ucursoron
m2:	call	keyifwaiting
	cmp	ax,27		; Esc?
	je	exit		;  exit if so
	cmp	ax,13		; Enter?
	je	select
	shr	ah,1		; extended keycode?
	jnc	m2a		;  no, get next key
	cmp	al,72
	je	up
	cmp	al,75
	je	left
	cmp	al,77
	je	right
	cmp	al,80
	je	down

m2a:	ror	mouse,1
	jnc	m2
	call	tmousestatus
	mov	position,dx
	jnz	select
	jmp	m1c		; update cursor position

select:	mov	dx,position
	call	mwselect
	jc	m2
	call	mwtop
	jmp	m1

up:	sub	row,1
	adc	row,0
	jmp	m1a
left:	sub	column,1
	adc	column,0
	jmp	m1a
right:	inc	column
	jmp	m1a
down:	inc	row
	jmp	m1a

exit:	call	mwcloseall
	call	mwdisplay

; restore initial window coordinates
	mov	ax,1
	mov	r0,ax
	mov	r0+2,ax
	mov	r0+4,15
	mov	r0+6,20

; release the screen buffers
	mov	es,initseg
	mov	ah,49h
	int	21h

; hide the cursor
	call	cursoroff

	ret
mwdemo	endp
	end
