;
; GRDP
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; MATH.ASM
;
; Function: Handle hex math
;
	;MASM MODE
	.MODEL SMALL
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include  ebreaks.inc 
include  eoptions.inc
	PUBLIC domath

	.CODE
;
; Do math
;
printx	PROC
	test	[optdword],1
	jnz	PrintDword
	jmp	PrintWord
printx	ENDP
domath	PROC	
	Call	WadeSpace	; Wade till address
	jc	readerr
	call	ReadNumber	; first number
	jc	readerr
	mov	edx,eax
	call	WadeSpace	; get operator
	jz	readerr
	sub	ebx,ebx
	cmp	al,'*'
	jz	got
	inc	bl
	cmp	al,'/'
	jz	got
	inc	bl
	cmp	al,'+'
	jz	got
	inc	bl
	cmp	al,'-'
	jz	got
	inc	bl
	cmp	al,'%'
	jz	got
	dec	si
	mov	bl,5		; default operator = default
got:
	inc	si
	call	WadeSpace
	jz	readerr
	call	ReadNumber	; second number
	jc	readerr
	mov	ecx,eax
	call	WadeSpace
	jnz	readerr
	shl	bl,1		; execute operand
	mov	eax,edx
	push	eax
	call	crlf
	pop	eax
	call	cs:[bx + jumptab]
	call	printx		; print result
	clc
	ret
jumptab	dw	xmul,xdiv,xxadd,xsub,xmod,xdefault
xmul:
	mul	ecx
	ret
xmod:
	call	xdiv
	mov	eax,edx
	ret
xdiv:
	or	eax,eax
	jz	nodiv
	sub	edx,edx
	div	ecx
nodiv:
	ret
xxadd:
	add	eax,ecx
	ret
xsub:
	sub	eax,ecx
	ret

xdefault:		; by default act like debug
	push	eax
	push	ecx
	add	eax,ecx
	call	printx
	call	printspace
	pop	ecx
	pop	eax
	sub	eax,ecx
	ret

readerr:
	stc
	ret
domath	ENDP
end