;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; cpuid.asm
;
; Function: Generic CPU identification
;

	.model small
	.586
;cpuid	macro
;	db	0fh,0a2h
;endm

	public	checkcpu, cpumodel, cpufeatures

	.data
cpufeatures	dd	0	;holds features available
cpumodel	db	0	;model (3,4,5,6 etc.)

	.code
checkcpu	PROC
;
; 8086 has bits 12-15 of flags stuck on
;
	pushf
	pop	bx
	mov	ax,0fffh
	and	ax,bx
	push	ax
	popf
	pushf
	pop	ax
	and	ax,0f000h
	cmp	ax,0f000h
	jz	failed
;
; 80286 has bits 12-15 of flags stuck off
;
	mov	[cpumodel],2
	mov	ax,0f000h
	or	ax,bx
	push	ax
	popf
	pushf
	pop	ax
	and	ax,0f000h
	jz	failed
;
; Now we have a 386 or better.  On a 386 the AC bit (bit 18)
; may not be toggled
;
	mov	[cpumodel],3
	pushfd
	pop	eax
	cli
	mov	dx,sp
	and	sp,NOT 3
	mov	ebx,eax
	btc	eax,18
	push	eax
	popfd
	pushfd
	pop	eax
	push	ebx
	popfd
	mov	sp,dx
	xor	eax,ebx
	bt	eax,18
	jnc	gotid
;
; Now see if a is a pentium or better.  CPUID flag (bit 21) may not
; be toggled on a 486
	mov	[cpumodel],4
	mov	eax,ebx
	btc	eax,21
	push	eax
	popfd
	pushfd
	pop	eax
	xor	eax,ebx
	bt	eax,21
	jnc	gotid
	
;
; It is a pentium or better
;
; so issue a CPUID instruction (level 1) to get the model # and features dword
;
	push	ebx
	mov	eax,1
	cpuid
	mov	[cpufeatures],edx
	and	ah,15
	mov	[cpumodel],ah
	pop	ebx
gotid:
	push	ebx
	popfd
	clc
	ret
failed:
	push	bx
	popf
	stc
	ret
checkcpu	ENDP
	END
