;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; FILL.ASM
;
; Function: Fill memory
;
	;MASM MODE
	.MODEL SMALL
	.386


include  eprints.inc 
include  einput.inc 
include  emtrap.inc 
include  eoptions.inc

	PUBLIC fill


	.CODE
;
; fill command
;
fill	PROC
	call	WadeSpace
	jz	errx
	call	ReadAddress		; read start address
	jc	errx
	call	defDS			; Get DS
	call	WadeSpace
	jz	errx
	call	ReadNumber    		; read length
	jc	errx
	mov	ecx,eax
	sub	ecx,ebx
	jc	errx
	call	WadeSpace
	mov	al,0           		; default fill = 0
	jz	gotfill
	call	ReadNumber		; else read a fill val
	jc	errx
	push	ax
	call	WadeSpace
	pop	ax
	jnz	errx
	test	[optdwordcommand],1
	jnz	gotfill
	movzx	ebx,bx
	movzx	ecx,cx
gotfill:
	push	es			; fill mem
	mov	es,dx
	mov	edi,ebx
	db	67h
	rep	stosb
	pop	es
	clc
	ret
errx:
	stc
	ret
fill	endp
end
