;
; Copyright (C) 2000 Grzegorz Kowal
;

;;
;; MOUSE EXTENTION MACROS
;;

LOCALS


;;
;; EAX ALLWAYS *DESTROYED*
;;

MousePresent	EQU	1
GLOBAL	MouseX:DWORD
GLOBAL	MouseY:DWORD
GLOBAL	MouseXCursorD:BYTE
GLOBAL	MouseXCursorB:BYTE
GLOBAL	_MouseInit:PROC
GLOBAL	_MouseOn:PROC
GLOBAL	_MouseOff:PROC
GLOBAL	_MousePos:PROC
GLOBAL	_MouseCursor:PROC


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseInit ()
;; Reset mouse driver and the extention, pass screen width and heigth.
;; Center mouse cursor, turn if off.
;; NOTE: ALLWAYS USE THIS MACRO AFTER SWITCHING TO A DIFFERENT MODE.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= button data
;;
MouseInit	MACRO
		call	_MouseInit
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseKill ()
;; Disables the mouse driver extention.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseKill	MACRO
		xor	ax,ax
		DosInt	33h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseOn ()
;; Turns the mouse cursor on.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseOn		MACRO
		call	_MouseOn
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseOff ()
;; Turns the mouse cursor off.
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseOff	MACRO
		call	_MouseOff
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; GetMouse ()
;; Get  mouse status.
;;
;; Expects:	nothing
;;
;; Returns:	BX	= button status
;;			  bit 0--left
;;			      1--right
;;			      2--middle
;;		CX	= X-Pos
;;		DX	= Y-Pos
;;
GetMouse	MACRO
		mov	ax,3
		DosInt	33h
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; SetMouse (X,Y)
;; Changes the cursor's position.
;;
;; Expects:	X	= x-pos (word)
;;		Y	= y-pos (word)
;;
;; Returns:	CF	= status [0--ok|1--error]
;;
SetMouse	MACRO	X,Y
		IFDIFI	<X>,<ecx>
			push	ecx
			mov	ecx,X
		ENDIF
		IFDIFI	<Y>,<edx>
			push	edx
			mov	edx,Y
		ENDIF
		call	_MousePos
		IFDIFI	<Y>,<edx>
			pop	edx
		ENDIF
		IFDIFI	<X>,<ecx>
			pop	ecx
		ENDIF
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseCursor (OFFSET to bitmap)
;; Changes the mouse cursor bitmap.
;;
;; Expects:	OFFSET to bitmap
;;
;; Returns:	nothing
;;
MouseCursor	MACRO	P1
		push	edx
		lea	edx,P1
		call	_MouseCursor
		pop	edx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseReadyCur
;; Changes the mouse cursor to an "arrow" (default).
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseReadyCur	MACRO
		push	edx
		lea	edx,MouseXCursorD
		call	_MouseCursor
		pop	edx
		ENDM


;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;; MouseBusyCur
;; Changes the mouse cursor to an "hourglass".
;;
;; Expects:	nothing
;;
;; Returns:	nothing
;;
MouseBusyCur	MACRO
		push	edx
		lea	edx,MouseXCursorB
		call	_MouseCursor
		pop	edx
		ENDM
