.nolist
ifndef	LIB_INC

comment 
	LIB.INC							V1.00
==========================================================================
NAME
	LIB.INC		 Iinclude file to specify ASM libraries

DESCRIPTION
	This include file is used if code from a ALIB is to be included
	in the program.  The defined memory model determines which library
	will be used.

	Note:  The '?' in "alib?" represents the DOS wildcard so "alib?"
	represents for all alib libraries.

PROGRAMMING NOTES
	Listing is turned off so that this include file do not lengthen the
	source file listings.

	Also, all library procedures are defined in the proper relationship
	with the current code segment.	This requires that each procedure
	appears twice in this .inc file.

	Any procedure added to the alib? libraries shold be added to this
	.inc file so that referencing alib? procedures requires no other
	intervention by the programmer except including this .inc file.

	externdef is used so that if the procedure is not actually used in
	the code, the procedures reference will not appear in the .obj
	file.  This technique ensures that only actually referenced alib?
	procedures are included in the resulting executible.

	Currently, all procedures use registers to pass information to the
	alib? procedures.  Therefore, the use of the Proto directive does
	not appear in this .inc file.

CAUTION
	This include file must be placed after the .model directive so that
	the memory model is defined.

AUTHOR
	Raymond Moon - 6 Oct 95
	Copyright 1995 - Raymond Moon
	ALL RIGHTS RESERVED

HISTORY
	Version - Date		- Remarks
	1.00	-  6 Oct 95	- Original

==========================================================================
	 End of Comment

;----------------------------
;	Define equate to identify this include file to preclude being
;	included more than once.

LIB_INC	equ	1

;----------------------------
;	Define the appropriate library for the appropriate memory model.

if	@Model	EQ 1
	includelib	ALIBT
elseif	@Model	EQ 2
	includelib	ALIBS
elseif	@Model	EQ 3
	includelib	ALIBC
elseif	@Model	EQ 4
	includelib	ALIBM
elseif	@Model	EQ 5
	includelib	ALIBL
elseif	@Model	EQ 6
	includelib	ALIBH
endif

;----------------------------
;	Define all procedures available in alib? with the proper relationship
;	to .CODE segment and NEAR and FAR attributes

if	@CodeSize				; Large Code Models

externdef	Bin2Hex:FAR
externdef	Stack_Check:FAR
externdef	Print:FAR
externdef	Puts:FAR
externdef	UtoA:FAR
.CODE

else

.CODE
externdef	Bin2Hex:NEAR
externdef	Stack_Check:NEAR
externdef	Print:NEAR
externdef	Puts:NEAR
externdef	UtoA:NEAR

endif

@CurSeg ends
;----------------------------
;	Clean up

endif					; Close opening ifndef
.list					; Turn list back on
