;
; *** Listing 11-14 ***
;
; Finds the first occurrence of the letter 'z' in
; a zero-terminated string, using LODSW and checking
; 2 bytes per read.
;
	jmp	Skip
;
TestString	label	byte
	db	'This is a test string that is '
	db	'z'
	db	'terminated with a zero byte...',0
;
; Finds the first occurrence of the specified byte in the
; specified zero-terminated string.
;
; Input:
;	AL = byte to find
;	DS:SI = zero-terminated string to search
;
; Output:
;	SI = pointer to first occurrence of byte in string,
;		or 0 if the byte wasn't found
;
; Registers altered: AX, BL, SI
;
; Direction flag cleared
;
; Note: Do not pass a string that starts at offset 0 (SI=0),
;	since a match on the first byte and failure to find
;	the byte would be indistinguishable.
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
FindCharInString:
	mov	bl,al	;we'll need AX since that's the
			; only register LODSW can use
	cld
FindCharInStringLoop:
	lodsw		;get the next 2 string bytes
	cmp	al,bl	;is the first byte the byte we're
			; looking for?
	jz	FindCharInStringDoneAdjust
			;yes, so we're done after we adjust
			; back to the first byte of the word
	and	al,al	;is the first byte the terminating
			; zero?
	jz	FindCharInStringNoMatch ;yes, no match
	cmp	ah,bl	;is the second byte the byte we're
			; looking for?
	jz	FindCharInStringDone
			;yes, so we're done
	and	ah,ah	;is the second byte the terminating
			; zero?
	jnz	FindCharInStringLoop
			;no, so check the next 2 bytes
FindCharInStringNoMatch:
	sub	si,si	;we didn't find a match, so return
			; 0 in SI
	ret
FindCharInStringDoneAdjust:
	dec	si	;adjust to the first byte of the
			; word we just read
FindCharInStringDone:
	dec	si	;point back to the matching byte
	ret
;
Skip:
	call	ZTimerOn
	mov	al,'z'		;byte value to find
	mov	si,offset TestString
				;string to search
	call	FindCharInString ;search for the byte
	call	ZTimerOff
