/****************************************************************

	gr_test.c       Validation program for Bywater
			Graphics Interface standard

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "signal.h"

#ifdef __STDC__
#include "malloc.h"
#else
extern char * malloc();
#define size_t  int
#endif

#include "bw.h"
#include "gr.h"
#include "kb.h"

struct gr_window main_window;
char tbuf[ 128 ];
char bw_ebuf[ BW_EBUFSIZE ];
int x_pos, y_pos, b_stat;
int x, y;
int bsize;
static int image;
int test_quit();

main()
   {
   register int c;

   gr_init( &main_window, NULL );
   kb_init();

   signal( SIGTERM, test_quit );

   /* set a font equal to 1/25 of the screen height */

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 25 );

   c = 0;
   while ( c != 0x1b )
      {
      gr_cls( GR_PRIMARY );
      gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
	 WHITE, SOLID );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
	 " Bywater gr (Graphics and Mouse) Interface Validation: ",
	 BLACK, WHITE );
      if ( gr_ismouse == TRUE )
	 {
	 gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 3 ),
	    "Mouse detected.", WHITE, BLACK );
	 }
      else
	 {
	 gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 3 ),
	    "No mouse detected.", WHITE, BLACK );
	 }
      sprintf( tbuf, "Screens supported:  %d ", gr_screens );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 4 ), tbuf, WHITE, BLACK );
      sprintf( tbuf, "Window size:  X axis, %d pixels; Y axis, %d pixels",
	 main_window.xmax, main_window.ymax );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 5 ), tbuf, WHITE, BLACK );

      sprintf( tbuf, "Pixel size:  X axis, %d pixels; Y axis, %d pixels",
	 gr_pxsize, gr_pysize );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 6 ), tbuf, WHITE, BLACK );

      sprintf( tbuf, "Font size:  X axis, %d pixels; Y axis, %d pixels",
	 main_window.fxsize, main_window.fysize );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 7 ), tbuf, WHITE, BLACK );

      sprintf( tbuf, "Colors available: %d", gr_colors );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 8 ), tbuf, WHITE, BLACK );

      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 10 ),
	 " 1  Validate gr_font() and gr_text()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 11 ),
	 " 2  Validate gr_pixel()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 12 ),
	 " 3  Validate gr_line()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 13 ),
	 " 4  Validate gr_rectangle()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 14 ),
	 " 5  Validate gr_circle()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 15 ),
	 " 6  Validate gr_imsave()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 16 ),
	 " 7  Validate gr_blit()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 17 ),
	 " 8  Validate gr_mouse()", WHITE, BLACK );
      gr_text( GR_PRIMARY, txt_x( 5 ), txt_y( 19 ),
	 " 9  EXIT", WHITE, BLACK );

      c = kb_rx();

      switch( c )
	 {
	 case '1':
	    val_font();
	    break;
	 case '2':
	    val_pixel();
	    break;
	 case '3':
	    val_line();
	    break;
	 case '4':
	    val_rectangle();
	    break;
	 case '5':
	    val_circle();
	    break;
	 case '6':
	    val_save();
	    break;
	 case '7':
	    val_blit();
	    break;
	 case '8':
	    val_mouse();
	    break;
	 case '9':
	 case 0x1b:
	    c = 0x1b;
	    break;
	 }


      }

   val_exit();

   }


/* 1: validate gr_font(), and gr_text()   */

val_font()
   {
   gr_cls( GR_PRIMARY );
   gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
      WHITE, SOLID );
   gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
      "GR test # 1:  gr_font() validation.",
      BLACK, WHITE );

   x = main_window.xmax / 10;
   y = main_window.ymax / 18;

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 40 );
   sprintf( tbuf, "Test size ymax / 40:  %dx%d font",
      main_window.fysize, main_window.fxsize );
   gr_text( GR_PRIMARY, x, y, tbuf, WHITE, BLACK );

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 30 );
   sprintf( tbuf, "Test size ymax / 30:  %dx%d font",
      main_window.fysize, main_window.fxsize );
   gr_text( GR_PRIMARY, x, y * 2, tbuf, WHITE, BLACK );

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 25 );
   sprintf( tbuf, "Test size ymax / 25:  %dx%d font",
      main_window.fysize, main_window.fxsize );
   gr_text( GR_PRIMARY, x, y * 4, tbuf, WHITE, BLACK );

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 20 );
   sprintf( tbuf, "Test size ymax / 20:  %dx%d font",
      main_window.fysize, main_window.fxsize );
   gr_text( GR_PRIMARY, x, y * 8, tbuf, WHITE, BLACK );

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 15 );
   sprintf( tbuf, "Test size ymax / 15:  %dx%d font",
      main_window.fysize, main_window.fxsize );
   gr_text( GR_PRIMARY, x, y * 12, tbuf, WHITE, BLACK );

   gr_font( GR_PRIMARY, F_DEFAULT, main_window.ymax / 25 );
   kb_rx();

   }

/* 2: validate gr_pixel() */

val_pixel()
   {
   register int c;

   gr_cls( GR_PRIMARY );
   gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
      WHITE, SOLID );
   gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
      "GR test # 2:  gr_pixel() validation.",
      BLACK, WHITE );

   x = main_window.xmax / 4;
   y = ( main_window.ymax / 4 ) * 3;
   c = 0;
   while ( ( c < gr_colors ) && ( y > main_window.fysize ) )
      {
      gr_pixel( GR_PRIMARY, x, y, c );
      sprintf( tbuf, " <- pixel color %d at x = %d, y = %d", 
         c, x, y );
      gr_text( GR_PRIMARY, x + ( 3 * main_window.fxsize ), 
         y - ( main_window.fysize / 2 ), tbuf, WHITE, BLACK );
      ++c;
      y -= ( main_window.fysize / 2 ) * 3;
      }
   kb_rx();

   }

/* 3: validate gr_line() */

val_line()
   {
   register int c;

   gr_cls( GR_PRIMARY );
   gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
      WHITE, SOLID );
   gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
      "GR test # 3:  gr_line() validation.",
      BLACK, WHITE );

   x = main_window.xmax / 8;
   y = ( main_window.ymax / 4 ) * 3;
   c = 0;
   while ( ( c < gr_colors ) && ( y > main_window.fysize ) )
      {
      gr_line( GR_PRIMARY, x, y, x + main_window.xmax / 20, y, 
         c, SOLID );
      x += main_window.xmax / 10;
      gr_line( GR_PRIMARY, x, y, x + main_window.xmax / 20, y, 
         c, HATCH );
      sprintf( tbuf, " <- lines, color %d at x = %d, y = %d", 
         c, x, y );
      gr_text( GR_PRIMARY, x + ( 3 * ( main_window.xmax / 20 )), 
         y - ( main_window.fysize / 2 ), tbuf, WHITE, BLACK );
      ++c;
      x -= main_window.xmax / 10;
      y -= ( main_window.fysize / 2 ) * 3;
      }
   kb_rx();

   gr_cls( GR_PRIMARY );
   for ( x = 0; x < main_window.xmax; x += 15 )
      {
      gr_line( GR_PRIMARY, x, 0, 0, main_window.ymax,
	 WHITE, SOLID );
      }

   for ( y = main_window.ymax - 10; y > 0; y -= 15 )
      {
      gr_line( GR_PRIMARY, 0, y, main_window.xmax, 0,
	 WHITE, SOLID );
      }

   kb_rx();

   }

/* 4: validate gr_rectangle() */

val_rectangle()
   {

   gr_cls( GR_PRIMARY );
   gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
      WHITE, SOLID );
   gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
      "GR test # 4:  gr_rectangle() validation.",
      BLACK, WHITE );

   x = main_window.xmax / 40;
   y = main_window.ymax / 20;
   gr_rectangle( GR_PRIMARY, x * 4, y * 16, x * 6, y * 18, WHITE, HOLLOW );
   gr_text( GR_PRIMARY, x * 10, y * 17, "Hollow rectangle", WHITE, BLACK );
   gr_rectangle( GR_PRIMARY, x * 4, y * 12, x * 6, y * 14, WHITE, SOLID );
   gr_text( GR_PRIMARY, x * 10, y * 13, "Solid rectangle", WHITE, BLACK );
    gr_rectangle( GR_PRIMARY, x * 4, y * 8, x * 6, y * 10, WHITE, GRID );
   gr_text( GR_PRIMARY, x * 10, y * 9, "Grid rectangle", WHITE, BLACK );
    gr_rectangle( GR_PRIMARY, x * 4, y * 4, x * 6, y * 6, WHITE, HATCH );
   gr_text( GR_PRIMARY, x * 10, y * 5, "Hatch rectangle", WHITE, BLACK );
   kb_rx();
   }

/* 5: validate gr_circle() */

val_circle()
   {
   gr_cls( GR_PRIMARY );
   gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
      WHITE, SOLID );
   gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
      "GR test # 5:  gr_circle() validation.",
      BLACK, WHITE );

   x = main_window.xmax / 40;
   y = main_window.ymax / 20;
   gr_circle( GR_PRIMARY, x * 5, y * 17, (y/2)*3, WHITE, HOLLOW );
   gr_text( GR_PRIMARY, x * 10, y * 17, "Hollow circle", WHITE, BLACK );
   gr_circle( GR_PRIMARY, x * 5, y * 13, (y/2)*3, WHITE, SOLID );
   gr_text( GR_PRIMARY, x * 10, y * 13, "Solid circle", WHITE, BLACK );
    gr_circle( GR_PRIMARY, x * 5, y * 9, (y/2)*3, WHITE, GRID );
   gr_text( GR_PRIMARY, x * 10, y * 9, "Grid circle", WHITE, BLACK );
    gr_circle( GR_PRIMARY, x * 5, y * 5, (y/2)*3, WHITE, HATCH );
   gr_text( GR_PRIMARY, x * 10, y * 5, "Hatch circle", WHITE, BLACK );
   kb_rx();
   }

/* 6: test gr_imsave() */

val_save()

   {

   /* if saving is allowed, save a portion of the screen here */

   if ( gr_saving )
      {
      x = main_window.xmax / 10;
      y = main_window.ymax / 18;

      gr_imsave( GR_PRIMARY, TRUE, x, y * 3, x * 6, y * 8, &image );
	   gr_rectangle( GR_PRIMARY, x, y * 3, x * 6, y * 8, WHITE, HOLLOW );



      /* now show the portion saved earlier */

      gr_cls( GR_PRIMARY );
      gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
	 WHITE, SOLID );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
	 "GR test # 6:  gr_imsave() validation.",
         BLACK, WHITE );

      gr_imsave( GR_PRIMARY, FALSE, x, y * 3, x * 6, y * 8, &image );
           gr_rectangle( GR_PRIMARY, x, y * 3, x * 6, y * 8, WHITE, HOLLOW );
      kb_rx();
      }
   }

/* 7: validate gr_blit() */

val_blit()
   {

   /* if there is more than one screen, validate screen writes and blits */

   if ( gr_blitting == TRUE )
      {
      gr_cls( GR_PRIMARY );
      gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
	 WHITE, SOLID );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
	 "GR test # 7:  gr_blit() validation.",
	 BLACK, WHITE );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 4 ),
	 "  this has been written to screen GR_PRIMARY.",
	 BLACK, WHITE );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 5 ),
	 "  but after you hit RETURN GR_HIDDEN ",
	 BLACK, WHITE );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 6 ),
	 "  will be blitted to this screen  ",
	 BLACK, WHITE );
      gr_text( GR_HIDDEN, txt_x( 0 ), txt_y( 0 ),
	 "  gr_blit() validation.",
	 BLACK, WHITE );
      gr_text( GR_HIDDEN, txt_x( 0 ), txt_y( 4 ),
	 "  this has been written to screen GR_HIDDEN.",
	 BLACK, WHITE );
      gr_text( GR_HIDDEN, txt_x( 0 ), txt_y( 5 ),
	 "  and has now been blitted over ",
	 BLACK, WHITE );
      gr_text( GR_HIDDEN, txt_x( 0 ), txt_y( 6 ),
	 "  to GR_PRIMARY  ",
	 BLACK, WHITE );

      kb_rx();
      gr_blit( GR_HIDDEN, GR_PRIMARY, 0, 0,
	 main_window.xmax,
	 main_window.ymax );
      kb_rx();
      }
   }

/* 8: validate mouse */

val_mouse()
   {
   register int c;

   /* If mouse exists, validate it */

   if ( gr_ismouse == TRUE )
      {
      gr_cls( GR_PRIMARY );
      gr_rectangle( GR_PRIMARY, 0, txt_y( 0 ), main_window.xmax, main_window.ymax,
	 WHITE, SOLID );
      gr_text( GR_PRIMARY, txt_x( 0 ), txt_y( 0 ),
	 "GR test # 8:  gr_mouse() validation.",
         BLACK, WHITE );

      x = main_window.xmax / 40;
      y = main_window.ymax / 20;

      while ( gr_mouse( STATUS, &x_pos, &y_pos, &b_stat ) != TRUE )
	 {
	 sprintf( tbuf, "Mouse position:  x = %d, y = %d    ",
	    x_pos, y_pos );
	 gr_text( GR_PRIMARY, x * 10, y * 17, tbuf, WHITE, BLACK );
	 }
      gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
      gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );

      c = 0;
      while( ( kb_rxstat() == FALSE ) && ( c < 12 ))
         {
	 ++c;
         gr_mouse( WAIT, &x_pos, &y_pos, &b_stat );
         sprintf( tbuf, "Mouse position:  x = %d, y = %d    ",
            x_pos, y_pos );
         gr_text( GR_PRIMARY, x * 10, y * 17, tbuf, WHITE, BLACK );
         }
      }
   }

val_exit()

   {

   /* Finished with validation:  clear screen and restore original state */

   gr_cls( GR_PRIMARY );
   kb_deinit();
   gr_deinit();
   }

txt_y( line )
   int line;
   {
   return ( main_window.ymax ) - ( main_window.fysize * ( line + 1 ));
   }

txt_x( column )
   int column;
   {
   return column * main_window.fxsize;
   }

test_quit()
   {
   gr_cls( GR_PRIMARY );
   kb_deinit();
   gr_deinit();
   }

bw_error( m )
   char *m;
   {
   fprintf( stderr, "ERROR: %s \n", m );
   }


