
(defun C:PIPE3D (/ rad r n)
;; 3D Pipeline drawing program for AutoCAD
;; (C) 1996 by Joseph Toth
;;
;; Pipeline contains n turning points (including begining and ending points),
;;   which determine (n - 1) linear pipe sections (some may have zero length!)
;;   and (n - 2) bendings between the linear sections.

  (setvar "blipmode" 0)
  (setvar "cmdecho" 0)
  (initget 1)
  (alert "\n3D Pipeline Drawing Program for AutoCAD.
          \n      (C) 1996 by Joseph Toth")
  (write-line "***    Please enter pipeline data    ***")
  (while (< n 2)
    (setq n (getint "\nNumber of turning points (including begin and end) (n >= 2) :"))
  )
  (setq rad (/ (getreal "\n Pipe diameter : ") 2))
  (if (> n 2)
    (while (< r rad)
      (setq r (getreal "\n Bending radius : "))
    )
  )
  (setq m 0)
  (setq pontok ())
  (while (< m n)
    (setq m (1+ m))
    (setq adatbe (strcat "\n " (itoa m) ". turning point [x,y,z]: "))
    (setq pt (getpoint adatbe))
    (setq pontok (cons pt pontok))
  )
  (setq m (1- m))
  (setq cen1 (nth m pontok))

 (while (> m 0)
  (setq cen2 (nth (- m 1) pontok))
    (setq x1 (nth 0 cen1))
    (setq y1 (nth 1 cen1))
    (setq z1 (nth 2 cen1))
    (setq x2 (nth 0 cen2))
    (setq y2 (nth 1 cen2))
    (setq z2 (nth 2 cen2))
        (setq alfa1 (atan (- y2 y1) (- x2 x1)))
        (setq beta1 (sqrt (+ (* (- x2 x1) (- x2 x1)) (* (- y2 y1) (- y2 y1)))))
        (setq beta1 (atan beta1 (- z2 z1)))
    (setq apt cen2)

  (if (> m 1)
    (progn
      (setq cen3 (nth (- m 2) pontok))
      (setq x3 (nth 0 cen3))
      (setq y3 (nth 1 cen3))
      (setq z3 (nth 2 cen3))
        (setq alfa2 (atan (- y2 y3) (- x2 x3)))
        (setq beta2 (sqrt (+ (* (- x2 x3) (- x2 x3)) (* (- y2 y3) (- y2 y3)))))
        (setq beta2 (atan beta2 (- z2 z3)))
       (setq a (sqrt (+ (* (- x2 x1) (- x2 x1)) (* (- y2 y1) (- y2 y1)) (* (- z2 z1) (- z2 z1)))))
       (setq b (sqrt (+ (* (- x3 x2) (- x3 x2)) (* (- y3 y2) (- y3 y2)) (* (- z3 z2) (- z3 z2)))))
       (setq c (sqrt (+ (* (- x3 x1) (- x3 x1)) (* (- y3 y1) (- y3 y1)) (* (- z3 z1) (- z3 z1)))))
      (setq cgamma (/ (- (+ (* a a) (* b b)) (* c c)) (* 2 a b)))
        (if (= cgamma 0)
           (setq gamma (/ pi 2))
           (progn
              (setq tgamma (sqrt (1- (/ 1 (* cgamma cgamma)))))
              (setq gamma (atan tgamma))
           )
        )
        (if (> cgamma 0)
           (setq gamma (- pi gamma))
        )

      (setq h (cos (/ gamma 2)))
      (setq h (* (sqrt (1- (/ 1 (* h h)))) r))

      (setq dz1 (* (cos beta1)  h))
      (setq dy1 (* (sin beta1) h (sin alfa1)))
      (setq dx1 (* (sin beta1) h (cos alfa1)))
         (setq za (- z2 dz1))
         (setq ya (- y2 dy1))
         (setq xa (- x2 dx1))
      (setq apt (list xa ya za))

      (setq dz2 (* (cos beta2) h))
      (setq dy2 (* (sin beta2) h (sin alfa2)))
      (setq dx2 (* (sin beta2) h (cos alfa2)))
         (setq zb (- z2 dz2))
         (setq yb (- y2 dy2))
         (setq xb (- x2 dx2))
      (setq bpt (list xb yb zb))

        (setq xc (/ (+ xa xb) 2))
        (setq yc (/ (+ ya yb) 2))
        (setq zc (/ (+ za zb) 2))

        (setq alfac (atan (- yc y2) (- xc x2)))
        (setq betac (sqrt (+ (* (- xc x2) (- xc x2)) (* (- yc y2) (- yc y2)))))
        (setq betac (atan betac (- zc z2)))

      (setq l (sqrt (+ (* r r) (* h h))))
        (setq dz (*  (cos betac) l))
        (setq dy (* (sin betac) l (sin alfac)))
        (setq dx (* (sin betac) l (cos alfac)))
        (setq z (+ z2 dz))
        (setq y (+ y2 dy))
        (setq x (+ x2 dx))
      (setq cen (list x y z))
      (setq gamma (atof (angtos gamma 0 1)))
    )
  )
  (setq alfa1 (atof (angtos alfa1 0 1)))
  (setq beta1 (atof (angtos beta1 0 1)))


  (setq numseg 36)
  (setvar "SURFTAB1" numseg)

  (command "_.UCS" "_z" alfa1)
  (command "_.UCS" "_y" beta1)
  (setq undoit T)

  (setq cen1 (trans cen1 0 1))
  (setq apt (trans apt 0 1))

  (command "_.CIRCLE" cen1 rad)
  (setq e1 (entlast))
  (command "_.CIRCLE" apt rad)
  (setq e2 (entlast))

  (command "_.RULESURF" (list e1 cen1) (list e2 apt))
  (entdel e1)

  (if (> m 1)
    (progn

      (setq sz (fix (/ gamma 10)))
      (if (= sz 0) (setq sz 1))
      (setq numseg1 sz)
      (setvar "SURFTAB1" numseg1)
      (setvar "SURFTAB2" numseg)

      (setq bpt (trans bpt 0 1))
      (setq cen (trans cen 0 1))

      (setq hrad (- r rad))
      (setq tcen (list (+ (+ (car cen) rad) hrad) (cadr cen) (caddr cen)))

      (setq a (- (cadr cen) (cadr apt)))
      (setq b (- (car cen) (car apt)))
      (setq ax (list (+ (car cen) a) (- (cadr cen) b) (caddr cen)))

      (command "_.LINE" cen ax "")
      (setq e1 (entlast))
      (command "_.REVSURF" (list e2 tcen) (list e1 ax) "" gamma)
      (entdel e1)
      (entdel e2)

      (setq bpt (trans bpt 1 0))
      (command "_.UCS" "_w")

      (setq cen1 bpt)
    )
    (progn
      (command "_.UCS" "_w")
      (entdel e2)
    )
  )
 (setq m (1- m))
 )
 (command "_.HIDE")
 (setvar "blipmode" 1)
 (setvar "cmdecho" 1)
)