@echo off

rem     $Id: asettst.bat 1.1 1993/03/09 13:22:25 Ricki Exp $
rem ------------------------------------------------------------------
rem     Batch file to create a log file containing lots of examples
rem     on how to use ASET. The log file name is ASETTST.OUT
rem ------------------------------------------------------------------
rem
rem     $Log: asettst.bat $
rem     Revision 1.1  1993/03/09  13:22:25  Ricki
rem     Initial revision
rem

rem     check if the designated output file already exists.
rem     if yes, output a warning and stop

if exist ASETTST.OUT goto warnexis

rem     create the output file by calling ASET with 6 of the 7 test
rem     files ASETx.TST (number 5 is omitted because interaction is
rem     required here)
rem
rem     ASET is invoked with the following switches here:
rem       -fASETx.TST   the input is read from ASETx.TST, not the command line
rem       -n            don't actually modify the environment, just simulate
rem       -r            repeat the assignment on standard output

for %%a in (1 2 3 4 6 7) do aset -fASET%%a.TST -n -r >> ASETTST.OUT

rem     if something failed, display a warning, otherwise exit

if errorlevel 1 goto warnfail

echo Everything worked fine. Look in ASETTST.OUT for the results of the test!
goto end

:warnexis
echo WARNING: The output file ASETTST.OUT does already exist! Remove it first!
goto end

:warnfail
echo WARNING: ASET failed for some reason (look at the above error message).
echo          The test is aborted.

:end

