{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'database.int'}
{$include: 'datainit.int'}

IMPLEMENTATION OF datainit;

USES types,globals,utils,database;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

{***Interface to MS Pascal library***}
procedure endxqq; EXTERN;

const
  tab = chr(9);

var
  rows [ORIGIN 16#40:16#84] : byte;
  com1_port [EXTERN] : word;
  com2_port [EXTERN] : word;
  status_port1 [EXTERN] : word;
  status_port2 [EXTERN] : word;
  bits8 [EXTERN] : word;
  eskape [EXTERN] : byte;
  hostecho [PUBLIC] : boolean;
  dcd_ok [PUBLIC] : boolean;

{strip trailing blanks and comments}
procedure stripc(var str : lstring);
var
  i : integer;
begin
  for i:=1 to ord(str.len) do
    if str[i]=chr(0) or else str[i]='{' then
      [str.len:=wrd(i-1); break];
  for i:=ord(str.len) downto 1 do
    if str[i]=' ' or else str[i]=tab then str.len:=str.len-1 else break;
end {stripc};

procedure opengl;
begin
  f_globals.trap:=true;
  f_globals.errs:=0;
  assign(f_globals,globs);
  reset(f_globals);
  if f_globals.errs=0 then readln(f_globals,number_of_calls);
  if f_globals.errs=0 then readln(f_globals,last_new_user);
  if not eof(f_globals) then readln(f_globals,mem_avl);
  close(f_globals);
end {opengl};

procedure db_open_all;
var
  i : integer;
  pm1,pm2 : pubmail_ptr;
  str : lstring(screen_cols);
  ud,ut,u_day,u_time : integer4;
  flag : boolean;
begin
  last_save:=jt;
{params}
  write('4');
  assign(f_params,'PARAMS');
  reset(f_params);
  readln(f_params,new_user_level);
  readln(f_params,shortest_password);
  readln(f_params,min_age);
  readln(f_params,who_b_low);
  readln(f_params,last_called_default);
  readln(f_params,times_called_default);
  readln(f_params,userlog_max);
  readln(f_params,msg_line_limit);
  readln(f_params,mbx_slot_limit);
  readln(f_params,many_calls);
  readln(f_params,closing_target);
  readln(f_params,prime);
  for i:=0 to 9 do
    [read(f_params,time_limit[i]);
     if time_limit[i]<0 then time_limit[i]:=0];
  readln(f_params);
  readln(f_params,chat_time_limit);
  readln(f_params,prime_on);
  readln(f_params,priv_reply);
  readln(f_params,prime_access);
  readln(f_params,priv_ans);
  readln(f_params,priv_bio);
  readln(f_params,priv_order);
  readln(f_params,priv_send);
  readln(f_params,priv_post);
  readln(f_params,priv_chat);
  readln(f_params,priv_bchatted);
  readln(f_params,priv_gchat);
  readln(f_params,priv_ad);
  readln(f_params,priv_download);
  readln(f_params,priv_upload);
  readln(f_params,priv_x);
  readln(f_params,priv_m);
  readln(f_params,priv_br);
  readln(f_params,priv_ma);
  readln(f_params,priv_us);
  readln(f_params,priv_cl);
  readln(f_params,priv_db);
  readln(f_params,verify_on);
  readln(f_params,verify_target);
  readln(f_params,order_target);
  readln(f_params,file_realname); stripc(file_realname);
  readln(f_params,timeout);
  readln(f_params,beep_length);
  readln(f_params,new_prime);
  readln(f_params,confirm_multiple);
  readln(f_params,confirm_essay);
  readln(f_params,log_lowest);
  readln(f_params,priv_log);
  readln(f_params,essay_required);
  readln(f_params,auto_delete);
  readln(f_params,set_modem_cmd); stripc(set_modem_cmd);
  readln(f_params,business);
  for i:=1 to 6 do read(f_params,modem_delay[i]); readln(f_params);
  readln(f_params,allow_new);
  readln(f_params,max_retries);
  readln(f_params,com1_port);
  readln(f_params,com2_port);
  readln(f_params,status_port1);
  readln(f_params,status_port2);
  readln(f_params,dcd_ok);
  readln(f_params,nBump);
  readln(f_params,megs_min);
  readln(f_params,d4dnload);
  readln(f_params,u4upload);
  readln(f_params,brief_len);
  readln(f_params,time_comments);
  readln(f_params,path_library); stripc(path_library);
  readln(f_params,chat_repeats);
  readln(f_params,opening_w);
  readln(f_params,log_bul);
  readln(f_params,notify_max);
  readln(f_params,nattr,iattr,gattr);
  readln(f_params,path_db); stripc(path_db);
  readln(f_params,bumpmax);
  readln(f_params,privnbm); !no bump max
  readln(f_params,min_db);
  readln(f_params,prefdef); prefdef:=uc(prefdef);
  if rows>24 then srm1:=ord(rows) else srm1:=24;
  gstat:=srm1; screen_rows:=srm1+1;
  readln(f_params,defchat); defchat:=uc(defchat);
  if defchat<>'N' and then defchat<>'P' then defchat:=' ';
  readln(f_params,defpage);
  readln(f_params,realen);
  readln(f_params,metric);
  readln(f_params,flag); if flag then bits8:=16#7f else bits8:=16#ff;
  readln(f_params,flag); if flag then eskape:=16#7f else eskape:=0;
  readln(f_params,hostecho);
  readln(f_params,wrap_column);
  readln(f_params,channels);
  readln(f_params,max_logtries);
  readln(f_params,no_remote9s);
  readln(f_params,file_dlog); stripc(file_dlog);
  readln(f_params,file_ulog); stripc(file_ulog);
  readln(f_params,file_olog); stripc(file_olog);
  readln(f_params,fEmpties);
  readln(f_params,ps2mc8);
  readln(f_params,p2chatoff);
  readln(f_params,priv_junk);
  readln(f_params,fTrust);
  readln(f_params,pwdigp);
  close(f_params);
{members}
  write('5');
  f_members.trap:=true;
  f_members.errs:=0;
  assign(f_members,members);
  reset(f_members);
  number_of_members:=0;
  largest_member_number:=0;
  while (f_members.errs=0) and then (not eof(f_members)) do begin
    readln(f_members,member_internal_buffer);
    if f_members.errs=0 then
      [largest_member_number:=largest_member_number + 1;
       movel(adr member_internal_buffer,adr member_buffer,member_length);
       if ivalue(member_buffer.userid)<>largest_member_number then
         writeln('MEMBERS file corrupt at record ',largest_member_number:1);
       if member_buffer.active[1]='T' then
         number_of_members:=number_of_members + 1];
  end {while};
!ifdef Demo
!  if number_of_members>100 then endxqq;
  write('6');
{set up secondary index}
  if largest_member_number<=UPPER(member_index^)
    then member_index_top:=largest_member_number
    else member_index_top:=UPPER(member_index^);
  mbi:=sizeof(member_index^[1])*WRD(member_index_top);
  member_index:=far_alloc(mbi);
  reset(f_members);
  i:=0;
  while f_members.errs=0 and then (not eof(f_members)) and then
        i<UPPER(member_index^) do begin
    readln(f_members,member_internal_buffer);
    if f_members.errs=0 then
      [i:=i+1;
       movel(adr member_internal_buffer,adr member_buffer,member_length);
       member_index^[i].active:=(member_buffer.active[1]='T');
       member_index^[i].gender[1]:=member_buffer.gender[1];
       member_index^[i].pref[1]:=member_buffer.pref[1];
       member_index^[i].age:=ivalue(member_buffer.age)];
  end {while};
  close(f_members);
  f_members.mode:=direct;
  f_members.trap:=true;
  f_members.errs:=0;
  assign(f_members,members);
  reset(f_members);
  members_io_flag:=getting;
{pubmail}
  write('7');
  f_pubmail.trap:=true;
  f_pubmail.errs:=0;
  assign(f_pubmail,'PUBMAIL');
  reset(f_pubmail);
  pubmail:=nil;
  while (f_pubmail.errs=0) and then (not eof(f_pubmail)) do begin
    new(pm1);
    if pubmail=nil then pubmail:=pm1 else pm2^.link:=pm1;
    pm1^.link:=nil;
    readln(f_pubmail,str); stripc(str); kopystr(str,pm1^.name);
    if pm1^.name[1]=' ' then
      [writeln('Excess characters at end of PUBMAIL file'); ret2dos(4)];
    readln(f_pubmail,pm1^.letter);
    readln(f_pubmail,pm1^.memberid);
    readln(f_pubmail,pm1^.holdem);
    readln(f_pubmail,pm1^.qaire);
    if pm1^.qaire<>0 then
      [copylst('MULTIPLE.0',str); str[10]:=chr(ord('0')+ord(pm1^.qaire));
       if not exist_file(str) then
         [writeln('Incorrect PUBMAIL or MULTIPLE file.'); ret2dos(4)]];
    readln(f_pubmail,pm1^.mandatory);
    readln(f_pubmail,pm1^.anon);
    readln(f_pubmail,pm1^.gender);
    readln(f_pubmail,pm1^.pref);
    readln(f_pubmail,pm1^.minlevr);
    readln(f_pubmail,pm1^.minlevw);
    readln(f_pubmail,pm1^.maxlev);
    readln(f_pubmail,pm1^.minage);
    readln(f_pubmail,pm1^.maxage);
    if not eof(f_pubmail) then
      [readln(f_pubmail,str);
       if str<>null and then str[1]<>' ' then
         [writeln('Incorrect PUBMAIL file'); ret2dos(4)]];
    pm1^.member[0]:=chr(name_width);
    fillc(adr pm1^.member[1],name_width,' '); 
    if pm1^.memberid>0 and then pm1^.memberid<=largest_member_number then
      [if dbg_member(pm1^.memberid,member_buffer) and then
          member_buffer.active[1]='T' then
         [stripx(member_buffer.name,pm1^.member);
          pm1^.member[0]:=chr(name_width)]];
{get data from actual public mail file}    
    pm1^.next_slot:=1; pm1^.msgs:=0;
    copystr('        ',pm1^.date); copystr('        ',pm1^.time);
    copylst(pbi,str); concat(str,pm1^.letter);
    f_index.mode:=direct; f_index.trap:=true; f_index.errs:=0;
    assign(f_index,str); reset(f_index);
    while not eof(f_index) and then f_index.errs=0 do
      [readln(f_index,index_internal_buffer);
       if f_index.errs<>0 then break;
       movel(adr index_internal_buffer,adr index_buffer,index_length);
       copylst(index_buffer.fptr,str); eval(decode(str,ut));
       pm1^.next_slot:=ut+ivalue(index_buffer.mlen);
       pm1^.msgs:=pm1^.msgs+1;
       copystr(index_buffer.date,pm1^.date);
       copystr(index_buffer.time,pm1^.time)];
    close(f_index);
    pm2:=pm1;
  end {while};
  close(f_pubmail);
{userlog}
  write('8');
  f_userlog.trap:=true;
  f_userlog.errs:=0;
  assign(f_userlog,ulog);
  reset(f_userlog);
  userlog_entries:=0; u_day:=0; u_time:=0; userlog_next:=0;
  while f_userlog.errs=0 and then not eof(f_userlog) do begin
    readln(f_userlog,userlog_internal_buffer);
    if f_userlog.errs=0 then
      [userlog_entries:=userlog_entries + 1;
       movel(adr userlog_internal_buffer,adr userlog_buffer,userlog_length);
       ud:=date2jd(userlog_buffer.last_called_date);
       if ud>=u_day then
         [ut:=time2secs(userlog_buffer.last_called_time);
          if ud>u_day or else ((ud=u_day) and (ut>=u_time)) then
            [u_day:=ud; u_time:=ut; userlog_next:=userlog_entries]]];
  end {while};
  userlog_next:=userlog_next+1;
  if userlog_entries>userlog_max then userlog_entries:=userlog_max;
  if userlog_next>userlog_max then userlog_next:=1;
  close(f_userlog);
  f_userlog.mode:=direct;
  f_userlog.trap:=true;
  f_userlog.errs:=0;
  assign(f_userlog,ulog);
  rewrite(f_userlog);
  userlog_io_flag:=putting;
{globals}
  write('9');
  opengl;
end {db_open_all};

END.
