{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}
{$include: 'script4.int'}

IMPLEMENTATION OF script4;

USES types,globals,utils,database,load,sutils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the PASASM assembler utilities package***}
{$include: 'newasm.int'}

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

var
  skipped [PUBLIC] : boolean;

{this function returns a task state - either pub_rfb1 or pub_rfb3}
function display_pubmail_header : task;
var
  c : char;
  p : para;
begin
  display_pubmail_header:=pub_rfb3; {display body}
  disparas(q[wx].pub_msg);
  c:=dbg_pubmail(q[wx].pub_msg,q[wx].current_msg);
  parse_header(q[wx].pub_msg);
  if wx=0 then skipped:=false else unskip_com;
  q[wx].bflag:=false;
  if q[wx].flag {scanning} then
    case c of
      ' ' : [if q[wx].pm^.anon
      	        then [q[wx].msg_from^.msg:=null;
		      q[wx].msg_date^.msg.len:=8];
             display(pub_header_txt); return];
      'H' : [display(pub_held_txt); return];
      'D' : [display(pub_del_txt); return];
      otherwise display(bad_format_txt);
    end {case}
  else
    case c of
      ' ' : [display(pubmsg_head_txt); return];
      'H' :  display(pubmsg_held_txt);
      'D' :  display(pubmsg_deleted_txt);
      otherwise display(bad_format_txt);
    end {case};
  q[wx].current_msg:=q[wx].current_msg+q[wx].direction;
  if q[wx].current_msg<1 or else q[wx].current_msg>q[wx].pm^.msgs
    then q[wx].current_msg:=0;
  display_pubmail_header:=pub_rfb1; {which message}
end {display_pubmail_header};

procedure bbs4{consts s : lstring; var str : lstring};
var
  i,j : integer;
  next_state : task;
  p : para;
  fl : boolean;
  c : char;

begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  pubmail5: prompt_with(pubcat_menu_txt);
  pubmail6: {choose from category menu}
    [next_state:=pubmail5;
     if str=null or else str[1]=mn[12][7] {Q} then
       [prompt_with(select_category_txt); next_state:=pubmail4]
     else if str[1]=mn[12][1] {?} or else eq(str,ss[40]) then {HELP}
       display(category_menu_txt)
     else if number_query(str,1,q[wx].pm^.msgs,i) then
       [q[wx].direction:=1; q[wx].flag:=false;
	q[wx].current_msg:=i; next_state:=display_pubmail_header]
     else if str.len=1 and then str[1]=mn[12][2] {A} and then
	  q[wx].pm^.qaire<>0 and then q[wx].level>=priv_ans then
       [q[wx].qr:=ord(q[wx].pm^.qaire); q[wx].qs:=qair[q[wx].qr];
	q[wx].index:=1; q[wx].return_state:=pubmail5;
	display(nextq_txt); next_state:=mult_ch1a]
     else if str.len=1 and then str[1]=mn[12][4] {D} then
       [prompt_with(delete_which_txt); next_state:=pubkill]
     else if str.len=1 and then str[1]=mn[12][5] {P} then {post public}
       [if q[wx].level>=priv_post and then
	   q[wx].level>=ord(q[wx].pm^.minlevw) then
	  [q[wx].return_state:=pubmail5; q[wx].current_msg:=0;
	   if q[wx].holding
	     then [display(send_menu_list_txt); next_state:=sendmail_menu]
	     else [prompt_with(who_to_txt); next_state:=pubmail_send1]]
	else
	  display(read_access_txt)]
     else if str.len=1 and then str[1]=mn[12][6] {H} and then
	     ((q[wx].pm^.memberid=q[wx].userid) or (q[wx].level>=9)) then
       [prompt_with(hold_which_txt); next_state:=pubhold]
     else if str[1]=mn[12][9] {N} then
       [repeat
	  q[wx].pm:=q[wx].pm^.link
	until q[wx].pm=nil or else
	      (see_pub and (q[wx].pm^.letter[1]=uc(q[wx].pm^.letter[1])));
	if q[wx].pm=nil then
	  [prompt_with(select_category_txt); next_state:=pubmail4]
	else if q[wx].pm^.qaire<>0 and then
		q[wx].my.mult_answer[ord(q[wx].pm^.qaire)][1]=' ' then
	  [prompt_with(special_qaire_txt); next_state:=pubmail4a]]
     else if eq(str,ss[27]) {RF} then
       [q[wx].current_msg:=1; q[wx].direction:=1; q[wx].flag:=false;
	if q[wx].pm^.msgs>0
	  then [display(pubread_head_txt); next_state:=pub_rfb1]]
     else if eq(str,ss[26]) {RB} then
       [q[wx].current_msg:=q[wx].pm^.msgs;
	q[wx].direction:=-1; q[wx].flag:=false;
	if q[wx].pm^.msgs>0
	  then [display(pubread_head_txt); next_state:=pub_rfb1]]
     else if eq(str,ss[28]) {RS} then
       [q[wx].current_msg:=q[wx].pm^.msgs; q[wx].flag:=false;
	if q[wx].pm^.msgs>0
	  then next_state:=pub_rs]
     else if eq(str,ss[30]) {SF} then
       [q[wx].current_msg:=1; q[wx].direction:=1; q[wx].flag:=true;
	if q[wx].pm^.msgs>0
	  then [display(pubscan_head_txt); next_state:=pub_rfb1]]
     else if eq(str,ss[29]) {SB} then
       [q[wx].current_msg:=q[wx].pm^.msgs;
	q[wx].direction:=-1; q[wx].flag:=true;
	if q[wx].pm^.msgs>0
	  then [display(pubscan_head_txt); next_state:=pub_rfb1]]
     else if eq(str,ss[31]) {SS} then
       [q[wx].current_msg:=q[wx].pm^.msgs; q[wx].flag:=true;
	if q[wx].pm^.msgs>0
	  then next_state:=pub_rs]
     else if str.len>2 and then
	     str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)];
  pubmail_send1:
    [q[wx].flag:=true; {not canned}
     if q[wx].msg_to=nill
       then q[wx].msg_to:=newpara(s)
       else kopylst(s,q[wx].msg_to^.msg);
     if not q[wx].pm^.anon
       then prompt_with(pub_to_from_txt)];
  pubmail_send2:
    if q[wx].pm^.anon or else agree(s) then
      [p:=newpara(ss[21]); concat(p^.msg,': ');
       konkat(p^.msg,q[wx].my.name); cat(p^.msg,q[wx].my.userid);
       q[wx].msg_first:=p; q[wx].msg_last:=p;
       p:=newpara(ss[20]); concat(p^.msg,': ');
       if q[wx].msg_to<>nill then konkat(p^.msg,q[wx].msg_to^.msg);
       q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       p:=newpara(ss[23]); concat(p^.msg,': '); {Date: }
       cat(p^.msg,mydate); cat(p^.msg,mytime);
       q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       prompt_with(enter_subject_txt); next_state:=enter_subject]
    else
      [prompt_with(who_to_txt); next_state:=pubmail_send1];
  pub_rs:
    [dbg_pubindex(q[wx].current_msg);
     if index_buffer.date[1]=' ' or else index_buffer.time[1]=' ' then
       fl:=true
     else if date2jd(index_buffer.date)=date2jd(q[wx].my.last_called_date)then
       fl:=(index_buffer.time<q[wx].my.last_called_time)
     else
       fl:=(date2jd(index_buffer.date)<date2jd(q[wx].my.last_called_date));
     if fl then
       [q[wx].current_msg:=q[wx].current_msg+1; q[wx].direction:=1;
        if q[wx].current_msg<=q[wx].pm^.msgs
          then display(pubread_head_txt)
          else next_state:=pubmail5]
     else
       [q[wx].current_msg:=q[wx].current_msg-1;
        if q[wx].current_msg>0 then
          next_state:=pub_rs
        else
          [q[wx].current_msg:=1; q[wx].direction:=1;
           display(pubread_head_txt)]]];
  pub_rfb1: prompt_with(which_pubmsg_txt);
  pub_rfb2: {select which message to start reading at (first message)}
    if str.len=1 and then str[1]=mn[8][3] {Q} then
      next_state:=pubmail5
    else if number_query(s,1,q[wx].pm^.msgs,i) then
      [q[wx].current_msg:=i;
       if q[wx].flag then {scanning}
         display(pub_title_txt)]
    else if str.len=1 and then str[1]=mn[8][1] {?} then
      [prompt_with(which_pubmsg_txt); next_state:=pub_rfb2]
    else if q[wx].current_msg=0 then
      next_state:=pubmail5
    else if q[wx].flag then {scanning}
      display(pub_title_txt);
  pub_rfb2a:
     next_state:=display_pubmail_header;
  pub_rfb3: {display public message}
    [if q[wx].bflag then {we've seen the From: field}
       [if wx=0 and then skipped then {we've been Ctrl-O'd}
          [skipped:=false; disparas(w^[wx].output); disparas(q[wx].pub_msg)]
        else if wx>0 and then skipped_com then {we've been Ctrl-O'd}
          [purge_com; disparas(w^[wx].output); disparas(q[wx].pub_msg)]];
     if q[wx].pub_msg=nill then {go on to the next message}
       [if wx>0 and then s_working>0 then
          next_state:=pub_rfb3
        else
          [q[wx].current_msg:=q[wx].current_msg+q[wx].direction;
           if (q[wx].current_msg<1) or (q[wx].current_msg>q[wx].pm^.msgs) then
             q[wx].current_msg:=0;
           if q[wx].flag then
             [if q[wx].current_msg=0
                then next_state:=pubmail5
                else next_state:=display_pubmail_header]
           else
             [if q[wx].pm^.anon
                then prompt_with(which_anon_txt)
                else prompt_with(which_pubmsg2_txt);
              next_state:=pub_rfb5]]]
     else if q[wx].flag then {just scanning}
       next_state:=pub_rfb6
     else
       [p:=q[wx].pub_msg; q[wx].pub_msg:=p^.link;
        if (not q[wx].bflag) and then p^.msg.len>6 and then
           p^.msg[1]=ss[21][1] and then eq2(p^.msg,ss[21]) {From} then
          [kopylst(p^.msg,str); delete(str,1,6);
           if q[wx].msg_from=nill
             then q[wx].msg_from:=newpara(str)
             else kopylst(str,q[wx].msg_from^.msg);
           for i:=ord(str.len) downto 1 do
             if str[i]=' ' then [delete(str,1,i); break];
           if q[wx].xstr=nill
             then q[wx].xstr:=newpara(str)
             else kopylst(str,q[wx].xstr^.msg);
           if q[wx].pm^.anon then
             [dispara(p); p:=q[wx].pub_msg; q[wx].pub_msg:=p^.link];
           q[wx].bflag:=true];
        if q[wx].pm^.anon and then eq2(p^.msg,ss[23]) {Date} and then
	   p^.msg.len=ss[23].len+19 then
	  p^.msg.len:=ss[23].len+10;
        p^.link:=nill;
        w^[wx].output:=p; w^[wx].crud:=true; w^[wx].node_type:=nt_display;
        next_state:=pub_rfb3]];
  pub_rfb4:
    [q[wx].flag:=false; {not scanning}
     if q[wx].pm^.anon
       then prompt_with(which_anon_txt)
       else prompt_with(which_pubmsg2_txt)];
  pub_rfb5: {select which message to continue reading at}
    [next_state:=pub_rfb4;
     if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str.len=1 and then str[1]=mn[12][3] {B} and then
             ((not q[wx].pm^.anon) or (q[wx].level=9) or
	     (fTrust and (q[wx].pm^.memberid=q[wx].userid))) then
       [if q[wx].level<priv_br then
          [display(read_access_txt); next_state:=pub_rfb4]
        else
          [if q[wx].xstr=nill
             then str.len:=0
             else copylst(q[wx].xstr^.msg,str);
           if disk2u(ivalue(str)) then
             [display(browse_txt);
              q[wx].return_state:=pub_rfb4; next_state:=browse_qs1]
           else display(bad_userid_txt)]]
    else if str.len=1 and then str[1]=mn[12][5] {E} then {public reply}
      [if q[wx].level>=priv_post and then
      	  q[wx].level>=ord(q[wx].pm^.minlevw) then
         [q[wx].return_state:=pubmail5; q[wx].flag:=true; {not canned}
          if q[wx].holding then
            [display(send_menu_list_txt); next_state:=sendmail_menu]
          else
            [if q[wx].pm^.anon then
               [prompt_with(who_to_txt); next_state:=pubmail_send1]
             else
               [if q[wx].msg_from=nill then
                  [if q[wx].msg_to=nill
                     then q[wx].msg_to:=newpara(null)
                     else q[wx].msg_to^.msg:=null]
                else
                  [if q[wx].msg_to=nill
                     then q[wx].msg_to:=newpara(q[wx].msg_from^.msg)
                     else kopylst(q[wx].msg_from^.msg,q[wx].msg_to^.msg)];
                prompt_with(pub_to_from_txt); next_state:=pubmail_send2]]]
       else
         [display(read_access_txt); next_state:=pub_rfb4]]
     else if str.len=1 and then str[1]=mn[12][7] {Q} then
       next_state:=pubmail5
     else if str.len=1 and then str[1]=mn[12][8] {R} and then
             (not q[wx].pm^.anon) then {reply privately to public mail}
       [q[wx].return_state:=pub_rfb4; q[wx].flag:=true; {not canned}
        if q[wx].level<priv_reply or else q[wx].level<priv_send then
          [display(read_access_txt); next_state:=pub_rfb4]
        else if q[wx].holding then
          [if q[wx].correspondent=q[wx].hold_target
             then [display(send_private_txt); next_state:=sendmail_menu]
             else [display(hold_error_txt); next_state:=pub_rfb4]]
        else
          [if q[wx].xstr=nill
             then str.len:=0
             else copylst(q[wx].xstr^.msg,str);
           if number_query(str,1,largest_member_number,i) then
             [q[wx].correspondent:=i;
              if disk2u(i) then
                [i:=ivalue(q[wx].your.mbx_count);
                 j:=ivalue(q[wx].your.mbx_max);
                 if (i<j) or (q[wx].level=9) then
		   [q[wx].flag:=true; {normal reply}
                    display(send_private_txt); next_state:=reply1]
                 else
		   display(no_slots_txt)]
              else
                display(bad_userid_txt)]
           else
             display(bad_userid_txt)]]
     else if number_query(s,1,q[wx].pm^.msgs,i) then
       [q[wx].current_msg:=i; next_state:=display_pubmail_header]
     else if str.len=1 and then str[1]=mn[12][1] {?} then
       [if q[wx].pm^.anon
          then prompt_with(which_anon_txt)
          else prompt_with(which_pubmsg2_txt);
        next_state:=pub_rfb5]
     else if str.len>2 and then
             str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)
     else if q[wx].current_msg=0 then
       next_state:=pubmail5
     else
       next_state:=display_pubmail_header];
  pub_rfb6:
    [q[wx].current_msg:=q[wx].current_msg+q[wx].direction;
     if (q[wx].current_msg<1) or (q[wx].current_msg>q[wx].pm^.msgs)
       then next_state:=pubmail5
       else next_state:=display_pubmail_header];
  pubkill:
    [next_state:=pubmail5;
     if number_query(s,1,q[wx].pm^.msgs,i) then
       [q[wx].current_msg:=i; dbg_pubindex(q[wx].current_msg); {load indx buf}
	c:=index_buffer.deleted[1]; {c = old status character D/H/blank}
	case dbm_pubdelete(i) of
	  'D' : display(msg_deleted_txt);
	  'H' : display(pubmail_held_txt);
	  otherwise
	    [if c='D'
	       then display(msg_undeleted_txt)
	       else display(msg_not_deleted_txt)];
	end {case}]];
  pubhold:
    [next_state:=pubmail5;
     if number_query(s,1,q[wx].pm^.msgs,i) then
       [q[wx].current_msg:=i;
	if dbm_pubhold(i)='H' then
	  display(pubmail_held_txt)
	else
	  [q[wx].direction:=1; q[wx].flag:=false;
	   next_state:=display_pubmail_header]]];
  end {case};
  q[wx].state:=next_state;
end {bbs4};

END.
