;
; TEST232 -- Diagnostics for serial ports
; Does not know about Digiboards
;
; To build: ml test232.asm
;
; DLX Bulletin Board System V7.0
;
; FREEWARE NOTICE
;
; DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
; Anyone who wishes to may run the program, copy it, or modify it for
; any purpose, including commercial gain.
;

.model tiny

dos	equ	21h		; dos function call interrupt
cr	equ	13		; carriage return
lf	equ	10		; linefeed
base	equ	8		; external 8259 interrupts start here
inta00  equ     20h             ; 8259A port, a0 = 0
inta01  equ     21h             ; 8259A port, a0 = 1
eoi3	equ	3 or 01100000b	; 8259A ocw2 specific irq3 eoi, a0=0
eoi4	equ	4 or 01100000b	; 8259A ocw2 specific irq4 eoi, a0=0

; rom bios data area
rbda	segment	at 40h
rs232_base dw	4 dup(?)	; addresses of rs232 adapters
rbda	ends

cseg	segment public 'code'
	assume	cs:cseg,ds:cseg,es:cseg
	org	80h
cmd_siz	label	byte		; number of characters on command line
	org	81h
cmd_lin label   byte		; command line
	org	100h
start	proc	far
	jmp	main		; goto actual beginning
start	endp
;
; data area
;
herald	db	'Test232 V1.0a',cr,lf
crlf	db	cr,lf,'$'

level	dw	0		; variable for interrupt level found
status	dw	0		; port status
port	dw	0		; port number (0-3)

datreg		dw	0	; data register
ier		dw	0	; interrupt enable register
iir		dw      0	; interrupt identification register
lcr		dw      0	; line control register
mcr		dw      0	; modem control register
lsr		dw      0	; line status register
msr		dw      0	; modem status register
dll		equ	datreg	; low divisor latch
dlh		equ	ier	; high divisor latch

com1	db	'COM1: $'
com2	db	'COM2: $'
com3	db	'COM3: $'
com4	db	'COM4: $'

msg1	db	'not installed$'
msg2	db	'serial port installed$'
msg3	db	', modem active$'
msg4	db	', status $'

intlev3	db	', interrupt level 3$'
intlev4	db	', interrupt level 4$'

hex	db	'0123456789ABCDEF'
;
; test port indicated by dx (0-3)
; CY=0 if port exists, CY=1 if port not installed
;
diag	proc	near
	mov	ah,0		; initialize comm port
	mov	al,01000011b	; 300 baud, no parity, 1 stopbit, 8 bits
	int	14h		; bios rs232_io
	mov	status,ax	; save status
	and	ah,60h		; leave just tx register ready bits
	cmp	ah,60h		; serial port ready?
	je	diag_1		; jump if so

; serial port not found
diag_0:	mov	ah,9		; display string
	lea	dx,msg1		; port not installed
	int	dos		; dos 1 function
	stc			; set carry
	ret			; done

; serial port found
diag_1:	mov	ah,9		; display string
	lea	dx,msg2		; serial port installed
	int	dos		; dos 1 function

; check for active modem
	mov	ax,status	; get status
	test	al,20h		; data set ready?
	jz	diag_2		; jump if not
	mov	ah,9		; display string
	lea	dx,msg3		; modem active
	int	dos		; dos 1 function

; display status
diag_2:	mov	ah,9		; display string
	lea	dx,msg4		; status msg
	int	dos		; dos 1 function

	mov	bx,status	; get status word
	mov	cl,12		; shift count
	shr	bx,cl		; right justify
	mov	ah,2		; display char
	mov	dl,hex[bx]	; hex ascii
	int	dos		; dos 1 function

	mov	bx,status	; get status word
	and	bx,0f00h	; leave only 2nd nybble
	mov	cl,8		; shift count
	shr	bx,cl		; right justify
	mov	ah,2		; display char
	mov	dl,hex[bx]	; hex ascii
	int	dos		; dos 1 function

	mov	bx,status	; get status word
	and	bx,00f0h	; leave only 3rd nybble
	mov	cl,4		; shift count
	shr	bx,cl		; right justify
	mov	ah,2		; display char
	mov	dl,hex[bx]	; hex ascii
	int	dos		; dos 1 function

	mov	bx,status	; get status word
	and	bx,000fh	; leave only 4th nybble
	mov	ah,2		; display char
	mov	dl,hex[bx]	; hex ascii
	int	dos		; dos 1 function

; done, port exists
	clc			; clear carry
	ret			; done
diag	endp
;
; test interrupt handlers
; these assume that dx contains IIR port
; they set BX to their interrupt level, use AX as a temp
;
int_hndlr3 proc	far

; make sure interrupt is from 8250
        in      al,dx		; interrupt identification register
	cmp	al,2		; pending tx interrupt?
	jne	ih3_1		; jump if not
	mov	bx,3		; our level

; clear the 8259 interrupt controller flag
ih3_1:	mov	al,eoi3		; specific end of interrupt
	out	inta00,al	; clear flag
	sti			; interrupts back on

	iret			; done
int_hndlr3 endp
;
int_hndlr4 proc	far

; make sure interrupt is from 8250
        in      al,dx		; interrupt identification register
	cmp	al,2		; pending tx interrupt?
	jne	ih4_1		; jump if not
	mov	bx,4		; our level

; clear the 8259 interrupt controller flag
ih4_1:	mov	al,eoi4		; specific end of interrupt
	out	inta00,al	; clear flag
	sti			; interrupts back on

	iret			; done
int_hndlr4 endp
;
; determine interrupt level for port indicated by dx (0-3)
;
testint	proc	near
	push	dx		; save arg

; install our interrupt handlers
	mov	ah,25h		; set interrupt vector contents
	mov	al,base+3	; level 3
	mov	dx,offset int_hndlr3	; our interrupt handler for level 3
	push    ds              ; save data segment
	push	cs		; copy cs
	pop	ds		; to ds
	int	dos		; dos 1 function
	pop     ds              ; recover data segment

	mov	ah,25h		; set interrupt vector contents
	mov	al,base+4	; level 4
	mov	dx,offset int_hndlr4	; our interrupt handler for level 4
	push    ds              ; save data segment
	push	cs		; copy cs
	pop	ds		; to ds
	int	dos		; dos function
	pop     ds              ; recover data segment

; set port addresses from given parameter (0-3)
	pop	bx		; recover port code
	shl	bx,1		; convert to word offset
	push	ds		; save ds
	mov	ax,rbda		; rom bios data area
	mov	ds,ax		; to ds
	assume	ds:rbda
	mov	ax,rs232_base[bx]	; get base port address
	pop	ds		; recover ds
	assume	ds:cseg
	lea	bx,datreg	; offset of table of ports
	mov	cx,7		; loop six times
inst3:	mov	[bx],ax		; set port address
	inc	ax		; next port
	add	bx,2		; next word address
	loop	inst3		; rs232 base loop

; enable interrupts on 8259
	cli			; interrupts off

	in	al,inta01	; current enabled interrupts from 8259
	jmp	short $+2	; clear instruction buffer
	push	ax		; save mask
	or	al,1		; disable timer
	and	al,11100111b	; enable levels 3 and 4
	out	inta01,al	; set new interrupt mask on 8259
	jmp	short $+2	; i/o delay for jr and at

	mov	al,eoi3		; specific end of interrupt
	out	inta00,al	; clear it
	mov	al,eoi4		; specific end of interrupt
	out	inta00,al	; clear it

; enable interrupts on 8250
        mov     al,2		; enable 8250 tx interrupts
        mov     dx,ier		; interrupt enable register
        out     dx,al		; to 8250 port
	jmp	short $+2	; i/o delay for jr and at

        mov     dx,mcr		; modem control register
        mov     al,0bh		; dtr on, rts on, out2 on
        out     dx,al		; to 8250 port
	jmp	short $+2	; clear instruction buffer

; wait for tx interrupt
	mov	bx,0		; level indicator
	mov	cx,0		; max count
	mov	dx,iir		; interrupt identification register
	sti			; interrupts on
wait1:	cmp	bx,0		; level still zero?
	jne	got1		; jump if we got an interrupt
	loop	wait1		; else keep waiting for interrupt
got1:	mov	level,bx	; set level

; clear tx interrupt
	cli			; interrupts off
        mov     dx,lsr		; clear tx latch
        in      al,dx		; on 8250
	jmp	short $+2	; i/o delay for jr and at

; disable interrupts on 8250
        mov     al,0		; disable all interrupts
	mov     dx,ier		; interrupt enable register
        out     dx,al		; to 8250 port
	jmp	short $+2	; i/o delay for jr and at

; disable interrupts on 8259
	pop	ax		; recover old mask
	out	inta01,al	; reset interrupt mask on 8259
	jmp	short $+2	; i/o delay for jr and at
	sti			; interrupts back on

; announce result
test_3:	cmp	level,3		; level 3?
	jne	test_4		; jump if not
	mov	ah,9		; display string
	lea	dx,intlev3	; interrupt level 3
	int	dos		; dos 1 function
	jmp	short test_x	; done

test_4:	cmp	level,4		; level 4?
	jne	test_0		; error if not
	mov	ah,9		; display string
	lea	dx,intlev4	; interrupt level 4
	int	dos		; dos 1 function
	jmp	short test_x	; done

; done, results negative
test_0:	stc			; set carry indicator
	ret			; done

; done, ok
test_x:	clc			; clear carry indicator
	ret			; done
testint	endp
;
; main program
;
main	proc	near

; display herald
	mov	ah,9		; display string
	lea	dx,herald	; who we are
	int	dos		; dos 1 function
 
; test com1:
	mov	port,0		; first port
	mov	ah,9		; display string
	lea	dx,com1		; port name
	int	dos		; dos 1 function
	push	ds		; save ds
	mov	ax,rbda		; rom bios data area
	mov	ds,ax		; to ds
	assume	ds:rbda
	cmp	rs232_base,3f8h	; is first port com1?
	pop	ds		; restore ds
	assume	ds:cseg
	je	main_0		; jump if so
	mov	ah,9		; display string
	lea	dx,msg1		; port not installed
	int	dos		; dos 1 function
	jmp	short main_1a	; continue on with com2
main_0:	mov	dx,port		; port
	call	diag		; perform test on this port
	jc	main_1		; jump if not installed
	mov	dx,port		; port
	call	testint		; identify interrupt level
	jnc	main_1		; jump if test ok
	mov	dx,port		; port
	call	testint		; else try again
main_1:	inc	port		; next port
main_1a:mov	ah,9		; display string
	lea	dx,crlf		; carriage return, linefeed
	int	dos		; dos 1 function

; test com2:
	mov	ah,9		; display string
	lea	dx,com2		; port name
	int	dos		; dos 1 function
	mov	dx,port		; port
	call	diag		; perform test on this port
	jc	main_2		; jump if not installed
	mov	dx,port		; port
	call	testint		; identify interrupt level
	jnc	main_2		; jump if test ok
	mov	dx,port		; port
	call	testint		; else try again
main_2:	mov	ah,9		; display string
	lea	dx,crlf		; carriage return, linefeed
	int	dos		; dos 1 function
	inc	port		; next port

; test com3:
	mov	ah,9		; display string
	lea	dx,com3		; port name
	int	dos		; dos 1 function
	mov	dx,port		; port
	call	diag		; perform test on this port
	jc	main_3		; jump if not installed
	mov	dx,port		; port
	call	testint		; identify interrupt level
	jnc	main_3		; jump if test ok
	mov	dx,port		; port
	call	testint		; else try again
main_3:	mov	ah,9		; display string
	lea	dx,crlf		; carriage return, linefeed
	int	dos		; dos 1 function
	inc	port		; next port

; test com4:
	mov	ah,9		; display string
	lea	dx,com4		; port name
	int	dos		; dos 1 function
	mov	dx,port		; port
	call	diag		; perform test on this port
	jc	main_4		; jump if not installed
	mov	dx,port		; port
	call	testint		; identify interrupt level
	jnc	main_4		; jump if test ok
	mov	dx,port		; port
	call	testint		; else try again
main_4:	mov	ah,9		; display string
	lea	dx,crlf		; carriage return, linefeed
	int	dos		; dos 1 function

; clear interrupt vectors
	push	ds		; save data segment
	mov	ah,25h		; set interrupt vector contents
	mov	al,base+3	; level 3
	mov	dx,0		; 0:0
	mov	ds,dx		; to vector
	int	dos		; dos 1 function

	mov	ah,25h		; set interrupt vector contents
	mov	al,base+4	; level 4
	mov	dx,0		; 0:0
	mov	ds,dx		; to vector
	int	dos		; dos function
	pop     ds              ; recover data segment
	
; exit to dos command processor
	int	20h		; normal return to dos

main	endp
cseg	ends
	end	start		; transfer address
