/* TWindow.H  File */

/* Window colors */
#define RED			4
#define GREEN		2
#define BLUE		1
#define WHITE		(RED+GREEN+BLUE)
#define YELLOW		(RED+GREEN)
#define AQUA		(GREEN+BLUE)
#define MAGENTA 	(RED+BLUE)
#define BLACK 		0
#define BRIGHT		8
#define DIM			0

#define BORDER		0
#define TITLE		1
#define ACCENT		2
#define NORMAL		3
#define ALL			4

#define TRUE    	1
#define FALSE    	0
#define ERROR      -1
#define OK        	0

extern unsigned int maxy;

/* Window controller structures */

typedef struct field {  /* data entry field description */
  char *fmask;          /* field data entry mask 	*/
  int fprot;			/* field protection 		*/
  char *fbuff;			/* field buffer			*/
  int ftype;			/* field type 			*/
  int frow;				/* field row			*/
  int fcol;				/* field column			*/
  void (*fhelp)();		/* field help function 		*/
  char *fhwin;			/* field help window		*/
  int flx,fly;			/* help window location		*/
  int (*fvalid)();		/* field validation function	*/
  struct field *fnxt;	/* next field on template	*/
  struct field *fprv;	/* previous field on template	*/
} FIELD;

typedef struct _wnd {
  int _wv;			/* true if window is visible 	*/
  int _hd;			/* true if window is hidden	*/
  char *_ws;		/* points to window save block  */
  char *_tl;		/* points to window title	*/
  int _wx;			/* nw x coordinate		*/
  int _wy;			/* nw y coordinate		*/
  int _ww;			/* window width			*/
  int _wh;			/* window height		*/
  int _wsp;			/* scroll pointer		*/
  int _sp;			/* selection pointer		*/
  int _cr;			/* cursor x location		*/
  int btype;		/* border type			*/
  int wcolor[4];	/* colors for window		*/
  int _pn;			/* previous normal color	*/
  struct _wnd *_nx;	/* points to next window	*/
  struct _wnd *_pv;	/* points to prev window	*/
  FIELD *_fh;		/* points to 1st data entry fld	*/
  FIELD *_ft;		/* points to last data entry fld*/
} WINDOW;

typedef struct w_menu {
  char *mname;
  char **mselcs;
  void (**func)();
} MENU;


typedef struct k_menu {
	char *mname;
	char **mselcs;
	int  *returnkey;
} KMENU;

#define SAV			(wnd->_ws)
#define WTITLE		(wnd->_tl)
#define COL			(wnd->_wx)
#define ROW			(wnd->_wy)
#define WIDTH		(wnd->_ww)
#define HEIGHT		(wnd->_wh)
#define SCROLL		(wnd->_wsp)
#define SELECT		(wnd->_sp)
#define WCURS		(wnd->_cr)
#define WBORDER		(wnd->wcolor[BORDER])
#define WTITLEC		(wnd->wcolor[TITLE])
#define WACCENT		(wnd->wcolor[ACCENT])
#define WNORMAL		(wnd->wcolor[NORMAL])
#define PNORMAL		(wnd->_pn)
#define BTYPE		(wnd->btype)
#define NEXT		(wnd->_nx)
#define PREV		(wnd->_pv)
#define WCOLOR		(wnd->wcolor)
#define VISIBLE		(wnd->_wv)
#define HIDDEN		(wnd->_hd)
#define FHEAD		(wnd->_fh)
#define FTAIL		(wnd->_ft)

#define NW		(wcs[wnd->btype].nw)
#define NE		(wcs[wnd->btype].ne)
#define SE		(wcs[wnd->btype].se)
#define SW		(wcs[wnd->btype].sw)
#define SIDE		(wcs[wnd->btype].side)
#define LINE		(wcs[wnd->btype].line)

/* function prototypes and macros */

/* general-purpose functions and macros */

void pascal clear_screen (void);
int pascal vmode(void);
void pascal cursor(int,int);
void pascal curr_cursor(int *,int *);
int pascal cursor_type(void);
void pascal set_cursor_type(int);
int pascal get_char(void);
int pascal scroll_lock(void);
void pascal vpoke (unsigned,unsigned,unsigned);
int pascal vpeek(unsigned,unsigned);
/*
#define vpoke(vseg,adr,chr) poke(vseg,adr,chr)
#define vpeek(vseg,adr) peek(vseg,adr)
*/

/* window functions and macros*/

WINDOW * pascal establish_window (int,int,int,int);
void pascal set_border(WINDOW *,int);
void pascal set_colors(WINDOW *,int,int,int,int);
void pascal set_intensity (WINDOW *,int);
void pascal set_title(WINDOW *,char *);
void pascal display_window(WINDOW *);
void pascal delete_window(WINDOW *);
void pascal clear_window (WINDOW *);
void pascal hide_window(WINDOW *);
void cdecl  wprintf(WINDOW *,char *,...);
void pascal wputchar (WINDOW *,int);
void cdecl  wprintfraw(WINDOW *,char *,...);
void pascal wputcharaw (WINDOW *,int);
void pascal close_all(void);
void pascal wcursor(WINDOW *,int x,int y);
void pascal wframe(WINDOW *wnd);
void pascal error_message(char *);
void pascal any_message(char *);
void pascal _anymsg(char *,char *);
void pascal clear_message(void);
int  pascal get_selection(WINDOW *,int,char *);
int  pascal hkmenu (char **selcs, char *keys, int *start);

#define reverse_video(wnd)wnd->wcolor[3]=wnd->wcolor[2]
#define normal_video(wnd)wnd->wcolor[3]=wnd->_pn
#define rmove_window(wnd,x,y) repos_wwnd(wnd,x,y,0)
#define move_window(wnd,x,y) repos_wnd,COL-x,ROW-y,0)
#define forefront(wnd) repos_wnd(wnd,0,0,1)
#define rear_window(wnd) repos_wnd(wnd,0,0,-1)

/* internal to window processes */

void pascal accent(WINDOW *);
void pascal deaccent(WINDOW *);
void pascal scroll(WINDOW *,int);
void pascal repos_wnd(WINDOW *,int,int,int);
void pascal acline(WINDOW *,int);
#define accent(wnd)acline(wnd,WACCENT)
#define deaccent(wnd)acline(wnd,WNORMAL)
#define clr(bg,fg,in)((fg)|(bg<<4)|(in))
#define vad(x,y) ((y) * (maxx * 2) + (x) * 2)
#ifdef FASTWINDOWS
#define cht (c,a) (((c)&255) | ((a)<<8))
#define displ(w,x,y,c,a) vpoke(VSG,vad(x+COL,y+ROW),(((c)&255) | ((a)<<8)))
#define dget(w,x,y) vpeek(VSG,vad(x+COL,y+ROW))
#define verify_wnd(w) (*(w)=listtail)!=0
#else
void pascal displ(WINDOW *wnd,int x,int y,int ch,int at);
#endif

/* Text editor function */

char * pascal text_editor(WINDOW *,char *,unsigned);

/* Menu function */

void pascal menu_select(char *name,MENU *mn);
int  pascal kmenu_select(char *name,KMENU *mn);

/* Help fundtions */

void pascal load_help(char *);
void pascal set_help(char *,int,int);

/* Data entry functions */

void pascal init_template(WINDOW *);
FIELD * pascal establish_field(WINDOW *,int,int,char *, char *,int);
void pascal clear_template(WINDOW *);
void pascal prep_template(WINDOW *);
void pascal field_tally(WINDOW *);
int  pascal data_entry(WINDOW *);
void pascal wprompt(WINDOW *,int,int,char *);
void pascal error_message(char *);
void pascal clear_notice(void);
void pascal field_window(FIELD *,char *,int,int);
void pascal disp_field(WINDOW *wnd,char *bf,char *msk);

#define field_protect(f,s) 	f->fprot=s
#define field_help(f,h)    	f->fhelp=h
#define field_validate(f,v)	f->fvalid=v

void pascal save_screen(void);
void pascal redraw_screen(void);
void pascal show_mouse(void);
void pascal hide_mouse(void);
void pascal confine_mouse(WINDOW *wnd);
void pascal pause_msg(void);
void pascal nopause_msg(void);
int pascal get_screen_char (int x,int y);
void pascal move_mouse (int x,int y);
int pascal generic_mouse_input (WINDOW *wnd);
void pascal reconfine_mouse(void);

#define SHOWMOUSE show_mouse()
#define HIDEMOUSE hide_mouse()
#define CONFINEMOUSE(x) confine_mouse(x)
