/* Figure 1b -- C Functions */	

#include "defs.h"  /* Hercules #defines */

/* Put a character and its attribute anywhere on the screen. */

void putc_at_location(char ch, int x, int y, unsigned char attrib)
{
_pokeb(SCREEN_BASE,((y * SCREEN_WIDTH) + x) * 2,ch);        

	   /* SCREEN_BASE = Address of the video adapter card;
	      ((y * SCREEN_WIDTH) + X) * 2 = offset address */

_pokeb (SCREEN_BASE,(((y * SCREEN_WIDTH) + x) * 2) + 1, attrib);

}

/* Draw a bar. If height = 0, don't draw the bar, 
   just go to the next. Use different characters for 
   different bars up to a maximum of 10 bars. Add more
   bars by adding more case statements. */

void draw_bar_0(int no,int start_x, int height, int width)
{
	int i,j,end_x,end_y,start_y;

	switch (height){
	  case 0 :
	    break;           
	  default:
	  end_x = start_x + width;
          end_y = 22 - height;
	  start_y = 22;
	    for (j = start_x; j <= end_x; ++j)
	      for (i = end_y; i <= start_y; ++i)
	        switch (no){
	        case 0 :		
      	          putc_at_location(0xB1, j,i, 7);
                  break;
		case 1 :
            	  putc_at_location(0xB2, j,i, 7);
              	  break;
        	case 2 :
            	  putc_at_location(0xB0, j,i, 7);
         	  break;
		case 3 :
                  putc_at_location(0xB1, j,i, 7);
         	  break;
		case 4 :
                  putc_at_location(0xB2, j,i, 7);
         	  break;
        	case 5 :
                  putc_at_location(0xB0, j,i, 7);
         	  break;
		case 6 :
                  putc_at_location(0xB2, j,i, 7);
              	  break;
        	case 7 :
                  putc_at_location(0xB0, j,i, 7);
         	  break;
		case 8 :
             	  putc_at_location(0xB1, j,i, 7);
         	  break;
		case 9 :
                  putc_at_location(0xB2, j,i, 7);
         	  break;
        	case 10 :
            	  putc_at_location(0xB0, j,i, 7);
         	  break;
        	}
        }
}

/* Draw an inverse video x/y axis. */

void draw_axis_0()
{
	int x,y;
	y = 23;
	for (x = 1; x <= 73; ++x)       /* from 1,23 to 1,73 */
           putc_at_location(0xdb,x,y,7);
        x = 1;
	for (y = 3; y <= 23; ++y)       /* from 3,1, to 23,1 */
           putc_at_location(0xdb,x,y,7);
}

/* Clear the screen by writing blanks to every 
   screen location. */

void clear_screen_0()

{
unsigned int x,y;
  for (y = 0; y <=25; ++y)
    for (x = 0; x <=80; ++x)
      putc_at_location(' ',x,y,7);
}

/* Remove or restore the cursor by writing to the 
	6845 CRT Controller. */

void remove_cursor_0()

{
  _outportb(0x3b4,10);	     /* 0x3b4 = PC I/O address register 
                               of the 6845; 
                               10 = 6845 register which 
                               defines cursor start */
  _outportb(0x3b5,20);       /* 20 = code to turn cursor off */
}

void restore_cursor_0()
{
  _outportb(0x3b4,10);       /* 0x3b4 = PC I/O address register 
                                of the 6845;
                                10 = 6845 register which 
                                defines cursor start */
  _outportb(0x3b5,(CURSOR)); /* CURSOR = cursor end */
}
