#!/bin/sh

AUTO=yes   
TESTONLY=no

for PARM in $*
do
    case $PARM in
	--interactive*)
		AUTO=no
		;;
	--test*)
		TESTONLY=yes
		;;
    esac;
done

if [ -e /usr/src/linux ]; then
    KERNELPATH=/usr/src/linux
else
    if [ -e /usr/src/linux-`uname -r` ]; then
	KERNELPATH=/usr/src/linux-`uname -r`
    else
	if [ -e /usr/lib/kernel/linux ]; then
	    KERNELPATH=/usr/lib/kernel/linux
	else
	    if [ -e /usr/lib/kernel/linux-`uname -r` ]; then
		KERNELPATH=/usr/lib/kernel/linux-`uname -r`
	    else
		echo "Can't find the kernel sources. Please, install them and run this program."
		exit 1
	    fi	
	fi
    fi	
fi

if [ ! -h /usr/include/linux ]; then
    if [ -d /usr/include/linux ]; then
	if [[ "$AUTO" = "no" ]]; then
	    echo "Directory /usr/include/linux exists. Create symlink to real kernel headers? [yes/no]"
	    read answer
	    case "$answer" in
		y|Y|yes|Yes|YES)
		    echo "Directory /usr/include/linux will be saved as /usr/include/linux.default"
		    mv /usr/include/linux /usr/include/linux.default
		    ;;
		*)
		    echo "Umpossibly to continue installation. Program will be terminated."
		    exit 1
		    ;;
	    esac
	else
	    mv /usr/include/linux /usr/include/linux.default
	fi
    fi
    [ $TESTONLY = "no" ] && ln -s $KERNELPATH/include/linux /usr/include/linux
fi

if [ ! -h /usr/include/asm ]; then
    if [ -d /usr/include/asm ]; then
	if [[ "$AUTO" = "no" ]]; then
	    echo "Directory /usr/include/asm exists. Create symlink to real kernel headers? [yes/no]"
	    read answer
	    case "$answer" in
		y|Y|yes|Yes|YES)
		    echo "Directory /usr/include/asm will be saved as /usr/include/asm.default"
		    mv /usr/include/asm /usr/include/asm.default
		    ;;
		*)
		    echo "Umpossibly to continue installation. Program will be terminated."
		    exit 1
		    ;;
	    esac
	else
	    rm /usr/include/asm /usr/include/asm.default
	fi
    fi
    [ $TESTONLY = "no" ] && ln -s $KERNELPATH/include/asm /usr/include/asm
fi

if [ ! -x "`which gcc 2>/dev/null`" -o ! -x "`which make 2>/dev/null`" ]; then
    echo "Can't find make or gcc. Program can't work any longer"
    exit 1
fi

cd ./ifslinux
# set current VERSION, PATCHLEVEL, SUBLEVEL, EXTRAVERSION
eval `sed -n -e 's/^\([A-Z]*\) = \([0-9]*\)$/\1=\2/p' -e 's/^\([A-Z]*\) = \(-[-a-z0-9]*\)$/\1=\2/p' $KERNELPATH/Makefile`
if [ -z "$VERSION" -o -z "$PATCHLEVEL" -o -z "$SUBLEVEL" ]
then
    echo "unable to determine current kernel version" >&2
    exit 1
fi

#KERNELVERSION=$VERSION.$PATCHLEVEL.$SUBLEVEL${EXTRAVERSION}
KERNELVERSION=`sed -n 's/^.define UTS_RELEASE "\(.*\).*"/\1/p' $KERNELPATH/include/linux/version.h`

maked=no

for ver in $KERNELVERSION
do
    MODPATH=/lib/modules/$ver/kernel/
    if [ -d $MODPATH ]; then
        echo "ufsd driver can be compiled for kernel $ver"
        make clean  >/dev/null 2>&1
        make  >/dev/null 2>&1

        exitCode=$?
        case $exitCode in
	    0)
		maked=yes
	        ;;
	    *)
	        echo "Ufsd module was't made"
	        cd ../
	        exit 1
        esac

        CURRKERNEL=`uname -r`

        if [ "$CURRKERNEL" != "$ver" ]; then
	    echo "Ufsd module was build and will be installed for kernel $ver but current kernel in $CURRKERNEL."
	    if [[ "$AUTO" = "no" ]]; then
	        echo "Do you want to install module and service?"
	        read answer
	        case "$answer" in
		    y|Y|yes|Yes|YES)
		        echo "Ok. Trying to install."
		        ;;
		    *)
		        echo "Program terminated."
		        cd ../
		        exit 1
		        ;;
	        esac
	    fi
        fi

        INSTPATH=/lib/modules/$ver/kernel/fs/ufsd
        if [ -e "$INSTPATH/ufsd.o" ]; then
    	    rm "$INSTPATH/ufsd.o"
        fi

        if [ ! -d $INSTPATH ]; then
	    echo Creating the directory for module
            mkdir $INSTPATH
        fi 						
        echo "Moving module in destination directory..."
        [ $TESTONLY = "no" ] && cp ./objfre/ufsd.o $INSTPATH
    else
	echo "Can't find compiled modules for kernel $ver"
    fi 						
done

cd ../

if [[ "$maked" = "no" ]]; then
    echo "Can't find compiled modules for kernel. Please, compile your kernel and run this program again."
    exit 1
fi

echo "Finding module dependencies..."
/sbin/depmod >/dev/null 2>&1

szOSType="unknown"
if [ -x "/sbin/SuSEconfig" ]; then
    if [ -x "`which yast 2>/dev/null`" -o -x "`which yast2 2>/dev/null`" ]; then
	if [ -e "/sbin/init.d" ]; then
		echo "I think you are using a SuSE-like (less 7.1) system"
		szOSType="SuSE70"
	else
	    if [ -e "/etc/init.d" ]; then
		echo "I think you are using a SuSE-like (7.1 or upper) system"
		szOSType="SuSE71"
	    else  
		echo "I think you are using a SuSE-like system"
		szOSType="SuSE"
	    fi
	fi
    fi	    
else
    if [ -x "`which chkconfig 2>/dev/null`" ]; then
	if [ -e "/etc/rc.d/init.d" ]; then
	    echo "I think you are using a Redhat-like system"
	    szOSType="redhat"
	else
    	    echo "I can't recognize your operating system and install services"
	    exit 1
	fi
    else
	if [ -x "`which dpkg 2>/dev/null`" ]; then
	    if [ -e "/etc/init.d" ]; then
		echo "I think you are using a Debian-like system"
		szOSType="debian"
	    fi
	else
	    if [ -e "/etc/rc.d/rc.M" ]; then
		echo "I think you are using a slackware-like system"
		szOSType="slackware"
	    else
		echo "I can't recognize your operating system and install services"
		exit 1
	    fi
	fi
    fi
fi

if [ $szOSType = "redhat" ]; then
    echo "Adding services for RedHat like system"
    if [ $TESTONLY = "no" ]; then
	if [ -e "$servicepath/ufsd" ]; then
	    chkconfig --del ufsd
	    rm -f /etc/rc.d/init.d/ufsd
	fi
	cp ./init.d/ufsd.rh7 /etc/rc.d/init.d/ufsd
	chkconfig --add ufsd
	if [ ! "$?" -eq 0 ]; then
    	    echo
    	    echo "Can't add services"
    	    echo
	    exit 1
	fi
    fi
fi

# for "SuSE70" "SuSE71" "SuSE"
if [ $szOSType = "SuSE70" -o $szOSType = "SuSE71" -o $szOSType = "SuSE" ]; then
    if [ $szOSType = "SuSE71" ]; then
	servicepath="/etc/init.d"
    else
	servicepath="/sbin/init.d"
    fi
    echo "Adding services for SuSE like system"
    if [ -x "`which chkconfig 2>/dev/null`" ]; then
	if [ $TESTONLY = "no" ]; then
	    if [ -e "$servicepath/ufsd" ]; then
		chkconfig --del ufsd
		rm -f $servicepath/ufsd
	    fi
	    cp ./init.d/ufsd.suse $servicepath/ufsd
	    chkconfig --add ufsd
	    if [ ! "$?" -eq 0 ]; then
    		echo
    		echo "Can't add services"
    	        echo
	        exit 1
	    fi
	fi    
    else
	if [ $TESTONLY = "no" ]; then
	    cp ./init.d/ufsd.suse $servicepath/ufsd
	    ln -s $servicepath/ufsd $servicepath/rc2.d/K14ufsd
	    ln -s $servicepath/ufsd $servicepath/rc2.d/S08ufsd
	    ln -s $servicepath/ufsd $servicepath/rc3.d/K14ufsd
	    ln -s $servicepath/ufsd $servicepath/rc3.d/S08ufsd
	    ln -s $servicepath/ufsd $servicepath/rc5.d/K14ufsd
	    ln -s $servicepath/ufsd $servicepath/rc5.d/S08ufsd
	fi 
    fi
fi

cd ./util
make clean >/dev/null 2>&1
make >/dev/null 2>&1

exitCode=$?
case $exitCode in
    0)
	echo "Utilite was made"
	;;
    *)
	echo "Utilite was't made"
	cd ../
	exit 1
esac

cd ../

ChangeFstab()
{
    if [ -e "./util/parttype" ]; then
	mntletter=0
	for mntdev in `/bin/awk '{print $4}' /proc/partitions` ; do
	    #major minor blocks device
	    type=`./util/parttype "/dev/$mntdev"`
	    if [ "$type" = "ntfs" ]; then
    		echo "Found NTFS partition /dev/$mntdev "
	        a=$[mntletter++]
		mkdir -p $1/ntfs_$a
	        /bin/cat >> /etc/fstab <<EOF
/dev/$mntdev $1/ntfs_$a ufsd defaults 0 0
EOF
		if ! /bin/grep -iq $1/ntfs_$a /proc/mounts >/dev/null 2>&1 ; then
		    /bin/mount -t ufsd /dev/$mntdev $1/ntfs_$a
    		    echo "NTFS partition /dev/$mntdev mounted to $1/ntfs_$a"
		fi
	    fi
        done
    fi
}    

if [[ "$AUTO" = "no" ]]; then
    echo "Would you like to mount your NTFS partition at start? [yes/no]"
    read answer
    case "$answer" in
	y|Y|yes|Yes|YES)
	    ChangeFstab /mnt
	    ;;
	*)
	    ;;
    esac
else
    ChangeFstab /mnt
fi
