/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strrmchr
 *
 *  Description :  Removing all occurences of a target character.
 *
 *  Parameters  :  in/out   char  *string
 *                 in       char  target     target char to remove
 *
 *  Return code :  pointer to result.
 *
 *  OS/Compiler :  All
 ***/

char *strrmchr( char *string, char target )

{ char *ptr, *str_begin = string;

  for ( ptr = string; *string; string ++ )
      if ( *string != target ) *ptr++ = *string;

  *ptr = '\0';

  return str_begin;
}
                                         