#include <dos.h>
#include <stdlib.h>
#include "colors.h"
#include "!bestlib.h"

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

#define ROCK 219                       /* ASCII code for the oncoming rocks */
#define FACEMAN 1                      /* ASCII code for the main character */
#define MAXROCKS 200                   /* the maximum number of rocks       */
#define MAXROCKDELAY 6                 /* the maximum delay in clock ticks  */
#define SCREENX 80                     /* number of characters on x axis    */
#define SCREENY 50                     /* number of characters on y axis    */

void moverock(void);                   /* procedure definition to move rock */
void movefaceman(void);      /* procedure definition to move main character */

   /*** NOTE  even though this program only uses the "keyp" structure, the
              other three are necessary for the assembler routines in the
              !BESTLIB.LIB library to function properly.  C would also
              produce a "linker warning" if you have enabled that warning ***/
filldata fidata;                       /* create a "filldata" structure     */
printdata prdata;                      /* create a "printdata" structure    */
mousedata msdata;                      /* create a "mousedata" structure    */
asciiscan keyp;                        /* create an "asciiscan" structure   */

struct {                               /* the rock data structure           */
   int x;                              /* the current x-coordinate          */
   int y;                              /* the current y-coordinate          */
   int oldx;                           /* the old x-coordinate              */
   int oldy;                           /* the old y-coordinate              */
   int dir;                            /* the direction                     */
} rock[MAXROCKS];                      /* create an array for all the rocks */

struct {                               /* the main character data structure */
   int x;                              /* the current x-coordinate          */
   int y;                              /* the current y-coordinate          */
   int oldx;                           /* the old x-coordinate              */
   int oldy;                           /* the old y-coordinate              */
   int dir;                            /* the direction                     */
} faceman;                             /* only one main character           */

void main(void)
{
   int oldmode;
   register int i;                     /* register class speeds up loops    */

   for (i = 0; i < MAXROCKS; i++) {    /* initialize rock structures        */
      stopw(i, random(MAXROCKDELAY));  /* initialize stop watch             */
      rock[i].x = rock[i].oldx = 0;    /* initialize x-coordinate           */
      rock[i].y = rock[i].oldy = random(SCREENY);    /* random y-coordinate */
      rock[i].dir = 3;                 /* initialize default direction      */
   }
   faceman.dir = 0;                /* initialize main character's direction */
   faceman.x = faceman.oldx = 40;    /* initialize main character's y-coord */
   faceman.y = faceman.oldy = 13;    /* initialize main character's x-coord */

   oldmode = readvideomode();          /* save the current video mode       */
   textm(2);                           /* change to 50 line text mode       */
   textmem(3);                         /* store text video memory           */
   cursor(3, 1);                       /* hide and store cursor position    */
   clear(LIGHTGREEN, BLUE);            /* clear the screen and set colors   */
   printcatxy(FACEMAN, faceman.x, faceman.y);    /* draw the main character */

   do {
      movefaceman();                   /* move the main character           */
      moverock();                      /* move one rock at a time           */
      printsatxy("Press <ESC> to exit", 30, 24);
   } while (keyp.ascii != 27);         /* loop until <ESC> key is pressed   */

   changevideomode(oldmode);           /* restore the original video mode   */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(1);                      /* restore text video memory         */
      cursor(1, 1);                    /* show and restore cursor position  */
   }
}

/*
 * MOVE ONE ROCK AT A TIME AND RANDOMLY SET THE NEW DELAY BEFORE THE NEXT MOVE
 */
void moverock(void)
{
   static int i = 0;                   /* this variable is never lost       */

   if (stopw(i, 0) > 0) {              /* if it is time to move this rock.. */
      if (++rock[i].x >= SCREENX) {    /* if the rock is at the boundary..  */
         rock[i].x = 0;                /* reset its x-coordinate            */
         rock[i].y = random(SCREENY);  /* randomly reset its y-coordinate   */
      }
      printcatxy(32, rock[i].oldx, rock[i].oldy);     /* erase the old rock */
      printcatxy(ROCK, rock[i].x, rock[i].y);         /* draw the new rock  */
      rock[i].oldx = rock[i].x;  /* modify the old x-coordinate of the rock */
      rock[i].oldy = rock[i].y;  /* modify the old y-coordinate of the rock */
      stopw(i, random(MAXROCKDELAY)); /* new random delay for the next move */
   }
   if (++i >= MAXROCKS) i = 0;  /* if all rocks have moved, restart from #1 */
}

/*
 * MOVES THE MAIN CHARACTER ACCORDING TO KEYPRESS, REGARDLESS OF NUM LOCK
 *
 *                                      1         5   6       5 1 6
 *                                     \|/         \|/         \|/
 *                    DIRECTIONS:    2--+--3      --+--      2--+--3
 *                                     /|\         /|\         /|\
 *                                      4         7   8       7 4 8
 */
void movefaceman(void)
{
   register int i;

   for (i = 0; i < MAXROCKS; i++) {    /* check for a collision with a rock */
      if (rock[i].x == faceman.x && rock[i].y == faceman.y) {
	 sound(120); msec(400);        /* create a 120 Hz sound for 400 ms  */
         sound(40); msec(850);         /* create a 40 Hz sound for 850 ms   */
         nosound();                    /* silence the speaker               */
      }
   }
   if (keyhit() == FALSE) return;      /* if not keypress ready, return     */
   getchr();                 /* read the keypress into the "keyp" structure */
   kbclear();         /* clear all other character from the keyboard buffer */
   keyp.ascii = dncase(keyp.ascii);    /* convert to lowercase if UPPERCASE */
   if (!keyp.ascii)                    /* if there is no ASCII code..       */
      keyp.ascii = keyp.scan;          /* read the scan code                */
   switch(keyp.ascii) {
   case 56 :                           /* direction 1, NUM LOCK active      */
   case 72 :                           /* direction 1, NUM LOCK inactive    */
   case 119: faceman.y--; break;       /* direction 1, right letter-pad     */
   case 52 :                           /* direction 2, NUM LOCK active      */
   case 75 :                           /* direction 2, NUM LOCK inactive    */
   case 97 : faceman.x--; break;       /* direction 2, right letter-pad     */
   case 54 :                           /* direction 3, NUM LOCK active      */
   case 77 :                           /* direction 3, NUM LOCK inactive    */
   case 100: faceman.x++; break;       /* direction 3, right letter-pad     */
   case 50 :                           /* direction 4, NUM LOCK active      */
   case 80 :                           /* direction 4, NUM LOCK inactive    */
   case 120: faceman.y++; break;       /* direction 4, right letter-pad     */
   case 55 :                           /* direction 5, NUM LOCK active      */
   case 71 :                           /* direction 5, NUM LOCK inactive    */
   case 113: faceman.x--, faceman.y--; break;
                                       /* direction 5, right letter-pad     */
   case 57 :                           /* direction 6, NUM LOCK active      */
   case 73 :                           /* direction 6, NUM LOCK inactive    */
   case 101: faceman.x++, faceman.y--; break;
                                       /* direction 6, right letter-pad     */
   case 49 :                           /* direction 7, NUM LOCK active      */
   case 79 :                           /* direction 7, NUM LOCK inactive    */
   case 122: faceman.x--, faceman.y++; break;
                                       /* direction 7, right letter-pad     */
   case 51 :                           /* direction 8, NUM LOCK active      */
   case 81 :                           /* direction 8, NUM LOCK inactive    */
   case 99 : faceman.x++, faceman.y++; /* direction 8, right letter-pad     */
   }
   if (faceman.x < 0) faceman.x = 0;   /* movement beyond the screen edge.. */
   if (faceman.y < 0) faceman.y = 0;   /* not allowed                       */
   if (faceman.y > SCREENY - 1) faceman.y = SCREENY - 1;
   if (faceman.x > SCREENX - 1) faceman.x = SCREENX - 1;
   printcatxy(32, faceman.oldx, faceman.oldy);  /* erase the main character */
   printcatxy(FACEMAN, faceman.x, faceman.y);   /* print the main character */
   faceman.oldx = faceman.x;    /* modify old x-coord of the main character */
   faceman.oldy = faceman.y;    /* modify old y-coord of the main character */
}
