/* This is an illustration of the use of a generalized function to give      */
/* access to IBM PC interupts from C (Lattice at least) using the subroutine */
/* INTRPT contained in INTC.OBJ (source in INTC.ASM).  This subroutine will  */
/* provide a standard interface to Lattice C (at least) to the interrupts    */
/* provided.  All interrupts using register (not segment) elements are       */
/* provided for, but the assembler program may be easily modified if segment */
/* registers are required.  Communications done with the module are through  */
/* external integers (again it is easy to change this).                      */
/* Please note that the routine works under DOS 1.1 with version 1.04, and   */
/* under DOS 2.0 with the new C.OBJ generated from the C.ASM module stored   */
/* under this BBS.							     */
/*									     */
/*				B. K. Jenkins				     */


#include	<stdio.h>

main()
{

/* The following variables are the communication link to the INTRPT      */
/* function in INTC.OBJ. r_ax is the value to be in the AX register      */
/* when the interupt occurs, r_bx is the BX register, etc. and intrp     */
/* is the interupt number.  Although these are declared as integer       */
/* only the low order bytes are used as required (2 bytes for a register */
/* 1 byte for intrp).  No validity checking for values occurs and are    */
/* fully the responsibility of the programmer (i.e. you can mess around  */
/* as well as mess up).                                                  */         
	extern int intrpt();
	extern int intrp,r_ax,r_bx,r_cx,r_dx;

	int dh,dl;

/* clear the screen (Type 10H, function 7H for whole screen) */
	intrp = 0x10;
	r_ax = 0x6 * 256 + 0;
	r_bx = 0x7 * 256;
	r_cx = 0;
	r_dx = 25*256 +80;
	intrpt();

	printf("The screen was cleared\n");

/* move cursor to top (Type 10H, function 2H) */
	intrp = 0x10;
	r_ax = 0x2 * 256 + 0;
	r_bx = 0;
	r_cx = 0;
	r_dx = 0;
	intrpt();

/* use the get date call (Type 21H, function 2AH) */
	intrp = 0x21;
	r_ax = 0x2a * 256 + 0;
	r_bx = 256;
	r_cx = 0;
	r_dx = 0;
	intrpt();

	dl = r_dx % 256; dh = r_dx / 256;

	printf("The date is %d/%d/%d (dd/mm/yy)\n",dl,dh,r_cx);
}
 	printf("The date is %d/%d/%d (dd/mm/yy)\n",dl,dh,r_cx);
}
 