#include "ctype.h"
/*
 *	Name		Popd
 *
 *	Function	Pop Directory Utility
 *
 *	Author		Joseph Boykin
 *			47-4 Sheridan Drive
 *			Shrewsbury, MA	01545
 *			617-845-1074
 *
 *	Version		1.00
 */

#define	PATHSZ	66

char	*stkfile = "F:\DIR.STK";	/* Stack file */

int	fd;				/* Open file File Descriptor */
short	int	nrecs;			/* Number of records on stack */
char	name[PATHSZ];			/* Name of directory to go to */

extern	long	_xlseek();

main(argc, argv)
int	argc;
char	*argv[];
{
	int	pflg = 0;

	/*
	 * Parse command line
	 *  -p says to not remove the last entry from the stack
	 */

	if(argc >= 2) {
		if(argv[1][0] == '-' && (tolower(argv[1][1]) == 'p')) {
			pflg++;
			argc--;
			argv++;
		} else {
			cprintf("Invalid command line option\r\n");
			_xexit(1);
		}
	}

	if(argc != 1) {
		cprintf("Usage: popd\r\n");
		_xexit(1);
	}

	/*
	 * Open stack file (if present) and read number of records field
	 */

	if((fd = _xopen(stkfile, 2)) < 0) {
		cprintf("Stack is empty\r\n");
		_xexit(0);
	}
	if(_xread(fd,(char *)&nrecs, sizeof(short int)) != sizeof(short int)) {
		cprintf("Unable to read stack file\r\n");
		_xexit(1);
	}

	/*
	 * Nrecs should never be read as being zero since we delete
	 *  the file when a popd command causes nrecs to become
	 *  zero, but deal with the possibility anyway.
	 */
	if(nrecs == 0) {
		_xclose(fd);
		_xunlink(stkfile);
		cprintf("Stack is empty\r\n");
		_xexit(0);
	}

	/*
	 * Seek to the appropriate entry in the file and
	 *  read the directory name.
	 */
	if(_xlseek(fd, ((long)PATHSZ*(long)(nrecs-1))+sizeof(short int), 0) <
	   (long) 0) {
		cprintf("Seek error on stack file\r\n");
		_xexit(1);
	}
	if(_xread(fd, name, PATHSZ) != PATHSZ) {
		cprintf("Error reading stack file\r\n");
		_xexit(1);
	}

	/*
	 * Change to the destination directory.  An error would mean
	 *  that the user changed disks (physically or logically)
	 *  between the push and pop commands.
	 */
	if(_xchdir(name) < 0) {
		cprintf("Error changing directories\r\n");
		_xexit(1);
	}

	/*
	 * If we don't want to remove the entry from the stack
	 *  just exit now.
	 */
	if(pflg)
		_xexit(0);

	/*
	 * If that was the last entry on the stack remove the file.
	 *  Since the size of the file is never truncated on other
	 *  popd commands, this is our one way of making sure that
	 *  the file maintains a reasonable size.
	 * Otherwise, seek to the beginning of the file and rewrite
	 *  the nrecs field.
	 */
	if(--nrecs <= 0) {
		_xclose(fd);
		_xunlink(stkfile);
	} else {
		if(_xlseek(fd, (long) 0, 0) < (long) 0) {
			cprintf("Seek error on stack file\r\n");
			_xexit(1);
		}
		if(_xwrite(fd, (char *)&nrecs, sizeof(short int)) !=
		   sizeof(short int)) {
			cprintf("Error writing to stack file\r\n");
			_xexit(1);
		}
	}
	_xexit(0);
}
