/*  memory.h

    Memory manipulation functions

*/

#if !defined(__MEM_H)
#define __MEM_H

#ifndef __DEFS_H__
#include <defs.h>
#endif


#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif


#ifdef __cplusplus
extern "C" {
#endif

void *    _RTL_NORM memccpy(void *__dest, const void *__src,
                                        int __c, size_t __n);
int       _RTL_NORM memcmp(const void *__s1, const void *__s2,
                                       size_t __n);
void *    _RTL_NORM memcpy(void *__dest, const void *__src,
                                       size_t __n);
int       _RTL_NORM memicmp(const void *__s1, const void *__s2,
                                        size_t __n);
void *    _RTL_NORM memmove(void *__dest, const void *__src,
                                        size_t __n);
void *    _RTL_NORM memset(void *__s, int __c, size_t __n);

void *    _RTL_NORM memchr(const void *__s, int __c, size_t __n);

#ifdef __cplusplus
};
#endif

#endif  /* __MEM_H */