#if !defined(__DOS_H)
#define __DOS_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#define _A_NORMAL   0x00        /* Normal file, no attributes */
#define _A_RDONLY   0x01        /* Read only attribute */
#define _A_HIDDEN   0x02        /* Hidden file */
#define _A_SYSTEM   0x04        /* System file */
#define _A_VOLID    0x08        /* Volume label */
#define _A_SUBDIR   0x10        /* Directory */
#define _A_ARCH     0x20        /* Archive */

#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0


struct dostime_t
{
    unsigned char hour;         /* Hours */
    unsigned char minute;       /* Minutes */
    unsigned char second;       /* Seconds */
    unsigned char hsecond;      /* Hundredths of seconds */
};

struct dosdate_t
{
    unsigned char day;      /* 1-31 */
    unsigned char month;    /* 1-12 */
    unsigned int  year;     /* 1980 - 2099 */
    unsigned char dayofweek;/* 0 - 6 (0=Sunday) */
};

/* I will reorganize this properly later, do, don't depend on the size
 * field for now.  And DON'T depend on ordering of fields either
 */
struct find_t
{
    unsigned char   reserved[21];
    unsigned char   attrib;            /* attribute byte for matched file */
    unsigned short  wr_time;           /* time of last write to file */
    unsigned short  wr_date;           /* date of last write to file */
    unsigned short  size[2];           /* size of file */
    char            name[13];         /* asciiz name of matched file */
    char	    uu[256];
};

#ifdef __cplusplus
extern "C" {
#endif

int        RTL_NORM _dos_getdrive(int *drive) ;
int        RTL_NORM _dos_setdrive(int drive, int *ndrives);
int        RTL_NORM _dos_getpwd(char *buf, int drive) ;
int        RTL_NORM _dos_setpwd(char *buf) ;
int        RTL_NORM _dos_findfirst(char *string, int attr, struct find_t *buf) ;
int        RTL_NORM _dos_findnext(struct find_t *buf) ;
unsigned   RTL_NORM _dos_open(char *name,int mode, int *fd);
unsigned   RTL_NORM _dos_close(int fd);
unsigned   RTL_NORM _dos_setftime(int fd, unsigned short date, unsigned short time);
unsigned   RTL_NORM _dos_getftime(int fd, unsigned short *date, unsigned short *time);
int        RTL_NORM bdos(int func, unsigned regdx, int regal);

#ifdef __cplusplus
};
#endif

#endif /* __DOS_H */