                        The Netwide Assembler: NASM
                        ===========================

Captulo 1: Introduccin
------------------------

   1.1 Qu es NASM?

       The Netwide Assembler, NASM, es un ensamblador 80x86 diseado para
       la portabilidad y la modularidad. Soporta diversos formatos de ficheros
       objeto, incluyendo los 'a.out' de Linux y ELF, NetBSD/FreeBSD, COFF y
       OBJ de Microsoft 16-bit y Win32. Tambin sacar ficheros en binario puro.
       Su sintaxis est diseada para ser simple y fcil de entender, similar
       a la de Intel pero menos compleja. Soporta cdigos de operacin de
       Pentium, P6 y MMX, y tiene capacidades de macro.

 1.1.1 Por qu otro ensamblador?

       The Netwide Assembler creci a raz de una idea en 'comp.lang.asm.x86'
       (o posiblemente en 'alt.lang.asm' - he olvidado cul), que esencialmente
       se resume en que pareca no haber ningn buen ensamblador gratis de las
       series x86, y que quiz debera alguien escribir alguno.

       (*) 'a86' es bueno, pero no gratis, y en particular no consigues ninguna
           capacidad 32-bit hasta que pagas. Y adems es slo para DOS.

       (*) 'gas' es gratis, y se porta sobre DOS y Unix, pero no es muy bueno,
           ya que est diseado para trabajar de fondo del 'gcc' que siempre
           suministra el cdigo correcto. Por eso, la comprobacin de errores es
           mnima. Adems, su sintxis es horrible, desde el punto de vista de
           cualquiera que quiera _escribir_ actualmente algo en l. Y no puedes
           escribir cdigo 16-bit en l (adecuadamente).

       (*) 'as86' es especfico de Linux, y (por lo menos mi versin) no
           parece tener mucha (o ninguna) documentacin.

       (*) MASM no es muy bueno, y es caro, y slo corre bajo DOS.

       (*) TASM es mejor, pero todava se esfuerza por tener compatibilidad con
           MASM, lo que significa millones de directivas y toneladas de papeleo.
           Y su sintaxis es esencialmente del MASM, con las contradicciones y
           peculiaridades que conlleva (aunque clasifica algunas de estas por
           medio del modo Ideal). Es caro tambin. Y es slo para DOS.

       Por eso aqu, para el placer de tu cdigo, est NASM. Hoy en da todava
       est en fase de prototipo - no te prometemos que pueda mejorar cualquiera
       de estos ensambladores. Pero por favor, _por favor_ envanos informes
       sobre bugs, arreglos, informacin til, y cualquier cosa que puedas tener
       en tus manos (y gracias a todas las personas que ya han hecho esto!. Ya
       sabis quines sois), y nosotros lo mejoraremos con mucho gusto. De nuevo.

 1.1.2 Condiciones de licencia

       Por favor, mira el fichero 'License', suministrado como parte de cualquier
       fichero de distribucin del NASM, para ver las condiciones de licencia
       bajo las cuales puedes usar el NASM.

   1.2 Informacin de contacto

       NASM tiene una pgina WWW en 'http://www.cryogen.com/Nasm'. Los autores
       estn localizables por E-Mail en 'jules@earthcorp.com' y
       'anakin@pobox.com'. Si quieres informarnos de un bug, por favor, lee la
       seccin 10.2 primero.

       Los nuevos lanzamientos de NASM se subirn a 'sunsite.unc.edu',
       'ftp.simtel.net' y 'ftp.coast.net'. Los anuncios se ponen en
       'comp.lang.asm.x86', 'alt.lang.asm', 'comp.os.linux.announce' y
       'comp.archives.msdos.announce' (en la ltima se hace automticamente al
       subir algo a 'ftp.simtel.net').

       Si no tienes acceso a Usenet, o quisieras ser informado por E-Mail
       cuando salgan nuevas versiones, E-Mail a 'anakin@pobox.com' y pregunta.

   1.3 Instalacin

 1.3.1 Instalando NASM bajo MS-DOS o Windows

       Una vez que has obtenido el fichero comprimido del NASM, 'nasmXXX.ZIP'
       (donde XXX denota el nmero de versin del NASM contenido en el
       archivo), descomprmelo dentro de su mismo directorio (por ejemplo
       'c:\nasm').

       El archivo contendr cuatro ficheros ejecutables: los ejecutables NASM
       'nasm.exe' y 'nasmw.exe', y los ficheros ejecutables NDISASM
       'ndisasm.exe' y 'ndisasmw.exe'. En cada caso, el fichero cuyo nombre
       terminat en 'w' es un ejecutable Win32, diseado para correr bajo
       Windows 95 o Windows NT sobre Intel, y el otro es un ejecutable para DOS
       de 16-bit.

       El nico fichero que el NASM necesita para ejecutar es el propio
       ejecutable, por eso copia (al menos) el 'nasm.exe' o el 'nasmw.exe' a
       un directorio en tu PATH, o alternativamente edita el 'autoexec.bat' para
       aadir el directorio del NASM a tu 'PATH'. (si ests instalando slo la
       versin Win32, puedes renombrarlo a 'nasm.exe').

       Esto es todo - NASM est instalado. No necesitas que el directorio 'nasm'
       est presente para ejecutar NASM (a menos que lo hayas aadido a tu
       'PATH'), por lo que puedes borrarlo si necesitas liberar espacio; sin
       embargo, podras querer mantener la documentacin o los programas de
       prueba.

       Si has bajado el archivo de cdigo fuente para DOS, 'nasmXXXs.zip', el
       directorio 'nasm' contendr tambin el cdigo fuente completo, y una
       seleccin de los ficheros Make que puedes (espero) usar para reconstruir
       tu copia de NASM desde el principio. El fichero 'Readme' lista los
       distintos ficheros Make y con qu compiladores funcionarn. Ntese que
       los fichero fuente 'insnsa.c' y 'insnsd.c' se generan automticamente
       desde la tabla maestra de intruccin 'insns.dat' mediante un script
       Perl; se proporciona una versin QBasic del programa, pero es preferible
       que uses la versin Perl. Un puerto DOS del Perl est disponible desde
       www.perl.org.

 1.3.2 Instalando NASM bajo Unix

       Una vez has obtenido el archivo con el cdigo fuente Unix del NASM,
       'nasm-X.XX.tar.gz' (donde 'X.XX' denota el nmero de versin del NASM
       contenido en el archivo), descomprmelo en un directorio como
       '/usr/local/src'. El archivo, cuando es descomprimido, crear su
       propio subdirectorio 'nasm-X.XX'.

       NASM es un paquete auto-configurado: una vez lo has descomprimido,
       'cd' hasta el directorio en que se ha descomprido y escribe
       './configure'. Este script del shell encontrar el mejor compilador de
       C para usarlo para construir NASM y configurar los ficheros Make de
       manera adecuada.

       Una vez que NASM se ha autoconfigurado, puedes escribir 'make' para
       construir los binarios 'nasm' y 'ndisasm', y entonces 'make install' para
       instalarlo en '/usr/local/bin' e instalar las pginas de manual 'nasm.1'
       y 'ndisasm.1' en '/usr/local/man/man1'.  Alternativamente, puedes dar
       opciones como '--prefix' al script 'configure' (ver el fichero 'INSTALL'
       para ms detalles), o instalar el programa t mismo.

       NASM tambin viene con un conjunto de utilidades para el manejo de
       formato personalizable de ficheros objeto RDOFF, que est en el
       subdirectorio 'rdoff' del archivo NASM. Puedes contruir estos con
       'make rdf' e instalarlos con 'make rdf_install', si los quieres.

       Si NASM falla al auto-configurarse, puedes todava hacerlo compilar
       usando el fichero make de Unix 'Makefile.unx'. Copia o renombra el
       fichero a 'Makefile' e intenta escribiendo 'make'. Hay tambin un
       fichero 'Makefile.unx' en el subdirectorio 'rdoff'.

Captulo 2: Ejecutando NASM
---------------------------

   2.1 Sintaxis de la lnea de comando del NASM

       Para ensamblar un fichero, dars un comando de la forma

       nasm -f <formato> <nombre_del_fichero> [-o <salida>]

       Por ejemplo,

       nasm -f elf myfile.asm

       ensamblar 'myfile.asm' en un fichero objeto ELF 'myfile.o'. Y

       nasm -f bin myfile.asm -o myfile.com

       ensamblar 'myfile.asm' en un fichero binario puro 'myfile.com'.

       Para producir un fichero de lista, con la salida de los cdigos
       hexadecimales desde NASM mostrados a la izquierda de los fuentes
       originales, usa la opcin '-l' para dar el nombre de un fichero de lista,
       por ejemplo:

       nasm -f coff myfile.asm -l myfile.lst

       Para conseguir instrucciones de uso adicionales desde NASM, intenta
       escribiendo:

       nasm -h

       Esto tambin listar los formatos de salida disponibles, y cules son.

       Si usas Linux pero no ests seguro si tu sistema es 'a.out' o ELF,
       escribe:

       file nasm

       (en el directorio en el cual pusiste el binario NASM cuando lo
       instalaste). Si te dice algo as como

       nasm: ELF 32-bit LSB executable i386 (386 and up) Version 1

       entonces tu sistema es ELF, y deberas usar la opcin '-f elf' cuando
       quieras usar NASM para producir ficheros objeto de Linux. Si te dice

       nasm: Linux/i386 demand-paged executable (QMAGIC)

       o algo similar, tu sistema es 'a.out', y deberas usar '-f aout' en su
       lugar.

       Al igual que los compiladores y ensambladores Unix, NASM se calla a no
       ser que haya algo mal: no vers ninguna salida en absoluto, a menos que
       d un mensaje de error.

 2.1.1 La opcin '-o': Especificando el nombre del fichero de salida

       NASM nomalmente elegir por ti el nombre de tu fichero de salida;
       precisamente cmo lo haga depende del formato del fichero objeto.
       Para los formatos de fichero objeto de Microsoft ('obj' y 'win32'),
       eliminar la extesin '.asm' (o cualquier extensin que te guste usar -
       a NASM no le importa) del nombre de tu fichero fuente y lo sustituir por
       '.obj'. Para formatos de fichero objeto Unix ('aout', 'coff', 'elf' y
       'as86') ser sustituido por '.o'. Para 'rdf', usar '.rdf', y para el
       formato binario simplemente eliminar la extensin, por eso 'myfile.asm'
       produce el fichero de salida 'myfile'.

       Si el fichero de salida ya existe, NASM lo sobreescribir, a menos que
       tenga el mismo nombre que el fichero de entrada en cuyo caso dar un
       aviso y usar en su lugar 'nasm.out' como nombre del fichero de salida.

       Para las situaciones en las que el comportamiento es inaceptable, NASM
       prove la opcin '-o' del a lnea de comandos, que te permite
       especificar el nombre que desees para el fichero de salida. Indicas la
       opcin '-o' seguida del nombre que desees para el fichero de salida, con
       o sin espacio. Por ejemplo:

       nasm -f bin program.asm -o program.com
       nasm -f bin driver.asm -odriver.sys

 2.1.2 La opcin '-f': Especificando el formato del fichero de salida.

       Si no suministras la opcin '-f' a NASM, ste elegir por s mismo un
       formato para el fichero de salida. En las versiones de distribucin de
       NASM, por defecto siempre es 'bin'; si has compilado tu propia copia de
       NASM, puedes redefinir 'OF_DEFAULT' en tiempo de compilacin y elegir
       qu quieres que sea por defecto.

       Al igual que '-o', el espacio entre '-f' y el formato del fichero de
       salida es opcional; por eso '-f elf' y '-felf' son ambos vlidos.

       Se puede obtener una lista completa de los formatos de salida disponibles
       enviando el comando 'nasm -h'.

 2.1.3 La opcin '-l': Generando un fichero de lista

       Si proporcionas la opcin '-l' al NASM, seguida (con el usual espacio
       opcional) de un nombre de fichero, NASM generar automticamente un
       fichero fuente de lista, en el que son listadas a la izquierda las
       direcciones y el cdigo generado, y el cdigo fuente actual, con
       expansiones de macros multi-lnea (excepto aquellos que especficamente
       soliciten no-expansin en las listas fuente: ver seccin 4.2.9) a la
       derecha. Por ejemplo:

       nasm -f elf myfile.asm -l myfile.lst

 2.1.4 La opcin '-s': Enviar errores a 'stdout'

       Bajo DOS puede ser difcil (creo que hay maneras) redireccionar la
       salida estndar de errores desde un programa a un fichero. Puesto que
       NASM produce normalmente sus mensajes de error y de aviso en 'stderr',
       puede hacerse difcil capturar los errores si (por ejemplo) deseas
       cargarlos en un editor.

       Por lo tanto, NASM proporciona la opcin '-s', sin ningn argumento,
       que hace que los errores sean enviados a la salida estndar en lugar de
       a la estndar de errores. Por eso puedes redireccionar los errores a un
       fichero escribiendo

       nasm -s -f obj myfile.asm > myfile.err

 2.1.5 La opcin '-i': Directorios de bsqueda de un fichero include

       Cuando NASM ve la directiva '%include' en un fichero fuente (ver la
       seccin 4.5), buscar dicho fichero no slo en el directorio actual,
       sino tambin en cualquier directorio especificado en la lnea de comandos
       usando la opcin '-i'. Por lo tanto puedes incluir ficheros desde una
       librera de macros, por ejemplo, escribiendo

       nasm -ic:\macrolib\ -f obj myfile.asm

       (Como siempre, se permite el espacio entre '-i' y el path, y es opcional).

       NASM, en base al inters de la completa portabilidad del cdigo fuente,
       no entiende los convenios de nombres de ficheros del OS en el que se est
       ejecutando; la cadena que entregues como argumento a la opcin '-i'
       preceder al fichero incluido exactamente como la hayas escrito. Por eso,
       es necesaria la barra invertida '\' final en el ejemplo de arriba. Bajo
       Unix, la barra '/' final es necesaria igualmente.

       (Puedes usar esto en tu beneficio, si eres realmente perverso, si te
       das cuenta que la opcin '-ifoo' causar que '%include "bar.i"' busque
       el fichero 'foobar.i'...)

       Si quieres definir un path _estndar_ de bsqueda de include, parecido
       al '/usr/include' en los sistemas Unix, deberas colocar una o ms
       directivas '-i' en la variable de entorno 'NASM' (ver seccin 2.1.11).

 2.1.6 La opcin '-p': Pre-incluir un fichero

       NASM te permite especificar ficheros para que sean _pre-incluidos_ en
       tu fichero fuente, usando la opcin '-p'. Por eso, ejecutar

       nasm myfile.asm -p myinc.inc

       es equivalente a ejecutar 'nasm myfile.asm' y colocar la directiva
       '%include "myinc.inc"' al principio del fichero.

 2.1.7 La opcin '-d': Pre-definir un macro

       Al igual que la opcin '-p', da una manera alternativa de colocar una
       directiva '%include' al principio del fichero fuente, la opcin '-d'
       da una manera alternativa de colocar una directiva '%define'. Puedes
       codificar

       nasm myfile.asm -dFOO=100

       como alternativa a colocar la directiva

       %define FOO 100

       al comienzo del fichero. Puedes omitir el valor del macro, esto es:
       la opcin '-dFOO' es equivalente a codificar '%define FOO'. Esta forma
       de directiva puede ser til para seleccionar opciones en tiempo de
       ensamblaje que son comprobadas usando '%ifdef', por ejemplo '-dDEBUG'.

 2.1.8 La opcin '-e': Slo preprocesar

       NASM permite al preprocesador que se ejecute solo, hasta un punto.
       Usando la opcin '-e' (que no requiere argumentos) har que NASM
       preprocese su fichero de entrada, expanda todas las referencias a macros,
       quite todos los comentarios y directivas del preprocesador, y escriba
       el fichero resultante en la salida estndar (o lo salve a un fichero, si
       la opcin '-o' es usada a su vez).

       Esta opcin no se puede aplicar a programas que requieran del
       preprocesador para evaluar expresiones que dependan de los valores de
       smbolos: por ejemplo el siguiente cdigo

       %assign tablesize ($-tablestart)

       causar un error en el modo de slo preprocesar.

 2.1.9 La opcin '-a': No preprocesar en absoluto

       Si NASM est siendo usado como 'back end' de un compilador, podra
       desearse suprimir completamente el preprocesado y asumir que el
       compilador ya lo ha hecho, para ganar tiempo e incrementar la velocidad
       de compilacin. La opcin '-a', que no requiere ningn argumento, le
       dice al NASM que sustituya su potente preprocesador por un preprocesador
       que no hace nada.

2.1.10 La opcin '-w': Activar o desactivar los avisos de ensamblaje

       NASM puede observar muchas condiciones durante el curso del ensamblaje
       que son de mencin especial para el usuario, pero no errores lo
       suficientemente importante como para justificar que NASM rechace el
       generar un fichero de salida. Estas condiciones son informadas como
       errores, pero vienen con la palabra 'warning' antes del mensaje. Los
       avisos no evitan que NASM genere un fichero de salida y devuelva un
       estado satisfactorio al sistema operativo.

       Algunas condiciones son todava menos importantes que esto: son slo
       algunas veces importantes para el usuario. Por eso, NASM implementa la
       opcin '-w' en la lnea de comandos, que activa o desactiva cierta clase
       de avisos del ensamblador. Tales clases de avisos son descritas por un
       nombre, por ejemplo 'orphan-labels'; puedes activar los avisos de esta
       clase con la opcin de lnea de comandos '-w+orphan-labels' y
       desactivarlos con '-w-orphan-labels'.

       Las clases de avisos suprimibles son:

       (*) 'macro-params' cubre los avisos sobre los macros multi-lnea que
           son invocados con un nmero errneo de parmetros. Esta clase de
           avisos est activa por defecto; ver la seccin 4.2.1 para un ejemplo
           de por qu puedes querer desactivarlos.

       (*) 'orphan-labels' cubre los avisos sobre las lneas del fuente que no
           contienen pero definen una etiqueta que no est seguida de ':'.
           NASM no avisa por defecto de esto en algunas situaciones oscuras;
           ver la seccin 3.1 para un ejemplo de por qu lo puedes querer.

       (*) 'number-overflow' cubre los avisos sobre las constantes numricas
           que no caben en 32 bits (por ejemplo, es fcil escribir una F de ms
           y generar '0x7ffffffff' por error). Esta clase de avisos est
           activada por defecto.

2.1.11 La variable de entorno 'NASM'

       Si defines una variable de entorno llamada 'NASM', el programa la
       interpretar como una lista extra de opciones de la lnea de comandos,
       que es procesada antes de la lnea real de comandos. Puedes usar esto
       para definir directorios estndar de bsqueda de los ficheros include,
       poniendo la opcin '-i' en la variable 'NASM'.

       El valor de la variable se divide en el espacio en blanco, por eso el
       valor '-s -ic:\nasmlib' ser tratado como dos opciones separadas. Sin
       embargo, esto quiere decir que el valor '-dNAME="my name"' no har lo
       que podras querer, porque ser partida en el espacio en blanco y el
       procesamiento de la lnea de comandos del NASM se ver confundido por
       las dos palabras sin sentido '-dNAME="my' y 'name"'.

       Para evitar esto, NASM proporciona una caracterstica, si comienzas la
       variable de entorno 'NASM' con algn carcter que no sea el signo menos,
       NASM tratar este carcter como un carcter separador de opciones. Por
       eso, estableciendo la variable 'NASM' con el valor '!-s!-ic:\nasmlib'
       equivale a establecerla con '-s -ic:\nasmlib', y '!-dNAME="my name"'
       funcionar.

   2.2 Comienzo rpido para los usuarios de MASM

       Si ests acostumbrado a escribir programas con MASM, o con TASM en el
       modo compatible con MASM (no Ideal), o con 'a86', esta seccin intenta
       remarcar las principales diferencias entre la sintaxis de MASM y de NASM.
       Si no ests acostumbrado a MASM, es probablemente mejor que te saltes
       esta seccin.

 2.2.1 NASM es sensible a maysculas

       Una sencilla diferencia es que NASM es sensible a maysculas. Diferencia
       si tu llamas a una etiqueta 'foo', 'Foo' o 'FOO'. Si ests ensamblando
       ficheros '.OBJ' para DOS u OS/2, puedes invocar la directiva 'UPPERCASE'
       (documentada en la seccin 6.2) para asegurarte que todos los smbolos
       exportados a otros mdulos de cdigo se fuerzan a maysculas; pero
       incluso entonces, _dentro_ de un mdulo sencillo, NASM distinguir entre
       etiquetas que difieran en ser maysculas o minsculas.

 2.2.2 NASM requiere de corchetes para las referencias a memoria

       NASM fue diseado teniendo en mente la simplificacin de la sintaxis. Una
       de las metas de diseo de NASM es que debera ser posible, tanto como sea
       prctico, para el usuario mirar una simple lnea de cdigo NASM y decir
       que cdigo de operacin genera. Esto no se puede hacer en MASM: si
       declaras por ejemplo,

       foo       equ 1
       bar       dw 2

       entonces las dos lneas de cdigo

                 mov ax,foo
                 mov ax,bar

       generaran cdigos de operacin completamente diferentes, a pesar de
       tener sintaxis de apariencia idntica.

       NASM evita estas situaciones indeseables teniendo una sintaxis mucho
       ms simple para las referencias a memoria. La regla es sencilla ya que
       cualquier acceso al _contenido_ de una posicin de memoria requiere de
       unos corchetes rodeando la direccin, y cualquier acceso a la _direccin_
       de memoria de una variable no. Por eso, una instruccin de la forma
       'mov ax,foo' _siempre_ se referir a una constante en tiempo de
       compilacin, ya sea un 'EQU' o la direccin de una variable; y para
       acceder al _contenido_ de la variable 'bar', debes codificar
       'mov ax,[bar]'.

       Esto tambin significa que NASM no necesita la palabra clave del MASM
       'OFFSET', puesto que el cdigo MASM 'mov ax,offset bar' significa
       exactamente lo mismo que el 'mov ax,bar' del NASM. Si ests intentando
       coger grandes cantidades de cdigo MASM para ensamblar bajo NASM, siempre
       puedes codificar '%idefine offset' para hacer que el preprocesador trate
       la palabra clave 'OFFSET' como algo sin funcin alguna.

       Este asunto es todava ms confuso en 'a86', donde declarar una etiqueta
       seguida de dos puntos la define como una 'etiqueta' en oposicin a una
       'variable', y hace que 'a86' adopte semntica del estilo de NASM; por
       eso en 'a86', 'mov ax,var' tiene un comportamiento distinto dependiendo
       de si 'var' ha sido declarada como 'var: dw 0' (una etiqueta) o como
       'var dw 0' (una variable del tamao de una palabra). NASM es ms sencillo
       en comparacin: _todo_ es una etiqueta.

       NASM, en base a la simplicidad, tampoco implementa la sintaxis hbrida
       soportada por MASM y sus clones, como 'mov ax,table[bx]', donde una
       referencia a memoria est indicada por una porcin fuera de los corchetes
       y otra dentro. La sintaxis correcta para lo de arriba es
       'mov ax,[table+bx]'. Igualmente, 'mov ax,es:[di]' es incorrecto y
       'mov ax,[es:di]' es correcto.

 2.2.3 NASM no almacena los tipos de las variables

       NASM, por diseo, decide no recordar los tipos de las variables que
       declares. Mientras que MASM recordar, al ver 'var dw 0', que has
       declarado 'var' como una variable del tamao de la palabra, y ser
       capaz de decidir en la ambigedad del tamao de la instruccin
       'mov var,2', NASM no recordar deliberadamente nada sobre el smbolo
       'var' excepto dnde comienza, y por eso debes especificiar el cdigo
       'mov word [var],2'.

       Por esta razn, NASM no implementa las instrucciones 'LODS', 'MOVS',
       'STOS', 'SCAS', 'CMPS', 'INS' o 'OUTS', sino que slo proporciona las
       formas tales como 'LODSB', 'MOVSW' y 'SCASD' que especifican
       explcitamente el tamao de los componentes de las cadenas que estn
       siendo manipuladas.

 2.2.4 NASM no tiene 'ASSUME'

       Como parte del camino de NASM hacia la simplicidad, tampoco implementa
       la directiva 'ASSUME'. NASM no seguir la pista de los valores que
       decidas poner en tus registros de segmento, y nunca generar
       _automticamente_ un prefijo de superposicin de segmento.

 2.2.5 NASM no soporta modelos de memoria

       NASM tampoco tiene directivas para soportar los diferentes modelos de
       memoria de 16-bit. El programador deber seguir el rastro de aquellas
       funciones que se supone que son llamadas con una llamada lejana y cules
       con una cercana, y es responsable de poner de forma correcta la
       instruccin 'RET' ('RETN' o 'RETF'; NASM acepta 'RET' en s mismo como
       una forma alternativa de 'RETN'); adems, el programador es responsable
       de codificar las instrucciones CALL FAR donde sea necesario cuando se
       llame a funciones _externas_, y tambin debe seguir la pista de qu
       definiciones de variables externas son lejanas y cules cercanas.

 2.2.6 Diferencias en la coma flotante

       NASM usa diferentes nombres para referirse a los registros de coma
       flotante desde MASM: donde MASM debera llamarlos 'ST(0)', 'ST(1)' y
       dems, y 'a86' los llamara simplemente '0', '1', etc, NASM decide
       llamarlos 'st0', 'st1', etc.

       Como en la versin 0.96, NASM trata las instrucciones con formas 'nowait'
       del mismo modo que los ensambladores compatibles con MASM. El tratamiento
       idiosincrtico empleado por la 0.95 y anteriores estaba basado en un
       malentendido por lo autores.

 2.2.7 Otras diferencias

       Por razones histricas, NASM usa la palabra clave 'TWORD' donde MASM y
       sus compatibles usand 'TBYTE'.

       NASM no declara los almacenamiento no iniciados de la misma forma que
       MASM: donde un programador de MASM debera usar 'stack db 64 dup (?)',
       NASM requiere 'stack resb 64', entendiendo que se debe leer como
       'reserva 64 bits'. Por un poco de compatibilidad, puesto que NASM trata
       '?' como un carcter vlido en los nombres de los smbolos, puedes
       codificar '? equ 0', y entonces escribiendo 'dw ?' har al menos algo
       vagamente til. 'DUP', sin embargo, todava no est implementado en la
       sintaxis.

       Adicionalmente a todo esto, las macros y directivas funcionan
       completamente diferentes a MASM. Ver el captulo 4 y 5 para ms detalles.

Captulo 3: El lenguaje NASM
----------------------------

   3.1 Composicin de una lnea fuente de NASM

       Como muchos ensambladores, cada lnea de cdigo fuente NASM contiene
       (a menos que sea una macro, una directiva del preprocesador o una
       directiva del ensamblador: ver el captulo 4 y 5) algunas combinaciones
       de los cuatro campos

       etiqueta:   instruccin operandos     ; comentario

       Como es usual, la mayora de estos campos son opcionales; se permite
       la presencia o ausencia de cualquier combinacin de una etiqueta, una
       instruccin y un comentario. por supuesto, el campo del operando se
       requiere o se prohibe dependiendo de la presencia y naturaleza del
       campo de instruccin.

       NASM no pone ninguna restriccin de espacios en blancos en una lnea;
       las etiquetas pueden tener espacios en blanco antes de ellas, o las
       instrucciones pueden no tener espacios antes de ellas, o cualquier cosa.
       Los dos puntos despus de la etiqueta tambin son opcionales. (Ntese
       que esto quiere decir que si intentas codificar 'lodsb' slo en una
       lnea, y escribes 'lodab' por error, entonces esto ser una lnea del
       fuente vlida que no hace nada sino definir una etiqueta. Ejecutando NASM
       con la opcin en la lnea de comandos '-w+orphan-labels' har que se te
       avise cuando definas una etiqueta solitaria en una lnea que no est
       seguida de los dos puntos.)

       Los caracteres vlidos en las etiquetas son letras, nmeros, '_', '$',
       '#', '@', '~', '.', y '?'. Los nicos caracteres que deberan poderse
       usar como _primer_ carcter de un identificador son letras, '.' (con un
       significado especial: ver seccin 3.8), '_' y '?'. Un identificador
       podra tambin estar precedido por un '$' para indicar que se pretende
       que se lea como un identificador y no como una palabra reservada; por
       eso, si algn otro mdulo que ests enlazando define un smbolo llamado
       'eax', puedes referirte a '$eax' en el cdigo NASM para distinguir el
       smbolo del registro.

       El campo de instruccin puede contener cualquier instruccin mquina:
       instrucciones Pentium o P6, instrucciones FPU, instrucciones MMX e
       incluso instrucciones no documentadas. Las instrucciones deberan ir
       precedidas de la manera habitual por 'LOCK', 'REP, 'REPE'/'REPZ' o
       'REPNE'/'REPNZ'. Se permiten los prefijos explcitos de tamao de
       direccin y de tamao de operando, 'A16', 'A32', O16' y 'O32' - un
       ejemplo de su uso est en el captulo 9. Tambin puedes usar el nombre
       de un registro de segmento como prefijo de una instruccin: codificar
       'es mov [b],ax' equivale a codificar 'mov [es:b],ax'. Recomendamos la
       ltima sintaxis, ya que es consistente con otras caractersticas
       sintcticas del lenguaje, aunque con instrucciones como 'LODSB', que no
       tiene operandos y todava puede requerir una superposicin de segmentos,
       no hay un modo sintctico limpio de proceder aparte de 'es lodsb'.

       No se requiere una instruccin para usar un prefijo: prefijos como 'CS',
       'A32', 'LOCK' o 'REPE' pueden aparecer en una lnea ellos solos, y NASM
       simplemente generar los bytes prefijo.

       Adicionalmente a las actuales instrucciones mquina, NASM tambin soporta
       un nmero de pseudo-instrucciones, descritas en la seccin 3.2.

       Los operandos de instrucciones pueden tomar diversas formas: pueden ser
       registros, descritos simplemente por el nombre del registo (ej: 'ax',
       'bp', 'ebx', 'cr0': NASM no usa la sintaxis del estilo 'gas' en la cual
       los nombres de los registros han de estar precedidos por un smbolo '%'),
       o pueden ser direcciones efectivas (ver seccin 3.3), constantes (seccin
       3.4) o expresiones (seccin 3.5).

       Para las instrucciones de coma flotante, NASM acepta un amplio rango de
       sintaxis: puedes usar las formas de dos operandos como la que soporta
       MASM, o puedes usar la forma nativa del MASM de un solo operando en la
       mayora de los casos. Los detalles de todas las formas de cada una de las
       instrucciones soportadas est en el apndice A. Por ejemplo, puedes
       codificar:

                 fadd st1               ; establece st0 := st0 + st1
                 fadd st0,st1           ; tambin lo hace

                 fadd st1,st0           ; establece st1 := st1 + st0
                 fadd to st1            ; dem

       Casi cualquier instruccin de coma flotante que referencie a memoria debe
       usar uno de los siguientes prefijos 'DWORD', 'QWORD' o 'TWORD' para
       indicar el tamao del operando de memoria al que se refiere.

   3.2 Pseudo-instrucciones

       Las pseudo-instrucciones son cosas que, aunque no instrucciones mquina
       reales del x86, se usan en el campo de instruccin de cualquier modo
       porque es el lugar ms conveniente para ponerlas. Las actuales
       pseudo-instrucciones son 'DB', 'DW', 'DD', 'DQ' y 'DT', sus
       contrapartidas no inicializadas 'RESB', 'RESW', 'RESD', 'RESQ' y 'REST',
       el comando 'INCBIN', el comando 'EQU' y el prefijo 'TIMES'.

 3.2.1 'DB' y similares: Declarando datos inicializados

       'DB', 'DW', 'DD', 'DQ' y 'DT' son usados, al igual que in MASM, para
       declarar datos inicializados en el fichero de salida. Pueden invocarse
       de un amplio rango de maneras:

                 db 0x55                ; simplemente el byte 0x55
                 db 0x55,0x56,0x57      ; tres bytes sucesivos
                 db 'a',0x55            ; constantes carcter son correctas
                 db 'hello',13,10,'$'   ; tambin hay constantes cadena
                 dw 0x1234              ; 0x34 0x12
                 dw 'a'                 ; 0x41 0x00 (simplemente un nmero)
                 dw 'ab'                ; 0x41 0x42 (constante carcter)
                 dw 'abc'               ; 0x41 0x42 0x43 0x00 (cadena)
                 dd 0x12345678          ; 0x78 0x56 0x34 0x12
                 dd 1.234567e20         ; constante de coma flotante
                 dq 1.234567e20         ; coma flotante de doble precisin
                 dt 1.234567e20         ; coma flotante de precisin extendida

       'DQ' y 'DT' no aceptan como operandos constantes numricas o constantes
       cadena.

 3.2.2 'RESB' y similares: Declarando datos no inicializados

       'RESB', 'RESW', 'RESD', 'RESQ' y 'REST' estn diseados para ser usados
       en la seccin BSS de un mdulo: declaran espacio de almacenamiento
       _no inicializado_. Cada uno lleva un solo operando, que es el nmero de
       bytes, palabras, palabras dobles o lo que sea para reservar. Tal y como
       ha sido expuesto en la seccin 2.2.7, NASM no soporta la sintaxis de
       reservar espacio no inicializado del MASM/TASM usando 'DW ?'o cosas
       similares: esto es lo que hace en su lugar. El operando de un 'RESB'-tipo
       pseudo-instruccin es una _expresin crtica_: ver seccin 3.7.

       Por ejemplo:

       buffer:   resb 64                ; reserva 64 bytes
       wordvar:  resw 1                 ; reserva una palabra
       realarray resq 10                ; array de 10 reales

 3.2.3 'INCBIN': Incluyendo ficheros binarios externos

       'INCBIN' ha sido tomada prestada del antiguo ensamblador de Amiga DevPac:
       incluye un ficheros binario palabra por palabra dentro del fichero de
       salida. Esto puede ser prctico para (por ejemplo) incluir grficos y
       sonido directamente en un fichero ejecutable de un juego. Puede llamarse
       de una de estas tres maneras:

                 incbin "file.dat"      ; incluye todo el fichero
                 incbin "file.dat",1024 ; se salta los primeros 1024 bytes
                 incbin "file.dat",1024,512 ; salta los primeros 1024, e
                                        ; incluye como mximo 512

 3.2.4 'EQU': Definiendo constantes

       'EQU' define un smbolo para un valor determinado de constante: cuando se
       usa 'EQU', la lnea de cdigo fuente debe contener una etiqueta. La
       accin de 'EQU' es para definir el nombre de la etiqueta dada para el
       valor de su (nico) operando. Esta definicin es absoluta, y no puede
       cambiar despus. Por eso, por ejemplo,

       message   db 'hello, world'
       msglen    equ $-message

       define 'msglen' para ser la constante 12. 'msglen' no podra ser definido
       despus. Esto no es una definicin del preprocesador: el valor de
       'msglen' se evala _una sola_ vez, usando el valor de '$' (ver seccin
       3.5 para una explicacin de '$') en el momento de la definicin, en lugar
       de ser evaluado si es referenciado y usando el valor de '$' en el punto
       de la referencia. Ntese que el operando de un 'EQU' es tambin una
       expresin crtica (seccin 3.7).

 3.2.5 'TIMES': Repitiendo instrucciones o datos

       El prefijo 'TIMES' hace que la instruccin se ensamble mltiples veces.
       Esto est presente parcialmente como el equivalente 'DUP' de la sintaxis
       MASM soportada por los ensambladores compatibles con el MASM, en los que
       puedes codificar

       zerobuf:  times 64 db 0

       o cosas similares: pero 'TIMES' es ms verstil que esto. El argumento
       de 'TIMES' no es simplemente una constante numrica, sino una _expresin_
       numrica, por eso puedes hacer cosas como sta

       buffer:   db 'hello ,world'
                 times 64-$+buffer db ' '

       que almacenar exactamente los espacios necesarios para hacer el total
       de la longitud de 'buffer' hasta 64. Finalmente, 'TIMES' puede aplicarse
       a un instruccin normal, por eso puede codificar loops desenrollados
       triviales en ella:

                 times 100 movsb

       Dse cuenta que no hay diferencias efectivas entre 'times 100 resb 1' y
       'resb 100', excepto que ste ltimo ser ensamblado unas 100 veces ms
       rpido debido a la estructura interna del ensamblador.

       El operando de 'TIMES', al igual que el de 'EQU' y aquellos de 'RESB' y
       similares, es una expresin crtica (seccin 3.7).

       Ntese tambin que 'TIMES' no puede aplicarse a macros: la razn para
       esto es que 'TIMES' se procesa despus de la fase de macros, que permite
       el argumento de 'TIMES' el contener una expresin como '64-$+buffer'
       como arriba. Para repetir de una lnea de cdigo, o una macro compleja,
       usa la directiva del preprocesador '%rep'.

   3.3 Direcciones efectivas

       Una direccin efectiva es cualquier operando de una instruccin que
       referencie a memoria. Las direcciones efectivas, en NASM, tienen una
       sintaxis simple: consisten en una evaluacin de expresin en la direccin
       deseada, encerrada entre corchetes. Por ejemplo:

       wordvar   dw 123
                 mov ax,[wordvar]
                 mov ax,[wordvar+1]
                 mov ax,[es:wordvar+bx]

       Cualquier cosa que no vaya conforme este ejemplo no es una referencia a
       memoria vlida en NASM, por ejemplo 'es:wordvar[bx]'.

       Direcciones efectivas ms complicadas, como aquellas que involucran ms
       de un registro, funcionan exactamente de la misma manera:

                 mov eax,[ebx*2+ecx+offset]
                 mov ax,[bp+di+8]

       NASM es capaz de operar algebraicamente con estas direcciones efectivas,
       por eso, estas cosas que no necesariamente _parecen_ legales son
       perfectamente correctas:

                 mov eax,[ebx*5]        ; ensambla como [ebx*4+ebx]
                 mov eax,[label1*2-label2] ; esto es [label1+(label1-label2)]

       Algunas formas de direcciones efectivas tienen ms de una forma
       ensamblada; en la mayora de los casos NASM generar la forma ms pequea
       que pueda. Por ejemplo, hay distintas formas ensambladas para la
       direccin efectiva de 32-bit '[eax*2+0]' y '[eax+eax]', y NASM generar
       generalmente la ltima, por la razn por que el offset 0 requiere cuatro
       bytes de almacenamiento.

       NASM tiene un mecanismo de ayuda que har que '[eax+ebx]' y '[ebx+eax]'
       generen diferentes cdigos de operacin; ocasionalmente esto es til
       porque '[esi+epb]' y '[ebp+esi]' tienen por defecto diferentes registros
       de segmento.

       Sin embargo, puedes forzar a NASM a que genere una direccin efectiva de
       una manera particular usando las palabras clave 'BYTE', 'WORD', 'DWORD' y
       'NOSPLIT'. Si necesitas que '[eax+3]' se ensamble usando un campo de
       offset de palabra doble en lugar de la de un byte que normalmente NASM
       generar, puedes codificar '[dword eax+3]'. Similarmente, puedes forzar
       a NASM a usar un offset de un byte para un valor pequeo que no ha sido
       visto en la primera pasada (ver seccin 3.7 para un ejemplo de un
       fragmento de cdigo) usando '[byte eax+offset]'. Como casos especiales,
       '[byte eax]' codificar '[eax+0]' con un offset cero de un byte , y
       '[dword eax]' lo codificar con un offset cero de palabra doble. La forma
       normal, '[eax]', ser codificada sin campo de offset.

       De forma similar, NASM partir '[eax+2]' en '[eax+eax]' porque esto
       permite omitir el campo de offset y salvar espacio; de hecho, tambin
       partir '[eax*2+offset]' en '[eax+eax+offset]'. Puedes combatir este
       comportamiento usando la palabra clave 'NOSPLIT':
       '[nosplit eax*2]' forzar que se genere literalmente '[eax*2+0]'

   3.4 Constantes

       NASM entiende cuatro tipos diferentes de constante: numricas, carcter,
       cadena y coma flotante.

 3.4.1 Constantes numricas

       Una constante numrica es simplemente un nmero. NASM te permite
       especificar nmeros en diferentes bases, de diversas maneras: puedes
       usar un sufijo 'H', 'Q' y 'B' para hexadecimal, octal y binario, o puedes
       usar un prefijo '0x' para hexadecimal al estilo del C, o poner el prefijo
       '$' para hexadecimal al estilo del Borland Pascal. Ntese, sin embargo,
       que el prefijo '$' hace una doble tarea como prefijo de identificadores
       (ver seccin 3.1), por eso un nmero hexadecimal precedido por un signo
       '$' debe tener un dgito despus del '$' en lugar de una letra.

       Algunos ejemplos:

                 mov ax,100             ; decimal
                 mov ax,0a2h            ; hex
                 mov ax,$0a2            ; hex de nuevo: el 0 es necesario
                 mov ax,0xa2            ; hex nuevamente
                 mov ax,777q            ; octal
                 mov ax,10010011b       ; binario

 3.4.2 Constantes carcter

       Una constante carcter consiste en hasta cuatro caracteres encerrados
       entre comillas simples o dobles. NASM no hace distincin entre el tipo de
       comilla, excepto, por supuesto, que encerrando la constante con comillas
       simples permite que aparezcan comillas dobles dentro y viceversa.

       Una constante carcter con ms de un carcter ser ordenada con el orden
       little-endian en mente: si codificas

                 mov eax,'abcd'

       entonces la constante generada no es '0x61626364', sino '0x64636261',
       por eso si vas a almacenar el valor en memoria, leer 'abcd' en lugar
       de 'dcba'. Este es tambin el sentido de la comprensin de las constantes
       carcter de la instruccin 'CPUID' de los Pentium (ver seccin A.22).

 3.4.3 Constantes cadena

       Las constantes cadena slo son aceptables en algunas
       pseudo-instrucciones, a saber, la familia 'DB' e 'INCBIN'.

       Una constante cadena se parece a una constante carcter, slo que ms
       larga. Es tratada en las mismas condiciones que una concatenacin de
       constantes carcter del mximo tamao. Por eso, lo siguiente es
       equivalente:

                 db 'hello'             ; constante cadena
                 db 'h','e','l','l','o' ; el equivalente en constantes carcter

       Y lo siguiente tambin es equivalente:

                 dd 'ninechars'         ; constante cadena de palabra doble
                 dd 'nine','char','s'   ; se convierte en tres palabras dobles
                 db 'ninechars',0,0,0   ; y realmente parece esto

       Dse cuenta que cuando se usa como un operando de 'db', una constante
       como ''ab'' es tratada como una constante cadena a pesar de ser lo
       suficientemente pequea como para ser una constante carcter, porque de
       otro modo, 'db 'ab'' tendra el mismo efecto que 'db 'a'', lo que sera
       estpido. De igual forma, constantes de tres o cuatro caracteres
       se tratan como cadenas cuando son operandos de 'dw'.

 3.4.4 Constantes de coma flotante

       Las constantes de coma flotante slo son aceptables como argumentos de
       'DD', 'DQ' y 'DT'. Estas son expresadas de la forma tradicional: dgitos,
       luego el perodo, y opcionalmente ms dgitos, luego opcionalmente una
       'E' seguida de un exponente. El perodo es obligatorio, por lo que NASM
       puede distinguir entre 'dd 1', que declara una constante entera, y
       'dd 1.0' que declara una constante de coma flotante.

       Algunos ejemplos:

                 dd 1.2                 ; una fcil
                 dq 1.e10               ; 10,000,000,000
                 dq 1.e+10              ; igual a 1.e10
                 dq 1.e-10              ; 0.000 000 000 1
                 dt 3.141592653589793238462 ; pi

       NASM, en tiempo de compilacin, no puede hacer aritmtica sobre
       constantes de coma flotante. Esto es debido a que NASM est diseado para
       ser portable - aunque siempre genera cdigo que funciona bajo
       procesadores x86, el ensamblador en s mismo puede ejecutarse en
       cualquier sistema con un compilador ANSI C. Por lo tanto, el ensamblador
       no te puede garantizar la presencia de una unidad de coma flotante que
       sea capaz de manejar el formato de Intel de los nmeros, y por eso NASM
       para poder hacer aritmtica con coma flotante tendra que incluir su
       propio conjunto de rutinas de coma flotante, lo que incrementara
       significativamente el tamao del ensamblador para tan poco beneficio.

   3.5 Expresiones

       Las expresiones en NASM son similares en sintaxis a las de C.

       NASM no garantiza el tamao de los enteros usados para evaluar
       expresiones en tiempo de compilacin: ya que NASM puede compilar y
       ejecutarse en sistemas de 64-bit bastante bien, no asume que las
       expresiones son evaluadas en registros de 32-bit, por eso hace un uso
       deliberado del desbordamiento de entero. Esto podra no funcionar
       siempre. Lo nico que NASM garantiza es lo que garantiza el ANSI C:
       siempre tienes para trabajar _al menos_ 32-bit.

       NASM implementa en las expresiones dos marcas especiales, permitiendo
       clculos que involucran a la actual posicin del ensamblador: el '$' y
       el '$$'. '$' evala la actual posicin del ensamblador al comienzo de la
       lnea que contiene la expresin; por eso puedes codificar un bucle
       infinito usando 'JMP $'. '$$' evala al comienzo de la actual seccin;
       por eso puedes indicar hasta dnde dentro de la seccin en la que ests,
       usando '($-$$)'.

       Los operadores aritmticos proporcionados por NASM son listados aqu,
       en orden creciente de precedencia.

 3.5.1 '|': Operador OR a nivel de bit

       El operador '|' proporciona un OR a nivel de bit, exactamente tal y como
       lo hace la instruccin 'OR' de la mquina. El OR de bit es el de menor
       prioridad de entre los operadores aritmticos soportados por NASM.

 3.5.2 '^': Operador XOR a nivel de bit

       '^' proporciona la operacin XOR entre bits.

 3.5.3 '&': Operador AND a nivel de bit

       '&' proporciona la operacin AND entre bits.

 3.5.4 '<<' y '>>': Operadores de desplazamiento a nivel de bit

       '<<' hace un desplazamiento de bits hacia la izquierda, al igual que en
       C. Por eso, '5<<3' evala 5 por 8,esto es 40. '>>' hace un desplazamiento
       de bits hacia la derecha; en NASM, como un desplazamiento es _siempre_
       sin signo, entonces los bits desplazados desde la parte izquierda sern
       rellenados con ceros en lugar de con una extensin de signo del bit
       superior.

 3.5.5 '+' y '-': Operadores de adicin y sustraccin

       Los operadores '+' y '-' hacen perfectamente la suma y resta ordinarias.

 3.5.6 '*', '/', '//', '%' y '%%': Multiplicacin y divisin

       '*' es el operador de multiplicacin. '/' y '//' son ambos operadores de
       divisin: '/' es divisin sin signo y '//' es divisin con signo.
       Igualmente, '%' y '%%' son los operadores de mdulo sin signo y con signo
       respectivamente.

       NASM, al igual que en ANSI C, no garantiza nada en la operacin lgica
       del operador mdulo con signo.

       Puesto que el caracter '%' se usa mucho por el preprocesador de macros,
       deberas asegurarte que tanto el operador de mdulo con signo y sin signo
       van seguidos de un espacio en blanco siempre que aparezcan.

 3.5.7 Operadores unitarios: '+', '-', '~' y 'SEG'

       Los operadores de mayor prioridad en la gramtica de las expresiones de
       NASM son aquellos que slo se aplican a un argumento. '-' niega su
       operando, '+' no hace nada (se provee por simetra con '-'), '~' calcula
       el complemento a uno de su operando, y 'SEG' proporciona la direccin del
       segmento de su operando (explicado con ms detalle en la seccin 3.6).

   3.6 'SEG' y 'WRT'

       Cuando se escriben programas largos de 16-bit, casi siempre han de
       partirse en mltiples segmentos, a menudo es necesario poder referirse a
       la parte del segmento de la direccin de un smbolo. NASM proporciona
       el operador 'SEG' para hacer esta funcin.

       El operador 'SEG' devuelve el segmento base _preferente_ de un
       smbolo, definido como la base del segmento relativa a la cual tiene
       sentido el offset del smbolo. Por eso el cdigo

                 mov ax,seg symbol
                 mov es.ax
                 mov bx,symbol

       cargar 'ES:BX' con un puntero vlido al smbolo 'symbol'.

       Las cosas pueden ser ms complejas que esto: ya que los segmentos y los
       grupos se pueden superponer, ocasionalmente podras querer referirte a
       un smbolo usando un segmento base desde el preferente. NASM te permite
       hacerlo, usando la palabra clave 'WRT' (With Reference To). Por eso
       puedes hacer cosas como sta

                 mov ax,weird_seg       ;weird_seg es el segmento base
                 mov es,ax
                 mov bx,symbol wrt weird_seg

       para cargar 'ES:BX' con un puntero diferente al smbolo 'symbol', pero
       equivalente funcionalmente.

       NASM soporta llamadas y saltos lejanos (entre segmentos) mediante la
       sintaxis 'call segment:offset', donde 'segment' y 'offset' representan
       valores inmediatos. Por eso, para llamar a un procedimiento lejano,
       deberas codificar alguna de stas

                 call (seg procedure):procedure
                 call weird_seg:(procedure wrt weird_seg)

       (Los parntesis se incluyen simplemente para clarificar, para mostrar
       la interpretacin intencionada de las instrucciones arriba mencionadas.
       En la prctica no son necesarios.)

       NASM soporta la sintaxis 'call far procedure' como sinnimo para la
       primera de las arriba usadas 'JMP' trabaja de forma idntica a 'CALL' en
       estos ejemplos.

       Para declarar un puntero lejano a un dato en un segmento de datos, debes
       codificar

                 dw symbol, seg symbol

       NASM no soporta ningn sinnimos conveniente para esto, sin embargo
       siempre puedes inventarte uno usando el procesador de macros.

   3.7 Expresiones crticas

       Una limitacin de NASM es que es un ensamblador de dos pasadas; al
       contrario que TASM y dems, siempre har exactamente dos pasadas de
       ensamblaje. Por lo tanto, es incapaz de hacer frente con ficheros fuente
       con la suficiente complejidad que requieran tres o ms pasadas.

       La primera pasada se usa para determinar el tamao de todo el cdigo y
       datos, por eso la segunda pasada, cuando se generar todo el cdigo,
       conoce todas las direcciones de los smbolos a los que se refiere el
       cdigo. Por eso, una cosa que NASM no puede manejar es el cdigo cuyo
       tamao dependa del valor de un smbolo declarado despus del cdigo en
       cuestin. Por ejemplo,

                 time (label-$) db 0
       label:    db 'Where am I?'

       El argumento de 'TIMES' en este caso podra no evaluar nada de forma
       igualmente legal; NASM rechazar este ejemplo porque no te puede decir
       el tamao de la lnea 'TIMES' cuando la ve por primera vez. Rechazar
       firmemente el siguiente cdigo ligeramente paradjico

                 times (label-$+1) db 0
       label:    db 'NOW where am I?'

       en la cual _cualquier_ valor como argumento de 'TIMES' ser errneo por
       definicin.

       NASM rechaza estos ejemplos mediante un concepto llamado _expresin
       crtica_, que se define como una expresin cuyos valores se requieren
       en una primera pasada para poder computarse, y que por lo tanto deben
       depender slo de smbolos definidos antes. El argumento del prefijo
       'TIMES' es una expresin crtica; por la misma razn, los argumentos de
       la familia de pseudo-instrucciones 'RESB' son tambin expresiones
       crticas.

       Las expresiones crticas pueden presentarse en otros contextos como:
       considere el siguiente cdigo.

                 mov a,symbol1
       symbol1   equ symbol2
       symbol2:

       En la primera pasada, NASM no puede determinar el valor de 'symbol1',
       porque 'symbol1' se le define para que sea igual a 'symbol2' que NASM
       todava no ha visto. En la segunda pasada, por lo tanto, cuando se
       encuentre la lnea 'mov ax,symbol1', es incapaz de generar el cdigo para
       ella porque todava no sabe el valor de 'symbol1'. En la siguiente lnea,
       podra ver el 'EQU' otra vez y ser capaz de determinar el valor de
       'symbol1', pero para entonces ser demasiado tarde.

       NASM evita este problema definiendo la parte derecha de una sentencia
       'EQU' como expresin crtica, por eso la definicin de 'symbol1' ser
       rechazada en la primera pasada.

       Hay un asunto relacionado que involucra las siguiente referencias:
       considere el siguiente fragmento de cdigo.

                 mov eax,[eb+offset]
       offset    equ 10

       NASM, en la primera pasada, debe calcular el tamao de la instruccin
       'mov eax,[ebx+offset]' sin saber el valor del 'offset'. No tiene forma
       de saber qu 'offset' es lo suficientemente pequeo para caber en un
       campo offset de un byte y que podra por lo tanto continuar generando
       una forma ms corta de la codificacin de la direccin efectiva; por lo
       que sabe, en la primera pasada, 'offset' podra ser un smbolo en el
       segmento de cdigo, y podra necesitar la forma completa de los cuatro
       bytes. Por eso est forzado a calcular el tamao de la instruccin para
       acomodar una parte de direccin de cuatro bytes. En la segunda pasada,
       habiendo hecho esta decisin, est forzada a respetarla y mantiene la
       instruccin grande, por eso el cdigo generado en este caso no es tan
       pequeo como podra haber sido. Este problema puede resolverse
       definiendo 'offset' antes de usarlo, o forzando un tamao de byte en la
       direccin efectiva codificando '[byte ebx+offset]'.

   3.8 Etiquetas locales

       NASM da un trato especial a los smbolos que empiezan por un punto. Una
       etiqueta que comience con un simple punto se trata como una etiqueta
       _local_, lo que quiere decir que est asociada a la etiqueta no local
       previa. Por eso, por ejemplo:

       label1    ; algo de cdigo
       .loop     ; algo de cdigo ms
                 jne .loop
                 ret
       label2    ; algo de cdigo
       .loop     ; algo de cdigo ms
                 jne .loop
                 ret

       En este fragmento de cdigo, cada intruccin 'JNE' salta a la lnea
       inmediatamente superior, porque las dos definiciones de '.loop' son
       mantenidas de forma separada en virtud de que cada una est asociada a
       la etiqueta no local previa.

       Esta forma de manejar las etiquetas locales ha sido tomada prestada del
       viejo ensamblador de Amiga, DevPac; sin embargo, NASM va un paso ms
       all, permitiendo acceder a las etiquetas locales desde otras partes de
       cdigo. Esto se ha logrado mediante la _definicin_ de una etiqueta
       local en trminos de la etiqueta no local previa: la primera definicin
       de '.loop' vista anteriormente est realmente definiendo un smbolo
       llamado 'label1.loop', y la segunda define un smbolo llamado
       'label2.loop'. Por eso, si realmente lo necesitas, podras escribir

       label3    ; algo de cdigo ms
                 ; y un poco ms
                 jmp label1.loop

       Algunas veces es til - en una macro, por ejemplo - el poder definir una
       etiqueta que pueda ser referenciada desde cualquier lugar pero que no
       interfiera con el mecanismo normal de etiquetas locales. Tal y como, una
       etiqueta no puede ser no local porque intereferira con definiciones
       subsecuentes de, y referencias a, etiquetas locales; y no puede ser local
       porque la macro que la define no sabra el nombre completo de la
       etiqueta. NASM, por lo tanto, introduce un tercer tipo de etiqueta, que
       es til posiblemente slo en las definiciones de macros: si una etiqueta
       comienza con el prefijo especial '..@', entonces no hace nada al
       mecanismo de la etiqueta local. Por eso podras codificar

       label1:   ; una etiqueta no local
       .local:   ; esto es realmente label1.local
       ..@foo:   ; esto es un smbolo especial
       label2:   ; otra etiqueta no local
       .local:   ; esto es realmente label2.local
                 jmp ..@foo             ; esto saltar tres lneas hacia arriba

       NASM tiene la capacidad de definir otros smbolos especiales empezando
       con un punto doble: por ejemplo, '..start' es usado para especificar el
       punto de entrada en el formato 'obj' de salida (ver seccin 6.2.6).

Captulo 4: El preprocesador NASM
---------------------------------

       NASM contiene un poderoso procesador de macros, que soporta ensamblaje
       condicional, inclusin multi-nivel de ficheros, dos formatos de macros
       (simple y multi-nivel), y un mecanismo de pila de contexto para una
       potencia extra de macros. Las directivas del preprocesador comienzan
       todas por el signo '%'.

   4.1 Macros de una lnea

 4.1.1 La forma normal: '%define'

       Las macros de una simple lnea son definidas usando la directiva del
       preprocesdor '%define'. Las definiciones trabajan de un modo similar
       a como lo hace C; por eso puedes hacer cosas como

       %define ctrl 0x1F &
       %define param(a,b) ((a)+(a)*(b))
                 mov byte [param(2,exb)], ctrl 'D'

       que se expandir a

                 mov byte [(2)+(2)*(eb)], 01F & 'D'

       Cuando la expansin de una macro de una slo lnea contiene seales que
       invoquen otras macros, la expansin se realiza en tiempo de invocacin,
       no en el momento de la definicin. As, el cdigo

       %define a(x) 1+b(x)
       %define b(x) 2*x
                 mov ax,a(8)

       evaluar de la forma esperada 'mov ax,1+2*8', incluso aunque la macro
       'b' no estuviese definida en el momento de la definicin de 'a'.

       Las macros definidas con '%define' son sensibles a maysculas: despus de
       '%define foo bar', slo 'foo' se epandir a 'bar': 'Foo' o 'FOO' no lo
       harn. Usando '%idefine' en lugar de '%define' (la 'i' se pone por
       'insensitive') puedes definir de una vez todas las variaciones de
       maysculas y minsculas de una macro, por eso '%idefine foo bar' hara
       que 'foo', Foo', 'FOO', 'fOO' se expandan a 'bar'.

       Hay un mecanismo que detecta cuando ha ocurrido una llamada de macro
       como resultado de una epansin previa de la misma macro, para salvarse
       de referencias circulares y bucles infinitos. Si esto pasa, el
       preprocesador expandir slo la primera ocurrencia de una macro. Por lo
       tanto, si codificas

       %define a(x) 1+a(x)
                 mov ax,a(3)

       la macro 'a(3)' se expandir una vez, siendo '1+a(3)', y no se expandir
       ms. Este comportamiento puede ser til: ver seccin 8.1 para ver un
       ejemplo de su uso.

       Puedes sobrecargar macros de una slo lnea: si escribes

       %define foo(x) 1+x
       %define foo(x,y) 1+x*y

       el preprocesador ser capz de manejar ambos tipos de llamadas de macro,
       contando los parmetros que pases; por eso 'foo(3)' ser '1+3' mientras
       que 'foo(ebx,2)' ser '1+ebx*2'. Sin embargo, si defines

       %define foo bar

       no se aceptar ninguna otra definicin de 'foo': una macro sin parmetros
       prohibe la definicin de una macro con el mismo nombre _con_ parmetros,
       y viceversa.

       Puedes predefinir macros de una lnea usando la opcin '-d' en la lnea
       de comandos de NASM: ver seccin 2.1.7.

 4.1.2 Variables del preprocesador: '%assign'

       Una forma alternativa de definir macros simples es mediante el comando
       '%assign' (y su contrapartida insensible a maysculas '%iassign', que
       difiere de '%assign' de la misma manera que difiere '%idefine' de
       '%define').

       '%assign' se usa para definir macros de una sla lnea que no tomen
       parmetros y tengan un valor numrico. Este valor puede especificarse en
       la forma de una expresin, y ser evaluado una vez, cuando sea procesada
       la directiva '%assign'.

       '%assign' es til para controlar el final de lo bucles '%rep' del
       preprocesador: ver seccin 4.4 para ver un ejemplo de esto. Otro uso de
       '%assign' se da en las secciones 7.4 y 8.1.

       La expresin pasada a '%assign' es una expresin crtica (ver seccin
       3.7), y debe evaluar un nmero puro (en lugar de una referencia
       relocalizable como podra ser una direccin de cdigo o segmento, o
       cualquier cosa que involucre a un registro).

   4.2 Macros multi-nivel: '%macro'

       Las macros multi-nivel son mucho ms parecidas a las macros vistas en
       MASM y TASM: una definicin de una macro multi-nivel en NASM se parece
       a algo similar a esto.

       %macro prologue 1
                 push ebp
                 mov ebp,esp
                 sub esp,%1
       %endmacro

       esto define, de forma parecida al C, una funcin 'prologue' como una
       macro: por eso podras invocar la macro con una llamada como sta

       myfunc:   prologue 12

       que se expandir a las tres lneas de cdigo

       myfunc:   push ebp
                 mov ebp,esp
                 sub esp,12

       El nmero '1' despus del nombre de la macro en la lnea '%macro' define
       el nmero de parmetros que la macro 'prologue' espera recibir. El uso
       de '%1' dentro de la definicin de la macro se refiere al primer
       parmetro de la llamada a la macro. Con una macro que tome ms de un
       parmetro, los subsiguientes parmetros seran referidos como '%2', '%3',
       y as.

       Las macros multi-lnea, al igual que las macros de una slo lnea, son
       sensibles a maysculas, a menos que las definas usando la directiva
       alternativa '%imacro'.

       Si necesitas pasar una coma como _parte_ de un parmetro en una macro
       multi-nivel, puedes hacerlo encerrndo el parmetro entero entre llaves.
       Por eso, podras codificar cosas como

       %macro silly 2
       %2:       db %1
       %endmacro
                 silly 'a', letter_a    ; letter_a:  db 'a'
                 silly 'ab', string_ab  ; string_ab: db 'ab'
                 silly {13,10}, crlf    ; crlf:      db 13,10

 4.2.1 Sobrecargando macros multi-lnea

       Al igual que con las macros de una slo lnea, las macros multi-lnea
       puedes sobrecargarse definiendo el mismo nombre de macro varias veces
       con diferente nmero de parmetros. Esta vez, no hay excepciones en las
       macros que no tienen parmetros. Por eso puedes definir

       %macro prologue 0
                 push ebp
                 mov ebp,esp
       %endmacro

       para definir una forma alternativa de la funcin 'prologue' que no
       coloca espacio de pila.

       Algunas veces, sin embargo, podras querer sobrecargar una instruccin
       mquina; por ejemplo, podras querer definir

       %macro push 2
                 push %1
                 push %2
       %endmacro

       por eso podras codificar

                 push ebx               ; esta lnea no es una llamada de macro
                 push eax,ecx           ; pero sta s

       Generalmente, NASM dar un aviso para la primera de las dos lneas, ya
       que 'push' est ahora definida como una macro, y est siendo invocada
       con un nmero de parmetros para los cuales no se ha dado definicin.
       El cdigo correcto todava ser generado, pero el ensamblador dar un
       aviso. Este aviso puede desactivarse usando la opcin de la lnea de
       comando '-w-macro-params' (ver seccin 2.1.10).

 4.2.2 Etiquetas locales de macros

       NASM te permite definir etiquetas dentro de la definicin de una macro
       multi-lnea de modo que la hacemos local a la llamada de la macro: por
       eso llamar a la misma macro mltiples veces usar una etiqueta diferente
       cada vez. Puedes hacer esto usando el prefijo '%%' en el nombre de la
       macro. Por eso, puedes inventar una instruccin que ejecute una 'RET'
       si el flag 'Z' se activa, haciendo esto:

       %macro retz 0
                 jnz %%skip
                 ret
       %skip:
       %endmacro

       Puedes llamar a esta macro tantas veces como quieras, y cada vez que la
       llames NASM crear un nombre 'real' diferente para sustituir la etiqueta
       '%%skip'. Los nombre que NASM inventa son de los forma '..@2354.skip',
       donde el nmero 2345 cambia con cada llamada de macro. El prefijo '..@'
       previene a las etiquetas locales de macros de interferir con el mecanismo
       de etiquetas locales, tal y como ha sido descrito en la seccin 3.8.
       Deberas evitar definir tus propias etiquetas de esta forma (el prefijo
       '..@'. luego un nmero, luego otro punto) en el caso que interfieran con
       las etiquetas locales de la macro.

 4.2.3 Parmetros de macros avariciosas

       A veces, es til definir una macro que amontone toda su lnea de comandos
       en un definicin de parmetro, posiblemente despus de extraer uno o dos
       parmetros pequeos de delante. Un ejemplo podra ser una macro que
       escriba una cadena de texto a un fichero en MS-DOS, donde podras querer
       ser capaz de escribir

                 writefile [filehandle],"hello, world",13,10

       NASM te permite definir el ltimo parmetro de una macro para que sea
       _avariciosa_, lo que quiere decir que invocas la macro con ms parmetros
       de los que espera, todos los parmetros sobrantes son amontonados en el
       ltimo definido junto con las comas de separacin. Por eso, si codificas:

       %macro writefile 2+
                 jmp %%endstr
       %%str:    db %2
       %%endstr: mov dx,%%str
                 mov cx,%%endstr-%%str
                 mov bx,%1
                 mov ah,0x40
                 int 0x21
       %endmacro

       entonces la llamada de ejemplo al 'writefile' de arriba trabajar como
       se espera: el texto antes de la primera coma, '[filehandle], se usa como
       primer parmetro de la macro y se expando cuando haya una referencia a
       '%1', y todo el texto subsiguiente se amontona en '%2' y es colocado
       despus de 'db'.

       La naturaleza avariciosa de la macro se indica a NASM usando el signo
       '+' despus de la cuenta de parmetros en la lnea '%macro'.

       Si defines una macro avariciosa, efectivamente le ests diciendo a NASM
       cmo deberas expandir la macro dndola _cualquier_ nmero de parmetros
       desde el nmero actual especificado hasta el infinito; en este caso, por
       ejemplo, NASM ahora sabe qu hacer cuando vea una llamada a 'writefile'
       con 2, 3, 4  ms parmetros. NASM tendr esto en cuenta cuando haya
       sobrecarga de macros, y no te permitir definir otra forma de 'writefile'
       tomando 4 parmetros (por ejemplo).

       Por supuesto, la macro arriba mencionada podra haber sido implementada
       como una macro no avariciosa, en cuyo caso la llamada tendra que ser
       algo as como

                 writefile [filehandle], {"hello, world",13,10}

       NASM proporciona ambos mecanismos para poner comas en los parmetros de
       las macros, y tu eliges cul prefieres para cada definicin de macros.

       Ver las seccin 5.2.1 para ver un mejor modo de escribir la macro de
       arriba.

 4.2.4 Parmetros por defecto de las macros

       NASM tambin te permite definir una macro multi-lnea con un _rango_ de
       parmetros permitidos. Si haces esto, puedes especificar los valores por
       defecto de los parmetros omitidos. Por eso, por ejemplo,

       %macro die 0-1 "Painful program death has ocurred."
                 writefile 2,%1
                 mov ax,0x4c01
                 int 0x21
       %endmacro

       Esta macro (que hace uso de la macro 'writefile' definida en la seccin
       4.2.3) puede ser llamada con un mensaje de error explcito, que mostrar
       en la salida de errores antes de salir, o puede llamarse sin parmetros,
       en cuyo caso usar el mensaje de error proporcionada en la definicin de
       la macro.

       En general, t facilitas un mnimo y un mximo nmero de parmetros para
       una macro de este tipo; en la llamada de la macro se requiere el mnimo
       nmero de parmetros, y entonces proporcionas los valores por defecto de
       los opcionales. Por eso, si una definicin de macro comienza con la lnea

       %macro foobar 1-3 eax,[ebx+2]

       entoces podra ser llamada con entre uno y tres parmetros, y '%1'
       siempre ser tomada de la llamada de la macro. '%2', si no est
       especificado en la llamada a la macro, se usar por defecto 'eax', y si
       '%3' tampoco est especificado usara por defecto '[ebx+2]'.

       Podra omitir los parmetros por defecto desde la definicin de la macro,
       en cuyo caso, los parmetros por defecto se considerarn en blanco. Esto
       puede ser til para las macros que puedan recibir un nmero variable de
       parmetros, ya que '%0' (ver seccin 4.2.5) te permite determinar cuntos
       parmetros han sido realmente pasados a la llamada de la macro.

       Este mecanismo de valores por defecto puede combinarse con el mecanismo
       de avaricia de parmetros; por eso, la macro 'die' de arriba podra
       hacerse ms potente, y ms til, cambiando la primera lnea de la
       definicin a

       %macro die 0-1+ "Painful program death has ocurred.",13,10

       El mximo nmero de parmetros puede ser infinito, denotado con '*'. En
       este caso, por supuesto, es imposible proporcionar un conjunto _completo_
       de parmetros por defecto. Ejemplos de este uso se muestran en la seccin
       4.2.6

 4.2.5 '%0': Contador de parmetros de macro

       Para una macro que pueda recibir un nmero variable de parmetros, la
       referencia de parmetro '%0' devolver una constante numrica dando el
       nmero de parmetros pasados a la macro. Esto puede usarse como un
       argumento para '%rep' (ver seccin 4.4) en vistas a iterar a travs de
       todos los parmetros de una macro. Se dan ejemplos en la seccin 4.2.6.

 4.2.6 '%rotate': Rotando los parmetros de macro

       Los programadores de shells de Unix estarn familiarizados con el comando
       'shift' del shell, que permite mover un lugar a la izquierda los
       argumentos pasados a un shell script (referenciados como '$1', '$2' etc.),
       por eso el argumento previamente referenciado como '$2' pasa a estar
       disponible como '$1', y el argumento que previamente estaba referenciado
       como '$1' ya no est disponible en absoluto.

       NASM proporciona un mecanismo similar, en forma de '%rotate'. Tal y como
       su nombre sugiere, difiere del 'shift' de Unix en que no se pierden los
       parmetros: los parmetros rotados fuera del lado izquierdo de la lista
       de argumentos reaparecen en la derecha, y viceversa.

       '%rotate' se invoca con un argumento numrico simple (que podra ser una
       expresin). Los parmetros de macro son rotados a la izquierda tantos
       lugares como indique este valor. Si el argumento de '%rotate' es
       negativo, los parmetros de la macro son rotados a la derecha.

       Por eso un par de macro para salvar y restaurar un conjunto de registros
       podra trabajar como sigue:

       %macro multipush 1-*
       %rep %0
                 push %1
       %rotate 1
       %endrep
       %endmacro

       Esta macro invoca la instruccin 'PUSH' en cada de uno de sus argumentos
       por turno, desde la derecha a la izquierda. Comienza empujando su primer
       argumento, '%1', luego invoca '%rotate' para mover todos los argumentos
       un lugar a la izquierda, por eso, el segundo argumento original ahora
       est disponible como '%1'. Repitiendo este proceso tantas veces como
       argumentos haya (que se consigue suministrando '%0' como argumento de
       '%rep') se consigue que cada argumento sea empujado por turno.

       Dse cuenta tambin del uso de '*' como mximo nmero de parmetros,
       indicando que no hay lmite superior en el nmero de parmetros que
       puedes proporcionar en la macro 'multipush'.

       Sera conveniente, cuando se usa esta macro, el tener un 'POP'
       equivalente, que _no_ requiera que los argumentos se den en orden
       inverso. Idealmente, podra escribir una llamada a un 'multipush', luego
       cotar y pegar la lnea all donde se necesite que se haga un pop, y
       cambiar el nombre de la macro a 'multipop', y luego la macro se
       encargara de sacar los registros en el orden opuesto al que han sido
       empujados.

       esto se puede hacer con la siguiente definicin:

       %macro multipop 1-*
       %rep %0
       %rotate -1
                 pop %1
       %endrep
       %endmacro

       Esta macro comienza rotando sus argumentos un lugar a la _derecha_, por
       eso el _ltimo_ argumento original aparece como '%1'. Entoces, ste es
       sacado, y los argumentos son rotados a la derecha otra vez, por eso el
       segundo por el final pasa a ser '%1'. As se van iterando los argumentos
       en orden inverso.

 4.2.7 Concatenando los parmetros de macro

       NASM puede concatenar los parmetros de macro en otro texto que lo
       envuelva. Esto te permite declarar una familia de smbolos, por ejemplo,
       en una definicin de macro. Si, por ejemplo, quieres generar una tabla
       de cdigos de tecla adems de los offsets en la tabla, podras codificar
       algo como

       %macro keytab_entry 2
       keypos%1 equ $-keytab
                 db %2
       %endmacro
       keytab:
                 keytab_entry F1,128+1
                 keytab_entry F2,128+2
                 keytab_entry Return,13

       se expandira a

       keytab:
       keyposF1 equ $-keytab
                 db 128+1
       keyposF2 equ $-keytab
                 db 128+2
       keyposReturn equ $-keytab
                 db 13

       Puedes concatenar texto fcilmente al final de otro parmetro de macro,
       escribiendo '%1foo'.

       Si necesitas unir un _dgito_ a un parmetro de macro, por ejemplo
       definiendo etiquetas 'foo1' y 'foo2' cuando se pasa el parmetro 'foo',
       no puedes codificar '%$11' porque sera tomado como el undcimo parmetro
       de macro. En su lugar, debes codificar '%{1}1', que separar el primer
       '1' (dando el nmero de parmetro de macro' del segundo (texto literal
       para ser concatenado al parmetro).

       Esta concatenacin tambin puede aplicarse a otros objetos en lnea de
       preprocesador, como etiquetas locales de macro (seccin 4.2.2) y
       etiquetas locales de contexto (seccin 4.6.2). En todos los casos, las
       ambigedades en la sintaxis se pueden resolver encerrando entre llaves
       todo lo que va despus del signo '%' y antes del texto literal: por eso
       '%{%foo}bar' concatena el texto 'bar' al final del nombre real de la
       etiqueta local de macro '%%foo'. (Esto es innecesario, ya que la forma
       que NASM usa para los nombres reales de las etiquetas locales de macros
       implica que los dos usos '%{%foo}bar' y '%%foobar' seran expandidos de
       cualquier forma a la misma cosa; no obstante, la capacidad est ah.)

 4.2.8 Cdigos de condicin como parmetros de macro

       NASM puede dar un trato especial a un parmetro de macro que contenga
       un cdigo de condicin. En principio, te puedes referir a un parmetro
       de macro '%1' con la sintaxis alternativa '%+1', que informa a NASM que
       este parmetro de macro se supone que contiene cdigo de condicin, y
       har que el preprocesador informe un mensaje de error si la macro es
       llamada con un parmetro que _no_ sea un cdigo de condicin vlido.

       Incluso ms til todava, creo, te puedes referir al parmetro de macro
       con '%-1', el cual NASM expandir como el cdigo de condicin _inverso_.
       Por eso la macro 'retz' definida en la seccin 4.2.2 puede sustituirse
       por una macro general de retorno condicional como sta:

       %macro retc 1
                 j%-1 %%skip
                 ret
       %%skip:
       %endmacro

       Esta macro puede invocarse ahora usando llamadas como 'retc ne', que
       har que la instruccin de salto condicional en la expansin de la macro
       aparezca como 'JE', o 'retc po' que har del salto un 'JPE'.

       La referencia de parmetro de macro '%+1' interpreta felizmente los
       argumentos 'CXZ' y 'ECXZ' como cdigos de condicin vlidos; sin embargo,
       '%-1' informar de un error si pasa cualquiera de estos, porque no
       existen cdigos de condicin inversa.

 4.2.9 Deshabilitando la expansin de listado

       Cuando NASM est generando un fichero de listado de tu programa,
       generalmente expande las macro mlti-lnea por medio de escribir la
       llamada a la macro y luego listando cada una de las lneas de la
       expansin. Esto te permite ver qu instrucciones en la expansin de la
       macro est generando qu cdigo; sin emabargo, para algunas macro esto
       atesta innecesariamente el listado.

       Por lo tanto NASM proporciona el cualificador '.nolist', que puedes
       incluir en un definicin de macro para inhibir la expansin de la macro
       en el fichero de lista. El cualificador '.nolist' va inmediatamente
       despus del nmero de parmetros, as:

       %macro foo 1.nolist

       O as:

       %macro bar 1-5+.nolist a,b,c,d,e,f,g,h

   4.3 Ensamblaje condicional

       Al igual que el preprocesador de C, NASM permite que haya secciones de
       un fichero fuente que se ensamblen slo si se cumplen ciertas
       condiciones. La sintaxis general de esta caracterstica es algo as:

       %if<condition>
       ; algo de cdigo que slo aparece si se cumple <condition>
       %elif<condition2>
       ; slo aparece si no se cumple <condition> pero s <condition2>
       %else
       ; esto aparece si no se cumple ninguna de las condiciones <condition> y
       ; <condition2>
       %endif

       La clusula '%else' es opcional, al igual que la clusula '%elif'. Puedes
       tener ms de una clusula '%elif'.

 4.3.1 '%ifdef': Comprobando la existencia de una macro de una lnea

       Comenzando el ensamblaje de un bloque condicional con la lnea
       '%ifdef MACRO' ensamblar el subsiguiente cdigo si, y slo si, la macro
       de una lnea llamada 'MACRO' est definida. Si no, entonces los bloques
       '%elif' y '%else' (si los hay) sern procesados en su lugar.

       Por ejemplo, cuando depuras un programa, podras querer escribir cdigo
       como

                 ; realiza algunas funciones
       %ifdef DEBUG
                 writefile 2,"Function performed successfully",13,10
       %endif
                 ; ir y hacer algo ms

       Entonces podras usar la opcin '-dDEBUG' de la lnea de comandos para
       crear una versin del programa que produzca mensajes de depuracin, y
       quite la opcin para generar la versin final del programa.

       Puedes comprobar una macro que _no_ haya sido definida usando '%ifndef'
       en lugar de '%ifdef'. Tambin puedes comprobar definiciones de macros
       en los bloques '%elif' usando '%elifdef' y '%elifndef'.

 4.3.2 '%ifctx': Comprobando la pila de contexto

       La construccin de ensamblaje condional '%ifctx ctxname' har que el
       cdigo subsiguiente sea ensamblado si y slo si el contexto superior en
       la pila de contexto del preprocesador tiene el nombre 'crxname'. Al igual
       que con '%ifdef', el inverso y las formas '%elif', '%ifnctx', '%elifctx'
       y '%elifnctx' tambin estn implementadas.

       Para ms detalles sobre la pila de contexto, ver la seccin 4.6. Para
       ver un ejemplo del uso de 'ifctx', ver la seccin 4.6.5.

 4.3.3 '%if': Comprobando expresiones numricas arbitrarias

       La construccin de ensamblaje condicional '%if expr' har que el cdigo
       subsiguiente se ensamble si y slo si el valor de la expresin numrica
       'expr' no es cero. Un ejemplo del uso de esta caracterstica est en
       decidir cundo abortar un bucle '%rep' del preprocesador: ver la seccin
       4.4 para un ejemplo detallado.

       La expresin dada a '%if', y su contrapartida '%elif', es una expresin
       crtica (ver seccin 3.7).

       '%if' extiende la sintaxis normal de las expresiones NASM, proporcionando
       un conjunto de operadores relacionados que no estn normalmente
       disponibles en las expresiones. Los operadores '=', '<', '>', '<=', '>='
       y '<>' comprueban la igualdad, menor que, mayor que, menor o igual que,
       mayor o igual que y distinto, respectivamente. La formas del estilo de C
       tales como '==' y '!=' estn implementadas como formas alternativas a
       '=' y '<>'. Adicionalmente, se proveen los operadores lgicos de menor
       prioridad '&&', '^^' y '||', suministrando el AND lgico, XOR lgico y el
       OR lgico. Estos funcionan como los operadores lgicos de C (aunque C no
       tiene XOR lgico), y siempre devuelven 0  1, y tratan cualquier entrada
       que no sea cero como un 1 (por eso '^^', por ejemplo, devuelve 1 si
       exactamente una de los entradas es cero, y 0 de otra forma). Los
       operadores relacionales tambin devuelven 1 para el cierto y 0 para el
       falso.

 4.3.4 '%ifidn' y '%ifidni': Comprobando la identidad exacta de textos

       La construccin '%ifidn text1,text2' har que le subsiguiente cdigo se
       ensamble si y slo si 'text1' y 'text2', tras expandir las macros de una
       sola lnea, son piezas idnticas de texto. Las diferencias en los
       espacios en blanco no se tiene en cuenta.

       '%ifidni' es parecido a '%ifidn', pero es sensible a maysculas.

       Por ejemplo, la siguiente macro empuja un registro o nmero en la pila, y
       te permite tratar 'IP' como un registro real:

       %macro pushparam 1
       %ifidni %1,ip
                 call %%label
       %%label:
       %else
                 push %1
       %endif
       %endmacro

       Al igual que otras construcciones '%if', '%ifidn' tiene una contrapartida
       '%elifidn', y formas negativas '%ifnidn' y '%elifnidn'. De forma similar,
       '%ifidni' tiene contrapartidas '%elifidni', '%ifnidni' y '%elifnidni'.

 4.3.5 '%ifid', '%ifnum', '%ifstr': Coprobando los tipos de los objetos

       Algunas macros querrn realizar diferentes tareas dependiendo de si se
       las pasa un nmero, una cadena, o un identificador. Por ejemplo, una
       macro de salida de cadena podra querer ser capaz de funcionar si se la
       pasa tanto una constante de cadena como un puntero a una cadena ya
       existente.

       La construccin condicional '%ifid', recibe un parmetro (que podra
       ser un blanco), ensambla el cdigo subsiguiente si y slo si el primer
       objeto en el parmetro existe y es un identificador. '%ifnum' trabaja
       de forma similar, pero comprueba si el objeto es una constante numrica;
       '%ifstr' comprueba si es una cadena.

       Por ejemplo, la macro 'writefile' definida en la seccin 4.2.3 puede
       extenderse para tomar ventaja de '%ifstr' de la siguiente manera:

       %macro writefile 2-3+
       %ifstr %2
                 jmp %%endstr
       %if %0 = 3
       %%str:     db %2,%3
       %else
       %%str:     db %2
       %endif
       %%endstr: mov dx,%%str
                 mov cx,%%endstr-%%str
       %else
          mov dx,%2
          mov cx,%3
       %endif
                 mov bx,%1
                 mov ah,0x40
                 int 0x21
       %endmacro

       Entoces la macro 'writefile' funcionar si es llamado de cualquiera de
       las siguiente formas:

                 writefile [file], strpointer, length
                 writefile [file], "hello, 13, 10

       Primero, 'strpointer' se usa como la direccin de una cadena ya
       declarada, y 'length' es usado como su longitud; segundo, a la macro se
       la entrega una cadena, la cual por lo tanto se declara a s misma y
       elabora la direccin y longitud por s misma.

       Ntese el uso de '%if' dentro de '%ifstr': esto es para detectar si a
       la macro se la pasan dos argumentos (por eso, la cadena podra ser una
       simple constante de cadena, y 'db %2' sera adecuado) o ms (en cuyo
       caso, todo excepto los dos primeros podran agruparse en '%3', y se
       requerira 'db %2,%3').

       Las versiones usuales '%elifXXX', '%ifnXXX' y '%elifnXXX' existen para
       cada '%ifid', '%ifnum' y '%ifstr'.

 4.3.6 '%error': Informando errores definidos por el usuario

       La directiva del preprocesador '%error' har que NASM informe de un error
       si ocurre en el cdigo ensamblado. Por eso, si otros usuarios intentar
       ensamblar tus ficheros fuente, puedes asegurarte de que definen las
       macros correctas mediante cdigo como ste:

       %ifdef SOME_MACRO
       ; hacer algo de configuracin
       %elifdef SOME_OTHER_MACRO
       ; hacer otra configuracin diferente
       %else
       %error Neither SOME_MACRO nor SOME_OTHER_MACRO was defined.
       %endif

       Entonces, cualquier otro usuario que no entienda el modo en que se
       supone que tu cdigo fuente debe ser ensamblado rpidamente percibir
       su error, en lugar de tener que esperar a que el programa se venga abajo
       cuando sea ejecutado y no sepa qu est mal.

   4.4 Bucles del preprocesador: '%rep'

       El prefijo 'TIMES' de NASM, aunque til, no puede usarse para invocar
       varias veces una macro multi-lnea, porque NASM lo procesa despus de que
       las macros hayan sido expandidas. Por lo tanto, NASM proporciona otra
       forma de bucle, esta vez a nivel de preprocesador: '%rep'.

       Las directivas '%rep' y '%endrep' ('%rep' recive un argumento numrico,
       que puede ser una expresin; '%endrep' no recibe argumentos) pueden
       usarse para encerrar un trozo de cdigo, que es replicado por el
       preprocesador tantas veces como sea especificado:

       %assign i 0
       %rep 64
                 inc word [table+2*i]
       %assign i i+1
       %endrep

       Esto generar una secuencia de 64 instrucciones 'INC', incrementando
       cada palabra de memoria desde '[table]' hasta '[table+126]'.

       Para condiciones de terminacin ms complejas, o para abortar un bucle,
       puedes usar la directiva '%exitrep' para terminar el bucle, como esto:

       fibonacci:
       %assign i 0
       %assign j 1
       %rep 100
       %if j > 65535
       %exitrep
       %endif
                 dw j
       %assign k j+i
       %assign i j
       %assign j k
       %endrep
       fib_number equ ($-fibonacci)/2

       Esto produce una lista de todos los nmero Fibonacci que quepan en 16
       bits. Ntese que todava es necesario dar un nmero mximo de
       repeticiones a '%rep'. Esto es para prevenir la posibilidad de que NASM
       se meta en un bucle infinito en el preprocesador, que (en sistemas
       multitarea y multiusuario) tpicamente har que la memoria se vaya usando
       y otras aplicaciones empiecen a fallar.

   4.5 Incluyendo otros ficheros

       Usando, otra vez, una sintaxis muy parecida a la del preprocesador de C,
       el preprocesador de NASM te permite incluir otros ficheros fuente dentro
       de tu cdigo. Este se hace usando la directiva '%include'.

       %include "macros.mac"

       incluir el contenido del fichero 'macros.mac' dentro del fichero fuente
       que contenga la directiva '%include'.

       Los ficheros include se buscan en el directorio actual (el directorio en
       el que estabas cuando ejecutaste NASM, en lugar de en la localizacin del
       ejecutable NASM o la localizacin del fichero fuente), ms cualquier otro
       directorio especificado en la lnea de comandos del NASM usando la opcin
       '-i'.

       El idioma estndar de C para prevenir que un fichero se incluya ms de
       una vez es aplicable en NASM: si un fichero 'macros.mac' tiene la forma

       %ifndef MACROS_MAC
       %define MACROS_MAC
       ; ahora define algunas macros
       %endif

       entonces incluir el fichero ms de una vez no provocar error, porque la
       segunda vez que el fichero es incluido no pasar nada porque la macro
       'MACROS_MAC' ya est definida.

       Puedes forzar a que un fichero sea incluido incluso si no hay directiva
       '%include' que lo incluya explcitamente, usando la opcin '-p' en la
       lnea de comandos de NASM (ver seccin 2.1.6).

   4.6 La pila de contexto

       El tener etiquetas que son locales a una definicin de macro no es a
       veces lo suficientemente potente: algunas veces quieres ser capaz de
       compartir etiquetas entre varias llamadas de macros. Un ejemplo podra
       ser un bucle 'REPEAT' ... 'UNTIL', en el cual, la expansin de la macro
       'REPEAT' podra necesitar ser capaz de referirse a un etiqueta que la
       macro 'UNTIL' haya definido. Sin embargo, para tales macros querras
       poder anidar estos bucles.

       NASM proporciona este nivel de potencia mediante una _pila de contexto_.
       El preprocesador mantiene una pila de _contextos_, cada uno de los cuales
       est caracterizado por un nombre. Usando la directiva '%push' aades un
       nuevo contexto a la pila, y quitas uno usando '%pop'. Puedes definir
       etiquetas de la pila que sean locales a un contexto en particular.

 4.6.1 '%push' y '%pop': Creando y destruyendo contextos

       La directiva '%push' se usa para crear un nuevo contexto y colocarlo en
       la parte superior de la pila de contexto. '%push' requiere un argumento,
       que es el nombre del contexto. Por ejemplo:

       %push foobar

       Esto empuja un nuevo contexto llamado 'foobar' en la pila. Puedes tener
       varios contextos en la pila con el mismo nombre: aun as se pueden
       distinguir.

       La directiva '%pop', no necesita argumentos, quita el contexto de la
       parte superior de la pila de contexto y lo destruye, junto con las
       etiquetas asociadas con l.

 4.6.2 Etiquetas de contexto local

       Al igual que en el uso de '%%foo' define una etiqueta que es local a una
       llamada de macro en particular en la cual se usa, la costumbre es usar
       '%%foo' para definir una etiqueta que sea local al contexto de la parte
       de arriba de la pila. Por eso, el ejemplo de 'REPEAT' y 'UNTIL' dado
       arriba, podra implementarse mediante:

       %macro repeat 0
       %push repeat
       %$begin:
       %endmacro

       %macro until 1
                 j%-1 %$begin
       %pop
       %endmacro

       e invocarlo mediante, por ejemplo,

                 mov cx,string
                 repeat
                 add cx,3
                 scasb
                 until e

       que buscara todos los cuartos bytes de una cadena en la bsqueda del
       byte en 'AL'.

       Si necesitas definir, o acceder, etiquetas locales al contexto que est
       _debajo_ del de la parte superior de la pila, puedes usar '%$$foo' o
       '%$$$foo' para acceder al contexto que est debajo, y as.

 4.6.3 Macros de una lnea y de contexto local

       NASM tambin te permite definir macros de una lnea que sean locales a
       un contexto en particular, de la misma manera:

       %define %$localmac 3

       definir la macro de una lnea '%$localmac' como local al contexto de la
       parte superior de la pila. Por supuesto, despus de un '%push'
       subsiguiente, todava podr ser accedida por el nombre '%$$localmac'.

 4.6.4 '%repl': Renombrando un contexto

       Si necesitas cambiar el nombre del contexto de la parte superior de la
       pila (para responder, por ejemplo, de manera diferente a '%ifctx'), puedes
       ejecutar un '%pop' seguido de un '%push'; pero esto tendr el efecto
       lateral de destruir todas las etiquetas de contexto local y las macros
       asociadas con el contexto que acaba de ser sacado.

       NASM proporciona la directiva '%repl', que _sustituye_ un contexto con
       un nombre diferente, sin tocar las macros y etiquetas asociadas. Por eso
       podras sustituir el cdigo destructivo

       %pop
       %push newname

       con la versin no destructiva '%repl newname'.

 4.6.5 Ejemplo de uso de la pila de contexto: Bloque IFs

       Este ejemplo hace uso de casi todas las caractersticas la pila de
       contexto, incluyendo la construccin de ensamblaje condicional '%ifctx',
       para implementar un bloque de sentencia IF como un conjunto de macros.

       %macro if 1
           %push if
           j%-1 %$ifnot
       %endmacro

       %macro else 0
           %ifctx if
               %repl else
               jmp %$ifend 
               %$ifnot: 
           %else 
               %error "expected `if' before `else'" 
           %endif 
       %endmacro

       %macro endif 0 
           %ifctx if 
               %$ifnot: 
               %pop 
           %elifctx else 
               %$ifend: 
               %pop 
           %else 
               %error "expected `if' or `else' before `endif'" 
           %endif 
       %endmacro

       Este cdigo es ms robusto que las macros 'REPEAT' y 'UNTIL' dadas en la
       seccin 4.6.2, porque usa ensamblaje condicional para comprobar que las
       macros se llaman en el orden correcto (por ejemplo, no llamando a 'endif'
       antes que 'if') y emitiendo un '%error' si no.

       Adicionalmente, la macro 'endif' tiene que ser capaz de hacer frente a
       los casos distintos de seguir directamente a un 'if', o seguir a un
       'else'. Se consigue esto, de nuevo, usando ensamblaje condicional para
       hacer cosas diferentes dependiendo de si el contexto de la parte superior
       de la pila es un 'if' o un 'else'.

       La macro 'else' tiene que preservar el contexto de la pila, para tener
       el '%$ifnot' referido para, por la macro 'if', ser la misma que la
       definida por la macro 'endif', pero tiene que cambiar el nombre del
       contexto, por eso, ese 'endif' sabr que hay interviniendo un 'else'.
       Esto se hace con el uso de '%repl'.

       Un ejemplo de uso de estas macros podra ser como:

                 cmp ax,bx
                 if ae
                   cmp bx,cx
                   if ae 
                     mov ax,cx 
                   else 
                     mov ax,bx 
                   endif 
                 else 
                   cmp ax,cx 
                   if ae 
                     mov ax,cx 
                   endif 
                 endif

       Las macros de bloque 'IF' se anidan bastante fcilmente, empujando otro
       contexto, describiendo el 'if' ms interno, encima del que describe el
       'if' de la parte ms exterior; por eso, 'else' y 'endif' siempre se
       refieren al ltimo 'if' o 'else' no emparejado.

   4.7 Macros estndar

       NASM define un conjunto de macros estndar, que estn ya definidas cuando
       empieza a procesar cualquier fichero fuente. Si realmente necesitas que
       un programa se ensamble sin las macros predefinidas, puedes hacer uso de
       la directiva '%clear' para vaciar el preprocesador de cualquier cosa.

       La mayora de las directivas a nivel de usuario (ver captulo 5) estn
       implementadas como macros que invocan directivas primitivas; estas estn
       descritas en el captulo 5. El resto del conjunto de macros estndar se
       describe aqu.

 4.7.1 '__NASM_MAJOR__' y '__NASM_MINOR__': Versin del NASM

       Las macros de una lnea '__NASM_MAJOR__' y '__NASM_MINOR__' se expanden
       a las partes principal y secundaria del nmero de versin del NASM que
       est siendo usado. Por eso, bajo NASM 0.96, por ejemplo, '__NASM_MAJOR__'
       sera definida como 0 y '__NASM_MINOR__' sera definida como 96.

 4.7.2 '__FILE__' y '__LINE__': Nombre de fichero y nmero de lneas

       Al igual que el preprocesador de C, NASM permite al usuario encontrar el
       nombre de fichero y el nmero de lnea que contiene la intruccin actual.
       La macro '__FILE__' se expande a una constante cadena dando el nombre del
       fichero de entrada actual (que podra cambiar a lo largo de un ensamblaje
       si se usan directivas '%include'), y '__LINE__' se expande a una
       constante numrica dando la lnea actual en el fichero de entrada.

       Estas macros podran usarse, por ejemplo, para comunicar informacin de
       depuracin a una macro, ya que invocando '__LINE__' dentro de una
       definicin de macro (ya sea de una lnea o de mltiples lneas) devolver
       el nmero de lnea de la _llamada_ a la macro, en lugar de la
       _definicin_. Por eso, para determinar dnde est fallando un trozo de
       cdigo, por ejemplo, uno podra escribir una rutina 'stillhere', que
       recibe un nmero de lnea en 'EAX' y devuelve algo como 'line 155: still
       here'. Podras escribir una macro

       %macro notdeadyet 0
                 push eax
                 mov eax,__LINE__
                 call stillhere
                 pop eax
       %endmacro

       y luego salpicar tu cdigo con llamadas a 'notdeadyet' hasta que
       encuentres el punto del fallo.

 4.7.3 'STRUC' y 'ENDSTRUC': Declarando tipos de estructura de datos

       El ncleo de NASM no contiene medios intrnsecos para definir estructuras
       de datos; en su lugar, el preprocesador es lo suficientemente potente que
       las estructuras de datos pueden implementarse como un conjunto de macros.
       Las macros 'STRUC' y 'ENDSTRUC' se usan para definir un tipo estructura
       de datos.

       'STRUC' recibe un parmetro, que es el nombre del tipo de dato. Este
       nombre est definido como un smbolo con el valor cero, y tambin tiene
       aadido el sufijo '_size' y entonces es definido como un 'EQU' dando
       el tamao de la estructura. Una vez que 'STRUC' ha sido emitido, ests
       definiendo la estructura, y deberas definir los campos usando la
       familia 'RESB' de pseudo-instrucciones, y luego invocar 'ENDSTRUC' para
       terminar la definicin.

       Por ejemplo, para definir una estructura llamada 'mytype' conteniendo
       una longword, una word, un byte y una cadena de bytes, podras codificar

                 struc mytype
       mt_long:  resb 1
       mt_word:  resw 1
       mt_byte:  resb 1
       mt_str:   resb 32
                 endstruc

       Este cdigo define seis smbolos: 'mt_long' como 0 (el offset del
       principio de la estructura 'mytype' al campo longword), 'mt_word' como 4,
       'mt_byte' como 6, 'mt_str' como 7, 'mytype_size' como 39, y 'mytype' como
       cero.

       La razn de por qu el nombre del tipo estructura se define como cero es
       un efecto lateral de permitir a las estructuras trabajar con el mecanismo
       de las etiquetas locales: si los miembros de tu estructura tienden a
       tener los mismos nombres en ms de una estructura, puedes definir la
       estructura de arriba como esto:

                 struc mytype
       .long:    resd 1 
       .word:    resw 1 
       .byte:    resb 1 
       .str:     resb 32 
                 endstruc

       Esto define los offsets a los campos de la estructura como 'mytype.long',
       'mytype.word', 'mytype.byte' y 'mytype.str'.

       NASM, ya que no tiene _intrnseco_ el soporte de estructuras, no soporta
       ninguna forma de notacin peridica para referirse a un elemento de una
       estructura una vez tengas una (excepto la notacin de etiquetas locales
       arriba mencionado), por eso, cdigo como 'mov ax,[mystruc.mt_word] no
       es vlido. 'mt_word' es una constante como cualquier otra constante, por
       eso la sintaxis correcta es 'mov ax,[mystruc+mt_word]' o
       'mov ax,[mystruc+mytype.word]'.

 4.7.4 'ISTRUC', 'AT' and 'IEND': Declarando instancias de estructuras

       Teniendo definida un tipo estructura, la siguiente cosa que tpicamente
       querrs hacer es declarar instancias de esa estructura en tu segmento de
       datos. NASM proporciona un modo fcil de hacer esto en el mecanismo
       'ISTRUC'. Para declarar una estructura del tipo 'mytype' en un programa,
       codificas algo similar a esto:

       mystruc:  istruc mytype
                 at mt_long, dd 123456
                 at mt_word, dw 1024
                 at mt_byte, db 'x'
                 at mt_str, db 'hello, world', 13, 10, 0
                 iend

       La funcin de la macro 'AT' es hacer uso del prefijo 'TIMES' para avanzar
       la posicin de ensamblaje al punto correcto del campo especificado de la
       estructura, y luego declarar el dato especificado. Por lo tanto los
       campos de estructura deben ser declarados en el mismo orden en que son
       especificados en la definicin de la estructura.

       Si el dato que va en el campo de la estructura requiere ms de una lnea
       del fuente para ser especificado, las restantes lnea del fuente pueden
       fcilmente venir despus de la lnea 'AT'. Por ejemplo:

                 at mt_str, db 123,134,145,156,167,178,189
                 db 190,100,0

       Dependiendo del gusto personal, puedes tambin omitir completamente la
       parte de cdigo de la lnea 'AT', y empezar el campo de la estructura
       en la siguiente lnea:

                 at mt_str
                 db 'hello, world'
                 db 13,10,0

 4.7.5 'ALIGN' y 'ALIGNB': Alineamiento de datos

       Las macros 'ALIGN' y 'ALIGNB' proporcionan un modo conveniente de alinear
       el cdigo o los datos a una palabra, palabra larga, prrafo u otro
       lmite. (Algunos ensambladores llaman a esta directiva 'EVEN'.) La
       sintaxis de las macros 'ALIGN' y 'ALIGNB' es

                 align 4                ; alina en el lmite de 4-bytes
                 align 16               ; alina en el lmite de 16-bytes
                 align 8,db 0           ; rellena con 0 en lugar de con NOPs
                 align 4.resb 1         ; alina a 4 en el BSS
                 alignb 4               ; equivalente a la lnea anterior

       Ambas macros requieren que su primer argumento sea una potencia de dos;
       ambas calculan el nmero de bytes adicionales requeridos para traer la
       longitud de la seccin actual a un mltiplo de esa potencia de dos, y
       luego aplican el prefijo 'TIMES' a su segundo argumento para realizar el
       alineamiento.

       Si no se especifica el segundo argumento, por defecto para 'ALIGN' es
       'NOP', y por defecto para 'ALIGNB' es 'RESB 1'. Por eso si est
       especificado el segundo argumento, las dos macros son equivalentes.
       Normalmente, simplemente puedes usar 'ALIGN' en las secciones de cdigo
       y datos, y 'ALIGNB' en las secciones BSS, y nunca necesitar el segundo
       argumento excepto para propsitos especiales.

       'ALIGN' y 'ALIGNB', al ser macros sencillas, no realizan ninguna
       comprobacin de errores: no te pueden avisar si su primer argumento falla
       el ser una potencia de dos, o si el segundo argumento genera ms de un
       byte de cdigo. En cada uno de estos casos har en silencio la cosa
       equivocada.

       'ALIGNB' ('ALIGN' con un segundo argumento 'RESB 1') pueden usarse dentro
       de definiciones de estructuras:

                 struc mytype2
       mt_byte:  resb 1
                 alignb 2
       mt_word:  resw 1 
                 alignb 4 
       mt_long:  resd 1 
       mt_str:   resb 32 
                 endstruc

       Esto asegurar que los miembros de la estructura estn alineados
       sensatamente en relacin a la base de la estructura.

       Un comentario final: 'ALIGN' y 'ALIGNB' trabajan en relacin al principio
       de la _seccin_, no al principio del espacio de direccin del ejecutable
       final. El alineamiento a un lmite de 16-byte cuando en la seccin en la
       que ests slo garantiza el alineamiento a un lmite de 4-byte, por
       ejemplo, es un esfuerzo perdido. De nuevo, NASM no comprueba que las
       caractersticas del alineamiento de la seccin sean correctas para el
       uso de 'ALIGN' y 'ALIGNB'.

Captulo 5: Directivas del ensamblador
--------------------------------------

       NASM, aunque intenta evitar la burocracia de ensambladores como MASM o
       TASM, est sin embargo forzado a soportar unas _pocas_ directivas. Estas
       estn descritas en este captulo.

       Las directivas de NASM viene en dos tipos: directivas a nivel de usuario
       y directivas primitivas. Tpicamente, cada directiva tiene una forma a
       nivel de usuario y una forma primitiva. En casi todos los casos,
       recomendamos que los usuarios usen las formas a nivel de usuario de las
       directivas, que estn implementadas como macros que llaman a las formas
       primitivas.

       Las directivas primitivas estn encerradas entre corchetes; las
       directivas a nivel de usuarios, no.

       Adicionalmente a las directivas universales descritas en este captulo,
       cada formato de fichero objeto puede suministrar opcionalmente directivas
       extra para controlar caractersticas particulares de ese formato de
       fichero. Estas directivas especficas del formato de fichero estn
       documentadas adems de los formatos que las implementas, en el
       captulo 6.

   5.1 'BITS': Especificando el modo de proceso del destino

       La directiva 'BITS' especifica si NASM debera generar cdigo diseado
       para correr en un procesador operando en modo de 16-bit, o cdigo
       diseado para correr en un procesador operando en modo de 32-bit. La
       sintaxis es 'BITS 16' or 'BITS 32'.

       En la mayora de los casos, no deberas necesitar usar 'BITS'
       explcitamente. Los formatos objeto 'aout', 'coff', 'elf' y 'win32', que
       estn diseados para ser usados en sistemas operativos de 32-bit, hacen
       que NASM seleccione por defecto el modo de 32-bit. El formato objeto
       'obj' te permite especificar cada segmento que definas como 'USE16' o
       'USE32', y NASM establecer de acuerdo a esto su modo de operacin, por
       eso, el uso de la directiva 'BITS' es una vez ms innecesario.

       La mejor razn para usar la directiva 'BITS' es para escribir cdigo
       32-bit en un fichero binario plano; esto es debido a que el formato de
       salida 'bin' est por defecto en el modo de 16-bit en anticipacin a que
       va a ser usado con mayor frecuencia para escribir programas '.COM' del
       DOS, controladores de dispositivo '.SYS' y software cargador de arranque.

       _No_ necesitas especificar 'BITS 32' simplemente para usar instrucciones
       de 32-bit en un programa DOS de 16-bit; si lo haces, el ensamblador
       generar cdigo incorrecto porque estar escribiendo cdigo destino en
       una plataforma de 32-bit, para ser ejecutado en una de 16-bit.

       Cuando NASM est en el estado 'BITS 16', las instrucciones que usen datos
       de 32-bit son prefijadas con un byte 0x66, y aquellas que se refieran a
       direcciones de 32-bit tendrn el prefijo 0x67. En el estado 'BITS 32', lo
       contrario es cierto: las instrucciones de 32-bit no requieren prefijo,
       sin embargo las instrucciones que usen datos de 16-bit necesitan un 0x66
       y aquellas que trabajen en direcciones de 16-bit necesitan un 0x67.

       La directiva 'BITS' tienen una forma primitiva exactamente equivalente,
       '[BITS 16]' y '[BITS 32]'. La forma a nivel de usuario es una macro que
       no tiene otra funcin que llamar a la forma primitiva.

   5.2 'SECTION' o 'SEGMENT': Cambiando y definiendo secciones

       La directiva 'SECTION' ('SEGMENT' es un sinnimo exactamente
       equivalente) cambia la seccin del fichero de salida en la que va a ser
       ensamblado el cdigo que escribas. En algunos formatos de fichero objeto,
       el nmero y nombre de las secciones es fijo; en otros, el usuario puede
       inventarse tantas como quiera. Por lo tanto, 'SECTION' podra a veces dar
       un mensaje de error, o podra definir una nueva seccin, si intentas
       cambiar a una seccin que (todava) no existe.

       Tanto los formatos objeto de Unix como el formato objeto 'bin' soportan
       los nombres de seccin entandarizados '.text', '.data' y '.bss' para las
       secciones de cdigo, datos y datos no inicializados. El formato 'obj',
       al contrario, no reconoce como especiales estos nombres de seccin, y de
       hecho desmontar el perodo previo de cualquier nombre de seccin que
       tenga uno.

 5.2.1 La macro '__SECT__'

       La directiva 'SECTION' es inusual ya que las funciones de su forma a
       nivel de usuario difieren de su forma primitiva. La forma primitiva,
       '[SECTION xyz]', simplemente cambia la seccin destino actual por la
       dada. La forma del nivel usuario, 'SECTION xyz', sin embargo, define
       primero la macro de una lnea '__SECT__' como la directiva primitiva de
       '[SECTION]' que es para emitir, y luego la emite. Por eso la directiva
       a nivel usuario

                 SECTION .text

       se expande a las dos lneas

       %define __SECT___ [SECTION .text]
                 [SECTION .text]

       Los usuarios pueden encontrar til hacer uso de esto en sus propias
       macros. Por ejemplo, la macro 'writefile' definida en la seccin 4.2.3
       puede reescribirse de forma ms til de la siguiente forma mucho ms
       sofisticada:

       %macro writefile 2+
                 [section .data] 
       %%str:    db %2 
       %%endstr: 
                 __SECT__ 
                 mov dx,%%str 
                 mov cx,%%endstr-%%str 
                 mov bx,%1 
                 mov ah,0x40 
                 int 0x21 
       %endmacro

       Esta forma de la macro, una vez pasada una cadena a la salida, primero
       cambia temporalmente a la seccin de datos del fichero, usando la forma
       primitiva de la directiva 'SECTION' y no modifica '__SECT__'. Entonces
       declara su cadena en la seccin de datos, y luego invoca '__SECT__' para
       cambiar de vuelta a _cualquier_ seccin en la que el usuario estuviese
       trabajando. De este modo evita la necesidad, en la versin anterior de la
       macro, de incluir una instruccin 'JMP' para saltar al dato, y no falla
       si, en un complicado mdulo de formato 'OBJ', el usuario podra estar
       potencialmente ensamblando el cdigo en varias secciones de cdigo
       separadas.

   5.3 'ABSOLUTE': Definiendo etiquetas absolutas

       La directiva 'ABSOLUTE' puede pensarse como una forma alternativa de
       'SECTION': hace que el cdigo subsiguiente no sea dirigido a ninguna
       seccin fsica, sino a la hipottica seccin que comienza en la direccin
       absoluta dada. Las nicas instrucciones que puedes usar en este modo son
       la familia 'RESB'.

       'ABSOLUTE' se usa como sigue:

                 absolute 0x1A
       kbuf_chr  resw 1
       kbuf_free resw 1
       kbuf      resw 16

       Este ejemplo describe una seccin del rea de datos de la BIOS PC, en la
       direccin de segmento 0x40: el cdigo de arriba define 'kbuf_chr' como
       0x1A, 'kbuf_free' como 0x1C, y 'kbuf' como 0x1E.

       La forma a nivel de usuario de 'ABSOLUTE', al igual que 'SECTION',
       redefine la macro '__SECT__' cuando es invocado.

       'STRUC' y 'ENDSTRUC' estn definidas como macros que usan 'ABSOLUTE' (y
       tambin '__SECT__').

       'ABSOLUTE' no tiene que coger una constante absoluta como un argumento:
       puede coger una expresin (actualmente, una expresin crtica: ver la
       la seccin 3.7) y puede ser un valor en un segmento. Por ejemplo, un TSR
       puede reutilizar su cdigo de inicialacin como un BSS en tiempo de
       ejecucin como ste:

                 org 100h               ; es un programa .COM
                 jmp setup              ; el cdigo de inicio viene al final
                 ; aqu viene la parte residente del TSR
       setup:    ;ahora escribe aqu el cdigo que installa el TSR
                 absolute setup
       runtimevar1 resw 1
       runtimevar2 resd 20
       tsr_end:

       Esto define algunas variables 'encima de' el cdigo de inicio, por eso
       despus que la inicializacin ha terminado de ejecutarse, el espacio que
       tom puede reutilizarse como almacenamiento de datos para el TSR que se
       est ejecutando. El smbolo 'tsr_end' puede usarse para calcular el
       tamao total de la parte del TSR que se necesita hacer residente.

   5.4 'EXTERN': Importando smbolos desde otros mdulos

       'EXTERN' es similar a la directiva de NASM 'EXTRN' y la palabra clave de
       C 'extern': se usa para declarar un smbolo que no est definido en
       ningn sitio del mdulo que est siendo ensamblado, pero que se asume que
       que est definido en algn otro mdulo y necesita ser referenciado por
       ste. No todos los formatos de fichero objeto soportan variables
       externas: el formato 'bin' no puede.

       La directiva 'EXTERN' recibe tantos argumentos como quieras. Cada
       argumento es el nombre de un smbolo:

                 extern _printf
                 extern _sscanf,_fscanf

       Algunos formatos de fichero objeto proporcionan caractersticas extras a
       la directiva 'EXTERN'. En todos los casos, las caractersticas extras
       son usadas poniendo como sufijo dos puntos al nombre del smbolo seguido
       por el texto especfico del formato objeto. Por ejemplo, el formato 'obj'
       te permite declarar el segmento base por defecto de un externo debera
       ser el grupo 'dgroup' mediante la directiva

                 extern _variable:wrt dgroup

       La forma primitiva de 'EXTERN' difiere de la forma a nivel de usuario en
       que aquella slo puede recibir un argumento cada vez: el soporte para
       mltiples argumentos est implementado a nivel de procesador.

       Puedes declarar la misma variable como 'EXTERN' ms de una vez: NASM
       tranquilamente ignorar la segunda y posteriores declaraciones. Sin
       embargo, no puedes declarar una variable como 'EXTERN' y adems como
       algo ms.

   5.5 'GLOBAL': Exportando smbolos desde otros mdulos

       'GLOBAL' es el otro lado de 'EXTERN': si un mdulo declara un smbolo
       como 'EXTERN' y se refiere a l, entonces, para prevenir errores del
       enlazador, algunos otros mdulos deben _definir_ actualmente el smbolo
       y declararlo como 'GLOBAL'. Algunos ensambladores usan el nombre 'PUBLIC'
       para este mismo propsito.

       La directiva 'GLOBAL' aplicada a un smbolo debe aparecer _antes_ que la
       definicin del smbolo.

       'GLOBAL' usa la misma sintaxis que 'EXTERN', excepto que debe referirse
       a smbolos que _estn_ definidos en el mismo mdulo con la directiva
       'GLOBAL'. Por ejemplo:

                 global _main
       _main     ; algo de cdigo

       'GLOBAL', al igual que 'EXTERN', permite a los formatos objeto definir
       extensiones privadas mediante dos puntos. El formato objeto 'elf', por
       ejemplo, te permite especificar si los datos globales son funciones o
       datos:

                 global hashlookup:function, hashtable:data

       Al igual que 'EXTERN', la forma primitiva de 'GLOBAL' difiere de la forma
       a nivel de usuario en que slo puede recibir un argumento cada vez.

   5.6 'COMMON': Definiendo reas de datos comunes

       La directiva 'COMMON' se usa para declarar _variables comunes_. Una
       variable comn es como una variable global declarada en la seccin de
       datos no inicializados, por eso

                 common intvar 4

       es similar en funcionamiento a

                 global intvar
                 section .bss
       intvar    resd 1

       La diferencia es que si ms de un mdulo definen la misma variable
       comn, entonces en tiempo de enlace estas variables sern _unidas_, y las
       referencias a 'intvar' en todos los mdulos apuntarn al mismo lugar de
       memoria.

       Al igual que 'GLOBAL' y 'EXTERN', 'COMMON' soporta extensiones
       especficas de los formatos objeto. Por ejemplo, el formato 'obj' permite
       a las variables comunes ser NEAR o FAR, y el formato 'elf' te permite
       especificar los requerimientos del alineamiento de una variable comn:

                 common commvar 4:near  ; funciona en OBJ
                 common intarray 100:4  ; funciona en ELF: 4 bytes alineados

       Una vez ms, al igual que 'EXTERN' y 'GLOBAL', la forma primitiva de
       'COMMON' difiere de la forma a nivel de usuario en que slo puede recibir
       un argumento cada vez.

Captulo 6: Formatos de salida
------------------------------

       NASM es un enasamblador portable, diseado para ser capaz de compilar
       en cualquier plataforma que soporte ANSI C y produce salidas que corren
       en una variedad de sistemas operativos de Intel x86. Por esta razn,
       tiene disponibles un gran nmero de formatos de salida, seleccionados
       usando la opcin '-f' en la lnea de comandos de NASM. Cada uno de estos
       formatos, adems de sus extensions en la sintaxis base de NASM, son
       detallados en este captulo.

       Segn se mencion en la seccin 3.1.1, NASM elige un nombre por defecto
       para tu fichero de salida basado en el fichero de entrada y el formato de
       salida elegido. Este ser generado quitando la extensin ('.asm', '.s' o
       cualquiera que sea la que uses) del nombre del fichero de entrada, y
       sustituyendola por la extensin definida por el formato de salida. Las
       extensiones estn dadas aqu abajo con cada formato.

   6.1 'bin': Salida binaria de forma plana

       El formato 'bin' no produce ficheros objeto: no genera nada en el fichero
       de salida excepto el cdigo que escribas. Por eso, los ficheros de
       'binario puro' son usados por MS-DOS: los ejecutables '.COM' y los
       controladores de dispositivo '.SYS' son ficheros de binario puro. La
       salida de binario puro tambin es til para el desarollo de sistemas
       operativos y de cargadores de arranque.

       'bin' soporta solamente los tres nombres de seccin estandarizados
       '.text', '.data' y '.bss'. El fichero que NASM saca contendr primero el
       contenido de la seccin '.text', seguido del contenido de la seccin
       '.data', alineado con un lmite de 4-bytes. La seccin '.bss' no se
       almacena para nada en el fichero de salida, pero se asume que aparece
       directamente despus del final de la seccin '.data', nuevamente alineado
       en un lmite de 4-bytes.

       Si no especificas explcitamente la directiva 'SECTION', el cdigo que
       escribas ser dirigido por defecto a la seccin '.text'.

       Al usar el formato 'bin' se pone a NASM por defecto en el modo 16-bit
       (ver la seccin 5.1). Para usar 'bin' para escribir cdigo 32-bit como un
       ncleo de sistema operativo, necesitas mandar explctamente la directiva
       'BITS 32'.

       'bin' no tiene por defecto extensin del nombre del fichero de salida:
       en su lugar, deja el nombre de tu fichero tal cual est una vez que haya
       sido quitada la extensin original. Por eso, por defecto est que NASM
       ensamble 'binprog.asm' en un fichero binario llamado 'binprog'.

 6.1.1 'ORG': Origen del programa del fichero binario

       El formato 'bin' proporciona una directiva adicional a la lista dada en
       el captulo 5: 'ORG'. La funcin de la directiva 'ORG' es especificar
       la direccin de origen en la cual NASM asume que comienza el programa
       cuando se carga en memoria.

       Por ejemplo, el siguiente cdigo generar la palabra larga '0x00000104':

                 org 0x100
                 dd label
       label:

       Al contrario que la directiva 'ORG' proporcionada por los ensambladores
       compatibles con MASM, que te permiten saltar por el fichero objeto y
       sobreescribir cdigo que ya has generado, el 'ORG' de NASM hace
       exactamente lo que dice la directiva: _origen_. Su nica funcin es
       especificar un offset que es aadido a todas las referencias de
       direcciones internas dentro del fichero; no permite ninguno de los trucos
       que las versiones MASM permiten. Ver la seccin 10.1.3 para ms
       comentarios.

 6.1.2 Extensiones 'bin' de la directiva 'SECTION'

       El formato de salida 'out' extiende la directiva 'SECTION' (o 'SEGMENT')
       para permitirte especificar los requerimientos de alineamiento de los
       segmentos. Esto se hace aadiendo el cualificador 'ALIGN' al final de la
       lnea de definicin de seccin. Por ejemplo,

                 section .data align=16

       cambia a la seccin '.data' y tambin especifica que debe alinearse con
       un lmite de 16-bytes.

       El parmetro de 'ALIGN' especifica cuntos bits bajos de la direccin
       de comienzo de la seccin deben forzarse a cero. El valor dado del
       alineamiento debera ser una potencia de dos.

   6.2 'obj': Ficheros objeto Microsoft OMF

       El formato de fichero 'obj' (NASM lo llama 'obj' en lugar de 'omf' por
       razones histricas) es el producido por MASM y TASM, que se suminstra a
       los enlazadores de 16-bits del DOS para producir ficheros '.EXE'. Este es
       tambin el formato usado por OS/2.

       'obj' proporciona por defecto la extensin '.obj' para el nombre del
       fichero de salida.

       'obj' no es un formato esclusivo de 16-bits, esto es: NASM soporta
       totalmente las extensiones de 32-bits del formato. En particular, los
       ficheros de formato 'obj' de 32-bits se usan por los compilador Win32 de
       Borland, en lugar de usar el nuevo formato de fichero objeto de
       Microsoft, 'win32'.

       El formato 'obj' no define ningn nombre especial de segmento: puedes
       llamar a tus segmentos como quieras. Nombres tpicos de segmentos en los
       ficheros de formato 'obj' son 'CODE', 'DATA' y 'BSS'.

       Si tu fichero fuente contiene cdigo antes de especificar una directiva
       'SEGMENT' explcita, entonces NASM se inventar por ti su propio segmento
       llamado '__NASMDEFSEG'.

       Cuando defines un segmento en un fichero 'obj', NASM define el nombre del
       segmento como un smbolo, por eso puedes acceder a la direccin de
       segmento del segmento. As, por ejemplo:

                 segment data
       dvar:     dw 1234
                 segmento code
       function: mov ax,data            ; coge la direccin de segmento de data
                 mov ds,ax              ; y la mueve a DS
                 inc word [dvar]        ; ahora esta referencia funcionar
                 ret

       El formato 'obj' tambin permite el uso de los operadores 'SEG' y 'WRT',
       por eso puedes escribir cdigo que haga cosas como

                 extern foo
                 mov ax,seg foo         ; como el segmento preferido de foo
                 mov ds,ax
                 mov ax,data            ; un segmento diferente
                 mov es,ax
                 mov ax,[ds:foo]        ; esto accede a 'foo'
                 mov [es:foo wrt data],bx  ; tambin hace esto

 6.2.1 Extensiones 'obj' de la directiva 'SEGMENT'

       El formato de salida 'obj' extiende la directiva 'SEGMENT' (o 'SECTION')
       para permitirte especificar varias propiedades del segmento que ests
       definiendo. Esto se hace aadiendo calificadores al final de la lnea de
       definicin del segmento. Por ejemplo,

                 segment code private align=16

       define el segmento 'code', pero tambin lo declara como segmento privado,
       y requiere que la porcin descrita en este mdulo de cdigo est alineado
       en un lmite de 16-byte.

       Los calificadores disponibles son:

       (*) 'PRIVATE', 'PUBLIC', 'COMMON' y 'STACK' especifican las
           caractersticas combinadas del segmento. Los segmento 'PRIVATE' no
           son combinados por el enlazador con ningn otro; los segmentos
           'PUBLIC' y 'STACK' se concatenan juntos en tiempo de enlace; y los
           segmentos 'COMMON' son todos superpuestos en la parte superior de
           cada uno de los otros en lugar de pegarlos final con final.

       (*) 'ALIGN' se usa, como se ha visto arriba, para especificar cuntos
           bits bajos de la direccin de comienzo de segmento deben forzarse a
           cero. El valor del alineamiento debera ser cualquier potencia de dos
           desde 1 a 4096; en realidad, los nicos valores soportados son 1, 2,
           4, 16, 256 y 4096, por eso si especificas 8 ser redondeado hasta 16,
           y 32, 64 y 128 sern redondeados hasta 256, y as. Ntese que el
           alineamiento en lmite de 4096-bytes es una extensin de PharLap del
           formato y podra no ser soportada por todos los enlazadores.

       (*) 'CLASS' puede usarse para especificar la clase del segmento; esta
           caracterstica indica al enlazador que los segmentos de la misma
           clase deberan colocarse cerca unos de otros en fichero de salida.
           El nombre de la clase puede ser cualquier palabra, por ejemplo
           'CLASS=CODE'.

       (*) 'OVERLAY', al igual que 'CLASS', se especifica con una palabra
           arbitraria como argumento, y proporciona informacin de solapamiento
           para un enlazador capaz de solapar.

       (*) Los segmentos se pueden declarar como 'USE16' o 'USE32', que tiene el
           efecto de grabar la eleccin en el fichero objeto y tambin de
           asegurar que el modo de ensamblaje por defecto de NASM, cuando se
           est ensamblando en este segmento, es 16-bit o 32-bit
           respectivamente.

       (*) Cuando escribas ficheros objeto de OS/2, deberas declarar los
           segmentos de 32-bits como 'FLAT', lo que har que el segmento base
           por defecto para cualquier cosa en el segmento sea del grupo especial
           'FLAT', y tambin define el grupo si no est ya definido.

       (*) El fomato de fichero 'obj' tambin permite a los segmentos ser
           declarados teniendo predefinido una direccin de segmento absoluta,
           aunque no se conocen enlazadores que actualmente hagan un uso sensato
           de esta caracterstica, no obstante, NASM te permite declarar si lo
           necesitas un segmento como 'SEGMENT SCREEN ABSOLUTE=0xB800'. Las
           palabras claves 'ABSOLUTE' y 'ALIGN' son excluyentes entre s.

       Los atributos de segmento por defecto de NASM son 'PUBLIC', 'ALIGN=1',
       sin clase, sin solapamiento, y 'USE16'.

 6.2.2 'GROUP': Definiendo grupos de segmentos

       El formato 'obj' tambin permite agrupar a los segmentos, por esto es que
       puede usarse un simple registro de segmento para referirse a todos los
       segmentos en un grupo. Por lo tanto, NASM proporciona la directiva
       'GROUP', y puedes codificar

                 segment data
                 ; algunos datos
                 segment bss
                 ; algunos datos no inicializados
                 group dgroup data bss

       lo que definir un grupo llamado 'dgroup' para contener los segmentos
       'data' y 'bss'. Al igual que 'SEGMENT', 'GROUP' hace que el nombre del
       grupo sea definido como un smbolo, por eso te puedes referir a la
       variable 'var' en el segmento 'data' como 'var wrt data' o como
       'var wrt dgroup', dependiendo de qu valor de segmento est actualmente
       en tu registro de segmento.

       Si simplemente te refieres a 'var', sin embargo, y 'var' est declarada
       en un segmento que forma parte de un grupo, entonces NASM por defecto te
       dar el offset de 'var' desde el principio del _grupo_, no del segmento.
       Por lo tanto, 'SEG var', tambin devolver la base del grupo, en lugar
       de la base del segmento.

       NASM permitir a un segmento ser parte de ms de un grupo, pero generar
       un warning si lo haces. Las variables declaradas en un segmento que forma
       parte de ms de un grupo por defecto ser relativas al primer grupo que
       fue definido para contener el segmento.

       Un grupo no tiene por qu contener algn segmento; todava puedes hacer
       referencias 'WRT' a un grupo que no contenga la variable a la que te
       ests refiriendo. OS/2, por ejemplo, define el grupo especial 'FLAT' que
       no contiene segmentos.

 6.2.3 'UPPERCASE': Desactivando en la salida la sensibilidad a maysculas

       Aunque NASM en s mismo es sensible a maysculas, algunos enlazadores OMF
       no lo son; por eso puede ser til para NASM dar ficheros objeto de salida
       que no sean sensibles a maysculas. La directiva especfica de formato
       'UPPERCASE' hace que todos los nombres de segmentos, grupos y smbolos
       escritos en el fichero objeto se pasen a maysculas antes de escribirse.
       Dentro de un fichero fuente, NASM todava es sensible a maysculas; pero
       el fichero objeto puede escribirse por completo si se quiere en
       maysculas.

       'UPPERCASE' se usa solo en una lnea; no requiere parmetros.

 6.2.4 'IMPORT': Importando smbolos DLL

       La directiva especfica de formato 'IMPORT' define un smbolo que va a
       ser importado desde una DLL, para usarlo si ests escribiendo en NASM una
       biblioteca importada de una DLL. Todava necesitas declarar el smbolo
       como 'EXTERN' as como usar la directiva 'IMPORT'.

       La directiva 'IMPORT' necesita dos parmetros, separados por espacios
       en blanco, que son (respectivamente) el nombre del smbolo que quieres
       importar y el nombre de la biblioteca desde la que lo deseas importar.
       Por ejemplo:

                 import WSAStartup wsock32.dll

       Un tercer parmetro opcional da el nombre con el cual es conocido el
       smbolo en la biblioteca desde la que lo ests importando, en este caso
       no es el mismo que el nombre con el que quieres que sea conocido el
       smbolo en tu cdigo una vez que haya sido importado. Por ejemplo:

                 import asyncsel wsock32.dll WSAAsyncSelect

 6.2.5 'EXPORT': Exportando smbolos DLL

       La directiva especfica de formato 'EXPORT' define un smbolo global para
       que sea exportado como un smbolo DLL, para usar si ests escribiendo DLL
       en NASM. Todava necesitas declarar el smbolo como 'GLOBAL' as como
       usar la directiva 'EXPORT'.

       'EXPORT' requiere un argumento, que es el nombre del smbolo que deseas
       exportar, tal y como ha sido definido en tu fichero fuente. Un segundo
       parmetro opcional (separado del primero por espacios en blanco) da el
       nombre _externo_ del smbolo: el nombre con el que deseas que sea
       conocido por los programas que usen la DLL. Si este nombre es el mismo
       que el nombre interno, deberas dejarlo sin el segundo parmetro.

       Se pueden dar otros parmetros para definir los atributos del smbolo
       exportado. Estos parmetros, como el segundo, estn separados por
       espacios en blanco. Si se dan estos parmetros adicionales, el nombre
       externo se debe especificar tambin, incluso si el mismo que el interno.
       Los atributos disponibles son:

       (*) 'resident' indica que el nombre exportado es para que el cargador del
           sistema lo mantenga como residente. Esto es una optimizacin para los
           smbolos importados por nombre que se usan frecuentemente.

       (*) 'nodata' indica que el smbolo exportado es una funcin que no hace
           uso de ningn dato inicializado.

       (*) 'parm=NNN', donde 'NNN' es un entero, establece el nmero de palabras
           del parmetro para el caso que el smbolo sea una puerta de llamada
           entre segmentos de 32 y 16 bits.

       (*) Un atributo que simplemente sea un nmero indica que el smbolo
           debera exportarse con un nmero identificativo (ordinal), y de el
           nmero deseado.

       Por ejemplo:

                 export myfunc
                 export myfunc TheRealMoreFormalLookingFunctionName
                 export myfunc myfunc 1234  ; exporta por ordinal
                 export myfunc myfunc resident parm=23 nodata

 6.2.6 '..start': Definiendo el punto de entrada del programa

       Los enlazadores OMF requieren exactamente que uno de los fichero objeto
       que estn siendo enlazados defina el punto de entrada del programa, donde
       comenzar la ejecucin cuando sea ejecutado el programa. Si el fichero
       objeto que define el punto de entrada est ensamblado con NASM,
       especificas el punto de entrada usando el smbolo especial '..start' en
       el punto en que quieras que comience la ejecucin.

 6.2.7 Extensiones 'obj' de la directiva 'EXTERN'

       Si declaras un smbolo externo con la directiva

                 extern foo

       entonces, referencias como 'mov ax,foo' te darn el offset de 'foo' desde
       el segmento base prioritario (tal y como est especificado en cualquier
       mdulo en el que 'foo' haya sido definido). Por eso para acceder al
       contenido de 'foo' usualmente necesitars hacer algo como

                 mov ax,seg foo         ; coge el segmento base prioritario
                 mov es,ax              ; los mueve dentro de ES
                 mov ax,[es:foo]        ; y usa el offset 'foo' desde l

       Esto es poco manejable, particularmente si sabes que uno externo va a ser
       accesible desde un grupo o segmento dado, digamos 'dgroup'. Por eso, si
       'DS' ya contiene a 'dgroup', podras codificar simplemente

                 mov ax,[foo wrt dgroup]

       Sin embargo, tener que escribir esto cada vez que quieras acceder a 'foo'
       puede ser doloroso; por eso NASM te permite declarar 'foo' de la forma
       alternativa

                 extern foo:wrt dgroup

       Esta forma hace que NAMS pretenda que el segmento base prioritario de
       'foo' sea de hecho 'dgroup'; por eso la expresin 'seg foo' ahora
       devolver 'dgroup', y la expresin 'foo' es equivalente a
       'foo wrt dgroup'.

       Este mecanismo 'WRT' por defecto puede usarse para hacer que externos
       parezcan relativos a cualquier grupo o segmento en tu programa. Tambin
       pueden aplicarse a variables comunes: ver seccin 6.2.8.

 6.2.8 Extensiones 'obj' para la directiva 'COMMON'

       El fomato 'obj' permite que las variables comunes sean cercanas o
       lejanas; NASM te permite especificar cul deberan ser tus variables
       usando la sintaxis

                 common bearvar 2:near  ; 'nearvar' es una comn cercana
                 common farvar 10:far   ; y 'farvar' es lejana

       Las variables lejanas comunes pueden ser mayores en tamao que 64Kb, y
       por eso la especificacin OMF dice que son declaradas como un nmero de
       _elementos_ de un tamao dado. Por eso una variables lejana comn de
       10-bytes podra declararse como diez elementos de un byte, cinco
       elementos de dos bytes, dos elementos de diez bytes o uno de diez bytes.

       Algunos enlazadores OMF requieren el tamao del elemento, as como el
       tamao de la variable, para que coincida cuando se resuelvan las
       variables lejanas comunes declaradas en ms de un mdulo. Por lo tanto,
       NASM debe permitirte especificar el tamao del elemento en tus variables
       lejanas comunes. Esto se hace con la siguiente sintaxis:

                 common c_5by2 10:far 5 ; dos elementos de cinco bytes
                 common c_2by5 10:far 2 ; cinco elementos de dos bytes

       Si no se especifica el tamao del elemento, por defecto es 1. Tampoco se
       requiere la palabra clave 'FAR' cuando se especifica el tamao de un
       elemento, ya que slo las lejanas comunes deberan tener tamao de los
       elementos. Por eso, las declaraciones de arriba podran equivaler a

                 common c_5by2 10:5     ; dos elementos de cinco bytes
                 common c_2by5 10:2     ; cinco elementos de dos bytes

       Adicionalemte a estas extensiones, la directiva 'COMMON' en 'obj' tambin
       soporta la especificacin 'WRT' por defecto al igual que lo hace 'EXTERN'
       (explicado en la seccin 6.2.7). Por eso tambin puedes declarar las
       cosas como

                 common foo 10:wrt dgroup
                 common bar 16:far 2:wrt data
                 common baz 24:wrt data:6

   6.3 'win32': Ficheros objeto Win32 de Microsoft

       El formato de salida 'win32' genera ficheros objeto del Win32 de
       Microsoft, indicados para ser pasados a enlazadores de Microsoft como
       Visual C++. Ntese que los compiladores Win32 de Borland no usan este
       formato, sino que usan 'obj' en su lugar (ver seccin 6.2).

       'win32' proporciona una extensin por defecto para el fichero de salida
       que es '.obj'.

       Dse cuenta que aunque Microsoft dice que los ficheros objeto de Win32
       siguen el estndar COFF (Common Object File Format), los ficheros objeto
       producidos por los compiladores Win32 de Microsoft no son compatibles con
       los enlazadores COFF como DJGPP, y viceversa. Esto es debido a una
       diferencia de opinin sobre la semntica precisa de las recolocaciones
       relativas al PC. Para producir ficheros COFF apropiados para DJGPP, usa
       el formato de salida 'coff' del NASM; a la inversa, el formato 'coff' no
       produce ficheros objeto que los enlazadores Win32 puedan usar
       correctamente para generar una salida.

 6.3.1 Extensiones 'win32' para la directiva 'SECTION'

       Similar al formato 'obj', 'win32' te permite especificar informacin
       adicional en la lnea de la directiva 'SECTION', para controlar el tipo
       y las propiedades de las secciones que declares. Los tipos de seccin y
       las propiedades son generados automticamente por NASM para los nombres
       de secciones estndares '.text', '.data' y '.bss', pero an as, pueden
       ser superpuestos por estos calificadores.

       Los calificadores disponibles son:

       (*) 'code', o de manera equivalente 'text', define la seccin como una
           seccin de cdigo. Esto marca la seccin como legible y ejecutable,
           pero no como escribible, y tambin indica al enlazador que el tipo
           de la seccin es code.

       (*) 'data' y 'bss' definen la seccin como una seccin de datos,
           anlogamente a 'code'. Las secciones de datos estn marcadas como
           legibles y escribibles, pero no como ejecutables. 'data' declara una
           seccin de datos inicializados, mientras que 'bss' declara una
           seccin de datos no inicializados.

       (*) 'info' define la seccin como una seccin informativa, que no es
           incluida por el enlazador en el fichero ejecutable, pero podra (por
           ejemplo) pasar informacin _al_ enlazador. Por ejemplo, declarando
           una seccin del tipo 'info' llamada '.drectve' haces que el enlazador
           interprete el contenido de la seccin como opciones de la lnea de
           comandos.

       (*) 'align=', usado seguido de un nmero como en 'obj', da los
           requerimientos de alineamiento de la seccin. El mximo que puedes
           especificar es 64: el fichero objeto Win32 no contiene otra manera de
           pedir un mayor alineamiento de seccin que sta. Si el alineamiento
           no est especificado explcitamente, por defecto es una alineamiento
           de 16-bytes para la seccin de cdigo, y un alineamiento de 4-bytes
           para las secciones de datos (y BSS). Las secciones informativas
           tienen por defecto un alineamiento de 1 byte (sin alineamiento),
           aunque el valor no importa.

       Los valores por defecto asumidos por NASM si no especificas los
       calificadores de arriba son:

                 section .text code align=16
                 section .data data slign=4
                 section .bss bss align=4

       Cualquier otro nombre de seccin es tratado por defecto como '.text'.

   6.4 'coff': Common Object File Format

       El tipo de salida 'coff' produce ficheros objeto COFF apropiados para
       enlazar con el enlazador DJGPP.

       'coff' proporciona una extensin '.o' por defecto para el nombre del
       fichero de salida.

       El formato 'coff' soporta las mismas extensiones que la directiva
       'SECTION' al igual que lo hace 'win32', excepto que el calificador
       'align' y el tipo de seccin 'info' no estn implementadas.

   6.5 'elf': Ficheros objeto ELF de Linux

       El formato de salida 'elf' genera fichero objeto ELF32 (Executable and
       Linkable Format), como los usados por Linux. 'elf' proporciona una
       extensin '.o' por defecto para el nombre del fichero de salida.

 6.5.1 Extensiones 'elf' para la directiva 'SECTION'

       Al igual que el formato 'obj', 'elf' te permite especificar informacin
       adicional en la lnea de la directiva 'SECTION', para controlar el tipo
       y las propiedades de las secciones que declares. Los tipos de la seccin
       y las propiedades son generadas automticamente por NASM para las nombres
       de secciones estndar '.text', '.data' y '.bss', pero aun as pueden ser
       superpuestas por estos calificadores.

       Los calificadores disponibles son:

       (*) 'alloc' define la seccin para que sea una de las que son cargadas
           en memoria cuando se ejecuta el programa. 'noalloc' la define como
           las que no son cargadas al inicio, como puedan ser las secciones
           informativas o de comentarios.

       (*) 'ecex' define la seccin como una de las que tiene que tener permiso
           de ejecucin cuando se ejecuta el programa. 'noecex' la define como
           las que no lo necesitan.

       (*) 'write' define la seccin como una de las que deberan ser
           escribibles cuando se ejecuta el programa. 'nowrite' como las que no.

       (*) 'progbits' define la seccin como una de las que tiene contenido
           explcito almacenado en el fichero objeto: una seccin corriente de
           datos o de cdigo, por ejemplo, 'nobits' define la seccin como una
           que no tiene contenido dado explcitamente, como la seccin BSS.

       (*) 'align=' usado seguido de un nmero al igual que en 'obj', da los
           requerimientos del alineamiento de la seccin.

       Los valores por defecto asumidos por NASM si no especificas los
       calificadores de arriba son:

                 section .text progbits alloc   exec nowrite align=16
                 section .data progbits alloc noexec   write align=4
                 section .bss    nobits alloc noexec   write align=4
                 section other progbits alloc noexec nowrite align=1

       (Cualquier otro nombre de seccin que no sea '.text', '.data' o '.bss'
       es tratado por defecto como 'other' en el cdigo de arriba.)

 6.5.2 Cdigo independiente de la posicin: Smbolos 'elf' especiales y 'WRT'

       La especificacin ELF contiene suficientes caractersticas para permitir
       escribir cdigo independiente de la posicin (PIC), lo que hace muy
       flexibles las bibliotecas compartidas de ELF. Sin emabargo, esto tambin
       quiere decir que NASM tiene que ser capaz de generar una variedad de
       tipos de recolocacin extraos en los ficheros objeto ELF, si quiere ser
       un ensamblador que pueda escribir PIC.

       Ya que ELF no soporta referencias al segmento base, el operador 'WRT' no
       se usa para se propsito normal; por lo tanto el formato de salida 'elf'
       de NASM hace un uso de 'WRT' para un propsito diferente, a saber, los
       tipos especficos de la relocalizacin PIC.

       'elf' define cinco smbolos espciales que puedes usar en el lado derecho
       del operador 'WRT' para obtener tipos de relocalizacin PCI. Estos son
       '..gotpc', '..gotoff', '..got', '..plt' y '..sym'. Sus funciones estn
       resumidas aqu:

       (*) Refirindose al smbolo que marca la base de la tabla global de
           offset, usando 'wrt ..gotpc' terminar dndonos la distancia desde el
           principio de la seccin actual hasta la tabla global de offset.
           ('_GLOBAL_OFFSET_TABLE_' es el nombre estndar de smbolo referido
           comnmente como GOT.) Por eso, deberas entonces necesitar aadir
           '$$'' al resultado para recibir la direccin real del GOT.

       (*) Refirindose a una posicin en una de tus propias secciones, usando
           'wrt ..gotoff' te dar la distancia desde el principio del GOT hasta
           la posicin especificada, por eso, esto aadido a la direccin del
           GOT nos dara la direccin real del la posicin que quieres.

       (*) Refirindose a un smbolo externo o global, usando 'wrt ..got' hace
           que el enlazador construya una entrada _en_ el GOT que contenga la
           direccin del smbolo, y la referencia da la distancia desde el
           principio del GOT hasta la entrada; por eso puedes aadir la
           direccin del GOT, cargar desde la direccin resultante, y terminar
           en la direccin del smbolo.

       (*) Refirindose a un nombre de procedimiento, usando 'wrt ..plt' hace
           que el enlazador construya para el smbolo una entrada en la tabla de
           enlazamiento de procedimientos, y las referencias den la direccin
           de la entrada a la PLT. Slo puedes usar esto en contextos que
           pudiesen generar una relocalizacin relativa al PC de manera normal
           (esto es, como el destino de un 'CALL' o un 'JMP'), ya que ELF no
           contiene en absoluto ningn tipo de relocalizacin para referirse
           a la PLT.

       (*) Refirindose a un nombre de smbolo, usando 'wrt ..sym' hace que
           NASM escriba una relocalizacin normal, pero en lugar de hacer la
           relocalizacin relativa al principio de la seccin y luego aadir
           el offset del smbolo, escribir un 'record' de relocalizacin
           apuntando directamente al smbolo en cuestin. Esta distincin es
           necesario debido a una peculiaridad del enlazador dinmico.

       Una explicacin ms completa de cmo usar estos tipos de relocalizaciones
       para escribir completamente en NASM bibliotecas compartidas est en la
       seccin 8.2.

 6.5.3 Extensiones 'elf' para la directiva 'GLOBAL'

       Los ficheros objeto ELF pueden contener ms informacin de un smbolo
       global adems de su direccin: pueden contener el tamao del smbolo as
       como su tipo. No son slo convenientes para la depuracin, sino que son
       actualmente necesarios cuando el programa que se est escribiendo es una
       biblioteca compartida. NASM por lo tanto soporta algunas extensiones para
       la directiva 'GLOBAL', permitindote especificar estas caractersticas.

       Puedes especificar si una variable global es una funcin o datos poniendo
       como sufijo el nombre con dos puntos y la palabra 'function' o 'data'.
       ('object' es un sinnimo de 'data'.) Por ejemplo:

                 global hashlookup:function, hashtable:data

       exporta el smbolo global 'hashlookup' como una funcin y 'hashtable'
       como un dato.

       Tambin puedes especificar el tamao del dato asociado con el smbolo,
       como una expresin numrica (que podra involucrar etiquetas, e incluso
       referencias ms adelante) despus del espcificador de tipo. Como ste:

                 global hashtable:data (hashtable.end - hashtable)
       hashtable:
                 db this,that,theother  ; aqu algunos datos
       .end:

       Esto hace que NASM calcule automticamente la longitud de la tabla y
       coloque la informacin dentro de la tabla de smbolos ELF.

       Es necesario declarar el tipo y el tamao de los smbolos globales cuando
       escribes cdigo de bibliotecas compartidas. Para ver ms informacin, ver
       la seccin 8.2.4.

 6.5.4 Extensiones 'elf' para la directiva 'COMMON'

       ELF tambin te permite especificar los requerimientos de alineamiento en
       las variables comunes. Esto se hace poniendo un nmero (que debe ser una
       potencia de dos) despus del nombre y el tamao de la variable comn,
       separado (como siempre) por dos puntos. Por ejemplo, un array de palabras
       dobles (doubleword) se beneficiara de un alineamiento de 4-bytes:

                 common dwordarray 128:4

       Esto declara el tamao total del array en 128 bytes, y requiere que est
       alineado con un lmite de 4-bytes.

   6.6 'aout': Ficheros objeto 'a.out' de Linux

       El formato 'aout' genera ficheros objeto 'a.out', de la forma usado por
       los primeros sistemas Linux. (Estos difieren de los otros ficheros objeto
       'a.out' en que el nmero mgico en los primeros cuatro bytes es
       diferente. Tambin, algunas implementaciones de 'a.out', por ejemplo las
       de NetBSD, proporcionana cdigo independiente de la posicin, el cual la
       implementacin de Linux no soporta.)

       'a.out' proporciona una extensin '.o' por defecto para los nombres de
       sus ficheros de salida.

       'a.out' es un formato objeto muy sencillo. No soporta directivas
       especiales, ni smbolos especiales, no usa 'SEG' ni 'WRT', y no tiene
       extensiones de ninguna directiva estndar. Slo soporta los tres nombres
       de seccin estndar '.text', '.data' y '.bss'.

   6.7 'aoutb': Ficheros objeto 'a.out' de NetBSD/FreeBSD/OpenBSD

       El formato 'aoutb' genera ficheros objeto 'a.out', de la manera a la
       usada por varios clnicos gratuitos de BSD Unix, NetBSD, FreeBSD y
       OpenBSD. Para los ficheros objeto simples, este formato objeto es
       exactamente el mismo que 'aout' excepto para el nmero mgico en los
       primero cuatro bytes del fichero. Sin embargo, el formato 'aoutb'
       soporta cdigo independiente de la posicin del mismo modo que el formato
       'elf', por eso puedes usarlo para escribir bibliotecas BSD compartidas.

       'aoutb' proporciona una extensin '.o' por defecto para los nombres de
       sus ficheros de salida.

       'aoutb' no soporta directivas especiales, ni smbolos especiales, y slo
       los tres nombres estndar de seccin '.text', '.data' y '.bss'. Sin
       embargo, tambin soporta el mismo uso de 'WRT' que hace 'elf', para
       proporcionar tipos de relocalizacin de cdigo independiente de la
       posicin. Ver la seccin 6.5.2 para una documentacin completa de esta
       caracterstica.

       'aoutb' tambin soporta las mismas extensiones para la directiva 'GLOBAL'
       que 'elf': ver la seccin 6.5.3 para la documentacin de esto.

   6.8 'as86': Ficheros objeto 'as86' de Linux

       El ensamblador de Linux de 16-bit 'as86' tiene su propio formato no
       estndar de ficheros objeto. Aunque su enlazador compaero 'ld86' produce
       como salida algo cercano a un binario 'a.out', el formato del fichero
       objeto usado para comunicarse entre 'as86' y 'ld86' no es en s mismo un
       'a.out'.

       NASM soporta este formato, slo en caso de que sea necesario, como
       'as86'. 'as86' proporciona la extensin '.o' por defecto para el nombre
       del fichero de salida.

       'as86' es un formato objeto muy sencillo (desde el punto de vista del
       usuario de NASM). No soporta directivas especiales, ni smbolos
       especiales, no usa 'SEG' ni 'WRT', y no tiene extensiones para ninguna
       directiva estndar. Slo soporta los tres nombre de seccin estndar
       '.text', '.data' y '.bss'.

   6.9 'rdf': Formato de ficheros objeto dinmicos recolocables

       El formato de salida 'rdf' produce ficheros objeto RDOFF. RDOFF
       (Relocatable Dynamic Object File Format) es el formato de ficheros objeto
       propio, diseado al lado de NASM y reflejando en el propio formato de
       fichero la estructura interna del ensamblador.

       Ningn sistema operativo bien conocido usa RDOFF. Estos escriben sus
       propios sistemas, sin embargo, bien podran desear usar RDOFF como su
       formato objeto, en la base que est diseado principalmente en busca de
       simplicidad y contiene muy poca burocracia en las cabeceras de fichero.

       Tanto el paquete NASM de Unix, y el de DOS que incluye los fuentes,
       contienen un subdirectorio 'rdoff' que tiene un conjunto de utilidad de
       RDOFF: un enlazador RDF, un gestor de bibliotecas RDF estticas, una
       utilidad de volcado de ficheros RDF, y un programa que cargar y
       ejecutar un ejecutable RDF bajo Linux.

       'rdf' slo soporta los nombres de seccin estndar '.text', '.data' y
       '.bss'.

 6.9.1 Requiriendo una biblioteca: La directiva 'LIBRARY'

       RDOFF contiene un mecanismo por el que un fichero objeto puede pedir que
       se enlace una biblioteca a un mdulo, ya sea en tiempo de carga o de
       ejecucin. Esto se hace con la directiva 'LIBRARY', que recibe un
       argumento que es el nombre del mdulo:

                 library mylib.rdl

  6.10 'dbg': Formato de depuracin

       El formato de salida 'dbg' no est construido en NASM en la configuracin
       por defecto. Si ests construyendo tus propios ejecutables NASM desde los
       fuentes, puedes definir 'OF_DBG' en 'outform.h' en la lnea de comandos
       del compilador, y obtener el formato de salida 'dbg'.

       El formato de salida no saca un fichero objeto tal cual; en su lugar,
       saca un fichero de texto que contiene una lista completa de todas las
       transaccciones entre el cuerpo principal de NASM y el mdulo del formato
       de salida. Est principalmente para ayudar a la gente que quiere escribir
       sus propios controladoresde salida, as pueden recibir una idea ms clara
       de las distintas peticiones que hace el programa principal al controlador
       de salida, y en qu orden suceden.

       Para ficheros sencillos, uno puede fcilmente usar el formato 'dbg' tal
       como ste:

       nasm -f dbg filename.asm

       que generar un fichero de diagnstico llamado 'filename.dbg'. Sin
       embargo, esto no funcionar bien en ficheros que hayan sido diseados
       para una formato objeto diferente, porque cada formato objeto define sus
       propias macros (normalmente formas de directivas a nivel de usuario), y
       estas macros no sern definidas en el formato 'dbg'. Por lo tanto, puede
       ser til ejecutar NASM dos veces, para hacer el preprocesado con el
       formato objeto nativo seleccionado:

       nasm -e -f rdf -o rdfprog.i rdfprog.asm
       nasm -a -f dbg rdfprog.i

       Esto preprocesa 'rdfprog.asm' en 'rdfprog.i', manteniendo el formato
       objeto 'rdf' seleccionado para asegurarse de que las directivas
       especiales son convertidas en su forma primitiva de forma correcta.
       Entonces el fuente preprocesado es alimentado a travs del formato 'dbg'
       para generar la definitiva salida del diagnstico.

       Esta forma de actuar tpicamente no funcionar para los programas que
       se deseen en el formato 'obj', porque las directivas 'SEGMENT' y 'GROUP'
       del 'obj' tienen el efecto lateral de definir los nombres del segmento y
       el grupo como smbolos; 'dbg' no har esto, por eso el programa no se
       ensamblar. Tendrs que trabajar en esto definiendo los smbolos por ti
       mismo (usando 'EXTERN', por ejemplo) si realmente necesitas un 'dbg' para
       seguir la pista de un fichero fuente 'obj' especfico.

       'dbg' acepta cualquier nombre de seccin y cualquier directiva, y toma
       nota en el fichero de salida.

Captulo 7: Escribiendo cdigo 16-bit (DOS, Windows 3/3.1)
----------------------------------------------------------

       Este captulo intenta cubrir algunas de las cuestiones comunes que se
       encuentran cuando se escribe cdigo de 16-bit para ejecutar bajo MS-DOS
       o Windows 3.x. Cubre cmo enlazar programas para producir ficheros '.EXE'
       o '.COM', cmo escribir controladores de dispositivos '.SYS', y cmo
       juntar cdigo en lenguaje ensamblador con compilador de C de 16-bit y
       con Borland Pascal.

   7.1 Produciendo ficheros '.EXE'

       Cualquier programa grande escrito bajo DOS necesita construirse como un
       fichero '.EXE': slo los ficheros '.EXE' tiene la estructura interna
       necesaria requerida para extenderse ms all del segmento de 64K. Los
       programas Windows, tambin, han de construirse como ficheros '.EXE', ya
       que Windows no soporta el formato '.COM'.

       En general, generas ficheros '.EXE' usando el formato objeto 'obj' para
       producir uno o ms ficheros '.OBJ', y luego los enlazas usando un
       enlazador. Sin embargo, NASM tambin soporta la generacin directa de
       ficheros '.EXE' simples del DOS usando el formato de salida 'bin' (usando
       'DB' y 'DW' para construir la cabecera del fichero '.EXE'), y para ello
       se proporciona un paquete de macros. Gracias a Yann Guidon por contribuir
       al cdigo con esto.

       NASM tambin podra soportar en futuras versiones '.EXE' de forma nativa.

 7.1.1 Usando el formato 'obj' para generar ficheros '.EXE'

       Esta seccin describe el mtodo usual de generar ficheros '.EXE'
       enlazando juntos ficheros '.OBJ'.

       La mayora de los paquetes de lenguajes de programacin de 16-bit vienen
       con un enlazador adecuado; si no tienes ninguno de estos, hay un
       enlazador gratuito llamado VAL, disponible comprimido en formato 'LZH'
       desde 'x2ftp.oulu.fi'. Un compresor LZH se puede encontrar en
       'ftp.simtel.net'. Hay otro enlazador 'gratuito' (aunque este viene sin
       los fuentes) llamado FREELINK, disponible en 'www.pcorner.com'. Un
       tercero, 'djlink', escrito por DJ Delorie, est disponible en
       'www.delorie.com'.

       Cuando enlaces varios ficheros '.OBJ' en un fichero '.EXE', deberas
       asegurarte de que exactamente uno de ellos tiene definido un punto de
       comienzo (usando el smbolo especial '..start' definido en el formato
       'obj': ver la seccin 6.2.6). Si ningn mdulo define el punto de
       comienzo, el enlazador no sabr qu valor dar en el campo de punto de
       entrada en la cabecera del fichero de salida; si ms de uno define un
       punto de comienzo, el enlazador no sabr _qu_ valor usar.

       Un ejemplo de fichero fuente NASM que puede ensamblarse a un fichero
       '.OBJ' y enlazarlo solo a un '.EXE' viene a continuacin. Demuestra los
       principios bsicos para definir una pila, inicializar los registros de
       segmento, y declarar un punto de comienzo. El fichero se proporciona
       tambin en el subdirectorio 'test' del archivo NASM, bajo el nombre
       'objexe.asm'.

                 segment code

       ..start:  mov ax.data
                 mov ds.ax
                 mov ax,stack
                 mov ss.ax
                 mov sp,stacktop

       Este trozo de cdigo inicial prepara 'DS' para apuntar al segmento de
       datos, e inicializa 'SS' y 'SP' para apuntar a la parte de arriba de la
       pila proporcionada. Ntese que las interrupciones estn deshabilitadas de
       forma implcita por una instruccin despus de un 'mov' a 'SS',
       precisamente por esta situacin, es por eso que no hay oportunidad de que
       ocurra una interrupcin entre la carga de 'SS' y 'SP' y no tenga una pila
       sobra la que ejecutarse.

       Ntese tambin que el smbolo especial '..start' est definido al
       principio de este cdigo, lo que significa que ser el punto de entrada
       en el fichero ejecutable resultante.

                 mov dx,hello
                 mov ah,9
                 int 0x21

       Lo de arriba es el programa principal: carga 'DS:DX' con un puntero al
       mensaje de saludo ('hello' es de forma implcita relativo al segmento
       'data', que fue cargado en 'DS' en el cdigo de inicializacin, por eso
       todo el puntero es vlido), y llama a la funcin imprimir cadena del DOS.

                 mov ax,0x4c00
                 int 0x21

       Esto termina el programa usando otra llamada de sistema del DOS.

                 segment data
       hello:    db 'hello, world', 13, 10, '$'

       El segmento de datos contiene la cadena que queremos mostrar.

                 segment stack stack
                 resb 64
       stacktop:

       El cdigo de arriba declara un segmento de pila que contiene 64 bytes de
       espacio de pila no inicializado, y apunta 'stacktop' a la parte superior
       de ella. La directiva 'segment stack stack' define un segmento _llamado_
       'stack', y tambin de _tipo_ 'STACK'. Lo siguiente no es necesario para
       la ejecucin correcta del programa, pero los enlazadores suelen emitir
       avisos y errores si tu programa no tiene segmento de tipo 'STACK'.

       El fichero de arriba, cuando se ensambla en un fichero '.OBJ', enlazar
       por si solo un fichero '.EXE' vlido, que cuando se ejecute imprimir
       'hello, world' y saldr.

 7.1.2 Usando el formato 'bin' para generar ficheros '.EXE'

       El formato de fichero '.EXE' es lo suficientemente simple como para
       construir un fichero '.EXE' escribiendo un programa binario puro y
       pegndole delante una cabecera de 32-bytes. Esta cabecera es lo
       suficientemente sencilla que NASM puede generarla por s mismo usando los
       comandos 'DB' y 'DW', por eso puedes usar el formato de salida 'bin' para
       generar directamente los ficheros '.EXE'.

       Incluido en el archivo NASM, en el subdirectorio 'misc', est un fichero
       'exebin.mac' de macros. Define tres macros: 'EXE_begin', 'EXE_stack' y
       'EXE_end'.

       Para producir un fichero '.EXE' usando este mtodo, deberas empezar por
       usar '%include' para cargar el paquete de macros 'exebin.mac' en tu
       fichero fuente. Deberas luego hace una llamada a la macro 'EXE_begin'
       (que no recibe argumentos) para generar los datos de la cabecera del
       fichero. Luego escribir el cdigo como siempre para el formato 'bin' -
       puedes usar las tres secciones estndar '.text', '.data' y '.bss'. Al
       final del fichero deberas llamar a la macro 'EXE_end' (nuevamente, sin
       argumentos), que define algunos smbolos para marcar los tamaos de las
       secciones, y estos smbolos estn referidos en el cdigo de cabecera
       generado por 'EXE_begin'.

       En este modelo, el cdigo que acabas de escribir comienza en '0x100', al
       igual que un fichero '.COM' - de hecho, si eliminas los 32-bytes de
       cabecera del fichero '.EXE' resultante, tendras un programa '.COM'
       vlido. Todas las bases de segmentos son las mismas, por eso ests
       limitado a un programa de 64K, nuevamente al igual que un fichero '.COM'.
       Ntese que la macro 'EXE_begin' emite una directiva 'ORG', por eso t no
       deberas hacer explcitamente una.

       No puedes referirte directamente al valor de tu segmento base,
       desafortunadamente, ya que esto requerira una recolocacin en la
       cabecera, y las cosas se podran hacer mucho ms complicadas. Por eso
       deberas en su lugar coger tu segmento base copiando 'CS'.

       En la entrada a tu fichero '.EXE', 'SS:SP' estn ya preparadas para
       apuntar al principio de la pila de 2K. Puedes ajustar el tamao de 2K por
       defecto de la pila llamando a la macro 'EXE_stack'. Por ejemplo, para
       cambiar el tamao de la pila de tu programa a 64 bytes, llamaras a
       'EXE_stack 64'.

       Un programa de ejemplo que genera un fichero '.EXE' de esta forma est en
       el subdirectorio 'test' del archivo NASM, como 'binexe.asm'.

   7.2 Produciendo ficheros '.COM'

       Mientras que los programas grandes de DOS han de escribirse como ficheros
       '.EXE', los pequeos, a menudo, mejor se escriben como ficheros '.COM'.
       Los ficheros '.COM' son binario puro, y por lo tanto se producen mucho
       ms fcilmente usando el formato de salida 'bin'.

 7.2.1 Usando el formato 'bin' para generar ficheros '.COM'

       Los ficheros '.COM' se espera que se carguen en el offset '100h' en su
       segmento (aunque el segmento pueda cambiar). Le ejecucin entonces
       comienza en '100h', esto es, a la derecha del comienzo del programa. Por
       eso para escribir un programa '.COM', deberas crear un fichero fuente
       parecido a ste

                 org 100h
                 section .text
       start:    ; pon aqu tu cdigo
                 section .data
                 ; pon aqu los datos
                 section .bss
                 ; pon aqu los datos no inicializados

       El formato 'bin' pone en el fichero primero la seccin '.text', por eso
       si quieres puedes declarar los data y BSS antes de empezar a escribir
       cdigo y el cdigo todava ir a parar delante del fichero al que
       pertenezca.

       La seccin BBS (datos no inicializados) no ocupa espacio en el fichero
       '.COM' por s misma: en su lugar, los direccionamientos a objetos del BSS
       se resuelven apuntando al espacio ms all del final del fichero, al
       principio de lo que ser memoria libre cuando se ejecute el programa. Por
       lo tanto, no deberas confiar en que tu BSS sea inicializado todo a ceros
       cuando los ejecutes.

       Para ensamblar el programa de arriba, deberas usar una lnea de comandos
       como

       nasm myprog.asm -fbin -o myprog.com

       El formato 'bin' producira un fichero llamado 'myprog' si no se
       especifica explcitamente un nombre para el fichero de salida, por eso
       debers eliminarlo dando el nombre de fichero deseado.

 7.2.2 Usando el formato 'obj' para generar ficheros '.COM'

       Si ests escribiendo un programa '.COM' como ms de un mdulo, podras
       queres ensamblar varios ficheros '.OBJ' y enlazarlos juntos en un
       programa '.COM'. Puedes hacerlo, siempre que tengas un enlazador capaz de
       crear ficheros '.COM' directamente (TLINK lo hace), o alternativamente
       un programa convertidor como 'EXE2BIN' para transformar un fichero de
       salida '.EXE' del enlazador a un fichero '.COM'.

       Si haces esto, debes tener en cuenta varias cosas:

       (*) El primer fichero objeto que contiene el cdigo debera empezar
           su segmento de cdigo con una lnea como 'RESB 100h'. Esto es para
           asegurar que el cdigo empieza en el offset '100h' relativo al
           principio del segmento de cdigo, as el enlazador o el programa
           convertidor no tiene que ajustar las referencias de direccin dentro
           del fichero '.COM' cuando se genere. Otros ensambladores usan para
           este propsito una directiva 'ORG', pero 'ORG' en NASM es una
           directiva especfica del formato del salida 'bin', y no quiere decir
           lo mismo que en los ensambladores compatibles con MASM.

       (*) No necesitas definir el segmento de pila.

       (*) Todos tus segmentos deberan estar en el mismo grupo, por eso cada
           vez que tu cdigo o tus datos referencien un offset de un smbolo,
           todos los offsets son relativos al mismo segmento base. Esto es
           debido a que cuando es cargado un fichero '.COM', todos los registros
           de segmento contienen el mismo valor.

   7.3 Produciendo ficheros '.SYS'

       Los controladores de dispositivos de MS-DOS - ficheros '.SYS' - son
       binario puro, parecido a los ficheros '.COM', excepto que empiezan en el
       origen cero en lugar del '100h'. As pues, si ests escribiendo un
       controlador de dispositivo usando el formato 'bin', no necesitas la
       directiva 'ORG', ya que el origen por defecto para 'bin' es cero. De
       forma parecida, si ests usando 'obj' no necesitas el 'RESB 100h' al
       principio de tu segmento de cdigo.

       Los fichero '.SYS' comienzan con una estructura de cabecera, que contiene
       punteros a diversas rutinas dentro del controlador que son las que hacen
       el trabajo. Esta estructura debera definirse al comienzo del segmento de
       cdigo, aunque realmente no sea cdigo.

       Para ver ms informacin del formato de los ficheros '.SYS', y de los
       datos que deben ir en la cabecera, se da una lista de libros en la lista
       de preguntas frecuentemente realizadas (FAQ) para el grupo de noticias
       'comp.os.msdos.programmer'.

   7.4 Interactuando con programas en C de 16-bits

       Esta seccin cubre los principios bsicos para escribir rutinas en
       ensamblador que llamen, o sean llamadas desde, programas en C. Para esto,
       tpicamente deberas escribir un mdulo en ensamblador como un fichero
       '.OBJ', y enlazarlo con tus mdulos de C para producir un programa en
       lenguajes mezclados.

 7.4.1 Nombres de smbolos externos

       Los compiladores de C tienen el convenio de que los nombres de todos sus
       smbolos globales (funciones o datos) que definan estn formados
       precediendo un subrayado al nombre tal cual aparece en el programa C. Por
       eso, por ejemplo, la funcin que el programador de C conoce como 'printf'
       aparece para el programador en ensamblador como '_printf'. Esto quiere
       decir que en tus programas en ensamblador, puedes definir smbolos sin
       el subrayado precedente y as no preocuparte de si el nombre entra en
       conflicto con algn smbolo de C.

       Si encuentras incovenientes los subrayados, puedes definir macros para
       reemplazar las directivas 'GLOBAL' y 'EXTERN' como sigue:

       %macro cglobal 1
                 global _%1
       %define %1 _%1
       %endmacro

       %macro cextern 1
                 extern _%1
       %define %1 _%1
       %endmacro

       (Estas formas de las macros slo reciben un argumento cada vez; una
       construccin '%rep' podra resolver esto.)

       Si entonces declaras una externa como sta:

                 cextern printf

       entonces la macro se expandir como

                 extern _printf
       %define printf _printf

       Despus, te puedes referir a 'printf' como si fuese un smbolo, y el
       preprocesador pondr el subrayado precedente all donde sea necesario.

       La macro 'cglobal' funciona de forma similar. Debes usar 'cglobal' antes
       de definir el smbolo en cuestin, aunque tendras que hacer esto de
       todas formas si usases 'GLOBAL'.

 7.4.2 Modelos de memoria

       NASM no contiene ningn mecanismo para soportar directamente los
       diferentes modelos de memoria de C; debers recordar por ti mismo para
       cul ests escribiendo. Esto quiere decir que debers recordar las
       siguientes cosas:

       (*) En modelos que usen un simple segmento de cdigo (tiny, small y
           compact), las funciones son cercanas. Lo que significa que los
           punteros a funciones, cuando se almacenan en segmentos de datos o
           son empujados a la pila como argumentos de una funcin, son de 16-bit
           y slo contienen un campo de offset (el registro 'CS' nunca cambia
           su valor, y siempre da la parte el segmento en la direccin completa
           de la funcin), y estas funciones se llaman usando la instruccin
           cercana 'CALL' normal y vuelve usando 'RETN' (la cual, en NASM, es
           sinnimo de 'RET' de todas formas). Esto quiere decir que debers
           escribir tus propias rutinas para volver con un 'RETN', y que
           deberas llamar a las rutinas C externas con instrucciones 'CALL'
           cercanas.

       (*) En los modelos que usen ms de un segmento de cdigo (medium, large y
           huge), las funciones son lejanas. Esto significa que los punteros de
           funcin son de 32-bits (que consisten en un offset de 16-bit seguido
           de un segmento de 16-bit), y estas funciones se llaman usando
           'CALL FAR' (o 'CALL seg:offset) y vuelven usando 'RETF'. Nuevamente,
           deberas por lo tanto escribir tus propias rutinas para volver con
           'RETF' y usar 'CALL FAR' para llamar a rutinas externas.

       (*) En los modelos que usen un solo segmento de datos (tiny, small y
           medium), los punteros de datos son de 16-bits, y contiene slo un
           campo de offset (el registro 'DS' no cambia su valor, y siempre da
           la parte del segmento de la direccin completa del dato).

       (*) En los modelos que usen ms de un segmento de datos (compact, large
           y huge), los punteros de datos son de 32-bit, y consisten en un
           offset de 16-bit seguido de un segmento de 16-bit. Deberas tener
           cuidado de no modificar 'DS' en tus rutinas sin restaurarlo despus
           a la vuelta, aunque 'ES' est libre para ti para que lo uses para
           acceder al contenido de los punteros de 32-bit a datos que pases.

       (*) El modelo de memoria huge permite a los datos simples exceder el
           tamao de 64K. En todos los dems modelos, puedes acceder a la
           totalidad de un dato haciendo simplemente aritmtica sobre el campo
           de offset del puntero que ests dando, si est presente un campo de
           segmento o no; en el modelo huge, debes ser ms cuidadoso en tu
           aritmtica de punteros.

       (*) En la mayora de los modelos de memoria, hay un segmento de datos
           _por defecto_, aquellos cuya direccin de segmento se guarde en 'DS'
           durante todo el programa. Este segmento de datos es normalmente el
           mismo segmento que la pila, guardado en 'SS', por eso estas variables
           locales de funciones (que estn guardadas en la pila) y los datos
           globales pueden accederse fcilmente sin cambiar 'DS'. En particular
           los datos grandes se suelen guardar en otros segmentos. Sin embargo,
           algunos modelos de memoria (aunque normalmente no los estndar)
           permiten que se asuma que 'SS' y 'DS' guardan el mismo valor para
           ser borrado. Ten cuidado en este ltimo caso con las variables
           locales de las funciones.

       En los modelos con un solo segmento de cdigo, el segmento se llama
       '_TEXT', por eso tu segmento de cdigo debe ir con este mismo nombre
       para que sea enlazado en el mismo lugar que el segmento de cdigo
       principal. En los modelos con solo segmento de datos, o con un segmento
       de datos por defecto, se llama '_DATA'.

 7.4.3 Definiciones de funciones y llamadas a las funciones

       El convenio de llamadas de C en los programas de 16-bits es el que sigue.
       En la siguiente descripcin, las palabras _llamante_ y _llamado_ se usan
       para denotar la funcin que hace la llamada y la que la recibe.

       (*) El llamante empuja los parmetros de la funcin a la pila, uno tras
           otro, en orden inverso (de derecha a izquierda, por eso el primer
           argumento especificado a la funcin es empujado el ltimo).

       (*) El llamante entonces ejecuta una instruccin 'CALL' para pasarle el
           control al llamado. Este 'CALL' puede ser cercano o lejano
           dependiendo del modelo de memoria.

       (*) El llamado recibe el control, y normalmente (aunque realmente no es
           necesario, en funciones que no necesitan acceder a sus parmetros)
           comienza salvando el valor de 'SP' en 'BP' para ser capaz de usar
           'BP' como puntero base para encontrar sus parmetros en la pila. Sin
           embargo, el llamante estuvo haciendo esto tambin, por eso, parte
           del convenio de llamadas dictamina que 'BP' debe conservarse por
           cualquier funcin de C. Por lo tanto el llamado, si va a establecer
           'BP' como _puntero de marco_, debe empujar a la pila previamente el
           valor que contiene.

       (*) El llamado podra entonces acceder a sus parmetros relativo a 'BP'.
           La palabra en '[BP]' contiene el valor previo de 'BP' segn fue
           empujado a la pila; la siguiente palabra, en '[BP+2]', contiene la
           parte del offset de la direccin de retorno, empujada implcitamente
           por 'CALL'. En una funcin (cercana) del modelo small, los
           parmetros comienzan despus de esto, en '[BP+4]'; en una funcin
           (lejana) del modelo large, la parte del segmento de la direccin de
           retorno est en '[BP+4]', y los parmetros comienzan en '[BP+6]'.
           El parmetro ms a la izquierda de la funcin, ya que fue empujado el
           ltimo, est accesible en este offset desde 'BP'; los dems siguen
           en los sucesivos offsets cada vez mayores. As, en una funcin como
           'printf' que recibe un nmero variable de parmetros, el empujar
           parmetros en el orden inverso quiere decir que la funcin conoce
           dnde encontrar el primer parmetro, que le dice el nmero y tipo de
           los restantes.

       (*) El llamado podra tambin desear el decrementar 'SP' ms adelante,
           as como para asignar espacio en la pila para las variables locales,
           que sern accesibles en offsets negativos desde 'BP'.

       (*) El llamado, si quiere devolver un valor al llamante, debera dejar
           el valor en 'AL', 'AX' o 'DX:AX' dependiendo del tamao del valor.
           Los resultados en coma flotante son a veces (dependiendo del
           compilador) devueltos en 'ST0'.

       (*) Una vez el llamado ha terminado de procesar, restaura 'SP' desde 'BP'
           si ha asignado espacio de la pila local, entonces saca el valor
           previo de 'BP', y regresa va 'RETN' o 'RETF' dependiendo del modelo
           de memoria.

       (*) Cuando el llamante retoma el control desde el llamado, los parmetros
           de la funcin estn todava en la pila, por eso tpicamente aade una
           constante inmediata a 'SP' para eliminarlos (en lugar de ejecutar un
           nmero de las lentas instrucciones 'POP'). As, si se llama
           accidentalmente a una funcin con un nmero errneo de parmetros
           debido a un error del prototipo, la pila todava ser devuelta a un
           estado correcto ya que el llamante, que _conoce_ cuntos parmetros
           empuj, hace le eliminacin.

       Es instructivo comparar este convenio de llamadas con el de los programas
       en Pascal (descrito en la seccin 7.5.1). Pascal tiene un convenio
       simple, ya que las funcionen no tienen un nmero variable de parmetros.
       Por lo tanto el llamado conoce cuntos parmetros deberan pasrsele, y
       es capaz de desasignarlos de la pila por s mismo pasando un argumento
       inmediato a la instruccin 'RET' o 'RETF', por eso el llamante no tiene
       que hacerlo. Tambin, los parmetros son empujados en orden de izquierda
       a derecha, no de derecha a izquierda, lo que significa que un compilador
       puede dar mayores garantas en la secuencia de puntos sin que sufra el
       rendimiento.

       Por eso, deberas definir una funcin en el estilo de C de la siguiente
       forma. El siguiente ejemplo es para el modelo small:

                 global _myfunc
       _myfunc:  push bp
                 mov bp,sp
                 sub sp,0x40            ; 64 bytes de espacio de la pila local
                 mov bx,[bp+4]          ; primer parmetro de la funcin
                 ; algo ms de cdigo
                 mov sp,bp              ; deshace el "sub sp,0x40" de arriba
                 pop bp
                 ret

       Para una funcin en un modelo large, deberas sustituir 'RET' por 'RETF',
       y buscar el primer parmetro en '[BP+6]' en lugar de '[BP+4]'. Por
       supuesto, si uno de los parmetros es un puntero, entonces los offsets
       de los parmetros subsiguientes cambiarn dependiendo tambin del modelo
       de memoria: los punteros lejanos ocupan cuatro bytes en la pila cuando
       son pasados como parmetros, por el contrario los punteros cercanos
       ocupan dos bytes.

       En el otro extremo del proceso, para llamar a una funcin C desde tu
       cdigo ensamblador, deberas hacer algo como esto:

                 extern _printf
                 ; y luego, ms abajo...
                 push word [myint]      ; una de mis variables enteras
                 push word mystring     ; puntero en mi segmento de datos
                 call _printf
                 add sp,byte 4          ; 'byte' salva espacio
                 ; luego estos datos
                 segment _DATA
       myint     dw 1234
       mystring  db 'This number -> %d <- should be 1234',10,0

       Este trozo de cdigo es el equivalente en el modelo small del ensamblador
       al cdigo C

           int myint = 1234;
           printf("This number -> %d <- should be 1234\n", myint);

       En el modelo large, el cdigo de la llamada a la funcin podra parecerse
       ms a ste. En este ejemplo, se asume que 'DS' ya contiene el segmento
       base del segmento '_DATA'. Si no, deberas inicializarlo antes.

                 push word [myint]
                 push word seg mystring ; Ahora empuja el segmento, y...
                 push word mystring     ; ... el offset de "mystring"
                 call far _printf
                 add sp,byte 6

       El valor entero todava ocupa una palabra en la pila, ya que el modelo
       large no afecta al tamao del tipo de dato 'int'. El primer argumento
       (empujado el ltimo) a 'printf', sin embargo, es un puntero de dato, y
       por lo tanto tiene que contener una parte segmento y otra offset. El
       segmento debera almacenarse en memoria en segundo lugar, y por lo tanto
       debe empujarse primero. (Por supuesto, 'PUSH DS' debera haber tenido una
       instruccin ms corta que 'PUSH WORD SEG mystring', si 'DS' ha sido
       establecido como en el ejemplo de arriba.) Entonces la llamada actual
       se hace una llamada lejana, ya que las funciones esperan llamadas lejanas
       en el modelo de memoria large; y 'SP' tiene que incrementarse despus en
       6 en lugar de 4 para inventarse la palabra extra de los parmetros.

 7.4.4 Accediendo a los datos

       Para leer el contenido de las variables, o para declarar variables que
       se puedan acceder desde C, slo necesitas declarar los nombres como
       'GLOBAL' o 'EXTERN'. (Nuevamente, los nombre requieren los subrayados
       precedentes, como se dijo en la seccin 7.4.1.). As, una variable C
       declarada como 'int i' puede accederse desde ensamblador como

                 extern _i
                 mov ax,[_i]

       Y para declarar tu propia variable entera a la que puedan acceder los
       programas en C como 'extern int j', haras esto (asegurndote de que
       ests ensamblando en el segmento '_DATA', si es necesario):

                 global _j
       _j        dw 0

       Para acceder a un array C, necesitas conocer el tamao de los componentes
       del array. Por ejemplo, las variables 'int' son de dos bytes, por eso si
       un programa C declara un array como 'int a[10]', puedes acceder al 'a[3]'
       codificando 'mov ax,[_a+6]'. (El offset del byte 6 se obtiene
       multiplicando el ndice del elemento deseado del array, 3, por el tamao
       de elemento del array, 2.) Los tamaos de los tipos bsicos de C en
       compiladores de 16-bit son:
       1 para el 'char', 2 para el 'short' e 'int', 4 para el 'long' y 'float',
       y 8 para el 'double'.

       Para acceder a un estructura de datos en C, necesitas conocer el offset
       desde la base de la estructura al campo que est interesado. Tambin
       puedes hacer esto convirtiendo la definicin de la estructura de C en
       una definicin de estructura de NASM (usando 'STRUC'), o calculando el
       offset y simplemente usndolo.

       Para hacer cualquiera de estas dos cosas, deberas leer el manual de tu
       compilador de C para encontrar cmo organiza las estructuras. NASM no da
       un alineamiento especial a los miembros de la estructura en su macro
       'STRUC', por eso tienes que especificar el alineamiento por ti mismo si
       el compilador lo genera. Tpicamente, podras escontrar que una
       estructura como sta

       struct {
           char c;
           int i;
       } foo;

       podra ocupar cuatro bytes en lugar de tres, ya que el campo 'int' sera
       alineado a un lmite de dos bytes. Sin embargo, este tipo de
       caracterstica tiende a ser una opcin configurable en el compilador de
       C, ya sea usando opciones de la lnea de comandos o lneas '#pragma', por
       eso tienes que encontrar cmo lo hace tu compilador.

 7.4.5 'c16.mac': Macros de ayuda para la interface de C de 16-bit

       Incluido en el archivo NASM, en el directortio 'misc', hay un fichero
       de macros, 'c16.mac'. Define tres macros: 'proc', 'arg' y 'endproc'. Son
       deseadas para usar en las definiciones de procedimientos al estilo de C,
       y automatizan un montn de trabajo involucrado en llevar la cuenta de
       los convenios de llamadas.

       Un ejemplo de una funcin en ensamblador usando el conjunto de macros
       dadas aqu:

                 proc _nearproc
       %$i       arg
       %$j       arg
                 mov ax,[bp + %$i]
                 mov bx,[bp + %$j]
                 add ax,[bx]
                 endproc

       Esto define '_nearproc' como un procedimiento que recibe dos argumentos,
       el primero ('i') es un entero y el segundo ('j') es un puntero a un
       entero. Devuelve 'i + *j'.

       Ntese que la macro 'arg' tiene un 'EQU' como primera lnea en su
       expansin, y ya que la etiqueta antes de la llamada a la macro queda
       unida a la primera lnea de la macro expandida, el 'EQU' funciona,
       definiendo '%$i' como un offset desde 'BP'. Se usa una variable de
       contexto local, local al contexto empujado por la macro 'proc' y sacada
       por la macro 'endproc', por eso se puede usar el mismo nombre de
       argumento en posteriores procedimientos. Por supuesto, _no tienes_ por
       qu hacerlo.

       Por defecto el conjunto de macro genera cdigo para las funciones
       cercanas (modelos tiny, small y compact). Puedes generar funciones
       lejanas (modelos medium, large y huge) mediante la codificacin de
       '%define FARCODE'. Esto cambia el tipo de la intruccin de retorno
       generada por 'endproc', y tambin cambia el punto de entrada de los
       offsets de los argumentos. El conjunto de macros no contiene
       dependencias intrnsecas de si los punteros de los datos son lejanos o
       no.

       'arg' puede recibir un parmetro opcional, dando el tamao del argumento.
       Si no se da el tamao, se asume que es 2, ya que la mayora de los
       argumentos de las funciones sern de tipo 'int'.

       El equivalente al modelo large de la funcin de arriba sera algo as:

       %define FARCODE
                 proc _farproc
       %$i       arg
       %$j       arg 4
                 mov ax,[bp + %$i]
                 mov bx,[bp + %$j]
                 mov es,[bp + %$j + 2]
                 add ax,[bx]
                 endproc

       Esto hace uso del argumento de la macro 'arg' para definir un tamao de
       parmetro de 4, porque 'j' ahora un puntero lejano. Cuando nosotros
       cargamos desde 'j', debemos cargar un segmento y un offset.

   7.5 Interpretando programas en Borland Pascal

       La interpretacin de los programas de Borland Pascal es parecida en el
       concepto a la interpretacin de los programas de C de 16-bit. Las
       diferencias son:

       (*) El subrayado precente requerido para la interpretacin de los
           programas C no se necesita para los de Pascal.

       (*) El modelo de memoria siempre es large: las funciones son lejanas, los
           punteros a los datos son lejanos, y no puede haber datos de mayor
           tamao que 64K. (Realmente, algunas funciones son cercanas, pero slo
           aquellas funciones que son locales a una unidad Pascal y nunca son
           llamadas desde funciones externas a ella. Todas las funciones en
           ensamblador que llame Pascal, y todas las funciones Pascal que son
           capaces de llamar las rutinas ensamblador, son lejanas.) Sin embargo,
           todos los datos estticos declarados en un programa Pascal va en el
           segmento de datos por defecto, que es aquel cuya direccin de
           segmento estar en 'DS' cuando el control se pase a tu cdigo
           ensamblador. La nica cosa que no est en el segmento de datos por
           defecto son las variables locales (estn en el segmento de pila) y
           las variables asignadas dinmicamente. Todos los _punteros_ de datos,
           sin embargo, son lejanos.

       (*) Los convenios de las llamadas a funciones son diferentes - descritos
           ms abajo.

       (*) Algunos tipos de datos, como las cadenas, se almacenan de manera
           diferente.

       (*) Hay restricciones en los nombres de segmentos que ests autorizado a
           usar - Borland Pascal ignorar el cdigo o los datos declarado en un
           segmento cuyo nombre no sea vlido. Las restricciones estn descritas
           ms abajo.

 7.5.1 El convenio de las llamadas en Pascal

       El convenio de las llamadas Pascal de 16-bit es como sigue. En la
       siguiente descripcin, las palabras _llamante_ y _llamado_ se usan para
       denotar la funcin que hace la llamada y la funcin que la recibe.

       (*) El llamante empuja a la pila los parmetros de la funcin, una tras
           otra, en otro orden (de izquierda a derecha, por eso el primer
           argumento especificado a la funcin se empuja primero).

       (*) El llamante luego ejecuta una instruccin 'CALL' lejana para pasar el
           control al llamado.

       (*) El llamado recibe el control, y tpicamente (aunque esto no es
           realmente necesario, en las funciones que no necesitan acceder a sus
           parmetros) comienza salvando el valor de 'SP' en 'BP' para poder
           usar 'BP' como puntero base para encontrar sus parmetros en la pila.
           Sin embargo, el llamante probablemente hizo esto, por eso parte del
           convenio de llamadas determina que 'BP' debe ser conservado por
           cualquier funcin. Por lo tanto el llamado, si va a establecer 'BP'
           como un puntero de marco, debe empujar previamente el valor a la
           pila.

       (*) El llamado podra entonces acceder a sus parmetros relativo al 'BP'.
           La palabra en '[BP]' contiene el valor previo de 'BP' segn fue
           empujado. La siguiente palabra, en '[BP+2]', contiene la parte de
           offset de la direccin de retorno, y la siguiente '[BP+4]' contiene
           la parte del segmento. Los parmetros comienzan en '[BP+6]'. El
           parmetro ms a la derecha de la funcin, ya que fue empujado el
           ltimo, est accesible en este offset desde 'BP'; los siguientes le
           siguen en offsets cada vez mayores.

       (*) El llamado podra tambin desear decrementar 'SP' ms adelante, para
           asignar espacio en la pila para las variables locales, que entonces
           estarn accesibles en offsets negativos desde 'BP'.

       (*) El llamado, si desea devolver un valor al llamante, debera dejar
           el valor en 'AL', 'AX' o 'DX:AX' dependiendo del tamao del valor.
           Los resultados en coma flotante se devuelven en 'ST0'. Resultados del
           tipo 'Real' (el tipo de dato personal en coma flotante de Borland, no
           manejado directamente por la FPU) se devuelven en 'DX:BX:AX'. Para
           devolver un resultado del tipo 'String', el llamante empuja un
           puntero a una cadena temporal antes de empujar los parmetros, y el
           llamado coloca el valor de la cadena de retorno en esta posicin. El
           puntero no es un parmetro, y no debera ser eliminado de la pila por
           la instruccin 'RETF'.

       (*) Una vez el llamado ha terminado de procesar, restaura 'SP' desde 'BP'
           si ha asignado espacio de pila local, luego saca el valor previo de
           'BP', y retorna va 'RETF'. Usa la forma de 'RETF' con un parmetro
           inmediato, dando el nmero de bytes ocupados en la pila por los
           parmetros. Esto hace que se eliminen de la pila los parmetros como
           un efecto lateral de la instruccin de retorno.

       (*) Cuando el llamante retoma el control desde el llamado, los parmetros
           de la funcin ya han sido eliminados de la pila, por eso no tiene que
           hacer nada ms.

       As, definiras una funcin en el estilo de Pascal, que recibe dos
       parmetros del tipo entero, del siguiente modo:

                 global myfunc
       myfunc:   push bp
                 mov bp,sp
                 sub sp,0x40            ; 64 bytes de espacio de pila local
                 mov bx,[bp+8]          ; el primer parmetro de la funcin
                 mov bx,[bp+6]          ; el segundo parmetro de la fucin
                 ; algo ms de cdigo
                 mov sp,bp              ; deshace el 'sub sp,0x40' de arriba
                 pop bp
                 retf 4                 ; el tamao total de los parmetros es 4

       En el otro extremo del proceso, para llamar a un funcin Pascal desde tu
       cdigo ensamblador, deberas hacer algo como:

                 extern SomeFunc
                 ; y ahora, ms abajo...
                 push word seg mystring ; ahora empuja el segmento, y...
                 push word mystring     ; ... el offset de "mystring"
                 push word [myint]      ; una de mis variables
                 call far SomeFunc

       Esto es equivalente al cdigo Pascal

       procedure SomeFunc(String: PChar; Int: Integer);
           SomeFunc(@mystring, myint);

 7.5.2 Restricciones de Borland Pascal a los nombres de segmento

       Ya que la unidad interna del formato de fichero del Pascal de Borland es
       completamente diferente del 'OBJ', slo hace un trabajo incompleto de la
       lectura y comprensin real de la diversa informacin que est contenida
       en un fichero 'OBJ' real cuando lo enlaza en l. Por lo tanto, un fichero
       objeto que se desee enlazar a un programa Pascal debe obedecer una serie
       de restricciones:

       (*) Los procedimientos y las funciones deben estar en un segmento cuyo
           nombre sea 'CODE', 'CSEG', o algo terminado en '_TEXT'.

       (*) Los datos inicializados deben estar en un segmento cuyo nombre sea
           'CONST' o algo terminado en '_DATA'.

       (*) Los datos no inicializados deben estar en un segmento cuyo nombre sea
           'DATA', 'DSEG', o algo terminado en '_BSS'.

       (*) Cualquier otro segmento en el fichero objeto ser completamente
           ignorado. Tambin son ignoradas las directivas 'GROUP' y los
           atributos de segmentos.

 7.5.3 Usando 'c16.mac' con programas en Pascal

       El paquete de macros 'c16.mac', descrito en la seccin 7.4.5 tambin
       puede usarse si codificas '%define PASCAL' para simplificar la escritura
       de funciones que sean llamadas desde programas en Pascal. Esta definicin
       asegura que las funciones son lejanas (implica 'FARCODE'), y tambin hace
       que la instruccin de retornos del procedimiento se genere con un
       operando.

       Definir 'PASCAL' no cambia el cdigo que calcula los offsets del
       argumento; debes declarar en orden inverso los argumentos de tu funcin.
       Por ejemplo:

       %define PASCAL
                 proc _pascalproc
       %$j       arg 4
       %$i       arg
                 mov ax,[bp + %$i]
                 mov bx,[bp + %$j]
                 mov es,[bp + %$j + 2]
                 add ax,[bx]
                 endproc

       Esto define la misma rutina, conceptualmente, que en el ejemplo de la
       seccin 7.4.5: define una funcin que recibe dos argumentos, un entero
       y un puntero a entero, que devuelve la suma del entero y el contenido del
       puntero. La nica diferencia entre este cdigo y la versin de C con
       modelo large es que 'PASCAL' est definida en lugar de 'FARCODE', y que
       los argumentos se declaran en orden contrario.

Captulo 8: Escribiendo cdigo 32-bit (Unix, Win32, DJGPP)
----------------------------------------------------------

       Este captulo intenta cubrir algunas de las cuestiones comunes que surgen
       cuando se escribe cdigo de 32-bit, para correr bajo Win32 o Unix, o para
       ser enlazado con cdigo C generado por un compilador de C del estilo de
       Unix como pueda ser DJGPP. Cubre cmo escribir cdigo ensamblador para
       interactuar con rutinas C, y cmo escribir cdigo independiente de la
       posicin para bibliotecas compartidas.

       Casi todo el cdigo de 32-bit, y en particular todo el cdigo que se
       ejecuta bajo Win32, DJGPP y cualquiera de las variantes de Unix para PC,
       se ejecuta en modelos de memoria _plana_. Esto quiere decir que los
       registros de segmentos y paginacin ya han sido establecidos para darte
       el mismo espacio de 4GB de direcciones de 32-bit, independientemente de
       en relacin a qu segmento trabajes, y deberas ignorar completamente
       todos los registros de segmento. Cuando escribes cdigo de aplicaciones
       en un modelo plano, nunca necesitas usar solapamiento de segmentos ni
       modificar ningn registro de segmento, y las direcciones de las secciones
       de cdigo que pasas a una 'CALL' y 'JMP' estn en el mismo espacio de
       direcciones que las direcciones de datos con las que accedes a tus
       variables y las direcciones de la seccin de pila con las que accedes a
       tus variables locales y parmetros de procedimiento. Cada direccin es de
       32-bit y slo contiene la parte del offset.

   8.1 Interactuando con programas en C de 32-bits

       Mucho de lo discutido en la seccin 7.4, sobre la interactuacin con
       programas en C de 16-bits, todava se aplica cuando se trabaja con
       32-bits. La ausencia de modelos de memoria o los problemas de
       segmentacin simplican mucho las cosas.

 8.1.1 Nombres de los smbolos externos

       La mayora de los compiladores de C de 32-bit comparten el convenio usado
       en los compiladores de 16-bits, que los nombres de todos los smbolos
       globales (funciones o datos) que definan estn formados por un subrayado
       precediendo al nombre que aparece en el programa C. Sin embargo, no todos
       lo hacen: la especificacin ELF determina que los smbolos C _no_ tienen
       un subrayado precediendo los nombres en lenguaje ensamblador.

       El antiguo compilador 'a.out' de C de Linux, todos los compiladores
       Win32, DJGPP, y NetBSD y FreeBSD, todos usan el subrayado precedente;
       para estos compiladores, las macros 'cextern' y 'cglobal', como las dadas
       en la seccin 7.4.1, todava funcionarn. Para ELF, sin embargo, el
       subrayado prefijado no debera usarse.

 8.1.2 Definiciones de funciones y llamadas a fuciones

       El convenio de llamadas en C en programas de 32-bits es como sigue. En la
       siguiente descripcin, las palabras _llamante_ y _llamado_ se usan para
       denotar a la funcin que hace la llamada y la funcin que la recibe.

       (*) El llamante empuja a la pila los parmetros de la funcin, uno tras
           otro, en orden contrario (de derecha a izquierda, por eso el primer
           argumentos especificado en la funcin es empujado el ltimo).

       (*) El llamante luego ejecuta una instruccin 'CALL' cercana para pasarle
           el control al llamado.

       (*) El llamado recibe el control, y normalmente (aunque esto no es
           realmente necesario en las funciones que no necesitan acceder a sus
           parmetros) comienza salvando el valor de 'ESP' en 'EBP' para poder
           ser capaz de usar 'EBP' como puntero base para encontrar sus
           parmetros en la pila. Sin embargo, el llamante habr hecho
           probablemente tambin esto, por eso, parte del convenio de llamadas
           determina que 'EBP' debe conservarse en cualquier funcin C. Por lo
           tanto, el llamado, si va a establecer 'EBP' como un puntero de marco,
           debe empujar previamente el valor a la pila.

       (*) El llamado podra luego acceder a sus parmetros en relacin a 'EBP'.
           La palabra doble en '[EBP]' contiene el anterior valor de 'EBP' segn
           fue empujado; la siguiente palabra doble, en '[EBP+4]' contiene la
           direccin de retorno, empujada implcitamente por 'CALL'. Los
           parmetros comienzan despus de sta, en '[EBP+8]'. El parmetro ms
           a la izquierda de la funcin, ya que fue empujado el ltimo, est
           accesible en este offset desde 'EBP'; los dems le siguen, en offsets
           sucesivos. As, en una funcin como 'printf' que recibe un nmero
           variable de argumentos, empujar los parmetros en orden contrario
           quiere decir que la funcin conoce dnde encontrar el primer
           parmetro, que le dice el nmero y tipo de los restantes.

       (*) El llamado tambin podra desear decrementar 'ESP' en un futuro, para
           asignar espacio en la pila para las variables locales, que sern
           accesibles en offsets negativos desde 'EBP'.

       (*) El llamado, si desea devolver un valor al llamante, debera dejarlo
           en 'AL', 'AX' o 'EAX' dependiendo del tamao del valor. Los resultado
           en coma flotante normalmente se devuelven en 'ST0'.

       (*) Una vez que el llamado ha terminado de procesar, restaura 'ESP'
           desde 'EBP' si ha asignado espacio de pila local, luego saca el
           anterior valor de 'EBP', y retorna va 'RET' (equivalente a 'RETN').

       (*) Cuando el llamante recupera el control desde el llamado, los
           parmetros de la funcin todava estn en la pila, por eso,
           normalmente aade un valor inmediato a 'ESP' para eliminarlos (en
           lugar de ejecutar un nmero de lentas instrucciones 'POP'). As, si
           una funcin es llamada accidentalmente con un nmero errneo de
           parmetros debido un fallo en el prototipo, la pila ser devuelta
           a un estado correcto ya que el llamante, que _conoce_ cuntos
           parmetros empuj, hace la eliminacin.

       Hay un convenio alternativo para las llamadas, usado por los programas de
       Win32 para las llamadas de la API, y tambin para las funciones llamadas
       _por_ el API de Windows como los procedimientos de la ventanas: ellas
       siguen lo que Microsoft llama el convenio '__stdcall'. Este es un poco
       ms parecido al convenio de Pascal, en el que el llamado limpia la pila
       pasando un parmetro en la instruccin 'RET'. Sin embargo, el parmetro
       sigue siendo empujado en el orden de derecha a izquierda.

       As, definiras una funcin en el estilo de C del siguiente modo:

                 global _myfunc
       _myfunc:  push ebp
                 mov ebp,esp
                 sub esp,0x40           ; 64 bytes de espacio de pila local
                 mov ebx,[ebp+8]        ; primer parmetro de la funcin
                 ; algo ms de cdigo
                 leave                  ; mov esp,ebp / pop ebp
                 ret

       En el otro extremo del proceso, para llamar a una funcin C desde tu
       cdigo ensamblador, haras algo parecido a esto:

                 extern _printf
                 ; y luego, ms abajo...
                 push dword [myint]     ; una de mis variables enteras
                 push dword mystring    ; un puntero en mi segmento de datos
                 call _printf
                 add esp,byte 8         ; 'byte' libera espacio
                 ; luego estos datos...
                 segment _DATA
       myint     dd 1234
       mystring  db 'This number -> %d <- should be 1234',10,0

       Este trozo de cdigo es el equivalente en ensamblador al cdigo de C

           int myint = 1234;
           printf("This number -> %d <- should be 1234\n", myint);

 8.1.3 Accediendo a los datos

       Para obtener los contenidos de las variables de C, o para declarar
       variables que se puedan acceder desde C, slo necesitas declarar los
       nombres como 'GLOBAL' o 'EXTERN'. (Nuevamente, los nombres requieren el
       subrayado delantero, como se dijo en la seccin 8.1.1). As, una variable
       en C declarada como 'int i' se puede acceder desde ensamblador como

                 extern _i
                 mov eax,[_i]

       Y para declarar tu propia variable entera que pueda ser accedida desde
       programas en C como 'extern int j', haz esto (asegurndote de que ests
       ensamblando el segmento '_DATA', si es necesario):

                 global _j
       _j        dd 0

       Para acceder a un array C, necesitas conocer el tamao de los componentes
       del array. Por ejemplo, las variables 'int' son de cuatro bytes, por eso
       si un programa C declara un array como 'int [10]', puedes acceder a
       'a[3]' codificando 'mov ax,[_a+12]'. (El offset del byte 12 se obtiene
       multiplicando el ndice deseado del array, 3, por el tamao de elemento
       del array, 4). Los tamaos de los tipos base de C en un compilador de
       32-bits son: 1 para el 'char', 2 para el 'short', 4 para el 'int', 'long'
       y 'float', y 8 para el 'double'. Los punteros, siendo direcciones de
       32-bits, son tambin de 4 bytes.

       Para acceder a una estructura de C, necesitas conocer el offset desde
       la base de la estructura hasta el campo en que ests interesado. Puedes
       hacerlo convirtiendo la definicin de la estructura de C en una
       definicin de estructura de NASM (usando 'STRUC'), o calculando el
       offset y simplemente usndolo.

       Para hacer cualquiera de estas dos, deberas leer el manual de tu
       compilador de C para encontar cmo organiza las estructuras de datos.
       NASM no da en su propia macro 'STRUC' un alineamiento especial a los
       miembros de la estructura, por eso tienes que especificar el alineamiento
       si el compilador de C lo genera. Tpicamente, podras encontar que una
       estructura como

       struct {
           chart c;
           int;
       } foo;

       podra ser de ocho bytes en lugar de cinco, ya que el campo 'int' podra
       alinearse a un lmite de cuatro bytes. Sin embargo, este tipo de
       caracterstica es a veces una opcin configurable en el compilador de C,
       ya sea usando las opciones de la lnea de comandos o lneas '#pragma',
       por eso tienes que encontrar cmo lo hace tu compilador.

 8.1.4 'c32.mac': Macros de ayuda para la interface de 32-bit

       Incluido en el archivo NASM, en el directorio 'misc' est un fichero
       'c32.mac' de macros. Este define tres macros: 'proc', 'arg' y 'endproc'.
       Viene bien usarlos en las definiciones de procedimientos en el estilo de
       C, y automatizan mucho trabajo del que implica tener en cuenta el
       convenio de llamadas.

       Un ejemplo de una funcin en ensamblador usando el conjunto de macros
       es ste:

                 proc _proc32
       %$i       arg
       %$j       arg
                 mov eax,[ebp + %$i]
                 mov ebx,[ebp + %$j]
                 add eax,[ebx]
                 endproc

       Este define '_proc32' como un procedimiento que recibe dos argumentos,
       el primero ('i') un entero y el segundo ('j') un puntero a un entero.
       Devuelve 'i + *j'.

       Ntese que la macro 'arg' tiene un 'EQU' como primera lnea en su
       expansin, y ya que la etiqueta de la llamada a la macro se conserva en
       la primera lnea de la macro expandida, el 'EQU' funciona, definiendo
       '%$i' como un offset desde 'BP'. Se usa una variable de contexto local,
       local al contexto empujado por la macro 'proc' y sacado por la macro
       'endproc', por eso se puede usar el mismo nombre de argumento en
       posteriores procedimientos. Por supuesto, _no tienes_ por qu hacerlo.

       'arg' puede recibir un argumento opcional, dando el tamao del argumento.
       Si no se da el tamao, se asume 4, ya que la mayor parte de los
       parmetros de las funciones sern del tipo 'int' o punteros.

   8.2 Escribiendo bibliotecas compartidas para NetBSD/FreeBSD/OpenBSD
       y Linux/ELF

       ELF sustituye bajo Linux el antiguo formato de fichero objeto 'a.out'
       porque contiene soporte para cdigo independiente de la posicin (PIC),
       que hace que escribir bibliotecas compartidas sea mucho ms fcil. NASM
       soporta las caractersticas del cdigo ELF independiente de la posicin,
       por eso puedes escribir bibliotecas ELF compartidas de Linux en NASM.

       NetBSD, y es un primo cercano de FreeBSD y OpenBSD, toma un acercamiento
       diferente introduciendo el soporte de PIC en el formato 'a.out'. NASM
       soporta esto como el formato de salida 'aoutb', por eso tambin puedes
       escribir en NASM bibliotecas BSD compartidas.

       El sistema operativo carga una biblioteca compartida PIC mediante el
       mapeado de memoria del fichero biblioteca en un punto arbitrario del
       espacio de direcciones en el proceso que se est ejecutando. El contenido
       de la seccin de cdigo de la biblioteca no debe depender por lo tanto
       de dnde sea cargado en memoria.

       As, no puedes leer tus variables escribiendo cdigo como ste:

                 mov eax,[myvar]        ; ERRONEO

       En su lugar, el enlazador proporciona un rea de memoria llamada
       _tabla global de offset_, o GOT; el GOT est situado a una distancia
       constante desde el cdigo de tu biblioteca, por eso puedes encontrar
       dnde est cargada tu biblioteca (que normalmente se hace usando una
       combinacin de 'CALL' y 'POP'), puedes obtener la direccin del GOT, y
       luego puedes cargar las direcciones de tus variables fuera de las
       entradas generadas en el GOT por el enlazador.

       La seccin _de datos_ de una biblioteca compartida PIC no tiene estas
       restricciones: ya que la seccin de datos es escribible, tiene que ser
       copiada en memoria de cualquier forma en lugar de simplemente paginarla
       desde el fichero biblioteca, por eso con tal que sea copiada puede ser
       tambin recolocada. As puedes poner los tipos normales de recolocacin
       en la seccin de datos sin mucha preocupacin (pero mira la seccin
       8.2.4 para ms aclaracin).

 8.2.1 Obteniendo la direccin del GOT

       Cada mdulo en tu biblioteca compartida debera definir la GOT como un
       smbolo externo:

                 extern _GLOBAL_OFFSET_TABLE_   ; en ELF
                 extern __GLOBAL_OFFSET_TABLE_  ; en el a.out de BSD

       Al comienzo de cualquier funcin en tu biblioteca compartida que planee
       acceder a tus datos o a las secciones BSS, debes primero calcular la
       direccin del GOT. Esto se hace normalmente escribiendo la funcin de
       esta forma:

       func:     push ebp
                 mov ebp,esp 
                 push ebx 
                 call .get_GOT 
       .get_GOT: pop ebx 
                 add ebx,_GLOBAL_OFFSET_TABLE_+$$-.get_GOT wrt ..gotpc 
                 ; el cuerpo de la funcin va aqu
                 mov ebx,[ebp-4] 
                 mov esp,ebp 
                 pop ebp 
                 ret

       (Para BSD, nuevamente, el smbolo '_GLOBAL_OFFSET_TABLE_' requiere un
       segundo subrayado delantero.)

       Las dos primeras lneas de esta funcin son simplemente el prlogo
       estndar de C para preparar el marco de pila, y las ltimas tres lneas
       son el eplogo estndar de las funciones de C. La tercera lnea, y desde
       la cuarta hasta la ltima, salvan y restauran el registro 'EBX', porque
       las bibliotecas compartidas PIC usan este registro para almacenar la
       direccin del GOT.

       El punto interesante es la instruccin 'CALL' y las siguientes dos
       lneas. La combinacin 'CALL' y 'POP' obtiene la direccin de la etiqueta
       '.get_GOT', sin tener que conocer previamente dnde ha sido cargado el
       programa (ya que la instruccin 'CALL' est codificada en relacin a la
       actual posicin). La instruccin 'ADD' hace uso de uno de los tipos
       especiales de recolocacin: recolocacin GOTPC. Con el cualificador
       especfico 'WRT ..gotpc', el smbolo referenciado (aqu
       '_GLOBAL_OFFSET_TABLE_', el smbolo especial asignado al GOT) est dado
       como un offset desde el principio de la seccin. (Realmente, ELF lo
       codifica como el offset desde el campo del operando de la instruccin
       'ADD', pero NASM lo simplifica deliberadamente, por eso hace las cosas
       igual tanto para ELF como para BSD.) As la instruccin luego _suma_ el
       principio de la seccin, para conseguir la direccin real de la GOT, y
       resta el valor de '.get_GOT' que sabe que est en 'EBX'. Por lo tanto,
       una vez que la instruccin ha terminado, 'EBX' contiene la direccin de
       la GOT.

       Si no has seguido esto, no te preocupes: nunca es necesario obtener la
       direccin del GOT mediante otras formas, por eso puedes poner estas tres
       instrucciones en una macro y olvidarte:

       %macro get_GOT 0
                 call %%getgot
       %%getgot: pop ebx
                 add ebx,_GLOBAL_OFFSET_TABLE_+$$-%%getgot wrt ..gotpc
       %endmacro

 8.2.2 Encontrando tus datos locales

       Habiendo cogido la GOT, entonces puedes usarla para obtener las
       direcciones de tus datos. La mayora de las variables residirn en las
       secciones que t habas declarado; pueden accederse usando el tipo
       especial de 'WRT', '..gotoff'. La forma en que funciona es como sta:

                 lea eax,[ebx+myvar wrt ..gotoff]

       La expresin 'myvar wrt ..gotoff' es calculada, cuando se enlaza la
       biblioteca compartida, para ser el offset de la variable local 'myvar'
       desde el comienzo del GOT. Por lo tanto, sumndolo a 'EBX' como arriba
       colocar la direccin real de 'myvar' en 'EAX'.

       Si declaras variables como 'GLOBAL' sin especificar el tamao para ellas,
       son compartidas entre los mdulos de cdigo de la biblioteca compartida,
       pero no exportadas desde la biblioteca al programa que la cargue. Estarn
       en tus secciones normales de datos y BSS, por eso puedes accederlas de
       la misma forma que a una variable local, usando el mecanismo '..gotoff'
       de arriba.

       Ntese que debido a una peculiaridad del manejo que hace el formato
       'a.out' de BSD de este tipo de recolocacin, debe haber al menos un
       smbolo no local en la misma seccin que la direccin a la que intentas
       acceder.

 8.2.3 Encontrando datos comunes y externos

       Si tu biblioteca necesita coger una variable externa (externa a la
       _biblioteca_, no simplemente una de los mdulos dentro de ella), debes
       usar el tipo '..got' para cogerla. El tipo '..got', en lugar de darte el
       offset desde la base GOT hasta la variable, te da el offset desde la base
       GOT hasta la _entrada_ GOT que contiene la direccin de la variable. El
       enlazador establecer esta entrada cuando construya la biblioteca, y el
       enlazador dinmico colocar la direccin correcta en tiempo de carga. Por
       eso para obtener la direccin de una variable externa 'extvar' en 'EAX',
       codificaras

                 mov eax,[ebx+extvar wrt ..got]

       Esto carga la direccin de 'extvar' fuera de la entrada al GOT. El
       enlazador, cuando construya la bilbioteca compartida, recoge juntas todas
       las recolocaciones del tipo '..got', y construye el GOT de tal forma que
       asegure que tiene presente todas las entradas necesarias.

       Las variables comunes tambin deben acceder usando este mtodo.

 8.2.4 Exportando smbolos al usuario de la biblioteca

       Si quieres exportar smbolos al usuario de la biblioteca, tienes que
       declarar si son funciones o datos, y si son datos, tienes que dar el
       tamao del dato. Esto es porque en enlazador dinmico tiene que construir
       las entradas a la tabla de enlace del procedimiento para cualquier
       funcin exportada, y tambin mueve los datos exportados fuera de la
       seccin data de la biblioteca en la que estn declarados.

       Por eso, para exportar una funcin a un usuario de la biblioteca, debes
       usar

                 global func:function   ; la declara como una funcin
       func:     push ebp
                 ; etc.

       Y para exportar un dato como por ejemplo un array, tendras que codificar

                 global array:data array.end-array ; tambin da el tamao
       array:    resd 128
       .end:

       Cuidado: si exportas una variable al usuario de la biblioteca,
       declarndola como 'GLOBAL' y dando el tamao, la variable terminar
       viviendo en la seccin de datos del programa principal, en lugar de
       hacerlo en la seccin de datos de tu biblioteca, en donde la has
       declarado. Por eso tendrs que acceder a tus propias variables globales
       con el mecanismo '..got' en lugar de con '..gotoff', si eran externas
       (las cuales, efectivamente, lo son).

       Igualmente, si necesitas almacenar la direccin de una global exportada
       en una de tus secciones de datos, no puedes hacerlo mediante este tipo
       estndar de cdigo:

       dataptr:  dd global_data_item    ; ERRONEO

       NASM interpretar este cdigo como una recolocacin normal, en la cual
       'global_data_item' es simplemente un offset desde el principio de la
       seccin (o lo que sea); por eso esta referencia terminar apuntando a tu
       seccin de datos en lugar de a la global exportada que reside en
       cualquier otro lugar.

       En lugar del cdigo de arriba, entonces, debes escribir

       dataptr:  dd global_data_item wrt ..sym

       que hace uso del tipo especial de 'WRT' '..sym' para indicarle a NASM
       que busque la tabla de smbolos para un smbolo en particular en esa
       direccin, en lugar de simplemente recolocar desde la seccin base.

       Cualquier mtodo funcionar para las funciones: refirindote a una de tus
       funciones mediante

       funcptr:  dd my_function

       dar al usuario la direccin del cdigo que escribiste, mientras que

       funcptr:  dd my_function wrt ..sym

       dar la direccin de la tabla de enlace del procedimiento para la
       funcin, que est donde el programa llamante _creer_ que vive la
       funcin. Cualquier direccin es vlida para llamar a la funcin.

 8.2.5 Llamando a procedimientos desde fuera de la biblioteca

       Llamar a procedimientos desde fuera de tus bibliotecas compartidas tiene
       que hacerse mediante una _tabla de enlace de procedimiento_, o PLT. La
       PLT est en un offset conocido desde donde se carga la biblioteca, por
       eso el cdigo de la biblioteca puede hacer llamadas a la PLT de forma
       independiente de la posicin. Dentro de la PLT hay cdigo para saltar a
       offsets contenidos en el GOT, por eso las llamadas a las funciones de
       otras bibliotecas compartidas o a rutinas en el programa principal pueden
       pasarse transparentemente desde sus destinos reales.

       Para llamar a una rutina externa, debes usar otro tipo especial de
       recolocacin, 'WRT ..plt'. Esto es mucho ms fcil que el basado en el
       GOT: simplemente sustituyes las llamadas como 'CALL printf' con la
       versin relativa a la PLT 'CALL printf WRT ..plt'.

 8.2.6 Generando el fichero biblioteca

       Teniendo escrito algunos mdulos de cdigo y ensamblados a ficheros '.o',
       tienes que generar tu biblioteca compartida con un comando como

       ld -shared -o library.so module1.o module2.o       # para ELF
       ld -Bshareable -o library.so module1.o module2.o   # para BSD

       Para ELF, si tu biblioteca compartida va a residir en directorios de
       sistema como 'usr/lib' o '/lib', es aconsejable normalmente usar la
       opcin '-soname' en el enlazador, para almacenar el nombre del fichero
       final de la biblioteca, con el nmero de versin, en la biblioteca:

       ld -shared -soname library.so.1 -o library.so.1.2 *.o

       Entonces copiaras 'library.so.1.2' en el directorio de la biblioteca, y
       crearas 'library.so.1' como un enlace simblico a ella.

Captulo 9: Mezclando cdigo de 16 y 32 bits
--------------------------------------------

       Este captulo intenta cubrir algunas de las cuestiones, enormemente
       relacionadas con formas inusuales de direccionamiento e instrucciones de
       salto, encontradas cuando se escribe cdigo de sistema operativo como las
       rutinas de inicializacin del modo protegido, que requieren cdigo que
       opere en diversos tamaos de segmentos, como cdigo en un segmento de
       16-bit que trata de modificar datos en uno de 32-bit, o saltos entre
       segmentos de diferentes tamaos.

   9.1 Saltos de distinto tamao

       La forma ms comn de las instrucciones de diverso tamao es la usada
       cuando se escribe un S.O. de 32-bit: habiendo hecho tu instalacin en el
       modo de 16-bit, al igual que la carga del kernel, tienes que reiniciarlo
       cambiando al modo protegido y saltando a la direccin de comienzo del
       kernel de 32-bit. En un S.O. completamente de 32-bit, sta tiende a ser
       la _nica_ instruccin de tamao mezclado que necesitas, ya que todo lo
       anterior puede hacerse con cdigo puramente de 16-bit, y todo lo
       posterior puede hacerse en puro 32-bit.

       Este salto debe especificar una direccin lejana de 48-bit, ya que el
       segmento de destino es uno de 32-bit. Sin embargo, debe ensamblarse en un
       segmento de 16-bit, por eso simplemente codificando, por ejemplo,

                 jmp 0x1234:0x56789ABC  ; errneo!

       no funcionar, ya que la parte del offset de la direccin ser truncada
       a '0x9ABC' y el salto ser uno lejano normal de 16-bit.

       El cdigo de instalacin del kernel de Linux rodea la incapacidad del
       'as86' para generar la instruccin requerida codificndola manualmente,
       usando instrucciones 'DB'. NASM puede hacerlo mejor que esto, generando
       actualmente por s mismo la instruccin correcta. Aqu va cmo hacerlo
       correctamente:

                 jmp dword 0x1234:0x56789ABC  ; correcto

       El prefijo 'DWORD' (estrictamente hablando, debera ir _despus_ de los
       dos puntos, ya que est declarando el campo del _offset_ como una palabra
       doble; pero NASM aceptar cualquiera de las dos formas, ya que ambas son
       ambiguas) fuerza a la parte del offset a ser tratado como lejano,
       asumiendo que ests deliberadamente escribiendo un salto desde un
       segmento de 16-bits a unos de 32-bit.

       Puedes hacer la operacin contraria, saltar desde un segmento de 32-bit a
       uno de 16-bit, mediante el prefijo 'WORD':

                 jmp word 0x8765:0x4321 ; 32 a 16 bit

       Si el prefijo 'WORD' se especifica en un modo de 16-bit, o el prefijo
       'DWORD' en uno de 32-bit, sern ignorados, ya que cada uno est forzando
       explcitamente a NASM a un modo en el que ya est de cualquier forma.

   9.2 Direccionando entre segmentos de diferente tamao

       Si tu S.O. tiene mezclado 16 y 32 bit, o si ests escribiendo un extensor
       de DOS, ests obligado a tener que tratar con algunos segmentos de 16-bit
       y otros de 32-bit. En este punto, problablemente terminars escribiendo
       cdigo en un segmento de 16-bit que tiene que acceder a datos en un
       segmento de 32-bit, o viceversa.

       Si el dato que ests intentando acceder en un segmento de 32-bit est
       entre los primeros 64K del segmento, podras ser capaz de hacer uso
       impunemente de una operacin de direccionamiento de 16-bit para este
       propsito; pero tarde o temprano, querrs hacer direccionamiento de
       32-bit desde un modo de 16-bit.

       El modo ms fcil de hacerlo es asegurarte de que usar un registro para
       la direccin, ya que cualquier direccin efectiva que contenga a un
       registro de 32-bit est forzada a ser una direccin de 32-bit. Por eso
       puedes hacer

                 mov eax,offset_into_32_bit_segment_specified_by_fs
                 mov dword [fs:eax],0x11223344

       Esto est bien, pero ligeramente molesto (ya que desperdicia una
       instruccin y un registro) si ya sabes el offset preciso al que ests
       apuntando. La arquitectura x86 no permite direcciones efectivas de 32-bit
       ms que para offset de 4 bytes, por eso, por qu podra NASM ser capaz
       de generar la mejor instruccin para esto?.

       Puede. Como en la seccin 9.1, slo necesitas preceder la direccin con
       la palabra clave 'DWORD', y ser forzado a ser una direccin de 32-bit:

                 mov dword [fs:dword my_offset],0x11223344

       Tambin en la seccin 9.1, NASM no es exigente sobre si el prefijo
       'DWORD' viene antes o despus que el solapamiento del segmento, por eso
       una forma ms bonita de codificar la instruccin de arriba es

                 mov dword [dword fs:my_offset],0x11223344

       No confunda el prefijo 'DWORD' de _fuera_ de los corchetes, que controla
       el tamao del dato almacenado en la direccin, con el de _dentro_ de los
       corchetes que controla la longitud de la direccin en s misma. Los dos
       pueden ser diferentes fcilmente:

                 mov word [dword 0x12345678],0x9ABC

       Esto mueve 16 bits de datos a un offset especificado por un offset de
       32-bit.

       Tambin puedes especificar los prefijos 'WORD' y 'DWORD' con el prefijo
       'FAR' para indireccionar los saltos o llamadas lejanas. Por ejemplo:

                 call dword far [fs:word 0x4321]

       Esta instruccin contiene una direccin especificada por un offset de
       16-bit; carga un puntero lejano de 48-bit desde se (segmento de 16-bit y
       offset de 32-bit), y llama a esta direccin.

   9.3 Otras instrucciones de tamao mezclado

       El otro modo en que podas querer acceder a datos podra ser usar las
       instrucciones de cadenas ('LODSx', 'STOSx' y dems) o la instruccin
       'XLATB'. Estas instrucciones, ya que no reciben parmetros, podra
       parecer que no tienen una forma fcil de hacerlas realizar
       direccionamientos de 32-bit cuando se ensamblan en segmentos de 16-bit.

       Este es el propsito de los prefijos de NASM 'a16' y 'a32'. Si ests
       codificando 'LODSB' en un segmento de 16-bit pero se supone que est
       accediendo a una cadena en un segmento de 32-bit, deberas cargar la
       direccin deseada en 'ESI' y luego codificar

                 a32 lodsb

       El prefijo fuerza al tamao del direccionamiento a 32-bits, mediante este
       'LODSB' carga desde '[DS:ESI]' en lugar de '[DS:SI]'. Para acceder a una
       cadena en un segmento de 16-bit cuando se est codificando en uno de
       32-bit, se puede usar el prefijo correspondiente 'a16'.

       Los prefijos 'a16' y 'a32' pueden aplicarse a cualquier instruccin en la
       tabla de instrucciones de NASM, pero la mayora de ellas pueden generar
       las formas correctas sin ellos. Los prefijo son necesarios slo para las
       instrucciones con direccionamiento implcito: 'CMPSx' (seccin A.19),
       'SCASx' (seccin A.149), 'LODSx' (seccin A.98), 'STOSx' (seccin A.157),
       'MOVSx' (seccin A.105), 'INSx' (seccin A.80), 'OUTSx' (seccin A.112),
       y 'LATB' (seccin A.169). Tambin, las diversas instrucciones push y pop
       ('PUSHA' y 'POPF' as como las ms usuales 'PUSH' y 'POP') pueden aceptar
       los prefijos 'a16' y 'a32' para forzar en particular a 'SP' o 'ESP' a ser
       puntero de pila, en el caso que el segmento de pila en uso tenga un
       tamao de pila diferente del segmento de cdigo.

       'PUSH' y 'POP', cuando se aplican a registros en el modo de 32-bit,
       tambin tienen el comportamiento un poco extrao de empujar y sacar 4
       bytes a la vez, del cual los dos superiores son ignorados y los dos
       inferiores dan el valor del registro de segmento que est siendo
       manipulado. Para forzar el comportamiento de 16-bit del registro de
       segmento de las instrucciones push y pop, puedes usar el prefijo de
       tamao de operando 'o16':

                 o16 push ss
                 o16 push ds

       Este cdigo salva una palabra doble de espacio de pila encajando dos
       registros de segmento en el espacio que normalmente sera consumido
       empujando uno.

       (Tambin puedes usar el prefijo 'o32' para forzar el comportamiento de
       32-bit cuando ests el modo de 16-bit, pero esto parece menos til.)

Captulo 10: Resolucin de problemas
------------------------------------

       este captulo describe algunos de los problemas ms comunes que los
       usuarios se han ido encontrando con NASM, y sus respuestas. Tambin da
       instrucciones para informar de bugs en NASM si t encuentras alguna
       dificultad que no est listada aqu.

  10.1 Problemas comunes

10.1.1 NASM genera cdigo ineficiente

       Recibo un montn de informes de 'bugs' de NASM generando cdigo
       ineficiente, e incluso errneo, en instrucciones como 'ADD ESP,8'. Esto
       es una caracterstica deliberada de diseo, ligada a la predecibilidad
       de la salida: NASM, al ver 'ADD ESP,8', generar la forma de la
       instruccin que deje espacio para un offset de 32-bits. Necesitas
       codificar 'ADD ESP,BYTE 8' si quieres la forma de la instruccin
       eficiente en espacio. Esto no es un bug: en el peor caso un defecto, y
       esto es slo cuestin de opiniones.

10.1.2 Mis saltos estn fuera de rango

       De forma similar, la gente se queja de que cuando comprueban saltos
       condicionales (que son 'SHORT' por defecto) intentan saltar demasiado
       lejos, NASM informa de 'short jump out of range' en lugar de hacer los
       saltos ms largos.

       Esto, nuevamente, es parcialmente una cuestin de predecibilidad, pero
       de hecho tiene una razn ms prctica. NASM no tiene medios de que se le
       diga en qu procesador se ejecutar el cdigo que est generando; por eso
       no puede decidir por s mismo si debera generar instrucciones del tipo
       'Jcc NEAR', porque no sabe que est trabajando en un 386 o superior.
       Alternativamente, podra sustituir el 'fuera de rango' de las
       instrucciones cortas 'JNE' con una instruccin 'JE' muy corta que salte
       sobre un 'JMP NEAR'; sta es una solucin sensata para procesadores
       inferiores al 386, pero poco eficiente en procesadores que tiene una
       buena prediccin de saltos _y_ podran haber usado en su lugar
       'JMP NEAR'. Por eso, una vez ms, es cosa del usuario, no del
       ensamblador, el decidir qu instruccin debera generar.

10.1.3 'ORG' no funciona

       Las personas que estn escribiendo programas del sector de arranque en el
       formato 'bin' a menudo se quejan de que 'ORG' no funciona de la manera
       que ellos quieren: para colocar la palabra de firma '0xAA55' al final de
       los 512 bytes de sector de arranque, las personas que usan MASN tienden a
       codificar

                 ORG 0
                 ; algo de cdigo del sector de arranque
                 ORG 510
                 DW 0xAA55

       Este no es el uso que se pretende de la directiva 'ORG' en NASM, y no
       funcionar. El modo correcto de solucionar este problema en NASM es usar
       la directiva 'TIMES', como sta:

                 ORG 0
                 ; algo de cdigo del sector de arranque
                 TIME 510-($-$$) DB 0
                 DW 0xAA55

       La directiva 'TIMES' insertar exactamente suficientes bytes cero en la
       salida para el punto de ensamblaje al 510. Este mtodo tambin tiene la
       ventaja de que si accidentalmente llenas demasiado tu sector de arranque,
       NASM detectar el problema en tiempo de ensamblaje e informar de ello,
       por eso no terminars con un sector de arranque que tendrs que
       desensamblar para encontrar qu es lo que est mal.

10.1.4 'TIMES' no funciona

       El otro problema comn con el cdigo de arriba es que la gente que
       escribe la lnea 'TIMES' as

                 TIMES 510-$ DB 0

       razonando que '$' debera ser un nmero puro, al igual que 510, por lo
       que la diferencia entre ellos es tambin un nmero puro y pude pasarse
       felizmente a 'TIMES'.

       NASM es un ensamblador _modular_: las distintas partes que lo componen
       estn diseadas para ser fcilmente separadas para reutilizarlas, por eso
       no intercambian informacin innecesariamente. En consecuencia, el formato
       de salida 'bin', incluso aunque se haya dicho mediante la directiva 'ORG'
       que el la seccin '.text' debera empezar en 0, no se pasa esta
       informacin de nuevo al evaluador de expresiones. Por eso desde el punto
       de vista del evaluador, '$' no es un nmero puro: es un offset desde la
       seccin base. Por lo tanto, la diferencia entre '$' y 510 tampoco es un
       nmero puro, sino que implica a la seccin base. Los valores que implican
       a la seccin base no se pueden pasar como argumentos a 'TIMES'.

       La solucin, como en la seccin previa, est en codificar la lnea de
       'TIMES' de la forma

                 TIMES 510-($-$$) DB 0

       en la cual '$' y '$$' son offsets desde la misma seccin base, y por eso
       su diferencia es un nmero puro. Esto resolver el problema y generar
       cdigo correcto.

  10.2 Bugs

       Nosotros nunca hemos sacado una versin de NASM con bugs _conocidos_.
       Aunque no solemos pararnos all donde no sabemos nada. Cualquiera que
       encuentres debera informarse a 'anakin@pobox.com'.

       Por favor, lee primero la seccin 2.2, y no informes del bug si est
       listado all como una caracterstica intencionada. (Si crees que la
       caracterstica est mal pensada, sintete libre de enviarnos las razones
       de por qu piensas que debera ser cambiado, pero no nos mandes slo un
       mensaje diciendo que 'Esto es un bug' si la documentacin dice que est
       as a propsito). Luego lee la seccin 10.1, y no te molestes de
       informarnos del bug si est listado all.

       Si informas de un bug, _por favor_ danos la siguiente informacin:

       (*) Qu sistema operativo ests usando para ejecutar NASM?. DOS, Linux,
           NetBSD, Win16, Win32, VMS (estara impresionado), o cualquiera que
           sea.

       (*) Si ests ejecutandop NASM bajo DOS o Win32, dinos si has compilado tu
           propio ejecutable desde el archivo fuente de DOS, o si ests usando
           los ficheros binarios de la distribucin estndar. Si ests usando
           un ejecutable construido de manera local, intenta reproducir el
           problema usando los ficheros binarios estndar, ya que nos facilitar
           las cosas para poder reproducir tu problema para poder arreglarlo.

       (*) Qu versin de NASM ests usando, y exactamente cmo lo invocas?.
           Danos la lnea de comandos precisa, y el contenido de la variable de
           entorno 'NASM', si la hay.

       (*) Qu versiones de cualquier programa suplementario que ests usando,
           y cmo los invocas?. Si el problema slo sa hace visible en el tiempo
           de compilacin, dinos el compilador que ests usando, qu versin
           tienes, y la lnea de comandos exacta. Si el problema implica enlazar
           ficheros objeto generados por un compilador, dinos qu compilador,
           qu versin, y qu lnea de comando u opciones has usado. (Si ests
           compilando en un IDE, por favor, intenta reproducir el problema con
           la versin del compilador de la lnea de comandos.)

       (*) Si es posible, mndanos un fichero de fuente NASM que presente el
           problema. Si esto causa problemas de Copyright (por ejemplo, slo
           puedes reproducir el bug en cdigo de distribucin restringida)
           entonces ten en mente los dos puntos siguiente: primeramente,
           garantizamos que cualquier cdigo fuente que se nos mande con fines
           para la depuracin de NASM sern usados _slo_ para el propsito de
           depurar NASM, y sern borradas todas nuestras copias tan pronto como
           hayamos encontrado y reparado el bug o los bugs en cuestin; y
           segundo, preferimos de cualquier forma que no se nos manden trozos
           grandes de cdigo. Cuanto menor sea el fichero, mejor. Un fichero de
           ejemplo de tres lneas que no haga nada til _excepto_ demostrarnos
           el problema es mucho mejor para trabajar que un programa funcional de
           diez mil lneas. (Por supuesto, algunos errores slo surgen en
           ficheros grandes, por eso esto podra no ser posible.)

       (*) Una descripcin de cul _es_ realmente el problema. 'No funciona'
           _no_ es una descripcin til!. Por favor, describe exactamente qu
           est pasando que no debera pasar, o qu es lo que no est pasando
           y debera. Algunos ejemplos podran ser: 'NASM me genera un mensaje
           de error diciendo Lnea 3 para un error que realmente est en la
           Lnea 5'; 'NASM genera un mensaje de error que creo que no debera
           generar en absoluto'; 'NASM no genera un mensaje de error que creo
           que _debera_ generar'; 'el fichero objeto producido desde este
           fuente hace fallar a mi enlazador'; 'el noveno byte del fichero de
           salida es 66 y creo que debera ser en su lugar 77'.

       (*) Si crees que el fichero de salida desde NASM es defectuoso,
           envanoslo. Esto nos permite determinar si nuestra propia copia de
           NASM genera el mismo fichero, o si el problema est relacionado con
           cuestiones de portabilidad entre nuestras plataformas de desarrollo
           y las tuyas. Nosotros podemos manejar ficheros binarios enviados con
           MIME, uuencode, e incluso BinHex. Alternativamente, podramos quiz
           proporcionarte un sitio FTP para que puedas subir los ficheros
           sospechosos; pero envindonoslos por correo es mucho ms fcil para
           nosotros.

       (*) Podra ser til cualquier otra informacin o fichero de datos. Si,
           por ejemplo, el problema implica un fallo de NASM al generar un
           fichero objeto mientras TASM puede generar sin problemas un fichero
           equivalente, entonces envanos _ambos_ ficheros objeto, as podremos
           ver qu est haciendo TASM distinto a nosotros.

Apndice A: Referencia a las instrucciones de Intel x86
-------------------------------------------------------

       Este apndice proporciona una lista completa de las instrucciones mquina
       qu NASM ensamblar, y una corta descripcin de la funcin de cada una.

       No es su intencin ser una documentacin exhaustiva de cada uno de los
       detalles de las funciones de las instrucciones, as como de las
       excepciones que pueden activar: para esta informacin, deberas ir a la
       Web de Intel, 'http://www.intel.com'.

       En su lugar, este apndice pretende principalmente proporcionar una
       documentacin del modo en que deberan usarse las instrucciones con NASM.
       Por ejemplo, buscando 'LOOP' te dir que NASM permite que se especifique
       'CX' o 'ECX' como un segundo argumento opcional para la instruccin
       'LOOP', para forzar cul de los dos posibles contadores debera usarse
       si el que est por defecto no es el deseado.

       las instrucciones no estn listadas en orden alfabtico, ya que los
       grupos de instrucciones con una funcin similar estn amontonadas juntas
       en la misma entrada. Muchas no estn muy lejos de su posicin alfabtica.

   A.1 Simbologa para la especificacin de operandos.

       Las descripciones de las instrucciones en este apndice especifican sus
       operandos usando la siguiente notacin:

       (*) Registros: 'reg8' denota un registro de uso general de 8-bit, 'reg16'
           denota un registro de uso general de 16-bit, y 'reg32' uno de 32-bit.
           'fpureg' denota uno de los ocho registros de pila de la FPU, 'mmxreg'
           denota uno de los ocho registros MMX de 64-bit, y 'segreg' denota un
           registro de segmento. Adicionalmente, algunos registros (como 'AL',
           'DX' o 'ECX') podran especificarse eplcitamente.

       (*) Operandos inmediatos: 'imm' denota un operando inmediato genrico.
           'imm8', 'imm16' e 'imm32' se usan cuando se pretende que el operando
           sea de un tamao especfico. Para algunas de estas instrucciones,
           NASM necesita un especificador explcito: por ejemplo, 'ADD ESP,16'
           podra interpretarse tanto como 'ADD r/m32,imm32' o como
           'ADD r/m32,imm8'. NASM elige la forma por defecto, y por eso debes
           especificar 'ADD ESP,BYTE 16' para esta ltima.

       (*) Referencias a memoria: 'mem' denota una referencia genrica a
           memoria; 'mem8', 'mem16', 'mem32', 'mem64' y 'mem80' se usan cuando
           el operando necesita tener un tamao especfico. Nuevamente, en
           algunos casos se necesita un especificador: 'DEC [address]' es
           ambiguo y NASM lo rechazar. Debes especificar en su lugar
           'DEC BYTES [address]', 'DEC WORD [address]' o 'DEC DWORD [address]'.

       (*) Referencias a memoria restringida: una forma de la instruccin 'MOV'
           permite especificar una direccin de memoria _sin_ permitir el rango
           normal de la combinacin de registros y procesado de direcciones
           efectivas. Esto se denota como 'memoffs8', 'memoffs16' y 'memoffs32'.

       (*) Elecciones entre registros o memoria: muchas instrucciones puden
           aceptar como un operando tanto un registro como una referencia a
           memoria. 'r/m8' es una abreviatura para 'reg8/mem8'; de forma similar
           'r/m16' y 'r/m32'. 'r/m64' est relacionado con MMX, y es una
           abreviatura de 'mmxreg/mem64'.

   A.2 Simbologa para las descripciones del cdigo de operacin

       Este apndice tambin proporciona los cdigo de operacin que NASM
       generar para cada forma de cada instruccin. Los cdigos de operacin
       estn listados de la siguiente forma:

       (*) Un nmero hexadecimal, como '3F', indica un byte fijo que contiene
           ese nmero.

       (*) Un nmero hexadecimal seguido de un '+r', como 'C8+r', indica que uno
           de los operandos de la instruccin es un registro, el 'valor del
           registro' de ese registro debera aadirse al nmero hexadecimal
           para producir el byte generado. Por ejemplo, EDX tiene un valor de
           registro de 2, por eso el cdigo 'C8+r', cuando el operando registro
           es EDX, genera el byte hexadecimal 'CA'. En la seccin A.2.1 se dan
           los valores de los registros para registros especficos.

       (*) Un nmero hexadecimal seguido de '+cc', como '40+cc', indica que el
           nombre de la instruccin tiene un cdigo de condicin como sufijo, y
           la representacin numrica del cdigo de condicin debera aadirse
           al nmero hexadecimal para producir el byte generado. Por ejemplo, el
           cdigo '40+cc', cuando la instruccin contiene la condicin 'NE',
           genera el byte hexadecimal '45'. Los cdigos de condicin y sus
           representaciones numricas se dan en la seccin A.2.2.

       (*) Una barra seguida de un dgito, como '/2', indica que uno de los
           operandos de la instruccin es una direccin de memoria o un
           registro (denotado 'mem' o 'r/m', con un tamao opcional). Esto es
           para codificarlo con una direccin efectiva, con un byte ModR/M, un
           byte SIB opcional, y un desplazamiento opcional, y el campo
           (registro) sobrante del byte ModR/M debera ser el dgito dado (que
           ser entre 0 y 7, por eso cabe en tre bits). La codificacin de la
           direccin efectiva se da en A.2.3.

       (*) El cdigo '/r' combina los dos de arriba: indica que uno de los
           operandos es una direccin de memoria o 'r/m', y el otro es un
           registro, y que una direccin efectiva se debera generar con el
           campo (registro) sobrante en el byte ModR/M siendo igual al 'valor
           del registro' del registro operando. La codificacin de la direccin
           efectiva se da en la seccin A.2.3; los valores de los registros se
           dan en la seccin A.2.1.

       (*) Los cdigos 'rb', 'rw' y 'rd' indican que uno de los operandos de la
           instruccin es un valor inmediato, y que la _diferencia_ entre este
           valor y la direccin del final de la instruccin se codifica como u
           byte, palabra o doble palabra respectivamente. Donde aparezca la
           forma 'rw/rd', indica que tanto 'rw' como 'rd' deberan usarse de
           manera acorde a si el ensamblaje se est haciendo en 'BITS 16' o
           'BITS 32'.

       (*) Los cdigos 'ow' y 'od' indican que uno de los operandos de la
           instruccin es una referencia al contenido de una direccin de
           memoria especificado como un valor inmediato: esta codificacin se
           usa en algunas formas de la instruccin 'MOV' en lugar del mecanismo
           estndar de direcciones efectivas. El desplazamiento se codifica como
           una palabra o doble palabra. Nuevamente, 'ow/od' denota que debera
           elegirse 'ow' o 'od' de acuerdo al establecimiento de 'BITS'.

       (*) Los cdigos 'o16' y 'o32' indican que la forma dada de la instruccin
           debera ensamblarse con un tamao de operando de 16 o de 32 bits. En
           otras palabras, 'o16' indica un prefijo '66' en el estado 'BITS 32',
           pero no genera ningn cdigo en el estado 'BITS 16'; y 'o32' indica
           un prefijo '66' en el estado 'BITS 16' pero no genera nada en
           'BITS 32'.

       (*) Los cdigos 'a16' y 'a32', de forma similar a 'o16' y 'o32', indican
           el tamao de la direccin para la forma dada de la instruccin.
           Cuando no coincida con 'BITS', requiere un prefijo '67'.

 A.2.1 Valores de los registros

       Donde una instruccin requiera un valor de registro, est ya implcito en
       la codificacin del resto de la instruccin que tipo de registro se
       desea: un registro de propsito general de 8-bit, un registro de
       segmento, un registro de depuracin, un registro MMX, o lo que sea. Por
       lo tanto, no hay ningn problema con los registros de diferentes tipos
       que comparten un valor de codificacin.

       Las codificaciones de la varias clases de registros son:

       (*) Registros generales de 8-bit: 'AL' es 0, 'CL' es 1, 'DL' es 2, 'BL'
           es 3, 'AH' es 4, 'CH' es 5, 'DH' es 6, y 'BH' es 7.

       (*) Registros generales de 16-bit: 'AX' es 0, 'CX' es 1, 'DX' es 2, 'BX'
           es 3, 'SP' es 4, 'BP' es 5, 'SI' es 6, y 'DI' es 7.

       (*) Registros generales de 32-bit: 'EAX' es 0, 'ECX' es 1, 'EDX' es 2,
           'EBX' es 3, 'ESP' es 4, 'EBP' es 5, 'ESI' es 6, y 'EDI' es 7.

       (*) Registros de segmento: 'ES' es 0, 'CS' es 1, 'SS' es 2, 'DS' es 3,
           'FS' es 4, y 'GS' es 5.

       (*) {Registros de punto flotante}: 'ST0' es 0, 'ST1' es 1, 'ST2' es 2,
           'ST3' es 3, 'ST4' es 4, 'ST5' es 5, 'ST6' es 6, y 'ST7' es 7.

       (*) Registros MMX de 64-bit: 'MM0' es 0, 'MM1' es 1, 'MM2' es 2, 'MM3' es
           3, 'MM4' es 4, 'MM5' es 5, 'MM6' es 6, y 'MM7' es 7.

       (*) Registros de control: 'CR0' es 0, 'CR2' es 2, 'CR3' es 3, y 'CR4'
           es 4.

       (*) Registros de depuracin: 'DR0' es 0, 'DR1' es 1, 'DR2' es 2, 'DR3'
           es 3, 'DR6' es 6, ' DR7' es 7.

       (*) Registros de comprobacin: 'TR3' es 3, 'TR4' es 4, 'TR5' es 5, 'TR6'
           es 6, y 'TR7' es 7.

       (Ntese que donde quiera que un registro contenga un nmero, ese nmero
       es tambin el valor del registro para ese registro.)

 A.2.2 Cdigos de condicin

       Los cdigos de condicin disponibles se dan aqu, con sus
       representaciones numricas como parte del su cdigo de operacin. Muchas
       de estos cdigos de condicin tienen sinnimos, por eso se listan varios
       a la vez.

       En las siguientes descripciones, la palabra 'o', cuando se aplica a dos
       posibles condiciones, se usa para decir 'una o ambas'. Si se quiere decir
       'una pero no ambas', se usa la frase 'exactamente una de'.

       (*) 'O' es 0 (se lanza si el flag de acarreo est activo); 'NO' es 1.

       (*) 'B', 'C' y 'NAE' son 2 (se lanzan si el flag de acarreo est activo);
           'AE', 'NB' y 'NC' son 3.

       (*) 'E' y 'Z' son 4 (se lanzan si el flag de cero est activo); 'NE' y
           'NZ' son 5.

       (*) 'BE' y 'NA' son 6 (se lanzan si el flag de acarreo o el de cero estn
           activos); 'A' y 'NBE' son 7.

       (*) 'S' es 8 (se lanza si el flag de signo est activo); 'NS' es 9.

       (*) 'P' y 'PE' son 10 (se lanzan si el flag de paridad est activo); 'NP'
           y 'PO' son 11.

       (*) 'L' y 'NGE' son 12 (se lanzan si exactamente el flag de signo o el de
           desbordamiento est activo); 'GE' y 'NL' son 13;

       (*) 'LE' y 'NG' son 14 (se lanzan si el flag de cero o exactamente el
           flag de signo o el de desbordamiento est activo); 'G' y 'NLE'
           son 15.

       Ntese que en todos los casos, el sentido de la condicin podra
       invertirse cambiando el bit bajo de la representacin numrica.

 A.2.3 Codificacin de la direccin efectiva: ModR/M y SIB

       Una direccin efectiva se codifica hasta en tres partes: un byte ModR/M,
       un byte SIB opcional, y un campo de desplazamiento opcional de un byte,
       palabra o doble palabra.

       El ModR/M consiste en tres campos: el campo 'mod', que va desde 0 a 3,
       en los dos bits ms altos del byte, el campo 'r/m', que va desde 0 a 7,
       en los tres bits ms bajos, y el campo (registro) sobrante en el medio
       (bits 3 al 5). El campo sobrante no es relevante para la direccin
       efectiva que est siendo codificada, y contiene una extensin al cdigo
       de operacin o el valor de registro de otro operando.

       El sistema ModR/M puede usarse para codificar una referencia directa a
       un registro en lugar de un acceso a memoria. Esto siempre se hace
       poniendo el campo 'mod' a 3 y el campo 'r/m' al valor de registro del
       registro en cuestin (debe ser un registro de propsito general, y el
       tamao del registro debe estar ya implcito en la codificacin del resto
       de la instruccin). En este caso, el byte SIB y el campo desplazamiento
       estn ausentes.

       En el modo de direccionamiento de 16-bit (ya sea 'BITS 16' sin el prefijo
       '67', o el 'BITS 32' con un prefijo '67'), el byte SIB nunca se usa. Las
       reglas generales para 'mod' y 'r/m' (hay una excepcin. dada abajo) son:

       (*) El campo 'mod' da la longitud del campo desplazamiento: 0 significa
           que no hay desplazamiento, 1 significa un byte, y 2 significa dos
           bytes.

       (*) El campo 'r/m' codifica la combinacin de registros para aadir al
           desplazamiento para dar la direccin accedida: 0 significa 'BX+SI',
           1 significa 'BX+DI', 2 significa 'BP+SI', 3 'BP+DI', 4 'SI' slo,
           5 'DI' slo, 6 'BP' slo, y 7 'BX' slo.

       Sin embargo, hay un caso especial:

       (*) Si 'mod' es 0 y 'r/m' es 6, la direccin efectiva codificada no es
           '[BP]' como sugieren las reglas de arriba, sino que es '[disp16]':
           el campo deplazamiento est presente y es de dos bytes de largo, y no
           se aaden registros al desplazamientos.

       Por lo tanto la direccin efectiva '[BP]' no puede codificarse tan
       eficientemente como '[BX]'; por eso, si codificas '[BP]' en un programa,
       NASM aadir un desplazamiento cero de 8-bit, y estabecer 'mod' a 1,
       'r/m' a 6, y el campo desplazamiento de un byte a 0.

       En el modo de direccionamiento de 32-bit (ya sea 'BITS 16' con un prefijo
       '67', o 'BITS 32' sin el prefijo '67') las reglas generales (nuevamente,
       hay excepciones) para 'mod' y 'r/m' son:

       (*) El campo 'mod' da la longitud del campo desplazamiento: 0 significa
           que no hay desplazamiento, 1 significa un byte, y 2 significa cuatro
           bytes.

       (*) Si slo se va a aadir un registro al desplazamiento, y no es 'ESP',
           el campo 'r/m' da su valor de registro, y el byte SIB est ausente.
           Si el campo 'r/m' es 4 (que codificara 'ESP'), est presente el byte
           SIB y da la combinacin y escalado de los registos que va a ser
           aadidos al desplazamiento.

       Si est presente el byte SIB, describe la combinacin de registros (un
       registro base opcional, y un registro ndice opcional escaldo mediante
       una multiplicacin por 1, 2, 4 u 8) a ser aadidos al desplazamiento. El
       byte SIB est dividido en el campo 'scale', en los dos bit superiores, el
       campo 'index' en los tres siguientes, y el campo 'base' en los ltimos
       tres. Las reglas generales son:

       (*) El campo 'base' codifica el valor de registro del registro base.

       (*) El campo 'index' codifica el valor de registro del registro ndice,
           a menos que sea 4, en cuyo caso no se usa registro ndice (por eso,
           no se puede usar 'ESP' como un registro ndice).

       (*) El campo 'scale' codifica el multiplicador por el cual se escala el
           registro ndice antes de aadirlo a la base y al desplazamiento:
           0 codifica un multiplicador de 1, 1 codifica 2, 2 codifica 4 y 3
           codifica 8.

       Las excepciones a las reglas de codificacin de 32-bits son:

       (*) Si 'mod' es 0 y 'r/m' es 5, la direccin efectiva codificada no es
           '[EBP]' como sugieren las reglas de arriba, sino que en su lugar es
           '[disp32]': el campo desplazamiento est presente y es de cuatro
           bytes, y no se aaden registros al desplazamiento.

       (*) Si 'mod' es 0, 'r/m' es 4 (lo que quiere decir que el byte SIB est
           presente) y 'base' es 4, la direccin efectiva codificada no es
           '[EBP+index]' como sugieren las reglas de arriba, sino que es
           '[disp32+index]': el campo desplazamiento est presente y es de
           cuatro bytes de largo, y no hay registro base (pero el registro
           ndice todava se procesa de la forma normal).

   A.3 Simbologa de los flags de instruccin

       Con cada instruccin en este apndice se da un conjunto de flags,
       denotando el tipo de instruccin. Los tipos son los siguientes:

       (*) '8086', '186', '286', '386', '486', 'PENT' y 'P6' denotan el
           procesador ms bajo que soporta la instruccin. La mayora de las
           instrucciones corrern en todos los procesadores por encima del tipo
           dado; aquellos que no estn documentadas. El Pentium II no contiene
           ninguna instruccin adicional ms all del P6 (Pentium Pro); desde el
           punto de vista del conjunto de instrucciones, podra pensarse como un
           P6 con capacidad MMX.

       (*) 'CYRIX' indica que la instruccin es especfica de los procesadores
           Cyrix, por ejemplo las instrucciones MMX extra en el conjunto
           extendido de instrucciones MMX.

       (*) 'FPU' indica que la instruccin es una de coma flotante, y slo
           ejecutar en ordenadores con coprocesador (incluido automticamente
           en los 486DX, Pentium y superiores).

       (*) 'MMX' indica que esa instruccin es una de MMX, y correr en
           procesadores Pentium con capacidad MMX o en el Pentium II.

       (*) 'PRIV' indica que esa instruccin es una instruccin de manejo del
           modo protegido. Muchas de estas podran usarse slo en modo
           protegido, o en un nivel de priviliegio cero.

       (*) 'UNDOC' indica que esa instruccin est indocumentada, y no es parte
           la Arquitectura Intel oficial; podra o no ser soportada por una
           determinada mquina.

   A.4 'AAA', 'AAS', 'AAM', 'AAD': Ajustes ASCII

       AAA                           ; 37                   [8086]

       AAS                           ; 3F                   [8086]

       AAD                           ; D5 0A                [8086] 
       AAD imm                       ; D5 ib                [8086]

       AAM                           ; D4 0A                [8086] 
       AAM imm                       ; D4 ib                [8086]

       Estas instrucciones se usan en conjuncin con las instruccions de suma,
       resta, multiplicacin y divisin para realizar aritmtica binaria
       codificada decimal en forma _desempaquetada_ (un dgito BCD por byte -
       por lo tanto los nombres de la instruccin, fcil de traducir a y desde
       ASCII). Hay tambin instrucciones BCD empaquetadas 'DAA' y 'DAS': ver la
       seccin A.23.

       'AAA' debera usarse despus de una instruccin 'ADD' de un byte cuyo
       destino haya sido el registro 'AL': mediante el examen del valor en el
       nibble bajo de 'AL' y tambin el flag auxiliar de acarreo 'AF', determina
       si la suma tiene desbordamiento, y lo ajusta (y activa el flag de
       acarreo) si es necesario. Puedes sumar juntas cadenas BCD largas haciendo
       'ADD'/'AAA' en los bits bajos, luego haciendo 'ADC'/'AAA' en cada uno de
       los bits subsiguientes.

       'AAS' funciona de forma similar a 'AAA', pero es para usar despus la
       instruccin 'SUB' en lugar de 'ADD'.

       'AAM' es para usar despus de que hayas multiplicado juntos dos dgitos
       decimales y dejes el resultado en 'AL': esto divide 'AL por diez y
       almacena el cociente en 'AH', dejando el resto en 'AL'. El divisor 10
       puede cambiarse especificando un operando en la inastruccin: un uso de
       esto particularmente prctico es 'AAM 16', haciendo que los dos nibbles
       en 'AL' se separen en 'AH' y 'AL'.

       'AAD' realiza la operacin inversa a 'AAM': multiplica 'AH' por diez, lo
       suma a 'AL', y pone 'AH' a cero. Nuevamente, el multiplicador 10 se puede
       cambiar.

   A.5 'ADC': Suma con acarreo

       ADC r/m8,reg8                 ; 10 /r                [8086]
       ADC r/m16,reg16               ; o16 11 /r            [8086] 
       ADC r/m32,reg32               ; o32 11 /r            [386]

       ADC reg8,r/m8                 ; 12 /r                [8086] 
       ADC reg16,r/m16               ; o16 13 /r            [8086] 
       ADC reg32,r/m32               ; o32 13 /r            [386]

       ADC r/m8,imm8                 ; 80 /2 ib             [8086] 
       ADC r/m16,imm16               ; o16 81 /2 iw         [8086] 
       ADC r/m32,imm32               ; o32 81 /2 id         [386]

       ADC r/m16,imm8                ; o16 83 /2 ib         [8086] 
       ADC r/m32,imm8                ; o32 83 /2 ib         [386]

       ADC AL,imm8                   ; 14 ib                [8086] 
       ADC AX,imm16                  ; o16 15 iw            [8086] 
       ADC EAX,imm32                 ; o32 15 id            [386]

       'ADC' realiza la suma entera: suma los dos operandos, ms el valor del
       flag de acarreo, y deja el resultado en su operando (el primero) destino.
       Los flag se activan de acuerdo al resultado de la operacin: en
       particular, se afecta al flag de acarreo y una instruccin 'ADC'
       subsiguiente puede hacer uso de l.

       En las formas con un inmediato de 8-bit como segundo operando y un primer
       operando ms largo, el segundo operando se considera con signo, y se hace
       extensin de signo hasta la longitud del primer operando. En estos casos,
       el calificador 'BYTE' se necesita para forzar a NASM a generar esta forma
       de la instruccin.

       Para sumar dos nmeros sin sumar el contenido del flag de acarreo, usa
       'ADD' (seccin A.6).

   A.6 'ADD': Sumar enteros

       ADD r/m8,reg8                 ; 00 /r                [8086]
       ADD r/m16,reg16               ; o16 01 /r            [8086] 
       ADD r/m32,reg32               ; o32 01 /r            [386]

       ADD reg8,r/m8                 ; 02 /r                [8086] 
       ADD reg16,r/m16               ; o16 03 /r            [8086] 
       ADD reg32,r/m32               ; o32 03 /r            [386]

       ADD r/m8,imm8                 ; 80 /0 ib             [8086] 
       ADD r/m16,imm16               ; o16 81 /0 iw         [8086] 
       ADD r/m32,imm32               ; o32 81 /0 id         [386]

       ADD r/m16,imm8                ; o16 83 /0 ib         [8086] 
       ADD r/m32,imm8                ; o32 83 /0 ib         [386]

       ADD AL,imm8                   ; 04 ib                [8086] 
       ADD AX,imm16                  ; o16 05 iw            [8086] 
       ADD EAX,imm32                 ; o32 05 id            [386]

       'ADD' realiza la suma entera: suma sus dos operandos, y deja el resultado
       en el operando (el primero) destino. Los flags se activan de acuerdo al
       resultado de la operacin: en particular, se afecta al flag de acarreo y
       puede usarse en subsiguientes instrucciones 'ADC' (seccin A.5).

       En las formas con un inmediato de 8-bit como segundo operando y un primer
       operando ms largo, el segundo operando se considera con signo, y se le
       hace extensin de signo hasta la longitud del primer operando. En estos
       casos, se necesita el calificador 'BYTE' para forzar a NASM a generar
       esta forma de la instruccin.

   A.7 'AND': AND a nivel de bit

       AND r/m8,reg8                 ; 20 /r                [8086]
       AND r/m16,reg16               ; o16 21 /r            [8086] 
       AND r/m32,reg32               ; o32 21 /r            [386]

       AND reg8,r/m8                 ; 22 /r                [8086] 
       AND reg16,r/m16               ; o16 23 /r            [8086] 
       AND reg32,r/m32               ; o32 23 /r            [386]

       AND r/m8,imm8                 ; 80 /4 ib             [8086] 
       AND r/m16,imm16               ; o16 81 /4 iw         [8086] 
       AND r/m32,imm32               ; o32 81 /4 id         [386]

       AND r/m16,imm8                ; o16 83 /4 ib         [8086] 
       AND r/m32,imm8                ; o32 83 /4 ib         [386]

       AND AL,imm8                   ; 24 ib                [8086] 
       AND AX,imm16                  ; o16 25 iw            [8086] 
       AND EAX,imm32                 ; o32 25 id            [386]

       'AND' realiza la operacin AND entre bits entre sus dos operandos (esto
       es, cada bit del resultado es 1 si y slo si los bits correspondientes de
       las dos entradas son ambos 1), y almacena el resultado en el operando
       (el primero) destino.

       En las formas con un inmediato de 8-bit como segundo operando y un primer
       operando ms largo, el segundo opearando se considera con signo, y se le
       hace extensin de signo hasta la longitud del primer operando. En estos
       casos, se necesita el calificador 'BYTE' para forzar a NASM a generar
       esta forma de la instruccin.

       La instruccin MMX 'PAND' (ver ka seccin A.116) realiza la misma
       operacin en los registros MMX de 64-bit.

   A.8 'ARPL': Ajusta el campo RPL del selector

       ARPL r/m16,reg16              ; 63 /r                [286,PRIV]

       'ARPL' espera que sus dos palabras operando sean selectores de segmento.
       Esto ajusta el campo RPL (se requiere nivel de privilegio - almacenado en
       los dos bits ms inferiores del selector) del operando (el primero)
       destino para asegurar que no es menos (esto es, no es ms privilegiado
       que) el campo RPL del operando fuente. Se activa el flag de cero si y
       slo si se ha hecho algn cambio.

   A.9 'BOUND': Comprueba los ndices de array contra redondeos

       BOUND reg16,mem               ; o16 62 /r            [186]
       BOUND reg32,mem               ; o32 62 /r            [386]

       'BOUND' espera que su segundo operando apunte a un rea de memoria que
       contenga dos valores con signo del mismo tamao que su primer operando
       (esto es, dos palabras para la forma de 16-bit; dos palabras dobles para
       la forma de 32-bit). Esto realiza dos comparaciones con signo: si el
       valor en el registro pasado como primer operando es menor que el primero
       de los valores en memoria, o es mayor o igual que el segundo, lanza una
       excepcin BR. De otro modo, no hace nada.

  A.10 'BSF', 'BSR': Examinar bits

       BSF reg16,r/m16               ; o16 0F BC /r         [386]
       BSF reg32,r/m32               ; o32 0F BC /r         [386]

       BSR reg16,r/m16               ; o16 0F BD /r         [386] 
       BSR reg32,r/m32               ; o32 0F BD /r         [386]

       'BSF' busca un conjunto de bits en su operando (el segundo) fuente,
       empezando desde la parte inferior, y si encuentra uno, almacena el ndice
       en su operando (el primero) destino. Si no se encuentra el conjunto de
       bits, el contenido del operando destino est indefinido.

       'BSR' realiza la misma funcin, pero en su lugar busca desde la parte
       superior, por eso encuentra el conjunto de bits ms significativos.

       Los ndices de los bits son desde 0 (menos significante) hasta 15 o 31
       (ms significante).

  A.11 'BSWAP': Intercambio de bytes

       BSWAP reg32                   ; o32 0F C8+r          [486]

       'BSWAP' intercambia el orden de los cuatro bytes de un registro de
       32-bit: los bits del 0-7 intercambian su lugar con los bits del 24-31,
       y los bits 8-15 se intercambian con los bits 16-23. No hay un equivalente
       explcito de 16-bit: para intercambiar los bytes en 'AX', 'BX', 'CX' o
       'DX', se puede usar 'XCHG'.

  A.12 'BT', 'BTC', 'BTR', 'BTS': Comprobacin de bits

       BT r/m16,reg16                ; o16 0F A3 /r         [386]
       BT r/m32,reg32                ; o32 0F A3 /r         [386] 
       BT r/m16,imm8                 ; o16 0F BA /4 ib      [386] 
       BT r/m32,imm8                 ; o32 0F BA /4 ib      [386]

       BTC r/m16,reg16               ; o16 0F BB /r         [386] 
       BTC r/m32,reg32               ; o32 0F BB /r         [386] 
       BTC r/m16,imm8                ; o16 0F BA /7 ib      [386] 
       BTC r/m32,imm8                ; o32 0F BA /7 ib      [386]

       BTR r/m16,reg16               ; o16 0F B3 /r         [386] 
       BTR r/m32,reg32               ; o32 0F B3 /r         [386] 
       BTR r/m16,imm8                ; o16 0F BA /6 ib      [386] 
       BTR r/m32,imm8                ; o32 0F BA /6 ib      [386]

       BTS r/m16,reg16               ; o16 0F AB /r         [386] 
       BTS r/m32,reg32               ; o32 0F AB /r         [386] 
       BTS r/m16,imm                 ; o16 0F BA /5 ib      [386] 
       BTS r/m32,imm                 ; o32 0F BA /5 ib      [386]

       Todas estas instrucciones comprueban un bit de su primer operando, cuyo
       ndice lo da el segundo operando, y almacena el valor de ese bit en el
       flag de acarreo. Los ndices de los bits van desde 0 (menos
       significativo) hasta 15 o 31 (ms significativo).

       Adicionalmente al almacenar el valor original del bit en el flag de
       acarreo, 'BTR' tambin limpia el bit en el operando. 'BTS' activa el bit,
       y 'BTC' complementa el bit. 'BT' no modifica el operando.

       El offset del bit no debera ser ms grande que el tamao del operando.

  A.13 'CALL': Llamar a una subrutina

       CALL imm                      ; E8 rw/rd             [8086]
       CALL imm:imm16                ; o16 9A iw iw         [8086] 
       CALL imm:imm32                ; o32 9A id iw         [386] 
       CALL FAR mem16                ; o16 FF /3            [8086] 
       CALL FAR mem32                ; o32 FF /3            [386] 
       CALL r/m16                    ; o16 FF /2            [8086] 
       CALL r/m32                    ; o32 FF /2            [386]

       'CALL' llama a una subrutina, mediante empujar el puntero de la
       instruccin actual ('IP') y opcionalmente 'CS', a la pila, y luego
       saltando a la direccin dada.

       Se empuja 'CS' al igual que 'IP' si y slo si la llamada es una llamada
       lejana, esto es, se especifica en la instruccin una direccin de
       segmento de destino. Las formas que implican dos argumentos separados por
       dos puntos son llamadas lejanas; por eso son las formas 'CALL FAR mem'.

       Puedes elegir entre las dos formas inmediatas de llamadas lejanas
       ('CALL imm:imm') usando las palabras clave 'WORD' y 'DWORD':
       'CALL WORD 0x1234:0x5678') o 'CALL DWORD 0x1234:0x56789abc'.

       Las formas 'CALL FAR mem' ejecutan una llamada lejana mediante la carga
       de la direccin de destino por la memoria. La direccin cargada
       consisten en un offset de 16 o 32 bits (dependiendo del tamao del
       operando), y 16 bits de segmento. El tamao del operando puede
       superponerse usando 'CALL WORD FAR mem' o 'CALL DWORD FAR mem'.

       Las formas 'CALL r/m' ejecutan una llamada cercana (dentro del mismo
       segmento), cargando la direccin de destino por memoria o por un
       registro. Podra especificarse la palabra clave 'NEAR', para mayor
       claridad, es estas formas, pero no es necesario. Nuevamente, se puede
       superponer el tamao del operando usando 'CALL WORD mem' o
       'CALL DWORD mem'.

       Como conveniencia, NASM no te pide que llames a un procedimiento lejano
       codificando la molesta 'CALL SEG rutina:rutina', sino que en su lugar
       permite el sinnimo ms fcil 'CALL FAR rutina'.

       Las formas 'CALL r/m' dadas arriba son llamadas cercanas; NASM aceptar
       la palabra clave 'NEAR' (por ejemplo, 'CALL NEAR [address]'), incluso
       aunque no sea estrictamente necesario.

  A.14 'CBW', 'CWD', 'CDQ', 'CWDE': Extensiones del signo

       CBW                           ; o16 98               [8086]
       CWD                           ; o16 99               [8086] 
       CDQ                           ; o32 99               [386] 
       CWDE                          ; o32 98               [386]

       Todas estas instrucciones hacen extensin de signo de un valor corto a
       otro ms largo, replicando el bit superior del valor original para
       rellenar el valor extendido.

       'CBW' extiende 'AL' en 'AX' repitiendo el bit superior de 'AL' en cada
       uno de los bits de 'AH'. 'CWD' extiende 'AX' en 'DX:AX' repitiendo el
       bit superior de 'AX' por todo 'DX'. 'CWDE' extiende 'AX' en 'EAX', y
       'CDQ' extiende 'EAX' en 'EDX:EAX'.

  A.15 'CLC', CLD', 'CLI', 'CLTS': Limpiar flags

       CLC                           ; F8                   [8086]
       CLD                           ; FC                   [8086] 
       CLI                           ; FA                   [8086] 
       CLTS                          ; 0F 06                [286,PRIV]

       Estas instrucciones limpian diversos flags. 'CLC' limpia el flag de
       acarreo; 'CLD' limpia el flag de direccin; 'CLI' limpia el flag de
       interrupcin (deshabilitando as las interrupciones); y 'CLTS' limpia el
       flag de cambio de tareas ('TS') en 'CR0'.

       Para activar los flags de acarreo, direccin o interrupcin, usa las
       instrucciones 'STC', 'STD' y 'STI' (seccin A.156). Para invertir el
       flag de acarreo, usa 'CMC' (seccin A.16).

  A.16 'CMC': Complementa el flag de acarreo

       CMC                           ; F5                   [8086]

       'CMC' cambia el valor del flag de acarreo: si era 0, se pone a 1, y
       viceversa.

  A.17 'CMOVcc': 'Move' condicional

       CMOVcc reg16,r/m16            ; o16 0F 40+cc /r      [P6]
       CMOVcc reg32,r/m32            ; o32 0F 40+cc /r      [P6]

       'CMOV' mueve su operando (el segundo) fuente a su operando (el primero)
       destino si se satisface el cdigo condicional que se da; de otra forma no
       hace nada.

       Para ver una lista de los cdigos de condiciones, ver la seccin A.2.2.

       Aunque la instruccin 'CMOV' est marcada como 'P6' o superior, podra
       no estar soportada por todos los procesadores Pentium Pro; la instruccin
       'CPUID' (seccin A.22) devolver un bit que indica si estn soportados
       los movimientos condicionales.

  A.18 'CMP': Compara enteros

       CMP r/m8,reg8                 ; 38 /r                [8086]
       CMP r/m16,reg16               ; o16 39 /r            [8086] 
       CMP r/m32,reg32               ; o32 39 /r            [386]

       CMP reg8,r/m8                 ; 3A /r                [8086] 
       CMP reg16,r/m16               ; o16 3B /r            [8086] 
       CMP reg32,r/m32               ; o32 3B /r            [386]

       CMP r/m8,imm8                 ; 80 /0 ib             [8086] 
       CMP r/m16,imm16               ; o16 81 /0 iw         [8086] 
       CMP r/m32,imm32               ; o32 81 /0 id         [386]

       CMP r/m16,imm8                ; o16 83 /0 ib         [8086] 
       CMP r/m32,imm8                ; o32 83 /0 ib         [386]

       CMP AL,imm8                   ; 3C ib                [8086] 
       CMP AX,imm16                  ; o16 3D iw            [8086] 
       CMP EAX,imm32                 ; o32 3D id            [386]

       'CMP' realiza una resta 'mental' de su segundo operando del primero, y
       afecta a los flags como si hubiese tenido lugar una resta, pero no
       almacena en ningn lugar el resultado de la resta.

       En las formas con inmediatos de 8-bit como segundo operando y un primer
       operando ms largo, el segundo operando se considera con signo, y se le
       hace extensin de signo hasta la longitud del primer operando. En estos
       casos, se necesita el calificador 'BYTE' para forzar a NASM a generar
       esta forma de la instruccin.

  A.19 'CMPSB', 'CMPSW', 'CMPSD': Compara cadenas

       CMPSB                         ; A6                   [8086]
       CMPSW                         ; o16 A7               [8086] 
       CMPSD                         ; o32 A7               [386]

       'CMPSB' compara el byte en '[DS:SI]' o '[DS:ESI]' con el byte en
       '[ES:DI]' o '[ES:EDI]', y activa los flag de manera acorde. Luego
       incrementa o decrementa (dependiendo del flag de direccin: incrementa si
       el flag est limpio, decrementa si est activo) 'SI' y 'DI' (o 'ESI' y
       'EDI').

       Los registros usados son 'SI' y 'DI' si el tamao de la direccin es de
       16 bits, y 'ESI' y 'EDI' si son de 32 bits. Si necesitas usar un tamao
       de direccin diferente al actual 'BITS', puedes usar explctamente un
       prefijo 'a16' o 'a32'.

       El registro de segmento usado para cargar desde '[SI]' o '[ESI]' se puede
       superponer usando el nombre de un registro de segmento como un prefijo
       (por ejemplo, 'es cmpsb'). El uso de 'ES' para cargar desde '[DI]' o
       '[EDI]' no se puede superponer.

       'CMPSW' y 'CMPSD' funcionan del mismo modo, pero comparan una palabra o
       una palabra doble en lugar de un byte, e incrementan o decrementan los
       registros de direccionamiento en 2  4 en lugar de en 1.

       Los prefijos 'REPE' y 'REPNE' (de forma equivalente, 'REPZ' y 'REPNZ')
       podra usarse para repetir la instruccin hasta 'CX' veces (o 'ECX' -
       nuevamente el tamao de la direccin determina cul) hasta que se
       encuentre el primer byte igual o diferente.

  A.20 'CMPXCHG', 'CMPCHG486': Compara e intercambia

       CMPXCHG r/m8,reg8             ; 0F B0 /r             [PENT]
       CMPXCHG r/m16,reg16           ; o16 0F B1 /r         [PENT] 
       CMPXCHG r/m32,reg32           ; o32 0F B1 /r         [PENT]

       CMPXCHG486 r/m8,reg8          ; 0F A6 /r             [486,UNDOC] 
       CMPXCHG486 r/m16,reg16        ; o16 0F A7 /r         [486,UNDOC] 
       CMPXCHG486 r/m32,reg32        ; o32 0F A7 /r         [486,UNDOC]

       Estas dos instrucciones realizan exactamente la misma operacin; sin
       embargo, aparentemente, algunos (no todos) procesadores 486 las soportan
       bajo un cdigo de operacin no estndar, por eso NASM proporciona la
       forma no documentada de 'CMPXCHG486' para generar el cdigo de operacin
       no estndar.

       'CMPXCHG' compara su operando (el primero) destino con el valor en 'AL',
       'AX' o 'EAX' (dependiendo del tamao de la instruccin). Si son iguales,
       copia su operando (el segundo) origen en el destino y activa el flag de
       cero. De otro modo, limpia el flag de cero y deja el destino solo.

       'CMPXCHG' viene bien usarlo para operaciones atmicas en entornos
       multitarea o multiprocesador. Para actualizar de forma segura un valor en
       memoria compartida, por ejemplo, podras cargar el valor en 'EAX', cargar
       el valor actualizado en 'EBX', y luego ejecutar la instruccin
       'lock cmpxchg [value],ebx'. Si 'value' no ha cambiado desde que fue
       cargado, es actualizado con tu nuevo valor deseado, y se activa el flag
       de cero para hacerte saber que ha funcionado. (El prefijo 'LOCK' previene
       el que otro procesador haga otra cosa en mitad de esta operacin:
       garantiza la atomicidad.) Sin embargo, si otro procesador ha modificado
       el valor entre tu carga y tu intento de almacenarlo, el almacenaje no
       tiene lugar, y se te avisa del fallo mediante un flag de cero limpio, por
       eso puedes volver atrs y volverlo a intentar.

  A.21 'CMPXCHG8B': Compara e interacambia ocho bytes

       CMPXCHG8B mem                 ; 0F C7 /1             [PENT]

       Esta es una versin mayor y ms difcil de usar de 'CMPXCHG': compara el
       valor de 64-bit (ocho bytes) almacenado en '[mem]' con el valor en
       'EDX:EAX'. Si son iguales, se activa el flag de cero y almacena 'ECX:EBX'
       en el rea de memoria. Si son diferentes, limpia el flag de cero y deja
       sin tocar el rea de memoria.

  A.22 'CPUID': Coge el cdigo de identificacin de la CPU

       CPUID                         ; 0F A2                [PENT]

       'CPUID' devuelve diversa informacin sobre el procesador en que est
       siendo ejecutada. Llena los cuatro registros 'EAX', 'EBX', 'ECX' y 'EDX'
       con informacin, que vara dependiendo del contenido de entrada de 'EAX'.

       'CPUID' tambin acta como una barrera para serializar la ejecucin de
       las instrucciones: ejecutar la instruccin 'CPUID' te garantiza que todos
       los efectos (modificaciones de memoria, modificaciones de flags,
       modificaciones de los registros) de las instrucciones previas se han
       completado antes de que se prepare la siguiente instruccin.

       La informacin devuelta es como sigue:

       (*) Si 'EAX' es cero en la entrada, 'EAX' en la salida contiene el mximo
           valor de entrada de 'EAX', y 'EAB:EDX:ECX' contiene la cadena
           '"GenuineIntel"' (o no, si tienes un procesador clnico). Esto es
           decir, 'EBX' contiene '"Genu"' (en el sentido propio de las
           constantes carcter en NASM, descrito en la seccin 3.4.2), 'EDX'
           contiene '"ineI"' y 'ECX' contiene '"ntel"'.

       (*) Si 'EAX' vale uno en la entrada, 'EAX' en la salida contiene la
           versin de la informacin sobre el procesador, y 'EDX' contiene un
           conjunto de flag caractersticos, mostrando la presencia y ausencia
           de distintas caractersticas. Por ejemplo, el bit 8 se activa si se
           soporta la instruccin 'CMPXCHG8B' (seccin A.21), el bit 15 se
           activa si se soportan las instrucciones de movimientos condicionales
           (seccin A.17 y seccin A.34), y el bit 23 se activa si se soportan
           instrucciones MMX.

       (*) Si 'EAX' tiene un dos en la entrada, 'EAX', 'EBX', 'ECX' y 'EDX'
           contienen informacin sobre cachs y TLBs (Translation Lookahead
           Buffers).

       Para ver ms informacin sobre los datos devueltos desde 'CPUID', ver la
       documentacin en el Web de Intel.

  A.23 'DAA', 'DAS': Ajustes decimales

       DAA                           ; 27                   [8086]
       DAS                           ; 2F                   [8086]

       Estas instrucciones se usan en conjuncin con las instrucciones de suma
       y resta para realizar aritmtica binaria codificada decimal en forma
       _empaquetada_ (un dgito BCD por cada nibble). Para ver las equivalentes
       desempaquetadas, ir a la seccin A.4.

       'DAA' debera usarse despus de una instruccin 'ADD' de un byte cuyo
       destino fuese el registro 'AL': examinando el valor en el 'AL' y tambin
       al flag auxiliar 'AF', determina si un dgito ha sufrido desbordamiento,
       y lo ajusta si es necesario (y activa los flag de acarreo y auxiliar).
       Puedes sumar largas cadenas BCD haciendo 'ADD'/'DAA' en los dos dgitos
       inferiores, luego haciendo 'ADC'/'DAA' en cada par de dgitos
       subsiguientes.

       'DAS' funciona de modo similar a 'DAA', pero es para usar despus de
       instrucciones 'SUB' en lugar de 'ADD'.

  A.24 'DEC': Decremento entero

       DEC reg16                     ; o16 48+r             [8086]
       DEC reg32                     ; o32 48+r             [386] 
       DEC r/m8                      ; FE /1                [8086] 
       DEC r/m16                     ; o16 FF /1            [8086] 
       DEC r/m32                     ; o32 FF /1            [386]

       'DEC' resta 1 de su operando. _No_ afecta al flag de acarreo: para
       afectar al flag de acarreo, usa 'SUB something,1' (ver la seccin A.159).
       Ver tambin 'INC' (seccin A.79).

  A.25 'DIV': Divisin entera sin signo

       DIV r/m8                      ; F6 /6                [8086]
       DIV r/m16                     ; o16 F7 /6            [8086] 
       DIV r/m32                     ; o32 F7 /6            [386]

       'DIV' realiza la divisin entera sin signo. El operando explcito
       proporcionado es el divisor; los operandos dividendo y destino estn
       implcitos, del siguiente modo:

       (*) Para 'DIV r/m8', 'AX' se divide por el operando dado; el cociente
           se almacena en 'AL' y el resto en 'AH'.

       (*) Para 'DIV r/m16', 'DX:AX' se divide por el operando dado; el cociente
           se almacena en 'AX' y el resto en 'DX'.

       (*) Para 'DIV r/m32', 'EDX:EAX' se divide por el operando dado; el
           cociente se almacena en 'EAX' y el resto en 'EDX'.

       La divisin entera con signo se realiza con la instruccin 'IDIV': ver
       la seccin A.76.

  A.26 'EMMS': Estado MMX vaco

       EMMS                          ; 0F 77                [PENT,MMX]

       'EMMS' activa la palabra etiqueta FPU (indicando que registros de coma
       flotante estn disponibles) a todos, lo que quiere decir que todos los
       registros estn disponibles para la FPU. Debera usarse despus de
       ejecutar instrucciones MMX y antes de ejecutar cualquier operacin de
       coma flotante subsiguiente.

  A.27 'ENTER': Crea un marco de pila

       ENTER imm,imm                 ; C8 iw ib             [186]

       'ENTER' construye un marco de pila para una llamda a un procedimiento de
       alto nivel. El primer operando (el 'iw' en la definicin del cdigo de
       operacin de arriba se refiere al primer operando) da la cantidad de
       espacio de pila para asignar las variables locales; el segundo (el 'ib'
       de arriba) da el nivel de anidamiento del procedimiento (para lenguajes
       como Pascal, con procedimientos anidados).

       La funcin 'ENTER', con un nivel de anidamiento de cero, es
       equivalente a

                 PUSH EBP            ; o PUSH BP         en 16 bits
                 MOV EBP,ESP         ; o MOV BP,SP       en 16 bits
                 SUB ESP,operand1    ; o SUB SP,operand1 en 16 bits

       Esto crea un marco de pila con los parmetros del procedimiento
       accesibles hacia arriba de 'EBP', y las variables locales accesibles
       desde 'EBP' hacia abajo..

       Con un nivel de anidamiento de uno, el marco de pila creado es 4 ( 2)
       bytes ms grande, y el valor del puntero de marco final 'EBP' est
       accesible en memoria en '[EBP-4]'.

       Esto permite a 'ENTER', cuando es llamada con un nivel de anidamiento de
       dos, considerando el marco de pila descrito por el valor _previo_ de
       'EBP', encontrar el puntero de marco en un offset -4 desde ste, y
       empujarlo con el nuevo puntero de marco, por eso cuando se llama a un
       procedimiento de nivel dos desde un procedimiento de nivel uno,
       '[EBP-4]' contiene el puntero de marco de la llamada de procedimiento de
       nivel uno ms reciente y '[EBP-8]' contiene la llamada de procedimiento
       de nivel dos ms reciente. Y as, para niveles de anidamiento de hasta
       nivel 31.

       Los marcos de pila creados con 'ENTER' se pueden destruir con la
       instruccin 'LEAVE': ver la seccin A.94.

  A.28 'F2XM1': Calcula 2**X-1

       F2XM1                         ; D9 F0                [8086,FPU]

       'F2XM1' eleva 2 a la potencia de 'ST0', resta uno, y almacena el
       resultado de nuevo en 'ST0'. El contenido inicial de 'ST0' debe ser un
       nmero del rango -1 a +1.

  A.29 'FABS': Valor absoluto de coma flotante

       FABS                          ; D9 E1                [8086,FPU]

       'FABS' calcula el valor absoluto de 'ST0', almacenando el resultado de
       nuevo en 'ST0'.

  A.30 'FADD', 'FADDP': Suma en coma flotante

       FADD mem32                    ; D8 /0                [8086,FPU]
       FADD mem64                    ; DC /0                [8086,FPU]

       FADD fpureg                   ; D8 C0+r              [8086,FPU] 
       FADD ST0,fpureg               ; D8 C0+r              [8086,FPU]

       FADD TO fpureg                ; DC C0+r              [8086,FPU] 
       FADD fpureg,ST0               ; DC C0+r              [8086,FPU]

       FADDP fpureg                  ; DE C0+r              [8086,FPU] 
       FADDP fpureg,ST0              ; DE C0+r              [8086,FPU]

       'FADD', dado un operando, suma el operando a 'ST0' y almacena el
       resultado de nuevo en 'ST0'. Si el operando tiene el modificador 'TO',
       el resultado se almacena en el registro dado en lugar de en 'ST0'.

       'FADDP' realiza la misma funcin que 'FADD TO', pero saca la pila de
       registros despus de almacenar el resultado.

       La forma de dos operandos es sinnimo de la forma de un operando.

  A.31 'FBLD', 'FBSTP': Carga y almacenamiento de BCD en coma flotante

       FBLD mem80                    ; DF /4                [8086,FPU]
       FBSTP mem80                   ; DF /6                [8086,FPU]

       'FBLD' carga un nmero empaquetado codificado decimal de 80-bits (diez
       bytes) desde la direccin de memoria dada, lo convierte a real, y lo
       empuja a la pila de registros. 'FBSTP' almacena el valor de 'ST0',
       en BCD empaquetado, en la direccin dada y luego saca la pila de
       registros.

  A.32 'FCHS': Cambio de signo en coma flotante

       FCHS                          ; D9 E0                [8086,FPU]

       'FCHS' niega el nmero en 'ST0': los nmeros negativos se vuelven
       positivos, y viceversa.

  A.33 'FCLEX', {FNCLEX}: Limpia las excepciones de coma flotante

       FCLEX                         ; 9B DB E2             [8086,FPU]
       FNCLEX                        ; DB E2                [8086,FPU]

       'FCLEX' limpia cualquier excepcin de coma flotante que pudiese estar
       pendiente. 'FNCLEX' hace lo mismo pero no espera a que se acaben primero
       las operaciones de coma flotante previas (incluyendo el _manejo_ de
       excepciones pendientes).

  A.34 'FCMOVcc': Movimientos condicionales en coma flotante

       FCMOVB fpureg                 ; DA C0+r              [P6,FPU]
       FCMOVB ST0,fpureg             ; DA C0+r              [P6,FPU]

       FCMOVBE fpureg                ; DA D0+r              [P6,FPU] 
       FCMOVBE ST0,fpureg            ; DA D0+r              [P6,FPU]

       FCMOVE fpureg                 ; DA C8+r              [P6,FPU] 
       FCMOVE ST0,fpureg             ; DA C8+r              [P6,FPU]

       FCMOVNB fpureg                ; DB C0+r              [P6,FPU] 
       FCMOVNB ST0,fpureg            ; DB C0+r              [P6,FPU]

       FCMOVNBE fpureg               ; DB D0+r              [P6,FPU] 
       FCMOVNBE ST0,fpureg           ; DB D0+r              [P6,FPU]

       FCMOVNE fpureg                ; DB C8+r              [P6,FPU] 
       FCMOVNE ST0,fpureg            ; DB C8+r              [P6,FPU]

       FCMOVNU fpureg                ; DB D8+r              [P6,FPU] 
       FCMOVNU ST0,fpureg            ; DB D8+r              [P6,FPU]

       FCMOVU fpureg                 ; DA D8+r              [P6,FPU] 
       FCMOVU ST0,fpureg             ; DA D8+r              [P6,FPU]

       La instruccin 'FCMOV' realiza operaciones de movimientos condicionales:
       cada una de ellas mueve el contenido del registro dado en 'ST0' si se
       satisface la condicin, y si no, no hace nada.

       Las condiciones no son las mismas que los cdigos de condicin estndar
       usados en las instrucciones de salto condicional. Las condiciones 'B',
       'BE', 'NB', 'NBE', 'E' y 'NE' son exactamente como las normales, pero
       no se soporta ninguno de los otros cdigos estndar. En su lugar, se
       proporcionana la condicin 'U' y su contrapartida 'NU'; la condicin 'U'
       se satisface si los dos ltimos nmeros en coma flotante comparados
       estaban _desordenados_, esto es, no son iguales pero no se podra decir
       si uno es mayor o no que el otro, por ejemplo, si fuesen NaNs. (El flag
       de estado que seala esto es el flag de paridad: por eso la nocin de la
       condicin 'U' es equivalente a 'PE', y 'NU' es equivalente a 'PO').

       Las condiciones 'FCMOV' comprueban el flag de estado del procesador, no
       los flags de estado de la FPU, por eso usar 'FCMOV' directamente despus
       de 'FCOM' no funcionar. En su lugar, deberas usar o 'FCOMI' que escribe
       directamente en la palabra de flags de la CPU principal, o usar 'FSTSW'
       para extraer los flags de estado de la FPU.

       Aunque las instrucciones 'FCMOV' estn marcadas como 'P6' o superior,
       podran no estar soportadas por todos los procesadores Pentium Pro; la
       instruccin 'CPUID' (seccin A.22) devolver un bit que indica si se
       soportan los movimientos condicionales.

  A.35 'FCOM', 'FCOMP', 'FCOMPP', 'FCOMI', 'FCOMIP': Compara en coma flotante

       FCOM mem32                    ; D8 /2                [8086,FPU]
       FCOM mem64                    ; DC /2                [8086,FPU] 
       FCOM fpureg                   ; D8 D0+r              [8086,FPU] 
       FCOM ST0,fpureg               ; D8 D0+r              [8086,FPU]

       FCOMP mem32                   ; D8 /3                [8086,FPU] 
       FCOMP mem64                   ; DC /3                [8086,FPU] 
       FCOMP fpureg                  ; D8 D8+r              [8086,FPU] 
       FCOMP ST0,fpureg              ; D8 D8+r              [8086,FPU]

       FCOMPP                        ; DE D9                [8086,FPU]

       FCOMI fpureg                  ; DB F0+r              [P6,FPU] 
       FCOMI ST0,fpureg              ; DB F0+r              [P6,FPU]

       FCOMIP fpureg                 ; DF F0+r              [P6,FPU] 
       FCOMIP ST0,fpureg             ; DF F0+r              [P6,FPU]

       'FCOM' compara con el operando dado, y activa los flags de la FPU de
       manera acorde. 'ST0' es tratado como el lado izquierdo de la comparacin,
       por eso se activa el flag de acarreo (para un resultado 'menor que') si
       'ST0' es menor que el operando dado.

       'FCOMP' hace lo mismo que 'FCOM' pero saca despus la pila de registros.
       'FCOMPP' compara 'ST0' con 'ST1' y luego saca el pila de registros dos
       veces.

       'FCOMI' y 'FCOMIP' funcionan como sus formas correspondientes de 'FCOM'
       y 'FCOMP', pero escriben directamente sus resultados en el registro de
       flags de la CPU en lugar de la palabra de estado de la FPU, por eso
       pueden estar seguidos inmediatamente de instrucciones de salto
       condicional o de movimientos condicionales.

       Las instrucciones 'FCOM' difieren de las instrucciones 'FUCOM' (seccin
       A.69) slo en el modo en que manejan los tranquilos NaNs: 'FUCOM' los
       manejar silenciosamente y activar los flags de los cdigos de condicin
       para un resultado 'desordenado', mientras que 'FCOM' generar una
       excepcin.

  A.36 'FCOS': Coseno

       FCOS                          ; D9 FF                [386,FPU]

       'FCOS' calcula el coseno de 'ST0' (en radianes), y almacena el resultado
       en 'ST0'. Ver tambin 'FSINCOS' (seccin A.61).

  A.37 'FDECSTP': Decrementa el puntero de pila en coma flotante

       FDECSTP                       ; D9 F6                [8086,FPU]

       'FDECSTP' decremente el campo 'superior' en la palabra de estado en coma
       flotante. Esto tiene el efecto de rotar en uno la pila de registros de la
       FPU, como si el contenido de 'ST7' hubiese sido empujado a la pila. Ver
       tambin 'FINCSTP' (seccin A.46).

  A.38 'FxDISI', 'FxENI': Desactiva y activa las interrupciones en coma flotante

       FDISI                         ; 9B DB E1             [8086,FPU]
       FNDISI                        ; DB E1                [8086,FPU]

       FENI                          ; 9B DB E0             [8086,FPU] 
       FNENI                         ; DB E0                [8086,FPU]

       'FDISI' y 'FENI' desactiva y activa las interrupciones de coma flotante.
       Estas instrucciones slo son significativas en los procesadores 8087
       originales: el 287 y superiores las trata como instrucciones que no hacen
       ninguna operacin.

       'FNDISI' y 'FNENI' hacen la misma cosa que 'FDISI' y 'FENI'
       respectivamente, pero sin esperar a que el procesador de coma flotante
       haya acabado primero con lo que estuviese haciendo.

  A.39 'FDIV', 'FDIVP', FDIVR', 'FDIVRP': Divisin en coma flotante

       FDIV mem32                    ; D8 /6                [8086,FPU]
       FDIV mem64                    ; DC /6                [8086,FPU]

       FDIV fpureg                   ; D8 F0+r              [8086,FPU] 
       FDIV ST0,fpureg               ; D8 F0+r              [8086,FPU]

       FDIV TO fpureg                ; DC F8+r              [8086,FPU] 
       FDIV fpureg,ST0               ; DC F8+r              [8086,FPU]

       FDIVR mem32                   ; D8 /0                [8086,FPU] 
       FDIVR mem64                   ; DC /0                [8086,FPU]

       FDIVR fpureg                  ; D8 F8+r              [8086,FPU] 
       FDIVR ST0,fpureg              ; D8 F8+r              [8086,FPU]

       FDIVR TO fpureg               ; DC F0+r              [8086,FPU] 
       FDIVR fpureg,ST0              ; DC F0+r              [8086,FPU]

       FDIVP fpureg                  ; DE F8+r              [8086,FPU] 
       FDIVP fpureg,ST0              ; DE F8+r              [8086,FPU]

       FDIVRP fpureg                 ; DE F0+r              [8086,FPU] 
       FDIVRP fpureg,ST0             ; DE F0+r              [8086,FPU]

       'FDIV' divide 'ST0' por el operando dado y almacena el resultado de nuevo
       en 'ST0', a menos que se de  el calificador 'TO', en cuyo caso divide el
       operando dado por 'ST0' y almacena el resultado en el operando.

       'FDIVR' hace lo mismo, pero hace la divisin de la otra forma: por eso si
       no se da 'TO', divide el operando dado por 'ST0' y almacena el resultado
       en 'ST0', mientras que si se da 'TO', divide 'ST0' por el operando y
       almacena el resultado en el operando.

       'FDIVP' opera como 'FDIV TO', pero saca la pila de registros una vez haya
       terminado. 'FDIVRP' opera de igual forma que 'FDIVR TO', pero saca la
       pila de registros una vez que haya terminado.

  A.40 'FFREE': Pone el registro de flags de coma flotante como no usado

       FFREE fpureg                  ; DD C0+r              [8086,FPU]

       'FFREE' marca el registro dado como si estuviese vaco.

  A.41 'FIADD': Suma coma flotante/entero

       FIADD mem16                   ; DE /0                [8086,FPU]
       FIADD mem32                   ; DA /0                [8086,FPU]

       'FIADD' suma el entero de 16-bit o 32-bit almacenado en la posicin de
       memoria dado, a 'ST0', almacenando el resultado en 'ST0'.

  A.42 'FICOM', 'FICOMP': Compara coma flotante/entero

       FICOM mem16                   ; DE /2                [8086,FPU]
       FICOM mem32                   ; DA /2                [8086,FPU]

       FICOMP mem16                  ; DE /3                [8086,FPU] 
       FICOMP mem32                  ; DA /3                [8086,FPU]

       'FICOM' compara 'ST0' con el entero de 16-bit o 32-bit almacenado en la
       posicin de memoria dada, y activa de forma acorde los flags FPU.
       'FICOMP' hace lo mismo, pero saca despus la pila de registros.

  A.43 'FIDIV', 'FIDIVR': Divisin coma flotante/entero

       FIDIV mem16                   ; DE /6                [8086,FPU]
       FIDIV mem32                   ; DA /6                [8086,FPU]

       FIDIVR mem16                  ; DE /0                [8086,FPU] 
       FIDIVR mem32                  ; DA /0                [8086,FPU]

       'FIDIV' divide 'ST0' por el entero de 16-bit o 32-bit almacenado en la
       posicin de memoria dada, y almacena el resultado en 'ST0'. 'FIDIVR' hace
       la divisin del otro modo: divide en entero por 'ST0', pero sigue
       almacenando el resultado en 'ST0'.

  A.44 'FILD', 'FIST', 'FISTP': Conversin coma flotante/entero

       FILD mem16                    ; DF /0                [8086,FPU]
       FILD mem32                    ; DB /0                [8086,FPU] 
       FILD mem64                    ; DF /5                [8086,FPU]

       FIST mem16                    ; DF /2                [8086,FPU] 
       FIST mem32                    ; DB /2                [8086,FPU]

       FISTP mem16                   ; DF /3                [8086,FPU] 
       FISTP mem32                   ; DB /3                [8086,FPU] 
       FISTP mem64                   ; DF /0                [8086,FPU]

       'FILD' carga un entero desde una direccin de memoria, lo convierte a un
       real, y lo empuja en la pila de registros de la FPU. 'FIST' convierte
       'ST0' a un entero y lo almacena en memoria; 'FIST' hace lo mismo que
       'FIST', pero saca despus de la pila de registros.

  A.45 'FIMUL': Multiplicacin coma flotante/entero

       FIMUL mem16                   ; DE /1                [8086,FPU]
       FIMUL mem32                   ; DA /1                [8086,FPU]

       'FIMUL' multiplica 'ST0' por el entero de 16-bit o 32-bit almacenado en
       la posicin de memoria dada, y almacena el resultado en 'ST0'.

  A.46 'FINCSTP': Incrementa el puntero de pila de coma flotante

       FINCSTP                       ; D9 F7                [8086,FPU]

       'FINCSTP' incrementa el campo 'superior' en la palabra de estado de coma
       flotante. Esto tiene el efecto de rotar en uno la pila de registros, como
       si la pila de registros hubiese sido sacada; sin embargo, al contrario
       que el 'pop' hecho por muchas instrucciones FPU, no marca el nuevo 'ST7'
       (anteriormente 'ST0') como vaco. Ver tambin 'FDECSTP' (seccin A.37).

  A.47 'FINIT', 'FNINIT': Inicializa la unidad de coma flotante

       FINIT                         ; 9B DB E3             [8086,FPU]
       FNINIT                        ; DB E3                [8086,FPU]

       'FINIT' inicializa la FPU a su estado por defecto. Marca todos los
       registros como vacos, aunque realmente no cambie sus valores. 'FNINIT'
       hace lo mismo, pero sin esperar a que las excepciones pendientes de hayan
       limpiado.

  A.48 'FISUB': Resta coma flotante/entero

       FISUB mem16                   ; DE /4                [8086,FPU]
       FISUB mem32                   ; DA /4                [8086,FPU]

       FISUBR mem16                  ; DE /5                [8086,FPU] 
       FISUBR mem32                  ; DA /5                [8086,FPU]

       'FISUB' resta de 'ST0' el entero de 16-bit o 32-bit almacenado en la
       posicin de memoria dada, y almacena el resultado en 'ST0'. 'FISIBR' hace
       la resta del otro modo, esto es, resta 'ST0' del entero dado, pero sigue
       almacenando el resultado en 'ST0'.

  A.49 'FLD': Carga en coma flotante

       FLD mem32                     ; D9 /0                [8086,FPU]
       FLD mem64                     ; DD /0                [8086,FPU] 
       FLD mem80                     ; DB /5                [8086,FPU] 
       FLD fpureg                    ; D9 C0+r              [8086,FPU]

       'FLD' carga un valor en coma flotante desde el registro o posicin de
       memoria dada, y lo empuja a la pila de registros de la FPU.

  A.50 'FLDxx': Carga de constantes en coma flotante

       FLD1                          ; D9 E8                [8086,FPU]
       FLDL2E                        ; D9 EA                [8086,FPU] 
       FLDL2T                        ; D9 E9                [8086,FPU] 
       FLDLG2                        ; D9 EC                [8086,FPU] 
       FLDLN2                        ; D9 ED                [8086,FPU] 
       FLDPI                         ; D9 EB                [8086,FPU] 
       FLDZ                          ; D9 EE                [8086,FPU]

       Estas instrucciones empujan una constante estndar especfica a la pila
       de registros de la FPU. 'FLD1' empuja el valor 1; 'FLDL2E' empuja el
       logaritmo de e en base 2; 'FLDL2T' empuja el logaritmo de 10 en base 2;
       'FLDLG2' empuja el logaritmo de 2 en base 10; 'FLDLN2' empuja el
       logaritmo de 2 en base e; 'FLDPI' empuja pi; y 'FLDZ' empuja cero.

  A.51 'FLDCW': Carga la palabra de control de coma flotante

       FLDCW mem16                   ; D9 /5                [8086,FPU]

       'FLDCW' carga un valor de 16-bit desde memoria y lo almacena en la
       palabra de control de la FPU (que gobierna cosas como el modo de
       redondeo, la precisin, y las mscaras de excepciones). Ver tambin
       'FSTCW' (seccin A.64).

  A.52 'FLDENV': Carga el entorno de coma flotante

       FLDENV mem                    ; D9 /4                [8086,FPU]

       'FLDENV' carga el entorno de operacin de la FPU (palabra de control,
       palabra de estado, palabra etiqueta, puntero de instruccin, puntero de
       datos y ltimo cdigo de operacin) desde memoria. El rea de memoria es
       de 14 o 28 bytes de largo, dependiendo del modo de la CPU en ese momento.
       Ver tambin 'FSTENV' (seccin A.65).

  A.53 'FMUL', 'FMULP': Multiplicacin en coma flotante

       FMUL mem32                    ; D8 /1                [8086,FPU]
       FMUL mem64                    ; DC /1                [8086,FPU]

       FMUL fpureg                   ; D8 C8+r              [8086,FPU] 
       FMUL ST0,fpureg               ; D8 C8+r              [8086,FPU]

       FMUL TO fpureg                ; DC C8+r              [8086,FPU] 
       FMUL fpureg,ST0               ; DC C8+r              [8086,FPU]

       FMULP fpureg                  ; DE C8+r              [8086,FPU] 
       FMULP fpureg,ST0              ; DE C8+r              [8086,FPU]

       'FMUL' multiplica 'ST0' por el operando dado, y alamacena el resultado en
       'ST0', a menos que se use el calificador 'TO' en cuyo caso se almacena
       el resultado en el operando. 'FMULP' realiza la misma opearacin que
       'FMUL TO', y luego saca la pila de registros.

  A.54 'FNOP': No_operacin en coma flotante

       FNOP                          ; D9 D0                [8086,FPU]

       'FNOP' no hace nada.

  A.55 'FPATAN', 'FPTAN': Arcotangente y tangente

       FPATAN                        ; D9 F3                [8086,FPU]
       FPTAN                         ; D9 F2                [8086,FPU]

       'FPATAN' calcula el arcotangente, en radianes, del resultado de dividir
       'ST1' por 'ST0', almacena el resultado en 'ST1', y saca la pila de
       registros. Funciona como la funcin 'atan2' de C, en que cambiando el
       signo tanto de 'ST0' como de 'ST1' cambia el valor de salida en pi (por
       eso realiza una verdadera conversin de coordenadas rectangulares a
       polares, siendo 'ST1' la coordenada Y y 'ST0' la X, no simplemente un
       arcotangente).

       'FPTAN' calcula la tangente del valor en 'ST0' (en radianes), y almacena
       el resultado de nuevo en 'ST0'.

  A.56 'FPREM', 'FPREM1': Restos parciales en coma flotante

       FPREM                         ; D9 F8                [8086,FPU]
       FPREM1                        ; D9 F5                [386,FPU]

       Estas instrucciones producen el resto obtenido de dividir 'ST0' por
       'ST1'. Esto se calcula, conceptualmente, dividiendo 'ST0' por 'ST1',
       redondeando el resultado a un entero, multiplicando 'ST1' nuevamente, y
       calculando el valor que necesitamos sumar al resultado para conseguir de
       nuevo el valor original en 'ST0'.

       Las dos instrucciones difieren en el modo en que se realiza la operacin
       de redondeo a entero. 'FPREM' lo hace redondeando hacia cero, por eso el
       resto que devuelve siempre tiene el mismo signo que el valor original en
       'ST0'; 'FPREM1' hace el redondeo hacia el entero ms prximo, por eso el
       resto siempre tiene como mucho la mitad de la magnitud de 'ST1'.

       Ambas instrucciones calculan restos _parciales_, lo que quiere decir que
       podran no encargarse de proporcionar el resultado final, pero podran
       dejar en su lugar resultado intermedios en 'ST0'. Si esto pasa, activarn
       el flag C2 en la palabra de estado de la FPU; por lo tanto, para calcular
       un resto, deberas ejecutar repetidamente 'FPREM' o 'FPREM1' hasta que se
       limpie C2.

  A.57 'FRNDINT': Redondeo a entero en coma flotante

       FRNDINT                       ; D9 FC                [8086,FPU]

       'FRNDINT' redondea el contenido de 'ST0' a un entero, de acuerdo al modo
       actual de redondeo establecido en la palabra de control de la FPU, y
       almacena el resultado de nuevo en 'ST0'.

  A.58 'FSAVE', 'FRSTOR': Salva/restaura el estado de la coma flotante

       FSAVE mem                     ; 9B DD /6             [8086,FPU]
       FNSAVE mem                    ; DD /6                [8086,FPU]

       FRSTOR mem                    ; DD /4                [8086,FPU]

       'FSAVE' salva entera la unidad de estado de la coma flotante, incluyendo
       toda la informacin salvada por 'FSTENV' (seccin A.65) ms el contenido
       de todos los registros, a un rea de memoria de 94 o 108 bytes
       (dependiendo del modo de la CPU). 'FRSTOR' restaura el estado de la coma
       flotante desde ese mismo rea de memoria.

       'FNSAVE' hace lo mismo que 'FSAVE', pero sin esperar primero a que se
       limpien las excepciones pendientes de coma flotante.

  A.59 'FSCALE': Escala valores en coma flotante por una potencia de dos

       FSCALE                        ; D9 FD                [8086,FPU]

       'FSCALE' escala un nmero por una potencia de dos: redondea 'ST1' hacia
       cero para obtener un entero, luego multiplica 'ST0' por dos a la potencia
       de ese entero, y almacena el resultado en 'ST0'.

  A.60 'FSETPM': Activa el modo protegido

       FSETPM                        ; DB E4                [286,FPU]

       Esta instruccin inicializa el modo protegido en el coprocesador de coma
       flotante 287. Slo tiene sentido en este procesador: el 387 y superiores
       tratan esta instruccin como una no_operacin.

  A.61 'FSIN', 'FSINCOS': Seno y coseno

       FSIN                          ; D9 FE                [386,FPU]
       FSINCOS                       ; D9 FB                [386,FPU]

       'FSIN' calcula el seno de 'ST0' (en radianes) y almacena el resultado en
       'ST0'. 'FSINCOS' hace lo mismo, pero empuja el coseno del mismo valor a
       la pila de registros, por eso el seno va a parar a 'ST1' y el coseno en
       'ST0'. 'FSINCOS' es ms rpido que ejecutar sucesivamente 'FSIN' y 'FCOS'
       (ver seccin A.36).

  A.62 'FSQRT': Raz cuadrada en coma flotante

       FSQRT                         ; D9 FA                [8086,FPU]

       'FSQRT' calcula la raz cuadrada de 'ST0' y almacena el resultado en
       'ST0'.

  A.63 'FST', 'FSTP': Almacena en coma flotante

       FST mem32                     ; D9 /2                [8086,FPU]
       FST mem64                     ; DD /2                [8086,FPU] 
       FST fpureg                    ; DD D0+r              [8086,FPU]

       FSTP mem32                    ; D9 /3                [8086,FPU] 
       FSTP mem64                    ; DD /3                [8086,FPU] 
       FSTP mem80                    ; DB /0                [8086,FPU] 
       FSTP fpureg                   ; DD D8+r              [8086,FPU]

       'FST' almacena el valor en 'ST0' a una posicin de memoria dada o en otro
       registro de la FPU. 'FSTP' hace lo mismo, pero luego saca la pila de
       registros.

  A.64 'FSTCW': Almacena la palabra de control de coma flotante

       FSTCW mem16                   ; 9B D9 /0             [8086,FPU]
       FNSTCW mem16                  ; D9 /0                [8086,FPU]

       'FSTCW' almacena la palabra de control de la FPU (que gobierna cosas como
       el modo de redondeo, la precisin, y la mscara de excepciones) en un
       rea de memoria de 2 bytes. Ver tambin 'FLDCW' (seccin A.51).

       'FNSTCW' hace lo mismo que 'FSTCW', pero sin esperar a que se limpien las
       excepciones pendientes de coma flotante.

  A.65 'FSTENV': Almacena el entorno de la coma flotante

       FSTENV mem                    ; 9B D9 /6             [8086,FPU]
       FNSTENV mem                   ; D9 /6                [8086,FPU]

       'FSTENV' almacena el entorno de operacin de la FPU (palabra de control,
       palabra de estado, palabra etiqueta, puntero de instruccin, puntero de
       datos y ltimo cdigo de operacin) en memoria. El rea de memoria es de
       14 o 28 bytes de largo, dependiendo del modo de la CPU en ese momento.
       Ver tambin 'FLDENV' (seccin A.52).

       'FNSTENV' hace lo mismo que 'FSTENV', pero sin esperar primero a que se
       limpien las excepciones pendiente de la coma flotante.

  A.66 'FSTSW': Almacena la palabra de estado de la coma flotante

       FSTSW mem16                   ; 9B DD /0             [8086,FPU]
       FSTSW AX                      ; 9B DF E0             [286,FPU]

       FNSTSW mem16                  ; DD /0                [8086,FPU] 
       FNSTSW AX                     ; DF E0                [286,FPU]

       'FSTSW' almacena la palabra de estado de la FPU en 'AX' o en un rea de
       memoria de 2 bytes.

       'FNSTSW' hace lo mismo que 'FSTSW', pero sin esperar primero a que se
       limpien las excepciones pendientes de la coma flotante.

  A.67 'FSUB', 'FSUBP', 'FSUBR', 'FSUBRP': Resta en coma flotante

       FSUB mem32                    ; D8 /4                [8086,FPU]
       FSUB mem64                    ; DC /4                [8086,FPU]

       FSUB fpureg                   ; D8 E0+r              [8086,FPU] 
       FSUB ST0,fpureg               ; D8 E0+r              [8086,FPU]

       FSUB TO fpureg                ; DC E8+r              [8086,FPU] 
       FSUB fpureg,ST0               ; DC E8+r              [8086,FPU]

       FSUBR mem32                   ; D8 /5                [8086,FPU] 
       FSUBR mem64                   ; DC /5                [8086,FPU]

       FSUBR fpureg                  ; D8 E8+r              [8086,FPU] 
       FSUBR ST0,fpureg              ; D8 E8+r              [8086,FPU]

       FSUBR TO fpureg               ; DC E0+r              [8086,FPU] 
       FSUBR fpureg,ST0              ; DC E0+r              [8086,FPU]

       FSUBP fpureg                  ; DE E8+r              [8086,FPU] 
       FSUBP fpureg,ST0              ; DE E8+r              [8086,FPU]

       FSUBRP fpureg                 ; DE E0+r              [8086,FPU] 
       FSUBRP fpureg,ST0             ; DE E0+r              [8086,FPU]

       'FSUB' resta el operando dado de 'ST0' y almacena el resultado de nuevo
       en 'ST0', a menos que se de el calificador 'TO', en cuyo caso resta 'ST0'
       del operando dado y almacena el resultado en el operando.

       'FSUBR' hace lo mismo, pero hace la resta del otro modo: por eso si no se
       da 'TO', resta 'ST0' del operando dado y almacena el resultado en 'ST0',
       mientras que si se da 'TO' resta el operando de 'ST0' y almacena el
       resultado en el operando.

       'FSUBP' opera como 'FSUB TO', pero saca la pila de registros una vez ha
       terminado. 'FSUBRP' opera como 'FSUBR TO', pero saca la pila de registros
       una vez ha terminado.

  A.68 'FTST': Comprueba 'ST0' con cero

       FTST                          ; D9 E4                [8086,FPU]

       'FTST' compara 'ST0' con cero y activa de acuerdo a esto los flags de la
       FPU. 'ST0' es tratado como el lado izquierdo de la comparacin, por eso
       se genera un resultado 'menor que' si 'ST0' es negativo.

  A.69 'FUCOMxx': Comparacin desordenada en coma flotante

       FUCOM fpureg                  ; DD E0+r              [386,FPU]
       FUCOM ST0,fpureg              ; DD E0+r              [386,FPU]

       FUCOMP fpureg                 ; DD E8+r              [386,FPU] 
       FUCOMP ST0,fpureg             ; DD E8+r              [386,FPU]

       FUCOMPP                       ; DA E9                [386,FPU]

       FUCOMI fpureg                 ; DB E8+r              [P6,FPU] 
       FUCOMI ST0,fpureg             ; DB E8+r              [P6,FPU]

       FUCOMIP fpureg                ; DF E8+r              [P6,FPU] 
       FUCOMIP ST0,fpureg            ; DF E8+r              [P6,FPU]

       'FUCOM' compara 'ST0' con el operando dado, y activa de forma acorde los
       flags de la FPU. 'ST0' es tratado como el lado izquierdo de la
       comparacin, por eso el flag de acarreo se activa (para un resultado
       'menor que') si 'ST0' es menor que el operando dado.

       'FUCOMP' hace lo mismo que 'FUCOM', pero despus saca la pila de
       registros. 'FUCOMPP' compara 'ST0' con 'ST1' y luego saca dos veces la
       pila de registros.

       'FUCOMI' y 'FUCOMIP' funcionan como las formas correspondientes de
       'FUCOM' y 'FUCOMP', pero escriben el resultado directamente en el
       registro de flags de la CPU en lugar de en la palabra de estado de la
       FPU, por eso pueden estar seguidas inmediatamente de instrucciones de
       salto condicional o de movimientos condicionales.

       Las instrucciones 'FUCOM' difieren de las instrucciones 'FCOM' (seccin
       A.35) slo en el modo en que manejan las NaNs: 'FUCOM' las manejar
       silenciosamente y activar los flags del cdigo de condicin para un
       resultado 'desordenado', mientras que 'FCOM' generar una excepcin.

  A.70 'FXAM': Examina la clase del valor en 'ST0'

       FXAM                          ; D9 E5                [8086,FPU]

       'FXAM' activa los flags C3, C2 y C0 de la FPU dependiendo del tipo del
       valor almacenado en 'ST0': 000 (respectivamente) para un formato no
       soportado, 001 para una NaN, 010 para un nmero finito normal, 011 para
       uno infinito, 100 para un cero, 101 para un registro vaco, y 110 para
       uno anormal. Tambin activa el flag C1 para el signo del nmero.

  A.71 'FXCH': Intercambio en coma flotante

       FXCH                          ; D9 C9                [8086,FPU]
       FXCH fpureg                   ; D9 C8+r              [8086,FPU] 
       FXCH fpureg,ST0               ; D9 C8+r              [8086,FPU] 
       FXCH ST0,fpureg               ; D9 C8+r              [8086,FPU]

       'FXCH' intercambia 'ST0' con un registro dado de la FPU. La forma sin
       operando intercambia 'ST0' con 'ST1'.

  A.72 'FXTRACT': Extrae el exponenete y la mantisa

       FXTRACT                       ; D9 F4                [8086,FPU]

       'FXTRACT' separa el nmero en 'ST0' en su exponente y su mantisa,
       almacena el exponenete de nuevo en 'ST0', y luego empuja la mantisa a la
       pila de registros (por eso la mantisa termina en 'ST0', y el exponenete
       en 'ST1').

  A.73 'FYL2X', 'FYL2XP1': Calcula Y veces Log2(X) o Log2(X+1)

       FYL2X                         ; D9 F1                [8086,FPU]
       FYL2XP1                       ; D9 F9                [8086,FPU]

       'FYL2X' multiplica 'ST1' por el logaritmo de 'ST0' en base 2, almacena el
       resultado en 'ST1', y saca la pila de registros (por eso el resultado
       termina en 'ST0'). 'ST0' debe ser distinto de cero y positivo.

       'FYL2XP1' funciona del mismo modo, pero sustituye el logaritmo de 'ST0'
       en base 2 por el de 'ST0' ms uno. Esta vez, 'ST0' debe tener una
       magnitud no mayor que 1 menos la mitad de la raz cuadrada de dos.

  A.74 'HLT': Para el procesador

       HLT                           ; F4                   [8086]

       'HLT' pone el procesador en el estado parado, en donde no realizar ms
       operaciones hasta que vuelva a empezar por una interrupcin o por un
       reset.

  A.75 'IBTS': Inserta una cadena de bits

       IBTS r/m16,reg16              ; o16 0F A7 /r         [386,UNDOC]
       IBTS r/m32,reg32              ; o32 0F A7 /r         [386,UNDOC]

       Parece que no hay una documentacin clara disponible de esta instruccin:
       lo mejor que he podido encontrar dice 'Coge una cadena de bits desde el
       segundo operando y lo pone en el primer operando'. Slo est presente en
       los primeros procesadores 386, y entra en conflicto con los cdigos de
       operacin de 'CMPXCHG486'. NASM la soporta slo por completar. Su
       contrapartida es 'XBTS' (ver la seccin A.167).

  A.76 'IDIV': Divisin de entero con signo

       IDIV r/m8                     ; F6 /7                [8086]
       IDIV r/m16                    ; o16 F7 /7            [8086] 
       IDIV r/m32                    ; o32 F7 /7            [386]

       'IDIV' realiza la divisin entera con signo. El operando explcito que
       se proporcione es el divisor; el dividendo y el destino estn
       implcitos, de la siguiente forma:

       (*) Para 'IDIV r/m8', 'AX' es dividido por el operando dado; el cociente
           se almacena en 'AL' y el resto en 'AH'.

       (*) Para 'IDIV r/m16', 'DX:AX' es dividido por el operando dado; el
           cociente se almacena en 'AX' y el resto en 'DX'.

       (*) Para 'IDIV r/m32', 'EDX:EAX' es dividido por el operando dado; el
           cociente se almacena en 'EAX' y el resto en 'EDX'.

       La divisin entera sin signo se realiza con la instruccin 'DIV': ver la
       seccin A.25.

  A.77 'IMUL': Multiplicacin entera con signo

       IMUL r/m8                     ; F6 /5                [8086]
       IMUL r/m16                    ; o16 F7 /5            [8086] 
       IMUL r/m32                    ; o32 F7 /5            [386]

       IMUL reg16,r/m16              ; o16 0F AF /r         [386] 
       IMUL reg32,r/m32              ; o32 0F AF /r         [386]

       IMUL reg16,imm8               ; o16 6B /r ib         [286] 
       IMUL reg16,imm16              ; o16 69 /r iw         [286] 
       IMUL reg32,imm8               ; o32 6B /r ib         [386] 
       IMUL reg32,imm32              ; o32 69 /r id         [386]

       IMUL reg16,r/m16,imm8         ; o16 6B /r ib         [286] 
       IMUL reg16,r/m16,imm16        ; o16 69 /r iw         [286] 
       IMUL reg32,r/m32,imm8         ; o32 6B /r ib         [386] 
       IMUL reg32,r/m32,imm32        ; o32 69 /r id         [386]

       'IMUL' realiza la multiplicacin entera con signo. Para la forma de un
       solo operando, el otro operando y el destino estn implcitos, de la
       siguiente forma:

      (*) Para 'IMUL r/m8', 'AL' es multiplicado por el operando dado; el
          producto se almacena en 'AX'.

      (*) Para 'IMUL r/m16', 'AX' es multiplicado por el operando dado; el
          producto se almacena en 'DX:AX'.

      (*) Para 'IMUL r/m32', 'EAX' es multiplicado por el operando dado; el
          producto se almacena en 'EDX:EAX'.

      La forma de dos operandos multiplica los dos operandos y almacena el
      resultado en el operando (el primero) destino. La forma de tres operandos
      multiplica los dos ltimos y almacena el resultado en el primer operando.

      La forma de dos operandos en de hecho un atajo para la de tres operandos,
      como se puede ver examinando las descripciones del cdigo de operacin:
      en la forma de dos operandos, el cdigo '/r' toma ambos registros y 'r/m'
      parte desde el mismo operando (el primero).

      En las formas con operando inmediatos de 8-bit y otro operando fuente ms
      largo, el operando inmediato se considera con signo, y se le hace una
      extensin de signo hasta la longitud del otro operando fuente. En estos
      casos, se necesita el calificador 'BYTE' para forzar a NASM a generar esta
      forma de la instruccin.

      La multiplicacin entera sin signo se realiza con la instruccin 'MUL':
      ver la seccin A.107.

  A.78 'IN': Entrada desde el puerto I/O

       IN AL,imm8                    ; E4 ib                [8086]
       IN AX,imm8                    ; o16 E5 ib            [8086] 
       IN EAX,imm8                   ; o32 E5 ib            [386] 
       IN AL,DX                      ; EC                   [8086] 
       IN AX,DX                      ; o16 ED               [8086] 
       IN EAX,DX                     ; o32 ED               [386]

       'IN' lee un byte, palabra o palabra doble desde el puerto I/O
       especificado, y lo almacena en el registro destino dado. El nmero de
       puerto podra especificarse como un valor inmediato si est entre 0 y
       255, de otra forma debe estar almacenado en 'DX'. Ver tambin 'OUT'
       (seccin A.111).

  A.79 'INC': Incrementa un entero

       INC reg16                     ; o16 40+r             [8086]
       INC reg32                     ; o32 40+r             [386] 
       INC r/m8                      ; FE /0                [8086] 
       INC r/m16                     ; o16 FF /0            [8086] 
       INC r/m32                     ; o32 FF /0            [386]

       'INC' suma 1 a su operando. _No_ afecta al flag de acarreo: para afectar
       al flag de acarreo, usa 'ADD something,1' (ver seccin A.6). Ver tambin
       'DEC' (seccin A.24).

  A.80 'INSB', 'INSW', 'INSD': Entra una cadena desde el puerto I/O

       INSB                          ; 6C                   [186]
       INSW                          ; o16 6D               [186] 
       INSD                          ; o32 6D               [386]

       'INSB' entra un byte desde el puerto I/O especificado en 'DX' y lo
       almacena en '[ES:DI]' o '[ES:EDI]'. Luego incrementa o decrementa
       (dependiendo del flag de direccin: incrementa si el flag est limpio,
       decrementa si est activo) 'DI' o 'EDI'.

       Si el tamao de la direccin es de 16 bits se usa el registro 'DI', y
       el 'EDI' si es de 32 bits. Si necesitas usar un tamao de direccin
       distinto del actual 'BITS', puedes usar en prefijo explcito 'a16' o
       'a32'.

       Los prefijos de solapamiento de segmentos no tienen efecto en esta
       instruccin: el uso de 'ES' para la carga de '[DI]' o '[EDI]' no se
       puede superponer.

       'INSW' e 'INSD' funcionan de la misma forma, pero meten una palabra o
       una palabra doble en lugar de un byte, e incrementan o decrementan el
       registro de direccionamiento en 2  4 en lugar de en 1.

       'El prefijo 'REP' podra usarse para repetir la instruccin 'CX' veces
       (o 'ECX' - nuevamente el tamao de la direccin elige cul).

       Ver tambin 'OUTSB', 'OUTSW' y 'OUTSD' (seccin A.112).

  A.81 'INT': Interrupcin software

       INT imm8                      ; CD ib                [8086]

       'INT' provoca una interrupcin software por medio de un nmero de vector
       especfico desde 0 a 255.

       El cdigo generado por la instruccin 'INT' siempre es de dos bytes de
       largo: aunque hay formas cortas para algunas instrucciones 'INT', NASM
       no las genera cuando ve el mnemnico 'INT'. Para generar instrucciones
       de ruptura de un solo byte, use en su lugar las instrucciones 'INT3' o
       'INT1' (ver la seccin A.82).

  A.82 'INT3', 'INT1', 'ICEBP', 'INT01': Puntos de ruptura

       INT1                          ; F1                   [P6]
       ICEBP                         ; F1                   [P6] 
       INT01                         ; F1                   [P6]

       INT3                          ; CC                   [8086]

       'INT1' e 'INT3' son formas cortas de las instrucciones 'INT 1' e 'INT 3'
       (ver la seccin A.81). Hacen una funcin similar a sus contrapartidas
       largas, pero ocupan menos espacio de cdigo. Son usadas como puntos de
       ruptura por los depuradores.

       'INT1', y su sinnimo alternativo 'INT01' e 'ICEBP', es una instruccin
       que se usa en emuladores de circuitos (ICEs). Est presente aunque no
       documentada, en algunos procesadores inferiores al 286, pero slo est
       documentada para el Pentium Pro. 'INT3' es la instruccin que se usa
       normalmente como punto de ruptura en los depuradores.

       'INT3' no es precisamente el equivalente de 'INT 3': la forma corta, ya
       que est diseada para usarse como punto de ruptura, evita la
       comprobacin normal de IOPL en el modo virtual 8086, y tampoco va a
       travs de redireccin de interrupcin.

  A.83 'INTO': Interrupcin si hay desbordamiento

       INTO                          ; CE                   [8086]

       'INTO' realiza una interrupcin software 'INT 4' (ver seccin A.81) si y
       slo si se activa el flag de desbordamiento.

  A.84 'INVD': Invalida los cachs internos

       INVD                          ; 0F 08                [486]

       'INVD' invalida y vaca los cachs internos del procesador, y hace que el
       procesador indique lo mismo a los cachs externos. No escribe primero los
       contenidos de los cachs de vuelta a memoria: cualquier dato modificado
       contenido en los cachs se perder. Para escribir los datos primero, usa
       'WBINVD' (seccin A.164).

  A.85 'INVLPG': Invalida la entrada a TLB

       INVLPG mem                    ; 0F 01 /0             [486]

       'INVLPG' invalida la entrada a la TLB (Translation Lookahead Buffer)
       asociada con la direccin de memoria suministrada.

  A.86 'IRET', 'IRETW', 'IRETD': Volver desde una interrupcin

       IRET                          ; CF                   [8086]
       IRETW                         ; o16 CF               [8086] 
       IRETD                         ; o32 CF               [386]

       'IRET' vuelve desde una interrupcin (hardware o software) sacando desde
       la pila el 'IP' (o 'EIP'), 'CS' y los flags y luego continuando la
       ejecucin desde el nuevo 'CS:IP'.

       'IRETW' saca desde la pila 'IP', 'CS' y los flags como dos bytes cada
       uno, liberando en total 6 bytes de la pila. 'IRETD' saca 'EIP' como 4
       bytes, saca 4 bytes adicionales de los cuales los dos superiores se
       descartan y los dos inferiores van a 'CS', y saca los flags como 4 bytes,
       liberando 12 bytes de la pila.

       'IRET' es un atajo de 'IRETW' o 'IRETD', dependiendo de la configuracin
       de 'BITS' en ese momento.

  A.87 'JCXZ', 'JECXZ': Salta si CX/ECX es cero

       JCXZ imm                      ; o16 E3 rb            [8086]
       JECXZ imm                     ; o32 E3 rb            [386]

       'JCXZ' realiza un salto corto (con un rango mximo de 128 bytes) si y
       slo si el contenido del registro 'CX' es 0. 'JECXZ' hace lo mismo, pero
       con 'ECX'.

  A.88 'JMP': Salto

       JMP imm                       ; E9 rw/rd             [8086]
       JMP SHORT imm                 ; EB rb                [8086] 
       JMP imm:imm16                 ; o16 EA iw iw         [8086] 
       JMP imm:imm32                 ; o32 EA id iw         [386] 
       JMP FAR mem                   ; o16 FF /5            [8086] 
       JMP FAR mem                   ; o32 FF /5            [386] 
       JMP r/m16                     ; o16 FF /4            [8086] 
       JMP r/m32                     ; o32 FF /4            [386]

       'JMP' salta a la direccin de dada. La direccin podra especificarse
       como un offset y un segmento absoluto, o como un salto relativo dentro
       del segmento actual.

       'JMP SHORT imm' tiene un rango mximo de 128 bytes, ya que el
       desplazamiento se especifica con slo 8 bits, pero ocupa menos espacio
       de cdigo. NASM no elige por ti cuando generar 'JMP SHORT': debes
       codificar explcitamente 'SHORT' cada vez que quieras un salto corto.

       Puedes elegir entre las dos formas de salto lejano inmediato
       ('JMP imm:imm') usando las palabras clave 'WORD' y 'DWORD':
       'JMP WORD 0x1234:0x5678' o 'JMP DWORD 0x1234:0x5678abc'.

       La forma 'JMP FAR mem' ejecuta un salto lejano cargando la direccin
       destino desde la memoria. La direccin cargada consiste en un offset de
       16 o 32 bits (dependiendo del tamao del operando), y 16 bits del
       segmento. El tamao del operando podra ser superpuesto usando
       'JMP WORD FAR mem' o 'JMP DWORD FAR mem'.

       La forma 'JMP r/m' ejecuta un salto cercano (dentro del mismo segmento),
       cargando la direccin de destino desde memoria o desde un registro. La
       palabra clave 'NEAR' en estas formas se puede especificar, para mayor
       claridad, pero no es necesaria. Nuevamente, el tamao del operando se
       puede superponer usando 'JMP WORD mem' o 'JMP DWORD mem'.

       Por comodidad, NASM no te pide que saltes a un smbolo lejano mediante
       la codificacin de un molesto 'JMP SEG rutina:rutina', sino que en su
       lugar permite el sinnimo ms fcil 'JMP FAR rutina'.

       Las formas 'CALL r/m' dadas arriba son llamadas cercanas; NASM aceptar
       la palabra clave 'NEAR' (por ejemplo 'CALL NEAR [address]'), incluso
       aunque no sea estrctamente necesaria.

  A.89 'Jcc': Ramificacin condicional

       Jcc imm                       ; 70+cc rb             [8086]
       Jcc NEAR imm                  ; 0F 80+cc rw/rd       [386]

       Las condiciones de saltos condicionales ejecutan un salto cercano (mismo
       segmento) si y slo si se satisfacen sus condiciones. Por ejemplo, 'JNZ'
       salta slo si no est activo el flag de cero.

       Las formas normales de las instrucciones tienen slo un rango de 128
       bytes; la forma 'NEAR' es una extensin del 386 al conjunto de
       instrucciones, y puede abarcar el tamao total del segmento. NASM no
       ignorar tu eleccin de la instruccin de salto: si quieres 'Jcc NEAR',
       tendrs que usar la palabra clave 'NEAR'.

       La palabra clave 'SHORT' est permitida en la primera forma de la
       instruccin para ms claridad, pero no es necesaria.

  A.90 'LAHF': Cargar AH desde los flags

       LAHF                          ; 9F                   [8086]

       'LAHF' establece el registro 'AH' de acuerdo con el contenido del byte
       bajo de la palabra de flags. Ver tambin 'SAHF' (seccin A.145).

  A.91 'LAR': Cargar derechos de acceso

       LAR reg16,r/m16               ; o16 0F 02 /r         [286,PRIV]
       LAR reg32,r/m32               ; o32 0F 02 /r         [286,PRIV]

       'LAR' toma el selector de segmento especificado por su operando (el
       segundo) fuente, encuentra en la GDT o LDT el correspondiente descriptor
       de segmento, y carga el byte de derechos de acceso del descriptor en su
       operando (el primero) destino.

  A.92 'LDS', 'LES', 'LFS', 'LGS', 'LSS': Carga un puntero lejano

       LDS reg16,mem                 ; o16 C5 /r            [8086]
       LDS reg32,mem                 ; o32 C5 /r            [8086]

       LES reg16,mem                 ; o16 C4 /r            [8086] 
       LES reg32,mem                 ; o32 C4 /r            [8086]

       LFS reg16,mem                 ; o16 0F B4 /r         [386] 
       LFS reg32,mem                 ; o32 0F B4 /r         [386]

       LGS reg16,mem                 ; o16 0F B5 /r         [386] 
       LGS reg32,mem                 ; o32 0F B5 /r         [386]

       LSS reg16,mem                 ; o16 0F B2 /r         [386] 
       LSS reg32,mem                 ; o32 0F B2 /r         [386]

       Estas instrucciones cargan entero de una vez un puntero lejano (16  32
       bits de offset, ms 16 bits de segmento) desde memoria. 'LDS', por
       ejemplo, carga 16  32 bits desde la direccin de memoria dada en el
       registro dado (dependiendo del tamao del registro), luego carga los
       _siguientes_ 16 bits desde memoria en 'DS'. 'LES'. 'LFS', 'LGS' y 'LSS'
       funcionan del mismo modo pero usan los otros registros de segmento.

  A.93 'LEA': Carga la direccin efectiva

       LEA reg16,mem                 ; o16 8D /r            [8086]
       LEA reg32,mem                 ; o32 8D /r            [8086]

       'LEA', a pesar de su sintaxis, no accede a memoria. Calcula la direccin
       efectiva especificada por su segundo operando como si fuese a cargar o
       almacenar datos desde ella, pero en su lugar almacena la direccin en el
       registro especificado por su primer operando. Esto puede usarse para
       realizar clculos bastante complejos en una instruccin (por ejemplo,
       'LEA EAX,[EBX+ECX*4+100]').

       'LEA', a pesar de ser una instruccin puramente aritmtica que no accede
       a memoria, sigue requiriendo los corchetes alrededor de su segundo
       operando, como si fuese una referencia a memoria.

  A.94 'LEAVE': Destruye el marco de pila

       LEAVE                         ; C9                   [186]

       'LEAVE' destruye un marco de pila de la forma creada por la instruccin
       'ENTER' (ver la seccin A.27). Funcionalmente equivale a 'MOV ESP,EBP'
       seguido de un 'POP EBP' (o 'MOV SP,BP' seguido de un 'POP BP' en el modo
       de 16-bit).

  A.95 'LGDT', 'LIDT', 'LLDT': Carga las tablas de descriptores

       LGDT mem                      ; 0F 01 /2             [286,PRIV]
       LIDT mem                      ; 0F 01 /3             [286,PRIV] 
       LLDT r/m16                    ; 0F 00 /2             [286,PRIV]

       'LGDT' y 'LIDT' cogen como operando un rea de memoria de 6 bytes: cargan
       una direccin lineal de 32-bits y un tamao lmite de 16-bit desde ese
       rea (en el orden contrario) en el GDTR (Global Descriptor Table
       Register) o IDTR (Interrupt Descriptor Table Register). Estas son las
       nicas instrucciones que usan directamente direcciones _lineales_, en
       lugar de pares segmento/offset.

       'LLDT' toma como operando un selector de segmento. El procesador mira
       este selector en la GDT y almacena las direcciones lmite y base dadas
       all en la LDTR (Local Descriptor Table Register).

       Ver tambin 'SGDT', 'SIDT' y 'SLDT' (seccin A.151).

  A.96 'LMSW': Carga/almacena la palabra de estado de la mquina

       LMSW r/m16                    ; 0F 01 /6             [286,PRIV]

       'LMSW' carga los cuatro bits inferiores del operando fuente en los cuatro
       bits inferiores del registro de control 'CR0' (o la palabra de estado de
       la mquina, en procesadores 286). Ver tambin 'SMSW' (seccin A.155).

  A.97 'LOADALL', 'LOADALL286': Carga el estado del procesador

       LOADALL                       ; 0F 07                [386,UNDOC]
       LOADALL286                    ; 0F 05                [286,UNDOC]

       Esta instruccin, en sus dos formas diferentes de cdigo de operacin,
       aparentemente est soportada en la mayora de los 286, algunos 386 y
       posiblemente algunos 486. Los cdigos de operacin difieren entre el 286
       y el 386.

       La funcin de la instruccin es cargar toda la informacin relativa al
       estado del procesador desde un bloque de memoria: en el 286, este bloque
       est localizado implcitamente en la direccin absoluta '0x800', y en los
       386 y 486 est en '[ES:EDI]'.

  A.98 'LODSB', 'LODSW', 'LODSD': Carga desde una cadena

       LODSB                         ; AC                   [8086]
       LODSW                         ; o16 AD               [8086] 
       LODSD                         ; o32 AD               [386]

       'LODSB' carga un byte desde '[DS:SI]' o '[DS:ESI]' en 'AL'. Luego
       incrementa o decrementa (dependiendo del flag de direccin: incrementa si
       el flag est limpio, decrementa si est activo) 'SI' o 'ESI'.

       Si el tamao de la direccin es de 16 bits se usa el registro 'SI', y
       'ESI' si es de 32 bits. Si necesitas usar un tamao de direccin distinto
       del actual 'BITS', puedes usar un prefijo 'a16' o 'a32' explcito.

       El registro de segmento usado para cargar desde '[SI]' o '[ESI]' se puede
       superponer usando un nombre de registro de segmento como prefio (por
       ejemplo, 'es lodsb').

       'LODSW' y 'LODSD' funcionan del mismo modo, pero cargan una palabra o una
       doble palabra en lugar de un byte, e incrementan o decrementan el
       registro de direccionamiento en 2  4 en lugar de en 1.

  A.99 'LOOP, 'LOOPE', 'LOOPZ', 'LOOPNE', 'LOOPNZ': Bucle con contador

       LOOP imm                      ; E2 rb                [8086]
       LOOP imm,CX                   ; a16 E2 rb            [8086] 
       LOOP imm,ECX                  ; a32 E2 rb            [386]

       LOOPE imm                     ; E1 rb                [8086] 
       LOOPE imm,CX                  ; a16 E1 rb            [8086] 
       LOOPE imm,ECX                 ; a32 E1 rb            [386] 
       LOOPZ imm                     ; E1 rb                [8086] 
       LOOPZ imm,CX                  ; a16 E1 rb            [8086] 
       LOOPZ imm,ECX                 ; a32 E1 rb            [386]

       LOOPNE imm                    ; E0 rb                [8086] 
       LOOPNE imm,CX                 ; a16 E0 rb            [8086] 
       LOOPNE imm,ECX                ; a32 E0 rb            [386] 
       LOOPNZ imm                    ; E0 rb                [8086] 
       LOOPNZ imm,CX                 ; a16 E0 rb            [8086] 
       LOOPNZ imm,ECX                ; a32 E0 rb            [386]

       'LOOP' decrementa su registro contador (ya sea 'CX' o 'ECX' - si no se
       especifica explcitamente, la configuracin de 'BITS' dictamina cul se
       usa) en uno, y si el contador no se hace cero como resultado de esta
       operacin, salta a la etiqueta dada. El salto tiene un rango de 128
       bytes.

       'LOOPE' (o su sinnimo 'LOOPZ') aade la condicin adicional de que slo
       salta si el contador no es cero _y_ est activo el flag de cero. De forma
       similar, 'LOOPNE' (y 'LOOPNZ') salta slo si el contador no es cero y el
       flag de cero est limpio.

 A.100 'LSL': Carga el lmite de segmento

       LSL reg16,r/m16               ; o16 0F 03 /r         [286,PRIV]
       LSL reg32,r/m32               ; o32 0F 03 /r         [286,PRIV]

       A 'LSL' se le da un selector de segmento en su operando (el segundo)
       fuente; calcula el valor del lmite de segmento cargando el campo del
       lmite de segmento desde el descriptor de segmento asociado en la GDT o
       LDT. (Esto implica desplazar 12 bits hacia la izquierda si el lmite de
       segmento es 'page-granular' y no 'byte-granular'; por eso terminas con un
       lmite de byte en cualquier caso). El lmite de segmento obtenido es ms
       tarde cargado en el operando (el primero) destino.

 A.101 'LTR': Carga el registro de tarea

       LTR r/m16                     ; 0F 00 /3             [286,PRIV]

       'LTR' busca la base del segmento y el lmite en el descriptor
       especificado de la GDT o LDT mediante el selector de segmento dado como
       operando, y los carga en el registro de tarea.

 A.102 'MOV': Mueve datos

       MOV r/m8,reg8                 ; 88 /r                [8086]
       MOV r/m16,reg16               ; o16 89 /r            [8086] 
       MOV r/m32,reg32               ; o32 89 /r            [386] 
       MOV reg8,r/m8                 ; 8A /r                [8086] 
       MOV reg16,r/m16               ; o16 8B /r            [8086] 
       MOV reg32,r/m32               ; o32 8B /r            [386]

       MOV reg8,imm8                 ; B0+r ib              [8086] 
       MOV reg16,imm16               ; o16 B8+r iw          [8086] 
       MOV reg32,imm32               ; o32 B8+r id          [386] 
       MOV r/m8,imm8                 ; C6 /0 ib             [8086] 
       MOV r/m16,imm16               ; o16 C7 /0 iw         [8086] 
       MOV r/m32,imm32               ; o32 C7 /0 id         [386]

       MOV AL,memoffs8               ; A0 ow/od             [8086] 
       MOV AX,memoffs16              ; o16 A1 ow/od         [8086] 
       MOV EAX,memoffs32             ; o32 A1 ow/od         [386] 
       MOV memoffs8,AL               ; A2 ow/od             [8086] 
       MOV memoffs16,AX              ; o16 A3 ow/od         [8086] 
       MOV memoffs32,EAX             ; o32 A3 ow/od         [386]

       MOV r/m16,segreg              ; o16 8C /r            [8086] 
       MOV r/m32,segreg              ; o32 8C /r            [386] 
       MOV segreg,r/m16              ; o16 8E /r            [8086] 
       MOV segreg,r/m32              ; o32 8E /r            [386]

       MOV reg32,CR0/2/3/4           ; 0F 20 /r             [386] 
       MOV reg32,DR0/1/2/3/6/7       ; 0F 21 /r             [386] 
       MOV reg32,TR3/4/5/6/7         ; 0F 24 /r             [386] 
       MOV CR0/2/3/4,reg32           ; 0F 22 /r             [386] 
       MOV DR0/1/2/3/6/7,reg32       ; 0F 23 /r             [386] 
       MOV TR3/4/5/6/7,reg32         ; 0F 26 /r             [386]

       'MOV' copia el contenido de su operando (el segundo) fuente en su
       operando (el primero) destino.

        En todas las formas de la instruccin 'MOV', el segundo operando es del
        mismo tamao, excepto para mover entre un registro de segmento y un
        operando 'r/m32'. Estas instrucciones se tratan exactamente igual que
        las correspondientes equivalentes de 16-bit (por eso, por ejemplo,
        'MOV DS,EAX' funciona idnticamente que 'MOV DS,AX' pero ahorra un
        prefijo en el modo de 32-bit), excepto cuando un registro de segmento se
        mueve a un destino de 32-bits, los dos bytes superiores del resultado
        estn indefinidos.

        'MOV' no debera usar 'CS' como destino.

        'CR4' es un registro slo soportado en el Pentium y superiores.

 A.103 'MOVD': Mueve una palabra doble a/desde un registro MMX

       MOVD mmxreg,r/m32             ; 0F 6E /r             [PENT,MMX]
       MOVD r/m32,mmxreg             ; 0F 7E /r             [PENT,MMX]

       'MOVD' copia 32 bits desde su operando (el segundo) fuente a su operando
       (el primero) destino. Cuando el destino es un registro MMX de 64-bits,
       los 32 bits superiores se ponen a cero.

 A.104 'MOVQ': Mueve una palabra cudruple a/desde un registro MMX

       MOVQ mmxreg,r/m64             ; 0F 6F /r             [PENT,MMX]
       MOVQ r/m64,mmxreg             ; 0F 7F /r             [PENT,MMX]

       'MOVQ' copia 64 bits desde su operando (el segundo) fuente a su operando
       (el primero) destino.

 A.105 'MOVSB', 'MOVSW', 'MOVSD': Mueve una cadena

       MOVSB                         ; A4                   [8086]
       MOVSW                         ; o16 A5               [8086] 
       MOVSD                         ; o32 A5               [386]

       'MOVSB' copia el byte en '[ES:DI]' o '[ES:EDI]' a '[DS:SI]' o '[DS:SI]'.
       Luego incrementa o decrementa (dependiendo del flag de direccin:
       incrementa si el flag est limpio, decrementa si est activo) 'SI' y 'DI'
       (o 'ESI' y 'EDI').

       Si el tamao de la direccin es de 16 bits los registros usados son 'SI'
       y 'DI', y 'ESI' y 'EDI' si son de 32 bits. Si necesitas usar un tamao
       de direccin distinto de la configuracin actual de 'BITS', puedes usar
       un prefijo 'a16' o 'a32' explcito.

       El registro de segmento usado para cargar desde '[SI]' o '[ESI]' se puede
       superponer usando un nombre de registro de segmento como prefijo (por
       ejemplo, 'es movsb'). El uso de 'ES' para alamcenar a '[DI]' o '[EDI]'
       no se puede superponer.

       'MOVSW' y 'MOVSD' funcionan del mismo modo, pero copian en su lugar una
       palabra o una palabra doble en lugar de un byte, e incrementan o
       decrementan el registro de direccionamiento en 2  4 en lugar de en 1.

       'El prefijo 'REP' se podra usar para repetir la intruccin 'CX' veces
       (o 'ECX' - nuevamente, el tamao de la direccin determina cal).

 A.106 'MOVSX', 'MOVZX': Mueve datos con extensin de signo o de cero

       MOVSX reg16,r/m8              ; o16 0F BE /r         [386]
       MOVSX reg32,r/m8              ; o32 0F BE /r         [386] 
       MOVSX reg32,r/m16             ; o32 0F BF /r         [386]

       MOVZX reg16,r/m8              ; o16 0F B6 /r         [386] 
       MOVZX reg32,r/m8              ; o32 0F B6 /r         [386] 
       MOVZX reg32,r/m16             ; o32 0F B7 /r         [386]

       'MOVSX' hace extensin de signo a su operando (el segundo) fuente hasta
       la longitud de su operando (el primero) destino, y copia el resultado en
       el operando destino. 'MOVZX' hace lo mismo, pero hace extensin de cero
       en lugar de extensin de signo.

 A.107 'MUL': Multiplicacin entera sin signo

       MUL r/m8                      ; F6 /4                [8086]
       MUL r/m16                     ; o16 F7 /4            [8086] 
       MUL r/m32                     ; o32 F7 /4            [386]

       'MUL' realiza la multiplicacin entera sin signo. El otro operando de la
       multiplicacin, y el operando destino, estn implcitos, de la siguiente
       forma:

       (*) Para 'MUL r/m8', 'AL' se multiplica por el operando dado; el producto
           se almacena en 'AX'.

       (*) Para 'MUL r/m16', 'AX' se multiplica por el operando dado; el
           producto se almacena en 'DX:AX'.

       (*) Para 'MUL r/m32', 'EAX' se multiplica por el operando dado; el
           producto se almacena en 'EDX:EAX'.

       La multiplicacin entera con signo se realiza usando la instruccin
       'IMUL': ver la seccin A.77.

 A.108 'NEG', 'NOT': Complemento a dos y a uno

       NEG r/m8                      ; F6 /3                [8086]
       NEG r/m16                     ; o16 F7 /3            [8086] 
       NEG r/m32                     ; o32 F7 /3            [386]

       NOT r/m8                      ; F6 /2                [8086] 
       NOT r/m16                     ; o16 F7 /2            [8086] 
       NOT r/m32                     ; o32 F7 /2            [386]

       'NEG' sustituye el contenido de su operando por la negacin en
       complemento a dos (invierte todos los bits y luego suma uno) del valor
       original. 'NOT', de forma similar, realiza el complemento a uno (invierte
       todos los bits).

 A.109 'NOP' No operacin

       NOP                           ; 90                   [8086]

       'NOP' realiza la no operacin. Su cdigo de operacin es el mismo que el
       generado por 'XCHG AX,AX' o 'XCHG EAX,EAX' (dependiendo del modo del
       procesador; ver la seccin A.168).

 A.110 'OR': OR a nivel de bit

       OR r/m8,reg8                  ; 08 /r                [8086]
       OR r/m16,reg16                ; o16 09 /r            [8086] 
       OR r/m32,reg32                ; o32 09 /r            [386]

       OR reg8,r/m8                  ; 0A /r                [8086] 
       OR reg16,r/m16                ; o16 0B /r            [8086] 
       OR reg32,r/m32                ; o32 0B /r            [386]

       OR r/m8,imm8                  ; 80 /1 ib             [8086] 
       OR r/m16,imm16                ; o16 81 /1 iw         [8086] 
       OR r/m32,imm32                ; o32 81 /1 id         [386]

       OR r/m16,imm8                 ; o16 83 /1 ib         [8086] 
       OR r/m32,imm8                 ; o32 83 /1 ib         [386]

       OR AL,imm8                    ; 0C ib                [8086] 
       OR AX,imm16                   ; o16 0D iw            [8086] 
       OR EAX,imm32                  ; o32 0D id            [386]

       'OR' realiza una operacin OR a nivel de bit entre sus dos operandos
       (esto es, cada bit del resultado es 1 si y slo si al menos uno de los
       bits correspondientes de las dos entradas es 1), y almacena el resultado
       en el operando (el primero) destino.

       En las formas con inmediatos de 8-bits como segundo operando y un primer
       operando ms largo, se considera el segundo operando con signo, y se le
       hace extensin de signo hasta la longitud del primer operando. En estos
       caso, se necesita el calificador 'BYTE' para forzar a NASM a generar esta
       forma de la instruccin.

       La instruccin MMX 'POR' (ver seccin A.129) realiza la misma operacin
       en los registros MMX de 64-bits.

 A.111 'OUT': Manda datos al puerto I/O

       OUT imm8,AL                   ; E6 ib                [8086]
       OUT imm8,AX                   ; o16 E7 ib            [8086] 
       OUT imm8,EAX                  ; o32 E7 ib            [386] 
       OUT DX,AL                     ; EE                   [8086] 
       OUT DX,AX                     ; o16 EF               [8086] 
       OUT DX,EAX                    ; o32 EF               [386]

       'OUT' escribe el contenido del registro fuente dado en el puerto I/O
       especificado. El nmero de puerto se podra especificar como un valor
       inmediato si est entre 0 y 255, y de otro modo debe estar almacenado en
       'DX'. Ver tambin 'IN' (seccin A.78).

 A.112 'OUTSB', 'OUTSW', 'OUTSD': Manda una cadena al puerto I/O

       OUTSB                         ; 6E                   [186]

       OUTSW                         ; o16 6F               [186]

       OUTSD                         ; o32 6F               [386]

       'OUTSB' carga un byte desde '[DS:SI]' o '[DS:ESI]' y lo escribe al puerto
       I/O especificado en 'DX'. Luego incrementa o decrementa (dependiendo del
       flag de direccin: incrementa si el flag est limpio, decrementa si est
       activo) 'SI' o 'ESI'.

       Si el tamao de la direccin es de 16 bits se usa el registro 'SI', y
       'ESI' si es de 32 bits. Si necesitas usar un tamao de direccin
       diferente de configurado por 'BITS', puedes usar un prefijo 'a16' o 'a32'
       explcito.

       El registro de segmento usado para cargar desde '[SI]' o '[ESI]' puede
       superponerse usando un nombre de registro de segmento como prefijo (por
       ejemplo, 'es outsb').

       'OUTSW' y 'OUTSD' funcionan de forma similar, pero sacan una palabra o
       una palabra doble en lugar de un byte, e incrementan o decrementan el
       registro de direccionamiento en 2  4 en lugar de en 1.

       Se podra usar el prefijo 'REP' para repetir la instruccin 'CX' veces
       (o 'ECX' - nuevamente, el tamao de la direccin elige cul).

 A.113 'PACKSSDW', 'PACKSSWB', 'PACKUSWB': Empaqueta datos

       PACKSSDW mmxreg,r/m64         ; 0F 6B /r             [PENT,MMX]
       PACKSSWB mmxreg,r/m64         ; 0F 63 /r             [PENT,MMX] 
       PACKUSWB mmxreg,r/m64         ; 0F 67 /r             [PENT,MMX]

       Todas estas instrucciones comienzan formando una palabra de 128-bit
       colocando el operando (el segundo) fuente a la izquierda del operando
       (el primero) destino. 'PACKSSDW' luego separa esta palabra de 128-bits
       en cuatro palabras dobles, convierte cada una en una palabra, y las carga
       juntas en el registro destino; 'PACKSSWB' y 'PACKUSWB' separan la palabra
       de 128-bits en ocho palabras, convirtiendo cada una en un byte, y
       cargndolas juntas en el registro destino.

       'PACKSSWD' y 'PACKSSWB' realizan una saturacin con signo cuando se
       reduce la longitud de nmeros: si el nmero es demasiado grande para
       caber en un espacio reducido, lo sustituyen con el mayor nmero con signo
       ('7FFFh' o '7Fh') que _cabr_, y si el nmero es demasiado pequeo
       entonces sustituyen el nmero con signo ms pequeo ('8000h' o '80h') que
       cabr. 'PACKUSWB' realiza la saturacin sin signo: trata su entrada como
       si fuese sin signo, y la sustituye por el mayor nmero sin signo que
       cabr.

 A.114 'PADDxx': Suma de MMX empaquetado

       PADDB mmxreg,r/m64            ; 0F FC /r             [PENT,MMX]
       PADDW mmxreg,r/m64            ; 0F FD /r             [PENT,MMX] 
       PADDD mmxreg,r/m64            ; 0F FE /r             [PENT,MMX]

       PADDSB mmxreg,r/m64           ; 0F EC /r             [PENT,MMX] 
       PADDSW mmxreg,r/m64           ; 0F ED /r             [PENT,MMX]

       PADDUSB mmxreg,r/m64          ; 0F DC /r             [PENT,MMX] 
       PADDUSW mmxreg,r/m64          ; 0F DD /r             [PENT,MMX]

       Todas las 'PADDxx' realizan la suma empaquetada entre sus dos operandos
       de 64-bit, almacenando el resultado en el operando (el primero) destino.
       Las formas 'PADDxB' tratan los operandos de 64-bit como vectores de ocho
       bytes, y suman cada byte individualmente; 'PADDxW' tratan los operandos
       como vectores de cuatro palabras; y 'PADDD' trata sus operandos como un
       vector de dos palabras dobles.

       'PADDSB' y 'PADDSW' realizan la saturacin de signo en la suma de cada
       par de bytes o palabras: si el resultado de una suma es demasiado grande
       o demasiado pequeo para caber en un resultado de byte o palabra con
       signo, se recorta (saturado) al valor ms grande o ms pequeo en el cual
       _cabr_. 'PADDUSB' y 'PADDUSW' de forma similar realizan la saturacin
       sin signo, recortando a '0FFh' o '0FFFFh' si el resultado es mayor que
       se.

 A.115 'PADDSIW': Suma MMX empaquetada a un destino implcito

       PADDSIW mmxreg,r/m64          ; 0F 51 /r             [CYRIX,MMX]

       'PADDSIW', especfico de las extensiones Cyrix al conjunto de
       instrucciones MMX, realiza la misma funcin que 'PADDSW', excepto que el
       resultado no se coloca en el registro especificado por el primero
       operando, sino en su lugar, en el registro cuyo nmero difiera del primer
       operando slo en su ltimo bit. Por eso 'PADDSIW MM0,MM2' pondra el
       resultado en 'MM1', pero 'PADDSIW MM1,MM2' lo pondra en 'MM0'.

 A.116 'PAND', 'PANDN': AND y AND-NOT del MMX a nivel de bit

       PAND mmxreg,r/m64             ; 0F DB /r             [PENT,MMX]
       PANDN mmxreg,r/m64            ; 0F DF /r             [PENT,MMX]

       'PAND' realiza una operacin AND a nivel de bit entre sus dos operandos
       (esto es, cada bit del resultado es 1 si y slo si los correspondientes
       bits de las dos entradas son ambos 1), y almacena el resultado en el
       operando (el primero) destino.

       'PANDN' realiza la misma operacin, pero realiza primero un complemento
       a uno del operando (el primero) destino.

 A.117 'PAVEB': Media empaquetada del MMX

       PAVEB mmxreg,r/m64            ; 0F 50 /r             [CYRIX,MMX]

       'PAVEB', especfico de las extensiones Cyrix del MMX, trata su dos
       operandos como vectores de ocho bytes sin signo, y calcula la media de
       los bytes correspondientes en los operandos. El vector resultante de ocho
       medias se almacena en el primer operando.

 A.118 'PCMPxx': Comparacin empaquetada del MMX

       PCMPEQB mmxreg,r/m64          ; 0F 74 /r             [PENT,MMX]
       PCMPEQW mmxreg,r/m64          ; 0F 75 /r             [PENT,MMX] 
       PCMPEQD mmxreg,r/m64          ; 0F 76 /r             [PENT,MMX]

       PCMPGTB mmxreg,r/m64          ; 0F 64 /r             [PENT,MMX] 
       PCMPGTW mmxreg,r/m64          ; 0F 65 /r             [PENT,MMX] 
       PCMPGTD mmxreg,r/m64          ; 0F 66 /r             [PENT,MMX]

       Las instrucciones 'PCMPxx' tratan a sus operandos como vectores de bytes,
       palabras, o doble palabras; se comparan los elementos correspondientes de
       la fuente y el destino, y los elementos correspondientes del operando (el
       primero) destino se ponen todos a cero o a unos dependiendo del resultado
       de la comparacin.

       'PCMPxxB' trata los operandos como vectores de ocho bytes, 'PCMPxxW' los
       trata como un vector de cuatro palabras, y 'PCMPxxD' como dos dobles
       palabras.

       'PCMPEQx' pone a uno el elemento correspondiente del operando destino si
       los dos elementos comparados son iguales; 'PCMPGTx' pone a uno el destino
       si el elemento del primer (el destino) operando es mayor (tratado como un
       entero con signo) que el segundo operando (el fuente).

 A.119 'PDISTIB': Distancia y acumulacin MMX empaquetada con registro implcito

       PDISTIB mmxreg,mem64          ; 0F 54 /r             [CYRIX,MMX]

       ''PDISTIB', especfico de la extensin MMX de Cyrix, trata su dos
       operandos de entrada como vectores de ocho bytes sin signo. Por cada
       posicin de byte, encuentra la diferencia absoluta entre los bytes en
       esa posicin en los dos operandos de entrada, y suma el valor al bytes en
       la misma posicin en el registro de salida implcito. La suma est
       saturada a un byte sin signo del mismo modo que 'PADDUSB'.

       El registro de salida implcito se encuentra del mismo modo que en
       'PADDSIW' (seccin A.115).

       Ntese que 'PDISTIB' no puede tomar un registro como su segundo operando
       fuente.

 A.120 'PMACHRIW': Multiplicacin y acumulacin MMX empaquetada con redondeo

       PMACHRIW mmxreg,mem64         ; 0F 5E /r             [CYRIX,MMX]

       'PMACHRIW' acta casi idnticamente a 'PMULHRIW' (seccin A.123), pero
       en lugar de _almacenar_ su resultado en un registro de destino implcito,
       _suma_ el resultado, como cuatro palabras empaquetadas, al registro
       destino implcito. No se hace saturacin: la suma puede excederse por uno
       de los lmites y aparecer por el otro ('dar la vuelta al marcador').

       Ntese que 'PMACHRIW' no puede tomar un registro como su segundo operando
       fuente.

 A.121 'PMADDWD': Multiplicacin y suma MMX empaquetada

       PMADDWD mmxreg,r/m64          ; 0F F5 /r             [PENT,MMX]

       'PMADDWD' trata sus dos operandos de entrada como vectores de cuatro
       palabras con signo. Multiplica el elemento correspondiente de los dos
       operandos, dando como resultado cuatro dobles palabras con signo. Las dos
       superiores se suman y colocan en los 32 bits superiores del operando
       (el primero) destino; las dos inferiores se suman y colocan en los
       32 bits inferiores.

 A.122 'PMAGW': Magnitud MMX empaquetada

       PMAGW mmxreg,r/m64            ; 0F 52 /r             [CYRIX,MMX]

       'PMAGW', especfico de la extensin MMX de Cyrix, trata sus dos operandos
       como vectores de cuatro palabras con signo. Compara los valores absolutos
       de las palabras en posiciones correspondientes, y establece cada palabra
       del operando (el primero) destino a cualquiera de las dos palabras en esa
       posicin que tenga mayor valor absoluto.

 A.123 'PMULHRW','PMULHRIW': Multiplicacin MMX empaquetada elevada con redondeo

       PMULHRW mmxreg,r/m64          ; 0F 59 /r             [CYRIX,MMX]
       PMULHRIW mmxreg,r/m64         ; 0F 5D /r             [CYRIX,MMX]

       Estas instrucciones, especficas de las extensiones MMX de Cyrix, tratan
       a sus operandos como vectores de cuatro palabras con signo. Las palabras
       en posiciones correspondientes se multiplican, para dar un valor de
       32-bit en el cual los bits 30 y 31 se garantiza que son iguales. Los
       bits 30 al 15 de este valor (mscara de bits '0x7FFF8000') se almacenan
       en la posicin correspondiente del operando destino, despus de redondear
       primero el bit bajo (equivalente a sumar '0x4000' antes de extraer los
       bits 30 al 15).

       Para 'PMULHRW', el operando destino es el primer operando; para
       'PMULHRIW' el operando destino est implcito en el primer operando en la
       manera de 'PADDSIW' (seccin A.115).

 A.124 'PMULHW', 'PMULLW': Multiplicacin MMX empaquetada

       PMULHW mmxreg,r/m64           ; 0F E5 /r             [PENT,MMX]
       PMULLW mmxreg,r/m64           ; 0F D5 /r             [PENT,MMX]

       'PMULxW' trata sus dos operandos de entrada como vectores de cuatro
       palabras con signo. Multiplica los elementos correspondientes de los dos
       operandos, dando como resultado cuatro dobles palabras con signo.

       'PMULHW' luego almacena los 16 bits superiores de cada palabras doble en
       operando (el primero) destino; 'PMULLW' almacena los 16 bits inferiores
       de cada palabra doble en el operando destino.

 A.125 'PMVccZB': Movimiento condicional MMX empaquetado

       PMVZB mmxreg,mem64            ; 0F 58 /r             [CYRIX,MMX]
       PMVNZB mmxreg,mem64           ; 0F 5A /r             [CYRIX,MMX] 
       PMVLZB mmxreg,mem64           ; 0F 5B /r             [CYRIX,MMX] 
       PMVGEZB mmxreg,mem64          ; 0F 5C /r             [CYRIX,MMX]

       Estas instrucciones, especficas de las extensiones MMX de Cyrix,
       realizan movimiento condicionales paralelos. Los dos operandos de entrada
       son tratados como vectores de ocho bytes. Cada byte del operando (el
       primero) destino es o escrito desde el byte correspondiente del operando
       (el segundo) fuente, o dejado solo, dependiendo del valor del byte en el
       operando _implcito_ (especificado del mismo modo que en 'PADDSIW', en la
       seccin A.115).

       'PMVZB' realiza cada movimiento si es cero el byte correspondiente en el
       operando implcito. 'PMVNZB' mueve si el byte no es cero. 'PMVLZB' mueve
       si el byte es menor que cero. y 'PMVGEZB' mueve si el byte es mayor o
       igual que cero.

       Ntese que estas instrucciones no pueden tomar un registro como su
       segundo operando fuente.

 A.126 'POP': Saca datos desde la pila

       POP reg16                     ; o16 58+r             [8086]
       POP reg32                     ; o32 58+r             [386]

       POP r/m16                     ; o16 8F /0            [8086] 
       POP r/m32                     ; o32 8F /0            [386]

       POP CS                        ; 0F                   [8086,UNDOC] 
       POP DS                        ; 1F                   [8086] 
       POP ES                        ; 07                   [8086] 
       POP SS                        ; 17                   [8086] 
       POP FS                        ; 0F A1                [386] 
       POP GS                        ; 0F A9                [386]

       'POP' carga un valor desde la pila (desde '[SS:SP]' o '[SS:ESP]') y luego
       incrementa el puntero de pila.

       El atributo de tamao de direccin de la instruccin determina si se usa
       como puntero de pila 'SP' o 'ESP': para superponer deliberadamente el
       dado por defecto por 'BITS', puedes usar un prefijo 'a16' o 'a32'.

       El atributo de tamao del operando de la instruccin determina si el
       puntero de pila se incrementa en 2  en 4: esto quiere decir que sacar en
       el modo 'BITS 32' sacar 4 bytes de la pila y descartar los dos
       superiores. Si necesitas superponer esto, puedes usar el prefijo 'o16' o
       'o32'.

       La lista de cdigos de operacin de arriba da dos formas de las
       instrucciones de sacar registros de propsito general: por ejemplo,
       'POP BX' tiene las dos formas '5B' y '8F C3'. NASM siempre generar la
       forma ms corta cuando se le d 'POP BX'. NDISASM desensamblar ambas.

       'POP CS' es una instruccin no documentada, y no est soportada en ningn
       procesador por encima del 8086 (ya que usan '0Fh' como un prefijo de
       cdigo de operacin para las extensiones del conjunto de instrucciones).
       Sin embargo, al menos algunos procesadores 8086 la soportan, y por eso
       NASM la genera para completar.

 A.127 'POPAx': Saca todos los registros de propsito general

       POPA                          ; 61                   [186]
       POPAW                         ; o16 61               [186] 
       POPAD                         ; o32 61               [386]

       'POPAW' saca una palabra desde la pila en cada uno de los, sucesivamente,
       'DI', 'SI', 'BP', nada (descarta una palabra desde la pila que
       corresponde con 'SP'), 'BX', 'DX', 'CX' y 'AX'. Se desea invertir la
       operacin de 'PUSHAW' (ver la seccin A.135), pero ignora el valor de
       'SP' que fue empujado a la pila por 'PUSHAW'.

       'POPAD' saca el doble de datos, y coloca los resultado en 'EDI', 'ESI',
       'EBP', nada (corresponde a 'ESP'), 'EBX', 'EDX', 'ECX' y 'EAX'. Invierte
       la operacin de 'PUSHAD'.

       'POPA' es un mnemnico para 'POPAW' o 'POAPD', dependiendo de la
       configuracin actual de 'BITS'.

       Ntese que los registros se sacan en orden inverso al de sus valores
       numricos en los cdigos de operacin (ver la seccin A.2.1).

 A.128 'POPFx': Saca el registro de flags

       POPF                          ; 9D                   [186]
       POPFW                         ; o16 9D               [186] 
       POPFD                         ; o32 9D               [386]

       'POPFW' saca una palabra desde la pila y la almacena en los 16 bits
       inferiores del registro de flags (en el registro de flags completo, en
       los procesadores inferiores al 386). 'POPFD' saca una palabra doble y la
       almacena entera en el registro de flags.

       'POPF' es un mnemnico para 'POPFW' o 'POPFD', dependiendo de la
       configuracin actual de 'BITS'.

       Ver tambin 'PUSHF' (seccin A.136).

 A.129 'POR': OR a nivel de bit del MMX

       POR mmxreg,r/m64              ; 0F EB /r             [PENT,MMX]

       'POR' realiza un OR a nivel de bit entre sus dos operandos (esto es, cada
       bit del resultado es 1 si y slo si lo es al menos uno de los bits
       correspondientes de sus dos entradas), y almacena el resultado en el
       operando (el primero) destino.

 A.130 'PSLLx', 'PSRLx', 'PSRAx': Desplazamiento de bits del MMX

       PSLLW mmxreg,r/m64            ; 0F F1 /r             [PENT,MMX]
       PSLLW mmxreg,imm8             ; 0F 71 /6 ib          [PENT,MMX]

       PSLLD mmxreg,r/m64            ; 0F F2 /r             [PENT,MMX] 
       PSLLD mmxreg,imm8             ; 0F 72 /6 ib          [PENT,MMX]

       PSLLQ mmxreg,r/m64            ; 0F F3 /r             [PENT,MMX] 
       PSLLQ mmxreg,imm8             ; 0F 73 /6 ib          [PENT,MMX]

       PSRAW mmxreg,r/m64            ; 0F E1 /r             [PENT,MMX] 
       PSRAW mmxreg,imm8             ; 0F 71 /4 ib          [PENT,MMX]

       PSRAD mmxreg,r/m64            ; 0F E2 /r             [PENT,MMX] 
       PSRAD mmxreg,imm8             ; 0F 72 /4 ib          [PENT,MMX]

       PSRLW mmxreg,r/m64            ; 0F D1 /r             [PENT,MMX] 
       PSRLW mmxreg,imm8             ; 0F 71 /2 ib          [PENT,MMX]

       PSRLD mmxreg,r/m64            ; 0F D2 /r             [PENT,MMX] 
       PSRLD mmxreg,imm8             ; 0F 72 /2 ib          [PENT,MMX]

       PSRLQ mmxreg,r/m64            ; 0F D3 /r             [PENT,MMX] 
       PSRLQ mmxreg,imm8             ; 0F 73 /2 ib          [PENT,MMX]

       'PSxxQ' realiza un sencillo desplazamiento de bit en los registros MMX de
       64-bits: el operando (el primero) destino es desplazado a la izquierda o
       derecha un nmero de bits dado en el operando (el segundo) fuente, y los
       bits vacos se rellenan con ceros (para el desplazamiento lgico) o copia
       el bit de signo original (para el desplazamiento aritmtico a la
       derecha).

       'PSxxW' y 'PSxxD' realiza desplazamientos empaquetados de bits: el
       operando destino es tratado como un vector de cuatro palabras o de dos
       palabras dobles, y cada elemento se desplaza individualmente, por eso los
       bits desplazados fuera de un elemento no interfieren con los bits vacos
       que quedan en el siguiente.

       'PSLLx' y 'PSRLx' realiza desplazamientos lgicos: los bits vacos en uno
       de los extremos del nmero desplazado se rellenan con ceros. 'PSRAx'
       realiza un desplazamiento aritmtico hacia la derecha: los bits vacos en
       la parte superior de nmero desplazado se rellenan con copias del bit de
       signo original (el bit superior).

 A.131 'PSUBxx': Resta MMX empaquetada

       PSUBB mmxreg,r/m64            ; 0F F8 /r             [PENT,MMX]
       PSUBW mmxreg,r/m64            ; 0F F9 /r             [PENT,MMX] 
       PSUBD mmxreg,r/m64            ; 0F FA /r             [PENT,MMX]

       PSUBSB mmxreg,r/m64           ; 0F E8 /r             [PENT,MMX] 
       PSUBSW mmxreg,r/m64           ; 0F E9 /r             [PENT,MMX]

       PSUBUSB mmxreg,r/m64          ; 0F D8 /r             [PENT,MMX] 
       PSUBUSW mmxreg,r/m64          ; 0F D9 /r             [PENT,MMX]

       'PSUBxx' realizan la resta empaquetada entre su dos operandos de 64-bits,
       almacenando el resultado en el operando (el primero) destino. Las formas
       'PSUBxB' tratan los operandos de 64-bits como vectores de ocho bytes, y
       restan cada byte individualmente; 'PSUBxW' trata los operandos como
       vectores de cuatro palabras; y 'PSUBD' trata sus operandos como vectores
       de dos palabras dobles.

       En todos los casos, los elementos del operando de la derecha se restan
       de los correspondientes elementos del operando de la izquierda, no de la
       otra forma.

       'PSUBSB' y 'PSUBSW' realiza la saturacin con signo en la suma de cada
       par de bytes o palabras: si el resultado de una resta es demasiado
       grande o demasiado pequeo como para caber en el byte o palabra
       resultado, es recortado (saturado) al ms grande o ms pequeo que
       _cabr_. 'PSUBUSB' y 'PSUBUSW' realiza de forma similar la saturacin sin
       signo, recortando a '0FFh' o '0FFFFh' si el resultado es mayor que se.

 A.132 'PSUBSIW': Resta MMX empaquetada con saturacin a un destino implcito

       PSUBSIW mmxreg,r/m64          ; 0F 55 /r             [CYRIX,MMX]

       'PSUBSIW', especfico de las extensiones MMX de Cyrix, realiza la misma
       funcin que 'PSUBSw', excepto que el resultado no se coloca en el
       registro especificado por el primer operando, sino que en su lugar se
       hace en el registro destino implcito, especificado como en 'PADDSIW'
       (seccin A.115).

 A.133 'PUNPCKxxx': Desempaquetar datos

       PUNPCKHBW mmxreg,r/m64        ; 0F 68 /r             [PENT,MMX]
       PUNPCKHWD mmxreg,r/m64        ; 0F 69 /r             [PENT,MMX] 
       PUNPCKHDQ mmxreg,r/m64        ; 0F 6A /r             [PENT,MMX]

       PUNPCKLBW mmxreg,r/m64        ; 0F 60 /r             [PENT,MMX] 
       PUNPCKLWD mmxreg,r/m64        ; 0F 61 /r             [PENT,MMX] 
       PUNPCKLDQ mmxreg,r/m64        ; 0F 62 /r             [PENT,MMX]

       'PUNPCKxx' tratan a sus operandos como vectores, y producen un nuevo
       vector generado entrelazando elementos desde sus dos entradas. Las
       instrucciones 'PUNPCKHxx' comienzan tirando la mitad inferior de cada
       operando de entrada, y las instrucciones 'PUNPCKLxx' tiran la mitad
       superior.

       Los elementos restantes, totalizan 64 bits, son entrelazados en el
       destino, alternando elementos desde el segundo operando (el fuente) y el
       primer operando (el destino): por eso el elemento ms a la izquierda de
       resultado siempre viene del segundo operando, y el ms a la derecha del
       destino.

       'PUNPCKxBW' funciona con un byte cada vez, 'PUNPCKxWD' una palabra cada
       vez, y 'PUNPCKxDQ' un palabra doble cada vez.

       Por eso, por ejemplo, si el primer operando contiene '0x7A6A5A4A3A2A1A0A'
       y el segundo contiene '0x7B6B5B4B3B2B1B0B', entonces:

       (*) 'PUNPCKHBW' devolvera '0x7B7A6B6A5B5A4B4A'.

       (*) 'PUNPCKHWD' devolvera '0x7B6B7A6A5B4B5A4A'.

       (*) 'PUNPCKHDQ' devolvera '0x7B6B5B4B7A6A5A4A'.

       (*) 'PUNPCKLBW' devolvera '0x3B3A2B2A1B1A0B0A'.

       (*) 'PUNPCKLWD' devolvera '0x3B2B3A2A1B0B1A0A'.

       (*) 'PUNPCKLDQ' devolvera '0x3B2B1B0B3A2A1A0A'.

 A.134 'PUSH': Empuja datos a la pila

       PUSH reg16                    ; o16 50+r             [8086]
       PUSH reg32                    ; o32 50+r             [386]

       PUSH r/m16                    ; o16 FF /6            [8086] 
       PUSH r/m32                    ; o32 FF /6            [386]

       PUSH CS                       ; 0E                   [8086] 
       PUSH DS                       ; 1E                   [8086] 
       PUSH ES                       ; 06                   [8086] 
       PUSH SS                       ; 16                   [8086] 
       PUSH FS                       ; 0F A0                [386] 
       PUSH GS                       ; 0F A8                [386]

       PUSH imm8                     ; 6A ib                [286] 
       PUSH imm16                    ; o16 68 iw            [286] 
       PUSH imm32                    ; o32 68 id            [386]

       'PUSH' decrementa el puntero de pila ('SP' o 'ESP') en 2  en 4, y luego
       almacena el valor dado en '[SS:SP]' o '[SS:ESP]'.

       El atributo de tamao de direccin de la instruccin determina si se usa
       como puntero de pila 'SP' o 'ESP': para superponer deliberadamente el
       valor por defecto dado por la configuracin de 'BITS', puedes usar un
       prefijo 'a16' o 'a32'.

       El atributo de tamao de operando de la instruccin determina si el
       puntero de pila se decrementa en 2  en 4: esto quiere decir que el
       empujar en el modo 'BITS 32' empujar 4 bytes a la pila, de los cuales
       los dos superiores estarn indefinidos. Si necesitas superponer esto,
       puedes usar un prefijo 'o16' o 'o32'.

       La lista de cdigos de operacin de arriba da dos formas de las
       instrucciones de empujar registros de propsito general: por ejemplo,
       'PUSH BX' tiene las dos formas '53' y 'FF F3'. NASM siempre generar la
       forma ms corta cuando se le d 'PUSH BX'. NDISASM desensamblar ambas.

       A diferencia de la indocumentada y raramente soportada 'POP CS',
       'PUSH CS' es una instruccin perfectamente vlida y correcta, soportada
       por todos los procesadores.

       La instruccin 'PUSH SP' se podra usar para distinguir un 8086 de
       posteriores procesadores: en un 8086, el valor de 'SP' almacenado es el
       valor que tiene _despus_ de la instruccin push, mientras que en
       procesadores posteriores es el valor de _antes_ de la instruccin push.

 A.135 'PUSHAx': Empujar todos los registros de propsito general

       PUSHA                         ; 60                   [186]
       PUSHAD                        ; o32 60               [386] 
       PUSHAW                        ; o16 60               [186]

       'PUSHAW' empuja, sucesivamente, 'AX', 'CX', 'DX', 'BX', 'SP', 'BP', 'SI'
       y 'DI' a la pila, decrementando el puntero de pila en un total de 16.

       'PUSHAD' empuja, sucesivamente, 'EAX', 'ECX', 'EDX', 'EBX', 'ESP', 'EBP',
       'ESI' y 'EDI' a la pila, decrementando el puntero de pila en un total de
       32.

       En ambos casos, el valor de 'SP' o 'ESP' empujado es el valor _original_,
       tal y como estaba antes de que se ejecutase la instruccin.

       'PUSHA' es un mnemnico para 'PUSHAW' o 'PUSHAD', dependiendo de la
       configuracin actual de 'BITS'.

       Ntese que se empujan los registros en orden de sus valores numricos
       en los cdigos de operacin (ver la seccin A.2.1).

       Ver tambin 'POPA' (seccin A.127).

 A.136 'PUSHFx': Empuja el registro de flags

       PUSHF                         ; 9C                   [186]
       PUSHFD                        ; o32 9C               [386] 
       PUSHFW                        ; o16 9C               [186]

       'PUSHFW' saca una palabra desde la pila y la almacena en los 16 bits
       inferiores del registro de flags (o en todo el registro, en procesadores
       inferiores al 386). 'PUSHFD' saca una palabra doble y la almacena en todo
       el registro de flags.

       'PUSHF' es un mnemnico sinnimo para 'PUSHFW' o 'PUSHFD', dependiendo
       de la configuracin actual de 'BITS'.

       Ver tambin 'POPF' (seccin A.128).

A.137 'POR': XOR a nivel de bit del MMX

       PXOR mmxreg,r/m64             ; 0F EF /r             [PENT,MMX]

       'PXOR' realiza una operacin XOR a nivel de bit entre sus dos operandos
       (esto es, cada bit del resultado es 1 si y slo si exactamente uno de los
       bits correspondientes de las dos entradas es 1), y almacena el resultado
       en el operando (el primero) destino.

 A.138 'RCL', 'RCR': Rotar a nivel de bit usando el bit de acarreo

       RCL r/m8,1                    ; D0 /2                [8086]
       RCL r/m8,CL                   ; D2 /2                [8086] 
       RCL r/m8,imm8                 ; C0 /2 ib             [286] 
       RCL r/m16,1                   ; o16 D1 /2            [8086] 
       RCL r/m16,CL                  ; o16 D3 /2            [8086] 
       RCL r/m16,imm8                ; o16 C1 /2 ib         [286] 
       RCL r/m32,1                   ; o32 D1 /2            [386] 
       RCL r/m32,CL                  ; o32 D3 /2            [386] 
       RCL r/m32,imm8                ; o32 C1 /2 ib         [386]

       RCR r/m8,1                    ; D0 /3                [8086] 
       RCR r/m8,CL                   ; D2 /3                [8086] 
       RCR r/m8,imm8                 ; C0 /3 ib             [286] 
       RCR r/m16,1                   ; o16 D1 /3            [8086] 
       RCR r/m16,CL                  ; o16 D3 /3            [8086] 
       RCR r/m16,imm8                ; o16 C1 /3 ib         [286] 
       RCR r/m32,1                   ; o32 D1 /3            [386] 
       RCR r/m32,CL                  ; o32 D3 /3            [386] 
       RCR r/m32,imm8                ; o32 C1 /3 ib         [386]

       'RCL' y 'RCR' realizan una operacin de rotacin de 9-bit, 17-bit o
       33-bit, implicando el operando fuente/destino dado y el bit de acarreo.
       As, por ejemplo, en la operacin 'RCR AL,1', se realiza una rotacin
       de 9-bit en la cual 'AL' es desplazado a la izquierda en 1, el bit
       superior de 'AL' se mueve al flag de acarreo, y el valor original del
       flag de acarreo se coloca como el bit inferior de 'AL'.

       El nmero de bits a rotar se da como segundo operando. En los
       procesadores superiores al 8086 slo se consideran los cinco bits
       inferiores del contador de rotacin.

       Puedes forzar la forma larga (286 en adelante, empezando con un byte
       'C1') de 'RCL foo,1' usando un prefijo 'BYTE': 'RCL foo,BYTE 1'. De forma
       similar con 'RCR'.

 A.139 'RDMSR': Leer los registros especficos del modelo

       RDMSR                         ; 0F 32                [PENT]

       'RDMSR' lee el registro especfico del modelo del procesador (MSR) cuyo
       ndice se almacena en 'ECX', y almacena el resultado en 'EDX:EAX'. Ver
       tambin 'WRMSR' (seccin A.165).

 A.140 'RDPMC': Leer los contadores de control de rendimiento

       RDPMC                         ; 0F 33                [P6]

       'RDPMC' lee el contador de control de rendimiento cuyo ndice se almacena
       en 'ECX', y almacena el resultado en 'EDX:EAX'.

 A.141 'RDTSC': Leer el contador de la fecha

       RDTSC                         ; 0F 31                [PENT]

       'RDTSC' lee el contador de la fecha del procesador en 'EDX:EAX'.

 A.142 'RET', 'RETF', 'RETN': Vuelve desde una llamada a un procedimiento.

       RET                           ; C3                   [8086]
       RET imm16                     ; C2 iw                [8086]

       RETF                          ; CB                   [8086] 
       RETF imm16                    ; CA iw                [8086]

       RETN                          ; C3                   [8086] 
       RETN imm16                    ; C2 iw                [8086]

       'RET', y su sinnimo exacto 'RETN', saca 'IP' o 'EIP' desde la pila y
       transfiere el control a la nueva direccin. Opcionalmente, si se
       proporciona un segundo operando, incrementa posteriormente el puntero de
       pila en 'imm16' bytes despus de sacar la direccin de retorno.

       'RETF' ejecuta un retorno lejano: tras sacar 'IP'/'EIP', luego saca 'CS',
       y _luego_ si est presente el argumento opcional incrementa el puntero de
       pila en lo que corresponda.

 A.143 'ROL', 'ROR': Rotar a nivel de bit

       ROL r/m8,1                    ; D0 /0                [8086]
       ROL r/m8,CL                   ; D2 /0                [8086] 
       ROL r/m8,imm8                 ; C0 /0 ib             [286] 
       ROL r/m16,1                   ; o16 D1 /0            [8086] 
       ROL r/m16,CL                  ; o16 D3 /0            [8086] 
       ROL r/m16,imm8                ; o16 C1 /0 ib         [286] 
       ROL r/m32,1                   ; o32 D1 /0            [386] 
       ROL r/m32,CL                  ; o32 D3 /0            [386] 
       ROL r/m32,imm8                ; o32 C1 /0 ib         [386]

       ROR r/m8,1                    ; D0 /1                [8086] 
       ROR r/m8,CL                   ; D2 /1                [8086] 
       ROR r/m8,imm8                 ; C0 /1 ib             [286] 
       ROR r/m16,1                   ; o16 D1 /1            [8086] 
       ROR r/m16,CL                  ; o16 D3 /1            [8086] 
       ROR r/m16,imm8                ; o16 C1 /1 ib         [286] 
       ROR r/m32,1                   ; o32 D1 /1            [386] 
       ROR r/m32,CL                  ; o32 D3 /1            [386] 
       ROR r/m32,imm8                ; o32 C1 /1 ib         [386]

       'ROL' y 'ROR' realizan una rotacin a nivel de bit en el operando
       destino/fuente (el primero). As, por ejemplo, en la operacin
       'ROR AL,1'. se realiza una operacin de 8-bits en la cual se desplaza
       'AL' a la izquierda en 1 y el bit superior original de 'AL' se mueve a la
       posicin de bit inferior.

       El nmero de bits a rotar se da como segundo operando. Slo en los
       precesadores superiores al 8086 se consideran los 3, 4  5 bits
       inferiores de la cuenta de rotacin (dependiendo del tamao del operando
       fuente).

       Puedes forzar la forma larga (286 y posteriores, empezando con un byte
       'C1') de 'ROL foo,1' usando un prefijo BYTE: 'ROL foo,BYTE 1'. De forma
       similar con 'ROR'.

 A.144 'RSM': Contina desde el modo de gestin del sistema

       RSM                           ; 0F AA                [PENT]

       'RSM' devuelve al procesador a su modo de operacin normal cuando estaba
       en el modo de gestin del sistema.

 A.145 'SAHF': Almacena AH en los flags

       SAHF                          ; 9E                   [8086]

       'SAHF' activa el byte inferior de la palabra de flags de acuerdo con el
       contenido del registro 'AH'. Ver tambin 'LAHF' (seccin A.90)

 A.146 'SAL', 'SAR': Desplazamientos aritmticos a nivel de bit.

       SAL r/m8,1                    ; D0 /4                [8086]
       SAL r/m8,CL                   ; D2 /4                [8086] 
       SAL r/m8,imm8                 ; C0 /4 ib             [286] 
       SAL r/m16,1                   ; o16 D1 /4            [8086] 
       SAL r/m16,CL                  ; o16 D3 /4            [8086] 
       SAL r/m16,imm8                ; o16 C1 /4 ib         [286] 
       SAL r/m32,1                   ; o32 D1 /4            [386] 
       SAL r/m32,CL                  ; o32 D3 /4            [386] 
       SAL r/m32,imm8                ; o32 C1 /4 ib         [386]

       SAR r/m8,1                    ; D0 /0                [8086] 
       SAR r/m8,CL                   ; D2 /0                [8086] 
       SAR r/m8,imm8                 ; C0 /0 ib             [286] 
       SAR r/m16,1                   ; o16 D1 /0            [8086] 
       SAR r/m16,CL                  ; o16 D3 /0            [8086] 
       SAR r/m16,imm8                ; o16 C1 /0 ib         [286] 
       SAR r/m32,1                   ; o32 D1 /0            [386] 
       SAR r/m32,CL                  ; o32 D3 /0            [386] 
       SAR r/m32,imm8                ; o32 C1 /0 ib         [386]

       'SAL' y 'SAR' realizan una operacin de desplazamiento aritmtico sobre
       el operando destino/fuente dado (el primero). Los bits vacos se rellenan
       en 'SAL' con ceros, y en 'SAR' con copias del bit superior original del
       operando fuente.

       'SAL' es sinnimo de 'SHL' (ver la seccin A.152). NASM ensamblar
       cualquier de los dos con el mismo cdigo, pero NDISASM siempre
       desensamblar este cdigo como 'SHL'.

       El nmero de bits a desplazar se da como segundo operando. Slo en los
       procesadores superiores al 8086 se consideran los 3, 4  5 bits
       inferiores de la cuenta de rotacin (dependiendo del tamao del operando
       fuente).

       Puedes forzar la forma larga (286 o posteriores, empezando con un byte
       'C1') de 'SAL foo,1' usando un prefijo 'BYTE': 'SAL foo,BYTE 1'. De forma
       similar con 'SAR'.

 A.147 'SALC': Establece AL desde el flag de acarreo

       SALC                          ; D6                   [8086,UNDOC]

       'SALC' es una instruccin no documentada relativamente nueva, similar en
       concepto a 'SETcc' (seccin A.150). Su funcin es poner 'AL' a cero si el
       flag de acarreo est limpio, o a '0xFF' si est activo.

 A.148 'SBB': Resta con prstamo

       SBB r/m8,reg8                 ; 18 /r                [8086]
       SBB r/m16,reg16               ; o16 19 /r            [8086] 
       SBB r/m32,reg32               ; o32 19 /r            [386]

       SBB reg8,r/m8                 ; 1A /r                [8086] 
       SBB reg16,r/m16               ; o16 1B /r            [8086] 
       SBB reg32,r/m32               ; o32 1B /r            [386]

       SBB r/m8,imm8                 ; 80 /3 ib             [8086] 
       SBB r/m16,imm16               ; o16 81 /3 iw         [8086] 
       SBB r/m32,imm32               ; o32 81 /3 id         [386]

       SBB r/m16,imm8                ; o16 83 /3 ib         [8086] 
       SBB r/m32,imm8                ; o32 83 /3 ib         [8086]

       SBB AL,imm8                   ; 1C ib                [8086] 
       SBB AX,imm16                  ; o16 1D iw            [8086] 
       SBB EAX,imm32                 ; o32 1D id            [386]

       'SBB' realiza la resta entre enteros: resta su segundo operando, ms el
       valor del flag de acarreo, de su primero, y deja el resultado en el
       operando (el primero) destino. Los flags se activan de forma acorde con
       el resultado de la operacin: en particular, se afecta al flag de acarreo
       y se puede usar en subsiguientes instrucciones 'SBB'.

       En las formas con un inmediato de 8-bit como segundo operando y un primer
       operando ms largo, el segundo operando se considera con signo, y se le
       hace extensin de signo hasta la longitud del primer operando. En estos
       casos, se necesita el calificador 'BYTE' para forzar a NASM a generar
       esta forma de la instruccin.

       Para restar un nmero de otro sin sumar el contenido del flag de acarreo,
       usa 'SUB' (seccin A.159).

 A.149 'SCASB', 'SCASW', 'SCASD': Buscar cadena

       SCASB                         ; AE                   [8086]
       SCASW                         ; o16 AF               [8086] 
       SCASD                         ; o32 AF               [386]

       'SCASB' compara el byte que est en 'AL' con el byte en '[ES:DI]' o
       '[ES:EDI]', y activa los flags de acuerdo a esto. Luego incrementa o
       decrementa (dependiendo del flag de direccin: incrementa si est limpio,
       decrementa si est activo) 'DI' (o 'EDI').

       Si la direccin es de 16 bits se usa el registro 'DI', y 'EDI' si es de
       32 bits. Si necesitas usar un tamao de direccin distinto de la
       configuracin actual de 'BITS', puedes usar un prefijo 'a16' o 'a32'
       explcito.

       Los prefijos de superposicin de segmentos no tienen efecto en esta
       instruccin: el uso de 'ES' para cargar desde '[DI]' o '[EDI]' no se
       puede solapar.

       'SCASW' y 'SCASD' funcionan de la misma manera, pero comparan una palabra
       con 'AX' o doble palabra con 'EAX' en lugar de un byte con 'AL', e
       incrementan o decrementan el registro de direccionamiento en 2  en 4
       en lugar de en 1.

       Los prefijos 'REPE' y 'REPNE' (equivalentes a 'REPZ' y 'REPNZ') se
       pueden usar para repetir una instruccin hasta 'CX' veces (o 'ECX' -
       nuevamente el tamao de la direccin elige cul) hasta que se encuentre
       el primer byte distinto o igual, depende.

 A.150 'SETcc': Establece un registro dependiendo de una condicin

       SETcc r/m8                    ; 0F 90+cc /2          [386]

       'SETcc' pone a cero el operando de 8-bits dado si no se satisface la
       condicin, y a 1 si s lo hace.

 A.151 'SGDT', 'SIDT', 'SLDT': Almacena los punteros de la tabla de descriptores

       SGDT mem                      ; 0F 01 /0             [286,PRIV]
       SIDT mem                      ; 0F 01 /1             [286,PRIV] 
       SLDT r/m16                    ; 0F 00 /0             [286,PRIV]

       'SGDT' y 'SIDT' toman como operando un rea de memoria de 6 bytes:
       almacenan el contenido de la GDTR (Global Descriptor Table Register) o la
       IDTR (Interrupt Descriptor Table Register) en ese rea como una direccin
       lineal de 32-bits y un lmite de tamao de 16-bit (en ese orden). Son las
       nicas instrucciones que usan directamente direcciones _lineales_, en
       lugar del par segmento/offset.

       'SLDT' almacena en el operando dado, el selector de segmento
       correspondiente a la LDT (Local Descriptor Table).

       Ver tambin 'LGDT', 'LIDT' y 'LLDT' (seccin A.95).

 A.152 'SHL', 'SHR': Desplazamientos lgicos a nivel de bit.

       SHL r/m8,1                    ; D0 /4                [8086]
       SHL r/m8,CL                   ; D2 /4                [8086] 
       SHL r/m8,imm8                 ; C0 /4 ib             [286] 
       SHL r/m16,1                   ; o16 D1 /4            [8086] 
       SHL r/m16,CL                  ; o16 D3 /4            [8086] 
       SHL r/m16,imm8                ; o16 C1 /4 ib         [286] 
       SHL r/m32,1                   ; o32 D1 /4            [386] 
       SHL r/m32,CL                  ; o32 D3 /4            [386] 
       SHL r/m32,imm8                ; o32 C1 /4 ib         [386]

       SHR r/m8,1                    ; D0 /5                [8086] 
       SHR r/m8,CL                   ; D2 /5                [8086] 
       SHR r/m8,imm8                 ; C0 /5 ib             [286] 
       SHR r/m16,1                   ; o16 D1 /5            [8086] 
       SHR r/m16,CL                  ; o16 D3 /5            [8086] 
       SHR r/m16,imm8                ; o16 C1 /5 ib         [286] 
       SHR r/m32,1                   ; o32 D1 /5            [386] 
       SHR r/m32,CL                  ; o32 D3 /5            [386] 
       SHR r/m32,imm8                ; o32 C1 /5 ib         [386]

       'SHL' y 'SHR' realizan un desplazamiento lgico sobre el operando
       fuente/destino dado. Los bits desocupados se rellenan con cero.

       'SAL' es un sinnimo de 'SHL' (ver la seccin A.146). NASM ensamblar
       cualquiera de ellos con el mismo cdigo, pero NDISASM siempre
       desensamblar este cdigo como 'SHL'.

       El segundo operando da el nmero de bits a desplazar. En los procesadores
       superiores al 8086 slo se consideran los 3, 4  5 bits inferiores de la
       cuenta de desplazamiento (dependiendo del tamao del operando fuente).

       Puedes forzar la forma ms larga (286 y posteriores, empezando con un
       byte 'C1') de 'SHL foo,1' usando un prefijo 'BYTE': 'SHL foo,BYTE 1'.
       De forma similar con 'SHR'.

 A.153 'SHLD', 'SHRD': Desplazamientos de doble precisin a nivel de bit

       SHLD r/m16,reg16,imm8         ; o16 0F A4 /r ib      [386]
       SHLD r/m16,reg32,imm8         ; o32 0F A4 /r ib      [386] 
       SHLD r/m16,reg16,CL           ; o16 0F A5 /r         [386] 
       SHLD r/m16,reg32,CL           ; o32 0F A5 /r         [386]

       SHRD r/m16,reg16,imm8         ; o16 0F AC /r ib      [386] 
       SHRD r/m32,reg32,imm8         ; o32 0F AC /r ib      [386] 
       SHRD r/m16,reg16,CL           ; o16 0F AD /r         [386] 
       SHRD r/m32,reg32,CL           ; o32 0F AD /r         [386]

       'SHLD' realiza un desplazamiento a la izquierda de doble precisin.
       Conceptualmente coloca su segundo operando a la derecha de su primero,
       luego desplaza a la izquierda la cadena entera de bits as generada el
       nmero de bits especificado por su tercer operando. Luego slo actualiza
       el _primer_ operando de acuerdo con el resultado de esto. El segundo
       operando no se modifica.

       'SHRD' realiza el correspondiente desplazamiento a la derecha:
       conceptualmente coloca el segundo operando a la _izquierda_ del primero,
       desplaza a la derecha la cadena entera de bits, y actualiza slo el
       primer operando.

       Por ejemplo, si 'EAX' contiene '0x01234567' y 'EBX' contiene
       '0x89ABCDEF', luego la instruccin 'SHLD EAX,EBX,4' actualizara 'EAX'
       para contener '0x12345678'. Bajo las mismas condiciones, 'SHRD EAX,EBX,4'
       actualizara 'EAX' para contener '0xF0123456'.

       El nmero de bits a desplazar viene dado por su tercer operando. Slo se
       consideran los 5 bits inferiores de la cuenta de desplazamiento.

 A.154 'SMI': Interrupcin de gestin del sistema

       SMI                           ; F1                   [386,UNDOC]

       Este es un cdigo de operacin que est soportado aparentemente por
       algunos procesadores AMD (la cual es por la que pueden generar el mismo
       cdigo de operacin como 'INT1'), y coloca la mquina en el modo de
       gestin del sistema, un modo especial de depuracin.

 A.155 'SMSW': Almacena la palabra de estado de la mquina

       SMSW r/m16                    ; 0F 01 /4             [286,PRIV]

       'SMSW' almacena la mitad inferior del registro de control 'CR0' (o la
       palabra de estado de la mquina, en los procesadores 286) en el operando
       destino. Ver tambin 'LMSW' (seccin A.96).

 A.156 'STC', 'STD', 'STI': Activa flags

       STC                           ; F9                   [8086]
       STD                           ; FD                   [8086] 
       STI                           ; FB                   [8086]

       Estas instrucciones activan diversos flags. 'STC' activa el flag de
       acarreo; 'STD' activa el flag de direccin; y 'STI' activa el flag de
       interrupcin (as permite interrupciones).

       Para limpiar el flag de acarreo, direccin o interrupcin, usa las
       instrucciones 'CLC', 'CLD' y 'CLI' (seccin A.15). Para invertir el flag
       de acarreo, usa 'CMC' (seccin A.16).

 A.157 'STOSB', 'STOSW', 'STOSD': Almacena un byte a una cadena

       STOSB                         ; AA                   [8086]
       STOSW                         ; o16 AB               [8086] 
       STOSD                         ; o32 AB               [386]

       'STOSB' almacena el byte que est en 'AL' en '[ES:DI]' o '[ES:EDI]', y
       activa los flags de acuerdo con esto. Luego incrementa o decrementa
       (dependiendo del flag de direccin: incrementa si el flag est limpio,
       decrementa si est activo) 'DI' (o 'EDI').

       Si el tamao de la direccin es 16 bits se usa el registro 'DI', y 'EDI'
       si es de 32 bits. Si necesitas usar un tamao de direccin distinto de la
       configuracin actual de 'BITS', puedes usar un prefijo 'a16' o 'a32'
       explcito.

       Los prefijos de superposicin de segmentos no tienen efecto en esta
       instruccin: no se puede superponer el uso de 'ES' para almacenar a
       '[DI]' o '[EDI]'.

       'STOSW' y 'STOSD' funcionan del mismo modo, pero almacenan una palabra
       en 'AX' o una doble palabra en 'EAX' en lugar de un byte en 'AL', e
       incrementan o decrementan el registro de direcciones en 2  en 4 en lugar
       de en 1.

       Se puede usar el prefijo 'REP' para repetir la instruccin 'CX' veces
       (o 'ECX' - nuevamente, el tamao de la direccin elige cul).

 A.158 'STR': Almacena el registro de tarea

       STR r/m16                     ; 0F 00 /1             [286,PRIV]

       'STR' almacena en su operando el selector de segmento correspondiente al
       contenido del registro de tarea.

 A.159 'SUB': Resta enteros

       SUB r/m8,reg8                 ; 28 /r                [8086]
       SUB r/m16,reg16               ; o16 29 /r            [8086] 
       SUB r/m32,reg32               ; o32 29 /r            [386]

       SUB reg8,r/m8                 ; 2A /r                [8086] 
       SUB reg16,r/m16               ; o16 2B /r            [8086] 
       SUB reg32,r/m32               ; o32 2B /r            [386]

       SUB r/m8,imm8                 ; 80 /5 ib             [8086] 
       SUB r/m16,imm16               ; o16 81 /5 iw         [8086] 
       SUB r/m32,imm32               ; o32 81 /5 id         [386]

       SUB r/m16,imm8                ; o16 83 /5 ib         [8086] 
       SUB r/m32,imm8                ; o32 83 /5 ib         [386]

       SUB AL,imm8                   ; 2C ib                [8086] 
       SUB AX,imm16                  ; o16 2D iw            [8086] 
       SUB EAX,imm32                 ; o32 2D id            [386]

       'SUB' realiza la resta entre enteros: resta su segundo operando del
       primero, y deja el resultado en su operando (el primero) destino. Los
       flags se activan de acuerdo con el resultado de la operacin: en
       particular, se afecta al flag de acarreo y se puede usar en subsiguientes
       instrucciones 'SBB' (seccin A.148).

       En las formas con un valor inmediato de 8-bits como segundo operando y
       un primer operando ms largo, el segundo operando se considera con signo,
       y se le hace extensin de signo hasta la longitud del primero. En estos
       casos, se necesita el calificador 'BYTE' para forzar a NASM a generar
       esta forma de la instruccin.

 A.160 'TEST': Comprueba bits (conceptualmente un AND a nivel de bit)

       TEST r/m8,reg8                ; 84 /r                [8086]
       TEST r/m16,reg16              ; o16 85 /r            [8086] 
       TEST r/m32,reg32              ; o32 85 /r            [386]

       TEST r/m8,imm8                ; F6 /7 ib             [8086] 
       TEST r/m16,imm16              ; o16 F7 /7 iw         [8086] 
       TEST r/m32,imm32              ; o32 F7 /7 id         [386]

       TEST AL,imm8                  ; A8 ib                [8086] 
       TEST AX,imm16                 ; o16 A9 iw            [8086] 
       TEST EAX,imm32                ; o32 A9 id            [386]

       'TEST' realiza 'mentalmente' un AND a nivel de bit de sus dos operandos,
       y afecta a los flags como si la operacin hubiese tenido lugar, pero no
       almacena en ningn lugar el resultado de la operacin.

 A.161 'UMOV': Mueve datos del usuario

       UMOV r/m8,reg8                ; 0F 10 /r             [386,UNDOC]
       UMOV r/m16,reg16              ; o16 0F 11 /r         [386,UNDOC] 
       UMOV r/m32,reg32              ; o32 0F 11 /r         [386,UNDOC]

       UMOV reg8,r/m8                ; 0F 12 /r             [386,UNDOC] 
       UMOV reg16,r/m16              ; o16 0F 13 /r         [386,UNDOC] 
       UMOV reg32,r/m32              ; o32 0F 13 /r         [386,UNDOC]

       Esta instruccin no documentada se usa en emuladores en circuito para
       acceder a memoria del usuario (opuesta a la memoria del host). Se usa
       como una instruccin 'MOV' normal de memoria/registro o
       registro/registro, pero accediendo a espacio de usuario.

 A.162 'VERR', 'VERW': Verifica la disponibilidad de escritura/lectura de un
       segmento

       VERR r/m16                    ; 0F 00 /4             [286,PRIV]

       VERW r/m16                    ; 0F 00 /5             [286,PRIV]

       'VERR' activa el flag de cero si el segmento especificado por el selector
       en su operando se puede leer desde el nivel de privilegio actual. 'VERW'
       activa el flag de cero si el segmento se puede escribir.

 A.163 'WAIT': Espera al procesador de coma flotante

       WAIT                          ; 9B                   [8086]

       'WAIT', en sistemas 8086 con una FPU 8087 separada, espera a que la FPU
       termine cualquier operacin en la que estuviese ocupada antes de
       continuar con las operaciones del procesador principal, por eso (por
       ejemplo) un almacenamiento de la FPU en la memoria principal se puede
       garantizar que est completo antes de que la CPU intente leer el
       resultado.

       En procesadores superiores, 'WAIT' es innecesario para este propsito, y
       tiene el propsito alternativo de asegurar que cualquier excepcin no
       enmascarada de la FPU pendiente ha ocurrido antes de que la CPU contine
       la ejecucin.

 A.164 'WBINVD': Escribe de vuelta la cach y la invalida

       WBINVD                        ; 0F 09                [486]

       'WBINVD' invalida y vaca la cach interna del procesador, y hace que el
       procesador indique a las cachs externas que hagan lo mismo. Escribe el
       contenido de las cachs de vuelta a la memoria, por eso no se pierden
       datos. Para limpiar las cachs rpidamente sin preocuparse de escribir
       primero los datos, usa 'INVD' (seccin A.84).

 A.165 'WRMSR': Escribe los registros especficos del modelo

       WRMSR                         ; 0F 30                [PENT]

       'WRMSR' escribe el valor en 'EDX:EAX' al registro especfico del modelo
       (MSR) del procesador cuyo ndice se almacena en 'ECX'. Ver tambin
       'RDMSR' (seccin A.139).

 A.166 'XADD': Intercambia y suma

       XADD r/m8,reg8                ; 0F C0 /r             [486]
       XADD r/m16,reg16              ; o16 0F C1 /r         [486] 
       XADD r/m32,reg32              ; o32 0F C1 /r         [486]

       'XADD' intercambia los valores de sus dos operandos, y luego los suma
       y escribe el resultado en su operando (el primero) destino. Esta
       instruccin se puede usar con un prefijo 'LOCK' para cuestiones de
       sincronismo en multiprocesadores.

 A.167 'XBTS': Extrae una cadena de bits

       XBTS reg16,r/m16              ; o16 0F A6 /r         [386,UNDOC]
       XBTS reg32,r/m32              ; o32 0F A6 /r         [386,UNDOC]

       No parece haber una documentacin clara para esta instruccin: lo mejor
       que he encontrado dice 'Toma una cadena de bits de su primer operando y
       la pone en su segundo operando'. Slo est presente en los primeros
       procesadores 386, y entra en conflicto con el cdigo de operacin de
       'CMPXCHG486'. NASM lo soporta slo para completar. Su contrapartida es
       'IBTS' (ver la seccin A.75).

 A.168 'XCHG': Intercambia

       XCHG reg8,r/m8                ; 86 /r                [8086]
       XCHG reg16,r/m8               ; o16 87 /r            [8086] 
       XCHG reg32,r/m32              ; o32 87 /r            [386]

       XCHG r/m8,reg8                ; 86 /r                [8086] 
       XCHG r/m16,reg16              ; o16 87 /r            [8086] 
       XCHG r/m32,reg32              ; o32 87 /r            [386]

       XCHG AX,reg16                 ; o16 90+r             [8086] 
       XCHG EAX,reg32                ; o32 90+r             [386] 
       XCHG reg16,AX                 ; o16 90+r             [8086] 
       XCHG reg32,EAX                ; o32 90+r             [386]

       'XCHG' intercambia los valores de sus dos operandos. Se puede usar con un
       prefijo 'LOCK' para cuestiones de sincronismo en multiprocesadores.

       'XCHG AX,AX' o 'XCHG EAX,EAX' (dependiendo de la configuracin de 'BITS')
       genera el cdigo de operacin '90h', y por eso es sinnimo de 'NOP'
       (seccin A.109).

 A.169 'XLATB': Traduce un byte en una tabla de bsqueda

       XLATB                         ; D7                   [8086]

       'XLATB' suma el valor en 'AL', tratado como un byte sin signo, a 'BX' o
       'EBX', y carga el byte desde la direccin resultante (en el segmento
       especificado por 'DS') de nuevo en 'AL'.

       Si el tamao de la direccin es de 16 bits se usa el registro base 'BX',
       y 'EBX' si es de 32 bits. Si necesitas usar un tamao de direccin
       distinto del marcado por 'BITS', puedes usar un prefijo 'a16' o 'a32'
       explcito.

       El registro de segmento usado para cargar desde '[BX+AL]' o '[EBX+AL]'
       se puede superponer usando como prefijo un nombre de registro de segmento
       (por ejemplo, 'es xlatb').

 A.170 'XOR': OR exclusivo a nivel de bit

       XOR r/m8,reg8                 ; 30 /r                [8086]
       XOR r/m16,reg16               ; o16 31 /r            [8086] 
       XOR r/m32,reg32               ; o32 31 /r            [386]

       XOR reg8,r/m8                 ; 32 /r                [8086] 
       XOR reg16,r/m16               ; o16 33 /r            [8086] 
       XOR reg32,r/m32               ; o32 33 /r            [386]

       XOR r/m8,imm8                 ; 80 /6 ib             [8086] 
       XOR r/m16,imm16               ; o16 81 /6 iw         [8086] 
       XOR r/m32,imm32               ; o32 81 /6 id         [386]

       XOR r/m16,imm8                ; o16 83 /6 ib         [8086] 
       XOR r/m32,imm8                ; o32 83 /6 ib         [386]

       XOR AL,imm8                   ; 34 ib                [8086] 
       XOR AX,imm16                  ; o16 35 iw            [8086] 
       XOR EAX,imm32                 ; o32 35 id            [386]

       'XOR' realiza un OR exclusivo a nivel de bit entre sus dos operandos
       (esto es, cada bit del resultado es un 1 si y slo si exactamente uno de
       los bits correspondientes de las dos entradas es 1), y almacena el
       resultado en su operando (el primero) destino.

       En las formas con un inmediato de 8-bits como segundo operando y un
       primer operando ms largo, el segundo operando se considera con signo, y
       se le hace extensin de signo hasta la longitud del primer operando. En
       estos casos, se necesita el calificador 'BYTE' para forzar a NASM a
       generar esta forma de la instruccin.

       La instruccin MMX 'PXOR' (ver la seccin A.137) realiza la misma
       operacin en los registros MMX de 64-bits.
